vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO pupnp/pupnp
    REF "release-${VERSION}"
    SHA512 2aed5c72cb8e33b89d85e6755b99e7bd4e82ffb58d03ef58c2cdd790d4dc6c33b3a9f91168595930be53f0bb803e266e2bb02ea5fcc5cda8edada9453bf56492
    PATCHES
        fix-pthreads4w-targets.patch
)

string(COMPARE EQUAL "${VCPKG_LIBRARY_LINKAGE}" "static" LIBUPNP_BUILD_STATIC)
string(COMPARE EQUAL "${VCPKG_LIBRARY_LINKAGE}" "dynamic" LIBUPNP_BUILD_SHARED)

if(LIBUPNP_BUILD_STATIC)
    set(UPNP_TARGET "Static")
else()
    set(UPNP_TARGET "Shared")
endif()

vcpkg_check_features(OUT_FEATURE_OPTIONS FEATURE_OPTIONS
    FEATURES
    client-api      UPNP_ENABLE_CLIENT_API
    ipv6            UPNP_ENABLE_IPV6
    ssl             UPNP_ENABLE_OPEN_SSL
    webserver       UPNP_ENABLE_WEBSERVER
)

vcpkg_cmake_configure(
    SOURCE_PATH "${SOURCE_PATH}"
    OPTIONS
    -DBUILD_TESTING=OFF
    -DIXML_ENABLE_SCRIPT_SUPPORT=ON
    -DUPNP_ENABLE_GENA=ON
    -DUPNP_ENABLE_SOAP=ON
    -DUPNP_ENABLE_SSDP=ON
    -DUPNP_ENABLE_BLOCKING_TCP_CONNECTIONS=OFF
    -DUPNP_ENABLE_DEVICE_API=${UPNP_ENABLE_WEBSERVER}
    -DUPNP_MINISERVER_REUSEADDR=${UPNP_ENABLE_WEBSERVER}
    -DUPNP_BUILD_SHARED=${LIBUPNP_BUILD_SHARED}
    -DUPNP_BUILD_STATIC=${LIBUPNP_BUILD_STATIC}
    -DUPNP_BUILD_SAMPLES=OFF
    -DUPNP_ENABLE_UNSPECIFIED_SERVER=OFF
    ${FEATURE_OPTIONS}
)

vcpkg_cmake_install()

vcpkg_fixup_pkgconfig()
vcpkg_cmake_config_fixup(CONFIG_PATH lib/cmake/UPNP DO_NOT_DELETE_PARENT_CONFIG_PATH)
vcpkg_cmake_config_fixup(CONFIG_PATH lib/cmake/IXML)

file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/include")
file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/debug/share")

vcpkg_copy_pdbs()

vcpkg_install_copyright(FILE_LIST "${SOURCE_PATH}/COPYING")

file(INSTALL "${CMAKE_CURRENT_LIST_DIR}/usage" DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}")
