/* Capstone Disassembly Engine, http://www.capstone-engine.org */
/* By Nguyen Anh Quynh <aquynh@gmail.com>, 2013-2019 */

/// getRegisterName - This method is automatically generated by tblgen
/// from the register set description.  This returns the assembler name
/// for the specified register.
static const char *getRegisterName(unsigned RegNo, unsigned AltIdx)
{


#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Woverlength-strings"
#endif
#ifndef CAPSTONE_DIET
  static const char AsmStrsNoRegAltName[] = {
  /* 0 */ "D7_D8_D9_D10\0"
  /* 13 */ "Q7_Q8_Q9_Q10\0"
  /* 26 */ "Z7_Z8_Z9_Z10\0"
  /* 39 */ "b10\0"
  /* 43 */ "d10\0"
  /* 47 */ "h10\0"
  /* 51 */ "p10\0"
  /* 55 */ "q10\0"
  /* 59 */ "s10\0"
  /* 63 */ "w10\0"
  /* 67 */ "x10\0"
  /* 71 */ "z10\0"
  /* 75 */ "D17_D18_D19_D20\0"
  /* 91 */ "Q17_Q18_Q19_Q20\0"
  /* 107 */ "Z17_Z18_Z19_Z20\0"
  /* 123 */ "b20\0"
  /* 127 */ "d20\0"
  /* 131 */ "h20\0"
  /* 135 */ "q20\0"
  /* 139 */ "s20\0"
  /* 143 */ "w20\0"
  /* 147 */ "x20\0"
  /* 151 */ "z20\0"
  /* 155 */ "D27_D28_D29_D30\0"
  /* 171 */ "Q27_Q28_Q29_Q30\0"
  /* 187 */ "Z27_Z28_Z29_Z30\0"
  /* 203 */ "b30\0"
  /* 207 */ "d30\0"
  /* 211 */ "h30\0"
  /* 215 */ "q30\0"
  /* 219 */ "s30\0"
  /* 223 */ "w30\0"
  /* 227 */ "x30\0"
  /* 231 */ "z30\0"
  /* 235 */ "D29_D30_D31_D0\0"
  /* 250 */ "Q29_Q30_Q31_Q0\0"
  /* 265 */ "Z29_Z30_Z31_Z0\0"
  /* 280 */ "b0\0"
  /* 283 */ "d0\0"
  /* 286 */ "h0\0"
  /* 289 */ "p0\0"
  /* 292 */ "q0\0"
  /* 295 */ "s0\0"
  /* 298 */ "w0\0"
  /* 301 */ "x0\0"
  /* 304 */ "z0\0"
  /* 307 */ "D8_D9_D10_D11\0"
  /* 321 */ "Q8_Q9_Q10_Q11\0"
  /* 335 */ "W10_W11\0"
  /* 343 */ "X4_X5_X6_X7_X8_X9_X10_X11\0"
  /* 369 */ "Z8_Z9_Z10_Z11\0"
  /* 383 */ "b11\0"
  /* 387 */ "d11\0"
  /* 391 */ "h11\0"
  /* 395 */ "p11\0"
  /* 399 */ "q11\0"
  /* 403 */ "s11\0"
  /* 407 */ "w11\0"
  /* 411 */ "x11\0"
  /* 415 */ "z11\0"
  /* 419 */ "D18_D19_D20_D21\0"
  /* 435 */ "Q18_Q19_Q20_Q21\0"
  /* 451 */ "W20_W21\0"
  /* 459 */ "X14_X15_X16_X17_X18_X19_X20_X21\0"
  /* 491 */ "Z18_Z19_Z20_Z21\0"
  /* 507 */ "b21\0"
  /* 511 */ "d21\0"
  /* 515 */ "h21\0"
  /* 519 */ "q21\0"
  /* 523 */ "s21\0"
  /* 527 */ "w21\0"
  /* 531 */ "x21\0"
  /* 535 */ "z21\0"
  /* 539 */ "D28_D29_D30_D31\0"
  /* 555 */ "Q28_Q29_Q30_Q31\0"
  /* 571 */ "Z28_Z29_Z30_Z31\0"
  /* 587 */ "b31\0"
  /* 591 */ "d31\0"
  /* 595 */ "h31\0"
  /* 599 */ "q31\0"
  /* 603 */ "s31\0"
  /* 607 */ "z31\0"
  /* 611 */ "D30_D31_D0_D1\0"
  /* 625 */ "Q30_Q31_Q0_Q1\0"
  /* 639 */ "W0_W1\0"
  /* 645 */ "X0_X1\0"
  /* 651 */ "Z30_Z31_Z0_Z1\0"
  /* 665 */ "b1\0"
  /* 668 */ "d1\0"
  /* 671 */ "h1\0"
  /* 674 */ "p1\0"
  /* 677 */ "q1\0"
  /* 680 */ "s1\0"
  /* 683 */ "w1\0"
  /* 686 */ "x1\0"
  /* 689 */ "z1\0"
  /* 692 */ "D9_D10_D11_D12\0"
  /* 707 */ "Q9_Q10_Q11_Q12\0"
  /* 722 */ "Z9_Z10_Z11_Z12\0"
  /* 737 */ "b12\0"
  /* 741 */ "d12\0"
  /* 745 */ "h12\0"
  /* 749 */ "p12\0"
  /* 753 */ "q12\0"
  /* 757 */ "s12\0"
  /* 761 */ "w12\0"
  /* 765 */ "x12\0"
  /* 769 */ "z12\0"
  /* 773 */ "D19_D20_D21_D22\0"
  /* 789 */ "Q19_Q20_Q21_Q22\0"
  /* 805 */ "Z19_Z20_Z21_Z22\0"
  /* 821 */ "b22\0"
  /* 825 */ "d22\0"
  /* 829 */ "h22\0"
  /* 833 */ "q22\0"
  /* 837 */ "s22\0"
  /* 841 */ "w22\0"
  /* 845 */ "x22\0"
  /* 849 */ "z22\0"
  /* 853 */ "D31_D0_D1_D2\0"
  /* 866 */ "Q31_Q0_Q1_Q2\0"
  /* 879 */ "Z31_Z0_Z1_Z2\0"
  /* 892 */ "b2\0"
  /* 895 */ "d2\0"
  /* 898 */ "h2\0"
  /* 901 */ "p2\0"
  /* 904 */ "q2\0"
  /* 907 */ "s2\0"
  /* 910 */ "w2\0"
  /* 913 */ "x2\0"
  /* 916 */ "z2\0"
  /* 919 */ "D10_D11_D12_D13\0"
  /* 935 */ "Q10_Q11_Q12_Q13\0"
  /* 951 */ "W12_W13\0"
  /* 959 */ "X6_X7_X8_X9_X10_X11_X12_X13\0"
  /* 987 */ "Z10_Z11_Z12_Z13\0"
  /* 1003 */ "b13\0"
  /* 1007 */ "d13\0"
  /* 1011 */ "h13\0"
  /* 1015 */ "p13\0"
  /* 1019 */ "q13\0"
  /* 1023 */ "s13\0"
  /* 1027 */ "w13\0"
  /* 1031 */ "x13\0"
  /* 1035 */ "z13\0"
  /* 1039 */ "D20_D21_D22_D23\0"
  /* 1055 */ "Q20_Q21_Q22_Q23\0"
  /* 1071 */ "W22_W23\0"
  /* 1079 */ "X16_X17_X18_X19_X20_X21_X22_X23\0"
  /* 1111 */ "Z20_Z21_Z22_Z23\0"
  /* 1127 */ "b23\0"
  /* 1131 */ "d23\0"
  /* 1135 */ "h23\0"
  /* 1139 */ "q23\0"
  /* 1143 */ "s23\0"
  /* 1147 */ "w23\0"
  /* 1151 */ "x23\0"
  /* 1155 */ "z23\0"
  /* 1159 */ "D0_D1_D2_D3\0"
  /* 1171 */ "Q0_Q1_Q2_Q3\0"
  /* 1183 */ "W2_W3\0"
  /* 1189 */ "X2_X3\0"
  /* 1195 */ "Z0_Z1_Z2_Z3\0"
  /* 1207 */ "b3\0"
  /* 1210 */ "d3\0"
  /* 1213 */ "h3\0"
  /* 1216 */ "p3\0"
  /* 1219 */ "q3\0"
  /* 1222 */ "s3\0"
  /* 1225 */ "w3\0"
  /* 1228 */ "x3\0"
  /* 1231 */ "z3\0"
  /* 1234 */ "D11_D12_D13_D14\0"
  /* 1250 */ "Q11_Q12_Q13_Q14\0"
  /* 1266 */ "Z11_Z12_Z13_Z14\0"
  /* 1282 */ "b14\0"
  /* 1286 */ "d14\0"
  /* 1290 */ "h14\0"
  /* 1294 */ "p14\0"
  /* 1298 */ "q14\0"
  /* 1302 */ "s14\0"
  /* 1306 */ "w14\0"
  /* 1310 */ "x14\0"
  /* 1314 */ "z14\0"
  /* 1318 */ "D21_D22_D23_D24\0"
  /* 1334 */ "Q21_Q22_Q23_Q24\0"
  /* 1350 */ "Z21_Z22_Z23_Z24\0"
  /* 1366 */ "b24\0"
  /* 1370 */ "d24\0"
  /* 1374 */ "h24\0"
  /* 1378 */ "q24\0"
  /* 1382 */ "s24\0"
  /* 1386 */ "w24\0"
  /* 1390 */ "x24\0"
  /* 1394 */ "z24\0"
  /* 1398 */ "D1_D2_D3_D4\0"
  /* 1410 */ "Q1_Q2_Q3_Q4\0"
  /* 1422 */ "Z1_Z2_Z3_Z4\0"
  /* 1434 */ "b4\0"
  /* 1437 */ "d4\0"
  /* 1440 */ "h4\0"
  /* 1443 */ "p4\0"
  /* 1446 */ "q4\0"
  /* 1449 */ "s4\0"
  /* 1452 */ "w4\0"
  /* 1455 */ "x4\0"
  /* 1458 */ "z4\0"
  /* 1461 */ "D12_D13_D14_D15\0"
  /* 1477 */ "Q12_Q13_Q14_Q15\0"
  /* 1493 */ "W14_W15\0"
  /* 1501 */ "X8_X9_X10_X11_X12_X13_X14_X15\0"
  /* 1531 */ "Z12_Z13_Z14_Z15\0"
  /* 1547 */ "b15\0"
  /* 1551 */ "d15\0"
  /* 1555 */ "h15\0"
  /* 1559 */ "p15\0"
  /* 1563 */ "q15\0"
  /* 1567 */ "s15\0"
  /* 1571 */ "w15\0"
  /* 1575 */ "x15\0"
  /* 1579 */ "z15\0"
  /* 1583 */ "D22_D23_D24_D25\0"
  /* 1599 */ "Q22_Q23_Q24_Q25\0"
  /* 1615 */ "W24_W25\0"
  /* 1623 */ "X18_X19_X20_X21_X22_X23_X24_X25\0"
  /* 1655 */ "Z22_Z23_Z24_Z25\0"
  /* 1671 */ "b25\0"
  /* 1675 */ "d25\0"
  /* 1679 */ "h25\0"
  /* 1683 */ "q25\0"
  /* 1687 */ "s25\0"
  /* 1691 */ "w25\0"
  /* 1695 */ "x25\0"
  /* 1699 */ "z25\0"
  /* 1703 */ "D2_D3_D4_D5\0"
  /* 1715 */ "Q2_Q3_Q4_Q5\0"
  /* 1727 */ "W4_W5\0"
  /* 1733 */ "X4_X5\0"
  /* 1739 */ "Z2_Z3_Z4_Z5\0"
  /* 1751 */ "b5\0"
  /* 1754 */ "d5\0"
  /* 1757 */ "h5\0"
  /* 1760 */ "p5\0"
  /* 1763 */ "q5\0"
  /* 1766 */ "s5\0"
  /* 1769 */ "w5\0"
  /* 1772 */ "x5\0"
  /* 1775 */ "z5\0"
  /* 1778 */ "D13_D14_D15_D16\0"
  /* 1794 */ "Q13_Q14_Q15_Q16\0"
  /* 1810 */ "Z13_Z14_Z15_Z16\0"
  /* 1826 */ "b16\0"
  /* 1830 */ "d16\0"
  /* 1834 */ "h16\0"
  /* 1838 */ "q16\0"
  /* 1842 */ "s16\0"
  /* 1846 */ "w16\0"
  /* 1850 */ "x16\0"
  /* 1854 */ "z16\0"
  /* 1858 */ "D23_D24_D25_D26\0"
  /* 1874 */ "Q23_Q24_Q25_Q26\0"
  /* 1890 */ "Z23_Z24_Z25_Z26\0"
  /* 1906 */ "b26\0"
  /* 1910 */ "d26\0"
  /* 1914 */ "h26\0"
  /* 1918 */ "q26\0"
  /* 1922 */ "s26\0"
  /* 1926 */ "w26\0"
  /* 1930 */ "x26\0"
  /* 1934 */ "z26\0"
  /* 1938 */ "D3_D4_D5_D6\0"
  /* 1950 */ "Q3_Q4_Q5_Q6\0"
  /* 1962 */ "Z3_Z4_Z5_Z6\0"
  /* 1974 */ "b6\0"
  /* 1977 */ "d6\0"
  /* 1980 */ "h6\0"
  /* 1983 */ "p6\0"
  /* 1986 */ "q6\0"
  /* 1989 */ "s6\0"
  /* 1992 */ "w6\0"
  /* 1995 */ "x6\0"
  /* 1998 */ "z6\0"
  /* 2001 */ "D14_D15_D16_D17\0"
  /* 2017 */ "Q14_Q15_Q16_Q17\0"
  /* 2033 */ "W16_W17\0"
  /* 2041 */ "X10_X11_X12_X13_X14_X15_X16_X17\0"
  /* 2073 */ "Z14_Z15_Z16_Z17\0"
  /* 2089 */ "b17\0"
  /* 2093 */ "d17\0"
  /* 2097 */ "h17\0"
  /* 2101 */ "q17\0"
  /* 2105 */ "s17\0"
  /* 2109 */ "w17\0"
  /* 2113 */ "x17\0"
  /* 2117 */ "z17\0"
  /* 2121 */ "D24_D25_D26_D27\0"
  /* 2137 */ "Q24_Q25_Q26_Q27\0"
  /* 2153 */ "W26_W27\0"
  /* 2161 */ "X20_X21_X22_X23_X24_X25_X26_X27\0"
  /* 2193 */ "Z24_Z25_Z26_Z27\0"
  /* 2209 */ "b27\0"
  /* 2213 */ "d27\0"
  /* 2217 */ "h27\0"
  /* 2221 */ "q27\0"
  /* 2225 */ "s27\0"
  /* 2229 */ "w27\0"
  /* 2233 */ "x27\0"
  /* 2237 */ "z27\0"
  /* 2241 */ "D4_D5_D6_D7\0"
  /* 2253 */ "Q4_Q5_Q6_Q7\0"
  /* 2265 */ "W6_W7\0"
  /* 2271 */ "X0_X1_X2_X3_X4_X5_X6_X7\0"
  /* 2295 */ "Z4_Z5_Z6_Z7\0"
  /* 2307 */ "b7\0"
  /* 2310 */ "d7\0"
  /* 2313 */ "h7\0"
  /* 2316 */ "p7\0"
  /* 2319 */ "q7\0"
  /* 2322 */ "s7\0"
  /* 2325 */ "w7\0"
  /* 2328 */ "x7\0"
  /* 2331 */ "z7\0"
  /* 2334 */ "D15_D16_D17_D18\0"
  /* 2350 */ "Q15_Q16_Q17_Q18\0"
  /* 2366 */ "Z15_Z16_Z17_Z18\0"
  /* 2382 */ "b18\0"
  /* 2386 */ "d18\0"
  /* 2390 */ "h18\0"
  /* 2394 */ "q18\0"
  /* 2398 */ "s18\0"
  /* 2402 */ "w18\0"
  /* 2406 */ "x18\0"
  /* 2410 */ "z18\0"
  /* 2414 */ "D25_D26_D27_D28\0"
  /* 2430 */ "Q25_Q26_Q27_Q28\0"
  /* 2446 */ "Z25_Z26_Z27_Z28\0"
  /* 2462 */ "b28\0"
  /* 2466 */ "d28\0"
  /* 2470 */ "h28\0"
  /* 2474 */ "q28\0"
  /* 2478 */ "s28\0"
  /* 2482 */ "w28\0"
  /* 2486 */ "x28\0"
  /* 2490 */ "z28\0"
  /* 2494 */ "D5_D6_D7_D8\0"
  /* 2506 */ "Q5_Q6_Q7_Q8\0"
  /* 2518 */ "Z5_Z6_Z7_Z8\0"
  /* 2530 */ "b8\0"
  /* 2533 */ "d8\0"
  /* 2536 */ "h8\0"
  /* 2539 */ "p8\0"
  /* 2542 */ "q8\0"
  /* 2545 */ "s8\0"
  /* 2548 */ "w8\0"
  /* 2551 */ "x8\0"
  /* 2554 */ "z8\0"
  /* 2557 */ "D16_D17_D18_D19\0"
  /* 2573 */ "Q16_Q17_Q18_Q19\0"
  /* 2589 */ "W18_W19\0"
  /* 2597 */ "X12_X13_X14_X15_X16_X17_X18_X19\0"
  /* 2629 */ "Z16_Z17_Z18_Z19\0"
  /* 2645 */ "b19\0"
  /* 2649 */ "d19\0"
  /* 2653 */ "h19\0"
  /* 2657 */ "q19\0"
  /* 2661 */ "s19\0"
  /* 2665 */ "w19\0"
  /* 2669 */ "x19\0"
  /* 2673 */ "z19\0"
  /* 2677 */ "D26_D27_D28_D29\0"
  /* 2693 */ "Q26_Q27_Q28_Q29\0"
  /* 2709 */ "W28_W29\0"
  /* 2717 */ "Z26_Z27_Z28_Z29\0"
  /* 2733 */ "b29\0"
  /* 2737 */ "d29\0"
  /* 2741 */ "h29\0"
  /* 2745 */ "q29\0"
  /* 2749 */ "s29\0"
  /* 2753 */ "w29\0"
  /* 2757 */ "x29\0"
  /* 2761 */ "z29\0"
  /* 2765 */ "D6_D7_D8_D9\0"
  /* 2777 */ "Q6_Q7_Q8_Q9\0"
  /* 2789 */ "W8_W9\0"
  /* 2795 */ "X2_X3_X4_X5_X6_X7_X8_X9\0"
  /* 2819 */ "Z6_Z7_Z8_Z9\0"
  /* 2831 */ "b9\0"
  /* 2834 */ "d9\0"
  /* 2837 */ "h9\0"
  /* 2840 */ "p9\0"
  /* 2843 */ "q9\0"
  /* 2846 */ "s9\0"
  /* 2849 */ "w9\0"
  /* 2852 */ "x9\0"
  /* 2855 */ "z9\0"
  /* 2858 */ "X22_X23_X24_X25_X26_X27_X28_FP\0"
  /* 2889 */ "W30_WZR\0"
  /* 2897 */ "LR_XZR\0"
  /* 2904 */ "za\0"
  /* 2907 */ "za0.b\0"
  /* 2913 */ "za0.d\0"
  /* 2919 */ "za1.d\0"
  /* 2925 */ "za2.d\0"
  /* 2931 */ "za3.d\0"
  /* 2937 */ "za4.d\0"
  /* 2943 */ "za5.d\0"
  /* 2949 */ "za6.d\0"
  /* 2955 */ "za7.d\0"
  /* 2961 */ "vg\0"
  /* 2964 */ "za0.h\0"
  /* 2970 */ "za1.h\0"
  /* 2976 */ "z10_hi\0"
  /* 2983 */ "z20_hi\0"
  /* 2990 */ "z30_hi\0"
  /* 2997 */ "z0_hi\0"
  /* 3003 */ "z11_hi\0"
  /* 3010 */ "z21_hi\0"
  /* 3017 */ "z31_hi\0"
  /* 3024 */ "z1_hi\0"
  /* 3030 */ "z12_hi\0"
  /* 3037 */ "z22_hi\0"
  /* 3044 */ "z2_hi\0"
  /* 3050 */ "z13_hi\0"
  /* 3057 */ "z23_hi\0"
  /* 3064 */ "z3_hi\0"
  /* 3070 */ "z14_hi\0"
  /* 3077 */ "z24_hi\0"
  /* 3084 */ "z4_hi\0"
  /* 3090 */ "z15_hi\0"
  /* 3097 */ "z25_hi\0"
  /* 3104 */ "z5_hi\0"
  /* 3110 */ "z16_hi\0"
  /* 3117 */ "z26_hi\0"
  /* 3124 */ "z6_hi\0"
  /* 3130 */ "z17_hi\0"
  /* 3137 */ "z27_hi\0"
  /* 3144 */ "z7_hi\0"
  /* 3150 */ "z18_hi\0"
  /* 3157 */ "z28_hi\0"
  /* 3164 */ "z8_hi\0"
  /* 3170 */ "z19_hi\0"
  /* 3177 */ "z29_hi\0"
  /* 3184 */ "z9_hi\0"
  /* 3190 */ "wsp\0"
  /* 3194 */ "za10.q\0"
  /* 3201 */ "za0.q\0"
  /* 3207 */ "za11.q\0"
  /* 3214 */ "za1.q\0"
  /* 3220 */ "za12.q\0"
  /* 3227 */ "za2.q\0"
  /* 3233 */ "za13.q\0"
  /* 3240 */ "za3.q\0"
  /* 3246 */ "za14.q\0"
  /* 3253 */ "za4.q\0"
  /* 3259 */ "za15.q\0"
  /* 3266 */ "za5.q\0"
  /* 3272 */ "za6.q\0"
  /* 3278 */ "za7.q\0"
  /* 3284 */ "za8.q\0"
  /* 3290 */ "za9.q\0"
  /* 3296 */ "ffr\0"
  /* 3300 */ "wzr\0"
  /* 3304 */ "xzr\0"
  /* 3308 */ "za0.s\0"
  /* 3314 */ "za1.s\0"
  /* 3320 */ "za2.s\0"
  /* 3326 */ "za3.s\0"
  /* 3332 */ "nzcv\0"
};
#ifdef __GNUC__
#pragma GCC diagnostic pop
#endif

  static const uint16_t RegAsmOffsetNoRegAltName[] = {
    3296, 2757, 227, 3332, 3191, 2961, 3190, 3300, 3304, 2904, 280, 665, 892, 1207,
    1434, 1751, 1974, 2307, 2530, 2831, 39, 383, 737, 1003, 1282, 1547, 1826, 2089,
    2382, 2645, 123, 507, 821, 1127, 1366, 1671, 1906, 2209, 2462, 2733, 203, 587,
    283, 668, 895, 1210, 1437, 1754, 1977, 2310, 2533, 2834, 43, 387, 741, 1007,
    1286, 1551, 1830, 2093, 2386, 2649, 127, 511, 825, 1131, 1370, 1675, 1910, 2213,
    2466, 2737, 207, 591, 286, 671, 898, 1213, 1440, 1757, 1980, 2313, 2536, 2837,
    47, 391, 745, 1011, 1290, 1555, 1834, 2097, 2390, 2653, 131, 515, 829, 1135,
    1374, 1679, 1914, 2217, 2470, 2741, 211, 595, 289, 674, 901, 1216, 1443, 1760,
    1983, 2316, 2539, 2840, 51, 395, 749, 1015, 1294, 1559, 292, 677, 904, 1219,
    1446, 1763, 1986, 2319, 2542, 2843, 55, 399, 753, 1019, 1298, 1563, 1838, 2101,
    2394, 2657, 135, 519, 833, 1139, 1378, 1683, 1918, 2221, 2474, 2745, 215, 599,
    295, 680, 907, 1222, 1449, 1766, 1989, 2322, 2545, 2846, 59, 403, 757, 1023,
    1302, 1567, 1842, 2105, 2398, 2661, 139, 523, 837, 1143, 1382, 1687, 1922, 2225,
    2478, 2749, 219, 603, 298, 683, 910, 1225, 1452, 1769, 1992, 2325, 2548, 2849,
    63, 407, 761, 1027, 1306, 1571, 1846, 2109, 2402, 2665, 143, 527, 841, 1147,
    1386, 1691, 1926, 2229, 2482, 2753, 223, 301, 686, 913, 1228, 1455, 1772, 1995,
    2328, 2551, 2852, 67, 411, 765, 1031, 1310, 1575, 1850, 2113, 2406, 2669, 147,
    531, 845, 1151, 1390, 1695, 1930, 2233, 2486, 304, 689, 916, 1231, 1458, 1775,
    1998, 2331, 2554, 2855, 71, 415, 769, 1035, 1314, 1579, 1854, 2117, 2410, 2673,
    151, 535, 849, 1155, 1394, 1699, 1934, 2237, 2490, 2761, 231, 607, 2907, 2913,
    2919, 2925, 2931, 2937, 2943, 2949, 2955, 2964, 2970, 3201, 3214, 3227, 3240, 3253,
    3266, 3272, 3278, 3284, 3290, 3194, 3207, 3220, 3233, 3246, 3259, 3308, 3314, 3320,
    3326, 2997, 3024, 3044, 3064, 3084, 3104, 3124, 3144, 3164, 3184, 2976, 3003, 3030,
    3050, 3070, 3090, 3110, 3130, 3150, 3170, 2983, 3010, 3037, 3057, 3077, 3097, 3117,
    3137, 3157, 3177, 2990, 3017, 619, 860, 1165, 1404, 1709, 1944, 2247, 2500, 2771,
    6, 313, 699, 927, 1242, 1469, 1786, 2009, 2342, 2565, 83, 427, 781, 1047,
    1326, 1591, 1866, 2129, 2422, 2685, 163, 547, 243, 1159, 1398, 1703, 1938, 2241,
    2494, 2765, 0, 307, 692, 919, 1234, 1461, 1778, 2001, 2334, 2557, 75, 419,
    773, 1039, 1318, 1583, 1858, 2121, 2414, 2677, 155, 539, 235, 611, 853, 857,
    1162, 1401, 1706, 1941, 2244, 2497, 2768, 3, 310, 695, 923, 1238, 1465, 1782,
    2005, 2338, 2561, 79, 423, 777, 1043, 1322, 1587, 1862, 2125, 2418, 2681, 159,
    543, 239, 615, 633, 873, 1177, 1416, 1721, 1956, 2259, 2512, 2783, 19, 327,
    714, 943, 1258, 1485, 1802, 2025, 2358, 2581, 99, 443, 797, 1063, 1342, 1607,
    1882, 2145, 2438, 2701, 179, 563, 258, 1171, 1410, 1715, 1950, 2253, 2506, 2777,
    13, 321, 707, 935, 1250, 1477, 1794, 2017, 2350, 2573, 91, 435, 789, 1055,
    1334, 1599, 1874, 2137, 2430, 2693, 171, 555, 250, 625, 866, 870, 1174, 1413,
    1718, 1953, 2256, 2509, 2780, 16, 324, 710, 939, 1254, 1481, 1798, 2021, 2354,
    2577, 95, 439, 793, 1059, 1338, 1603, 1878, 2141, 2434, 2697, 175, 559, 254,
    629, 2858, 2271, 2795, 343, 959, 1501, 2041, 2597, 459, 1079, 1623, 2161, 2889,
    639, 1183, 1727, 2265, 2789, 335, 951, 1493, 2033, 2589, 451, 1071, 1615, 2153,
    2709, 2897, 2882, 645, 1189, 1733, 2289, 2813, 361, 979, 1523, 2065, 2621, 483,
    1103, 1647, 2185, 659, 886, 1201, 1428, 1745, 1968, 2301, 2524, 2825, 32, 375,
    729, 995, 1274, 1539, 1818, 2081, 2374, 2637, 115, 499, 813, 1119, 1358, 1663,
    1898, 2201, 2454, 2725, 195, 579, 273, 1195, 1422, 1739, 1962, 2295, 2518, 2819,
    26, 369, 722, 987, 1266, 1531, 1810, 2073, 2366, 2629, 107, 491, 805, 1111,
    1350, 1655, 1890, 2193, 2446, 2717, 187, 571, 265, 651, 879, 883, 1198, 1425,
    1742, 1965, 2298, 2521, 2822, 29, 372, 725, 991, 1270, 1535, 1814, 2077, 2370,
    2633, 111, 495, 809, 1115, 1354, 1659, 1894, 2197, 2450, 2721, 191, 575, 269,
    655,
  };


#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Woverlength-strings"
#endif
  static const char AsmStrsvlist1[] = {
  /* 0 */ "\0"
};
#ifdef __GNUC__
#pragma GCC diagnostic pop
#endif

  static const uint8_t RegAsmOffsetvlist1[] = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0,
  };


#ifdef __GNUC__
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Woverlength-strings"
#endif
  static const char AsmStrsvreg[] = {
  /* 0 */ "v10\0"
  /* 4 */ "v20\0"
  /* 8 */ "v30\0"
  /* 12 */ "v0\0"
  /* 15 */ "v11\0"
  /* 19 */ "v21\0"
  /* 23 */ "v31\0"
  /* 27 */ "v1\0"
  /* 30 */ "v12\0"
  /* 34 */ "v22\0"
  /* 38 */ "v2\0"
  /* 41 */ "v13\0"
  /* 45 */ "v23\0"
  /* 49 */ "v3\0"
  /* 52 */ "v14\0"
  /* 56 */ "v24\0"
  /* 60 */ "v4\0"
  /* 63 */ "v15\0"
  /* 67 */ "v25\0"
  /* 71 */ "v5\0"
  /* 74 */ "v16\0"
  /* 78 */ "v26\0"
  /* 82 */ "v6\0"
  /* 85 */ "v17\0"
  /* 89 */ "v27\0"
  /* 93 */ "v7\0"
  /* 96 */ "v18\0"
  /* 100 */ "v28\0"
  /* 104 */ "v8\0"
  /* 107 */ "v19\0"
  /* 111 */ "v29\0"
  /* 115 */ "v9\0"
};
#ifdef __GNUC__
#pragma GCC diagnostic pop
#endif

  static const uint8_t RegAsmOffsetvreg[] = {
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    12, 27, 38, 49, 60, 71, 82, 93, 104, 115, 0, 15, 30, 41,
    52, 63, 74, 85, 96, 107, 4, 19, 34, 45, 56, 67, 78, 89,
    100, 111, 8, 23, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 12, 27, 38, 49,
    60, 71, 82, 93, 104, 115, 0, 15, 30, 41, 52, 63, 74, 85,
    96, 107, 4, 19, 34, 45, 56, 67, 78, 89, 100, 111, 8, 23,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 12, 27, 38, 49, 60, 71, 82, 93, 104,
    115, 0, 15, 30, 41, 52, 63, 74, 85, 96, 107, 4, 19, 34,
    45, 56, 67, 78, 89, 100, 111, 8, 23, 12, 27, 38, 49, 60,
    71, 82, 93, 104, 115, 0, 15, 30, 41, 52, 63, 74, 85, 96,
    107, 4, 19, 34, 45, 56, 67, 78, 89, 100, 111, 8, 23, 12,
    27, 38, 49, 60, 71, 82, 93, 104, 115, 0, 15, 30, 41, 52,
    63, 74, 85, 96, 107, 4, 19, 34, 45, 56, 67, 78, 89, 100,
    111, 8, 23, 12, 27, 38, 49, 60, 71, 82, 93, 104, 115, 0,
    15, 30, 41, 52, 63, 74, 85, 96, 107, 4, 19, 34, 45, 56,
    67, 78, 89, 100, 111, 8, 23, 12, 27, 38, 49, 60, 71, 82,
    93, 104, 115, 0, 15, 30, 41, 52, 63, 74, 85, 96, 107, 4,
    19, 34, 45, 56, 67, 78, 89, 100, 111, 8, 23, 12, 27, 38,
    49, 60, 71, 82, 93, 104, 115, 0, 15, 30, 41, 52, 63, 74,
    85, 96, 107, 4, 19, 34, 45, 56, 67, 78, 89, 100, 111, 8,
    23, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
    3,
  };

  switch(AltIdx) {
  default:
    return (const char *)(sizeof(RegAsmOffsetvreg)/sizeof(RegAsmOffsetvreg[0]));
  case AArch64_NoRegAltName:
    return AsmStrsNoRegAltName+RegAsmOffsetNoRegAltName[RegNo-1];
  case AArch64_vlist1:
    return AsmStrsvlist1+RegAsmOffsetvlist1[RegNo-1];
  case AArch64_vreg:
    return AsmStrsvreg+RegAsmOffsetvreg[RegNo-1];
  }
#else
  return NULL;
#endif
}
