 (module
  (table $t0 i64 0 externref)
  (table $t1 i64 1 externref)
  (table $t2 i64 0 2 externref)
  (table $t3 i64 3 8 externref)

  (func (export "size-t0") (result i64) table.size)
  (func (export "size-t1") (result i64) (table.size $t1))
  (func (export "size-t2") (result i64) (table.size $t2))
  (func (export "size-t3") (result i64) (table.size $t3))

  (func (export "grow-t0") (param $sz i64)
    (drop (table.grow $t0 (ref.null extern) (local.get $sz)))
  )
  (func (export "grow-t1") (param $sz i64)
    (drop (table.grow $t1 (ref.null extern) (local.get $sz)))
  )
  (func (export "grow-t2") (param $sz i64)
    (drop (table.grow $t2 (ref.null extern) (local.get $sz)))
  )
  (func (export "grow-t3") (param $sz i64)
    (drop (table.grow $t3 (ref.null extern) (local.get $sz)))
  )
)

(assert_return (invoke "size-t0") (i64.const 0))
(assert_return (invoke "grow-t0" (i64.const 1)))
(assert_return (invoke "size-t0") (i64.const 1))
(assert_return (invoke "grow-t0" (i64.const 4)))
(assert_return (invoke "size-t0") (i64.const 5))
(assert_return (invoke "grow-t0" (i64.const 0)))
(assert_return (invoke "size-t0") (i64.const 5))

(assert_return (invoke "size-t1") (i64.const 1))
(assert_return (invoke "grow-t1" (i64.const 1)))
(assert_return (invoke "size-t1") (i64.const 2))
(assert_return (invoke "grow-t1" (i64.const 4)))
(assert_return (invoke "size-t1") (i64.const 6))
(assert_return (invoke "grow-t1" (i64.const 0)))
(assert_return (invoke "size-t1") (i64.const 6))

(assert_return (invoke "size-t2") (i64.const 0))
(assert_return (invoke "grow-t2" (i64.const 3)))
(assert_return (invoke "size-t2") (i64.const 0))
(assert_return (invoke "grow-t2" (i64.const 1)))
(assert_return (invoke "size-t2") (i64.const 1))
(assert_return (invoke "grow-t2" (i64.const 0)))
(assert_return (invoke "size-t2") (i64.const 1))
(assert_return (invoke "grow-t2" (i64.const 4)))
(assert_return (invoke "size-t2") (i64.const 1))
(assert_return (invoke "grow-t2" (i64.const 1)))
(assert_return (invoke "size-t2") (i64.const 2))

(assert_return (invoke "size-t3") (i64.const 3))
(assert_return (invoke "grow-t3" (i64.const 1)))
(assert_return (invoke "size-t3") (i64.const 4))
(assert_return (invoke "grow-t3" (i64.const 3)))
(assert_return (invoke "size-t3") (i64.const 7))
(assert_return (invoke "grow-t3" (i64.const 0)))
(assert_return (invoke "size-t3") (i64.const 7))
(assert_return (invoke "grow-t3" (i64.const 2)))
(assert_return (invoke "size-t3") (i64.const 7))
(assert_return (invoke "grow-t3" (i64.const 1)))
(assert_return (invoke "size-t3") (i64.const 8))
