//! Expose all known instructions as Rust `struct`s; this is generated in
//! `build.rs`.
//!
//! See also: [`Inst`], an `enum` containing all these instructions.

use crate::api::{AsReg, CodeSink, KnownOffsetTable, RegisterVisitor, Registers};
use crate::gpr::{self, Gpr, Size};
use crate::imm::{Extension, Imm16, Imm32, Imm8, Simm32, Simm8};
use crate::mem::{emit_modrm_sib_disp, Amode, GprMem, XmmMem};
use crate::rex::{self, RexFlags};
use crate::xmm::Xmm;

// Include code generated by the `meta` crate.
include!(concat!(env!("OUT_DIR"), "/assembler.rs"));

/// Helper function to make code generation simpler.
fn emit_modrm(buffer: &mut impl CodeSink, enc_reg_g: u8, rm_e: u8) {
    let modrm = rex::encode_modrm(0b11, enc_reg_g & 7, rm_e & 7);
    buffer.put1(modrm);
}
