# VTK 9.5 Release Notes

Changes made since VTK 9.4.2 include the following.

----------------------------------------

<!-- sphinx-exclude-start -->

<!-- vim-markdown-toc GFM -->

* [New Features](#new-features)
    * [Annotation](#annotation)
    * [DataModel](#datamodel)
    * [Filters](#filters)
    * [I/O](#io)
    * [Interaction](#interaction)
    * [Python](#python)
    * [Qt](#qt)
    * [Rendering](#rendering)
    * [ThirdParty](#thirdparty)
    * [WebAssembly](#webassembly)
    * [Wrapping](#wrapping)
* [Changes](#changes)
    * [API](#api)
    * [Annotation](#annotation-1)
    * [Build](#build)
    * [Filters](#filters-1)
    * [I/O](#io-1)
    * [Interaction](#interaction-1)
    * [ThirdParty](#thirdparty-1)
    * [VR](#vr)
    * [Wrapping](#wrapping-1)
* [Fixes/improvements](#fixesimprovements)
    * [Charts](#charts)
    * [DataModel](#datamodel-1)
    * [Filters](#filters-2)
    * [I/O](#io-2)
    * [MPI](#mpi)
    * [Python](#python-1)
    * [Rendering](#rendering-1)
    * [WebAssembly](#webassembly-1)
* [Deprecations/Removals](#deprecationsremovals)

<!-- vim-markdown-toc -->

----------------------------------------

<!-- sphinx-exclude-end -->

## New Features

### Annotation

- **Grid Axes in VTK**
    VTK now has the `vtkGridAxesActor3D` that is the successor to the `vtkCubeAxesActor` for cube axes annotation. This new actor was the default cube axes grid for ParaView and uses `vtkAxisActor` underneath the covers for better label placement strategy over its precursor.
    ![Grid Axes Actor 3D](https://vtk.org/files/ExternalData/SHA512/70e9ad194620080a3f194edf08a8b726af2d39f019b61169a66a07a7ff71024bfefa9b0919dac0924e637169564ef0d11d50c31c0e318e72b3df9e2ca459d433)

### DataModel

- **Add AxisAligned and Offset options to vtkPlane**
    vtkPlane now has AxisAligned and Offset options.
    - AxisAligned: if On, locks normal to plane to be aligned with x, y, or z axis.
    - Offset: the origin is shifted in the direction of the normal by the offset.

- **Introduce implicit Frustum and widget**

    ![Implicit Frustum Widget](imgs/9.5/implicit-frustum-widget.png)

    The new `vtkFrustum` implicit function represents a frustum resembling a pyramid with a clipped top. You can shape it by using setters for its vertical/horizontal angles and the near plane distance. It supports `vtkImplicitFunction`'s transform capabilities.
    ([Author notes](9.5/frustum-implicit-widget.md))

- **vtkDataSet: Add GetMinSpatialDimension**
    `vtkDataSet` has a new method `GetMinSpatialDimension` that returns the minimum spatial dimension of the dataset.

- **Added new class to manually create a Cocoa NSAutoreleasePool**
    The new class `vtkCocoaAutoreleasePool` allows manually creating and draining a Cocoa autorelease pool.
    ([Author notes](9.5/add-vtkCocoaAutoreleasePool.md))

### Filters

- **Add AxisAlignedReflectionFilter**

    The Axis Aligned Reflection filter reflects the input dataset across the specified plane.
    This filter operates on any type of data set or hyper tree grid and produces a Partitioned DataSet Collection containing partitions of the same type as the input (the reflection and the input if CopyInput is enabled).
    Data arrays are also reflected (if ReflectAllInputArrays is false, only Vectors, Normals and Tensors will be reflected, otherwise, all 3, 6 and 9-component data arrays are reflected).

- **Add AxisAlignedTransformFilter**

    The Axis Aligned Transform Filter performs axis aligned affine transformation on the input (translation, scaling, rotation). The filter operates on any type of vtkDataSet or vtkHyperTreeGrid, and the outputs data type matches the input.

- **Add FillMaterial option to HTG Geometry filter**
    `vtkHyperTreeGridGeometry` now has a `FillMaterial` option. Enabled by default, it produces the same result as before. When disabled, only interface lines are added to the resulting polydata.

- **Add option to add cells to the output of vtkPCANormalEstimation**

    The vtkPCANormalEstimation support now adding cells to the output `vtkPolyData` to enable the visualization on paraview, the user can set the variable CellGenerationMode to 0: No cells will be added (default option), 1: A single cell encompassing the entire `vtkPolyData` and 2: A cell for each point.

- **Add Gaussian integration strategy**

    The `vtkIntegrateAttributes` filter now accepts different integration strategies. The original way of integration is now called Linear and the Gaussian Integration strategy has been added. The Gaussian Integration handles higher order cells and n-linear degenerate cells like non planar quads or hexahedron with non planar faces. Also, the Gaussian integration is not affected by a different point ordering as long as the constraints specified for each cell are maintained.

- **Add support for oriented images in vtkProbeFilter**

    vtkProbeFilter has been improved to support oriented images.
    The implementation now rely on the native support of orientation
    in the API of vtkImageData.

- **Add vtkQuadricDecimation::Set/GetMaximumError()**
    `vtkQuadricDecimation` now has `SetMaximumError()` and `GetMaximumError()` methods. This allows stopping decimation when the node error exceeds a specified upper limit.

- **Append filters: Multithread and Improve Performance**
    The `vtkAppendFilter` and `vtkAppendPolyData` filters have been re-written and multithreaded, significantly improving their performance. `vtkMergeBlocks` and `vtkAppendDataSets`, which use these filters internally, have also been improved.

- 💥**Introduce vtkExplodeDataSet filter**

    ![Blocks from FeatureEdges Region Ids](imgs/9.5/ExplodeDataSet.png)

    `vtkExplodeDataSet` creates a `vtkPartitionedDataSetCollection` from any input dataset according to a cell scalar isovalue criteria. Each partition of the output contains cells that share the same value for the given cell array. It replaces `vtkSplitByCellScalarFilter` and uses `vtkPartitionedDataSetCollection` as output.
    ([Author notes](9.5/ExplodeDataSet.md))

- **vtkGenerateRegionIds**
    `vtkGenerateRegionIds` is a new polydata filter that adds a CellData array containing a region identifier. A region is defined as a collection of cells sharing at least one point and having normals within a configurable `MaxAngle` threshold. The resulting array name is `vtkRegionIds` by default.
    ([Author notes](9.5/region-id-filter.md))

### I/O

- **Add AVMESH reader**

    AVMESH is the unstructured format used in CREATE-AV Kestrel and Helios.

- **Add external memory support for vtkConduitSource**

    `vtkConduitSource` can now keep point coordinates, cell connectivity
    and field values from conduit on an accelerator device such as CUDA or
    HIP. This is done by testing pointers in conduit to see if they are
    stored on a device or on the host memory. Note that you must
    configure and build VTK with VTK-m configured for the appropriate
    device, otherwise data will be transferred to the host memory.

- **Add vtkFidesWriter for writing out data in ADIOS2 BP format**

    This adds `vtkFidesWriter` which uses the Fides library to write data to ADIOS2 BP files.
    This initial version only provides support for the BP engines (SST support is in progress).
    When writing the data, Fides will also write the schema as an attribute in the BP file,
    so the data can be read back in with `vtkFidesReader`.

- **Add zone section selection to FLUENT Reader**
    You can now select zone sections to load when reading a FLUENT file, and the output multiblock will only contain these zones. A `CacheData` option is available to balance I/O performance and memory usage. Due to interdependencies, some unselected zones might still be read.
    ([Author notes](9.5/fluentReaderImprovements.md))

- **CGNSReader: Load surface elements stored as Element_t entries**
    The CGNS reader has a new option `LoadSurfacePatch` that allows to read 2D elements that are not `BC_t` nodes (handled by the `LoadBndPatch` option) but rather `Element_t` nodes. This allows reading boundary elements regardless of assigned boundary conditions.

- **GLTF document loader selectively toggle model data**
    The `vtkGLTFDocumentLoader` can now selectively enable/disable loading of animation keyframes (`SetLoadAnimation`), model images (`SetLoadImages`), and inverse bind matrices for model Skin (`SetLoadSkinMatrix`). All are true by default.
    ([Author notes](9.5/gltf-toggle-data.md))

- **Import GLTF scenes from in-memory streams**

    ![GLTF Stream Import Example](https://vtk.org/files/ExternalData/SHA512/a40ba06e652140ed031e7cda5597b2cfa84b42ab2ae05ca068c015432e5302f00c72bea03b2bb9e6532181fb0a33ec4abc7f178ad2292d57cb82d6bc9ee97bf7)

    The `vtkGLTFImporter` now accepts a resource stream to load the scene from.

- **netcdf: Enable CDF5 format**
    VTK's internal netcdf now enables the CDF5 format.

- **OpenFOAM reader: allow `_0` files**
    The OpenFOAM file reader in VTK now provides an option to load file names which ends with `_0`. This was previously disabled as OpenFOAM restart files often use this naming schema, but it prevented loading actual result files with the same pattern.
    ([Author notes](9.5/openfoam-restart-files.md))

- **Support reading XGC files in Fides format**
    Recent changes to Fides allow loading XGC files without specifying paths to all of the input files. The VTK Fides reader is updated to support reading these files.

- **Support unsigned integers in netCDF files**
    NetCDF readers like `vtkNetCDFCFReader` now support unsigned integer data types, loading these variables into the correct VTK array type.

- **vtkConduitSource: Add state/metadata/vtk_fields node**

    A new Conduit tree node, `state/metadata/vtk_fields`, has been introduced to store VTK-interpretable field metadata, including `attribute_type` and data cleaning parameters, thereby deprecating `ascent_ghosts`.
    ([Author notes](9.5/add-state_metadata_vtk_fields-vtkConduitSource.md))

- **vtkDelimitedTextReader improvements: Preview, SkippedRecords, Comments**
    `vtkDelimitedTextReader` now offers a `GetPreview()` method to inspect the initial lines of a file for configuration. A new `SkippedRecords` option allows skipping initial N records. Support for `CommentCharacters` has been added to ignore parts of records.
    ([Author notes](9.5/delimited-text-reader-options.md))

- **vtkLANLX3DReader: Import from ParaView**
    `vtkLANLX3DReader` is a reader for LANL X3D files. This reader used to be available in ParaView, but it has been moved to VTK now.

- **vtkOpenFOAMReader: Multithreaded Reading of case files**
    `vtkOpenFOAMReader` now supports multithreaded reading of case files (on by default, disable with `SetSequentialProcessing(true)`). Useful for large cases on network drives. An option `ReadAllFilesToDetermineStructure` (off by default) allows reading only proc 0 directory to determine case structure. Several performance improvements were also made.
    ([Author notes](9.5/multithread-vtkOpenFOAMReader.md))

- **VTK Conduit now supports pyramids and wedges**
    VTK_PYRAMID and VTK_WEDGE cell types are now supported by `vtkDataObjectToConduit`. These cell types are serialized to Conduit nodes with "shape" set to "pyramid" or "wedge" respectively.

- **VTK Conduit now supports Blueprint implicit topology using point set**

    Catalyst Conduit now supports Blueprint's implicit topology using point sets, enabling meshes defined by points without cells. This is achieved by specifying a points topology type linked to an explicit coordset.
    ([Author notes](9.5/vtk-Catalyst-Implicit-Topology.md)

- **VTKHDF: Add support for HyperTreeGrid**

    HyperTreeGrid support has been added to the VTKHDF specification and reader. It supports temporal & multi-piece reading.

    VTKHDF Specification is now version 2.4.

- **VTKHDF: Support reading and writing composite distributed temporal datasets**

    The vtkHDFWriter support now extends to composite temporal datasets (multiblock and partitioned dataset collection), all written in a same file.
    Composite temporal datasets can also be written and read efficiently in parallel using MPI, and support static meshes.

    Support for reading composite structures containing ImageData has been fixed. `vtkHDFReader` protected members `WholeExtent`, `Origin` and `Spacing` have been deleted.

### Module System

- **vtk_module_wrap_python**

  Added argument `vtk_module_wrap_python(WRAP_TARGET)`. This argument names a target to be created that depends upon all wrapping work done in the call.

### Interaction

- **Add getter and setter functions for the text on the buttons of vtkCameraOrientationRepresentation**

    You can now customize the text displayed on top of the buttons of a `vtkCameraOrientationRepresentation` using functions like `vtkCameraOrientationRepresentation::SetXPlusLabelText(const std::string& label)`.
    These methods follow similar naming convention to the existing getter methods for the `vtkTextProperty` corresponding to the button labels.
    ([Author notes](9.5/add-getter-setter-for-camera-orientation-widget-buttons.md))

- **Add function Stop Select to vtkInteractorStyleRubberBandPick**

    As the already existing "StartSelect()" function allows user to start picking, the new function "StopSelect()" allows to interrupt picking.

- **Add option to independently set the thickness of reslice cursor widget axes**

    You can now set the thickness of reslice cursor axes independently by turning on the vtkResliceCursorRepresentation::IndependentThickness flag.

### Python

- **Wheels for linux aarch64 available on PyPi**

    VTK now provides wheels for Linux aarch64. See https://pypi.org/project/vtk/9.5.0/

- **Add `vtkBitArray` support to `numpy_support`**
    Array conversion between vtk and numpy (using `vtk_to_numpy`) now supports `vtkBitArray`. Converting a `vtkBitArray` to numpy results in an array of uint8.

- **Add deprecated decorator to Python**

    VTK now provides a `@deprecated` decorator that emits a `DeprecationWarning` when a decorated function is called. You can edit the message shown to the user.

    To mark a function as deprecated, use:
    ```python
    @deprecated(version=1.2, message="Use 'new_function' instead.")
    def old_function():
        pass
    ```

- **Add to the NetCDFCFReader the ability to use data from an XArray**
    An XArray can create a vtkNetCDFCFReader that uses its data, using zero copy when possible to create a VTK dataset using `reader = xarray_data.vtk.reader()`. Any `vtkNetCDFCFReader` options can be set (`FileName` is ignored), and the reader can be used as usual in a VTK pipeline.

- **OpenXR and OpenXRRemoting modules are now wrapped in Python and shipped in Windows VTK wheels!**
    OpenXR loader is shipped with the wheel, but OpenXR runtimes have to be installed by the end user for their specific devices.

### Qt

- **Generate ConfigureEvent for Qt QResizeEvent**

    The `QVTKInteractorAdapter` now translates QResizeEvent into
    a VTK ConfigureEvent. This brings its behavior in line with
    the native X11/Windows/macOS event handling, which generate
    ConfigureEvent in response to the native UI resize events.

- **Add EnableTouchEventProcessing flag to QVTKOpenGL*Widgets & QVTKOpenGLWindow**

    As Qt touch event will automatically be translated to mouse event, so the mouse event will be processed twice for one touch in VTK interactor.
    With this new flag for `QVTKOpenGL*Widget/QVTKOpenGLWindow`, you can switch on/off the Qt touch event processing by purpose.

- **Multi-touch gestures in QtQuick/QML**
    Added support for multi-touch interaction to `QQuickVTKItem` using the `PinchHandler` QML component. Connect new slots in `QQuickVTKItem` to the handler's signals for translation, rotation, and scale changes.
    ([Author notes](9.5/qml-multitouch.md))

### Rendering

- **Add new setting to specify 2D point shape in vtkProperty**

    You can now draw round points by calling `vtkProperty::SetPoint2DShape(vtkProperty::Point2DShapeType::Round)`. The default is square. This feature is currently implemented in the WebGPU rendering module.
    ([Author notes](9.5/add-point-2d-shape-setting-for-vtkProperty.md))

- **Add option to independently set thickness of cell edges and lines**

    You can now set the thickness of cell edges independently without altering the
    thickness of lines. This feature is useful to emphasize either edges or lines in a scene
    with different widths.

    ![Image showing different edge and line widths](imgs/9.5/add-edge-width-property.png)

    ([Author notes](9.5/add-edge-width-property.md))

- **Add Prolab Transfer function interpolation support**

    The `vtkColorTransferFunction` now supports Prolab color space for interpolation via `vtkColorTransferFunction::SetColorSpaceToProlab()`.
    ([Author notes](9.5/add-prolab-transferfunction-interpolation.md))

- **Add SurfaceProbeVolumeMapper**
    `vtkOpenGLSurfaceProbeVolumeMapper` is a PolyDataMapper colored with probed volume data. It accepts Input (rendered surface), Source (vtkImageData for scalar interpolation), and optional ProbeInput (geometry for interpolation). Scalar values are projected using texture coordinates.
    ([Author notes](9.5/addSurfaceProbeVolumeMapper.md))

- **Add vtkFastLabeledDataMapper**

    The new `vtkFastLabeledDataMapper` uses GPU texture acceleration to draw labels at much
    higher frame rates, designed to render thousands of labels at over 60 fps.

- **Add vtkLightWidget to path-traced environments**

    The `vtkRenderingRayTracing` module now supports rendering and interaction with the `vtkLightWidget` for interactive light placement and modification.

    ![](https://vtk.org/files/ExternalData/SHA512/53b5e6ab5f30f59915be20da76fb415181d7fba709964f0d78de60bcc24abb860d2f339dfeaad26da8dfbe4f674617a65132ec442955c9ba9768d9c630693a8b)

    ![LightWidget in Path Tracing](imgs/9.5/lightwidget_pathtracing.png)

- **Add webgpu implementation for vtkGlyph3DMapper**

    The VTK::RenderingWebGPU module now provides an implementation for the abstract `vtkGlyph3DMapper` class.

- **Add webgpu implementation for vtkPolyDataMapper2D**

    The VTK::RenderingWebGPU module now provides an implementation for the abstract `vtkPolyDataMapper2D` class. This allows rendering geometry in the 2D viewport plane using webgpu.

- **Improved OpenGL Debug Logging**

    You can now see detailed debug messages from OpenGL when VTK is built with `VTK_REPORT_OPENGL_ERRORS=ON`. The `vtkOpenGLRenderWindow` utilizes the `GL_ARB_debug_output` extension for more clarity. The `QVTKRenderWindowAdapter` now creates a debug OpenGL context when this option is enabled.

- **Memory Statistics For WebGPU Rendering Backend**

    You can now view detailed information about the GPU memory usage
    of individual textures and buffers by setting the `VTK_WEBGPU_MEMORY_LOG_VERBOSITY`
    environment variable or specifying a `vtkLogger::Verbosity` value to
    `vtkWebGPUConfiguration::SetGPUMemoryLogVerbosity`.

- **Order Indepedent Translucency with MSAA**

    ![](https://vtk.org/files/ExternalData/SHA512/b5dce5a56db0d685c638e3383536bcbb1cbf0b71040989c7fad040f221f4527f761d7cd22c7e4dd63aaf368cc236e366d37c4832b07f59f50b6928d223f7da9e)

    The new `vtkRenderer::UseOIT` flag helps resolve conflicts between OIT and MSAA.
    ([Author notes](9.5/useoit_translucent.md))

### ThirdParty

- **Add scnlib third-party library**

    The `scnlib` third-party library (v4.0.1) has been added to VTK for fast and efficient parsing of numbers from strings.

### WebAssembly

- **Allow binding a WASM scene manager render window to a HTML canvas**

    You can now call `sceneManager.bindRenderWindow(vtkTypeUInt32 id, const char* canvasSelector)` method from JavaScript
    in order to bind a render window to a HTML canvas element.

- **Add exception support for WebAssembly builds**

    You can now enable exceptions in VTK wasm build with the `VTK_WEBASSEMBLY_EXCEPTIONS` option. Default value is `OFF`.

### Wrapping

- **Add function call feature in vtkObjectManager**

    You can now invoke methods on a registered object using the
    new `nlohmann::json vtkObjectManager::Invoke(vtkTypeUInt32 identifier, const std::string& methodName, const nlohmann::json& args)`
    function.

- **Add method that allows updating states of specific objects.**

    You can now call the `void UpdateStatesFromObjects(const std::vector<vtkTypeUInt32>& identifiers)` method on the `vtkObjectManager`
    to only update states of objects corresponding to the vector of identifiers. This method allows you to efficiently update a specific
    object and it's dependencies without touching other unrelated objects.

- **Add new verbosity setting for log messages related to marshalling**

    You can now configure the verbosity level for log messages in the core marshalling classes `vtkDeserializer`, `vtkSerializer` and `vtkObjectManager`. This facilitates debugging (de)serialization errors in release builds on the desktop and even in wasm.


## Changes

### API

- **Remove usage of the nlohmannjson library from public facing API** :warning: **BREAKING_CHANGES**

    The `nlohmann::json vtkAbstractArray::SerializeValues()` method is removed due to conflicts with downstream projects using different nlohmannjson versions. This method, added in 9.4, has been reverted.
    ([Author notes](9.5/breaking-change-remove-nlohmann-json-from-public-API.md))

### Annotation

- **vtkAxisActor and vtkPolarAxesActor breaking changes** :warning: **BREAKING_CHANGES**

    Protected members of `vtkAxisActor` and `vtkPolarAxesActor` classes were moved to private. Please use appropriate Getter/Setter to use them instead. Also some API were ported from `const char*` to `std::string`, breaking getters like `vtkAxisActor::GetTitle()` and `vtkPolarAxesActor::GetPolarAxisTitle()`.
    ([Author notes](9.5/axes-actors-breaking-change.md))

### Build

- **C++17 is now required for VTK** :warning: **BREAKING_CHANGES**

    VTK now requires C++17 compiler support. Minimum required compiler versions have been updated (e.g., GCC 8.0, Clang 5.0, MSVC 2017, Apple Clang 10.0, Intel ICC 19.0).

- **Simplify the customization for Kokkos backend**

    When using Kokkos, setting up compilers for devices/backends requiring specific languages (like CUDA or HIP) is simplified. VTK now gets Kokkos backends directly from Kokkos configuration, automating compiler setup, removing the need to set `VTK_KOKKOS_BACKEND`.

### Filters

- **Rename HTG filter VisibleLeavesSize to GenerateFields**

    `vtkHyperTreeGridVisibleLeavesSize` is renamed to `vtkHyperTreeGridGenerateFields`. The new class is more generic, allowing easier addition of new fields by inheriting `vtkHyperTreeGridGenerateField`.

- **HTG Surface Representation improvements** :warning: **BREAKING_CHANGES**

    Cells outside the camera frustum are now decimated in 3D/2D/1D in HTG Surface Representation, working in all cases including non-parallel projection and masks. Several public members of `vtkAdaptiveDataSetSurfaceFilter` are deprecated or moved to private.
    ([Author notes](9.5/htg-representation-decimation.md))

- **vtkParticleTracer::CachedData private**

    Previously protected member `vtkParticleTracer::CachedData` is now a private member. It is not intended to be used by classes inheriting `vtkParticleTracer`.

- **vtkQuadricDecimation now handles id attributes**

    The quadric decimation filter has been updated for `vtkIdTypeArray` point attributes. These are no longer interpolated during edge collapse; instead, one ID is kept, and the other is discarded.

### I/O

- **JSONSceneExporter: Support exporting a list of named actors and arrays selections**

    `vtkJSONSceneExporter` can now export a list of named actors and select which arrays are exported per actor. `vtkJSONDataSetWriter` also supports point/cell array selection. Some protected methods in `vtkJSONSceneExporter` are now private.


### Interaction

- **High precision timers for Windows interactor**

    The Windows interactor was creating timers using the native Win32 API `SetTimer`.
    However, this timer isn't precise and the duration wasn't respected for short duration.
    It now uses `CreateTimerQueueTimer` API which is much more precise.

### Thirdparty

- **Transition from VTKm to Viskores**

    VTK has transitioned its dependency from [VTKm](https://gitlab.kitware.com/vtk/vtk-m) to [Viskores](https://github.com/viskores/viskores).
    VTK Accelerator VTKm API remains fully compatible for downstream users.
    No code changes should be required for applications using the VTK Accelerator API.
    ([Author notes](9.5/transition-from-vtkm-to-viskores.md))

- **cli11**

    Updated to be based on [v2.5.0](https://github.com/CLIUtils/CLI11/tree/v2.5.0) for security updates and bug fixes.

- **diy**

    Updated to use the internal `fmt` library. This change is necessary to avoid conflicts with diy's `fmt`.

- **expat**

    Updated to be based on [2.7.0](https://github.com/libexpat/libexpat/releases/tag/R_2_7_0). Using expat older than 2.6.3 now causes a warning.

- **exprtk**

    Update to be based on [0.0.3-cmake](https://github.com/ArashPartow/exprtk/releases/tag/0.0.3-cmake).

- **fast_float**

    Updated to be based on [v8.0.2](https://github.com/fastfloat/fast_float/releases/tag/v8.0.2). The minimum version has been upgraded to 7.0.0 to support int parsing and have C++17 compliant results.

- **fmt**

    Updated to be based on [11.1.4](https://github.com/fmtlib/fmt/releases/tag/11.1.4). The minimal external fmt version is now 11.0.0.

- **libharu**

    Updated to be based on [v2.4.5](https://github.com/libharu/libharu/tree/v2.4.5) to obtain the latest security and bug fix patches.

- **lz4**

    Updated to be based on [v1.10.0](https://github.com/lz4/lz4/tree/v1.10.0) for security updates and bug fixes.

- **lzma**

    Updated to be based on [v2.6.4](https://github.com/tukaani-project/xz/tree/v5.6.4) to obtain the latest security and bug fix patches.

- **exodusII and Ioss**

    Updated `exodusII` and `Ioss`  to be based on [SEACAS 2025-02-27](https://github.com/sandialabs/seacas/releases/tag/v2025-02-27).

### VR

- **`vtkOpenXRManager::Initialize` and `vtkOpenXRManager::Finalize` marked as internal APIs**

    These functions are now treated as internal to `vtkOpenXRRenderWindow`. The signature of `vtkOpenXRManager::Initialize` has changed.

- **`vtkOpenXRManager::(Set|Get)UseDepthExtension` moved to `vtkOpenXRRenderWindow`**

    These methods have been moved to `vtkOpenXRRenderWindow`. The `vtkOpenXRManager` versions are now no-op and deprecated.

### Wrapping

- **Change Java build flags**

    `VTK_JAVA_SOURCE_VERSION` and `VTK_JAVA_TARGET_VERSION` CMake flags are superseded by `VTK_JAVA_RELEASE_VERSION`. This aligns with newer JDK `javac` versions that provide the `-release` flag, simplifying build configuration.

## Fixes/improvements

### Charts

- **Fix vtkPlotBar::GetBounds logic when log scale is enabled**

    The `vtkPlotBar::GetBounds(double*, bool unscaled)` now correctly returns unscaled bounds when `unscaled` is true and scaled bounds when `unscaled` is false.

### DataModel

- **Fix CellTreeLocator for 2D grids**

    A `std::vector` out of bounds access has been fixed when building the locator for meshes whose x, y or z extent is zero.

- **Polygon centroid computation fixed**

    An issue with `vtkPolygon::ComputeCentroid()` has been fixed. It now uses a composite weighted-area triangulation for robustness with non-planar polygons and includes a planarity tolerance.
    ([Author notes](9.5/fix-polygon-centroid.md))

- **vtkPolyhedron: Implement GetCentroid and use it in GetParametricCenter**

    In VTK 9.5.1, the `vtkPolyhedron` class introduces the `GetCentroid` function, which computes the signed-volume weighted centroid of a polyhedron using its pyramid decomposition. The `GetParametricCenter` method has been updated to return the parametric location of the centroid returned from `vtkPolyhedron`'s `GetCentroid` function.
    ([Author notes](9.5/fix-polyhedron-parametric-center.md))

- **Implicit Widget Representations Improvements**

    Improved interaction and intuitiveness in VTK's implicit widget representations, including enhanced picking and mouse-based control for shape sizing. A new `vtkBoundedWidgetRepresentation` base class introduces cropping to outline bounds, with API changes affecting several subclasses.
    ([Author notes](9.5/widget-representations-improvements.md))

### Filters

- **Fix vtkBandedPolyDataContourFilter scalars**

    You can now select scalars used by `vtkBandedPolyDataContourFilter` using the `SetInputArrayToProcess` method instead of changing the scalars on the input data.

- **Fix vtkParticleTracer with unstructured data**

    Fixed an issue leading to a crash in `vtkParticleTracer` where locators for unstructured data would not have been created.

- **Fix UMR in vtkDataSetTriangleFilter**

    For a `vtkUnstructuredGrid` input consisting of only tetrahedrons, `vtkDataSetTriangleFilter` could give non-deterministic results due to an uninitialized memory read (UMR).

- **Support Partitioned Input in HyperTreeGridGhostCellsGenerator**

    The HTG GhostCellsGenerator now natively supports Partitioned inputs, using the first non-null partition found as the HTG to process, fixing issues with multi-partition data.

- **vtkGeometryFilter: Improve performance for polyhedron**

    `vtkGeometryFilter` now efficiently extracts polyhedron faces using `GetPolyhedronFaces` and `GetPolyhedronFaceLocations` methods, improving performance.

- **vtkRandomAttributesFilter: Prevent deletion of actives attributes**

    When using `vtkRandomAttributesGenerator`, the filter no longer replaces active attributes; it now appends the new random array and flags it as active. Random normals and tcoords are now correctly named.

- **Relative Mode for vtkTemporalArrayOperatorFilter** :warning: **BREAKING_CHANGES**

    `vtkTemporalArrayOperatorFilter` now supports a `RelativeMode` that uses the current `UPDATE_TIME_STEP` and a shifted time step for temporal operations. This introduces consistent output behavior across data types and enforces encapsulation via getter/setter access to formerly protected members.
    ([Author notes](9.5/relative-temporal-array-operator.md))


### I/O

- **EnsightCombinedReader: Performance improvements pass**

    Performance of `vtkEnSightGoldCombinedReader` improved, especially for large binary files with nfaced/tetrahedron cells. Fixes include tetrahedron-specific cell building, block reading of connectivity data, faster parsing during RequestInfo, and an int overflow fix.
    ([Author notes](9.5/ensight-reader-improvements.md))

- **Fix AMReX particle reader for files without top-level header**

    The `vtkAMReXParticlesReader` now continues to read particles if a top-level header is missing, initializing the time step to 0 in such cases.

- **Fix ordering of DICOM pixel spacing**

    The `vtkDICOMImageReader` used to provide the vertical and horizontal pixel spacing in the wrong order. This issue was only discovered recently because DICOM pixels are nearly always square.

- **Fix issue with Fides not initializing HIP before using it**

    Addressed a crash in Fides caused by attempting HIP memory allocation before HIP initialization. This was fixed by updating VTK-m.
    ([Author notes](9.5/fides-init.md))

- **Fix vtkAMReXGridReader when reading larger than 2GB files in Windows**

    You can now open grid files larger than 2GB on Windows using the `vtkAMReXGridReader`. Previously, a bug prevented loading arrays stored beyond the 2GB offset.

- **Fix vtkAMReXParticlesReader when using MPI**

    The `vtkAMReXParticlesReader` now functions correctly in parallel MPI mode, fixing a bug that caused incorrect output when the number of grids was not evenly divisible by the number of MPI processes.

- **GLTF document loader default scene**

    The `vtkGLTFDocumentLoader` ensures that the internal cache of scenes is non-empty for consumer code that relies on checking the validity of the default scene.

- **Remove error for missing Fides timestep**

    The Fides reader no longer errors if a requested timestep is not found, especially when the Fides file has no specified timesteps. It now sets an appropriate time index (0) in such cases, improving compatibility with tools like ParaView.
    ([Author notes](9.5/fides-timestep-error.md))

- **vtkDIYGhostUtilities: Ensure arrays are enqueued and dequeued properly**

    Improvements to `vtkDIYUtilities` and `vtkDIYGhostUtilities` for stricter loading, correct saving of array types, ensuring dequeued arrays are valid, and fixing polyhedral meshes in `vtkConduitToDataObject`.
    ([Author notes](9.5/fix-ghost-cells-polyhedrons.md))

- **vtkAlembicExporter: Fixed export of textures**

    Previously, textures were unintentionally being saved to the current working directory of the executable. Now, they are saved alongside the exported Alembic file.

- **VRML export of cell data colors**

    Colors of polydata colored by cell data arrays are now designated as such in the exported VRML file.

### MPI

- **Fix: MPI Gather function hanging when data size was invalid**

    `vtkMPICommunicator::GatherVVoidArray` could hang due to a size check causing an early return for only the failing process. Now, `recvLengths` and `offsets` must be specified for all processes when calling `vtkCommunicator::GatherV` to prevent this.

### Python

- **Python VTK data model improvements**

    Further cleaned up field array handling in Python for homogeneous behavior between `vtkDataSet` and composite datasets. This includes better support for dictionary-like access to `point_data` and `cell_data`.
    ([Author notes](9.5/fix-py-data-model.md))

### Rendering

- **ANARI renderer warnings**

    The ANARI scenegraph implementation has been fixed so that missing backend feature warnings are only issued once per renderer per device, reducing output buffer spam. Various compiler warnings in ANARI integration classes have also been fixed.

- **Fix actor lighting flag for WASM and cell grid rendering**

    Fixed a bug that caused an actor to disappear when lighting was disabled on an actor in WASM with the WebGL2 backend.

- **Fix wide line rendering in GLES default polydata mapper**

    The `vtkOpenGLLowMemoryPolyDataMapper` rendered thick lines incorrectly. It appeared as an extruded cross. This issue is now fixed in the mapper.

- **Fix lighting calculations for PBR interpolation**

    ![](https://vtk.org/files/ExternalData/SHA512/01b2f3261b9dc1550b1dae1abcc32ab45c170964500115ee66efba9200ff46485d2bee6efe1e13c6972630661c29dfac5abc83de7ac88b21d566a3db215936d4)

    When both directional and positional lights were intermixed, the polydata mapper treated directional lights as positional, generating incorrect renderings. This is now fixed.
    ([Author notes](https://gitlab.kitware.com/vtk/vtk/-/tree/master/Documentation/release/9.5/pbr-lighting.md))

- **Fix low memory polydata mapper when an actor is added after another is removed from a renderer**

    Fixed a bug in `vtkOpenGLLowMemoryPolyDataMapper` where an actor, if added, removed, and then re-added, would not become visible the second time.

- **Fix OpenGL error in OSMesa backend**

    Fixed a `GL_INVALID_ENUM` error in `vtkOSOpenGLRenderWindow::ReportCapabilities` caused by using an unsupported method for querying `GL_EXTENSIONS`.

- **Fix vtkCompositePolyDataMapper opacity override**

    ![](imgs/9.5/fix-composite-mapper-opacity-override.png)

    You can now render opaque blocks in a composite dataset even when the actor has an `opacity < 1.0` by setting the opacity of the block to 1.0.
    ([Author notes](9.5/fix-composite-mapper-opacity-override.md))

- **Fix vertex visibility in OpenGL mappers**

    Vertices of a mesh are now correctly displayed when `actor->SetVertexVisibility(true)` is called, fixing a bug where they only showed if edge visibility was also on.

- **Fix wide lines with cell colors for Apple silicon**

    Thick lines with cell scalar colors now render correctly on Apple silicon. VTK patches the shader code at runtime for the Apple OpenGL over Metal driver to handle an upstream bug. Use `vtkOpenGLRenderWindow::IsPrimIDBugPresent()` to check for this driver bug.

- **Improve IBO construction performances in vtkOpenGLIndexBufferObject**

    For common cases of triangles-only polydata, IBO construction time has been reduced by about 25%. Performance is further improved if polydata cell arrays use 32-bit connectivity IDs.
    ([Author notes](9.5/index-buffer-creation-performances.md))

- **Rectilinear Grid Volume Rendering with Cell Data**

    Fixed an issue in the volume mapper for rectilinear grids with cell scalars where the bounds of the dataset were incorrectly mapped to the texture space.

    |Before|After|
    |:--:|:--:|
    |![](imgs/9.5/rectgrid_celldata_pre.png)|![](imgs/9.5/rectgrid_celldata_fixed.png)|

- **Fix X error about maximum clients reached**

    Fixes a bug in `vtkXOpenGLRenderWindow` that prevented users from instantiating more than about 300 render windows on Linux with X11.

* **Fix light transforms when computing shadow maps**

    The `vtkShadowMapBakerPass` computes shadow maps for each light by simulating a `vtkCamera` for each light and compositing the rendered images. However, an unintentional side-effect of this was that the original light's transforms were being affected by this. In other words, the lights would be corrupt after the shadow map computation. To circumvent this, we cache the light transforms prior to the shadow map computation and then reset them after.

    ![](http://vtk.org/files/ExternalData/SHA512/9412ed54080c7a972d786a269538a3dbd56a5aa070f2b35ba448dfd3cca211e7e4b4d196e07c8ff2d56ff4bb7b0855e5584758c09457d3d6f3c760ee47a4dded)

### WebAssembly

- **Patch state that refers to OSMesa OpenGL window into a WASM OpenGL window class.**

    The `vtkWasmSceneManager` now automatically patches the state provided to `RegisterState` and `UpdateObjectFromState` methods to replace 'ClassName' entry of `vtkOSOpenGLRenderWindow` with `vtkWebAssemblyOpenGLRenderWindow`.

## Deprecations/Removals

- All APIs that were deprecated in 9.3 are now removed.
- `vtkExtentSplitter::Min` and `::Max` have been deprecated in favor of `std::min` and `std::max`.
- `vtkXMLReader::Min` and `::Max` have been deprecated in favor of `std::min` and `std::max`.
- Classes like `vtkHierarchicalBoxDataSet`, `vtkHierarchicalBoxDataSetAlgorithm`, related geometry filters, and XML readers/writers are deprecated. Use `vtkOverlappingAMR` versions instead.
- `vtkTypedDataArray`, `vtkTypedDataArrayIterator`, `vtkMappedDataArray`, `vtkCPExodusIINodalCoordinatesTemplate`, and `vtkCPExodusIIResultsArrayTemplate` are deprecated. Use `vtkGenericDataArray` or `vtkAOSDataArrayTemplate`/`vtkSOADataArrayTemplate` alternatives.
- `vtkHyperTreeGridVisibleLeavesSize` is deprecated in favor of `vtkHyperTreeGridGenerateFields`.
- Several public members related to selection and decimation level in `vtkAdaptiveDataSetSurfaceFilter` (used by HTG Surface Representation) are now deprecated and have no effect (e.g., `Set/GetCircleSelection`, `Set/GetDynamicDecimateLevelMax`).
    ([Author notes](9.5/htg-representation-decimation.md))
- `vtkOpenXRManager::(Set|Get)UseDepthExtension` are deprecated and now no-op. Use the versions in `vtkOpenXRRenderWindow` instead.

- **VTKHDF Reader: Remove the MergeParts option**

    The `MergeParts` option of the vtkHDFReader allowed getting a unique Unstructured Grid or PolyData dataset after reading multiple parts. This option has been deprecated and has no effect anymore. Now, multi-piece datasets properly output a vtkPartitionedDataset containing non merged parts. Single-piece datasets still output simple vtkUnstructuredGrid or vtkPolyData. This **changes the default behavior of the reader**: Unstructured Grid and PolyData multi-piece datasets that used to be read with `MergeParts` (default) as a single piece are now read as a partitioned dataset. If `MergeParts` was disabled manually, only the single-piece case will be read differently: instead of forcing the output to be a partitioned dataset with a single piece, the output is now directly the non composite type, Unstructured Grid or PolyData.

    Users should replace the use of `MergeParts` by manually merging parts using the `vtkMergeBlocks` or `vtkAppendDatasets` manually instead.
