/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.init;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.boot.cli.command.init.InitializrService;
import org.springframework.boot.cli.command.init.ProjectGenerationRequest;
import org.springframework.boot.cli.command.init.ProjectGenerationResponse;
import org.springframework.boot.cli.command.init.ReportableException;
import org.springframework.boot.cli.util.Log;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StreamUtils;

class ProjectGenerator {
    private static final String ZIP_MIME_TYPE = "application/zip";
    private final InitializrService initializrService;

    ProjectGenerator(InitializrService initializrService) {
        this.initializrService = initializrService;
    }

    void generateProject(ProjectGenerationRequest request, boolean force) throws IOException {
        String fileName;
        ProjectGenerationResponse response = this.initializrService.generate(request);
        String string = fileName = request.getOutput() != null ? request.getOutput() : response.getFileName();
        if (this.shouldExtract(request, response)) {
            if (this.isZipArchive(response)) {
                this.extractProject(response, request.getOutput(), force);
                return;
            }
            Log.info((String)("Could not extract '" + String.valueOf(response.getContentType()) + "'"));
            fileName = response.getFileName();
        }
        if (fileName == null) {
            throw new ReportableException("Could not save the project, the server did not set a preferred file name and no location was set. Specify the output location for the project.");
        }
        this.writeProject(response, fileName, force);
    }

    private boolean shouldExtract(ProjectGenerationRequest request, ProjectGenerationResponse response) {
        if (request.isExtract()) {
            return true;
        }
        return this.isZipArchive(response) && request.getOutput() != null && !request.getOutput().contains(".");
    }

    private boolean isZipArchive(ProjectGenerationResponse entity) {
        if (entity.getContentType() != null) {
            try {
                return ZIP_MIME_TYPE.equals(entity.getContentType().getMimeType());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private void extractProject(ProjectGenerationResponse entity, String output, boolean overwrite) throws IOException {
        File outputDirectory;
        File file = outputDirectory = output != null ? new File(output) : new File(System.getProperty("user.dir"));
        if (!outputDirectory.exists()) {
            outputDirectory.mkdirs();
        }
        try (ZipInputStream zipStream = new ZipInputStream(new ByteArrayInputStream(entity.getContent()));){
            this.extractFromStream(zipStream, overwrite, outputDirectory);
            this.fixExecutableFlag(outputDirectory, "mvnw");
            this.fixExecutableFlag(outputDirectory, "gradlew");
            Log.info((String)("Project extracted to '" + outputDirectory.getAbsolutePath() + "'"));
        }
    }

    private void extractFromStream(ZipInputStream zipStream, boolean overwrite, File outputDirectory) throws IOException {
        ZipEntry entry = zipStream.getNextEntry();
        String canonicalOutputPath = outputDirectory.getCanonicalPath() + File.separator;
        while (entry != null) {
            File file = new File(outputDirectory, entry.getName());
            String canonicalEntryPath = file.getCanonicalPath();
            if (!canonicalEntryPath.startsWith(canonicalOutputPath)) {
                throw new ReportableException("Entry '" + entry.getName() + "' would be written to '" + canonicalEntryPath + "'. This is outside the output location of '" + canonicalOutputPath + "'. Verify your target server configuration.");
            }
            if (file.exists() && !overwrite) {
                throw new ReportableException((file.isDirectory() ? "Directory" : "File") + " '" + file.getName() + "' already exists. Use --force if you want to overwrite or specify an alternate location.");
            }
            if (!entry.isDirectory()) {
                FileCopyUtils.copy((InputStream)StreamUtils.nonClosing((InputStream)zipStream), (OutputStream)new FileOutputStream(file));
            } else {
                file.mkdir();
            }
            zipStream.closeEntry();
            entry = zipStream.getNextEntry();
        }
    }

    private void writeProject(ProjectGenerationResponse entity, String output, boolean overwrite) throws IOException {
        File outputFile = new File(output);
        if (outputFile.exists()) {
            if (!overwrite) {
                throw new ReportableException("File '" + outputFile.getName() + "' already exists. Use --force if you want to overwrite or specify an alternate location.");
            }
            if (!outputFile.delete()) {
                throw new ReportableException("Failed to delete existing file " + outputFile.getPath());
            }
        }
        FileCopyUtils.copy((byte[])entity.getContent(), (File)outputFile);
        Log.info((String)("Content saved to '" + output + "'"));
    }

    private void fixExecutableFlag(File dir, String fileName) {
        File f = new File(dir, fileName);
        if (f.exists()) {
            f.setExecutable(true, false);
        }
    }
}

