# SHBiasKMask()

Calculate the multitaper (cross-)power spectrum expectation of a function localized by arbitrary windows derived from a mask.

# Usage

outcspectra = SHBiasK (tapers, incspectra, [lwin, k, ldata, taper_wt, save_cg])

# Returns

outcspectra : float, dimension (ldata+lwin+1)
:   The expectation of the multitaper localized power spectrum.

# Parameters

tapers : float, dimension ((lwinin+1)**2, kin)
:   The spherical harmonic coefficients of the localization windows generated by a call to SHReturnTapersMap. The coefficients in each column are ordered according to the convention in SHCilmToVector.

incspectra : float, dimension (ldatain+1)
:   The global unwindowed power spectrum.

lwin : optional, integer, default = lwinin
:   The spherical harmonic bandwidth of the localizing windows.

k : optional, integer, default = kin
:   The number of localization windows to use. Only the first k columns of tapers will be employed, which corresponds to the best-concentrated windows.

ldata : optional, integer, default = ldatain
:   The maximum degree of the global unwindowed power spectrum.

taper_wt : optional, float, dimension (kin), default = -1
:   The weights to apply to each individual windowed specral estimate. The weights must sum to unity, and the default specifies that taper weights are not used.

save_cg : optional, integer, default = 0
:   If set equal to 1, the Clebsch-Gordon coefficients will be precomputed and saved for future use (if lwin or ldata change, these will be recomputed). To deallocate the saved memory, set this parameter equal to 1. If set equal to 0 (default), the Clebsch-Gordon coefficients will be recomputed for each call.

# Description

SHBiasKMask will calculate the multitaper (cross-)power spectrum expectation of a function multiplied by the k best-concentrated localization windows derived from an arbitrary mask. This is given by equation 36 of Wieczorek and Simons (2005) (see also eq. 2.11 of Wieczorek and Simons 2007). In contrast to SHBias, which takes as input the power spectrum of a single localizing window, this routine expects as input a matrix containing the spherical harmonic coefficients of the localizing windows. These can be generated by a call to SHReturnTapersMap and the coefficients in each column are ordered according to the convention in SHCilmToVector.

It is assumed implicitly that the power spectrum of inspectrum is zero beyond degree ldata. If this is not the case, the ouput power spectrum should be considered valid only for the degrees up to and including ldata - lwin.

The default is to apply equal weights to each individual windowed estimate of the spectrum, but this can be modified by specifying the weights in the optional argument taper_wt. The weights must sum to unity. If this routine is to be called several times using the same values of lwin and ldata, then the Clebsch-Gordon coefficients can be precomputed and saved by setting the optional parameter save_cg equal to 1.

# References

Wieczorek, M. A. and F. J. Simons, Minimum-variance multitaper spectral estimation on the sphere, J. Fourier Anal. Appl., 13, 665-692, doi:10.1007/s00041-006-6904-1, 2007.

Simons, F. J., F. A. Dahlen and M. A. Wieczorek, Spatiospectral concentration on a sphere, SIAM Review, 48, 504-536, doi:10.1137/S0036144504445765, 2006. 

Wieczorek, M. A. and F. J. Simons, Localized spectral analysis on the sphere, 
Geophys. J. Int., 162, 655-675, doi:10.1111/j.1365-246X.2005.02687.x, 2005.
