---
title: "Legendre functions"
keywords: spherical harmonics software package, spherical harmonic transform, legendre functions, multitaper spectral analysis, fortran, Python, gravity, magnetic field
sidebar: fortran_sidebar
permalink: legendre-functions.html
summary: 
toc: true
folder: fortran
---

<style>
table:nth-of-type(n) {
    display:table;
    width:100%;
}
table:nth-of-type(n) th:nth-of-type(2) {
    width:75%;
}
</style>

## $$4 \pi$$ normalized

| Routine name | Description |
| ----------- | ----------- |
| [PlmBar](plmbar.html) | Compute all the 4&pi;-normalized associated Legendre functions. |
| [PlmBar_d1](plmbar_d1.html) | Compute all the 4&pi;-normalized associated Legendre functions and first derivatives. |
| [PlBar](plbar.html) | Compute all the 4&pi;-normalized Legendre polynomials. |
| [PlBar_d1](plbar_d1.html) | Compute all the 4&pi;-normalized Legendre Polynomials and first derivatives. |

## Orthonormalized

| Routine name | Description |
| ----------- | ----------- |
| [PlmON](plmon.html) | Compute all the orthonormalized associated Legendre functions. |
| [PlmON_d1](plmon_d1.html) | Compute all the orthonormalized associated Legendre functions and first derivatives. |
| [PlON](plon.html) | Compute all the orthonormalized Legendre polynomials. |
| [PlON_d1](plon_d1.html) | Compute all the orthonormalized Legendre polynomials and first derivatives. |

## Schmidt semi-normalized

| Routine name | Description |
| ----------- | ----------- |
| [PlmSchmidt](plmschmidt.html) | Compute all the Schmidt-normalized associated Legendre functions. |
| [PlmSchmidt_d1](plmschmidt_d1.html) | Compute all the Schmidt-normalized associated Legendre functions and first derivatives. |
| [PlSchmidt](plschmidt.html) | Compute all the Schmidt-normalized Legendre polynomials. |
| [PlSchmidt_d1](plschmidt_d1.html) | Compute all the Schmidt-normalized Legendre polynomials and first derivatives. |

## Unnormalized

| Routine name | Description |
| ----------- | ----------- |
| [PLegendreA](plegendrea.html) | Compute all the unnormalized associated Legendre functions. |
| [PLegendreA_d1](plegendrea_d1.html) | Compute all the unnormalized associated Legendre functions and first derivatives. |
| [PLegendre](plegendre.html) | Compute all the unnormalized Legendre polynomials. |
| [PLegendre_d1](plegendre_d1.html) | Compute all the unnormalized Legendre polynomials and first derivatives. |

## Utilities

| Routine name | Description |
| ----------- | ----------- |
| [PlmIndex](plmindex.html) | Compute the index of an array of Legendre functions corresponding to degree l and angular order m. |

