#!/bin/bash

set -e

test -d dist || echo "No dist/ directory found."

SRC=dist/`ls dist/|grep \.tar\.gz|tail -n1`
VER=`echo "$SRC" | perl -n -e 'print "$1\n" if /-([0-9.]*)\.tar\.gz/;'`
BN=`basename "$SRC" .tar.gz`
PL=0

test -f "$SRC" || echo "No source package found."
echo "Using source package $SRC"

# spkg
# ----
rm -rf dist/pkg
mkdir -p dist/pkg
cp src/dist/{SPKG.txt,spkg-check,spkg-install} dist/pkg
(cd dist/pkg && tar xzf ../../$SRC)
(cd dist/pkg && mv "$BN" src)

PN="${BN}.p${PL}"
(cd dist && mv pkg "$PN")
(cd dist && sage -pkg "$PN")
rm -rf "dist/$PN"
echo "- $PN built."

