<TeXmacs|1.0.7.14>

<style|<tuple|article|maxima|axiom>>

<\body>
  <doc-data|<doc-title|Riccati parameterization of the Usadel
  equations>|<\doc-author-data|<author-name|Pauli Virtanen>>
    \;
  </doc-author-data|<\author-address>
    Low Temperature Laboratory, Teknillinen Korkeakoulu, P. O. BOX 2200,
    FIN-02015 TKK, Finland
  </author-address>>|<doc-date|<date>>>

  <section|Initial work>

  Initialize Maxima workspace:

  <\session|maxima|default>
    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>1) >
    <|unfolded-io>
      kill(all);

      domain: complex;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o0>)
      >><math-bf|done>>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>1) >
    <|input>
      t0: matrix([1,0],[0,1])$

      t1: matrix([0,1],[1,0])$

      t2: matrix([0,-i],[i,0])$

      t3: matrix([1,0],[0,-1])$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>6) >
    <|input>
      comm(a,b):=a.b-b.a$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>7) >
    <|input>
      load(linearalgebra)$

      load(format)$

      load(coeflist)$
    </input>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>10) >
    <|unfolded-io>
      matchdeclare([y,x], true)$

      tellsimp(conjugate('diff(y(x),x,1)), 'diff(conjugate(y(x)),x,1));

      tellsimp(conjugate('diff(y(x),x,2)), 'diff(conjugate(y(x)),x,2));

      kill(y,x)$
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o11>)
      >><around*|[|<with|math-font-family|rm|conjugaterule1>,<with|math-font-family|rm|simp-conjugate>|]>>>
    </unfolded-io>

    <\input|<with|color|red|(<with|math-font-family|rm|%i>14) >>
      \;
    </input>
  </session>

  First, we define some Green's functions:

  <\session|maxima|default>
    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>10) >
    <|unfolded-io>
      declare(Delta,real,phi,real,epsilon,real,Gamma,real,Gamma_sf,real);

      DM: Delta*matrix([0,exp(%i*phi)],[-exp(-%i*phi),0]);
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o14>)
      >><math-bf|done>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>10) >
    <|unfolded-io>
      declare(a,complex,b,complex);

      GR: 1/(1-a*b) * matrix([1+a*b, 2*a],[-2*b,-(1+a*b)]);
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o16>)
      >><math-bf|done>>>

      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o17>)
      >><matrix|<tformat|<table|<row|<cell|<frac|a*b+1|1-a*b>>|<cell|<frac|2*a|1-a*b>>>|<row|<cell|-<frac|2*b|1-a*b>>|<cell|<frac|-a*b-1|1-a*b>>>>>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>18) >
    <|unfolded-io>
      factor(GR.GR);
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o18>)
      >><matrix|<tformat|<table|<row|<cell|1>|<cell|0>>|<row|<cell|0>|<cell|1>>>>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>19) >
    <|unfolded-io>
      GA: -t3.conjugate(transpose(GR)).t3;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o19>)
      >><matrix|<tformat|<table|<row|<cell|-<frac|a<rsup|\<star\>>*b<rsup|\<star\>>+1|1-a<rsup|\<star\>>*b<rsup|\<star\>>>>|<cell|-<frac|2*b<rsup|\<star\>>|1-a<rsup|\<star\>>*b<rsup|\<star\>>>>>|<row|<cell|<frac|2*a<rsup|\<star\>>|1-a<rsup|\<star\>>*b<rsup|\<star\>>>>|<cell|-<frac|-a<rsup|\<star\>>*b<rsup|\<star\>>-1|1-a<rsup|\<star\>>*b<rsup|\<star\>>>>>>>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>20) >
    <|unfolded-io>
      declare(fL,real,fT,real);

      h: fL*t0 + fT*t3;

      GK: factor(GR.h - h.GA)$
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o20>)
      >><math-bf|done>>>

      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o21>)
      >><matrix|<tformat|<table|<row|<cell|<math-up|fT>+<math-up|fL>>|<cell|0>>|<row|<cell|0>|<cell|<math-up|fL>-<math-up|fT>>>>>>>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>20) >
    <|input>
      G: mat_fullunblocker(matrix([GR,GK],[0*t0,GA]))$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>46) >
    <|input>
      SigmaR: matrix([SR1, SR2], [SR3, SR4])$

      SigmaA: -t3.conjugate(transpose(SigmaR)).t3$

      SigmaK: matrix([SK1, SK2], [SK3, SK4])$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>49) >
    <|input>
      Sigma: mat_fullunblocker(matrix([SigmaR,SigmaK],[0*t0,SigmaA]))$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>51) >
    <|input>
      \;
    </input>
  </session>

  <section|Spectral equations>

  Derive now the Usadel equations in this parameterization:

  <\session|maxima|default>
    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>51) >
    <|unfolded-io>
      declare(x,real);

      funcrule: [a=a(x),b=b(x),fT=fT(x),fL=fL(x)];

      s0t3: kronecker_product(t0,t3);
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o51>)
      >><math-bf|done>>>

      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o52>)
      >><around*|[|a=a<around*|(|x|)>,b=b<around*|(|x|)>,<math-up|fT>=<math-up|fT><around*|(|x|)>,<math-up|fL>=<math-up|fL><around*|(|x|)>|]>>>

      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o53>)
      >><matrix|<tformat|<table|<row|<cell|1>|<cell|0>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|-1>|<cell|0>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|1>|<cell|0>>|<row|<cell|0>|<cell|0>|<cell|0>|<cell|-1>>>>>>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>54) >
    <|input>
      Gx: ev(G, funcrule)$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>55) >
    <|input>
      Jx: Gx.diff(Gx,x)$

      lhs: factor(diff(Jx,x))$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>57) >
    <|input>
      rhs1: factor(comm(-%i*epsilon*s0t3, Gx))$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>58) >
    <|input>
      rhs2: factor(comm(-%i*kronecker_product(t0,DM),Gx))$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>59) >
    <|input>
      rhs3: factor(comm((1/2)*Gamma_sf * s0t3.Gx.s0t3, Gx))$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>60) >
    <|input>
      rhs4: factor(comm(Sigma, Gx))$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>66) >
    <|input>
      spectralside: lhs-rhs1-rhs2-rhs3-rhs4$

      d2a: diff(a(x),x,2)$

      d2b: diff(b(x),x,2)$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>69) >
    <|input>
      solspectral: linsolve([spectralside[1,1]=0, spectralside[1,2]=0], [d2a,
      d2b])$
    </input>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>72) >
    <|unfolded-io>
      format(solspectral, %poly(epsilon, Delta, Gamma_sf, SR1, SR2, SR3,
      SR4), %factor);
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o72>)
      >><around*|[|<frac|d<rsup|2>|d*x<rsup|2>>*a<around*|(|x|)>=-a<around*|(|x|)>*<with|math-font-family|rm|SR4>+a<around*|(|x|)><rsup|2>*<with|math-font-family|rm|SR3>-<with|math-font-family|rm|SR2>+a<around*|(|x|)>*<with|math-font-family|rm|SR1>+<frac|2*b<around*|(|x|)>*<around*|(|<frac|d|d*x>*a<around*|(|x|)>|)><rsup|2>|a<around*|(|x|)>*b<around*|(|x|)>-1>-<frac|2*<with|math-font-family|rm|Gamma_sf>*a<around*|(|x|)>*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>+1|)>|a<around*|(|x|)>*b<around*|(|x|)>-1>+\<mathi\>*\<Delta\>*\<mathe\><rsup|-\<mathi\>*\<varphi\>>*<around*|(|a<around*|(|x|)><rsup|2>+\<mathe\><rsup|2*\<mathi\>*\<varphi\>>|)>-2*\<mathi\>*\<varepsilon\>*a<around*|(|x|)>,<frac|d<rsup|2>|d*x<rsup|2>>*b<around*|(|x|)>=-b<around*|(|x|)>*<with|math-font-family|rm|SR4>+<with|math-font-family|rm|SR3>-b<around*|(|x|)><rsup|2>*<with|math-font-family|rm|SR2>+b<around*|(|x|)>*<with|math-font-family|rm|SR1>+<frac|2*a<around*|(|x|)>*<around*|(|<frac|d|d*x>*b<around*|(|x|)>|)><rsup|2>|a<around*|(|x|)>*b<around*|(|x|)>-1>+\<mathi\>*\<Delta\>*\<mathe\><rsup|-\<mathi\>*\<varphi\>>*<around*|(|\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*b<around*|(|x|)><rsup|2>+1|)>-<frac|2*<with|math-font-family|rm|Gamma_sf>*b<around*|(|x|)>*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>+1|)>|a<around*|(|x|)>*b<around*|(|x|)>-1>-2*\<mathi\>*\<varepsilon\>*b<around*|(|x|)>|]>>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>73) >
    <|input>
      \;
    </input>
  </session>

  Ok, so there the spectral Riccati-parameterized Usadel equations are.

  <section|Kinetic equations>

  Then the kinetic equations:

  <\session|maxima|default>
    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>73) >
    <|input>
      kinJ1: (Jx[1,3] + Jx[2,4])/4$

      kinJ2: (Jx[1,3] - Jx[2,4])/4$

      d2fL: diff(fL(x),x,2)$

      d2fT: diff(fT(x),x,2)$

      d1fL: diff(fL(x),x)$

      d1fT: diff(fT(x),x)$
    </input>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>79) >
    <|unfolded-io>
      DL: ratcoef(kinJ1,d1fL), factor
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o79>)
      >><frac|<around*|(|a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>-1|)>*<around*|(|b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>-1|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>80) >
    <|unfolded-io>
      T1: ratcoef(kinJ1,d1fT), factor;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o80>)
      >>-<frac|b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>81) >
    <|unfolded-io>
      ratcoef(kinJ1,fL(x)), factor;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o81>)
      >>0>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>82) >
    <|input>
      jsT: ratcoef(kinJ1,fT(x)), factor$
    </input>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>83) >
    <|unfolded-io>
      T2: ratcoef(kinJ2,d1fL), factor;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o83>)
      >><frac|b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>84) >
    <|unfolded-io>
      DT: ratcoef(kinJ2,d1fT), factor;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o84>)
      >><frac|<around*|(|a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>+1|)>*<around*|(|b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>+1|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>85) >
    <|input>
      jsL: ratcoef(kinJ2,fL(x)), factor$
    </input>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>86) >
    <|unfolded-io>
      sinhtheta2: 4*a(x)*b(x)/(1-a(x)*b(x))**2;

      chi: 1/(2*%i)*log(a(x)/b(x));
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o86>)
      >><frac|4*a<around*|(|x|)>*b<around*|(|x|)>|<around*|(|1-a<around*|(|x|)>*b<around*|(|x|)>|)><rsup|2>>>>

      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o87>)
      >>-<frac|\<mathi\>*log <around*|(|<frac|a<around*|(|x|)>|b<around*|(|x|)>>|)>|2>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>88) >
    <|unfolded-io>
      jE: -sinhtheta2 * diff(chi, x), factor;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o88>)
      >>-<frac|2*\<mathi\>*<around*|(|a<around*|(|x|)>*<around*|(|<frac|d|d*x>*b<around*|(|x|)>|)>-b<around*|(|x|)>*<around*|(|<frac|d|d*x>*a<around*|(|x|)>|)>|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)><rsup|2>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>89) >
    <|unfolded-io>
      js: (1/(2*%i))*(jE - conjugate(jE))
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o89>)
      >>-<frac|\<mathi\>*<around*|(|-<frac|2*\<mathi\>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*<around*|(|<frac|d|d*x>*b<around*|(|x|)><rsup|\<star\>>|)>-b<around*|(|x|)><rsup|\<star\>>*<around*|(|<frac|d|d*x>*a<around*|(|x|)><rsup|\<star\>>|)>|)>|<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)><rsup|2>>-<frac|2*\<mathi\>*<around*|(|a<around*|(|x|)>*<around*|(|<frac|d|d*x>*b<around*|(|x|)>|)>-b<around*|(|x|)>*<around*|(|<frac|d|d*x>*a<around*|(|x|)>|)>|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)><rsup|2>>|)>|2>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>90) >
    <|unfolded-io>
      jsL - js, factor
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o90>)
      >>0>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>91) >
    <|unfolded-io>
      jsT - js, factor
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o91>)
      >>0>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>92) >
    <|unfolded-io>
      T1+T2
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o92>)
      >>0>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>93) >
    <|input>
      \;
    </input>
  </session>

  Then find the RHS coefficients:

  <\session|maxima|default>
    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>96) >
    <|input>
      totrhs: ev(rhs1 + rhs2 + rhs3 + rhs4,

      \ \ 

      )$

      kinrhs1: (totrhs[1,3] + totrhs[2,4])/4$

      kinrhs2: (totrhs[1,3] - totrhs[2,4])/4$
    </input>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>99) >
    <|unfolded-io>
      kinrhs1
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o99>)
      >><frac|<frac|2*<around*|(|b<around*|(|x|)>*<math-up|fT><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>-a<around*|(|x|)>*<math-up|fT><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>+b<around*|(|x|)>*<math-up|fL><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>+a<around*|(|x|)>*<math-up|fL><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>+a<around*|(|x|)>*b<around*|(|x|)>*<math-up|fT><around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>-<math-up|fT><around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>+a<around*|(|x|)>*b<around*|(|x|)>*<math-up|fL><around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>-<math-up|fL><around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>-a<around*|(|x|)>*b<around*|(|x|)>*<math-up|fT><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>+<math-up|fT><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>+a<around*|(|x|)>*b<around*|(|x|)>*<math-up|fL><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>-<math-up|fL><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>-b<around*|(|x|)>*<math-up|fT><around*|(|x|)>*<with|math-font-family|rm|SR2>+a<around*|(|x|)>*<math-up|fT><around*|(|x|)>*<with|math-font-family|rm|SR2>-b<around*|(|x|)>*<math-up|fL><around*|(|x|)>*<with|math-font-family|rm|SR2>-a<around*|(|x|)>*<math-up|fL><around*|(|x|)>*<with|math-font-family|rm|SR2>-2*a<around*|(|x|)>*b<around*|(|x|)>*<math-up|fT><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR1>-2*a<around*|(|x|)>*b<around*|(|x|)>*<math-up|fL><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR1>+2*<math-up|fT><around*|(|x|)>*<with|math-font-family|rm|SR1>+2*<math-up|fL><around*|(|x|)>*<with|math-font-family|rm|SR1>+a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SK3>-a<around*|(|x|)>*<with|math-font-family|rm|SK3>-a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SK2>+a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SK2>+a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SK1>-<with|math-font-family|rm|SK1>|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>-<frac|2*<around*|(|2*a<around*|(|x|)>*b<around*|(|x|)>*<math-up|fT><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR4>-2*a<around*|(|x|)>*b<around*|(|x|)>*<math-up|fL><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR4>-2*<math-up|fT><around*|(|x|)>*<with|math-font-family|rm|SR4>+2*<math-up|fL><around*|(|x|)>*<with|math-font-family|rm|SR4>+b<around*|(|x|)>*<math-up|fT><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>-a<around*|(|x|)>*<math-up|fT><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>+b<around*|(|x|)>*<math-up|fL><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>+a<around*|(|x|)>*<math-up|fL><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>+a<around*|(|x|)>*b<around*|(|x|)>*<math-up|fT><around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>-<math-up|fT><around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>+a<around*|(|x|)>*b<around*|(|x|)>*<math-up|fL><around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>-<math-up|fL><around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>-a<around*|(|x|)>*b<around*|(|x|)>*<math-up|fT><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>+<math-up|fT><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>+a<around*|(|x|)>*b<around*|(|x|)>*<math-up|fL><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>-<math-up|fL><around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>-b<around*|(|x|)>*<math-up|fT><around*|(|x|)>*<with|math-font-family|rm|SR3>+a<around*|(|x|)>*<math-up|fT><around*|(|x|)>*<with|math-font-family|rm|SR3>-b<around*|(|x|)>*<math-up|fL><around*|(|x|)>*<with|math-font-family|rm|SR3>-a<around*|(|x|)>*<math-up|fL><around*|(|x|)>*<with|math-font-family|rm|SR3>+a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SK4>-<with|math-font-family|rm|SK4>-a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SK3>+b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SK3>+b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SK2>-b<around*|(|x|)>*<with|math-font-family|rm|SK2>|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>|4>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>112) >
    <|unfolded-io>
      ev
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o112>)
      >>5>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>111) >
    <|unfolded-io>
      format(kinrhs2, %poly(fL(x),fT(x),SR1,SR2,SR3,SR4,SK1,SK2,SK3,SK4),
      %factor);
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o111>)
      >><frac|<math-up|fT><around*|(|x|)>*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>*<with|math-font-family|rm|SR4>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>-<frac|<math-up|fL><around*|(|x|)>*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>*<with|math-font-family|rm|SR4>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>+<frac|<math-up|fL><around*|(|x|)>*<around*|(|b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>-b<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)><rsup|\<star\>>-b<around*|(|x|)>-a<around*|(|x|)>|)>*<with|math-font-family|rm|SR3>|2*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>+<frac|<math-up|fT><around*|(|x|)>*<around*|(|b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>-b<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)><rsup|\<star\>>-b<around*|(|x|)>+a<around*|(|x|)>|)>*<with|math-font-family|rm|SR3>|2*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>+<frac|<math-up|fL><around*|(|x|)>*<around*|(|b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>-b<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)><rsup|\<star\>>-b<around*|(|x|)>-a<around*|(|x|)>|)>*<with|math-font-family|rm|SR2>|2*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>+<frac|<math-up|fT><around*|(|x|)>*<around*|(|b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>-b<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)><rsup|\<star\>>-b<around*|(|x|)>+a<around*|(|x|)>|)>*<with|math-font-family|rm|SR2>|2*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>-<frac|<math-up|fT><around*|(|x|)>*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>*<with|math-font-family|rm|SR1>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>-<frac|<math-up|fL><around*|(|x|)>*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>*<with|math-font-family|rm|SR1>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>+<frac|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>*<with|math-font-family|rm|SK4>|2*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>+<frac|<around*|(|a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>+b<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>|)>*<with|math-font-family|rm|SK3>|2*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>+<frac|<around*|(|b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)><rsup|\<star\>>-b<around*|(|x|)>|)>*<with|math-font-family|rm|SK2>|2*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>+<frac|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>*<with|math-font-family|rm|SK1>|2*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>-<frac|\<mathi\>*\<Delta\>*\<mathe\><rsup|-\<mathi\>*\<varphi\>>*<math-up|fT><around*|(|x|)>*<around*|(|\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>+b<around*|(|x|)><rsup|\<star\>>-\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>+\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*a<around*|(|x|)><rsup|\<star\>>-\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*b<around*|(|x|)>-a<around*|(|x|)>|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>-<frac|\<mathi\>*\<Delta\>*\<mathe\><rsup|-\<mathi\>*\<varphi\>>*<math-up|fL><around*|(|x|)>*<around*|(|\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>+b<around*|(|x|)><rsup|\<star\>>+\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>-\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*a<around*|(|x|)><rsup|\<star\>>-\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*b<around*|(|x|)>+a<around*|(|x|)>|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>101) >
    <|unfolded-io>
      R: ratcoef(kinrhs2, fT(x)), factor;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o101>)
      >><frac|\<mathe\><rsup|-\<mathi\>*\<varphi\>>*<around*|(|2*\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR4>-2*\<mathe\><rsup|\<mathi\>*\<varphi\>>*<with|math-font-family|rm|SR4>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*b<around*|(|x|)>*<with|math-font-family|rm|SR3>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*<with|math-font-family|rm|SR3>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*b<around*|(|x|)>*<with|math-font-family|rm|SR2>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*<with|math-font-family|rm|SR2>-2*\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR1>+2*\<mathe\><rsup|\<mathi\>*\<varphi\>>*<with|math-font-family|rm|SR1>-2*\<mathi\>*\<Delta\>*\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-2*\<mathi\>*\<Delta\>*a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>+2*\<mathi\>*\<Delta\>*a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>-2*\<mathi\>*\<Delta\>*b<around*|(|x|)><rsup|\<star\>>+2*\<mathi\>*\<Delta\>*\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>-2*\<mathi\>*\<Delta\>*\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*a<around*|(|x|)><rsup|\<star\>>+2*\<mathi\>*\<Delta\>*\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*b<around*|(|x|)>+2*\<mathi\>*\<Delta\>*a<around*|(|x|)>|)>|2*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>102) >
    <|unfolded-io>
      L: ratcoef(kinrhs2, fL(x)), factor;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o102>)
      >>-<frac|\<mathe\><rsup|-\<mathi\>*\<varphi\>>*<around*|(|2*\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR4>-2*\<mathe\><rsup|\<mathi\>*\<varphi\>>*<with|math-font-family|rm|SR4>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR3>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*b<around*|(|x|)>*<with|math-font-family|rm|SR3>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*<with|math-font-family|rm|SR3>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>-\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR2>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*b<around*|(|x|)>*<with|math-font-family|rm|SR2>+\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*<with|math-font-family|rm|SR2>+2*\<mathe\><rsup|\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>*<with|math-font-family|rm|SR1>-2*\<mathe\><rsup|\<mathi\>*\<varphi\>>*<with|math-font-family|rm|SR1>+2*\<mathi\>*\<Delta\>*\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-2*\<mathi\>*\<Delta\>*a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-2*\<mathi\>*\<Delta\>*a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>+2*\<mathi\>*\<Delta\>*b<around*|(|x|)><rsup|\<star\>>+2*\<mathi\>*\<Delta\>*\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>-2*\<mathi\>*\<Delta\>*\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*a<around*|(|x|)><rsup|\<star\>>-2*\<mathi\>*\<Delta\>*\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*b<around*|(|x|)>+2*\<mathi\>*\<Delta\>*a<around*|(|x|)>|)>|2*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>103) >
    <|unfolded-io>
      csolspectral: conjugate(solspectral)$

      tmp: L - diff(js,x)$

      ev(tmp, append(solspectral, csolspectral)), ratsimp
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o105>)
      >>-<frac|<around*|(|2*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-2|)>*<with|math-font-family|rm|SR4>+<around*|(|<around*|(|<around*|(|a<around*|(|x|)>-b<around*|(|x|)>|)>*a<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*b<around*|(|x|)>+1|)>*b<around*|(|x|)><rsup|\<star\>>+<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*a<around*|(|x|)><rsup|\<star\>>+b<around*|(|x|)>-a<around*|(|x|)>|)>*<with|math-font-family|rm|SR3>+<around*|(|<around*|(|<around*|(|b<around*|(|x|)>-a<around*|(|x|)>|)>*a<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)>*b<around*|(|x|)>-1|)>*b<around*|(|x|)><rsup|\<star\>>+<around*|(|1-a<around*|(|x|)>*b<around*|(|x|)>|)>*a<around*|(|x|)><rsup|\<star\>>-b<around*|(|x|)>+a<around*|(|x|)>|)>*<with|math-font-family|rm|SR2>+<around*|(|2*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-2|)>*<with|math-font-family|rm|SR1>|<around*|(|2*a<around*|(|x|)>*b<around*|(|x|)>-2|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-2*a<around*|(|x|)>*b<around*|(|x|)>+2>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>106) >
    <|unfolded-io>
      RR: -%i*Delta*(-exp(-%i*phi)*a(x)*b(x)*conjugate(b(x))
      -exp(%i*phi)*b(x)*a(x)*conjugate(a(x)) -exp(%i*phi)*b(x) -
      exp(-%i*phi)*a(x))/(a(x)*b(x)-1)/conjugate(a(x)*b(x)-1)

      , factor
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o106>)
      >><frac|\<mathi\>*\<Delta\>*\<mathe\><rsup|-\<mathi\>*\<varphi\>>*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>+\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>+\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*b<around*|(|x|)>+a<around*|(|x|)>|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>107) >
    <|unfolded-io>
      LL: -%i*Delta*(-exp(-%i*phi)*a(x)*b(x)*conjugate(b(x)) +
      exp(%i*phi)*b(x)*a(x)*conjugate(a(x)) - exp(%i*phi)*b(x) +
      exp(-%i*phi)*a(x))/(a(x)*b(x)-1)/conjugate(a(x)*b(x)-1)

      , factor
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o107>)
      >><frac|\<mathi\>*\<Delta\>*\<mathe\><rsup|-\<mathi\>*\<varphi\>>*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>-\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>+\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*b<around*|(|x|)>-a<around*|(|x|)>|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>108) >
    <|unfolded-io>
      R - (RR + conjugate(RR)), factor, ratsimp
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o108>)
      >><frac|<around*|(|2*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-2|)>*<with|math-font-family|rm|SR4>+<around*|(|<around*|(|<around*|(|b<around*|(|x|)>-a<around*|(|x|)>|)>*a<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)>*b<around*|(|x|)>-1|)>*b<around*|(|x|)><rsup|\<star\>>+<around*|(|1-a<around*|(|x|)>*b<around*|(|x|)>|)>*a<around*|(|x|)><rsup|\<star\>>-b<around*|(|x|)>+a<around*|(|x|)>|)>*<with|math-font-family|rm|SR3>+<around*|(|<around*|(|<around*|(|b<around*|(|x|)>-a<around*|(|x|)>|)>*a<around*|(|x|)><rsup|\<star\>>+a<around*|(|x|)>*b<around*|(|x|)>-1|)>*b<around*|(|x|)><rsup|\<star\>>+<around*|(|1-a<around*|(|x|)>*b<around*|(|x|)>|)>*a<around*|(|x|)><rsup|\<star\>>-b<around*|(|x|)>+a<around*|(|x|)>|)>*<with|math-font-family|rm|SR2>+<around*|(|2-2*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>|)>*<with|math-font-family|rm|SR1>|<around*|(|2*a<around*|(|x|)>*b<around*|(|x|)>-2|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-2*a<around*|(|x|)>*b<around*|(|x|)>+2>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>109) >
    <|unfolded-io>
      L - (LL + conjugate(LL)), factor, ratsimp
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o109>)
      >>-<frac|<around*|(|2*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-2|)>*<with|math-font-family|rm|SR4>+<around*|(|<around*|(|<around*|(|-b<around*|(|x|)>-a<around*|(|x|)>|)>*a<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*b<around*|(|x|)>+1|)>*b<around*|(|x|)><rsup|\<star\>>+<around*|(|1-a<around*|(|x|)>*b<around*|(|x|)>|)>*a<around*|(|x|)><rsup|\<star\>>+b<around*|(|x|)>+a<around*|(|x|)>|)>*<with|math-font-family|rm|SR3>+<around*|(|<around*|(|<around*|(|-b<around*|(|x|)>-a<around*|(|x|)>|)>*a<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*b<around*|(|x|)>+1|)>*b<around*|(|x|)><rsup|\<star\>>+<around*|(|1-a<around*|(|x|)>*b<around*|(|x|)>|)>*a<around*|(|x|)><rsup|\<star\>>+b<around*|(|x|)>+a<around*|(|x|)>|)>*<with|math-font-family|rm|SR2>+<around*|(|2*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-2|)>*<with|math-font-family|rm|SR1>|<around*|(|2*a<around*|(|x|)>*b<around*|(|x|)>-2|)>*a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-2*a<around*|(|x|)>*b<around*|(|x|)>+2>>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>110) >
    <|input>
      \;
    </input>
  </session>

  <subsection|Final result>

  Note that <math|j<rsub|S>=j<rsub|SL>=j<rsub|ST>> above. Hence,we obtain the
  kinetic equations

  <\eqnarray*>
    <tformat|<table|<row|<cell|D\<nabla\>\<cdot\>j<rsub|T>>|<cell|=>|<cell|<with|math-font|cal|R>f<rsub|T>+D<around|(|\<nabla\>\<cdot\>j<rsub|S>|)>f<rsub|L>>>|<row|<cell|D\<nabla\>\<cdot\>j<rsub|L>>|<cell|=>|<cell|0>>|<row|<cell|j<rsub|T>>|<cell|=>|<cell|<with|math-font|cal|D><rsub|T>\<nabla\>f<rsub|T>+<with|math-font|cal|T>\<nabla\>f<rsub|L>+j<rsub|S>f<rsub|L>>>|<row|<cell|j<rsub|L>>|<cell|=>|<cell|<with|math-font|cal|D><rsub|L>\<nabla\>f<rsub|L>-<with|math-font|cal|T>\<nabla\>f<rsub|T>+j<rsub|S>f<rsub|T>>>>>
  </eqnarray*>

  with the coefficients

  <\session|maxima|default>
    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>72) >
    <|unfolded-io>
      DL
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o72>)
      >><frac|<around*|(|a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>-1|)>*<around*|(|b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>-1|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>73) >
    <|unfolded-io>
      DT
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o73>)
      >><frac|<around*|(|a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>+1|)>*<around*|(|b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>+1|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>74) >
    <|unfolded-io>
      T: T2
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o74>)
      >><frac|b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>-a<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>75) >
    <|unfolded-io>
      'js = 'imagpart(jE)
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o75>)
      >><math-up|js>=<math-up|imagpart><around*|(|-<frac|2*\<mathi\>*<around*|(|a<around*|(|x|)>*<around*|(|<frac|d|d*x>*b<around*|(|x|)>|)>-b<around*|(|x|)>*<around*|(|<frac|d|d*x>*a<around*|(|x|)>|)>|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)><rsup|2>>|)>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>76) >
    <|unfolded-io>
      'R = 2*'realpart(RR)
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o76>)
      >>R=2*<math-up|realpart><around*|(|<frac|\<mathi\>*\<Delta\>*\<mathe\><rsup|-\<mathi\>*\<varphi\>>*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>+\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>+\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*b<around*|(|x|)>+a<around*|(|x|)>|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>|)>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>77) >
    <|unfolded-io>
      'diff('js,x)=2*'realpart(LL)
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o77>)
      >><frac|d|d*x>*<math-up|js>=2*<math-up|realpart><around*|(|<frac|\<mathi\>*\<Delta\>*\<mathe\><rsup|-\<mathi\>*\<varphi\>>*<around*|(|a<around*|(|x|)>*b<around*|(|x|)>*b<around*|(|x|)><rsup|\<star\>>-\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*a<around*|(|x|)>*b<around*|(|x|)>*a<around*|(|x|)><rsup|\<star\>>+\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*b<around*|(|x|)>-a<around*|(|x|)>|)>|<around*|(|a<around*|(|x|)>*b<around*|(|x|)>-1|)>*<around*|(|a<around*|(|x|)><rsup|\<star\>>*b<around*|(|x|)><rsup|\<star\>>-1|)>>|)>>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>78) >
    <|input>
      \;
    </input>
  </session>

  which have the derivatives

  <\session|maxima|default>
    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>78) >
    <|unfolded-io>
      jEx: diff(jE,x)$

      ev(jEx, solspectral), factor
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o79>)
      >><frac|2*\<Delta\>*\<mathe\><rsup|-\<mathi\>*\<varphi\>>*<around*|(|\<mathe\><rsup|2*\<mathi\>*\<varphi\>>*b<around*|(|x|)>-a<around*|(|x|)>|)>|a<around*|(|x|)>*b<around*|(|x|)>-1>>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>80) >
    <|input>
      \;
    </input>
  </session>

  <section|Boundary conditions>

  In general, we have

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<sigma\>A
    <wide|G|\<check\>>\<partial\><rsub|x><wide|G|\<check\>>>|<cell|=>|<cell|<frac|2|\<pi\>><big|sum><rsub|n><frac|T<rsub|n><around|[|<wide|G<rsub|>|\<check\>><rsub|1>,<wide|G|\<check\>><rsub|2>|]>|4+T<rsub|n><around|(|<around|{|<wide|G|\<check\>><rsub|1>,<wide|G|\<check\>><rsub|2>|}>-2|)>>=<frac|1|R<rsub|I>>f<around|(|<around|{|<wide|G|\<check\>><rsub|1>,<wide|G|\<check\>><rsub|2>|}>|)><around|[|<wide|G<rsub|>|\<check\>><rsub|1>,<wide|G|\<check\>><rsub|2>|]>,>>|<row|<cell|f<around|(|z|)>>|<cell|=>|<cell|<frac|<big|sum><rsub|n>T<rsub|n><around|[|4+T<rsub|n><around|(|z-2|)>|]><rsup|-1>|<big|sum><rsub|n>T<rsub|n>>>>>>
  </eqnarray*>

  where the current density on the lhs is assumed to <strong|enter> the
  junction. It is important to note that rather than inserting
  parameterization and then summing over the transmission eigenvalues, it may
  be easier to first find the function <math|f<around|(|z|)>> and use its
  analytic form to find the corresponding matrix expression. Or, actually
  it's even more easy to calculate the boundary conditions for a single
  channel and only after then average them over the distribution.

  <subsection|Clean boundary>

  Consider clean boundary conditions: there the (retarded) Green's function
  is simply continuous

  <\session|maxima|default>
    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>80) >
    <|unfolded-io>
      declare(epsilon,real,Delta,real)$

      assume([Delta\<gtr\>0, epsilon\<gtr\>0])$

      bcs: solve([GR[1,1] = cosh(theta), GR[1,2] =
      sinh(theta)*exp(%i*phi)],[a,b])[1]
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o82>)
      >><around*|[|a=<frac|\<mathe\><rsup|\<mathi\>*\<varphi\>>*sinh
      <around*|(|\<vartheta\>|)>|cosh <around*|(|\<vartheta\>|)>+1>,b=<frac|\<mathe\><rsup|-\<mathi\>*\<varphi\>>*<around*|(|cosh
      <around*|(|\<vartheta\>|)>-1|)>|sinh <around*|(|\<vartheta\>|)>>|]>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>83) >
    <|unfolded-io>
      bcs1: ev(bcs, sinh(theta) = z/sqrt(1-z**2), cosh(theta) =
      1/sqrt(1-z**2)), factor;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o83>)
      >><around*|[|a=<frac|\<mathe\><rsup|\<mathi\>*\<varphi\>>*z|<sqrt|1-z<rsup|2>>+1>,b=-<frac|\<mathe\><rsup|-\<mathi\>*\<varphi\>>*<around*|(|<sqrt|1-z<rsup|2>>-1|)>|z>|]>>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>84) >
    <|input>
      \;
    </input>
  </session>

  where <math|z=<frac|\<Delta\>|\<epsilon\>+i\<Gamma\>>>. Actually,
  <math|a=e<rsup|2i\<phi\>>b>...

  <subsection|Dirty interface>

  The dirty interface boundary condition is somewhat more tricky: we have the
  transmission eigenvalue density

  <\equation*>
    \<rho\><around|(|t|)>=<frac|g|\<pi\>><space|0.2spc>
    <frac|1|t<rsup|3/2><sqrt|1-t>>
  </equation*>

  This results to

  <\session|maxima|default>
    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>84) >
    <|input>
      forget(facts(z))$

      assume(z\<gtr\>2, z\<less\>4)$

      dirtyintegral1:\ 

      \ \ \ integrate(1/%pi*1/(t**(3/2)*sqrt(1-t)) * 2*t/(4 + t*(z-2)), t, 0,
      1), factor;
    </input>

    <\unfolded-io>
      <math|<with|math-display|true|<text|Is
      ><around*|(|<frac|8|z<rsup|2>-4*z+4>+<frac|1|z-2>|)><rsup|2>+<frac|4*<around*|(|-<frac|16|z<rsup|2>-4*z+4>-<frac|4|z-2>|)>|z<rsup|2>-4*z+4><text|
      positive, negative, or zero?>>>

      \;
    <|unfolded-io>
      positive;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o86>)
      >><frac|2*<sqrt|z<rsup|2>-4*z+4>*arcsin
      <around*|(|<frac|<sqrt|z<rsup|2>-4*z+4>|z-2>|)>|\<pi\>*<around*|(|z-2|)>*<sqrt|z+2>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>87) >
    <|unfolded-io>
      dirtyintegral2: ev(dirtyintegral1, z**2-4*z+4=(z-2)**2);
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o87>)
      >><frac|1|<sqrt|z+2>>>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>88) >
    <|input>
      \;
    </input>
  </session>

  \ Hence, the dirty interface boundary condition is fairly simple:

  <\equation*>
    \<sigma\>A<wide|G|\<check\>><rsub|1>\<partial\><wide|G|\<check\>><rsub|1>=<frac|1|R<rsub|I>><around|(|<around|{|<wide|G|\<check\>><rsub|1>,<wide|G|\<check\>><rsub|2>|}>+2|)><rsup|-1/2><around|[|<wide|G|\<check\>><rsub|1>,<wide|G|\<check\>><rsub|2>|]>
  </equation*>

  The results for the Riccati parameters (as far as the spectral part is
  concerned) are also not too complicated:

  <\session|maxima|default>
    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>88) >
    <|input>
      dGR1: diff(ev(GR, funcrule), x)$
    </input>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>89) >
    <|unfolded-io>
      dGR2: ev(dGR1, diff(b(x),x)=db, diff(a(x),x)=da)$

      dGR3: ev(dGR2, b(x)=b, a(x)=a);
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o90>)
      >><matrix|<tformat|<table|<row|<cell|<frac|a*<math-up|db>+b*<math-up|da>|1-a*b>-<frac|<around*|(|a*b+1|)>*<around*|(|-a*<math-up|db>-b*<math-up|da>|)>|<around*|(|1-a*b|)><rsup|2>>>|<cell|<frac|2*<math-up|da>|1-a*b>-<frac|2*a*<around*|(|-a*<math-up|db>-b*<math-up|da>|)>|<around*|(|1-a*b|)><rsup|2>>>>|<row|<cell|<frac|2*b*<around*|(|-a*<math-up|db>-b*<math-up|da>|)>|<around*|(|1-a*b|)><rsup|2>>-<frac|2*<math-up|db>|1-a*b>>|<cell|<frac|-a*<math-up|db>-b*<math-up|da>|1-a*b>-<frac|<around*|(|-a*b-1|)>*<around*|(|-a*<math-up|db>-b*<math-up|da>|)>|<around*|(|1-a*b|)><rsup|2>>>>>>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>91) >
    <|unfolded-io>
      declare(a2,complex,b2,complex);

      GR2: ev(GR, a=a2, b=b2);
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o91>)
      >><math-bf|done>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>91) >
    <|unfolded-io>
      /* Very crude 2x2 matrix sqrt functions */

      matrixsqrt22(A):=block([ex: eigenvectors(A)],
      transpose(invert(matrix(ex[2], ex[3])).sqrt(matrix([ex[1][1][1],0],[0,ex[1][1][2]])).matrix(ex[2],
      ex[3]))), factor$

      matrixsqrt22x(A):=block([ex: eigenvectors(A)],
      transpose(invert(matrix(ex[2][1][1],
      ex[2][1][2])).sqrt(matrix([ex[1][1][1],0],[0,ex[1][1][1]])).matrix(ex[2][1][1],
      ex[2][1][2]))), factor$
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o92>)
      >><matrix|<tformat|<table|<row|<cell|<frac|<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>+1|1-<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>>>|<cell|<frac|2*<with|math-font-family|rm|a*2>|1-<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>>>>|<row|<cell|-<frac|2*<with|math-font-family|rm|b*2>|1-<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>>>|<cell|<frac|-<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>-1|1-<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>>>>>>>>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>93) >
    <|input>
      /* Note: the matrix under sqrt has a doubly degenerate eigenvalue! Use
      the second matrix SQRT function */

      eigenvalues(2*t0 + GR.GR2 + GR2.GR);

      dirtyrhs1: invert(matrixsqrt22x(2*t0 + GR.GR2 + GR2.GR)) .
      comm(GR,GR2), factor;
    </input>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>95) >
    <|unfolded-io>
      dirtylhs1: GR.dGR3, factor
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o95>)
      >><around*|[|<around*|[|<frac|a*<around*|(|4*<with|math-font-family|rm|a*2>*b*<with|math-font-family|rm|b*2>-4*<with|math-font-family|rm|b*2>|)>-4*<with|math-font-family|rm|a*2>*b+4|a*<around*|(|<with|math-font-family|rm|a*2>*b*<with|math-font-family|rm|b*2>-b|)>-<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>+1>|]>,<around*|[|2|]>|]>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>95) >
    <|unfolded-io>
      dirtysol: solve([dirtylhs1[1,1]=dirtyrhs1[1,1],
      dirtylhs1[1,2]=dirtyrhs1[1,2]], [da,db]), factor;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o96>)
      >><matrix|<tformat|<table|<row|<cell|-<frac|2*<around*|(|a*<with|math-font-family|rm|b*2>-<with|math-font-family|rm|a*2>*b|)>*<sqrt|<frac|<around*|(|<with|math-font-family|rm|a*2>*b-1|)>*<around*|(|a*<with|math-font-family|rm|b*2>-1|)>|<around*|(|a*b-1|)>*<around*|(|<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>-1|)>>>|<around*|(|<with|math-font-family|rm|a*2>*b-1|)>*<around*|(|a*<with|math-font-family|rm|b*2>-1|)>>>|<cell|-<frac|2*<around*|(|a*<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>-a*<with|math-font-family|rm|a*2>*b-<with|math-font-family|rm|a*2>+a|)>*<sqrt|<frac|<around*|(|<with|math-font-family|rm|a*2>*b-1|)>*<around*|(|a*<with|math-font-family|rm|b*2>-1|)>|<around*|(|a*b-1|)>*<around*|(|<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>-1|)>>>|<around*|(|<with|math-font-family|rm|a*2>*b-1|)>*<around*|(|a*<with|math-font-family|rm|b*2>-1|)>>>>|<row|<cell|-<frac|2*<around*|(|<with|math-font-family|rm|a*2>*b*<with|math-font-family|rm|b*2>-a*b*<with|math-font-family|rm|b*2>-<with|math-font-family|rm|b*2>+b|)>*<sqrt|<frac|<around*|(|<with|math-font-family|rm|a*2>*b-1|)>*<around*|(|a*<with|math-font-family|rm|b*2>-1|)>|<around*|(|a*b-1|)>*<around*|(|<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>-1|)>>>|<around*|(|<with|math-font-family|rm|a*2>*b-1|)>*<around*|(|a*<with|math-font-family|rm|b*2>-1|)>>>|<cell|<frac|2*<around*|(|a*<with|math-font-family|rm|b*2>-<with|math-font-family|rm|a*2>*b|)>*<sqrt|<frac|<around*|(|<with|math-font-family|rm|a*2>*b-1|)>*<around*|(|a*<with|math-font-family|rm|b*2>-1|)>|<around*|(|a*b-1|)>*<around*|(|<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>-1|)>>>|<around*|(|<with|math-font-family|rm|a*2>*b-1|)>*<around*|(|a*<with|math-font-family|rm|b*2>-1|)>>>>>>>>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>97) >
    <|input>
      \;
    </input>
  </session>

  Simplifying the result a bit more, we get\ 

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<sigma\><rsub|1>A<rsub|1>\<partial\><rsub|x>a<rsub|1>>|<cell|=>|<cell|<frac|1|R<rsub|I>><around|(|a<rsub|2>-a<rsub|1>|)><sqrt|<frac|<around|(|a<rsub|1>b<rsub|1>-1|)><around|(|a<rsub|1>b<rsub|2>-1|)>|<around|(|a<rsub|2>b<rsub|2>-1|)><around|(|a<rsub|2>b<rsub|1>-1|)>>>
    =<frac|1|R<rsub|I>><around|(|a<rsub|2>-a<rsub|1>|)><frac|a<rsub|1>b<rsub|2>-1|a<rsub|2>b<rsub|2>-1>
    \<alpha\>,>>|<row|<cell|\<sigma\><rsub|1>A<rsub|1>\<partial\><rsub|x>b<rsub|1>>|<cell|=>|<cell|<frac|1|R<rsub|I>><around|(|b<rsub|2>-b<rsub|1>|)><sqrt|<frac|<around|(|a<rsub|1>b<rsub|1>-1|)><around|(|a<rsub|2>b<rsub|1>-1|)>|<around|(|a<rsub|2>b<rsub|2>-1|)><around|(|a<rsub|1>b<rsub|2>-1|)>>>
    \ =<frac|1|R<rsub|I>><around|(|b<rsub|2>-b<rsub|1>|)><frac|a<rsub|2>b<rsub|1>-1|a<rsub|2>b<rsub|2>-1>
    \<alpha\>,>>|<row|<cell|\<alpha\><rsub|>>|<cell|=>|<cell|<sqrt|<frac|<around|(|a<rsub|1>b<rsub|1>-1|)><around|(|a<rsub|2>b<rsub|2>-1|)>|<around|(|a<rsub|1>b<rsub|2>-1|)><around|(|a<rsub|2>b<rsub|1>-1|)>>>,>>>>
  </eqnarray*>

  and similarly for <math|a<rsub|2>> and <math|b<rsub|2>> by interchanging
  the indices. Note that <math|\<alpha\>> is unaffected by the change
  <math|1\<leftrightarrow\>2>. Reason for writing the conditions using
  <math|\<alpha\>> is revealed when comparing to the tunnel interface:

  <subsection|Tunnel interface>

  We get the Kupriyanov-Lukichev style boundary condition,\ 

  <\equation*>
    A <wide|G|\<check\>>\<partial\><rsub|x><wide|G|\<check\>>\<approx\><frac|1|2R<rsub|I>><around|[|<wide|G|\<check\>><rsub|1>,<wide|G|\<check\>><rsub|2>|]>
  </equation*>

  which, within the parameterization, becomes

  <\session|maxima|default>
    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>97) >
    <|unfolded-io>
      tunnellhs1: GR.dGR3, factor$

      tunnelrhs1: comm(GR,GR2)/2, factor;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o100>)
      >><matrix|<tformat|<table|<row|<cell|-<frac|2*<around*|(|a*<with|math-font-family|rm|b*2>-<with|math-font-family|rm|a*2>*b|)>|<around*|(|a*b-1|)>*<around*|(|<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>-1|)>>>|<cell|-<frac|2*<around*|(|a*<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>-a*<with|math-font-family|rm|a*2>*b-<with|math-font-family|rm|a*2>+a|)>|<around*|(|a*b-1|)>*<around*|(|<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>-1|)>>>>|<row|<cell|-<frac|2*<around*|(|<with|math-font-family|rm|a*2>*b*<with|math-font-family|rm|b*2>-a*b*<with|math-font-family|rm|b*2>-<with|math-font-family|rm|b*2>+b|)>|<around*|(|a*b-1|)>*<around*|(|<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>-1|)>>>|<cell|<frac|2*<around*|(|a*<with|math-font-family|rm|b*2>-<with|math-font-family|rm|a*2>*b|)>|<around*|(|a*b-1|)>*<around*|(|<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>-1|)>>>>>>>>>
    </unfolded-io>

    <\unfolded-io>
      <with|color|red|(<with|math-font-family|rm|%i>101) >
    <|unfolded-io>
      tunnelsol: solve([tunnellhs1[1,1]=tunnelrhs1[1,1],
      tunnellhs1[1,2]=tunnelrhs1[1,2]], [da,db]), factor;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o101>)
      >><around*|[|<around*|[|<math-up|da>=<frac|<around*|(|<with|math-font-family|rm|a*2>-a|)>*<around*|(|a*<with|math-font-family|rm|b*2>-1|)>|<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>-1>,<math-up|db>=<frac|<around*|(|<with|math-font-family|rm|a*2>*b-1|)>*<around*|(|<with|math-font-family|rm|b*2>-b|)>|<with|math-font-family|rm|a*2>*<with|math-font-family|rm|b*2>-1>|]>|]>>>
    </unfolded-io>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>102) >
    <|input>
      \;
    </input>
  </session>

  Simplifying a bit more,

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<sigma\><rsub|1>A<rsub|1>\<partial\><rsub|x>a<rsub|1>>|<cell|=>|<cell|<frac|1|R<rsub|I>><around|(|a<rsub|2>-a<rsub|1>|)><frac|a<rsub|1>b<rsub|2>-1|a<rsub|2>b<rsub|2>-1>
    ,>>|<row|<cell|\<sigma\><rsub|1>A<rsub|1>\<partial\><rsub|x>b<rsub|1>>|<cell|=>|<cell|<frac|1|R<rsub|I>><around|(|b<rsub|2>-b<rsub|1>|)><frac|a<rsub|2>b<rsub|1>-1|a<rsub|2>b<rsub|2>-1>
    ,>>>>
  </eqnarray*>

  i.e., they differ from the dirty interface b.c.s only by multiplication
  with the factor <math|\<alpha\>>.

  <\session|maxima|default>
    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>102) >
    <|input>
      G2: ev(G, a=a2, b=b2, fT=fT2, fL=fL2), factor$

      dGz0: diff(Gx, x), factor$

      dGz1: ev(dGz0, diff(b(x),x)=db, diff(a(x),x)=da, diff(fT(x),x)=dfT,
      diff(fL(x),x)=dfL, diff(conjugate(a(x)),x)=conjugate(da),
      diff(conjugate(b(x)),x)=conjugate(db))$

      dG: ev(dGz1, a(x)=a, b(x)=b, fT(x)=fT, fL(x)=fL), factor$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>107) >
    <|input>
      tunnelklhs: G.dG$

      tunnelkrhs: comm(G,G2)/2$

      tunnelkinlhs1: (tunnelklhs[1,3] + tunnelklhs[2,4])/4$

      tunnelkinlhs2: (tunnelklhs[1,3] - tunnelklhs[2,4])/4$

      tunnelkinrhs1: (tunnelkrhs[1,3] + tunnelkrhs[2,4])/4$

      tunnelkinrhs2: (tunnelkrhs[1,3] - tunnelkrhs[2,4])/4$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>113) >
    <|input>
      soltunnelk: linsolve([tunnelkinlhs1=tunnelkinrhs1,
      tunnelkinlhs2=tunnelkinrhs2], [dfL, dfT])$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>121) >
    <|input>
      soltunnelkdfL: ev(dfL, soltunnelk)$

      soltunnelkdfT: ev(dfT, soltunnelk)$
    </input>

    <\input>
      <with|color|red|(<with|math-font-family|rm|%i>129) >
    <|input>
      \;
    </input>
  </session>

  <subsection|Single channel>

  A boundary condition for a single channel is also possible to parameterize
  easily:

  <\session|maxima|default>
    <\unfolded-io|<with|color|red|(<with|math-font-family|rm|%i>243) >>
      singlelhs1: GR.dGR3, factor$

      singlerhs1: t*invert(4*t0 + t*(GR.GR2+GR2.GR - 2*t0)).(GR.GR2-GR2.GR),
      factor
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o265>)
      >><around*|(|<tabular*|<tformat|<table|<row|<cell|-<frac|<around*|(|a*<with|math-font-family|rm|b2>-<with|math-font-family|rm|a2>*b|)>*t|<with|math-font-family|rm|a2>*<with|math-font-family|rm|b2>*t-a*<with|math-font-family|rm|b2>*t-<with|math-font-family|rm|a2>*b*t+a*b*t+a*<with|math-font-family|rm|a2>*b*<with|math-font-family|rm|b2>-<with|math-font-family|rm|a2>*<with|math-font-family|rm|b2>-a*b+1>>|<cell|-<frac|<around*|(|a*<with|math-font-family|rm|a2>*<with|math-font-family|rm|b2>-a*<with|math-font-family|rm|a2>*b-<with|math-font-family|rm|a2>+a|)>*t|<with|math-font-family|rm|a2>*<with|math-font-family|rm|b2>*t-a*<with|math-font-family|rm|b2>*t-<with|math-font-family|rm|a2>*b*t+a*b*t+a*<with|math-font-family|rm|a2>*b*<with|math-font-family|rm|b2>-<with|math-font-family|rm|a2>*<with|math-font-family|rm|b2>-a*b+1>>>|<row|<cell|-<frac|<around*|(|<with|math-font-family|rm|a2>*b*<with|math-font-family|rm|b2>-a*b*<with|math-font-family|rm|b2>-<with|math-font-family|rm|b2>+b|)>*t|<with|math-font-family|rm|a2>*<with|math-font-family|rm|b2>*t-a*<with|math-font-family|rm|b2>*t-<with|math-font-family|rm|a2>*b*t+a*b*t+a*<with|math-font-family|rm|a2>*b*<with|math-font-family|rm|b2>-<with|math-font-family|rm|a2>*<with|math-font-family|rm|b2>-a*b+1>>|<cell|<frac|<around*|(|a*<with|math-font-family|rm|b2>-<with|math-font-family|rm|a2>*b|)>*t|<with|math-font-family|rm|a2>*<with|math-font-family|rm|b2>*t-a*<with|math-font-family|rm|b2>*t-<with|math-font-family|rm|a2>*b*t+a*b*t+a*<with|math-font-family|rm|a2>*b*<with|math-font-family|rm|b2>-<with|math-font-family|rm|a2>*<with|math-font-family|rm|b2>-a*b+1>>>>>>|)>>>
    </unfolded-io>

    <\unfolded-io|<with|color|red|(<with|math-font-family|rm|%i>266) >>
      singlesol: solve([singlelhs1[1,1]=singlerhs1[1,1],
      singlelhs1[1,2]=singlerhs1[1,2]], [da,db]), factor;
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o266>)
      >><around*|[|<around*|[|<math-up|da>=<frac|<around*|(|<with|math-font-family|rm|a2>-a|)>*<around*|(|a*b-1|)>*<around*|(|a*<with|math-font-family|rm|b2>-1|)>*t|2*<around*|(|<with|math-font-family|rm|a2>*<with|math-font-family|rm|b2>*t-a*<with|math-font-family|rm|b2>*t-<with|math-font-family|rm|a2>*b*t+a*b*t+a*<with|math-font-family|rm|a2>*b*<with|math-font-family|rm|b2>-<with|math-font-family|rm|a2>*<with|math-font-family|rm|b2>-a*b+1|)>>,<math-up|db>=<frac|<around*|(|a*b-1|)>*<around*|(|<with|math-font-family|rm|a2>*b-1|)>*<around*|(|<with|math-font-family|rm|b2>-b|)>*t|2*<around*|(|<with|math-font-family|rm|a2>*<with|math-font-family|rm|b2>*t-a*<with|math-font-family|rm|b2>*t-<with|math-font-family|rm|a2>*b*t+a*b*t+a*<with|math-font-family|rm|a2>*b*<with|math-font-family|rm|b2>-<with|math-font-family|rm|a2>*<with|math-font-family|rm|b2>-a*b+1|)>>|]>|]>>>
    </unfolded-io>

    <\unfolded-io|<with|color|red|(<with|math-font-family|rm|%i>267) >>
      a2*b2-a*b2-a2*b+a*b, factor
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o267>)
      >><around*|(|<with|math-font-family|rm|a2>-a|)>*<around*|(|<with|math-font-family|rm|b2>-b|)>>>
    </unfolded-io>

    <\unfolded-io|<with|color|red|(<with|math-font-family|rm|%i>268) >>
      a*a2*b*b2-a2*b2-a*b+1, factor
    <|unfolded-io>
      <math|<with|math-display|true|<text|<with|font-family|tt|color|red|(<with|math-font-family|rm|%o268>)
      >><around*|(|a*b-1|)>*<around*|(|<with|math-font-family|rm|a2>*<with|math-font-family|rm|b2>-1|)>>>
    </unfolded-io>

    <\input|<with|color|red|(<with|math-font-family|rm|%i>269) >>
      \;
    </input>
  </session>

  This is conveniently written as

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<sigma\><rsub|1>A<rsub|1>\<partial\><rsub|x>a<rsub|1>>|<cell|=>|<cell|<around|(|a<rsub|2>-a<rsub|1>|)>
    <frac|a<rsub|1>b<rsub|2>-1|a<rsub|2>b<rsub|2>-1>
    \ \<gamma\>,>>|<row|<cell|\<sigma\><rsub|1>A<rsub|1>\<partial\><rsub|x>b<rsub|1>>|<cell|=>|<cell|<around|(|b<rsub|2>-b<rsub|1>|)><frac|a<rsub|2>b<rsub|1>-1|a<rsub|2>b<rsub|2>-1>
    \<gamma\> ,>>|<row|<cell|\<gamma\>>|<cell|=>|<cell|<frac|2|\<pi\>>
    <frac|<around|(|a<rsub|1>b<rsub|1>-1|)><around|(|a<rsub|2>b<rsub|2>-1|)>|<around|(|a<rsub|1>b<rsub|1>-1|)><around|(|a<rsub|2>b<rsub|2>-1|)>+t<around|(|a<rsub|2>-a<rsub|1>|)><around|(|b<rsub|2>-b<rsub|1>|)>>
    \ ,>>>>
  </eqnarray*>

  Again, the result resembles that of a tunnel junction, corrected by a
  factor invariant under <math|1\<leftrightarrow\>2> change. The reason for
  the <math|a\<leftrightarrow\>b> symmetry in the equations is due to the
  tilde-symmetry of the quasiclassical Green's functions <emdash> we indeed
  get the equations for <math|b> via the <math|a\<leftrightarrow\>b> change;
  in this case (energy-independent transmission eigenvalues) it is equivalent
  to the tilde transformation.

  The above result of course agrees with Cuevas's calculation in
  arXiv:0704.2358.

  Note now that <math|t> appears in <verbatim|singlerhs1> only in an
  identical prefactor for all matrix elements. Hence, the average over
  channels only gives the replacement

  <\eqnarray*>
    <tformat|<table|<row|<cell|\<gamma\>>|<cell|\<mapsto\>>|<cell|g<around*|(|<frac|<around|(|a<rsub|2>-a<rsub|1>|)><around|(|b<rsub|2>-b<rsub|1>|)>|<around|(|a<rsub|1>b<rsub|1>-1|)><around|(|a<rsub|2>b<rsub|2>-1|)>>|)>
    ,>>|<row|<cell|g<around|(|z|)>>|<cell|=>|<cell|<frac|1|R<rsub|I>>
    <around*|(|<big|sum><rsub|n>T<rsub|n>|)><rsup|-1> <big|sum><rsub|n>
    <frac|T<rsub|n>|1+T<rsub|n> z> ,>>|<row|<cell|<frac|1|R<rsub|I>>>|<cell|=>|<cell|<frac|e<rsup|2>|\<pi\>\<hbar\>><big|sum><rsub|n>T<rsub|n>
    ,>>>>
  </eqnarray*>

  where <math|g> is now a scalar function. This is rather neat: <em|all
  information pertaining to the interface is contained in the scalar function
  <math|g<around|(|z|)>>>.

  From this, we can also see what happens if the interface is clean. Then,
  <math|R<rsub|I>\<rightarrow\>0>, and the condition essentially becomes

  <\equation*>
    0=<around|(|a<rsub|2>-a<rsub|1>|)><frac|a<rsub|1>b<rsub|2>-1|a<rsub|2>b<rsub|2>-1>
    <around*|(|<big|sum><rsub|n>T<rsub|n>|)><rsup|-1> <big|sum><rsub|n>
    <frac|T<rsub|n>|1+T<rsub|n> z> ,
  </equation*>

  and similarly for <math|b>. Now, obviously <math|a<rsub|1>=a<rsub|2>>,
  <math|b<rsub|1>=b<rsub|2>> is a solution, so that the functions become
  continuous at the interface.

  Also, it is easy to see the boundary condition for infinitely resistive
  interface: for it, <math|\<partial\><rsub|x>a=\<partial\><rsub|x>b=0> since
  then <math|g<around|(|z|)>\<rightarrow\>0>.
</body>

<\initial>
  <\collection>
    <associate|page-type|letter>
    <associate|sfactor|8>
  </collection>
</initial>

<\references>
  <\collection>
    <associate|auto-1|<tuple|1|1>>
    <associate|auto-2|<tuple|2|2>>
    <associate|auto-3|<tuple|3|3>>
    <associate|auto-4|<tuple|3.1|5>>
    <associate|auto-5|<tuple|4|6>>
    <associate|auto-6|<tuple|4.1|6>>
    <associate|auto-7|<tuple|4.2|6>>
    <associate|auto-8|<tuple|4.3|8>>
    <associate|auto-9|<tuple|4.4|8>>
  </collection>
</references>

<\auxiliary>
  <\collection>
    <\associate|toc>
      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|1<space|2spc>Initial
      work> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-1><vspace|0.5fn>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|2<space|2spc>Spectral
      equations> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-2><vspace|0.5fn>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|3<space|2spc>Kinetic
      equations> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-3><vspace|0.5fn>

      <with|par-left|<quote|1.5fn>|3.1<space|2spc>Final result
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-4>>

      <vspace*|1fn><with|font-series|<quote|bold>|math-font-series|<quote|bold>|4<space|2spc>Boundary
      conditions> <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-5><vspace|0.5fn>

      <with|par-left|<quote|1.5fn>|4.1<space|2spc>Clean boundary
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-6>>

      <with|par-left|<quote|1.5fn>|4.2<space|2spc>Dirty interface
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-7>>

      <with|par-left|<quote|1.5fn>|4.3<space|2spc>Tunnel interface
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-8>>

      <with|par-left|<quote|1.5fn>|4.4<space|2spc>Single channel
      <datoms|<macro|x|<repeat|<arg|x>|<with|font-series|medium|<with|font-size|1|<space|0.2fn>.<space|0.2fn>>>>>|<htab|5mm>>
      <no-break><pageref|auto-9>>
    </associate>
  </collection>
</auxiliary>