# Rubicon Objective-C

Rubicon Objective-C is a bridge between Objective-C and Python. It enables you to:

- Use Python to instantiate objects defined in Objective-C,
- Use Python to invoke methods on objects defined in Objective-C, and
- Subclass and extend Objective-C classes in Python.

It also includes wrappers of some key data types from the Foundation framework (e.g., `NSString`).

## [Tutorial](tutorial/index.md)

Get started with a hands-on introduction for beginners.

## [How-to guides](how-to/index.md)

Guides and recipes for common problems and tasks, including how to contribute.

## [Topic guides](topics/index.md)

Deeper explorations of concepts and issues related to Rubicon-ObjC usage.

## [Reference](reference/index.md)

Technical reference - commands, modules, classes, methods

## [About Rubicon-ObjC](about/index.md)

Frequently Asked Questions, success stories, and other details about Rubicon-ObjC as a project.

## Community

Rubicon is part of the [BeeWare suite](https://beeware.org). You can talk to the community through:

- [@beeware@fosstodon.org on Mastodon](https://fosstodon.org/@beeware)
- [Discord](https://beeware.org/bee/chat/)
- The Rubicon-ObjC [GitHub Discussions forum](https://github.com/beeware/rubicon-objc/discussions)

### Code of Conduct

The BeeWare community has a strict [Code of Conduct](https://beeware.org/community/behavior/code-of-conduct/). All users and developers are expected to adhere to this code.

If you have any concerns about this code of conduct, or you wish to report a violation of this code, please contact the project founder [Russell Keith-Magee](mailto:russell@keith-magee.com).

### Contributing

If you experience problems with Rubicon-ObjC, [log them on GitHub](https://github.com/beeware/rubicon-objc/issues).

If you'd like to contribute to Rubicon-ObjC development, our [contribution guide](https://rubicon-objc.readthedocs.io/en/latest/how-to/contribute) details how to set up a development environment, and other requirements we have as part of our contribution process.
