import asyncio

from tests.utils import clear_log_text, get_kernel, get_log_text


def test_latex_magic() -> None:
    kernel = get_kernel()
    asyncio.run(kernel.do_execute("%latex $x_1 = \\dfrac{a}{b}$"))
    text = get_log_text(kernel)
    assert "Display Data" in text

    clear_log_text(kernel)

    asyncio.run(
        kernel.do_execute("""%%latex
            $x_1 = \\dfrac{a}{b}$

            $x_2 = a^{n - 1}$""")
    )
    text = get_log_text(kernel)
    assert "Display Data" in text
