import asyncio

from tests.utils import get_kernel


def test_plot_magic_backend() -> None:
    kernel = get_kernel()
    asyncio.run(kernel.do_execute("%plot qt -f svg -s400,200", None))
    assert kernel.plot_settings["width"] == 400
    assert kernel.plot_settings["height"] == 200
    assert kernel.plot_settings["format"] == "svg"
    assert kernel.plot_settings["backend"] == "qt"


def test_plot_magic_format() -> None:
    kernel = get_kernel()
    asyncio.run(kernel.do_execute("%plot qt -f svg -w 500 -h 400 -r 200"))
    assert kernel.plot_settings["backend"] == "qt", kernel.plot_settings
    assert kernel.plot_settings["format"] == "svg", kernel.plot_settings
    assert kernel.plot_settings["width"] == 500, kernel.plot_settings
    assert kernel.plot_settings["height"] == 400, kernel.plot_settings
    assert kernel.plot_settings["resolution"] == 200, kernel.plot_settings


def test_plot_magic_size() -> None:
    kernel = get_kernel()
    asyncio.run(kernel.do_execute("%plot qt4 -s 400,200"))
    assert kernel.plot_settings["width"] == 400
    assert kernel.plot_settings["height"] == 200
    assert kernel.plot_settings["backend"] == "qt4", kernel.plot_settings


def test_plot_magic_all() -> None:
    kernel = get_kernel()
    asyncio.run(kernel.do_execute("%plot -b qt5 -f svg -s 400,200"))
    assert kernel.plot_settings["width"] == 400
    assert kernel.plot_settings["height"] == 200
    assert kernel.plot_settings["format"] == "svg", kernel.plot_settings
    assert kernel.plot_settings["backend"] == "qt5", kernel.plot_settings
