# Copyright (c) Metakernel Development Team.
# Distributed under the terms of the Modified BSD License.

import os

from metakernel import Magic


class LoadMagic(Magic):
    def line_load(self, filename) -> None:
        """
        %load FILENAME - load code from filename into next cell

        This line magic will get the contents of a file and load it
        into the next cell.

        Example:
            %load myprog.py
        """
        if filename.startswith("~"):
            filename = os.path.expanduser(filename)
        filename = os.path.abspath(filename)
        with open(filename) as f:
            self.kernel.payload.append({"source": "set_next_input", "text": f.read()})


def register_magics(kernel) -> None:
    kernel.register_magics(LoadMagic)
