"""A Jupyter kernel base class in Python which includes core magic functions (including help, command and file path completion, parallel and distributed processing, downloads, and much more)."""

from typing import Any

from . import pexpect
from ._metakernel import (
    ExceptionWrapper,
    IPythonKernel,
    MetaKernel,
    MetaKernelApp,
    get_metakernel,
    register_ipython_magics,
)
from .magic import Magic, option
from .parser import Parser
from .process_metakernel import ProcessMetaKernel
from .replwrap import REPLWrapper


def u(s: Any) -> Any:
    """No-op function retained for backwards compatibility."""
    return s


__all__ = [
    "ExceptionWrapper",
    "IPythonKernel",
    "Magic",
    "MetaKernel",
    "MetaKernelApp",
    "Parser",
    "ProcessMetaKernel",
    "REPLWrapper",
    "get_metakernel",
    "option",
    "pexpect",
    "register_ipython_magics",
    "u",
]

__version__ = "0.31.0"
