// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import * as React from 'react';
import { caretDownEmptyIcon } from '../icon';
import { classes } from '../utils';
import { DEFAULT_STYLE_CLASS } from './interface';
export const HTML_SELECT_CLASS = 'jp-HTMLSelect';
export class HTMLSelect extends React.Component {
    render() {
        const { className, defaultStyle = true, disabled, elementRef, iconProps, icon = caretDownEmptyIcon, options = [], ...htmlProps } = this.props;
        const cls = classes(HTML_SELECT_CLASS, {
            [DEFAULT_STYLE_CLASS]: defaultStyle
        }, className);
        const optionChildren = options.map(option => {
            const props = typeof option === 'object' ? option : { value: option };
            return (React.createElement("option", { ...props, key: props.value }, props.label || props.value));
        });
        return (React.createElement("div", { className: cls },
            React.createElement("select", { disabled: disabled, ref: elementRef, ...htmlProps, multiple: false },
                optionChildren,
                htmlProps.children),
            React.createElement(icon.react, { ...{
                    tag: 'span',
                    stylesheet: 'select',
                    right: '7px',
                    top: '5px',
                    ...iconProps
                } })));
    }
}
//# sourceMappingURL=htmlselect.js.map