import { JSONObject, ReadonlyJSONObject } from '@lumino/coreutils';
import { IDisposable } from '@lumino/disposable';
import { IStream } from '@lumino/signaling';
import { ServerConnection } from '../serverconnection';
/**
 * The events API service manager.
 */
export declare class EventManager implements Event.IManager {
    /**
     * Create a new event manager.
     */
    constructor(options?: EventManager.IOptions);
    /**
     * The server settings used to make API requests.
     */
    readonly serverSettings: ServerConnection.ISettings;
    /**
     * Whether the event manager is disposed.
     */
    get isDisposed(): boolean;
    /**
     * An event stream that emits and yields each new event.
     */
    get stream(): Event.Stream;
    /**
     * Dispose the event manager.
     */
    dispose(): void;
    /**
     * Post an event request to be emitted by the event bus.
     */
    emit(event: Event.Request): Promise<void>;
    /**
     * Subscribe to event bus emissions.
     */
    private _subscribe;
    private _poll;
    private _socket;
    private _stream;
}
/**
 * A namespace for `EventManager` statics.
 */
export declare namespace EventManager {
    /**
     * The instantiation options for an event manager.
     */
    interface IOptions {
        /**
         * The server settings used to make API requests.
         */
        serverSettings?: ServerConnection.ISettings;
    }
}
/**
 * A namespace for event API interfaces.
 */
export declare namespace Event {
    /**
     * The event emission type.
     */
    type Emission = ReadonlyJSONObject & {
        schema_id: string;
    };
    /**
     * The event request type.
     */
    type Request = {
        data: JSONObject;
        schema_id: string;
        version: string;
    };
    /**
     * An event stream with the characteristics of a signal and an async iterator.
     */
    type Stream = IStream<IManager, Emission>;
    /**
     * The interface for the event bus front-end.
     */
    interface IManager extends IDisposable {
        /**
         * The server settings used to make API requests.
         */
        readonly serverSettings: ServerConnection.ISettings;
        /**
         * An event stream that emits and yields each new event.
         */
        readonly stream: Event.Stream;
        /**
         * Post an event request to be emitted by the event bus.
         */
        emit(event: Event.Request): Promise<void>;
    }
}
