import { Extension } from '@codemirror/state';
/**
 * Editor customizable styles
 */
export type CustomTheme = {
    /**
     * Font family
     */
    fontFamily: string | null;
    /**
     * Font size
     */
    fontSize: number | null;
    /**
     * Line height
     */
    lineHeight: number | null;
};
/**
 * Get the extension to customize an editor theme.
 *
 * @param config Theme customization
 * @returns Editor extension
 */
export declare function customTheme(config: CustomTheme): Extension;
