// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import * as React from 'react';
/**
 * A functional tsx component for a progress bar.
 */
export function ProgressBar(props) {
    const { width, percentage, ...rest } = props;
    return (React.createElement("div", { className: 'jp-Statusbar-ProgressBar-progress-bar', role: "progressbar", "aria-valuemin": 0, "aria-valuemax": 100, "aria-valuenow": percentage },
        React.createElement(Filler, { ...{ percentage, ...rest }, contentWidth: width })));
}
/**
 * A functional tsx component for a partially filled div.
 */
function Filler(props) {
    return (React.createElement("div", { style: {
            width: `${props.percentage}%`
        } },
        React.createElement("p", null, props.content)));
}
//# sourceMappingURL=progressBar.js.map