'use strict';

const cssTree = require('css-tree');

const HASH = cssTree.tokenTypes.Hash;
const FUNCTION = cssTree.tokenTypes.Function;
const IDENT = cssTree.tokenTypes.Ident;
const FULLSTOP = 0x002E;        // U+002E FULL STOP (.)
const GREATERTHANSIGN = 0x003E; // U+003E GREATER-THAN SIGN (>)

function consumeRaw() {
    return this.createSingleNodeList(
        this.Raw(this.tokenIndex, null, false)
    );
}

const name = 'LessNamespace';
const structure = {
    name: 'Identifier',
    member: ['Function', 'Identifier']
};
function parse() {
    const start = this.tokenStart;
    const name = this.consume(HASH).substr(1);
    let member;

    this.skipSC(); // deprecated


    // deprecated
    if (this.isDelim(GREATERTHANSIGN)) {
        this.next();
        this.skipSC();
    }

    this.eatDelim(FULLSTOP);

    switch (this.tokenType) {
        case FUNCTION:
            member = this.Function(consumeRaw, this.scope.Value);
            break;

        case IDENT:
            member = this.Identifier();
            break;

        default:
            this.error('Function or ident expected');
    }

    return {
        type: 'LessNamespace',
        loc: this.getLocation(start, this.tokenEnd),
        name,
        member
    };
}

exports.name = name;
exports.parse = parse;
exports.structure = structure;
