# FVM GitHub Workflows

## Active Workflows

### `release.yml`
**Trigger**: Git tag push with `v*` pattern + manual dispatch
**Purpose**: Main deployment pipeline triggered by pushing a version tag
**Process**:
1. **Test** - Run all tests and quality checks
2. **Release** - Create GitHub release and deploy core packages:
   - 📦 pub.dev
   - 🐧 GitHub Linux binaries
   - Uses cli_pkg's `pkg-github-release` to create GitHub release from CHANGELOG
3. **Deploy** - Deploy to all platforms simultaneously:
   - 🍎 GitHub macOS binaries + Homebrew
   - 🪟 GitHub Windows binaries + Chocolatey
   - 🐳 Docker Hub

> Release Grinder tasks now live in `tool/release_tool` and require Dart SDK ≥ 3.8.
> Run release commands from that directory (e.g. `cd tool/release_tool && dart pub get && dart run grinder pkg-github-release`).
> CI pins this toolchain via the `RELEASE_DART_SDK` environment variable (currently `3.9.0`,
> aligned with our Homebrew formula) while the rest of the repo targets the
> lower (`>=3.6.0`) constraint for everyday development.

**Usage**:
1. Update `pubspec.yaml` version
2. Update `CHANGELOG.md` with release notes
3. Run `dart run build_runner build` to generate version.dart
4. Commit changes
5. Tag with `v` prefix: `git tag v4.0.0-beta.3`
6. Push tag: `git push origin v4.0.0-beta.3`
7. Everything deploys automatically!

### `test.yml`
**Trigger**: Push, PR, workflow_call  
**Purpose**: Run all tests and quality checks  
**Used by**: Other workflows for validation before deployment

### `test-install.yml` 
**Trigger**: Manual dispatch  
**Purpose**: Test FVM installation across different platforms

## Standalone Deploy Workflows

### Platform-Specific Deploy Workflows
- `deploy_docker.yml` - Standalone Docker deployment
- `deploy_homebrew.yml` - Standalone Homebrew updates  
- `deploy_macos.yml` - Standalone macOS deployment
- `deploy_windows.yml` - Standalone Windows deployment

## Recommended Release Process

### 🚀 Standard Release (Recommended)

1. **Prepare Release**
   - Update `pubspec.yaml` with new version number
   - Update `CHANGELOG.md` with release notes (use traditional format with bullet points)
   - Run `dart run build_runner build --delete-conflicting-outputs` to generate `lib/src/version.dart`
   - Commit all changes: `git commit -m "chore: prepare vX.Y.Z release"`

2. **Create and Push Tag**
   - Create tag: `git tag vX.Y.Z` (e.g., `v4.0.0-beta.3`)
   - Push tag: `git push origin vX.Y.Z`

3. **Automatic Deployment**
   - `release.yml` triggers automatically on tag push
   - cli_pkg creates GitHub release from CHANGELOG content
   - Monitor progress in [Actions](https://github.com/leoafarias/fvm/actions)
   - All platforms deployed simultaneously

### ⚡ Emergency Release (Alternative)

For hotfixes or platform-specific urgent updates, use individual platform workflows:

- Manual dispatch `deploy_homebrew.yml` for Homebrew-only updates
- Manual dispatch `deploy_docker.yml` for Docker-only updates
- Manual dispatch individual platform workflows as needed

## Version Management

- **Version Source**: `pubspec.yaml` (manually updated before tagging)
- **Tag Format**: Must follow semver with 'v' prefix: `v4.0.0-beta.2`
- **CHANGELOG**: cli_pkg reads CHANGELOG.md to populate GitHub release notes
- **Generated Files**: `lib/src/version.dart` is generated by build_runner from pubspec.yaml

## Troubleshooting

### Workflow doesn't trigger
- Ensure tag is pushed to remote (not just created locally)
- Check that tag follows `v*` pattern
- Verify all required secrets are configured

### Binary upload fails
- Check if GitHub release exists with matching tag
- Verify `GITHUB_TOKEN` has release permissions
- Ensure standalone binaries built successfully

### Platform deployment fails
- Check platform-specific tokens (Chocolatey, Homebrew, Docker)
- Verify runner OS matches deployment target
- Review build logs for specific error details
