@page CHANGES-2-0 Version 2.0

Version 2.0.0 (September 27, 2013)
----------------------------

Version 2.0 is a complete rewrite, so there is no way to write a complete set of difference
with respect to plumed 1.3. Here is a possibly incomplete summary of the difference:
- The input is simpler, more flexible, and more error proof.
  Many checks are now performed and in this way common errors are avoided. 
- The units are now the same for all MD codes.
  If you want to use a different unit than the default you set it in the input file. 
- The analysis tools are now much more flexible.
  As an example of this it is now possible to write different collective variables with different frequencies.
- Many complex collective variables are considerably faster than they were in plumed1.
  In particular, all variables based on RMSD distances. 
- Centers of mass can be used as if they were atoms.
  Hence, unlike plumed 1.3, you can use center of mass positions in ALL collective variables.
- The virial contribution is now computed and passed to the MD code.
  Plumed can thus now be used to perform biased NPT simulations.
- Variables can be dumped on different files, and are
  computed only when this is necessary.
- PLUMED is now compiled as a separate library. This simplifies the patching
  procedure, but might require some extra work to configure PLUMED properly.
  Since PLUMED can be loaded as a shared library, it is possible to setup
  everything such that PLUMED and MD codes can be updated independently from each
  other.

In addition, it is now much easier to contribute new functionality to the code because: 
- There is a much simpler interface between plumed and the base MD codes.
  This makes it much easier to add plumed to a new MD code. Hopefully, in the future,
  interfaces with MD codes will be maintained by the developers of the MD codes
  independently from PLUMED developers. This will allow more MD codes
  to be compatible with PLUMED.
- There is C++ object oriented programming and full compatibility with the C++ standard library 
- A modular structure.
- New collective variables and methods can be released independently.
- There is an extensive developer documentation.
- User documentation is provided together inside the implementation files.

Caveats:
- PLUMED 2 input file (plumed.dat) has a syntax which is not
  compatible with PLUMED 1.
  Transition should be easy, but cannot
  be done just using the new version with the old input file.
- PLUMED 2 is written in C++, thus requires a C++ compiler
- PLUMED 2 may not include all the features that were available
  in PLUMED 1.

A tutorial explaining how to move from PLUMED 1 to PLUMED 2 is available (see \ref moving).

Version 2.0.1 (Nov 14, 2013)
----------------------------

For users:
- Fixed a bug in \ref HISTOGRAM with REWEIGHT_BIAS. Reweighting was only done when also temperature-reweighting was enabled.
- Fixed a bug that was sometime crashing code with domain decomposition and
  non-dense simulation boxes (e.g. implicit solvent).
- Performance improvements for \ref GYRATION.
- Flush all files every 10000 steps by default, without need to use \ref FLUSH
- Errors when writing input for \ref switchingfunction are now properly
  recognized.
- Added message when \ref simplemd is used on a non-existing file.
- Fixed `plumed mklib` such that it deletes the target shared library in case
  of compilation error.
- Several small fixes in documentation and log file.

For developers:
- Added possibility to setup replica exchange from MD codes in Fortran (commands "GREX setMPIFIntercomm" and "GREX setMPIFIntracomm").
- cmd("setStopFlag") should now be called after PLUMED initialization.
- Several small fixes in documentation.

Version 2.0.2 (Feb 11, 2014)
----------------------------

For users:
- Fixed bug with \ref METAD with INTERVAL and replica exchange, including bias exchange.
  Now the bias is correctly computed outside the boundaries. Notice that this is different
  from what was done in PLUMED 1.3. Also notice that INTERVAL now works
  correctly with grids and splines.
- Fixed bug with \ref READ and periodic variables.
- Fixed bug with \ref HISTOGRAM (option USE_ALL_DATA was not working properly).
- Gromacs patch updated to 4.6.5.
- Gromacs patch for 4.6 has been modified to allow for better load balancing when
  using GPUs.
- Added option 'plumed info --long-version' and 'plumed info --git-version'.
- Added full reference (page/number) to published paper in doc and log.
- Fixed a bug in file backups (only affecting Windows version - thanks to T. Giorgino).
- Added possibility to search in the documentation.
- Several small fixes in documentation and log file.

For developers:
- Fixed Makefile dependencies in some auxiliary files in src/lib (*cmake and *inc).
- Changed way modules are linked in src/.
  E.g. src/colvar/tools/ is not anymore a symlink to src/colvar but a real directory.
  (Notice that this introduces a regression: when using plumed as an external library
  some include files could not work - this only applies when plumed is installed;
  also notice that this is fixed in 2.0.3)
- Patch for gromacs 4.6 now also include original code so as to simplify its modification.
- Added option 'plumed patch --save-originals'.
- Fixed regtest regtest/secondarystructure/rt32 to avoid problems with NUMERICAL_DERIVATIVES.
- Removed include graphs in the documentation (too large).
- Several small fixes in documentation.

Version 2.0.3 (June 30, 2014)
----------------------------

For users:
- Now compiles on Blue Gene Q with IBM compilers.
- Fixed bug in \ref CENTER where default WEIGHTS were missing. 
- Fixed broken \ref CONTACTMAP with SUM
- Fixed \ref DUMPATOMS with gro file and more than 100k atoms.
- Added CMDIST in \ref CONTACTMAP to emulate plumed1 CMAP.
- Several small fixes in documentation and log file.

For developers:
- Fixed cmd("getBias") to retrieve bias. It was not working with
  single precision codes and it was not converting units properly.
- Fixed a regression in 2.0.2 concerning include files from installed plumed
  (see commit 562d5ea9dfc3).
- Small fix in tools/Random.cpp that allows Random objects to be
  declared as static.
- Small fix in user-doc compilation, so that if plumed is not found
  the sourceme.sh file is sourced
- Fixed non-ANSI syntax in a few points and a non-important memory leakage.
- Split cltools/Driver.cpp to make parallel compilation faster.

Version 2.0.4 (September 15, 2014)
----------------------------------------------

For users:
- Fixed a bug in \ref BIASVALUE that could produce wrong acceptance with replica exchange simulations.
- Fixed a few innocuous memory leaks.
- Fixed reader for xyz files, that now correctly detects missing columns. Also a related regtest has
  been changed.
- Several small fixes in documentation and log file.

For developers:
- Renamed Value.cpp to BiasValue.cpp

Version 2.0.5 (December 15, 2014)
----------------------------------------------

\plumednotmaintained

For users:
- Fixed a bug in replica exchange with different Hamiltonians (either lambda-dynamics
  or plumed XX-hrex branch) possibly occurring when using charge or mass dependent
  variables.
- Fixed a bug in analysis (e.g. \ref HISTOGRAM) leading to wrong accumulation
  of statistics when running a replica exchange simulation.
- Fixed a bug in the calculation of derivatives in histograms. This should
  be harmless since people usually only consider the value in histograms
  and not the derivatives.
- Fixed an issue in Makefile that could results in problems when
  patching an MD code with --shared option (pointed out by Abhi Acharya).
  This fixes a regression introduced in 2.0.2.
- Small fixes in documentation.

For developers:
- Added warning when performing regtests using an instance of plumed from
  a different directory

