#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.20';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CNTH',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo750D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfo80D',
	'Image::ExifTool::Canon::CameraInfoG5XII',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoR6',
	'Image::ExifTool::Canon::CameraInfoR6m2',
	'Image::ExifTool::Canon::CameraInfoR6m3',
	'Image::ExifTool::Canon::CameraInfoUnknown',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCalib2',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorCoefs2',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData10',
	'Image::ExifTool::Canon::ColorData11',
	'Image::ExifTool::Canon::ColorData12',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorData9',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::FocusBracketingInfo',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LevelInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::LogInfo',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::RawBurstInfo',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::Canon::WBInfo',
	'Image::ExifTool::Canon::uuid',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DLOInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DJI::Main',
	'Image::ExifTool::DJI::XMP',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::AFCSettings',
	'Image::ExifTool::FujiFilm::DriveSettings',
	'Image::ExifTool::FujiFilm::FocusSettings',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::FujiFilm::PrioritySettings',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GIF::Extensions',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::Google::Device',
	'Image::ExifTool::Google::GAudio',
	'Image::ExifTool::Google::GCamera',
	'Image::ExifTool::Google::GContainer',
	'Image::ExifTool::Google::GCreations',
	'Image::ExifTool::Google::GDepth',
	'Image::ExifTool::Google::GFocus',
	'Image::ExifTool::Google::GImage',
	'Image::ExifTool::Google::GPano',
	'Image::ExifTool::Google::GSpherical',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::ColorSpec',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type5',
	'Image::ExifTool::Kodak::Type6',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::MacOS::MDItem',
	'Image::ExifTool::MacOS::XAttr',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Microsoft::Xtra',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Motorola::Main',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2V0100',
	'Image::ExifTool::Nikon::AFInfo2V0101',
	'Image::ExifTool::Nikon::AFInfo2V0200',
	'Image::ExifTool::Nikon::AFInfo2V0300',
	'Image::ExifTool::Nikon::AFInfo2V0400',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::AutoCaptureInfo',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::BracketingInfoD500',
	'Image::ExifTool::Nikon::BracketingInfoD810',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceB',
	'Image::ExifTool::Nikon::ColorBalanceC',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::ColorBalanceUnknown2',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::DistortionInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::FlashInfo0106',
	'Image::ExifTool::Nikon::FlashInfo0107',
	'Image::ExifTool::Nikon::FlashInfo0300',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::HDRInfo2',
	'Image::ExifTool::Nikon::ISOAutoInfoD810',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::IntervalInfoD6',
	'Image::ExifTool::Nikon::IntervalInfoZ7II',
	'Image::ExifTool::Nikon::JPGInfoD500',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LensData0402',
	'Image::ExifTool::Nikon::LensData0403',
	'Image::ExifTool::Nikon::LensData0800',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MakerNotes0x51',
	'Image::ExifTool::Nikon::MakerNotes0x56',
	'Image::ExifTool::Nikon::MenuSettingsD850',
	'Image::ExifTool::Nikon::MenuSettingsZ6III',
	'Image::ExifTool::Nikon::MenuSettingsZ7II',
	'Image::ExifTool::Nikon::MenuSettingsZ8',
	'Image::ExifTool::Nikon::MenuSettingsZ8v1',
	'Image::ExifTool::Nikon::MenuSettingsZ8v2',
	'Image::ExifTool::Nikon::MenuSettingsZ9',
	'Image::ExifTool::Nikon::MenuSettingsZ9v3',
	'Image::ExifTool::Nikon::MenuSettingsZ9v4',
	'Image::ExifTool::Nikon::MoreSettingsD850',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::MultiExposure2',
	'Image::ExifTool::Nikon::Offset13InfoZ9',
	'Image::ExifTool::Nikon::OrientationInfo',
	'Image::ExifTool::Nikon::OtherInfoD500',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PictureControl2',
	'Image::ExifTool::Nikon::PictureControl3',
	'Image::ExifTool::Nikon::PortraitInfoZ7II',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::RotationInfoD500',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::SeqInfoD6',
	'Image::ExifTool::Nikon::SeqInfoZ9',
	'Image::ExifTool::Nikon::SettingsInfoD810',
	'Image::ExifTool::Nikon::ShootingMenuD500',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::VignetteInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5',
	'Image::ExifTool::NikonCustom::SettingsD500',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD610',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD850',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::NikonCustom::SettingsZ6III',
	'Image::ExifTool::NikonCustom::SettingsZ8',
	'Image::ExifTool::NikonCustom::SettingsZ9',
	'Image::ExifTool::NikonCustom::SettingsZ9v4',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::AFTargetInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::Olympus::SubjectDetectInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PLUS::XMP',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::DSA',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::FocusInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Leica9',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::Panasonic::TimeInfo',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AFInfoK3III',
	'Image::ExifTool::Pentax::AFPointInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CAFPointInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FaceInfoK3III',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::LevelInfoK3III',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::PixelShiftInfo',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhaseOne::Main',
	'Image::ExifTool::PhaseOne::SensorCalibration',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::AudioKeys',
	'Image::ExifTool::QuickTime::ItemList',
	'Image::ExifTool::QuickTime::ItemPropCont',
	'Image::ExifTool::QuickTime::Keys',
	'Image::ExifTool::QuickTime::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::QuickTime::UserData',
	'Image::ExifTool::QuickTime::VideoKeys',
	'Image::ExifTool::Reconyx::HyperFire',
	'Image::ExifTool::Reconyx::HyperFire2',
	'Image::ExifTool::Reconyx::HyperFire4K',
	'Image::ExifTool::Reconyx::MicroFire',
	'Image::ExifTool::Reconyx::UltraFire',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::OrientationInfo',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sigma::WBSettings',
	'Image::ExifTool::Sigma::WBSettings2',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::AFStatus79',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::HiddenInfo',
	'Image::ExifTool::Sony::ISOInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MeterInfo9',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::SR2SubIFD',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag2010i',
	'Image::ExifTool::Sony::Tag202a',
	'Image::ExifTool::Sony::Tag9050a',
	'Image::ExifTool::Sony::Tag9050b',
	'Image::ExifTool::Sony::Tag9050c',
	'Image::ExifTool::Sony::Tag9050d',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9404c',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag9406b',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::ACDSeeRegions',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExifTool',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::HDRGainMap',
	'Image::ExifTool::XMP::LImage',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apdi',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::crd',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::hdr',
	'Image::ExifTool::XMP::hdrgm',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::panorama',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::pdfx',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 117 => 0x69 },
	'about' => { 560 => 'about' },
	'aboutcvterm' => { 550 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 550 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 550 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 550 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 550 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'absolutealtitude' => { 124 => 'AbsoluteAltitude' },
	'abspeakaudiofilepath' => { 566 => 'absPeakAudioFilePath' },
	'academicfield' => { 556 => 'academicField' },
	'acceleration' => { 127 => 0x9404, 543 => 'Acceleration' },
	'accelerationtracking' => { 92 => 0x518 },
	'accelerationvector' => { 1 => 0x8 },
	'accelerometer' => { 450 => 0x3 },
	'accelerometerdata' => { 437 => 'vrot' },
	'accelerometerx' => { 372 => 0x8d },
	'accelerometery' => { 372 => 0x8e },
	'accelerometerz' => { 372 => 0x8c },
	'accessoryserialnumber' => { 372 => 0x54 },
	'accessorytype' => { 372 => 0x53 },
	'acdseeregion' => { 519 => [\'Regions','RegionsRegionList'] },
	'acdseeregionalgarea' => { 519 => [\'Regions','RegionsRegionListALGArea'] },
	'acdseeregionalgareah' => { 519 => [\'Regions','RegionsRegionListALGAreaH'] },
	'acdseeregionalgareaw' => { 519 => [\'Regions','RegionsRegionListALGAreaW'] },
	'acdseeregionalgareax' => { 519 => [\'Regions','RegionsRegionListALGAreaX'] },
	'acdseeregionalgareay' => { 519 => [\'Regions','RegionsRegionListALGAreaY'] },
	'acdseeregionappliedtodimensions' => { 519 => [\'Regions','RegionsAppliedToDimensions'] },
	'acdseeregionappliedtodimensionsh' => { 519 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'acdseeregionappliedtodimensionsunit' => { 519 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'acdseeregionappliedtodimensionsw' => { 519 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'acdseeregiondlyarea' => { 519 => [\'Regions','RegionsRegionListDLYArea'] },
	'acdseeregiondlyareah' => { 519 => [\'Regions','RegionsRegionListDLYAreaH'] },
	'acdseeregiondlyareaw' => { 519 => [\'Regions','RegionsRegionListDLYAreaW'] },
	'acdseeregiondlyareax' => { 519 => [\'Regions','RegionsRegionListDLYAreaX'] },
	'acdseeregiondlyareay' => { 519 => [\'Regions','RegionsRegionListDLYAreaY'] },
	'acdseeregionname' => { 519 => [\'Regions','RegionsRegionListName'] },
	'acdseeregionnameassigntype' => { 519 => [\'Regions','RegionsRegionListNameAssignType'] },
	'acdseeregiontype' => { 519 => [\'Regions','RegionsRegionListType'] },
	'actionadvised' => { 150 => 0x2a },
	'actioninafccont' => { 383 => 0x220 },
	'actionpriority' => { 2 => 0x1d },
	'activearea' => { 127 => 0xc68d },
	'actived-lighting' => { 258 => 0x22, 316 => 0x24 },
	'actived-lightingmode' => { 316 => 0x25 },
	'adaptervoltage' => { 157 => 0x407 },
	'addaspectratioinfo' => { 92 => 0x80e },
	'addiptcinformation' => { 92 => 0x815 },
	'additionalmodelinformation' => { 550 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 92 => 0x80f, 93 => 0x11, 94 => 0x13, 97 => 0x14 },
	'address' => { 180 => 'Address' },
	'adjustmentmode' => { 457 => 0x15 },
	'adlbracketingstep' => { 220 => 0x17 },
	'adlbracketingtype' => { 220 => 0x18 },
	'adobe' => { 128 => 'Adobe' },
	'adultcontentwarning' => { 358 => 'AdultContentWarning', 559 => 'adultContentWarning' },
	'advancedfilter' => { 135 => 0x1201 },
	'advancedraw' => { 318 => 0x76a43203 },
	'advancedscenetype' => { 372 => 0x3d },
	'advisory' => { 564 => 'Advisory' },
	'ae_iso' => { 380 => 0x2, 381 => 0x4, 382 => 0x12 },
	'aeaperture' => { 380 => 0x1, 381 => 0x3, 382 => 0x11 },
	'aeaperturesteps' => { 380 => 0x8, 381 => 0xb },
	'aeaverage' => { 1 => 0x6 },
	'aebautocancel' => { 92 => 0x104 },
	'aebbracketvalue' => { 84 => 0x11 },
	'aebracketingsteps' => { 220 => 0xf, 221 => 0xf, 298 => 0x174c },
	'aebsequence' => { 92 => 0x105 },
	'aebsequenceautocancel' => { 90 => 0x9, 91 => 0x9, 93 => 0x8, 94 => 0x9, 97 => 0x9, 98 => 0x7 },
	'aebshotcount' => { 92 => 0x106 },
	'aebxv' => { 380 => 0x4, 381 => 0x6 },
	'aeerror' => { 381 => 0x8 },
	'aeexposuretime' => { 380 => 0x0, 381 => 0x2, 382 => 0x10 },
	'aelbutton' => { 203 => 0x45 },
	'aelexposureindicator' => { 203 => 0x51 },
	'aelock' => { 203 => 0x5b, 327 => '4.2', 336 => '4.2', 347 => 0x201, 411 => 0x48, 467 => 0x40, 468 => 0x40, 469 => [0x86,0x286] },
	'aelockbutton' => { 325 => '16.1', 327 => '4.1', 330 => '15.1', 331 => '16.1', 332 => '16.1', 334 => '30.1', 335 => '16.1', 336 => '4.1', 338 => '17.1', 340 => '17.1' },
	'aelockbuttonplusdials' => { 325 => '16.2', 334 => '32.1', 338 => '44.1' },
	'aelockformb-d80' => { 340 => '3.1' },
	'aelockmetermodeafterfocus' => { 92 => 0x114 },
	'aematrix' => { 1 => 0x2 },
	'aemaxaperture' => { 380 => 0x9, 381 => 0x10, 382 => 0x1c },
	'aemaxaperture2' => { 380 => 0xa, 381 => 0x11, 382 => 0x1d },
	'aemeteringmode' => { 380 => 0xc },
	'aemeteringmode2' => { 380 => '13.1' },
	'aemeteringsegments' => { 206 => 0x628, 411 => 0x209 },
	'aemicroadjustment' => { 92 => 0x110 },
	'aeminaperture' => { 380 => 0xb, 381 => 0x12, 382 => 0x1e },
	'aeminexposuretime' => { 380 => 0x5, 381 => 0x13, 382 => 0x1f },
	'aeprogrammode' => { 380 => 0x6 },
	'aeprojectlink' => { 537 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 537 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 537 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 537 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 537 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 537 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 38 => 0x21 },
	'aestable' => { 1 => 0x4 },
	'aestheticscore' => { 361 => 'aesthetic_score' },
	'aetarget' => { 1 => 0x5 },
	'aewhitebalance' => { 380 => 0xd },
	'aexv' => { 380 => 0x3, 381 => 0x5 },
	'af-assistilluminator' => { 341 => 0x1a, 342 => 0x19, 343 => 0x19, 344 => 0x19 },
	'af-cfocusdisplay' => { 342 => 0x234, 343 => 0x234, 344 => 0x24c },
	'af-cpriority' => { 136 => '0.2' },
	'af-cpriorityselection' => { 325 => '1.1', 326 => '1.1', 328 => '1.1', 329 => '1.1', 331 => '0.1', 332 => '0.1', 333 => '0.1', 334 => '1.1', 335 => '0.1', 338 => '1.1', 339 => '1.1', 341 => 0x3, 342 => 0x3, 343 => 0x3, 344 => 0x3 },
	'af-csetting' => { 132 => 0x0 },
	'af-cspeedtrackingsensitivity' => { 132 => '0.2' },
	'af-ctrackingsensitivity' => { 132 => '0.1' },
	'af-czoneareaswitching' => { 132 => '0.3' },
	'af-onbutton' => { 328 => '70.1', 329 => '70.1', 339 => '70.1' },
	'af-onformb-d10' => { 325 => '3.3', 334 => '3.2' },
	'af-onformb-d11' => { 335 => '2.2' },
	'af-onformb-d12' => { 338 => '50.1' },
	'af-onoutoffocusrelease' => { 341 => 0x10, 342 => 0x10, 343 => 0x10, 344 => 0x10 },
	'af-spriority' => { 136 => '0.1' },
	'af-spriorityselection' => { 325 => '1.2', 326 => '1.2', 328 => '1.2', 329 => '1.2', 333 => '0.2', 334 => '1.2', 335 => '0.2', 338 => '1.2', 339 => '1.2', 341 => 0x5, 342 => 0x5, 343 => 0x5, 344 => 0x5 },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 325 => '2.1', 326 => '2.1', 328 => '78.3', 329 => '78.3', 334 => '2.1', 338 => '2.1', 339 => '78.3', 341 => 0xf, 342 => 0xf, 343 => 0xf, 344 => 0xf },
	'afadjustment' => { 411 => 0x72, 420 => 0x267 },
	'afandmeteringbuttons' => { 92 => 0x701 },
	'afaperture' => { 251 => 0x5, 252 => 0x5, 256 => 0x5 },
	'afareaheight' => { 212 => 0x1a, 213 => 0x50, 215 => 0x34, 216 => 0x48 },
	'afareaillumination' => { 203 => 0x4b, 336 => '15.3' },
	'afareainitialheight' => { 273 => 0xbeb },
	'afareainitialwidth' => { 273 => 0xbea },
	'afareainitialxposition' => { 273 => 0xbe8 },
	'afareainitialyposition' => { 273 => 0xbe9 },
	'afareamode' => { 134 => '0.3', 199 => 0x33, 203 => 0xe, 211 => 0x0, 212 => 0x5, 213 => 0x5, 214 => 0x5, 215 => 0x5, 216 => 0x5, 262 => 0x340, 264 => 0x224, 267 => 0x210, 268 => 0x224, 269 => 0x224, 372 => 0xf, 447 => 0x1205, 460 => [0xa,0x3a], 467 => 0x11, 468 => 0x10, 469 => 0x24, 481 => 0xb043, 507 => 0x17 },
	'afareamodesetting' => { 327 => '11.1', 330 => '0.1', 336 => '16.1', 340 => '2.1', 481 => 0x201c },
	'afareapointsize' => { 134 => '0.4' },
	'afareas' => { 347 => 0x304 },
	'afareaselectionmethod' => { 2 => 0xd },
	'afareaselectmethod' => { 92 => 0x51b },
	'afareasize' => { 372 => 0xde },
	'afareawidth' => { 212 => 0x18, 213 => 0x4e, 215 => 0x32, 216 => 0x46 },
	'afareaxposition' => { 212 => 0x14, 213 => 0x4a, 215 => 0x2e, 216 => 0x42, 447 => 0x1203 },
	'afareaxposition1' => { 447 => 0x1201 },
	'afareayposition' => { 212 => 0x16, 213 => 0x4c, 215 => 0x30, 216 => 0x44, 447 => 0x1204 },
	'afareayposition1' => { 447 => 0x1202 },
	'afareazonesize' => { 134 => '0.5' },
	'afassist' => { 90 => 0x5, 98 => 0x5, 203 => 0x48, 325 => '2.5', 327 => '0.2', 330 => '0.2', 331 => '1.1', 332 => '1.1', 333 => '1.3', 334 => '2.4', 335 => '1.3', 336 => '0.2', 338 => '2.4', 340 => '2.3' },
	'afassistbeam' => { 2 => 0x8, 92 => 0x50e, 93 => 0x4, 94 => 0x5, 95 => 0x4, 96 => 0x4, 97 => 0x5 },
	'afassistlamp' => { 372 => 0x31 },
	'afbuttonpressed' => { 469 => [0x83,0x283] },
	'afchold' => { 383 => 0x221 },
	'afconfidence' => { 1 => 0x3d },
	'afconfigtool' => { 2 => 0x1 },
	'afcoordinatesavailable' => { 215 => 0x7, 216 => 0x7 },
	'afcpointtracking' => { 383 => '545.1' },
	'afcsensitivity' => { 383 => '545.2' },
	'afdefocus' => { 383 => 0x6 },
	'afdetectionmethod' => { 212 => 0x4, 213 => 0x4, 215 => 0x4, 216 => 0x4 },
	'afduringliveview' => { 92 => 0x511 },
	'affinea' => { 529 => 'AffineA' },
	'affineb' => { 529 => 'AffineB' },
	'affinec' => { 529 => 'AffineC' },
	'affined' => { 529 => 'AffineD' },
	'affinetune' => { 217 => 0x0, 265 => 0x6b0, 266 => 0x6c0, 267 => 0x5b0, 268 => 0x5e0, 269 => 0x5f8, 347 => 0x306 },
	'affinetuneadj' => { 217 => 0x2, 291 => 0x2d1, 292 => 0x2dc, 347 => 0x307 },
	'affinetuneadjtele' => { 217 => 0x3 },
	'affinetuneindex' => { 217 => 0x1 },
	'affinex' => { 529 => 'AffineX' },
	'affiney' => { 529 => 'AffineY' },
	'affocusarea' => { 346 => 0x2 },
	'afframesize' => { 346 => 0x0 },
	'afhold' => { 383 => 0x1fd },
	'afilluminator' => { 467 => 0x29, 481 => 0xb044 },
	'afimageheight' => { 212 => 0x12, 213 => 0x48, 215 => 0x2c, 216 => 0x40 },
	'afimagewidth' => { 212 => 0x10, 213 => 0x46, 215 => 0x2a, 216 => 0x3e },
	'afinfo' => { 384 => 0x0 },
	'afintegrationtime' => { 383 => 0x7 },
	'afmeasureddepth' => { 1 => 0x38 },
	'afmicroadj' => { 460 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 464 => 0x131 },
	'afmicroadjregisteredlenses' => { 464 => '305.1' },
	'afmicroadjustment' => { 92 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 464 => 0x130 },
	'afmode' => { 121 => 0x3009, 135 => 0x1022, 199 => 0x16, 384 => '0.1', 457 => 0x5 },
	'afmoderestrictions' => { 326 => '50.3', 328 => '48.3', 329 => '48.3', 338 => '48.3', 339 => '48.3' },
	'afonaelockbuttonswitch' => { 92 => 0x702 },
	'afonbutton' => { 325 => '3.1', 326 => '47.1', 341 => 0x87, 342 => 0x83, 343 => 0x83, 344 => 0x83 },
	'afperformance' => { 1 => 0x23 },
	'afpoint' => { 38 => 0x13, 120 => 0x18, 199 => 0x15, 211 => 0x1, 350 => 0x308, 457 => 0x1f, 460 => [0x37,0x7], 464 => 0x19, 465 => 0x18, 466 => [0x18,0x20] },
	'afpointactivationarea' => { 91 => 0x11, 97 => 0x11 },
	'afpointareaexpansion' => { 92 => 0x508 },
	'afpointatshutterrelease' => { 460 => [0x39,0x9] },
	'afpointautoselection' => { 92 => 0x50b },
	'afpointbrightness' => { 92 => 0x50d, 325 => '2.4', 326 => '46.5', 328 => '2.2', 329 => '2.2', 338 => '2.3', 339 => '2.2' },
	'afpointdetails' => { 350 => 0x31b },
	'afpointdisplayduringfocus' => { 2 => 0x10, 92 => 0x50c },
	'afpointillumination' => { 91 => 0xa, 325 => '2.3', 326 => '46.2', 328 => '47.2', 329 => '47.2', 333 => '1.2', 334 => '2.3', 335 => '1.2', 338 => '47.2', 339 => '47.2', 340 => '2.4' },
	'afpointinfocus' => { 460 => [0x38,0x8] },
	'afpointmode' => { 390 => 0x3 },
	'afpointposition' => { 121 => 0x2021, 372 => 0x4d },
	'afpointregistration' => { 90 => 0x7 },
	'afpoints' => { 202 => 0x10 },
	'afpointsel' => { 341 => 0xb, 342 => 0xb, 343 => 0xb, 344 => 0xb },
	'afpointselected' => { 203 => 0xd, 347 => 0x305, 411 => 0xe, 464 => 0x15, 465 => 0x14, 466 => [0x14,0x1c], 481 => 0x201e },
	'afpointselected2' => { 390 => 0x4 },
	'afpointselection' => { 91 => 0xb, 325 => '1.3', 326 => '1.3', 334 => '1.3', 338 => '1.3', 339 => '1.3' },
	'afpointselectionmethod' => { 92 => 0x50f, 93 => 0xc, 94 => 0xd, 97 => 0xd },
	'afpointsetting' => { 467 => 0x12, 468 => 0x11 },
	'afpointsinfocus' => { 84 => 0xe, 211 => 0x2, 213 => 0x30, 383 => 0xb, 411 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 19 => 0x38 },
	'afpointspotmetering' => { 91 => 0xd },
	'afpointsselected' => { 212 => 0x1c, 213 => 0x1c, 383 => 0x12a, 516 => 0x4 },
	'afpointsunknown' => { 383 => 0x18f },
	'afpointsunknown1' => { 383 => 0x0 },
	'afpointsunknown2' => { 383 => 0x2 },
	'afpointsused' => { 212 => 0x8, 213 => [0x1c,0x8], 214 => 0x8, 215 => 0xa, 216 => 0xa, 460 => [0x10,0x16e] },
	'afpointswitching' => { 2 => 0x4 },
	'afpointvalues' => { 383 => 0x14 },
	'afpredictor' => { 383 => 0x4 },
	'afresponse' => { 258 => 0xad },
	'afresult' => { 352 => 0x1038 },
	'afsearch' => { 347 => 0x303 },
	'afselectedarea' => { 346 => 0x6 },
	'afselectionmode' => { 384 => 0x1 },
	'afsensoractive' => { 199 => 0x1 },
	'afstable' => { 1 => 0x7 },
	'afstatus' => { 447 => 0x1200 },
	'afstatus_00_b4' => { 463 => 0x0 },
	'afstatus_01_c4' => { 463 => 0x2 },
	'afstatus_02_d4' => { 463 => 0x4 },
	'afstatus_03_e4' => { 463 => 0x6 },
	'afstatus_04_f4' => { 463 => 0x8 },
	'afstatus_05_g4' => { 463 => 0xa },
	'afstatus_06_h4' => { 463 => 0xc },
	'afstatus_07_b3' => { 463 => 0xe },
	'afstatus_08_c3' => { 463 => 0x10 },
	'afstatus_09_d3' => { 463 => 0x12 },
	'afstatus_10_e3' => { 463 => 0x14 },
	'afstatus_11_f3' => { 463 => 0x16 },
	'afstatus_12_g3' => { 463 => 0x18 },
	'afstatus_13_h3' => { 463 => 0x1a },
	'afstatus_14_b2' => { 463 => 0x1c },
	'afstatus_15_c2' => { 463 => 0x1e },
	'afstatus_16_d2' => { 463 => 0x20 },
	'afstatus_17_e2' => { 463 => 0x22 },
	'afstatus_18_f2' => { 463 => 0x24 },
	'afstatus_19_g2' => { 463 => 0x26 },
	'afstatus_20_h2' => { 463 => 0x28 },
	'afstatus_21_c1' => { 463 => 0x2a },
	'afstatus_22_d1' => { 463 => 0x2c },
	'afstatus_23_e1' => { 463 => 0x2e },
	'afstatus_24_f1' => { 463 => 0x30 },
	'afstatus_25_g1' => { 463 => 0x32 },
	'afstatus_26_a7_vertical' => { 463 => 0x34 },
	'afstatus_27_a6_vertical' => { 463 => 0x36 },
	'afstatus_28_a5_vertical' => { 463 => 0x38 },
	'afstatus_29_c7_vertical' => { 463 => 0x3a },
	'afstatus_30_c6_vertical' => { 463 => 0x3c },
	'afstatus_31_c5_vertical' => { 463 => 0x3e },
	'afstatus_32_e7_vertical' => { 463 => 0x40 },
	'afstatus_33_e6_center_vertical' => { 463 => 0x42 },
	'afstatus_34_e5_vertical' => { 463 => 0x44 },
	'afstatus_35_g7_vertical' => { 463 => 0x46 },
	'afstatus_36_g6_vertical' => { 463 => 0x48 },
	'afstatus_37_g5_vertical' => { 463 => 0x4a },
	'afstatus_38_i7_vertical' => { 463 => 0x4c },
	'afstatus_39_i6_vertical' => { 463 => 0x4e },
	'afstatus_40_i5_vertical' => { 463 => 0x50 },
	'afstatus_41_a7' => { 463 => 0x52 },
	'afstatus_42_b7' => { 463 => 0x54 },
	'afstatus_43_c7' => { 463 => 0x56 },
	'afstatus_44_d7' => { 463 => 0x58 },
	'afstatus_45_e7' => { 463 => 0x5a },
	'afstatus_46_f7' => { 463 => 0x5c },
	'afstatus_47_g7' => { 463 => 0x5e },
	'afstatus_48_h7' => { 463 => 0x60 },
	'afstatus_49_i7' => { 463 => 0x62 },
	'afstatus_50_a6' => { 463 => 0x64 },
	'afstatus_51_b6' => { 463 => 0x66 },
	'afstatus_52_c6' => { 463 => 0x68 },
	'afstatus_53_d6' => { 463 => 0x6a },
	'afstatus_54_e6_center' => { 463 => 0x6c },
	'afstatus_55_f6' => { 463 => 0x6e },
	'afstatus_56_g6' => { 463 => 0x70 },
	'afstatus_57_h6' => { 463 => 0x72 },
	'afstatus_58_i6' => { 463 => 0x74 },
	'afstatus_59_a5' => { 463 => 0x76 },
	'afstatus_60_b5' => { 463 => 0x78 },
	'afstatus_61_c5' => { 463 => 0x7a },
	'afstatus_62_d5' => { 463 => 0x7c },
	'afstatus_63_e5' => { 463 => 0x7e },
	'afstatus_64_f5' => { 463 => 0x80 },
	'afstatus_65_g5' => { 463 => 0x82 },
	'afstatus_66_h5' => { 463 => 0x84 },
	'afstatus_67_i5' => { 463 => 0x86 },
	'afstatus_68_c11' => { 463 => 0x88 },
	'afstatus_69_d11' => { 463 => 0x8a },
	'afstatus_70_e11' => { 463 => 0x8c },
	'afstatus_71_f11' => { 463 => 0x8e },
	'afstatus_72_g11' => { 463 => 0x90 },
	'afstatus_73_b10' => { 463 => 0x92 },
	'afstatus_74_c10' => { 463 => 0x94 },
	'afstatus_75_d10' => { 463 => 0x96 },
	'afstatus_76_e10' => { 463 => 0x98 },
	'afstatus_77_f10' => { 463 => 0x9a },
	'afstatus_78_g10' => { 463 => 0x9c },
	'afstatus_79_h10' => { 463 => 0x9e },
	'afstatus_80_b9' => { 463 => 0xa0 },
	'afstatus_81_c9' => { 463 => 0xa2 },
	'afstatus_82_d9' => { 463 => 0xa4 },
	'afstatus_83_e9' => { 463 => 0xa6 },
	'afstatus_84_f9' => { 463 => 0xa8 },
	'afstatus_85_g9' => { 463 => 0xaa },
	'afstatus_86_h9' => { 463 => 0xac },
	'afstatus_87_b8' => { 463 => 0xae },
	'afstatus_88_c8' => { 463 => 0xb0 },
	'afstatus_89_d8' => { 463 => 0xb2 },
	'afstatus_90_e8' => { 463 => 0xb4 },
	'afstatus_91_f8' => { 463 => 0xb6 },
	'afstatus_92_g8' => { 463 => 0xb8 },
	'afstatus_93_h8' => { 463 => 0xba },
	'afstatus_94_e6_center_f2-8' => { 463 => 0xbc },
	'afstatusactivesensor' => { 199 => 0x2, 460 => [0x4,0x3b], 464 => 0x1e, 465 => 0x1b, 466 => [0x1b,0x21] },
	'afstatusbottom' => { 199 => 0x8, 464 => 0x2a, 465 => 0x21, 466 => 0x21 },
	'afstatusbottom-left' => { 199 => 0x12, 465 => 0x2b, 466 => 0x2b },
	'afstatusbottom-right' => { 199 => 0x6, 465 => 0x1f, 466 => 0x1f },
	'afstatusbottomassist-left' => { 464 => 0x28 },
	'afstatusbottomassist-right' => { 464 => 0x2c },
	'afstatusbottomhorizontal' => { 461 => 0x10, 462 => 0x1c },
	'afstatusbottomvertical' => { 461 => 0x16, 462 => 0x26 },
	'afstatuscenter-10' => { 464 => 0x34 },
	'afstatuscenter-11' => { 464 => 0x36 },
	'afstatuscenter-12' => { 464 => 0x38 },
	'afstatuscenter-14' => { 464 => 0x3c },
	'afstatuscenter-7' => { 464 => 0x2e },
	'afstatuscenter-9' => { 464 => 0x32 },
	'afstatuscenter-horizontal' => { 464 => 0x30 },
	'afstatuscenter-vertical' => { 464 => 0x3a },
	'afstatuscenterf2-8' => { 464 => 0x4c },
	'afstatuscenterhorizontal' => { 199 => 0x2f, 461 => 0xc, 462 => 0x18, 465 => 0x2f, 466 => 0x2f },
	'afstatuscentervertical' => { 199 => 0xc, 461 => 0x14, 462 => 0x22, 465 => 0x25, 466 => 0x25 },
	'afstatusfarleft' => { 461 => 0x6, 464 => 0x26 },
	'afstatusfarlefthorizontal' => { 462 => 0x4 },
	'afstatusfarleftvertical' => { 462 => 0x12 },
	'afstatusfarright' => { 461 => 0x18, 464 => 0x44 },
	'afstatusfarrighthorizontal' => { 462 => 0x2c },
	'afstatusfarrightvertical' => { 462 => 0x34 },
	'afstatusleft' => { 199 => 0x2d, 461 => 0x2, 464 => 0x22, 465 => 0x2d, 466 => 0x2d },
	'afstatuslefthorizontal' => { 462 => 0x6 },
	'afstatusleftvertical' => { 462 => 0xe },
	'afstatuslower-left' => { 461 => 0x4, 464 => 0x24 },
	'afstatuslower-lefthorizontal' => { 462 => 0xa },
	'afstatuslower-leftvertical' => { 462 => 0x10 },
	'afstatuslower-middle' => { 461 => 0x22, 462 => 0x24 },
	'afstatuslower-right' => { 461 => 0x1e, 464 => 0x4a },
	'afstatuslower-righthorizontal' => { 462 => 0x32 },
	'afstatuslower-rightvertical' => { 462 => 0x3a },
	'afstatuslowerfarleft' => { 462 => 0x8 },
	'afstatuslowerfarright' => { 462 => 0x30 },
	'afstatusmiddlehorizontal' => { 199 => 0xa, 465 => 0x23, 466 => 0x23 },
	'afstatusnearleft' => { 461 => 0xe, 462 => 0x1a },
	'afstatusnearright' => { 461 => 0xa, 462 => 0x16 },
	'afstatusright' => { 199 => 0x31, 461 => 0x1c, 464 => 0x48, 465 => 0x31, 466 => 0x31 },
	'afstatusrighthorizontal' => { 462 => 0x2e },
	'afstatusrightvertical' => { 462 => 0x38 },
	'afstatustop' => { 199 => 0xe, 464 => 0x40, 465 => 0x27, 466 => 0x27 },
	'afstatustop-left' => { 199 => 0x10, 465 => 0x29, 466 => 0x29 },
	'afstatustop-right' => { 199 => 0x4, 465 => 0x1d, 466 => 0x1d },
	'afstatustopassist-left' => { 464 => 0x3e },
	'afstatustopassist-right' => { 464 => 0x42 },
	'afstatustophorizontal' => { 461 => 0x8, 462 => 0x14 },
	'afstatustopvertical' => { 461 => 0x12, 462 => 0x1e },
	'afstatusupper-left' => { 461 => 0x0, 464 => 0x20 },
	'afstatusupper-lefthorizontal' => { 462 => 0x2 },
	'afstatusupper-leftvertical' => { 462 => 0xc },
	'afstatusupper-middle' => { 461 => 0x20, 462 => 0x20 },
	'afstatusupper-right' => { 461 => 0x1a, 464 => 0x46 },
	'afstatusupper-righthorizontal' => { 462 => 0x2a },
	'afstatusupper-rightvertical' => { 462 => 0x36 },
	'afstatusupperfarleft' => { 462 => 0x0 },
	'afstatusupperfarright' => { 462 => 0x28 },
	'afstatusviewfinder' => { 2 => 0x12 },
	'afsubjectdetection' => { 372 => 0xe9 },
	'aftargetinfo' => { 347 => 0x30a },
	'aftracking' => { 481 => 0x2021 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 460 => 0x2 },
	'afwithshutter' => { 467 => 0x2a },
	'aggregateissuenumber' => { 556 => 'aggregateIssueNumber' },
	'aggregationtype' => { 556 => 'aggregationType' },
	'agreement' => { 559 => 'agreement' },
	'ah2greeninterpolationthreshold' => { 157 => 0xe4e },
	'aipromptinformation' => { 550 => 'AIPromptInformation' },
	'aipromptwritername' => { 550 => 'AIPromptWriterName' },
	'airplanemode' => { 262 => 0x9c0, 265 => 0x722, 266 => 0x782, 267 => 0x624, 268 => 0x654, 269 => 0x6bc },
	'aiservocontinuousshooting' => { 91 => 0x15 },
	'aiservofirstimage' => { 2 => 0x5 },
	'aiservofirstimagepriority' => { 92 => 0x519 },
	'aiservoimagepriority' => { 92 => 0x503 },
	'aiservosecondimage' => { 2 => 0x6 },
	'aiservosecondimagepriority' => { 92 => 0x51a },
	'aiservotrackingmethod' => { 92 => 0x504 },
	'aiservotrackingsensitivity' => { 91 => 0x14, 92 => 0x502 },
	'aisubjecttrackingmode' => { 347 => 0x309 },
	'aisystemused' => { 550 => 'AISystemUsed' },
	'aisystemversionused' => { 550 => 'AISystemVersionUsed' },
	'album' => { 429 => ['albm',"\xa9alb"], 431 => 'album', 437 => ['albm',"\xa9alb"], 566 => 'album' },
	'albumartist' => { 198 => 'WM/AlbumArtist', 429 => 'aART', 437 => 'albr' },
	'albumcoverurl' => { 198 => 'WM/AlbumCoverURL' },
	'albumid' => { 429 => 'plID' },
	'albumtitle' => { 198 => 'WM/AlbumTitle' },
	'alreadyapplied' => { 536 => 'AlreadyApplied', 538 => 'AlreadyApplied' },
	'alternatetitle' => { 556 => 'alternateTitle' },
	'alternatetitlea-lang' => { 556 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 556 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 556 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 219 => 0x6 },
	'alttapename' => { 566 => 'altTapeName' },
	'alttextaccessibility' => { 549 => 'AltTextAccessibility' },
	'alttimecode' => { 566 => 'altTimecode' },
	'alttimecodetimeformat' => { 566 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 566 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 566 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambientinfrared' => { 440 => 0x5c, 442 => 0x6c },
	'ambientlight' => { 440 => 0x5e, 441 => 0x45, 442 => 0x6e },
	'ambienttemperature' => { 127 => 0x9400, 439 => 0x14, 440 => 0x50, 441 => 0x3a, 442 => 0x60, 443 => 0x46, 507 => 0x4, 543 => 'Temperature' },
	'ambienttemperaturefahrenheit' => { 439 => 0x13, 440 => 0x4e, 441 => 0x38, 442 => 0x5e, 443 => 0x44 },
	'analogbalance' => { 127 => 0xc627 },
	'analogcaptureiso' => { 157 => 0x89e },
	'analogisotable' => { 157 => 0x89d },
	'androidcapturefps' => { 431 => 'com.android.capture.fps' },
	'androidmake' => { 431 => 'com.android.manufacturer' },
	'androidmodel' => { 431 => 'com.android.model' },
	'androidtimezone' => { 431 => 'samsung.android.utc_offset' },
	'androidversion' => { 431 => 'com.android.version' },
	'angleadj' => { 111 => 0x10003, 117 => 0x8b },
	'angleinforoll' => { 532 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 532 => 'AngleInfoYaw' },
	'anti-blur' => { 481 => 0xb04b },
	'antialiasstrength' => { 127 => 0xc632 },
	'antiflicker' => { 62 => 0x20 },
	'antishockwaitingtime' => { 350 => 0x2100 },
	'aperturelock' => { 326 => '38.2', 328 => '38.2', 329 => '38.2', 338 => '38.2', 339 => '38.2', 341 => 0xbc, 342 => 0xb8, 343 => 0xb8, 344 => 0xb8 },
	'aperturemode' => { 437 => 'apmd' },
	'aperturerange' => { 92 => 0x10d },
	'apertureringuse' => { 390 => '1.4' },
	'aperturesetting' => { 203 => 0x7, 467 => 0x30, 468 => 0x29, 469 => 0x1 },
	'aperturevalue' => { 101 => 0x2, 127 => 0x9202, 352 => 0x1002, 420 => 0x401, 542 => 'ApertureValue' },
	'appinfo' => { 140 => 'AppInfo' },
	'appinfoapplication' => { 140 => [\'AppInfo','AppInfoApplication'] },
	'appinfoitemuri' => { 140 => [\'AppInfo','AppInfoItemURI'] },
	'appinfoversion' => { 140 => [\'AppInfo','AppInfoVersion'] },
	'apple_0x004e' => { 1 => 0x4e },
	'apple_0x004f' => { 1 => 0x4f },
	'apple_0x0054' => { 1 => 0x54 },
	'apple_0x005a' => { 1 => 0x5a },
	'applekeywords' => { 357 => 'AAPL:Keywords' },
	'applephotosvariationidentifier' => { 431 => 'apple.photos.variation-identifier' },
	'applestoreaccount' => { 429 => 'apID' },
	'applestoreaccounttype' => { 429 => 'akID' },
	'applestorecatalogid' => { 429 => 'cnID' },
	'applestorecountry' => { 429 => 'sfID' },
	'applicationkeystring' => { 157 => 0x400 },
	'applicationnotes' => { 127 => 0x2bc, 377 => 0x2bc },
	'applicationrecordversion' => { 150 => 0x0 },
	'applyautomatically' => { 362 => 'ApplyAutomatically' },
	'applyshootingmeteringmode' => { 92 => 0x10e },
	'approved' => { 544 => 'Approved' },
	'approvedby' => { 544 => 'ApprovedBy' },
	'approximatefnumber' => { 367 => 0x313, 374 => 0x3406 },
	'approximatefocusdistance' => { 533 => 'ApproximateFocusDistance' },
	'appversion' => { 548 => 'AppVersion' },
	'aps-csizecapture' => { 500 => 0x114, 501 => [0x114,0x1eb,0x1ee,0x21a,0x21c] },
	'aquahsl' => { 111 => 0x20914 },
	'armidentifier' => { 151 => 0x78 },
	'armversion' => { 151 => 0x7a },
	'arranger' => { 429 => "\xa9arg", 437 => "\xa9arg" },
	'arrangerkeywords' => { 437 => "\xa9ark" },
	'artdirector' => { 429 => "\xa9ard" },
	'artfilter' => { 347 => 0x529 },
	'artfiltereffect' => { 347 => 0x52f },
	'artist' => { 127 => 0x13b, 361 => 'Artist', 377 => 0x13b, 411 => 0x22e, 429 => "\xa9ART", 431 => 'artist', 437 => "\xa9ART", 562 => 'Artist', 566 => 'artist' },
	'artistid' => { 429 => 'atID' },
	'artmode' => { 121 => 0x301b },
	'artmodeparameters' => { 121 => 0x310b },
	'artwork' => { 431 => 'artwork' },
	'artworkcircadatecreated' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontentdescription' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworkcontributiondescription' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 550 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworksource' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 550 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 351 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 351 => 0x1112, 411 => 0x80, 467 => 0x55, 468 => 0x55, 469 => 0xa, 494 => [0x192c,0x1a88], 495 => 0x192c, 496 => 0x1958, 497 => 0x192c, 498 => 0x188c },
	'assetid' => { 524 => 'AssetID' },
	'asshoticcprofile' => { 127 => 0xc68f },
	'asshotneutral' => { 127 => 0xc628 },
	'asshotpreprofilematrix' => { 127 => 0xc690 },
	'asshotprofilename' => { 127 => 0xc6f6 },
	'asshotwhitexy' => { 127 => 0xc629 },
	'assignbktbutton' => { 325 => '4.2', 326 => '16.1', 328 => '16.1', 329 => '16.1', 338 => '16.1', 339 => '16.1' },
	'assignfuncbutton' => { 92 => 0x70b },
	'assignmb-d17af-onbutton' => { 329 => '79.1' },
	'assignmb-d17funcbutton' => { 329 => '67.1' },
	'assignmb-d17funcbuttonplusdials' => { 329 => '68.1' },
	'assignmb-d18af-onbutton' => { 339 => '79.1' },
	'assignmb-d18funcbutton' => { 339 => '67.1' },
	'assignmb-d18funcbuttonplusdials' => { 339 => '68.1' },
	'assignmoviefunc1buttonplusdials' => { 328 => '75.1', 329 => '75.1', 339 => '75.1' },
	'assignmoviefunc2button' => { 328 => '82.1', 329 => '82.1', 339 => '82.1' },
	'assignmoviepreviewbuttonplusdials' => { 328 => '75.2', 329 => '75.2', 339 => '75.2' },
	'assignmovierecordbutton' => { 326 => '43.2', 338 => '45.1', 341 => 0x9f, 342 => 0x9b, 343 => 0x9b, 344 => 0x9b },
	'assignmovierecordbuttonplusdials' => { 328 => '45.1', 329 => '45.1', 339 => '45.1' },
	'assignmoviesubselector' => { 328 => '74.1', 329 => '74.1', 339 => '74.1' },
	'assignmoviesubselectorplusdials' => { 328 => '76.1', 329 => '76.1', 339 => '76.1' },
	'assignremotefnbutton' => { 326 => '54.1', 338 => '51.1' },
	'assistbuttonfunction' => { 90 => 0xd },
	'atcaptureusercrop' => { 157 => 0x943 },
	'attributionname' => { 534 => 'attributionName' },
	'attributionurl' => { 534 => 'attributionURL' },
	'audio' => { 372 => 0x20 },
	'audiobitrate' => { 74 => 0x6c, 550 => 'audioBitRate' },
	'audiobitratemode' => { 550 => 'audioBitRateMode' },
	'audiobitspersample' => { 550 => 'audioBitsPerSample' },
	'audiobutton' => { 343 => 0x17b, 344 => 0x193 },
	'audiobuttonplaybackmode' => { 343 => 0x1b9, 344 => 0x1d1 },
	'audiochannelcount' => { 550 => 'audioChannelCount' },
	'audiochannels' => { 74 => 0x70 },
	'audiochanneltype' => { 566 => 'audioChannelType' },
	'audiocompression' => { 92 => 0x816, 174 => 'Compression' },
	'audiocompressor' => { 566 => 'audioCompressor' },
	'audiodata' => { 141 => 'Data' },
	'audioduration' => { 150 => 0x99 },
	'audiogain' => { 428 => 'player.movie.audio.gain', 431 => 'player.movie.audio.gain' },
	'audiomimetype' => { 141 => 'Mime' },
	'audiomoddate' => { 566 => 'audioModDate' },
	'audiooutcue' => { 150 => 0x9a },
	'audiosamplerate' => { 74 => 0x6e, 566 => 'audioSampleRate' },
	'audiosampletype' => { 566 => 'audioSampleType' },
	'audiosamplingrate' => { 150 => 0x97 },
	'audiosamplingresolution' => { 150 => 0x98 },
	'audiotype' => { 150 => 0x96 },
	'author' => { 176 => 'Author', 357 => 'Author', 361 => 'Author', 427 => 'Author', 429 => ['auth',"\xa9aut"], 431 => 'author', 437 => 'auth', 530 => 'author', 552 => 'Author', 564 => 'Author' },
	'authorsposition' => { 554 => 'AuthorsPosition' },
	'authorurl' => { 198 => 'WM/AuthorURL' },
	'autoafpointcolortracking' => { 92 => 0x51c },
	'autoafpointseleositraf' => { 2 => 0xa },
	'autoaperture' => { 401 => '0.1' },
	'autobracket' => { 457 => 0x19 },
	'autobracketing' => { 135 => 0x1100, 411 => 0x18, 447 => 0x1007 },
	'autobracketingmode' => { 337 => '12.3' },
	'autobracketingset' => { 337 => '12.1' },
	'autobracketmodem' => { 325 => '21.2', 326 => '13.3', 328 => '13.2', 329 => '13.2', 334 => '26.2', 338 => '13.3', 339 => '13.2', 341 => 0x63, 342 => 0x5f, 343 => 0x5f, 344 => 0x5f },
	'autobracketorder' => { 203 => 0x43, 325 => '21.3', 326 => '13.2', 328 => '13.1', 329 => '13.1', 334 => '26.3', 335 => '12.2', 336 => '2.2', 337 => '12.2', 338 => '13.2', 339 => '13.1', 340 => '13.2', 341 => 0x65, 342 => 0x61, 343 => 0x61, 344 => 0x61 },
	'autobracketset' => { 325 => '21.1', 326 => '13.1', 330 => '11.1', 331 => '12.1', 332 => '12.1', 334 => '26.1', 335 => '12.1', 336 => '2.1', 338 => '13.1', 340 => '13.1' },
	'autobrightness' => { 536 => 'AutoBrightness', 538 => 'AutoBrightness' },
	'autocapturecriteria' => { 218 => 0x1 },
	'autocapturecriteriamotiondirection' => { 218 => 0x5f },
	'autocapturecriteriamotionsize' => { 218 => 0x64 },
	'autocapturecriteriamotionspeed' => { 218 => 0x63 },
	'autocapturecriteriasubjectsize' => { 218 => 0x69 },
	'autocapturecriteriasubjecttype' => { 218 => 0x6a },
	'autocapturedframe' => { 218 => 0x0 },
	'autocapturedistancefar' => { 218 => 0x4a },
	'autocapturedistancenear' => { 218 => 0x4e },
	'autocapturepreset' => { 269 => 0x746 },
	'autocapturerecordingtime' => { 218 => 0x37 },
	'autocapturewaittime' => { 218 => 0x38 },
	'autocontrast' => { 536 => 'AutoContrast', 538 => 'AutoContrast' },
	'autodistortioncontrol' => { 232 => 0x4, 262 => 0x2cf, 263 => 0x143 },
	'autodynamicrange' => { 135 => 0x140b },
	'autoexposure' => { 536 => 'AutoExposure', 538 => 'AutoExposure' },
	'autoexposurebracketing' => { 84 => 0x10 },
	'autoflashisosensitivity' => { 328 => '38.5', 329 => '38.5', 339 => '38.5', 341 => 0x5f, 342 => 0x5b, 343 => 0x5b, 344 => 0x5b },
	'autofocus' => { 350 => 0x209 },
	'autofocusmoderestrictions' => { 342 => 0x107, 343 => 0x107, 344 => 0x11d },
	'autofp' => { 336 => '7.3', 340 => '31.4' },
	'autoiso' => { 84 => 0x1, 121 => 0x3008, 262 => 0x288, 264 => 0x152, 267 => 0x142, 268 => 0x156, 269 => 0x156, 327 => '1.1', 336 => '1.1' },
	'autoisomax' => { 327 => '1.2', 336 => '1.2' },
	'autoisominshutterspeed' => { 327 => '1.3', 336 => '1.3' },
	'autolateralca' => { 536 => 'AutoLateralCA', 538 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 16 => 0xbe, 17 => 0xbf, 20 => 0xbf, 69 => 0x2, 92 => 0x204, 111 => 0x20500, 117 => 0x6f },
	'autolightingoptimizeron' => { 111 => '0x20500.0', 117 => 0x6e },
	'autoportraitframed' => { 481 => 0x2016 },
	'autoredeye' => { 318 => 0xfe28a44f },
	'autorotate' => { 84 => 0x1b },
	'autoshadows' => { 536 => 'AutoShadows', 538 => 'AutoShadows' },
	'autotone' => { 536 => 'AutoTone', 538 => 'AutoTone' },
	'autotonedigest' => { 536 => 'AutoToneDigest', 538 => 'AutoToneDigest' },
	'autotonedigestnosat' => { 536 => 'AutoToneDigestNoSat', 538 => 'AutoToneDigestNoSat' },
	'autowhiteversion' => { 536 => 'AutoWhiteVersion', 538 => 'AutoWhiteVersion' },
	'auxiliaryimagetype' => { 531 => 'AuxiliaryImageType' },
	'auxiliarylens' => { 258 => 0x82 },
	'avaperturesetting' => { 390 => 0x13 },
	'averageblacklevel' => { 50 => 0xe7, 52 => 0xfb, 53 => 0x114, 54 => 0x146 },
	'averagelv' => { 206 => 0x38 },
	'avsettingwithoutlens' => { 92 => 0x707 },
	'azimuth' => { 184 => 'Azimuth' },
	'babyage' => { 372 => [0x8010,0x33] },
	'babyname' => { 372 => 0x66 },
	'backgroundalpha' => { 561 => 'bgalpha' },
	'balance' => { 428 => 'player.movie.audio.balance', 431 => 'player.movie.audio.balance' },
	'baseexposurecompensation' => { 390 => 0x15 },
	'baseiso' => { 84 => 0x2, 105 => 0x101c, 157 => 0x903, 374 => 0x312a, 513 => 0x6 },
	'baseisodaylight' => { 157 => 0x910 },
	'baseisoflash' => { 157 => 0x913 },
	'baseisofluorescent' => { 157 => 0x912 },
	'baseisotungsten' => { 157 => 0x911 },
	'baselineexposure' => { 127 => 0xc62a },
	'baselineexposureoffset' => { 127 => 0xc7a5 },
	'baselinenoise' => { 127 => 0xc62b },
	'baselinesharpness' => { 127 => 0xc62c },
	'baserenditionishdr' => { 547 => 'BaseRenditionIsHDR' },
	'baseurl' => { 564 => 'BaseURL' },
	'bass' => { 428 => 'player.movie.audio.bass', 431 => 'player.movie.audio.bass' },
	'batterylevel' => { 372 => 0x38, 467 => 0x51, 471 => 0xc, 472 => 0x4, 473 => 0x4, 514 => 0x7, 515 => 0x5 },
	'batterylevel2' => { 515 => 0x7 },
	'batterylevelgrip1' => { 514 => 0x6 },
	'batterylevelgrip2' => { 514 => 0x8 },
	'batteryorder' => { 325 => '12.5', 334 => '13.2', 335 => '2.1', 338 => '3.1' },
	'batterystate' => { 203 => 0x60, 467 => 0x50, 473 => 0x14 },
	'batterytemperature' => { 471 => 0x1, 473 => 0x2, 514 => 0x5 },
	'batterytype' => { 71 => 0x38, 440 => 0x66, 441 => 0x4f, 442 => 0x74 },
	'batteryunknown' => { 471 => 0x2, 473 => 0x0 },
	'batteryvoltage' => { 157 => 0x408, 439 => 0x2a, 440 => 0x62, 441 => 0x4b, 442 => 0x72, 443 => 0x49, 471 => 0x8 },
	'batteryvoltage1' => { 473 => 0x6 },
	'batteryvoltage2' => { 473 => 0x8 },
	'batteryvoltageavg' => { 440 => 0x64, 441 => 0x4d },
	'bayergreensplit' => { 127 => 0xc62d },
	'bayerpattern' => { 156 => 0xf902, 207 => 0x17 },
	'beatsperminute' => { 429 => 'tmpo' },
	'beatspliceparams' => { 566 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 566 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 566 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 566 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 566 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 566 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 325 => '13.1', 326 => '5.4', 327 => '0.1', 330 => '2.1', 331 => '3.1', 332 => '3.1', 334 => '10.1', 336 => '0.1', 338 => '5.5', 340 => '4.1' },
	'beeppitch' => { 335 => '3.1' },
	'beepvolume' => { 335 => '4.5' },
	'bestqualityscale' => { 127 => 0xc65c },
	'bestshotmode' => { 121 => 0x3007 },
	'bitdepth' => { 181 => 'BitDepth', 207 => 0x11, 284 => 0x41 },
	'bitspercomponent' => { 152 => 0x87 },
	'bitspersample' => { 127 => 0x102, 377 => 0xa, 562 => 'BitsPerSample' },
	'blackacquirerows' => { 157 => 0x18ba },
	'blacklevel' => { 127 => [0x7310,0xc61a], 229 => 0x20, 258 => 0x3d, 352 => [0x401,0x1012], 420 => 0x21d, 488 => [0x7300,0x7310] },
	'blacklevel2' => { 351 => 0x600, 355 => 0x600 },
	'blacklevelblue' => { 377 => 0x1e },
	'blacklevelbottom' => { 157 => 0x3f0 },
	'blackleveldata' => { 420 => 0x223 },
	'blackleveldeltah' => { 127 => 0xc61b },
	'blackleveldeltav' => { 127 => 0xc61c },
	'blacklevelgreen' => { 377 => 0x1d },
	'blacklevelred' => { 377 => 0x1c },
	'blacklevelrepeatdim' => { 127 => 0xc619 },
	'blacklevelrough' => { 157 => 0x40e },
	'blacklevelroughafter' => { 157 => 0x416 },
	'blacklevels' => { 39 => 0x1d },
	'blackleveltop' => { 157 => 0x3ef },
	'blackpoint' => { 411 => 0x200 },
	'blacks2012' => { 536 => 'Blacks2012', 538 => 'Blacks2012' },
	'blacksadj' => { 518 => 0x9018 },
	'bleachbypasstoning' => { 411 => 0x7f },
	'blockshotafresponse' => { 328 => '1.5', 329 => '1.5', 339 => '1.5', 341 => 0x7, 342 => 0x7, 343 => 0x7, 344 => 0x7 },
	'blogtitle' => { 556 => 'blogTitle' },
	'blogurl' => { 556 => 'blogURL' },
	'bluebalance' => { 352 => 0x1018, 377 => 0x12, 411 => 0x1b },
	'bluecurvelimits' => { 116 => 0x1fe },
	'bluecurvepoints' => { 115 => 0x79, 116 => 0x1d4 },
	'bluehsl' => { 111 => 0x20915 },
	'bluehue' => { 536 => 'BlueHue', 538 => 'BlueHue' },
	'bluesaturation' => { 536 => 'BlueSaturation', 538 => 'BlueSaturation' },
	'bluetoothfirmwaredate' => { 442 => 0x3a },
	'bluetoothfirmwareversion' => { 442 => 0x34 },
	'bluratinfinity' => { 146 => 'BlurAtInfinity' },
	'blurcontrol' => { 411 => 0x82 },
	'blurwarning' => { 135 => 0x1300 },
	'bodybatteryadload' => { 387 => 0x3 },
	'bodybatteryadnoload' => { 387 => 0x2 },
	'bodybatterypercent' => { 387 => 0x3 },
	'bodybatterystate' => { 387 => ['1.1',0x2] },
	'bodybatteryvoltage' => { 387 => 0x4 },
	'bodybatteryvoltage1' => { 387 => 0x2 },
	'bodybatteryvoltage2' => { 387 => 0x4 },
	'bodybatteryvoltage3' => { 387 => 0x6 },
	'bodybatteryvoltage4' => { 387 => 0x8 },
	'bodyfirmware' => { 448 => 0x0 },
	'bodyfirmwareversion' => { 348 => 0x104, 349 => 0x100, 352 => 0x104 },
	'bodyserialnumber' => { 448 => 0x10 },
	'bookedition' => { 556 => 'bookEdition' },
	'bootloaderversion' => { 443 => 0x26 },
	'bracketbutton' => { 266 => 0x808, 269 => 0x80c },
	'bracketbuttonplaybackmode' => { 266 => 0x810, 269 => 0x816 },
	'bracketincrement' => { 262 => 0x34a, 264 => 0x22e, 267 => 0x21a, 268 => 0x22e, 269 => 0x22e },
	'bracketmode' => { 62 => 0x3 },
	'bracketprogram' => { 262 => 0x348, 264 => 0x22c, 267 => 0x218, 268 => 0x22c, 269 => 0x22c },
	'bracketsequence' => { 121 => 0x301d },
	'bracketset' => { 262 => 0x346, 264 => 0x22a, 267 => 0x216, 268 => 0x22a, 269 => 0x22a },
	'bracketsettings' => { 372 => 0x45 },
	'bracketshotnumber' => { 62 => 0x5, 390 => 0x9, 478 => 0x2b },
	'bracketshotnumber2' => { 478 => 0x2d },
	'bracketstep' => { 200 => 0xe },
	'bracketvalue' => { 62 => 0x4 },
	'brightness' => { 127 => 0xfe53, 175 => 'Brightness', 195 => 'Brightness', 200 => 0x2c, 276 => 0x34, 277 => 0x39, 278 => 0x41, 431 => 'player.movie.visual.brightness', 439 => 0x25, 440 => 0x54, 441 => 0x3e, 442 => 0x64, 467 => 0x22, 481 => 0x2007, 536 => 'Brightness', 538 => 'Brightness' },
	'brightnessadj' => { 116 => 0x114, 311 => 0x0, 321 => 0x2d, 518 => 0x8018 },
	'brightnessvalue' => { 127 => 0x9203, 206 => [0x691,0x49c3], 352 => 0x1003, 486 => 0x1e, 490 => 0x1140, 491 => 0x1140, 492 => 0x111c, 493 => 0x1198, 494 => 0x1174, 495 => 0x102c, 496 => 0x224, 497 => 0x224, 498 => 0x219, 542 => 'BrightnessValue' },
	'buildnumber' => { 210 => 0x5500 },
	'bulbduration' => { 84 => 0x18 },
	'burstcount' => { 157 => 0x40d },
	'burstgroupid' => { 260 => 0x4 },
	'burstid' => { 142 => 'BurstID' },
	'burstmode' => { 159 => 0xa, 372 => 0x2a },
	'burstmode2' => { 159 => 0x18 },
	'burstprimary' => { 142 => 'BurstPrimary' },
	'burstshot' => { 457 => 0x34 },
	'burstspeed' => { 372 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 92 => 0x70a },
	'bwadjustment' => { 135 => 0x1049 },
	'bwfilter' => { 200 => 0x2a, 208 => 0x39 },
	'bwmagentagreen' => { 135 => 0x104b },
	'bwmode' => { 352 => 0x203 },
	'by-line' => { 150 => 0x50 },
	'by-linetitle' => { 150 => 0x55 },
	'bytecount' => { 556 => 'byteCount' },
	'c14configuration' => { 157 => 0x1964 },
	'cacheversion' => { 127 => 0xc7aa },
	'cafarea' => { 394 => 0x2 },
	'cafgridsize' => { 388 => '1.1' },
	'calibratedfocallength' => { 124 => 'CalibratedFocalLength' },
	'calibratedopticalcenterx' => { 124 => 'CalibratedOpticalCenterX' },
	'calibratedopticalcentery' => { 124 => 'CalibratedOpticalCenterY' },
	'calibration' => { 457 => [0x24,0x30] },
	'calibrationhistory' => { 157 => 0x9c9 },
	'calibrationilluminant1' => { 127 => 0xc65a },
	'calibrationilluminant2' => { 127 => 0xc65b },
	'calibrationilluminant3' => { 127 => 0xcd31 },
	'calibrationversion' => { 157 => 0x9c6 },
	'callforimage' => { 524 => 'CallForImage' },
	'camera' => { 140 => [\'Cameras','CamerasCamera'] },
	'cameraangle' => { 437 => 'angl', 566 => 'cameraAngle' },
	'cameraappinfo' => { 140 => [\'Cameras','CamerasCameraAppInfo'] },
	'cameraappinfoapplication' => { 140 => [\'Cameras','CamerasCameraAppInfoApplication'] },
	'cameraappinfoitemuri' => { 140 => [\'Cameras','CamerasCameraAppInfoItemURI'] },
	'cameraappinfoversion' => { 140 => [\'Cameras','CamerasCameraAppInfoVersion'] },
	'cameraburstid' => { 144 => 'CameraBurstID' },
	'cameracalibration' => { 457 => 0x11f },
	'cameracalibration1' => { 127 => 0xc623 },
	'cameracalibration2' => { 127 => 0xc624 },
	'cameracalibration3' => { 127 => 0xcd32 },
	'cameracalibrationsig' => { 127 => 0xc6f3 },
	'cameracolorcalibration01' => { 40 => 0x0, 41 => 0x0 },
	'cameracolorcalibration02' => { 40 => 0x4, 41 => 0x5 },
	'cameracolorcalibration03' => { 40 => 0x8, 41 => 0xa },
	'cameracolorcalibration04' => { 40 => 0xc, 41 => 0xf },
	'cameracolorcalibration05' => { 40 => 0x10, 41 => 0x14 },
	'cameracolorcalibration06' => { 40 => 0x14, 41 => 0x19 },
	'cameracolorcalibration07' => { 40 => 0x18, 41 => 0x1e },
	'cameracolorcalibration08' => { 40 => 0x1c, 41 => 0x23 },
	'cameracolorcalibration09' => { 40 => 0x20, 41 => 0x28 },
	'cameracolorcalibration10' => { 40 => 0x24, 41 => 0x2d },
	'cameracolorcalibration11' => { 40 => 0x28, 41 => 0x32 },
	'cameracolorcalibration12' => { 40 => 0x2c, 41 => 0x37 },
	'cameracolorcalibration13' => { 40 => 0x30, 41 => 0x3c },
	'cameracolorcalibration14' => { 40 => 0x34, 41 => 0x41 },
	'cameracolorcalibration15' => { 40 => 0x38, 41 => 0x46 },
	'cameradepthmap' => { 140 => [\'Cameras','CamerasCameraDepthMap'] },
	'cameradepthmapconfidenceuri' => { 140 => [\'Cameras','CamerasCameraDepthMapConfidenceURI'] },
	'cameradepthmapdepthuri' => { 140 => [\'Cameras','CamerasCameraDepthMapDepthURI'] },
	'cameradepthmapfar' => { 140 => [\'Cameras','CamerasCameraDepthMapFar'] },
	'cameradepthmapfocaltable' => { 140 => [\'Cameras','CamerasCameraDepthMapFocalTable'] },
	'cameradepthmapfocaltableentrycount' => { 140 => [\'Cameras','CamerasCameraDepthMapFocalTableEntryCount'] },
	'cameradepthmapformat' => { 140 => [\'Cameras','CamerasCameraDepthMapFormat'] },
	'cameradepthmapitemsemantic' => { 140 => [\'Cameras','CamerasCameraDepthMapItemSemantic'] },
	'cameradepthmapmeasuretype' => { 140 => [\'Cameras','CamerasCameraDepthMapMeasureType'] },
	'cameradepthmapnear' => { 140 => [\'Cameras','CamerasCameraDepthMapNear'] },
	'cameradepthmapsoftware' => { 140 => [\'Cameras','CamerasCameraDepthMapSoftware'] },
	'cameradepthmapunits' => { 140 => [\'Cameras','CamerasCameraDepthMapUnits'] },
	'cameradirection' => { 431 => 'direction.facing' },
	'camerae-mountversion' => { 517 => 0xb },
	'cameraelevationangle' => { 127 => 0x9405, 543 => 'CameraElevationAngle' },
	'camerafilename' => { 524 => 'CameraFilename' },
	'camerafirmware' => { 127 => 0xa439, 543 => 'CameraFirmware' },
	'cameraid' => { 352 => 0x209, 437 => 'cmid', 456 => 0x209 },
	'cameraidentifier' => { 438 => 'camera.identifier' },
	'cameraimage' => { 140 => [\'Cameras','CamerasCameraImage'] },
	'cameraimageitemsemantic' => { 140 => [\'Cameras','CamerasCameraImageItemSemantic'] },
	'cameraimageitemuri' => { 140 => [\'Cameras','CamerasCameraImageItemURI'] },
	'cameraimagingmodel' => { 140 => [\'Cameras','CamerasCameraImagingModel'] },
	'cameraimagingmodeldistortion' => { 140 => [\'Cameras','CamerasCameraImagingModelDistortion'] },
	'cameraimagingmodeldistortioncount' => { 140 => [\'Cameras','CamerasCameraImagingModelDistortionCount'] },
	'cameraimagingmodelfocallengthx' => { 140 => [\'Cameras','CamerasCameraImagingModelFocalLengthX'] },
	'cameraimagingmodelfocallengthy' => { 140 => [\'Cameras','CamerasCameraImagingModelFocalLengthY'] },
	'cameraimagingmodelimageheight' => { 140 => [\'Cameras','CamerasCameraImagingModelImageHeight'] },
	'cameraimagingmodelimagewidth' => { 140 => [\'Cameras','CamerasCameraImagingModelImageWidth'] },
	'cameraimagingmodelpixelaspectratio' => { 140 => [\'Cameras','CamerasCameraImagingModelPixelAspectRatio'] },
	'cameraimagingmodelprincipalpointx' => { 140 => [\'Cameras','CamerasCameraImagingModelPrincipalPointX'] },
	'cameraimagingmodelprincipalpointy' => { 140 => [\'Cameras','CamerasCameraImagingModelPrincipalPointY'] },
	'cameraimagingmodelskew' => { 140 => [\'Cameras','CamerasCameraImagingModelSkew'] },
	'cameraiso' => { 38 => 0x10 },
	'cameralabel' => { 127 => 0xc7a1, 566 => 'cameraLabel' },
	'cameralightestimate' => { 140 => [\'Cameras','CamerasCameraLightEstimate'] },
	'cameralightestimatecolorcorrectionb' => { 140 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionB'] },
	'cameralightestimatecolorcorrectiong' => { 140 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionG'] },
	'cameralightestimatecolorcorrectionr' => { 140 => [\'Cameras','CamerasCameraLightEstimateColorCorrectionR'] },
	'cameralightestimatepixelintensity' => { 140 => [\'Cameras','CamerasCameraLightEstimatePixelIntensity'] },
	'cameramakemodel' => { 524 => 'CameraMakeModel' },
	'cameramodel' => { 420 => 0x410, 566 => 'cameraModel' },
	'cameramodelid' => { 195 => 'CameraModelID' },
	'cameramodelrestriction' => { 536 => 'CameraModelRestriction', 538 => 'CameraModelRestriction' },
	'cameramotion' => { 431 => 'direction.motion' },
	'cameramove' => { 566 => 'cameraMove' },
	'cameraorientation' => { 7 => 0x30, 9 => 0x7d, 11 => 0x30, 13 => 0x35, 14 => 0x30, 15 => 0x30, 16 => 0x31, 17 => 0x31, 18 => 0x35, 19 => 0x27, 20 => 0x31, 21 => 0x7d, 22 => 0x38, 23 => [0x36,0x3a], 24 => 0x7d, 25 => 0x83, 26 => 0x84, 27 => 0x96, 28 => 0x35, 29 => 0x96, 372 => 0x8f, 410 => 0x1, 415 => 0x1, 420 => 0x100, 473 => [0x16,0x18], 504 => 0x28, 505 => 0x24, 506 => 0x29 },
	'cameraowner' => { 160 => 0xc353 },
	'cameraparameters' => { 352 => 0x2050 },
	'camerapicturestyle' => { 28 => 0xaf },
	'camerapitch' => { 123 => 0x9, 437 => "\xa9gpt" },
	'camerapointcloud' => { 140 => [\'Cameras','CamerasCameraPointCloud'] },
	'camerapointcloudmetric' => { 140 => [\'Cameras','CamerasCameraPointCloudMetric'] },
	'camerapointcloudpointcloud' => { 140 => [\'Cameras','CamerasCameraPointCloudPointCloud'] },
	'camerapointcloudpoints' => { 140 => [\'Cameras','CamerasCameraPointCloudPoints'] },
	'camerapose' => { 140 => [\'Cameras','CamerasCameraPose'] },
	'cameraposepositionx' => { 140 => [\'Cameras','CamerasCameraPosePositionX'] },
	'cameraposepositiony' => { 140 => [\'Cameras','CamerasCameraPosePositionY'] },
	'cameraposepositionz' => { 140 => [\'Cameras','CamerasCameraPosePositionZ'] },
	'cameraposerotationw' => { 140 => [\'Cameras','CamerasCameraPoseRotationW'] },
	'cameraposerotationx' => { 140 => [\'Cameras','CamerasCameraPoseRotationX'] },
	'cameraposerotationy' => { 140 => [\'Cameras','CamerasCameraPoseRotationY'] },
	'cameraposerotationz' => { 140 => [\'Cameras','CamerasCameraPoseRotationZ'] },
	'cameraposetimestamp' => { 140 => [\'Cameras','CamerasCameraPoseTimestamp'] },
	'cameraprofile' => { 536 => 'CameraProfile', 538 => 'CameraProfile' },
	'cameraprofiledigest' => { 536 => 'CameraProfileDigest', 538 => 'CameraProfileDigest' },
	'cameraprofiles' => { 554 => 'CameraProfiles' },
	'cameraprofilesaperturevalue' => { 554 => [\'CameraProfiles','CameraProfilesApertureValue'] },
	'cameraprofilesauthor' => { 554 => [\'CameraProfiles','CameraProfilesAuthor'] },
	'cameraprofilesautoscale' => { 554 => [\'CameraProfiles','CameraProfilesAutoScale'] },
	'cameraprofilescameraprettyname' => { 554 => [\'CameraProfiles','CameraProfilesCameraPrettyName'] },
	'cameraprofilescamerarawprofile' => { 554 => [\'CameraProfiles','CameraProfilesCameraRawProfile'] },
	'cameraprofilesfocallength' => { 554 => [\'CameraProfiles','CameraProfilesFocalLength'] },
	'cameraprofilesfocusdistance' => { 554 => [\'CameraProfiles','CameraProfilesFocusDistance'] },
	'cameraprofileslens' => { 554 => [\'CameraProfiles','CameraProfilesLens'] },
	'cameraprofileslensprettyname' => { 554 => [\'CameraProfiles','CameraProfilesLensPrettyName'] },
	'cameraprofilesmake' => { 554 => [\'CameraProfiles','CameraProfilesMake'] },
	'cameraprofilesmodel' => { 554 => [\'CameraProfiles','CameraProfilesModel'] },
	'cameraprofilesperspectivemodel' => { 554 => [\'CameraProfiles','CameraProfilesPerspectiveModel'] },
	'cameraprofilesperspectivemodelimagexcenter' => { 554 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageXCenter'] },
	'cameraprofilesperspectivemodelimageycenter' => { 554 => [\'CameraProfiles','CameraProfilesPerspectiveModelImageYCenter'] },
	'cameraprofilesperspectivemodelradialdistortparam1' => { 554 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam1'] },
	'cameraprofilesperspectivemodelradialdistortparam2' => { 554 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam2'] },
	'cameraprofilesperspectivemodelradialdistortparam3' => { 554 => [\'CameraProfiles','CameraProfilesPerspectiveModelRadialDistortParam3'] },
	'cameraprofilesperspectivemodelscalefactor' => { 554 => [\'CameraProfiles','CameraProfilesPerspectiveModelScaleFactor'] },
	'cameraprofilesperspectivemodelversion' => { 554 => [\'CameraProfiles','CameraProfilesPerspectiveModelVersion'] },
	'cameraprofilesprofilename' => { 554 => [\'CameraProfiles','CameraProfilesProfileName'] },
	'cameraprofilessensorformatfactor' => { 554 => [\'CameraProfiles','CameraProfilesSensorFormatFactor'] },
	'cameraprofilesuniquecameramodel' => { 554 => [\'CameraProfiles','CameraProfilesUniqueCameraModel'] },
	'camerarawcolortone' => { 117 => 0xe1 },
	'camerarawcontrast' => { 117 => 0xe3 },
	'camerarawhighlightpoint' => { 117 => 0xe6 },
	'camerarawlinear' => { 117 => 0xe4 },
	'camerarawoutputhighlightpoint' => { 117 => 0xe8 },
	'camerarawoutputshadowpoint' => { 117 => 0xe9 },
	'camerarawsaturation' => { 117 => 0xe2 },
	'camerarawshadowpoint' => { 117 => 0xe7 },
	'camerarawsharpness' => { 117 => 0xe5 },
	'cameraroll' => { 123 => 0xb, 437 => "\xa9grl" },
	'cameras' => { 140 => 'Cameras' },
	'cameraserialnumber' => { 127 => 0xc62f, 197 => 'CameraSerialNumber', 524 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 347 => 0x0 },
	'cameratemperature' => { 7 => 0x18, 9 => 0x1b, 11 => 0x18, 13 => 0x19, 14 => 0x18, 15 => 0x18, 16 => 0x19, 17 => 0x19, 18 => 0x19, 19 => 0x17, 20 => 0x19, 21 => 0x1b, 22 => 0x19, 23 => 0x19, 24 => 0x1b, 25 => 0x1b, 26 => 0x1b, 27 => 0x1b, 28 => 0x19, 29 => 0x1b, 31 => [0x87,0x91], 32 => [0x99,0x9f,0xa4,0xa8,0x105], 37 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 84 => 0xc, 157 => 0x406, 351 => 0x1306, 367 => 0x320, 374 => 0x3402, 411 => 0x47, 454 => 0x43, 508 => 0x5 },
	'cameratemperature4' => { 416 => 0x14 },
	'cameratemperature5' => { 416 => 0x16 },
	'cameratemperaturerangemax' => { 129 => 0x5 },
	'cameratemperaturerangemin' => { 129 => 0x6 },
	'cameratrait' => { 140 => [\'Cameras','CamerasCameraTrait'] },
	'cameratype' => { 1 => 0x2e, 84 => 0x1a, 352 => 0x207 },
	'cameratype2' => { 348 => 0x100 },
	'cameravendorinfo' => { 140 => [\'Cameras','CamerasCameraVendorInfo'] },
	'cameravendorinfomanufacturer' => { 140 => [\'Cameras','CamerasCameraVendorInfoManufacturer'] },
	'cameravendorinfomodel' => { 140 => [\'Cameras','CamerasCameraVendorInfoModel'] },
	'cameravendorinfonotes' => { 140 => [\'Cameras','CamerasCameraVendorInfoNotes'] },
	'camerayaw' => { 123 => 0xa, 437 => "\xa9gyw" },
	'camreverse' => { 124 => 'CamReverse' },
	'canondr4' => { 128 => 'CanonDR4' },
	'canonexposuremode' => { 38 => 0x14 },
	'canonfiledescription' => { 105 => 0x805 },
	'canonfilelength' => { 71 => 0xe },
	'canonfirmwareversion' => { 71 => 0x7, 105 => 0x80b },
	'canonflashinfo' => { 105 => 0x1028 },
	'canonflashmode' => { 38 => 0x4 },
	'canonimagesize' => { 10 => 0x39, 38 => 0xa },
	'canonimagetype' => { 71 => 0x6, 105 => 0x815 },
	'canonlogversion' => { 70 => 0xb },
	'canonmodelid' => { 71 => 0x10, 105 => 0x1834 },
	'canonvrd' => { 128 => 'CanonVRD' },
	'caption' => { 530 => 'caption' },
	'caption-abstract' => { 150 => 0x78 },
	'captionsauthornames' => { 541 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 541 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 554 => 'CaptionWriter' },
	'captureframerate' => { 121 => 0x4001 },
	'captureheightnormal' => { 157 => 0x1839 },
	'capturelook' => { 157 => 0xc48 },
	'capturemode' => { 438 => 'com.apple.photos.captureMode' },
	'capturesoftware' => { 148 => 'CaptureSoftware' },
	'capturewidthnormal' => { 157 => 0x1838 },
	'capturewidthtest' => { 157 => 0x1842 },
	'cardshutterlock' => { 203 => 0x49 },
	'caseautosetting' => { 2 => 0x1c },
	'casioimagesize' => { 121 => 0x9 },
	'catalogsets' => { 150 => 0xff, 523 => 'CatalogSets', 528 => 'CatalogSets' },
	'categories' => { 71 => 0x23, 530 => 'categories' },
	'category' => { 150 => 0xf, 198 => 'WM/Category', 345 => 0x30, 429 => 'catg', 554 => 'Category' },
	'cbcrgain' => { 454 => 0xa036 },
	'cbcrgaindefault' => { 454 => 0xa035 },
	'cbcrmatrix' => { 454 => 0xa034 },
	'cbcrmatrixdefault' => { 454 => 0xa033 },
	'ccdboardversion' => { 367 => 0x331 },
	'ccdscanmode' => { 352 => 0x1039 },
	'ccdsensitivity' => { 307 => 0x6 },
	'ccdversion' => { 367 => 0x330 },
	'ccvavgluminancenits' => { 546 => 'ccv_avg_luminance_nits' },
	'ccvmaxluminancenits' => { 546 => 'ccv_max_luminance_nits' },
	'ccvminluminancenits' => { 546 => 'ccv_min_luminance_nits' },
	'ccvprimariesxy' => { 546 => 'ccv_primaries_xy' },
	'ccvwhitexy' => { 546 => 'ccv_white_xy' },
	'cellglobalid' => { 535 => 'cgi' },
	'celllength' => { 127 => 0x109 },
	'cellr' => { 535 => 'r' },
	'celltowerid' => { 535 => 'cellid' },
	'cellwidth' => { 127 => 0x108 },
	'centerafarea' => { 336 => '15.1' },
	'centerfocuspoint' => { 340 => '2.2' },
	'centerpixel' => { 157 => 0x40c },
	'centerweightedareasize' => { 325 => '7.1', 326 => '8.1', 328 => '8.1', 329 => '8.1', 333 => '7.1', 334 => '5.1', 335 => '7.1', 336 => '6.3', 338 => '8.1', 339 => '8.1', 340 => '8.1', 341 => 0x21, 342 => 0x1f, 343 => 0x1f, 344 => 0x1f },
	'certificate' => { 570 => 'Certificate' },
	'cfainterpolationalgorithm' => { 157 => 0xe60 },
	'cfainterpolationmetric' => { 157 => 0xe61 },
	'cfaoffsetcols' => { 157 => 0xc71 },
	'cfaoffsetrows' => { 157 => 0xc6f },
	'cfapattern' => { 127 => 0xa302, 377 => 0x9, 542 => 'CFAPattern' },
	'cfapattern2' => { 127 => 0x828e },
	'cfapatterncolumns' => { 542 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 542 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 542 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 127 => 0x828d },
	'cfazipperfixthreshold' => { 157 => 0xe62 },
	'channel' => { 556 => 'channel' },
	'channela-lang' => { 556 => [\'channel','channelA-lang'] },
	'channelchannel' => { 556 => [\'channel','channelChannel'] },
	'channels' => { 174 => 'Channels' },
	'channelsubchannel1' => { 556 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 556 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 556 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 556 => [\'channel','channelSubchannel4'] },
	'chapterlist' => { 437 => 'chpl' },
	'checkmark' => { 111 => 0x10101, 116 => 0x26a },
	'checkmark2' => { 117 => 0x8e },
	'childfontfiles' => { 571 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 325 => '10.3', 326 => '11.2', 342 => 0x10b, 343 => 0x10b, 344 => 0x121 },
	'chromablurradius' => { 127 => 0xc631 },
	'chromanoisecolorspace' => { 157 => 0xe6d },
	'chromanoiseedgemapthresh' => { 157 => 0xe6c },
	'chromanoisehighfthresh' => { 157 => 0xe6a },
	'chromanoiselowfthresh' => { 157 => 0xe6b },
	'chromaticaberration' => { 111 => 0x20703, 117 => 0x66, 454 => 0xa051 },
	'chromaticaberrationb' => { 536 => 'ChromaticAberrationB', 538 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 111 => 0x20708, 117 => 0x6b },
	'chromaticaberrationcorr' => { 86 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 127 => 0x7034, 400 => 0x1, 518 => 0x900d },
	'chromaticaberrationcorrparams' => { 127 => 0x7035, 512 => 0x66a, 513 => [0x37c,0x384,0x39c,0x3b0,0x3b8] },
	'chromaticaberrationon' => { 111 => '0x20703.0', 117 => 0x62 },
	'chromaticaberrationr' => { 536 => 'ChromaticAberrationR', 538 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 111 => 0x20707, 117 => 0x6a },
	'chromaticaberrationsetting' => { 87 => 0x6 },
	'chrominancenoisereduction' => { 111 => 0x20601, 117 => 0x5e, 457 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 117 => 0x60 },
	'circadatecreated' => { 550 => 'CircaDateCreated' },
	'circgradbasedcorractive' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrblacks2012' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBlacks2012'] },
	'circgradbasedcorrbrightness' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrcorrectionname' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionName'] },
	'circgradbasedcorrcorrectionsyncid' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionSyncID'] },
	'circgradbasedcorrdefringe' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrdehaze' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDehaze'] },
	'circgradbasedcorrexposure' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHue'] },
	'circgradbasedcorrluminancenoise' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskinputdigest' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'circgradbasedcorrmaskleft' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmaskactive' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'circgradbasedcorrmaskmaskblendmode' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmaskdigest' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'circgradbasedcorrmaskmaskinverted' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'circgradbasedcorrmaskmaskname' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskName'] },
	'circgradbasedcorrmaskmasks' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasks'] },
	'circgradbasedcorrmaskmasksalpha' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'circgradbasedcorrmaskmasksangle' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'circgradbasedcorrmaskmasksbottom' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'circgradbasedcorrmaskmaskscentervalue' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'circgradbasedcorrmaskmaskscenterweight' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'circgradbasedcorrmaskmasksdabs' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'circgradbasedcorrmaskmasksfeather' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'circgradbasedcorrmaskmasksflipped' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'circgradbasedcorrmaskmasksflow' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'circgradbasedcorrmaskmasksfullx' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'circgradbasedcorrmaskmasksfully' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'circgradbasedcorrmaskmasksinputdigest' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'circgradbasedcorrmaskmasksleft' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'circgradbasedcorrmaskmasksmaskactive' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'circgradbasedcorrmaskmasksmaskblendmode' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'circgradbasedcorrmaskmasksmaskdigest' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'circgradbasedcorrmaskmasksmaskinverted' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'circgradbasedcorrmaskmasksmaskname' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'circgradbasedcorrmaskmasksmasksubtype' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksmasksyncid' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'circgradbasedcorrmaskmasksmaskversion' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'circgradbasedcorrmaskmasksmidpoint' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'circgradbasedcorrmaskmasksorigin' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'circgradbasedcorrmaskmasksperimetervalue' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'circgradbasedcorrmaskmasksradius' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'circgradbasedcorrmaskmasksreferencepoint' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'circgradbasedcorrmaskmasksright' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'circgradbasedcorrmaskmasksroundness' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'circgradbasedcorrmaskmaskssizex' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'circgradbasedcorrmaskmaskssizey' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'circgradbasedcorrmaskmaskstop' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'circgradbasedcorrmaskmasksubtype' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'circgradbasedcorrmaskmasksvalue' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'circgradbasedcorrmaskmasksversion' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'circgradbasedcorrmaskmaskswhat' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'circgradbasedcorrmaskmaskswholeimagearea' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'circgradbasedcorrmaskmasksx' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksX'] },
	'circgradbasedcorrmaskmasksy' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksY'] },
	'circgradbasedcorrmaskmasksyncid' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'circgradbasedcorrmaskmaskszerox' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'circgradbasedcorrmaskmaskszeroy' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'circgradbasedcorrmaskmaskversion' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'circgradbasedcorrmaskmidpoint' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskorigin' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksOrigin'] },
	'circgradbasedcorrmaskperimetervalue' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskrange' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'circgradbasedcorrmaskrangeareamodels' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrmaskrangeareamodelscolorsampleinfo' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrmaskrangeareamodelscomponents' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrmaskrangecoloramount' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrmaskrangedepthfeather' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrmaskrangedepthmax' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrmaskrangedepthmin' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrmaskrangeinvert' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'circgradbasedcorrmaskrangelumfeather' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrmaskrangeluminancedepthsampleinfo' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrmaskrangelummax' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrmaskrangelummin' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrmaskrangelumrange' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrmaskrangesampletype' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrmaskrangetype' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'circgradbasedcorrmaskrangeversion' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'circgradbasedcorrmaskreferencepoint' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'circgradbasedcorrmaskright' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskwholeimagearea' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'circgradbasedcorrmaskx' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrrangemask' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMask'] },
	'circgradbasedcorrrangemaskareamodels' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'circgradbasedcorrrangemaskareamodelscolorsampleinfo' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'circgradbasedcorrrangemaskareamodelscomponents' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'circgradbasedcorrrangemaskcoloramount' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'circgradbasedcorrrangemaskdepthfeather' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'circgradbasedcorrrangemaskdepthmax' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'circgradbasedcorrrangemaskdepthmin' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'circgradbasedcorrrangemaskinvert' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'circgradbasedcorrrangemasklumfeather' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'circgradbasedcorrrangemaskluminancedepthsampleinfo' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'circgradbasedcorrrangemasklummax' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'circgradbasedcorrrangemasklummin' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'circgradbasedcorrrangemasklumrange' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'circgradbasedcorrrangemasksampletype' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'circgradbasedcorrrangemasktype' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskType'] },
	'circgradbasedcorrrangemaskversion' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'circgradbasedcorrsaturation' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation'] },
	'circgradbasedcorrshadows2012' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtexture' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTexture'] },
	'circgradbasedcorrtint' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrtoninghue' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrtoningsaturation' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrwhat' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circgradbasedcorrwhites2012' => { 536 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'], 538 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalWhites2012'] },
	'circulargradientbasedcorrections' => { 536 => 'CircularGradientBasedCorrections', 538 => 'CircularGradientBasedCorrections' },
	'city' => { 150 => 0x5a, 180 => 'City', 372 => 0x6d, 554 => 'City' },
	'city2' => { 372 => 0x80 },
	'clarity' => { 38 => 0x33, 135 => 0x100f, 277 => 0x35, 278 => 0x3d, 481 => 0x2036, 536 => 'Clarity', 538 => 'Clarity' },
	'clarity2012' => { 536 => 'Clarity2012', 538 => 'Clarity2012' },
	'claritycontrol' => { 411 => 0x96 },
	'classification' => { 437 => 'clsf' },
	'classifystate' => { 150 => 0xe1 },
	'clearretouch' => { 372 => 0x7c },
	'clearretouchvalue' => { 372 => 0xa3 },
	'client' => { 566 => 'client' },
	'clientname' => { 544 => 'ClientName' },
	'clipboardaspectratio' => { 536 => 'ClipboardAspectRatio', 538 => 'ClipboardAspectRatio' },
	'clipboardorientation' => { 536 => 'ClipboardOrientation', 538 => 'ClipboardOrientation' },
	'clipfilename' => { 437 => 'clfn' },
	'clipid' => { 437 => 'clid' },
	'clmodeshootingspeed' => { 325 => '10.2', 326 => '11.3', 328 => '11.2', 329 => '11.2', 334 => '11.2', 335 => '10.2', 338 => '11.2', 339 => '11.2', 340 => '11.1', 341 => 0x3f, 342 => 0x3b, 343 => 0x3b, 344 => 0x3b },
	'cluster' => { 536 => 'Cluster', 538 => 'Cluster' },
	'cmcontrast' => { 355 => 0x2022 },
	'cmddialsreverserotation' => { 341 => 0xbe, 342 => 0xba, 343 => 0xba, 344 => 0xba },
	'cmexposurecompensation' => { 355 => 0x2000 },
	'cmhue' => { 355 => 0x2021 },
	'cmsaturation' => { 355 => 0x2020 },
	'cmsharpness' => { 355 => 0x2023 },
	'cmwhitebalance' => { 355 => 0x2001 },
	'cmwhitebalancecomp' => { 355 => 0x2002 },
	'cmwhitebalancegraypoint' => { 355 => 0x2010 },
	'codec' => { 188 => 'Codec' },
	'codedcharacterset' => { 151 => 0x5a },
	'codeversion' => { 437 => 'cver' },
	'collection' => { 361 => 'Collection' },
	'collectionname' => { 189 => [\'Collections','CollectionsCollectionName'], 437 => 'coll' },
	'collections' => { 189 => 'Collections', 530 => 'collections' },
	'collectionuri' => { 189 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 431 => 'player.movie.visual.color', 555 => 'color' },
	'coloraberrationcontrol' => { 318 => 0xc89224b },
	'coloradjustment' => { 457 => 0x14 },
	'coloradjustmentmode' => { 456 => 0x210 },
	'coloranta' => { 571 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 571 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 571 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 571 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 571 => [\'Colorants','ColorantsCyan'] },
	'colorantgray' => { 571 => [\'Colorants','ColorantsGray'] },
	'colorantgreen' => { 571 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 571 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 571 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 571 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 571 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 571 => 'Colorants' },
	'colorantswatchname' => { 571 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 571 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 571 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 571 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 175 => 'ColorBalance' },
	'colorbalanceadj' => { 318 => 0x76a43202 },
	'colorbalanceblue' => { 200 => 0x1e },
	'colorbalancegreen' => { 200 => 0x1d },
	'colorbalancered' => { 200 => 0x1c },
	'colorbalanceversion' => { 228 => 0x4, 229 => 0x4, 230 => 0x0, 231 => 0x0 },
	'colorblur' => { 117 => 0x65 },
	'colorbluron' => { 111 => 0x20704 },
	'colorbooster' => { 318 => 0x5f0e7d23 },
	'colorboostlevel' => { 312 => 0x1 },
	'colorboosttype' => { 312 => 0x0 },
	'colorchromeeffect' => { 135 => 0x1048 },
	'colorchromefxblue' => { 135 => 0x104e },
	'colorclass' => { 422 => 0xde, 423 => 'ColorClass' },
	'colorcompensationfilter' => { 203 => [0x3a,0x5f], 205 => 0x111, 481 => 0xb022 },
	'colorcompensationfiltercustom' => { 467 => 0xd, 468 => 0xc },
	'colorcompensationfilterset' => { 467 => 0x8, 468 => 0x7, 469 => 0x18, 486 => 0xf },
	'colorcontrol' => { 352 => 0x102b },
	'colorcorrection' => { 518 => 0x8015 },
	'colorcorrectionmatrix' => { 1 => 0x3e },
	'colorcreatoreffect' => { 347 => 0x532 },
	'colordataversion' => { 45 => 0x0, 46 => 0x0, 47 => 0x0, 49 => 0x0, 50 => 0x0, 51 => 0x0, 52 => 0x0, 53 => 0x0, 54 => 0x0, 55 => 0x0 },
	'coloreffect' => { 372 => 0x28 },
	'colorfilter' => { 120 => 0x17, 121 => 0x3017, 200 => 0x29, 208 => [0x38,0x4d,0x4f], 418 => 0x17 },
	'colorgain' => { 284 => 0x51 },
	'colorgradeblending' => { 536 => 'ColorGradeBlending', 538 => 'ColorGradeBlending' },
	'colorgradeglobalhue' => { 536 => 'ColorGradeGlobalHue', 538 => 'ColorGradeGlobalHue' },
	'colorgradegloballum' => { 536 => 'ColorGradeGlobalLum', 538 => 'ColorGradeGlobalLum' },
	'colorgradeglobalsat' => { 536 => 'ColorGradeGlobalSat', 538 => 'ColorGradeGlobalSat' },
	'colorgradehighlightlum' => { 536 => 'ColorGradeHighlightLum', 538 => 'ColorGradeHighlightLum' },
	'colorgrademidtonehue' => { 536 => 'ColorGradeMidtoneHue', 538 => 'ColorGradeMidtoneHue' },
	'colorgrademidtonelum' => { 536 => 'ColorGradeMidtoneLum', 538 => 'ColorGradeMidtoneLum' },
	'colorgrademidtonesat' => { 536 => 'ColorGradeMidtoneSat', 538 => 'ColorGradeMidtoneSat' },
	'colorgradeshadowlum' => { 536 => 'ColorGradeShadowLum', 538 => 'ColorGradeShadowLum' },
	'colorhue' => { 111 => 0x20900, 258 => 0x8d },
	'colorimetricreference' => { 127 => 0xc6bf },
	'colorlabel' => { 541 => 'ColorLabel' },
	'colormatrix' => { 70 => 0xa, 351 => 0x200, 352 => 0x1011, 454 => 0xa030 },
	'colormatrix1' => { 127 => 0xc621, 420 => 0x106 },
	'colormatrix2' => { 127 => 0xc622, 355 => 0x200, 420 => 0x226 },
	'colormatrix3' => { 127 => 0xcd33 },
	'colormatrixa' => { 411 => 0x203 },
	'colormatrixa2' => { 411 => 0x21c },
	'colormatrixadobergb' => { 454 => 0xa032 },
	'colormatrixb' => { 411 => 0x204 },
	'colormatrixb2' => { 411 => 0x21d },
	'colormatrixnumber' => { 352 => 0x1019 },
	'colormatrixsrgb' => { 454 => 0xa031 },
	'colormode' => { 121 => 0x3015, 135 => 0x1210, 159 => 0x66, 200 => 0x28, 203 => 0x16, 205 => 0x101, 206 => 0x36, 208 => 0x7, 258 => 0x3, 307 => 0x4, 372 => 0x32, 457 => 0x2c, 481 => 0xb029, 554 => 'ColorMode' },
	'colormoirereduction' => { 111 => 0x20670, 319 => 0x15 },
	'colormoirereductionmode' => { 319 => 0x5 },
	'colormoirereductionon' => { 111 => '0x20670.0' },
	'colornoisereduction' => { 518 => 0x8029, 536 => 'ColorNoiseReduction', 538 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 536 => 'ColorNoiseReductionDetail', 538 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 319 => 0x18 },
	'colornoisereductionsharpness' => { 319 => 0x1c },
	'colornoisereductionsmoothness' => { 536 => 'ColorNoiseReductionSmoothness', 538 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 131 => 0x2 },
	'colorprofile' => { 200 => 0x33 },
	'colorprofilesettings' => { 347 => 0x539 },
	'colorrepresentation' => { 152 => 0x3c },
	'colorsaturationadj' => { 111 => 0x20305 },
	'colorsequence' => { 152 => 0x41 },
	'colorspace' => { 56 => 0x3, 71 => 0xb4, 105 => 0x10b4, 127 => 0xa001, 154 => 0x3, 181 => 'ColorSpace', 201 => 0x2f, 202 => 0x25, 203 => 0x17, 258 => 0x1e, 347 => 0x507, 411 => 0x37, 454 => 0xa011, 457 => 0xb, 467 => 0x1b, 468 => 0x83, 469 => 0xe, 486 => 0x6, 542 => 'ColorSpace' },
	'colorspace2' => { 70 => 0x9 },
	'colorspecapproximation' => { 154 => 0x2 },
	'colorspecdata' => { 154 => 0x3 },
	'colorspecmethod' => { 154 => 0x0 },
	'colorspecprecedence' => { 154 => 0x1 },
	'colortempasshot' => { 42 => 0x4, 43 => 0x7, 44 => 0x1d, 45 => 0x59, 46 => 0x6d, 47 => 0x6d, 48 => 0x26, 49 => 0x43, 52 => 0x43, 53 => 0x43, 54 => 0x43, 55 => 0x4b },
	'colortempauto' => { 42 => 0x9, 43 => 0xf, 44 => 0x22, 45 => 0x5e, 46 => 0x72, 48 => 0x1c, 49 => 0x48, 52 => 0x48, 53 => 0x48, 54 => 0x48, 55 => 0x50 },
	'colortempcloudy' => { 42 => 0x22, 43 => 0x37, 44 => 0x31, 45 => 0xa4, 46 => 0xdb, 47 => 0x7c, 48 => 0x35, 49 => 0x5c, 52 => 0x75, 53 => 0x8e, 54 => 0x93, 55 => 0x96, 411 => 0x55 },
	'colortempcustom' => { 49 => 0x84 },
	'colortempcustom1' => { 44 => 0x45 },
	'colortempcustom2' => { 44 => 0x4a },
	'colortempdaylight' => { 42 => 0x18, 43 => 0x27, 44 => 0x27, 45 => 0x9a, 46 => 0xd1, 47 => 0x72, 48 => 0x2b, 49 => 0x52, 52 => 0x6b, 53 => 0x84, 54 => 0x89, 55 => 0x8c, 411 => 0x53 },
	'colortemperature' => { 1 => 0x2d, 7 => 0x73, 8 => [0x48,0x4e], 9 => 0xc0, 10 => 0x37, 11 => 0x62, 12 => 0x37, 13 => 0x7c, 14 => 0x73, 15 => 0x73, 16 => 0x77, 17 => 0x73, 18 => 0x7c, 19 => 0x58, 20 => 0x73, 21 => 0xc0, 22 => 0x7f, 23 => 0x7d, 24 => 0xc0, 25 => 0xc6, 26 => 0xc7, 27 => 0x135, 28 => 0x7b, 29 => 0x13a, 71 => 0xae, 81 => 0x9, 105 => 0x10ae, 135 => 0x1005, 157 => 0x846, 175 => 'ColorTemperature', 201 => [0x6e,0x49], 202 => 0x3f, 203 => [0x39,0x5e], 205 => 0x10b, 208 => [0x3c,0x4c,0x4e], 367 => 0x321, 411 => 0x50, 447 => 0x1308, 481 => 0xb021, 536 => 'Temperature', 538 => 'Temperature' },
	'colortemperatureadj' => { 518 => 0x8013 },
	'colortemperatureauto' => { 258 => 0x4f },
	'colortemperaturebg' => { 352 => 0x1013 },
	'colortemperaturecustom' => { 467 => 0xc, 468 => 0xb },
	'colortemperaturerg' => { 352 => 0x1014 },
	'colortemperatureset' => { 467 => 0x7, 468 => 0x6 },
	'colortemperaturesetting' => { 203 => 0x25, 469 => 0x17, 486 => 0xe },
	'colortempflash' => { 42 => 0x36, 43 => 0x57, 44 => 0x40, 45 => 0xb8, 46 => 0xef, 47 => 0x8b, 48 => 0x49, 49 => 0x70, 52 => 0x89, 53 => 0xa2, 54 => 0xa7, 55 => 0xaa, 411 => 0x5a },
	'colortempflashdata' => { 49 => 0x24a },
	'colortempfluorescent' => { 42 => 0x2c, 43 => 0x47, 44 => 0x3b, 45 => 0xae, 46 => 0xe5, 47 => 0x86, 48 => 0x3f, 49 => 0x66, 52 => 0x7f, 53 => 0x98, 54 => 0x9d, 55 => 0xa0 },
	'colortempfluorescentd' => { 411 => 0x57 },
	'colortempfluorescentn' => { 411 => 0x58 },
	'colortempfluorescentw' => { 411 => 0x59 },
	'colortempkelvin' => { 42 => 0x31, 43 => 0x4f, 45 => 0xb3, 46 => 0xea, 48 => 0x44, 49 => 0x6b, 52 => 0x84, 53 => 0x9d, 54 => 0xa2, 55 => 0xa5, 372 => 0x44, 447 => 0x1307 },
	'colortempmeasured' => { 42 => 0xe, 43 => 0x17, 45 => 0x63, 46 => 0x77, 49 => 0x4d, 52 => 0x4d, 53 => 0x4d, 54 => 0x4d, 55 => 0x55 },
	'colortemppc1' => { 48 => 0x94, 49 => 0x75 },
	'colortemppc2' => { 48 => 0x99, 49 => 0x7a },
	'colortemppc3' => { 48 => 0x9e, 49 => 0x7f },
	'colortempshade' => { 42 => 0x1d, 43 => 0x2f, 44 => 0x2c, 45 => 0x9f, 46 => 0xd6, 47 => 0x77, 48 => 0x30, 49 => 0x57, 52 => 0x70, 53 => 0x89, 54 => 0x8e, 55 => 0x91, 411 => 0x54 },
	'colortemptungsten' => { 42 => 0x27, 43 => 0x3f, 44 => 0x36, 45 => 0xa9, 46 => 0xe0, 47 => 0x81, 48 => 0x3a, 49 => 0x61, 52 => 0x7a, 53 => 0x93, 54 => 0x98, 55 => 0x9b, 411 => 0x56 },
	'colortempunknown' => { 42 => 0x13, 43 => 0x1f, 45 => 0x68, 46 => 0x7c, 48 => 0x21, 52 => 0x52, 53 => 0x52, 54 => 0x52, 55 => 0x5a },
	'colortempunknown10' => { 42 => 0x63, 43 => 0x9f, 45 => 0x95, 46 => 0xa9, 47 => 0xb8, 48 => 0x76, 52 => 0xa2, 53 => 0x7f, 54 => 0x7f, 55 => 0x87 },
	'colortempunknown11' => { 42 => 0x68, 43 => 0xa7, 45 => 0xbd, 46 => [0xae,0xb3], 47 => 0xbd, 48 => 0x7b, 52 => 0xa7, 53 => 0xa7, 54 => 0x84, 55 => 0xaf },
	'colortempunknown12' => { 42 => 0x6d, 43 => 0xaf, 45 => 0xc2, 46 => 0xb8, 47 => 0xc2, 48 => 0x80, 52 => 0xac, 53 => 0xac, 54 => 0xac, 55 => 0xb4 },
	'colortempunknown13' => { 42 => 0x72, 43 => 0xb7, 45 => 0xc7, 46 => 0xbd, 47 => 0xc7, 48 => 0x85, 52 => 0xb1, 53 => 0xb1, 54 => 0xb1, 55 => 0xb9 },
	'colortempunknown14' => { 45 => 0xcc, 46 => 0xc2, 47 => 0xcc, 48 => 0x8a, 52 => 0xb6, 53 => 0xb6, 54 => 0xb6, 55 => 0xbe },
	'colortempunknown15' => { 45 => 0xd1, 46 => 0xc7, 47 => 0xd1, 48 => 0x8f, 52 => 0xbb, 53 => 0xbb, 54 => 0xbb, 55 => 0xc3 },
	'colortempunknown16' => { 45 => 0xd6, 46 => 0xcc, 47 => 0xd6, 48 => 0xa3, 53 => 0xc0, 54 => 0xc0, 55 => 0xc8 },
	'colortempunknown17' => { 45 => 0xdb, 46 => 0xf4, 47 => 0xdb, 53 => 0xc5, 54 => 0xc5, 55 => 0xcd },
	'colortempunknown18' => { 45 => 0xe0, 46 => 0xf9, 47 => 0xe0, 53 => 0xca, 54 => 0xca, 55 => 0xd2 },
	'colortempunknown19' => { 45 => 0xe5, 46 => 0xfe, 47 => 0xe5, 53 => 0xcf, 54 => 0xcf, 55 => 0xd7 },
	'colortempunknown2' => { 42 => 0x3b, 43 => 0x5f, 45 => 0x6d, 46 => 0x81, 47 => 0x90, 48 => 0x4e, 52 => 0x57, 53 => 0x57, 54 => 0x57, 55 => 0x5f },
	'colortempunknown20' => { 45 => 0xea, 46 => 0x103, 47 => 0xea, 53 => 0xd4, 54 => 0xd4, 55 => 0xdc },
	'colortempunknown21' => { 45 => 0xef, 46 => 0x108, 47 => 0xef, 54 => 0xd9, 55 => 0xe1 },
	'colortempunknown22' => { 45 => 0xf4, 46 => 0x10d, 47 => 0xf4, 54 => 0xde, 55 => 0xe6 },
	'colortempunknown23' => { 45 => 0xf9, 46 => 0x112, 47 => 0xf9, 54 => 0xe3, 55 => 0xeb },
	'colortempunknown24' => { 45 => 0xfe, 46 => 0x117, 47 => 0xfe, 54 => 0xe8, 55 => 0xf0 },
	'colortempunknown25' => { 45 => 0x103, 46 => 0x11c, 47 => 0x103, 54 => 0xed, 55 => 0xf5 },
	'colortempunknown26' => { 45 => 0x108, 46 => 0x121, 47 => 0x108, 54 => 0xf2, 55 => 0xfa },
	'colortempunknown27' => { 45 => 0x10d, 46 => 0x126, 47 => 0x10d, 54 => 0xf7, 55 => 0xff },
	'colortempunknown28' => { 45 => 0x112, 47 => 0x112, 54 => 0xfc, 55 => 0x104 },
	'colortempunknown29' => { 45 => 0x117, 47 => 0x117, 54 => 0x101, 55 => 0x109 },
	'colortempunknown3' => { 42 => 0x40, 43 => 0x67, 45 => 0x72, 46 => 0x86, 47 => 0x95, 48 => 0x53, 52 => 0x5c, 53 => 0x5c, 54 => 0x5c, 55 => 0x64 },
	'colortempunknown30' => { 47 => 0x11c, 54 => 0x106 },
	'colortempunknown31' => { 47 => 0x121 },
	'colortempunknown32' => { 47 => 0x126 },
	'colortempunknown33' => { 47 => 0x12b },
	'colortempunknown4' => { 42 => 0x45, 43 => 0x6f, 45 => 0x77, 46 => 0x8b, 47 => 0x9a, 48 => 0x58, 52 => 0x61, 53 => 0x61, 54 => 0x61, 55 => 0x69 },
	'colortempunknown5' => { 42 => 0x4a, 43 => 0x77, 45 => 0x7c, 46 => 0x90, 47 => 0x9f, 48 => 0x5d, 52 => 0x66, 53 => 0x66, 54 => 0x66, 55 => 0x6e },
	'colortempunknown6' => { 42 => 0x4f, 43 => 0x7f, 45 => 0x81, 46 => 0x95, 47 => 0xa4, 48 => 0x62, 52 => 0x8e, 53 => 0x6b, 54 => 0x6b, 55 => 0x73 },
	'colortempunknown7' => { 42 => 0x54, 43 => 0x87, 45 => 0x86, 46 => 0x9a, 47 => 0xa9, 48 => 0x67, 52 => 0x93, 53 => 0x70, 54 => 0x70, 55 => 0x78 },
	'colortempunknown8' => { 42 => 0x59, 43 => 0x8f, 45 => 0x8b, 46 => 0x9f, 47 => 0xae, 48 => 0x6c, 52 => 0x98, 53 => 0x75, 54 => 0x75, 55 => 0x7d },
	'colortempunknown9' => { 42 => 0x5e, 43 => 0x97, 45 => 0x90, 46 => 0xa4, 47 => 0xb3, 48 => 0x71, 52 => 0x9d, 53 => 0x7a, 54 => 0x7a, 55 => 0x82 },
	'colortint' => { 371 => 0x35c },
	'colortone' => { 10 => 0x6f, 12 => 0x77, 38 => 0x2a, 56 => 0x2, 70 => 0x8 },
	'colortoneadj' => { 111 => 0x20304, 116 => 0x11e },
	'colortoneauto' => { 78 => 0x9c },
	'colortonefaithful' => { 19 => 0x107, 77 => 0x6c, 78 => 0x6c },
	'colortonelandscape' => { 19 => 0x105, 77 => 0x3c, 78 => 0x3c },
	'colortonemonochrome' => { 77 => 0x84, 78 => 0x84 },
	'colortoneneutral' => { 19 => 0x106, 77 => 0x54, 78 => 0x54 },
	'colortoneportrait' => { 19 => 0x104, 77 => 0x24, 78 => 0x24 },
	'colortonestandard' => { 19 => 0x103, 77 => 0xc, 78 => 0xc },
	'colortoneuserdef1' => { 19 => 0x109, 77 => 0x9c, 78 => 0xb4 },
	'colortoneuserdef2' => { 19 => 0x10a, 77 => 0xb4, 78 => 0xcc },
	'colortoneuserdef3' => { 19 => 0x10b, 77 => 0xcc, 78 => 0xe4 },
	'columninterleavefactor' => { 127 => 0xcd43 },
	'comlenblksize' => { 157 => 0xfde8 },
	'commanddialframeadvancezoom' => { 269 => 0x804 },
	'commanddialplaybackmode' => { 342 => 0x1cb, 343 => 0x1cb, 344 => 0x1e3 },
	'commanddials' => { 336 => '5.1' },
	'commanddialsaperturesetting' => { 325 => '17.3', 326 => '18.3', 328 => '18.3', 329 => '18.3', 334 => '33.3', 335 => '17.3', 338 => '18.3', 339 => '18.3' },
	'commanddialschangemainsub' => { 325 => '17.2', 326 => '18.1', 328 => '18.1', 329 => '18.1', 334 => '33.2', 335 => '17.2', 338 => '18.1', 339 => '18.1' },
	'commanddialsmenuandplayback' => { 325 => '17.4', 326 => '18.2', 328 => '18.2', 329 => '18.2', 334 => '33.4', 335 => '17.4', 338 => '18.2', 339 => '18.2' },
	'commanddialsreverserotation' => { 325 => '17.1', 326 => '6.4', 328 => '6.2', 329 => '6.2', 330 => '16.2', 331 => '17.2', 334 => '33.1', 335 => '17.1', 338 => '6.2', 339 => '6.2', 340 => '18.1' },
	'commanddialvideoplaybackmode' => { 342 => 0x1cd, 344 => 0x1e5 },
	'commanderchannel' => { 336 => '10.2', 337 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 336 => '13.1', 337 => '31.1' },
	'commandergroupa_ttlcomp' => { 340 => '32.1' },
	'commandergroupamanualoutput' => { 336 => '13.2', 337 => '28.2' },
	'commandergroupamode' => { 336 => '11.2', 337 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 336 => '14.1', 337 => '32.1' },
	'commandergroupb_ttlcomp' => { 340 => '33.1' },
	'commandergroupbmanualoutput' => { 336 => '14.2', 337 => '29.2' },
	'commandergroupbmode' => { 336 => '11.3', 337 => '29.1' },
	'commanderinternalflash' => { 336 => '11.1', 337 => '27.1' },
	'commanderinternalmanualoutput' => { 336 => '12.2', 337 => '27.2' },
	'commanderinternalttlchannel' => { 334 => '18.2' },
	'commanderinternalttlcomp' => { 336 => '12.1', 337 => '30.2', 340 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 334 => '20.1', 335 => '26.1' },
	'commanderinternalttlcompgroupa' => { 334 => '21.1', 335 => '27.1' },
	'commanderinternalttlcompgroupb' => { 334 => '22.1', 335 => '28.1' },
	'comment' => { 0 => 0x2, 128 => 'Comment', 176 => 'Comment', 361 => 'Comment', 429 => "\xa9cmt", 431 => 'comment', 437 => "\xa9cmt" },
	'compass' => { 450 => 0x4 },
	'compatiblebrands' => { 431 => 'compatible_brands' },
	'compatibleversion' => { 536 => 'CompatibleVersion', 538 => 'CompatibleVersion' },
	'compilation' => { 429 => 'cpil' },
	'compimageimagespersequence' => { 543 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfImagesInSequences'] },
	'compimagemaxexposureall' => { 543 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfAll'] },
	'compimagemaxexposureused' => { 543 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMaxExposureTimesOfUsed'] },
	'compimageminexposureall' => { 543 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfAll'] },
	'compimageminexposureused' => { 543 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesMinExposureTimesOfUsed'] },
	'compimagenumsequences' => { 543 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesNumberOfSequences'] },
	'compimagesumexposureall' => { 543 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfAll'] },
	'compimagesumexposureused' => { 543 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesSumOfExposureTimesOfUsed'] },
	'compimagetotalexposureperiod' => { 543 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesTotalExposurePeriod'] },
	'compimagevalues' => { 543 => [\'CompositeImageExposureTimes','CompositeImageExposureTimesValues'] },
	'complianceprofile' => { 556 => 'complianceProfile' },
	'componentsconfiguration' => { 127 => 0x9101, 181 => 'Components', 542 => 'ComponentsConfiguration' },
	'componentversion' => { 105 => 0x80c },
	'composer' => { 198 => 'WM/Composer', 429 => ["\xa9com","\xa9wrt"], 437 => ["\xa9com","\xa9wrt"], 566 => 'composer' },
	'composerid' => { 429 => 'cmID' },
	'composerkeywords' => { 437 => "\xa9cok" },
	'compositeimage' => { 127 => 0xa460, 543 => 'CompositeImage' },
	'compositeimagecount' => { 127 => 0xa461, 543 => 'CompositeImageCount' },
	'compositeimagecount1' => { 135 => 0x1151 },
	'compositeimagecount2' => { 135 => 0x1152 },
	'compositeimageexposuretimes' => { 127 => 0xa462, 543 => 'CompositeImageExposureTimes' },
	'compositeimagemode' => { 135 => 0x1150 },
	'composition' => { 524 => 'Composition' },
	'compositionadjust' => { 409 => '0.1' },
	'compositionadjustrotation' => { 409 => 0x7 },
	'compositionadjustx' => { 409 => 0x5 },
	'compositionadjusty' => { 409 => 0x6 },
	'compressedbitsperpixel' => { 127 => 0x9102, 542 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 205 => 0x40, 352 => 0x40 },
	'compression' => { 127 => 0x103, 377 => 0xb, 562 => 'Compression' },
	'compressionfactor' => { 347 => 0x50d },
	'compressionformat' => { 70 => 0x4 },
	'compressionratio' => { 181 => 'Compression', 352 => 0x1034 },
	'compressorversion' => { 437 => 'CNCV' },
	'condadobvfactor' => { 157 => 0xf3e },
	'condadodaybvthresh' => { 157 => 0xf3c },
	'condadodayoffsets' => { 157 => 0xf42 },
	'condadofluoffsets' => { 157 => 0xf44 },
	'condadofluthresh' => { 157 => 0xf41 },
	'condadoillfactor' => { 157 => 0xf3f },
	'condadoneurange' => { 157 => 0xf3d },
	'condadotunoffsets' => { 157 => 0xf43 },
	'condadotunthresh' => { 157 => 0xf40 },
	'conductor' => { 198 => 'WM/Conductor', 429 => "\xa9con" },
	'confidence' => { 145 => 'Confidence' },
	'confidencelevel' => { 532 => 'ConfidenceLevel' },
	'confidencemime' => { 145 => 'ConfidenceMime' },
	'constrainedcropheight' => { 116 => 0x266, 422 => 0xd6 },
	'constrainedcropwidth' => { 116 => 0x262, 422 => 0xd5 },
	'contact' => { 150 => 0x76 },
	'contactinfo' => { 536 => 'ContactInfo', 538 => 'ContactInfo', 555 => 'contactInfo' },
	'container' => { 140 => 'Container' },
	'containerdirectory' => { 140 => [\'Container','ContainerDirectory'], 143 => 'Directory' },
	'containerdirectoryitem' => { 140 => [\'Container','ContainerDirectoryItem'] },
	'containerdirectoryitemdatauri' => { 140 => [\'Container','ContainerDirectoryItemDataURI'] },
	'containerdirectoryitemlength' => { 140 => [\'Container','ContainerDirectoryItemLength'] },
	'containerdirectoryitemmime' => { 140 => [\'Container','ContainerDirectoryItemMime'] },
	'containerdirectoryitempadding' => { 140 => [\'Container','ContainerDirectoryItemPadding'] },
	'containerformat' => { 550 => 'ContainerFormat' },
	'containerformatidentifier' => { 550 => [\'ContainerFormat','ContainerFormatIdentifier'] },
	'containerformatname' => { 550 => [\'ContainerFormat','ContainerFormatName'] },
	'contentcreatedate' => { 429 => "\xa9day", 437 => ['@day',"\xa9day"] },
	'contentdistributor' => { 198 => 'WM/ContentDistributor' },
	'contentdistributorid' => { 437 => 'cdis' },
	'contentid' => { 437 => 'ccid' },
	'contentidentifier' => { 1 => 0x11, 431 => 'content.identifier' },
	'contentlocationcode' => { 150 => 0x1a },
	'contentlocationname' => { 150 => 0x1b },
	'contenttype' => { 556 => 'contentType' },
	'continuousbracketing' => { 203 => 0x20 },
	'continuousdrive' => { 38 => 0x5 },
	'continuousmodedisplay' => { 341 => 0x55, 342 => 0x51, 343 => 0x51, 344 => 0x51 },
	'continuousmodeliveview' => { 339 => '77.2' },
	'continuousshootingspeed' => { 92 => 0x610 },
	'continuousshotlimit' => { 92 => 0x611 },
	'contrast' => { 10 => 0x73, 12 => 0x75, 38 => 0xd, 120 => 0xc, 121 => [0x3012,0x20], 127 => [0xa408,0xfe54], 135 => [0x1004,0x1006], 175 => 'Contrast', 195 => 'Contrast', 200 => 0x20, 201 => 0x31, 202 => 0x27, 203 => 0x19, 208 => 0x2, 276 => 0x33, 277 => 0x37, 278 => 0x3f, 352 => 0x1029, 372 => 0x39, 374 => 0x300a, 411 => 0x20, 418 => 0xc, 431 => 'player.movie.visual.contrast', 439 => 0x24, 440 => 0x52, 441 => 0x3c, 442 => 0x62, 447 => 0x1012, 457 => 0xd, 467 => 0x1d, 468 => 0x1a, 481 => 0x2004, 536 => 'Contrast', 538 => 'Contrast', 542 => 'Contrast' },
	'contrast2012' => { 536 => 'Contrast2012', 538 => 'Contrast2012' },
	'contrastadj' => { 111 => 0x20303, 116 => 0x115, 321 => 0x2c, 518 => 0x8017 },
	'contrastauto' => { 78 => 0x90 },
	'contrastcurve' => { 258 => 0x8c },
	'contrastdetectafarea' => { 411 => 0x231 },
	'contrastdetectafinfocus' => { 212 => 0x1c, 213 => [0x1c,0x52] },
	'contrastfaithful' => { 19 => 0xec, 77 => 0x60, 78 => 0x60 },
	'contrasthighlight' => { 411 => 0x6d },
	'contrasthighlightshadowadj' => { 411 => 0x6f },
	'contrastlandscape' => { 19 => 0xea, 77 => 0x30, 78 => 0x30 },
	'contrastmode' => { 372 => 0x2c },
	'contrastmonochrome' => { 19 => 0xed, 77 => 0x78, 78 => 0x78 },
	'contrastneutral' => { 19 => 0xeb, 77 => 0x48, 78 => 0x48 },
	'contrastportrait' => { 19 => 0xe9, 77 => 0x18, 78 => 0x18 },
	'contrastsetting' => { 347 => 0x505, 355 => 0x1012, 469 => 0x10, 486 => 0x8 },
	'contrastshadow' => { 411 => 0x6e },
	'contraststandard' => { 19 => 0xe8, 77 => 0x0, 78 => 0x0 },
	'contrastuserdef1' => { 19 => 0xee, 77 => 0x90, 78 => 0xa8 },
	'contrastuserdef2' => { 19 => 0xef, 77 => 0xa8, 78 => 0xc0 },
	'contrastuserdef3' => { 19 => 0xf0, 77 => 0xc0, 78 => 0xd8 },
	'contributedmedia' => { 566 => 'contributedMedia' },
	'contributedmediaduration' => { 566 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 566 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 566 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 566 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 566 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 566 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 566 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 566 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 566 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 566 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 539 => 'contributor', 550 => 'Contributor' },
	'contributoridentifier' => { 550 => [\'Contributor','ContributorIdentifier'] },
	'contributorname' => { 550 => [\'Contributor','ContributorName'] },
	'contributorrole' => { 550 => [\'Contributor','ContributorRole'] },
	'contributors' => { 176 => 'Contributors' },
	'controldialset' => { 203 => 0x46 },
	'controlledvocabularyterm' => { 550 => 'CVterm' },
	'controllerboardversion' => { 367 => 0x332 },
	'controlmode' => { 84 => 0x12 },
	'controlringresponse' => { 341 => 0x1cf, 342 => 0x1d5, 343 => 0x1d5, 344 => 0x1ed },
	'controlringrotation' => { 92 => 0x712 },
	'conversionlens' => { 348 => 0x403, 372 => 0x35 },
	'converter' => { 127 => 0xfe4d, 307 => 0xb, 536 => 'Converter', 538 => 'Converter' },
	'converttograyscale' => { 536 => 'ConvertToGrayscale', 538 => 'ConvertToGrayscale' },
	'cookingequipment' => { 558 => 'cookingEquipment' },
	'cookingmethod' => { 558 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 127 => 0x8298, 176 => 'Copyright', 361 => 'Copyright', 377 => 0x8298, 411 => 0x22f, 427 => 'Copyright', 429 => ['cprt',"\xa9cpy"], 431 => 'copyright', 437 => ['cprt',"\xa9cpy"], 536 => 'Copyright', 538 => 'Copyright', 552 => 'Copyright', 559 => 'copyright', 562 => 'Copyright', 566 => 'copyright' },
	'copyrightflag' => { 425 => 0x40a },
	'copyrightnotice' => { 150 => 0x74 },
	'copyrightowner' => { 358 => 'CopyrightOwner' },
	'copyrightownerid' => { 358 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 358 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 358 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 358 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 358 => 'CopyrightStatus' },
	'copyrightyear' => { 550 => 'CopyrightYear', 556 => 'copyrightYear' },
	'coringfilter' => { 351 => 0x310, 352 => 0x102d, 355 => 0x310 },
	'coringvalues' => { 351 => 0x311, 355 => 0x311 },
	'corporateentity' => { 556 => 'corporateEntity' },
	'correctionalreadyapplied' => { 362 => 'CorrectionAlreadyApplied' },
	'correlatedcolortemp' => { 371 => 0x35b },
	'country' => { 180 => 'Country', 372 => 0x69, 554 => 'Country' },
	'country-primarylocationcode' => { 150 => 0x64 },
	'country-primarylocationname' => { 150 => 0x65 },
	'countrycode' => { 257 => 0x5, 423 => 'CountryCode', 549 => 'CountryCode' },
	'course' => { 558 => 'course' },
	'coverage' => { 539 => 'coverage' },
	'coverart' => { 429 => 'covr' },
	'coverdate' => { 556 => 'coverDate' },
	'coverdisplaydate' => { 556 => 'coverDisplayDate' },
	'coveruri' => { 437 => 'cvru' },
	'cpufirmwareversion' => { 411 => 0x28 },
	'crc32' => { 540 => 'crc32' },
	'createdate' => { 127 => 0x9004, 176 => 'CreateDate', 357 => 'CreationDate', 361 => 'create-date', 427 => 'CreationDate', 434 => 0x1, 564 => 'CreateDate' },
	'creationdate' => { 431 => 'creationdate', 552 => 'CreationDate', 556 => 'creationDate' },
	'creationtime' => { 361 => 'Creation Time', 431 => 'creation_time' },
	'creativestyle' => { 467 => 0x1a, 468 => 0x18, 478 => 0x41, 481 => 0xb020, 513 => 0x4a },
	'creativestylesetting' => { 469 => 0xf, 486 => 0x7 },
	'creativestylewaschanged' => { 518 => 0x8001 },
	'creator' => { 357 => 'Creator', 427 => 'Creator', 539 => 'creator', 550 => 'Creator', 552 => 'Creator' },
	'creatoraddress' => { 549 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorappid' => { 197 => 'CreatorAppId' },
	'creatorcity' => { 549 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 549 => 'CreatorContactInfo' },
	'creatorcountry' => { 549 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatoridentifier' => { 550 => [\'Creator','CreatorIdentifier'] },
	'creatoridentity' => { 423 => 'CreatorIdentity' },
	'creatorname' => { 550 => [\'Creator','CreatorName'] },
	'creatoropenwithuioptions' => { 197 => 'CreatorOpenWithUIOptions' },
	'creatorpostalcode' => { 549 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 549 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatorrole' => { 550 => [\'Creator','CreatorRole'] },
	'creatortool' => { 564 => 'CreatorTool' },
	'creatorworkemail' => { 549 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 549 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 549 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 150 => 0x6e, 554 => 'Credit' },
	'creditline' => { 559 => 'creditLine' },
	'creditlinereq' => { 569 => 'CreditLineReq' },
	'creditlinerequired' => { 358 => 'CreditLineRequired' },
	'cropactive' => { 109 => 0x0, 116 => 0x244 },
	'cropangle' => { 109 => 0x8, 536 => 'CropAngle', 538 => 'CropAngle' },
	'croparea' => { 258 => 0x45, 518 => 0x9011 },
	'cropaspectratio' => { 111 => 0x30101, 116 => 0x260 },
	'cropaspectratiocustom' => { 111 => 0x30102 },
	'cropbottom' => { 131 => 0x9, 313 => 0x36, 377 => 0x31, 422 => 0xdc, 536 => 'CropBottom', 538 => 'CropBottom' },
	'cropbottommargin' => { 58 => 0x3 },
	'cropcircleactive' => { 117 => 0xd6 },
	'cropcircleradius' => { 117 => 0xd9 },
	'cropcirclex' => { 117 => 0xd7 },
	'cropcircley' => { 117 => 0xd8 },
	'cropconstraintowarp' => { 536 => 'CropConstrainToWarp', 538 => 'CropConstrainToWarp' },
	'cropflag' => { 135 => 0x1051 },
	'croph' => { 529 => 'CropH' },
	'cropheight' => { 109 => 0x6, 116 => 0x24c, 351 => 0x615, 355 => 0x615, 536 => 'CropHeight', 538 => 'CropHeight' },
	'crophispeed' => { 258 => 0x1b },
	'cropleft' => { 116 => 0x246, 131 => 0x6, 313 => 0x1e, 351 => 0x612, 355 => 0x612, 377 => 0x30, 422 => 0xd9, 536 => 'CropLeft', 538 => 'CropLeft' },
	'cropleftmargin' => { 58 => 0x0 },
	'cropmode' => { 135 => 0x104d, 447 => 0x1018 },
	'croporiginalheight' => { 109 => 0xb },
	'croporiginalwidth' => { 109 => 0xa },
	'cropoutputheight' => { 313 => 0xce },
	'cropoutputheightinches' => { 313 => 0x96 },
	'cropoutputpixels' => { 313 => 0xd6 },
	'cropoutputresolution' => { 313 => 0xb6 },
	'cropoutputscale' => { 313 => 0xbe },
	'cropoutputwidth' => { 313 => 0xc6 },
	'cropoutputwidthinches' => { 313 => 0x8e },
	'croppedareaimageheightpixels' => { 148 => 'CroppedAreaImageHeightPixels', 149 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 148 => 'CroppedAreaImageWidthPixels', 149 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 148 => 'CroppedAreaLeftPixels', 149 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 148 => 'CroppedAreaTopPixels', 149 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 447 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 447 => 0x1603 },
	'cropping' => { 518 => 0x9010 },
	'cropright' => { 131 => 0x8, 313 => 0x2e, 377 => 0x32, 422 => 0xdb, 536 => 'CropRight', 538 => 'CropRight' },
	'croprightmargin' => { 58 => 0x1 },
	'croprotatedoriginalheight' => { 109 => 0x2 },
	'croprotatedoriginalwidth' => { 109 => 0x1 },
	'croprotation' => { 109 => 0x7, 131 => 0xb },
	'cropscaledresolution' => { 313 => 0x9e },
	'cropsize' => { 135 => 0x1053 },
	'cropsourceresolution' => { 313 => 0xae },
	'croptop' => { 116 => 0x248, 131 => 0x7, 313 => 0x26, 351 => 0x613, 355 => 0x613, 377 => 0x2f, 422 => 0xda, 536 => 'CropTop', 538 => 'CropTop' },
	'croptopleft' => { 135 => 0x1052 },
	'croptopmargin' => { 58 => 0x2 },
	'cropunit' => { 536 => 'CropUnit', 538 => 'CropUnit' },
	'cropunits' => { 536 => 'CropUnits', 538 => 'CropUnits' },
	'cropw' => { 529 => 'CropW' },
	'cropwidth' => { 109 => 0x5, 116 => 0x24a, 351 => 0x614, 355 => 0x614, 536 => 'CropWidth', 538 => 'CropWidth' },
	'cropx' => { 109 => 0x3, 529 => 'CropX' },
	'cropy' => { 109 => 0x4, 529 => 'CropY' },
	'crossprocess' => { 411 => 0x7b },
	'crossprocessparams' => { 411 => 0x235 },
	'cuisine' => { 558 => 'cuisine' },
	'currenticcprofile' => { 127 => 0xc691 },
	'currentpreprofilematrix' => { 127 => 0xc692 },
	'currentversion' => { 518 => 0xd000 },
	'curve0x' => { 529 => 'Curve0x' },
	'curve0y' => { 529 => 'Curve0y' },
	'curve1x' => { 529 => 'Curve1x' },
	'curve1y' => { 529 => 'Curve1y' },
	'curve2x' => { 529 => 'Curve2x' },
	'curve2y' => { 529 => 'Curve2y' },
	'curve3x' => { 529 => 'Curve3x' },
	'curve3y' => { 529 => 'Curve3y' },
	'curve4x' => { 529 => 'Curve4x' },
	'curve4y' => { 529 => 'Curve4y' },
	'curves' => { 318 => 0x76a43201 },
	'custom1' => { 358 => 'Custom1' },
	'custom10' => { 358 => 'Custom10' },
	'custom2' => { 358 => 'Custom2' },
	'custom3' => { 358 => 'Custom3' },
	'custom4' => { 358 => 'Custom4' },
	'custom5' => { 358 => 'Custom5' },
	'custom6' => { 358 => 'Custom6' },
	'custom7' => { 358 => 'Custom7' },
	'custom8' => { 358 => 'Custom8' },
	'custom9' => { 358 => 'Custom9' },
	'customcolortone' => { 117 => 0x4c },
	'customcontrast' => { 117 => 0x4e },
	'customcontrols' => { 92 => 0x70c },
	'customdefaultunsharpfineness' => { 117 => 0xbe },
	'customdefaultunsharpstrength' => { 117 => 0xbc },
	'customdefaultunsharpthreshold' => { 117 => 0xc0 },
	'customilluminant' => { 157 => 0x405 },
	'customizedials' => { 92 => 0x715 },
	'customlinear' => { 117 => 0x4f },
	'customoutputhighlightpoint' => { 117 => 0x53 },
	'customoutputshadowpoint' => { 117 => 0x54 },
	'custompicturestyle' => { 111 => 0x10021 },
	'custompicturestyledata' => { 111 => 0xf0500 },
	'custompicturestylefilename' => { 71 => 0x4010 },
	'customrawhighlight' => { 117 => 0x7c },
	'customrawhighlightpoint' => { 117 => 0x51 },
	'customrawshadow' => { 117 => 0x85 },
	'customrawshadowpoint' => { 117 => 0x52 },
	'customrendered' => { 127 => 0xa401, 210 => 0x6420, 542 => 'CustomRendered' },
	'customsaturation' => { 117 => 0x4d, 347 => 0x503 },
	'customsettingsalldefault' => { 325 => '0.2', 334 => '0.2' },
	'customsettingsbank' => { 325 => '0.1', 326 => '0.1', 328 => '0.1', 329 => '0.1', 334 => '0.1', 338 => '0.2', 339 => '0.2', 342 => 0x1, 343 => 0x1, 344 => 0x1 },
	'customsharpness' => { 117 => 0x50 },
	'customunsharpmaskfineness' => { 117 => 0xb8 },
	'customunsharpmaskstrength' => { 117 => 0xb6 },
	'customunsharpmaskthreshold' => { 117 => 0xba },
	'customwb_rblevels' => { 486 => 0x1a },
	'customwb_rgblevels' => { 468 => 0x8, 469 => 0x19 },
	'customwbbluelevel' => { 203 => 0x36 },
	'customwberror' => { 203 => 0x37 },
	'customwbgreenlevel' => { 203 => 0x35 },
	'customwbredlevel' => { 203 => 0x34 },
	'customwbsetting' => { 203 => 0x26 },
	'cx' => { 437 => '_cx_' },
	'cy' => { 437 => '_cy_' },
	'd-lightinghq' => { 318 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 314 => 0x2 },
	'd-lightinghqhighlight' => { 314 => 0x1 },
	'd-lightinghqselected' => { 318 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 314 => 0x0 },
	'd-lightinghs' => { 318 => 0xce5554aa },
	'd-lightinghsadjustment' => { 315 => 0x0 },
	'd-lightinghscolorboost' => { 315 => 0x1 },
	'd-rangeoptimizerhighlight' => { 518 => 0x8024 },
	'd-rangeoptimizermode' => { 518 => 0x8022 },
	'd-rangeoptimizershadow' => { 518 => 0x802d },
	'd-rangeoptimizervalue' => { 518 => 0x8023 },
	'darkblacksegrows' => { 157 => 0x18d8 },
	'darkfocusenvironment' => { 372 => 0x8003 },
	'darkframecountfactor' => { 157 => 0xc85 },
	'darkframelongexposure' => { 157 => 0xc84 },
	'darkframeshortexposure' => { 157 => 0xc83 },
	'darkpedestal' => { 157 => 0xc7f },
	'datacompressionmethod' => { 152 => 0x6e },
	'dataimprint' => { 200 => 0x34 },
	'datamining' => { 358 => 'DataMining' },
	'dataonscreen' => { 550 => 'DataOnScreen' },
	'dataonscreenregion' => { 550 => [\'DataOnScreen','DataOnScreenRegion'] },
	'dataonscreenregiond' => { 550 => [\'DataOnScreen','DataOnScreenRegionD'] },
	'dataonscreenregionh' => { 550 => [\'DataOnScreen','DataOnScreenRegionH'] },
	'dataonscreenregiontext' => { 550 => [\'DataOnScreen','DataOnScreenRegionText'] },
	'dataonscreenregionunit' => { 550 => [\'DataOnScreen','DataOnScreenRegionUnit'] },
	'dataonscreenregionw' => { 550 => [\'DataOnScreen','DataOnScreenRegionW'] },
	'dataonscreenregionx' => { 550 => [\'DataOnScreen','DataOnScreenRegionX'] },
	'dataonscreenregiony' => { 550 => [\'DataOnScreen','DataOnScreenRegionY'] },
	'datascaling' => { 411 => 0x3d },
	'date' => { 411 => 0x6, 539 => 'date' },
	'dateacquired' => { 197 => 'DateAcquired', 198 => '{2CBAA8F5-D81F-47CA-B17A-F8D822300131} 100' },
	'datecreated' => { 150 => 0x37, 554 => 'DateCreated' },
	'datedisplayformat' => { 310 => 0x3 },
	'dateidentified' => { 126 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 330 => '4.2' },
	'daterecieved' => { 556 => 'dateRecieved' },
	'datesent' => { 151 => 0x46 },
	'datestampmode' => { 71 => 0x1c, 258 => 0x9d },
	'datetime' => { 530 => 'datetime', 562 => 'DateTime' },
	'datetimedigitized' => { 542 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 108 => 0x0, 127 => 0x9003, 173 => 0x14, 176 => 'OriginalDate', 432 => 'IDIT', 437 => 'date', 439 => 0xb, 440 => 0x3e, 441 => 0x2f, 442 => 0x4e, 443 => 0x3b, 542 => 'DateTimeOriginal' },
	'datetimestamp' => { 159 => 0x64 },
	'datetimeutc' => { 347 => 0x908 },
	'daylightsavings' => { 85 => 0x3, 310 => 0x2 },
	'dayofweek' => { 440 => 0x4a, 441 => 0x36, 442 => 0x5a, 443 => 0x42 },
	'dccontinent' => { 126 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 126 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 126 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 126 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 126 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 126 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 126 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 126 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 126 => 'Event' },
	'dcfootprintspatialfit' => { 126 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 126 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 126 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 126 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 126 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 126 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 126 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 126 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 126 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 126 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 126 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 126 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 126 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 126 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 126 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 126 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 126 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 126 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 126 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 126 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 126 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 126 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 126 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 126 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 126 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 126 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 126 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 126 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 126 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 126 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 126 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 126 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 126 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 126 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 126 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 126 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcverticaldatum' => { 126 => [\'dctermsLocation','dctermsLocationVerticalDatum'] },
	'dcwaterbody' => { 126 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 184 => 'Declination' },
	'decposition' => { 200 => 0x32 },
	'defaultautogray' => { 536 => 'DefaultAutoGray', 538 => 'DefaultAutoGray' },
	'defaultautotone' => { 536 => 'DefaultAutoTone', 538 => 'DefaultAutoTone' },
	'defaultblackrender' => { 127 => 0xc7a6 },
	'defaultcroporigin' => { 127 => 0xc61f },
	'defaultcropsize' => { 127 => 0xc620 },
	'defaulteraseoption' => { 92 => 0x813 },
	'defaultscale' => { 127 => 0xc61e },
	'defaultsspecifictoiso' => { 536 => 'DefaultsSpecificToISO', 538 => 'DefaultsSpecificToISO' },
	'defaultsspecifictoserial' => { 536 => 'DefaultsSpecificToSerial', 538 => 'DefaultsSpecificToSerial' },
	'defaultusercrop' => { 127 => 0xc7b5 },
	'defectisocode' => { 157 => 0x90f },
	'defringe' => { 536 => 'Defringe', 538 => 'Defringe' },
	'defringegreenamount' => { 536 => 'DefringeGreenAmount', 538 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 536 => 'DefringeGreenHueHi', 538 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 536 => 'DefringeGreenHueLo', 538 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 536 => 'DefringePurpleAmount', 538 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 536 => 'DefringePurpleHueHi', 538 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 536 => 'DefringePurpleHueLo', 538 => 'DefringePurpleHueLo' },
	'dehaze' => { 536 => 'Dehaze', 538 => 'Dehaze' },
	'deletedimagecount' => { 258 => 0xa6, 289 => 0x6e },
	'deprecatedon' => { 534 => 'deprecatedOn' },
	'depthbasedcorrcorrectionactive' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionActive'] },
	'depthbasedcorrcorrectionamount' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionAmount'] },
	'depthbasedcorrcorrectionsyncid' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionSyncID'] },
	'depthbasedcorrections' => { 536 => 'DepthBasedCorrections', 538 => 'DepthBasedCorrections' },
	'depthbasedcorrlocalcorrecteddepth' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCorrectedDepth'] },
	'depthbasedcorrlocalcurverefinesaturation' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsLocalCurveRefineSaturation'] },
	'depthbasedcorrmask' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasks'] },
	'depthbasedcorrmaskalpha' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAlpha'] },
	'depthbasedcorrmaskangle' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksAngle'] },
	'depthbasedcorrmaskbottom' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksBottom'] },
	'depthbasedcorrmaskcentervalue' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterValue'] },
	'depthbasedcorrmaskcenterweight' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCenterWeight'] },
	'depthbasedcorrmaskdabs' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksDabs'] },
	'depthbasedcorrmaskfeather' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFeather'] },
	'depthbasedcorrmaskflipped' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlipped'] },
	'depthbasedcorrmaskflow' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFlow'] },
	'depthbasedcorrmaskfullx' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullX'] },
	'depthbasedcorrmaskfully' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksFullY'] },
	'depthbasedcorrmaskinputdigest' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksInputDigest'] },
	'depthbasedcorrmaskleft' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksLeft'] },
	'depthbasedcorrmaskmaskactive' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskActive'] },
	'depthbasedcorrmaskmaskblendmode' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'depthbasedcorrmaskmaskdigest' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskDigest'] },
	'depthbasedcorrmaskmaskinverted' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskInverted'] },
	'depthbasedcorrmaskmaskname' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskName'] },
	'depthbasedcorrmaskmasks' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasks'] },
	'depthbasedcorrmaskmasksalpha' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'depthbasedcorrmaskmasksangle' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksAngle'] },
	'depthbasedcorrmaskmasksbottom' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksBottom'] },
	'depthbasedcorrmaskmaskscentervalue' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'depthbasedcorrmaskmaskscenterweight' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'depthbasedcorrmaskmasksdabs' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksDabs'] },
	'depthbasedcorrmaskmasksfeather' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFeather'] },
	'depthbasedcorrmaskmasksflipped' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'depthbasedcorrmaskmasksflow' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFlow'] },
	'depthbasedcorrmaskmasksfullx' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullX'] },
	'depthbasedcorrmaskmasksfully' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksFullY'] },
	'depthbasedcorrmaskmasksinputdigest' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'depthbasedcorrmaskmasksleft' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksLeft'] },
	'depthbasedcorrmaskmasksmaskactive' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'depthbasedcorrmaskmasksmaskblendmode' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'depthbasedcorrmaskmasksmaskdigest' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'depthbasedcorrmaskmasksmaskinverted' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'depthbasedcorrmaskmasksmaskname' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'depthbasedcorrmaskmasksmasksubtype' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'depthbasedcorrmaskmasksmasksyncid' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'depthbasedcorrmaskmasksmaskversion' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'depthbasedcorrmaskmasksmidpoint' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'depthbasedcorrmaskmasksorigin' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'depthbasedcorrmaskmasksperimetervalue' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'depthbasedcorrmaskmasksradius' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRadius'] },
	'depthbasedcorrmaskmasksreferencepoint' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'depthbasedcorrmaskmasksright' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRight'] },
	'depthbasedcorrmaskmasksroundness' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'depthbasedcorrmaskmaskssizex' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'depthbasedcorrmaskmaskssizey' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'depthbasedcorrmaskmaskstop' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksTop'] },
	'depthbasedcorrmaskmasksubtype' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSubType'] },
	'depthbasedcorrmaskmasksvalue' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'depthbasedcorrmaskmasksversion' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksVersion'] },
	'depthbasedcorrmaskmaskswhat' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWhat'] },
	'depthbasedcorrmaskmaskswholeimagearea' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'depthbasedcorrmaskmasksx' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksX'] },
	'depthbasedcorrmaskmasksy' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksY'] },
	'depthbasedcorrmaskmasksyncid' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'depthbasedcorrmaskmaskszerox' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'depthbasedcorrmaskmaskszeroy' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'depthbasedcorrmaskmaskversion' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskVersion'] },
	'depthbasedcorrmaskmidpoint' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMidpoint'] },
	'depthbasedcorrmaskorigin' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksOrigin'] },
	'depthbasedcorrmaskperimetervalue' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'depthbasedcorrmaskradius' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRadius'] },
	'depthbasedcorrmaskrange' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'depthbasedcorrmaskrangeareamodels' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'depthbasedcorrmaskrangeareamodelscolorsampleinfo' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'depthbasedcorrmaskrangeareamodelscomponents' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'depthbasedcorrmaskrangecoloramount' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'depthbasedcorrmaskrangedepthfeather' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'depthbasedcorrmaskrangedepthmax' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'depthbasedcorrmaskrangedepthmin' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'depthbasedcorrmaskrangeinvert' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'depthbasedcorrmaskrangelumfeather' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'depthbasedcorrmaskrangeluminancedepthsampleinfo' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'depthbasedcorrmaskrangelummax' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'depthbasedcorrmaskrangelummin' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'depthbasedcorrmaskrangelumrange' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'depthbasedcorrmaskrangesampletype' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'depthbasedcorrmaskrangetype' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'depthbasedcorrmaskrangeversion' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'depthbasedcorrmaskreferencepoint' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksReferencePoint'] },
	'depthbasedcorrmaskright' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRight'] },
	'depthbasedcorrmaskroundness' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksRoundness'] },
	'depthbasedcorrmasksizex' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeX'] },
	'depthbasedcorrmasksizey' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksSizeY'] },
	'depthbasedcorrmasktop' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksTop'] },
	'depthbasedcorrmaskvalue' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksMaskValue'] },
	'depthbasedcorrmaskversion' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksVersion'] },
	'depthbasedcorrmaskwhat' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWhat'] },
	'depthbasedcorrmaskwholeimagearea' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'depthbasedcorrmaskx' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksX'] },
	'depthbasedcorrmasky' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksY'] },
	'depthbasedcorrmaskzerox' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroX'] },
	'depthbasedcorrmaskzeroy' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsCorrectionMasksZeroY'] },
	'depthbasedcorrwhat' => { 536 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'], 538 => [\'DepthBasedCorrections','DepthBasedCorrectionsWhat'] },
	'depthfar' => { 127 => 0xc7eb },
	'depthformat' => { 127 => 0xc7e9 },
	'depthimage' => { 145 => 'Data' },
	'depthmapinfo' => { 536 => 'DepthMapInfo', 538 => 'DepthMapInfo' },
	'depthmapinfobasehighlightguideinputdigest' => { 536 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'], 538 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideInputDigest'] },
	'depthmapinfobasehighlightguidetable' => { 536 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'], 538 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideTable'] },
	'depthmapinfobasehighlightguideversion' => { 536 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'], 538 => [\'DepthMapInfo','DepthMapInfoBaseHighlightGuideVersion'] },
	'depthmapinfobaselayereddepthinputdigest' => { 536 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'], 538 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthInputDigest'] },
	'depthmapinfobaselayereddepthtable' => { 536 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'], 538 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthTable'] },
	'depthmapinfobaselayereddepthversion' => { 536 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'], 538 => [\'DepthMapInfo','DepthMapInfoBaseLayeredDepthVersion'] },
	'depthmapinfobaserawdepthinputdigest' => { 536 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'], 538 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthInputDigest'] },
	'depthmapinfobaserawdepthtable' => { 536 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'], 538 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthTable'] },
	'depthmapinfobaserawdepthversion' => { 536 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'], 538 => [\'DepthMapInfo','DepthMapInfoBaseRawDepthVersion'] },
	'depthmapinfodepthsource' => { 536 => [\'DepthMapInfo','DepthMapInfoDepthSource'], 538 => [\'DepthMapInfo','DepthMapInfoDepthSource'] },
	'depthmeasuretype' => { 127 => 0xc7ed },
	'depthnear' => { 127 => 0xc7ea },
	'depthunits' => { 127 => 0xc7ec },
	'derivedfrom' => { 567 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 567 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 567 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 567 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 567 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 567 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 567 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfromlasturl' => { 567 => [\'DerivedFrom','DerivedFromLastURL'] },
	'derivedfromlinkcategory' => { 567 => [\'DerivedFrom','DerivedFromLinkCategory'] },
	'derivedfromlinkform' => { 567 => [\'DerivedFrom','DerivedFromLinkForm'] },
	'derivedfrommanager' => { 567 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 567 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 567 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 567 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 567 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 567 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 567 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromplacedresolutionunit' => { 567 => [\'DerivedFrom','DerivedFromPlacedResolutionUnit'] },
	'derivedfromplacedxresolution' => { 567 => [\'DerivedFrom','DerivedFromPlacedXResolution'] },
	'derivedfromplacedyresolution' => { 567 => [\'DerivedFrom','DerivedFromPlacedYResolution'] },
	'derivedfromrenditionclass' => { 567 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 567 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 567 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 567 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 198 => 'Description', 361 => 'Description', 429 => ['desc','dscp',"\xa9des"], 431 => 'description', 437 => 'dscp', 536 => 'Description', 538 => 'Description', 539 => 'description', 564 => 'Description' },
	'destination' => { 151 => 0x5 },
	'destinationcity' => { 411 => 0x24, 417 => 0x3 },
	'destinationcitycode' => { 418 => 0x1001 },
	'destinationdst' => { 411 => 0x26, 417 => '0.3' },
	'developmentdynamicrange' => { 135 => 0x1403 },
	'deviantmatrixcustom' => { 157 => 0x7de },
	'deviantmatrixdaylight' => { 157 => 0x7da },
	'deviantmatrixflash' => { 157 => 0x7dd },
	'deviantmatrixfluorescent' => { 157 => 0x7dc },
	'deviantmatrixtungsten' => { 157 => 0x7db },
	'deviantwhitecustom' => { 157 => 0x842 },
	'deviantwhitedaylight' => { 157 => 0x83e },
	'deviantwhiteflash' => { 157 => 0x841 },
	'deviantwhitefluorescent' => { 157 => 0x840 },
	'deviantwhitetungsten' => { 157 => 0x83f },
	'device' => { 556 => 'device' },
	'devicesettingdescription' => { 542 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 542 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 542 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 542 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 454 => 0x2 },
	'dewarpdata' => { 124 => 'DewarpData' },
	'dewarpflag' => { 124 => 'DewarpFlag' },
	'dialdirectiontvav' => { 92 => 0x706 },
	'dietaryneeds' => { 558 => 'dietaryNeeds' },
	'diffractioncompensation' => { 247 => 0x20e, 262 => 0x2ce, 263 => 0x142, 264 => 0x1b2, 267 => 0x1a2, 268 => 0x1b6, 269 => 0x1b6 },
	'diffractioncorrection' => { 372 => 0xbc, 400 => 0x3 },
	'diffractioncorrectionon' => { 111 => 0x2070b },
	'digitalcreationdate' => { 150 => 0x3e },
	'digitalcreationtime' => { 150 => 0x3f },
	'digitaldeehighlightadj' => { 284 => 0x202 },
	'digitaldeeshadowadj' => { 284 => 0x200 },
	'digitaldeethreshold' => { 284 => 0x201 },
	'digitalfilter' => { 457 => 0x59 },
	'digitalfilter01' => { 397 => 0x5 },
	'digitalfilter02' => { 397 => 0x16 },
	'digitalfilter03' => { 397 => 0x27 },
	'digitalfilter04' => { 397 => 0x38 },
	'digitalfilter05' => { 397 => 0x49 },
	'digitalfilter06' => { 397 => 0x5a },
	'digitalfilter07' => { 397 => 0x6b },
	'digitalfilter08' => { 397 => 0x7c },
	'digitalfilter09' => { 397 => 0x8d },
	'digitalfilter10' => { 397 => 0x9e },
	'digitalfilter11' => { 397 => 0xaf },
	'digitalfilter12' => { 397 => 0xc0 },
	'digitalfilter13' => { 397 => 0xd1 },
	'digitalfilter14' => { 397 => 0xe2 },
	'digitalfilter15' => { 397 => 0xf3 },
	'digitalfilter16' => { 397 => 0x104 },
	'digitalfilter17' => { 397 => 0x115 },
	'digitalfilter18' => { 397 => 0x126 },
	'digitalfilter19' => { 397 => 0x137 },
	'digitalfilter20' => { 397 => 0x148 },
	'digitalgain' => { 81 => 0xb },
	'digitalgem' => { 242 => 0x0 },
	'digitalice' => { 284 => 0x100 },
	'digitalimageguid' => { 550 => 'DigImageGUID' },
	'digitallensoptimizer' => { 69 => 0xa },
	'digitallensoptimizersetting' => { 87 => 0x9 },
	'digitalroc' => { 281 => 0x0 },
	'digitalsourcefiletype' => { 550 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 550 => 'DigitalSourceType' },
	'digitalzoom' => { 38 => 0xc, 120 => 0xa, 135 => 0x1044, 159 => 0x68, 170 => 0x22, 171 => 0x1e, 175 => 'DigitalZoom', 200 => 0xc, 258 => 0x86, 307 => 0xa, 352 => 0x204, 411 => 0x1e, 418 => 0xa, 456 => 0x204, 504 => 0x12, 505 => 0x12 },
	'digitalzoomon' => { 456 => 0x21b },
	'digitalzoomratio' => { 127 => 0xa404, 492 => 0x200, 494 => 0x21c, 542 => 'DigitalZoomRatio' },
	'director' => { 198 => 'WM/Director', 429 => "\xa9dir", 431 => 'director', 437 => "\xa9dir", 566 => 'director' },
	'directorphotography' => { 566 => 'directorPhotography' },
	'directory' => { 128 => 'Directory' },
	'directorycreatedate' => { 440 => 0x14, 442 => 0x14 },
	'directoryindex' => { 7 => 0x137, 9 => 0x2dc, 11 => 0x17e, 13 => 0x238, 14 => 0x13f, 15 => 0x133, 16 => 0x1df, 17 => 0x1a7, 18 => 0x1f0, 19 => 0xcc, 20 => 0x1c7, 21 => 0x298, 22 => 0x1e7, 23 => 0x1e5, 24 => [0x27c,0x280], 25 => 0x2b6, 26 => 0x2bf, 28 => 0x1f7, 29 => 0x4ba, 30 => 0xb21 },
	'directoryindex2' => { 21 => 0x29c },
	'directoryitem' => { 143 => [\'Directory','DirectoryItem'] },
	'directoryitemlabel' => { 143 => [\'Directory','DirectoryItemLabel'] },
	'directoryitemlength' => { 143 => [\'Directory','DirectoryItemLength'] },
	'directoryitemmime' => { 143 => [\'Directory','DirectoryItemMime'] },
	'directoryitempadding' => { 143 => [\'Directory','DirectoryItemPadding'] },
	'directoryitemsemantic' => { 143 => [\'Directory','DirectoryItemSemantic'] },
	'directoryitemuri' => { 143 => [\'Directory','DirectoryItemURI'] },
	'directorynumber' => { 235 => 0x3, 440 => 0x12, 441 => 0x93, 442 => 0x12 },
	'disableautocreation' => { 142 => 'DisableAutoCreation' },
	'disablesuggestedaction' => { 142 => 'DisableSuggestedAction' },
	'disclaimer' => { 361 => 'Disclaimer' },
	'discnumber' => { 566 => 'discNumber' },
	'dishtype' => { 558 => 'dishType' },
	'disknumber' => { 429 => 'disk' },
	'dispbutton' => { 269 => 0x7d4, 342 => 0x2ab },
	'displayallafpoints' => { 92 => 0x514 },
	'displayaperture' => { 38 => 0x23 },
	'displayedunitsx' => { 426 => 0x2 },
	'displayedunitsy' => { 426 => 0x6 },
	'displayname' => { 431 => 'displayname', 555 => 'displayName' },
	'distance1' => { 159 => 0x28 },
	'distance2' => { 159 => 0x2c },
	'distance3' => { 159 => 0x30 },
	'distance4' => { 159 => 0x34 },
	'distortion' => { 454 => 0xa050 },
	'distortioncompensation' => { 518 => 0x8040 },
	'distortioncontrol' => { 289 => 0x10 },
	'distortioncorrection' => { 86 => 0x3, 111 => 0x20705, 117 => 0x67, 127 => 0x7036, 233 => 0x4, 347 => 0x50b, 376 => '7.1', 400 => 0x0, 512 => 0x601, 513 => 0x5b },
	'distortioncorrection2' => { 351 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 533 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 111 => '0x20705.0', 117 => 0x63 },
	'distortioncorrectionsetting' => { 87 => 0x7, 481 => 0x2013 },
	'distortioncorrectionvalue' => { 86 => 0x9 },
	'distortioncorrectionversion' => { 233 => 0x0 },
	'distortioncorrparams' => { 127 => 0x7037, 491 => 0x1a23, 494 => 0x1870, 496 => 0x189c, 497 => 0x18cc, 498 => 0x17d0, 512 => 0x6ca, 513 => 0x64 },
	'distortioncorrparamsnumber' => { 494 => 0x1899, 496 => 0x18c5, 497 => 0x18f5, 498 => 0x17f9 },
	'distortioncorrparamspresent' => { 494 => 0x1898, 496 => 0x18c4, 497 => 0x18f4, 498 => 0x17f8, 500 => 0x10b, 501 => 0x10b, 512 => 0x600, 513 => 0x5a },
	'distortioneffect' => { 111 => 0x20709 },
	'distortionn' => { 376 => 0xc },
	'distortionparam02' => { 376 => 0x2 },
	'distortionparam04' => { 376 => 0x4 },
	'distortionparam08' => { 376 => 0x8 },
	'distortionparam09' => { 376 => 0x9 },
	'distortionparam11' => { 376 => 0xb },
	'distortionscale' => { 376 => 0x5 },
	'distributor' => { 556 => 'distributor' },
	'distributorproductid' => { 555 => 'distributorProductID' },
	'dloon' => { 111 => '0x20706.0', 117 => 0xdc },
	'dlosetting' => { 111 => 0x20706, 117 => 0xdd },
	'dlosettingapplied' => { 110 => 0x4 },
	'dloshootingdistance' => { 117 => 0xde },
	'dloversion' => { 110 => 0x5 },
	'dmcomment' => { 566 => 'comment' },
	'dmdithermatrix' => { 157 => 0xc7a },
	'dmdithermatrixheight' => { 157 => 0xc7c },
	'dmdithermatrixwidth' => { 157 => 0xc7b },
	'dngadobedata' => { 127 => 0xc634 },
	'dngbackwardversion' => { 127 => 0xc613 },
	'dngignoresidecars' => { 536 => 'DNGIgnoreSidecars', 538 => 'DNGIgnoreSidecars' },
	'dnglensinfo' => { 127 => 0xc630 },
	'dngprivatedata' => { 127 => 0xc634 },
	'dngversion' => { 127 => 0xc612 },
	'document' => { 361 => 'Document' },
	'documentancestors' => { 554 => 'DocumentAncestors' },
	'documenthistory' => { 150 => 0xe7 },
	'documentid' => { 567 => 'DocumentID' },
	'documentname' => { 127 => 0x10d },
	'documentnotes' => { 150 => 0xe6 },
	'doi' => { 556 => 'doi' },
	'dopesheet' => { 550 => 'Dopesheet' },
	'dopesheetlink' => { 550 => 'DopesheetLink' },
	'dopesheetlinklink' => { 550 => [\'DopesheetLink','DopesheetLinkLink'] },
	'dopesheetlinklinkqualifier' => { 550 => [\'DopesheetLink','DopesheetLinkLinkQualifier'] },
	'doublingmicrovolts' => { 157 => 0xc82 },
	'dpp' => { 530 => 'dpp' },
	'dprawbokehshift' => { 111 => 0x20b20 },
	'dprawbokehshiftarea' => { 111 => 0x20b21 },
	'dprawghostingreductionarea' => { 111 => 0x20b30 },
	'dprawmicroadjustbackfront' => { 111 => 0x20b10 },
	'dprawmicroadjuststrength' => { 111 => 0x20b12 },
	'dr4cameramodel' => { 112 => 0x3 },
	'drangepriority' => { 135 => 0x1443 },
	'drangepriorityauto' => { 135 => 0x1444 },
	'drangepriorityfixed' => { 135 => 0x1445 },
	'drivemode' => { 121 => 0x3103, 133 => '0.1', 200 => 0x6, 203 => 0x1e, 206 => 0xe, 210 => 0x64d0, 347 => 0x600, 411 => 0x34, 447 => 0x1002, 457 => 0x3, 467 => 0x4, 468 => 0x7e, 469 => 0x34 },
	'drivemode2' => { 203 => 0xa, 390 => 0x7, 478 => 0xe, 486 => 0x1 },
	'drivemodesetting' => { 469 => 0x4 },
	'drivespeed' => { 133 => '0.2' },
	'dspfirmwareversion' => { 411 => 0x27 },
	'dualpixelraw' => { 69 => 0xb },
	'duration' => { 74 => 0x6a, 174 => 'Duration', 188 => 'Duration', 558 => 'duration', 566 => 'duration' },
	'durationscale' => { 566 => [\'duration','durationScale'] },
	'durationvalue' => { 566 => [\'duration','durationValue'] },
	'dustremovaldata' => { 71 => 0x97 },
	'dxcropalert' => { 264 => 0x250, 267 => 0x23c, 268 => 0x250, 269 => 0x250 },
	'dynamicafarea' => { 325 => '1.4', 334 => '1.4' },
	'dynamicafareasize' => { 262 => 0x370, 264 => 0x254, 267 => 0x240, 268 => 0x254, 269 => 0x254 },
	'dynamicareaafassist' => { 341 => 0x18, 342 => 0x18, 343 => 0x18, 344 => 0x18 },
	'dynamicareaafdisplay' => { 326 => '46.1', 328 => '47.1', 329 => '47.1', 338 => '47.1', 339 => '47.1' },
	'dynamicrange' => { 135 => 0x1400 },
	'dynamicrangeboost' => { 372 => 0xee },
	'dynamicrangeexpansion' => { 411 => 0x69, 447 => 0x100e },
	'dynamicrangemax' => { 116 => 0x7c },
	'dynamicrangemin' => { 116 => 0x7a },
	'dynamicrangeoptimizer' => { 203 => 0x15, 481 => [0xb025,0xb04f], 490 => 0x1144, 491 => [0x1144,0x324], 492 => [0x1120,0x300], 493 => [0x119c,0x37c], 494 => [0x1178,0x328], 495 => [0x1030,0x50], 496 => [0x228,0x50], 497 => [0x228,0x50], 498 => [0x21b,0x4e] },
	'dynamicrangeoptimizerbracket' => { 478 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 467 => 0x19, 468 => 0x17, 469 => 0xd, 478 => 0x79, 486 => 0x5 },
	'dynamicrangeoptimizermode' => { 206 => 0x15, 467 => 0x18, 468 => 0x16, 478 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 203 => 0x27, 469 => 0xc, 486 => 0x4 },
	'dynamicrangesetting' => { 135 => 0x1402 },
	'e-dialinprogram' => { 390 => '1.3' },
	'earliestageorloweststage' => { 126 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 126 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 126 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 126 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 126 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'earthpos' => { 140 => 'EarthPos' },
	'earthposaltitude' => { 140 => [\'EarthPos','EarthPosAltitude'] },
	'earthposlatitude' => { 140 => [\'EarthPos','EarthPosLatitude'] },
	'earthposlongitude' => { 140 => [\'EarthPos','EarthPosLongitude'] },
	'earthposrotationw' => { 140 => [\'EarthPos','EarthPosRotationW'] },
	'earthposrotationx' => { 140 => [\'EarthPos','EarthPosRotationX'] },
	'earthposrotationy' => { 140 => [\'EarthPos','EarthPosRotationY'] },
	'earthposrotationz' => { 140 => [\'EarthPos','EarthPosRotationZ'] },
	'earthpostimestamp' => { 140 => [\'EarthPos','EarthPosTimestamp'] },
	'easyexposurecomp' => { 340 => '6.1' },
	'easyexposurecompensation' => { 325 => '6.4', 326 => '6.5', 328 => '6.3', 329 => '6.3', 333 => '5.1', 334 => '4.4', 335 => '5.2', 338 => '6.3', 339 => '6.3', 341 => 0x1f, 342 => 0x1d, 343 => 0x1d, 344 => 0x1d },
	'easymode' => { 38 => 0xb },
	'edgemapslope' => { 157 => 0x930 },
	'edgemapx1' => { 157 => 0x931 },
	'edgemapx2' => { 157 => 0x932 },
	'edgemapx3' => { 157 => 0x934 },
	'edgemapx4' => { 157 => 0x935 },
	'edgenoisereduction' => { 319 => 0x4, 518 => 0x8028 },
	'edit1' => { 437 => "\xa9ed1" },
	'edit2' => { 437 => "\xa9ed2" },
	'edit3' => { 437 => "\xa9ed3" },
	'edit4' => { 437 => "\xa9ed4" },
	'edit5' => { 437 => "\xa9ed5" },
	'edit6' => { 437 => "\xa9ed6" },
	'edit7' => { 437 => "\xa9ed7" },
	'edit8' => { 437 => "\xa9ed8" },
	'edit9' => { 437 => "\xa9ed9" },
	'edition' => { 556 => 'edition' },
	'editorialupdate' => { 150 => 0x8 },
	'editstatus' => { 150 => 0x7, 423 => 'EditStatus', 530 => 'EditStatus' },
	'editversionname' => { 318 => 0x3d136244 },
	'effectivelv' => { 411 => 0x2d },
	'effectivemaxaperture' => { 251 => 0x12, 252 => 0x13, 256 => 0x14 },
	'eissn' => { 556 => 'eIssn' },
	'electricalblackcolumns' => { 157 => 0x1810 },
	'electronicfront-curtainshutter' => { 328 => '5.2', 329 => '5.2', 338 => '5.3', 339 => '5.2' },
	'electronicfrontcurtainshutter' => { 481 => 0x201a },
	'elevation' => { 184 => 'Elevation' },
	'email' => { 176 => 'EMail' },
	'embargodate' => { 559 => 'embargoDate' },
	'embdencrightsexpr' => { 550 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 550 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 550 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 550 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 554 => 'EmbeddedXMPDigest' },
	'emissivity' => { 129 => 0x3 },
	'emptyslotrelease' => { 262 => 0x98c, 265 => 0x723, 266 => 0x783, 267 => 0x625, 268 => 0x655, 269 => 0x6bd },
	'enablechromanoisereduction' => { 157 => 0xe6e },
	'enablesharpening' => { 157 => 0x92e },
	'encodedby' => { 198 => 'WM/EncodedBy', 429 => "\xa9enc" },
	'encodedwith' => { 431 => 'Encoded_With' },
	'encoder' => { 429 => "\xa9too", 431 => 'encoder', 437 => "\xa9too" },
	'encoderid' => { 437 => "\xa9enc" },
	'encodingtime' => { 198 => 'WM/EncodingTime' },
	'encryptionkey' => { 454 => 0xa020 },
	'endingpage' => { 556 => 'endingPage' },
	'enduser' => { 358 => 'EndUser' },
	'enduserid' => { 358 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 358 => [\'EndUser','EndUserEndUserName'] },
	'energysavingmode' => { 262 => 0x992, 265 => 0x746, 266 => 0x7a6, 267 => 0x648, 268 => 0x678, 269 => 0x6e0 },
	'engineer' => { 566 => 'engineer' },
	'enhancedarktones' => { 311 => 0x8 },
	'enhancedenoisealreadyapplied' => { 533 => 'EnhanceDenoiseAlreadyApplied' },
	'enhancedenoiselumaamount' => { 533 => 'EnhanceDenoiseLumaAmount' },
	'enhancedenoiseversion' => { 533 => 'EnhanceDenoiseVersion' },
	'enhancedetailsalreadyapplied' => { 533 => 'EnhanceDetailsAlreadyApplied' },
	'enhancedetailsversion' => { 533 => 'EnhanceDetailsVersion' },
	'enhancement' => { 120 => 0x16, 121 => 0x3016 },
	'enhanceparams' => { 127 => 0xc7ee },
	'enhancer' => { 351 => 0x300 },
	'enhancervalues' => { 351 => 0x301 },
	'enhancesuperresolutionalreadyapplied' => { 533 => 'EnhanceSuperResolutionAlreadyApplied' },
	'enhancesuperresolutionscale' => { 533 => 'EnhanceSuperResolutionScale' },
	'enhancesuperresolutionversion' => { 533 => 'EnhanceSuperResolutionVersion' },
	'envelopenumber' => { 151 => 0x28 },
	'envelopepriority' => { 151 => 0x3c },
	'enveloperecordversion' => { 151 => 0x0 },
	'episode' => { 550 => 'Episode' },
	'episodeglobaluniqueid' => { 429 => 'egid' },
	'episodeidentifier' => { 550 => [\'Episode','EpisodeIdentifier'] },
	'episodename' => { 550 => [\'Episode','EpisodeName'] },
	'episodenumber' => { 550 => [\'Episode','EpisodeNumber'] },
	'epsonimageheight' => { 352 => 0x20c },
	'epsonimagewidth' => { 352 => 0x20b },
	'epsonsoftware' => { 352 => 0x20d },
	'equipmentinstitution' => { 521 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 521 => 'EquipmentManufacturer' },
	'equipmentversion' => { 348 => 0x0 },
	'ettlii' => { 92 => 0x304, 93 => 0xd, 94 => 0xe, 95 => 0x7, 96 => 0x7, 97 => 0xe },
	'event' => { 523 => 'Event', 528 => 'Event', 550 => 'Event', 556 => 'event' },
	'eventalias' => { 555 => 'eventAlias' },
	'eventdate' => { 126 => [\'Event','EventEventDate'] },
	'eventday' => { 126 => [\'Event','EventDay'] },
	'eventearliestdate' => { 126 => [\'Event','EventEarliestDate'] },
	'eventend' => { 555 => 'eventEnd' },
	'eventenddayofyear' => { 126 => [\'Event','EventEndDayOfYear'] },
	'eventeventtype' => { 126 => [\'Event','EventEventType'] },
	'eventfieldnotes' => { 126 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 126 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 126 => [\'Event','EventHabitat'] },
	'eventid' => { 126 => [\'Event','EventEventID'], 550 => 'EventId' },
	'eventlatestdate' => { 126 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 126 => [\'Event','EventMonth'] },
	'eventnumber' => { 439 => 0x9, 440 => 0x3a, 441 => 0x2b, 442 => 0x4a, 443 => 0x37 },
	'eventparenteventid' => { 126 => [\'Event','EventParentEventID'] },
	'eventremarks' => { 126 => [\'Event','EventEventRemarks'] },
	'eventsamplesizeunit' => { 126 => [\'Event','EventSampleSizeUnit'] },
	'eventsamplesizevalue' => { 126 => [\'Event','EventSampleSizeValue'] },
	'eventsamplingeffort' => { 126 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 126 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 555 => 'eventStart' },
	'eventstartdayofyear' => { 126 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 555 => 'eventSubtype' },
	'eventtime' => { 126 => [\'Event','EventEventTime'] },
	'eventtype' => { 555 => 'eventType' },
	'eventverbatimeventdate' => { 126 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 126 => [\'Event','EventYear'] },
	'evfgrid' => { 341 => 0x15f, 342 => 0x165, 343 => 0x165, 344 => 0x17d },
	'evfimageframe' => { 341 => 0x15e, 342 => 0x164, 343 => 0x164, 344 => 0x17c },
	'evfreleaseindicator' => { 342 => 0x24f, 343 => 0x24f, 344 => 0x267 },
	'evfwarmdisplaybrightness' => { 342 => 0x24d, 343 => 0x24d, 344 => 0x265 },
	'evfwarmdisplaymode' => { 342 => 0x24b, 343 => 0x24b, 344 => 0x263 },
	'evsteps' => { 390 => '1.2', 392 => 0x0 },
	'evstepsize' => { 330 => '5.1', 331 => '6.1', 332 => '6.1', 336 => '0.7' },
	'exclusivecoverage' => { 524 => 'ExclusiveCoverage' },
	'exclusivityenddate' => { 559 => 'exclusivityEndDate' },
	'excursiontolerance' => { 152 => 0x82 },
	'executiveproducer' => { 429 => "\xa9xpd" },
	'exif' => { 128 => 'EXIF' },
	'exifbyteorder' => { 128 => 'ExifByteOrder' },
	'exifcamerainfo' => { 150 => 0xe8 },
	'exifimageheight' => { 127 => 0xa003, 542 => 'PixelYDimension' },
	'exifimagewidth' => { 127 => 0xa002, 542 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 128 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 127 => 0x9000, 542 => 'ExifVersion' },
	'exitpupilposition' => { 251 => 0x4, 252 => 0x4, 256 => 0x4 },
	'expirationdate' => { 150 => 0x25, 559 => 'expirationDate' },
	'expirationtime' => { 150 => 0x26 },
	'exposure' => { 127 => 0xfe51, 536 => 'Exposure', 538 => 'Exposure' },
	'exposure2012' => { 536 => 'Exposure2012', 538 => 'Exposure2012' },
	'exposureadj' => { 316 => 0x0 },
	'exposureadj2' => { 316 => 0x12 },
	'exposureadjust' => { 457 => 0xc },
	'exposurebracketingindicatorlast' => { 203 => 0x52 },
	'exposurebracketshotnumber' => { 206 => 0x2d, 478 => 0x2f },
	'exposurebracketstepsize' => { 390 => 0x8 },
	'exposurebracketvalue' => { 258 => 0x19 },
	'exposurecompautocancel' => { 92 => 0x113 },
	'exposurecompensation' => { 84 => 0x6, 101 => 0x0, 127 => 0x9204, 159 => 0x24, 175 => 'ExposureComp', 195 => 'ExposureCompensation', 200 => 0xd, 201 => 0x53, 202 => 0x1e, 206 => 0x49c0, 352 => 0x1006, 411 => 0x16, 420 => 0x402, 454 => 0xa013, 457 => [0xc,0x35,0x47,0x4d], 490 => 0x114c, 491 => 0x114c, 492 => 0x1128, 494 => 0x1180, 495 => 0x1038, 496 => 0x230, 497 => 0x230, 498 => 0x223, 542 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 486 => [0x24,0x26,0x2a] },
	'exposurecompensationbutton' => { 269 => 0x794 },
	'exposurecompensationmode' => { 203 => 0x47, 206 => 0x2a },
	'exposurecompensationset' => { 467 => 0x3, 468 => 0x3, 469 => 0x3, 486 => 0x1e },
	'exposurecompensationsetting' => { 203 => 0x1 },
	'exposurecompstepsize' => { 325 => '6.3', 326 => '7.3', 328 => '7.3', 329 => '7.3', 334 => '4.3', 338 => '7.3', 339 => '7.3' },
	'exposurecontrolstep' => { 333 => '6.1', 335 => '6.1' },
	'exposurecontrolstepsize' => { 325 => '6.2', 326 => '7.1', 328 => '7.1', 329 => '7.1', 334 => '4.2', 338 => '7.1', 339 => '7.1', 340 => '7.1', 341 => 0x1d, 342 => 0x1b, 343 => 0x1b, 344 => 0x1b },
	'exposurecount' => { 135 => 0x1032 },
	'exposuredelay' => { 269 => 0x800, 342 => 0x2f1 },
	'exposuredelaymode' => { 325 => '10.1', 326 => '11.1', 328 => '11.1', 329 => '11.1', 330 => '9.1', 331 => '10.1', 332 => '10.1', 334 => '10.4', 335 => '10.1', 336 => '6.4', 338 => '11.1', 339 => '11.1', 340 => '11.2' },
	'exposuredifference' => { 258 => 0xe },
	'exposuregaincustom' => { 157 => 0x89c },
	'exposuregaindaylight' => { 157 => 0x898 },
	'exposuregainflash' => { 157 => 0x89b },
	'exposuregainfluorescent' => { 157 => 0x89a },
	'exposuregaintungsten' => { 157 => 0x899 },
	'exposureindex' => { 127 => 0xa215, 542 => 'ExposureIndex' },
	'exposureindicator' => { 203 => 0x50 },
	'exposurelevelincrements' => { 90 => 0x6, 91 => 0x6, 92 => 0x101, 93 => 0x5, 94 => 0x6, 95 => 0x5, 96 => 0x5, 97 => 0x6, 98 => 0x4, 467 => 0x58, 468 => 0x58 },
	'exposurelockused' => { 148 => 'ExposureLockUsed' },
	'exposuremode' => { 127 => 0xa402, 175 => 'ExposureMode', 200 => 0x1, 201 => 0xa, 202 => 0x0, 203 => 0x0, 206 => 0x34, 347 => 0x200, 369 => 0x40d, 457 => 0x8, 481 => 0xb041, 542 => 'ExposureMode' },
	'exposuremodeinmanual' => { 92 => 0x10b },
	'exposureprogram' => { 127 => 0x8822, 447 => 0x1001, 460 => [0x17e,0x43], 467 => 0x3c, 468 => 0x3c, 469 => 0x5, 473 => 0x14, 478 => 0x3f, 486 => 0x2, 490 => 0x1175, 491 => 0x1179, 492 => 0x1155, 493 => 0x11d1, 494 => 0x11ad, 495 => 0x1065, 496 => 0x25d, 497 => 0x25d, 498 => 0x24c, 509 => 0xb, 510 => 0xc, 511 => 0xb, 513 => 0x48, 542 => 'ExposureProgram' },
	'exposureshift' => { 347 => 0x203 },
	'exposurestandardadjustment' => { 481 => 0x202d },
	'exposuretime' => { 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x4, 28 => 0x4, 29 => 0x4, 31 => 0x6, 32 => 0x7, 84 => 0x16, 127 => 0x829a, 156 => 0xfd05, 159 => 0x20, 161 => 0xfa24, 163 => 0xf104, 166 => 0x12, 168 => 0x38, 170 => 0x14, 171 => 0x10, 173 => 0x10, 175 => 'ExposureTime', 200 => 0x9, 201 => 0x35, 202 => 0x48, 203 => 0x8, 206 => 0x49b8, 411 => 0x12, 454 => 0xa018, 457 => [0x32,0x4a], 467 => 0x0, 468 => 0x0, 486 => [0x21,0x23,0x27], 513 => 0x10, 542 => 'ExposureTime' },
	'exposuretime2' => { 457 => [0x33,0x4b] },
	'exposuretuning' => { 258 => 0x1c },
	'exposurevalue' => { 157 => 0x3 },
	'exposurewarning' => { 135 => 0x1302 },
	'exrauto' => { 135 => 0x1033 },
	'exrmode' => { 135 => 0x1034 },
	'extdescraccessibility' => { 549 => 'ExtDescrAccessibility' },
	'extendedmenubanks' => { 264 => 0x120, 267 => 0x114, 268 => 0x124, 269 => 0x124 },
	'extendedshutterspeeds' => { 341 => 0xf2, 342 => 0x102, 343 => 0x102, 344 => 0x118 },
	'extendedwbdetect' => { 347 => 0x902 },
	'extender' => { 348 => 0x301 },
	'extenderfirmwareversion' => { 348 => 0x304 },
	'extendermagnification' => { 177 => 'Magnification' },
	'extendermake' => { 177 => 'Make' },
	'extendermodel' => { 177 => 'Model', 348 => 0x303 },
	'extenderserialnumber' => { 177 => 'SerialNumber', 348 => 0x302 },
	'extenderstatus' => { 408 => 0x3 },
	'externalflash' => { 350 => 0x1201 },
	'externalflashae1' => { 352 => 0x101f },
	'externalflashae1_0' => { 352 => 0x101b },
	'externalflashae2' => { 352 => 0x1020 },
	'externalflashae2_0' => { 352 => 0x101c },
	'externalflashbounce' => { 350 => 0x1204, 352 => 0x1026, 398 => 0x1a },
	'externalflashcompensation' => { 238 => 0x1b },
	'externalflashexposurecomp' => { 258 => 0x17, 398 => 0x19 },
	'externalflashfirmware' => { 236 => 0x6, 237 => 0x6, 238 => 0x6, 239 => 0x6, 240 => 0x6, 241 => 0x6 },
	'externalflashflags' => { 236 => 0x8, 237 => 0x8, 238 => 0x8, 239 => 0x8, 241 => 0x8 },
	'externalflashguidenumber' => { 350 => 0x1203, 398 => '24.1' },
	'externalflashgvalue' => { 352 => 0x1025 },
	'externalflashmode' => { 352 => 0x1028, 398 => 0x2 },
	'externalflashreadystate' => { 240 => '9.1' },
	'externalflashstatus' => { 240 => '8.2' },
	'externalflashzoom' => { 350 => 0x1205, 352 => 0x1027 },
	'externalflashzoomoverride' => { 240 => '8.1' },
	'externalmetadatalink' => { 550 => 'ExternalMetadataLink' },
	'externalsensorbrightnessvalue' => { 367 => 0x311, 370 => 0x311, 371 => 0x311, 374 => 0x3408 },
	'extrainfoversion' => { 471 => 0x1a },
	'eyedetection' => { 2 => 0x18 },
	'eyestartaf' => { 203 => 0x40 },
	'fac100per' => { 157 => 0xe94 },
	'fac170per' => { 157 => 0xe93 },
	'fac18per' => { 157 => 0xe92 },
	'face10aarea' => { 394 => 0xbe },
	'face10aeye1' => { 394 => 0xc2 },
	'face10aeye2' => { 394 => 0xc6 },
	'face10barea' => { 394 => 0x186 },
	'face10beye1' => { 394 => 0x18a },
	'face10beye2' => { 394 => 0x18e },
	'face10position' => { 118 => 0x3f4, 119 => 0x1ec, 234 => 0x28, 395 => 0x12 },
	'face10size' => { 396 => 0x12 },
	'face11position' => { 234 => 0x2c, 395 => 0x14 },
	'face11size' => { 396 => 0x14 },
	'face12position' => { 234 => 0x30, 395 => 0x16 },
	'face12size' => { 396 => 0x16 },
	'face13position' => { 395 => 0x18 },
	'face13size' => { 396 => 0x18 },
	'face14position' => { 395 => 0x1a },
	'face14size' => { 396 => 0x1a },
	'face15position' => { 395 => 0x1c },
	'face15size' => { 396 => 0x1c },
	'face16position' => { 395 => 0x1e },
	'face16size' => { 396 => 0x1e },
	'face17position' => { 395 => 0x20 },
	'face17size' => { 396 => 0x20 },
	'face18position' => { 395 => 0x22 },
	'face18size' => { 396 => 0x22 },
	'face19position' => { 395 => 0x24 },
	'face19size' => { 396 => 0x24 },
	'face1aarea' => { 394 => 0xa },
	'face1aeye1' => { 394 => 0xe },
	'face1aeye2' => { 394 => 0x12 },
	'face1barea' => { 394 => 0xd2 },
	'face1beye1' => { 394 => 0xd6 },
	'face1beye2' => { 394 => 0xda },
	'face1position' => { 59 => 0x8, 118 => 0xd, 119 => 0x18, 234 => 0x4, 364 => 0x1, 395 => 0x0, 444 => 0xbc, 474 => 0x1, 475 => 0x0, 476 => 0x0, 477 => 0x5b },
	'face1size' => { 396 => 0x0 },
	'face20position' => { 395 => 0x26 },
	'face20size' => { 396 => 0x26 },
	'face21position' => { 395 => 0x28 },
	'face21size' => { 396 => 0x28 },
	'face22position' => { 395 => 0x2a },
	'face22size' => { 396 => 0x2a },
	'face23position' => { 395 => 0x2c },
	'face23size' => { 396 => 0x2c },
	'face24position' => { 395 => 0x2e },
	'face24size' => { 396 => 0x2e },
	'face25position' => { 395 => 0x30 },
	'face25size' => { 396 => 0x30 },
	'face26position' => { 395 => 0x32 },
	'face26size' => { 396 => 0x32 },
	'face27position' => { 395 => 0x34 },
	'face27size' => { 396 => 0x34 },
	'face28position' => { 395 => 0x36 },
	'face28size' => { 396 => 0x36 },
	'face29position' => { 395 => 0x38 },
	'face29size' => { 396 => 0x38 },
	'face2aarea' => { 394 => 0x1e },
	'face2aeye1' => { 394 => 0x22 },
	'face2aeye2' => { 394 => 0x26 },
	'face2barea' => { 394 => 0xe6 },
	'face2beye1' => { 394 => 0xea },
	'face2beye2' => { 394 => 0xee },
	'face2position' => { 59 => 0xa, 118 => 0x7c, 119 => 0x4c, 234 => 0x8, 364 => 0x5, 395 => 0x2, 444 => 0xc8, 474 => 0x6, 475 => 0x20, 476 => 0x25, 477 => 0x65 },
	'face2size' => { 396 => 0x2 },
	'face30position' => { 395 => 0x3a },
	'face30size' => { 396 => 0x3a },
	'face31position' => { 395 => 0x3c },
	'face31size' => { 396 => 0x3c },
	'face32position' => { 395 => 0x3e },
	'face32size' => { 396 => 0x3e },
	'face3aarea' => { 394 => 0x32 },
	'face3aeye1' => { 394 => 0x36 },
	'face3aeye2' => { 394 => 0x3a },
	'face3barea' => { 394 => 0xfa },
	'face3beye1' => { 394 => 0xfe },
	'face3beye2' => { 394 => 0x102 },
	'face3position' => { 59 => 0xc, 118 => 0xeb, 119 => 0x80, 234 => 0xc, 364 => 0x9, 395 => 0x4, 444 => 0xd4, 474 => 0xb, 475 => 0x40, 476 => 0x4a, 477 => 0x6f },
	'face3size' => { 396 => 0x4 },
	'face4aarea' => { 394 => 0x46 },
	'face4aeye1' => { 394 => 0x4a },
	'face4aeye2' => { 394 => 0x4e },
	'face4barea' => { 394 => 0x10e },
	'face4beye1' => { 394 => 0x112 },
	'face4beye2' => { 394 => 0x116 },
	'face4position' => { 59 => 0xe, 118 => 0x15a, 119 => 0xb4, 234 => 0x10, 364 => 0xd, 395 => 0x6, 444 => 0xe0, 474 => 0x10, 475 => 0x60, 476 => 0x6f, 477 => 0x79 },
	'face4size' => { 396 => 0x6 },
	'face5aarea' => { 394 => 0x5a },
	'face5aeye1' => { 394 => 0x5e },
	'face5aeye2' => { 394 => 0x62 },
	'face5barea' => { 394 => 0x122 },
	'face5beye1' => { 394 => 0x126 },
	'face5beye2' => { 394 => 0x12a },
	'face5position' => { 59 => 0x10, 118 => 0x1c9, 119 => 0xe8, 234 => 0x14, 364 => 0x11, 395 => 0x8, 444 => 0xec, 474 => 0x15, 475 => 0x80, 476 => 0x94 },
	'face5size' => { 396 => 0x8 },
	'face6aarea' => { 394 => 0x6e },
	'face6aeye1' => { 394 => 0x72 },
	'face6aeye2' => { 394 => 0x76 },
	'face6barea' => { 394 => 0x136 },
	'face6beye1' => { 394 => 0x13a },
	'face6beye2' => { 394 => 0x13e },
	'face6position' => { 59 => 0x12, 118 => 0x238, 119 => 0x11c, 234 => 0x18, 395 => 0xa, 444 => 0xf8, 474 => 0x1a, 475 => 0xa0, 476 => 0xb9 },
	'face6size' => { 396 => 0xa },
	'face7aarea' => { 394 => 0x82 },
	'face7aeye1' => { 394 => 0x86 },
	'face7aeye2' => { 394 => 0x8a },
	'face7barea' => { 394 => 0x14a },
	'face7beye1' => { 394 => 0x14e },
	'face7beye2' => { 394 => 0x152 },
	'face7position' => { 59 => 0x14, 118 => 0x2a7, 119 => 0x150, 234 => 0x1c, 395 => 0xc, 444 => 0x104, 474 => 0x1f, 475 => 0xc0, 476 => 0xde },
	'face7size' => { 396 => 0xc },
	'face8aarea' => { 394 => 0x96 },
	'face8aeye1' => { 394 => 0x9a },
	'face8aeye2' => { 394 => 0x9e },
	'face8barea' => { 394 => 0x15e },
	'face8beye1' => { 394 => 0x162 },
	'face8beye2' => { 394 => 0x166 },
	'face8position' => { 59 => 0x16, 118 => 0x316, 119 => 0x184, 234 => 0x20, 395 => 0xe, 444 => 0x110, 474 => 0x24, 475 => 0xe0, 476 => 0x103 },
	'face8size' => { 396 => 0xe },
	'face9aarea' => { 394 => 0xaa },
	'face9aeye1' => { 394 => 0xae },
	'face9aeye2' => { 394 => 0xb2 },
	'face9barea' => { 394 => 0x172 },
	'face9beye1' => { 394 => 0x176 },
	'face9beye2' => { 394 => 0x17a },
	'face9position' => { 59 => 0x18, 118 => 0x385, 119 => 0x1b8, 234 => 0x24, 395 => 0x10 },
	'face9size' => { 396 => 0x10 },
	'facebalanceorigi' => { 529 => 'FaceBalanceOrigI' },
	'facebalanceorigq' => { 529 => 'FaceBalanceOrigQ' },
	'facebalancestrength' => { 529 => 'FaceBalanceStrength' },
	'facebalancewarmth' => { 529 => 'FaceBalanceWarmth' },
	'facedetect' => { 411 => 0x76, 454 => 0x100 },
	'facedetectarea' => { 351 => 0x1201 },
	'facedetectframecrop' => { 351 => 0x1207 },
	'facedetectframesize' => { 59 => 0x3, 118 => 0x1, 119 => 0x4, 234 => 0x1, 351 => 0x1203, 411 => 0x77, 444 => 0xb6 },
	'facedetection' => { 469 => 0x30, 486 => 0x19 },
	'faceelementpositions' => { 135 => 0x4203 },
	'faceelementselected' => { 135 => 0x4005 },
	'faceelementtypes' => { 135 => 0x4201 },
	'faceid' => { 532 => 'FaceID' },
	'faceimagesize' => { 394 => 0x0 },
	'faceinfok3iii' => { 394 => '0.1' },
	'faceinfounknown' => { 121 => 0x2089 },
	'facename' => { 454 => 0x123 },
	'faceorientation' => { 119 => 0x8 },
	'faceposition' => { 393 => 0x2, 455 => 0x4 },
	'facepositions' => { 135 => 0x4103 },
	'facerecognition' => { 454 => 0x120 },
	'facesdetected' => { 59 => 0x2, 60 => 0x2, 61 => 0x3, 118 => 0x0, 119 => 0x2, 121 => 0x211c, 135 => 0x4100, 234 => 0x3, 351 => 0x1200, 372 => 0x3f, 393 => 0x0, 444 => 0xb5, 455 => 0x0, 474 => 0x0, 477 => 0x3, 489 => 0x30 },
	'facesdetecteda' => { 394 => 0x6 },
	'facesdetectedb' => { 394 => 0x8 },
	'facesrecognized' => { 365 => 0x0 },
	'facewidth' => { 60 => 0x1 },
	'fade' => { 457 => 0x138, 481 => 0x2034 },
	'faithfuloutputhighlightpoint' => { 117 => 0x38 },
	'faithfuloutputshadowpoint' => { 117 => 0x39 },
	'faithfulrawcolortone' => { 117 => 0x31 },
	'faithfulrawcontrast' => { 117 => 0x33 },
	'faithfulrawhighlight' => { 117 => 0x79 },
	'faithfulrawhighlightpoint' => { 117 => 0x36 },
	'faithfulrawlinear' => { 117 => 0x34 },
	'faithfulrawsaturation' => { 117 => 0x32 },
	'faithfulrawshadow' => { 117 => 0x82 },
	'faithfulrawshadowpoint' => { 117 => 0x37 },
	'faithfulrawsharpness' => { 117 => 0x35 },
	'faithfulunsharpmaskfineness' => { 117 => 0xac },
	'faithfulunsharpmaskstrength' => { 117 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 117 => 0xae },
	'far' => { 145 => 'Far' },
	'fastresetlinetime' => { 157 => 0x1860 },
	'feedidentifier' => { 550 => 'FeedIdentifier' },
	'femicroadjustment' => { 92 => 0x111 },
	'ffid' => { 540 => 'ffid' },
	'field' => { 555 => 'field' },
	'fieldcount' => { 352 => 0x103f },
	'fieldofview' => { 437 => "FOV\x00" },
	'fifoenonepixeldelay' => { 157 => 0x1901 },
	'filecreatedate' => { 128 => 'FileCreateDate' },
	'filedatarate' => { 566 => 'fileDataRate' },
	'fileformat' => { 103 => 0x0, 151 => 0x14, 457 => [0x22,0x26], 481 => 0xb000 },
	'filegroupid' => { 128 => 'FileGroupID' },
	'fileindex' => { 7 => 0x143, 9 => 0x2d0, 11 => 0x172, 13 => 0x22c, 14 => 0x133, 15 => 0x13f, 16 => 0x1d3, 17 => 0x19b, 18 => 0x1e4, 19 => 0xd0, 20 => 0x1bb, 21 => 0x28c, 22 => 0x1db, 23 => 0x1d9, 24 => [0x270,0x274], 25 => 0x2aa, 26 => 0x2b3, 28 => 0x1eb, 29 => 0x4ae, 30 => 0xb2d, 373 => 0x0 },
	'fileindex2' => { 21 => 0x290 },
	'filemodifydate' => { 128 => 'FileModifyDate' },
	'filename' => { 128 => 'FileName' },
	'filenameasdelivered' => { 358 => 'FileNameAsDelivered' },
	'filenumber' => { 62 => 0x1, 71 => 0x8, 105 => 0x1817, 122 => 'Canon-FileNumber', 235 => 0x4, 440 => 0x10, 441 => 0x95, 442 => 0x10 },
	'filenumbermemory' => { 200 => 0x1a },
	'filenumbersequence' => { 325 => '12.2', 330 => '3.1', 331 => '4.1', 332 => '4.1', 334 => '11.1', 335 => '4.3', 340 => '5.2', 341 => 0x4e, 342 => 0x48, 343 => 0x48, 344 => 0x48 },
	'filepermissions' => { 128 => 'FilePermissions' },
	'filesource' => { 127 => 0xa300, 135 => 0x8000, 542 => 'FileSource' },
	'fileuserid' => { 128 => 'FileUserID' },
	'fileversion' => { 151 => 0x16 },
	'fillflashautoreduction' => { 90 => 0xe, 91 => 0xe, 98 => 0xa },
	'filllight' => { 536 => 'FillLight', 538 => 'FillLight' },
	'fillorder' => { 127 => 0x10a },
	'filmgraineffect' => { 347 => 0x538 },
	'filmmode' => { 135 => 0x1401, 369 => 0x412, 372 => 0x42 },
	'filmtype' => { 284 => 0x2 },
	'filtereffect' => { 62 => 0xe, 276 => 0x37, 277 => 0x3f, 278 => 0x47, 372 => 0xa1 },
	'filtereffectauto' => { 78 => 0xa0 },
	'filtereffectfaithful' => { 77 => 0x70, 78 => 0x70 },
	'filtereffectlandscape' => { 77 => 0x40, 78 => 0x40 },
	'filtereffectmonochrome' => { 19 => 0xff, 77 => 0x88, 78 => 0x88 },
	'filtereffectneutral' => { 77 => 0x58, 78 => 0x58 },
	'filtereffectportrait' => { 77 => 0x28, 78 => 0x28 },
	'filtereffectstandard' => { 77 => 0x10, 78 => 0x10 },
	'filtereffectuserdef1' => { 77 => 0xa0, 78 => 0xb8 },
	'filtereffectuserdef2' => { 77 => 0xb8, 78 => 0xd0 },
	'filtereffectuserdef3' => { 77 => 0xd0, 78 => 0xe8 },
	'finderdisplayduringexposure' => { 91 => 0x1 },
	'finesharpness' => { 411 => 0x70 },
	'finetuneoptcenterweighted' => { 325 => '7.2', 326 => '9.1', 328 => '9.1', 329 => '9.1', 333 => '8.1', 338 => '9.1', 339 => '9.1', 340 => '9.1', 341 => 0x25, 342 => 0x23, 343 => 0x23, 344 => 0x23 },
	'finetuneopthighlightweighted' => { 328 => '46.1', 329 => '46.1', 338 => '46.1', 339 => '46.1', 341 => 0x29, 342 => 0x27, 343 => 0x27, 344 => 0x27 },
	'finetuneoptmatrixmetering' => { 325 => '8.1', 326 => '8.2', 328 => '8.2', 329 => '8.2', 333 => '7.2', 334 => '6.1', 338 => '8.2', 339 => '8.2', 340 => '8.2', 341 => 0x23, 342 => 0x21, 343 => 0x21, 344 => 0x21 },
	'finetuneoptspotmetering' => { 325 => '8.2', 326 => '9.2', 328 => '9.2', 329 => '9.2', 333 => '8.2', 334 => '6.2', 338 => '9.2', 339 => '9.2', 340 => '9.2', 341 => 0x27, 342 => 0x25, 343 => 0x25, 344 => 0x25 },
	'finishexposure' => { 157 => 0xdbd },
	'finishfiletype' => { 157 => 0xdb8 },
	'finishlook' => { 157 => 0xdbc },
	'finishnoise' => { 157 => 0xdba },
	'finishresolution' => { 157 => 0xdb9 },
	'finishsharpening' => { 157 => 0xdbb },
	'firmware' => { 352 => 0x405, 457 => [0x8c,0x17,0x3b], 533 => 'Firmware' },
	'firmware2' => { 457 => 0x57 },
	'firmwaredate' => { 120 => 0x15, 121 => 0x2001, 439 => 0x4, 440 => 0x30, 442 => 0x30 },
	'firmwareid' => { 207 => 0x0 },
	'firmwarename' => { 454 => 0xa001 },
	'firmwarerevision' => { 19 => 0xa4, 71 => 0x1e, 445 => 0x0 },
	'firmwarerevision2' => { 445 => 0xc },
	'firmwareversion' => { 7 => 0x10b, 11 => 0x136, 14 => 0xff, 15 => 0x107, 157 => [0x415,0xce5], 173 => 0x57, 175 => 'FirmwareVersion', 370 => 0x320, 372 => 0x2, 374 => 0x3109, 411 => 0x230, 437 => ['CNFV','FIRM','info'], 440 => 0x2a, 441 => 0x1a, 442 => 0x2a, 443 => 0x18, 447 => 0x2 },
	'firmwareversions' => { 420 => 0x301 },
	'firstframeactioninafc' => { 383 => 0x21f },
	'firstphotodate' => { 148 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 358 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 150 => 0x16, 530 => 'FixtureIdentifier' },
	'flash' => { 122 => 'XMP-Flash', 127 => 0x9209, 171 => 0x22, 201 => 0x1f, 202 => 0x15, 440 => 0x5a, 441 => 0x44, 442 => 0x6a, 542 => 'Flash' },
	'flashaction' => { 467 => 0x3e, 468 => 0x3e, 481 => 0x2017, 486 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 467 => 0x4c, 468 => 0x4c, 486 => 0x77 },
	'flashactionexternal' => { 486 => [0x78,0x7c] },
	'flashactivity' => { 38 => 0x1c },
	'flashbatterylevel' => { 49 => 0x249 },
	'flashbias' => { 372 => 0x24 },
	'flashbits' => { 38 => 0x1d },
	'flashburstpriority' => { 341 => 0x101, 342 => 0x111, 343 => 0x111, 344 => 0x129 },
	'flashbuttonfunction' => { 92 => 0x70e },
	'flashchargelevel' => { 352 => 0x1010 },
	'flashcolorfilter' => { 238 => 0x10, 239 => 0x10, 241 => 0x10 },
	'flashcommandermode' => { 236 => '9.1', 237 => '9.1', 238 => '9.1', 239 => '9.1', 241 => '9.1' },
	'flashcompensation' => { 157 => 0x3f3, 236 => 0xa, 237 => 0xa, 238 => 0xa, 239 => 0x27, 240 => 0xa, 241 => 0xa, 533 => 'FlashCompensation' },
	'flashcontrol' => { 467 => 0x23, 468 => 0x1f, 469 => 0x21 },
	'flashcontrolbuilt-in' => { 334 => '16.1', 335 => '23.1', 337 => '23.1', 338 => '24.1' },
	'flashcontrolmode' => { 236 => '9.2', 237 => '9.2', 238 => '9.2', 239 => '9.2', 241 => '9.2', 247 => 0x214, 262 => 0x2d4, 263 => 0x148, 264 => 0x1b8, 267 => 0x1a8, 268 => 0x1bc, 269 => 0x1bc, 347 => 0x404 },
	'flashcurtain' => { 372 => 0x48 },
	'flashdefault' => { 203 => 0x42 },
	'flashdevice' => { 352 => 0x1005 },
	'flashdistance' => { 121 => 0x2034 },
	'flashenergy' => { 127 => 0xa20b, 542 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 258 => 0x18 },
	'flashexposurecomp' => { 84 => 0xf, 135 => 0x1011, 178 => 'ExposureComp', 200 => 0x23, 205 => 0x104, 206 => 0x49c1, 258 => 0x12, 347 => 0x401, 352 => 0x1023, 411 => 0x4d, 447 => 0x100b, 457 => [0x3a,0x56], 481 => 0x104 },
	'flashexposurecomp2' => { 305 => 0x4d2 },
	'flashexposurecomp3' => { 238 => 0x1d },
	'flashexposurecomp4' => { 238 => 0x27 },
	'flashexposurecomparea' => { 326 => '38.4', 328 => '38.4', 329 => '38.4', 338 => '38.4', 339 => '38.4', 341 => 0x5d, 342 => 0x59, 343 => 0x59, 344 => 0x59 },
	'flashexposurecompset' => { 203 => 0x10, 380 => 0xe, 467 => 0x14, 468 => 0x12, 469 => 0x23, 486 => 0x1f },
	'flashexposurecompset2' => { 486 => [0x26,0x2c] },
	'flashexposureindicator' => { 203 => 0x54 },
	'flashexposureindicatorlast' => { 203 => 0x56 },
	'flashexposureindicatornext' => { 203 => 0x55 },
	'flashexposurelock' => { 62 => 0x19 },
	'flashfired' => { 159 => 0x5d, 178 => 'Fired', 200 => 0x14, 304 => '590.3', 542 => [\'Flash','FlashFired'] },
	'flashfiring' => { 92 => 0x306, 93 => 0x6, 94 => 0x7, 97 => 0x7 },
	'flashfirmwareversion' => { 348 => 0x1002 },
	'flashfocallength' => { 236 => 0xb, 237 => 0xc, 238 => 0xc, 239 => 0xc, 240 => 0xc, 241 => 0x26 },
	'flashfunction' => { 206 => 0x31, 542 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 236 => 0xe, 237 => 0xf, 238 => 0xf, 239 => 0xf, 240 => 0xf, 241 => 0xf, 247 => 0x21a, 262 => 0x2da, 263 => 0x14e, 267 => 0x1ae, 268 => 0x1c2, 269 => 0x1c2 },
	'flashgroupacompensation' => { 236 => 0x11, 237 => 0x12, 238 => 0x13, 239 => 0x28, 240 => 0x28, 241 => 0x28 },
	'flashgroupacontrolmode' => { 236 => 0xf, 237 => '16.1', 238 => '17.1', 239 => '17.1', 240 => '17.1', 241 => '17.1' },
	'flashgroupaoutput' => { 236 => 0x11, 237 => 0x12, 238 => 0x13, 239 => 0x28, 240 => 0x28, 241 => 0x28 },
	'flashgroupbcompensation' => { 236 => 0x12, 237 => 0x13, 238 => 0x14, 239 => 0x29, 240 => 0x29, 241 => 0x29 },
	'flashgroupbcontrolmode' => { 236 => 0x10, 237 => '17.1', 238 => '18.1', 239 => '18.1', 240 => '18.1', 241 => '18.1' },
	'flashgroupboutput' => { 236 => 0x12, 237 => 0x13, 238 => 0x14, 239 => 0x29, 240 => 0x29, 241 => 0x29 },
	'flashgroupccompensation' => { 237 => 0x14, 238 => 0x15, 239 => 0x2a, 240 => 0x2a, 241 => 0x2a },
	'flashgroupccontrolmode' => { 237 => '17.2', 238 => '18.2', 239 => '18.2', 240 => '18.2', 241 => '18.2' },
	'flashgroupcoutput' => { 237 => 0x14, 238 => 0x15, 239 => 0x2a, 240 => 0x2a, 241 => 0x2a },
	'flashguidenumber' => { 84 => 0xd, 102 => 0x0, 178 => 'GuideNumber' },
	'flashilluminationpattern' => { 241 => 0x25 },
	'flashintensity' => { 120 => [0x19,0x5], 347 => 0x405 },
	'flashlevel' => { 327 => 0x9, 481 => 0xb048 },
	'flashmake' => { 178 => 'Make' },
	'flashmanufacturer' => { 197 => 'FlashManufacturer' },
	'flashmastercompensation' => { 247 => 0x22e, 262 => 0x2ee, 263 => 0x162, 267 => 0x1aa, 268 => 0x1be, 269 => 0x1be },
	'flashmastercontrolmode' => { 247 => 0x22c, 262 => 0x2ec, 263 => 0x160 },
	'flashmasteroutput' => { 247 => 0x232, 262 => 0x2f2, 263 => 0x166 },
	'flashmetering' => { 200 => 0x3f, 203 => 0x1c },
	'flashmeteringmode' => { 7 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 18 => 0x15, 20 => 0x15, 22 => 0x15, 28 => 0x15 },
	'flashmeteringsegments' => { 411 => 0x20a },
	'flashmode' => { 120 => 0x4, 157 => 0x3f2, 159 => 0x5c, 170 => 0x27, 178 => 'Mode', 200 => 0x2, 201 => 0x20, 202 => 0x16, 203 => 0xf, 258 => 0x87, 347 => 0x400, 352 => 0x1004, 411 => 0xc, 418 => 0x4, 446 => 0x20, 447 => 0x100a, 456 => 0x225, 467 => 0x13, 468 => 0x7f, 469 => 0x20, 486 => 0x10, 490 => 0x1138, 491 => 0x1138, 492 => 0x1114, 493 => 0x1190, 494 => 0x116c, 495 => 0x1024, 496 => 0x21c, 497 => 0x21c, 498 => 0x211, 542 => [\'Flash','FlashMode'] },
	'flashmodebutton' => { 269 => 0x80e },
	'flashmodebuttonplaybackmode' => { 269 => 0x818 },
	'flashmodel' => { 178 => 'Model', 197 => 'FlashModel', 348 => 0x1001 },
	'flashoptions' => { 390 => 0x2 },
	'flashoptions2' => { 390 => 0x10 },
	'flashoutput' => { 49 => 0x248, 84 => 0x21, 236 => 0xa, 237 => 0xa, 238 => 0xa, 239 => 0x27, 241 => 0x21, 247 => 0x21e, 262 => 0x2de, 263 => 0x152, 267 => 0x1b2, 268 => 0x1c6, 269 => 0x1c6 },
	'flashpixversion' => { 127 => 0xa000, 542 => 'FlashpixVersion' },
	'flashredeyemode' => { 542 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 247 => 0x228, 262 => 0x2e8, 263 => 0x15c, 267 => 0x1bc, 347 => 0x403 },
	'flashreturn' => { 542 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 178 => 'SerialNumber', 348 => 0x1003 },
	'flashsetting' => { 258 => 0x8 },
	'flashshutterspeed' => { 325 => '20.2', 326 => '23.2', 328 => '23.2', 329 => '23.2', 334 => '15.2', 335 => '22.2', 336 => '7.2', 337 => '22.2', 338 => '23.2', 339 => '23.2', 340 => '23.1', 341 => 0x5b, 342 => 0x57, 343 => 0x57, 344 => 0x57 },
	'flashsource' => { 236 => 0x4, 237 => 0x4, 238 => 0x4, 239 => 0x4, 240 => 0x4, 241 => 0x4 },
	'flashstatus' => { 398 => 0x0, 486 => [0x82,0x86], 500 => 0x31, 501 => 0x39, 502 => 0x39 },
	'flashstatusbuilt-in' => { 469 => [0x87,0x287] },
	'flashstatusexternal' => { 469 => [0x88,0x288] },
	'flashsyncspeed' => { 325 => '20.1', 326 => '23.1', 328 => '23.1', 329 => '23.1', 334 => '15.1', 335 => '22.1', 337 => '22.1', 338 => '23.1', 339 => '23.1', 341 => 0x57, 342 => 0x53, 343 => 0x53, 344 => 0x53 },
	'flashsyncspeedav' => { 90 => 0x3, 92 => 0x10f, 93 => 0x2, 94 => 0x3, 95 => 0x2, 96 => 0x2, 97 => 0x3, 98 => 0x6 },
	'flashthreshold' => { 102 => 0x1 },
	'flashtype' => { 178 => 'Type', 203 => 0x59, 258 => 0x9, 348 => 0x1000 },
	'flashwarning' => { 335 => '30.1', 336 => '7.1', 340 => '31.1', 372 => 0x62 },
	'flashwirelessoption' => { 247 => 0x234, 262 => 0x2e6, 263 => 0x15a, 267 => 0x1c8 },
	'flexiblespotposition' => { 481 => 0x201d },
	'flickadvancedirection' => { 342 => 0x25f, 343 => 0x25f, 344 => 0x277 },
	'flickerreduce' => { 456 => 0x218 },
	'flickerreduction' => { 135 => 0x1446, 288 => 0x7 },
	'flickerreductionindicator' => { 283 => 0x532 },
	'flickerreductionshooting' => { 262 => 0x2d0, 264 => 0x1b4, 267 => 0x1a4, 268 => 0x1b8, 269 => 0x1b8 },
	'flightpitchdegree' => { 124 => 'FlightPitchDegree' },
	'flightrolldegree' => { 124 => 'FlightRollDegree' },
	'flightxspeed' => { 124 => 'FlightXSpeed' },
	'flightyawdegree' => { 124 => 'FlightYawDegree' },
	'flightyspeed' => { 124 => 'FlightYSpeed' },
	'flightzspeed' => { 124 => 'FlightZSpeed' },
	'fliphorizontal' => { 318 => 0x76a43206 },
	'fnumber' => { 7 => 0x3, 9 => 0x3, 11 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x3, 28 => 0x3, 29 => 0x3, 31 => 0x5, 32 => 0x6, 84 => 0x15, 127 => 0x829d, 156 => 0xfd04, 159 => 0x1e, 161 => 0xfa23, 163 => 0xf103, 166 => 0x13, 168 => 0x3c, 170 => 0x1c, 171 => 0x18, 173 => 0xc, 182 => 'FNumber', 200 => 0xa, 201 => 0x36, 202 => 0x47, 203 => 0x9, 206 => 0x49c7, 256 => 0x38, 371 => 0x35a, 411 => 0x13, 454 => 0xa019, 457 => [0x31,0x49], 467 => 0x1, 468 => 0x1, 486 => [0x20,0x22,0x26], 542 => 'FNumber' },
	'focaldistance' => { 146 => 'FocalDistance' },
	'focallength' => { 7 => 0x1d, 8 => 0xa, 9 => 0x23, 10 => 0x9, 11 => 0x1d, 12 => 0x9, 13 => 0x1e, 14 => 0x1d, 15 => 0x1d, 16 => 0x1e, 17 => 0x1e, 18 => 0x1e, 19 => 0x28, 20 => 0x1e, 21 => 0x23, 22 => 0x1e, 23 => 0x1e, 24 => 0x23, 25 => 0x23, 26 => 0x23, 27 => 0x23, 28 => 0x1e, 29 => 0x23, 64 => 0x1, 68 => 0x7, 121 => 0x1d, 127 => 0x920a, 166 => 0x1d, 182 => 'FocalLength', 200 => 0x12, 251 => 0xa, 252 => 0xb, 256 => [0xc,0x3c], 366 => 0x1, 411 => 0x1d, 420 => 0x403, 447 => 0x1500, 466 => 0xe, 494 => 0x1278, 495 => 0x1134, 496 => 0x32c, 497 => 0x32c, 498 => 0x30a, 542 => 'FocalLength' },
	'focallength2' => { 486 => [0x23,0x25,0x29] },
	'focallength35mm' => { 362 => 'FocalLength35mm' },
	'focallengthin35mmformat' => { 127 => 0xa405, 438 => 'camera.focal_length.35mm_equivalent', 454 => 0xa01a, 542 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 466 => 0x10 },
	'focalplaneafpointarea' => { 499 => 0x2 },
	'focalplaneafpointlocation1' => { 499 => 0x6 },
	'focalplaneafpointlocation10' => { 499 => 0x2a },
	'focalplaneafpointlocation11' => { 499 => 0x2e },
	'focalplaneafpointlocation12' => { 499 => 0x32 },
	'focalplaneafpointlocation13' => { 499 => 0x36 },
	'focalplaneafpointlocation14' => { 499 => 0x3a },
	'focalplaneafpointlocation15' => { 499 => 0x3e },
	'focalplaneafpointlocation2' => { 499 => 0xa },
	'focalplaneafpointlocation3' => { 499 => 0xe },
	'focalplaneafpointlocation4' => { 499 => 0x12 },
	'focalplaneafpointlocation5' => { 499 => 0x16 },
	'focalplaneafpointlocation6' => { 499 => 0x1a },
	'focalplaneafpointlocation7' => { 499 => 0x1e },
	'focalplaneafpointlocation8' => { 499 => 0x22 },
	'focalplaneafpointlocation9' => { 499 => 0x26 },
	'focalplaneafpointsused' => { 499 => 0x1 },
	'focalplanediagonal' => { 348 => 0x103, 352 => 0x205 },
	'focalplaneresolutionunit' => { 127 => 0xa210, 542 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 127 => 0xa20e, 542 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 64 => 0x2 },
	'focalplanexunknown' => { 64 => 0x2 },
	'focalplaneyresolution' => { 127 => 0xa20f, 542 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 64 => 0x3 },
	'focalplaneyunknown' => { 64 => 0x3 },
	'focalpointx' => { 146 => 'FocalPointX' },
	'focalpointy' => { 146 => 'FocalPointY' },
	'focaltype' => { 10 => 0x2d, 64 => 0x0 },
	'focalunits' => { 38 => 0x19 },
	'focus' => { 307 => 0x8 },
	'focusarea' => { 200 => 0x31 },
	'focusareaselection' => { 336 => '15.2' },
	'focusbracket' => { 372 => 0xbd },
	'focusbracketing' => { 38 => 0x32, 65 => 0x1 },
	'focusbracketingcropdepthcomposite' => { 65 => 0x6 },
	'focusbracketingdepthcomposite' => { 65 => 0x5 },
	'focusbracketingexposuresmoothing' => { 65 => 0x4 },
	'focusbracketingflashinterval' => { 65 => 0x7 },
	'focusbracketingfocusincrement' => { 65 => 0x3 },
	'focusbracketingimagecount' => { 65 => 0x2 },
	'focusbracketstepsize' => { 347 => 0x308 },
	'focuscontinuous' => { 38 => 0x20 },
	'focusdisplayaiservoandmf' => { 92 => 0x515 },
	'focusdistance' => { 182 => 'FocusDistance', 200 => 0x13, 206 => 0x49bb, 251 => 0x9, 252 => 0xa, 256 => [0xb,0x4e], 350 => 0x305, 366 => 0x0, 370 => 0x304, 371 => 0x304 },
	'focusdistancelower' => { 7 => 0x45, 9 => 0x8e, 11 => 0x45, 13 => 0x56, 14 => 0x45, 15 => 0x45, 16 => 0x52, 17 => 0x52, 18 => 0x56, 20 => 0x52, 21 => 0x8e, 22 => 0x59, 23 => 0x57, 24 => 0x8e, 25 => 0x94, 26 => 0x95, 27 => 0xa7, 28 => 0x56, 29 => 0xa7, 62 => 0x15, 84 => 0x14 },
	'focusdistancerange' => { 1 => 0xc },
	'focusdistancerangewidth' => { 256 => 0x4c },
	'focusdistanceupper' => { 7 => 0x43, 9 => 0x8c, 11 => 0x43, 13 => 0x54, 14 => 0x43, 15 => 0x43, 16 => 0x50, 17 => 0x50, 18 => 0x54, 20 => 0x50, 21 => 0x8c, 22 => 0x57, 23 => 0x55, 24 => 0x8c, 25 => 0x92, 26 => 0x93, 27 => 0xa5, 28 => 0x54, 29 => 0xa5, 62 => 0x14, 84 => 0x13 },
	'focusholdbutton' => { 203 => 0x44 },
	'focusinfoversion' => { 350 => 0x0 },
	'focusingscreen' => { 91 => 0x0, 92 => 0x80b, 97 => 0x0 },
	'focuslocation' => { 481 => 0x2027 },
	'focuslocation2' => { 481 => 0x204a },
	'focuslocked' => { 199 => 0x14 },
	'focusmode' => { 38 => 0x7, 120 => 0x3, 121 => [0x3003,0xd], 135 => 0x1021, 157 => 0x3f5, 159 => 0x38, 175 => 'FocusMode', 200 => 0x30, 202 => 0xe, 203 => 0xc, 258 => 0x7, 347 => 0x301, 352 => 0x100b, 372 => 0x7, 411 => 0xd, 418 => 0x3, 447 => 0x1006, 460 => [0xb,0x5], 466 => [0x15,0x1d], 467 => 0x4d, 468 => 0x4d, 481 => [0xb042,0xb04e,0x201b], 486 => 0x13, 507 => 0x16 },
	'focusmode2' => { 134 => '0.1', 390 => '3.1', 486 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 327 => '10.1', 464 => 0x14, 465 => 0x15, 467 => 0x10, 468 => 0xf, 469 => 0x6 },
	'focusmodeswitch' => { 203 => 0x58, 467 => 0x2e },
	'focuspeakingdisplay' => { 341 => 0x22f, 342 => 0x235, 343 => 0x235, 344 => 0x24d },
	'focuspeakinghighlightcolor' => { 341 => 0x53, 342 => 0x4b, 343 => 0x4b, 344 => 0x4b },
	'focuspeakinglevel' => { 341 => 0x51, 342 => 0x49, 343 => 0x49, 344 => 0x49 },
	'focuspixel' => { 135 => 0x1023 },
	'focuspointlock' => { 342 => 0x1d3, 343 => 0x1d3, 344 => 0x1eb },
	'focuspointpersistence' => { 341 => 0xf5, 342 => 0x105, 343 => 0x105, 344 => 0x11b },
	'focuspointwrap' => { 325 => '2.2', 326 => '2.2', 328 => '2.1', 329 => '2.1', 333 => '1.1', 334 => '2.2', 335 => '1.1', 338 => '2.2', 339 => '2.1', 340 => '2.5', 341 => 0x16, 342 => 0x16, 343 => 0x16, 344 => 0x16 },
	'focusposition' => { 1 => 0x2f, 251 => 0x8, 252 => 0x8, 411 => 0x10, 478 => 0x9bb },
	'focusposition2' => { 486 => [0x29,0x2b,0x2f], 507 => 0x2d, 510 => 0x20 },
	'focuspositionhorizontal' => { 215 => 0x2f, 216 => 0x43 },
	'focuspositionvertical' => { 215 => 0x31, 216 => 0x45 },
	'focusprocess' => { 347 => 0x302 },
	'focusrange' => { 38 => 0x12, 352 => 0x100a },
	'focusrangeindex' => { 401 => '3.1' },
	'focusresult' => { 216 => 0x4a },
	'focusringrotation' => { 92 => 0x713 },
	'focussetting' => { 457 => 0x6 },
	'focusshiftautoreset' => { 268 => 0x6da, 269 => 0x748 },
	'focusshiftexposurelock' => { 247 => 0x1b4, 262 => 0x224, 263 => 0xe8, 264 => 0x100, 267 => 0xf4, 268 => 0x104, 269 => 0x104 },
	'focusshiftinterval' => { 247 => 0x1b0, 262 => 0x220, 263 => 0xe4, 264 => 0xfc, 267 => 0xf0, 268 => 0x100, 269 => 0x100 },
	'focusshiftnumbershots' => { 247 => 0x1a8, 262 => 0x218, 263 => 0xdc, 264 => 0xf4, 267 => 0xe8, 268 => 0xf8, 269 => 0xf8 },
	'focusshiftshooting' => { 286 => 0x20 },
	'focusshiftstepwidth' => { 247 => 0x1ac, 262 => 0x21c, 263 => 0xe0, 264 => 0xf8, 267 => 0xec, 268 => 0xfc, 269 => 0xfc },
	'focusstatus' => { 466 => 0x19, 467 => 0x53, 468 => 0x53 },
	'focusstepcount' => { 350 => 0x301, 352 => 0x100e },
	'focusstepinfinity' => { 350 => 0x303, 352 => 0x103b },
	'focusstepnear' => { 350 => 0x304, 352 => 0x103c },
	'focusstepsfrominfinity' => { 256 => 0x58 },
	'focustrackinglockon' => { 325 => ['1.5','4.1'], 326 => '1.4', 333 => '0.4', 334 => '3.1', 335 => '0.4', 338 => '1.4' },
	'focuswarning' => { 135 => 0x1301 },
	'foldername' => { 200 => 0x27 },
	'foldernumber' => { 467 => 0x9a, 469 => [0x402,0x114,0x316] },
	'fontcomposite' => { 571 => [\'Fonts','FontsComposite'] },
	'fontface' => { 571 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 571 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 571 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 571 => [\'Fonts','FontsFontName'] },
	'fonts' => { 571 => 'Fonts' },
	'fonttype' => { 571 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 571 => [\'Fonts','FontsVersionString'] },
	'for' => { 427 => 'For' },
	'forcewrite' => { 128 => 'ForceWrite' },
	'format' => { 145 => 'Format', 437 => "\xa9fmt", 539 => 'format', 564 => 'Format' },
	'forwardlock' => { 561 => 'forwardlock' },
	'forwardmatrix1' => { 127 => 0xc714 },
	'forwardmatrix2' => { 127 => 0xc715 },
	'forwardmatrix3' => { 127 => 0xcd34 },
	'fossilspecimen' => { 126 => 'FossilSpecimen' },
	'fossilspecimenmaterialsampleid' => { 126 => [\'FossilSpecimen','FossilSpecimenMaterialSampleID'] },
	'framecount' => { 74 => [0x2,0x4] },
	'frameheight' => { 135 => 0x3822 },
	'framenum' => { 422 => 0xd7 },
	'framenumber' => { 135 => 0x8003, 206 => 0x3c, 411 => 0x29 },
	'framerate' => { 74 => [0x1,0x6], 127 => 0xc764, 135 => 0x3820 },
	'framereadouttime' => { 438 => 'camera.framereadouttimeinmicroseconds' },
	'framewidth' => { 135 => 0x3821 },
	'framing' => { 555 => 'framing' },
	'freebytes' => { 105 => 0x1 },
	'freememorycardimages' => { 201 => [0x37,0x54], 202 => [0x2d,0x4a], 203 => 0x32 },
	'fujiflashmode' => { 135 => 0x1010 },
	'fujimodel' => { 135 => 0x1447 },
	'fujimodel2' => { 135 => 0x1448 },
	'fullframerateplaybackintent' => { 431 => 'full-frame-rate-playback-intent' },
	'fullhdhighspeedrec' => { 135 => 0x3824 },
	'fullimagesize' => { 481 => 0xb02b },
	'fullpanoheightpixels' => { 148 => 'FullPanoHeightPixels', 149 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 148 => 'FullPanoWidthPixels', 149 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 447 => 0x100d },
	'fullsizeimage' => { 181 => 'data' },
	'fullsizeimagename' => { 181 => '1Name' },
	'fullsizeimagetype' => { 181 => '0Type' },
	'func1button' => { 328 => '14.1', 329 => '14.1', 339 => '14.1', 341 => 0x67, 342 => 0x63, 343 => 0x63, 344 => 0x63 },
	'func1buttonplaybackmode' => { 341 => 0x19f, 342 => 0x1a5, 343 => 0x1a5, 344 => 0x1bd },
	'func1buttonplusdials' => { 328 => '42.1', 329 => '42.1', 339 => '42.1' },
	'func2button' => { 328 => '80.1', 329 => '80.1', 339 => '80.1', 341 => 0x77, 342 => 0x73, 343 => 0x73, 344 => 0x73 },
	'func2buttonplaybackmode' => { 341 => 0x1a1, 342 => 0x1a7, 343 => 0x1a7, 344 => 0x1bf },
	'func2buttonplusdials' => { 328 => '81.1' },
	'func3button' => { 328 => '83.1', 342 => 0x119, 343 => 0x119, 344 => 0x131 },
	'func3buttonplaybackmode' => { 343 => 0x1a9, 344 => 0x1c1 },
	'func4button' => { 343 => 0x175, 344 => 0x18d },
	'func4buttonplaybackmode' => { 343 => 0x1af, 344 => 0x1c7 },
	'funcbutton' => { 325 => ['14.1','15.1'], 326 => '14.1', 334 => '28.1', 335 => '13.1', 338 => '14.1', 340 => '14.1' },
	'funcbuttonplusdials' => { 325 => ['14.2','15.2'], 326 => '14.2', 334 => '31.1', 338 => '42.1' },
	'functionbutton' => { 332 => '13.1', 336 => '5.2' },
	'gainbase' => { 351 => 0x610 },
	'gaincontrol' => { 127 => 0xa407, 542 => 'GainControl' },
	'gainmapmax' => { 547 => 'GainMapMax' },
	'gainmapmin' => { 547 => 'GainMapMin' },
	'gamma' => { 127 => 0xa500, 157 => 0x8fe, 359 => 'gAMA', 377 => 0x11c, 543 => 'Gamma', 547 => 'Gamma' },
	'gammablackpoint' => { 113 => 0xc },
	'gammacolortone' => { 113 => 0x3 },
	'gammacompensatedvalue' => { 152 => 0x91 },
	'gammacontrast' => { 113 => 0x2 },
	'gammacurveoutputrange' => { 113 => 0xf },
	'gammahighlight' => { 113 => 0xa },
	'gammalinear' => { 111 => 0x20200 },
	'gammamidpoint' => { 113 => 0xe },
	'gammasaturation' => { 113 => 0x4 },
	'gammashadow' => { 113 => 0x9 },
	'gammasharpnessstrength' => { 113 => 0x8 },
	'gammaunsharpmaskfineness' => { 113 => 0x6 },
	'gammaunsharpmaskstrength' => { 113 => 0x5 },
	'gammaunsharpmaskthreshold' => { 113 => 0x7 },
	'gammawhitepoint' => { 113 => 0xd },
	'garminsettings' => { 437 => 'pmcc' },
	'garminsoftware' => { 437 => 'uuid' },
	'gdalmetadata' => { 127 => 0xa480 },
	'gdalnodata' => { 127 => 0xa481 },
	'geimagesize' => { 135 => 0x1304 },
	'gemake' => { 137 => 0x300 },
	'gemodel' => { 137 => 0x207 },
	'genre' => { 429 => ['gnre',"\xa9gen"], 431 => 'genre', 437 => ['gnre',"\xa9gen"], 550 => 'Genre', 556 => 'genre', 566 => 'genre' },
	'genrecvid' => { 550 => [\'Genre','GenreCvId'] },
	'genrecvtermid' => { 550 => [\'Genre','GenreCvTermId'] },
	'genrecvtermname' => { 550 => [\'Genre','GenreCvTermName'] },
	'genrecvtermrefinedabout' => { 550 => [\'Genre','GenreCvTermRefinedAbout'] },
	'genreid' => { 429 => 'geID' },
	'geography' => { 557 => 'geography' },
	'geolocate' => { 128 => 'Geolocate' },
	'geologicalcontext' => { 126 => 'GeologicalContext' },
	'geologicalcontextbed' => { 126 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 126 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 126 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 126 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 126 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 128 => 'Geosync' },
	'geotag' => { 128 => 'Geotag' },
	'geotiffasciiparams' => { 127 => 0x87b1 },
	'geotiffdirectory' => { 127 => 0x87af },
	'geotiffdoubleparams' => { 127 => 0x87b0 },
	'geotime' => { 128 => 'Geotime' },
	'giftftppriority' => { 524 => 'GIFTFtpPriority' },
	'gimbalpitchdegree' => { 124 => 'GimbalPitchDegree' },
	'gimbalreverse' => { 124 => 'GimbalReverse' },
	'gimbalrolldegree' => { 124 => 'GimbalRollDegree' },
	'gimbalyawdegree' => { 124 => 'GimbalYawDegree' },
	'globalaltitude' => { 425 => 0x419 },
	'globalangle' => { 425 => 0x40d },
	'gndfiltertype' => { 351 => 0x2110 },
	'good' => { 566 => 'good' },
	'googlehostheader' => { 429 => 'gshh' },
	'googlepingmessage' => { 429 => 'gspm' },
	'googlepingurl' => { 429 => 'gspu' },
	'googleplusuploadcode' => { 127 => 0x9009 },
	'googlesourcedata' => { 429 => 'gssd' },
	'googlestarttime' => { 429 => 'gsst' },
	'googletrackduration' => { 429 => 'gstd' },
	'goprotype' => { 437 => 'GoPr' },
	'gpsaltitude' => { 139 => 0x6, 179 => 'Altitude', 542 => 'GPSAltitude' },
	'gpsaltituderef' => { 139 => 0x5, 542 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 139 => 0x1c, 542 => 'GPSAreaInformation' },
	'gpscoordinates' => { 429 => "\xa9xyz", 431 => 'location.ISO6709', 437 => ['@xyz',"\xa9xyz"] },
	'gpsdatestamp' => { 139 => 0x1d },
	'gpsdatetime' => { 179 => 'DateTime', 542 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 139 => 0x18, 179 => 'Bearing', 542 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 139 => 0x17, 542 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 139 => 0x1a, 179 => 'Distance', 542 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 139 => 0x19, 542 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 139 => 0x14, 542 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 139 => 0x13 },
	'gpsdestlongitude' => { 139 => 0x16, 542 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 139 => 0x15 },
	'gpsdifferential' => { 139 => 0x1e, 179 => 'Differential', 542 => 'GPSDifferential' },
	'gpsdop' => { 139 => 0xb, 542 => 'GPSDOP' },
	'gpshpositioningerror' => { 139 => 0x1f, 542 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 139 => 0x11, 542 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 139 => 0x10, 542 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 122 => 'GPS-GPSLatitude', 124 => 'GpsLatitude', 139 => 0x2, 179 => 'Latitude', 542 => 'GPSLatitude' },
	'gpslatituderef' => { 139 => 0x1 },
	'gpslongitude' => { 122 => 'GPS-GPSLongitude', 124 => 'GpsLongitude', 139 => 0x4, 179 => 'Longitude', 542 => 'GPSLongitude' },
	'gpslongituderef' => { 139 => 0x3 },
	'gpslongtitude' => { 124 => 'GpsLongtitude' },
	'gpsmapdatum' => { 139 => 0x12, 179 => 'Datum', 542 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 139 => 0xa, 179 => 'MeasureMode', 542 => 'GPSMeasureMode' },
	'gpsposition' => { 122 => 'Exif-GPSPosition' },
	'gpsprocessingmethod' => { 139 => 0x1b, 542 => 'GPSProcessingMethod' },
	'gpssatellites' => { 139 => 0x8, 179 => 'Satellites', 542 => 'GPSSatellites' },
	'gpsspeed' => { 139 => 0xd, 179 => 'Speed', 542 => 'GPSSpeed' },
	'gpsspeedref' => { 139 => 0xc, 542 => 'GPSSpeedRef' },
	'gpsstatus' => { 139 => 0x9, 542 => 'GPSStatus' },
	'gpsstring' => { 157 => 0x402 },
	'gpstimestamp' => { 139 => 0x7 },
	'gpstrack' => { 139 => 0xf, 179 => 'Heading', 542 => 'GPSTrack' },
	'gpstrackref' => { 139 => 0xe, 542 => 'GPSTrackRef' },
	'gpsversionid' => { 139 => 0x0, 542 => 'GPSVersionID' },
	'gradation' => { 347 => 0x50f },
	'gradientbasedcorractive' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrblacks2012' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBlacks2012'] },
	'gradientbasedcorrbrightness' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrcorrectionname' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionName'] },
	'gradientbasedcorrcorrectionsyncid' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionSyncID'] },
	'gradientbasedcorrdefringe' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrdehaze' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDehaze'] },
	'gradientbasedcorrections' => { 536 => 'GradientBasedCorrections', 538 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHue'] },
	'gradientbasedcorrluminancenoise' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskinputdigest' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksInputDigest'] },
	'gradientbasedcorrmaskleft' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmaskactive' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskActive'] },
	'gradientbasedcorrmaskmaskblendmode' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmaskdigest' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskDigest'] },
	'gradientbasedcorrmaskmaskinverted' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskInverted'] },
	'gradientbasedcorrmaskmaskname' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskName'] },
	'gradientbasedcorrmaskmasks' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasks'] },
	'gradientbasedcorrmaskmasksalpha' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'gradientbasedcorrmaskmasksangle' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksAngle'] },
	'gradientbasedcorrmaskmasksbottom' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksBottom'] },
	'gradientbasedcorrmaskmaskscentervalue' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'gradientbasedcorrmaskmaskscenterweight' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'gradientbasedcorrmaskmasksdabs' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksDabs'] },
	'gradientbasedcorrmaskmasksfeather' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFeather'] },
	'gradientbasedcorrmaskmasksflipped' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'gradientbasedcorrmaskmasksflow' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFlow'] },
	'gradientbasedcorrmaskmasksfullx' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullX'] },
	'gradientbasedcorrmaskmasksfully' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksFullY'] },
	'gradientbasedcorrmaskmasksinputdigest' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'gradientbasedcorrmaskmasksleft' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksLeft'] },
	'gradientbasedcorrmaskmasksmaskactive' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'gradientbasedcorrmaskmasksmaskblendmode' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'gradientbasedcorrmaskmasksmaskdigest' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'gradientbasedcorrmaskmasksmaskinverted' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'gradientbasedcorrmaskmasksmaskname' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'gradientbasedcorrmaskmasksmasksubtype' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksmasksyncid' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'gradientbasedcorrmaskmasksmaskversion' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'gradientbasedcorrmaskmasksmidpoint' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'gradientbasedcorrmaskmasksorigin' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'gradientbasedcorrmaskmasksperimetervalue' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'gradientbasedcorrmaskmasksradius' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRadius'] },
	'gradientbasedcorrmaskmasksreferencepoint' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'gradientbasedcorrmaskmasksright' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRight'] },
	'gradientbasedcorrmaskmasksroundness' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'gradientbasedcorrmaskmaskssizex' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'gradientbasedcorrmaskmaskssizey' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'gradientbasedcorrmaskmaskstop' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksTop'] },
	'gradientbasedcorrmaskmasksubtype' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSubType'] },
	'gradientbasedcorrmaskmasksvalue' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'gradientbasedcorrmaskmasksversion' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksVersion'] },
	'gradientbasedcorrmaskmaskswhat' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWhat'] },
	'gradientbasedcorrmaskmaskswholeimagearea' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'gradientbasedcorrmaskmasksx' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksX'] },
	'gradientbasedcorrmaskmasksy' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksY'] },
	'gradientbasedcorrmaskmasksyncid' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'gradientbasedcorrmaskmaskszerox' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'gradientbasedcorrmaskmaskszeroy' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'gradientbasedcorrmaskmaskversion' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskVersion'] },
	'gradientbasedcorrmaskmidpoint' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskorigin' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksOrigin'] },
	'gradientbasedcorrmaskperimetervalue' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskrange' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'gradientbasedcorrmaskrangeareamodels' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrmaskrangeareamodelscolorsampleinfo' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrmaskrangeareamodelscomponents' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrmaskrangecoloramount' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrmaskrangedepthfeather' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrmaskrangedepthmax' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrmaskrangedepthmin' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrmaskrangeinvert' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'gradientbasedcorrmaskrangelumfeather' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrmaskrangeluminancedepthsampleinfo' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrmaskrangelummax' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrmaskrangelummin' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrmaskrangelumrange' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrmaskrangesampletype' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrmaskrangetype' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'gradientbasedcorrmaskrangeversion' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'gradientbasedcorrmaskreferencepoint' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksReferencePoint'] },
	'gradientbasedcorrmaskright' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskwholeimagearea' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'gradientbasedcorrmaskx' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrrangemask' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMask'] },
	'gradientbasedcorrrangemaskareamodels' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'gradientbasedcorrrangemaskareamodelscolorsampleinfo' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'gradientbasedcorrrangemaskareamodelscomponents' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'gradientbasedcorrrangemaskcoloramount' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'gradientbasedcorrrangemaskdepthfeather' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'gradientbasedcorrrangemaskdepthmax' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'gradientbasedcorrrangemaskdepthmin' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'gradientbasedcorrrangemaskinvert' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskInvert'] },
	'gradientbasedcorrrangemasklumfeather' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'gradientbasedcorrrangemaskluminancedepthsampleinfo' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'gradientbasedcorrrangemasklummax' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'gradientbasedcorrrangemasklummin' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'gradientbasedcorrrangemasklumrange' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'gradientbasedcorrrangemasksampletype' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'gradientbasedcorrrangemasktype' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskType'] },
	'gradientbasedcorrrangemaskversion' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionRangeMaskVersion'] },
	'gradientbasedcorrsaturation' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation'] },
	'gradientbasedcorrshadows2012' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtexture' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTexture'] },
	'gradientbasedcorrtint' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrtoninghue' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrtoningsaturation' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrwhat' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'gradientbasedcorrwhites2012' => { 536 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'], 538 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalWhites2012'] },
	'grainamount' => { 536 => 'GrainAmount', 538 => 'GrainAmount' },
	'graineffectroughness' => { 135 => 0x1047 },
	'graineffectsize' => { 135 => 0x104c },
	'grainfrequency' => { 536 => 'GrainFrequency', 538 => 'GrainFrequency' },
	'grainseed' => { 536 => 'GrainSeed', 538 => 'GrainSeed' },
	'grainsize' => { 536 => 'GrainSize', 538 => 'GrainSize' },
	'graymixeraqua' => { 536 => 'GrayMixerAqua', 538 => 'GrayMixerAqua' },
	'graymixerblue' => { 536 => 'GrayMixerBlue', 538 => 'GrayMixerBlue' },
	'graymixergreen' => { 536 => 'GrayMixerGreen', 538 => 'GrayMixerGreen' },
	'graymixermagenta' => { 536 => 'GrayMixerMagenta', 538 => 'GrayMixerMagenta' },
	'graymixerorange' => { 536 => 'GrayMixerOrange', 538 => 'GrayMixerOrange' },
	'graymixerpurple' => { 536 => 'GrayMixerPurple', 538 => 'GrayMixerPurple' },
	'graymixerred' => { 536 => 'GrayMixerRed', 538 => 'GrayMixerRed' },
	'graymixeryellow' => { 536 => 'GrayMixerYellow', 538 => 'GrayMixerYellow' },
	'graypoint' => { 518 => 0x8021 },
	'grayresponseunit' => { 127 => 0x122 },
	'greencurvelimits' => { 116 => 0x1c4 },
	'greencurvepoints' => { 115 => 0x53, 116 => 0x19a },
	'greenghostmitigationstatus' => { 1 => 0x3f },
	'greenhsl' => { 111 => 0x20913 },
	'greenhue' => { 536 => 'GreenHue', 538 => 'GreenHue' },
	'greensaturation' => { 536 => 'GreenSaturation', 538 => 'GreenSaturation' },
	'griddisplay' => { 325 => '13.3', 326 => '4.3', 328 => '4.2', 329 => '4.2', 330 => '2.2', 334 => '10.5', 335 => '3.4', 336 => '6.1', 338 => '4.4', 339 => '4.2', 340 => '4.2' },
	'gripbatteryadload' => { 387 => 0x5 },
	'gripbatteryadnoload' => { 387 => 0x4 },
	'gripbatterypercent' => { 387 => 0x11 },
	'gripbatterystate' => { 387 => ['1.2',0x10] },
	'gripbatteryvoltage' => { 387 => 0x12 },
	'group' => { 536 => 'Group', 538 => 'Group' },
	'groupareaafillumination' => { 326 => '46.4', 329 => '47.4', 338 => '47.4' },
	'grouping' => { 429 => ['grup',"\xa9grp"], 437 => "\xa9grp" },
	'guid' => { 429 => 'GUID' },
	'h2resetblackpixels' => { 157 => 0x18a6 },
	'h3resetblackcolumns' => { 157 => 0x18ce },
	'h3resetblackpixels' => { 157 => 0x18b0 },
	'halftonehints' => { 127 => 0x141 },
	'hardlink' => { 128 => 'HardLink' },
	'hasalternative' => { 556 => 'hasAlternative' },
	'hascorrection' => { 556 => 'hasCorrection' },
	'hascorrectiona-lang' => { 556 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 556 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 556 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 536 => 'HasCrop', 538 => 'HasCrop' },
	'hasextendedxmp' => { 568 => 'HasExtendedXMP' },
	'hassettings' => { 536 => 'HasSettings', 538 => 'HasSettings' },
	'hastranslation' => { 556 => 'hasTranslation' },
	'hasvisibleoverprint' => { 571 => 'HasVisibleOverprint' },
	'hasvisibletransparency' => { 571 => 'HasVisibleTransparency' },
	'hdmioutputn-log' => { 263 => 0x35a },
	'hdmioutputresolution' => { 265 => 0x710, 266 => 0x770, 267 => 0x610, 268 => 0x640, 269 => 0x6a8 },
	'hdmiviewassist' => { 343 => 0x20f, 344 => 0x227 },
	'hdr' => { 66 => 0x1, 243 => 0x4, 244 => 0x4, 262 => 0x354, 264 => 0x23a, 269 => 0x23a, 372 => 0x9e, 411 => 0x85, 481 => 0x200a },
	'hdr-pq' => { 38 => 0x34 },
	'hdrcapacitymax' => { 547 => 'HDRCapacityMax' },
	'hdrcapacitymin' => { 547 => 'HDRCapacityMin' },
	'hdreditmode' => { 536 => 'HDREditMode', 538 => 'HDREditMode' },
	'hdreffect' => { 66 => 0x2 },
	'hdrgain' => { 1 => 0x30 },
	'hdrgainmapversion' => { 525 => 'HDRGainMapVersion' },
	'hdrheadroom' => { 1 => 0x21 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrlevel' => { 243 => 0x5, 244 => 0x5, 262 => 0x360, 264 => 0x246, 269 => 0x246, 469 => 0x2e, 486 => 0x17 },
	'hdrlevel2' => { 243 => 0x7 },
	'hdrplusmakernote' => { 142 => 'HdrPlusMakernote' },
	'hdrpmakernote' => { 142 => 'hdrp_makernote' },
	'hdrsetting' => { 469 => 0x2d, 486 => 0x16, 490 => 0x1148, 491 => 0x1148, 492 => 0x1124, 493 => 0x11a0, 494 => 0x117c, 495 => 0x1034, 496 => 0x22c, 497 => 0x22c, 498 => 0x21f },
	'hdrsmoothing' => { 243 => 0x6 },
	'hdvideo' => { 429 => 'hdvd' },
	'headline' => { 150 => 0x69, 550 => 'Headline', 554 => 'Headline' },
	'hiddendatalength' => { 479 => 0x1 },
	'hiddendataoffset' => { 479 => 0x0 },
	'hierarchicalkeywords' => { 190 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 190 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 190 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 190 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 190 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 190 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 190 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 190 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 190 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 190 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 190 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 190 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 190 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 190 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 190 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 190 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 190 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 190 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 527 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 126 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highframerate' => { 262 => 0x16c, 264 => 0x48, 268 => 0x48, 269 => 0x48 },
	'highfrequencyflickerreduction' => { 262 => 0x386, 264 => 0x27c, 268 => 0x27c, 269 => 0x27c },
	'highisomultiplierblue' => { 377 => 0x1a },
	'highisomultipliergreen' => { 377 => 0x19 },
	'highisomultiplierred' => { 377 => 0x18 },
	'highisonoisereduction' => { 16 => 0xbc, 17 => 0xbd, 20 => 0xbd, 28 => 0xc9, 69 => 0x5, 92 => 0x202, 258 => 0xb1, 411 => 0x71, 467 => 0x2c, 468 => 0x26, 469 => 0x26, 481 => 0x2009, 486 => 0x12, 513 => 0x42 },
	'highisonoisereduction2' => { 481 => 0xb050 },
	'highlight' => { 457 => 0xf },
	'highlight2012' => { 536 => 'Highlight2012', 538 => 'Highlight2012' },
	'highlightadj' => { 111 => 0x2030c },
	'highlightcolordistortreduct' => { 518 => 0x8026 },
	'highlightlinearitylimit' => { 454 => 0xa025 },
	'highlightprotection' => { 317 => 0x6 },
	'highlightrecovery' => { 536 => 'HighlightRecovery', 538 => 'HighlightRecovery' },
	'highlights' => { 481 => 0x2033, 529 => 'Highlights' },
	'highlights2012' => { 536 => 'Highlights2012', 538 => 'Highlights2012' },
	'highlightsadj' => { 518 => 0x9019 },
	'highlightshadow' => { 372 => 0xad },
	'highlighttone' => { 135 => 0x1041 },
	'highlighttonepriority' => { 13 => 0x7, 16 => 0x7, 17 => 0x7, 18 => 0x7, 20 => 0x7, 22 => 0x7, 28 => 0x7, 69 => 0x3, 92 => 0x203 },
	'highlightwarning' => { 372 => 0x8002 },
	'highlowkeyadj' => { 411 => 0x6c },
	'highspeedsync' => { 203 => 0x5, 341 => 0x59, 342 => 0x55, 343 => 0x55, 344 => 0x55, 467 => 0x2, 468 => 0x2 },
	'hintversion' => { 437 => 'hinv' },
	'histogramxml' => { 318 => 0x83a1a25 },
	'history' => { 554 => 'History', 567 => 'History' },
	'historyaction' => { 567 => [\'History','HistoryAction'] },
	'historychanged' => { 567 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 567 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 567 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 567 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 567 => [\'History','HistoryWhen'] },
	'holefilldarkdeltathreshold' => { 157 => 0xc88 },
	'holefilldeltathreshold' => { 157 => 0xc7e },
	'hometowncity' => { 121 => 0x3006, 411 => 0x23, 417 => 0x2 },
	'hometowncitycode' => { 418 => 0x1000 },
	'hometowndst' => { 411 => 0x25, 417 => '0.2' },
	'hostcomputer' => { 127 => 0x13c },
	'hostsoftwarerendering' => { 157 => 0xce7 },
	'hue' => { 208 => 0x3b, 277 => 0x3d, 278 => 0x45, 411 => 0x67 },
	'hueadj' => { 321 => 0x2f, 518 => 0x8019 },
	'hueadjust' => { 447 => 0x1016 },
	'hueadjustment' => { 201 => 0x4a, 202 => 0x40, 258 => 0x92, 276 => 0x36 },
	'hueadjustmentaqua' => { 536 => 'HueAdjustmentAqua', 538 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 536 => 'HueAdjustmentBlue', 538 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 536 => 'HueAdjustmentGreen', 538 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 536 => 'HueAdjustmentMagenta', 538 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 536 => 'HueAdjustmentOrange', 538 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 536 => 'HueAdjustmentPurple', 538 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 536 => 'HueAdjustmentRed', 538 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 536 => 'HueAdjustmentYellow', 538 => 'HueAdjustmentYellow' },
	'huesetting' => { 355 => 0x1011 },
	'humanobservation' => { 126 => 'HumanObservation' },
	'humanobservationday' => { 126 => [\'HumanObservation','HumanObservationDay'] },
	'humanobservationearliestdate' => { 126 => [\'HumanObservation','HumanObservationEarliestDate'] },
	'humanobservationenddayofyear' => { 126 => [\'HumanObservation','HumanObservationEndDayOfYear'] },
	'humanobservationeventdate' => { 126 => [\'HumanObservation','HumanObservationEventDate'] },
	'humanobservationeventid' => { 126 => [\'HumanObservation','HumanObservationEventID'] },
	'humanobservationeventremarks' => { 126 => [\'HumanObservation','HumanObservationEventRemarks'] },
	'humanobservationeventtime' => { 126 => [\'HumanObservation','HumanObservationEventTime'] },
	'humanobservationeventtype' => { 126 => [\'HumanObservation','HumanObservationEventType'] },
	'humanobservationfieldnotes' => { 126 => [\'HumanObservation','HumanObservationFieldNotes'] },
	'humanobservationfieldnumber' => { 126 => [\'HumanObservation','HumanObservationFieldNumber'] },
	'humanobservationhabitat' => { 126 => [\'HumanObservation','HumanObservationHabitat'] },
	'humanobservationlatestdate' => { 126 => [\'HumanObservation','HumanObservationLatestDate'] },
	'humanobservationmonth' => { 126 => [\'HumanObservation','HumanObservationMonth'] },
	'humanobservationparenteventid' => { 126 => [\'HumanObservation','HumanObservationParentEventID'] },
	'humanobservationsamplesizeunit' => { 126 => [\'HumanObservation','HumanObservationSampleSizeUnit'] },
	'humanobservationsamplesizevalue' => { 126 => [\'HumanObservation','HumanObservationSampleSizeValue'] },
	'humanobservationsamplingeffort' => { 126 => [\'HumanObservation','HumanObservationSamplingEffort'] },
	'humanobservationsamplingprotocol' => { 126 => [\'HumanObservation','HumanObservationSamplingProtocol'] },
	'humanobservationstartdayofyear' => { 126 => [\'HumanObservation','HumanObservationStartDayOfYear'] },
	'humanobservationverbatimeventdate' => { 126 => [\'HumanObservation','HumanObservationVerbatimEventDate'] },
	'humanobservationyear' => { 126 => [\'HumanObservation','HumanObservationYear'] },
	'humidity' => { 127 => 0x9401, 543 => 'Humidity' },
	'hybridloggamma' => { 372 => 0xd4 },
	'icc_profile' => { 128 => 'ICC_Profile', 138 => 'ICCRGBG1/012' },
	'iccprofilename' => { 554 => 'ICCProfile' },
	'iconuri' => { 437 => 'icnu' },
	'idccreativestyle' => { 518 => 0x8000 },
	'idcpreviewlength' => { 518 => 0x202 },
	'idcpreviewstart' => { 518 => 0x201 },
	'identification' => { 126 => 'Identification' },
	'identificationid' => { 126 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 126 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 126 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 126 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 126 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 126 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifiedbyid' => { 126 => [\'Identification','IdentificationIdentifiedByID'] },
	'identifier' => { 539 => 'identifier', 564 => 'Identifier' },
	'ifcameramodel' => { 157 => 0x9c8 },
	'illuminantdata1' => { 127 => 0xcd35 },
	'illuminantdata2' => { 127 => 0xcd36 },
	'illuminantdata3' => { 127 => 0xcd37 },
	'illumination' => { 336 => '0.5', 443 => 0x48 },
	'imageabsolutex' => { 157 => 0x3fe },
	'imageabsolutey' => { 157 => 0x3ff },
	'imageadjustment' => { 258 => 0x80, 307 => 0x5 },
	'imagealterationconstraints' => { 358 => 'ImageAlterationConstraints' },
	'imagearea' => { 248 => 0x2b, 285 => 0x2b, 293 => 0x10, 296 => 0x10 },
	'imageareaoffset' => { 411 => 0x38 },
	'imageauthentication' => { 258 => 0x20 },
	'imageboundary' => { 258 => 0x16 },
	'imagecapturerequestid' => { 1 => 0x20 },
	'imagecapturetype' => { 1 => 0x14 },
	'imagecount' => { 35 => 0x86d, 135 => 0x1438, 258 => 0xa5, 484 => 0x11b },
	'imagecreator' => { 358 => 'ImageCreator' },
	'imagecreatorid' => { 358 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 358 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 358 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagecropx' => { 157 => 0x41f },
	'imagecropy' => { 157 => 0x420 },
	'imagedata' => { 147 => 'Data' },
	'imagedatasize' => { 258 => 0xa2 },
	'imagedescription' => { 127 => 0x10e, 562 => 'ImageDescription' },
	'imageduplicationconstraints' => { 358 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 318 => 0xfe443a45 },
	'imageeditcount' => { 411 => 0x41 },
	'imageediting' => { 411 => 0x32 },
	'imageeditingsoftware' => { 127 => 0xa43b, 543 => 'ImageEditingSoftware' },
	'imageeditor' => { 127 => 0xa438, 543 => 'ImageEditor' },
	'imageeffects' => { 447 => 0x1010 },
	'imagefileconstraints' => { 358 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 358 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 358 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 135 => 0x1436 },
	'imageheight' => { 127 => 0x101, 145 => 'ImageHeight', 207 => 0xc, 420 => 0x10d, 562 => 'ImageLength' },
	'imagehistory' => { 127 => 0x9213, 541 => 'ImageHistory' },
	'imageidnumber' => { 367 => 0x340 },
	'imagemimetype' => { 147 => 'Mime' },
	'imagenumber' => { 127 => 0x9211, 175 => 'ImageNumber', 201 => 0xae, 202 => 0x5e, 420 => 0x113, 467 => 0x9b, 469 => [0x400,'276.1',0x314], 533 => 'ImageNumber' },
	'imagenumber2' => { 202 => 0x62 },
	'imageoptimization' => { 258 => 0xa9 },
	'imageorientation' => { 150 => 0x83 },
	'imageprocessing' => { 258 => 0x1a },
	'imageprocessingfiledatecreated' => { 157 => 0xc81 },
	'imageprocessingfiletagsversionnumber' => { 157 => 0xc80 },
	'imageprocessingflags' => { 1 => 0x19 },
	'imageprocessingversion' => { 351 => 0x0 },
	'imagequality' => { 175 => 'ImageQuality', 295 => '723.2', 296 => '732.2', 304 => '708.1', 372 => 0x1 },
	'imagequality2' => { 347 => 0x603 },
	'imagerank' => { 524 => 'ImageRank' },
	'imagerbiassettlingdelaymsec' => { 157 => 0x600 },
	'imagerboardversion' => { 157 => 0x439 },
	'imagercols' => { 157 => 0x17d4 },
	'imageref' => { 548 => 'ImageRef' },
	'imageregion' => { 550 => 'ImageRegion' },
	'imageregionboundary' => { 550 => [\'ImageRegion','ImageRegionRegionBoundary'] },
	'imageregionboundaryh' => { 550 => [\'ImageRegion','ImageRegionRegionBoundaryRbH'] },
	'imageregionboundaryrx' => { 550 => [\'ImageRegion','ImageRegionRegionBoundaryRbRx'] },
	'imageregionboundaryshape' => { 550 => [\'ImageRegion','ImageRegionRegionBoundaryRbShape'] },
	'imageregionboundaryunit' => { 550 => [\'ImageRegion','ImageRegionRegionBoundaryRbUnit'] },
	'imageregionboundaryvertices' => { 550 => [\'ImageRegion','ImageRegionRegionBoundaryRbVertices'] },
	'imageregionboundaryverticesx' => { 550 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbX'] },
	'imageregionboundaryverticesy' => { 550 => [\'ImageRegion','ImageRegionRegionBoundaryRbVerticesRbY'] },
	'imageregionboundaryw' => { 550 => [\'ImageRegion','ImageRegionRegionBoundaryRbW'] },
	'imageregionboundaryx' => { 550 => [\'ImageRegion','ImageRegionRegionBoundaryRbX'] },
	'imageregionboundaryy' => { 550 => [\'ImageRegion','ImageRegionRegionBoundaryRbY'] },
	'imageregionctype' => { 550 => [\'ImageRegion','ImageRegionRCtype'] },
	'imageregionctypeidentifier' => { 550 => [\'ImageRegion','ImageRegionRCtypeIdentifier'] },
	'imageregionctypename' => { 550 => [\'ImageRegion','ImageRegionRCtypeName'] },
	'imageregionid' => { 550 => [\'ImageRegion','ImageRegionRId'] },
	'imageregionname' => { 550 => [\'ImageRegion','ImageRegionName'] },
	'imageregionrole' => { 550 => [\'ImageRegion','ImageRegionRRole'] },
	'imageregionroleidentifier' => { 550 => [\'ImageRegion','ImageRegionRRoleIdentifier'] },
	'imageregionrolename' => { 550 => [\'ImageRegion','ImageRegionRRoleName'] },
	'imageresolution' => { 157 => 0x944 },
	'imageresolutionjpg' => { 157 => 0x945 },
	'imagereview' => { 327 => '0.4', 336 => '0.4' },
	'imagereviewmonitorofftime' => { 326 => '21.1', 328 => '21.1', 329 => '21.1', 333 => '20.1', 338 => '21.1', 339 => '21.1', 341 => 0x3b, 342 => 0x39, 343 => 0x39, 344 => 0x39 },
	'imagereviewtime' => { 325 => '25.1', 327 => '2.1', 330 => '19.1', 331 => '20.1', 332 => '20.1', 334 => '9.2', 335 => '20.1', 340 => '21.2' },
	'imagerfiledatecreated' => { 157 => 0x9c5 },
	'imagerfileproductionlevel' => { 157 => 0x9c4 },
	'imagerfiletagsversionstandard' => { 157 => 0x9c7 },
	'imagerotated' => { 170 => 0x2a },
	'imagerpowerondelaymsec' => { 157 => 0x5fd },
	'imagerrows' => { 157 => 0x17de },
	'imagesegmentlines' => { 157 => 0x184d },
	'imagesegmentstartline' => { 157 => 0x184c },
	'imagesequenceinfo' => { 127 => 0xcd44 },
	'imagesize' => { 181 => 'ImageSize' },
	'imagesizeraw' => { 258 => 0x3e },
	'imagesizerestriction' => { 559 => 'imageSizeRestriction' },
	'imagesourcedata' => { 127 => 0x935c },
	'imagespace' => { 157 => 0x909 },
	'imagestabilization' => { 38 => 0x22, 121 => 0x3020, 135 => 0x1422, 175 => 'ImageStabilization', 201 => 0xbd, 202 => 0x71, 203 => 0x57, 204 => 0x0, 205 => [0x18,0x107,0x113], 206 => 0x49c2, 258 => 0xac, 347 => 0x604, 350 => 0x1600, 372 => 0x1a, 472 => 0x12, 473 => 0x11, 481 => 0xb026 },
	'imagestabilization2' => { 471 => 0xa },
	'imagestabilizationsetting' => { 206 => 0x14, 467 => 0x3d, 468 => 0x3d, 478 => 0x14 },
	'imagestats' => { 127 => 0xcd46 },
	'imagestyle' => { 467 => 0x2d, 468 => 0x27 },
	'imagesupplier' => { 358 => 'ImageSupplier' },
	'imagesupplierid' => { 358 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 358 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 358 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 129 => 0x1 },
	'imagetemperaturemin' => { 129 => 0x2 },
	'imagetitle' => { 127 => 0xa436, 543 => 'ImageTitle' },
	'imagetone' => { 411 => 0x4f },
	'imagetype' => { 150 => 0x82, 358 => 'ImageType' },
	'imageuniqueid' => { 1 => 0x15, 71 => 0x28, 127 => 0xa420, 541 => 'ImageUniqueID', 542 => 'ImageUniqueID', 543 => 'ImageUniqueID' },
	'imagewidth' => { 127 => 0x100, 145 => 'ImageWidth', 207 => 0xe, 420 => 0x10c, 562 => 'ImageWidth' },
	'inclinationangle' => { 518 => 0x900f },
	'inclinationcorrection' => { 518 => 0x900e },
	'incrementaltemperature' => { 536 => 'IncrementalTemperature', 538 => 'IncrementalTemperature' },
	'incrementaltint' => { 536 => 'IncrementalTint', 538 => 'IncrementalTint' },
	'industry' => { 556 => 'industry', 557 => 'industry' },
	'infobuttonwhenshooting' => { 92 => 0x409 },
	'information' => { 431 => 'information', 437 => "\xa9inf" },
	'infourl' => { 437 => 'infu' },
	'infraredilluminator' => { 439 => 0x28 },
	'ingredientexclusion' => { 558 => 'ingredientExclusion' },
	'ingredients' => { 567 => 'Ingredients' },
	'ingredientsalternatepaths' => { 567 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 567 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 567 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 567 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 567 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 567 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientslasturl' => { 567 => [\'Ingredients','IngredientsLastURL'] },
	'ingredientslinkcategory' => { 567 => [\'Ingredients','IngredientsLinkCategory'] },
	'ingredientslinkform' => { 567 => [\'Ingredients','IngredientsLinkForm'] },
	'ingredientsmanager' => { 567 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 567 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 567 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 567 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 567 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 567 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 567 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsplacedresolutionunit' => { 567 => [\'Ingredients','IngredientsPlacedResolutionUnit'] },
	'ingredientsplacedxresolution' => { 567 => [\'Ingredients','IngredientsPlacedXResolution'] },
	'ingredientsplacedyresolution' => { 567 => [\'Ingredients','IngredientsPlacedYResolution'] },
	'ingredientsrenditionclass' => { 567 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 567 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 567 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 567 => [\'Ingredients','IngredientsVersionID'] },
	'initialafpointaiservoaf' => { 92 => 0x51e },
	'initialafpointinservo' => { 2 => 0x13 },
	'initialcameradolly' => { 148 => 'InitialCameraDolly' },
	'initialhorizontalfovdegrees' => { 148 => 'InitialHorizontalFOVDegrees' },
	'initialkey' => { 198 => 'WM/InitialKey' },
	'initialverticalfovdegrees' => { 148 => 'InitialVerticalFOVDegrees' },
	'initialviewheadingdegrees' => { 148 => 'InitialViewHeadingDegrees', 149 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 148 => 'InitialViewPitchDegrees', 149 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 148 => 'InitialViewRollDegrees', 149 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 325 => '4.4' },
	'initialzoomsetting' => { 325 => '9.3', 334 => '27.3' },
	'inkset' => { 127 => 0x14c },
	'inputprofile' => { 157 => 0x1389 },
	'instanceid' => { 567 => 'InstanceID' },
	'instantplaybacksetup' => { 203 => 0x3e },
	'instantplaybacktime' => { 203 => 0x3d },
	'instructions' => { 554 => 'Instructions' },
	'instrument' => { 566 => 'instrument' },
	'integrationtime' => { 157 => 0x423 },
	'intellectualgenre' => { 549 => 'IntellectualGenre' },
	'intelligentauto' => { 481 => 0xb052, 509 => 0xd, 510 => 0xe, 511 => 0xd },
	'intelligentcontrast' => { 57 => 0x4 },
	'intelligentd-range' => { 372 => 0x79 },
	'intelligentexposure' => { 372 => 0x5d },
	'intelligentresolution' => { 372 => 0x70 },
	'interchangecolorspace' => { 152 => 0x40 },
	'intergraphmatrix' => { 127 => 0x8480 },
	'internalflash' => { 200 => 0x2b, 325 => '23.1', 327 => '8.1', 330 => '22.1', 332 => '23.1', 336 => '8.1', 340 => '24.1', 350 => 0x1208 },
	'internalflashae1' => { 352 => 0x1021 },
	'internalflashae1_0' => { 352 => 0x101d },
	'internalflashae2' => { 352 => 0x1022 },
	'internalflashae2_0' => { 352 => 0x101e },
	'internalflashmode' => { 398 => 0x1 },
	'internalflashstrength' => { 398 => 0x3 },
	'internalflashtable' => { 352 => 0x1024 },
	'internallensserialnumber' => { 454 => 0xa005 },
	'internalndfilter' => { 372 => 0x9d },
	'internalserialnumber' => { 71 => 0x96, 83 => 0x9, 135 => 0x10, 206 => 0x49dc, 345 => 0x18, 348 => 0x102, 369 => 0x500, 372 => 0x25, 389 => 0x4, 447 => 0x5, 500 => [0x7c,0xf0], 501 => 0x88, 502 => [0x88,0x8a], 503 => 0x38 },
	'interopindex' => { 127 => 0x1, 543 => 'InteroperabilityIndex' },
	'interopversion' => { 127 => 0x2 },
	'interval' => { 283 => 0x20 },
	'intervaldurationhours' => { 262 => 0x1dc, 263 => 0xa0, 264 => 0xb8 },
	'intervaldurationminutes' => { 262 => 0x1e0, 263 => 0xa4, 264 => 0xbc },
	'intervaldurationseconds' => { 262 => 0x1e4, 263 => 0xa8, 264 => 0xc0 },
	'intervalexposuresmoothing' => { 247 => 0x184, 262 => 0x1f4, 263 => 0xb8, 264 => 0xd0 },
	'intervalframe' => { 283 => 0x24 },
	'intervallength' => { 200 => 0x10 },
	'intervalmode' => { 200 => 0x26 },
	'intervalnumber' => { 200 => 0x11 },
	'intervalpriority' => { 247 => 0x186, 262 => 0x1f6, 263 => 0xba, 264 => 0xd2 },
	'intervals' => { 247 => 0x17c, 262 => 0x1ec, 263 => 0xb0, 264 => 0xc8, 267 => 0xbc, 268 => 0xcc, 269 => 0xcc },
	'intervalshooting' => { 248 => 0x24, 285 => 0x24, 286 => 0x28, 411 => 0x92 },
	'introtime' => { 566 => 'introTime' },
	'introtimescale' => { 566 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 566 => [\'introTime','introTimeValue'] },
	'ipaversion' => { 157 => 0xdae },
	'ipfcameramodel' => { 157 => 0xe4d },
	'iptc' => { 128 => 'IPTC' },
	'iptc-naa' => { 127 => 0x83bb, 377 => 0x83bb },
	'iptcbitspersample' => { 152 => 0x56 },
	'iptcdigest' => { 425 => 0x425 },
	'iptcimageheight' => { 152 => 0x1e },
	'iptcimagerotation' => { 152 => 0x66 },
	'iptcimagewidth' => { 152 => 0x14 },
	'iptclastedited' => { 550 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 152 => 0xa },
	'iptcpixelheight' => { 152 => 0x32 },
	'iptcpixelwidth' => { 152 => 0x28 },
	'isalternativeof' => { 556 => 'isAlternativeOf' },
	'isbn' => { 556 => 'isbn' },
	'iscorrectionof' => { 556 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 117 => 0x3 },
	'ismergedhdr' => { 533 => 'IsMergedHDR' },
	'ismergedpanorama' => { 533 => 'IsMergedPanorama' },
	'iso' => { 7 => 0x6, 9 => 0x6, 10 => 0x75, 11 => 0x6, 12 => 0x79, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x6, 28 => 0x6, 29 => 0x6, 31 => 0x0, 32 => 0x1, 120 => 0x14, 121 => [0x3014,0x14], 127 => 0x8827, 156 => 0xfd06, 157 => 0x1784, 159 => 0x60, 161 => [0xfa2e,0xfa46], 162 => [0x27,0x28], 163 => 0xf105, 166 => 0x14, 168 => 0x4e, 170 => 0x1e, 171 => 0x1a, 173 => 0x34, 175 => 'ISO', 200 => 0x8, 206 => 0x49ba, 246 => 0x0, 258 => 0x2, 372 => 0xd1, 377 => [0x17,0x37], 411 => [0x8b,0x14], 418 => 0x14, 420 => 0x105, 454 => 0xa014, 457 => 0x86, 478 => 0x6f, 486 => [0x1f,0x21,0x25], 542 => 'ISOSpeedRatings' },
	'iso2' => { 246 => 0x6, 290 => 0x265, 291 => 0x25c, 292 => 0x265, 293 => 0x221, 294 => 0x25d, 295 => 0x256, 296 => 0x25d, 299 => 0x2b5, 302 => 0x265, 306 => 0x2b5 },
	'isoauto' => { 390 => '14.4' },
	'isoautoflashlimit' => { 264 => 0x156, 267 => 0x146, 268 => 0x15a, 269 => 0x15a },
	'isoautohilimit' => { 245 => 0x5, 262 => 0x28a, 264 => 0x154, 267 => 0x144, 268 => 0x158, 269 => 0x158, 288 => 0x5, 298 => 0x18eb },
	'isoautomax' => { 480 => 0x4 },
	'isoautomin' => { 480 => 0x2 },
	'isoautominspeed' => { 411 => 0x7a },
	'isoautosettings' => { 347 => 0x821 },
	'isoautoshuttertime' => { 245 => 0x4, 264 => 0x15e, 267 => 0x14e, 268 => 0x162, 269 => 0x162, 288 => 0x4, 298 => 0x18ea },
	'isobutton' => { 269 => 0x796 },
	'isocalibrationgain' => { 157 => 0x89f },
	'isodisplay' => { 328 => '4.1', 329 => '4.1', 330 => '2.3', 331 => '3.3', 332 => '3.3', 335 => '3.3', 338 => '4.3', 339 => '4.1', 340 => '4.3' },
	'isoexpansion' => { 92 => 0x103, 93 => 0x7, 94 => 0x8, 97 => 0x8, 246 => 0x4 },
	'isoexpansion2' => { 246 => 0xa },
	'isofloor' => { 390 => 0x6 },
	'isoselected' => { 371 => 0x359 },
	'isoselection' => { 258 => 0xf },
	'isosensitivitystep' => { 333 => '6.2', 335 => '6.2' },
	'isosetting' => { 159 => 0x5e, 171 => 0x14, 175 => 'ISOSetting', 200 => 0x24, 201 => 0x26, 202 => 0x1c, 203 => 0x13, 208 => 0x6, 258 => 0x13, 390 => '17.3', 446 => 0x27, 467 => 0x16, 468 => 0x14, 469 => 0x2, 478 => 0x6d, 480 => 0x0 },
	'isospeed' => { 127 => 0x8833, 543 => 'ISOSpeed' },
	'isospeedexpansion' => { 91 => 0x3 },
	'isospeedincrements' => { 92 => 0x102 },
	'isospeedlatitudeyyy' => { 127 => 0x8834, 543 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 127 => 0x8835, 543 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 92 => 0x103 },
	'isostepsize' => { 325 => '6.1', 326 => '7.2', 328 => '7.2', 329 => '7.2', 334 => '4.1', 338 => '7.2', 339 => '7.2', 341 => 0x14d, 342 => 0x15d, 343 => 0x15d, 344 => 0x175 },
	'isovalue' => { 352 => 0x1001 },
	'isrc' => { 429 => 'xid ' },
	'isrccode' => { 437 => "\xa9isr" },
	'issn' => { 556 => 'issn' },
	'issueidentifier' => { 556 => 'issueIdentifier' },
	'issuename' => { 556 => 'issueName' },
	'issueteaser' => { 556 => 'issueTeaser' },
	'issuetype' => { 556 => 'issueType' },
	'istranslationof' => { 556 => 'isTranslationOf' },
	'itemsubtype' => { 197 => 'ItemSubType' },
	'itunesu' => { 429 => 'itnu' },
	'jobid' => { 150 => 0xb8 },
	'jobname' => { 544 => 'JobName' },
	'jobref' => { 565 => 'JobRef' },
	'jobrefid' => { 565 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 565 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 565 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 544 => 'JobStatus' },
	'jpeg-heifswitch' => { 481 => 0x2039 },
	'jpeghandling' => { 536 => 'JPEGHandling', 538 => 'JPEGHandling' },
	'jpegquality' => { 10 => 0x66, 372 => 0x43, 374 => 0x3034, 481 => 0xb047 },
	'jpegsize' => { 374 => 0x303a },
	'jpgcompression' => { 249 => 0x24, 258 => 0x44, 293 => '671.1' },
	'jpgfromraw' => { 105 => 0x2007, 122 => 'Exif-JpgFromRaw', 377 => 0x2e },
	'jpgfromrawlength' => { 127 => [0x117,0x202] },
	'jpgfromrawstart' => { 127 => [0x111,0x201] },
	'jpgrecordedpixels' => { 390 => '14.1' },
	'jurisdiction' => { 534 => 'jurisdiction' },
	'jxldecodespeed' => { 127 => 0xcd4b },
	'jxldistance' => { 127 => 0xcd49 },
	'jxleffort' => { 127 => 0xcd4a },
	'keepexposure' => { 342 => 0x237, 343 => 0x237, 344 => 0x24f },
	'kelvinwb_01' => { 399 => 0x5 },
	'kelvinwb_02' => { 399 => 0x9 },
	'kelvinwb_03' => { 399 => 0xd },
	'kelvinwb_04' => { 399 => 0x11 },
	'kelvinwb_05' => { 399 => 0x15 },
	'kelvinwb_06' => { 399 => 0x19 },
	'kelvinwb_07' => { 399 => 0x1d },
	'kelvinwb_08' => { 399 => 0x21 },
	'kelvinwb_09' => { 399 => 0x25 },
	'kelvinwb_10' => { 399 => 0x29 },
	'kelvinwb_11' => { 399 => 0x2d },
	'kelvinwb_12' => { 399 => 0x31 },
	'kelvinwb_13' => { 399 => 0x35 },
	'kelvinwb_14' => { 399 => 0x39 },
	'kelvinwb_15' => { 399 => 0x3d },
	'kelvinwb_16' => { 399 => 0x41 },
	'kelvinwb_daylight' => { 399 => 0x1 },
	'kerneldenominators' => { 157 => 0x933 },
	'key' => { 566 => 'key' },
	'keystonecompensation' => { 351 => 0x1900 },
	'keystonedirection' => { 351 => 0x1901 },
	'keystonevalue' => { 351 => 0x1906 },
	'keyword' => { 429 => 'keyw', 556 => 'keyword' },
	'keywordinfo' => { 190 => 'Keywords' },
	'keywords' => { 150 => 0x19, 176 => 'Keywords', 357 => 'Keywords', 427 => 'Keywords', 431 => 'keywords', 530 => 'keywords', 552 => 'Keywords', 564 => 'Keywords' },
	'killdate' => { 556 => 'killDate' },
	'killdatea-platform' => { 556 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 556 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 156 => 0xf908, 159 => 0xe, 161 => [0xfa1e,0xfa52], 167 => 0x70 },
	'kodakimagewidth' => { 156 => 0xf907, 159 => 0xc, 161 => [0xfa1d,0xfa51], 167 => 0x6c },
	'kodakinfotype' => { 156 => 0xfa00 },
	'kodaklook' => { 157 => 0xe4c },
	'kodaklookprofile' => { 157 => 0x138a },
	'kodakmaker' => { 167 => 0x8 },
	'kodakmodel' => { 159 => 0x0, 167 => 0x28 },
	'kodaktag' => { 157 => 0x3ea },
	'kodakversion' => { 157 => 0x0 },
	'label' => { 361 => 'Label', 564 => 'Label' },
	'labelname1' => { 548 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 548 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 372 => 0x6f },
	'landscapeoutputhighlightpoint' => { 117 => 0x26 },
	'landscapeoutputshadowpoint' => { 117 => 0x27 },
	'landscaperawcolortone' => { 117 => 0x1f },
	'landscaperawcontrast' => { 117 => 0x21 },
	'landscaperawhighlight' => { 117 => 0x77 },
	'landscaperawhighlightpoint' => { 117 => 0x24 },
	'landscaperawlinear' => { 117 => 0x22 },
	'landscaperawsaturation' => { 117 => 0x20 },
	'landscaperawshadow' => { 117 => 0x80 },
	'landscaperawshadowpoint' => { 117 => 0x25 },
	'landscaperawsharpness' => { 117 => 0x23 },
	'landscapeunsharpmaskfineness' => { 117 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 117 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 117 => 0xa2 },
	'language' => { 262 => 0x8fc, 265 => 0x6a2, 266 => 0x6a2, 267 => 0x592, 268 => 0x5c2, 269 => 0x5da, 539 => 'language' },
	'languageidentifier' => { 150 => 0x87 },
	'largestvalidinteriorrectheight' => { 148 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 148 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 148 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 148 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 200 => 0x1b },
	'lastkeywordiptc' => { 197 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 197 => 'LastKeywordXMP' },
	'lastphotodate' => { 148 => 'LastPhotoDate' },
	'lasturl' => { 567 => 'LastURL' },
	'lateralchromaticaberration' => { 481 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 533 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 126 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 126 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 126 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 126 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 126 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'latitude' => { 124 => 'Latitude' },
	'lc1' => { 401 => 0x2 },
	'lc10' => { 401 => 0xb },
	'lc11' => { 401 => 0xc },
	'lc12' => { 401 => 0xd },
	'lc14' => { 401 => 0xf },
	'lc15' => { 401 => 0x10 },
	'lc3' => { 401 => 0x4 },
	'lc4' => { 401 => 0x5 },
	'lc5' => { 401 => 0x6 },
	'lc6' => { 401 => 0x7 },
	'lc7' => { 401 => 0x8 },
	'lc8' => { 401 => 0x9 },
	'lcddisplayatpoweron' => { 92 => 0x811, 96 => 0xa },
	'lcddisplayreturntoshoot' => { 97 => 0x12 },
	'lcdillumination' => { 325 => '17.5', 326 => '5.2', 328 => '5.1', 329 => '5.1', 334 => '10.3', 335 => '4.2', 338 => '5.2', 339 => '5.1', 340 => '5.4', 341 => 0xf1, 342 => 0x101, 343 => 0x101, 344 => 0x117 },
	'lcdilluminationduringbulb' => { 92 => 0x408 },
	'lcdmatrix' => { 157 => 0xe74 },
	'lcdmatrixchickfix' => { 157 => 0xe75 },
	'lcdmatrixmarvin' => { 157 => 0xe76 },
	'lcdpanels' => { 91 => 0x8 },
	'lcheditor' => { 318 => 0x8ae85e },
	'legacyiptcdigest' => { 554 => 'LegacyIPTCDigest' },
	'legalcode' => { 534 => 'legalcode' },
	'lens' => { 127 => 0xfdea, 258 => 0x84, 533 => 'Lens' },
	'lensafstopbutton' => { 90 => 0x11, 91 => 0x13, 92 => 0x506, 93 => 0x10, 94 => 0x12, 97 => 0x13, 98 => 0x9 },
	'lensaperturerange' => { 457 => [0x30,0x48] },
	'lensblur' => { 536 => 'LensBlur', 538 => 'LensBlur' },
	'lensbluractive' => { 536 => [\'LensBlur','LensBlurActive'], 538 => [\'LensBlur','LensBlurActive'] },
	'lensbluramount' => { 536 => [\'LensBlur','LensBlurBlurAmount'], 538 => [\'LensBlur','LensBlurBlurAmount'] },
	'lensblurbokehaspect' => { 536 => [\'LensBlur','LensBlurBokehAspect'], 538 => [\'LensBlur','LensBlurBokehAspect'] },
	'lensblurbokehrotation' => { 536 => [\'LensBlur','LensBlurBokehRotation'], 538 => [\'LensBlur','LensBlurBokehRotation'] },
	'lensblurbokehshape' => { 536 => [\'LensBlur','LensBlurBokehShape'], 538 => [\'LensBlur','LensBlurBokehShape'] },
	'lensblurbokehshapedetail' => { 536 => [\'LensBlur','LensBlurBokehShapeDetail'], 538 => [\'LensBlur','LensBlurBokehShapeDetail'] },
	'lensblurcateyeamount' => { 536 => [\'LensBlur','LensBlurCatEyeAmount'], 538 => [\'LensBlur','LensBlurCatEyeAmount'] },
	'lensblurcateyescale' => { 536 => [\'LensBlur','LensBlurCatEyeScale'], 538 => [\'LensBlur','LensBlurCatEyeScale'] },
	'lensblurfocalrange' => { 536 => [\'LensBlur','LensBlurFocalRange'], 538 => [\'LensBlur','LensBlurFocalRange'] },
	'lensblurfocalrangesource' => { 536 => [\'LensBlur','LensBlurFocalRangeSource'], 538 => [\'LensBlur','LensBlurFocalRangeSource'] },
	'lensblurhighlightsboost' => { 536 => [\'LensBlur','LensBlurHighlightsBoost'], 538 => [\'LensBlur','LensBlurHighlightsBoost'] },
	'lensblurhighlightsthreshold' => { 536 => [\'LensBlur','LensBlurHighlightsThreshold'], 538 => [\'LensBlur','LensBlurHighlightsThreshold'] },
	'lensblursampledarea' => { 536 => [\'LensBlur','LensBlurSampledArea'], 538 => [\'LensBlur','LensBlurSampledArea'] },
	'lensblursampledrange' => { 536 => [\'LensBlur','LensBlurSampledRange'], 538 => [\'LensBlur','LensBlurSampledRange'] },
	'lensblursphericalaberration' => { 536 => [\'LensBlur','LensBlurSphericalAberration'], 538 => [\'LensBlur','LensBlurSphericalAberration'] },
	'lensblursubjectrange' => { 536 => [\'LensBlur','LensBlurSubjectRange'], 538 => [\'LensBlur','LensBlurSubjectRange'] },
	'lensblurversion' => { 536 => [\'LensBlur','LensBlurVersion'], 538 => [\'LensBlur','LensBlurVersion'] },
	'lenscontrolring' => { 341 => 0xb1, 342 => 0xad, 343 => 0xad, 344 => 0xad },
	'lenscorrectionsettings' => { 541 => 'LensCorrectionSettings' },
	'lensdistortinfo' => { 533 => 'LensDistortInfo' },
	'lensdistortionparams' => { 352 => 0x206 },
	'lensdriveend' => { 256 => 0x56 },
	'lensdrivenoaf' => { 92 => 0x505 },
	'lensdrivewhenafimpossible' => { 2 => 0xb },
	'lense-mountversion' => { 469 => 0x3f0, 517 => 0xd },
	'lensfirmware' => { 448 => 0x20, 454 => 0xa004 },
	'lensfirmwareversion' => { 256 => 0x34, 348 => 0x204, 372 => 0x60, 469 => 0x3f3, 517 => 0x14 },
	'lensfocallength' => { 111 => 0xf0512, 401 => 0x9 },
	'lensfocalrange' => { 457 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 326 => '55.1', 328 => '52.1', 329 => '52.1', 338 => '52.1', 339 => '52.1' },
	'lensformat' => { 494 => 0x1891, 496 => 0x18bd, 497 => 0x18ed, 498 => 0x17f1, 500 => 0x106, 501 => 0x106, 512 => 0x603, 513 => 0x5d },
	'lensfstops' => { 250 => 0x7, 251 => 0xc, 252 => 0xd, 256 => 0xe, 258 => 0x8b, 401 => '0.3' },
	'lensfunc1button' => { 341 => 0xa3, 342 => 0x9f, 343 => 0x9f, 344 => 0x9f },
	'lensfunc1buttonplaybackmode' => { 266 => 0x80a, 269 => 0x810 },
	'lensfunc2button' => { 341 => 0xab, 342 => 0xa7, 343 => 0xa7, 344 => 0xa7 },
	'lensfunc2buttonplaybackmode' => { 266 => 0x80c, 269 => 0x812 },
	'lensid' => { 256 => 0x30, 533 => 'LensID' },
	'lensidnumber' => { 250 => 0x6, 251 => 0xb, 252 => 0xc, 256 => 0xd },
	'lensinfo' => { 127 => 0xa432, 407 => 0x2a, 533 => 'LensInfo', 543 => 'LensSpecification' },
	'lenskind' => { 401 => 0x1 },
	'lensmake' => { 127 => 0xa433, 182 => 'Make', 543 => 'LensMake' },
	'lensmanualdistortionamount' => { 536 => 'LensManualDistortionAmount', 538 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 197 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 457 => 0x2b },
	'lensmodel' => { 7 => 0x937, 14 => 0x92b, 15 => 0x933, 71 => 0x95, 127 => 0xa434, 182 => 'Model', 197 => 'LensModel', 253 => 0x18a, 254 => 0x18b, 255 => 0x2ac, 348 => 0x203, 407 => 0xc, 420 => 0x412, 438 => 'camera.lens_model', 543 => 'LensModel' },
	'lensmodulationoptimizer' => { 135 => 0x1045 },
	'lensmount' => { 469 => 0x99, 494 => 0x1892, 496 => 0x18be, 497 => 0x18ee, 498 => 0x17f2, 500 => 0x105, 501 => 0x105, 512 => 0x604, 513 => 0x5e },
	'lensmount2' => { 517 => 0x8 },
	'lensmounttype' => { 256 => 0x5f },
	'lenspositionabsolute' => { 256 => 0x5a },
	'lensprofilechromaticaberrationscale' => { 536 => 'LensProfileChromaticAberrationScale', 538 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 536 => 'LensProfileDigest', 538 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 536 => 'LensProfileDistortionScale', 538 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 536 => 'LensProfileEnable', 538 => 'LensProfileEnable' },
	'lensprofilefilename' => { 536 => 'LensProfileFilename', 538 => 'LensProfileFilename' },
	'lensprofileisembedded' => { 536 => 'LensProfileIsEmbedded', 538 => 'LensProfileIsEmbedded' },
	'lensprofilematchkeycameramodelname' => { 536 => 'LensProfileMatchKeyCameraModelName', 538 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 536 => 'LensProfileMatchKeyExifMake', 538 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 536 => 'LensProfileMatchKeyExifModel', 538 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 536 => 'LensProfileMatchKeyIsRaw', 538 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 536 => 'LensProfileMatchKeyLensID', 538 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 536 => 'LensProfileMatchKeyLensInfo', 538 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 536 => 'LensProfileMatchKeyLensName', 538 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 536 => 'LensProfileMatchKeySensorFormatFactor', 538 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 371 => 0x370, 536 => 'LensProfileName', 538 => 'LensProfileName' },
	'lensprofilesetup' => { 536 => 'LensProfileSetup', 538 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 536 => 'LensProfileVignettingScale', 538 => 'LensProfileVignettingScale' },
	'lensproperties' => { 348 => 0x20b },
	'lensserialnumber' => { 21 => 0x164, 36 => 0x16b, 67 => 0x0, 127 => 0xa435, 182 => 'SerialNumber', 348 => 0x202, 370 => 0x321, 372 => 0x52, 437 => 'LENS', 448 => 0x30, 533 => 'LensSerialNumber', 543 => 'LensSerialNumber' },
	'lensshutterlock' => { 203 => 0x4a },
	'lensspec' => { 464 => 0x0, 465 => 0x0, 466 => 0x0, 481 => 0xb02a },
	'lensspecfeatures' => { 500 => [0x115,0x116], 501 => [0x116,0x1ed,0x1f0,0x21c,0x21e] },
	'lenstemperature' => { 352 => 0x1008 },
	'lenstype' => { 7 => 0xe2, 8 => 0xd, 9 => 0x1a7, 10 => 0xc, 11 => 0x111, 12 => 0xc, 13 => 0x14f, 14 => 0xd6, 15 => 0xde, 16 => 0xf6, 17 => 0xea, 18 => 0xff, 19 => [0xc,0x97], 20 => 0xe6, 21 => 0x153, 22 => 0xea, 23 => 0xe8, 24 => 0x127, 25 => 0x161, 26 => 0x166, 27 => 0x184, 28 => 0x112, 29 => 0x189, 38 => 0x16, 205 => 0x10c, 206 => 0x49bd, 258 => 0x83, 348 => 0x201, 363 => 0x16, 367 => 0x310, 369 => 0x303, 370 => 0x303, 372 => 0x51, 374 => 0x3405, 402 => 0x0, 403 => 0x0, 404 => 0x1, 405 => 0x1, 406 => 0x1, 408 => 0x0, 454 => 0xa003, 457 => 0x27, 481 => 0xb027, 494 => 0x1896, 496 => 0x18c2, 497 => 0x18f2, 498 => 0x17f6, 500 => 0x109, 501 => 0x109, 512 => 0x608, 513 => 0x62 },
	'lenstype2' => { 469 => 0x3f7, 494 => 0x1893, 496 => 0x18bf, 497 => 0x18ef, 498 => 0x17f3, 500 => 0x107, 501 => 0x107, 512 => 0x605, 513 => 0x60 },
	'lenstype3' => { 517 => 0x9 },
	'lenstypemake' => { 372 => 0xc4 },
	'lenstypemodel' => { 372 => [0xc5,0xe4] },
	'lenszoomposition' => { 509 => 0x19, 510 => 0x1e, 513 => [0x342,0x34e,0x35a] },
	'levelindicator' => { 380 => 0x15 },
	'levelmeter' => { 437 => ['Lvlm','lvlm'] },
	'levelorientation' => { 409 => 0x0 },
	'license' => { 534 => 'license' },
	'licensee' => { 358 => 'Licensee' },
	'licenseeid' => { 358 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 358 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 358 => 'LicenseeImageNotes' },
	'licenseename' => { 358 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 358 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 358 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 358 => 'LicenseeTransactionID' },
	'licenseid' => { 358 => 'LicenseID' },
	'licensestartdate' => { 358 => 'LicenseStartDate' },
	'licensetransactiondate' => { 358 => 'LicenseTransactionDate' },
	'licensetype' => { 540 => 'licensetype' },
	'licensor' => { 358 => 'Licensor' },
	'licensorcity' => { 358 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 358 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 358 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 358 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 358 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 358 => 'LicensorImageID' },
	'licensorname' => { 358 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 358 => 'LicensorNotes' },
	'licensorpostalcode' => { 358 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 358 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 358 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 358 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 358 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 358 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 358 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 358 => 'LicensorTransactionID' },
	'licensorurl' => { 358 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 352 => 0x1009 },
	'lightingmode' => { 121 => 0x302a },
	'lightreading' => { 411 => 0x15 },
	'lightsource' => { 127 => 0x9208, 258 => 0x90, 355 => 0x1000, 542 => 'LightSource' },
	'lightsourcespecial' => { 456 => 0x21d },
	'lightswitch' => { 338 => '0.1', 340 => '0.1' },
	'lightvaluecenter' => { 352 => 0x103d },
	'lightvalueperiphery' => { 352 => 0x103e },
	'limitaf-areamodesel3dtracking' => { 341 => 0x143, 342 => 0x153, 343 => 0x153, 344 => 0x16b },
	'limitaf-areamodeseldynamic_l' => { 341 => 0x141, 342 => 0x151, 343 => 0x151, 344 => 0x169 },
	'limitaf-areamodeseldynamic_m' => { 341 => 0x140, 342 => 0x150, 343 => 0x150, 344 => 0x168 },
	'limitaf-areamodeseldynamic_s' => { 341 => 0x13f, 342 => 0x14f, 343 => 0x14f, 344 => 0x167 },
	'limitaf-areamodeselpinpoint' => { 341 => 0x11, 342 => 0x11, 343 => 0x11, 344 => 0x11 },
	'limitaf-areamodeselwideaf_l' => { 341 => 0x14, 342 => 0x14, 343 => 0x14, 344 => 0x14 },
	'limitaf-areamodeselwideaf_s' => { 341 => 0x13, 342 => 0x13, 343 => 0x13, 344 => 0x13 },
	'limitafareamodeselauto' => { 341 => 0x15, 342 => 0x15, 343 => 0x15, 344 => 0x15 },
	'limitafareamodeselection' => { 326 => '51.1', 328 => '49.1', 329 => '49.1', 338 => '49.1', 339 => '49.1' },
	'limitreleasemodeselc120' => { 343 => '269.4', 344 => '293.4' },
	'limitreleasemodeselc30' => { 343 => '269.3', 344 => '293.3' },
	'limitreleasemodeselch' => { 343 => '269.2', 344 => '293.2' },
	'limitreleasemodeselcl' => { 343 => '269.1', 344 => '293.1' },
	'limitreleasemodeselself' => { 343 => '269.5', 344 => '293.5' },
	'limitselectableimagearea16to9' => { 341 => 0x4d, 342 => 0x47, 343 => 0x47, 344 => 0x47 },
	'limitselectableimagearea1to1' => { 341 => 0x4c, 342 => 0x46, 343 => 0x46, 344 => 0x46 },
	'limitselectableimageareadx' => { 341 => 0x4b, 342 => 0x45, 343 => 0x45, 344 => 0x45 },
	'linearitylimitblue' => { 377 => 0x10 },
	'linearitylimitgreen' => { 377 => 0xf },
	'linearitylimitred' => { 377 => 0xe },
	'linearityuppermargin' => { 45 => 0x32c, 46 => 0x282, 47 => 0x296, 50 => [0x2ba,0x2d1,0x2d5], 52 => 0x1e5, 53 => [0x1fe,0x2de], 54 => [0x232,0x310], 55 => 0x31e },
	'linearizationtable' => { 127 => 0xc618 },
	'linearresponselimit' => { 127 => 0xc62e },
	'link' => { 556 => 'link' },
	'linkaetoafpoint' => { 390 => '14.2' },
	'linkedencodedrightsexpr' => { 550 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 550 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 550 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 550 => 'LinkedEncRightsExpr' },
	'linkvrtofocuspoint' => { 262 => 0x3ec },
	'linlogcoring' => { 157 => 0x904 },
	'lithostratigraphicterms' => { 126 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'livephotoauto' => { 431 => 'live-photo.auto' },
	'livephotovideoindex' => { 1 => 0x17 },
	'livephotovitalityscore' => { 431 => 'live-photo.vitality-score' },
	'livephotovitalityscoringversion' => { 431 => 'live-photo.vitality-scoring-version' },
	'liveview' => { 383 => 0x1fa, 392 => 0x3 },
	'liveviewaf' => { 330 => '32.1', 340 => '34.1' },
	'liveviewafareamode' => { 335 => '34.1' },
	'liveviewafmethod' => { 486 => 0x20 },
	'liveviewafmode' => { 335 => '34.2' },
	'liveviewafsetting' => { 469 => 0x36 },
	'liveviewbuttonoptions' => { 326 => '50.2', 328 => '48.2', 329 => '48.2', 338 => '48.2', 339 => '48.2' },
	'liveviewexposuresimulation' => { 92 => 0x810 },
	'liveviewfocusmode' => { 469 => [0x8b,0x28b] },
	'liveviewmetering' => { 469 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 326 => '21.2', 328 => '21.2', 329 => '21.2', 331 => '20.2', 332 => '20.2', 333 => '20.2', 335 => '20.2', 338 => '21.2', 339 => '21.2' },
	'liveviewshooting' => { 62 => 0x13 },
	'livingspecimen' => { 126 => 'LivingSpecimen' },
	'livingspecimenmaterialsampleid' => { 126 => [\'LivingSpecimen','LivingSpecimenMaterialSampleID'] },
	'localcaption' => { 150 => 0x79 },
	'localizedcameramodel' => { 127 => 0xc615 },
	'locallocationname' => { 454 => 0x30 },
	'location' => { 257 => 0x9, 372 => 0x67, 528 => 'Location', 549 => 'Location', 555 => 'location', 556 => 'location' },
	'locationaccuracyhorizontal' => { 431 => 'location.accuracy.horizontal' },
	'locationareacode' => { 535 => 'lac' },
	'locationbody' => { 431 => 'location.body' },
	'locationcreated' => { 550 => 'LocationCreated' },
	'locationcreatedcity' => { 550 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 550 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 550 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedgpsaltitude' => { 550 => [\'LocationCreated','LocationCreatedGPSAltitude'] },
	'locationcreatedgpsaltituderef' => { 550 => [\'LocationCreated','LocationCreatedGPSAltitudeRef'] },
	'locationcreatedgpslatitude' => { 550 => [\'LocationCreated','LocationCreatedGPSLatitude'] },
	'locationcreatedgpslongitude' => { 550 => [\'LocationCreated','LocationCreatedGPSLongitude'] },
	'locationcreatedidentifier' => { 550 => [\'LocationCreated','LocationCreatedIdentifier'] },
	'locationcreatedlocationid' => { 550 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedlocationname' => { 550 => [\'LocationCreated','LocationCreatedLocationName'] },
	'locationcreatedprovincestate' => { 550 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 550 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 550 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationdate' => { 431 => 'location.date' },
	'locationinformation' => { 437 => 'loci' },
	'locationinfoversion' => { 257 => 0x0 },
	'locationname' => { 431 => 'location.name', 454 => 0x31 },
	'locationnote' => { 431 => 'location.note' },
	'locationrole' => { 431 => 'location.role' },
	'locationshown' => { 550 => 'LocationShown' },
	'locationshowncity' => { 550 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 550 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 550 => [\'LocationShown','LocationShownCountryName'] },
	'locationshowngpsaltitude' => { 550 => [\'LocationShown','LocationShownGPSAltitude'] },
	'locationshowngpsaltituderef' => { 550 => [\'LocationShown','LocationShownGPSAltitudeRef'] },
	'locationshowngpslatitude' => { 550 => [\'LocationShown','LocationShownGPSLatitude'] },
	'locationshowngpslongitude' => { 550 => [\'LocationShown','LocationShownGPSLongitude'] },
	'locationshownidentifier' => { 550 => [\'LocationShown','LocationShownIdentifier'] },
	'locationshownlocationid' => { 550 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownlocationname' => { 550 => [\'LocationShown','LocationShownLocationName'] },
	'locationshownprovincestate' => { 550 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 550 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 550 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 92 => 0x709 },
	'logcomment' => { 566 => 'logComment' },
	'logscale' => { 157 => 0x902 },
	'longdescription' => { 429 => 'ldes' },
	'longexposurenoisereduction' => { 69 => 0x4, 92 => 0x201, 93 => 0x1, 94 => 0x2, 95 => 0x1, 96 => 0x1, 97 => 0x2, 98 => 0x1, 372 => 0x49, 467 => 0x2b, 468 => 0x25, 469 => 0x25, 481 => 0x2008, 486 => 0x11, 513 => 0x44 },
	'longexposurenoisereduction2' => { 62 => 0x8 },
	'longexposurenrused' => { 372 => 0xbe },
	'longitude' => { 124 => 'Longitude' },
	'look' => { 536 => 'Look', 538 => 'Look' },
	'lookamount' => { 536 => [\'Look','LookAmount'], 538 => [\'Look','LookAmount'] },
	'lookcluster' => { 536 => [\'Look','LookCluster'], 538 => [\'Look','LookCluster'] },
	'lookcopyright' => { 536 => [\'Look','LookCopyright'], 538 => [\'Look','LookCopyright'] },
	'lookgroup' => { 536 => [\'Look','LookGroup'], 538 => [\'Look','LookGroup'] },
	'lookname' => { 536 => 'LookName', 538 => 'LookName' },
	'lookparameters' => { 536 => [\'Look','LookParameters'], 538 => [\'Look','LookParameters'] },
	'lookparameterscameraprofile' => { 536 => [\'Look','LookParametersCameraProfile'], 538 => [\'Look','LookParametersCameraProfile'] },
	'lookparametersclarity2012' => { 536 => [\'Look','LookParametersClarity2012'], 538 => [\'Look','LookParametersClarity2012'] },
	'lookparametersconverttograyscale' => { 536 => [\'Look','LookParametersConvertToGrayscale'], 538 => [\'Look','LookParametersConvertToGrayscale'] },
	'lookparametershighlights2012' => { 536 => [\'Look','LookParametersHighlights2012'], 538 => [\'Look','LookParametersHighlights2012'] },
	'lookparameterslooktable' => { 536 => [\'Look','LookParametersLookTable'], 538 => [\'Look','LookParametersLookTable'] },
	'lookparametersprocessversion' => { 536 => [\'Look','LookParametersProcessVersion'], 538 => [\'Look','LookParametersProcessVersion'] },
	'lookparametersshadows2012' => { 536 => [\'Look','LookParametersShadows2012'], 538 => [\'Look','LookParametersShadows2012'] },
	'lookparameterstonecurvepv2012' => { 536 => [\'Look','LookParametersToneCurvePV2012'], 538 => [\'Look','LookParametersToneCurvePV2012'] },
	'lookparameterstonecurvepv2012blue' => { 536 => [\'Look','LookParametersToneCurvePV2012Blue'], 538 => [\'Look','LookParametersToneCurvePV2012Blue'] },
	'lookparameterstonecurvepv2012green' => { 536 => [\'Look','LookParametersToneCurvePV2012Green'], 538 => [\'Look','LookParametersToneCurvePV2012Green'] },
	'lookparameterstonecurvepv2012red' => { 536 => [\'Look','LookParametersToneCurvePV2012Red'], 538 => [\'Look','LookParametersToneCurvePV2012Red'] },
	'lookparametersversion' => { 536 => [\'Look','LookParametersVersion'], 538 => [\'Look','LookParametersVersion'] },
	'looksupportsamount' => { 536 => [\'Look','LookSupportsAmount'], 538 => [\'Look','LookSupportsAmount'] },
	'looksupportsmonochrome' => { 536 => [\'Look','LookSupportsMonochrome'], 538 => [\'Look','LookSupportsMonochrome'] },
	'looksupportsoutputreferred' => { 536 => [\'Look','LookSupportsOutputReferred'], 538 => [\'Look','LookSupportsOutputReferred'] },
	'lookuuid' => { 536 => [\'Look','LookUUID'], 538 => [\'Look','LookUUID'] },
	'loop' => { 566 => 'loop' },
	'loopstyle' => { 437 => 'LOOP' },
	'lowestbiostratigraphiczone' => { 126 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 536 => 'LuminanceAdjustmentAqua', 538 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 536 => 'LuminanceAdjustmentBlue', 538 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 536 => 'LuminanceAdjustmentGreen', 538 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 536 => 'LuminanceAdjustmentMagenta', 538 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 536 => 'LuminanceAdjustmentOrange', 538 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 536 => 'LuminanceAdjustmentPurple', 538 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 536 => 'LuminanceAdjustmentRed', 538 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 536 => 'LuminanceAdjustmentYellow', 538 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 116 => 0x150 },
	'luminancecurvepoints' => { 116 => 0x126 },
	'luminancenoiseamplitude' => { 1 => 0x1d },
	'luminancenoisereduction' => { 111 => 0x20600, 117 => 0x5f, 457 => 0x1b },
	'luminancenoisereductioncontrast' => { 536 => 'LuminanceNoiseReductionContrast', 538 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 536 => 'LuminanceNoiseReductionDetail', 538 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 117 => 0x6d },
	'luminancesmoothing' => { 536 => 'LuminanceSmoothing', 538 => 'LuminanceSmoothing' },
	'lut1name' => { 372 => 0xf1 },
	'lut1opacity' => { 372 => 0xf3 },
	'lut2name' => { 372 => 0xf4 },
	'lut2opacity' => { 372 => 0xf5 },
	'lvshootingareadisplay' => { 92 => [0x40b,0x40c] },
	'lyrics' => { 429 => "\xa9lyr", 437 => "\xa9lyr", 566 => 'lyrics' },
	'lyricsuri' => { 437 => 'lrcu' },
	'm16cversion' => { 367 => 0x333 },
	'macatom' => { 537 => 'macAtom' },
	'macatomapplicationcode' => { 537 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 537 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 537 => [\'macAtom','macAtomPosixProjectPath'] },
	'machineobservation' => { 126 => 'MachineObservation' },
	'machineobservationday' => { 126 => [\'MachineObservation','MachineObservationDay'] },
	'machineobservationearliestdate' => { 126 => [\'MachineObservation','MachineObservationEarliestDate'] },
	'machineobservationenddayofyear' => { 126 => [\'MachineObservation','MachineObservationEndDayOfYear'] },
	'machineobservationeventdate' => { 126 => [\'MachineObservation','MachineObservationEventDate'] },
	'machineobservationeventid' => { 126 => [\'MachineObservation','MachineObservationEventID'] },
	'machineobservationeventremarks' => { 126 => [\'MachineObservation','MachineObservationEventRemarks'] },
	'machineobservationeventtime' => { 126 => [\'MachineObservation','MachineObservationEventTime'] },
	'machineobservationeventtype' => { 126 => [\'MachineObservation','MachineObservationEventType'] },
	'machineobservationfieldnotes' => { 126 => [\'MachineObservation','MachineObservationFieldNotes'] },
	'machineobservationfieldnumber' => { 126 => [\'MachineObservation','MachineObservationFieldNumber'] },
	'machineobservationhabitat' => { 126 => [\'MachineObservation','MachineObservationHabitat'] },
	'machineobservationlatestdate' => { 126 => [\'MachineObservation','MachineObservationLatestDate'] },
	'machineobservationmonth' => { 126 => [\'MachineObservation','MachineObservationMonth'] },
	'machineobservationparenteventid' => { 126 => [\'MachineObservation','MachineObservationParentEventID'] },
	'machineobservationsamplesizeunit' => { 126 => [\'MachineObservation','MachineObservationSampleSizeUnit'] },
	'machineobservationsamplesizevalue' => { 126 => [\'MachineObservation','MachineObservationSampleSizeValue'] },
	'machineobservationsamplingeffort' => { 126 => [\'MachineObservation','MachineObservationSamplingEffort'] },
	'machineobservationsamplingprotocol' => { 126 => [\'MachineObservation','MachineObservationSamplingProtocol'] },
	'machineobservationstartdayofyear' => { 126 => [\'MachineObservation','MachineObservationStartDayOfYear'] },
	'machineobservationverbatimeventdate' => { 126 => [\'MachineObservation','MachineObservationVerbatimEventDate'] },
	'machineobservationyear' => { 126 => [\'MachineObservation','MachineObservationYear'] },
	'macro' => { 135 => 0x1020, 137 => 0x202, 170 => 0x2b, 352 => 0x202, 446 => 0x21, 456 => 0x202, 481 => 0xb040 },
	'macroled' => { 350 => 0x120a },
	'macromagnification' => { 7 => 0x1b, 11 => 0x1b, 14 => 0x1b, 15 => 0x1b, 19 => 0x1b, 20 => 0x1b, 62 => 0x10 },
	'macromode' => { 38 => 0x1, 200 => 0xb, 347 => 0x300, 372 => 0x1c, 447 => 0x1009 },
	'magentahsl' => { 111 => 0x20917 },
	'magicfilter' => { 347 => 0x52c },
	'magnifiedview' => { 94 => 0x11, 96 => 0x9 },
	'mainboardversion' => { 157 => 0x438 },
	'maindialexposurecomp' => { 336 => '0.6' },
	'mainingredient' => { 558 => 'mainIngredient' },
	'majorbrand' => { 431 => 'major_brand' },
	'majorversion' => { 526 => 'MajorVersion' },
	'make' => { 106 => 0x0, 123 => 0x1, 127 => 0x10f, 175 => 'Make', 361 => 'Make', 377 => 0x10f, 431 => 'make', 437 => ['@mak',"\xa9mak"], 555 => 'make', 562 => 'Make' },
	'makernote' => { 542 => 'MakerNote' },
	'makernoteapple' => { 125 => 'MakN', 127 => 0x927c },
	'makernotecanon' => { 89 => 'CMT3', 125 => 'MakN', 127 => 0x927c },
	'makernotecasio' => { 125 => 'MakN', 127 => 0x927c },
	'makernotecasio2' => { 125 => 'MakN', 127 => 0x927c },
	'makernotedji' => { 125 => 'MakN', 127 => 0x927c },
	'makernotedjiinfo' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteflir' => { 125 => 'MakN', 127 => 0x927c },
	'makernotefujifilm' => { 125 => 'MakN', 127 => 0x927c },
	'makernotege' => { 125 => 'MakN', 127 => 0x927c },
	'makernotege2' => { 125 => 'MakN', 127 => 0x927c },
	'makernotegoogle' => { 125 => 'MakN', 127 => 0x927c },
	'makernotehasselblad' => { 125 => 'MakN', 127 => 0x927c },
	'makernotehp' => { 125 => 'MakN', 127 => 0x927c },
	'makernotehp2' => { 125 => 'MakN', 127 => 0x927c },
	'makernotehp4' => { 125 => 'MakN', 127 => 0x927c },
	'makernotehp6' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteisl' => { 125 => 'MakN', 127 => 0x927c },
	'makernotejvc' => { 125 => 'MakN', 127 => 0x927c },
	'makernotejvctext' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak10' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak11' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak12' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak1a' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak1b' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak2' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak3' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak4' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak5' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak6a' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak6b' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak7' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak8a' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak8b' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak8c' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodak9' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekodakunknown' => { 125 => 'MakN', 127 => 0x927c },
	'makernotekyocera' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteleica' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteleica10' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteleica2' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteleica3' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteleica4' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteleica5' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteleica6' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteleica7' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteleica8' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteleica9' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteminolta' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteminolta2' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteminolta3' => { 125 => 'MakN', 127 => 0x927c },
	'makernotemotorola' => { 125 => 'MakN', 127 => 0x927c },
	'makernotenikon' => { 125 => 'MakN', 127 => 0x927c },
	'makernotenikon2' => { 125 => 'MakN', 127 => 0x927c },
	'makernotenikon3' => { 125 => 'MakN', 127 => 0x927c },
	'makernotenintendo' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteoffset' => { 456 => 0xff },
	'makernoteolympus' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteolympus2' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteolympus3' => { 125 => 'MakN', 127 => 0x927c },
	'makernotepanasonic' => { 125 => 'MakN', 127 => 0x927c },
	'makernotepanasonic2' => { 125 => 'MakN', 127 => 0x927c },
	'makernotepanasonic3' => { 125 => 'MakN', 127 => 0x927c },
	'makernotepentax' => { 125 => 'MakN', 127 => 0x927c },
	'makernotepentax2' => { 125 => 'MakN', 127 => 0x927c },
	'makernotepentax3' => { 125 => 'MakN', 127 => 0x927c },
	'makernotepentax4' => { 125 => 'MakN', 127 => 0x927c },
	'makernotepentax5' => { 125 => 'MakN', 127 => 0x927c },
	'makernotepentax6' => { 125 => 'MakN', 127 => 0x927c },
	'makernotepentaxunknown' => { 437 => 'PXMN' },
	'makernotephaseone' => { 125 => 'MakN', 127 => 0x927c },
	'makernotereconyxhyperfire' => { 125 => 'MakN', 127 => 0x927c },
	'makernotereconyxhyperfire2' => { 125 => 'MakN', 127 => 0x927c },
	'makernotereconyxhyperfire4k' => { 125 => 'MakN', 127 => 0x927c },
	'makernotereconyxmicrofire' => { 125 => 'MakN', 127 => 0x927c },
	'makernotereconyxultrafire' => { 125 => 'MakN', 127 => 0x927c },
	'makernotericoh' => { 125 => 'MakN', 127 => 0x927c },
	'makernotericoh2' => { 125 => 'MakN', 127 => 0x927c },
	'makernotericohpentax' => { 125 => 'MakN', 127 => 0x927c },
	'makernotericohtext' => { 125 => 'MakN', 127 => 0x927c },
	'makernotesafety' => { 127 => 0xc635 },
	'makernotesamsung1a' => { 125 => 'MakN', 127 => 0x927c },
	'makernotesamsung1b' => { 125 => 'MakN', 127 => 0x927c },
	'makernotesamsung2' => { 125 => 'MakN', 127 => 0x927c },
	'makernotesanyo' => { 125 => 'MakN', 127 => 0x927c },
	'makernotesanyoc4' => { 125 => 'MakN', 127 => 0x927c },
	'makernotesanyopatch' => { 125 => 'MakN', 127 => 0x927c },
	'makernotesigma' => { 125 => 'MakN', 127 => 0x927c },
	'makernotesony' => { 125 => 'MakN', 127 => 0x927c },
	'makernotesony2' => { 125 => 'MakN', 127 => 0x927c },
	'makernotesony3' => { 125 => 'MakN', 127 => 0x927c },
	'makernotesony4' => { 125 => 'MakN', 127 => 0x927c },
	'makernotesony5' => { 125 => 'MakN', 127 => 0x927c },
	'makernotesonyericsson' => { 125 => 'MakN', 127 => 0x927c },
	'makernotesonysrf' => { 125 => 'MakN', 127 => 0x927c },
	'makernotetype' => { 447 => 0x1 },
	'makernoteunknown' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteunknownbinary' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteunknowntext' => { 125 => 'MakN', 127 => 0x927c },
	'makernoteversion' => { 1 => 0x1, 205 => 0x0, 258 => 0x1, 352 => 0x0, 372 => 0x8000, 451 => 0x0, 454 => 0x1, 457 => [0x1d,0x1f], 470 => 0x2000 },
	'makerurl' => { 437 => "\xa9mal" },
	'managedfrom' => { 567 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 567 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 567 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 567 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 567 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 567 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 567 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfromlasturl' => { 567 => [\'ManagedFrom','ManagedFromLastURL'] },
	'managedfromlinkcategory' => { 567 => [\'ManagedFrom','ManagedFromLinkCategory'] },
	'managedfromlinkform' => { 567 => [\'ManagedFrom','ManagedFromLinkForm'] },
	'managedfrommanager' => { 567 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 567 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 567 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 567 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 567 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 567 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 567 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromplacedresolutionunit' => { 567 => [\'ManagedFrom','ManagedFromPlacedResolutionUnit'] },
	'managedfromplacedxresolution' => { 567 => [\'ManagedFrom','ManagedFromPlacedXResolution'] },
	'managedfromplacedyresolution' => { 567 => [\'ManagedFrom','ManagedFromPlacedYResolution'] },
	'managedfromrenditionclass' => { 567 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 567 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 567 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 567 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 567 => 'Manager' },
	'managervariant' => { 567 => 'ManagerVariant' },
	'manageto' => { 567 => 'ManageTo' },
	'manageui' => { 567 => 'ManageUI' },
	'manifest' => { 567 => 'Manifest' },
	'manifestlinkform' => { 567 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 567 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 567 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 567 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 567 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 567 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 567 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 567 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 567 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 567 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 567 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencelasturl' => { 567 => [\'Manifest','ManifestReferenceLastURL'] },
	'manifestreferencelinkcategory' => { 567 => [\'Manifest','ManifestReferenceLinkCategory'] },
	'manifestreferencelinkform' => { 567 => [\'Manifest','ManifestReferenceLinkForm'] },
	'manifestreferencemanager' => { 567 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 567 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 567 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 567 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 567 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 567 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 567 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferenceplacedresolutionunit' => { 567 => [\'Manifest','ManifestReferencePlacedResolutionUnit'] },
	'manifestreferenceplacedxresolution' => { 567 => [\'Manifest','ManifestReferencePlacedXResolution'] },
	'manifestreferenceplacedyresolution' => { 567 => [\'Manifest','ManifestReferencePlacedYResolution'] },
	'manifestreferencerenditionclass' => { 567 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 567 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 567 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 567 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 347 => 0x900, 372 => 0x86 },
	'manometerreading' => { 347 => 0x901 },
	'manualafpointselectpattern' => { 92 => 0x513 },
	'manualafpointselpattern' => { 2 => 0xf },
	'manualflash' => { 350 => 0x1209 },
	'manualflashoutput' => { 38 => 0x29, 327 => '8.2', 330 => '22.2', 331 => '23.1', 332 => '23.2', 334 => '16.2', 335 => '23.2', 336 => '8.2', 337 => '23.2', 340 => '24.2', 447 => 0x100c },
	'manualflashstrength' => { 347 => 0x406 },
	'manualfocusdistance' => { 258 => 0x85, 352 => 0x100c, 456 => 0x223 },
	'manualfocuspointillumination' => { 341 => 0x17, 342 => 0x17, 343 => 0x17, 344 => 0x17 },
	'manualfocusringinafmode' => { 341 => 0x1b, 342 => 0x1a, 343 => 0x1a, 344 => 0x1a },
	'manualtv' => { 91 => 0x5, 92 => 0x705 },
	'manufacturedate' => { 210 => 0x6705, 389 => 0x1 },
	'manufacturedate1' => { 449 => 0x4 },
	'manufacturedate2' => { 449 => 0x5 },
	'manufacturer' => { 145 => 'Manufacturer', 555 => 'manufacturer' },
	'mariahchromablursize' => { 157 => 0xf0d },
	'mariahmaphithreshold' => { 157 => 0xf0c },
	'mariahmaplothreshold' => { 157 => 0xf0b },
	'mariahsigmathreshold' => { 157 => 0xf0e },
	'mariahtexturethreshold' => { 157 => 0xf0a },
	'marked' => { 552 => 'Marked', 570 => 'Marked' },
	'markers' => { 566 => 'markers' },
	'markerscomment' => { 566 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 566 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 566 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 566 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 566 => [\'markers','markersCuePointType'] },
	'markersduration' => { 566 => [\'markers','markersDuration'] },
	'markerslocation' => { 566 => [\'markers','markersLocation'] },
	'markersname' => { 566 => [\'markers','markersName'] },
	'markersprobability' => { 566 => [\'markers','markersProbability'] },
	'markersspeaker' => { 566 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 566 => [\'markers','markersStartTime'] },
	'markerstarget' => { 566 => [\'markers','markersTarget'] },
	'markerstype' => { 566 => [\'markers','markersType'] },
	'maskedareas' => { 127 => 0xc68e },
	'maskgroupbasedcorractive' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionActive'] },
	'maskgroupbasedcorramount' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionAmount'] },
	'maskgroupbasedcorrblacks2012' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBlacks2012'] },
	'maskgroupbasedcorrbrightness' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalBrightness'] },
	'maskgroupbasedcorrclarity' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity'] },
	'maskgroupbasedcorrclarity2012' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalClarity2012'] },
	'maskgroupbasedcorrcontrast' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast'] },
	'maskgroupbasedcorrcontrast2012' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalContrast2012'] },
	'maskgroupbasedcorrcorrectionname' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionName'] },
	'maskgroupbasedcorrcorrectionsyncid' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionSyncID'] },
	'maskgroupbasedcorrdefringe' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDefringe'] },
	'maskgroupbasedcorrdehaze' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalDehaze'] },
	'maskgroupbasedcorrections' => { 536 => 'MaskGroupBasedCorrections', 538 => 'MaskGroupBasedCorrections' },
	'maskgroupbasedcorrexposure' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure'] },
	'maskgroupbasedcorrexposure2012' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalExposure2012'] },
	'maskgroupbasedcorrhighlights2012' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHighlights2012'] },
	'maskgroupbasedcorrhue' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalHue'] },
	'maskgroupbasedcorrluminancenoise' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalLuminanceNoise'] },
	'maskgroupbasedcorrmask' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasks'] },
	'maskgroupbasedcorrmaskalpha' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAlpha'] },
	'maskgroupbasedcorrmaskangle' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksAngle'] },
	'maskgroupbasedcorrmaskbottom' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksBottom'] },
	'maskgroupbasedcorrmaskcentervalue' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterValue'] },
	'maskgroupbasedcorrmaskcenterweight' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCenterWeight'] },
	'maskgroupbasedcorrmaskdabs' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksDabs'] },
	'maskgroupbasedcorrmaskfeather' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFeather'] },
	'maskgroupbasedcorrmaskflipped' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlipped'] },
	'maskgroupbasedcorrmaskflow' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFlow'] },
	'maskgroupbasedcorrmaskfullx' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullX'] },
	'maskgroupbasedcorrmaskfully' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksFullY'] },
	'maskgroupbasedcorrmaskinputdigest' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksInputDigest'] },
	'maskgroupbasedcorrmaskleft' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksLeft'] },
	'maskgroupbasedcorrmaskmaskactive' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskActive'] },
	'maskgroupbasedcorrmaskmaskblendmode' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmaskdigest' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmaskinverted' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmaskname' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskName'] },
	'maskgroupbasedcorrmaskmasks' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasks'] },
	'maskgroupbasedcorrmaskmasksalpha' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'maskgroupbasedcorrmaskmasksangle' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksAngle'] },
	'maskgroupbasedcorrmaskmasksbottom' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksBottom'] },
	'maskgroupbasedcorrmaskmaskscentervalue' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'maskgroupbasedcorrmaskmaskscenterweight' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'maskgroupbasedcorrmaskmasksdabs' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksDabs'] },
	'maskgroupbasedcorrmaskmasksfeather' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFeather'] },
	'maskgroupbasedcorrmaskmasksflipped' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'maskgroupbasedcorrmaskmasksflow' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFlow'] },
	'maskgroupbasedcorrmaskmasksfullx' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullX'] },
	'maskgroupbasedcorrmaskmasksfully' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksFullY'] },
	'maskgroupbasedcorrmaskmasksinputdigest' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'maskgroupbasedcorrmaskmasksleft' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksLeft'] },
	'maskgroupbasedcorrmaskmasksmaskactive' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'maskgroupbasedcorrmaskmasksmaskblendmode' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'maskgroupbasedcorrmaskmasksmaskdigest' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'maskgroupbasedcorrmaskmasksmaskinverted' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'maskgroupbasedcorrmaskmasksmaskname' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'maskgroupbasedcorrmaskmasksmasksubtype' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksmasksyncid' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmasksmaskversion' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmasksmidpoint' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'maskgroupbasedcorrmaskmasksorigin' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'maskgroupbasedcorrmaskmasksperimetervalue' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskmasksradius' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRadius'] },
	'maskgroupbasedcorrmaskmasksreferencepoint' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'maskgroupbasedcorrmaskmasksright' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRight'] },
	'maskgroupbasedcorrmaskmasksroundness' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'maskgroupbasedcorrmaskmaskssizex' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'maskgroupbasedcorrmaskmaskssizey' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'maskgroupbasedcorrmaskmaskstop' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksTop'] },
	'maskgroupbasedcorrmaskmasksubtype' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSubType'] },
	'maskgroupbasedcorrmaskmasksvalue' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'maskgroupbasedcorrmaskmasksversion' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksVersion'] },
	'maskgroupbasedcorrmaskmaskswhat' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWhat'] },
	'maskgroupbasedcorrmaskmaskswholeimagearea' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskmasksx' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksX'] },
	'maskgroupbasedcorrmaskmasksy' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksY'] },
	'maskgroupbasedcorrmaskmasksyncid' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'maskgroupbasedcorrmaskmaskszerox' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'maskgroupbasedcorrmaskmaskszeroy' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'maskgroupbasedcorrmaskmaskversion' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskVersion'] },
	'maskgroupbasedcorrmaskmidpoint' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMidpoint'] },
	'maskgroupbasedcorrmaskorigin' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksOrigin'] },
	'maskgroupbasedcorrmaskperimetervalue' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'maskgroupbasedcorrmaskradius' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRadius'] },
	'maskgroupbasedcorrmaskrange' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'maskgroupbasedcorrmaskrangeareamodels' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrmaskrangeareamodelscolorsampleinfo' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrmaskrangeareamodelscomponents' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrmaskrangecoloramount' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrmaskrangedepthfeather' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrmaskrangedepthmax' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrmaskrangedepthmin' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrmaskrangeinvert' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrmaskrangelumfeather' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrmaskrangeluminancedepthsampleinfo' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrmaskrangelummax' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrmaskrangelummin' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrmaskrangelumrange' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrmaskrangesampletype' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrmaskrangetype' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'maskgroupbasedcorrmaskrangeversion' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrmaskreferencepoint' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksReferencePoint'] },
	'maskgroupbasedcorrmaskright' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRight'] },
	'maskgroupbasedcorrmaskroundness' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksRoundness'] },
	'maskgroupbasedcorrmasksizex' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeX'] },
	'maskgroupbasedcorrmasksizey' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksSizeY'] },
	'maskgroupbasedcorrmasktop' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksTop'] },
	'maskgroupbasedcorrmaskvalue' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksMaskValue'] },
	'maskgroupbasedcorrmaskversion' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksVersion'] },
	'maskgroupbasedcorrmaskwhat' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWhat'] },
	'maskgroupbasedcorrmaskwholeimagearea' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'maskgroupbasedcorrmaskx' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksX'] },
	'maskgroupbasedcorrmasky' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksY'] },
	'maskgroupbasedcorrmaskzerox' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroX'] },
	'maskgroupbasedcorrmaskzeroy' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionMasksZeroY'] },
	'maskgroupbasedcorrmoire' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalMoire'] },
	'maskgroupbasedcorrrangemask' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMask'] },
	'maskgroupbasedcorrrangemaskareamodels' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'maskgroupbasedcorrrangemaskareamodelscolorsampleinfo' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'maskgroupbasedcorrrangemaskareamodelscomponents' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'maskgroupbasedcorrrangemaskcoloramount' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'maskgroupbasedcorrrangemaskdepthfeather' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'maskgroupbasedcorrrangemaskdepthmax' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'maskgroupbasedcorrrangemaskdepthmin' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'maskgroupbasedcorrrangemaskinvert' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskInvert'] },
	'maskgroupbasedcorrrangemasklumfeather' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'maskgroupbasedcorrrangemaskluminancedepthsampleinfo' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'maskgroupbasedcorrrangemasklummax' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'maskgroupbasedcorrrangemasklummin' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'maskgroupbasedcorrrangemasklumrange' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'maskgroupbasedcorrrangemasksampletype' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'maskgroupbasedcorrrangemasktype' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskType'] },
	'maskgroupbasedcorrrangemaskversion' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsCorrectionRangeMaskVersion'] },
	'maskgroupbasedcorrsaturation' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSaturation'] },
	'maskgroupbasedcorrshadows2012' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalShadows2012'] },
	'maskgroupbasedcorrsharpness' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalSharpness'] },
	'maskgroupbasedcorrtemperature' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTemperature'] },
	'maskgroupbasedcorrtexture' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTexture'] },
	'maskgroupbasedcorrtint' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalTint'] },
	'maskgroupbasedcorrtoninghue' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningHue'] },
	'maskgroupbasedcorrtoningsaturation' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalToningSaturation'] },
	'maskgroupbasedcorrwhat' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsWhat'] },
	'maskgroupbasedcorrwhites2012' => { 536 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'], 538 => [\'MaskGroupBasedCorrections','MaskGroupBasedCorrectionsLocalWhites2012'] },
	'masterdocumentid' => { 150 => 0xb9 },
	'mastergain' => { 284 => 0x50 },
	'materialsample' => { 126 => 'MaterialSample' },
	'materialsampleid' => { 126 => [\'MaterialSample','MaterialSampleMaterialSampleID'] },
	'matrixmetering' => { 326 => '50.1', 328 => '48.1', 329 => '48.1', 338 => '48.1', 339 => '48.1', 342 => 0x233, 343 => 0x233, 344 => 0x24b },
	'matrixselectk' => { 157 => 0x91b },
	'matrixselectthreshold' => { 157 => 0x91a },
	'matrixselectthreshold1' => { 157 => 0x91e },
	'matrixselectthreshold2' => { 157 => 0x91f },
	'matrixstructure' => { 436 => 0xa },
	'maxaperture' => { 38 => 0x1a, 157 => 0x3f9, 163 => 0x6103, 182 => 'MaxAperture', 200 => 0x17, 206 => 0x49c5, 256 => 0x36, 348 => 0x20a, 401 => '14.1' },
	'maxapertureatmaxfocal' => { 135 => 0x1407, 182 => 'MaxApertureAtMaxFocal', 250 => 0xb, 251 => 0x10, 252 => 0x11, 256 => 0x12, 348 => 0x206 },
	'maxapertureatminfocal' => { 135 => 0x1406, 250 => 0xa, 251 => 0xf, 252 => 0x10, 256 => 0x11, 348 => 0x205 },
	'maxaperturevalue' => { 127 => 0x9205, 420 => 0x414, 542 => 'MaxApertureValue' },
	'maxavailheight' => { 550 => 'MaxAvailHeight' },
	'maxavailwidth' => { 550 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 325 => 0xb, 326 => 0xc, 328 => '12.1', 329 => '12.1', 334 => 0xc, 335 => 0xb, 338 => '12.1', 339 => '12.1', 341 => 0x41, 342 => 0x3d, 343 => 0x3d, 344 => 0x3d },
	'maxfaces' => { 351 => 0x1202 },
	'maxfocallength' => { 7 => 0xe6, 8 => 0x10, 9 => 0x1ab, 10 => 0x13, 11 => 0x115, 12 => 0x13, 13 => 0x153, 14 => 0xda, 16 => 0xfa, 17 => 0xee, 18 => 0x103, 19 => 0x95, 20 => 0xea, 21 => 0x157, 22 => 0xee, 23 => 0xec, 24 => 0x12b, 25 => 0x165, 26 => 0x16a, 27 => 0x188, 28 => 0x116, 29 => 0x18d, 38 => 0x17, 135 => 0x1405, 182 => 'MaxFocalLength', 250 => 0x9, 251 => 0xe, 252 => 0xf, 256 => 0x10, 348 => 0x208, 494 => 0x127c, 495 => 0x1138, 496 => 0x330, 497 => 0x330, 498 => 0x30e },
	'maxfocallength2' => { 68 => 0x9 },
	'maximumaperturelv' => { 266 => 0x89e },
	'maximumdensityrange' => { 152 => 0x8c },
	'maxnumafpoints' => { 384 => 0x2 },
	'maxpagesize' => { 571 => 'MaxPageSize' },
	'maxpagesizeh' => { 571 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 571 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 571 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxpixelvaluethreshold' => { 157 => 0xc7d },
	'maxsamplevalue' => { 127 => 0x119 },
	'maxstorage' => { 561 => 'maxstorage' },
	'mb-d10batteries' => { 325 => '12.6' },
	'mb-d10batterytype' => { 334 => '13.3' },
	'mb-d11batterytype' => { 335 => '2.3' },
	'mb-d12batterytype' => { 338 => '3.2' },
	'mb-d80batteries' => { 336 => '6.5' },
	'mb-d80batterytype' => { 340 => '3.2' },
	'mcuversion' => { 250 => 0xc, 251 => 0x11, 252 => 0x12, 256 => 0x13 },
	'md5digest' => { 183 => 'zmd5' },
	'mditemfindercomment' => { 192 => 'MDItemFinderComment' },
	'mditemfscreationdate' => { 192 => 'MDItemFSCreationDate' },
	'mditemfslabel' => { 192 => 'MDItemFSLabel' },
	'mditemusertags' => { 192 => 'MDItemUserTags' },
	'meal' => { 558 => 'meal' },
	'measuredev' => { 28 => 0x9, 84 => 0x3, 105 => 0x1814, 175 => 'MeasuredEV' },
	'measuredev2' => { 13 => 0x8, 28 => 0x8, 84 => 0x17 },
	'measuredev3' => { 13 => 0x9 },
	'measuredlv' => { 206 => 0x690, 367 => 0x312, 370 => 0x312, 371 => 0x312, 374 => 0x3407 },
	'measuredrggb' => { 72 => 0x1 },
	'measuredrggbdata' => { 49 => 0x287 },
	'measurementaccuracy' => { 126 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 126 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 126 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 126 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 126 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 126 => 'MeasurementOrFact' },
	'measurementremarks' => { 126 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 126 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 126 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 126 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'measuretype' => { 145 => 'MeasureType' },
	'mechanicalshuttercount' => { 258 => 0x37 },
	'mediaclassprimaryid' => { 198 => 'WM/MediaClassPrimaryID' },
	'mediaclasssecondaryid' => { 198 => 'WM/MediaClassSecondaryID' },
	'mediaconstraints' => { 358 => 'MediaConstraints' },
	'mediacreatedate' => { 433 => 0x1 },
	'mediaeventiddate' => { 524 => 'MediaEventIdDate' },
	'mediamodifydate' => { 433 => 0x2 },
	'mediasummarycode' => { 358 => 'MediaSummaryCode' },
	'mediatype' => { 429 => 'stik' },
	'mediauid' => { 437 => 'MUID' },
	'memoaudioquality' => { 92 => 0x812 },
	'memorycardconfiguration' => { 473 => 0x16 },
	'memorycardnumber' => { 235 => 0x2 },
	'menubuttondisplayposition' => { 90 => 0xb, 93 => 0xa, 94 => 0xb, 97 => 0xb },
	'menubuttonreturn' => { 98 => 0xb },
	'menumonitorofftime' => { 325 => '26.1', 326 => '22.1', 328 => '22.1', 329 => '22.1', 333 => '21.1', 334 => '8.2', 335 => '21.1', 338 => '22.1', 339 => '22.1', 340 => '22.1', 341 => 0x39, 342 => 0x35, 343 => 0x35, 344 => 0x35 },
	'mergedimages' => { 372 => 0x76 },
	'metadataauthority' => { 550 => 'metadataAuthority' },
	'metadataauthorityidentifier' => { 550 => [\'metadataAuthority','metadataAuthorityIdentifier'] },
	'metadataauthorityname' => { 550 => [\'metadataAuthority','metadataAuthorityName'] },
	'metadatadate' => { 564 => 'MetadataDate' },
	'metadataeditingsoftware' => { 127 => 0xa43c, 543 => 'MetadataEditingSoftware' },
	'metadatalastedited' => { 550 => 'metadataLastEdited' },
	'metadatalasteditor' => { 550 => 'metadataLastEditor' },
	'metadatalasteditoridentifier' => { 550 => [\'metadataLastEditor','metadataLastEditorIdentifier'] },
	'metadatalasteditorname' => { 550 => [\'metadataLastEditor','metadataLastEditorName'] },
	'metadatamoddate' => { 566 => 'metadataModDate' },
	'metaversion' => { 489 => 0x34 },
	'meterinfo1row1' => { 482 => 0x0, 483 => 0x0 },
	'meterinfo1row2' => { 482 => 0x6c, 483 => 0x5a },
	'meterinfo1row3' => { 482 => 0xd8, 483 => 0xb4 },
	'meterinfo1row4' => { 482 => 0x144, 483 => 0x10e },
	'meterinfo1row5' => { 482 => 0x1b0, 483 => 0x168 },
	'meterinfo1row6' => { 482 => 0x21c, 483 => 0x1c2 },
	'meterinfo1row7' => { 482 => 0x288, 483 => 0x21c },
	'meterinfo2row1' => { 482 => 0x2f4, 483 => 0x276 },
	'meterinfo2row2' => { 482 => 0x378, 483 => 0x2e4 },
	'meterinfo2row3' => { 482 => 0x3fc, 483 => 0x352 },
	'meterinfo2row4' => { 482 => 0x480, 483 => 0x3c0 },
	'meterinfo2row5' => { 482 => 0x504, 483 => 0x42e },
	'meterinfo2row6' => { 482 => 0x588, 483 => 0x49c },
	'meterinfo2row7' => { 482 => 0x60c, 483 => 0x50a },
	'meterinfo2row8' => { 482 => 0x690, 483 => 0x578 },
	'meterinfo2row9' => { 482 => 0x714, 483 => 0x5e6 },
	'metering' => { 327 => '6.1' },
	'meteringmode' => { 38 => 0x11, 127 => 0x9207, 159 => 0x1c, 200 => 0x7, 201 => 0x25, 203 => 0x12, 347 => 0x202, 411 => 0x17, 457 => 0x9, 467 => 0x15, 468 => 0x13, 469 => 0x7, 486 => 0x3, 490 => 0x1174, 491 => 0x1178, 492 => 0x1154, 493 => 0x11d0, 494 => 0x11ac, 495 => 0x1064, 496 => 0x25c, 497 => 0x25c, 498 => 0x24b, 542 => 'MeteringMode' },
	'meteringmode2' => { 390 => '2.1', 481 => 0x202c },
	'meteringmode3' => { 390 => '16.1' },
	'meteringoffscaleindicator' => { 203 => 0x53 },
	'meteringtime' => { 325 => '22.2', 327 => '3.2', 330 => '17.1', 331 => '18.1', 334 => '7.3', 335 => '18.1', 336 => '3.2', 340 => '19.1' },
	'micro1version' => { 443 => 0x1f },
	'micro2version' => { 443 => 0x2d },
	'microphoneattenuator' => { 264 => 0x34e, 267 => 0x2d2, 268 => 0x2fa, 269 => 0x2fa },
	'microphonefrequencyresponse' => { 264 => 0x350, 267 => 0x2d4, 268 => 0x2fc, 269 => 0x2fc },
	'microphonejackpower' => { 264 => 0x376, 267 => 0x2fa, 268 => 0x322, 269 => 0x322 },
	'microphonesensitivity' => { 264 => 0x34c, 267 => 0x2d0, 268 => 0x2f8, 269 => 0x2f8 },
	'microvideo' => { 142 => 'MicroVideo' },
	'microvideooffset' => { 142 => 'MicroVideoOffset' },
	'microvideopresentationtimestampus' => { 142 => 'MicroVideoPresentationTimestampUs' },
	'microvideoversion' => { 142 => 'MicroVideoVersion' },
	'midrangesharpness' => { 278 => 0x3b },
	'mieversion' => { 183 => '0Vers' },
	'mime' => { 145 => 'Mime' },
	'minaperture' => { 38 => 0x1b, 157 => 0x3f8, 182 => 'MinAperture', 401 => '0.2' },
	'minaperturevalue' => { 420 => 0x415 },
	'minfocallength' => { 7 => 0xe4, 8 => 0xe, 9 => 0x1a9, 10 => 0x11, 11 => 0x113, 12 => 0x11, 13 => 0x151, 14 => 0xd8, 16 => 0xf8, 17 => 0xec, 18 => 0x101, 19 => 0x93, 20 => 0xe8, 21 => 0x155, 22 => 0xec, 23 => 0xea, 24 => 0x129, 25 => 0x163, 26 => 0x168, 27 => 0x186, 28 => 0x114, 29 => 0x18b, 38 => 0x18, 135 => 0x1404, 182 => 'MinFocalLength', 250 => 0x8, 251 => 0xd, 252 => 0xe, 256 => 0xf, 348 => 0x207, 494 => 0x127a, 495 => 0x1136, 496 => 0x32e, 497 => 0x32e, 498 => 0x30c },
	'minfocallength2' => { 68 => 0x8 },
	'minfocusdistance' => { 401 => 0x3 },
	'minimumiso' => { 372 => 0xe8 },
	'minintegrationrows' => { 157 => 0x1874 },
	'minoltadate' => { 200 => 0x15 },
	'minoltaimagesize' => { 200 => 0x4, 201 => 0xc, 202 => 0x2, 205 => 0x103 },
	'minoltamodelid' => { 200 => 0x25 },
	'minoltaquality' => { 200 => 0x5, 201 => 0xd, 202 => 0x3, 205 => [0x102,0x103] },
	'minoltatime' => { 200 => 0x16 },
	'minormodelagedisclosure' => { 358 => 'MinorModelAgeDisclosure' },
	'minorversion' => { 431 => 'minor_version', 526 => 'MinorVersion' },
	'minsamplevalue' => { 127 => 0x118 },
	'mirroring' => { 430 => 'imir' },
	'mirrorlockup' => { 90 => 0xc, 91 => 0xc, 92 => 0x60f, 93 => 0xb, 94 => 0xc, 95 => 0x6, 96 => 0x6, 97 => 0xc, 98 => 0x3 },
	'mobilecountrycode' => { 535 => 'mcc' },
	'mobilenetworkcode' => { 535 => 'mnc' },
	'moddate' => { 361 => 'modify-date', 552 => 'ModDate' },
	'modedialposition' => { 473 => 0x14 },
	'model' => { 106 => 0x6, 127 => 0x110, 145 => 'Model', 175 => 'Model', 361 => 'Model', 377 => 0x110, 411 => 0x23f, 431 => 'model', 437 => ['@mod','CNMN','cmnm',"\xa9mdl","\xa9mod"], 457 => 0x84, 555 => 'model', 562 => 'Model' },
	'modelage' => { 550 => 'ModelAge' },
	'modelid' => { 345 => 0x0 },
	'modelingflash' => { 325 => '21.4', 326 => '31.1', 328 => '31.1', 329 => '31.1', 334 => '26.4', 335 => '30.2', 336 => '7.4', 337 => '30.1', 338 => '31.1', 339 => '31.1', 340 => '31.3', 341 => 0x61, 342 => 0x5d, 343 => 0x5d, 344 => 0x5d },
	'modelreleaseid' => { 358 => 'ModelReleaseID' },
	'modelreleasestatus' => { 358 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 504 => 0x52, 505 => 0x46, 506 => 0x53 },
	'modeltiepoint' => { 127 => 0x8482 },
	'modeltransform' => { 127 => 0x85d8 },
	'modelyear' => { 555 => 'modelYear' },
	'modificationdate' => { 556 => 'modificationDate' },
	'modifiedcolortemp' => { 73 => 0x9 },
	'modifieddigitalgain' => { 73 => 0xb },
	'modifiedparamflag' => { 63 => 0x1 },
	'modifiedpicturestyle' => { 73 => 0xa },
	'modifiedsaturation' => { 347 => 0x504 },
	'modifiedsensorbluelevel' => { 73 => 0x5 },
	'modifiedsensorredlevel' => { 73 => 0x4 },
	'modifiedsharpness' => { 73 => 0x2 },
	'modifiedsharpnessfreq' => { 73 => 0x3 },
	'modifiedtonecurve' => { 73 => 0x1 },
	'modifiedwhitebalance' => { 73 => 0x8 },
	'modifiedwhitebalanceblue' => { 73 => 0x7 },
	'modifiedwhitebalancered' => { 73 => 0x6 },
	'modifydate' => { 127 => 0x132, 176 => 'ModifyDate', 357 => 'ModDate', 359 => 'tIME', 427 => 'ModDate', 434 => 0x2, 564 => 'ModifyDate' },
	'moirefilter' => { 127 => 0xfe58, 536 => 'MoireFilter', 538 => 'MoireFilter' },
	'monitorbrightness' => { 262 => 0x904, 265 => 0x69a, 266 => 0x6aa, 267 => 0x59a, 268 => 0x5ca, 269 => 0x5e2 },
	'monitordisplayoff' => { 203 => 0x4c },
	'monitormatrix' => { 157 => 0x8fc },
	'monitorofftime' => { 325 => '18.2', 327 => '3.1', 336 => '3.1' },
	'monochromecolor' => { 347 => 0x53b },
	'monochromecontrast' => { 117 => 0x3c },
	'monochromefiltereffect' => { 111 => 0x20307, 117 => 0x3a, 372 => 0xac, 411 => 0x73 },
	'monochromegraineffect' => { 372 => 0xd2 },
	'monochromelinear' => { 117 => 0x3d },
	'monochromeoutputhighlightpoint' => { 117 => 0x41 },
	'monochromeoutputshadowpoint' => { 117 => 0x42 },
	'monochromeprofilesettings' => { 347 => 0x537 },
	'monochromerawhighlight' => { 117 => 0x7a },
	'monochromerawhighlightpoint' => { 117 => 0x3f },
	'monochromerawshadow' => { 117 => 0x83 },
	'monochromerawshadowpoint' => { 117 => 0x40 },
	'monochromesharpness' => { 117 => 0x3e },
	'monochrometoning' => { 411 => 0x74 },
	'monochrometoningeffect' => { 111 => 0x20306, 117 => 0x3b },
	'monochromeunsharpmaskfineness' => { 117 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 117 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 117 => 0xb4 },
	'monochromevignetting' => { 347 => 0x53a },
	'monthdaycreated' => { 159 => 0x12, 168 => 0xe },
	'mood' => { 198 => 'WM/Mood' },
	'moonphase' => { 439 => 0x12, 440 => 0x4c, 441 => 0x37, 442 => 0x5c, 443 => 0x43 },
	'morepermissions' => { 534 => 'morePermissions' },
	'motionphoto' => { 142 => 'MotionPhoto' },
	'motionphotopresentationtimestampus' => { 142 => 'MotionPhotoPresentationTimestampUs' },
	'motionphotoversion' => { 142 => 'MotionPhotoVersion' },
	'motionphotovideo' => { 432 => 'mpvd' },
	'motionsensitivity' => { 439 => 0x29, 440 => 0x60, 441 => 0x49, 442 => 0x70 },
	'movementcount' => { 429 => "\xa9mvc" },
	'movementname' => { 429 => "\xa9mvn" },
	'movementnumber' => { 429 => "\xa9mvi" },
	'movieactived-lighting' => { 263 => 0x238, 264 => 0x334, 267 => 0x2b8, 268 => 0x2e0, 269 => 0x2e0 },
	'movieaelockbuttonassignment' => { 338 => '40.1' },
	'movieaf-onbutton' => { 341 => 0xd3, 342 => 0xcb, 343 => 0xcb, 344 => 0xcb },
	'movieafareamode' => { 264 => 0x342, 267 => 0x2c6, 268 => 0x2ee, 269 => 0x2ee, 343 => 0x203 },
	'movieafspeed' => { 341 => 0xe5, 342 => 0xdd, 343 => 0xdd, 344 => 0xdd },
	'movieafspeedapply' => { 341 => 0xe7, 342 => 0xdf, 343 => 0xdf, 344 => 0xdf },
	'movieaftrackingsensitivity' => { 341 => 0xe9, 342 => 0xe1, 343 => 0xe1, 344 => 0xe1 },
	'movieaperturelock' => { 342 => 0x259, 343 => 0x259, 344 => 0x271 },
	'movieautodistortioncontrol' => { 263 => 0x242 },
	'moviediffractioncompensation' => { 263 => 0x241 },
	'moviedxcropalert' => { 264 => 0x377, 267 => 0x2fb, 268 => 0x323, 269 => 0x323 },
	'movieelectronicvr' => { 264 => 0x348, 267 => 0x2cc, 268 => 0x2f4, 269 => 0x2f4 },
	'movieevfgrid' => { 342 => 0x21d, 343 => 0x21d, 344 => 0x235 },
	'movieflickerreduction' => { 264 => 0x33c, 267 => 0x2c0, 268 => 0x2e8, 269 => 0x2e8 },
	'moviefocusmode' => { 263 => 0x248, 264 => 0x340, 267 => 0x2c4, 268 => 0x2ec, 269 => 0x2ec },
	'moviefocuspointlock' => { 342 => 0x226, 343 => 0x226, 344 => 0x23e },
	'movieframerate' => { 262 => 0x48c, 263 => 0x1f8, 264 => 0x374, 267 => 0x2f4, 268 => 0x31c, 269 => 0x31c },
	'movieframesize' => { 262 => 0x48a, 263 => 0x1f6, 264 => 0x372, 267 => 0x2f2, 268 => 0x31a, 269 => 0x31a },
	'moviefunc1button' => { 328 => '41.1', 329 => '41.1', 339 => '41.1', 341 => 0xc7, 342 => 0xc3, 343 => 0xc3, 344 => 0xc3 },
	'moviefunc2button' => { 341 => 0xcd, 342 => 0xc7, 343 => 0xc7, 344 => 0xc7 },
	'moviefunc3button' => { 343 => 0x127, 344 => 0x13f },
	'moviefunctionbutton' => { 326 => '41.1', 338 => '41.1' },
	'moviefunctionbuttonplusdials' => { 326 => '52.1' },
	'moviehighisonoisereduction' => { 263 => 0x23c, 264 => 0x336, 267 => 0x2ba, 268 => 0x2e2, 269 => 0x2e2 },
	'moviehighlightdisplaythreshold' => { 342 => 0x215, 343 => 0x215, 344 => 0x22d },
	'moviehighreszoom' => { 264 => 0x380, 268 => 0x32c, 269 => 0x32c },
	'movieimagearea' => { 264 => 0x2da, 267 => 0x25c, 268 => 0x286, 269 => 0x286 },
	'movieisoautocontrolmanualmode' => { 264 => 0x2e8, 267 => 0x26a, 268 => 0x294, 269 => 0x294 },
	'movieisoautohilimit' => { 264 => 0x2e6, 267 => 0x268, 268 => 0x292, 269 => 0x292 },
	'movieisoautomanualmode' => { 263 => 0x204, 264 => 0x2ea, 267 => 0x26c, 268 => 0x296, 269 => 0x296 },
	'movielenscontrolring' => { 341 => 0xdf, 342 => 0xd7, 343 => 0xd7, 344 => 0xd7 },
	'moviemeteringmode' => { 264 => 0x33e, 267 => 0x2c2, 268 => 0x2ea, 269 => 0x2ea },
	'moviemidtonedisplayrange' => { 342 => 0x219, 343 => 0x219, 344 => 0x231 },
	'moviemidtonedisplayvalue' => { 342 => 0x217, 343 => 0x217, 344 => 0x22f },
	'moviemultiselector' => { 341 => 0xe1, 342 => 0xd9, 343 => 0xcf, 344 => 0xcf },
	'moviepreviewbutton' => { 326 => '41.2', 328 => '41.2', 329 => '41.2', 338 => '41.2', 339 => '41.2' },
	'moviepreviewbuttonplusdials' => { 326 => '52.2' },
	'movierecordbuttonplaybackmode' => { 341 => 0x1af, 342 => 0x1b5, 343 => 0x1b5, 344 => 0x1cd },
	'movieshutterbutton' => { 326 => '38.3', 328 => '38.3', 329 => '38.3', 338 => '38.3', 339 => '38.3' },
	'movieshutterspeedlock' => { 342 => 0x225, 343 => 0x225, 344 => 0x23d },
	'movieslowmotion' => { 262 => 0x416, 263 => 0x1fa },
	'moviesoundrecording' => { 264 => 0x34a, 267 => 0x2ce, 268 => 0x2f6, 269 => 0x2f6 },
	'moviesubjectdetection' => { 264 => 0x378, 267 => 0x2fc, 268 => 0x324, 269 => 0x324 },
	'moviesubselectorassignment' => { 326 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 326 => '53.1' },
	'movietonemap' => { 267 => 0x2ec, 268 => 0x314, 269 => 0x314 },
	'movietype' => { 247 => 0x2ca, 262 => 0x41a, 263 => 0x1fe, 264 => 0x2e4, 267 => 0x266, 268 => 0x290, 269 => 0x290 },
	'movievibrationreduction' => { 263 => 0x24e },
	'movievibrationreductionsameasphoto' => { 263 => 0x24f },
	'movievignettecontrol' => { 263 => 0x23e, 264 => 0x1b0, 267 => 0x1a0, 268 => 0x1b4, 269 => 0x1b4 },
	'movievignettecontrolsameasphoto' => { 263 => 0x240 },
	'movievrmode' => { 264 => 0x344, 267 => 0x2c8, 268 => 0x2f0, 269 => 0x2f0 },
	'moviezebrapattern' => { 342 => 0x213, 343 => 0x213, 344 => 0x22b },
	'multiburstimageheight' => { 481 => 0x1002 },
	'multiburstimagewidth' => { 481 => 0x1001 },
	'multiburstmode' => { 481 => 0x1000 },
	'multicontrollerwhilemetering' => { 92 => 0x517 },
	'multiexposure' => { 75 => 0x1, 372 => 0xb4 },
	'multiexposureautogain' => { 271 => 0x3 },
	'multiexposurecontrol' => { 75 => 0x2 },
	'multiexposuremode' => { 271 => 0x1, 272 => 0x1 },
	'multiexposureoverlaymode' => { 272 => 0x3 },
	'multiexposureshots' => { 75 => 0x3, 262 => 0x1be, 264 => 0x9a, 267 => 0x8e, 268 => 0x9c, 269 => 0x9c, 271 => 0x2, 272 => 0x2 },
	'multiframenoisereduction' => { 469 => 0x35, 481 => 0x200b, 486 => 0x15 },
	'multiframenreffect' => { 481 => 0x2023 },
	'multifunctionlock' => { 92 => 0x70f },
	'multipleexposure' => { 135 => 0x1037 },
	'multipleexposuremode' => { 262 => 0x1bc, 264 => 0x98, 267 => 0x8c, 268 => 0x9a, 269 => 0x9a, 351 => 0x101c },
	'multipleexposureset' => { 390 => '10.1' },
	'multisample' => { 284 => 0x40 },
	'multiselector' => { 325 => '9.4', 326 => '10.3', 328 => '10.3', 329 => '10.3', 334 => '27.4', 338 => '10.3', 339 => '10.3' },
	'multiselectorliveview' => { 325 => '4.3', 328 => '37.1', 329 => '37.1', 338 => '37.1', 339 => '37.1' },
	'multiselectorliveviewmode' => { 298 => 0x18c2 },
	'multiselectorplaybackmode' => { 325 => ['13.5','9.2'], 326 => '10.2', 329 => '10.2', 334 => '27.2', 338 => '10.2', 339 => '10.2', 341 => 0xb7, 342 => 0xb3, 343 => 0xb3, 344 => 0xb3 },
	'multiselectorshootmode' => { 325 => '9.1', 326 => '10.1', 328 => '10.1', 329 => '10.1', 334 => '27.1', 338 => '10.1', 339 => '10.1', 341 => 0xb3, 342 => 0xaf, 343 => 0xaf, 344 => 0xaf },
	'multishot' => { 377 => 0x121 },
	'mute' => { 428 => 'player.movie.audio.mute', 431 => 'player.movie.audio.mute' },
	'mycolormode' => { 76 => 0x2 },
	'name' => { 437 => 'name', 536 => 'Name', 538 => 'Name' },
	'narrator' => { 429 => "\xa9nrt" },
	'nationalcatalognumber' => { 556 => 'nationalCatalogNumber' },
	'nativedigest' => { 542 => 'NativeDigest', 562 => 'NativeDigest' },
	'nativeformat' => { 531 => 'NativeFormat' },
	'ndfilter' => { 84 => 0x1c, 347 => 0x204, 447 => 0x1019 },
	'near' => { 145 => 'Near' },
	'nefbitdepth' => { 258 => 0xe22 },
	'nefcompression' => { 258 => 0x93, 259 => 0xa },
	'neflinearizationtable' => { 258 => 0x96 },
	'negativecachelargepreviewsize' => { 536 => 'NegativeCacheLargePreviewSize', 538 => 'NegativeCacheLargePreviewSize' },
	'negativecachemaximumsize' => { 536 => 'NegativeCacheMaximumSize', 538 => 'NegativeCacheMaximumSize' },
	'negativecachepath' => { 536 => 'NegativeCachePath', 538 => 'NegativeCachePath' },
	'neutraldensityfactor' => { 533 => 'NeutralDensityFactor' },
	'neutraldensityfilter' => { 411 => 0x88 },
	'neutraloutputhighlightpoint' => { 117 => 0x2f },
	'neutraloutputshadowpoint' => { 117 => 0x30 },
	'neutralrawcolortone' => { 117 => 0x28 },
	'neutralrawcontrast' => { 117 => 0x2a },
	'neutralrawhighlight' => { 117 => 0x78 },
	'neutralrawhighlightpoint' => { 117 => 0x2d },
	'neutralrawlinear' => { 117 => 0x2b },
	'neutralrawsaturation' => { 117 => 0x29 },
	'neutralrawshadow' => { 117 => 0x81 },
	'neutralrawshadowpoint' => { 117 => 0x2e },
	'neutralrawsharpness' => { 117 => 0x2c },
	'neutralunsharpmaskfineness' => { 117 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 117 => 0xa8 },
	'neutraunsharpmaskstrength' => { 117 => 0xa4 },
	'newlensdata' => { 256 => 0x2f },
	'newrawimagedigest' => { 127 => 0xc7a7 },
	'newsphotoversion' => { 152 => 0x0 },
	'nickname' => { 564 => 'Nickname' },
	'nikoncapturedata' => { 258 => 0xe01 },
	'nikoncaptureeditversions' => { 258 => 0xe13 },
	'nikoncaptureoffsets' => { 258 => 0xe0e },
	'nikoncaptureoutput' => { 258 => 0xe1e },
	'nikoncaptureversion' => { 258 => 0xe09 },
	'nikoniccprofile' => { 258 => 0xe1d },
	'nikonimagesize' => { 295 => '723.1', 296 => '732.1', 304 => 0x2c4 },
	'nikonmeteringmode' => { 221 => 0x17, 262 => 0x2d2, 263 => 0x146, 275 => 0x214 },
	'nikonsettings' => { 258 => 0x4e },
	'noisefilter' => { 347 => 0x527 },
	'noiseprofile' => { 127 => 0xc761 },
	'noisereduction' => { 135 => [0x100b,0x100e], 201 => 0xb0, 202 => 0x60, 203 => 0x3f, 258 => 0x95, 318 => 0x753dcbc0, 319 => 0x17, 347 => 0x50a, 352 => 0x103a, 372 => 0x2d, 411 => 0x49, 447 => 0x100f, 449 => 0x2a },
	'noisereduction2' => { 351 => 0x1010 },
	'noisereductionapplied' => { 127 => 0xc6f7 },
	'noisereductionintensity' => { 319 => 0x9 },
	'noisereductionmethod' => { 319 => 0x11 },
	'noisereductionmode' => { 518 => 0x801e },
	'noisereductionparametersatcapture' => { 157 => 0xe73 },
	'noisereductionparameterscamera' => { 157 => 0xe72 },
	'noisereductionparametershost3mp' => { 157 => 0xe71 },
	'noisereductionparametershost6mp' => { 157 => 0xe70 },
	'noisereductionparametershostrgb' => { 157 => 0xe6f },
	'noisereductionparameterskhufu3mp' => { 157 => 0xe65 },
	'noisereductionparameterskhufu6mp' => { 157 => 0xe64 },
	'noisereductionparameterskhufurgb' => { 157 => 0xe63 },
	'noisereductionparams' => { 377 => 0x1b },
	'noisereductionsharpness' => { 319 => 0xd },
	'noisereductionstrength' => { 372 => 0xd6 },
	'noisereductionvalue' => { 518 => 0x8027 },
	'nomemorycard' => { 325 => '22.1', 326 => '4.2', 327 => '0.3', 330 => '2.4', 331 => '3.2', 332 => '3.2', 334 => '33.7', 335 => '3.2', 336 => '0.3', 338 => '4.2', 340 => '4.5' },
	'nominalmaxaperture' => { 401 => 0xa },
	'nominalminaperture' => { 401 => '10.1' },
	'noncpulens10focallength' => { 265 => 0x6c6, 266 => 0x6d6, 269 => 0x620 },
	'noncpulens10maxaperture' => { 265 => 0x6ee, 266 => 0x738, 269 => 0x670 },
	'noncpulens11focallength' => { 265 => 0x6c8, 266 => 0x6d8, 269 => 0x624 },
	'noncpulens11maxaperture' => { 265 => 0x6f0, 266 => 0x73c, 269 => 0x674 },
	'noncpulens12focallength' => { 265 => 0x6ca, 266 => 0x6da, 269 => 0x628 },
	'noncpulens12maxaperture' => { 265 => 0x6f2, 266 => 0x740, 269 => 0x678 },
	'noncpulens13focallength' => { 265 => 0x6cc, 266 => 0x6dc, 269 => 0x62c },
	'noncpulens13maxaperture' => { 265 => 0x6f4, 266 => 0x744, 269 => 0x67c },
	'noncpulens14focallength' => { 265 => 0x6ce, 266 => 0x6de, 269 => 0x630 },
	'noncpulens14maxaperture' => { 265 => 0x6f6, 266 => 0x748, 269 => 0x680 },
	'noncpulens15focallength' => { 265 => 0x6d0, 266 => 0x6e0, 269 => 0x634 },
	'noncpulens15maxaperture' => { 265 => 0x6f8, 266 => 0x74c, 269 => 0x684 },
	'noncpulens16focallength' => { 265 => 0x6d2, 266 => 0x6e2, 269 => 0x638 },
	'noncpulens16maxaperture' => { 265 => 0x6fa, 266 => 0x750, 269 => 0x688 },
	'noncpulens17focallength' => { 265 => 0x6d4, 266 => 0x6e4, 269 => 0x63c },
	'noncpulens17maxaperture' => { 265 => 0x6fc, 266 => 0x754, 269 => 0x68c },
	'noncpulens18focallength' => { 265 => 0x6d6, 266 => 0x6e6, 269 => 0x640 },
	'noncpulens18maxaperture' => { 265 => 0x6fe, 266 => 0x758, 269 => 0x690 },
	'noncpulens19focallength' => { 265 => 0x6d8, 266 => 0x6e8, 269 => 0x644 },
	'noncpulens19maxaperture' => { 265 => 0x700, 266 => 0x75c, 269 => 0x694 },
	'noncpulens1focallength' => { 265 => 0x6b4, 266 => 0x6c4, 269 => 0x5fc },
	'noncpulens1maxaperture' => { 265 => 0x6dc, 266 => 0x714, 269 => 0x64c },
	'noncpulens20focallength' => { 265 => 0x6da, 266 => 0x6ea, 269 => 0x648 },
	'noncpulens20maxaperture' => { 265 => 0x702, 266 => 0x760, 269 => 0x698 },
	'noncpulens2focallength' => { 265 => 0x6b6, 266 => 0x6c6, 269 => 0x600 },
	'noncpulens2maxaperture' => { 265 => 0x6de, 266 => 0x718, 269 => 0x650 },
	'noncpulens3focallength' => { 265 => 0x6b8, 266 => 0x6c8, 269 => 0x604 },
	'noncpulens3maxaperture' => { 265 => 0x6e0, 266 => 0x71c, 269 => 0x654 },
	'noncpulens4focallength' => { 265 => 0x6ba, 266 => 0x6ca, 269 => 0x608 },
	'noncpulens4maxaperture' => { 265 => 0x6e2, 266 => 0x720, 269 => 0x658 },
	'noncpulens5focallength' => { 265 => 0x6bc, 266 => 0x6cc, 269 => 0x60c },
	'noncpulens5maxaperture' => { 265 => 0x6e4, 266 => 0x724, 269 => 0x65c },
	'noncpulens6focallength' => { 265 => 0x6be, 266 => 0x6ce, 269 => 0x610 },
	'noncpulens6maxaperture' => { 265 => 0x6e6, 266 => 0x728, 269 => 0x660 },
	'noncpulens7focallength' => { 265 => 0x6c0, 266 => 0x6d0, 269 => 0x614 },
	'noncpulens7maxaperture' => { 265 => 0x6e8, 266 => 0x72c, 269 => 0x664 },
	'noncpulens8focallength' => { 265 => 0x6c2, 266 => 0x6d2, 269 => 0x618 },
	'noncpulens8maxaperture' => { 265 => 0x6ea, 266 => 0x730, 269 => 0x668 },
	'noncpulens9focallength' => { 265 => 0x6c4, 266 => 0x6d4, 269 => 0x61c },
	'noncpulens9maxaperture' => { 265 => 0x6ec, 266 => 0x734, 269 => 0x66c },
	'normalizedcropcorners' => { 362 => 'NormalizedCropCorners' },
	'normallinetime' => { 157 => 0x186a },
	'normalwhitelevel' => { 45 => 0x32a, 46 => 0x280, 47 => 0x294, 50 => [0x2b8,0x2cf,0x2d3], 51 => 0x569, 52 => 0x1e3, 53 => [0x1fc,0x2dc], 54 => [0x230,0x30e], 55 => 0x31c },
	'notes' => { 520 => 'Notes', 530 => 'notes' },
	'npages' => { 571 => 'NPages' },
	'nullrecord' => { 105 => 0x0 },
	'numafpoints' => { 384 => 0x3, 385 => 0x2 },
	'number' => { 556 => 'number' },
	'numberofbeats' => { 566 => 'numberOfBeats' },
	'numberoffocuspoints' => { 328 => '1.3', 329 => '1.3', 332 => '0.2', 333 => '0.3', 335 => '0.3' },
	'numcafpoints' => { 388 => 0x1 },
	'numfaceelements' => { 135 => 0x4200 },
	'numfacepositions' => { 364 => 0x0 },
	'numindexentries' => { 152 => 0x54 },
	'numwbentries' => { 378 => 0x0, 379 => 0x0 },
	'object' => { 556 => 'object' },
	'objectattributereference' => { 150 => 0x4 },
	'objectcycle' => { 150 => 0x4b, 530 => 'ObjectCycle' },
	'objectdescription' => { 555 => 'objectDescription' },
	'objectdistance' => { 120 => 0x6, 121 => 0x2022 },
	'objectname' => { 150 => 0x5 },
	'objectpreviewdata' => { 150 => 0xca },
	'objectpreviewfileformat' => { 150 => 0xc8 },
	'objectpreviewfileversion' => { 150 => 0xc9 },
	'objectsubtype' => { 555 => 'objectSubtype' },
	'objecttype' => { 555 => 'objectType' },
	'objecttypereference' => { 150 => 0x3 },
	'occurrence' => { 126 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 126 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 126 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 126 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 126 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 126 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 126 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecaste' => { 126 => [\'Occurrence','OccurrenceCaste'] },
	'occurrencecatalognumber' => { 126 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedegreeofestablishment' => { 126 => [\'Occurrence','OccurrenceDegreeOfEstablishment'] },
	'occurrencedetails' => { 126 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 126 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 126 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrencegeoreferenceverificationstatus' => { 126 => [\'Occurrence','OccurrenceGeoreferenceVerificationStatus'] },
	'occurrenceid' => { 126 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 126 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 126 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 126 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceorganismquantity' => { 126 => [\'Occurrence','OccurrenceOrganismQuantity'] },
	'occurrenceorganismquantitytype' => { 126 => [\'Occurrence','OccurrenceOrganismQuantityType'] },
	'occurrenceothercatalognumbers' => { 126 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepathway' => { 126 => [\'Occurrence','OccurrencePathway'] },
	'occurrencepreparations' => { 126 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 126 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 126 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordedbyid' => { 126 => [\'Occurrence','OccurrenceRecordedByID'] },
	'occurrencerecordnumber' => { 126 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 126 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 126 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 126 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 126 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'occurrencevitality' => { 126 => [\'Occurrence','OccurrenceVitality'] },
	'oecfcolumns' => { 542 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 542 => [\'OECF','OECFNames'] },
	'oecfrows' => { 542 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 542 => [\'OECF','OECFValues'] },
	'offsaledate' => { 556 => 'offSaleDate' },
	'offsaledatea-platform' => { 556 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 556 => [\'offSaleDate','offSaleDateDate'] },
	'offsetdacvalue' => { 157 => 0x190a },
	'offsethdr' => { 547 => 'OffsetHDR' },
	'offsetschema' => { 127 => 0xea1d },
	'offsetsdr' => { 547 => 'OffsetSDR' },
	'offsettime' => { 127 => 0x9010 },
	'offsettimedigitized' => { 127 => 0x9012 },
	'offsettimeoriginal' => { 127 => 0x9011 },
	'oismode' => { 1 => 0xf },
	'okbutton' => { 335 => '15.1', 340 => '16.1' },
	'oldsubfiletype' => { 127 => 0xff },
	'olympusimageheight' => { 352 => 0x102f },
	'olympusimagewidth' => { 352 => 0x102e },
	'omenatcapturestrength' => { 157 => 0xa60 },
	'omenautostrength' => { 157 => 0xa5f },
	'omenearlystrength' => { 157 => 0xa5e },
	'omenfocallengthlimit' => { 157 => 0xa62 },
	'omeninitialipfstrength' => { 157 => 0xa5d },
	'omensurfaceindex' => { 157 => 0xa64 },
	'oneshotafrelease' => { 2 => 0x9 },
	'onetouchwb' => { 352 => 0x302 },
	'onsaledate' => { 556 => 'onSaleDate' },
	'onsaledatea-platform' => { 556 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 556 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 556 => 'onSaleDay' },
	'onsaledaya-platform' => { 556 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 556 => [\'onSaleDay','onSaleDayDay'] },
	'opcodelist1' => { 127 => 0xc740 },
	'opcodelist2' => { 127 => 0xc741 },
	'opcodelist3' => { 127 => 0xc74e },
	'opticalzoom' => { 161 => 0xfa3d, 163 => [0x6006,0xf006], 164 => 0x1000, 165 => 0xf, 168 => 0x1e, 170 => 0x20, 171 => 0x1c, 182 => 'OpticalZoom' },
	'opticalzoomcode' => { 84 => 0xa },
	'opticalzoommode' => { 372 => 0x34 },
	'opticalzoomon' => { 456 => 0x219 },
	'optionenddate' => { 559 => 'optionEndDate' },
	'opto-electricconvfactor' => { 542 => 'OECF' },
	'orangehsl' => { 111 => 0x20911 },
	'ordernumber' => { 135 => 0x8002 },
	'organisationinimagecode' => { 550 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 550 => 'OrganisationInImageName' },
	'organism' => { 126 => 'Organism' },
	'organismassociatedoccurrences' => { 126 => [\'Organism','OrganismAssociatedOccurrences'] },
	'organismassociatedorganisms' => { 126 => [\'Organism','OrganismAssociatedOrganisms'] },
	'organismid' => { 126 => [\'Organism','OrganismOrganismID'] },
	'organismname' => { 126 => [\'Organism','OrganismOrganismName'] },
	'organismpreviousidentifications' => { 126 => [\'Organism','OrganismPreviousIdentifications'] },
	'organismremarks' => { 126 => [\'Organism','OrganismOrganismRemarks'] },
	'organismscope' => { 126 => [\'Organism','OrganismOrganismScope'] },
	'organization' => { 556 => 'organization' },
	'orientation' => { 127 => 0x112, 377 => 0x112, 555 => 'orientation', 562 => 'Orientation' },
	'orientation2' => { 486 => [0x28,0x2e] },
	'orientationlinkedaf' => { 2 => 0xe },
	'orientationlinkedafpoint' => { 92 => 0x516 },
	'originalalbumtitle' => { 198 => 'WM/OriginalAlbumTitle' },
	'originalartist' => { 198 => 'WM/OriginalArtist', 429 => "\xa9ope" },
	'originalbestqualitysize' => { 127 => 0xc792 },
	'originalcreatedatetime' => { 524 => 'OriginalCreateDateTime' },
	'originaldecisiondata' => { 122 => 'Canon-OriginalDecisionData' },
	'originaldecisiondataoffset' => { 71 => 0x83 },
	'originaldefaultcropsize' => { 127 => 0xc793 },
	'originaldefaultfinalsize' => { 127 => 0xc791 },
	'originaldirectory' => { 369 => 0x408 },
	'originaldocumentid' => { 567 => 'OriginalDocumentID' },
	'originalfilename' => { 105 => 0x816, 157 => 0x3e9, 169 => 0x20, 369 => 0x407, 524 => 'OriginalFilename' },
	'originalfilepath' => { 437 => 'fsid' },
	'originalimagehash' => { 522 => 'OriginalImageHash' },
	'originalimagehashtype' => { 522 => 'OriginalImageHashType' },
	'originalimageheight' => { 86 => 0xc, 131 => 0x1 },
	'originalimagemd5' => { 522 => 'OriginalImageMD5' },
	'originalimagesize' => { 181 => 'OriginalImageSize' },
	'originalimagewidth' => { 86 => 0xb, 131 => 0x0 },
	'originallyricist' => { 198 => 'WM/OriginalLyricist' },
	'originalrawfiledata' => { 127 => 0xc68c },
	'originalrawfiledigest' => { 127 => 0xc71d },
	'originalrawfilename' => { 127 => 0xc68b },
	'originaltransmissionreference' => { 150 => 0x67 },
	'originatingprogram' => { 150 => 0x41, 530 => 'OriginatingProgram' },
	'originplatform' => { 556 => 'originPlatform' },
	'os' => { 540 => 'os' },
	'otherconditions' => { 358 => 'OtherConditions' },
	'otherconstraints' => { 358 => 'OtherConstraints' },
	'otherimage' => { 122 => 'Exif-OtherImage' },
	'otherimageinfo' => { 358 => 'OtherImageInfo' },
	'otherimagelength' => { 127 => 0x202 },
	'otherimagestart' => { 127 => 0x201 },
	'otherlicensedocuments' => { 358 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 358 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 358 => 'OtherLicenseRequirements' },
	'outcue' => { 566 => 'outCue' },
	'outcuescale' => { 566 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 566 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 222 => 0x3 },
	'outputimagewidth' => { 222 => 0x2 },
	'outputlut' => { 372 => 0xa7 },
	'outputprofile' => { 157 => 0x138b },
	'outputresolution' => { 222 => 0x4 },
	'overclockcols' => { 157 => 0x189c },
	'overclockrows' => { 157 => 0x18c4 },
	'overridelookvignette' => { 536 => 'OverrideLookVignette', 538 => 'OverrideLookVignette' },
	'owner' => { 429 => 'ownr', 570 => 'Owner' },
	'ownerid' => { 150 => 0xbc },
	'ownername' => { 15 => 0x10f, 71 => 0x9, 105 => 0x810, 127 => [0xa430,0xfde8], 175 => 'OwnerName', 533 => 'OwnerName', 543 => 'CameraOwnerName' },
	'padding' => { 127 => 0xea1c },
	'pagecount' => { 556 => 'pageCount' },
	'pageimage' => { 564 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 564 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 564 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 564 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 564 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 564 => 'PageInfo' },
	'pagename' => { 127 => 0x11d },
	'pagenumber' => { 127 => 0x129 },
	'pageprogressiondirection' => { 556 => 'pageProgressionDirection' },
	'pagerange' => { 556 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 536 => 'PaintBasedCorrections', 538 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionblacks2012' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBlacks2012'] },
	'paintcorrectionbrightness' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectioncorrectionname' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionName'] },
	'paintcorrectioncorrectionsyncid' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionSyncID'] },
	'paintcorrectiondefringe' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectiondehaze' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDehaze'] },
	'paintcorrectionexposure' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHue'] },
	'paintcorrectionluminancenoise' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskinputdigest' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksInputDigest'] },
	'paintcorrectionmaskleft' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmaskactive' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskActive'] },
	'paintcorrectionmaskmaskblendmode' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskBlendMode'] },
	'paintcorrectionmaskmaskdigest' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskDigest'] },
	'paintcorrectionmaskmaskinverted' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskInverted'] },
	'paintcorrectionmaskmaskname' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskName'] },
	'paintcorrectionmaskmasks' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasks'] },
	'paintcorrectionmaskmasksalpha' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAlpha'] },
	'paintcorrectionmaskmasksangle' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksAngle'] },
	'paintcorrectionmaskmasksbottom' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksBottom'] },
	'paintcorrectionmaskmaskscentervalue' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterValue'] },
	'paintcorrectionmaskmaskscenterweight' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksCenterWeight'] },
	'paintcorrectionmaskmasksdabs' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksDabs'] },
	'paintcorrectionmaskmasksfeather' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFeather'] },
	'paintcorrectionmaskmasksflipped' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlipped'] },
	'paintcorrectionmaskmasksflow' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFlow'] },
	'paintcorrectionmaskmasksfullx' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullX'] },
	'paintcorrectionmaskmasksfully' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksFullY'] },
	'paintcorrectionmaskmasksinputdigest' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksInputDigest'] },
	'paintcorrectionmaskmasksleft' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksLeft'] },
	'paintcorrectionmaskmasksmaskactive' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskActive'] },
	'paintcorrectionmaskmasksmaskblendmode' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskBlendMode'] },
	'paintcorrectionmaskmasksmaskdigest' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskDigest'] },
	'paintcorrectionmaskmasksmaskinverted' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskInverted'] },
	'paintcorrectionmaskmasksmaskname' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskName'] },
	'paintcorrectionmaskmasksmasksubtype' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSubType'] },
	'paintcorrectionmaskmasksmasksyncid' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskSyncID'] },
	'paintcorrectionmaskmasksmaskversion' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskVersion'] },
	'paintcorrectionmaskmasksmidpoint' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMidpoint'] },
	'paintcorrectionmaskmasksorigin' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksOrigin'] },
	'paintcorrectionmaskmasksperimetervalue' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksPerimeterValue'] },
	'paintcorrectionmaskmasksradius' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRadius'] },
	'paintcorrectionmaskmasksreferencepoint' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksReferencePoint'] },
	'paintcorrectionmaskmasksright' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRight'] },
	'paintcorrectionmaskmasksroundness' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksRoundness'] },
	'paintcorrectionmaskmaskssizex' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeX'] },
	'paintcorrectionmaskmaskssizey' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksSizeY'] },
	'paintcorrectionmaskmaskstop' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksTop'] },
	'paintcorrectionmaskmasksubtype' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSubType'] },
	'paintcorrectionmaskmasksvalue' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksMaskValue'] },
	'paintcorrectionmaskmasksversion' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksVersion'] },
	'paintcorrectionmaskmaskswhat' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWhat'] },
	'paintcorrectionmaskmaskswholeimagearea' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksWholeImageArea'] },
	'paintcorrectionmaskmasksx' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksX'] },
	'paintcorrectionmaskmasksy' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksY'] },
	'paintcorrectionmaskmasksyncid' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskSyncID'] },
	'paintcorrectionmaskmaskszerox' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroX'] },
	'paintcorrectionmaskmaskszeroy' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMasksZeroY'] },
	'paintcorrectionmaskmaskversion' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskVersion'] },
	'paintcorrectionmaskmidpoint' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskorigin' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksOrigin'] },
	'paintcorrectionmaskperimetervalue' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskrange' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMask'] },
	'paintcorrectionmaskrangeareamodels' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModels'] },
	'paintcorrectionmaskrangeareamodelscolorsampleinfo' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionmaskrangeareamodelscomponents' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionmaskrangecoloramount' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskColorAmount'] },
	'paintcorrectionmaskrangedepthfeather' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionmaskrangedepthmax' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMax'] },
	'paintcorrectionmaskrangedepthmin' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskDepthMin'] },
	'paintcorrectionmaskrangeinvert' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskInvert'] },
	'paintcorrectionmaskrangelumfeather' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumFeather'] },
	'paintcorrectionmaskrangeluminancedepthsampleinfo' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionmaskrangelummax' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMax'] },
	'paintcorrectionmaskrangelummin' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumMin'] },
	'paintcorrectionmaskrangelumrange' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskLumRange'] },
	'paintcorrectionmaskrangesampletype' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskSampleType'] },
	'paintcorrectionmaskrangetype' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskType'] },
	'paintcorrectionmaskrangeversion' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCorrectionRangeMaskVersion'] },
	'paintcorrectionmaskreferencepoint' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksReferencePoint'] },
	'paintcorrectionmaskright' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskwholeimagearea' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWholeImageArea'] },
	'paintcorrectionmaskx' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionrangemask' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMask'] },
	'paintcorrectionrangemaskareamodels' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModels'] },
	'paintcorrectionrangemaskareamodelscolorsampleinfo' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'paintcorrectionrangemaskareamodelscomponents' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskAreaModelsAreaComponents'] },
	'paintcorrectionrangemaskcoloramount' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskColorAmount'] },
	'paintcorrectionrangemaskdepthfeather' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthFeather'] },
	'paintcorrectionrangemaskdepthmax' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMax'] },
	'paintcorrectionrangemaskdepthmin' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskDepthMin'] },
	'paintcorrectionrangemaskinvert' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskInvert'] },
	'paintcorrectionrangemasklumfeather' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumFeather'] },
	'paintcorrectionrangemaskluminancedepthsampleinfo' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'paintcorrectionrangemasklummax' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMax'] },
	'paintcorrectionrangemasklummin' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumMin'] },
	'paintcorrectionrangemasklumrange' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskLumRange'] },
	'paintcorrectionrangemasksampletype' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskSampleType'] },
	'paintcorrectionrangemasktype' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskType'] },
	'paintcorrectionrangemaskversion' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionRangeMaskVersion'] },
	'paintcorrectionsaturation' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation'] },
	'paintcorrectionshadows2012' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontexture' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTexture'] },
	'paintcorrectiontint' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectiontoninghue' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectiontoningsaturation' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionwhat' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'paintcorrectionwhites2012' => { 536 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'], 538 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalWhites2012'] },
	'panasonicdatetime' => { 375 => 0x0 },
	'panasonicexifversion' => { 372 => 0x26 },
	'panasonicimageheight' => { 372 => 0x4c },
	'panasonicimagewidth' => { 372 => 0x4b },
	'panasonicrawversion' => { 377 => 0x1 },
	'panasonictitle' => { 127 => 0xc6d2 },
	'panasonictitle2' => { 127 => 0xc6d3 },
	'panoramaangle' => { 135 => 0x1153 },
	'panoramacropbottom' => { 487 => 0x7 },
	'panoramacropleft' => { 487 => 0x4 },
	'panoramacropright' => { 487 => 0x6 },
	'panoramacroptop' => { 487 => 0x5 },
	'panoramadirection' => { 79 => 0x5, 135 => 0x1154, 487 => 0x3 },
	'panoramaframeheight' => { 487 => 0x9 },
	'panoramaframenumber' => { 79 => 0x2 },
	'panoramaframewidth' => { 487 => 0x8 },
	'panoramafullheight' => { 487 => 0x2 },
	'panoramafullwidth' => { 487 => 0x1 },
	'panoramamode' => { 159 => 0x3c, 347 => 0x601 },
	'panoramasize3d' => { 469 => 0x38 },
	'panoramasourceheight' => { 487 => 0xb },
	'panoramasourcewidth' => { 487 => 0xa },
	'panoramicstitchcameramotion' => { 195 => 'PanoramicStitchCameraMotion', 196 => 0x1 },
	'panoramicstitchmaptype' => { 195 => 'PanoramicStitchMapType', 196 => 0x2 },
	'panoramicstitchphi0' => { 195 => 'PanoramicStitchPhi0', 196 => 0x5 },
	'panoramicstitchphi1' => { 195 => 'PanoramicStitchPhi1', 196 => 0x6 },
	'panoramicstitchtheta0' => { 195 => 'PanoramicStitchTheta0', 196 => 0x3 },
	'panoramicstitchtheta1' => { 195 => 'PanoramicStitchTheta1', 196 => 0x4 },
	'panoramicstitchversion' => { 196 => 0x0 },
	'pantry' => { 567 => 'Pantry' },
	'pantryinstanceid' => { 567 => [\'Pantry','PantryInstanceID'] },
	'parallax' => { 135 => 0xb211, 345 => 0x28 },
	'parameters' => { 361 => 'parameters' },
	'parametricdarks' => { 536 => 'ParametricDarks', 538 => 'ParametricDarks' },
	'parametrichighlights' => { 536 => 'ParametricHighlights', 538 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 536 => 'ParametricHighlightSplit', 538 => 'ParametricHighlightSplit' },
	'parametriclights' => { 536 => 'ParametricLights', 538 => 'ParametricLights' },
	'parametricmidtonesplit' => { 536 => 'ParametricMidtoneSplit', 538 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 536 => 'ParametricShadows', 538 => 'ParametricShadows' },
	'parametricshadowsplit' => { 536 => 'ParametricShadowSplit', 538 => 'ParametricShadowSplit' },
	'parentalrating' => { 198 => 'WM/ParentalRating' },
	'parentid' => { 550 => 'parentId' },
	'parentmeasurementid' => { 126 => [\'MeasurementOrFact','MeasurementOrFactParentMeasurementID'] },
	'parentmediaeventid' => { 524 => 'ParentMediaEventID' },
	'parentmeid' => { 524 => 'ParentMEID' },
	'parentproductid' => { 429 => '@ppi' },
	'parentreference1' => { 548 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 548 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentshorttitle' => { 429 => '@PST' },
	'parenttitle' => { 429 => '@pti' },
	'partialactivecols1' => { 157 => 0x17e8 },
	'partialactivecols2' => { 157 => 0x17f2 },
	'partialactiverows1' => { 157 => 0x17fc },
	'partialactiverows2' => { 157 => 0x1806 },
	'partofcompilation' => { 566 => 'partOfCompilation' },
	'patientbirthdate' => { 521 => 'PatientDOB' },
	'patientid' => { 521 => 'PatientID' },
	'patientname' => { 521 => 'PatientName' },
	'patientsex' => { 521 => 'PatientSex' },
	'patternareaheight' => { 157 => 0x963 },
	'patternareawidth' => { 157 => 0x962 },
	'patterncorrectionfactorscale' => { 157 => 0x969 },
	'patterncropcols1' => { 157 => 0x96c },
	'patterncropcols2' => { 157 => 0x96d },
	'patterncroprows1' => { 157 => 0x96a },
	'patterncroprows2' => { 157 => 0x96b },
	'patternimagerheight' => { 157 => 0x961 },
	'patternimagerwidth' => { 157 => 0x960 },
	'patternx' => { 157 => 0x966 },
	'patterny' => { 157 => 0x967 },
	'pdfversion' => { 552 => 'PDFVersion' },
	'pentaximagesize' => { 411 => 0x9 },
	'pentaxmodelid' => { 389 => 0x0, 411 => 0x5 },
	'pentaxmodeltype' => { 411 => 0x1 },
	'pentaxversion' => { 411 => 0x0 },
	'people' => { 523 => 'People', 528 => 'People' },
	'perchannelblacklevel' => { 45 => 0x157, 46 => 0x16b, 47 => 0x17f, 49 => 0xc4, 50 => [0x2b4,0x2cb,0x2cf], 51 => [0x108,0x14d], 52 => 0x1df, 53 => [0x1f8,0x2d8], 54 => [0x22c,0x30a], 55 => 0x149 },
	'performer' => { 429 => 'perf', 437 => 'perf' },
	'performerkeywords' => { 437 => "\xa9prk" },
	'performers' => { 437 => "\xa9prf" },
	'performerurl' => { 437 => "\xa9prl" },
	'period' => { 198 => 'WM/Period' },
	'peripheralillumcentralradius' => { 518 => 0x8030 },
	'peripheralillumcentralvalue' => { 518 => 0x8031 },
	'peripheralillumination' => { 111 => 0x20702, 117 => 0x68 },
	'peripheralilluminationcorr' => { 69 => 0x1, 400 => 0x2 },
	'peripheralilluminationon' => { 111 => '0x20702.0', 117 => 0x64 },
	'peripheralillumperiphvalue' => { 518 => 0x8032 },
	'peripherallighting' => { 86 => 0x2, 135 => 0x3804 },
	'peripherallightingsetting' => { 87 => 0x5 },
	'peripherallightingvalue' => { 86 => 0x6 },
	'permissions' => { 559 => 'permissions' },
	'permits' => { 534 => 'permits' },
	'person' => { 556 => 'person' },
	'personality' => { 524 => 'Personality' },
	'personheard' => { 550 => 'PersonHeard' },
	'personheardidentifier' => { 550 => [\'PersonHeard','PersonHeardIdentifier'] },
	'personheardname' => { 550 => [\'PersonHeard','PersonHeardName'] },
	'personinimage' => { 550 => 'PersonInImage' },
	'personinimagecharacteristic' => { 550 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 550 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 550 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 550 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 550 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 550 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 550 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 550 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 550 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 536 => 'PerspectiveAspect', 538 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 536 => 'PerspectiveHorizontal', 538 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 536 => 'PerspectiveRotate', 538 => 'PerspectiveRotate' },
	'perspectivescale' => { 536 => 'PerspectiveScale', 538 => 'PerspectiveScale' },
	'perspectiveupright' => { 536 => 'PerspectiveUpright', 538 => 'PerspectiveUpright' },
	'perspectivevertical' => { 536 => 'PerspectiveVertical', 538 => 'PerspectiveVertical' },
	'perspectivex' => { 536 => 'PerspectiveX', 538 => 'PerspectiveX' },
	'perspectivey' => { 536 => 'PerspectiveY', 538 => 'PerspectiveY' },
	'pf0customfuncregistration' => { 100 => 0x1 },
	'pf10retainprogramshift' => { 100 => 0xb },
	'pf13drivepriority' => { 100 => 0xe },
	'pf14disablefocussearch' => { 100 => 0xf },
	'pf15disableafassistbeam' => { 100 => 0x10 },
	'pf16autofocuspointshoot' => { 100 => 0x11 },
	'pf17disableafpointsel' => { 100 => 0x12 },
	'pf18enableautoafpointsel' => { 100 => 0x13 },
	'pf19continuousshootspeed' => { 100 => 0x14 },
	'pf19shootingspeedhigh' => { 99 => 0xa },
	'pf19shootingspeedlow' => { 99 => 0x9 },
	'pf1disableshootingmodes' => { 100 => 0x2 },
	'pf1value' => { 99 => 0x1 },
	'pf20limitcontinousshots' => { 100 => 0x15 },
	'pf20maxcontinousshots' => { 99 => 0xb },
	'pf21enablequietoperation' => { 100 => 0x16 },
	'pf23felocktime' => { 99 => 0xd },
	'pf23postreleasetime' => { 99 => 0xe },
	'pf23settimerlengths' => { 100 => 0x18 },
	'pf23shutterbuttontime' => { 99 => 0xc },
	'pf24lightlcdduringbulb' => { 100 => 0x19 },
	'pf25aemode' => { 99 => 0xf },
	'pf25afmode' => { 99 => 0x12 },
	'pf25afpointsel' => { 99 => 0x13 },
	'pf25colormatrix' => { 99 => 0x17 },
	'pf25defaultclearsettings' => { 100 => 0x1a },
	'pf25drivemode' => { 99 => 0x11 },
	'pf25imagesize' => { 99 => 0x14 },
	'pf25meteringmode' => { 99 => 0x10 },
	'pf25parameters' => { 99 => 0x16 },
	'pf25wbmode' => { 99 => 0x15 },
	'pf26shortenreleaselag' => { 100 => 0x1b },
	'pf27reversedialrotation' => { 100 => 0x1c },
	'pf27value' => { 99 => 0x18 },
	'pf28noquickdialexpcomp' => { 100 => 0x1d },
	'pf29quickdialswitchoff' => { 100 => 0x1e },
	'pf2disablemeteringmodes' => { 100 => 0x3 },
	'pf2value' => { 99 => 0x2 },
	'pf30enlargementmode' => { 100 => 0x1f },
	'pf31originaldecisiondata' => { 100 => 0x20 },
	'pf3manualexposuremetering' => { 100 => 0x4 },
	'pf3value' => { 99 => 0x3 },
	'pf4exposuretimelimits' => { 100 => 0x5 },
	'pf4exposuretimemax' => { 99 => 0x5 },
	'pf4exposuretimemin' => { 99 => 0x4 },
	'pf5aperturelimits' => { 100 => 0x6 },
	'pf5aperturemax' => { 99 => 0x7 },
	'pf5aperturemin' => { 99 => 0x6 },
	'pf6presetshootingmodes' => { 100 => 0x7 },
	'pf7bracketcontinuousshoot' => { 100 => 0x8 },
	'pf8bracketshots' => { 99 => 0x8 },
	'pf8setbracketshots' => { 100 => 0x9 },
	'pf9changebracketsequence' => { 100 => 0xa },
	'phasedetectaf' => { 214 => 0x6 },
	'phonenumber' => { 176 => 'Phone' },
	'photoeffect' => { 38 => 0x28 },
	'photoeffecthistoryxml' => { 318 => 0xe9651831 },
	'photoeffects' => { 318 => 0xab5eca5e },
	'photoeffectsblue' => { 320 => 0x8 },
	'photoeffectsgreen' => { 320 => 0x6 },
	'photoeffectsred' => { 320 => 0x4 },
	'photoeffectstype' => { 320 => 0x0 },
	'photographer' => { 127 => 0xa437, 543 => 'Photographer' },
	'photographicsensitivity' => { 543 => 'PhotographicSensitivity' },
	'photoidentifier' => { 1 => 0x2b },
	'photoinfoplayback' => { 325 => '17.6', 334 => '33.6' },
	'photometricinterpretation' => { 127 => 0x106, 562 => 'PhotometricInterpretation' },
	'photosappfeatureflags' => { 1 => 0x1f },
	'photoshootingmenubank' => { 264 => 0x11e, 267 => 0x112, 268 => 0x122, 269 => 0x122, 270 => 0x24, 288 => 0x0 },
	'photoshootingmenubankimagearea' => { 261 => 0x6dd, 264 => 0x144, 267 => 0x134, 268 => 0x148, 269 => 0x148, 288 => '7.1' },
	'photoshopbgrthumbnail' => { 425 => 0x409 },
	'photoshopquality' => { 424 => 0x0 },
	'photoshopthumbnail' => { 425 => 0x40c },
	'photostyle' => { 372 => 0x89 },
	'picasawebgphotoid' => { 541 => 'picasawebGPhotoId' },
	'pick' => { 566 => 'pick' },
	'picklabel' => { 541 => 'PickLabel' },
	'pictinfo' => { 456 => 0x208 },
	'picturecontrol' => { 318 => 0xe2173c47 },
	'picturecontrolactive' => { 321 => 0x0 },
	'picturecontroladjust' => { 276 => 0x30, 277 => 0x30, 278 => 0x36 },
	'picturecontrolbase' => { 276 => 0x18, 277 => 0x18, 278 => 0x1c },
	'picturecontroldata' => { 258 => [0xbd,0x23] },
	'picturecontrolmode' => { 321 => 0x13 },
	'picturecontrolname' => { 276 => 0x4, 277 => 0x4, 278 => 0x8 },
	'picturecontrolquickadjust' => { 276 => 0x31, 277 => 0x31, 278 => 0x37 },
	'pictureeffect' => { 481 => 0x200e },
	'pictureeffect2' => { 490 => 0x1163, 491 => 0x1167, 492 => 0x1143, 493 => 0x11bf, 494 => 0x119b, 495 => 0x1053, 496 => 0x24b, 497 => 0x24b, 498 => 0x23c, 513 => 0x46 },
	'picturefinish' => { 201 => 0x71 },
	'picturemode' => { 135 => 0x1031, 347 => 0x520, 411 => [0xb,0x33], 457 => 0x3d },
	'picturemode2' => { 390 => 0x0 },
	'picturemodebwfilter' => { 347 => 0x525 },
	'picturemodecontrast' => { 347 => 0x523 },
	'picturemodeeffect' => { 347 => 0x52d },
	'picturemodehue' => { 347 => 0x522 },
	'picturemodesaturation' => { 347 => 0x521 },
	'picturemodesharpness' => { 347 => 0x524 },
	'picturemodestrength' => { 457 => 0x113 },
	'picturemodetone' => { 347 => 0x526 },
	'pictureprofile' => { 490 => [0x115e,0x115f], 491 => [0x1162,0x1163], 492 => [0x113e,0x113f], 493 => [0x11ba,0x11bb], 494 => [0x1196,0x1197], 495 => [0x104e,0x104f], 496 => [0x246,0x247], 497 => [0x246,0x247], 498 => [0x237,0x238] },
	'picturestyle' => { 8 => [0x4b,0x51], 9 => 0xf4, 10 => 0x6c, 11 => 0x86, 12 => 0x73, 16 => 0xab, 17 => 0xa7, 18 => 0xb0, 19 => 0x6c, 20 => 0xa7, 21 => 0xf4, 22 => 0xb3, 24 => 0xf4, 25 => 0xfa, 27 => 0x169, 81 => 0xa, 111 => 0x20301, 117 => 0x2 },
	'picturestylepc' => { 71 => 0x4009 },
	'picturestyleuserdef' => { 71 => 0x4008 },
	'picturewizard' => { 454 => 0x21 },
	'picturewizardcolor' => { 453 => 0x1 },
	'picturewizardcontrast' => { 453 => 0x4 },
	'picturewizardmode' => { 453 => 0x0 },
	'picturewizardsaturation' => { 453 => 0x2 },
	'picturewizardsharpness' => { 453 => 0x3 },
	'pipelineversion' => { 195 => 'PipelineVersion' },
	'pitch' => { 123 => 0x6, 326 => '4.1', 338 => '4.1', 437 => ['ptch',"\xa9fpt"] },
	'pitchangle' => { 68 => 0x5, 274 => 0x4, 347 => 0x904, 362 => 'PitchAngle', 372 => 0x91, 409 => 0x2, 410 => 0x5, 452 => 0x1 },
	'pitchshift' => { 428 => 'player.movie.audio.pitchshift', 431 => 'player.movie.audio.pitchshift' },
	'pixelaspectratio' => { 430 => 'pasp' },
	'pixelclockfrequency' => { 157 => 0x40b },
	'pixelcorrectionoffset' => { 157 => 0x972 },
	'pixelcorrectionscale' => { 157 => 0x971 },
	'pixelscale' => { 127 => 0x830e },
	'pixelshiftdelay' => { 262 => 0x38c, 266 => 0x802 },
	'pixelshiftinfo' => { 481 => 0x202f },
	'pixelshiftinterval' => { 262 => 0x38e },
	'pixelshiftnumbershots' => { 262 => 0x38a, 266 => 0x800 },
	'pixelshiftoffset' => { 135 => 0x1106 },
	'pixelshiftresolution' => { 412 => 0x0 },
	'pixelshiftshooting' => { 262 => 0x388, 266 => 0x7fe },
	'pixelshiftshots' => { 135 => 0x1105 },
	'pixelsperunitx' => { 360 => 0x0 },
	'pixelsperunity' => { 360 => 0x4 },
	'pixelunits' => { 360 => 0x8 },
	'planarconfiguration' => { 127 => 0x11c, 562 => 'PlanarConfiguration' },
	'plane' => { 140 => [\'Planes','PlanesPlane'] },
	'planeboundary' => { 140 => [\'Planes','PlanesPlaneBoundary'] },
	'planeboundaryvertexcount' => { 140 => [\'Planes','PlanesPlaneBoundaryVertexCount'] },
	'planeextentx' => { 140 => [\'Planes','PlanesPlaneExtentX'] },
	'planeextentz' => { 140 => [\'Planes','PlanesPlaneExtentZ'] },
	'planepose' => { 140 => [\'Planes','PlanesPlanePose'] },
	'planeposepositionx' => { 140 => [\'Planes','PlanesPlanePosePositionX'] },
	'planeposepositiony' => { 140 => [\'Planes','PlanesPlanePosePositionY'] },
	'planeposepositionz' => { 140 => [\'Planes','PlanesPlanePosePositionZ'] },
	'planeposerotationw' => { 140 => [\'Planes','PlanesPlanePoseRotationW'] },
	'planeposerotationx' => { 140 => [\'Planes','PlanesPlanePoseRotationX'] },
	'planeposerotationy' => { 140 => [\'Planes','PlanesPlanePoseRotationY'] },
	'planeposerotationz' => { 140 => [\'Planes','PlanesPlanePoseRotationZ'] },
	'planeposetimestamp' => { 140 => [\'Planes','PlanesPlanePoseTimestamp'] },
	'planes' => { 140 => 'Planes' },
	'planningref' => { 550 => 'PlanningRef' },
	'planningrefidentifier' => { 550 => [\'PlanningRef','PlanningRefIdentifier'] },
	'planningrefname' => { 550 => [\'PlanningRef','PlanningRefName'] },
	'planningrefrole' => { 550 => [\'PlanningRef','PlanningRefRole'] },
	'platenames' => { 571 => 'PlateNames' },
	'platform' => { 556 => 'platform' },
	'playallframes' => { 437 => 'AllF' },
	'playbackbutton' => { 266 => 0x804, 269 => 0x808 },
	'playbackbuttonplaybackmode' => { 266 => 0x80e, 269 => 0x814 },
	'playbackflickdown' => { 341 => 0x149, 342 => 0x159, 343 => 0x159, 344 => 0x171 },
	'playbackflickup' => { 341 => 0x145, 342 => 0x155, 343 => 0x155, 344 => 0x16d },
	'playbackmenustime' => { 330 => '20.1', 331 => '21.1', 332 => '21.1' },
	'playbackmonitorofftime' => { 325 => '25.2', 326 => '36.1', 328 => '36.1', 329 => '36.1', 333 => '35.1', 334 => '8.1', 335 => '35.1', 338 => '36.1', 339 => '36.1', 340 => '21.1', 341 => 0x37, 342 => 0x33, 343 => 0x33, 344 => 0x33 },
	'playbackzoom' => { 326 => '37.1' },
	'playdisplay' => { 203 => 0x4e },
	'playerversion' => { 431 => 'player.version' },
	'playgap' => { 429 => 'pgap' },
	'playmode' => { 437 => 'SDLN' },
	'playselection' => { 437 => 'SelO' },
	'plusversion' => { 358 => 'Version' },
	'pmversion' => { 423 => 'PMVersion' },
	'pngwarning' => { 361 => 'Warning' },
	'podcast' => { 429 => 'pcst' },
	'podcasturl' => { 429 => 'purl' },
	'poilevel' => { 257 => 0x8 },
	'pointcolors' => { 536 => 'PointColors', 538 => 'PointColors' },
	'portraitimpressionbalance' => { 262 => 0x378, 264 => 0x26e, 279 => 0xa0 },
	'portraitnote' => { 142 => 'PortraitNote' },
	'portraitoutputhighlightpoint' => { 117 => 0x1d },
	'portraitoutputshadowpoint' => { 117 => 0x1e },
	'portraitrawcolortone' => { 117 => 0x16 },
	'portraitrawcontrast' => { 117 => 0x18 },
	'portraitrawhighlight' => { 117 => 0x76 },
	'portraitrawhighlightpoint' => { 117 => 0x1b },
	'portraitrawlinear' => { 117 => 0x19 },
	'portraitrawsaturation' => { 117 => 0x17 },
	'portraitrawshadow' => { 117 => 0x7f },
	'portraitrawshadowpoint' => { 117 => 0x1c },
	'portraitrawsharpness' => { 117 => 0x1a },
	'portraitrefiner' => { 121 => 0x302b },
	'portraitrequest' => { 142 => 'PortraitRequest' },
	'portraitunsharpmaskfineness' => { 117 => 0x9a },
	'portraitunsharpmaskstrength' => { 117 => 0x98 },
	'portraitunsharpmaskthreshold' => { 117 => 0x9c },
	'portraitversion' => { 142 => 'PortraitVersion' },
	'pose' => { 140 => 'Pose' },
	'poseheadingdegrees' => { 148 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 148 => 'PosePitchDegrees' },
	'posepositionx' => { 140 => [\'Pose','PosePositionX'] },
	'posepositiony' => { 140 => [\'Pose','PosePositionY'] },
	'posepositionz' => { 140 => [\'Pose','PosePositionZ'] },
	'poserolldegrees' => { 148 => 'PoseRollDegrees' },
	'poserotationw' => { 140 => [\'Pose','PoseRotationW'] },
	'poserotationx' => { 140 => [\'Pose','PoseRotationX'] },
	'poserotationy' => { 140 => [\'Pose','PoseRotationY'] },
	'poserotationz' => { 140 => [\'Pose','PoseRotationZ'] },
	'posetimestamp' => { 140 => [\'Pose','PoseTimestamp'] },
	'positiondescriptor' => { 555 => 'positionDescriptor' },
	'postalcode' => { 180 => 'PostalCode' },
	'postcropvignetteamount' => { 536 => 'PostCropVignetteAmount', 538 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 536 => 'PostCropVignetteFeather', 538 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 536 => 'PostCropVignetteHighlightContrast', 538 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 536 => 'PostCropVignetteMidpoint', 538 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 536 => 'PostCropVignetteRoundness', 538 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 536 => 'PostCropVignetteStyle', 538 => 'PostCropVignetteStyle' },
	'postfocusmerging' => { 372 => 0xbf },
	'postreleaseburstlength' => { 268 => 0x714, 269 => 0x784, 342 => 0x289 },
	'potentialface1position' => { 477 => 0xb },
	'potentialface2position' => { 477 => 0x15 },
	'potentialface3position' => { 477 => 0x1f },
	'potentialface4position' => { 477 => 0x29 },
	'potentialface5position' => { 477 => 0x33 },
	'potentialface6position' => { 477 => 0x3d },
	'potentialface7position' => { 477 => 0x47 },
	'potentialface8position' => { 477 => 0x51 },
	'poweravailable' => { 387 => '0.2' },
	'powersource' => { 387 => '0.1' },
	'poweruptime' => { 258 => 0xb6 },
	'preaf' => { 134 => '0.2' },
	'precaptureframes' => { 352 => 0x300 },
	'predictor' => { 127 => 0x13d },
	'preflashreturnstrength' => { 296 => 0x28a },
	'prefs' => { 150 => 0xdd, 423 => 'Prefs' },
	'prereadfastresetcount' => { 157 => 0x187e },
	'prereleaseburstlength' => { 268 => 0x712, 269 => 0x782, 342 => 0x287 },
	'preservedfilename' => { 567 => 'PreservedFileName' },
	'preservedspecimen' => { 126 => 'PreservedSpecimen' },
	'preservedspecimenmaterialsampleid' => { 126 => [\'PreservedSpecimen','PreservedSpecimenMaterialSampleID'] },
	'presettype' => { 536 => 'PresetType', 538 => 'PresetType' },
	'presetwhitebalance' => { 203 => 0x24, 518 => 0x8002 },
	'presetwhitebalanceadj' => { 518 => 0x8014 },
	'pressure' => { 127 => 0x9402, 543 => 'Pressure' },
	'previewapplicationname' => { 127 => 0xc716 },
	'previewapplicationversion' => { 127 => 0xc717 },
	'previewbutton' => { 325 => ['14.1','15.1'], 326 => '15.1', 328 => '15.1', 329 => '15.1', 334 => '29.1', 335 => '14.1', 338 => '15.1', 339 => '15.1' },
	'previewbuttonplusdials' => { 325 => ['14.2','15.2'], 326 => '15.2', 328 => '43.1', 329 => '43.1', 334 => '31.2', 338 => '43.1', 339 => '43.1' },
	'previewcolorspace' => { 127 => 0xc71a },
	'previewcropbottom' => { 422 => 0xef },
	'previewcropleft' => { 422 => 0xec },
	'previewcropright' => { 422 => 0xee },
	'previewcroptop' => { 422 => 0xed },
	'previewdate' => { 435 => 0x0 },
	'previewdatetime' => { 127 => 0xc71b },
	'previewimage' => { 121 => 0x2000, 122 => 'Exif-PreviewImage', 128 => 'PreviewImage', 130 => 0x4, 185 => 'data', 205 => 0x81, 352 => 0x280, 370 => 0x300, 429 => 'snal', 437 => ['SIGM','mcvr'], 481 => 0x2001 },
	'previewimageborders' => { 411 => 0x3e },
	'previewimageheight' => { 80 => 0x4, 161 => 0xfa58 },
	'previewimagelength' => { 80 => 0x2, 121 => 0x3, 127 => [0x117,0x202], 205 => 0x89, 280 => 0x202, 347 => 0x102, 352 => 0x1037, 411 => 0x3, 446 => 0x1e, 451 => 0x3, 457 => [0x1b,0x1d], 470 => 0x202 },
	'previewimagename' => { 185 => '1Name' },
	'previewimagesize' => { 121 => 0x2, 166 => 0x2, 185 => 'ImageSize', 411 => 0x2, 457 => [0x1c,0x1e], 481 => 0xb02c, 518 => 0x9012 },
	'previewimagestart' => { 80 => 0x5, 121 => 0x4, 127 => [0x111,0x201], 205 => 0x88, 280 => 0x201, 347 => 0x101, 352 => 0x1036, 411 => 0x4, 446 => 0x1c, 451 => 0x2, 457 => [0x1a,0x1c], 470 => 0x201 },
	'previewimagetype' => { 185 => '0Type' },
	'previewimagevalid' => { 347 => 0x100, 352 => 0x1035 },
	'previewimagewidth' => { 80 => 0x3, 161 => 0xfa57 },
	'previewquality' => { 80 => 0x1 },
	'previewsettingsdigest' => { 127 => 0xc719 },
	'previewsettingsname' => { 127 => 0xc718 },
	'primaryafpoint' => { 212 => 0x7, 213 => 0x44, 214 => 0x7, 215 => 0x38 },
	'primarychromaticities' => { 127 => 0x13f, 562 => 'PrimaryChromaticities' },
	'primaryftp' => { 524 => 'PrimaryFTP' },
	'primaryslot' => { 270 => 0x25, 288 => 0x2 },
	'printim' => { 127 => 0xc4a5 },
	'prioritysetinawb' => { 481 => 0x202b },
	'prioritysetupshutterrelease' => { 203 => 0x1d, 467 => 0x28 },
	'privatertkinfo' => { 527 => 'privateRTKInfo' },
	'processbordercolsleft' => { 157 => 0xc61 },
	'processbordercolsright' => { 157 => 0xc62 },
	'processborderrowsbottom' => { 157 => 0xc64 },
	'processborderrowstop' => { 157 => 0xc63 },
	'processingsoftware' => { 127 => 0xb },
	'processversion' => { 536 => 'ProcessVersion', 538 => 'ProcessVersion' },
	'producer' => { 198 => 'WM/Producer', 357 => 'Producer', 429 => "\xa9prd", 431 => 'producer', 437 => "\xa9prd", 552 => 'Producer' },
	'producerkeywords' => { 437 => "\xa9pdk" },
	'productcode' => { 556 => 'productCode' },
	'productid' => { 151 => 0x32, 429 => 'prID', 555 => 'productID' },
	'productidtype' => { 555 => 'productIDType' },
	'productinimage' => { 550 => 'ProductInImage' },
	'productinimagedescription' => { 550 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 550 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 550 => [\'ProductInImage','ProductInImageProductName'] },
	'productinimageproductid' => { 550 => [\'ProductInImage','ProductInImageProductId'] },
	'productioncode' => { 389 => 0x2 },
	'productorserviceconstraints' => { 358 => 'ProductOrServiceConstraints' },
	'productversion' => { 429 => 'VERS' },
	'profession' => { 556 => 'profession' },
	'profile' => { 140 => [\'Profiles','ProfilesProfile'] },
	'profilecalibrationsig' => { 127 => 0xc6f4 },
	'profilecameraindices' => { 140 => [\'Profiles','ProfilesProfileCameraIndices'] },
	'profilecopyright' => { 127 => 0xc6fe },
	'profiledynamicrange' => { 127 => 0xcd47 },
	'profileembedpolicy' => { 127 => 0xc6fd },
	'profilegaintablemap' => { 127 => 0xcd2d },
	'profilegaintablemap2' => { 127 => 0xcd40 },
	'profilegroupname' => { 127 => 0xcd48 },
	'profilehuesatmapdata1' => { 127 => 0xc6fa },
	'profilehuesatmapdata2' => { 127 => 0xc6fb },
	'profilehuesatmapdata3' => { 127 => 0xcd39 },
	'profilehuesatmapdims' => { 127 => 0xc6f9 },
	'profilehuesatmapencoding' => { 127 => 0xc7a3 },
	'profilelooktabledata' => { 127 => 0xc726 },
	'profilelooktabledims' => { 127 => 0xc725 },
	'profilelooktableencoding' => { 127 => 0xc7a4 },
	'profilename' => { 127 => 0xc6f8, 359 => 'iCCP-name' },
	'profiles' => { 140 => 'Profiles' },
	'profiletonecurve' => { 127 => 0xc6fc },
	'profiletype' => { 140 => [\'Profiles','ProfilesProfileType'] },
	'programiso' => { 372 => 0x3c },
	'programline' => { 390 => '1.1' },
	'programmode' => { 208 => 0x5 },
	'programshift' => { 258 => 0xd },
	'programversion' => { 150 => 0x46 },
	'prohibits' => { 534 => 'prohibits' },
	'projectiontype' => { 148 => 'ProjectionType', 149 => 'ProjectionType' },
	'projectname' => { 566 => 'projectName' },
	'projectref' => { 566 => 'projectRef' },
	'projectrefpath' => { 566 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 566 => [\'projectRef','projectRefType'] },
	'promotionurl' => { 198 => 'WM/PromotionURL' },
	'propertyreleaseid' => { 358 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 358 => 'PropertyReleaseStatus' },
	'provider' => { 198 => 'WM/Provider' },
	'province-state' => { 150 => 0x5f },
	'publicationdate' => { 556 => 'publicationDate' },
	'publicationdatea-platform' => { 556 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 556 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 556 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 556 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 556 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationevent' => { 550 => 'PublicationEvent' },
	'publicationeventdate' => { 550 => [\'PublicationEvent','PublicationEventDate'] },
	'publicationeventidentifier' => { 550 => [\'PublicationEvent','PublicationEventIdentifier'] },
	'publicationeventname' => { 550 => [\'PublicationEvent','PublicationEventName'] },
	'publicationname' => { 556 => 'publicationName' },
	'publisher' => { 198 => 'WM/Publisher', 429 => "\xa9pub", 431 => 'publisher', 539 => 'publisher' },
	'publishingfrequency' => { 556 => 'publishingFrequency' },
	'pulldown' => { 566 => 'pullDown' },
	'purchasedate' => { 429 => 'purd' },
	'purplehsl' => { 111 => 0x20916 },
	'pxshiftperiphedgenr' => { 518 => 0x9013 },
	'pxshiftperiphedgenrvalue' => { 518 => 0x9014 },
	'quality' => { 0 => 0x1, 38 => 0x3, 120 => 0x2, 121 => 0x3002, 135 => 0x1000, 159 => 0x9, 258 => 0x4, 307 => 0x3, 352 => 0x201, 367 => 0x300, 411 => 0x8, 418 => 0x2, 457 => 0x16, 467 => 0x56, 468 => 0x56, 469 => 0xb, 481 => [0x102,0x202e] },
	'quality2' => { 490 => 0x1170, 491 => 0x1174, 492 => 0x1150, 494 => 0x11a8, 495 => 0x1060, 496 => 0x258, 497 => 0x258, 498 => 0x247, 504 => 0x29, 505 => 0x25, 506 => 0x2a },
	'qualitybutton' => { 343 => 0x17d, 344 => 0x195 },
	'qualitybuttonplaybackmode' => { 343 => 0x1bf, 344 => 0x1d7 },
	'qualityhint' => { 1 => 0x1a },
	'qualitymode' => { 121 => 0x8 },
	'quantizationmethod' => { 152 => 0x78 },
	'quickadjust' => { 321 => 0x2a },
	'quickcontroldialinmeter' => { 92 => 0x703 },
	'quickfix' => { 318 => 0x416391c6 },
	'quickshot' => { 456 => 0x213 },
	'quiettime' => { 157 => 0x188a },
	'radialdistortioncoefficient1' => { 233 => 0x14 },
	'radialdistortioncoefficient2' => { 233 => 0x1c },
	'radialdistortioncoefficient3' => { 233 => 0x24 },
	'rads' => { 437 => 'rads' },
	'rangefinder' => { 330 => '4.1', 331 => '5.1', 332 => '5.1' },
	'rangemask' => { 536 => 'RangeMaskMapInfo', 538 => 'RangeMaskMapInfo' },
	'rangemaskmapinfo' => { 536 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'], 538 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfo'] },
	'rangemaskmapinfolabmax' => { 536 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'], 538 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMax'] },
	'rangemaskmapinfolabmin' => { 536 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'], 538 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLabMin'] },
	'rangemaskmapinfolumeq' => { 536 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'], 538 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoLumEq'] },
	'rangemaskmapinforgbmax' => { 536 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'], 538 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMax'] },
	'rangemaskmapinforgbmin' => { 536 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'], 538 => [\'RangeMaskMapInfo','RangeMaskMapInfoRangeMaskMapInfoRGBMin'] },
	'rasterizedcaption' => { 150 => 0x7d },
	'rating' => { 111 => 0x10100, 127 => 0x4746, 135 => 0x1431, 422 => 0xdf, 429 => 'rtng', 437 => 'rtng', 481 => 0x2002, 530 => 'rating', 540 => 'rating', 550 => 'Rating', 556 => 'rating', 564 => 'Rating' },
	'ratingpercent' => { 127 => 0x4749, 197 => 'Rating', 429 => 'rate', 564 => 'RatingPercent' },
	'ratingregion' => { 550 => [\'Rating','RatingRatingRegion'] },
	'ratingregioncity' => { 550 => [\'Rating','RatingRatingRegionCity'] },
	'ratingregioncountrycode' => { 550 => [\'Rating','RatingRatingRegionCountryCode'] },
	'ratingregioncountryname' => { 550 => [\'Rating','RatingRatingRegionCountryName'] },
	'ratingregiongpsaltitude' => { 550 => [\'Rating','RatingRatingRegionGPSAltitude'] },
	'ratingregiongpsaltituderef' => { 550 => [\'Rating','RatingRatingRegionGPSAltitudeRef'] },
	'ratingregiongpslatitude' => { 550 => [\'Rating','RatingRatingRegionGPSLatitude'] },
	'ratingregiongpslongitude' => { 550 => [\'Rating','RatingRatingRegionGPSLongitude'] },
	'ratingregionidentifier' => { 550 => [\'Rating','RatingRatingRegionIdentifier'] },
	'ratingregionlocationid' => { 550 => [\'Rating','RatingRatingRegionLocationId'] },
	'ratingregionlocationname' => { 550 => [\'Rating','RatingRatingRegionLocationName'] },
	'ratingregionprovincestate' => { 550 => [\'Rating','RatingRatingRegionProvinceState'] },
	'ratingregionsublocation' => { 550 => [\'Rating','RatingRatingRegionSublocation'] },
	'ratingregionworldregion' => { 550 => [\'Rating','RatingRatingRegionWorldRegion'] },
	'ratingscalemaxvalue' => { 550 => [\'Rating','RatingRatingScaleMaxValue'] },
	'ratingscaleminvalue' => { 550 => [\'Rating','RatingRatingScaleMinValue'] },
	'ratingsourcelink' => { 550 => [\'Rating','RatingRatingSourceLink'] },
	'ratingvalue' => { 550 => [\'Rating','RatingRatingValue'] },
	'ratingvaluelogolink' => { 550 => [\'Rating','RatingRatingValueLogoLink'] },
	'rawandjpgrecording' => { 90 => 0x8, 205 => 0x109, 390 => 0xd },
	'rawbrightnessadj' => { 111 => 0x20001, 116 => 0x38 },
	'rawburstimagecount' => { 82 => 0x2 },
	'rawburstimagenum' => { 82 => 0x1 },
	'rawcoloradj' => { 116 => 0x2e },
	'rawcropbottom' => { 422 => 0xd4 },
	'rawcropleft' => { 422 => 0xd1 },
	'rawcropright' => { 422 => 0xd3 },
	'rawcroptop' => { 422 => 0xd2 },
	'rawcustomsaturation' => { 116 => 0x30 },
	'rawcustomtone' => { 116 => 0x34 },
	'rawdata' => { 454 => 0xa048 },
	'rawdatabyteorder' => { 454 => 0x40 },
	'rawdatacfapattern' => { 454 => 0x50 },
	'rawdatauniqueid' => { 127 => 0xc65d },
	'rawdepth' => { 207 => 0x10 },
	'rawdevartfilter' => { 354 => 0x121 },
	'rawdevautogradation' => { 354 => 0x119 },
	'rawdevcolorspace' => { 353 => 0x108, 354 => 0x109 },
	'rawdevcontrastvalue' => { 353 => 0x106, 354 => 0x105 },
	'rawdeveditstatus' => { 353 => 0x10b },
	'rawdevelopingsoftware' => { 127 => 0xa43a, 543 => 'RAWDevelopingSoftware' },
	'rawdevelopmentprocess' => { 411 => 0x62 },
	'rawdevengine' => { 353 => 0x109, 354 => 0x10b },
	'rawdevexposurebiasvalue' => { 353 => 0x100, 354 => 0x100 },
	'rawdevgradation' => { 354 => 0x112 },
	'rawdevgraypoint' => { 353 => 0x103, 354 => 0x104 },
	'rawdevmemorycoloremphasis' => { 353 => 0x105, 354 => 0x108 },
	'rawdevnoisereduction' => { 353 => 0x10a, 354 => 0x10a },
	'rawdevpicturemode' => { 354 => 0x10c },
	'rawdevpm_bwfilter' => { 354 => 0x110 },
	'rawdevpmcontrast' => { 354 => 0x10e },
	'rawdevpmnoisefilter' => { 354 => 0x120 },
	'rawdevpmpicturetone' => { 354 => 0x111 },
	'rawdevpmsaturation' => { 354 => 0x10d },
	'rawdevpmsharpness' => { 354 => 0x10f },
	'rawdevsaturation3' => { 354 => 0x113 },
	'rawdevsaturationemphasis' => { 353 => 0x104, 354 => 0x107 },
	'rawdevsettings' => { 353 => 0x10c },
	'rawdevsharpnessvalue' => { 353 => 0x107, 354 => 0x106 },
	'rawdevversion' => { 353 => 0x0, 354 => 0x0 },
	'rawdevwbfineadjustment' => { 353 => 0x102, 354 => 0x103 },
	'rawdevwhitebalance' => { 354 => 0x101 },
	'rawdevwhitebalancevalue' => { 353 => 0x101, 354 => 0x102 },
	'rawfile' => { 127 => 0xfe4c },
	'rawfilename' => { 536 => 'RawFileName', 538 => 'RawFileName' },
	'rawfiletype' => { 481 => 0x2029 },
	'rawformat' => { 377 => 0x2d, 420 => 0x10e },
	'rawimagecenter' => { 258 => 0x99 },
	'rawimagedigest' => { 127 => 0xc71c },
	'rawimagesize' => { 411 => 0x39 },
	'rawinfoversion' => { 355 => 0x0 },
	'rawjpgheight' => { 107 => 0x4 },
	'rawjpgquality' => { 62 => 0x6, 107 => 0x1 },
	'rawjpgsize' => { 62 => 0x7, 107 => 0x2 },
	'rawjpgwidth' => { 107 => 0x3 },
	'rawmeasuredrggb' => { 48 => 0x26a, 50 => 0x280, 52 => 0x194, 53 => [0x1ad,0x26b] },
	'rawrppused' => { 530 => 'rawrppused' },
	'rawtopreviewgain' => { 127 => 0xc7a8 },
	'readouttypeactual' => { 157 => 0x1903 },
	'readouttyperequested' => { 157 => 0x1902 },
	'reardisplay' => { 325 => '12.3', 326 => '6.2' },
	'recdevice' => { 550 => 'RecDevice' },
	'recdeviceattlensdescription' => { 550 => [\'RecDevice','RecDeviceAttLensDescription'] },
	'recdevicemanufacturer' => { 550 => [\'RecDevice','RecDeviceManufacturer'] },
	'recdevicemodelname' => { 550 => [\'RecDevice','RecDeviceModelName'] },
	'recdeviceownersdeviceid' => { 550 => [\'RecDevice','RecDeviceOwnersDeviceId'] },
	'recdeviceserialnumber' => { 550 => [\'RecDevice','RecDeviceSerialNumber'] },
	'recipeendingpage' => { 558 => 'recipeEndingPage' },
	'recipepagerange' => { 558 => 'recipePageRange' },
	'recipesource' => { 558 => 'recipeSource' },
	'recipestartingpage' => { 558 => 'recipeStartingPage' },
	'recipetitle' => { 558 => 'recipeTitle' },
	'recognizedface1age' => { 365 => 0x20 },
	'recognizedface1name' => { 365 => 0x4 },
	'recognizedface1position' => { 365 => 0x18 },
	'recognizedface2age' => { 365 => 0x50 },
	'recognizedface2name' => { 365 => 0x34 },
	'recognizedface2position' => { 365 => 0x48 },
	'recognizedface3age' => { 365 => 0x80 },
	'recognizedface3name' => { 365 => 0x64 },
	'recognizedface3position' => { 365 => 0x78 },
	'recognizedfaceflags' => { 372 => 0x63 },
	'recommendedexposureindex' => { 127 => 0x8832, 543 => 'RecommendedExposureIndex' },
	'record' => { 126 => 'Record' },
	'recordbasisofrecord' => { 126 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 126 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 126 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 126 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 126 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 126 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 203 => 0x4d },
	'recorddynamicproperties' => { 126 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 105 => 0x1804 },
	'recordinformationwithheld' => { 126 => [\'Record','RecordInformationWithheld'] },
	'recordingcopyright' => { 437 => "\xa9phg" },
	'recordingformat' => { 447 => 0x1000 },
	'recordingmode' => { 120 => 0x1, 418 => 0x1 },
	'recordinstitutioncode' => { 126 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 126 => [\'Record','RecordInstitutionID'] },
	'recordlabelname' => { 437 => "\xa9lab" },
	'recordlabelurl' => { 437 => "\xa9lal" },
	'recordlocationdata' => { 267 => 0x660, 268 => 0x690, 269 => 0x6f8 },
	'recordmode' => { 38 => 0x9, 121 => 0x3000 },
	'recordownerinstitutioncode' => { 126 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 456 => 0x217 },
	'redbalance' => { 352 => 0x1017, 377 => 0x11, 411 => 0x1c },
	'redcurvelimits' => { 116 => 0x18a },
	'redcurvepoints' => { 115 => 0x2d, 116 => 0x160 },
	'redeyecorrection' => { 322 => 0x0 },
	'redeyeinfo' => { 536 => 'RedEyeInfo', 538 => 'RedEyeInfo' },
	'redeyereduction' => { 203 => 0x41, 467 => 0x6a, 469 => 0x28 },
	'redeyeremoval' => { 372 => 0xb9 },
	'redhsl' => { 111 => 0x20910 },
	'redhue' => { 536 => 'RedHue', 538 => 'RedHue' },
	'redsaturation' => { 536 => 'RedSaturation', 538 => 'RedSaturation' },
	'reductionmatrix1' => { 127 => 0xc625 },
	'reductionmatrix2' => { 127 => 0xc626 },
	'reductionmatrix3' => { 127 => 0xcd3a },
	'reelname' => { 127 => 0xc789, 437 => 'reel' },
	'reference1' => { 548 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 548 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 127 => 0x214, 562 => 'ReferenceBlackWhite' },
	'referencedate' => { 150 => 0x2f },
	'referencenumber' => { 150 => 0x32 },
	'references' => { 176 => 'References' },
	'referenceservice' => { 150 => 0x2d },
	'regionappliedtodimensions' => { 191 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 191 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 191 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 191 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 191 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 191 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 191 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 191 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 191 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 191 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 191 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 191 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 358 => 'RegionConstraints' },
	'regiondescription' => { 191 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 191 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 191 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 191 => 'Regions' },
	'regioninfoacdsee' => { 519 => 'Regions' },
	'regioninfodateregionsvalid' => { 194 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 194 => 'RegionInfo' },
	'regioninforegions' => { 194 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 191 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 191 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 194 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 194 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 194 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 194 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 194 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 191 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 191 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 191 => [\'Regions','RegionsRegionListType'] },
	'registryentryrole' => { 550 => [\'RegistryId','RegistryIdRegEntryRole'] },
	'registryid' => { 550 => 'RegistryId' },
	'registryitemid' => { 550 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 550 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 174 => 'data' },
	'relatedaudiofilename' => { 174 => '1Name' },
	'relatedaudiofiletype' => { 174 => '0Type' },
	'relatedimagefileformat' => { 127 => 0x1000 },
	'relatedimageheight' => { 127 => 0x1002 },
	'relatedimagewidth' => { 127 => 0x1001 },
	'relatedresourceid' => { 126 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 127 => 0xa004, 542 => 'RelatedSoundFile' },
	'relatedvideofile' => { 188 => 'data' },
	'relatedvideofilename' => { 188 => '1Name' },
	'relatedvideofiletype' => { 188 => '0Type' },
	'relation' => { 539 => 'relation' },
	'relationshipaccordingto' => { 126 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 126 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 126 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipofresourceid' => { 126 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResourceID'] },
	'relationshipremarks' => { 126 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativealtitude' => { 124 => 'RelativeAltitude' },
	'relativepeakaudiofilepath' => { 566 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 566 => 'relativeTimestamp' },
	'relativetimestampscale' => { 566 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 566 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 325 => '17.8', 326 => '18.5', 328 => '18.4', 329 => '18.4', 334 => '33.8', 335 => '17.6', 338 => '18.5', 339 => '18.4' },
	'releasedate' => { 150 => 0x1e, 429 => 'rldt', 530 => 'ReleaseDate', 566 => 'releaseDate' },
	'releasemode' => { 121 => 0x3001, 263 => 0x5c, 298 => 0x184d, 481 => 0xb049 },
	'releasemode2' => { 490 => 0x112c, 491 => [0x112c,0x8], 492 => [0x1108,0x8], 493 => [0x1184,0x8], 494 => [0x1160,0x8], 495 => [0x4,0x1018], 496 => [0x4,0x210], 497 => [0x4,0x210], 498 => [0x4,0x208], 500 => [0x67,0x3f], 501 => [0x6b,0x6d,0x73,0x4b], 502 => [0x6b,0x4b], 503 => 0x1f, 504 => 0x10, 505 => 0x10, 506 => 0x9, 513 => 0x34 },
	'releasemode3' => { 490 => 0x1128, 491 => 0x1128, 492 => 0x1104, 493 => 0x1180, 494 => 0x115c, 495 => 0x1014, 496 => 0x20c, 497 => 0x20c, 498 => 0x204 },
	'releasemodebutton' => { 266 => 0x8a0 },
	'releasemodebuttonplaybackmode' => { 266 => 0x8a8 },
	'releaseready' => { 550 => 'ReleaseReady' },
	'releasesetting' => { 105 => 0x1016 },
	'releasetime' => { 150 => 0x23, 530 => 'ReleaseTime' },
	'remoteonduration' => { 327 => '3.4', 330 => '17.2', 331 => '18.2', 332 => '18.2', 333 => '18.2', 335 => '18.2', 336 => '4.3', 340 => '19.2' },
	'renditionclass' => { 567 => 'RenditionClass' },
	'renditionof' => { 567 => 'RenditionOf' },
	'renditionofalternatepaths' => { 567 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 567 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 567 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 567 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 567 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 567 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionoflasturl' => { 567 => [\'RenditionOf','RenditionOfLastURL'] },
	'renditionoflinkcategory' => { 567 => [\'RenditionOf','RenditionOfLinkCategory'] },
	'renditionoflinkform' => { 567 => [\'RenditionOf','RenditionOfLinkForm'] },
	'renditionofmanager' => { 567 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 567 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 567 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 567 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 567 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 567 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 567 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofplacedresolutionunit' => { 567 => [\'RenditionOf','RenditionOfPlacedResolutionUnit'] },
	'renditionofplacedxresolution' => { 567 => [\'RenditionOf','RenditionOfPlacedXResolution'] },
	'renditionofplacedyresolution' => { 567 => [\'RenditionOf','RenditionOfPlacedYResolution'] },
	'renditionofrenditionclass' => { 567 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 567 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 567 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 567 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 567 => 'RenditionParams' },
	'repeatingflashcount' => { 236 => 0xd, 237 => 0xe, 238 => 0xe, 239 => 0xe, 240 => 0xe, 241 => 0xe, 334 => '17.2', 335 => '24.2', 336 => '9.2', 337 => '24.2', 340 => '25.2' },
	'repeatingflashcountbuilt-in' => { 305 => 0x4db },
	'repeatingflashcountexternal' => { 305 => 0x4c3 },
	'repeatingflashoutput' => { 334 => '17.1', 335 => '24.1', 336 => '9.1', 337 => '24.1', 340 => '25.1' },
	'repeatingflashoutputexternal' => { 305 => 0x4c0 },
	'repeatingflashrate' => { 236 => 0xc, 237 => 0xd, 238 => 0xd, 239 => 0xd, 240 => 0xd, 241 => 0xd, 334 => '18.1', 335 => '25.1', 336 => '10.1', 337 => '25.1', 340 => '26.1' },
	'repeatingflashratebuilt-in' => { 305 => 0x4da },
	'repeatingflashrateexternal' => { 305 => 0x4c2 },
	'requirements' => { 437 => "\xa9req" },
	'requires' => { 534 => 'requires' },
	'resampleparams' => { 566 => 'resampleParams' },
	'resampleparamsquality' => { 566 => [\'resampleParams','resampleParamsQuality'] },
	'resamplingkerneldenominators050' => { 157 => 0xe50 },
	'resamplingkerneldenominators067' => { 157 => 0xe4f },
	'resamplingkerneldenominators100' => { 157 => 0xe51 },
	'resaved' => { 456 => 0x21e },
	'resetblacksegrows' => { 157 => 0x181a },
	'resolution' => { 181 => 'Resolution' },
	'resolutionmode' => { 457 => [0x87,0x4] },
	'resolutionunit' => { 127 => 0x128, 153 => 0x2, 562 => 'ResolutionUnit' },
	'resourceid' => { 126 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 126 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 126 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 92 => 0x612 },
	'restrictions' => { 559 => 'restrictions' },
	'retouchareafeather' => { 536 => [\'RetouchAreas','RetouchAreasFeather'], 538 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 536 => [\'RetouchAreas','RetouchAreasMasksAlpha'], 538 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 536 => [\'RetouchAreas','RetouchAreasMasksAngle'], 538 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 536 => [\'RetouchAreas','RetouchAreasMasksBottom'], 538 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 536 => [\'RetouchAreas','RetouchAreasMasksCenterValue'], 538 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 536 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'], 538 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 536 => [\'RetouchAreas','RetouchAreasMasksDabs'], 538 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 536 => [\'RetouchAreas','RetouchAreasMasksFeather'], 538 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 536 => [\'RetouchAreas','RetouchAreasMasksFlipped'], 538 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 536 => [\'RetouchAreas','RetouchAreasMasksFlow'], 538 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 536 => [\'RetouchAreas','RetouchAreasMasksFullX'], 538 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 536 => [\'RetouchAreas','RetouchAreasMasksFullY'], 538 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskinputdigest' => { 536 => [\'RetouchAreas','RetouchAreasMasksInputDigest'], 538 => [\'RetouchAreas','RetouchAreasMasksInputDigest'] },
	'retouchareamaskleft' => { 536 => [\'RetouchAreas','RetouchAreasMasksLeft'], 538 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmaskactive' => { 536 => [\'RetouchAreas','RetouchAreasMasksMaskActive'], 538 => [\'RetouchAreas','RetouchAreasMasksMaskActive'] },
	'retouchareamaskmaskblendmode' => { 536 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'], 538 => [\'RetouchAreas','RetouchAreasMasksMaskBlendMode'] },
	'retouchareamaskmaskdigest' => { 536 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'], 538 => [\'RetouchAreas','RetouchAreasMasksMaskDigest'] },
	'retouchareamaskmaskinverted' => { 536 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'], 538 => [\'RetouchAreas','RetouchAreasMasksMaskInverted'] },
	'retouchareamaskmaskname' => { 536 => [\'RetouchAreas','RetouchAreasMasksMaskName'], 538 => [\'RetouchAreas','RetouchAreasMasksMaskName'] },
	'retouchareamaskmasks' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasks'], 538 => [\'RetouchAreas','RetouchAreasMasksMasks'] },
	'retouchareamaskmasksalpha' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksAlpha'] },
	'retouchareamaskmasksangle' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksAngle'] },
	'retouchareamaskmasksbottom' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksBottom'] },
	'retouchareamaskmaskscentervalue' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksCenterValue'] },
	'retouchareamaskmaskscenterweight' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksCenterWeight'] },
	'retouchareamaskmasksdabs' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksDabs'] },
	'retouchareamaskmasksfeather' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksFeather'] },
	'retouchareamaskmasksflipped' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksFlipped'] },
	'retouchareamaskmasksflow' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksFlow'] },
	'retouchareamaskmasksfullx' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksFullX'] },
	'retouchareamaskmasksfully' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksFullY'] },
	'retouchareamaskmasksinputdigest' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksInputDigest'] },
	'retouchareamaskmasksleft' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksLeft'] },
	'retouchareamaskmasksmaskactive' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksMaskActive'] },
	'retouchareamaskmasksmaskblendmode' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksMaskBlendMode'] },
	'retouchareamaskmasksmaskdigest' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksMaskDigest'] },
	'retouchareamaskmasksmaskinverted' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksMaskInverted'] },
	'retouchareamaskmasksmaskname' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksMaskName'] },
	'retouchareamaskmasksmasksubtype' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSubType'] },
	'retouchareamaskmasksmasksyncid' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksMaskSyncID'] },
	'retouchareamaskmasksmaskversion' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksMaskVersion'] },
	'retouchareamaskmasksmidpoint' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksMidpoint'] },
	'retouchareamaskmasksorigin' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksOrigin'] },
	'retouchareamaskmasksperimetervalue' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksPerimeterValue'] },
	'retouchareamaskmasksradius' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksRadius'] },
	'retouchareamaskmasksreferencepoint' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksReferencePoint'] },
	'retouchareamaskmasksright' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksRight'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksRight'] },
	'retouchareamaskmasksroundness' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksRoundness'] },
	'retouchareamaskmaskssizex' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksSizeX'] },
	'retouchareamaskmaskssizey' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksSizeY'] },
	'retouchareamaskmaskstop' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksTop'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksTop'] },
	'retouchareamaskmasksubtype' => { 536 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'], 538 => [\'RetouchAreas','RetouchAreasMasksMaskSubType'] },
	'retouchareamaskmasksvalue' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksMaskValue'] },
	'retouchareamaskmasksversion' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksVersion'] },
	'retouchareamaskmaskswhat' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksWhat'] },
	'retouchareamaskmaskswholeimagearea' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksWholeImageArea'] },
	'retouchareamaskmasksx' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksX'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksX'] },
	'retouchareamaskmasksy' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksY'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksY'] },
	'retouchareamaskmasksyncid' => { 536 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'], 538 => [\'RetouchAreas','RetouchAreasMasksMaskSyncID'] },
	'retouchareamaskmaskszerox' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksZeroX'] },
	'retouchareamaskmaskszeroy' => { 536 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'], 538 => [\'RetouchAreas','RetouchAreasMasksMasksZeroY'] },
	'retouchareamaskmaskversion' => { 536 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'], 538 => [\'RetouchAreas','RetouchAreasMasksMaskVersion'] },
	'retouchareamaskmidpoint' => { 536 => [\'RetouchAreas','RetouchAreasMasksMidpoint'], 538 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskorigin' => { 536 => [\'RetouchAreas','RetouchAreasMasksOrigin'], 538 => [\'RetouchAreas','RetouchAreasMasksOrigin'] },
	'retouchareamaskperimetervalue' => { 536 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'], 538 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 536 => [\'RetouchAreas','RetouchAreasMasksRadius'], 538 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskrange' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMask'] },
	'retouchareamaskrangeareamodels' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModels'] },
	'retouchareamaskrangeareamodelscolorsampleinfo' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsColorRangeMaskAreaSampleInfo'] },
	'retouchareamaskrangeareamodelscomponents' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskAreaModelsAreaComponents'] },
	'retouchareamaskrangecoloramount' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskColorAmount'] },
	'retouchareamaskrangedepthfeather' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthFeather'] },
	'retouchareamaskrangedepthmax' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMax'] },
	'retouchareamaskrangedepthmin' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskDepthMin'] },
	'retouchareamaskrangeinvert' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskInvert'] },
	'retouchareamaskrangelumfeather' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumFeather'] },
	'retouchareamaskrangeluminancedepthsampleinfo' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLuminanceDepthSampleInfo'] },
	'retouchareamaskrangelummax' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMax'] },
	'retouchareamaskrangelummin' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumMin'] },
	'retouchareamaskrangelumrange' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskLumRange'] },
	'retouchareamaskrangesampletype' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskSampleType'] },
	'retouchareamaskrangetype' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskType'] },
	'retouchareamaskrangeversion' => { 536 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'], 538 => [\'RetouchAreas','RetouchAreasMasksCorrectionRangeMaskVersion'] },
	'retouchareamaskreferencepoint' => { 536 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'], 538 => [\'RetouchAreas','RetouchAreasMasksReferencePoint'] },
	'retouchareamaskright' => { 536 => [\'RetouchAreas','RetouchAreasMasksRight'], 538 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 536 => [\'RetouchAreas','RetouchAreasMasksRoundness'], 538 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 536 => [\'RetouchAreas','RetouchAreasMasks'], 538 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 536 => [\'RetouchAreas','RetouchAreasMasksSizeX'], 538 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 536 => [\'RetouchAreas','RetouchAreasMasksSizeY'], 538 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 536 => [\'RetouchAreas','RetouchAreasMasksTop'], 538 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 536 => [\'RetouchAreas','RetouchAreasMasksMaskValue'], 538 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 536 => [\'RetouchAreas','RetouchAreasMasksVersion'], 538 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 536 => [\'RetouchAreas','RetouchAreasMasksWhat'], 538 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskwholeimagearea' => { 536 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'], 538 => [\'RetouchAreas','RetouchAreasMasksWholeImageArea'] },
	'retouchareamaskx' => { 536 => [\'RetouchAreas','RetouchAreasMasksX'], 538 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 536 => [\'RetouchAreas','RetouchAreasMasksY'], 538 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 536 => [\'RetouchAreas','RetouchAreasMasksZeroX'], 538 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 536 => [\'RetouchAreas','RetouchAreasMasksZeroY'], 538 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 536 => [\'RetouchAreas','RetouchAreasMethod'], 538 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 536 => [\'RetouchAreas','RetouchAreasOffsetY'], 538 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 536 => [\'RetouchAreas','RetouchAreasOpacity'], 538 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 536 => 'RetouchAreas', 538 => 'RetouchAreas' },
	'retouchareaseed' => { 536 => [\'RetouchAreas','RetouchAreasSeed'], 538 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 536 => [\'RetouchAreas','RetouchAreasSourceState'], 538 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 536 => [\'RetouchAreas','RetouchAreasSourceX'], 538 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 536 => [\'RetouchAreas','RetouchAreasSpotType'], 538 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 258 => 0x9e },
	'retouchinfo' => { 536 => 'RetouchInfo', 538 => 'RetouchInfo' },
	'retouchnefprocessing' => { 282 => 0x5 },
	'retractlensonpoweroff' => { 92 => 0x814 },
	'reuse' => { 358 => 'Reuse' },
	'reuseallowed' => { 569 => 'ReuseAllowed' },
	'reuseprohibited' => { 559 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 332 => '5.2' },
	'reversefocusring' => { 342 => 0x163, 343 => 0x163, 344 => 0x17b },
	'reverseindicators' => { 325 => '12.1', 326 => '6.1', 328 => '6.1', 329 => '6.1', 330 => '4.3', 331 => '5.2', 332 => '5.4', 334 => '33.5', 335 => '5.1', 338 => '6.1', 339 => '6.1', 340 => '6.2', 341 => 0xc5, 342 => 0xc1, 343 => 0xc1, 344 => 0xc1 },
	'reverseshutterspeedaperture' => { 332 => '5.3' },
	'revision' => { 540 => 'revision' },
	'rflensmffocusringsensitivity' => { 92 => 0x714 },
	'rflenstype' => { 62 => 0x3d },
	'rgbcurvelimits' => { 116 => 0x238 },
	'rgbcurvepoints' => { 115 => 0x7, 116 => 0x20e },
	'rgbtables' => { 127 => 0xcd3f },
	'richtextcomment' => { 545 => 'RichTextComment' },
	'ricohdate' => { 446 => 0x6 },
	'ricohimageheight' => { 446 => 0x2 },
	'ricohimagewidth' => { 446 => 0x0 },
	'rightalbedo' => { 526 => 'RightAlbedo' },
	'rightascension' => { 184 => 'RightAscension' },
	'rights' => { 539 => 'rights' },
	'rightsagent' => { 559 => 'rightsAgent' },
	'rightsowner' => { 559 => 'rightsOwner' },
	'roll' => { 123 => 0x8, 437 => ['roll',"\xa9frl"] },
	'rollangle' => { 68 => 0x4, 135 => 0x144d, 274 => 0x0, 347 => 0x903, 362 => 'RollAngle', 372 => 0x90, 409 => 0x1, 410 => 0x3, 452 => 0x2 },
	'romoperationmode' => { 105 => 0x80d },
	'rotation' => { 31 => 0x17, 32 => 0x18, 104 => 0x3, 111 => 0x10002, 116 => 0x26e, 122 => 'QuickTime-Rotation', 131 => 0x4, 184 => 'Rotation', 201 => [0x65,0x50], 202 => 0x46, 203 => 0x5a, 206 => 0x10, 283 => 0x1a, 298 => 0x3693, 304 => '590.1', 318 => 0x76a43207, 372 => 0x30, 390 => '17.2', 422 => 0xd8, 430 => 'irot', 467 => 0x3f, 468 => 0x3f, 478 => 0x10 },
	'routedto' => { 544 => 'RoutedTo' },
	'routing' => { 427 => 'Routing' },
	'routingdestinations' => { 524 => 'RoutingDestinations' },
	'routingexclusions' => { 524 => 'RoutingExclusions' },
	'routingnotes' => { 544 => 'RoutingNotes' },
	'rowsperstrip' => { 127 => 0x116 },
	'rpp' => { 530 => 'rpp' },
	'rtkflag' => { 124 => 'RtkFlag' },
	'rtkstdhgt' => { 124 => 'RtkStdHgt' },
	'rtkstdlat' => { 124 => 'RtkStdLat' },
	'rtkstdlon' => { 124 => 'RtkStdLon' },
	'safetyshift' => { 92 => 0x108 },
	'safetyshiftinavortv' => { 90 => 0x10, 91 => 0x10, 93 => 0xf, 94 => 0x10, 97 => 0x10 },
	'sameexposurefornewaperture' => { 92 => 0x112 },
	'samplebits' => { 174 => 'SampleBits' },
	'samplepagerange' => { 556 => 'samplePageRange' },
	'samplerate' => { 174 => 'SampleRate' },
	'samplesperpixel' => { 127 => 0x115, 377 => 0x8, 562 => 'SamplesPerPixel' },
	'samplestructure' => { 152 => 0x5a },
	'samsungmodelid' => { 454 => 0x3 },
	'sanyoquality' => { 456 => 0x201 },
	'sanyothumbnail' => { 456 => 0x100 },
	'saturation' => { 10 => 0x6e, 12 => 0x76, 38 => 0xe, 56 => 0x1, 70 => 0x7, 120 => 0xd, 121 => [0x3013,0x1f], 127 => [0xa409,0xfe55], 135 => 0x1003, 175 => 'Saturation', 200 => 0x1f, 201 => 0x32, 202 => 0x28, 203 => 0x1a, 208 => 0x1, 258 => 0xaa, 276 => 0x35, 277 => 0x3b, 278 => 0x43, 372 => 0x40, 374 => 0x300d, 411 => 0x1f, 418 => 0xd, 439 => 0x27, 440 => 0x58, 441 => 0x42, 442 => 0x68, 446 => 0x28, 447 => 0x1013, 457 => 0x10, 467 => 0x1e, 468 => 0x1b, 481 => 0x2005, 536 => 'Saturation', 538 => 'Saturation', 542 => 'Saturation' },
	'saturationadj' => { 111 => 0x20901, 116 => 0x116, 258 => 0x94, 317 => 0x1, 321 => 0x2e, 518 => 0x8016 },
	'saturationadjustmentaqua' => { 536 => 'SaturationAdjustmentAqua', 538 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 536 => 'SaturationAdjustmentBlue', 538 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 536 => 'SaturationAdjustmentGreen', 538 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 536 => 'SaturationAdjustmentMagenta', 538 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 536 => 'SaturationAdjustmentOrange', 538 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 536 => 'SaturationAdjustmentPurple', 538 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 536 => 'SaturationAdjustmentRed', 538 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 536 => 'SaturationAdjustmentYellow', 538 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 78 => 0x98 },
	'saturationfaithful' => { 19 => 0xfe, 77 => 0x68, 78 => 0x68 },
	'saturationlandscape' => { 19 => 0xfc, 77 => 0x38, 78 => 0x38 },
	'saturationmonochrome' => { 77 => 0x80, 78 => 0x80 },
	'saturationneutral' => { 19 => 0xfd, 77 => 0x50, 78 => 0x50 },
	'saturationportrait' => { 19 => 0xfb, 77 => 0x20, 78 => 0x20 },
	'saturationsetting' => { 355 => 0x1010, 469 => 0x11, 486 => 0x9 },
	'saturationstandard' => { 19 => 0xfa, 77 => 0x8, 78 => 0x8 },
	'saturationuserdef1' => { 19 => 0x100, 77 => 0x98, 78 => 0xb0 },
	'saturationuserdef2' => { 19 => 0x101, 77 => 0xb0, 78 => 0xc8 },
	'saturationuserdef3' => { 19 => 0x102, 77 => 0xc8, 78 => 0xe0 },
	'savefocusposition' => { 262 => 0x9b0 },
	'saveid' => { 567 => 'SaveID' },
	'sbaanalysiscomplete' => { 157 => 0xc35 },
	'sbablack' => { 157 => 0xc25 },
	'sbagmoffset' => { 157 => 0xc4a },
	'sbagray' => { 157 => 0xc26 },
	'sbagreenmagentabal' => { 157 => 0xc33 },
	'sbahighgray' => { 157 => 0xc46 },
	'sbailloffset' => { 157 => 0xc49 },
	'sbailluminantbal' => { 157 => 0xc34 },
	'sbalowgray' => { 157 => 0xc47 },
	'sbaneutralbal' => { 157 => 0xc32 },
	'sbawhite' => { 157 => 0xc27 },
	'scaletype' => { 566 => 'scaleType' },
	'scalingfactorheight' => { 362 => 'ScalingFactorHeight' },
	'scanimageenhancer' => { 284 => 0x60 },
	'scanningdirection' => { 152 => 0x64 },
	'scene' => { 437 => 'scen', 549 => 'Scene', 566 => 'scene' },
	'scenearea' => { 350 => 0x211, 352 => 0x1031 },
	'sceneassist' => { 258 => 0x9c },
	'scenecapturetype' => { 127 => 0xa406, 542 => 'SceneCaptureType' },
	'scenedetect' => { 350 => 0x210, 352 => 0x1030 },
	'scenedetectdata' => { 350 => 0x212, 352 => 0x1033 },
	'sceneflags' => { 1 => 0x25 },
	'scenemode' => { 161 => 0xfa02, 205 => 0x100, 258 => 0x8f, 347 => 0x509, 352 => 0x403, 372 => 0x8001, 381 => 0xf, 481 => 0xb023 },
	'scenemodeused' => { 163 => [0x6002,0xf002] },
	'scenerecognition' => { 135 => 0x1425 },
	'scenereferred' => { 546 => 'scene_referred' },
	'sceneselect' => { 456 => 0x21f },
	'scenetype' => { 127 => 0xa301, 542 => 'SceneType' },
	'screentips' => { 325 => '12.7', 326 => '5.3', 334 => '13.1', 335 => '4.4', 338 => '5.4', 340 => '5.1' },
	'scriptversion' => { 157 => 0x1770 },
	'sdcardid' => { 442 => 0x18 },
	'sdrblend' => { 536 => 'SDRBlend', 538 => 'SDRBlend' },
	'sdrbrightness' => { 536 => 'SDRBrightness', 538 => 'SDRBrightness' },
	'sdrcontrast' => { 536 => 'SDRContrast', 538 => 'SDRContrast' },
	'sdrhighlights' => { 536 => 'SDRHighlights', 538 => 'SDRHighlights' },
	'sdrshadows' => { 536 => 'SDRShadows', 538 => 'SDRShadows' },
	'sdrwhites' => { 536 => 'SDRWhites', 538 => 'SDRWhites' },
	'seal' => { 127 => 0xcea1 },
	'season' => { 550 => 'Season', 555 => 'season' },
	'seasonidentifier' => { 550 => [\'Season','SeasonIdentifier'] },
	'seasonname' => { 550 => [\'Season','SeasonName'] },
	'seasonnumber' => { 550 => [\'Season','SeasonNumber'] },
	'secondaryftp' => { 524 => 'SecondaryFTP' },
	'secondaryslotfunction' => { 262 => 0x35a, 264 => 0x240, 267 => 0x22c, 268 => 0x240, 269 => 0x240, 287 => 0x13c, 298 => 0x1d0 },
	'section' => { 556 => 'section' },
	'securityclassification' => { 127 => 0x9212 },
	'selectableafpoint' => { 92 => 0x509 },
	'selectafareaselectionmode' => { 2 => 0xc },
	'selectafareaselectmode' => { 92 => 0x512 },
	'selfdata' => { 124 => 'SelfData' },
	'selftimer' => { 38 => 0x2, 372 => 0x2e, 456 => 0x214, 490 => 0x1134, 491 => 0x1134, 492 => 0x1110, 493 => 0x118c, 494 => 0x1168, 495 => 0x1020, 496 => 0x218, 497 => 0x218, 498 => 0x210 },
	'selftimer2' => { 84 => 0x1d },
	'selftimerinterval' => { 335 => '19.2' },
	'selftimermode' => { 127 => 0x882b },
	'selftimershotcount' => { 326 => '20.2', 328 => '20.3', 329 => '20.3', 330 => '18.2', 331 => '19.2', 332 => '19.2', 333 => '19.3', 335 => '19.3', 338 => '20.3', 339 => '20.3', 340 => '20.2', 341 => 0x31, 342 => 0x2d, 343 => 0x2d, 344 => 0x2d },
	'selftimershotinterval' => { 326 => '20.3', 328 => '20.2', 329 => '20.2', 333 => '19.2', 338 => '20.2', 339 => '20.2', 341 => 0x35, 342 => 0x31, 343 => 0x31, 344 => 0x31 },
	'selftimertime' => { 105 => 0x1806, 203 => 0x1f, 325 => '18.1', 326 => '20.1', 327 => '3.3', 328 => '20.1', 329 => '20.1', 330 => '18.1', 331 => '19.1', 332 => '19.1', 333 => '19.1', 334 => '7.2', 335 => '19.1', 336 => '3.3', 338 => '20.1', 339 => '20.1', 340 => '20.1', 341 => 0x2d, 342 => 0x2b, 343 => 0x2b, 344 => 0x2b },
	'sellingagency' => { 556 => 'sellingAgency' },
	'semanticstyle' => { 1 => 0x40 },
	'semanticstylepreset' => { 1 => 0x42 },
	'semanticstylerenderingver' => { 1 => 0x41 },
	'seminfo' => { 127 => 0x8546 },
	'sensingmethod' => { 127 => 0xa217, 542 => 'SensingMethod' },
	'sensitivityadjust' => { 411 => 0x40 },
	'sensitivitysteps' => { 390 => ['14.3','17.4'], 392 => 0x1 },
	'sensitivitytype' => { 127 => 0x8830, 543 => 'SensitivityType' },
	'sensor' => { 210 => 0x665e },
	'sensorarea' => { 352 => 0x400 },
	'sensorareas' => { 454 => 0xa010 },
	'sensorbitdepth' => { 374 => 0x312d },
	'sensorbluelevel' => { 81 => 0x5 },
	'sensorcalibration' => { 351 => 0x805 },
	'sensorcleaning' => { 98 => 0xd },
	'sensorfullheight' => { 156 => 0xf904 },
	'sensorfullwidth' => { 156 => 0xf903 },
	'sensorheight' => { 156 => 0xf901, 161 => 0xfa21, 207 => 0x8, 374 => 0x312c, 420 => 0x109, 447 => 0x1602 },
	'sensorimageheight' => { 157 => 0x3ee },
	'sensorimagewidth' => { 157 => 0x3ed },
	'sensorleftborder' => { 157 => 0x3eb },
	'sensorleftmargin' => { 420 => 0x10a },
	'sensorpixelsize' => { 258 => 0x9a },
	'sensorredlevel' => { 81 => 0x4 },
	'sensorserialnumber' => { 157 => 0x9ce },
	'sensorshield' => { 265 => 0x76b, 266 => 0x7cb, 267 => 0x66d, 268 => 0x69d, 269 => 0x705 },
	'sensorsize' => { 175 => 'SensorSize', 411 => 0x35 },
	'sensortemperature' => { 350 => 0x1500, 352 => 0x1007, 416 => [0xc,0x2a], 420 => 0x210, 457 => [0x39,0x55] },
	'sensortemperature2' => { 416 => 0xe, 420 => 0x211 },
	'sensortopborder' => { 157 => 0x3ec },
	'sensortopmargin' => { 420 => 0x10b },
	'sensortype' => { 372 => 0xca },
	'sensorwidth' => { 156 => 0xf900, 161 => 0xfa20, 207 => 0xa, 374 => 0x312b, 420 => 0x108, 447 => 0x1601 },
	'sequence' => { 439 => 0x7, 440 => 0x36, 441 => 0x29, 442 => 0x46, 443 => 0x35 },
	'sequencefilenumber' => { 491 => 0x4, 492 => 0x4, 493 => 0x4, 494 => 0x4, 504 => 0xc, 505 => 0xc, 506 => 0x1a },
	'sequenceframecount' => { 420 => 0x265 },
	'sequenceframenumber' => { 420 => 0x264 },
	'sequenceid' => { 420 => 0x262 },
	'sequenceimagenumber' => { 491 => 0x0, 492 => 0x0, 493 => 0x0, 494 => 0x0, 504 => 0x8, 505 => 0x8, 506 => 0x12, 513 => 0x24 },
	'sequencekind' => { 420 => 0x263 },
	'sequencelength' => { 504 => 0x22, 505 => 0x1e, 506 => [0x16,0x1e] },
	'sequencename' => { 555 => 'sequenceName' },
	'sequencenumber' => { 84 => 0x9, 121 => 0x301c, 135 => 0x1101, 159 => 0x1d, 305 => 0x51c, 372 => 0x2b, 469 => [0x10c,0x30c], 481 => 0xb04a, 555 => 'sequenceNumber' },
	'sequenceshotinterval' => { 456 => 0x224 },
	'sequencetotalnumber' => { 555 => 'sequenceTotalNumber' },
	'sequentialshot' => { 456 => 0x20e },
	'serialnumber' => { 71 => 0xc, 105 => 0x180b, 127 => [0xa431,0xfde9], 156 => 0xfa04, 158 => 0xfa00, 160 => 0xc354, 161 => 0xfa19, 172 => 0x0, 175 => 'SerialNumber', 210 => 0x5501, 258 => [0xa0,0x1d], 348 => 0x101, 352 => [0x404,0x101a], 367 => 0x303, 369 => 0x305, 374 => 0x3103, 411 => 0x229, 420 => 0x102, 421 => 0x407, 437 => ['SNum','slno'], 439 => 0x15, 440 => 0x7e, 441 => 0x84, 442 => 0x8c, 443 => 0x4b, 447 => 0x5, 454 => 0xa002, 457 => 0x2, 481 => 0x2031, 533 => 'SerialNumber', 543 => 'BodySerialNumber' },
	'serialnumberformat' => { 71 => 0x15, 105 => 0x183b },
	'serialnumberhash' => { 437 => 'CAME' },
	'series' => { 550 => 'Series' },
	'seriesdatetime' => { 521 => 'SeriesDateTime' },
	'seriesdescription' => { 521 => 'SeriesDescription' },
	'seriesidentifier' => { 550 => [\'Series','SeriesIdentifier'] },
	'seriesmodality' => { 521 => 'SeriesModality' },
	'seriesname' => { 550 => [\'Series','SeriesName'] },
	'seriesnumber' => { 521 => 'SeriesNumber', 556 => 'seriesNumber' },
	'seriestitle' => { 556 => 'seriesTitle' },
	'serviceidentifier' => { 151 => 0x1e },
	'servingsize' => { 558 => 'servingSize' },
	'servoafcharacteristics' => { 2 => 0x1b },
	'setbuttoncrosskeysfunc' => { 95 => 0x0, 96 => 0x0 },
	'setbuttonwhenshooting' => { 90 => 0x1, 92 => 0x704, 98 => 0xc },
	'setclockfromlocationdata' => { 267 => 0x61d, 268 => 0x64d, 269 => 0x6b5 },
	'setfunctionwhenshooting' => { 93 => 0x0, 94 => 0x1, 97 => 0x1 },
	'setting' => { 555 => 'setting' },
	'shadingcompensation' => { 347 => 0x50c, 372 => 0x8a },
	'shadingcompensation2' => { 351 => 0x1012 },
	'shadow' => { 457 => 0xe },
	'shadowadj' => { 111 => 0x2030b },
	'shadowcorrection' => { 411 => 0x79 },
	'shadowprotection' => { 317 => 0x0 },
	'shadows' => { 127 => 0xfe52, 481 => 0x2032, 529 => 'Shadows', 536 => 'Shadows', 538 => 'Shadows' },
	'shadows2012' => { 536 => 'Shadows2012', 538 => 'Shadows2012' },
	'shadowsadj' => { 518 => 0x901a },
	'shadowscale' => { 127 => 0xc633 },
	'shadowtint' => { 536 => 'ShadowTint', 538 => 'ShadowTint' },
	'shadowtone' => { 135 => 0x1040 },
	'shakereduction' => { 413 => 0x1, 414 => 0x1 },
	'shareduserrating' => { 198 => 'WM/SharedUserRating' },
	'sharpendetail' => { 536 => 'SharpenDetail', 538 => 'SharpenDetail' },
	'sharpenedgemasking' => { 536 => 'SharpenEdgeMasking', 538 => 'SharpenEdgeMasking' },
	'sharpening' => { 374 => 0x300b },
	'sharpeningadj' => { 321 => 0x2b },
	'sharpeningkernel' => { 157 => 0x92f },
	'sharpenradius' => { 536 => 'SharpenRadius', 538 => 'SharpenRadius' },
	'sharpness' => { 8 => [0x42,0x48], 10 => 0x72, 12 => 0x74, 38 => 0xf, 70 => 0x6, 81 => 0x2, 120 => 0xb, 121 => [0x3011,0x21], 127 => [0xa40a,0xfe56], 135 => 0x1001, 159 => 0x6b, 168 => 0x37, 175 => 'Sharpness', 200 => 0x21, 201 => 0x30, 202 => 0x26, 203 => 0x18, 208 => 0x3, 258 => 0x6, 276 => 0x32, 277 => 0x33, 278 => 0x39, 352 => 0x100f, 372 => 0x41, 411 => 0x21, 418 => 0xb, 439 => 0x26, 440 => 0x56, 441 => 0x40, 442 => 0x66, 446 => 0x22, 447 => [0x1003,0x1014], 457 => 0x11, 467 => 0x1c, 468 => 0x19, 481 => 0x2006, 513 => 0x52, 536 => 'Sharpness', 538 => 'Sharpness', 542 => 'Sharpness' },
	'sharpnessadj' => { 111 => 0x20310, 116 => 0x25a, 518 => 0x801a },
	'sharpnessadjon' => { 111 => '0x20310.0' },
	'sharpnessauto' => { 78 => 0x94 },
	'sharpnessfactor' => { 352 => 0x102a },
	'sharpnessfaithful' => { 19 => 0xf5, 77 => 0x64, 78 => 0x64 },
	'sharpnessfrequency' => { 8 => [0x41,0x47], 81 => 0x3 },
	'sharpnesslandscape' => { 19 => 0xf3, 77 => 0x34, 78 => 0x34 },
	'sharpnessmonochrome' => { 19 => 0xf6, 77 => 0x7c, 78 => 0x7c },
	'sharpnessneutral' => { 19 => 0xf4, 77 => 0x4c, 78 => 0x4c },
	'sharpnessovershoot' => { 518 => 0x801b },
	'sharpnessportrait' => { 19 => 0xf2, 77 => 0x1c, 78 => 0x1c },
	'sharpnessrange' => { 481 => 0x2035 },
	'sharpnesssetting' => { 347 => 0x506, 355 => 0x1013, 469 => 0x12, 486 => 0xa },
	'sharpnessstandard' => { 19 => 0xf1, 77 => 0x4, 78 => 0x4 },
	'sharpnessstrength' => { 111 => 0x20311 },
	'sharpnessthreshold' => { 518 => 0x801d },
	'sharpnessundershoot' => { 518 => 0x801c },
	'sharpnessuserdef1' => { 19 => 0xf7, 77 => 0x94, 78 => 0xac },
	'sharpnessuserdef2' => { 19 => 0xf8, 77 => 0xac, 78 => 0xc4 },
	'sharpnessuserdef3' => { 19 => 0xf9, 77 => 0xc4, 78 => 0xdc },
	'shiftcols' => { 157 => 0xc70 },
	'shootid' => { 555 => 'shootID' },
	'shootingdistance' => { 111 => 0x20701 },
	'shootinginfodisplay' => { 325 => '13.2', 326 => '5.1', 334 => '10.2', 335 => '4.1', 338 => '5.1', 340 => '5.3' },
	'shootinginfomonitorofftime' => { 325 => '26.2', 326 => '22.2', 328 => '22.2', 329 => '22.2', 333 => '21.2', 334 => '9.1', 335 => '21.2', 338 => '22.2', 339 => '22.2', 340 => '22.2', 341 => 0x3d, 342 => 0x37, 343 => 0x37, 344 => 0x37 },
	'shootingmode' => { 175 => 'ShootingMode', 258 => 0x89, 372 => 0x1f },
	'shootingmodesetting' => { 327 => '5.1' },
	'shortdescription' => { 540 => 'shortdescription' },
	'shortdocumentid' => { 150 => 0xba },
	'shortname' => { 536 => 'ShortName', 538 => 'ShortName' },
	'shortownername' => { 19 => 0xac },
	'shortreleasetimelag' => { 92 => 0x80d },
	'shorttitle' => { 429 => '@sti' },
	'shotdate' => { 566 => 'shotDate' },
	'shotday' => { 566 => 'shotDay' },
	'shotlocation' => { 566 => 'shotLocation' },
	'shotlogdata' => { 142 => 'shot_log_data' },
	'shotname' => { 437 => 'shot', 566 => 'shotName' },
	'shotnumber' => { 416 => 0xa, 566 => 'shotNumber' },
	'shotnumbersincepowerup' => { 485 => 0x44e, 504 => 0x1a, 505 => 0x16, 506 => 0xa },
	'shotnumbersincepowerup2' => { 469 => 0x200 },
	'shotsize' => { 566 => 'shotSize' },
	'shotsperinterval' => { 247 => 0x180, 262 => 0x1f0, 263 => 0xb4, 264 => 0xcc, 267 => 0xc0, 268 => 0xd0, 269 => 0xd0 },
	'showmovement' => { 429 => 'shwm' },
	'shownevent' => { 550 => 'EventExt' },
	'showneventidentifier' => { 550 => [\'EventExt','EventExtIdentifier'] },
	'showneventname' => { 550 => [\'EventExt','EventExtName'] },
	'shutter' => { 500 => 0x20, 501 => 0x26, 502 => 0x26 },
	'shutter-aelock' => { 90 => 0x4, 92 => 0x701, 93 => 0x3, 94 => 0x4, 95 => 0x3, 96 => 0x3, 97 => 0x4, 98 => 0x2 },
	'shutteraelbutton' => { 91 => 0x4 },
	'shutterbuttonafonbutton' => { 92 => 0x701 },
	'shuttercount' => { 11 => 0x176, 30 => [0xa95,0x293], 33 => 0xaf1, 34 => 0xd29, 62 => 0x1, 258 => 0xa7, 289 => [0x6a,0x157,0x24d], 290 => 0x286, 291 => 0x279, 292 => 0x284, 293 => 0x242, 294 => 0x280, 295 => 0x276, 296 => [0x27d,0x27f], 297 => 0x246, 299 => 0x2d6, 300 => 0x321, 301 => 0xbd8, 302 => 0x287, 303 => 0x320, 304 => 0x24a, 305 => 0x5fb, 306 => 0x2d5, 411 => 0x5d, 478 => 0x846, 484 => [0x125,0x14a], 500 => [0xa,0x32], 501 => 0x3a, 502 => 0x3a, 503 => 0xa },
	'shuttercount2' => { 500 => 0x4c, 501 => [0x50,0x52,0x58], 502 => 0x50 },
	'shuttercount3' => { 500 => [0x1a0,0x1aa,0x1bd], 501 => [0x19f,0x1cb,0x1cd] },
	'shuttercurtainsync' => { 90 => 0xf, 91 => 0xf, 92 => 0x305, 93 => 0xe, 94 => 0xf, 95 => 0x8, 96 => 0x8, 97 => 0xf, 98 => 0x8 },
	'shuttermode' => { 62 => 0x17, 159 => 0x1b, 258 => 0x34 },
	'shutterreleasebuttonae-l' => { 325 => '17.7', 326 => '18.4', 328 => '78.4', 329 => '78.4', 330 => '16.1', 331 => '17.1', 332 => '17.1', 333 => '17.1', 334 => '7.1', 335 => '17.5', 338 => '18.4', 339 => '78.4', 340 => '18.2', 341 => 0x2b, 342 => 0x29, 343 => 0x29, 344 => 0x29 },
	'shutterreleasemethod' => { 105 => 0x1010 },
	'shutterreleasenocfcard' => { 90 => 0x2, 91 => 0x2, 98 => 0xf },
	'shutterreleasetiming' => { 105 => 0x1011 },
	'shutterreleasewithoutlens' => { 92 => 0x711 },
	'shutterspeedlock' => { 326 => '38.1', 328 => '38.1', 329 => '38.1', 338 => '38.1', 339 => '38.1', 341 => 0xbb, 342 => 0xb7, 343 => 0xb7, 344 => 0xb7 },
	'shutterspeedrange' => { 92 => 0x10c },
	'shutterspeedsetting' => { 203 => 0x6, 467 => 0x2f, 468 => 0x28, 469 => 0x0 },
	'shutterspeedvalue' => { 101 => 0x1, 127 => 0x9201, 352 => 0x1000, 420 => 0x400, 542 => 'ShutterSpeedValue' },
	'shuttertype' => { 135 => 0x1050, 372 => 0x9f, 411 => 0x87, 506 => [0x133,0x139,0x13f] },
	'sidecarforextension' => { 554 => 'SidecarForExtension' },
	'sigmaimpulseparameters' => { 157 => 0xe0d },
	'sigmascalingfactorcamera' => { 157 => 0xe0c },
	'sigmascalingfactorlowres' => { 157 => 0xe0b },
	'sigmasizetable' => { 157 => 0xe0f },
	'signaltonoiseratio' => { 1 => 0x27 },
	'signaltonoiseratiotype' => { 1 => 0x26 },
	'silentphotography' => { 258 => 0xbf, 262 => 0x9b7 },
	'similarityindex' => { 150 => 0xe4 },
	'singleframebracketing' => { 203 => 0x21 },
	'skilllevel' => { 558 => 'skillLevel' },
	'skintonecorrection' => { 411 => 0x95 },
	'skiplinetime' => { 157 => 0x184e },
	'slaveflashmeteringsegments' => { 411 => 0x20b },
	'slideshowname' => { 555 => 'slideshowName' },
	'slideshownumber' => { 555 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 555 => 'slideshowTotalNumber' },
	'slot2jpgsize' => { 262 => 0x364, 264 => 0x24a, 269 => 0x24a },
	'slowshutter' => { 84 => 0x8 },
	'slowsync' => { 135 => 0x1030 },
	'smartalbumcolor' => { 454 => 0x20 },
	'smartrange' => { 454 => 0xa012 },
	'smileshutter' => { 469 => 0x31 },
	'smileshuttermode' => { 469 => 0x27 },
	'smoothness' => { 127 => 0xfe57, 536 => 'Smoothness', 538 => 'Smoothness' },
	'snapshot' => { 550 => 'SnapshotLink' },
	'snapshotformat' => { 550 => [\'SnapshotLink','SnapshotLinkFormat'] },
	'snapshotheightpixels' => { 550 => [\'SnapshotLink','SnapshotLinkHeightPixels'] },
	'snapshotimagerole' => { 550 => [\'SnapshotLink','SnapshotLinkImageRole'] },
	'snapshotlink' => { 550 => [\'SnapshotLink','SnapshotLinkLink'] },
	'snapshotlinkqualifier' => { 550 => [\'SnapshotLink','SnapshotLinkLinkQualifier'] },
	'snapshots' => { 530 => 'Snapshots' },
	'snapshotusedvideoframe' => { 550 => [\'SnapshotLink','SnapshotLinkUsedVideoFrame'] },
	'snapshotusedvideoframetimeformat' => { 550 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeFormat'] },
	'snapshotusedvideoframetimevalue' => { 550 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameTimeValue'] },
	'snapshotusedvideoframevalue' => { 550 => [\'SnapshotLink','SnapshotLinkUsedVideoFrameValue'] },
	'snapshotwidthpixels' => { 550 => [\'SnapshotLink','SnapshotLinkWidthPixels'] },
	'softskineffect' => { 481 => 0x200f },
	'software' => { 127 => 0x131, 145 => 'Software', 176 => 'Software', 361 => 'Software', 420 => 0x203, 431 => 'software', 457 => 0x18, 562 => 'Software' },
	'softwareversion' => { 437 => ['@swr',"\xa9swr"], 456 => 0x207 },
	'soloist' => { 429 => "\xa9sol" },
	'songwriter' => { 437 => "\xa9swf" },
	'songwriterkeywords' => { 437 => "\xa9swk" },
	'sonycropsize' => { 127 => 0x74c8 },
	'sonycroptopleft' => { 127 => 0x74c7 },
	'sonydatetime' => { 489 => 0x6, 491 => 0x1b6, 492 => 0x210, 493 => 0x1fe, 494 => 0x22c },
	'sonydatetime2' => { 500 => 0x51 },
	'sonyexposuretime' => { 500 => 0x3a, 501 => 0x46, 502 => [0x66,0x46], 503 => 0x1a },
	'sonyexposuretime2' => { 513 => 0xe },
	'sonyfnumber' => { 500 => 0x3c, 501 => 0x48, 502 => [0x68,0x48], 503 => 0x1c, 513 => 0x14 },
	'sonyimageheight' => { 489 => 0x1a, 504 => 0x44, 505 => 0x3f },
	'sonyimageheightmax' => { 513 => 0x40 },
	'sonyimagesize' => { 203 => 0x3b, 467 => 0x54, 468 => 0x54, 469 => 0x9 },
	'sonyimagewidth' => { 489 => 0x1c },
	'sonyimagewidthmax' => { 513 => 0x3e },
	'sonyiso' => { 491 => 0x1218, 492 => 0x11f4, 493 => 0x1270, 494 => [0x1254,0x1258,0x1280], 495 => 0x113c, 496 => 0x344, 497 => 0x346, 498 => 0x320, 513 => 0x4 },
	'sonymaxaperture' => { 500 => 0x0, 501 => 0x0 },
	'sonymaxaperturevalue' => { 513 => 0x16 },
	'sonyminaperture' => { 500 => 0x1, 501 => 0x1 },
	'sonymodelid' => { 481 => 0xb001 },
	'sonyquality' => { 203 => 0x3c },
	'sonyrawimagesize' => { 127 => 0x7038 },
	'sonytimeminsec' => { 501 => 0x61 },
	'sortalbum' => { 429 => 'soal' },
	'sortalbumartist' => { 429 => 'soaa' },
	'sortartist' => { 429 => 'soar' },
	'sortcomposer' => { 429 => 'soco' },
	'sortname' => { 429 => 'sonm', 536 => 'SortName', 538 => 'SortName' },
	'sortshow' => { 429 => 'sosn' },
	'soundengineer' => { 429 => "\xa9sne" },
	'source' => { 150 => 0x73, 361 => 'Source', 539 => 'source', 540 => 'source', 554 => 'Source' },
	'sourcecount' => { 149 => 'SourceCount' },
	'sourcecredits' => { 437 => "\xa9src" },
	'sourcedirectoryindex' => { 397 => 0x0 },
	'sourcefileindex' => { 397 => 0x2 },
	'sourcemodified' => { 357 => 'SourceModified', 553 => 'SourceModified' },
	'sourcephotoscount' => { 148 => 'SourcePhotosCount' },
	'sourceprofileprefix' => { 157 => 0x1390 },
	'spatialfrequencyresponse' => { 542 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 542 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 542 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 542 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 542 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 566 => 'speakerPlacement' },
	'specialeffectlevel' => { 121 => 0x3030 },
	'specialeffectmode' => { 121 => 0x2076 },
	'specialeffectsetting' => { 121 => 0x3031 },
	'specialinstructions' => { 150 => 0x28 },
	'specialmode' => { 352 => 0x200, 456 => 0x200 },
	'specialoccasion' => { 558 => 'specialOccasion' },
	'specialtypeid' => { 142 => 'SpecialTypeID' },
	'spectralsensitivity' => { 127 => 0x8824, 542 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 45 => 0x32b, 46 => 0x281, 47 => 0x295, 50 => [0x2b9,0x2d0,0x2d4], 51 => [0x56a,0x296], 52 => 0x1e4, 53 => [0x1fd,0x2dd], 54 => [0x231,0x30f], 55 => 0x31d },
	'speedx' => { 123 => 0x3, 437 => "\xa9xsp" },
	'speedy' => { 123 => 0x4, 437 => "\xa9ysp" },
	'speedz' => { 123 => 0x5, 437 => "\xa9zsp" },
	'spherical' => { 149 => 'Spherical' },
	'sphericalvideoxml' => { 128 => 'SphericalVideoXML' },
	'splitcolumn' => { 420 => 0x222 },
	'splittoningbalance' => { 536 => 'SplitToningBalance', 538 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 536 => 'SplitToningHighlightHue', 538 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 536 => 'SplitToningHighlightSaturation', 538 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 536 => 'SplitToningShadowHue', 538 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 536 => 'SplitToningShadowSaturation', 538 => 'SplitToningShadowSaturation' },
	'sport' => { 556 => 'sport' },
	'sportevents' => { 2 => 0x1e },
	'spotfocuspointx' => { 200 => 0x2d },
	'spotfocuspointy' => { 200 => 0x2e },
	'spotmeteringmode' => { 38 => 0x27 },
	'spotmeterlinktoafpoint' => { 92 => 0x107 },
	'sractive' => { 390 => '17.1' },
	'srawquality' => { 38 => 0x2e },
	'srfocallength' => { 413 => 0x3 },
	'srgbrendering' => { 359 => 'sRGB' },
	'srhalfpresstime' => { 413 => 0x2 },
	'srresult' => { 413 => 0x0, 414 => 0x0 },
	'stackedimage' => { 347 => 0x804 },
	'standardmatrixcustom' => { 157 => 0x7d4 },
	'standardmatrixdaylight' => { 157 => 0x7d0 },
	'standardmatrixflash' => { 157 => 0x7d3 },
	'standardmatrixfluorescent' => { 157 => 0x7d2 },
	'standardmatrixtungsten' => { 157 => 0x7d1 },
	'standardoutputhighlightpoint' => { 117 => 0x14 },
	'standardoutputsensitivity' => { 127 => 0x8831, 543 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 117 => 0x15 },
	'standardrawcolortone' => { 117 => 0xd },
	'standardrawcontrast' => { 117 => 0xf },
	'standardrawhighlight' => { 117 => 0x75 },
	'standardrawhighlightpoint' => { 117 => 0x12 },
	'standardrawlinear' => { 117 => 0x10 },
	'standardrawsaturation' => { 117 => 0xe },
	'standardrawshadow' => { 117 => 0x7e },
	'standardrawshadowpoint' => { 117 => 0x13 },
	'standardrawsharpness' => { 117 => 0x11 },
	'standardunsharpmaskfineness' => { 117 => 0x94 },
	'standardunsharpmaskstrength' => { 117 => 0x92 },
	'standardunsharpmaskthreshold' => { 117 => 0x96 },
	'standardwhitecustom' => { 157 => 0x838 },
	'standardwhitedaylight' => { 157 => 0x834 },
	'standardwhiteflash' => { 157 => 0x837 },
	'standardwhitefluorescent' => { 157 => 0x836 },
	'standardwhitetungsten' => { 157 => 0x835 },
	'standbytimer' => { 326 => '19.1', 328 => '19.1', 329 => '19.1', 332 => '18.1', 333 => '18.1', 338 => '19.1', 339 => '19.1' },
	'starlightview' => { 342 => 0x249, 343 => 0x249, 344 => 0x261 },
	'startingpage' => { 556 => 'startingPage' },
	'startmovieshooting' => { 92 => 0x70d },
	'starttimecode' => { 437 => "\xa9TIM", 566 => 'startTimecode' },
	'starttimecodetimeformat' => { 566 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 566 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 566 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 437 => "\xa9TSZ", 566 => 'startTimeSampleSize' },
	'starttimescale' => { 437 => "\xa9TSC", 566 => 'startTimeScale' },
	'state' => { 180 => 'State', 372 => 0x6b, 554 => 'State' },
	'status' => { 523 => 'Status', 528 => 'Status' },
	'stepcropshooting' => { 481 => 0x205c },
	'stereomode' => { 149 => 'StereoMode' },
	'stitched' => { 149 => 'Stitched' },
	'stitchingsoftware' => { 148 => 'StitchingSoftware', 149 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 490 => 0x113e, 491 => 0x113e, 492 => 0x111a, 493 => 0x1196, 494 => 0x1172, 495 => 0x102a, 496 => 0x222, 497 => 0x222, 498 => 0x217, 513 => 0xa },
	'storagemethod' => { 207 => 0x12 },
	'storebyorientation' => { 326 => '46.3', 328 => '47.3', 329 => '47.3', 338 => '47.3', 339 => '47.3', 341 => 0xd, 342 => 0xd, 343 => 0xd, 344 => 0xd },
	'storedescription' => { 429 => 'sdes' },
	'storedformat' => { 531 => 'StoredFormat' },
	'storylineidentifier' => { 550 => 'StorylineIdentifier' },
	'straightenangle' => { 318 => 0x2fc08431 },
	'streamready' => { 550 => 'StreamReady' },
	'streamtype' => { 195 => 'StreamType' },
	'stretchmode' => { 566 => 'stretchMode' },
	'studydatetime' => { 521 => 'StudyDateTime' },
	'studydescription' => { 521 => 'StudyDescription' },
	'studyid' => { 521 => 'StudyID' },
	'studyphysician' => { 521 => 'StudyPhysician' },
	'styleperiod' => { 550 => 'StylePeriod' },
	'sub-location' => { 150 => 0x5c },
	'subcommanddialframeadvancezoom' => { 269 => 0x806 },
	'subcommanddialplaybackmode' => { 342 => 0x1cf, 343 => 0x1cf, 344 => 0x1e7 },
	'subcommanddialvideoplaybackmode' => { 342 => 0x1d1, 344 => 0x1e9 },
	'subfiledata' => { 183 => 'data' },
	'subfiledirectory' => { 183 => '1Directory' },
	'subfilemimetype' => { 183 => '2MIME' },
	'subfilename' => { 183 => '1Name' },
	'subfileresource' => { 183 => 'rsrc' },
	'subfiletype' => { 127 => 0xfe, 183 => '0Type' },
	'subject' => { 357 => 'Subject', 427 => 'Subject', 539 => 'subject', 552 => 'Subject', 567 => 'subject' },
	'subjectarea' => { 127 => 0x9214, 542 => 'SubjectArea' },
	'subjectcode' => { 549 => 'SubjectCode' },
	'subjectdetectarea' => { 356 => 0x2 },
	'subjectdetectdetail' => { 356 => 0x6 },
	'subjectdetectframesize' => { 356 => 0x0 },
	'subjectdetectinfo' => { 347 => 0x30b },
	'subjectdetection' => { 262 => 0x36e, 264 => 0x252, 267 => 0x23e, 268 => 0x252, 269 => 0x252 },
	'subjectdetectionareamf' => { 262 => 0x3ea },
	'subjectdetectstatus' => { 356 => 0xa },
	'subjectdistance' => { 127 => 0x9206, 159 => 0x3e, 542 => 'SubjectDistance' },
	'subjectdistancerange' => { 127 => 0xa40c, 542 => 'SubjectDistanceRange' },
	'subjectlocation' => { 127 => 0xa214, 542 => 'SubjectLocation' },
	'subjectmotion' => { 328 => '78.2', 329 => '78.2', 339 => '78.2', 342 => 0x103, 343 => 0x103, 344 => 0x119 },
	'subjectprogram' => { 200 => 0x22 },
	'subjectrecognition' => { 383 => 0x960 },
	'subjectreference' => { 150 => 0xc },
	'subjectswitching' => { 2 => 0x15 },
	'subjecttodetect' => { 2 => 0x14 },
	'sublabels1' => { 548 => [\'TagStructure','TagStructureSubLabels'] },
	'sublabels2' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublabels3' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'sublabels4' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 548 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'subseccreatedate' => { 122 => 'Exif-SubSecCreateDate' },
	'subsecdatetimeoriginal' => { 122 => 'Exif-SubSecDateTimeOriginal' },
	'subsecmodifydate' => { 122 => 'Exif-SubSecModifyDate' },
	'subsectime' => { 127 => 0x9290 },
	'subsectimedigitized' => { 127 => 0x9292 },
	'subsectimeoriginal' => { 127 => 0x9291 },
	'subsection1' => { 556 => 'subsection1' },
	'subsection2' => { 556 => 'subsection2' },
	'subsection3' => { 556 => 'subsection3' },
	'subsection4' => { 556 => 'subsection4' },
	'subselector' => { 326 => '49.1', 328 => '71.1', 329 => '71.1', 339 => '71.1', 341 => 0x93, 342 => 0x8f, 343 => 0x8f, 344 => 0x8f },
	'subselectorassignment' => { 326 => '48.1' },
	'subselectorcenter' => { 328 => '72.1', 329 => '72.1', 339 => '72.1' },
	'subselectorplusdials' => { 326 => '49.2', 328 => '73.1', 329 => '73.1', 339 => '73.1' },
	'subtitle' => { 198 => 'WM/SubTitle', 429 => "\xa9st3", 437 => "\xa9snm", 556 => 'subtitle' },
	'subtitlekeywords' => { 437 => "\xa9snk" },
	'subversionfilename' => { 548 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 548 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 548 => 'SubVersions' },
	'superimposeddisplay' => { 90 => 0xa, 92 => 0x510, 93 => 0x9, 94 => 0xa, 97 => 0xa, 98 => 0xe },
	'supermacro' => { 71 => 0x1a },
	'supplementalcategories' => { 150 => 0x14, 554 => 'SupplementalCategories' },
	'supplementaltype' => { 152 => 0x37 },
	'supplementdisplayid' => { 556 => 'supplementDisplayID' },
	'supplementstartingpage' => { 556 => 'supplementStartingPage' },
	'supplementtitle' => { 556 => 'supplementTitle' },
	'supplychainsource' => { 550 => 'SupplyChainSource' },
	'supplychainsourceidentifier' => { 550 => [\'SupplyChainSource','SupplyChainSourceIdentifier'] },
	'supplychainsourcename' => { 550 => [\'SupplyChainSource','SupplyChainSourceName'] },
	'supportsamount' => { 536 => 'SupportsAmount', 538 => 'SupportsAmount' },
	'supportscolor' => { 536 => 'SupportsColor', 538 => 'SupportsColor' },
	'supportshighdynamicrange' => { 536 => 'SupportsHighDynamicRange', 538 => 'SupportsHighDynamicRange' },
	'supportsmonochrome' => { 536 => 'SupportsMonochrome', 538 => 'SupportsMonochrome' },
	'supportsnormaldynamicrange' => { 536 => 'SupportsNormalDynamicRange', 538 => 'SupportsNormalDynamicRange' },
	'supportsoutputreferred' => { 536 => 'SupportsOutputReferred', 538 => 'SupportsOutputReferred' },
	'supportsscenereferred' => { 536 => 'SupportsSceneReferred', 538 => 'SupportsSceneReferred' },
	'svisosetting' => { 390 => 0x14 },
	'swatchcoloranta' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsA'] },
	'swatchcolorantb' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsB'] },
	'swatchcolorantblack' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsBlack'] },
	'swatchcolorantblue' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsBlue'] },
	'swatchcolorantcyan' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsCyan'] },
	'swatchcolorantgray' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsGray'] },
	'swatchcolorantgreen' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsGreen'] },
	'swatchcolorantl' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsL'] },
	'swatchcolorantmagenta' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsMagenta'] },
	'swatchcolorantmode' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsMode'] },
	'swatchcolorantred' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsRed'] },
	'swatchcolorantswatchname' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsSwatchName'] },
	'swatchcoloranttint' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsTint'] },
	'swatchcoloranttype' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsType'] },
	'swatchcolorantyellow' => { 571 => [\'SwatchGroups','SwatchGroupsColorantsYellow'] },
	'swatchgroupname' => { 571 => [\'SwatchGroups','SwatchGroupsGroupName'] },
	'swatchgroups' => { 571 => 'SwatchGroups' },
	'swatchgroupscolorants' => { 571 => [\'SwatchGroups','SwatchGroupsColorants'] },
	'swatchgrouptype' => { 571 => [\'SwatchGroups','SwatchGroupsGroupType'] },
	'sweeppanoramadirection' => { 372 => 0x93, 469 => 0x33 },
	'sweeppanoramafieldofview' => { 372 => 0x94 },
	'sweeppanoramasize' => { 469 => 0x32 },
	'switchtoregisteredafpoint' => { 91 => 0x12, 92 => 0x50a },
	'symlink' => { 128 => 'SymLink' },
	'syncreleasemode' => { 328 => '77.1', 329 => '77.1', 339 => '77.1', 341 => 0x45, 342 => 0x41, 343 => 0x41, 344 => 0x41 },
	'system' => { 420 => 0x204 },
	'tagged' => { 422 => 0xdd, 423 => 'Tagged', 530 => 'tagged' },
	'tagslist' => { 541 => 'TagsList' },
	'tagstructure' => { 548 => 'TagStructure' },
	'takenumber' => { 566 => 'takeNumber' },
	'tapename' => { 566 => 'tapeName' },
	'targetaperture' => { 84 => 0x4 },
	'targetaspectratio' => { 362 => 'TargetAspectRatio' },
	'targetcompressionratio' => { 103 => 0x1 },
	'targetdistancesetting' => { 105 => 0x1807 },
	'targetexposuretime' => { 84 => 0x5 },
	'targetimagetype' => { 105 => 0x100a },
	'targetprinter' => { 127 => 0x151 },
	'taxon' => { 126 => 'Taxon' },
	'taxonacceptednameusage' => { 126 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 126 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 126 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 126 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxoncultivarepithet' => { 126 => [\'Taxon','TaxonCultivarEpithet'] },
	'taxonfamily' => { 126 => [\'Taxon','TaxonFamily'] },
	'taxongenericname' => { 126 => [\'Taxon','TaxonGenericName'] },
	'taxongenus' => { 126 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 126 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 126 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfragenericepithet' => { 126 => [\'Taxon','TaxonInfragenericEpithet'] },
	'taxoninfraspecificepithet' => { 126 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 126 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 126 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 126 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 126 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 126 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 126 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 126 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 126 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 126 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 126 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 126 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 126 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 126 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 126 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 126 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 126 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 126 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 126 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 126 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 126 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubfamily' => { 126 => [\'Taxon','TaxonSubFamily'] },
	'taxonsubgenus' => { 126 => [\'Taxon','TaxonSubgenus'] },
	'taxonsubtribe' => { 126 => [\'Taxon','TaxonSubTribe'] },
	'taxonsuperfamily' => { 126 => [\'Taxon','TaxonSuperFamily'] },
	'taxontaxonomicstatus' => { 126 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxontribe' => { 126 => [\'Taxon','TaxonTribe'] },
	'taxonverbatimtaxonrank' => { 126 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 126 => [\'Taxon','TaxonVernacularName'] },
	'tda1bandwidth' => { 157 => 0x196f },
	'tda1edgepolarity' => { 157 => 0x1971 },
	'tda1gain' => { 157 => 0x1970 },
	'tda1offset' => { 157 => 0x196e },
	'tda2bandwidth' => { 157 => 0x1979 },
	'tda2edgepolarity' => { 157 => 0x197b },
	'tda2gain' => { 157 => 0x197a },
	'tda2offset' => { 157 => 0x1978 },
	'tda3bandwidth' => { 157 => 0x1983 },
	'tda3edgepolarity' => { 157 => 0x1985 },
	'tda3gain' => { 157 => 0x1984 },
	'tda3offset' => { 157 => 0x1982 },
	'tda4bandwidth' => { 157 => 0x198d },
	'tda4edgepolarity' => { 157 => 0x198f },
	'tda4gain' => { 157 => 0x198e },
	'tda4offset' => { 157 => 0x198c },
	'teaser' => { 556 => 'teaser' },
	'teleconverter' => { 205 => 0x105, 481 => 0x105 },
	'tempampgainx100' => { 157 => 0x1914 },
	'tempo' => { 566 => 'tempo' },
	'temporalcoverage' => { 550 => 'TemporalCoverage' },
	'temporalcoveragefrom' => { 550 => [\'TemporalCoverage','TemporalCoverageTempCoverageFrom'] },
	'temporalcoverageto' => { 550 => [\'TemporalCoverage','TemporalCoverageTempCoverageTo'] },
	'termsandconditionstext' => { 358 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 358 => 'TermsAndConditionsURL' },
	'testname' => { 128 => 'TestName' },
	'textencoding' => { 257 => 0x4 },
	'textlayername' => { 554 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 554 => 'TextLayers' },
	'textlayertext' => { 554 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 372 => [0x8008,0x8009,0x3b,0x3e] },
	'texture' => { 536 => 'Texture', 538 => 'Texture' },
	'three-dtrackingfacedetection' => { 328 => '1.4', 329 => '1.4', 339 => '1.4' },
	'three-dtrackingwatcharea' => { 328 => '78.1', 329 => '78.1', 339 => '78.1' },
	'thresholding' => { 127 => 0x107 },
	'thumbnailfilename' => { 105 => 0x817 },
	'thumbnailformat' => { 564 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 161 => 0xfa55, 564 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 6 => 'CNDA', 105 => 0x2008, 122 => 'Exif-ThumbnailImage', 130 => 0x3, 186 => 'data', 352 => 0x100, 429 => 'tnal', 437 => 'thmb', 564 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 186 => '1Name' },
	'thumbnailimagesize' => { 186 => 'ImageSize' },
	'thumbnailimagetype' => { 186 => '0Type' },
	'thumbnailimagevalidarea' => { 71 => 0x13 },
	'thumbnaillength' => { 127 => 0x202 },
	'thumbnailoffset' => { 127 => 0x201 },
	'thumbnailpng' => { 437 => 'thmb' },
	'thumbnails' => { 564 => 'Thumbnails' },
	'thumbnailwidth' => { 161 => 0xfa54, 564 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 556 => 'ticker' },
	'tiffhandling' => { 536 => 'TIFFHandling', 538 => 'TIFFHandling' },
	'tiffmeteringimage' => { 206 => 0x104c, 478 => 0x1110 },
	'tilelength' => { 127 => 0x143 },
	'tilewidth' => { 127 => 0x142 },
	'time' => { 157 => 0x401, 411 => 0x7 },
	'timecodes' => { 127 => 0xc763 },
	'timecreated' => { 150 => 0x3c, 159 => 0x14, 168 => 0x10, 423 => 'TimeCreated' },
	'timelapseshotnumber' => { 375 => 0x10 },
	'timeperiod' => { 556 => 'timePeriod' },
	'timerfunctionbutton' => { 327 => '5.2', 330 => '12.1', 331 => '13.1' },
	'timerlength' => { 92 => 0x80c },
	'timerrecording' => { 372 => 0x96 },
	'timescaleparams' => { 566 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 566 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 566 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 566 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 151 => 0x50 },
	'timeshot' => { 524 => 'TimeShot' },
	'timesignature' => { 566 => 'timeSignature' },
	'timesincepoweron' => { 372 => 0x29 },
	'timestamp' => { 11 => 0x45e, 19 => 0x11c, 149 => 'Timestamp', 345 => 0x8, 361 => 'TimeStamp', 372 => 0xaf, 532 => 'Timestamp', 548 => 'TimeStamp' },
	'timestamp1' => { 11 => 0x45a },
	'timezone' => { 85 => 0x1, 262 => 0x8fe, 265 => 0x694, 266 => 0x6a4, 267 => 0x594, 268 => 0x5c4, 269 => 0x5dc, 310 => 0x0, 450 => 0xa },
	'timezonecity' => { 85 => 0x2 },
	'timezonecode' => { 108 => 0x1 },
	'timezoneinfo' => { 108 => 0x2 },
	'timezoneoffset' => { 127 => 0x882a },
	'tint' => { 431 => 'player.movie.visual.tint', 536 => 'Tint', 538 => 'Tint' },
	'title' => { 176 => 'Title', 357 => 'Title', 361 => 'Title', 372 => 0x65, 427 => 'Title', 429 => ['titl',"\xa9nam"], 431 => 'title', 437 => ['titl',"\xa9nam"], 539 => 'title', 552 => 'Title', 564 => 'Title' },
	'togglestyleamount' => { 536 => 'ToggleStyleAmount', 538 => 'ToggleStyleAmount' },
	'togglestyledigest' => { 536 => 'ToggleStyleDigest', 538 => 'ToggleStyleDigest' },
	'tonecomp' => { 258 => 0x81 },
	'tonecurve' => { 81 => 0x1, 411 => 0x402, 536 => 'ToneCurve', 538 => 'ToneCurve' },
	'tonecurveactive' => { 116 => 0x110 },
	'tonecurveadobergb' => { 454 => 0xa043 },
	'tonecurveadobergbdefault' => { 454 => 0xa041 },
	'tonecurveblue' => { 536 => 'ToneCurveBlue', 538 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 518 => 0x9003 },
	'tonecurvebluey' => { 518 => 0x9007 },
	'tonecurvebrightness' => { 111 => 0x20410 },
	'tonecurvebrightnessx' => { 518 => 0x9000 },
	'tonecurvebrightnessy' => { 518 => 0x9004 },
	'tonecurvecolorspace' => { 115 => 0x0 },
	'tonecurvecontrast' => { 111 => 0x20411 },
	'tonecurvegreen' => { 536 => 'ToneCurveGreen', 538 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 518 => 0x9002 },
	'tonecurvegreeny' => { 518 => 0x9006 },
	'tonecurveinputrange' => { 115 => 0x3 },
	'tonecurveinterpolation' => { 116 => 0x159 },
	'tonecurvemode' => { 116 => 0x113 },
	'tonecurvename' => { 536 => 'ToneCurveName', 538 => 'ToneCurveName' },
	'tonecurvename2012' => { 536 => 'ToneCurveName2012', 538 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 111 => '0x20400.1' },
	'tonecurveoutputrange' => { 115 => 0x5 },
	'tonecurveprofilename' => { 157 => 0x1391 },
	'tonecurveproperty' => { 116 => 0x3c },
	'tonecurvepv2012' => { 536 => 'ToneCurvePV2012', 538 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 536 => 'ToneCurvePV2012Blue', 538 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 536 => 'ToneCurvePV2012Green', 538 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 536 => 'ToneCurvePV2012Red', 538 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 536 => 'ToneCurveRed', 538 => 'ToneCurveRed' },
	'tonecurveredx' => { 518 => 0x9001 },
	'tonecurveredy' => { 518 => 0x9005 },
	'tonecurves' => { 411 => 0x403 },
	'tonecurveshape' => { 115 => 0x1 },
	'tonecurvesrgb' => { 454 => 0xa042 },
	'tonecurvesrgbdefault' => { 454 => 0xa040 },
	'tonecurvex' => { 115 => 0xa },
	'tonecurvey' => { 115 => 0xb },
	'tonelevel' => { 347 => 0x52e },
	'tonemap' => { 262 => 0x374, 264 => 0x26a },
	'tonemapstrength' => { 536 => 'ToneMapStrength', 538 => 'ToneMapStrength' },
	'toningeffect' => { 62 => 0xf, 258 => 0xb3, 276 => 0x38, 277 => 0x40, 278 => 0x48, 447 => 0x1015 },
	'toningeffectauto' => { 78 => 0xa4 },
	'toningeffectfaithful' => { 77 => 0x74, 78 => 0x74 },
	'toningeffectlandscape' => { 77 => 0x44, 78 => 0x44 },
	'toningeffectmonochrome' => { 19 => 0x108, 77 => 0x8c, 78 => 0x8c },
	'toningeffectneutral' => { 77 => 0x5c, 78 => 0x5c },
	'toningeffectportrait' => { 77 => 0x2c, 78 => 0x2c },
	'toningeffectstandard' => { 77 => 0x14, 78 => 0x14 },
	'toningeffectuserdef1' => { 77 => 0xa4, 78 => 0xbc },
	'toningeffectuserdef2' => { 77 => 0xbc, 78 => 0xd4 },
	'toningeffectuserdef3' => { 77 => 0xd4, 78 => 0xec },
	'toningsaturation' => { 276 => 0x39, 277 => 0x41, 278 => 0x49 },
	'totalzoom' => { 159 => 0x62 },
	'touchae' => { 372 => 0xab },
	'touchfn' => { 341 => 0x154 },
	'touchfnareatall' => { 341 => 0x15b },
	'touchfnareawide' => { 341 => 0x159 },
	'touchfnrole' => { 341 => 0x155 },
	'track' => { 429 => "\xa9trk", 437 => "\xa9trk" },
	'trackcreatedate' => { 436 => 0x1 },
	'trackmodifydate' => { 436 => 0x2 },
	'trackname' => { 437 => 'tnam' },
	'tracknumber' => { 429 => 'trkn', 566 => 'trackNumber' },
	'tracks' => { 566 => 'Tracks' },
	'tracksframerate' => { 566 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 566 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 566 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 566 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 566 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 566 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 566 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 566 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 566 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 566 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 566 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 566 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 566 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 566 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 566 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 566 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 566 => [\'Tracks','TracksTrackType'] },
	'tracktype' => { 437 => 'kgtt' },
	'trailer' => { 128 => 'Trailer' },
	'trailersignature' => { 183 => 'zmie' },
	'transcript' => { 550 => 'Transcript' },
	'transcriptlink' => { 550 => 'TranscriptLink' },
	'transcriptlinklink' => { 550 => [\'TranscriptLink','TranscriptLinkLink'] },
	'transcriptlinklinkqualifier' => { 550 => [\'TranscriptLink','TranscriptLinkLinkQualifier'] },
	'transferfunction' => { 127 => 0x12d, 562 => 'TransferFunction' },
	'transfertimenormal' => { 157 => 0x1888 },
	'transfertimetest' => { 157 => 0x1889 },
	'transform' => { 372 => [0x8012,0x59] },
	'transformation' => { 551 => 'Transformation' },
	'transmissionreference' => { 554 => 'TransmissionReference' },
	'trapped' => { 357 => 'Trapped', 552 => 'Trapped' },
	'trashbuttonfunction' => { 92 => 0x710 },
	'travelday' => { 372 => 0x36 },
	'treble' => { 428 => 'player.movie.audio.treble', 431 => 'player.movie.audio.treble' },
	'triggermode' => { 439 => 0x6, 440 => 0x34, 441 => 0x28, 442 => 0x44, 443 => 0x34 },
	'tstop' => { 127 => 0xc772 },
	'ttl_da_adown' => { 398 => 0x5 },
	'ttl_da_aup' => { 398 => 0x4 },
	'ttl_da_bdown' => { 398 => 0x7 },
	'ttl_da_bup' => { 398 => 0x6 },
	'tungstenawb' => { 386 => 0x1 },
	'tvepisode' => { 429 => 'tves' },
	'tvepisodeid' => { 429 => 'tven' },
	'tvexposuretimesetting' => { 390 => 0x12 },
	'tvnetworkname' => { 429 => 'tvnn' },
	'tvseason' => { 429 => 'tvsn' },
	'tvshow' => { 429 => 'tvsh' },
	'type' => { 144 => 'Type', 539 => 'type', 561 => 'type' },
	'typestatus' => { 126 => [\'Identification','IdentificationTypeStatus'] },
	'uibfirmwareversion' => { 441 => 0x21 },
	'uniquecameramodel' => { 127 => 0xc614 },
	'uniquedocumentid' => { 150 => 0xbb },
	'uniquematrixauto' => { 157 => 0x7e9 },
	'uniquematrixcustom' => { 157 => 0x7e8 },
	'uniquematrixdaylight' => { 157 => 0x7e4 },
	'uniquematrixflash' => { 157 => 0x7e7 },
	'uniquematrixfluorescent' => { 157 => 0x7e6 },
	'uniquematrixtungsten' => { 157 => 0x7e5 },
	'uniqueobjectname' => { 151 => 0x64 },
	'units' => { 145 => 'Units' },
	'unknown_aacr' => { 429 => 'AACR' },
	'unknown_cdek' => { 429 => 'CDEK' },
	'unknown_cdet' => { 429 => 'CDET' },
	'unknownblock' => { 411 => 0x405 },
	'unknownblock1' => { 351 => 0x635 },
	'unknownblock2' => { 351 => 0x636 },
	'unknownblock3' => { 351 => 0x1103 },
	'unknownblock4' => { 351 => 0x1104 },
	'unknowncontrast' => { 117 => 0x45 },
	'unknowndate' => { 420 => 0x212 },
	'unknownev' => { 157 => 0x1 },
	'unknownlinear' => { 117 => 0x46 },
	'unknownnumber' => { 105 => 0x180b },
	'unknownoutputhighlightpoint' => { 117 => 0x4a },
	'unknownoutputshadowpoint' => { 117 => 0x4b },
	'unknownrawhighlight' => { 117 => 0x7b },
	'unknownrawhighlightpoint' => { 117 => 0x48 },
	'unknownrawshadow' => { 117 => 0x84 },
	'unknownrawshadowpoint' => { 117 => 0x49 },
	'unknownsharpness' => { 117 => 0x47 },
	'unknowntags' => { 437 => 'TAGS' },
	'unknowntemperature' => { 129 => 0x4 },
	'unknownthumbnail' => { 437 => 'thmb' },
	'unsharp1color' => { 323 => 0x13 },
	'unsharp1halowidth' => { 323 => 0x19 },
	'unsharp1intensity' => { 323 => 0x17 },
	'unsharp1threshold' => { 323 => 0x1b },
	'unsharp2color' => { 323 => 0x2e },
	'unsharp2halowidth' => { 323 => 0x34 },
	'unsharp2intensity' => { 323 => 0x32 },
	'unsharp2threshold' => { 323 => 0x36 },
	'unsharp3color' => { 323 => 0x49 },
	'unsharp3halowidth' => { 323 => 0x4f },
	'unsharp3intensity' => { 323 => 0x4d },
	'unsharp3threshold' => { 323 => 0x51 },
	'unsharp4color' => { 323 => 0x64 },
	'unsharp4halowidth' => { 323 => 0x6a },
	'unsharp4intensity' => { 323 => 0x68 },
	'unsharp4threshold' => { 323 => 0x6c },
	'unsharpcount' => { 323 => 0x0 },
	'unsharpmask' => { 117 => 0x90, 318 => 0x76a43200 },
	'unsharpmaskfineness' => { 81 => 0xe, 111 => 0x20309 },
	'unsharpmaskstrength' => { 111 => 0x20308 },
	'unsharpmaskthreshold' => { 81 => 0xf, 111 => 0x2030a },
	'uprightcentermode' => { 536 => 'UprightCenterMode', 538 => 'UprightCenterMode' },
	'uprightcenternormx' => { 536 => 'UprightCenterNormX', 538 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 536 => 'UprightCenterNormY', 538 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 536 => 'UprightDependentDigest', 538 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 536 => 'UprightFocalLength35mm', 538 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 536 => 'UprightFocalMode', 538 => 'UprightFocalMode' },
	'uprightfoursegments_0' => { 536 => 'UprightFourSegments_0', 538 => 'UprightFourSegments_0' },
	'uprightfoursegments_1' => { 536 => 'UprightFourSegments_1', 538 => 'UprightFourSegments_1' },
	'uprightfoursegments_2' => { 536 => 'UprightFourSegments_2', 538 => 'UprightFourSegments_2' },
	'uprightfoursegments_3' => { 536 => 'UprightFourSegments_3', 538 => 'UprightFourSegments_3' },
	'uprightfoursegmentscount' => { 536 => 'UprightFourSegmentsCount', 538 => 'UprightFourSegmentsCount' },
	'uprightguideddependentdigest' => { 536 => 'UprightGuidedDependentDigest', 538 => 'UprightGuidedDependentDigest' },
	'uprightpreview' => { 536 => 'UprightPreview', 538 => 'UprightPreview' },
	'uprighttransform_0' => { 536 => 'UprightTransform_0', 538 => 'UprightTransform_0' },
	'uprighttransform_1' => { 536 => 'UprightTransform_1', 538 => 'UprightTransform_1' },
	'uprighttransform_2' => { 536 => 'UprightTransform_2', 538 => 'UprightTransform_2' },
	'uprighttransform_3' => { 536 => 'UprightTransform_3', 538 => 'UprightTransform_3' },
	'uprighttransform_4' => { 536 => 'UprightTransform_4', 538 => 'UprightTransform_4' },
	'uprighttransform_5' => { 536 => 'UprightTransform_5', 538 => 'UprightTransform_5' },
	'uprighttransformcount' => { 536 => 'UprightTransformCount', 538 => 'UprightTransformCount' },
	'uprightversion' => { 536 => 'UprightVersion', 538 => 'UprightVersion' },
	'urgency' => { 150 => 0xa, 554 => 'Urgency' },
	'url' => { 176 => 'URL', 361 => 'URL', 425 => 0x40b, 556 => 'url' },
	'url_list' => { 425 => 0x41e },
	'urla-platform' => { 556 => [\'url','urlA-platform'] },
	'urlurl' => { 556 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 92 => 0x10a },
	'usableshootingmodes' => { 92 => 0x109 },
	'usage' => { 557 => 'usage' },
	'usageterms' => { 570 => 'UsageTerms' },
	'usbpowerdelivery' => { 262 => 0x9ac, 265 => 0x762, 266 => 0x7c2, 267 => 0x664, 268 => 0x694, 269 => 0x6fc },
	'usedialwithouthold' => { 341 => 0xc3, 342 => 0xbf, 343 => 0xbf, 344 => 0xbf },
	'useguidelines' => { 534 => 'useGuidelines' },
	'usepanoramaviewer' => { 148 => 'UsePanoramaViewer' },
	'usercollection' => { 431 => 'collection.user' },
	'usercomment' => { 105 => 0x805, 127 => 0x9286, 542 => 'UserComment' },
	'userdef1picturestyle' => { 19 => 0x10c, 77 => 0xd8, 78 => 0xf0 },
	'userdef2picturestyle' => { 19 => 0x10e, 77 => 0xda, 78 => 0xf2 },
	'userdef3picturestyle' => { 19 => 0x110, 77 => 0xdc, 78 => 0xf4 },
	'userfields' => { 528 => 'UserFields' },
	'userlabel' => { 439 => 0x2b, 440 => 0x68, 441 => 0x51, 442 => 0x76, 443 => 0x5a },
	'userprofile' => { 367 => 0x302, 371 => 0x34c, 374 => 0x3038 },
	'userrating' => { 431 => 'rating.user', 437 => 'urat' },
	'usmlenselectronicmf' => { 2 => 0x7, 91 => 0x7, 92 => 0x501 },
	'uspsnumber' => { 556 => 'uspsNumber' },
	'utmeasting' => { 187 => 'Easting' },
	'utmmapdatum' => { 187 => 'Datum' },
	'utmnorthing' => { 187 => 'Northing' },
	'utmzone' => { 187 => 'Zone' },
	'uuid' => { 536 => 'UUID', 538 => 'UUID' },
	'uv-irfiltercorrection' => { 367 => 0x325 },
	'validbits' => { 351 => 0x611, 352 => 0x102c },
	'validcropcorners' => { 362 => 'ValidCropCorners' },
	'validpixeldepth' => { 355 => 0x611 },
	'variablelowpassfilter' => { 481 => 0x2028 },
	'variousmodes' => { 159 => 0x26 },
	'variousmodes2' => { 159 => 0x3a },
	'variprogram' => { 258 => 0xab },
	'varraydacnominalvalues' => { 157 => 0x191e },
	'vendor' => { 437 => 'vndr' },
	'vendorinfo' => { 140 => 'VendorInfo' },
	'vendorinfomanufacturer' => { 140 => [\'VendorInfo','VendorInfoManufacturer'] },
	'vendorinfomodel' => { 140 => [\'VendorInfo','VendorInfoModel'] },
	'vendorinfonotes' => { 140 => [\'VendorInfo','VendorInfoNotes'] },
	'verbatimidentification' => { 126 => [\'Identification','IdentificationVerbatimIdentification'] },
	'version' => { 135 => 0x0, 362 => 'Version', 427 => 'Version', 431 => 'version', 536 => 'Version', 538 => 'Version', 547 => 'Version' },
	'versioncreatedate' => { 518 => 0xd100 },
	'versionid' => { 567 => 'VersionID' },
	'versionidentifier' => { 556 => 'versionIdentifier' },
	'versionmodifydate' => { 518 => 0xd101 },
	'versions' => { 567 => 'Versions' },
	'versionscomments' => { 567 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 567 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 567 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 567 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 567 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 567 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 567 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 567 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 567 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 567 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 567 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 325 => '3.2', 326 => '47.2', 328 => '79.1', 343 => 0x11d, 344 => 0x135 },
	'verticalclockoverlaps' => { 157 => 0x412 },
	'verticalfuncbutton' => { 326 => '42.2', 328 => '67.1', 343 => 0x115, 344 => 0x12d },
	'verticalfuncbuttonplaybackmode' => { 343 => 0x1b7, 344 => 0x1cf },
	'verticalfuncbuttonplusdials' => { 326 => '43.1' },
	'verticalfuncplusdials' => { 328 => '68.1' },
	'verticalisobutton' => { 269 => 0x792 },
	'verticalmovieafonbutton' => { 343 => 0x1f9, 344 => 0x211 },
	'verticalmoviefuncbutton' => { 343 => 0x1e1, 344 => 0x1f9 },
	'verticalmultiselector' => { 326 => '42.1', 328 => '66.1', 329 => '66.1', 339 => '66.1', 343 => 0x18f, 344 => 0x1a7 },
	'verticalmultiselectorplaybackmode' => { 343 => 0x125, 344 => 0x13d },
	'vfdisplayillumination' => { 2 => 0x11, 92 => [0x510,0x51d] },
	'vibrance' => { 529 => 'Vibrance', 536 => 'Vibrance', 538 => 'Vibrance' },
	'vibrationreduction' => { 289 => [0x75,0x82,0x1ae], 297 => '586.1', 304 => '590.2', 308 => 0x4 },
	'videoalphamode' => { 566 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 566 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgray' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGray'] },
	'videoalphapremultiplecolorgreen' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 566 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 566 => 'videoAlphaUnityIsTransparent' },
	'videobitrate' => { 550 => 'videoBitRate' },
	'videobitratemode' => { 550 => 'videoBitRateMode' },
	'videoburstmode' => { 372 => 0xbb },
	'videoburstresolution' => { 372 => 0xb3 },
	'videocodec' => { 74 => 0x74 },
	'videocolorspace' => { 566 => 'videoColorSpace' },
	'videocompression' => { 135 => 0x3806 },
	'videocompressor' => { 566 => 'videoCompressor' },
	'videodisplayaspectratio' => { 550 => 'videoDisplayAspectRatio' },
	'videoencodingprofile' => { 550 => 'videoEncodingProfile' },
	'videofieldorder' => { 566 => 'videoFieldOrder' },
	'videoframerate' => { 372 => 0x27, 566 => 'videoFrameRate' },
	'videoframesize' => { 566 => 'videoFrameSize' },
	'videoframesizeh' => { 566 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 566 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 566 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 566 => 'videoModDate' },
	'videopixelaspectratio' => { 566 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 566 => 'videoPixelDepth' },
	'videopreburst' => { 372 => 0xc1 },
	'videoquality' => { 121 => 0x4003 },
	'videorecordingmode' => { 135 => 0x3803 },
	'videoshottype' => { 550 => 'VideoShotType' },
	'videoshottypeidentifier' => { 550 => [\'VideoShotType','VideoShotTypeIdentifier'] },
	'videoshottypename' => { 550 => [\'VideoShotType','VideoShotTypeName'] },
	'videostreamscount' => { 550 => 'videoStreamsCount' },
	'viewfinder' => { 420 => 0x455 },
	'viewfinderdisplay' => { 325 => '12.4', 326 => '6.3' },
	'viewfinderwarning' => { 325 => '13.4', 335 => '3.5', 336 => '6.2', 340 => '4.4' },
	'viewfinderwarnings' => { 92 => 0x40a },
	'viewinfoduringexposure' => { 92 => 0x407 },
	'viewingmode' => { 469 => 0x2f, 486 => 0x18 },
	'viewingmode2' => { 469 => [0x85,0x285] },
	'viewmodeshoweffectsofsettings' => { 269 => 0x7d2, 342 => 0x2a9 },
	'viewpoint' => { 555 => 'viewpoint' },
	'vignette' => { 457 => 0x139 },
	'vignetteamount' => { 536 => 'VignetteAmount', 538 => 'VignetteAmount' },
	'vignettecoefficient1' => { 309 => 0x24 },
	'vignettecoefficient2' => { 309 => 0x34 },
	'vignettecoefficient3' => { 309 => 0x44 },
	'vignettecontrol' => { 258 => 0x2a, 318 => 0x76a43205 },
	'vignettecontrolintensity' => { 318 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 533 => 'VignetteCorrectionAlreadyApplied' },
	'vignettecorrectionversion' => { 309 => 0x0 },
	'vignettemidpoint' => { 536 => 'VignetteMidpoint', 538 => 'VignetteMidpoint' },
	'vignetting' => { 447 => 0x1011, 454 => 0xa052 },
	'vignettingcorrection' => { 127 => 0x7031, 454 => 0xa053, 481 => 0x2011 },
	'vignettingcorrparams' => { 127 => 0x7032, 512 => 0x64a, 513 => [0x34a,0x350,0x35c,0x368] },
	'vignettingsetting' => { 454 => 0xa054 },
	'virtualfocallength' => { 551 => 'VirtualFocalLength' },
	'virtualhorizonstyle' => { 341 => 0x161, 342 => 0x167, 343 => 0x167, 344 => 0x17f },
	'virtualimagexcenter' => { 551 => 'VirtualImageXCenter' },
	'virtualimageycenter' => { 551 => 'VirtualImageYCenter' },
	'visualcolor' => { 550 => 'VisualColour' },
	'visualtechnique' => { 555 => 'visualTechnique' },
	'voicememo' => { 456 => 0x216 },
	'volume' => { 556 => 'volume' },
	'vr_0x66' => { 289 => 0x66 },
	'vrdoffset' => { 71 => 0xd0 },
	'vrmode' => { 262 => 0x342, 264 => 0x226, 267 => 0x212, 268 => 0x226, 269 => 0x226, 308 => 0x6 },
	'vrtype' => { 308 => 0x8 },
	'waterdepth' => { 127 => 0x9403, 543 => 'WaterDepth' },
	'wb_bluelevel3500k' => { 206 => 0x19a },
	'wb_bluelevel6500k' => { 206 => 0x18a },
	'wb_bluelevelcustom' => { 206 => 0x18e },
	'wb_bluelevelscloudy' => { 206 => 0x106 },
	'wb_bluelevelsdaylight' => { 206 => 0xea },
	'wb_bluelevelsflash' => { 206 => 0x122 },
	'wb_bluelevelsfluorescent' => { 206 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 206 => 0x254 },
	'wb_bluelevelsshade' => { 206 => 0x176 },
	'wb_bluelevelstungsten' => { 206 => 0xce },
	'wb_gbrglevels' => { 206 => 0xae, 209 => 0x4 },
	'wb_glevel' => { 351 => 0x11f },
	'wb_glevel3000k' => { 351 => 0x113 },
	'wb_glevel3300k' => { 351 => 0x114 },
	'wb_glevel3600k' => { 351 => 0x115 },
	'wb_glevel3900k' => { 351 => 0x116 },
	'wb_glevel4000k' => { 351 => 0x117 },
	'wb_glevel4300k' => { 351 => 0x118 },
	'wb_glevel4500k' => { 351 => 0x119 },
	'wb_glevel4800k' => { 351 => 0x11a },
	'wb_glevel5300k' => { 351 => 0x11b },
	'wb_glevel6000k' => { 351 => 0x11c },
	'wb_glevel6600k' => { 351 => 0x11d },
	'wb_glevel7500k' => { 351 => 0x11e },
	'wb_grbglevels' => { 226 => 0x0, 488 => 0x7303 },
	'wb_grbglevelsauto' => { 88 => 0x2, 488 => 0x7302 },
	'wb_grbglevelscloudy' => { 88 => 0x12 },
	'wb_grbglevelscustom1' => { 88 => 0x42 },
	'wb_grbglevelscustom2' => { 88 => 0x4a },
	'wb_grbglevelsdaylight' => { 88 => 0xa },
	'wb_grbglevelsflash' => { 88 => 0x32 },
	'wb_grbglevelsfluorescent' => { 88 => 0x22 },
	'wb_grbglevelsfluorhigh' => { 88 => 0x2a },
	'wb_grbglevelstungsten' => { 88 => 0x1a },
	'wb_grbglevelsunderwater' => { 88 => 0x3a },
	'wb_rbgglevels' => { 223 => 0x0 },
	'wb_rblevels' => { 227 => 0x270, 258 => 0xc, 351 => 0x100 },
	'wb_rblevels1' => { 378 => 0x2 },
	'wb_rblevels2' => { 378 => 0x5 },
	'wb_rblevels3' => { 378 => 0x8 },
	'wb_rblevels3000k' => { 351 => 0x102 },
	'wb_rblevels3300k' => { 351 => 0x103 },
	'wb_rblevels3500k' => { 206 => 0x430 },
	'wb_rblevels3600k' => { 351 => 0x104 },
	'wb_rblevels3900k' => { 351 => 0x105 },
	'wb_rblevels4' => { 378 => 0xb },
	'wb_rblevels4000k' => { 351 => 0x106 },
	'wb_rblevels4300k' => { 351 => 0x107 },
	'wb_rblevels4500k' => { 351 => 0x108 },
	'wb_rblevels4800k' => { 351 => 0x109 },
	'wb_rblevels5' => { 378 => 0xe },
	'wb_rblevels5300k' => { 351 => 0x10a },
	'wb_rblevels6' => { 378 => 0x11 },
	'wb_rblevels6000k' => { 351 => 0x10b },
	'wb_rblevels6500k' => { 206 => 0x420 },
	'wb_rblevels6600k' => { 351 => 0x10c },
	'wb_rblevels7' => { 378 => 0x14 },
	'wb_rblevels7500k' => { 351 => 0x10d },
	'wb_rblevelsauto' => { 227 => 0x272, 355 => 0x110 },
	'wb_rblevelscloudy' => { 206 => 0x3f0, 208 => 0x10, 227 => 0x296, 355 => 0x121 },
	'wb_rblevelscoolwhitef' => { 206 => 0x308, 208 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 355 => 0x132 },
	'wb_rblevelscustom' => { 206 => 0x424, 208 => 0x1c },
	'wb_rblevelscwb1' => { 351 => 0x10e },
	'wb_rblevelscwb2' => { 351 => 0x10f },
	'wb_rblevelscwb3' => { 351 => 0x110 },
	'wb_rblevelscwb4' => { 351 => 0x111 },
	'wb_rblevelsdaylight' => { 206 => [0x3ec,0x528], 208 => 0xc, 227 => 0x274 },
	'wb_rblevelsdaylightf' => { 208 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 355 => 0x130 },
	'wb_rblevelsdaywhitef' => { 208 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 355 => 0x131 },
	'wb_rblevelseveningsunlight' => { 355 => 0x124 },
	'wb_rblevelsfineweather' => { 355 => 0x122 },
	'wb_rblevelsflash' => { 206 => [0x3f4,0x304], 208 => 0x18, 227 => 0x2a4 },
	'wb_rblevelsfluorescent' => { 227 => 0x290 },
	'wb_rblevelsincandescent' => { 227 => 0x282 },
	'wb_rblevelsshade' => { 206 => 0x418, 208 => 0x20, 227 => 0x2b2, 355 => 0x120 },
	'wb_rblevelstungsten' => { 206 => 0x3e8, 208 => 0x8, 355 => 0x123 },
	'wb_rblevelsused' => { 355 => 0x100 },
	'wb_rblevelswhitef' => { 208 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 355 => 0x133 },
	'wb_redlevel3500k' => { 206 => 0x198 },
	'wb_redlevel6500k' => { 206 => 0x188 },
	'wb_redlevelcustom' => { 206 => 0x18c },
	'wb_redlevelscloudy' => { 206 => 0xf8 },
	'wb_redlevelsdaylight' => { 206 => 0xdc },
	'wb_redlevelsflash' => { 206 => 0x114 },
	'wb_redlevelsfluorescent' => { 206 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 206 => 0x1be },
	'wb_redlevelsshade' => { 206 => 0x168 },
	'wb_redlevelstungsten' => { 206 => 0xc0 },
	'wb_rgbglevels' => { 225 => 0x0 },
	'wb_rgblevels' => { 206 => [0x546,0x96], 368 => 0xd, 369 => 0x413, 374 => 0x3036, 420 => 0x107, 490 => 0x117c, 491 => 0x1180, 492 => 0x115c, 493 => 0x11d8, 494 => 0x11b4, 495 => 0x106c, 496 => 0x264, 497 => 0x264, 498 => 0x252 },
	'wb_rgblevels1' => { 379 => 0x2 },
	'wb_rgblevels2' => { 379 => 0x6 },
	'wb_rgblevels2500k' => { 488 => 0x782d },
	'wb_rgblevels3' => { 379 => 0xa },
	'wb_rgblevels3200k' => { 488 => 0x782c },
	'wb_rgblevels4' => { 379 => 0xe },
	'wb_rgblevels4500k' => { 488 => [0x7484,0x7824] },
	'wb_rgblevels5' => { 379 => 0x12 },
	'wb_rgblevels6' => { 379 => 0x16 },
	'wb_rgblevels6000k' => { 488 => 0x782b },
	'wb_rgblevels7' => { 379 => 0x1a },
	'wb_rgblevels8500k' => { 488 => 0x782a },
	'wb_rgblevelsauto' => { 458 => 0x0 },
	'wb_rgblevelscloudy' => { 488 => [0x7481,0x7821] },
	'wb_rgblevelscustom1' => { 458 => 0x15 },
	'wb_rgblevelscustom2' => { 458 => 0x18 },
	'wb_rgblevelscustom3' => { 458 => 0x1b },
	'wb_rgblevelsdaylight' => { 458 => 0x3, 488 => [0x7480,0x7820] },
	'wb_rgblevelsflash' => { 458 => 0x12, 488 => [0x7483,0x7823] },
	'wb_rgblevelsfluorescent' => { 458 => 0xf, 488 => [0x7486,0x7826] },
	'wb_rgblevelsfluorescentm1' => { 488 => 0x7829 },
	'wb_rgblevelsfluorescentp1' => { 488 => 0x7827 },
	'wb_rgblevelsfluorescentp2' => { 488 => 0x7828 },
	'wb_rgblevelsincandescent' => { 458 => 0xc },
	'wb_rgblevelsovercast' => { 458 => 0x9 },
	'wb_rgblevelsshade' => { 458 => 0x6, 488 => 0x7825 },
	'wb_rgblevelstungsten' => { 488 => [0x7482,0x7822] },
	'wb_rgblevelsunknown0' => { 459 => 0x0 },
	'wb_rgblevelsunknown1' => { 459 => 0x3 },
	'wb_rgblevelsunknown2' => { 459 => 0x6 },
	'wb_rgblevelsunknown3' => { 459 => 0x9 },
	'wb_rgblevelsunknown4' => { 459 => 0xc },
	'wb_rgblevelsunknown5' => { 459 => 0xf },
	'wb_rgblevelsunknown6' => { 459 => 0x12 },
	'wb_rgblevelsunknown7' => { 459 => 0x15 },
	'wb_rgblevelsunknown8' => { 459 => 0x18 },
	'wb_rgblevelsunknown9' => { 459 => 0x1b },
	'wb_rgbmuldaylight' => { 157 => 0x852 },
	'wb_rgbmulflash' => { 157 => 0x855 },
	'wb_rgbmulfluorescent' => { 157 => 0x854 },
	'wb_rgbmultungsten' => { 157 => 0x853 },
	'wb_rggbblacklevels' => { 39 => 0x25 },
	'wb_rggblevels' => { 127 => 0x7313, 209 => 0x4, 224 => 0x0, 228 => 0x13e8, 229 => 0x38, 488 => 0x7313 },
	'wb_rggblevelsasshot' => { 42 => 0x0, 43 => 0x0, 44 => 0x19, 45 => 0x55, 46 => 0x69, 47 => 0x69, 48 => 0x22, 49 => 0x3f, 52 => 0x3f, 53 => 0x3f, 54 => 0x3f, 55 => 0x47 },
	'wb_rggblevelsauto' => { 39 => 0x1, 42 => 0x5, 43 => 0x8, 44 => 0x1e, 45 => 0x5a, 46 => 0x6e, 48 => 0x18, 49 => 0x44, 52 => 0x44, 53 => 0x44, 54 => 0x44, 55 => 0x4c, 228 => 0x1478, 229 => 0x114, 454 => 0xa022, 488 => 0x7312 },
	'wb_rggblevelsblack' => { 454 => 0xa028 },
	'wb_rggblevelscloudy' => { 39 => 0xd, 42 => 0x1e, 43 => 0x30, 44 => 0x2d, 45 => 0xa0, 46 => 0xd7, 47 => 0x78, 48 => 0x31, 49 => 0x58, 52 => 0x71, 53 => 0x8a, 54 => 0x8f, 55 => 0x92, 228 => 0x1408, 229 => 0x60, 411 => 0x20f, 419 => 0x14 },
	'wb_rggblevelscustom' => { 39 => 0x1d, 49 => 0x80, 228 => 0x1468, 229 => 0x100 },
	'wb_rggblevelscustom1' => { 44 => 0x41 },
	'wb_rggblevelscustom2' => { 44 => 0x46 },
	'wb_rggblevelsdaylight' => { 39 => 0x5, 42 => 0x14, 43 => 0x20, 44 => 0x23, 45 => 0x96, 46 => 0xcd, 47 => 0x6e, 48 => 0x27, 49 => 0x4e, 52 => 0x67, 53 => 0x80, 54 => 0x85, 55 => 0x88, 228 => 0x13f8, 229 => 0x4c, 411 => 0x20d, 419 => 0x2 },
	'wb_rggblevelsflash' => { 39 => 0x19, 42 => 0x32, 43 => 0x50, 44 => 0x3c, 45 => 0xb4, 46 => 0xeb, 47 => 0x87, 48 => 0x45, 49 => 0x6c, 52 => 0x85, 53 => 0x9e, 54 => 0xa3, 55 => 0xa6, 228 => 0x1448, 411 => 0x214, 419 => 0x41 },
	'wb_rggblevelsfluorescent' => { 39 => 0x15, 42 => 0x28, 43 => 0x40, 44 => 0x37, 45 => 0xaa, 46 => 0xe1, 47 => 0x82, 48 => 0x3b, 49 => 0x62, 52 => 0x7b, 53 => 0x94, 54 => 0x99, 55 => 0x9c },
	'wb_rggblevelsfluorescentd' => { 229 => 0xc4, 411 => 0x211, 419 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 419 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 229 => 0xb0, 411 => 0x212, 419 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 228 => 0x1438, 229 => 0x9c, 411 => 0x213, 419 => 0x38 },
	'wb_rggblevelshtmercury' => { 229 => 0xd8 },
	'wb_rggblevelsilluminator1' => { 454 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 454 => 0xa024 },
	'wb_rggblevelskelvin' => { 39 => 0x21, 42 => 0x2d, 43 => 0x48, 45 => 0xaf, 46 => 0xe6, 48 => 0x40, 49 => 0x67, 52 => 0x80, 53 => 0x99, 54 => 0x9e, 55 => 0xa1 },
	'wb_rggblevelsmeasured' => { 42 => 0xa, 43 => 0x10, 45 => 0x5f, 46 => 0x73, 49 => 0x49, 52 => 0x49, 53 => 0x49, 54 => 0x49, 55 => 0x51 },
	'wb_rggblevelspc1' => { 48 => 0x90, 49 => 0x71 },
	'wb_rggblevelspc2' => { 48 => 0x95, 49 => 0x76 },
	'wb_rggblevelspc3' => { 48 => 0x9a, 49 => 0x7b },
	'wb_rggblevelsshade' => { 39 => 0x9, 42 => 0x19, 43 => 0x28, 44 => 0x28, 45 => 0x9b, 46 => 0xd2, 47 => 0x73, 48 => 0x2c, 49 => 0x53, 52 => 0x6c, 53 => 0x85, 54 => 0x8a, 55 => 0x8d, 229 => 0x74, 411 => 0x20e, 419 => 0xb },
	'wb_rggblevelstungsten' => { 39 => 0x11, 42 => 0x23, 43 => 0x38, 44 => 0x32, 45 => 0xa5, 46 => 0xdc, 47 => 0x7d, 48 => 0x36, 49 => 0x5d, 52 => 0x76, 53 => 0x8f, 54 => 0x94, 55 => 0x97, 228 => 0x1428, 229 => 0x88, 411 => 0x210, 419 => 0x1d },
	'wb_rggblevelsuncorrected' => { 454 => 0xa021 },
	'wb_rggblevelsunknown' => { 42 => 0xf, 43 => 0x18, 45 => 0x64, 46 => 0x78, 48 => 0x1d, 52 => 0x4e, 53 => 0x4e, 54 => 0x4e, 55 => 0x56, 419 => 0x53 },
	'wb_rggblevelsunknown10' => { 42 => 0x5f, 43 => 0x98, 45 => 0x91, 46 => 0xa5, 47 => 0xb4, 48 => 0x72, 52 => 0x9e, 53 => 0x7b, 54 => 0x7b, 55 => 0x83 },
	'wb_rggblevelsunknown11' => { 42 => 0x64, 43 => 0xa0, 45 => 0xb9, 46 => [0xaa,0xaf], 47 => 0xb9, 48 => 0x77, 52 => 0xa3, 53 => 0xa3, 54 => 0x80, 55 => 0xab },
	'wb_rggblevelsunknown12' => { 42 => 0x69, 43 => 0xa8, 45 => 0xbe, 46 => 0xb4, 47 => 0xbe, 48 => 0x7c, 52 => 0xa8, 53 => 0xa8, 54 => 0xa8, 55 => 0xb0 },
	'wb_rggblevelsunknown13' => { 42 => 0x6e, 43 => 0xb0, 45 => 0xc3, 46 => 0xb9, 47 => 0xc3, 48 => 0x81, 52 => 0xad, 53 => 0xad, 54 => 0xad, 55 => 0xb5 },
	'wb_rggblevelsunknown14' => { 45 => 0xc8, 46 => 0xbe, 47 => 0xc8, 48 => 0x86, 52 => 0xb2, 53 => 0xb2, 54 => 0xb2, 55 => 0xba },
	'wb_rggblevelsunknown15' => { 45 => 0xcd, 46 => 0xc3, 47 => 0xcd, 48 => 0x8b, 52 => 0xb7, 53 => 0xb7, 54 => 0xb7, 55 => 0xbf },
	'wb_rggblevelsunknown16' => { 45 => 0xd2, 46 => 0xc8, 47 => 0xd2, 48 => 0x9f, 53 => 0xbc, 54 => 0xbc, 55 => 0xc4 },
	'wb_rggblevelsunknown17' => { 45 => 0xd7, 46 => 0xf0, 47 => 0xd7, 53 => 0xc1, 54 => 0xc1, 55 => 0xc9 },
	'wb_rggblevelsunknown18' => { 45 => 0xdc, 46 => 0xf5, 47 => 0xdc, 53 => 0xc6, 54 => 0xc6, 55 => 0xce },
	'wb_rggblevelsunknown19' => { 45 => 0xe1, 46 => 0xfa, 47 => 0xe1, 53 => 0xcb, 54 => 0xcb, 55 => 0xd3 },
	'wb_rggblevelsunknown2' => { 42 => 0x37, 43 => 0x58, 45 => 0x69, 46 => 0x7d, 47 => 0x8c, 48 => 0x4a, 52 => 0x53, 53 => 0x53, 54 => 0x53, 55 => 0x5b },
	'wb_rggblevelsunknown20' => { 45 => 0xe6, 46 => 0xff, 47 => 0xe6, 53 => 0xd0, 54 => 0xd0, 55 => 0xd8 },
	'wb_rggblevelsunknown21' => { 45 => 0xeb, 46 => 0x104, 47 => 0xeb, 54 => 0xd5, 55 => 0xdd },
	'wb_rggblevelsunknown22' => { 45 => 0xf0, 46 => 0x109, 47 => 0xf0, 54 => 0xda, 55 => 0xe2 },
	'wb_rggblevelsunknown23' => { 45 => 0xf5, 46 => 0x10e, 47 => 0xf5, 54 => 0xdf, 55 => 0xe7 },
	'wb_rggblevelsunknown24' => { 45 => 0xfa, 46 => 0x113, 47 => 0xfa, 54 => 0xe4, 55 => 0xec },
	'wb_rggblevelsunknown25' => { 45 => 0xff, 46 => 0x118, 47 => 0xff, 54 => 0xe9, 55 => 0xf1 },
	'wb_rggblevelsunknown26' => { 45 => 0x104, 46 => 0x11d, 47 => 0x104, 54 => 0xee, 55 => 0xf6 },
	'wb_rggblevelsunknown27' => { 45 => 0x109, 46 => 0x122, 47 => 0x109, 54 => 0xf3, 55 => 0xfb },
	'wb_rggblevelsunknown28' => { 45 => 0x10e, 47 => 0x10e, 54 => 0xf8, 55 => 0x100 },
	'wb_rggblevelsunknown29' => { 45 => 0x113, 47 => 0x113, 54 => 0xfd, 55 => 0x105 },
	'wb_rggblevelsunknown3' => { 42 => 0x3c, 43 => 0x60, 45 => 0x6e, 46 => 0x82, 47 => 0x91, 48 => 0x4f, 52 => 0x58, 53 => 0x58, 54 => 0x58, 55 => 0x60 },
	'wb_rggblevelsunknown30' => { 47 => 0x118, 54 => 0x102 },
	'wb_rggblevelsunknown31' => { 47 => 0x11d },
	'wb_rggblevelsunknown32' => { 47 => 0x122 },
	'wb_rggblevelsunknown33' => { 47 => 0x127 },
	'wb_rggblevelsunknown4' => { 42 => 0x41, 43 => 0x68, 45 => 0x73, 46 => 0x87, 47 => 0x96, 48 => 0x54, 52 => 0x5d, 53 => 0x5d, 54 => 0x5d, 55 => 0x65 },
	'wb_rggblevelsunknown5' => { 42 => 0x46, 43 => 0x70, 45 => 0x78, 46 => 0x8c, 47 => 0x9b, 48 => 0x59, 52 => 0x62, 53 => 0x62, 54 => 0x62, 55 => 0x6a },
	'wb_rggblevelsunknown6' => { 42 => 0x4b, 43 => 0x78, 45 => 0x7d, 46 => 0x91, 47 => 0xa0, 48 => 0x5e, 52 => 0x8a, 53 => 0x67, 54 => 0x67, 55 => 0x6f },
	'wb_rggblevelsunknown7' => { 42 => 0x50, 43 => 0x80, 45 => 0x82, 46 => 0x96, 47 => 0xa5, 48 => 0x63, 52 => 0x8f, 53 => 0x6c, 54 => 0x6c, 55 => 0x74 },
	'wb_rggblevelsunknown8' => { 42 => 0x55, 43 => 0x88, 45 => 0x87, 46 => 0x9b, 47 => 0xaa, 48 => 0x68, 52 => 0x94, 53 => 0x71, 54 => 0x71, 55 => 0x79 },
	'wb_rggblevelsunknown9' => { 42 => 0x5a, 43 => 0x90, 45 => 0x8c, 46 => 0xa0, 47 => 0xaf, 48 => 0x6d, 52 => 0x99, 53 => 0x76, 54 => 0x76, 55 => 0x7e },
	'wb_rggblevelsuserselected' => { 419 => 0x5c },
	'wbadjblueamber' => { 111 => 0x20106 },
	'wbadjbluebalance' => { 324 => 0x8 },
	'wbadjcolortemp' => { 111 => 0x20102, 116 => 0x1a },
	'wbadjlighting' => { 324 => 0x14 },
	'wbadjmagentagreen' => { 111 => 0x20105 },
	'wbadjmode' => { 324 => 0x10 },
	'wbadjredbalance' => { 324 => 0x0 },
	'wbadjrggblevels' => { 111 => 0x20125, 116 => 0x6 },
	'wbadjtemperature' => { 324 => 0x18 },
	'wbadjtint' => { 324 => 0x25 },
	'wbblue' => { 135 => 0x144c },
	'wbbluelevel' => { 367 => 0x324, 372 => 0x8006, 377 => 0x26 },
	'wbbracketingsteps' => { 220 => 0x10, 221 => 0x10, 298 => 0x174d },
	'wbbracketmode' => { 62 => 0x9 },
	'wbbracketshotnumber' => { 206 => 0x2b, 447 => 0x101a },
	'wbbracketvalueab' => { 62 => 0xc },
	'wbbracketvaluegm' => { 62 => 0xd },
	'wbbutton' => { 266 => 0x806, 269 => 0x80a },
	'wbbuttonplaybackmode' => { 342 => 0x1c5 },
	'wbfinetuneactive' => { 116 => 0x24 },
	'wbfinetunesaturation' => { 116 => 0x28 },
	'wbfinetunetone' => { 116 => 0x2c },
	'wbgreen' => { 135 => 0x144b },
	'wbgreenlevel' => { 367 => 0x323, 372 => 0x8005, 377 => 0x25 },
	'wbmediaimagesizesetting' => { 92 => 0x708 },
	'wbmode' => { 208 => 0x4, 352 => 0x1015 },
	'wbred' => { 135 => 0x144a },
	'wbredlevel' => { 367 => 0x322, 372 => 0x8004, 377 => 0x24 },
	'wbscale' => { 209 => 0x0 },
	'wbshiftab' => { 81 => 0xc, 372 => 0x46, 391 => 0x10 },
	'wbshiftab_gm' => { 481 => 0x2014 },
	'wbshiftab_gm_precise' => { 481 => 0x2026 },
	'wbshiftcreativecontrol' => { 372 => 0x92 },
	'wbshiftgm' => { 81 => 0xd, 372 => 0x47, 391 => 0x11 },
	'wbshiftintelligentauto' => { 372 => 0x8b },
	'wbtype1' => { 378 => 0x1, 379 => 0x1 },
	'wbtype2' => { 378 => 0x4, 379 => 0x5 },
	'wbtype3' => { 378 => 0x7, 379 => 0x9 },
	'wbtype4' => { 378 => 0xa, 379 => 0xd },
	'wbtype5' => { 378 => 0xd, 379 => 0x11 },
	'wbtype6' => { 378 => 0x10, 379 => 0x15 },
	'wbtype7' => { 378 => 0x13, 379 => 0x19 },
	'webstatement' => { 570 => 'WebStatement' },
	'weightedflatsubject' => { 527 => 'weightedFlatSubject' },
	'what' => { 536 => 'What', 538 => 'What' },
	'whitebalance' => { 7 => 0x6f, 8 => [0x44,0x4a], 9 => 0xbc, 10 => 0x36, 11 => 0x5e, 12 => 0x36, 13 => 0x78, 14 => 0x6f, 15 => 0x6f, 16 => 0x73, 17 => 0x6f, 18 => 0x78, 19 => 0x54, 20 => 0x6f, 21 => 0xbc, 22 => 0x7b, 24 => 0xbc, 25 => 0xc2, 27 => 0x131, 28 => 0x77, 81 => 0x8, 84 => 0x7, 120 => 0x7, 121 => [0x19,0x2012], 127 => [0xa403,0xfe4e], 135 => 0x1002, 157 => 0x3fc, 158 => 0xfa0d, 159 => 0x40, 170 => 0x1a, 200 => 0x3, 201 => 0xe, 202 => 0x4, 203 => 0xb, 205 => 0x115, 258 => 0x5, 307 => 0x7, 367 => 0x304, 372 => 0x3, 374 => 0x3033, 411 => 0x19, 418 => 0x7, 446 => 0x26, 447 => 0x1003, 457 => [0x88,0x3c,0x7,0x58], 467 => 0xf, 468 => 0xe, 481 => [0x115,0xb054], 536 => 'WhiteBalance', 538 => 'WhiteBalance', 542 => 'WhiteBalance' },
	'whitebalance0' => { 195 => 'WhiteBalance0' },
	'whitebalance1' => { 195 => 'WhiteBalance1' },
	'whitebalance2' => { 195 => 'WhiteBalance2', 347 => 0x500 },
	'whitebalanceadj' => { 111 => 0x20101, 116 => 0x18, 318 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 386 => 0x0 },
	'whitebalancebias' => { 121 => 0x2011, 352 => 0x304, 372 => 0x23 },
	'whitebalanceblue' => { 81 => 0x7 },
	'whitebalancebracket' => { 347 => 0x502, 352 => 0x303 },
	'whitebalancebracketing' => { 135 => 0x1102, 203 => 0x22, 206 => 0x2c, 478 => 0x2c },
	'whitebalancebuttonplaybackmode' => { 343 => 0x1c5, 344 => 0x1dd },
	'whitebalancecomp' => { 355 => 0x1001 },
	'whitebalancedetected' => { 157 => 0x3fb },
	'whitebalancefinetune' => { 135 => 0x100a, 203 => 0x38, 205 => 0x112, 258 => [0xb,0x3f], 447 => 0x1004, 467 => 0x6, 468 => 0x5, 481 => 0x112 },
	'whitebalancemode' => { 157 => 0x3fa, 411 => 0x1a },
	'whitebalancered' => { 81 => 0x6 },
	'whitebalanceset' => { 390 => 0xa },
	'whitebalancesetting' => { 203 => 0x23, 467 => 0x5, 468 => 0x4, 469 => 0x16, 486 => 0xd },
	'whitebalancesetup' => { 454 => 0x41 },
	'whitebalancetemperature' => { 347 => 0x501 },
	'whiteboard' => { 352 => 0x301 },
	'whitelevel' => { 127 => 0xc61d, 411 => 0x7e, 488 => 0x787f },
	'whitepoint' => { 127 => 0x13e, 371 => 0x35d, 411 => 0x201, 562 => 'WhitePoint' },
	'whites2012' => { 536 => 'Whites2012', 538 => 'Whites2012' },
	'whitesadj' => { 518 => 0x9017 },
	'wholeareatracking' => { 2 => 0x1a },
	'wideadapter' => { 447 => 0x1017 },
	'widefocuszone' => { 200 => 0x2f },
	'widerange' => { 456 => 0x20f },
	'wififirmwaredate' => { 442 => 0x42 },
	'wififirmwareversion' => { 442 => 0x3c },
	'windmode' => { 157 => 0x3f4 },
	'windnoisereduction' => { 264 => 0x352, 267 => 0x2d6, 268 => 0x2fe, 269 => 0x2fe },
	'windowlocation' => { 437 => 'WLOC' },
	'windowsatom' => { 537 => 'windowsAtom' },
	'windowsatomextension' => { 537 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 537 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 537 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 556 => 'wordCount' },
	'work' => { 429 => "\xa9wrk" },
	'workcolorspace' => { 111 => 0x10200, 116 => 0x270 },
	'workflowtag' => { 550 => 'WorkflowTag' },
	'workflowtagcvid' => { 550 => [\'WorkflowTag','WorkflowTagCvId'] },
	'workflowtagcvtermid' => { 550 => [\'WorkflowTag','WorkflowTagCvTermId'] },
	'workflowtagcvtermname' => { 550 => [\'WorkflowTag','WorkflowTagCvTermName'] },
	'workflowtagcvtermrefinedabout' => { 550 => [\'WorkflowTag','WorkflowTagCvTermRefinedAbout'] },
	'worktodo' => { 544 => 'WorkToDo' },
	'worldtimelocation' => { 372 => 0x3a, 411 => 0x22, 417 => '0.1' },
	'writer' => { 198 => 'WM/Writer' },
	'writer-editor' => { 150 => 0x7a },
	'x3filllight' => { 457 => 0x12 },
	'xattrmditemwherefroms' => { 193 => 'com.apple.metadata:kMDItemWhereFroms' },
	'xattrquarantine' => { 193 => 'com.apple.quarantine' },
	'xiaomiexifinfo' => { 431 => 'xiaomi.exifInfo.videoinfo' },
	'xiaomihdr10' => { 431 => 'com.xiaomi.hdr10' },
	'xiaomimodel' => { 127 => 0x9a00 },
	'xiaomipreviewvideocover' => { 431 => 'com.xiaomi.preview_video_cover' },
	'xiaomisettings' => { 127 => 0x9999 },
	'xilinxversion' => { 157 => 0x414 },
	'xml' => { 155 => 'xml ' },
	'xmp' => { 114 => 0xffff00f6, 128 => 'XMP', 138 => 'XMP Data/XMP' },
	'xmptoolkit' => { 563 => 'xmptk' },
	'xpauthor' => { 127 => 0x9c9d },
	'xpcomment' => { 127 => 0x9c9c },
	'xpkeywords' => { 127 => 0x9c9e },
	'xposition' => { 127 => 0x11e },
	'xpsubject' => { 127 => 0x9c9f },
	'xptitle' => { 127 => 0x9c9b },
	'xresolution' => { 127 => 0x11a, 153 => 0x3, 426 => 0x0, 562 => 'XResolution' },
	'xyresolution' => { 131 => 0x3 },
	'yaw' => { 123 => 0x7, 437 => ['_yaw',"\xa9fyw"] },
	'yawangle' => { 274 => 0x8, 452 => 0x0 },
	'ycbcrcoefficients' => { 127 => 0x211, 562 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 127 => 0x213, 562 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 127 => 0x212, 562 => 'YCbCrSubSampling' },
	'year' => { 429 => 'yrrc', 431 => 'year', 437 => 'yrrc' },
	'yearcreated' => { 159 => 0x10, 168 => 0xc },
	'yellowhsl' => { 111 => 0x20912 },
	'yield' => { 558 => 'yield' },
	'yposition' => { 127 => 0x11f },
	'yresolution' => { 127 => 0x11b, 153 => 0x5, 426 => 0x4, 562 => 'YResolution' },
	'zebrapatterntonerange' => { 342 => 0x211, 343 => 0x211, 344 => 0x229 },
	'zoneidentifier' => { 128 => 'ZoneIdentifier' },
	'zonematching' => { 205 => 0x10a, 208 => [0x3a,0x4a], 481 => 0xb024 },
	'zonematchingmode' => { 203 => 0x14 },
	'zonematchingon' => { 202 => 0x75 },
	'zonematchingvalue' => { 467 => 0x1f },
	'zoomedpreviewlength' => { 352 => 0xf05 },
	'zoomedpreviewsize' => { 352 => 0xf06 },
	'zoomedpreviewstart' => { 352 => 0xf04 },
	'zoomsourcewidth' => { 38 => 0x24 },
	'zoomstepcount' => { 350 => 0x300, 352 => 0x100d },
	'zoomtargetwidth' => { 38 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_misb' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'abstractfilename' => 1,
	'accel360fly' => 1,
	'acceldata' => 1,
	'accelerometermatrix' => 1,
	'accelerometertime' => 1,
	'accelerometerunknown' => 1,
	'accelmode' => 1,
	'accelypr' => 1,
	'accessdate' => 1,
	'accessrights' => 1,
	'accompaniment' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acdsee-rs' => 1,
	'acidizer' => 1,
	'acidizerflags' => 1,
	'acnespotremoval' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'activebuf1cols' => 1,
	'activebuf1rows' => 1,
	'activebuf2cols' => 1,
	'activebuf2rows' => 1,
	'activecols' => 1,
	'activectemonitor1cols' => 1,
	'activectemonitor2cols' => 1,
	'activectemonitorrows' => 1,
	'activerows' => 1,
	'actor' => 1,
	'actors' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'actualsoftpostpadding' => 1,
	'actualsoftprepadding' => 1,
	'additionalinfo' => 1,
	'adjdebuginfo' => 1,
	'adjustedtbnimageheight' => 1,
	'adjustedtbnimagewidth' => 1,
	'adjustmentdata' => 1,
	'adjustmentssettingsstatisticslightmap' => 1,
	'adjustmentvalue' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aedebuginfo' => 1,
	'aeflags' => 1,
	'aehistograminfo' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'aeliveviewhistograminfo' => 1,
	'aeliveviewlocalhistogram' => 1,
	'aelocalhistogram' => 1,
	'af' => 1,
	'af-cprioritysel' => 1,
	'af-sprioritysel' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afcsettings' => 1,
	'afdebuginfo' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfok3iii' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointinfo' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsspecial' => 1,
	'afsp' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'afstatus79' => 1,
	'aftune' => 1,
	'aibuildnumber' => 1,
	'aicolormodel' => 1,
	'aicolorusage' => 1,
	'aicreatorversion' => 1,
	'aifileformat' => 1,
	'aimetadata' => 1,
	'ainumlayers' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'airfieldbarometricpressure' => 1,
	'airfieldelevation' => 1,
	'airspeed' => 1,
	'airtemperature' => 1,
	'airulerunits' => 1,
	'aistream' => 1,
	'aitargetresolution' => 1,
	'album2' => 1,
	'albumartistsortorder' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitlesortorder' => 1,
	'alerts' => 1,
	'alexa' => 1,
	'alexa-paireddevicename' => 1,
	'alexa-pairing' => 1,
	'alexa-privacymode' => 1,
	'alexa-wakewordlanguage' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaisused' => 1,
	'alphamask' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alphavalue' => 1,
	'alternatealtitude' => 1,
	'alternateduotonecolors' => 1,
	'alternateellipsoidheight' => 1,
	'alternateellipsoidheightextended' => 1,
	'alternateformattrack' => 1,
	'alternateheading' => 1,
	'alternatelatitude' => 1,
	'alternatelongitude' => 1,
	'alternatename' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'altitudefromtakeoff' => 1,
	'ambienceinfo' => 1,
	'ambisonicchannelmap' => 1,
	'ambisonicchannelordering' => 1,
	'ambisonicchannels' => 1,
	'ambisonicnormalization' => 1,
	'ambisonicorder' => 1,
	'ambisonictype' => 1,
	'amendlocalset' => 1,
	'androidrelease' => 1,
	'angleaxis' => 1,
	'angleofattack' => 1,
	'angularvelocity' => 1,
	'anim' => 1,
	'animation' => 1,
	'animationcontrol' => 1,
	'animationframes' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'animationplays' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anoiselines' => 1,
	'anta' => 1,
	'apdi' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'appledataoffsets' => 1,
	'applemaildatereceived' => 1,
	'applemaildatesent' => 1,
	'applemailflagged' => 1,
	'applemailisremoteattachment' => 1,
	'applemailmessageid' => 1,
	'applemailpriority' => 1,
	'applemailread' => 1,
	'applemailrepliedto' => 1,
	'application' => 1,
	'application_riff' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationunknown' => 1,
	'applicationversion' => 1,
	'applysettingstoliveview' => 1,
	'appname' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'arcoreaccel' => 1,
	'arcoreaccel0' => 1,
	'arcorecustom' => 1,
	'arcoregyro' => 1,
	'arcoregyro0' => 1,
	'arcorevideo' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artists' => 1,
	'artisturl' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiounwarped' => 1,
	'aspectratiowarped' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantdirector' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'associateddatalist' => 1,
	'associatedimagefile' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'ast' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'atob3' => 1,
	'atom0' => 1,
	'atsccontent' => 1,
	'attachbinary' => 1,
	'attachfileextension' => 1,
	'attachfilename' => 1,
	'attachlongfilename' => 1,
	'attachlongpathname' => 1,
	'attachments' => 1,
	'attachmethod' => 1,
	'attachmimetype' => 1,
	'attachnum' => 1,
	'attachpathname' => 1,
	'attachsize' => 1,
	'attitude' => 1,
	'attitudetarget' => 1,
	'attr' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobluetooth' => 1,
	'audiobytes' => 1,
	'audiochannellayout' => 1,
	'audiochanneltypes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiokeys' => 1,
	'audiolayer' => 1,
	'audiolevel' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioprotuneoption' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosetting' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoridentifier' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorname' => 1,
	'authors' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'autoareaafstartingpoint' => 1,
	'autoboostscore' => 1,
	'autocaptureoffset' => 1,
	'autoisomin' => 1,
	'autolowlightduration' => 1,
	'automationanimation' => 1,
	'automationflags' => 1,
	'autopoweroff' => 1,
	'autoprotune' => 1,
	'autorotation' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'auxiliaryimageref' => 1,
	'av1configuration' => 1,
	'av1configurationversion' => 1,
	'avcconfiguration' => 1,
	'averagebitrate' => 1,
	'averageframerate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbdebuginfo' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'axml' => 1,
	'b1' => 1,
	'b2' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barcodes' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'basename' => 1,
	'baseviewpointnum' => 1,
	'basicfileinfo' => 1,
	'basisobject' => 1,
	'battery' => 1,
	'batterycapacity' => 1,
	'batterycurrent' => 1,
	'batteryinfo' => 1,
	'batterystatus' => 1,
	'batterytime' => 1,
	'batteryvoltage3' => 1,
	'batteryvoltage4' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats' => 1,
	'beats-per-minute' => 1,
	'beautycolorlevel' => 1,
	'beautyenable' => 1,
	'beautyretouchlevel' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'bibligraphicfilename' => 1,
	'bibliographicreferences' => 1,
	'bikebroaccel' => 1,
	'bikebrogps' => 1,
	'billinginformation' => 1,
	'binarydata' => 1,
	'binarydatatype' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'binning' => 1,
	'birthday' => 1,
	'bitdepthchroma' => 1,
	'bitdepthluma' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitratesetting' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackadcountsperdacvolt' => 1,
	'blackclamp' => 1,
	'blackclampoffset' => 1,
	'blackcolsleft' => 1,
	'blackcolsright' => 1,
	'blackdacchannel' => 1,
	'blackdacsettlingmsec' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blackrowsbottom' => 1,
	'blackrowstop' => 1,
	'blacktarget' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'blueendpoint' => 1,
	'bluegain' => 1,
	'bluegrassscale1' => 1,
	'bluegrassscale2' => 1,
	'bluegrasstable' => 1,
	'bluemask' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetoothmacaddress' => 1,
	'bluetoothname' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'blurstrength' => 1,
	'blush' => 1,
	'bmpversion' => 1,
	'boardtemperature' => 1,
	'body' => 1,
	'bokehshape' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bootidentifier' => 1,
	'bootrecord' => 1,
	'bootsystem' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottomdarkrow1' => 1,
	'bottomdarkrow2' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bpm' => 1,
	'bps' => 1,
	'bracketingburstoptions' => 1,
	'bracketingcounter' => 1,
	'bracketingmode' => 1,
	'bracketingoffset' => 1,
	'bracketingstep' => 1,
	'bracketshot' => 1,
	'brain' => 1,
	'brandingimageid' => 1,
	'brandingname' => 1,
	'brdfatob0' => 1,
	'brdfatob1' => 1,
	'brdfatob2' => 1,
	'brdfatob3' => 1,
	'brdfbtoa0' => 1,
	'brdfbtoa1' => 1,
	'brdfbtoa2' => 1,
	'brdfbtoa3' => 1,
	'brdfbtod0' => 1,
	'brdfbtod1' => 1,
	'brdfbtod2' => 1,
	'brdfbtod3' => 1,
	'brdfcolorimetricparam0' => 1,
	'brdfcolorimetricparam1' => 1,
	'brdfcolorimetricparam2' => 1,
	'brdfcolorimetricparam3' => 1,
	'brdfdtob0' => 1,
	'brdfdtob1' => 1,
	'brdfdtob2' => 1,
	'brdfdtob3' => 1,
	'brdfmtob0' => 1,
	'brdfmtob1' => 1,
	'brdfmtob2' => 1,
	'brdfmtob3' => 1,
	'brdfmtos0' => 1,
	'brdfmtos1' => 1,
	'brdfmtos2' => 1,
	'brdfmtos3' => 1,
	'brdfspectralparam0' => 1,
	'brdfspectralparam1' => 1,
	'brdfspectralparam2' => 1,
	'brdfspectralparam3' => 1,
	'breakchar' => 1,
	'briefdescription' => 1,
	'brightdefectintegrationms' => 1,
	'brightdefectisocode' => 1,
	'brightdefectthreshold' => 1,
	'brightnessdata' => 1,
	'brightrowstop' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'brotliexif' => 1,
	'brotlijumb' => 1,
	'brotlixmp' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btoa3' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwf_umid' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'byteordermark' => 1,
	'byterange' => 1,
	'bytes' => 1,
	'bytesperline' => 1,
	'bytesperminute' => 1,
	'bytespersample' => 1,
	'c2pa' => 1,
	'c2pasalthash' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'cafpointinfo' => 1,
	'cafpointsinfocus' => 1,
	'cafpointsselected' => 1,
	'cafsensitivity' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'calibrationlog' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'callsign' => 1,
	'camcore' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameraifd' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraoperator' => 1,
	'camerapan' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'cameratemperaturemaxclip' => 1,
	'cameratemperaturemaxsaturated' => 1,
	'cameratemperaturemaxwarn' => 1,
	'cameratemperatureminclip' => 1,
	'cameratemperatureminsaturated' => 1,
	'cameratemperatureminwarn' => 1,
	'cameratilt' => 1,
	'camm0' => 1,
	'camm1' => 1,
	'camm2' => 1,
	'camm3' => 1,
	'camm4' => 1,
	'camm5' => 1,
	'camm6' => 1,
	'camm7' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1200d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo700d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo750d' => 1,
	'canoncamerainfo760d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfo80d' => 1,
	'canoncamerainfog5xii' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfor6' => 1,
	'canoncamerainfor6m2' => 1,
	'canoncamerainfor6m3' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncctp' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedelaytimer' => 1,
	'capturedevicefid' => 1,
	'captureheightresetblacksegnormal' => 1,
	'captureheightresetblacksegtest' => 1,
	'captureheighttest' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturewidthresetblacksegnormal' => 1,
	'capturewidthresetblacksegtest' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'car' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'catalognumber' => 1,
	'caveats' => 1,
	'cbor' => 1,
	'cbordata' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdi1' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfagreenthreshold1' => 1,
	'cfagreenthreshold2' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channel01' => 1,
	'channel01description' => 1,
	'channel01dispmax' => 1,
	'channel01dispmin' => 1,
	'channel01flags' => 1,
	'channel01id' => 1,
	'channel01interval' => 1,
	'channel01max' => 1,
	'channel01min' => 1,
	'channel01multiplier' => 1,
	'channel01name' => 1,
	'channel01num' => 1,
	'channel01offset' => 1,
	'channel01type' => 1,
	'channel01units' => 1,
	'channel0lagkernel' => 1,
	'channel1coordinates' => 1,
	'channel1flags' => 1,
	'channel1label' => 1,
	'channel1lagkernel' => 1,
	'channel2coordinates' => 1,
	'channel2flags' => 1,
	'channel2label' => 1,
	'channel2lagkernel' => 1,
	'channel3coordinates' => 1,
	'channel3flags' => 1,
	'channel3label' => 1,
	'channel3lagkernel' => 1,
	'channel4coordinates' => 1,
	'channel4flags' => 1,
	'channel4label' => 1,
	'channel5coordinates' => 1,
	'channel5flags' => 1,
	'channel5label' => 1,
	'channel6coordinates' => 1,
	'channel6flags' => 1,
	'channel6label' => 1,
	'channel7coordinates' => 1,
	'channel7flags' => 1,
	'channel7label' => 1,
	'channel8coordinates' => 1,
	'channel8flags' => 1,
	'channel8label' => 1,
	'channelcoarsegainadjust' => 1,
	'channelcolordata' => 1,
	'channelcolorindicates' => 1,
	'channelcolorspace' => 1,
	'channelcount' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'channelopacity' => 1,
	'channeloptions' => 1,
	'channeltype' => 1,
	'channelusage' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'character' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'checksum' => 1,
	'children' => 1,
	'chmversion' => 1,
	'choregrapher' => 1,
	'chromaformat' => 1,
	'chromasampleposition' => 1,
	'chromaticaberrationparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chrominancetable' => 1,
	'chunkcount' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'churchillnav' => 1,
	'cicodepoints' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classificationandmarkingsystem' => 1,
	'classificationcomments' => 1,
	'classificationdatapresent' => 1,
	'classificationreason' => 1,
	'classifiedby' => 1,
	'classifyingcountry' => 1,
	'classifyingcountrycodemethod' => 1,
	'classifyingcountrycodingmethoddate' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipcenterx' => 1,
	'clipcentery' => 1,
	'clipheight' => 1,
	'cliphflip' => 1,
	'cliphflipeffect' => 1,
	'cliphozperspective' => 1,
	'clipinfovalue' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cliprotate' => 1,
	'cliprotateeffect' => 1,
	'cliprotation' => 1,
	'cliprotationeffect' => 1,
	'clipverperspective' => 1,
	'clipvflip' => 1,
	'clipvflipeffect' => 1,
	'clipwidth' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'closedcaptiontrack' => 1,
	'cmddialsaperturesetting' => 1,
	'cmddialschangemainsub' => 1,
	'cmddialschangemainsubexposure' => 1,
	'cmddialsmenuandplayback' => 1,
	'cmddialsreverserotexposurecomp' => 1,
	'cmmflags' => 1,
	'cmp1' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantinfoout' => 1,
	'colorantorder' => 1,
	'colorantorderout' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalance0219' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown1' => 1,
	'colorbalanceunknown2' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalib2' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcoefs2' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata10' => 1,
	'colordata11' => 1,
	'colordata12' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordata9' => 1,
	'colordataunknown' => 1,
	'colorencodingparams' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetricspecification' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorpopstrength' => 1,
	'colorprimaries' => 1,
	'colorprofiles' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspacename' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortemperatures' => 1,
	'colortransferfuncs' => 1,
	'colortransferfunction' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'columncount' => 1,
	'columngainfactors' => 1,
	'columnresetoffsets' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentby' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblefontname' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'componenttable' => 1,
	'composernationality' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositeimaginglocalset' => 1,
	'compositinglayerheader' => 1,
	'compositionlocation' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressioncodecs' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductors' => 1,
	'confidencemapimage' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'connectortype' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'constantframerate' => 1,
	'constraintindicatorflags' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerversion' => 1,
	'contentbranding' => 1,
	'contentdescribes' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributorduration' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentlightlevel' => 1,
	'contentprotected' => 1,
	'contentprotectedpercent' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstatus' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastdetectaf' => 1,
	'contrastinfo' => 1,
	'controller' => 1,
	'controllevel' => 1,
	'conttake' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'coordinateunits' => 1,
	'coproducer' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coringtablebest' => 1,
	'coringtablebetter' => 1,
	'coringtablegood' => 1,
	'cornerlatitude1' => 1,
	'cornerlatitude2' => 1,
	'cornerlatitude3' => 1,
	'cornerlatitude4' => 1,
	'cornerlongitude1' => 1,
	'cornerlongitude2' => 1,
	'cornerlongitude3' => 1,
	'cornerlongitude4' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coyotesense' => 1,
	'coyotestatus' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'cr2cfapattern' => 1,
	'crc' => 1,
	'crcdevelparams' => 1,
	'crd' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorapp' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatormodule' => 1,
	'creatoros' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'creditclass' => 1,
	'creditdir' => 1,
	'creditname' => 1,
	'creditrole' => 1,
	'crediturl' => 1,
	'crgbtoerimm0spline' => 1,
	'crgbtoerimm1spline' => 1,
	'crgbtoerimm2spline' => 1,
	'crgbtoerimm3spline' => 1,
	'crgbtoerimm4spline' => 1,
	'crgbtoerimm5spline' => 1,
	'crgbtoerimm6spline' => 1,
	'crgbtoerimm7spline' => 1,
	'crgbtoerimm8spline' => 1,
	'crgbtoerimm9spline' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossbarenable' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs0' => 1,
	'cs1' => 1,
	'ctmd' => 1,
	'cubemapproj' => 1,
	'cuepoint' => 1,
	'cuepointlabel' => 1,
	'cuepointnote' => 1,
	'cuepoints' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'custominfo' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5' => 1,
	'customsettingsd500' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd610' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'customsettingsz6iii' => 1,
	'customsettingsz8' => 1,
	'customsettingsz9' => 1,
	'customsettingsz9v4' => 1,
	'customtostandardpcc' => 1,
	'cxf' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'd2' => 1,
	'daccountspervolt' => 1,
	'dacgainscoarse' => 1,
	'dacgainscoarseadjpreif41' => 1,
	'dacgainsfine' => 1,
	'dacvoltages' => 1,
	'dacvoltagesflush' => 1,
	'darkcircle' => 1,
	'darkcorrectiontype' => 1,
	'darkmapscale' => 1,
	'darkrefoffsetnormal' => 1,
	'darkrefoffsettest' => 1,
	'darkthreshold' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'dataformat' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datapreparer' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datasize64' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'date1' => 1,
	'date2' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateencoded' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datepurchased' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetagged' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'datewritten' => 1,
	'daymat0' => 1,
	'daymat1' => 1,
	'daymat2' => 1,
	'daymat3' => 1,
	'daymat4' => 1,
	'daymat5' => 1,
	'daymat6' => 1,
	'daymat7' => 1,
	'daymat8' => 1,
	'daymat9' => 1,
	'db' => 1,
	'dblcoldcacthres1' => 1,
	'dblcoldcacthres2' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dcs3xxprocessinginfo' => 1,
	'dcs3xxprocessinginfoifd' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'declassificationdate' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultcmyk' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultsettings' => 1,
	'defaultstyle' => 1,
	'defectconcealartcorrectthres' => 1,
	'defectconcealthrestable' => 1,
	'defectcount' => 1,
	'defectlist' => 1,
	'defectlistpacked' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'definition' => 1,
	'delay' => 1,
	'delaycols' => 1,
	'delaytime' => 1,
	'delimiter' => 1,
	'delta12to8spline' => 1,
	'delta8to12spline' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'densityaltitude' => 1,
	'densityaltitudeextended' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'depthhwheight' => 1,
	'depthhwwidth' => 1,
	'depthmapdata' => 1,
	'depthmapdata2' => 1,
	'depthmapheight' => 1,
	'depthmapimage' => 1,
	'depthmapname' => 1,
	'depthmaptiff' => 1,
	'depthmapwidth' => 1,
	'depthswheight' => 1,
	'depthswwidth' => 1,
	'derivedimageref' => 1,
	'desc' => 1,
	'descender' => 1,
	'descriptionurl' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detectedfacebounds' => 1,
	'detectedfaceid' => 1,
	'detectedfacerollangle' => 1,
	'detectedfaceyawangle' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicecodename' => 1,
	'devicecontainer' => 1,
	'devicehardwarerevision' => 1,
	'deviceid' => 1,
	'devicemake' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'deviceorientation' => 1,
	'devicesettings' => 1,
	'devicesounds' => 1,
	'dex' => 1,
	'diagonalfieldofview' => 1,
	'dialect' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'differentialpressure' => 1,
	'difftilegains24t852822' => 1,
	'difftilegains602832' => 1,
	'digestalgorithm' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalexposurebiases' => 1,
	'digitalexposuregains' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'digitalzoomamount' => 1,
	'dimensions' => 1,
	'directionalatob0' => 1,
	'directionalatob1' => 1,
	'directionalatob2' => 1,
	'directionalatob3' => 1,
	'directionalbtoa0' => 1,
	'directionalbtoa1' => 1,
	'directionalbtoa2' => 1,
	'directionalbtoa3' => 1,
	'directionalbtod0' => 1,
	'directionalbtod1' => 1,
	'directionalbtod2' => 1,
	'directionalbtod3' => 1,
	'directionaldtob0' => 1,
	'directionaldtob1' => 1,
	'directionaldtob2' => 1,
	'directionaldtob3' => 1,
	'directorofphotography' => 1,
	'directors' => 1,
	'disableflagspresent' => 1,
	'discardobjects' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distance' => 1,
	'distancefromhome' => 1,
	'distortinfo' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'dji-dbg' => 1,
	'dji_dtat' => 1,
	'djidebug' => 1,
	'djimetadata' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'dloinfo' => 1,
	'dmeroderadius' => 1,
	'dmfillrejthresh' => 1,
	'dmnoisescale' => 1,
	'dmnumpatches' => 1,
	'dmpixelthresholdfactor' => 1,
	'dmsmoothrejthresh' => 1,
	'dmtrimfraction' => 1,
	'dmwindowthresholdfactor' => 1,
	'docclass' => 1,
	'docflags' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'docversion' => 1,
	'dof' => 1,
	'domain' => 1,
	'donotshow' => 1,
	'dop' => 1,
	'dotrange' => 1,
	'dotsperinch' => 1,
	'downsampleby2hor' => 1,
	'downsampleby2hor3mpdcr' => 1,
	'downsampleby2ver' => 1,
	'downsampleby2ver3mpdcr' => 1,
	'downsampleby3hor' => 1,
	'downsampleby3ver' => 1,
	'downsampleby4hor' => 1,
	'downsampleby4ver' => 1,
	'downsampleby6hor' => 1,
	'downsampleby6ver' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivesettings' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'drone-dji' => 1,
	'droneinfo' => 1,
	'dronepitch' => 1,
	'dronequaternion' => 1,
	'droneroll' => 1,
	'droneyaw' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'dtvcontent' => 1,
	'dualcameraimage' => 1,
	'dualcameraimagename' => 1,
	'dualfiles' => 1,
	'dualshotextra' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'dummycolsleft' => 1,
	'dummycolsright' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'durationsetting' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'dynamicranger128' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edgespline' => 1,
	'edgesplinehigh' => 1,
	'edgesplinelow' => 1,
	'edgesplinemed' => 1,
	'edit4data' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'ef' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectleveloriginal' => 1,
	'effectstrength' => 1,
	'effectsvisible' => 1,
	'effecttype' => 1,
	'effectvalue' => 1,
	'eighteenpercentpoint' => 1,
	'eighthlanguage' => 1,
	'electricalextendermagnification' => 1,
	'electronicimagestabilization' => 1,
	'electronicstabilizationon' => 1,
	'electronicvr' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimage2' => 1,
	'embeddedimageclass' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagerectangle' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'embeddedjpg' => 1,
	'embeddedpng' => 1,
	'embeddedvideo' => 1,
	'embeddedvideofile' => 1,
	'embeddedvideooffsetsize' => 1,
	'embeddedvideotype' => 1,
	'emergencysos' => 1,
	'emphasis' => 1,
	'empty' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encoderoptions' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encodetime' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endianness' => 1,
	'endmotionvideo' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'environmenttarget' => 1,
	'environmenttargetunicode' => 1,
	'envvardata' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'equirectangularproj' => 1,
	'erimmnonlinearityspline' => 1,
	'erimmtocrgb0spline' => 1,
	'erimmtocrgb1spline' => 1,
	'erimmtocrgb2spline' => 1,
	'erimmtocrgb3spline' => 1,
	'erimmtocrgb4spline' => 1,
	'erimmtocrgb5spline' => 1,
	'erimmtocrgb6spline' => 1,
	'erimmtocrgb7spline' => 1,
	'erimmtocrgb8spline' => 1,
	'erimmtocrgb9spline' => 1,
	'erimmtonescale0spline' => 1,
	'erimmtonescale1spline' => 1,
	'erimmtonescale2spline' => 1,
	'erimmtonescale3spline' => 1,
	'erimmtonescale4spline' => 1,
	'erimmtonescale5spline' => 1,
	'erimmtonescale6spline' => 1,
	'erimmtonescale7spline' => 1,
	'erimmtonescale8spline' => 1,
	'erimmtonescale9spline' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escapestatus' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'et' => 1,
	'evalstate' => 1,
	'eventlogcapture' => 1,
	'eventlogprocess' => 1,
	'events' => 1,
	'eventstarttime' => 1,
	'evstepinfo' => 1,
	'exceptionendtime' => 1,
	'exceptionstarttime' => 1,
	'exefilename' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exififd' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinfo7' => 1,
	'exifinfo8' => 1,
	'exifinfo9' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expirationspan' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureheadroomfactor' => 1,
	'exposureinfo' => 1,
	'exposurereferencegain' => 1,
	'exposurereferenceoffset' => 1,
	'exposuretimemax' => 1,
	'exposuretimemin' => 1,
	'exposuretimes' => 1,
	'exposuretype' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedalbumname' => 1,
	'extendedartistname' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedlanguagetag' => 1,
	'extendedstreamprops' => 1,
	'extendedtracktitle' => 1,
	'extendedxmp' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionid' => 1,
	'extensionitemid' => 1,
	'extensionitemname' => 1,
	'extensionitemvalue' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'extraticklocations' => 1,
	'extremeweathermode' => 1,
	'eyebrows' => 1,
	'eyeenlarge' => 1,
	'f-stop' => 1,
	'f_' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetected' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'faceitem' => 1,
	'facenumbers' => 1,
	'facepos' => 1,
	'facerec' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'faceslimming' => 1,
	'factorywhitegainsdaylight' => 1,
	'factorywhiteoffsetsdaylight' => 1,
	'farklewhitethreshold' => 1,
	'fastseek' => 1,
	'fax' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fcc-id' => 1,
	'fdsc' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'fileguid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterindication' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterparametersbinary' => 1,
	'filterparameterscustomcustomdata' => 1,
	'filterparametersexportexportdata' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'filtertype' => 1,
	'finalflushsequence' => 1,
	'finalframeblocks' => 1,
	'finetune' => 1,
	'finishedfileprocessingrequest' => 1,
	'finishedimage' => 1,
	'finishipaversion' => 1,
	'finishipfversion' => 1,
	'firmwareinfo' => 1,
	'firmwareversion51' => 1,
	'firmwareversion56' => 1,
	'firstchar' => 1,
	'firstflushsequence' => 1,
	'firstlanguage' => 1,
	'firstlines' => 1,
	'firstlinetransfertiming' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfo0106' => 1,
	'flashinfo0107' => 1,
	'flashinfo0300' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashmat0' => 1,
	'flashmat1' => 1,
	'flashmat2' => 1,
	'flashmat3' => 1,
	'flashmat4' => 1,
	'flashmat5' => 1,
	'flashmat6' => 1,
	'flashmat7' => 1,
	'flashmat8' => 1,
	'flashmat9' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashused' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flightdegree' => 1,
	'flightspeed' => 1,
	'flipstatus' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'flirdata' => 1,
	'fluormat0' => 1,
	'fluormat1' => 1,
	'fluormat2' => 1,
	'fluormat3' => 1,
	'fluormat4' => 1,
	'fluormat5' => 1,
	'fluormat6' => 1,
	'fluormat7' => 1,
	'fluormat8' => 1,
	'fluormat9' => 1,
	'flushtiming' => 1,
	'flyingstate' => 1,
	'focalinfo' => 1,
	'focallength35efl' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusbracketinginfo' => 1,
	'focusdistance2' => 1,
	'focusedgemap' => 1,
	'focusframesize' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspointbrightness' => 1,
	'focuspointselectionspeed' => 1,
	'focuspos' => 1,
	'focussettings' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'follow-meanimation' => 1,
	'follow-memode' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'forcedsubtitletrack' => 1,
	'form' => 1,
	'formatid' => 1,
	'formatsdcard' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fps' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framebaseview' => 1,
	'framecenterelevation' => 1,
	'framecenterheightaboveellipsoid' => 1,
	'framecenterlatitude' => 1,
	'framecenterlongitude' => 1,
	'framedelay' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'frameisp_4' => 1,
	'framepriority' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'frameview' => 1,
	'framinggriddisplay' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fuelremaining' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullangleofattack' => 1,
	'fullname' => 1,
	'fullpitchangle' => 1,
	'fullrollangle' => 1,
	'fullscreen' => 1,
	'fullsideslipangle' => 1,
	'fusion360fly' => 1,
	'fusionmode' => 1,
	'fusionypr' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gainmapimage' => 1,
	'gammablue' => 1,
	'gammagreen' => 1,
	'gammainfo' => 1,
	'gammared' => 1,
	'gammatable' => 1,
	'gamut' => 1,
	'gamutboundarydescription0' => 1,
	'gamutboundarydescription1' => 1,
	'gamutboundarydescription2' => 1,
	'gamutboundarydescription3' => 1,
	'gapless' => 1,
	'garmingps' => 1,
	'garminmodel' => 1,
	'gaudio' => 1,
	'gaussianweights' => 1,
	'gcamera' => 1,
	'gcontainer' => 1,
	'gcreations' => 1,
	'gdepth' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generalencapsulatedobject' => 1,
	'generallevelidc' => 1,
	'generalprofileidc' => 1,
	'generalprofilespace' => 1,
	'generaltierflag' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genericflagdata01' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genimageversion' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genprofilecompatibilityflags' => 1,
	'genr' => 1,
	'geo' => 1,
	'geob-data' => 1,
	'geob-desc' => 1,
	'geob-file' => 1,
	'geob-mime' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geolocationbearing' => 1,
	'geolocationcity' => 1,
	'geolocationcountry' => 1,
	'geolocationcountrycode' => 1,
	'geolocationdistance' => 1,
	'geolocationfeaturecode' => 1,
	'geolocationfeaturetype' => 1,
	'geolocationpopulation' => 1,
	'geolocationposition' => 1,
	'geolocationregion' => 1,
	'geolocationsubregion' => 1,
	'geolocationtimezone' => 1,
	'geolocationwarning' => 1,
	'geometricdistortionparams' => 1,
	'georegistrationlocalset' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gfocus' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gimage' => 1,
	'gimbaldegree' => 1,
	'gimbalinfo' => 1,
	'gimbalpitch' => 1,
	'gimbalroll' => 1,
	'gimbalyaw' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'gkudata' => 1,
	'glamoursettings' => 1,
	'globalinfo' => 1,
	'globalpalette' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'google' => 1,
	'googlebot' => 1,
	'gopro' => 1,
	'goprogpmf' => 1,
	'goudarequesttext' => 1,
	'gpano' => 1,
	'gpmd_fmas' => 1,
	'gpmd_gopro' => 1,
	'gpmd_kingslim' => 1,
	'gpmd_rove' => 1,
	'gpmd_wolfbox' => 1,
	'gps' => 1,
	'gps360fly' => 1,
	'gpsaltituderaw' => 1,
	'gpsaltitudesystem' => 1,
	'gpsdata' => 1,
	'gpsdatalist' => 1,
	'gpsdatalist2' => 1,
	'gpsdatetimeraw' => 1,
	'gpsdestaltitude' => 1,
	'gpsframingaltitude' => 1,
	'gpsframinglatitude' => 1,
	'gpsframinglongitude' => 1,
	'gpshomelatitude' => 1,
	'gpshomelongitude' => 1,
	'gpshorizontalaccuracy' => 1,
	'gpsinfo' => 1,
	'gpsinfo9' => 1,
	'gpslatitude2' => 1,
	'gpslatituderaw' => 1,
	'gpslog' => 1,
	'gpslongitude2' => 1,
	'gpslongituderaw' => 1,
	'gpsmode' => 1,
	'gpspos' => 1,
	'gpsraw' => 1,
	'gpsspeed3d' => 1,
	'gpsspeedaccuracy' => 1,
	'gpsspeedraw' => 1,
	'gpsspeedx' => 1,
	'gpsspeedy' => 1,
	'gpsspeedz' => 1,
	'gpsstamp' => 1,
	'gpstargetaltitude' => 1,
	'gpstargetlatitude' => 1,
	'gpstargetlongitude' => 1,
	'gpstrackraw' => 1,
	'gpsvalid' => 1,
	'gpsvelocitydown' => 1,
	'gpsvelocityeast' => 1,
	'gpsvelocitynorth' => 1,
	'gpsvelocityup' => 1,
	'gpsverticalaccuracy' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'gravityvector' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greenendpoint' => 1,
	'greengain' => 1,
	'greenmask' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'gridsize' => 1,
	'groundrange' => 1,
	'groupareac1' => 1,
	'groupcaption' => 1,
	'groupmutualexclusion' => 1,
	'groups' => 1,
	'gsensor' => 1,
	'gspherical' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guano' => 1,
	'gyro360fly' => 1,
	'gyromode' => 1,
	'gyroscope' => 1,
	'gyroscopeunknown' => 1,
	'gyroypr' => 1,
	'halftonedegree' => 1,
	'halftonelpi' => 1,
	'halftonelpiunit' => 1,
	'halftonemisc' => 1,
	'halftonescreen' => 1,
	'halftoneshape' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hardpostpadding' => 1,
	'hardprepadding' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasrealmergeddata' => 1,
	'hasscript' => 1,
	'hasselbladexif' => 1,
	'hasselbladrawimage' => 1,
	'hasselbladxml' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdcontent' => 1,
	'hdgainmapinfo' => 1,
	'hdmibitdepth' => 1,
	'hdmiexternalrecorder' => 1,
	'hdmioutputhdr' => 1,
	'hdmioutputrange' => 1,
	'hdrgaincurve' => 1,
	'hdrgaincurvesize' => 1,
	'hdrgaininfo' => 1,
	'hdrgainmap' => 1,
	'hdrgm' => 1,
	'hdrimage' => 1,
	'hdrinfo' => 1,
	'hdrinfo2' => 1,
	'hdrinfoversion' => 1,
	'hdrl' => 1,
	'hdrpsoftware' => 1,
	'hdrtoninginfo' => 1,
	'hdrvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'headshrinking' => 1,
	'healthlogs' => 1,
	'heightresolution' => 1,
	'hevcconfiguration' => 1,
	'hevcconfigurationversion' => 1,
	'hiddendata' => 1,
	'hiddeninfo' => 1,
	'hiddenslides' => 1,
	'highbitdepth' => 1,
	'highisomode' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'highlightmarkers' => 1,
	'highnote' => 1,
	'highvelocity' => 1,
	'hindsightsettings' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintmaxoutputvalue' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'histogram' => 1,
	'historybuffersize' => 1,
	'hmaphandling' => 1,
	'hmcolrejthresh' => 1,
	'hmcolthresh' => 1,
	'hmpixthresh' => 1,
	'hmwsize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizoncontrol' => 1,
	'horizontalfieldofview' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hostsoftwareexportversion' => 1,
	'hotkey' => 1,
	'hotspotx' => 1,
	'hotspoty' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'hrnoiselines' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huawei' => 1,
	'huffmantable' => 1,
	'huffmantablelength' => 1,
	'huffmantablevalue' => 1,
	'hyperfocaldistance' => 1,
	'hyperlapsdebuginfo' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'iad1' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iccprofilelocation' => 1,
	'icingdetected' => 1,
	'icondir' => 1,
	'iconenvdata' => 1,
	'iconfile' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3-2' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idlesequence' => 1,
	'idletiming' => 1,
	'idlist' => 1,
	'idsbasevalue' => 1,
	'idstring' => 1,
	'ifd0' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illuminantdetectordata' => 1,
	'illuminantdetecttable' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagecompressiontable' => 1,
	'imagecoordinatesystem' => 1,
	'imagedatadiscard' => 1,
	'imagedatahash' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imageexpansiontable' => 1,
	'imagefields' => 1,
	'imagefilecharacteristics' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imagegeometry' => 1,
	'imageheader' => 1,
	'imageheightinches' => 1,
	'imagehorizonpixelpack' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagelocation' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imagename' => 1,
	'imageoffset' => 1,
	'imagepixeldepth' => 1,
	'imagepixelformat' => 1,
	'imagepixeloffset' => 1,
	'imagepixelstorage' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresources' => 1,
	'imagerinitialtimingcode' => 1,
	'imagerlogicprogram' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagertimingdata' => 1,
	'imagesampleformat' => 1,
	'imagesensorgain' => 1,
	'imagesourceek' => 1,
	'imagespatialextent' => 1,
	'imagestabilisation' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imagewidthinches' => 1,
	'imageworkstationmake' => 1,
	'imagingdata' => 1,
	'imdb' => 1,
	'imdb_id' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'inbandratingattributes' => 1,
	'inbandratinglevel' => 1,
	'inbandratingsystem' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexbackground' => 1,
	'indexed' => 1,
	'indexedcolortablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'indextransparent' => 1,
	'indicatedairspeed' => 1,
	'indications' => 1,
	'infirayfactory' => 1,
	'infirayisothermal' => 1,
	'infiraymixmode' => 1,
	'infirayopmode' => 1,
	'infiraypicture' => 1,
	'infiraysensor' => 1,
	'infirayversion' => 1,
	'info' => 1,
	'ingrreserved' => 1,
	'initialdelaysamples' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'initparamstext' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'inputheight' => 1,
	'inputorientation' => 1,
	'inputuniformity' => 1,
	'inputwidth' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'insta360' => 1,
	'insta360info' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'instruments' => 1,
	'insv' => 1,
	'integratetiming' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpolationcoefficients' => 1,
	'interpolationcoefficients3mp' => 1,
	'interpolationcoefficients6mp' => 1,
	'interpretedby' => 1,
	'intervaloffset' => 1,
	'inversemonitormatrix' => 1,
	'inverserimnonlinearity' => 1,
	'inversesbalog12transform' => 1,
	'inversesbalogtransform' => 1,
	'invnifnonlinearity' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isaifilterreeditonly' => 1,
	'isapplyshapecorrection' => 1,
	'isartbokeh' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'isblending' => 1,
	'isbrightnessipe' => 1,
	'iscompleted' => 1,
	'iscontrastipe' => 1,
	'isdecoreeditonly' => 1,
	'isdeleted' => 1,
	'isexposureipe' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'ismotionvideomute' => 1,
	'isnetworkfeed' => 1,
	'isnewreeditonly' => 1,
	'isnotreedit' => 1,
	'isoautooffset' => 1,
	'isocalibrationgaintable' => 1,
	'isoinfo' => 1,
	'isomax' => 1,
	'isomin' => 1,
	'isonline' => 1,
	'isospeeds' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'issaturationipe' => 1,
	'isscaleai' => 1,
	'istrimmotionvideo' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemdesignatorid' => 1,
	'itemid' => 1,
	'iteminfoentry' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemproperties' => 1,
	'itempropertyassociation' => 1,
	'itempropertycontainer' => 1,
	'itemprotection' => 1,
	'itemreference' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'ixml' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg-likedata' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpegimagelength' => 1,
	'jpeginfo' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtablebest' => 1,
	'jpegqtablebetter' => 1,
	'jpegqtablegood' => 1,
	'jpegqtables' => 1,
	'jpegqualityestimate' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jpgfromraw2' => 1,
	'jpginfooffset' => 1,
	'jplcartoifd' => 1,
	'jps' => 1,
	'jpscomment' => 1,
	'jpsflags' => 1,
	'jpslayout' => 1,
	'jpsseparation' => 1,
	'jpstype' => 1,
	'jsondata' => 1,
	'jsoninfo' => 1,
	'jsonmetadata' => 1,
	'jumbf' => 1,
	'jumbfbox' => 1,
	'jumbfdescr' => 1,
	'jumdid' => 1,
	'jumdlabel' => 1,
	'jumdsignature' => 1,
	'jumdtoggles' => 1,
	'jumdtype' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'jxlcodestream' => 1,
	'k1' => 1,
	'k2' => 1,
	'k3' => 1,
	'k4' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'keepexposurewithteleconverter' => 1,
	'keepuntil' => 1,
	'keepusersettings' => 1,
	'kelvinwb' => 1,
	'kenwooddata' => 1,
	'keyalgorithm' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'keyversion' => 1,
	'kf' => 1,
	'kf8coveruri' => 1,
	'kfix' => 1,
	'khufui0thresholds' => 1,
	'khufui1thresholds' => 1,
	'khufui2thresholds' => 1,
	'khufui3thresholds' => 1,
	'khufui4thresholds' => 1,
	'khufui5thresholds' => 1,
	'khufulinearbluemixingcoefficient' => 1,
	'khufulineargreenmixingcoefficient' => 1,
	'khufulinearredmixingcoefficient' => 1,
	'khufusigmagaussianweights' => 1,
	'khufusigmascalingfactors14mp' => 1,
	'khufusigmascalingfactors3mp' => 1,
	'khufusigmascalingfactors6mp' => 1,
	'khufuuspacec2mixingcoefficient' => 1,
	'kids' => 1,
	'kilocalories' => 1,
	'kinds' => 1,
	'kj' => 1,
	'kk' => 1,
	'klut' => 1,
	'klut12tolin12' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'kstb' => 1,
	'kvar' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'labelcode' => 1,
	'labeledtext' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'languages' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'laserprfcode' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'lawrating' => 1,
	'layerblendmodes' => 1,
	'layercolors' => 1,
	'layercomps' => 1,
	'layercount' => 1,
	'layergroupsenabledid' => 1,
	'layerids' => 1,
	'layermodifydates' => 1,
	'layernames' => 1,
	'layeropacities' => 1,
	'layerrectangles' => 1,
	'layers' => 1,
	'layersections' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layerunicodenames' => 1,
	'layervisible' => 1,
	'layout' => 1,
	'layoutflags' => 1,
	'lccn' => 1,
	'lcdedgemapslope' => 1,
	'lcdedgemapx1' => 1,
	'lcdedgemapx2' => 1,
	'lcdedgemapx3' => 1,
	'lcdedgemapx4' => 1,
	'lcdedgespline' => 1,
	'lcdgammatable' => 1,
	'lcdgammatablechickfix' => 1,
	'lcdgammatablemarvin' => 1,
	'lcdhistlut0' => 1,
	'lcdhistlut1' => 1,
	'lcdhistlut2' => 1,
	'lcdhistlut3' => 1,
	'lcdhistlut4' => 1,
	'lcdhistlut5' => 1,
	'lcdhistlut6' => 1,
	'lcdhistlut7' => 1,
	'lcdhistlut8' => 1,
	'lcdhistlut9' => 1,
	'lcdlinearclipvalue' => 1,
	'lcdsharpeningf1' => 1,
	'lcdsharpeningf2' => 1,
	'lcdsharpeningf3' => 1,
	'lcdsharpeningf4' => 1,
	'lcdstepyvalues' => 1,
	'lcdstepyvalueschickfix' => 1,
	'lcdstepyvaluesmarvin' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkcol1' => 1,
	'leftdarkcol2' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'leftmargin' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leglonger' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensattached' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdata0402' => 1,
	'lensdata0403' => 1,
	'lensdata0800' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfacing' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lensnumber' => 1,
	'lenspartnumber' => 1,
	'lensprojection' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'lenstableindex' => 1,
	'levelinfo' => 1,
	'levelinfok3iii' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseeclass' => 1,
	'licenseedir' => 1,
	'licenseinfourl' => 1,
	'licenseurl' => 1,
	'lightbalance' => 1,
	'lightingopt' => 1,
	'lightleveloriginal' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'ligogpsinfo' => 1,
	'ligojson' => 1,
	'limage' => 1,
	'limitaf-areamodeselautoanimals' => 1,
	'limitaf-areamodeselautopeople' => 1,
	'limitaf-areamodeseldynamic' => 1,
	'limitaf-areamodeselwidelanimals' => 1,
	'limitaf-areamodeselwidelpeople' => 1,
	'limitafareamodesel3d' => 1,
	'limitafareamodeseld105' => 1,
	'limitafareamodeseld25' => 1,
	'limitafareamodeseld49' => 1,
	'limitafareamodeseld9' => 1,
	'limitafareamodeselgroup' => 1,
	'limitafareamodeselgroupc1' => 1,
	'limitafareamodeselgroupc2' => 1,
	'limitreleasemodeselmirror-up' => 1,
	'limitreleasemodeselq' => 1,
	'limitreleasemodeseltimer' => 1,
	'limitselectableimagearea5to4' => 1,
	'lin12toklut12' => 1,
	'lin12toklut8' => 1,
	'linearitysplinetags' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'linecount' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkedfilename' => 1,
	'linkedprofilename' => 1,
	'linkerversion' => 1,
	'linkgoodput' => 1,
	'linkinfo' => 1,
	'linkquality' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'linlogtable' => 1,
	'linux' => 1,
	'lipstick' => 1,
	'listtype' => 1,
	'lit' => 1,
	'livephotoinfo' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'localpositionned' => 1,
	'locationinfo' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'loggingmetadatatext' => 1,
	'loginfo' => 1,
	'loglintable' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmat0' => 1,
	'lookmat1' => 1,
	'lookmat2' => 1,
	'lookmat3' => 1,
	'lookmat4' => 1,
	'lookmat5' => 1,
	'lookmat6' => 1,
	'lookmat7' => 1,
	'lookmat8' => 1,
	'lookmat9' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopcount' => 1,
	'lotus' => 1,
	'lowlightaf' => 1,
	'lownote' => 1,
	'lowvelocity' => 1,
	'lr' => 1,
	'lslv' => 1,
	'lucasjunk' => 1,
	'lumaaverage' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'luminancetable' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'mag360fly' => 1,
	'magmode' => 1,
	'magneticfield' => 1,
	'magneticheading' => 1,
	'magneticvariation' => 1,
	'magnetometer' => 1,
	'magnetometerxyz' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotebyteorder' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotericohpentax2' => 1,
	'makernotericohpentax3' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'mappingsignature' => 1,
	'mappingxcoefficients' => 1,
	'mappingxmode' => 1,
	'mappingycoefficients' => 1,
	'mappingymode' => 1,
	'mapscale' => 1,
	'mariahthresholds' => 1,
	'mariahthresholdslow' => 1,
	'mariahthresholdsnormal' => 1,
	'mariahthresholdsstrong' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'marl' => 1,
	'marlindataversion' => 1,
	'marlindictionary' => 1,
	'marlinheader' => 1,
	'marlinvalues' => 1,
	'masksubarea' => 1,
	'masteredby' => 1,
	'mastergainadjustment' => 1,
	'matrixcoefficients' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxanalogiso' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxcontentlightlevel' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxpicaveragelightlevel' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mccdata' => 1,
	'mcdi' => 1,
	'md5signature' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mditemaccounthandles' => 1,
	'mditemaccountidentifier' => 1,
	'mditemacquisitionmake' => 1,
	'mditemacquisitionmodel' => 1,
	'mditemaltitude' => 1,
	'mditemaperture' => 1,
	'mditemaudiobitrate' => 1,
	'mditemaudiochannelcount' => 1,
	'mditemauthoremailaddresses' => 1,
	'mditemauthors' => 1,
	'mditembitspersample' => 1,
	'mditembundleidentifier' => 1,
	'mditemcity' => 1,
	'mditemcodecs' => 1,
	'mditemcolorspace' => 1,
	'mditemcomment' => 1,
	'mditemcontentcreationdate' => 1,
	'mditemcontentcreationdate_ranking' => 1,
	'mditemcontentcreationdateranking' => 1,
	'mditemcontentmodificationdate' => 1,
	'mditemcontenttype' => 1,
	'mditemcontenttypetree' => 1,
	'mditemcontributors' => 1,
	'mditemcopyright' => 1,
	'mditemcountry' => 1,
	'mditemcreator' => 1,
	'mditemdateadded' => 1,
	'mditemdateadded_ranking' => 1,
	'mditemdescription' => 1,
	'mditemdisplayname' => 1,
	'mditemdownloadeddate' => 1,
	'mditemdurationseconds' => 1,
	'mditememailconversationid' => 1,
	'mditemencodingapplications' => 1,
	'mditemexifgpsversion' => 1,
	'mditemexifversion' => 1,
	'mditemexposuremode' => 1,
	'mditemexposureprogram' => 1,
	'mditemexposuretimeseconds' => 1,
	'mditemflashonoff' => 1,
	'mditemfnumber' => 1,
	'mditemfocallength' => 1,
	'mditemfscontentchangedate' => 1,
	'mditemfscreatorcode' => 1,
	'mditemfsfinderflags' => 1,
	'mditemfshascustomicon' => 1,
	'mditemfsinvisible' => 1,
	'mditemfsisextensionhidden' => 1,
	'mditemfsisstationery' => 1,
	'mditemfsname' => 1,
	'mditemfsnodecount' => 1,
	'mditemfsownergroupid' => 1,
	'mditemfsowneruserid' => 1,
	'mditemfssize' => 1,
	'mditemfstypecode' => 1,
	'mditemgpsdatestamp' => 1,
	'mditemgpsstatus' => 1,
	'mditemgpstrack' => 1,
	'mditemhasalphachannel' => 1,
	'mditemidentifier' => 1,
	'mditemimagedirection' => 1,
	'mditeminterestingdate_ranking' => 1,
	'mditeminterestingdateranking' => 1,
	'mditemisapplicationmanaged' => 1,
	'mditemisexistingthread' => 1,
	'mditemislikelyjunk' => 1,
	'mditemisospeed' => 1,
	'mditemkeywords' => 1,
	'mditemkind' => 1,
	'mditemlastuseddate' => 1,
	'mditemlastuseddate_ranking' => 1,
	'mditemlatitude' => 1,
	'mditemlensmodel' => 1,
	'mditemlogicalsize' => 1,
	'mditemlongitude' => 1,
	'mditemmailboxes' => 1,
	'mditemmaildatereceived_ranking' => 1,
	'mditemmediatypes' => 1,
	'mditemnumberofpages' => 1,
	'mditemorientation' => 1,
	'mditemoriginapplicationidentifier' => 1,
	'mditemoriginmessageid' => 1,
	'mditemoriginsenderdisplayname' => 1,
	'mditemoriginsenderhandle' => 1,
	'mditemoriginsubject' => 1,
	'mditempageheight' => 1,
	'mditempagewidth' => 1,
	'mditemphysicalsize' => 1,
	'mditempixelcount' => 1,
	'mditempixelheight' => 1,
	'mditempixelwidth' => 1,
	'mditemprimaryrecipientemailaddresses' => 1,
	'mditemprofilename' => 1,
	'mditemrecipients' => 1,
	'mditemredeyeonoff' => 1,
	'mditemresolutionheightdpi' => 1,
	'mditemresolutionwidthdpi' => 1,
	'mditemsecuritymethod' => 1,
	'mditemspeed' => 1,
	'mditemstateorprovince' => 1,
	'mditemstreamable' => 1,
	'mditemsubject' => 1,
	'mditemtimestamp' => 1,
	'mditemtitle' => 1,
	'mditemtotalbitrate' => 1,
	'mditemusecount' => 1,
	'mditemuseddates' => 1,
	'mditemuserdownloadeddate' => 1,
	'mditemuserdownloadeduserhandle' => 1,
	'mditemusersharedreceiveddate' => 1,
	'mditemusersharedreceivedrecipient' => 1,
	'mditemusersharedreceivedrecipienthandle' => 1,
	'mditemusersharedreceivedsender' => 1,
	'mditemusersharedreceivedsenderhandle' => 1,
	'mditemusersharedreceivedtransport' => 1,
	'mditemversion' => 1,
	'mditemvideobitrate' => 1,
	'mditemwherefroms' => 1,
	'mditemwhitebalance' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measure' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementinputinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'mebx' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediabox' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediadataoffset' => 1,
	'mediadatasize' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaismovie' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaissport' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'mediamode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediaoriginalchannelsubnumber' => 1,
	'mediaoriginalruntime' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediathumbaspectratiox' => 1,
	'mediathumbaspectratioy' => 1,
	'mediathumbheight' => 1,
	'mediathumbratingattributes' => 1,
	'mediathumbratinglevel' => 1,
	'mediathumbratingsystem' => 1,
	'mediathumbret' => 1,
	'mediathumbstride' => 1,
	'mediathumbtimestamp' => 1,
	'mediathumbwidth' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediauniqueid' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'melodicpolyphony' => 1,
	'menuoffset' => 1,
	'menusettingsoffset' => 1,
	'menusettingsoffsetz7ii' => 1,
	'menusettingsoffsetz8v1' => 1,
	'menusettingsoffsetz8v2' => 1,
	'menusettingsoffsetz9' => 1,
	'menusettingsoffsetz9v3' => 1,
	'menusettingsoffsetz9v4' => 1,
	'menusettingsz8' => 1,
	'mergedimage' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metadatasource' => 1,
	'metadataversion' => 1,
	'metaformat' => 1,
	'metaimagesize' => 1,
	'metarelation' => 1,
	'metasampledesc' => 1,
	'metatype' => 1,
	'metdata' => 1,
	'meter' => 1,
	'meterinfo' => 1,
	'meteringbutton' => 1,
	'meteringframecount' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'mett' => 1,
	'microphonewet' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'midicontrol' => 1,
	'midicontrolversion' => 1,
	'midipitchfraction' => 1,
	'midisong' => 1,
	'midiunitynote' => 1,
	'mie' => 1,
	'miiscoreidentifier' => 1,
	'mileage' => 1,
	'mimeencoding' => 1,
	'mimetype' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumflushrows' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'minspatialsegmentationidc' => 1,
	'mintransmissiontime' => 1,
	'missionid' => 1,
	'mixedby' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modelstamp' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modified' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'monomonitormatrix' => 1,
	'monostrength' => 1,
	'monotonescaletable' => 1,
	'monouniquematrix' => 1,
	'montage' => 1,
	'month' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'moresettingsoffset' => 1,
	'mosaicpattern' => 1,
	'motionphotoautoplayvideo' => 1,
	'mouthmodify' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviefragment' => 1,
	'moviefragmentheader' => 1,
	'moviefragmentsequence' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'moviehighlightdisplaypattern' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'moviewhitebalancesameasphoto' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'mtoa0' => 1,
	'mtob0' => 1,
	'mtob1' => 1,
	'mtob2' => 1,
	'mtob3' => 1,
	'mtos0' => 1,
	'mtos1' => 1,
	'mtos2' => 1,
	'mtos3' => 1,
	'multiexp' => 1,
	'multiexposure2' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiplexdefaultvalues' => 1,
	'multiplextypearray' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multishoton' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'mynextbase-paireddevicename' => 1,
	'mynextbase-pairing' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'nbcd' => 1,
	'ncc' => 1,
	'ndeversion' => 1,
	'nemoblurkernel' => 1,
	'nemodarklimit' => 1,
	'nemogainfactors' => 1,
	'nemohighlight12limit' => 1,
	'nemotilesize' => 1,
	'nestedsignalstream' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'newlines' => 1,
	'nextbasemeta' => 1,
	'nexttrackid' => 1,
	'nifnonlinearity' => 1,
	'nifnonlinearity12bit' => 1,
	'nifnonlinearity12to16' => 1,
	'nifnonlinearity16bit' => 1,
	'nifnonlinearityext' => 1,
	'nikon' => 1,
	'nikonapp' => 1,
	'nikondata' => 1,
	'nikondatetime' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonnefinfo' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'nine' => 1,
	'nineedits' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'noisereductionkernel' => 1,
	'noisereductionparametershostlow' => 1,
	'noisereductionparametershostnormal' => 1,
	'noisereductionparametershoststrong' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'non-primarysourcetrack' => 1,
	'normallinetransfertiming' => 1,
	'noseslimming' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nrwdata' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numberlicenseplate' => 1,
	'numberlist' => 1,
	'numberofbytes' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numberofsamples' => 1,
	'numberofsamples64' => 1,
	'numchanneldescriptions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numplanes' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numsampleloops' => 1,
	'numslices' => 1,
	'numstreams' => 1,
	'numtemporallayers' => 1,
	'objectcountrycodes' => 1,
	'objectcountrycodingmethod' => 1,
	'objectcountrycodingmethoddate' => 1,
	'objectfiletype' => 1,
	'objectflags' => 1,
	'objectid' => 1,
	'objectorientation' => 1,
	'objectsizeannounced' => 1,
	'observationdate' => 1,
	'observationdateend' => 1,
	'observationtime' => 1,
	'observationtimeend' => 1,
	'observer' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offset13' => 1,
	'offsetcornerlatitude1' => 1,
	'offsetcornerlatitude2' => 1,
	'offsetcornerlatitude3' => 1,
	'offsetcornerlatitude4' => 1,
	'offsetcornerlongitude1' => 1,
	'offsetcornerlongitude2' => 1,
	'offsetcornerlongitude3' => 1,
	'offsetcornerlongitude4' => 1,
	'offsetmaphorizontal' => 1,
	'offsetmapvertical' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'oleinfo' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'omenatcapturemode' => 1,
	'omenearlygobcolumns' => 1,
	'omenearlygobrows' => 1,
	'omenearlygobsurface' => 1,
	'omengradientexclusionlimits' => 1,
	'omengradientkernel' => 1,
	'omengradientkerneltaps' => 1,
	'omengradientoffset' => 1,
	'omeninitialcolumns' => 1,
	'omeninitialrows' => 1,
	'omeninitialscaling' => 1,
	'omenmeantostrength' => 1,
	'omenpercenttorationallimitsblue' => 1,
	'omenpercenttorationallimitsgob' => 1,
	'omenpercenttorationallimitsgor' => 1,
	'omenpercenttorationallimitsred' => 1,
	'omenrangeweighting' => 1,
	'omenratioclipfactors' => 1,
	'omenratioexclusionfactors' => 1,
	'omenroicoefficients' => 1,
	'omenroicoordinates' => 1,
	'omensmoothingkernel' => 1,
	'on1_settingsdata' => 1,
	'on1_settingsmetadatacreated' => 1,
	'on1_settingsmetadatamodified' => 1,
	'on1_settingsmetadataname' => 1,
	'on1_settingsmetadatapluginid' => 1,
	'on1_settingsmetadatatimestamp' => 1,
	'on1_settingsmetadatausage' => 1,
	'on1_settingsmetadatavisibletouser' => 1,
	'oneplus' => 1,
	'oneplustrailerlen' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationalmode' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'opticalvr' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'opus' => 1,
	'opusversion' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'orientationdatapresent' => 1,
	'orientationinfo' => 1,
	'orientationoffset' => 1,
	'orientoffset' => 1,
	'original' => 1,
	'originalalbum' => 1,
	'originaldate' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalframerate' => 1,
	'originalimagebroker' => 1,
	'originalmedia' => 1,
	'originalmediatype' => 1,
	'originalmedium' => 1,
	'originalpath' => 1,
	'originalpathhashkey' => 1,
	'originalpayloadframecount' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalsoftpostpadding' => 1,
	'originalsoftprepadding' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originalyear' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherdate1' => 1,
	'otherdate2' => 1,
	'otherdate3' => 1,
	'otherfirmware' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'othermeta' => 1,
	'othername' => 1,
	'otheroffset' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherserialnumber' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputgain' => 1,
	'outputheight' => 1,
	'outputorientation' => 1,
	'outputresponse' => 1,
	'outputwidth' => 1,
	'overclockcolsright' => 1,
	'overclockrowsbottom' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'parallelismtype' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalratingreason' => 1,
	'parkingmode' => 1,
	'parrotautomation' => 1,
	'parrotfollowme' => 1,
	'parrottimestamp' => 1,
	'parrotv1' => 1,
	'parrotv2' => 1,
	'parrotv3' => 1,
	'part' => 1,
	'partialactivecolsleft' => 1,
	'partialactivecolsright' => 1,
	'partialactiverowsbottom' => 1,
	'partialactiverowstop' => 1,
	'partialjxlcodestream' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partoffset' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'pathtablelocation' => 1,
	'pathtablesize' => 1,
	'patternangle' => 1,
	'patterncorrectionfactors' => 1,
	'patterncorrectiongains' => 1,
	'patterncorrectionoffsets' => 1,
	'patterngainconversiontable' => 1,
	'payloadframe' => 1,
	'payloadmetadatatext' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdbage' => 1,
	'pdbcreatedate' => 1,
	'pdbfilename' => 1,
	'pdbmodifydate' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'pdrversion' => 1,
	'peakbitrate' => 1,
	'peaklevelr128' => 1,
	'peaklevelsample' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'peg_info' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxdata2' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'percussivepolyphony' => 1,
	'perfmode' => 1,
	'performersortorder' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'phone' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoresolution' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'photoshopstream' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pilotingmode' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchrollyaw' => 1,
	'pittasoft' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelcorrectiongains' => 1,
	'pixelexposuretime' => 1,
	'pixelformat' => 1,
	'pixelinfo' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'playbackflickdownrating' => 1,
	'playbackflickuprating' => 1,
	'playbackframerate' => 1,
	'playcounter' => 1,
	'playlist' => 1,
	'playlistdelay' => 1,
	'playlistindex' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'pointsize' => 1,
	'polynomialcoefficients' => 1,
	'polynomialpower' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'portraiteffectid' => 1,
	'portraiteffectidoriginal' => 1,
	'portraiteffectlevel' => 1,
	'portraiteffectvalue' => 1,
	'portraitexifrotation' => 1,
	'portraitlightlevel' => 1,
	'portraitmatrix' => 1,
	'portraitoffset' => 1,
	'portraitrefocusx' => 1,
	'portraitrefocusy' => 1,
	'portraittonescaletable' => 1,
	'portraittouchx' => 1,
	'portraittouchy' => 1,
	'poseyawdegrees' => 1,
	'position' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2crd3' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'powerprofile' => 1,
	'pragma' => 1,
	'predominanthue' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'prefersubselectorcenter' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimage1' => 1,
	'previewimage2' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewjxl' => 1,
	'previewjxllength' => 1,
	'previewjxlstart' => 1,
	'previewpdf' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtiff' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryfileguid' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'primaryvolume' => 1,
	'printflags' => 1,
	'printflagsbleedwidth' => 1,
	'printflagsbleedwidthscale' => 1,
	'printflagscrop' => 1,
	'printflagsinfo' => 1,
	'printflagsversion' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printposition' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printscaleinfo' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prioritysettings' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingnotes' => 1,
	'processingparameters' => 1,
	'processingtime' => 1,
	'processparametersv2' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productioncopyright' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversionnumber' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledataoffset' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profilesequenceinfo' => 1,
	'profilesize' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programid' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projectidcode' => 1,
	'projection' => 1,
	'projectionboundsbottom' => 1,
	'projectionboundsleft' => 1,
	'projectionboundsright' => 1,
	'projectionboundstop' => 1,
	'projectionheader' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'protocol' => 1,
	'protune' => 1,
	'protuneisomode' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'ptrh' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasecurrency' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purchaseitem' => 1,
	'purchaseowner' => 1,
	'purchaseprice' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qtablelarge100pct' => 1,
	'qtablelarge25pct' => 1,
	'qtablelarge50pct' => 1,
	'qtablelarge67pct' => 1,
	'qtablemedium100pct' => 1,
	'qtablemedium25pct' => 1,
	'qtablemedium50pct' => 1,
	'qtablemedium67pct' => 1,
	'qtablesmall100pct' => 1,
	'qtablesmall25pct' => 1,
	'qtablesmall50pct' => 1,
	'qtablesmall67pct' => 1,
	'qualcomm' => 1,
	'qualcommdualcamera' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'quietshuttershootingspeed' => 1,
	'quoting' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafcompression' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rangeimagelocalset' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawburstmoderoll' => 1,
	'rawcfacomponentaverages' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawdevsubifd' => 1,
	'rawexposurebias' => 1,
	'rawgsensor' => 1,
	'rawhistogram' => 1,
	'rawimageaspectratio' => 1,
	'rawimagecroppedsize' => 1,
	'rawimagecroptopleft' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagenumber' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawvaluerangemax' => 1,
	'rawvaluerangemin' => 1,
	'rawzoomactive' => 1,
	'rawzoomsize' => 1,
	'rawzoomtopleft' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readername' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'rearcontropaneldisplay' => 1,
	'recallshootfuncaf-on' => 1,
	'recallshootfuncafareamode' => 1,
	'recallshootfuncaperture' => 1,
	'recallshootfuncexposurecomp' => 1,
	'recallshootfuncexposuremode' => 1,
	'recallshootfuncfocustracking' => 1,
	'recallshootfunciso' => 1,
	'recallshootfuncmeteringmode' => 1,
	'recallshootfuncshutterspeed' => 1,
	'recallshootfuncwhitebalance' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingdates' => 1,
	'recordinghistory' => 1,
	'recordinglocation' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'records' => 1,
	'recordsv2' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'rectifacetext' => 1,
	'red1header' => 1,
	'red2header' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redcodeversion' => 1,
	'redendpoint' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmask' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reeditdata' => 1,
	'reelnumber' => 1,
	'reeltimecode' => 1,
	'reference' => 1,
	'referencename' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectedtemperature' => 1,
	'reflection' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refocusxoriginal' => 1,
	'refocusyoriginal' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'registerreadtiming' => 1,
	'relatedimagefile' => 1,
	'relatedresources' => 1,
	'relationship' => 1,
	'relativeexposure' => 1,
	'relativehumidity' => 1,
	'relativelocation' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'releasinginstructions' => 1,
	'remasterinfo' => 1,
	'rembrandtconsumertonescale' => 1,
	'rembrandtportraittonescale' => 1,
	'rembrandttonescale' => 1,
	'remindertime' => 1,
	'remixedby' => 1,
	'remotefuncbutton' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaingain' => 1,
	'replaygainpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replaytrackgain' => 1,
	'replaytrackpeak' => 1,
	'replayvolumelevel' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeframeloc' => 1,
	'representativeimage' => 1,
	'requestid' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'reserved5' => 1,
	'reservedblob2' => 1,
	'reservedblob3' => 1,
	'reservedblob4' => 1,
	'reservedblob5' => 1,
	'reservedblob6' => 1,
	'reservedblob7' => 1,
	'reservedblob8' => 1,
	'reservedblob9' => 1,
	'resize' => 1,
	'resolutioninfo' => 1,
	'resolutionxlengthunit' => 1,
	'resolutionxunit' => 1,
	'resolutionylengthunit' => 1,
	'resolutionyunit' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'reversingcamera' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'rgbcurves' => 1,
	'rgbtoev0' => 1,
	'rgbtoev1' => 1,
	'rgbtoev2' => 1,
	'rgbtoev3' => 1,
	'rgbtoev4' => 1,
	'rgbtoev5' => 1,
	'rgbtoev6' => 1,
	'rgbtoev7' => 1,
	'rgbtoev8' => 1,
	'rgbtoev9' => 1,
	'rgtable' => 1,
	'ricoh' => 1,
	'ricohinfo' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrdta' => 1,
	'ricohrdtb' => 1,
	'ricohrdtc' => 1,
	'ricohrdtg' => 1,
	'ricohrdtl' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'riffsize64' => 1,
	'rightdarkcol1' => 1,
	'rightdarkcol2' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rimm13toerimm12spline' => 1,
	'rimmtocrgb0spline' => 1,
	'rimmtocrgb1spline' => 1,
	'rimmtocrgb2spline' => 1,
	'rimmtocrgb3spline' => 1,
	'rimmtocrgb4spline' => 1,
	'rimmtocrgb5spline' => 1,
	'rimmtocrgb6spline' => 1,
	'rimmtocrgb7spline' => 1,
	'rimmtocrgb8spline' => 1,
	'rimmtocrgb9spline' => 1,
	'rimnonlinearity' => 1,
	'rimtonifcolortransform' => 1,
	'rimtonifscalefactor' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'rnoiselines' => 1,
	'roamed' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'rollingshutterskewtime' => 1,
	'root' => 1,
	'rootdirectorycreatedate' => 1,
	'rootnote' => 1,
	'rot360fly' => 1,
	'rotationangle' => 1,
	'rotationinfooffset' => 1,
	'rotationxyz' => 1,
	'rotmode' => 1,
	'roundtripversion' => 1,
	'rovegps' => 1,
	'rowcount' => 1,
	'rowinterleavefactor' => 1,
	'rsrc' => 1,
	'rtmd' => 1,
	'rtos' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	'rvmi_grev' => 1,
	'rvmi_srev' => 1,
	'rvtlocalset' => 1,
	's2n' => 1,
	'sample' => 1,
	'sampleblacksequence' => 1,
	'samplecount' => 1,
	'sampledatetime' => 1,
	'sampledegradationpriority' => 1,
	'sampleduration' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'sampleperiod' => 1,
	'sampler' => 1,
	'samplerate2' => 1,
	'samplerdata' => 1,
	'samplerdatalen' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletime' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungcaptureinfo' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungmodel' => 1,
	'samsungrawbyteorder' => 1,
	'samsungrawpointerslength' => 1,
	'samsungrawpointersoffset' => 1,
	'samsungrawunknown' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'samsungtrailer' => 1,
	'samsunguniqueid' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'sarmotionimagerydata' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'savefocus' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbabluebalancelut' => 1,
	'sbaexposurerecord' => 1,
	'sbagreenbalancelut' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'sbalog12transform' => 1,
	'sbalogtransform' => 1,
	'sbaredbalancelut' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scaledimu' => 1,
	'scaledpressure' => 1,
	'scalefactor' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'scav11cols' => 1,
	'scav12cols' => 1,
	'scav21cols' => 1,
	'scav22cols' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'sceneclassification' => 1,
	'scenecolorimetryestimates' => 1,
	'sceneilluminance' => 1,
	'schedulecapture' => 1,
	'schedulecapturetime' => 1,
	'scheduleitemid' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screendimming' => 1,
	'screenheight' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenplayby' => 1,
	'screensaver' => 1,
	'screenwidth' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'script' => 1,
	'scriptcommand' => 1,
	'sdc' => 1,
	'sdcardclass' => 1,
	'sdcardformat' => 1,
	'sdcardmanfdate' => 1,
	'sdcardmanfid' => 1,
	'sdcardmodelno' => 1,
	'sdcardoemid' => 1,
	'sdcardserialno' => 1,
	'sdcardsize' => 1,
	'sdcardtype' => 1,
	'sdcardusedspace' => 1,
	'sdcc-flp' => 1,
	'sealcomment' => 1,
	'sealversion' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondcam' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'securitylocalmetadataset' => 1,
	'securitysci-shiinformation' => 1,
	'securityversion' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'segheight' => 1,
	'segmentlocalset' => 1,
	'segwidth' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'semanticinstanceid' => 1,
	'semanticname' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensitivityvalue' => 1,
	'sensorbottomborder' => 1,
	'sensordata' => 1,
	'sensordefects' => 1,
	'sensorellipsoidheight' => 1,
	'sensorellipsoidheightextended' => 1,
	'sensorfieldofviewname' => 1,
	'sensorid' => 1,
	'sensorinfo' => 1,
	'sensorname' => 1,
	'sensorreadouttime' => 1,
	'sensorrelativeazimuthangle' => 1,
	'sensorrelativeelevationangle' => 1,
	'sensorrelativerollangle' => 1,
	'sensorrightborder' => 1,
	'sensorvelocityeast' => 1,
	'sensorvelocitynorth' => 1,
	'sepversion' => 1,
	'seqcount' => 1,
	'seqfinal' => 1,
	'seqframeinfo' => 1,
	'seqid' => 1,
	'seqindex' => 1,
	'seqlevelidx0' => 1,
	'seqprofile' => 1,
	'seqtier0' => 1,
	'seqtype' => 1,
	'sequencenumberrandomoffset' => 1,
	'sequenceoffset' => 1,
	'serialinfo' => 1,
	'serialnumber2' => 1,
	'seriesuid' => 1,
	'serviceid' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'settingsoffset' => 1,
	'seventhlanguage' => 1,
	'sfsboundary' => 1,
	'sglcoldcacthres1' => 1,
	'sglcoldcacthres2' => 1,
	'sglcoldcacthres3' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'sharedwith' => 1,
	'sharpenforthumbnail' => 1,
	'sharpeningon' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shifttiming' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingmenuoffset' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod500' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod6' => 1,
	'shotinfod610' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod7500' => 1,
	'shotinfod780' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod850' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'shotinfoz6iii' => 1,
	'shotinfoz7ii' => 1,
	'shotinfoz8' => 1,
	'shotinfoz9' => 1,
	'shotlogdatatext' => 1,
	'shotparamstext' => 1,
	'showcommand' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutterangle' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sidelightstrength' => 1,
	'sideslipangle' => 1,
	'sigma' => 1,
	'sigmaexif' => 1,
	'sigmanoisefiltercaltablev1' => 1,
	'sigmanoisefiltertablev1' => 1,
	'sigmanoisefiltertablev1version' => 1,
	'sigmanoisethreshtablev2' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureformat' => 1,
	'signaturelength' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'singleshotdepthmap' => 1,
	'singleshotdepthmaptiff' => 1,
	'singleshotmeta' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'siunits' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'skipinfo' => 1,
	'slantrange' => 1,
	'slateinformation' => 1,
	'sliceinfo' => 1,
	'slicesgroupname' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'slowmotionrate' => 1,
	'slowmotionregions' => 1,
	'slowmotionregionsdurationepoch' => 1,
	'slowmotionregionsdurationflags' => 1,
	'slowmotionregionsdurationtimescale' => 1,
	'slowmotionregionsdurationvalue' => 1,
	'slowmotionregionsstarttimeepoch' => 1,
	'slowmotionregionsstarttimeflags' => 1,
	'slowmotionregionsstarttimescale' => 1,
	'slowmotionregionsstarttimevalue' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'smoother' => 1,
	'smpteformat' => 1,
	'smpteoffset' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwaredate' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sony_0x9416' => 1,
	'sonyfnumber2' => 1,
	'sonyhiddendata' => 1,
	'sonyrawfiletype' => 1,
	'sonytonecurve' => 1,
	'sortwith' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialaudio' => 1,
	'spatialaudioversion' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'spectralviewingconditions' => 1,
	'spectralwhitepoint' => 1,
	'speed' => 1,
	'speedrampsetting' => 1,
	'speedstamp' => 1,
	'speedunits' => 1,
	'sphericalvideo' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spinstrength' => 1,
	'spothalftone' => 1,
	'spotmeter' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'standardtocustompcc' => 1,
	'standbymonitorofftime' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startedgecode' => 1,
	'startmotionvideo' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'staticmetadatatext' => 1,
	'staticpressure' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'statisticstags' => 1,
	'statisticswritingapp' => 1,
	'statisticswritingdateutc' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereoscopic3d' => 1,
	'stillimagetime' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchcolumns' => 1,
	'stitchinfo' => 1,
	'stitchrows' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'storageformatdate' => 1,
	'storageformattime' => 1,
	'storagemodel' => 1,
	'storageserialnumber' => 1,
	'storagetype' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streamid' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'structuretype' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdialframeadvance' => 1,
	'subdialframeadvancerating0' => 1,
	'subdialframeadvancerating1' => 1,
	'subdialframeadvancerating2' => 1,
	'subdialframeadvancerating3' => 1,
	'subdialframeadvancerating4' => 1,
	'subdialframeadvancerating5' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitletrack' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'summarytext' => 1,
	'surfacemap' => 1,
	'surroundmode' => 1,
	'surroundshotvideo' => 1,
	'surroundshotvideoname' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncronizedtrack' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'synopsis' => 1,
	'systeminfo' => 1,
	'systemtime' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag2010i' => 1,
	'tag202a' => 1,
	'tag900b' => 1,
	'tag9050a' => 1,
	'tag9050b' => 1,
	'tag9050c' => 1,
	'tag9050d' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9401' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9404c' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag9406b' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'tag940e' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tailnumber' => 1,
	'take' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targeterrorestimatece90' => 1,
	'targeterrorestimatele90' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetlocationcovariancematrix' => 1,
	'targetlocationelevation' => 1,
	'targetlocationlatitude' => 1,
	'targetlocationlongitude' => 1,
	'targettrackgateheight' => 1,
	'targettrackgatewidth' => 1,
	'targetwidth' => 1,
	'targetwidthextended' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tattoo' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'teethwhitening' => 1,
	'telephonenumber' => 1,
	'telescope' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporalidnested' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'testtransfertiming' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'thanksto' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thermalcalibration' => 1,
	'thermaldata' => 1,
	'thermalparams' => 1,
	'thermalparams2' => 1,
	'thermalparams3' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailartist' => 1,
	'thumbnailbitspersample' => 1,
	'thumbnailbpg' => 1,
	'thumbnailclip' => 1,
	'thumbnailcolordepth' => 1,
	'thumbnailcompressedsize' => 1,
	'thumbnailcompression' => 1,
	'thumbnailcompressiontable' => 1,
	'thumbnailcopyright' => 1,
	'thumbnaildata' => 1,
	'thumbnaildatetime' => 1,
	'thumbnaildescription' => 1,
	'thumbnailequipmake' => 1,
	'thumbnailequipmodel' => 1,
	'thumbnailexpansiontable' => 1,
	'thumbnailhash' => 1,
	'thumbnailimageheight' => 1,
	'thumbnailimagewidth' => 1,
	'thumbnailorientation' => 1,
	'thumbnailphotometricinterp' => 1,
	'thumbnailplanarconfig' => 1,
	'thumbnailplanes' => 1,
	'thumbnailprimarychromaticities' => 1,
	'thumbnailrawbytes' => 1,
	'thumbnailref' => 1,
	'thumbnailrefblackwhite' => 1,
	'thumbnailresizeratio' => 1,
	'thumbnailresolutionunit' => 1,
	'thumbnailresolutionx' => 1,
	'thumbnailresolutiony' => 1,
	'thumbnailrowsperstrip' => 1,
	'thumbnailsamplesperpixel' => 1,
	'thumbnailsoftware' => 1,
	'thumbnailstripbytecounts' => 1,
	'thumbnailstripoffsets' => 1,
	'thumbnailtiff' => 1,
	'thumbnailtransferfunction' => 1,
	'thumbnailurl' => 1,
	'thumbnailwhitepoint' => 1,
	'thumbnailycbcrcoefficients' => 1,
	'thumbnailycbcrpositioning' => 1,
	'thumbnailycbcrsubsampling' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffmeteringimageheight' => 1,
	'tiffmeteringimagewidth' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tilegaindeterminationtable' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'time1' => 1,
	'time2' => 1,
	'timeanddate' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timecodetrack' => 1,
	'timeinfo' => 1,
	'timelapse' => 1,
	'timelineinfo' => 1,
	'timelogtext' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamplist' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'timezonedst' => 1,
	'tipl' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'tmdb' => 1,
	'tmdb_id' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tomtomad' => 1,
	'tomtomhl' => 1,
	'tomtomid' => 1,
	'tomtommetadata' => 1,
	'tomtomvd' => 1,
	'tomtomvi' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonescale0' => 1,
	'tonescale0spline' => 1,
	'tonescale1' => 1,
	'tonescale1spline' => 1,
	'tonescale2' => 1,
	'tonescale2spline' => 1,
	'tonescale3' => 1,
	'tonescale3spline' => 1,
	'tonescale4' => 1,
	'tonescale4spline' => 1,
	'tonescale5' => 1,
	'tonescale5spline' => 1,
	'tonescale6' => 1,
	'tonescale6spline' => 1,
	'tonescale7' => 1,
	'tonescale7spline' => 1,
	'tonescale8' => 1,
	'tonescale8spline' => 1,
	'tonescale9' => 1,
	'tonescale9spline' => 1,
	'tonespaceflow' => 1,
	'tonevalue' => 1,
	'tonscaletable' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topdarkrow1' => 1,
	'topdarkrow2' => 1,
	'topmag' => 1,
	'topmargin' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalparts' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'touchxoriginal' => 1,
	'touchyoriginal' => 1,
	'toycamerafilter' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackfragment' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transcripttrack' => 1,
	'transfercharacteristic' => 1,
	'transfercharacteristics' => 1,
	'transferrange' => 1,
	'transfersequence' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentcolor' => 1,
	'transparentindex' => 1,
	'transportstreamid' => 1,
	'trapindicator' => 1,
	'trashcolsright' => 1,
	'trashrowsbottom' => 1,
	'trim' => 1,
	'trueairspeed' => 1,
	'tty-ttdphone' => 1,
	'tungmat0' => 1,
	'tungmat1' => 1,
	'tungmat2' => 1,
	'tungmat3' => 1,
	'tungmat4' => 1,
	'tungmat5' => 1,
	'tungmat6' => 1,
	'tungmat7' => 1,
	'tungmat8' => 1,
	'tungmat9' => 1,
	'tuning' => 1,
	'tvdb' => 1,
	'twelvebit' => 1,
	'tx3g' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'uas_lsversionnumber' => 1,
	'uasdatalink' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'umid' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uniformresourcename' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'uniqueid' => 1,
	'uniqueidentifier' => 1,
	'unknown' => 1,
	'unknown00' => 1,
	'unknown01' => 1,
	'unknown02' => 1,
	'unknown03' => 1,
	'unknown_cndb' => 1,
	'unknown_grpl' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknownexif' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unsharpdata' => 1,
	'unshiftednote' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'unusedblackcolsleftin' => 1,
	'unusedblackcolsleftout' => 1,
	'unusedblackcolsrightin' => 1,
	'unusedblackcolsrightout' => 1,
	'unusedblackrowsbottomin' => 1,
	'unusedblackrowsbottomout' => 1,
	'unusedblackrowstopin' => 1,
	'unusedblackrowstopout' => 1,
	'unusedloggingmetadata' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'usermetadata' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'usertext' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usmparametershigh' => 1,
	'usmparametershost' => 1,
	'usmparametershost3mp' => 1,
	'usmparametershost6mp' => 1,
	'usmparameterslow' => 1,
	'usmparametersmed' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-c2paclaimsignature' => 1,
	'uuid-canon' => 1,
	'uuid-canon2' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-exif_bad' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-signature' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'validate' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vddimdacnominalvalues' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendorclass' => 1,
	'vendordir' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalaf-onbutton' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalfieldofview' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalspeed' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videoeditedtimezone' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videofullrangeflag' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videokeys' => 1,
	'videolength' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoorientation' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotimestamp' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignetteinfo' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'vignettingparams' => 1,
	'vintagestrength' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'visualflightruleshud' => 1,
	'visualsampledesc' => 1,
	'vivo' => 1,
	'vmaphandling' => 1,
	'vmcoldropthresh' => 1,
	'vmcolthresh' => 1,
	'vmnbands' => 1,
	'vmpatchreslimit' => 1,
	'vmpixthresh' => 1,
	'vmtidataset' => 1,
	'vmwsize' => 1,
	'volumeblockcount' => 1,
	'volumeblocksize' => 1,
	'volumecreatedate' => 1,
	'volumeeffectivedate' => 1,
	'volumeexpirationdate' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumelevelr128' => 1,
	'volumemodifydate' => 1,
	'volumename' => 1,
	'volumenormalization' => 1,
	'volumesetdiskcount' => 1,
	'volumesetdisknumber' => 1,
	'volumesetname' => 1,
	'volumesize' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watched' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarkremoved' => 1,
	'watermarkremovedoriginal' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_bluelevelauto' => 1,
	'wb_cfa0_leveldaylight' => 1,
	'wb_cfa1_leveldaylight' => 1,
	'wb_cfa2_leveldaylight' => 1,
	'wb_cfa3_leveldaylight' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_redlevelauto' => 1,
	'wb_rgbcoeffsdaylight' => 1,
	'wb_rgbcoeffsflash' => 1,
	'wb_rgbcoeffsfluorescent' => 1,
	'wb_rgbcoeffstungsten' => 1,
	'wb_rgblevelsasshot' => 1,
	'wb_rgblevelscustom' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluefluorescent' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreenfluorescent' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredfluorescent' => 1,
	'wbredtungsten' => 1,
	'wbsettings' => 1,
	'wbsettings2' => 1,
	'wbtemperature' => 1,
	'wcsprofiles' => 1,
	'weaponfired' => 1,
	'weaponload' => 1,
	'webp_flags' => 1,
	'webpage' => 1,
	'weight' => 1,
	'what3words' => 1,
	'whatsnew' => 1,
	'whitebalancematching' => 1,
	'whitebalancergb' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitening' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wi-fimacaddress' => 1,
	'wi-fipassword' => 1,
	'wi-fissid' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'wifirssi' => 1,
	'winddirection' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'windprocessing' => 1,
	'windspeed' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'woffversion' => 1,
	'word97' => 1,
	'worddocument' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wpgversion' => 1,
	'wrapmodes' => 1,
	'writername' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xattrapplemaildatereceived' => 1,
	'xattrapplemaildatesent' => 1,
	'xattrapplemailisremoteattachment' => 1,
	'xattrfinderinfo' => 1,
	'xattrlastuseddate' => 1,
	'xattrmditemdownloadeddate' => 1,
	'xattrmditemfindercomment' => 1,
	'xattrmdlabel' => 1,
	'xattrresourcefork' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xidiri' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmlpackets' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpdsa' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'ycrcbmatrix' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zifannotations' => 1,
	'zifmetadata' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilecomment' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zisrawversion' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
	'zoomposition' => 1,
	'zoomscalenormalization' => 1,
	'zoomstrength' => 1,
	'zxif' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'gpslatitude' => 'Image::ExifTool::GPS',
	'gpslongitude' => 'Image::ExifTool::GPS',
	'gpsposition' => 'Image::ExifTool::Exif',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'rotation' => 'Image::ExifTool::QuickTime',
	'subseccreatedate' => 'Image::ExifTool::Exif',
	'subsecdatetimeoriginal' => 'Image::ExifTool::Exif',
	'subsecmodifydate' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
    GROUPS      => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names to lookup corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level structure
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '${strName}'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $fieldInfo = $$strTable{$field};
        my $flatName;
        $flatName = $$fieldInfo{FlatName} if ref $fieldInfo eq 'HASH';
        $flatName or ($flatName = $field) =~ tr/-_a-zA-Z0-9//dc;    # remove illegal characters
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($flatName);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                my $lcFlat = $$newInfo{FlatName} ? lc($$newInfo{FlatName}) : $lcTag;
                AddFields($tagTablePtr, $tagID, $lcFlat, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (sort { $a <=> $b } keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    if ($writeProc) {
                        no strict 'refs';
                        $reload = 1 if &$writeProc();
                    }
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2026, Phil Harvey (philharvey66 at gmail.com)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
