/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PSSParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cryptopro.GOST3410NamedParameters;
import org.bouncycastle.asn1.cryptopro.GOST3410ParamSetParameters;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.misc.CAST5CBCParameters;
import org.bouncycastle.asn1.misc.IDEACBCPar;
import org.bouncycastle.asn1.oiw.ElGamalParameter;
import org.bouncycastle.asn1.pkcs.DHParameter;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.RC2CBCParameter;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;
import org.bouncycastle.jce.spec.GOST3410ParameterSpec;
import org.bouncycastle.jce.spec.IESParameterSpec;

public abstract class JDKAlgorithmParameters
extends AlgorithmParametersSpi {
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$RC2ParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$PBEParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$DHParameterSpec;
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;
    static /* synthetic */ Class class$org$bouncycastle$jce$spec$GOST3410PublicKeyParameterSetSpec;
    static /* synthetic */ Class class$org$bouncycastle$jce$spec$ElGamalParameterSpec;
    static /* synthetic */ Class class$org$bouncycastle$jce$spec$IESParameterSpec;
    static /* synthetic */ Class class$java$security$spec$PSSParameterSpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class PSS
    extends JDKAlgorithmParameters {
        PSSParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            PSSParameterSpec pSSParameterSpec = this.currentSpec;
            RSASSAPSSparams rSASSAPSSparams = new RSASSAPSSparams(RSASSAPSSparams.DEFAULT_HASH_ALGORITHM, RSASSAPSSparams.DEFAULT_MASK_GEN_FUNCTION, new DERInteger(pSSParameterSpec.getSaltLength()), RSASSAPSSparams.DEFAULT_TRAILER_FIELD);
            try {
                dEROutputStream.writeObject(rSASSAPSSparams);
                dEROutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error encoding PSSParameters");
            }
            return byteArrayOutputStream.toByteArray();
        }

        protected byte[] engineGetEncoded(String string) {
            if (string.equalsIgnoreCase("X.509") || string.equalsIgnoreCase("ASN.1")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$java$security$spec$PSSParameterSpec == null ? (class$java$security$spec$PSSParameterSpec = JDKAlgorithmParameters.class$("java.security.spec.PSSParameterSpec")) : class$java$security$spec$PSSParameterSpec) && this.currentSpec instanceof PSSParameterSpec) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to PSS parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof PSSParameterSpec)) {
                throw new InvalidParameterSpecException("PSSParameterSpec required to initialise an PSS algorithm parameters object");
            }
            this.currentSpec = (PSSParameterSpec)algorithmParameterSpec;
        }

        protected void engineInit(byte[] byArray) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            try {
                RSASSAPSSparams rSASSAPSSparams = new RSASSAPSSparams((ASN1Sequence)aSN1InputStream.readObject());
                this.currentSpec = new PSSParameterSpec(rSASSAPSSparams.getSaltLength().getValue().intValue());
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Not a valid PSS Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Not a valid PSS Parameter encoding.");
            }
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (!string.equalsIgnoreCase("X.509") && !string.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown parameter format " + string);
            }
            this.engineInit(byArray);
        }

        protected String engineToString() {
            return "PSS Parameters";
        }
    }

    public static class IES
    extends JDKAlgorithmParameters {
        IESParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            try {
                ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
                aSN1EncodableVector.add(new DEROctetString(this.currentSpec.getDerivationV()));
                aSN1EncodableVector.add(new DEROctetString(this.currentSpec.getEncodingV()));
                aSN1EncodableVector.add(new DERInteger(this.currentSpec.getMacKeySize()));
                dEROutputStream.writeObject(new DERSequence(aSN1EncodableVector));
                dEROutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error encoding IESParameters");
            }
            return byteArrayOutputStream.toByteArray();
        }

        protected byte[] engineGetEncoded(String string) {
            if (string.equalsIgnoreCase("X.509") || string.equalsIgnoreCase("ASN.1")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$org$bouncycastle$jce$spec$IESParameterSpec == null ? (class$org$bouncycastle$jce$spec$IESParameterSpec = JDKAlgorithmParameters.class$("org.bouncycastle.jce.spec.IESParameterSpec")) : class$org$bouncycastle$jce$spec$IESParameterSpec)) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to ElGamal parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof IESParameterSpec)) {
                throw new InvalidParameterSpecException("IESParameterSpec required to initialise a IES algorithm parameters object");
            }
            this.currentSpec = (IESParameterSpec)algorithmParameterSpec;
        }

        protected void engineInit(byte[] byArray) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            try {
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
                this.currentSpec = new IESParameterSpec(((ASN1OctetString)aSN1Sequence.getObjectAt(0)).getOctets(), ((ASN1OctetString)aSN1Sequence.getObjectAt(0)).getOctets(), ((DERInteger)aSN1Sequence.getObjectAt(0)).getValue().intValue());
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Not a valid IES Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Not a valid IES Parameter encoding.");
            }
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (!string.equalsIgnoreCase("X.509") && !string.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown parameter format " + string);
            }
            this.engineInit(byArray);
        }

        protected String engineToString() {
            return "IES Parameters";
        }
    }

    public static class ElGamal
    extends JDKAlgorithmParameters {
        ElGamalParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            ElGamalParameter elGamalParameter = new ElGamalParameter(this.currentSpec.getP(), this.currentSpec.getG());
            try {
                dEROutputStream.writeObject(elGamalParameter);
                dEROutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error encoding ElGamalParameters");
            }
            return byteArrayOutputStream.toByteArray();
        }

        protected byte[] engineGetEncoded(String string) {
            if (string.equalsIgnoreCase("X.509") || string.equalsIgnoreCase("ASN.1")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$org$bouncycastle$jce$spec$ElGamalParameterSpec == null ? (class$org$bouncycastle$jce$spec$ElGamalParameterSpec = JDKAlgorithmParameters.class$("org.bouncycastle.jce.spec.ElGamalParameterSpec")) : class$org$bouncycastle$jce$spec$ElGamalParameterSpec)) {
                return this.currentSpec;
            }
            if (clazz == (class$javax$crypto$spec$DHParameterSpec == null ? (class$javax$crypto$spec$DHParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.DHParameterSpec")) : class$javax$crypto$spec$DHParameterSpec)) {
                return new DHParameterSpec(this.currentSpec.getP(), this.currentSpec.getG());
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to ElGamal parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof ElGamalParameterSpec) && !(algorithmParameterSpec instanceof DHParameterSpec)) {
                throw new InvalidParameterSpecException("DHParameterSpec required to initialise a ElGamal algorithm parameters object");
            }
            if (algorithmParameterSpec instanceof ElGamalParameterSpec) {
                this.currentSpec = (ElGamalParameterSpec)algorithmParameterSpec;
            } else {
                DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
                this.currentSpec = new ElGamalParameterSpec(dHParameterSpec.getP(), dHParameterSpec.getG());
            }
        }

        protected void engineInit(byte[] byArray) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            try {
                ElGamalParameter elGamalParameter = new ElGamalParameter((ASN1Sequence)aSN1InputStream.readObject());
                this.currentSpec = new ElGamalParameterSpec(elGamalParameter.getP(), elGamalParameter.getG());
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Not a valid ElGamal Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Not a valid ElGamal Parameter encoding.");
            }
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (!string.equalsIgnoreCase("X.509") && !string.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown parameter format " + string);
            }
            this.engineInit(byArray);
        }

        protected String engineToString() {
            return "ElGamal Parameters";
        }
    }

    public static class GOST3410
    extends JDKAlgorithmParameters {
        GOST3410ParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters(new DERObjectIdentifier(this.currentSpec.getPublicKeyParamSetOID()), new DERObjectIdentifier(this.currentSpec.getDigestParamSetOID()), new DERObjectIdentifier(this.currentSpec.getEncryptionParamSetOID()));
            try {
                dEROutputStream.writeObject(gOST3410PublicKeyAlgParameters);
                dEROutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error encoding GOST3410Parameters");
            }
            return byteArrayOutputStream.toByteArray();
        }

        protected byte[] engineGetEncoded(String string) {
            if (string.equalsIgnoreCase("X.509") || string.equalsIgnoreCase("ASN.1")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$org$bouncycastle$jce$spec$GOST3410PublicKeyParameterSetSpec == null ? (class$org$bouncycastle$jce$spec$GOST3410PublicKeyParameterSetSpec = JDKAlgorithmParameters.class$("org.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec")) : class$org$bouncycastle$jce$spec$GOST3410PublicKeyParameterSetSpec)) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to GOST3410 parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof GOST3410ParameterSpec)) {
                throw new InvalidParameterSpecException("GOST3410ParameterSpec required to initialise a GOST3410 algorithm parameters object");
            }
            this.currentSpec = (GOST3410ParameterSpec)algorithmParameterSpec;
        }

        protected void engineInit(byte[] byArray) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            try {
                GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters((ASN1Sequence)aSN1InputStream.readObject());
                GOST3410ParamSetParameters gOST3410ParamSetParameters = GOST3410NamedParameters.getByOID(gOST3410PublicKeyAlgParameters.getPublicKeyParamSet());
                this.currentSpec = new GOST3410ParameterSpec(gOST3410PublicKeyAlgParameters.getPublicKeyParamSet().getId(), gOST3410PublicKeyAlgParameters.getDigestParamSet().getId(), gOST3410PublicKeyAlgParameters.getEncryptionParamSet().getId());
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Not a valid GOST3410 Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Not a valid GOST3410 Parameter encoding.");
            }
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (!string.equalsIgnoreCase("X.509") && !string.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown parameter format " + string);
            }
            this.engineInit(byArray);
        }

        protected String engineToString() {
            return "GOST3410 Parameters";
        }
    }

    public static class DSA
    extends JDKAlgorithmParameters {
        DSAParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            DSAParameter dSAParameter = new DSAParameter(this.currentSpec.getP(), this.currentSpec.getQ(), this.currentSpec.getG());
            try {
                dEROutputStream.writeObject(dSAParameter);
                dEROutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error encoding DSAParameters");
            }
            return byteArrayOutputStream.toByteArray();
        }

        protected byte[] engineGetEncoded(String string) {
            if (string.equalsIgnoreCase("X.509") || string.equalsIgnoreCase("ASN.1")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$java$security$spec$DSAParameterSpec == null ? (class$java$security$spec$DSAParameterSpec = JDKAlgorithmParameters.class$("java.security.spec.DSAParameterSpec")) : class$java$security$spec$DSAParameterSpec)) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to DSA parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
                throw new InvalidParameterSpecException("DSAParameterSpec required to initialise a DSA algorithm parameters object");
            }
            this.currentSpec = (DSAParameterSpec)algorithmParameterSpec;
        }

        protected void engineInit(byte[] byArray) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            try {
                DSAParameter dSAParameter = new DSAParameter((ASN1Sequence)aSN1InputStream.readObject());
                this.currentSpec = new DSAParameterSpec(dSAParameter.getP(), dSAParameter.getQ(), dSAParameter.getG());
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Not a valid DSA Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Not a valid DSA Parameter encoding.");
            }
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (!string.equalsIgnoreCase("X.509") && !string.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown parameter format " + string);
            }
            this.engineInit(byArray);
        }

        protected String engineToString() {
            return "DSA Parameters";
        }
    }

    public static class DH
    extends JDKAlgorithmParameters {
        DHParameterSpec currentSpec;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            DHParameter dHParameter = new DHParameter(this.currentSpec.getP(), this.currentSpec.getG(), this.currentSpec.getL());
            try {
                dEROutputStream.writeObject(dHParameter);
                dEROutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error encoding DHParameters");
            }
            return byteArrayOutputStream.toByteArray();
        }

        protected byte[] engineGetEncoded(String string) {
            if (string.equalsIgnoreCase("X.509") || string.equalsIgnoreCase("ASN.1")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$javax$crypto$spec$DHParameterSpec == null ? (class$javax$crypto$spec$DHParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.DHParameterSpec")) : class$javax$crypto$spec$DHParameterSpec)) {
                return this.currentSpec;
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to DH parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
                throw new InvalidParameterSpecException("DHParameterSpec required to initialise a Diffie-Hellman algorithm parameters object");
            }
            this.currentSpec = (DHParameterSpec)algorithmParameterSpec;
        }

        protected void engineInit(byte[] byArray) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            try {
                DHParameter dHParameter = new DHParameter((ASN1Sequence)aSN1InputStream.readObject());
                this.currentSpec = dHParameter.getL() != null ? new DHParameterSpec(dHParameter.getP(), dHParameter.getG(), dHParameter.getL().intValue()) : new DHParameterSpec(dHParameter.getP(), dHParameter.getG());
            }
            catch (ClassCastException classCastException) {
                throw new IOException("Not a valid DH Parameter encoding.");
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Not a valid DH Parameter encoding.");
            }
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (!string.equalsIgnoreCase("X.509") && !string.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown parameter format " + string);
            }
            this.engineInit(byArray);
        }

        protected String engineToString() {
            return "Diffie-Hellman Parameters";
        }
    }

    public static class PKCS12PBE
    extends JDKAlgorithmParameters {
        PKCS12PBEParams params;

        protected byte[] engineGetEncoded() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
            try {
                dEROutputStream.writeObject(this.params);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Oooops! " + iOException.toString());
            }
            return byteArrayOutputStream.toByteArray();
        }

        protected byte[] engineGetEncoded(String string) {
            if (string.equals("ASN.1")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$javax$crypto$spec$PBEParameterSpec == null ? (class$javax$crypto$spec$PBEParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.PBEParameterSpec")) : class$javax$crypto$spec$PBEParameterSpec)) {
                return new PBEParameterSpec(this.params.getIV(), this.params.getIterations().intValue());
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to PKCS12 PBE parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PKCS12 PBE parameters algorithm parameters object");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            this.params = new PKCS12PBEParams(pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
        }

        protected void engineInit(byte[] byArray) throws IOException {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
            this.params = PKCS12PBEParams.getInstance(aSN1InputStream.readObject());
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (string.equals("ASN.1")) {
                this.engineInit(byArray);
                return;
            }
            throw new IOException("Unknown parameters format in PKCS12 PBE parameters object");
        }

        protected String engineToString() {
            return "PKCS12 PBE Parameters";
        }
    }

    public static class CAST5AlgorithmParameters
    extends JDKAlgorithmParameters {
        private byte[] iv;
        private int keyLength = 128;

        protected byte[] engineGetEncoded() {
            byte[] byArray = new byte[this.iv.length];
            System.arraycopy(this.iv, 0, byArray, 0, this.iv.length);
            return byArray;
        }

        protected byte[] engineGetEncoded(String string) {
            if (string.equals("RAW")) {
                return this.engineGetEncoded();
            }
            if (string.equals("ASN.1")) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
                try {
                    aSN1OutputStream.writeObject(new CAST5CBCParameters(this.engineGetEncoded(), this.keyLength));
                }
                catch (IOException iOException) {
                    return null;
                }
                return byteArrayOutputStream.toByteArray();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec)) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to CAST5 parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a CAST5 parameters algorithm parameters object");
            }
            this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
        }

        protected void engineInit(byte[] byArray) throws IOException {
            this.iv = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.iv, 0, this.iv.length);
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (string.equals("RAW")) {
                this.engineInit(byArray);
                return;
            }
            if (string.equals("ASN.1")) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                CAST5CBCParameters cAST5CBCParameters = CAST5CBCParameters.getInstance(aSN1InputStream.readObject());
                this.keyLength = cAST5CBCParameters.getKeyLength();
                this.iv = cAST5CBCParameters.getIV();
                return;
            }
            throw new IOException("Unknown parameters format in IV parameters object");
        }

        protected String engineToString() {
            return "CAST5 Parameters";
        }
    }

    public static class RC2AlgorithmParameters
    extends JDKAlgorithmParameters {
        private short[] table = new short[]{189, 86, 234, 242, 162, 241, 172, 42, 176, 147, 209, 156, 27, 51, 253, 208, 48, 4, 182, 220, 125, 223, 50, 75, 247, 203, 69, 155, 49, 187, 33, 90, 65, 159, 225, 217, 74, 77, 158, 218, 160, 104, 44, 195, 39, 95, 128, 54, 62, 238, 251, 149, 26, 254, 206, 168, 52, 169, 19, 240, 166, 63, 216, 12, 120, 36, 175, 35, 82, 193, 103, 23, 245, 102, 144, 231, 232, 7, 184, 96, 72, 230, 30, 83, 243, 146, 164, 114, 140, 8, 21, 110, 134, 0, 132, 250, 244, 127, 138, 66, 25, 246, 219, 205, 20, 141, 80, 18, 186, 60, 6, 78, 236, 179, 53, 17, 161, 136, 142, 43, 148, 153, 183, 113, 116, 211, 228, 191, 58, 222, 150, 14, 188, 10, 237, 119, 252, 55, 107, 3, 121, 137, 98, 198, 215, 192, 210, 124, 106, 139, 34, 163, 91, 5, 93, 2, 117, 213, 97, 227, 24, 143, 85, 81, 173, 31, 11, 94, 133, 229, 194, 87, 99, 202, 61, 108, 180, 197, 204, 112, 178, 145, 89, 13, 71, 32, 200, 79, 88, 224, 1, 226, 22, 56, 196, 111, 59, 15, 101, 70, 190, 126, 45, 123, 130, 249, 64, 181, 29, 115, 248, 235, 38, 199, 135, 151, 37, 84, 177, 40, 170, 152, 157, 165, 100, 109, 122, 212, 16, 129, 68, 239, 73, 214, 174, 46, 221, 118, 92, 47, 167, 28, 201, 9, 105, 154, 131, 207, 41, 57, 185, 233, 76, 255, 67, 171};
        private short[] ekb = new short[]{93, 190, 155, 139, 17, 153, 110, 77, 89, 243, 133, 166, 63, 183, 131, 197, 228, 115, 107, 58, 104, 90, 192, 71, 160, 100, 52, 12, 241, 208, 82, 165, 185, 30, 150, 67, 65, 216, 212, 44, 219, 248, 7, 119, 42, 202, 235, 239, 16, 28, 22, 13, 56, 114, 47, 137, 193, 249, 128, 196, 109, 174, 48, 61, 206, 32, 99, 254, 230, 26, 199, 184, 80, 232, 36, 23, 252, 37, 111, 187, 106, 163, 68, 83, 217, 162, 1, 171, 188, 182, 31, 152, 238, 154, 167, 45, 79, 158, 142, 172, 224, 198, 73, 70, 41, 244, 148, 138, 175, 225, 91, 195, 179, 123, 87, 209, 124, 156, 237, 135, 64, 140, 226, 203, 147, 20, 201, 97, 46, 229, 204, 246, 94, 168, 92, 214, 117, 141, 98, 149, 88, 105, 118, 161, 74, 181, 85, 9, 120, 51, 130, 215, 221, 121, 245, 27, 11, 222, 38, 33, 40, 116, 4, 151, 86, 223, 60, 240, 55, 57, 220, 255, 6, 164, 234, 66, 8, 218, 180, 113, 176, 207, 18, 122, 78, 250, 108, 29, 132, 0, 200, 127, 145, 69, 170, 43, 194, 177, 143, 213, 186, 242, 173, 25, 178, 103, 54, 247, 15, 10, 146, 125, 227, 157, 233, 144, 62, 35, 39, 102, 19, 236, 129, 21, 189, 34, 191, 159, 126, 169, 81, 75, 76, 251, 2, 211, 112, 134, 49, 231, 59, 5, 3, 84, 96, 72, 101, 24, 210, 205, 95, 50, 136, 14, 53, 253};
        private byte[] iv;
        private int parameterVersion = 58;

        protected byte[] engineGetEncoded() {
            byte[] byArray = new byte[this.iv.length];
            System.arraycopy(this.iv, 0, byArray, 0, this.iv.length);
            return byArray;
        }

        protected byte[] engineGetEncoded(String string) {
            if (string.equals("RAW")) {
                return this.engineGetEncoded();
            }
            if (string.equals("ASN.1")) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
                try {
                    if (this.parameterVersion == -1) {
                        aSN1OutputStream.writeObject(new RC2CBCParameter(this.engineGetEncoded()));
                    } else {
                        aSN1OutputStream.writeObject(new RC2CBCParameter(this.parameterVersion, this.engineGetEncoded()));
                    }
                }
                catch (IOException iOException) {
                    return null;
                }
                return byteArrayOutputStream.toByteArray();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$javax$crypto$spec$RC2ParameterSpec == null ? (class$javax$crypto$spec$RC2ParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.RC2ParameterSpec")) : class$javax$crypto$spec$RC2ParameterSpec) && this.parameterVersion != -1) {
                if (this.parameterVersion < 256) {
                    return new RC2ParameterSpec(this.ekb[this.parameterVersion], this.iv);
                }
                return new RC2ParameterSpec(this.parameterVersion, this.iv);
            }
            if (clazz == (class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec)) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to RC2 parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
            } else if (algorithmParameterSpec instanceof RC2ParameterSpec) {
                int n = ((RC2ParameterSpec)algorithmParameterSpec).getEffectiveKeyBits();
                if (n != -1) {
                    this.parameterVersion = n < 256 ? this.table[n] : n;
                }
                this.iv = ((RC2ParameterSpec)algorithmParameterSpec).getIV();
            } else {
                throw new InvalidParameterSpecException("IvParameterSpec or RC2ParameterSpec required to initialise a RC2 parameters algorithm parameters object");
            }
        }

        protected void engineInit(byte[] byArray) throws IOException {
            this.iv = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.iv, 0, this.iv.length);
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (string.equals("RAW")) {
                this.engineInit(byArray);
                return;
            }
            if (string.equals("ASN.1")) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                RC2CBCParameter rC2CBCParameter = RC2CBCParameter.getInstance(aSN1InputStream.readObject());
                if (rC2CBCParameter.getRC2ParameterVersion() != null) {
                    this.parameterVersion = rC2CBCParameter.getRC2ParameterVersion().intValue();
                }
                this.iv = rC2CBCParameter.getIV();
                return;
            }
            throw new IOException("Unknown parameters format in IV parameters object");
        }

        protected String engineToString() {
            return "RC2 Parameters";
        }
    }

    public static class IDEAAlgorithmParameters
    extends JDKAlgorithmParameters {
        private byte[] iv;

        protected byte[] engineGetEncoded() {
            return this.engineGetEncoded("ASN.1");
        }

        protected byte[] engineGetEncoded(String string) {
            if (string == null) {
                return this.engineGetEncoded("ASN.1");
            }
            if (string.equals("RAW")) {
                byte[] byArray = new byte[this.iv.length];
                System.arraycopy(this.iv, 0, byArray, 0, this.iv.length);
                return byArray;
            }
            if (string.equals("ASN.1")) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
                try {
                    aSN1OutputStream.writeObject(new IDEACBCPar(this.engineGetEncoded("RAW")));
                }
                catch (IOException iOException) {
                    return null;
                }
                return byteArrayOutputStream.toByteArray();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec)) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to IV parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
            }
            this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
        }

        protected void engineInit(byte[] byArray) throws IOException {
            this.iv = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.iv, 0, this.iv.length);
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (string.equals("RAW")) {
                this.engineInit(byArray);
                return;
            }
            if (string.equals("ASN.1")) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                try {
                    IDEACBCPar iDEACBCPar = new IDEACBCPar((ASN1Sequence)aSN1InputStream.readObject());
                    this.engineInit(iDEACBCPar.getIV());
                }
                catch (Exception exception) {
                    throw new IOException("Exception decoding: " + exception);
                }
                return;
            }
            throw new IOException("Unknown parameters format in IV parameters object");
        }

        protected String engineToString() {
            return "IDEA Parameters";
        }
    }

    public static class IVAlgorithmParameters
    extends JDKAlgorithmParameters {
        private byte[] iv;

        protected byte[] engineGetEncoded() {
            return this.engineGetEncoded("ASN.1");
        }

        protected byte[] engineGetEncoded(String string) {
            if (string == null) {
                return this.engineGetEncoded("ASN.1");
            }
            if (string.equals("RAW")) {
                byte[] byArray = new byte[this.iv.length];
                System.arraycopy(this.iv, 0, byArray, 0, this.iv.length);
                return byArray;
            }
            if (string.equals("ASN.1")) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
                try {
                    aSN1OutputStream.writeObject(new DEROctetString(this.engineGetEncoded("RAW")));
                }
                catch (IOException iOException) {
                    return null;
                }
                return byteArrayOutputStream.toByteArray();
            }
            return null;
        }

        protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == (class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = JDKAlgorithmParameters.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec)) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to IV parameters object.");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
                throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
            }
            this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
        }

        protected void engineInit(byte[] byArray) throws IOException {
            if (byArray.length % 8 != 0 && byArray[0] == 4 && byArray[1] == byArray.length - 2) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
                byArray = aSN1OctetString.getOctets();
            }
            this.iv = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.iv, 0, this.iv.length);
        }

        protected void engineInit(byte[] byArray, String string) throws IOException {
            if (string.equals("RAW")) {
                this.engineInit(byArray);
                return;
            }
            if (string.equals("ASN.1")) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
                try {
                    ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
                    this.engineInit(aSN1OctetString.getOctets());
                }
                catch (Exception exception) {
                    throw new IOException("Exception decoding: " + exception);
                }
                return;
            }
            throw new IOException("Unknown parameters format in IV parameters object");
        }

        protected String engineToString() {
            return "IV Parameters";
        }
    }
}

