#include "stddefx.h"

#ifndef INCLUDED_CALC_SPATIAL
#include "calc_spatial.h"
#define INCLUDED_CALC_SPATIAL
#endif
/*
#ifndef INCLUDED_ALGORITHM
#include <algorithm>
#define INCLUDED_ALGORITHM
#endif
#ifndef INCLUDED_MEMORY
#include <memory>
#define INCLUDED_MEMORY
#endif
#ifndef INCLUDED_GEO_SIMPLERASTER
#include "geo_simpleraster.h"
#define INCLUDED_GEO_SIMPLERASTER
#endif


#ifndef INCLUDED_CALC_GRIDMAP
#include "calc_gridmap.h"
#define INCLUDED_CALC_GRIDMAP
#endif
*/

#ifndef INCLUDED_CALC_MAP2CSF
#include "calc_map2csf.h" // bytesPerCell
#define INCLUDED_CALC_MAP2CSF
#endif
#ifndef INCLUDED_COM_CSFCELL
#include "com_csfcell.h"  // getCell
#define INCLUDED_COM_CSFCELL
#endif

size_t calc::Spatial::d_maxBPC=0;
size_t calc::Spatial::d_currentBPC=0;

void calc::Spatial::countBPC(VS vs) const
{
  d_currentBPC += bytesPerCell(vs);
  d_maxBPC  = std::max(d_maxBPC, d_currentBPC);
}

//! maximum nr of bytes per cell ever allocated
size_t calc::Spatial::maxBPC()
{
  return d_maxBPC;
}

//! nr of bytes per cell currently allocated
size_t calc::Spatial::currentBPC()
{
  return d_currentBPC;
}


//! ctor with allocation by default
calc::Spatial::Spatial(VS vs, CRIndex cri, size_t nrValues):
  ISpatial(vs,cri,nrValues),d_val(0)
{
  allocate();
}

//! copy ctor
calc::Spatial::Spatial(const Spatial& rhs):
  ISpatial(rhs.vs(),rhs.cri(),rhs.nrValues()),d_val(0)
{
  allocate();
  fill(rhs.src());
}

/*
//! ctor that will own the value buffer
 *!
 * \param valueBuffer owned by this, this will delete
calc::Spatial::Spatial(VS vs, size_t nrValues, void *valueBuffer):
  Field(vs),d_val(valueBuffer),d_nrValues(nrValues)
{
}

*/

void calc::Spatial::fill(const void *src)
{
 std::memcpy(dest(),src,nrValues()*bytesPerCell(vs()));
}
#include <stdlib.h>
void calc::Spatial::allocate()
{
  PRECOND(allFitCRIndex(vs())==cri());
  /*
  switch(bytesPerCell(vs())) {
   case 1: d_val1 = new UINT1_A16[nrValues()];
           break;
   case 4: d_val4 = new  INT4_A16[nrValues()];
           break;
  }
  GCC malloc's/new on 8 byte allign, calc_simdmath.h needs
      16 byte alignment
  */
  posix_memalign(&d_val,16,bytesPerCell(vs())*nrValues());
  POSTCOND(( ((int)d_val)%16)==0);
  countBPC(vs());
}

//! dtor
calc::Spatial::~Spatial()
{
  if (!d_val)
    return;
  d_currentBPC -= bytesPerCell(vs());
  free(d_val);
/*
  switch(bytesPerCell(vs())) {
   case 1: delete [] d_val1; break;
   case 4: delete [] d_val4; break;
  }
*/
}


//! return value as read only, initialized value
const void *calc::Spatial::src() const
{
  PRECOND(d_val != 0);
  return d_val;
}

//! return value writable and readable, allocated value
void *calc::Spatial::dest()
{
  PRECOND(d_val != 0);
  return d_val;
}

bool calc::Spatial::getCell(double& value, size_t i) const
{
   switch(cri()) {
    case CRI_1:
      com::CastCell<double,UINT1>()(value,d_val1[i]);
      break;
    case CRI_4:
      com::CastCell<double,INT4>()(value,d_val4[i]);
      break;
    case CRI_f:
      com::CastCell<double,REAL4>()(value,d_vals[i]);
      break;
    default: PRECOND(FALSE);
  }
  return !com::isMV(value);
}

//! \brief generic set interface
/*!
 * the generic interface does the automatic cast-down with MV handling.
 * a faster interface is to use the type specific dest_1(), dest_4(), dest_f()
 * interface:
 * \code
 *   Spatial s(VS_L,CRI_1,nrCells());
 *   // set cell 4 to value 5 in two ways
 *   double v=5;
 *   s.setCell(v,4);
 *   s.dest_1()[4]=5;
 * \param value  can be missing value
 */
void calc::Spatial::setCell(const double& value, size_t i)
{
   switch(biggestCellRepr(vs())) {
    case CR_UINT1:
      com::CastCell<UINT1,double>()(d_val1[i],value);
      break;
    case CR_INT4:
      com::CastCell<INT4, double>()(d_val4[i],value);
      break;
    case CR_REAL4:
      com::CastCell<REAL4,double>()(d_vals[i],value);
      break;
    default: PRECOND(FALSE);
  }
}


calc::Spatial* calc::Spatial::createClone() const
{
  return new Spatial(*this);
}


//! check if no cells are true and no cells are false
void calc::Spatial::analyzeBoolean(
    bool& noneAreTrue,
    bool& noneAreFalse) const
{
  PRECOND(vs() == VS_B);
  PRECOND(biggestCellRepr(vs()) == CR_UINT1);
  noneAreTrue = noneAreFalse = true;
  for (size_t i=0; i < nrValues(); i++) {
   if (d_val1[i] == 1)
    noneAreTrue  = false;
   if (d_val1[i] == 0)
    noneAreFalse = false;
  }
}

namespace calc {
class MaskChecker {
  bool   d_newMVsFound;
  bool   d_allZero;
  size_t d_n;
public:
  MaskChecker(
    size_t n):
    d_newMVsFound(false),
    d_allZero(true),
    d_n(n)
    {}

  template<class CR> void check(
    UINT1    *mask,
    const CR *val)
  {
   /*
    double  prevIdenticalValue;
    bool    allIdentical=true;
    com::setMV(prevIdenticalValue);
   */
    for(size_t i=0; i < d_n; i++)
      if (mask[i] == 1) {
        if (com::isMV(val[i]) ) {
         d_newMVsFound =true;
         mask[i] = 2;
        }
      /*
        else {
          double v;
          me->getCell(v,i);
          if ( com::isMV(prevIdenticalValue))
             prevIdenticalValue=v;
          if (v != prevIdenticalValue)
               allIdentical=false;
          // if (std::fabs(v) > 0.000001)
          if (val[i] != 0)
              d_allZero=false;
        }
       */
      }
    // if (!d_allZero && allIdentical)
    //  std::cout << "ident " << prevIdenticalValue << " " << me << " " << sizeof(CR) << "\n";
  };
  bool newMVsFound() const { return d_newMVsFound; };
  bool allZero() const { return d_allZero; };
};
}


//! check if I have MV's on cells where the areaMask is 1 (true)
/*! if any such MV's  are found then the script's areaMask
 *  is modified and written to debugMapName
 *  \a maskField is temporary changed but undone on return
 *  \returns
 *    0 is no MV's inside mask, an allocated VS_N Spatial object if it does
 */
calc::Spatial* calc::Spatial::findMVinMask(
    const Field* maskField) const
{
  PRECOND(maskField->nrValues() == nrValues());
  UINT1 *mask = ((Field *)maskField)->dest_1();
  CRIndex cr=allFitCRIndex(vs());

  MaskChecker c(nrValues());
  // check for MV created if we are assigning a spatial
  switch(cr) {
   case CRI_1 : c.check(mask, src_1()); break;
   case CRI_4 : c.check(mask, src_4()); break;
   case CRI_f : c.check(mask, src_f()); break;
   default: PRECOND(FALSE);
  }
  if (!c.newMVsFound())
    return 0;

  Spatial *m = new Spatial(VS_N,CRI_4,nrValues());
  for(size_t i=0; i < nrValues(); ++i) {
    m->dest_4()[i]=mask[i];
    // undo mark
    if (mask[i]==2)
      mask[i]=1;
  }
  return m;
}
