# Contributing to PCRaster

Thanks for your time and willingness to contribute to PCRaster! This page gives a few guidelines:


**Reporting Bugs**

If you have found a bug in the PCRaster software (or any other erroneous behaviour) please file a bug report. Any error messages containing the phrases: "assertion failed" or "programming error" are always related to errors in the software we should fix.

Bugs are tracked on our GitHub [issue](https://github.com/pcraster/pcraster/issues) page. To allow us to reproduce the issue please provide:

- The PCRaster version and the Python version used.
- Details about the operating system used.
- The description of the problem in as much detail as possible.
- If possible, a minimal working example and zip or archive file with all data and scripts so we can reproduce the bug.


**General questions**

Please do not use the issue tracker for support questions. You can send your questions, ideas and discussion issues to our [mailing list](https://lists.geo.uu.nl/mailman/listinfo/pcraster-info).


**Pull requests**

In case you can provide a code fix yourself please consider submitting a [pull](https://github.com/pcraster/pcraster/pulls) request.

For something that is bigger than a trivial fix follow these steps:

1. Create an issue describing the changes you intend to make.
2. Create your own fork of the PCRaster code.
3. Create a branch with the corresponding issue number.
4. Switch to that branch.
5. Apply your modifications.
6. Ensure cross-platform compatibility; for Linux, Mac, and Windows.

All contributions to this project will be released under the GPLv3 license under copyright of the PCRaster owners. By submitting a pull request:

- You are agreeing to comply with the waiver of your copyright interest.
- You state that the contribution was created in whole by you and you have the right to submit it.


**Contacting us**

For project related questions please contact us at info@pcraster.eu.
