:::
::: Build Release and Installer subdirectories of the current shadow build directory.
::: The Release directory contains everything needed to run OSCAR.
::: The Installer directory contains a single executable -- the OSCAR installer.
:::
::: DEPLOY.BAT should be run as the last step of a QT Build Release kit.
::: QT Shadow build should be specified (this is the QT default).
::: A command line parameter is optional.  Any text on the command line will be appended
::: to the file name of the installer.
:::
::: Requirements:
:::     Inno Setup 6 - http://www.jrsoftware.org/isinfo.php, installed to default Program Files (x86) location:%ProgramFiles(x86)%
:::     gawk - somewhere in the PATH or in Git for Windows installed with Git\cmd in the path
:::
::: Deploy.bat resides in ...\OSCAR-code\Building\Windows, along with
:::     buildinstall.iss -- script for Inno Setup to create installer
:::     getBuildInfo.awk -- gawk script for extracting version fields from various files
:::     setup.ico -- Icon to be used for the installer.
:::
::: When building a release version in QT, QT will start this batch file which will prepare
::: additional files, run WinDeployQt, and create an installer.
:::
@echo off
echo Executing %~nx0 %*
setlocal
set doSkipInstall=0
set	suffixParam=%1
if "%1"=="skipInstall" (
		set doSkipInstall=1
		set	suffixParam=%2
	) else (
		if "%2"=="skipInstall" set doSkipInstall=1
	)

echo doSkipInstall = %doSkipInstall%
set errDescription=
set errvalue=0
::: Current Directory is the shadowBuildDir
set shadowBuildDir=%cd%
::: toolDir is where the Window install\deploy tools are located
cd %~dp0 && cd ..\..\..
set parentDir=%cd%
if exist %shadowBuildDir%\oscar\nul set shadowBuildDir=%shadowBuildDir%\oscar
cd %shadowBuildDir%
set toolDir=%parentDir%\OSCAR-code\Building\Windows
::: Calculate directory where OSCAR-code is located.
set sourceDir=%parentDir%\OSCAR-code\oscar

echo tooldir is %toolDir%
::echo parentDir is %parentDir%
:: echo sourceDir is %sourceDir%
echo shadowBuildDir is %shadowBuildDir%
if NOT exist %shadowBuildDir%\OSCAR.exe  (
	call :err 41	%shadowBuildDir%\OSCAR.exe does not exist
	goto :endProgram
	)

call :cleanFolder
if exist %shadowBuildDir%\buildInfo.iss  del /q %shadowBuildDir%\buildInfo.iss  || (call :err 42	& goto :endProgram)
if exist %shadowBuildDir%\buildInstall.iss  del /q %shadowBuildDir%\buildInstall.iss  || (call :err 43	& goto :endProgram)
if exist %shadowBuildDir%\setup.ico   del /q %shadowBuildDir%\setup.ico  || (call :err 44	& goto :endProgram)

call :getGawk

::: Now have gawk. -- do not delete this line.
::: Now copy the base installation control file
copy %toolDir%\buildInstall.iss %shadowBuildDir%   1>nul
if NOT %ERRORLEVEL%==0 (
	call :err 45  %ERRORLEVEL% failure to copy %toolDir%\buildInstall.iss to %shadowBuildDir%
	goto :endProgram
	)
copy %toolDir%\setup.ico %shadowBuildDir% 1>nul
if NOT %ERRORLEVEL%==0 (
	call :err 	 failure to copy %toolDir%\setup.ico to %shadowBuildDir%
	goto :endProgram
	)
:::copy %toolDir%\use*.reg %shadowBuildDir% || call :err 47	& goto :endProgram

::: Create and copy installer control files
::: Create file with all version numbers etc. ready for use by buildinstall.iss
::: Extract the version info from various header files using gawk and
::: #define fields for each data item in buildinfo.iss which will be
::: used by the installer script.
echo ; This script auto-generated by DEPLOY.BAT >%shadowBuildDir%\buildinfo.iss
gawk -f %toolDir%\getBuildInfo.awk %sourcedir%\VERSION >>%shadowBuildDir%\buildInfo.iss
if NOT %ERRORLEVEL%==0 (
	call :err 60	& goto :endProgram)
gawk -f %toolDir%\getBuildInfo.awk %sourcedir%\git_info.h >>%shadowBuildDir%\buildInfo.iss
if NOT %ERRORLEVEL%==0 (
	call :err 62	& goto :endProgram)
echo %shadowBuildDir% | gawk -f %toolDir%\getBuildInfo.awk >>%shadowBuildDir%\buildInfo.iss
if NOT %ERRORLEVEL%==0 (
	call :err 63	& goto :endProgram)
echo #define MySuffix "%suffixParam%" >>%shadowBuildDir%\buildinfo.iss
if NOT %ERRORLEVEL%==0 (
	call :err 64	& goto :endProgram)
:::echo #define MySourceDir "%sourcedir%" >>%shadowBuildDir%\buildinfo.iss

set releaseDir=%shadowBuildDir%\Release

::: Create Release directory and subdirectories
::: if exist %shadowBuildDir%\Release\*.* rmdir /s /q %shadowBuildDir%\Release
mkdir %releaseDir%
cd %shadowBuildDir%\Release
copy %shadowBuildDir%\oscar.exe .  1>nul
if NOT %ERRORLEVEL%==0 (
	call :err 71	& goto :endProgram)
:::copy %shadowBuildDir%\use*.reg .  || call :err 72	& goto :endProgram
::: if exist %shadowBuildDir%\Installer\*.* rmdir /s /q %shadowBuildDir%\Installer  (call :err 73	& goto :endProgram)

::: starting to copy files
::: Now in Release subdirectory
::: If QT created a help directory, copy it.  But it might not have if "helpless" option was set

::: if exist Help\*.* rmdir /s /q Help
mkdir Help
if exist %shadowBuildDir%\help\*.qch copy %shadowBuildDir%\help %releaseDir%\Help 1>nul ||  (call :err 80	& goto :endProgram)

::: if exist Html\*.* rmdir /s /q Html
mkdir Html
copy %shadowBuildDir%\html %releaseDir%\html 1>nul || 		(call :err 81	& goto :endProgram)

::: if exist Translations\*.* rmdir /s /q Translations
mkdir Translations
copy %shadowBuildDir%\translations %releaseDir%\Translations   1>nul || (call :err 84	& goto :endProgram)

::: Run deployment tool										
echo Running Qt Deployment tool
windeployqt.exe --release --force --compiler-runtime --no-translations --verbose 1 OSCAR.exe 1>nul 2>nul
if %errorlevel% == 0 goto :cleanup
::: echo windeployqt error = %errorlevel%	executing next version
::: Post mingw 8.0 --release Must not be used.
windeployqt.exe --force --compiler-runtime --no-translations --verbose 1 OSCAR.exe 1>nul || (call :err 87	& goto :endProgram)


:cleanup
::: Clean up unwanted translation files
::::For unknown reasons, Win64 build copies the .ts files into the release directory, while Win32 does not
if exist Translations\*.ts del /q Translations\*.ts


::: Create installer
cd ..
IF %doSkipInstall%==1 goto :endProgram
echo Creating OSCAR Installer
"%ProgramFiles(x86)%\Inno Setup 6\iscc" /Q BuildInstall.iss 		|| (call :err 88	& goto :endProgram)
if NOT exist %shadowBuildDir%\Installer\OSCAR*.exe  (call :err 89	& goto :endProgram)
echo Installers in %shadowBuildDir%\Installer are:
dir %shadowBuildDir%\Installer\ >%TEMP%\dirout.txt
FINDSTR /C:".exe" %TEMP%\dirout.txt
:endProgram
echo Finished %~nx0 %errDescription%
exit /b %errvalue%
:::: =======================

:err
set errvalue=%1
set errDescription=%*
echo %~nx0 detected error: %*

exit /b %errvalue%


::: =====================================================================================

:getGawk
:: check if gawk is already available.
where gawk  > temp.txt 2>nul
set er=%errorlevel%
set gawk=<temp.txt
if %er%==0 (
	del temp.txt
	goto :eof)
:: get location of Git command - then find where Git was downloaded.
where Git > temp.txt 2>nul
set er=%errorlevel%
set /p git=<temp.txt
del temp.txt
if NOT %er%==0 (echo git command not found && exit /b 33)
::: found the location of GIT. because git has gawk		
:: have fullpath of git.exe which is in Git\cmd\git.exe need Git\usr\bin\gawk
FOR %%i IN ("%git%") DO (set git=%%~dpi)
:: get rid of trailing \ for above command to decend one level
FOR %%i IN ("%git:~0,-1%") DO (set git=%%~dpi)
set path=%git:~0,-1%\usr\bin;%path%
echo %path%
goto :eof

::: =====================================================================================
:cleanFolder
for /d %%i in (%shadowBuildDir%\*) do (
	call :handClean %%i
)
goto :eof
:handClean
	::: Qt adds hidden files to build folder for glang compiler. .qtc_clangd (for windows builds)
	::: This results is no file name, however it does exist in the full path name %1
	set xpath=%1
	set fname=%~n1
	:: if fname is empty then directory is hidden and is in xpath
:::	if "%fname%"=="" goto :endhandClean:::
	if /I "%fname%"=="Help" goto :endhandClean
	if /I "%fname%"=="Html" goto :endhandClean
	if /I "%fname%"=="Translations" goto :endhandClean
	if /I "%fname%"=="Release" goto :cleanDir
	if /I "%fname%"=="Installer" goto :cleanDir
	echo Folder %fname% was not cleaned
	goto :endhandClean
:cleanDir
	echo Cleaning %xpath%
	rmdir /Q /S %xpath%
:endhandClean
goto :eof
