      subroutine stm

c - to vary the number of quadratures
      include "paramdef.inc"
      integer nquad
      common /num_quad/ nquad
      real ph,qh,uh
      common /sixs_aerbas/ ph(20,nqmax_p),qh(20,nqmax_p),uh(20,nqmax_p)
      real phr(20,nqdef_p),qhr(20,nqdef_p),uhr(20,nqdef_p)
c - to vary the number of quadratures
      real ex,sc,asy,vi
      common /sixs_coef/ ex(4,20),sc(4,20),asy(4,20),vi(4)
      real ex_m(20),sc_m(20),asy_m(20)
      integer i,j


c Aerosol stratospheric model
c Parameters (STM-params.dat) are calculated with PINATUBO.f
c for one-year-old aerosol. PINATUBO.f is written based on
c Russel et al., 'Global to microscale evolution of the Pinatubo
c volcanic aerosol derived from diverse measurements and analyses',
c Journal of Geophysical Research, 101(D13), pp. 18745-18763, 1996.
c Extinction coefficients are calculated in km-1

c*************** MIE (asy) ******************
      data (asy_m(j),j=1,20)/
     a 0.787,0.795,0.796,0.800,0.802,0.804,0.806,0.808,0.809,0.810,
     a 0.810,0.809,0.807,0.802,0.770,0.736,0.723,0.685,0.647,0.469/
c*************** MIE (ext&sca) ******************
        data (ex_m(j),sc_m(j),j=1,20) /
     a 0.1323426E+01,0.1323426E+01,0.1367378E+01,0.1367378E+01,
     a 0.1375664E+01,0.1375664E+01,0.1389866E+01,0.1389866E+01,
     a 0.1397082E+01,0.1397082E+01,0.1397282E+01,0.1397282E+01,
     a 0.1394358E+01,0.1394358E+01,0.1384032E+01,0.1384032E+01,
     a 0.1363314E+01,0.1363314E+01,0.1332585E+01,0.1332585E+01,
     a 0.1301248E+01,0.1301248E+01,0.1278673E+01,0.1278673E+01,
     a 0.1211386E+01,0.1211386E+01,0.1101411E+01,0.1101411E+01,
     a 0.7206790E+00,0.7206790E+00,0.5124845E+00,0.5124845E+00,
     a 0.4508164E+00,0.4508164E+00,0.3256089E+00,0.3256089E+00,
     a 0.2397076E+00,0.2397076E+00,0.6640586E-01,0.6640586E-01 /
c************** MIE (phase fun ph) ***************
        DATA ((PHR(i,j),j=1,83),i= 1, 1)/
     *0.2975E+00,0.2696E+00,0.2051E+00,0.1882E+00,0.2239E+00,
     *0.2685E+00,0.2867E+00,0.2805E+00,0.2628E+00,0.2453E+00,
     *0.2311E+00,0.2201E+00,0.2119E+00,0.2031E+00,0.1933E+00,
     *0.1849E+00,0.1764E+00,0.1653E+00,0.1520E+00,0.1401E+00,
     *0.1305E+00,0.1216E+00,0.1134E+00,0.1062E+00,0.1001E+00,
     *0.9488E-01,0.9120E-01,0.8890E-01,0.8686E-01,0.8502E-01,
     *0.8471E-01,0.8559E-01,0.8624E-01,0.8630E-01,0.8770E-01,
     *0.9053E-01,0.9360E-01,0.9716E-01,0.1019E+00,0.1071E+00,
     *0.1127E+00,0.1161E+00,0.1202E+00,0.1294E+00,0.1389E+00,
     *0.1504E+00,0.1641E+00,0.1786E+00,0.1954E+00,0.2161E+00,
     *0.2396E+00,0.2653E+00,0.2963E+00,0.3324E+00,0.3735E+00,
     *0.4204E+00,0.4750E+00,0.5394E+00,0.6129E+00,0.6964E+00,
     *0.7964E+00,0.9181E+00,0.1057E+01,0.1217E+01,0.1407E+01,
     *0.1633E+01,0.1900E+01,0.2216E+01,0.2599E+01,0.3062E+01,
     *0.3634E+01,0.4352E+01,0.5270E+01,0.6481E+01,0.8163E+01,
     *0.1059E+02,0.1417E+02,0.1956E+02,0.2763E+02,0.3922E+02,
     *0.5407E+02,0.6807E+02,0.7250E+02 /
        DATA ((PHR(i,j),j=1,83),i= 2, 2)/
     *0.2458E+00,0.2255E+00,0.1731E+00,0.1522E+00,0.1759E+00,
     *0.2136E+00,0.2382E+00,0.2436E+00,0.2355E+00,0.2220E+00,
     *0.2096E+00,0.2001E+00,0.1918E+00,0.1835E+00,0.1749E+00,
     *0.1656E+00,0.1561E+00,0.1466E+00,0.1380E+00,0.1298E+00,
     *0.1211E+00,0.1129E+00,0.1061E+00,0.1004E+00,0.9533E-01,
     *0.9133E-01,0.8829E-01,0.8568E-01,0.8370E-01,0.8269E-01,
     *0.8238E-01,0.8235E-01,0.8286E-01,0.8428E-01,0.8650E-01,
     *0.8908E-01,0.9184E-01,0.9539E-01,0.9990E-01,0.1049E+00,
     *0.1105E+00,0.1138E+00,0.1174E+00,0.1260E+00,0.1356E+00,
     *0.1461E+00,0.1585E+00,0.1734E+00,0.1899E+00,0.2092E+00,
     *0.2325E+00,0.2584E+00,0.2868E+00,0.3206E+00,0.3611E+00,
     *0.4070E+00,0.4599E+00,0.5231E+00,0.5974E+00,0.6830E+00,
     *0.7828E+00,0.9016E+00,0.1043E+01,0.1209E+01,0.1404E+01,
     *0.1639E+01,0.1927E+01,0.2274E+01,0.2692E+01,0.3206E+01,
     *0.3850E+01,0.4669E+01,0.5724E+01,0.7113E+01,0.8980E+01,
     *0.1155E+02,0.1515E+02,0.2022E+02,0.2722E+02,0.3637E+02,
     *0.4693E+02,0.5589E+02,0.5854E+02 /
        DATA ((PHR(i,j),j=1,83),i= 3, 3)/
     *0.2347E+00,0.2165E+00,0.1684E+00,0.1476E+00,0.1687E+00,
     *0.2047E+00,0.2294E+00,0.2353E+00,0.2287E+00,0.2174E+00,
     *0.2058E+00,0.1961E+00,0.1878E+00,0.1798E+00,0.1713E+00,
     *0.1619E+00,0.1522E+00,0.1431E+00,0.1349E+00,0.1269E+00,
     *0.1188E+00,0.1111E+00,0.1045E+00,0.9920E-01,0.9465E-01,
     *0.9069E-01,0.8751E-01,0.8517E-01,0.8347E-01,0.8239E-01,
     *0.8178E-01,0.8146E-01,0.8207E-01,0.8392E-01,0.8605E-01,
     *0.8827E-01,0.9132E-01,0.9505E-01,0.9934E-01,0.1045E+00,
     *0.1105E+00,0.1138E+00,0.1174E+00,0.1255E+00,0.1348E+00,
     *0.1454E+00,0.1579E+00,0.1725E+00,0.1893E+00,0.2083E+00,
     *0.2303E+00,0.2560E+00,0.2851E+00,0.3183E+00,0.3579E+00,
     *0.4044E+00,0.4576E+00,0.5197E+00,0.5936E+00,0.6804E+00,
     *0.7808E+00,0.8981E+00,0.1039E+01,0.1207E+01,0.1407E+01,
     *0.1645E+01,0.1934E+01,0.2287E+01,0.2716E+01,0.3242E+01,
     *0.3899E+01,0.4737E+01,0.5823E+01,0.7245E+01,0.9145E+01,
     *0.1173E+02,0.1532E+02,0.2029E+02,0.2705E+02,0.3576E+02,
     *0.4559E+02,0.5377E+02,0.5616E+02 /
        DATA ((PHR(i,j),j=1,83),i= 4, 4)/
     *0.2072E+00,0.1924E+00,0.1526E+00,0.1348E+00,0.1519E+00,
     *0.1832E+00,0.2073E+00,0.2165E+00,0.2133E+00,0.2042E+00,
     *0.1942E+00,0.1853E+00,0.1771E+00,0.1690E+00,0.1608E+00,
     *0.1523E+00,0.1436E+00,0.1350E+00,0.1273E+00,0.1204E+00,
     *0.1131E+00,0.1063E+00,0.1006E+00,0.9577E-01,0.9133E-01,
     *0.8774E-01,0.8502E-01,0.8293E-01,0.8154E-01,0.8091E-01,
     *0.8072E-01,0.8075E-01,0.8128E-01,0.8266E-01,0.8473E-01,
     *0.8716E-01,0.9004E-01,0.9369E-01,0.9813E-01,0.1032E+00,
     *0.1089E+00,0.1122E+00,0.1158E+00,0.1240E+00,0.1334E+00,
     *0.1439E+00,0.1560E+00,0.1704E+00,0.1866E+00,0.2052E+00,
     *0.2273E+00,0.2523E+00,0.2805E+00,0.3140E+00,0.3537E+00,
     *0.3995E+00,0.4524E+00,0.5147E+00,0.5876E+00,0.6726E+00,
     *0.7726E+00,0.8920E+00,0.1035E+01,0.1206E+01,0.1409E+01,
     *0.1655E+01,0.1955E+01,0.2322E+01,0.2769E+01,0.3324E+01,
     *0.4025E+01,0.4921E+01,0.6070E+01,0.7562E+01,0.9530E+01,
     *0.1216E+02,0.1571E+02,0.2046E+02,0.2663E+02,0.3419E+02,
     *0.4235E+02,0.4885E+02,0.5070E+02 /
        DATA ((PHR(i,j),j=1,83),i= 5, 5)/
     *0.1879E+00,0.1756E+00,0.1427E+00,0.1286E+00,0.1445E+00,
     *0.1724E+00,0.1934E+00,0.2016E+00,0.2005E+00,0.1948E+00,
     *0.1868E+00,0.1778E+00,0.1693E+00,0.1614E+00,0.1539E+00,
     *0.1462E+00,0.1377E+00,0.1296E+00,0.1221E+00,0.1149E+00,
     *0.1084E+00,0.1026E+00,0.9750E-01,0.9308E-01,0.8933E-01,
     *0.8627E-01,0.8377E-01,0.8174E-01,0.8043E-01,0.7987E-01,
     *0.7963E-01,0.7973E-01,0.8058E-01,0.8203E-01,0.8377E-01,
     *0.8592E-01,0.8890E-01,0.9265E-01,0.9692E-01,0.1021E+00,
     *0.1086E+00,0.1120E+00,0.1155E+00,0.1233E+00,0.1325E+00,
     *0.1431E+00,0.1552E+00,0.1693E+00,0.1854E+00,0.2036E+00,
     *0.2246E+00,0.2495E+00,0.2789E+00,0.3123E+00,0.3508E+00,
     *0.3963E+00,0.4492E+00,0.5101E+00,0.5824E+00,0.6689E+00,
     *0.7705E+00,0.8900E+00,0.1034E+01,0.1207E+01,0.1417E+01,
     *0.1669E+01,0.1975E+01,0.2351E+01,0.2817E+01,0.3400E+01,
     *0.4133E+01,0.5062E+01,0.6251E+01,0.7793E+01,0.9812E+01,
     *0.1246E+02,0.1594E+02,0.2046E+02,0.2618E+02,0.3298E+02,
     *0.4009E+02,0.4560E+02,0.4714E+02 /
        DATA ((PHR(i,j),j=1,83),i= 6, 6)/
     *0.1755E+00,0.1650E+00,0.1366E+00,0.1235E+00,0.1363E+00,
     *0.1615E+00,0.1828E+00,0.1930E+00,0.1932E+00,0.1873E+00,
     *0.1796E+00,0.1718E+00,0.1638E+00,0.1558E+00,0.1480E+00,
     *0.1402E+00,0.1330E+00,0.1258E+00,0.1183E+00,0.1115E+00,
     *0.1055E+00,0.1002E+00,0.9529E-01,0.9099E-01,0.8735E-01,
     *0.8439E-01,0.8211E-01,0.8043E-01,0.7921E-01,0.7857E-01,
     *0.7864E-01,0.7928E-01,0.8015E-01,0.8126E-01,0.8312E-01,
     *0.8568E-01,0.8859E-01,0.9215E-01,0.9660E-01,0.1016E+00,
     *0.1073E+00,0.1107E+00,0.1143E+00,0.1226E+00,0.1318E+00,
     *0.1421E+00,0.1542E+00,0.1679E+00,0.1836E+00,0.2022E+00,
     *0.2240E+00,0.2486E+00,0.2769E+00,0.3103E+00,0.3492E+00,
     *0.3941E+00,0.4465E+00,0.5083E+00,0.5808E+00,0.6659E+00,
     *0.7676E+00,0.8897E+00,0.1036E+01,0.1211E+01,0.1421E+01,
     *0.1677E+01,0.1991E+01,0.2376E+01,0.2854E+01,0.3452E+01,
     *0.4205E+01,0.5160E+01,0.6379E+01,0.7949E+01,0.9985E+01,
     *0.1264E+02,0.1607E+02,0.2047E+02,0.2590E+02,0.3220E+02,
     *0.3860E+02,0.4345E+02,0.4478E+02 /
        DATA ((PHR(i,j),j=1,83),i= 7, 7)/
     *0.1638E+00,0.1551E+00,0.1306E+00,0.1178E+00,0.1276E+00,
     *0.1496E+00,0.1696E+00,0.1804E+00,0.1820E+00,0.1777E+00,
     *0.1711E+00,0.1641E+00,0.1567E+00,0.1491E+00,0.1416E+00,
     *0.1342E+00,0.1271E+00,0.1203E+00,0.1139E+00,0.1078E+00,
     *0.1020E+00,0.9688E-01,0.9251E-01,0.8873E-01,0.8542E-01,
     *0.8270E-01,0.8061E-01,0.7900E-01,0.7789E-01,0.7737E-01,
     *0.7742E-01,0.7789E-01,0.7881E-01,0.8032E-01,0.8242E-01,
     *0.8499E-01,0.8796E-01,0.9154E-01,0.9587E-01,0.1008E+00,
     *0.1066E+00,0.1098E+00,0.1134E+00,0.1214E+00,0.1305E+00,
     *0.1408E+00,0.1527E+00,0.1665E+00,0.1824E+00,0.2009E+00,
     *0.2225E+00,0.2471E+00,0.2752E+00,0.3081E+00,0.3467E+00,
     *0.3916E+00,0.4438E+00,0.5057E+00,0.5788E+00,0.6651E+00,
     *0.7677E+00,0.8912E+00,0.1040E+01,0.1217E+01,0.1432E+01,
     *0.1694E+01,0.2017E+01,0.2416E+01,0.2911E+01,0.3530E+01,
     *0.4308E+01,0.5293E+01,0.6547E+01,0.8151E+01,0.1021E+02,
     *0.1284E+02,0.1619E+02,0.2038E+02,0.2544E+02,0.3112E+02,
     *0.3673E+02,0.4085E+02,0.4196E+02 /
        DATA ((PHR(i,j),j=1,83),i= 8, 8)/
     *0.1489E+00,0.1422E+00,0.1236E+00,0.1141E+00,0.1226E+00,
     *0.1410E+00,0.1576E+00,0.1670E+00,0.1696E+00,0.1674E+00,
     *0.1624E+00,0.1559E+00,0.1489E+00,0.1417E+00,0.1347E+00,
     *0.1278E+00,0.1213E+00,0.1149E+00,0.1088E+00,0.1030E+00,
     *0.9774E-01,0.9320E-01,0.8922E-01,0.8576E-01,0.8295E-01,
     *0.8069E-01,0.7886E-01,0.7756E-01,0.7675E-01,0.7632E-01,
     *0.7636E-01,0.7698E-01,0.7807E-01,0.7955E-01,0.8152E-01,
     *0.8411E-01,0.8729E-01,0.9100E-01,0.9530E-01,0.1003E+00,
     *0.1062E+00,0.1094E+00,0.1128E+00,0.1205E+00,0.1295E+00,
     *0.1401E+00,0.1522E+00,0.1660E+00,0.1820E+00,0.2005E+00,
     *0.2215E+00,0.2459E+00,0.2745E+00,0.3075E+00,0.3457E+00,
     *0.3904E+00,0.4433E+00,0.5058E+00,0.5794E+00,0.6670E+00,
     *0.7718E+00,0.8971E+00,0.1047E+01,0.1229E+01,0.1451E+01,
     *0.1722E+01,0.2056E+01,0.2470E+01,0.2984E+01,0.3627E+01,
     *0.4433E+01,0.5448E+01,0.6735E+01,0.8367E+01,0.1043E+02,
     *0.1303E+02,0.1626E+02,0.2019E+02,0.2480E+02,0.2984E+02,
     *0.3464E+02,0.3807E+02,0.3899E+02 /
        DATA ((PHR(i,j),j=1,83),i= 9, 9)/
     *0.1415E+00,0.1359E+00,0.1198E+00,0.1103E+00,0.1156E+00,
     *0.1302E+00,0.1448E+00,0.1540E+00,0.1574E+00,0.1565E+00,
     *0.1524E+00,0.1467E+00,0.1404E+00,0.1341E+00,0.1279E+00,
     *0.1215E+00,0.1150E+00,0.1090E+00,0.1037E+00,0.9871E-01,
     *0.9410E-01,0.8990E-01,0.8621E-01,0.8313E-01,0.8063E-01,
     *0.7866E-01,0.7713E-01,0.7601E-01,0.7535E-01,0.7517E-01,
     *0.7538E-01,0.7595E-01,0.7705E-01,0.7869E-01,0.8075E-01,
     *0.8326E-01,0.8638E-01,0.9012E-01,0.9450E-01,0.9966E-01,
     *0.1057E+00,0.1091E+00,0.1126E+00,0.1203E+00,0.1293E+00,
     *0.1398E+00,0.1518E+00,0.1657E+00,0.1816E+00,0.1998E+00,
     *0.2207E+00,0.2453E+00,0.2739E+00,0.3070E+00,0.3457E+00,
     *0.3913E+00,0.4449E+00,0.5080E+00,0.5831E+00,0.6728E+00,
     *0.7794E+00,0.9069E+00,0.1061E+01,0.1249E+01,0.1479E+01,
     *0.1761E+01,0.2108E+01,0.2537E+01,0.3070E+01,0.3736E+01,
     *0.4569E+01,0.5615E+01,0.6928E+01,0.8573E+01,0.1062E+02,
     *0.1316E+02,0.1624E+02,0.1990E+02,0.2407E+02,0.2848E+02,
     *0.3256E+02,0.3540E+02,0.3614E+02 /
        DATA ((PHR(i,j),j=1,83),i=10,10)/
     *0.1337E+00,0.1293E+00,0.1163E+00,0.1075E+00,0.1102E+00,
     *0.1214E+00,0.1339E+00,0.1427E+00,0.1464E+00,0.1459E+00,
     *0.1427E+00,0.1380E+00,0.1325E+00,0.1267E+00,0.1208E+00,
     *0.1150E+00,0.1093E+00,0.1039E+00,0.9893E-01,0.9453E-01,
     *0.9050E-01,0.8683E-01,0.8361E-01,0.8086E-01,0.7857E-01,
     *0.7673E-01,0.7539E-01,0.7453E-01,0.7411E-01,0.7409E-01,
     *0.7445E-01,0.7518E-01,0.7637E-01,0.7808E-01,0.8021E-01,
     *0.8279E-01,0.8594E-01,0.8972E-01,0.9418E-01,0.9941E-01,
     *0.1055E+00,0.1088E+00,0.1124E+00,0.1205E+00,0.1297E+00,
     *0.1401E+00,0.1521E+00,0.1659E+00,0.1818E+00,0.2002E+00,
     *0.2215E+00,0.2463E+00,0.2750E+00,0.3086E+00,0.3481E+00,
     *0.3945E+00,0.4491E+00,0.5136E+00,0.5902E+00,0.6816E+00,
     *0.7908E+00,0.9226E+00,0.1083E+01,0.1278E+01,0.1516E+01,
     *0.1807E+01,0.2167E+01,0.2611E+01,0.3163E+01,0.3850E+01,
     *0.4707E+01,0.5776E+01,0.7103E+01,0.8746E+01,0.1077E+02,
     *0.1322E+02,0.1615E+02,0.1954E+02,0.2330E+02,0.2715E+02,
     *0.3059E+02,0.3292E+02,0.3352E+02 /
        DATA ((PHR(i,j),j=1,83),i=11,11)/
     *0.1284E+00,0.1248E+00,0.1140E+00,0.1066E+00,0.1085E+00,
     *0.1173E+00,0.1275E+00,0.1349E+00,0.1385E+00,0.1387E+00,
     *0.1362E+00,0.1320E+00,0.1270E+00,0.1216E+00,0.1162E+00,
     *0.1109E+00,0.1057E+00,0.1007E+00,0.9599E-01,0.9168E-01,
     *0.8792E-01,0.8467E-01,0.8184E-01,0.7938E-01,0.7732E-01,
     *0.7569E-01,0.7448E-01,0.7368E-01,0.7333E-01,0.7341E-01,
     *0.7386E-01,0.7469E-01,0.7600E-01,0.7779E-01,0.8003E-01,
     *0.8273E-01,0.8597E-01,0.8983E-01,0.9435E-01,0.9965E-01,
     *0.1058E+00,0.1092E+00,0.1128E+00,0.1208E+00,0.1301E+00,
     *0.1407E+00,0.1529E+00,0.1670E+00,0.1832E+00,0.2018E+00,
     *0.2233E+00,0.2485E+00,0.2779E+00,0.3121E+00,0.3521E+00,
     *0.3993E+00,0.4548E+00,0.5204E+00,0.5986E+00,0.6923E+00,
     *0.8047E+00,0.9404E+00,0.1105E+01,0.1306E+01,0.1551E+01,
     *0.1851E+01,0.2220E+01,0.2676E+01,0.3242E+01,0.3945E+01,
     *0.4815E+01,0.5892E+01,0.7221E+01,0.8853E+01,0.1084E+02,
     *0.1322E+02,0.1601E+02,0.1918E+02,0.2263E+02,0.2609E+02,
     *0.2913E+02,0.3115E+02,0.3167E+02 /
        DATA ((PHR(i,j),j=1,83),i=12,12)/
     *0.1253E+00,0.1223E+00,0.1130E+00,0.1062E+00,0.1073E+00,
     *0.1148E+00,0.1239E+00,0.1308E+00,0.1342E+00,0.1344E+00,
     *0.1322E+00,0.1284E+00,0.1238E+00,0.1187E+00,0.1133E+00,
     *0.1082E+00,0.1035E+00,0.9880E-01,0.9428E-01,0.9010E-01,
     *0.8647E-01,0.8337E-01,0.8071E-01,0.7843E-01,0.7649E-01,
     *0.7493E-01,0.7380E-01,0.7311E-01,0.7282E-01,0.7295E-01,
     *0.7353E-01,0.7455E-01,0.7594E-01,0.7772E-01,0.8000E-01,
     *0.8283E-01,0.8620E-01,0.9014E-01,0.9471E-01,0.9998E-01,
     *0.1061E+00,0.1095E+00,0.1131E+00,0.1213E+00,0.1306E+00,
     *0.1413E+00,0.1536E+00,0.1678E+00,0.1842E+00,0.2032E+00,
     *0.2251E+00,0.2506E+00,0.2802E+00,0.3148E+00,0.3554E+00,
     *0.4031E+00,0.4594E+00,0.5261E+00,0.6054E+00,0.7005E+00,
     *0.8151E+00,0.9538E+00,0.1122E+01,0.1326E+01,0.1574E+01,
     *0.1880E+01,0.2255E+01,0.2720E+01,0.3294E+01,0.4004E+01,
     *0.4881E+01,0.5962E+01,0.7290E+01,0.8910E+01,0.1087E+02,
     *0.1319E+02,0.1590E+02,0.1894E+02,0.2221E+02,0.2544E+02,
     *0.2824E+02,0.3007E+02,0.3054E+02 /
        DATA ((PHR(i,j),j=1,83),i=13,13)/
     *0.1225E+00,0.1201E+00,0.1128E+00,0.1067E+00,0.1062E+00,
     *0.1107E+00,0.1169E+00,0.1220E+00,0.1249E+00,0.1252E+00,
     *0.1236E+00,0.1204E+00,0.1164E+00,0.1121E+00,0.1076E+00,
     *0.1029E+00,0.9837E-01,0.9419E-01,0.9039E-01,0.8685E-01,
     *0.8359E-01,0.8068E-01,0.7822E-01,0.7626E-01,0.7474E-01,
     *0.7361E-01,0.7280E-01,0.7231E-01,0.7220E-01,0.7251E-01,
     *0.7322E-01,0.7434E-01,0.7591E-01,0.7795E-01,0.8044E-01,
     *0.8339E-01,0.8688E-01,0.9097E-01,0.9573E-01,0.1012E+00,
     *0.1076E+00,0.1111E+00,0.1149E+00,0.1232E+00,0.1328E+00,
     *0.1439E+00,0.1566E+00,0.1714E+00,0.1884E+00,0.2080E+00,
     *0.2308E+00,0.2573E+00,0.2882E+00,0.3243E+00,0.3665E+00,
     *0.4163E+00,0.4752E+00,0.5453E+00,0.6291E+00,0.7296E+00,
     *0.8502E+00,0.9954E+00,0.1171E+01,0.1385E+01,0.1646E+01,
     *0.1965E+01,0.2357E+01,0.2838E+01,0.3428E+01,0.4153E+01,
     *0.5039E+01,0.6121E+01,0.7433E+01,0.9008E+01,0.1088E+02,
     *0.1305E+02,0.1552E+02,0.1824E+02,0.2107E+02,0.2379E+02,
     *0.2609E+02,0.2756E+02,0.2793E+02 /
        DATA ((PHR(i,j),j=1,83),i=14,14)/
     *0.1200E+00,0.1185E+00,0.1132E+00,0.1081E+00,0.1062E+00,
     *0.1076E+00,0.1106E+00,0.1135E+00,0.1151E+00,0.1151E+00,
     *0.1137E+00,0.1112E+00,0.1080E+00,0.1044E+00,0.1006E+00,
     *0.9679E-01,0.9304E-01,0.8947E-01,0.8618E-01,0.8326E-01,
     *0.8070E-01,0.7847E-01,0.7653E-01,0.7490E-01,0.7362E-01,
     *0.7273E-01,0.7225E-01,0.7216E-01,0.7243E-01,0.7305E-01,
     *0.7399E-01,0.7530E-01,0.7704E-01,0.7925E-01,0.8194E-01,
     *0.8516E-01,0.8896E-01,0.9340E-01,0.9855E-01,0.1045E+00,
     *0.1113E+00,0.1151E+00,0.1192E+00,0.1282E+00,0.1386E+00,
     *0.1505E+00,0.1642E+00,0.1800E+00,0.1981E+00,0.2191E+00,
     *0.2435E+00,0.2718E+00,0.3050E+00,0.3439E+00,0.3898E+00,
     *0.4439E+00,0.5080E+00,0.5840E+00,0.6745E+00,0.7827E+00,
     *0.9124E+00,0.1069E+01,0.1258E+01,0.1487E+01,0.1764E+01,
     *0.2101E+01,0.2511E+01,0.3008E+01,0.3613E+01,0.4345E+01,
     *0.5229E+01,0.6290E+01,0.7550E+01,0.9033E+01,0.1075E+02,
     *0.1270E+02,0.1485E+02,0.1715E+02,0.1945E+02,0.2160E+02,
     *0.2335E+02,0.2444E+02,0.2471E+02 /
        DATA ((PHR(i,j),j=1,83),i=15,15)/
     *0.1280E+00,0.1274E+00,0.1252E+00,0.1220E+00,0.1188E+00,
     *0.1161E+00,0.1140E+00,0.1121E+00,0.1102E+00,0.1082E+00,
     *0.1059E+00,0.1034E+00,0.1008E+00,0.9812E-01,0.9541E-01,
     *0.9278E-01,0.9029E-01,0.8797E-01,0.8585E-01,0.8397E-01,
     *0.8238E-01,0.8110E-01,0.8013E-01,0.7948E-01,0.7912E-01,
     *0.7908E-01,0.7939E-01,0.8008E-01,0.8118E-01,0.8271E-01,
     *0.8468E-01,0.8710E-01,0.9000E-01,0.9343E-01,0.9745E-01,
     *0.1022E+00,0.1076E+00,0.1140E+00,0.1213E+00,0.1297E+00,
     *0.1393E+00,0.1447E+00,0.1504E+00,0.1631E+00,0.1776E+00,
     *0.1942E+00,0.2133E+00,0.2352E+00,0.2605E+00,0.2898E+00,
     *0.3237E+00,0.3630E+00,0.4088E+00,0.4621E+00,0.5243E+00,
     *0.5969E+00,0.6818E+00,0.7814E+00,0.8982E+00,0.1036E+01,
     *0.1197E+01,0.1388E+01,0.1612E+01,0.1875E+01,0.2185E+01,
     *0.2549E+01,0.2974E+01,0.3472E+01,0.4050E+01,0.4717E+01,
     *0.5484E+01,0.6355E+01,0.7333E+01,0.8417E+01,0.9594E+01,
     *0.1084E+02,0.1213E+02,0.1341E+02,0.1460E+02,0.1563E+02,
     *0.1642E+02,0.1689E+02,0.1700E+02 /
        DATA ((PHR(i,j),j=1,83),i=16,16)/
     *0.1420E+00,0.1416E+00,0.1400E+00,0.1375E+00,0.1346E+00,
     *0.1315E+00,0.1285E+00,0.1255E+00,0.1226E+00,0.1197E+00,
     *0.1168E+00,0.1140E+00,0.1111E+00,0.1084E+00,0.1057E+00,
     *0.1032E+00,0.1009E+00,0.9875E-01,0.9687E-01,0.9528E-01,
     *0.9398E-01,0.9298E-01,0.9231E-01,0.9197E-01,0.9199E-01,
     *0.9240E-01,0.9323E-01,0.9449E-01,0.9622E-01,0.9843E-01,
     *0.1011E+00,0.1044E+00,0.1083E+00,0.1129E+00,0.1182E+00,
     *0.1245E+00,0.1316E+00,0.1399E+00,0.1493E+00,0.1601E+00,
     *0.1725E+00,0.1793E+00,0.1866E+00,0.2028E+00,0.2213E+00,
     *0.2424E+00,0.2666E+00,0.2944E+00,0.3262E+00,0.3627E+00,
     *0.4046E+00,0.4529E+00,0.5084E+00,0.5725E+00,0.6464E+00,
     *0.7316E+00,0.8301E+00,0.9437E+00,0.1075E+01,0.1227E+01,
     *0.1402E+01,0.1604E+01,0.1837E+01,0.2105E+01,0.2412E+01,
     *0.2765E+01,0.3167E+01,0.3624E+01,0.4140E+01,0.4720E+01,
     *0.5365E+01,0.6076E+01,0.6850E+01,0.7679E+01,0.8551E+01,
     *0.9446E+01,0.1034E+02,0.1119E+02,0.1197E+02,0.1262E+02,
     *0.1311E+02,0.1340E+02,0.1346E+02 /
        DATA ((PHR(i,j),j=1,83),i=17,17)/
     *0.1485E+00,0.1482E+00,0.1468E+00,0.1445E+00,0.1417E+00,
     *0.1387E+00,0.1356E+00,0.1325E+00,0.1294E+00,0.1264E+00,
     *0.1234E+00,0.1204E+00,0.1175E+00,0.1147E+00,0.1120E+00,
     *0.1095E+00,0.1072E+00,0.1051E+00,0.1033E+00,0.1018E+00,
     *0.1005E+00,0.9963E-01,0.9906E-01,0.9884E-01,0.9899E-01,
     *0.9953E-01,0.1005E+00,0.1019E+00,0.1038E+00,0.1062E+00,
     *0.1092E+00,0.1129E+00,0.1171E+00,0.1221E+00,0.1279E+00,
     *0.1347E+00,0.1425E+00,0.1515E+00,0.1618E+00,0.1736E+00,
     *0.1871E+00,0.1945E+00,0.2025E+00,0.2201E+00,0.2402E+00,
     *0.2631E+00,0.2892E+00,0.3190E+00,0.3531E+00,0.3922E+00,
     *0.4369E+00,0.4882E+00,0.5471E+00,0.6147E+00,0.6923E+00,
     *0.7814E+00,0.8837E+00,0.1001E+01,0.1136E+01,0.1291E+01,
     *0.1469E+01,0.1672E+01,0.1905E+01,0.2171E+01,0.2474E+01,
     *0.2818E+01,0.3207E+01,0.3645E+01,0.4136E+01,0.4681E+01,
     *0.5282E+01,0.5937E+01,0.6644E+01,0.7393E+01,0.8172E+01,
     *0.8964E+01,0.9745E+01,0.1049E+02,0.1115E+02,0.1171E+02,
     *0.1213E+02,0.1237E+02,0.1242E+02 /
        DATA ((PHR(i,j),j=1,83),i=18,18)/
     *0.1709E+00,0.1707E+00,0.1696E+00,0.1677E+00,0.1653E+00,
     *0.1626E+00,0.1596E+00,0.1564E+00,0.1532E+00,0.1500E+00,
     *0.1468E+00,0.1437E+00,0.1406E+00,0.1377E+00,0.1349E+00,
     *0.1323E+00,0.1300E+00,0.1278E+00,0.1260E+00,0.1244E+00,
     *0.1231E+00,0.1222E+00,0.1217E+00,0.1215E+00,0.1218E+00,
     *0.1226E+00,0.1238E+00,0.1256E+00,0.1279E+00,0.1309E+00,
     *0.1345E+00,0.1389E+00,0.1441E+00,0.1502E+00,0.1573E+00,
     *0.1656E+00,0.1750E+00,0.1859E+00,0.1983E+00,0.2125E+00,
     *0.2286E+00,0.2375E+00,0.2470E+00,0.2679E+00,0.2917E+00,
     *0.3187E+00,0.3495E+00,0.3844E+00,0.4241E+00,0.4692E+00,
     *0.5204E+00,0.5785E+00,0.6445E+00,0.7194E+00,0.8044E+00,
     *0.9008E+00,0.1010E+01,0.1134E+01,0.1274E+01,0.1433E+01,
     *0.1611E+01,0.1813E+01,0.2039E+01,0.2293E+01,0.2577E+01,
     *0.2894E+01,0.3244E+01,0.3631E+01,0.4054E+01,0.4515E+01,
     *0.5012E+01,0.5542E+01,0.6100E+01,0.6678E+01,0.7267E+01,
     *0.7852E+01,0.8416E+01,0.8942E+01,0.9406E+01,0.9788E+01,
     *0.1007E+02,0.1023E+02,0.1027E+02 /
        DATA ((PHR(i,j),j=1,83),i=19,19)/
     *0.1989E+00,0.1987E+00,0.1978E+00,0.1962E+00,0.1942E+00,
     *0.1917E+00,0.1889E+00,0.1859E+00,0.1828E+00,0.1796E+00,
     *0.1764E+00,0.1732E+00,0.1701E+00,0.1671E+00,0.1643E+00,
     *0.1616E+00,0.1592E+00,0.1569E+00,0.1550E+00,0.1534E+00,
     *0.1520E+00,0.1511E+00,0.1506E+00,0.1504E+00,0.1508E+00,
     *0.1516E+00,0.1530E+00,0.1549E+00,0.1576E+00,0.1609E+00,
     *0.1650E+00,0.1699E+00,0.1758E+00,0.1828E+00,0.1909E+00,
     *0.2003E+00,0.2111E+00,0.2235E+00,0.2377E+00,0.2539E+00,
     *0.2724E+00,0.2826E+00,0.2934E+00,0.3172E+00,0.3441E+00,
     *0.3745E+00,0.4089E+00,0.4478E+00,0.4916E+00,0.5410E+00,
     *0.5967E+00,0.6595E+00,0.7301E+00,0.8095E+00,0.8987E+00,
     *0.9988E+00,0.1111E+01,0.1237E+01,0.1377E+01,0.1534E+01,
     *0.1708E+01,0.1902E+01,0.2117E+01,0.2354E+01,0.2615E+01,
     *0.2901E+01,0.3212E+01,0.3550E+01,0.3914E+01,0.4303E+01,
     *0.4714E+01,0.5146E+01,0.5591E+01,0.6045E+01,0.6499E+01,
     *0.6942E+01,0.7364E+01,0.7749E+01,0.8086E+01,0.8359E+01,
     *0.8557E+01,0.8671E+01,0.8698E+01 /
        DATA ((PHR(i,j),j=1,83),i=20,20)/
     *0.4039E+00,0.4037E+00,0.4031E+00,0.4020E+00,0.4004E+00,
     *0.3985E+00,0.3961E+00,0.3934E+00,0.3903E+00,0.3870E+00,
     *0.3834E+00,0.3797E+00,0.3758E+00,0.3718E+00,0.3678E+00,
     *0.3638E+00,0.3598E+00,0.3559E+00,0.3522E+00,0.3487E+00,
     *0.3454E+00,0.3425E+00,0.3400E+00,0.3379E+00,0.3364E+00,
     *0.3355E+00,0.3352E+00,0.3358E+00,0.3372E+00,0.3396E+00,
     *0.3430E+00,0.3476E+00,0.3536E+00,0.3610E+00,0.3700E+00,
     *0.3808E+00,0.3934E+00,0.4082E+00,0.4253E+00,0.4449E+00,
     *0.4672E+00,0.4795E+00,0.4925E+00,0.5209E+00,0.5529E+00,
     *0.5886E+00,0.6283E+00,0.6724E+00,0.7211E+00,0.7748E+00,
     *0.8339E+00,0.8986E+00,0.9693E+00,0.1046E+01,0.1130E+01,
     *0.1221E+01,0.1319E+01,0.1424E+01,0.1537E+01,0.1659E+01,
     *0.1788E+01,0.1925E+01,0.2069E+01,0.2222E+01,0.2382E+01,
     *0.2548E+01,0.2721E+01,0.2898E+01,0.3079E+01,0.3263E+01,
     *0.3447E+01,0.3631E+01,0.3810E+01,0.3984E+01,0.4150E+01,
     *0.4304E+01,0.4444E+01,0.4567E+01,0.4671E+01,0.4753E+01,
     *0.4811E+01,0.4844E+01,0.4852E+01 /
c************** MIE (phase fun qh) ***************
        DATA ((QHR(i,j),j=1,83),i= 1, 1)/
     *-0.5308E-21,-0.3847E-02,-0.7671E-02,-0.1357E-02, 0.4828E-02,
     *-0.2220E-02,-0.2526E-01,-0.5228E-01,-0.7486E-01,-0.8780E-01,
     *-0.9331E-01,-0.9431E-01,-0.8953E-01,-0.7919E-01,-0.6584E-01,
     *-0.5399E-01,-0.4485E-01,-0.3392E-01,-0.2352E-01,-0.1671E-01,
     *-0.1125E-01,-0.6411E-02,-0.3637E-02,-0.2257E-02,-0.4036E-03,
     * 0.1497E-02, 0.2087E-02, 0.1657E-02, 0.2143E-02, 0.3304E-02,
     * 0.3609E-02, 0.3288E-02, 0.3797E-02, 0.4872E-02, 0.6129E-02,
     * 0.6769E-02, 0.7335E-02, 0.8643E-02, 0.9557E-02, 0.1068E-01,
     * 0.1298E-01, 0.1395E-01, 0.1447E-01, 0.1504E-01, 0.1661E-01,
     * 0.1898E-01, 0.2061E-01, 0.2232E-01, 0.2514E-01, 0.2842E-01,
     * 0.3015E-01, 0.3158E-01, 0.3669E-01, 0.4103E-01, 0.4226E-01,
     * 0.4606E-01, 0.5303E-01, 0.5746E-01, 0.6100E-01, 0.6848E-01,
     * 0.7725E-01, 0.8308E-01, 0.8673E-01, 0.9333E-01, 0.1045E+00,
     * 0.1155E+00, 0.1211E+00, 0.1233E+00, 0.1321E+00, 0.1445E+00,
     * 0.1527E+00, 0.1531E+00, 0.1504E+00, 0.1585E+00, 0.1756E+00,
     * 0.1892E+00, 0.1897E+00, 0.1712E+00, 0.1322E+00, 0.8504E-01,
     * 0.3936E-01, 0.8367E-02, 0.1901E-19 /
        DATA ((QHR(i,j),j=1,83),i= 2, 2)/
     * 0.6787E-21,-0.1662E-02,-0.3169E-02, 0.9185E-03, 0.3963E-02,
     *-0.3095E-02,-0.2183E-01,-0.4467E-01,-0.6291E-01,-0.7432E-01,
     *-0.7984E-01,-0.8006E-01,-0.7549E-01,-0.6806E-01,-0.5945E-01,
     *-0.4954E-01,-0.3957E-01,-0.3153E-01,-0.2509E-01,-0.1935E-01,
     *-0.1391E-01,-0.9390E-02,-0.6723E-02,-0.4789E-02,-0.2548E-02,
     *-0.1083E-02,-0.4758E-03, 0.4041E-03, 0.1280E-02, 0.1548E-02,
     * 0.1781E-02, 0.2567E-02, 0.3456E-02, 0.3663E-02, 0.3860E-02,
     * 0.4835E-02, 0.5663E-02, 0.6322E-02, 0.7667E-02, 0.8904E-02,
     * 0.9905E-02, 0.1067E-01, 0.1162E-01, 0.1323E-01, 0.1408E-01,
     * 0.1571E-01, 0.1827E-01, 0.1991E-01, 0.2125E-01, 0.2362E-01,
     * 0.2592E-01, 0.2787E-01, 0.3089E-01, 0.3509E-01, 0.3916E-01,
     * 0.4221E-01, 0.4604E-01, 0.5197E-01, 0.5751E-01, 0.6183E-01,
     * 0.6828E-01, 0.7651E-01, 0.8355E-01, 0.9061E-01, 0.1001E+00,
     * 0.1107E+00, 0.1202E+00, 0.1292E+00, 0.1388E+00, 0.1497E+00,
     * 0.1612E+00, 0.1729E+00, 0.1808E+00, 0.1857E+00, 0.1927E+00,
     * 0.2037E+00, 0.2113E+00, 0.2034E+00, 0.1811E+00, 0.1435E+00,
     * 0.8311E-01, 0.1985E-01,-0.6852E-19 /
        DATA ((QHR(i,j),j=1,83),i= 3, 3)/
     * 0.5459E-21,-0.8407E-03,-0.4804E-03, 0.3452E-02, 0.3932E-02,
     *-0.4570E-02,-0.2150E-01,-0.4196E-01,-0.6035E-01,-0.7299E-01,
     *-0.7823E-01,-0.7741E-01,-0.7284E-01,-0.6617E-01,-0.5821E-01,
     *-0.4899E-01,-0.3932E-01,-0.3126E-01,-0.2512E-01,-0.1961E-01,
     *-0.1464E-01,-0.1062E-01,-0.7453E-02,-0.5056E-02,-0.3402E-02,
     *-0.2244E-02,-0.1182E-02,-0.2040E-03, 0.4527E-03, 0.8720E-03,
     * 0.1457E-02, 0.2287E-02, 0.2885E-02, 0.3056E-02, 0.3389E-02,
     * 0.4199E-02, 0.4951E-02, 0.5611E-02, 0.6817E-02, 0.8115E-02,
     * 0.8826E-02, 0.9268E-02, 0.9985E-02, 0.1195E-01, 0.1341E-01,
     * 0.1459E-01, 0.1651E-01, 0.1849E-01, 0.1987E-01, 0.2171E-01,
     * 0.2460E-01, 0.2740E-01, 0.2975E-01, 0.3303E-01, 0.3747E-01,
     * 0.4136E-01, 0.4479E-01, 0.4979E-01, 0.5591E-01, 0.6082E-01,
     * 0.6577E-01, 0.7395E-01, 0.8361E-01, 0.9120E-01, 0.9799E-01,
     * 0.1079E+00, 0.1194E+00, 0.1303E+00, 0.1403E+00, 0.1506E+00,
     * 0.1618E+00, 0.1742E+00, 0.1867E+00, 0.1955E+00, 0.1989E+00,
     * 0.2008E+00, 0.2088E+00, 0.2211E+00, 0.2187E+00, 0.1758E+00,
     * 0.9568E-01, 0.2146E-01,-0.2920E-21 /
        DATA ((QHR(i,j),j=1,83),i= 4, 4)/
     *-0.2160E-21,-0.5478E-03,-0.3328E-03, 0.2842E-02, 0.4430E-02,
     *-0.1803E-02,-0.1715E-01,-0.3619E-01,-0.5231E-01,-0.6302E-01,
     *-0.6842E-01,-0.6906E-01,-0.6578E-01,-0.6007E-01,-0.5313E-01,
     *-0.4509E-01,-0.3694E-01,-0.3008E-01,-0.2451E-01,-0.1964E-01,
     *-0.1505E-01,-0.1111E-01,-0.8535E-02,-0.6538E-02,-0.4446E-02,
     *-0.3014E-02,-0.2147E-02,-0.1212E-02,-0.5118E-03,-0.2022E-03,
     * 0.2086E-03, 0.9618E-03, 0.1733E-02, 0.2072E-02, 0.2448E-02,
     * 0.3363E-02, 0.4169E-02, 0.4819E-02, 0.5963E-02, 0.7034E-02,
     * 0.7800E-02, 0.8361E-02, 0.9085E-02, 0.1044E-01, 0.1124E-01,
     * 0.1252E-01, 0.1454E-01, 0.1614E-01, 0.1760E-01, 0.1983E-01,
     * 0.2229E-01, 0.2464E-01, 0.2746E-01, 0.3088E-01, 0.3451E-01,
     * 0.3771E-01, 0.4113E-01, 0.4632E-01, 0.5222E-01, 0.5728E-01,
     * 0.6361E-01, 0.7184E-01, 0.7958E-01, 0.8707E-01, 0.9636E-01,
     * 0.1069E+00, 0.1174E+00, 0.1280E+00, 0.1395E+00, 0.1521E+00,
     * 0.1646E+00, 0.1762E+00, 0.1857E+00, 0.1931E+00, 0.1996E+00,
     * 0.2050E+00, 0.2055E+00, 0.1947E+00, 0.1714E+00, 0.1326E+00,
     * 0.7461E-01, 0.1751E-01, 0.6497E-19 /
        DATA ((QHR(i,j),j=1,83),i= 5, 5)/
     *-0.2354E-21, 0.7911E-04, 0.1869E-02, 0.5575E-02, 0.5783E-02,
     *-0.1751E-02,-0.1525E-01,-0.3073E-01,-0.4557E-01,-0.5729E-01,
     *-0.6318E-01,-0.6339E-01,-0.6055E-01,-0.5588E-01,-0.4990E-01,
     *-0.4325E-01,-0.3617E-01,-0.2967E-01,-0.2410E-01,-0.1923E-01,
     *-0.1552E-01,-0.1253E-01,-0.9657E-02,-0.7314E-02,-0.5819E-02,
     *-0.4774E-02,-0.3636E-02,-0.2503E-02,-0.1788E-02,-0.1330E-02,
     *-0.7149E-03,-0.6828E-04, 0.4573E-03, 0.1058E-02, 0.1663E-02,
     * 0.2294E-02, 0.3129E-02, 0.3931E-02, 0.4575E-02, 0.5319E-02,
     * 0.6089E-02, 0.6411E-02, 0.6748E-02, 0.7799E-02, 0.9324E-02,
     * 0.1057E-01, 0.1163E-01, 0.1332E-01, 0.1535E-01, 0.1722E-01,
     * 0.1963E-01, 0.2237E-01, 0.2450E-01, 0.2689E-01, 0.3038E-01,
     * 0.3432E-01, 0.3830E-01, 0.4288E-01, 0.4833E-01, 0.5407E-01,
     * 0.6000E-01, 0.6706E-01, 0.7582E-01, 0.8512E-01, 0.9317E-01,
     * 0.1017E+00, 0.1138E+00, 0.1278E+00, 0.1402E+00, 0.1511E+00,
     * 0.1629E+00, 0.1762E+00, 0.1899E+00, 0.2005E+00, 0.2039E+00,
     * 0.2001E+00, 0.1944E+00, 0.1880E+00, 0.1713E+00, 0.1330E+00,
     * 0.7310E-01, 0.1672E-01, 0.4950E-19 /
        DATA ((QHR(i,j),j=1,83),i= 6, 6)/
     *-0.1055E-21,-0.4079E-03, 0.2357E-03, 0.4274E-02, 0.6725E-02,
     * 0.1356E-02,-0.1153E-01,-0.2710E-01,-0.4117E-01,-0.5124E-01,
     *-0.5667E-01,-0.5834E-01,-0.5661E-01,-0.5225E-01,-0.4638E-01,
     *-0.3989E-01,-0.3397E-01,-0.2861E-01,-0.2347E-01,-0.1903E-01,
     *-0.1524E-01,-0.1208E-01,-0.9792E-02,-0.7959E-02,-0.6207E-02,
     *-0.4666E-02,-0.3670E-02,-0.3007E-02,-0.2176E-02,-0.1423E-02,
     *-0.1069E-02,-0.5962E-03, 0.9352E-04, 0.6808E-03, 0.1268E-02,
     * 0.1913E-02, 0.2525E-02, 0.3139E-02, 0.3855E-02, 0.4686E-02,
     * 0.5611E-02, 0.6124E-02, 0.6635E-02, 0.7467E-02, 0.8339E-02,
     * 0.9799E-02, 0.1147E-01, 0.1303E-01, 0.1479E-01, 0.1684E-01,
     * 0.1866E-01, 0.2041E-01, 0.2324E-01, 0.2671E-01, 0.2937E-01,
     * 0.3233E-01, 0.3682E-01, 0.4179E-01, 0.4665E-01, 0.5236E-01,
     * 0.5910E-01, 0.6618E-01, 0.7311E-01, 0.8086E-01, 0.9079E-01,
     * 0.1020E+00, 0.1128E+00, 0.1230E+00, 0.1346E+00, 0.1480E+00,
     * 0.1612E+00, 0.1720E+00, 0.1799E+00, 0.1877E+00, 0.1954E+00,
     * 0.1984E+00, 0.1912E+00, 0.1680E+00, 0.1281E+00, 0.8054E-01,
     * 0.3755E-01, 0.7960E-02, 0.9892E-19 /
        DATA ((QHR(i,j),j=1,83),i= 7, 7)/
     * 0.1958E-22, 0.4175E-04, 0.1454E-02, 0.4916E-02, 0.6743E-02,
     * 0.2535E-02,-0.8462E-02,-0.2263E-01,-0.3546E-01,-0.4487E-01,
     *-0.5053E-01,-0.5253E-01,-0.5135E-01,-0.4799E-01,-0.4344E-01,
     *-0.3806E-01,-0.3257E-01,-0.2774E-01,-0.2352E-01,-0.1961E-01,
     *-0.1600E-01,-0.1298E-01,-0.1077E-01,-0.8974E-02,-0.7248E-02,
     *-0.5826E-02,-0.4808E-02,-0.3890E-02,-0.3038E-02,-0.2430E-02,
     *-0.1931E-02,-0.1320E-02,-0.7169E-03,-0.3549E-03,-0.1914E-04,
     * 0.5437E-03, 0.1106E-02, 0.1661E-02, 0.2412E-02, 0.3195E-02,
     * 0.4025E-02, 0.4532E-02, 0.5086E-02, 0.6131E-02, 0.7058E-02,
     * 0.8325E-02, 0.9937E-02, 0.1133E-01, 0.1269E-01, 0.1443E-01,
     * 0.1622E-01, 0.1805E-01, 0.2049E-01, 0.2360E-01, 0.2675E-01,
     * 0.2983E-01, 0.3365E-01, 0.3846E-01, 0.4341E-01, 0.4857E-01,
     * 0.5476E-01, 0.6171E-01, 0.6882E-01, 0.7670E-01, 0.8611E-01,
     * 0.9663E-01, 0.1074E+00, 0.1184E+00, 0.1299E+00, 0.1421E+00,
     * 0.1546E+00, 0.1665E+00, 0.1760E+00, 0.1827E+00, 0.1872E+00,
     * 0.1885E+00, 0.1819E+00, 0.1625E+00, 0.1309E+00, 0.9003E-01,
     * 0.4509E-01, 0.9761E-02, 0.1818E-19 /
        DATA ((QHR(i,j),j=1,83),i= 8, 8)/
     *-0.1308E-21, 0.5053E-03, 0.2848E-02, 0.6212E-02, 0.7468E-02,
     * 0.3675E-02,-0.5366E-02,-0.1737E-01,-0.2903E-01,-0.3802E-01,
     *-0.4379E-01,-0.4637E-01,-0.4593E-01,-0.4323E-01,-0.3939E-01,
     *-0.3532E-01,-0.3117E-01,-0.2684E-01,-0.2267E-01,-0.1905E-01,
     *-0.1609E-01,-0.1366E-01,-0.1151E-01,-0.9679E-02,-0.8249E-02,
     *-0.7079E-02,-0.6049E-02,-0.5228E-02,-0.4549E-02,-0.3857E-02,
     *-0.3234E-02,-0.2838E-02,-0.2501E-02,-0.1975E-02,-0.1434E-02,
     *-0.1045E-02,-0.5853E-03, 0.1863E-04, 0.6278E-03, 0.1332E-02,
     * 0.2225E-02, 0.2699E-02, 0.3165E-02, 0.4089E-02, 0.5098E-02,
     * 0.6137E-02, 0.7140E-02, 0.8324E-02, 0.9743E-02, 0.1118E-01,
     * 0.1284E-01, 0.1499E-01, 0.1729E-01, 0.1960E-01, 0.2248E-01,
     * 0.2611E-01, 0.2990E-01, 0.3370E-01, 0.3818E-01, 0.4368E-01,
     * 0.4960E-01, 0.5564E-01, 0.6262E-01, 0.7113E-01, 0.8060E-01,
     * 0.9015E-01, 0.1000E+00, 0.1111E+00, 0.1231E+00, 0.1351E+00,
     * 0.1468E+00, 0.1578E+00, 0.1674E+00, 0.1744E+00, 0.1776E+00,
     * 0.1755E+00, 0.1647E+00, 0.1434E+00, 0.1119E+00, 0.7395E-01,
     * 0.3589E-01, 0.7629E-02,-0.9169E-21 /
        DATA ((QHR(i,j),j=1,83),i= 9, 9)/
     *-0.8726E-23, 0.6411E-03, 0.3394E-02, 0.7113E-02, 0.8528E-02,
     * 0.5340E-02,-0.1990E-02,-0.1168E-01,-0.2190E-01,-0.3070E-01,
     *-0.3643E-01,-0.3897E-01,-0.3928E-01,-0.3808E-01,-0.3571E-01,
     *-0.3252E-01,-0.2891E-01,-0.2539E-01,-0.2219E-01,-0.1929E-01,
     *-0.1680E-01,-0.1460E-01,-0.1258E-01,-0.1088E-01,-0.9605E-02,
     *-0.8601E-02,-0.7678E-02,-0.6826E-02,-0.6152E-02,-0.5612E-02,
     *-0.5069E-02,-0.4530E-02,-0.4033E-02,-0.3557E-02,-0.3079E-02,
     *-0.2562E-02,-0.1973E-02,-0.1383E-02,-0.8448E-03,-0.2873E-03,
     * 0.2886E-03, 0.5708E-03, 0.8697E-03, 0.1622E-02, 0.2563E-02,
     * 0.3436E-02, 0.4277E-02, 0.5371E-02, 0.6689E-02, 0.8146E-02,
     * 0.9911E-02, 0.1188E-01, 0.1382E-01, 0.1599E-01, 0.1869E-01,
     * 0.2173E-01, 0.2496E-01, 0.2862E-01, 0.3280E-01, 0.3737E-01,
     * 0.4247E-01, 0.4860E-01, 0.5585E-01, 0.6356E-01, 0.7117E-01,
     * 0.7944E-01, 0.8932E-01, 0.1002E+00, 0.1111E+00, 0.1219E+00,
     * 0.1328E+00, 0.1436E+00, 0.1534E+00, 0.1602E+00, 0.1618E+00,
     * 0.1574E+00, 0.1485E+00, 0.1349E+00, 0.1131E+00, 0.7987E-01,
     * 0.4026E-01, 0.8715E-02,-0.3362E-20 /
        DATA ((QHR(i,j),j=1,83),i=10,10)/
     *-0.4912E-22, 0.6492E-03, 0.3305E-02, 0.6903E-02, 0.8964E-02,
     * 0.7371E-02, 0.1685E-02,-0.6733E-02,-0.1568E-01,-0.2337E-01,
     *-0.2887E-01,-0.3203E-01,-0.3319E-01,-0.3286E-01,-0.3147E-01,
     *-0.2924E-01,-0.2652E-01,-0.2388E-01,-0.2150E-01,-0.1926E-01,
     *-0.1712E-01,-0.1519E-01,-0.1354E-01,-0.1214E-01,-0.1093E-01,
     *-0.9904E-02,-0.9012E-02,-0.8237E-02,-0.7603E-02,-0.7065E-02,
     *-0.6523E-02,-0.5954E-02,-0.5442E-02,-0.5021E-02,-0.4591E-02,
     *-0.4111E-02,-0.3656E-02,-0.3222E-02,-0.2738E-02,-0.2280E-02,
     *-0.1886E-02,-0.1658E-02,-0.1385E-02,-0.7561E-03,-0.1249E-03,
     * 0.6209E-03, 0.1598E-02, 0.2669E-02, 0.3765E-02, 0.5048E-02,
     * 0.6578E-02, 0.8207E-02, 0.9949E-02, 0.1199E-01, 0.1435E-01,
     * 0.1684E-01, 0.1957E-01, 0.2287E-01, 0.2673E-01, 0.3088E-01,
     * 0.3556E-01, 0.4115E-01, 0.4731E-01, 0.5366E-01, 0.6057E-01,
     * 0.6847E-01, 0.7729E-01, 0.8679E-01, 0.9672E-01, 0.1067E+00,
     * 0.1166E+00, 0.1258E+00, 0.1338E+00, 0.1394E+00, 0.1413E+00,
     * 0.1384E+00, 0.1301E+00, 0.1157E+00, 0.9404E-01, 0.6447E-01,
     * 0.3161E-01, 0.6695E-02, 0.6922E-19 /
        DATA ((QHR(i,j),j=1,83),i=11,11)/
     * 0.9602E-22, 0.7231E-03, 0.3548E-02, 0.7227E-02, 0.9379E-02,
     * 0.8188E-02, 0.3559E-02,-0.3404E-02,-0.1127E-01,-0.1855E-01,
     *-0.2402E-01,-0.2736E-01,-0.2894E-01,-0.2921E-01,-0.2851E-01,
     *-0.2708E-01,-0.2515E-01,-0.2303E-01,-0.2094E-01,-0.1900E-01,
     *-0.1729E-01,-0.1575E-01,-0.1428E-01,-0.1298E-01,-0.1191E-01,
     *-0.1100E-01,-0.1015E-01,-0.9345E-02,-0.8677E-02,-0.8121E-02,
     *-0.7609E-02,-0.7149E-02,-0.6763E-02,-0.6420E-02,-0.6104E-02,
     *-0.5782E-02,-0.5421E-02,-0.5057E-02,-0.4709E-02,-0.4337E-02,
     *-0.3936E-02,-0.3722E-02,-0.3488E-02,-0.2916E-02,-0.2227E-02,
     *-0.1541E-02,-0.8513E-03,-0.2911E-04, 0.9395E-03, 0.2030E-02,
     * 0.3312E-02, 0.4719E-02, 0.6144E-02, 0.7770E-02, 0.9783E-02,
     * 0.1210E-01, 0.1466E-01, 0.1759E-01, 0.2099E-01, 0.2479E-01,
     * 0.2896E-01, 0.3368E-01, 0.3906E-01, 0.4492E-01, 0.5110E-01,
     * 0.5800E-01, 0.6612E-01, 0.7506E-01, 0.8401E-01, 0.9276E-01,
     * 0.1016E+00, 0.1104E+00, 0.1183E+00, 0.1237E+00, 0.1249E+00,
     * 0.1214E+00, 0.1133E+00, 0.1004E+00, 0.8140E-01, 0.5582E-01,
     * 0.2757E-01, 0.5893E-02, 0.2684E-19 /
        DATA ((QHR(i,j),j=1,83),i=12,12)/
     * 0.2191E-22, 0.6181E-03, 0.3190E-02, 0.6894E-02, 0.9547E-02,
     * 0.9106E-02, 0.5059E-02,-0.1485E-02,-0.8772E-02,-0.1539E-01,
     *-0.2067E-01,-0.2437E-01,-0.2639E-01,-0.2690E-01,-0.2638E-01,
     *-0.2531E-01,-0.2393E-01,-0.2224E-01,-0.2042E-01,-0.1870E-01,
     *-0.1712E-01,-0.1569E-01,-0.1445E-01,-0.1335E-01,-0.1231E-01,
     *-0.1135E-01,-0.1056E-01,-0.9909E-02,-0.9308E-02,-0.8767E-02,
     *-0.8350E-02,-0.8019E-02,-0.7705E-02,-0.7394E-02,-0.7096E-02,
     *-0.6827E-02,-0.6575E-02,-0.6302E-02,-0.5988E-02,-0.5596E-02,
     *-0.5117E-02,-0.4872E-02,-0.4635E-02,-0.4161E-02,-0.3613E-02,
     *-0.2982E-02,-0.2308E-02,-0.1572E-02,-0.7213E-03, 0.2080E-03,
     * 0.1176E-02, 0.2305E-02, 0.3727E-02, 0.5314E-02, 0.6980E-02,
     * 0.8974E-02, 0.1142E-01, 0.1417E-01, 0.1723E-01, 0.2076E-01,
     * 0.2469E-01, 0.2885E-01, 0.3336E-01, 0.3862E-01, 0.4488E-01,
     * 0.5183E-01, 0.5905E-01, 0.6651E-01, 0.7458E-01, 0.8323E-01,
     * 0.9185E-01, 0.9967E-01, 0.1061E+00, 0.1108E+00, 0.1131E+00,
     * 0.1112E+00, 0.1032E+00, 0.8785E-01, 0.6592E-01, 0.4075E-01,
     * 0.1806E-01, 0.3567E-02, 0.2626E-19 /
        DATA ((QHR(i,j),j=1,83),i=13,13)/
     *-0.1487E-21, 0.7015E-03, 0.3409E-02, 0.7016E-02, 0.9635E-02,
     * 0.9834E-02, 0.7324E-02, 0.2669E-02,-0.3157E-02,-0.9005E-02,
     *-0.1392E-01,-0.1754E-01,-0.1995E-01,-0.2134E-01,-0.2185E-01,
     *-0.2166E-01,-0.2101E-01,-0.2010E-01,-0.1907E-01,-0.1799E-01,
     *-0.1694E-01,-0.1593E-01,-0.1499E-01,-0.1418E-01,-0.1350E-01,
     *-0.1293E-01,-0.1240E-01,-0.1191E-01,-0.1150E-01,-0.1115E-01,
     *-0.1085E-01,-0.1058E-01,-0.1035E-01,-0.1016E-01,-0.9979E-02,
     *-0.9791E-02,-0.9579E-02,-0.9358E-02,-0.9143E-02,-0.8919E-02,
     *-0.8682E-02,-0.8559E-02,-0.8428E-02,-0.8117E-02,-0.7749E-02,
     *-0.7388E-02,-0.7034E-02,-0.6626E-02,-0.6153E-02,-0.5615E-02,
     *-0.4972E-02,-0.4239E-02,-0.3435E-02,-0.2463E-02,-0.1231E-02,
     * 0.2256E-03, 0.1850E-02, 0.3656E-02, 0.5654E-02, 0.7850E-02,
     * 0.1038E-01, 0.1347E-01, 0.1719E-01, 0.2135E-01, 0.2580E-01,
     * 0.3074E-01, 0.3639E-01, 0.4269E-01, 0.4938E-01, 0.5638E-01,
     * 0.6358E-01, 0.7066E-01, 0.7700E-01, 0.8167E-01, 0.8353E-01,
     * 0.8191E-01, 0.7671E-01, 0.6772E-01, 0.5425E-01, 0.3650E-01,
     * 0.1764E-01, 0.3711E-02,-0.3550E-19 /
        DATA ((QHR(i,j),j=1,83),i=14,14)/
     *-0.1464E-21, 0.6290E-03, 0.3055E-02, 0.6400E-02, 0.9252E-02,
     * 0.1043E-01, 0.9451E-02, 0.6562E-02, 0.2449E-02,-0.2067E-02,
     *-0.6299E-02,-0.9870E-02,-0.1269E-01,-0.1480E-01,-0.1624E-01,
     *-0.1710E-01,-0.1748E-01,-0.1758E-01,-0.1751E-01,-0.1733E-01,
     *-0.1705E-01,-0.1670E-01,-0.1632E-01,-0.1596E-01,-0.1563E-01,
     *-0.1535E-01,-0.1510E-01,-0.1489E-01,-0.1471E-01,-0.1456E-01,
     *-0.1442E-01,-0.1430E-01,-0.1420E-01,-0.1416E-01,-0.1414E-01,
     *-0.1415E-01,-0.1417E-01,-0.1422E-01,-0.1429E-01,-0.1439E-01,
     *-0.1452E-01,-0.1459E-01,-0.1467E-01,-0.1481E-01,-0.1495E-01,
     *-0.1511E-01,-0.1524E-01,-0.1535E-01,-0.1543E-01,-0.1545E-01,
     *-0.1541E-01,-0.1534E-01,-0.1528E-01,-0.1518E-01,-0.1506E-01,
     *-0.1491E-01,-0.1471E-01,-0.1436E-01,-0.1383E-01,-0.1309E-01,
     *-0.1211E-01,-0.1083E-01,-0.9279E-02,-0.7482E-02,-0.5331E-02,
     *-0.2583E-02, 0.9063E-03, 0.5089E-02, 0.9833E-02, 0.1506E-01,
     * 0.2070E-01, 0.2665E-01, 0.3257E-01, 0.3777E-01, 0.4143E-01,
     * 0.4292E-01, 0.4191E-01, 0.3801E-01, 0.3086E-01, 0.2082E-01,
     * 0.1004E-01, 0.2105E-02, 0.2511E-19 /
        DATA ((QHR(i,j),j=1,83),i=15,15)/
     *-0.3694E-21, 0.3515E-03, 0.1740E-02, 0.3816E-02, 0.6001E-02,
     * 0.7727E-02, 0.8609E-02, 0.8516E-02, 0.7521E-02, 0.5816E-02,
     * 0.3628E-02, 0.1173E-02,-0.1373E-02,-0.3888E-02,-0.6304E-02,
     *-0.8584E-02,-0.1070E-01,-0.1265E-01,-0.1444E-01,-0.1609E-01,
     *-0.1762E-01,-0.1906E-01,-0.2041E-01,-0.2168E-01,-0.2288E-01,
     *-0.2404E-01,-0.2518E-01,-0.2632E-01,-0.2746E-01,-0.2863E-01,
     *-0.2982E-01,-0.3103E-01,-0.3228E-01,-0.3357E-01,-0.3492E-01,
     *-0.3635E-01,-0.3789E-01,-0.3954E-01,-0.4131E-01,-0.4323E-01,
     *-0.4528E-01,-0.4635E-01,-0.4747E-01,-0.4980E-01,-0.5226E-01,
     *-0.5486E-01,-0.5760E-01,-0.6050E-01,-0.6359E-01,-0.6688E-01,
     *-0.7040E-01,-0.7414E-01,-0.7812E-01,-0.8230E-01,-0.8667E-01,
     *-0.9116E-01,-0.9575E-01,-0.1004E+00,-0.1050E+00,-0.1095E+00,
     *-0.1139E+00,-0.1180E+00,-0.1217E+00,-0.1247E+00,-0.1269E+00,
     *-0.1280E+00,-0.1279E+00,-0.1263E+00,-0.1231E+00,-0.1179E+00,
     *-0.1108E+00,-0.1018E+00,-0.9103E-01,-0.7876E-01,-0.6550E-01,
     *-0.5190E-01,-0.3872E-01,-0.2677E-01,-0.1670E-01,-0.8919E-02,
     *-0.3585E-02,-0.6734E-03,-0.5888E-20 /
        DATA ((QHR(i,j),j=1,83),i=16,16)/
     *-0.3902E-21, 0.2073E-03, 0.1033E-02, 0.2299E-02, 0.3696E-02,
     * 0.4902E-02, 0.5663E-02, 0.5830E-02, 0.5367E-02, 0.4316E-02,
     * 0.2770E-02, 0.8345E-03,-0.1384E-02,-0.3793E-02,-0.6318E-02,
     *-0.8901E-02,-0.1150E-01,-0.1409E-01,-0.1667E-01,-0.1921E-01,
     *-0.2172E-01,-0.2420E-01,-0.2666E-01,-0.2910E-01,-0.3154E-01,
     *-0.3399E-01,-0.3647E-01,-0.3897E-01,-0.4152E-01,-0.4411E-01,
     *-0.4676E-01,-0.4947E-01,-0.5226E-01,-0.5515E-01,-0.5815E-01,
     *-0.6129E-01,-0.6459E-01,-0.6805E-01,-0.7171E-01,-0.7558E-01,
     *-0.7966E-01,-0.8179E-01,-0.8398E-01,-0.8854E-01,-0.9335E-01,
     *-0.9842E-01,-0.1037E+00,-0.1093E+00,-0.1151E+00,-0.1212E+00,
     *-0.1275E+00,-0.1341E+00,-0.1408E+00,-0.1478E+00,-0.1549E+00,
     *-0.1621E+00,-0.1693E+00,-0.1763E+00,-0.1831E+00,-0.1895E+00,
     *-0.1954E+00,-0.2005E+00,-0.2047E+00,-0.2078E+00,-0.2094E+00,
     *-0.2093E+00,-0.2072E+00,-0.2029E+00,-0.1963E+00,-0.1871E+00,
     *-0.1753E+00,-0.1610E+00,-0.1444E+00,-0.1260E+00,-0.1062E+00,
     *-0.8580E-01,-0.6571E-01,-0.4688E-01,-0.3025E-01,-0.1670E-01,
     *-0.6904E-02,-0.1321E-02, 0.4135E-19 /
        DATA ((QHR(i,j),j=1,83),i=17,17)/
     *-0.5161E-22, 0.1652E-03, 0.8250E-03, 0.1839E-02, 0.2962E-02,
     * 0.3931E-02, 0.4530E-02, 0.4625E-02, 0.4163E-02, 0.3161E-02,
     * 0.1677E-02,-0.2090E-03,-0.2412E-02,-0.4854E-02,-0.7469E-02,
     *-0.1020E-01,-0.1301E-01,-0.1587E-01,-0.1875E-01,-0.2165E-01,
     *-0.2455E-01,-0.2745E-01,-0.3036E-01,-0.3327E-01,-0.3619E-01,
     *-0.3913E-01,-0.4211E-01,-0.4513E-01,-0.4821E-01,-0.5136E-01,
     *-0.5460E-01,-0.5792E-01,-0.6136E-01,-0.6492E-01,-0.6864E-01,
     *-0.7252E-01,-0.7659E-01,-0.8087E-01,-0.8539E-01,-0.9015E-01,
     *-0.9515E-01,-0.9775E-01,-0.1004E+00,-0.1059E+00,-0.1117E+00,
     *-0.1177E+00,-0.1239E+00,-0.1304E+00,-0.1372E+00,-0.1442E+00,
     *-0.1514E+00,-0.1589E+00,-0.1666E+00,-0.1743E+00,-0.1822E+00,
     *-0.1900E+00,-0.1977E+00,-0.2052E+00,-0.2123E+00,-0.2188E+00,
     *-0.2247E+00,-0.2296E+00,-0.2334E+00,-0.2358E+00,-0.2365E+00,
     *-0.2353E+00,-0.2319E+00,-0.2261E+00,-0.2178E+00,-0.2068E+00,
     *-0.1931E+00,-0.1768E+00,-0.1582E+00,-0.1377E+00,-0.1159E+00,
     *-0.9356E-01,-0.7167E-01,-0.5119E-01,-0.3310E-01,-0.1832E-01,
     *-0.7594E-02,-0.1456E-02,-0.1341E-20 /
        DATA ((QHR(i,j),j=1,83),i=18,18)/
     * 0.1407E-21, 0.7840E-04, 0.3879E-03, 0.8488E-03, 0.1322E-02,
     * 0.1656E-02, 0.1711E-02, 0.1388E-02, 0.6310E-03,-0.5766E-03,
     *-0.2220E-02,-0.4263E-02,-0.6662E-02,-0.9368E-02,-0.1233E-01,
     *-0.1552E-01,-0.1889E-01,-0.2241E-01,-0.2606E-01,-0.2983E-01,
     *-0.3370E-01,-0.3767E-01,-0.4174E-01,-0.4592E-01,-0.5020E-01,
     *-0.5459E-01,-0.5910E-01,-0.6375E-01,-0.6852E-01,-0.7344E-01,
     *-0.7852E-01,-0.8376E-01,-0.8918E-01,-0.9480E-01,-0.1006E+00,
     *-0.1066E+00,-0.1129E+00,-0.1194E+00,-0.1261E+00,-0.1330E+00,
     *-0.1402E+00,-0.1439E+00,-0.1477E+00,-0.1555E+00,-0.1635E+00,
     *-0.1718E+00,-0.1803E+00,-0.1891E+00,-0.1981E+00,-0.2072E+00,
     *-0.2164E+00,-0.2257E+00,-0.2350E+00,-0.2441E+00,-0.2531E+00,
     *-0.2617E+00,-0.2698E+00,-0.2774E+00,-0.2841E+00,-0.2898E+00,
     *-0.2944E+00,-0.2975E+00,-0.2989E+00,-0.2984E+00,-0.2958E+00,
     *-0.2909E+00,-0.2833E+00,-0.2731E+00,-0.2600E+00,-0.2442E+00,
     *-0.2256E+00,-0.2046E+00,-0.1814E+00,-0.1566E+00,-0.1310E+00,
     *-0.1052E+00,-0.8025E-01,-0.5716E-01,-0.3691E-01,-0.2041E-01,
     *-0.8460E-02,-0.1622E-02,-0.1894E-19 /
        DATA ((QHR(i,j),j=1,83),i=19,19)/
     * 0.2306E-21, 0.1529E-04, 0.6618E-04, 0.1025E-03, 0.4286E-04,
     *-0.2063E-03,-0.7331E-03,-0.1609E-02,-0.2880E-02,-0.4570E-02,
     *-0.6683E-02,-0.9205E-02,-0.1212E-01,-0.1538E-01,-0.1898E-01,
     *-0.2288E-01,-0.2706E-01,-0.3148E-01,-0.3613E-01,-0.4099E-01,
     *-0.4606E-01,-0.5130E-01,-0.5673E-01,-0.6234E-01,-0.6812E-01,
     *-0.7408E-01,-0.8021E-01,-0.8653E-01,-0.9304E-01,-0.9976E-01,
     *-0.1067E+00,-0.1138E+00,-0.1212E+00,-0.1288E+00,-0.1366E+00,
     *-0.1448E+00,-0.1531E+00,-0.1617E+00,-0.1706E+00,-0.1797E+00,
     *-0.1891E+00,-0.1939E+00,-0.1987E+00,-0.2086E+00,-0.2186E+00,
     *-0.2288E+00,-0.2391E+00,-0.2494E+00,-0.2598E+00,-0.2702E+00,
     *-0.2805E+00,-0.2906E+00,-0.3004E+00,-0.3097E+00,-0.3186E+00,
     *-0.3268E+00,-0.3341E+00,-0.3404E+00,-0.3456E+00,-0.3493E+00,
     *-0.3514E+00,-0.3517E+00,-0.3500E+00,-0.3460E+00,-0.3395E+00,
     *-0.3305E+00,-0.3187E+00,-0.3041E+00,-0.2867E+00,-0.2666E+00,
     *-0.2440E+00,-0.2192E+00,-0.1928E+00,-0.1651E+00,-0.1371E+00,
     *-0.1094E+00,-0.8302E-01,-0.5887E-01,-0.3788E-01,-0.2090E-01,
     *-0.8646E-02,-0.1656E-02, 0.1482E-19 /
        DATA ((QHR(i,j),j=1,83),i=20,20)/
     *-0.1974E-21,-0.1772E-03,-0.9349E-03,-0.2303E-02,-0.4288E-02,
     *-0.6899E-02,-0.1014E-01,-0.1403E-01,-0.1856E-01,-0.2375E-01,
     *-0.2957E-01,-0.3605E-01,-0.4316E-01,-0.5089E-01,-0.5925E-01,
     *-0.6820E-01,-0.7773E-01,-0.8783E-01,-0.9849E-01,-0.1097E+00,
     *-0.1214E+00,-0.1335E+00,-0.1462E+00,-0.1592E+00,-0.1727E+00,
     *-0.1866E+00,-0.2009E+00,-0.2154E+00,-0.2303E+00,-0.2455E+00,
     *-0.2608E+00,-0.2764E+00,-0.2921E+00,-0.3079E+00,-0.3238E+00,
     *-0.3397E+00,-0.3555E+00,-0.3713E+00,-0.3868E+00,-0.4021E+00,
     *-0.4170E+00,-0.4243E+00,-0.4315E+00,-0.4456E+00,-0.4590E+00,
     *-0.4717E+00,-0.4835E+00,-0.4945E+00,-0.5044E+00,-0.5131E+00,
     *-0.5205E+00,-0.5264E+00,-0.5308E+00,-0.5335E+00,-0.5344E+00,
     *-0.5333E+00,-0.5302E+00,-0.5249E+00,-0.5173E+00,-0.5073E+00,
     *-0.4949E+00,-0.4801E+00,-0.4629E+00,-0.4432E+00,-0.4213E+00,
     *-0.3971E+00,-0.3709E+00,-0.3429E+00,-0.3134E+00,-0.2827E+00,
     *-0.2512E+00,-0.2193E+00,-0.1877E+00,-0.1568E+00,-0.1271E+00,
     *-0.9931E-01,-0.7396E-01,-0.5161E-01,-0.3277E-01,-0.1789E-01,
     *-0.7351E-02,-0.1403E-02,-0.2286E-20 /
c************** MIE (phase fun uh) ***************
        DATA ((UHR(i,j),j=1,83),i= 1, 1)/
     *-0.2975E+00,-0.2668E+00,-0.1549E+00,-0.1893E-01, 0.8761E-01,
     * 0.1490E+00, 0.1690E+00, 0.1621E+00, 0.1425E+00, 0.1202E+00,
     * 0.1006E+00, 0.8386E-01, 0.7080E-01, 0.5982E-01, 0.5096E-01,
     * 0.4534E-01, 0.4095E-01, 0.3683E-01, 0.3467E-01, 0.3363E-01,
     * 0.3287E-01, 0.3248E-01, 0.3227E-01, 0.3202E-01, 0.3221E-01,
     * 0.3315E-01, 0.3341E-01, 0.3416E-01, 0.3596E-01, 0.3750E-01,
     * 0.3891E-01, 0.4129E-01, 0.4417E-01, 0.4684E-01, 0.5013E-01,
     * 0.5405E-01, 0.5841E-01, 0.6347E-01, 0.6904E-01, 0.7469E-01,
     * 0.8139E-01, 0.8556E-01, 0.9018E-01, 0.9939E-01, 0.1083E+00,
     * 0.1199E+00, 0.1340E+00, 0.1482E+00, 0.1645E+00, 0.1852E+00,
     * 0.2084E+00, 0.2329E+00, 0.2629E+00, 0.2995E+00, 0.3403E+00,
     * 0.3861E+00, 0.4398E+00, 0.5032E+00, 0.5757E+00, 0.6589E+00,
     * 0.7580E+00, 0.8782E+00, 0.1017E+01, 0.1175E+01, 0.1362E+01,
     * 0.1588E+01, 0.1853E+01, 0.2167E+01, 0.2547E+01, 0.3006E+01,
     * 0.3574E+01, 0.4289E+01, 0.5202E+01, 0.6408E+01, 0.8085E+01,
     * 0.1050E+02, 0.1408E+02, 0.1947E+02, 0.2755E+02, 0.3918E+02,
     * 0.5406E+02, 0.6807E+02, 0.7250E+02 /
        DATA ((UHR(i,j),j=1,83),i= 2, 2)/
     *-0.2458E+00,-0.2241E+00,-0.1447E+00,-0.4556E-01, 0.3753E-01,
     * 0.9297E-01, 0.1209E+00, 0.1259E+00, 0.1161E+00, 0.9999E-01,
     * 0.8441E-01, 0.7229E-01, 0.6217E-01, 0.5317E-01, 0.4587E-01,
     * 0.4108E-01, 0.3883E-01, 0.3724E-01, 0.3524E-01, 0.3361E-01,
     * 0.3266E-01, 0.3251E-01, 0.3315E-01, 0.3373E-01, 0.3388E-01,
     * 0.3429E-01, 0.3542E-01, 0.3680E-01, 0.3789E-01, 0.3897E-01,
     * 0.4054E-01, 0.4285E-01, 0.4571E-01, 0.4849E-01, 0.5137E-01,
     * 0.5498E-01, 0.5913E-01, 0.6371E-01, 0.6905E-01, 0.7498E-01,
     * 0.8126E-01, 0.8467E-01, 0.8842E-01, 0.9722E-01, 0.1073E+00,
     * 0.1181E+00, 0.1307E+00, 0.1455E+00, 0.1620E+00, 0.1811E+00,
     * 0.2039E+00, 0.2296E+00, 0.2581E+00, 0.2912E+00, 0.3305E+00,
     * 0.3762E+00, 0.4288E+00, 0.4909E+00, 0.5646E+00, 0.6497E+00,
     * 0.7480E+00, 0.8653E+00, 0.1006E+01, 0.1170E+01, 0.1364E+01,
     * 0.1597E+01, 0.1882E+01, 0.2227E+01, 0.2643E+01, 0.3153E+01,
     * 0.3794E+01, 0.4609E+01, 0.5661E+01, 0.7047E+01, 0.8911E+01,
     * 0.1148E+02, 0.1508E+02, 0.2015E+02, 0.2716E+02, 0.3633E+02,
     * 0.4692E+02, 0.5589E+02, 0.5854E+02 /
        DATA ((UHR(i,j),j=1,83),i= 3, 3)/
     *-0.2347E+00,-0.2152E+00,-0.1427E+00,-0.4866E-01, 0.3153E-01,
     * 0.8391E-01, 0.1109E+00, 0.1176E+00, 0.1105E+00, 0.9650E-01,
     * 0.8184E-01, 0.6955E-01, 0.5952E-01, 0.5163E-01, 0.4572E-01,
     * 0.4123E-01, 0.3829E-01, 0.3675E-01, 0.3552E-01, 0.3436E-01,
     * 0.3347E-01, 0.3299E-01, 0.3325E-01, 0.3383E-01, 0.3404E-01,
     * 0.3451E-01, 0.3568E-01, 0.3694E-01, 0.3806E-01, 0.3948E-01,
     * 0.4132E-01, 0.4339E-01, 0.4580E-01, 0.4869E-01, 0.5183E-01,
     * 0.5537E-01, 0.5952E-01, 0.6400E-01, 0.6899E-01, 0.7493E-01,
     * 0.8148E-01, 0.8488E-01, 0.8848E-01, 0.9678E-01, 0.1068E+00,
     * 0.1180E+00, 0.1305E+00, 0.1450E+00, 0.1618E+00, 0.1805E+00,
     * 0.2023E+00, 0.2281E+00, 0.2569E+00, 0.2894E+00, 0.3283E+00,
     * 0.3744E+00, 0.4271E+00, 0.4887E+00, 0.5619E+00, 0.6477E+00,
     * 0.7467E+00, 0.8629E+00, 0.1002E+01, 0.1169E+01, 0.1368E+01,
     * 0.1604E+01, 0.1890E+01, 0.2240E+01, 0.2667E+01, 0.3191E+01,
     * 0.3844E+01, 0.4679E+01, 0.5760E+01, 0.7181E+01, 0.9079E+01,
     * 0.1167E+02, 0.1525E+02, 0.2022E+02, 0.2700E+02, 0.3573E+02,
     * 0.4558E+02, 0.5377E+02, 0.5616E+02 /
        DATA ((UHR(i,j),j=1,83),i= 4, 4)/
     *-0.2072E+00,-0.1914E+00,-0.1329E+00,-0.5698E-01, 0.1086E-01,
     * 0.5998E-01, 0.8847E-01, 0.9828E-01, 0.9476E-01, 0.8454E-01,
     * 0.7332E-01, 0.6387E-01, 0.5578E-01, 0.4867E-01, 0.4299E-01,
     * 0.3920E-01, 0.3724E-01, 0.3592E-01, 0.3453E-01, 0.3352E-01,
     * 0.3301E-01, 0.3301E-01, 0.3357E-01, 0.3408E-01, 0.3426E-01,
     * 0.3476E-01, 0.3596E-01, 0.3742E-01, 0.3875E-01, 0.4012E-01,
     * 0.4176E-01, 0.4385E-01, 0.4635E-01, 0.4896E-01, 0.5179E-01,
     * 0.5527E-01, 0.5936E-01, 0.6393E-01, 0.6915E-01, 0.7503E-01,
     * 0.8140E-01, 0.8483E-01, 0.8854E-01, 0.9708E-01, 0.1069E+00,
     * 0.1177E+00, 0.1300E+00, 0.1444E+00, 0.1605E+00, 0.1788E+00,
     * 0.2005E+00, 0.2254E+00, 0.2536E+00, 0.2864E+00, 0.3254E+00,
     * 0.3709E+00, 0.4233E+00, 0.4847E+00, 0.5569E+00, 0.6410E+00,
     * 0.7396E+00, 0.8577E+00, 0.9997E+00, 0.1169E+01, 0.1371E+01,
     * 0.1614E+01, 0.1912E+01, 0.2276E+01, 0.2722E+01, 0.3274E+01,
     * 0.3972E+01, 0.4864E+01, 0.6012E+01, 0.7502E+01, 0.9470E+01,
     * 0.1210E+02, 0.1565E+02, 0.2040E+02, 0.2659E+02, 0.3417E+02,
     * 0.4234E+02, 0.4885E+02, 0.5070E+02 /
        DATA ((UHR(i,j),j=1,83),i= 5, 5)/
     *-0.1879E+00,-0.1748E+00,-0.1262E+00,-0.6112E-01,-0.6590E-04,
     * 0.4540E-01, 0.7199E-01, 0.8237E-01, 0.8222E-01, 0.7657E-01,
     * 0.6805E-01, 0.5898E-01, 0.5140E-01, 0.4579E-01, 0.4188E-01,
     * 0.3887E-01, 0.3623E-01, 0.3462E-01, 0.3409E-01, 0.3395E-01,
     * 0.3388E-01, 0.3375E-01, 0.3376E-01, 0.3412E-01, 0.3465E-01,
     * 0.3528E-01, 0.3607E-01, 0.3709E-01, 0.3849E-01, 0.4035E-01,
     * 0.4245E-01, 0.4439E-01, 0.4649E-01, 0.4928E-01, 0.5249E-01,
     * 0.5587E-01, 0.5974E-01, 0.6419E-01, 0.6921E-01, 0.7508E-01,
     * 0.8180E-01, 0.8536E-01, 0.8906E-01, 0.9724E-01, 0.1069E+00,
     * 0.1176E+00, 0.1296E+00, 0.1436E+00, 0.1597E+00, 0.1778E+00,
     * 0.1987E+00, 0.2236E+00, 0.2526E+00, 0.2855E+00, 0.3236E+00,
     * 0.3687E+00, 0.4210E+00, 0.4812E+00, 0.5526E+00, 0.6380E+00,
     * 0.7385E+00, 0.8571E+00, 0.9993E+00, 0.1171E+01, 0.1379E+01,
     * 0.1630E+01, 0.1933E+01, 0.2306E+01, 0.2771E+01, 0.3351E+01,
     * 0.4081E+01, 0.5008E+01, 0.6196E+01, 0.7737E+01, 0.9756E+01,
     * 0.1241E+02, 0.1589E+02, 0.2041E+02, 0.2614E+02, 0.3296E+02,
     * 0.4009E+02, 0.4560E+02, 0.4714E+02 /
        DATA ((UHR(i,j),j=1,83),i= 6, 6)/
     *-0.1755E+00,-0.1643E+00,-0.1222E+00,-0.6482E-01,-0.9411E-02,
     * 0.3384E-01, 0.6082E-01, 0.7282E-01, 0.7400E-01, 0.6903E-01,
     * 0.6219E-01, 0.5552E-01, 0.4945E-01, 0.4406E-01, 0.3959E-01,
     * 0.3676E-01, 0.3534E-01, 0.3409E-01, 0.3301E-01, 0.3255E-01,
     * 0.3250E-01, 0.3281E-01, 0.3336E-01, 0.3393E-01, 0.3451E-01,
     * 0.3520E-01, 0.3611E-01, 0.3734E-01, 0.3875E-01, 0.4016E-01,
     * 0.4187E-01, 0.4421E-01, 0.4679E-01, 0.4939E-01, 0.5231E-01,
     * 0.5573E-01, 0.5966E-01, 0.6418E-01, 0.6938E-01, 0.7512E-01,
     * 0.8147E-01, 0.8505E-01, 0.8894E-01, 0.9748E-01, 0.1067E+00,
     * 0.1172E+00, 0.1294E+00, 0.1432E+00, 0.1588E+00, 0.1774E+00,
     * 0.1988E+00, 0.2231E+00, 0.2511E+00, 0.2842E+00, 0.3227E+00,
     * 0.3670E+00, 0.4185E+00, 0.4795E+00, 0.5512E+00, 0.6354E+00,
     * 0.7359E+00, 0.8567E+00, 0.1002E+01, 0.1175E+01, 0.1383E+01,
     * 0.1637E+01, 0.1949E+01, 0.2332E+01, 0.2808E+01, 0.3403E+01,
     * 0.4155E+01, 0.5107E+01, 0.6326E+01, 0.7895E+01, 0.9932E+01,
     * 0.1258E+02, 0.1603E+02, 0.2043E+02, 0.2587E+02, 0.3218E+02,
     * 0.3860E+02, 0.4345E+02, 0.4478E+02 /
        DATA ((UHR(i,j),j=1,83),i= 7, 7)/
     *-0.1638E+00,-0.1546E+00,-0.1193E+00,-0.7024E-01,-0.2173E-01,
     * 0.1788E-01, 0.4480E-01, 0.5866E-01, 0.6220E-01, 0.5955E-01,
     * 0.5464E-01, 0.4967E-01, 0.4499E-01, 0.4066E-01, 0.3709E-01,
     * 0.3475E-01, 0.3360E-01, 0.3288E-01, 0.3214E-01, 0.3166E-01,
     * 0.3160E-01, 0.3200E-01, 0.3272E-01, 0.3344E-01, 0.3408E-01,
     * 0.3483E-01, 0.3588E-01, 0.3718E-01, 0.3852E-01, 0.3995E-01,
     * 0.4174E-01, 0.4400E-01, 0.4662E-01, 0.4938E-01, 0.5239E-01,
     * 0.5583E-01, 0.5974E-01, 0.6417E-01, 0.6925E-01, 0.7490E-01,
     * 0.8112E-01, 0.8453E-01, 0.8822E-01, 0.9652E-01, 0.1059E+00,
     * 0.1164E+00, 0.1285E+00, 0.1424E+00, 0.1582E+00, 0.1766E+00,
     * 0.1980E+00, 0.2224E+00, 0.2503E+00, 0.2827E+00, 0.3207E+00,
     * 0.3649E+00, 0.4166E+00, 0.4776E+00, 0.5499E+00, 0.6353E+00,
     * 0.7367E+00, 0.8588E+00, 0.1006E+01, 0.1182E+01, 0.1395E+01,
     * 0.1655E+01, 0.1976E+01, 0.2373E+01, 0.2866E+01, 0.3483E+01,
     * 0.4260E+01, 0.5243E+01, 0.6496E+01, 0.8100E+01, 0.1016E+02,
     * 0.1279E+02, 0.1615E+02, 0.2034E+02, 0.2541E+02, 0.3111E+02,
     * 0.3673E+02, 0.4085E+02, 0.4196E+02 /
        DATA ((UHR(i,j),j=1,83),i= 8, 8)/
     *-0.1489E+00,-0.1418E+00,-0.1143E+00,-0.7374E-01,-0.3142E-01,
     * 0.3980E-02, 0.2856E-01, 0.4264E-01, 0.4865E-01, 0.4937E-01,
     * 0.4702E-01, 0.4327E-01, 0.3953E-01, 0.3665E-01, 0.3458E-01,
     * 0.3295E-01, 0.3169E-01, 0.3099E-01, 0.3081E-01, 0.3096E-01,
     * 0.3132E-01, 0.3176E-01, 0.3214E-01, 0.3268E-01, 0.3362E-01,
     * 0.3472E-01, 0.3576E-01, 0.3689E-01, 0.3828E-01, 0.3996E-01,
     * 0.4184E-01, 0.4396E-01, 0.4639E-01, 0.4919E-01, 0.5242E-01,
     * 0.5607E-01, 0.6009E-01, 0.6449E-01, 0.6936E-01, 0.7485E-01,
     * 0.8116E-01, 0.8465E-01, 0.8836E-01, 0.9644E-01, 0.1056E+00,
     * 0.1162E+00, 0.1284E+00, 0.1423E+00, 0.1583E+00, 0.1767E+00,
     * 0.1976E+00, 0.2216E+00, 0.2497E+00, 0.2824E+00, 0.3202E+00,
     * 0.3643E+00, 0.4165E+00, 0.4782E+00, 0.5508E+00, 0.6374E+00,
     * 0.7413E+00, 0.8654E+00, 0.1014E+01, 0.1194E+01, 0.1414E+01,
     * 0.1684E+01, 0.2016E+01, 0.2428E+01, 0.2940E+01, 0.3581E+01,
     * 0.4386E+01, 0.5401E+01, 0.6688E+01, 0.8320E+01, 0.1039E+02,
     * 0.1299E+02, 0.1622E+02, 0.2016E+02, 0.2478E+02, 0.2983E+02,
     * 0.3464E+02, 0.3807E+02, 0.3899E+02 /
        DATA ((UHR(i,j),j=1,83),i= 9, 9)/
     *-0.1415E+00,-0.1356E+00,-0.1128E+00,-0.7940E-01,-0.4385E-01,
     *-0.1264E-01, 0.1078E-01, 0.2581E-01, 0.3391E-01, 0.3702E-01,
     * 0.3695E-01, 0.3532E-01, 0.3338E-01, 0.3176E-01, 0.3059E-01,
     * 0.2970E-01, 0.2902E-01, 0.2881E-01, 0.2907E-01, 0.2951E-01,
     * 0.2992E-01, 0.3035E-01, 0.3096E-01, 0.3179E-01, 0.3274E-01,
     * 0.3380E-01, 0.3498E-01, 0.3632E-01, 0.3788E-01, 0.3968E-01,
     * 0.4165E-01, 0.4372E-01, 0.4606E-01, 0.4885E-01, 0.5201E-01,
     * 0.5550E-01, 0.5942E-01, 0.6385E-01, 0.6886E-01, 0.7458E-01,
     * 0.8105E-01, 0.8454E-01, 0.8823E-01, 0.9634E-01, 0.1057E+00,
     * 0.1163E+00, 0.1284E+00, 0.1422E+00, 0.1581E+00, 0.1761E+00,
     * 0.1969E+00, 0.2213E+00, 0.2496E+00, 0.2822E+00, 0.3204E+00,
     * 0.3655E+00, 0.4184E+00, 0.4808E+00, 0.5550E+00, 0.6435E+00,
     * 0.7489E+00, 0.8752E+00, 0.1028E+01, 0.1214E+01, 0.1443E+01,
     * 0.1723E+01, 0.2068E+01, 0.2496E+01, 0.3027E+01, 0.3692E+01,
     * 0.4524E+01, 0.5570E+01, 0.6884E+01, 0.8530E+01, 0.1058E+02,
     * 0.1312E+02, 0.1621E+02, 0.1988E+02, 0.2405E+02, 0.2847E+02,
     * 0.3256E+02, 0.3540E+02, 0.3614E+02 /
        DATA ((UHR(i,j),j=1,83),i=10,10)/
     *-0.1337E+00,-0.1291E+00,-0.1110E+00,-0.8412E-01,-0.5464E-01,
     *-0.2736E-01,-0.5128E-02, 0.1067E-01, 0.2020E-01, 0.2497E-01,
     * 0.2688E-01, 0.2740E-01, 0.2725E-01, 0.2679E-01, 0.2633E-01,
     * 0.2608E-01, 0.2615E-01, 0.2647E-01, 0.2689E-01, 0.2739E-01,
     * 0.2801E-01, 0.2876E-01, 0.2966E-01, 0.3063E-01, 0.3161E-01,
     * 0.3272E-01, 0.3407E-01, 0.3558E-01, 0.3721E-01, 0.3899E-01,
     * 0.4098E-01, 0.4322E-01, 0.4572E-01, 0.4850E-01, 0.5159E-01,
     * 0.5508E-01, 0.5907E-01, 0.6360E-01, 0.6873E-01, 0.7452E-01,
     * 0.8102E-01, 0.8456E-01, 0.8833E-01, 0.9665E-01, 0.1061E+00,
     * 0.1168E+00, 0.1288E+00, 0.1426E+00, 0.1584E+00, 0.1766E+00,
     * 0.1977E+00, 0.2223E+00, 0.2507E+00, 0.2838E+00, 0.3228E+00,
     * 0.3686E+00, 0.4225E+00, 0.4862E+00, 0.5619E+00, 0.6521E+00,
     * 0.7601E+00, 0.8905E+00, 0.1049E+01, 0.1243E+01, 0.1479E+01,
     * 0.1770E+01, 0.2127E+01, 0.2571E+01, 0.3121E+01, 0.3808E+01,
     * 0.4664E+01, 0.5733E+01, 0.7062E+01, 0.8707E+01, 0.1073E+02,
     * 0.1319E+02, 0.1612E+02, 0.1952E+02, 0.2328E+02, 0.2714E+02,
     * 0.3059E+02, 0.3292E+02, 0.3352E+02 /
        DATA ((UHR(i,j),j=1,83),i=11,11)/
     *-0.1284E+00,-0.1246E+00,-0.1098E+00,-0.8708E-01,-0.6128E-01,
     *-0.3663E-01,-0.1602E-01,-0.6693E-03, 0.9705E-02, 0.1606E-01,
     * 0.1949E-01, 0.2112E-01, 0.2193E-01, 0.2246E-01, 0.2290E-01,
     * 0.2328E-01, 0.2365E-01, 0.2419E-01, 0.2493E-01, 0.2577E-01,
     * 0.2666E-01, 0.2756E-01, 0.2852E-01, 0.2956E-01, 0.3068E-01,
     * 0.3189E-01, 0.3322E-01, 0.3473E-01, 0.3646E-01, 0.3840E-01,
     * 0.4053E-01, 0.4283E-01, 0.4539E-01, 0.4833E-01, 0.5162E-01,
     * 0.5523E-01, 0.5925E-01, 0.6377E-01, 0.6888E-01, 0.7468E-01,
     * 0.8123E-01, 0.8480E-01, 0.8857E-01, 0.9687E-01, 0.1063E+00,
     * 0.1171E+00, 0.1294E+00, 0.1435E+00, 0.1596E+00, 0.1781E+00,
     * 0.1994E+00, 0.2243E+00, 0.2533E+00, 0.2871E+00, 0.3266E+00,
     * 0.3731E+00, 0.4279E+00, 0.4927E+00, 0.5699E+00, 0.6625E+00,
     * 0.7738E+00, 0.9083E+00, 0.1072E+01, 0.1271E+01, 0.1515E+01,
     * 0.1813E+01, 0.2181E+01, 0.2636E+01, 0.3202E+01, 0.3904E+01,
     * 0.4774E+01, 0.5852E+01, 0.7183E+01, 0.8817E+01, 0.1081E+02,
     * 0.1319E+02, 0.1598E+02, 0.1916E+02, 0.2262E+02, 0.2609E+02,
     * 0.2913E+02, 0.3115E+02, 0.3167E+02 /
        DATA ((UHR(i,j),j=1,83),i=12,12)/
     *-0.1253E+00,-0.1221E+00,-0.1093E+00,-0.8905E-01,-0.6548E-01,
     *-0.4236E-01,-0.2251E-01,-0.7273E-02, 0.3367E-02, 0.1027E-01,
     * 0.1454E-01, 0.1709E-01, 0.1863E-01, 0.1961E-01, 0.2037E-01,
     * 0.2115E-01, 0.2194E-01, 0.2271E-01, 0.2351E-01, 0.2441E-01,
     * 0.2544E-01, 0.2654E-01, 0.2766E-01, 0.2880E-01, 0.3001E-01,
     * 0.3133E-01, 0.3275E-01, 0.3432E-01, 0.3607E-01, 0.3801E-01,
     * 0.4016E-01, 0.4258E-01, 0.4526E-01, 0.4821E-01, 0.5150E-01,
     * 0.5519E-01, 0.5931E-01, 0.6391E-01, 0.6905E-01, 0.7481E-01,
     * 0.8135E-01, 0.8494E-01, 0.8878E-01, 0.9717E-01, 0.1067E+00,
     * 0.1175E+00, 0.1299E+00, 0.1441E+00, 0.1605E+00, 0.1793E+00,
     * 0.2010E+00, 0.2261E+00, 0.2554E+00, 0.2896E+00, 0.3297E+00,
     * 0.3767E+00, 0.4321E+00, 0.4979E+00, 0.5763E+00, 0.6704E+00,
     * 0.7839E+00, 0.9213E+00, 0.1088E+01, 0.1291E+01, 0.1538E+01,
     * 0.1842E+01, 0.2217E+01, 0.2680E+01, 0.3253E+01, 0.3963E+01,
     * 0.4840E+01, 0.5923E+01, 0.7253E+01, 0.8876E+01, 0.1084E+02,
     * 0.1317E+02, 0.1588E+02, 0.1893E+02, 0.2220E+02, 0.2543E+02,
     * 0.2824E+02, 0.3007E+02, 0.3054E+02 /
        DATA ((UHR(i,j),j=1,83),i=13,13)/
     *-0.1225E+00,-0.1200E+00,-0.1102E+00,-0.9449E-01,-0.7561E-01,
     *-0.5627E-01,-0.3862E-01,-0.2391E-01,-0.1248E-01,-0.4072E-02,
     * 0.1893E-02, 0.6110E-02, 0.9222E-02, 0.1167E-01, 0.1368E-01,
     * 0.1539E-01, 0.1690E-01, 0.1836E-01, 0.1980E-01, 0.2119E-01,
     * 0.2249E-01, 0.2380E-01, 0.2518E-01, 0.2665E-01, 0.2817E-01,
     * 0.2972E-01, 0.3133E-01, 0.3304E-01, 0.3493E-01, 0.3701E-01,
     * 0.3930E-01, 0.4180E-01, 0.4458E-01, 0.4769E-01, 0.5114E-01,
     * 0.5494E-01, 0.5917E-01, 0.6391E-01, 0.6922E-01, 0.7522E-01,
     * 0.8197E-01, 0.8565E-01, 0.8956E-01, 0.9817E-01, 0.1080E+00,
     * 0.1192E+00, 0.1320E+00, 0.1467E+00, 0.1637E+00, 0.1831E+00,
     * 0.2057E+00, 0.2319E+00, 0.2624E+00, 0.2980E+00, 0.3396E+00,
     * 0.3887E+00, 0.4469E+00, 0.5162E+00, 0.5991E+00, 0.6986E+00,
     * 0.8181E+00, 0.9622E+00, 0.1137E+01, 0.1349E+01, 0.1609E+01,
     * 0.1928E+01, 0.2319E+01, 0.2799E+01, 0.3390E+01, 0.4114E+01,
     * 0.5002E+01, 0.6085E+01, 0.7399E+01, 0.8978E+01, 0.1085E+02,
     * 0.1303E+02, 0.1551E+02, 0.1823E+02, 0.2106E+02, 0.2379E+02,
     * 0.2609E+02, 0.2756E+02, 0.2793E+02 /
        DATA ((UHR(i,j),j=1,83),i=14,14)/
     *-0.1200E+00,-0.1184E+00,-0.1117E+00,-0.1007E+00,-0.8670E-01,
     *-0.7146E-01,-0.5647E-01,-0.4287E-01,-0.3132E-01,-0.2191E-01,
     *-0.1438E-01,-0.8345E-02,-0.3461E-02, 0.5524E-03, 0.3912E-02,
     * 0.6786E-02, 0.9315E-02, 0.1161E-01, 0.1374E-01, 0.1573E-01,
     * 0.1761E-01, 0.1940E-01, 0.2116E-01, 0.2290E-01, 0.2468E-01,
     * 0.2653E-01, 0.2850E-01, 0.3059E-01, 0.3280E-01, 0.3514E-01,
     * 0.3764E-01, 0.4035E-01, 0.4334E-01, 0.4666E-01, 0.5035E-01,
     * 0.5445E-01, 0.5902E-01, 0.6414E-01, 0.6987E-01, 0.7631E-01,
     * 0.8355E-01, 0.8752E-01, 0.9173E-01, 0.1010E+00, 0.1116E+00,
     * 0.1236E+00, 0.1373E+00, 0.1530E+00, 0.1710E+00, 0.1918E+00,
     * 0.2159E+00, 0.2439E+00, 0.2767E+00, 0.3151E+00, 0.3604E+00,
     * 0.4140E+00, 0.4774E+00, 0.5526E+00, 0.6423E+00, 0.7496E+00,
     * 0.8784E+00, 0.1034E+01, 0.1222E+01, 0.1450E+01, 0.1727E+01,
     * 0.2064E+01, 0.2473E+01, 0.2971E+01, 0.3576E+01, 0.4310E+01,
     * 0.5196E+01, 0.6258E+01, 0.7522E+01, 0.9008E+01, 0.1073E+02,
     * 0.1268E+02, 0.1484E+02, 0.1714E+02, 0.1945E+02, 0.2160E+02,
     * 0.2335E+02, 0.2444E+02, 0.2471E+02 /
        DATA ((UHR(i,j),j=1,83),i=15,15)/
     *-0.1280E+00,-0.1274E+00,-0.1248E+00,-0.1202E+00,-0.1139E+00,
     *-0.1061E+00,-0.9731E-01,-0.8809E-01,-0.7884E-01,-0.6988E-01,
     *-0.6141E-01,-0.5355E-01,-0.4633E-01,-0.3973E-01,-0.3370E-01,
     *-0.2821E-01,-0.2319E-01,-0.1858E-01,-0.1432E-01,-0.1035E-01,
     *-0.6610E-02,-0.3050E-02, 0.3643E-03, 0.3671E-02, 0.6915E-02,
     * 0.1015E-01, 0.1342E-01, 0.1680E-01, 0.2031E-01, 0.2401E-01,
     * 0.2791E-01, 0.3206E-01, 0.3651E-01, 0.4133E-01, 0.4660E-01,
     * 0.5241E-01, 0.5887E-01, 0.6608E-01, 0.7416E-01, 0.8324E-01,
     * 0.9346E-01, 0.9906E-01, 0.1050E+00, 0.1181E+00, 0.1329E+00,
     * 0.1497E+00, 0.1689E+00, 0.1910E+00, 0.2164E+00, 0.2457E+00,
     * 0.2796E+00, 0.3190E+00, 0.3648E+00, 0.4182E+00, 0.4804E+00,
     * 0.5530E+00, 0.6381E+00, 0.7378E+00, 0.8549E+00, 0.9926E+00,
     * 0.1155E+01, 0.1346E+01, 0.1571E+01, 0.1835E+01, 0.2147E+01,
     * 0.2512E+01, 0.2940E+01, 0.3439E+01, 0.4020E+01, 0.4691E+01,
     * 0.5460E+01, 0.6334E+01, 0.7316E+01, 0.8403E+01, 0.9584E+01,
     * 0.1084E+02, 0.1213E+02, 0.1340E+02, 0.1460E+02, 0.1563E+02,
     * 0.1642E+02, 0.1689E+02, 0.1700E+02 /
        DATA ((UHR(i,j),j=1,83),i=16,16)/
     *-0.1420E+00,-0.1416E+00,-0.1399E+00,-0.1368E+00,-0.1325E+00,
     *-0.1270E+00,-0.1207E+00,-0.1137E+00,-0.1062E+00,-0.9867E-01,
     *-0.9113E-01,-0.8376E-01,-0.7664E-01,-0.6985E-01,-0.6339E-01,
     *-0.5728E-01,-0.5149E-01,-0.4602E-01,-0.4082E-01,-0.3587E-01,
     *-0.3112E-01,-0.2653E-01,-0.2207E-01,-0.1769E-01,-0.1333E-01,
     *-0.8958E-02,-0.4508E-02, 0.5975E-04, 0.4790E-02, 0.9731E-02,
     * 0.1494E-01, 0.2049E-01, 0.2646E-01, 0.3294E-01, 0.4003E-01,
     * 0.4783E-01, 0.5646E-01, 0.6605E-01, 0.7674E-01, 0.8870E-01,
     * 0.1021E+00, 0.1095E+00, 0.1173E+00, 0.1344E+00, 0.1537E+00,
     * 0.1757E+00, 0.2007E+00, 0.2293E+00, 0.2619E+00, 0.2992E+00,
     * 0.3420E+00, 0.3911E+00, 0.4476E+00, 0.5127E+00, 0.5877E+00,
     * 0.6742E+00, 0.7740E+00, 0.8892E+00, 0.1022E+01, 0.1175E+01,
     * 0.1352E+01, 0.1557E+01, 0.1792E+01, 0.2063E+01, 0.2373E+01,
     * 0.2729E+01, 0.3134E+01, 0.3594E+01, 0.4114E+01, 0.4697E+01,
     * 0.5346E+01, 0.6060E+01, 0.6837E+01, 0.7669E+01, 0.8544E+01,
     * 0.9442E+01, 0.1034E+02, 0.1119E+02, 0.1197E+02, 0.1262E+02,
     * 0.1311E+02, 0.1340E+02, 0.1346E+02 /
        DATA ((UHR(i,j),j=1,83),i=17,17)/
     *-0.1485E+00,-0.1482E+00,-0.1467E+00,-0.1440E+00,-0.1402E+00,
     *-0.1353E+00,-0.1296E+00,-0.1232E+00,-0.1164E+00,-0.1093E+00,
     *-0.1022E+00,-0.9513E-01,-0.8821E-01,-0.8152E-01,-0.7508E-01,
     *-0.6891E-01,-0.6302E-01,-0.5738E-01,-0.5197E-01,-0.4678E-01,
     *-0.4175E-01,-0.3685E-01,-0.3205E-01,-0.2731E-01,-0.2258E-01,
     *-0.1781E-01,-0.1296E-01,-0.7946E-02,-0.2730E-02, 0.2748E-02,
     * 0.8549E-02, 0.1474E-01, 0.2139E-01, 0.2859E-01, 0.3646E-01,
     * 0.4510E-01, 0.5467E-01, 0.6530E-01, 0.7716E-01, 0.9044E-01,
     * 0.1053E+00, 0.1135E+00, 0.1221E+00, 0.1409E+00, 0.1622E+00,
     * 0.1863E+00, 0.2136E+00, 0.2446E+00, 0.2799E+00, 0.3202E+00,
     * 0.3663E+00, 0.4190E+00, 0.4793E+00, 0.5485E+00, 0.6277E+00,
     * 0.7186E+00, 0.8229E+00, 0.9424E+00, 0.1080E+01, 0.1237E+01,
     * 0.1417E+01, 0.1623E+01, 0.1859E+01, 0.2128E+01, 0.2435E+01,
     * 0.2782E+01, 0.3175E+01, 0.3616E+01, 0.4110E+01, 0.4659E+01,
     * 0.5264E+01, 0.5923E+01, 0.6632E+01, 0.7384E+01, 0.8166E+01,
     * 0.8960E+01, 0.9743E+01, 0.1049E+02, 0.1115E+02, 0.1171E+02,
     * 0.1213E+02, 0.1237E+02, 0.1242E+02 /
        DATA ((UHR(i,j),j=1,83),i=18,18)/
     *-0.1709E+00,-0.1707E+00,-0.1695E+00,-0.1675E+00,-0.1645E+00,
     *-0.1608E+00,-0.1563E+00,-0.1512E+00,-0.1457E+00,-0.1397E+00,
     *-0.1336E+00,-0.1273E+00,-0.1210E+00,-0.1147E+00,-0.1084E+00,
     *-0.1023E+00,-0.9627E-01,-0.9034E-01,-0.8453E-01,-0.7880E-01,
     *-0.7314E-01,-0.6751E-01,-0.6189E-01,-0.5623E-01,-0.5048E-01,
     *-0.4461E-01,-0.3855E-01,-0.3226E-01,-0.2567E-01,-0.1872E-01,
     *-0.1132E-01,-0.3382E-02, 0.5188E-02, 0.1450E-01, 0.2466E-01,
     * 0.3581E-01, 0.4809E-01, 0.6166E-01, 0.7669E-01, 0.9342E-01,
     * 0.1121E+00, 0.1222E+00, 0.1329E+00, 0.1563E+00, 0.1826E+00,
     * 0.2122E+00, 0.2455E+00, 0.2831E+00, 0.3255E+00, 0.3733E+00,
     * 0.4273E+00, 0.4884E+00, 0.5574E+00, 0.6355E+00, 0.7238E+00,
     * 0.8237E+00, 0.9366E+00, 0.1064E+01, 0.1208E+01, 0.1371E+01,
     * 0.1553E+01, 0.1759E+01, 0.1990E+01, 0.2248E+01, 0.2537E+01,
     * 0.2857E+01, 0.3212E+01, 0.3603E+01, 0.4031E+01, 0.4496E+01,
     * 0.4996E+01, 0.5530E+01, 0.6091E+01, 0.6672E+01, 0.7262E+01,
     * 0.7849E+01, 0.8415E+01, 0.8941E+01, 0.9406E+01, 0.9788E+01,
     * 0.1007E+02, 0.1023E+02, 0.1027E+02 /
        DATA ((UHR(i,j),j=1,83),i=19,19)/
     *-0.1989E+00,-0.1987E+00,-0.1977E+00,-0.1961E+00,-0.1937E+00,
     *-0.1907E+00,-0.1870E+00,-0.1828E+00,-0.1781E+00,-0.1730E+00,
     *-0.1676E+00,-0.1620E+00,-0.1563E+00,-0.1504E+00,-0.1444E+00,
     *-0.1385E+00,-0.1324E+00,-0.1264E+00,-0.1204E+00,-0.1143E+00,
     *-0.1081E+00,-0.1019E+00,-0.9558E-01,-0.8910E-01,-0.8243E-01,
     *-0.7552E-01,-0.6831E-01,-0.6073E-01,-0.5272E-01,-0.4419E-01,
     *-0.3507E-01,-0.2525E-01,-0.1464E-01,-0.3121E-02, 0.9448E-02,
     * 0.2321E-01, 0.3833E-01, 0.5501E-01, 0.7343E-01, 0.9383E-01,
     * 0.1165E+00, 0.1287E+00, 0.1416E+00, 0.1696E+00, 0.2008E+00,
     * 0.2355E+00, 0.2742E+00, 0.3175E+00, 0.3658E+00, 0.4199E+00,
     * 0.4803E+00, 0.5479E+00, 0.6235E+00, 0.7079E+00, 0.8023E+00,
     * 0.9077E+00, 0.1025E+01, 0.1156E+01, 0.1302E+01, 0.1465E+01,
     * 0.1645E+01, 0.1844E+01, 0.2065E+01, 0.2307E+01, 0.2574E+01,
     * 0.2865E+01, 0.3181E+01, 0.3524E+01, 0.3892E+01, 0.4285E+01,
     * 0.4700E+01, 0.5135E+01, 0.5583E+01, 0.6040E+01, 0.6495E+01,
     * 0.6940E+01, 0.7362E+01, 0.7749E+01, 0.8085E+01, 0.8359E+01,
     * 0.8557E+01, 0.8671E+01, 0.8698E+01 /
        DATA ((UHR(i,j),j=1,83),i=20,20)/
     *-0.4039E+00,-0.4037E+00,-0.4031E+00,-0.4020E+00,-0.4004E+00,
     *-0.3983E+00,-0.3957E+00,-0.3926E+00,-0.3891E+00,-0.3851E+00,
     *-0.3806E+00,-0.3757E+00,-0.3703E+00,-0.3645E+00,-0.3582E+00,
     *-0.3514E+00,-0.3442E+00,-0.3364E+00,-0.3282E+00,-0.3194E+00,
     *-0.3100E+00,-0.3000E+00,-0.2894E+00,-0.2780E+00,-0.2659E+00,
     *-0.2530E+00,-0.2391E+00,-0.2243E+00,-0.2084E+00,-0.1914E+00,
     *-0.1732E+00,-0.1536E+00,-0.1325E+00,-0.1098E+00,-0.8535E-01,
     *-0.5904E-01,-0.3069E-01,-0.1341E-03, 0.3282E-01, 0.6835E-01,
     * 0.1067E+00, 0.1269E+00, 0.1480E+00, 0.1925E+00, 0.2405E+00,
     * 0.2923E+00, 0.3480E+00, 0.4080E+00, 0.4725E+00, 0.5419E+00,
     * 0.6164E+00, 0.6963E+00, 0.7820E+00, 0.8737E+00, 0.9717E+00,
     * 0.1076E+01, 0.1188E+01, 0.1306E+01, 0.1432E+01, 0.1565E+01,
     * 0.1705E+01, 0.1852E+01, 0.2007E+01, 0.2169E+01, 0.2337E+01,
     * 0.2511E+01, 0.2690E+01, 0.2873E+01, 0.3060E+01, 0.3248E+01,
     * 0.3436E+01, 0.3622E+01, 0.3805E+01, 0.3980E+01, 0.4147E+01,
     * 0.4303E+01, 0.4443E+01, 0.4567E+01, 0.4671E+01, 0.4753E+01,
     * 0.4811E+01, 0.4844E+01, 0.4852E+01 /



      do 1 i=1,20
       asy(1,i)=asy_m(i)
       ex(1,i)=ex_m(i)
       sc(1,i)=sc_m(i)
      do 1 j=1,nquad
      ph(i,j)=phr(i,j)
      qh(i,j)=qhr(i,j)
      uh(i,j)=uhr(i,j)
    1 continue
      return
      end
