       subroutine   soot

c - to vary the number of quadratures
      include "paramdef.inc"
      integer nquad
      common /num_quad/ nquad
      real ph,qh,uh
      common /sixs_aerbas/ ph(20,nqmax_p),qh(20,nqmax_p),uh(20,nqmax_p)
      real phr(20,nqdef_p),qhr(20,nqdef_p),uhr(20,nqdef_p)
c - to vary the number of quadratures
      real ex,sc,asy,vi
      common /sixs_coef/ ex(4,20),sc(4,20),asy(4,20),vi(4)
      real ex_m(20),sc_m(20),asy_m(20),vi_m
      integer i,j

c Soot model
c Parameters and refractive indices - G.A. d'Almeida, 'Atmospheric
c aerosols. Global climatology and radiative characteristics', 1991.
c Extinction coefficients are calculated in km-1

c*************** MIE (asy) ******************
      data (asy_m(j),j=1,20)/
     a 0.423,0.397,0.391,0.377,0.365,0.358,0.348,0.337,0.324,0.310,
     a 0.299,0.293,0.276,0.253,0.188,0.155,0.144,0.121,0.103,0.055/
c*************** MIE (ext&sca) ******************
        data (ex_m(j),sc_m(j),j=1,20) /
     a 0.1017724E-02,0.2956808E-03,0.8614733E-03,0.2301183E-03,
     a 0.8291564E-03,0.2170554E-03,0.7534558E-03,0.1871983E-03,
     a 0.6955619E-03,0.1651221E-03,0.6605808E-03,0.1521293E-03,
     a 0.6115299E-03,0.1348011E-03,0.5541574E-03,0.1156599E-03,
     a 0.5007540E-03,0.9774679E-04,0.4542466E-03,0.8218560E-04,
     a 0.4189021E-03,0.7111410E-04,0.3975466E-03,0.6486094E-04,
     a 0.3507939E-03,0.5093826E-04,0.2984524E-03,0.3621259E-04,
     a 0.1898267E-03,0.1251277E-04,0.1479603E-03,0.6450522E-05,
     a 0.1378559E-03,0.5127908E-05,0.1161122E-03,0.2946072E-05,
     a 0.1005532E-03,0.1794028E-05,0.6124496E-04,0.3055190E-06 /
c************** MIE (phase fun ph) ***************
        DATA ((PHR(i,j),j=1,83),i= 1, 1)/
     *0.4446E+00,0.4445E+00,0.4440E+00,0.4431E+00,0.4419E+00,
     *0.4403E+00,0.4384E+00,0.4363E+00,0.4339E+00,0.4312E+00,
     *0.4284E+00,0.4255E+00,0.4225E+00,0.4195E+00,0.4165E+00,
     *0.4135E+00,0.4106E+00,0.4079E+00,0.4053E+00,0.4031E+00,
     *0.4011E+00,0.3995E+00,0.3983E+00,0.3975E+00,0.3974E+00,
     *0.3978E+00,0.3989E+00,0.4008E+00,0.4035E+00,0.4071E+00,
     *0.4117E+00,0.4174E+00,0.4244E+00,0.4327E+00,0.4424E+00,
     *0.4537E+00,0.4666E+00,0.4814E+00,0.4982E+00,0.5172E+00,
     *0.5384E+00,0.5500E+00,0.5622E+00,0.5886E+00,0.6179E+00,
     *0.6503E+00,0.6861E+00,0.7254E+00,0.7685E+00,0.8156E+00,
     *0.8670E+00,0.9231E+00,0.9840E+00,0.1050E+01,0.1122E+01,
     *0.1199E+01,0.1282E+01,0.1372E+01,0.1468E+01,0.1571E+01,
     *0.1681E+01,0.1799E+01,0.1923E+01,0.2055E+01,0.2195E+01,
     *0.2341E+01,0.2495E+01,0.2655E+01,0.2822E+01,0.2993E+01,
     *0.3168E+01,0.3346E+01,0.3525E+01,0.3703E+01,0.3877E+01,
     *0.4044E+01,0.4201E+01,0.4343E+01,0.4468E+01,0.4569E+01,
     *0.4642E+01,0.4685E+01,0.4695E+01 /
        DATA ((PHR(i,j),j=1,83),i= 2, 2)/
     *0.4907E+00,0.4905E+00,0.4900E+00,0.4890E+00,0.4876E+00,
     *0.4858E+00,0.4836E+00,0.4811E+00,0.4783E+00,0.4752E+00,
     *0.4719E+00,0.4684E+00,0.4647E+00,0.4610E+00,0.4572E+00,
     *0.4535E+00,0.4498E+00,0.4462E+00,0.4428E+00,0.4396E+00,
     *0.4367E+00,0.4341E+00,0.4320E+00,0.4303E+00,0.4292E+00,
     *0.4288E+00,0.4290E+00,0.4300E+00,0.4319E+00,0.4347E+00,
     *0.4386E+00,0.4436E+00,0.4500E+00,0.4576E+00,0.4668E+00,
     *0.4776E+00,0.4902E+00,0.5046E+00,0.5211E+00,0.5398E+00,
     *0.5608E+00,0.5723E+00,0.5843E+00,0.6106E+00,0.6397E+00,
     *0.6719E+00,0.7074E+00,0.7464E+00,0.7890E+00,0.8356E+00,
     *0.8864E+00,0.9415E+00,0.1001E+01,0.1066E+01,0.1135E+01,
     *0.1210E+01,0.1290E+01,0.1376E+01,0.1468E+01,0.1566E+01,
     *0.1670E+01,0.1780E+01,0.1896E+01,0.2018E+01,0.2146E+01,
     *0.2280E+01,0.2419E+01,0.2563E+01,0.2711E+01,0.2862E+01,
     *0.3015E+01,0.3170E+01,0.3323E+01,0.3474E+01,0.3620E+01,
     *0.3759E+01,0.3889E+01,0.4005E+01,0.4105E+01,0.4185E+01,
     *0.4244E+01,0.4277E+01,0.4285E+01 /
        DATA ((PHR(i,j),j=1,83),i= 3, 3)/
     *0.5012E+00,0.5010E+00,0.5005E+00,0.4995E+00,0.4980E+00,
     *0.4961E+00,0.4939E+00,0.4913E+00,0.4884E+00,0.4852E+00,
     *0.4817E+00,0.4781E+00,0.4743E+00,0.4704E+00,0.4665E+00,
     *0.4625E+00,0.4586E+00,0.4548E+00,0.4512E+00,0.4478E+00,
     *0.4447E+00,0.4419E+00,0.4396E+00,0.4377E+00,0.4364E+00,
     *0.4357E+00,0.4357E+00,0.4365E+00,0.4382E+00,0.4408E+00,
     *0.4446E+00,0.4494E+00,0.4556E+00,0.4631E+00,0.4722E+00,
     *0.4829E+00,0.4953E+00,0.5096E+00,0.5260E+00,0.5446E+00,
     *0.5656E+00,0.5770E+00,0.5890E+00,0.6152E+00,0.6443E+00,
     *0.6764E+00,0.7118E+00,0.7506E+00,0.7932E+00,0.8396E+00,
     *0.8901E+00,0.9450E+00,0.1004E+01,0.1069E+01,0.1138E+01,
     *0.1212E+01,0.1291E+01,0.1377E+01,0.1467E+01,0.1564E+01,
     *0.1667E+01,0.1775E+01,0.1889E+01,0.2009E+01,0.2135E+01,
     *0.2266E+01,0.2402E+01,0.2542E+01,0.2687E+01,0.2834E+01,
     *0.2983E+01,0.3132E+01,0.3280E+01,0.3426E+01,0.3567E+01,
     *0.3701E+01,0.3824E+01,0.3936E+01,0.4031E+01,0.4108E+01,
     *0.4163E+01,0.4195E+01,0.4203E+01 /
        DATA ((PHR(i,j),j=1,83),i= 4, 4)/
     *0.5274E+00,0.5272E+00,0.5266E+00,0.5255E+00,0.5240E+00,
     *0.5220E+00,0.5195E+00,0.5167E+00,0.5135E+00,0.5101E+00,
     *0.5063E+00,0.5023E+00,0.4981E+00,0.4938E+00,0.4895E+00,
     *0.4851E+00,0.4807E+00,0.4764E+00,0.4723E+00,0.4683E+00,
     *0.4647E+00,0.4613E+00,0.4584E+00,0.4560E+00,0.4541E+00,
     *0.4529E+00,0.4523E+00,0.4526E+00,0.4538E+00,0.4560E+00,
     *0.4592E+00,0.4636E+00,0.4694E+00,0.4765E+00,0.4852E+00,
     *0.4955E+00,0.5077E+00,0.5217E+00,0.5378E+00,0.5562E+00,
     *0.5769E+00,0.5882E+00,0.6002E+00,0.6261E+00,0.6550E+00,
     *0.6869E+00,0.7220E+00,0.7605E+00,0.8027E+00,0.8487E+00,
     *0.8987E+00,0.9528E+00,0.1011E+01,0.1075E+01,0.1142E+01,
     *0.1215E+01,0.1293E+01,0.1376E+01,0.1464E+01,0.1558E+01,
     *0.1657E+01,0.1762E+01,0.1871E+01,0.1986E+01,0.2106E+01,
     *0.2231E+01,0.2360E+01,0.2492E+01,0.2627E+01,0.2765E+01,
     *0.2904E+01,0.3042E+01,0.3179E+01,0.3313E+01,0.3441E+01,
     *0.3563E+01,0.3674E+01,0.3774E+01,0.3860E+01,0.3928E+01,
     *0.3977E+01,0.4005E+01,0.4012E+01 /
        DATA ((PHR(i,j),j=1,83),i= 5, 5)/
     *0.5491E+00,0.5490E+00,0.5483E+00,0.5472E+00,0.5455E+00,
     *0.5434E+00,0.5408E+00,0.5378E+00,0.5345E+00,0.5307E+00,
     *0.5267E+00,0.5224E+00,0.5179E+00,0.5133E+00,0.5085E+00,
     *0.5037E+00,0.4990E+00,0.4942E+00,0.4897E+00,0.4853E+00,
     *0.4811E+00,0.4773E+00,0.4740E+00,0.4710E+00,0.4687E+00,
     *0.4670E+00,0.4660E+00,0.4658E+00,0.4666E+00,0.4683E+00,
     *0.4711E+00,0.4752E+00,0.4805E+00,0.4873E+00,0.4957E+00,
     *0.5057E+00,0.5176E+00,0.5314E+00,0.5472E+00,0.5654E+00,
     *0.5858E+00,0.5970E+00,0.6089E+00,0.6346E+00,0.6632E+00,
     *0.6949E+00,0.7298E+00,0.7680E+00,0.8098E+00,0.8554E+00,
     *0.9048E+00,0.9584E+00,0.1016E+01,0.1078E+01,0.1145E+01,
     *0.1217E+01,0.1293E+01,0.1375E+01,0.1461E+01,0.1552E+01,
     *0.1649E+01,0.1750E+01,0.1856E+01,0.1967E+01,0.2082E+01,
     *0.2202E+01,0.2325E+01,0.2451E+01,0.2580E+01,0.2710E+01,
     *0.2841E+01,0.2971E+01,0.3099E+01,0.3224E+01,0.3344E+01,
     *0.3456E+01,0.3559E+01,0.3651E+01,0.3729E+01,0.3792E+01,
     *0.3836E+01,0.3862E+01,0.3868E+01 /
        DATA ((PHR(i,j),j=1,83),i= 6, 6)/
     *0.5632E+00,0.5630E+00,0.5623E+00,0.5611E+00,0.5594E+00,
     *0.5572E+00,0.5545E+00,0.5514E+00,0.5479E+00,0.5440E+00,
     *0.5398E+00,0.5353E+00,0.5306E+00,0.5258E+00,0.5208E+00,
     *0.5157E+00,0.5107E+00,0.5057E+00,0.5008E+00,0.4961E+00,
     *0.4917E+00,0.4876E+00,0.4839E+00,0.4807E+00,0.4780E+00,
     *0.4760E+00,0.4747E+00,0.4742E+00,0.4747E+00,0.4761E+00,
     *0.4787E+00,0.4825E+00,0.4876E+00,0.4942E+00,0.5023E+00,
     *0.5121E+00,0.5238E+00,0.5374E+00,0.5531E+00,0.5710E+00,
     *0.5914E+00,0.6025E+00,0.6143E+00,0.6398E+00,0.6683E+00,
     *0.6998E+00,0.7344E+00,0.7725E+00,0.8140E+00,0.8593E+00,
     *0.9084E+00,0.9616E+00,0.1019E+01,0.1081E+01,0.1147E+01,
     *0.1217E+01,0.1293E+01,0.1373E+01,0.1458E+01,0.1548E+01,
     *0.1643E+01,0.1742E+01,0.1846E+01,0.1954E+01,0.2067E+01,
     *0.2183E+01,0.2303E+01,0.2426E+01,0.2550E+01,0.2676E+01,
     *0.2802E+01,0.2927E+01,0.3050E+01,0.3170E+01,0.3284E+01,
     *0.3391E+01,0.3489E+01,0.3576E+01,0.3650E+01,0.3709E+01,
     *0.3751E+01,0.3775E+01,0.3781E+01 /
        DATA ((PHR(i,j),j=1,83),i= 7, 7)/
     *0.5829E+00,0.5827E+00,0.5820E+00,0.5807E+00,0.5789E+00,
     *0.5766E+00,0.5738E+00,0.5705E+00,0.5668E+00,0.5627E+00,
     *0.5582E+00,0.5535E+00,0.5485E+00,0.5433E+00,0.5379E+00,
     *0.5325E+00,0.5271E+00,0.5217E+00,0.5164E+00,0.5113E+00,
     *0.5064E+00,0.5019E+00,0.4977E+00,0.4941E+00,0.4910E+00,
     *0.4885E+00,0.4868E+00,0.4859E+00,0.4859E+00,0.4870E+00,
     *0.4891E+00,0.4926E+00,0.4973E+00,0.5036E+00,0.5114E+00,
     *0.5209E+00,0.5323E+00,0.5456E+00,0.5611E+00,0.5788E+00,
     *0.5989E+00,0.6099E+00,0.6215E+00,0.6469E+00,0.6751E+00,
     *0.7063E+00,0.7407E+00,0.7784E+00,0.8196E+00,0.8645E+00,
     *0.9131E+00,0.9657E+00,0.1022E+01,0.1083E+01,0.1148E+01,
     *0.1218E+01,0.1292E+01,0.1371E+01,0.1454E+01,0.1542E+01,
     *0.1634E+01,0.1731E+01,0.1832E+01,0.1937E+01,0.2045E+01,
     *0.2157E+01,0.2272E+01,0.2390E+01,0.2509E+01,0.2629E+01,
     *0.2748E+01,0.2867E+01,0.2983E+01,0.3096E+01,0.3203E+01,
     *0.3303E+01,0.3394E+01,0.3475E+01,0.3544E+01,0.3598E+01,
     *0.3637E+01,0.3659E+01,0.3664E+01 /
        DATA ((PHR(i,j),j=1,83),i= 8, 8)/
     *0.6066E+00,0.6064E+00,0.6057E+00,0.6043E+00,0.6024E+00,
     *0.6000E+00,0.5970E+00,0.5935E+00,0.5895E+00,0.5851E+00,
     *0.5803E+00,0.5753E+00,0.5699E+00,0.5643E+00,0.5585E+00,
     *0.5527E+00,0.5467E+00,0.5409E+00,0.5351E+00,0.5294E+00,
     *0.5240E+00,0.5189E+00,0.5143E+00,0.5100E+00,0.5064E+00,
     *0.5034E+00,0.5011E+00,0.4997E+00,0.4992E+00,0.4998E+00,
     *0.5015E+00,0.5044E+00,0.5088E+00,0.5146E+00,0.5220E+00,
     *0.5311E+00,0.5422E+00,0.5552E+00,0.5703E+00,0.5877E+00,
     *0.6075E+00,0.6184E+00,0.6299E+00,0.6550E+00,0.6829E+00,
     *0.7138E+00,0.7478E+00,0.7851E+00,0.8259E+00,0.8702E+00,
     *0.9182E+00,0.9701E+00,0.1026E+01,0.1086E+01,0.1150E+01,
     *0.1218E+01,0.1290E+01,0.1367E+01,0.1448E+01,0.1534E+01,
     *0.1623E+01,0.1717E+01,0.1814E+01,0.1915E+01,0.2019E+01,
     *0.2126E+01,0.2236E+01,0.2348E+01,0.2460E+01,0.2574E+01,
     *0.2686E+01,0.2797E+01,0.2906E+01,0.3010E+01,0.3110E+01,
     *0.3202E+01,0.3286E+01,0.3360E+01,0.3423E+01,0.3473E+01,
     *0.3508E+01,0.3528E+01,0.3533E+01 /
        DATA ((PHR(i,j),j=1,83),i= 9, 9)/
     *0.6338E+00,0.6336E+00,0.6328E+00,0.6314E+00,0.6293E+00,
     *0.6267E+00,0.6235E+00,0.6198E+00,0.6155E+00,0.6108E+00,
     *0.6057E+00,0.6002E+00,0.5944E+00,0.5883E+00,0.5821E+00,
     *0.5757E+00,0.5693E+00,0.5628E+00,0.5564E+00,0.5502E+00,
     *0.5442E+00,0.5385E+00,0.5332E+00,0.5283E+00,0.5240E+00,
     *0.5204E+00,0.5175E+00,0.5155E+00,0.5144E+00,0.5143E+00,
     *0.5155E+00,0.5179E+00,0.5217E+00,0.5270E+00,0.5339E+00,
     *0.5426E+00,0.5531E+00,0.5657E+00,0.5804E+00,0.5974E+00,
     *0.6168E+00,0.6275E+00,0.6388E+00,0.6634E+00,0.6909E+00,
     *0.7214E+00,0.7549E+00,0.7917E+00,0.8318E+00,0.8754E+00,
     *0.9227E+00,0.9736E+00,0.1028E+01,0.1087E+01,0.1150E+01,
     *0.1216E+01,0.1287E+01,0.1362E+01,0.1440E+01,0.1523E+01,
     *0.1609E+01,0.1699E+01,0.1793E+01,0.1890E+01,0.1989E+01,
     *0.2091E+01,0.2195E+01,0.2301E+01,0.2407E+01,0.2513E+01,
     *0.2619E+01,0.2723E+01,0.2823E+01,0.2920E+01,0.3012E+01,
     *0.3097E+01,0.3174E+01,0.3241E+01,0.3298E+01,0.3343E+01,
     *0.3375E+01,0.3393E+01,0.3398E+01 /
        DATA ((PHR(i,j),j=1,83),i=10,10)/
     *0.6626E+00,0.6624E+00,0.6616E+00,0.6601E+00,0.6579E+00,
     *0.6551E+00,0.6517E+00,0.6476E+00,0.6431E+00,0.6381E+00,
     *0.6326E+00,0.6267E+00,0.6204E+00,0.6139E+00,0.6071E+00,
     *0.6002E+00,0.5931E+00,0.5861E+00,0.5791E+00,0.5722E+00,
     *0.5655E+00,0.5592E+00,0.5532E+00,0.5476E+00,0.5427E+00,
     *0.5383E+00,0.5348E+00,0.5321E+00,0.5303E+00,0.5296E+00,
     *0.5301E+00,0.5319E+00,0.5351E+00,0.5398E+00,0.5462E+00,
     *0.5543E+00,0.5644E+00,0.5764E+00,0.5907E+00,0.6072E+00,
     *0.6261E+00,0.6365E+00,0.6475E+00,0.6717E+00,0.6986E+00,
     *0.7285E+00,0.7615E+00,0.7976E+00,0.8370E+00,0.8799E+00,
     *0.9262E+00,0.9761E+00,0.1030E+01,0.1087E+01,0.1148E+01,
     *0.1213E+01,0.1282E+01,0.1354E+01,0.1430E+01,0.1510E+01,
     *0.1594E+01,0.1680E+01,0.1770E+01,0.1862E+01,0.1957E+01,
     *0.2055E+01,0.2153E+01,0.2253E+01,0.2353E+01,0.2453E+01,
     *0.2551E+01,0.2648E+01,0.2742E+01,0.2831E+01,0.2916E+01,
     *0.2994E+01,0.3064E+01,0.3126E+01,0.3178E+01,0.3219E+01,
     *0.3248E+01,0.3264E+01,0.3268E+01 /
        DATA ((PHR(i,j),j=1,83),i=11,11)/
     *0.6857E+00,0.6855E+00,0.6846E+00,0.6830E+00,0.6808E+00,
     *0.6778E+00,0.6742E+00,0.6700E+00,0.6652E+00,0.6599E+00,
     *0.6540E+00,0.6478E+00,0.6412E+00,0.6342E+00,0.6270E+00,
     *0.6197E+00,0.6122E+00,0.6046E+00,0.5971E+00,0.5897E+00,
     *0.5825E+00,0.5756E+00,0.5690E+00,0.5630E+00,0.5574E+00,
     *0.5526E+00,0.5484E+00,0.5452E+00,0.5429E+00,0.5417E+00,
     *0.5417E+00,0.5429E+00,0.5457E+00,0.5499E+00,0.5558E+00,
     *0.5635E+00,0.5731E+00,0.5847E+00,0.5985E+00,0.6146E+00,
     *0.6331E+00,0.6433E+00,0.6542E+00,0.6779E+00,0.7044E+00,
     *0.7338E+00,0.7663E+00,0.8019E+00,0.8407E+00,0.8829E+00,
     *0.9285E+00,0.9776E+00,0.1030E+01,0.1087E+01,0.1146E+01,
     *0.1210E+01,0.1277E+01,0.1348E+01,0.1422E+01,0.1500E+01,
     *0.1581E+01,0.1665E+01,0.1751E+01,0.1841E+01,0.1932E+01,
     *0.2025E+01,0.2120E+01,0.2215E+01,0.2311E+01,0.2406E+01,
     *0.2499E+01,0.2591E+01,0.2679E+01,0.2764E+01,0.2843E+01,
     *0.2916E+01,0.2982E+01,0.3039E+01,0.3088E+01,0.3126E+01,
     *0.3153E+01,0.3168E+01,0.3171E+01 /
        DATA ((PHR(i,j),j=1,83),i=12,12)/
     *0.6997E+00,0.6995E+00,0.6986E+00,0.6969E+00,0.6946E+00,
     *0.6915E+00,0.6878E+00,0.6835E+00,0.6785E+00,0.6730E+00,
     *0.6670E+00,0.6606E+00,0.6537E+00,0.6465E+00,0.6391E+00,
     *0.6314E+00,0.6236E+00,0.6158E+00,0.6080E+00,0.6002E+00,
     *0.5927E+00,0.5855E+00,0.5786E+00,0.5721E+00,0.5663E+00,
     *0.5611E+00,0.5566E+00,0.5530E+00,0.5504E+00,0.5489E+00,
     *0.5485E+00,0.5495E+00,0.5519E+00,0.5559E+00,0.5615E+00,
     *0.5689E+00,0.5782E+00,0.5896E+00,0.6032E+00,0.6190E+00,
     *0.6372E+00,0.6473E+00,0.6580E+00,0.6815E+00,0.7077E+00,
     *0.7369E+00,0.7690E+00,0.8043E+00,0.8428E+00,0.8845E+00,
     *0.9297E+00,0.9783E+00,0.1030E+01,0.1086E+01,0.1145E+01,
     *0.1208E+01,0.1274E+01,0.1344E+01,0.1417E+01,0.1493E+01,
     *0.1573E+01,0.1655E+01,0.1740E+01,0.1828E+01,0.1917E+01,
     *0.2008E+01,0.2100E+01,0.2193E+01,0.2286E+01,0.2378E+01,
     *0.2469E+01,0.2557E+01,0.2642E+01,0.2724E+01,0.2800E+01,
     *0.2870E+01,0.2934E+01,0.2989E+01,0.3035E+01,0.3071E+01,
     *0.3097E+01,0.3111E+01,0.3115E+01 /
        DATA ((PHR(i,j),j=1,83),i=13,13)/
     *0.7383E+00,0.7380E+00,0.7370E+00,0.7352E+00,0.7327E+00,
     *0.7294E+00,0.7254E+00,0.7207E+00,0.7153E+00,0.7093E+00,
     *0.7028E+00,0.6958E+00,0.6883E+00,0.6804E+00,0.6723E+00,
     *0.6638E+00,0.6553E+00,0.6466E+00,0.6379E+00,0.6293E+00,
     *0.6209E+00,0.6127E+00,0.6049E+00,0.5975E+00,0.5907E+00,
     *0.5845E+00,0.5791E+00,0.5746E+00,0.5710E+00,0.5686E+00,
     *0.5673E+00,0.5674E+00,0.5690E+00,0.5721E+00,0.5769E+00,
     *0.5835E+00,0.5920E+00,0.6026E+00,0.6154E+00,0.6305E+00,
     *0.6480E+00,0.6577E+00,0.6680E+00,0.6907E+00,0.7161E+00,
     *0.7444E+00,0.7756E+00,0.8099E+00,0.8473E+00,0.8879E+00,
     *0.9317E+00,0.9788E+00,0.1029E+01,0.1083E+01,0.1140E+01,
     *0.1201E+01,0.1265E+01,0.1331E+01,0.1401E+01,0.1474E+01,
     *0.1550E+01,0.1628E+01,0.1709E+01,0.1791E+01,0.1875E+01,
     *0.1961E+01,0.2047E+01,0.2133E+01,0.2219E+01,0.2304E+01,
     *0.2388E+01,0.2469E+01,0.2547E+01,0.2621E+01,0.2690E+01,
     *0.2753E+01,0.2810E+01,0.2860E+01,0.2901E+01,0.2934E+01,
     *0.2956E+01,0.2969E+01,0.2972E+01 /
        DATA ((PHR(i,j),j=1,83),i=14,14)/
     *0.7925E+00,0.7922E+00,0.7911E+00,0.7892E+00,0.7863E+00,
     *0.7827E+00,0.7782E+00,0.7730E+00,0.7670E+00,0.7604E+00,
     *0.7531E+00,0.7452E+00,0.7369E+00,0.7280E+00,0.7188E+00,
     *0.7093E+00,0.6996E+00,0.6898E+00,0.6798E+00,0.6700E+00,
     *0.6602E+00,0.6507E+00,0.6416E+00,0.6329E+00,0.6247E+00,
     *0.6171E+00,0.6104E+00,0.6045E+00,0.5996E+00,0.5958E+00,
     *0.5933E+00,0.5921E+00,0.5924E+00,0.5942E+00,0.5978E+00,
     *0.6032E+00,0.6106E+00,0.6200E+00,0.6316E+00,0.6455E+00,
     *0.6618E+00,0.6709E+00,0.6807E+00,0.7021E+00,0.7263E+00,
     *0.7532E+00,0.7830E+00,0.8158E+00,0.8516E+00,0.8904E+00,
     *0.9324E+00,0.9774E+00,0.1026E+01,0.1077E+01,0.1131E+01,
     *0.1188E+01,0.1249E+01,0.1312E+01,0.1378E+01,0.1446E+01,
     *0.1517E+01,0.1590E+01,0.1664E+01,0.1740E+01,0.1818E+01,
     *0.1896E+01,0.1974E+01,0.2053E+01,0.2130E+01,0.2207E+01,
     *0.2281E+01,0.2354E+01,0.2423E+01,0.2488E+01,0.2549E+01,
     *0.2604E+01,0.2654E+01,0.2696E+01,0.2732E+01,0.2760E+01,
     *0.2780E+01,0.2791E+01,0.2793E+01 /
        DATA ((PHR(i,j),j=1,83),i=15,15)/
     *0.9497E+00,0.9494E+00,0.9479E+00,0.9454E+00,0.9417E+00,
     *0.9369E+00,0.9311E+00,0.9242E+00,0.9164E+00,0.9076E+00,
     *0.8980E+00,0.8876E+00,0.8765E+00,0.8647E+00,0.8524E+00,
     *0.8396E+00,0.8264E+00,0.8130E+00,0.7994E+00,0.7857E+00,
     *0.7721E+00,0.7586E+00,0.7454E+00,0.7326E+00,0.7203E+00,
     *0.7087E+00,0.6978E+00,0.6878E+00,0.6789E+00,0.6711E+00,
     *0.6646E+00,0.6595E+00,0.6559E+00,0.6540E+00,0.6538E+00,
     *0.6555E+00,0.6592E+00,0.6649E+00,0.6729E+00,0.6832E+00,
     *0.6958E+00,0.7030E+00,0.7109E+00,0.7284E+00,0.7486E+00,
     *0.7714E+00,0.7968E+00,0.8249E+00,0.8557E+00,0.8892E+00,
     *0.9254E+00,0.9642E+00,0.1006E+01,0.1049E+01,0.1096E+01,
     *0.1144E+01,0.1195E+01,0.1248E+01,0.1303E+01,0.1359E+01,
     *0.1417E+01,0.1476E+01,0.1535E+01,0.1596E+01,0.1657E+01,
     *0.1717E+01,0.1778E+01,0.1837E+01,0.1896E+01,0.1953E+01,
     *0.2008E+01,0.2060E+01,0.2110E+01,0.2156E+01,0.2199E+01,
     *0.2237E+01,0.2271E+01,0.2301E+01,0.2325E+01,0.2344E+01,
     *0.2357E+01,0.2364E+01,0.2366E+01 /
        DATA ((PHR(i,j),j=1,83),i=16,16)/
     *0.1036E+01,0.1036E+01,0.1034E+01,0.1031E+01,0.1027E+01,
     *0.1022E+01,0.1015E+01,0.1007E+01,0.9983E+00,0.9883E+00,
     *0.9773E+00,0.9654E+00,0.9527E+00,0.9392E+00,0.9251E+00,
     *0.9103E+00,0.8952E+00,0.8796E+00,0.8639E+00,0.8480E+00,
     *0.8321E+00,0.8163E+00,0.8008E+00,0.7856E+00,0.7710E+00,
     *0.7570E+00,0.7438E+00,0.7315E+00,0.7202E+00,0.7101E+00,
     *0.7013E+00,0.6939E+00,0.6881E+00,0.6839E+00,0.6816E+00,
     *0.6811E+00,0.6826E+00,0.6862E+00,0.6921E+00,0.7001E+00,
     *0.7106E+00,0.7167E+00,0.7234E+00,0.7387E+00,0.7565E+00,
     *0.7768E+00,0.7997E+00,0.8252E+00,0.8532E+00,0.8836E+00,
     *0.9166E+00,0.9520E+00,0.9897E+00,0.1030E+01,0.1072E+01,
     *0.1116E+01,0.1162E+01,0.1210E+01,0.1259E+01,0.1309E+01,
     *0.1361E+01,0.1413E+01,0.1466E+01,0.1520E+01,0.1573E+01,
     *0.1626E+01,0.1679E+01,0.1731E+01,0.1781E+01,0.1830E+01,
     *0.1877E+01,0.1921E+01,0.1963E+01,0.2002E+01,0.2038E+01,
     *0.2071E+01,0.2099E+01,0.2123E+01,0.2143E+01,0.2159E+01,
     *0.2170E+01,0.2176E+01,0.2177E+01 /
        DATA ((PHR(i,j),j=1,83),i=17,17)/
     *0.1065E+01,0.1065E+01,0.1063E+01,0.1060E+01,0.1056E+01,
     *0.1050E+01,0.1043E+01,0.1035E+01,0.1026E+01,0.1015E+01,
     *0.1004E+01,0.9916E+00,0.9784E+00,0.9643E+00,0.9495E+00,
     *0.9341E+00,0.9183E+00,0.9020E+00,0.8855E+00,0.8689E+00,
     *0.8522E+00,0.8357E+00,0.8193E+00,0.8034E+00,0.7880E+00,
     *0.7731E+00,0.7591E+00,0.7460E+00,0.7339E+00,0.7230E+00,
     *0.7134E+00,0.7052E+00,0.6986E+00,0.6937E+00,0.6905E+00,
     *0.6893E+00,0.6900E+00,0.6929E+00,0.6979E+00,0.7053E+00,
     *0.7149E+00,0.7206E+00,0.7270E+00,0.7414E+00,0.7584E+00,
     *0.7779E+00,0.7999E+00,0.8244E+00,0.8514E+00,0.8809E+00,
     *0.9127E+00,0.9470E+00,0.9835E+00,0.1022E+01,0.1063E+01,
     *0.1106E+01,0.1150E+01,0.1196E+01,0.1244E+01,0.1292E+01,
     *0.1342E+01,0.1393E+01,0.1444E+01,0.1495E+01,0.1546E+01,
     *0.1597E+01,0.1647E+01,0.1696E+01,0.1745E+01,0.1791E+01,
     *0.1836E+01,0.1878E+01,0.1918E+01,0.1955E+01,0.1989E+01,
     *0.2019E+01,0.2046E+01,0.2069E+01,0.2088E+01,0.2103E+01,
     *0.2113E+01,0.2119E+01,0.2120E+01 /
        DATA ((PHR(i,j),j=1,83),i=18,18)/
     *0.1129E+01,0.1129E+01,0.1127E+01,0.1124E+01,0.1119E+01,
     *0.1113E+01,0.1105E+01,0.1096E+01,0.1086E+01,0.1075E+01,
     *0.1062E+01,0.1049E+01,0.1034E+01,0.1019E+01,0.1003E+01,
     *0.9858E+00,0.9684E+00,0.9505E+00,0.9324E+00,0.9141E+00,
     *0.8957E+00,0.8774E+00,0.8593E+00,0.8416E+00,0.8243E+00,
     *0.8077E+00,0.7919E+00,0.7769E+00,0.7631E+00,0.7504E+00,
     *0.7390E+00,0.7291E+00,0.7207E+00,0.7141E+00,0.7092E+00,
     *0.7063E+00,0.7054E+00,0.7065E+00,0.7099E+00,0.7155E+00,
     *0.7234E+00,0.7283E+00,0.7337E+00,0.7464E+00,0.7616E+00,
     *0.7792E+00,0.7992E+00,0.8217E+00,0.8466E+00,0.8738E+00,
     *0.9034E+00,0.9352E+00,0.9691E+00,0.1005E+01,0.1043E+01,
     *0.1082E+01,0.1124E+01,0.1166E+01,0.1210E+01,0.1255E+01,
     *0.1301E+01,0.1348E+01,0.1394E+01,0.1441E+01,0.1488E+01,
     *0.1535E+01,0.1580E+01,0.1625E+01,0.1668E+01,0.1710E+01,
     *0.1751E+01,0.1789E+01,0.1824E+01,0.1857E+01,0.1888E+01,
     *0.1915E+01,0.1939E+01,0.1959E+01,0.1976E+01,0.1989E+01,
     *0.1998E+01,0.2003E+01,0.2004E+01 /
        DATA ((PHR(i,j),j=1,83),i=19,19)/
     *0.1180E+01,0.1180E+01,0.1178E+01,0.1174E+01,0.1169E+01,
     *0.1163E+01,0.1155E+01,0.1145E+01,0.1134E+01,0.1122E+01,
     *0.1109E+01,0.1094E+01,0.1079E+01,0.1062E+01,0.1045E+01,
     *0.1027E+01,0.1008E+01,0.9891E+00,0.9696E+00,0.9499E+00,
     *0.9301E+00,0.9104E+00,0.8908E+00,0.8716E+00,0.8529E+00,
     *0.8349E+00,0.8175E+00,0.8012E+00,0.7858E+00,0.7717E+00,
     *0.7589E+00,0.7475E+00,0.7378E+00,0.7297E+00,0.7234E+00,
     *0.7191E+00,0.7168E+00,0.7166E+00,0.7186E+00,0.7228E+00,
     *0.7293E+00,0.7335E+00,0.7382E+00,0.7495E+00,0.7631E+00,
     *0.7792E+00,0.7977E+00,0.8185E+00,0.8417E+00,0.8672E+00,
     *0.8949E+00,0.9248E+00,0.9567E+00,0.9905E+00,0.1026E+01,
     *0.1063E+01,0.1102E+01,0.1142E+01,0.1184E+01,0.1226E+01,
     *0.1269E+01,0.1312E+01,0.1356E+01,0.1400E+01,0.1443E+01,
     *0.1487E+01,0.1529E+01,0.1570E+01,0.1611E+01,0.1650E+01,
     *0.1687E+01,0.1722E+01,0.1754E+01,0.1785E+01,0.1813E+01,
     *0.1837E+01,0.1859E+01,0.1878E+01,0.1893E+01,0.1905E+01,
     *0.1913E+01,0.1918E+01,0.1919E+01 /
        DATA ((PHR(i,j),j=1,83),i=20,20)/
     *0.1325E+01,0.1324E+01,0.1322E+01,0.1318E+01,0.1311E+01,
     *0.1304E+01,0.1294E+01,0.1283E+01,0.1270E+01,0.1255E+01,
     *0.1239E+01,0.1222E+01,0.1203E+01,0.1184E+01,0.1163E+01,
     *0.1141E+01,0.1119E+01,0.1096E+01,0.1073E+01,0.1049E+01,
     *0.1025E+01,0.1001E+01,0.9774E+00,0.9539E+00,0.9310E+00,
     *0.9086E+00,0.8871E+00,0.8664E+00,0.8469E+00,0.8286E+00,
     *0.8117E+00,0.7962E+00,0.7824E+00,0.7703E+00,0.7601E+00,
     *0.7518E+00,0.7456E+00,0.7415E+00,0.7395E+00,0.7398E+00,
     *0.7424E+00,0.7446E+00,0.7473E+00,0.7545E+00,0.7640E+00,
     *0.7758E+00,0.7900E+00,0.8063E+00,0.8249E+00,0.8455E+00,
     *0.8682E+00,0.8928E+00,0.9193E+00,0.9475E+00,0.9772E+00,
     *0.1008E+01,0.1041E+01,0.1074E+01,0.1109E+01,0.1144E+01,
     *0.1180E+01,0.1216E+01,0.1252E+01,0.1288E+01,0.1324E+01,
     *0.1359E+01,0.1394E+01,0.1428E+01,0.1460E+01,0.1491E+01,
     *0.1521E+01,0.1549E+01,0.1576E+01,0.1600E+01,0.1622E+01,
     *0.1642E+01,0.1659E+01,0.1673E+01,0.1685E+01,0.1695E+01,
     *0.1701E+01,0.1705E+01,0.1706E+01 /
c************** MIE (phase fun qh) ***************
        DATA ((QHR(i,j),j=1,83),i= 1, 1)/
     *-0.6313E-21,-0.2429E-03,-0.1278E-02,-0.3133E-02,-0.5796E-02,
     *-0.9250E-02,-0.1347E-01,-0.1844E-01,-0.2413E-01,-0.3051E-01,
     *-0.3754E-01,-0.4521E-01,-0.5347E-01,-0.6229E-01,-0.7165E-01,
     *-0.8151E-01,-0.9185E-01,-0.1026E+00,-0.1138E+00,-0.1254E+00,
     *-0.1374E+00,-0.1497E+00,-0.1623E+00,-0.1751E+00,-0.1882E+00,
     *-0.2016E+00,-0.2151E+00,-0.2288E+00,-0.2426E+00,-0.2565E+00,
     *-0.2704E+00,-0.2844E+00,-0.2983E+00,-0.3122E+00,-0.3259E+00,
     *-0.3395E+00,-0.3530E+00,-0.3661E+00,-0.3790E+00,-0.3915E+00,
     *-0.4036E+00,-0.4095E+00,-0.4152E+00,-0.4263E+00,-0.4368E+00,
     *-0.4466E+00,-0.4556E+00,-0.4638E+00,-0.4710E+00,-0.4773E+00,
     *-0.4824E+00,-0.4864E+00,-0.4892E+00,-0.4905E+00,-0.4904E+00,
     *-0.4888E+00,-0.4855E+00,-0.4806E+00,-0.4738E+00,-0.4652E+00,
     *-0.4547E+00,-0.4423E+00,-0.4278E+00,-0.4114E+00,-0.3930E+00,
     *-0.3727E+00,-0.3505E+00,-0.3266E+00,-0.3011E+00,-0.2743E+00,
     *-0.2464E+00,-0.2177E+00,-0.1886E+00,-0.1596E+00,-0.1312E+00,
     *-0.1039E+00,-0.7844E-01,-0.5546E-01,-0.3565E-01,-0.1967E-01,
     *-0.8147E-02,-0.1562E-02,-0.1106E-20 /
        DATA ((QHR(i,j),j=1,83),i= 2, 2)/
     *-0.1599E-20,-0.2648E-03,-0.1394E-02,-0.3418E-02,-0.6325E-02,
     *-0.1010E-01,-0.1472E-01,-0.2017E-01,-0.2641E-01,-0.3341E-01,
     *-0.4116E-01,-0.4960E-01,-0.5871E-01,-0.6846E-01,-0.7880E-01,
     *-0.8972E-01,-0.1012E+00,-0.1131E+00,-0.1255E+00,-0.1383E+00,
     *-0.1515E+00,-0.1651E+00,-0.1790E+00,-0.1932E+00,-0.2076E+00,
     *-0.2223E+00,-0.2371E+00,-0.2520E+00,-0.2670E+00,-0.2821E+00,
     *-0.2971E+00,-0.3121E+00,-0.3270E+00,-0.3418E+00,-0.3564E+00,
     *-0.3707E+00,-0.3847E+00,-0.3984E+00,-0.4116E+00,-0.4243E+00,
     *-0.4365E+00,-0.4423E+00,-0.4480E+00,-0.4588E+00,-0.4689E+00,
     *-0.4781E+00,-0.4864E+00,-0.4937E+00,-0.4999E+00,-0.5049E+00,
     *-0.5087E+00,-0.5111E+00,-0.5121E+00,-0.5116E+00,-0.5096E+00,
     *-0.5058E+00,-0.5004E+00,-0.4932E+00,-0.4841E+00,-0.4732E+00,
     *-0.4603E+00,-0.4455E+00,-0.4288E+00,-0.4103E+00,-0.3898E+00,
     *-0.3677E+00,-0.3439E+00,-0.3186E+00,-0.2921E+00,-0.2645E+00,
     *-0.2362E+00,-0.2074E+00,-0.1786E+00,-0.1502E+00,-0.1227E+00,
     *-0.9665E-01,-0.7256E-01,-0.5103E-01,-0.3264E-01,-0.1794E-01,
     *-0.7407E-02,-0.1417E-02, 0.2048E-20 /
        DATA ((QHR(i,j),j=1,83),i= 3, 3)/
     *-0.1770E-22,-0.2698E-03,-0.1420E-02,-0.3482E-02,-0.6445E-02,
     *-0.1029E-01,-0.1501E-01,-0.2056E-01,-0.2692E-01,-0.3407E-01,
     *-0.4197E-01,-0.5059E-01,-0.5989E-01,-0.6984E-01,-0.8041E-01,
     *-0.9156E-01,-0.1032E+00,-0.1154E+00,-0.1281E+00,-0.1412E+00,
     *-0.1547E+00,-0.1686E+00,-0.1828E+00,-0.1972E+00,-0.2119E+00,
     *-0.2269E+00,-0.2419E+00,-0.2571E+00,-0.2724E+00,-0.2877E+00,
     *-0.3030E+00,-0.3183E+00,-0.3334E+00,-0.3483E+00,-0.3631E+00,
     *-0.3775E+00,-0.3917E+00,-0.4054E+00,-0.4187E+00,-0.4314E+00,
     *-0.4436E+00,-0.4494E+00,-0.4551E+00,-0.4659E+00,-0.4758E+00,
     *-0.4849E+00,-0.4930E+00,-0.5001E+00,-0.5060E+00,-0.5108E+00,
     *-0.5142E+00,-0.5163E+00,-0.5169E+00,-0.5160E+00,-0.5135E+00,
     *-0.5093E+00,-0.5034E+00,-0.4957E+00,-0.4861E+00,-0.4747E+00,
     *-0.4613E+00,-0.4461E+00,-0.4289E+00,-0.4099E+00,-0.3891E+00,
     *-0.3665E+00,-0.3424E+00,-0.3169E+00,-0.2902E+00,-0.2624E+00,
     *-0.2340E+00,-0.2053E+00,-0.1766E+00,-0.1483E+00,-0.1210E+00,
     *-0.9520E-01,-0.7139E-01,-0.5016E-01,-0.3205E-01,-0.1760E-01,
     *-0.7263E-02,-0.1390E-02, 0.8561E-20 /
        DATA ((QHR(i,j),j=1,83),i= 4, 4)/
     * 0.5940E-22,-0.2822E-03,-0.1485E-02,-0.3643E-02,-0.6744E-02,
     *-0.1077E-01,-0.1571E-01,-0.2153E-01,-0.2820E-01,-0.3570E-01,
     *-0.4399E-01,-0.5304E-01,-0.6281E-01,-0.7327E-01,-0.8438E-01,
     *-0.9610E-01,-0.1084E+00,-0.1212E+00,-0.1345E+00,-0.1483E+00,
     *-0.1625E+00,-0.1771E+00,-0.1920E+00,-0.2071E+00,-0.2225E+00,
     *-0.2382E+00,-0.2539E+00,-0.2698E+00,-0.2857E+00,-0.3016E+00,
     *-0.3175E+00,-0.3333E+00,-0.3489E+00,-0.3643E+00,-0.3794E+00,
     *-0.3942E+00,-0.4086E+00,-0.4225E+00,-0.4359E+00,-0.4487E+00,
     *-0.4609E+00,-0.4667E+00,-0.4723E+00,-0.4829E+00,-0.4925E+00,
     *-0.5012E+00,-0.5089E+00,-0.5154E+00,-0.5207E+00,-0.5248E+00,
     *-0.5274E+00,-0.5286E+00,-0.5283E+00,-0.5264E+00,-0.5228E+00,
     *-0.5175E+00,-0.5104E+00,-0.5015E+00,-0.4908E+00,-0.4781E+00,
     *-0.4636E+00,-0.4471E+00,-0.4289E+00,-0.4088E+00,-0.3871E+00,
     *-0.3637E+00,-0.3388E+00,-0.3127E+00,-0.2855E+00,-0.2575E+00,
     *-0.2290E+00,-0.2003E+00,-0.1718E+00,-0.1439E+00,-0.1171E+00,
     *-0.9186E-01,-0.6871E-01,-0.4816E-01,-0.3071E-01,-0.1684E-01,
     *-0.6937E-02,-0.1326E-02, 0.1225E-19 /
        DATA ((QHR(i,j),j=1,83),i= 5, 5)/
     * 0.1282E-20,-0.2925E-03,-0.1539E-02,-0.3775E-02,-0.6990E-02,
     *-0.1117E-01,-0.1629E-01,-0.2232E-01,-0.2925E-01,-0.3704E-01,
     *-0.4565E-01,-0.5506E-01,-0.6522E-01,-0.7609E-01,-0.8765E-01,
     *-0.9984E-01,-0.1126E+00,-0.1260E+00,-0.1398E+00,-0.1541E+00,
     *-0.1689E+00,-0.1840E+00,-0.1995E+00,-0.2152E+00,-0.2312E+00,
     *-0.2474E+00,-0.2637E+00,-0.2801E+00,-0.2965E+00,-0.3129E+00,
     *-0.3292E+00,-0.3454E+00,-0.3614E+00,-0.3772E+00,-0.3926E+00,
     *-0.4076E+00,-0.4222E+00,-0.4363E+00,-0.4498E+00,-0.4626E+00,
     *-0.4747E+00,-0.4805E+00,-0.4860E+00,-0.4964E+00,-0.5058E+00,
     *-0.5142E+00,-0.5215E+00,-0.5275E+00,-0.5323E+00,-0.5357E+00,
     *-0.5377E+00,-0.5382E+00,-0.5371E+00,-0.5344E+00,-0.5300E+00,
     *-0.5237E+00,-0.5157E+00,-0.5059E+00,-0.4942E+00,-0.4806E+00,
     *-0.4651E+00,-0.4478E+00,-0.4287E+00,-0.4078E+00,-0.3853E+00,
     *-0.3613E+00,-0.3359E+00,-0.3094E+00,-0.2819E+00,-0.2537E+00,
     *-0.2251E+00,-0.1964E+00,-0.1681E+00,-0.1405E+00,-0.1141E+00,
     *-0.8934E-01,-0.6670E-01,-0.4667E-01,-0.2971E-01,-0.1627E-01,
     *-0.6697E-02,-0.1279E-02,-0.7240E-20 /
        DATA ((QHR(i,j),j=1,83),i= 6, 6)/
     * 0.1097E-20,-0.2990E-03,-0.1574E-02,-0.3861E-02,-0.7148E-02,
     *-0.1142E-01,-0.1666E-01,-0.2284E-01,-0.2993E-01,-0.3790E-01,
     *-0.4672E-01,-0.5635E-01,-0.6675E-01,-0.7789E-01,-0.8973E-01,
     *-0.1022E+00,-0.1153E+00,-0.1290E+00,-0.1432E+00,-0.1578E+00,
     *-0.1729E+00,-0.1884E+00,-0.2042E+00,-0.2203E+00,-0.2367E+00,
     *-0.2532E+00,-0.2698E+00,-0.2866E+00,-0.3033E+00,-0.3200E+00,
     *-0.3366E+00,-0.3531E+00,-0.3693E+00,-0.3853E+00,-0.4009E+00,
     *-0.4161E+00,-0.4308E+00,-0.4449E+00,-0.4585E+00,-0.4713E+00,
     *-0.4834E+00,-0.4891E+00,-0.4945E+00,-0.5048E+00,-0.5141E+00,
     *-0.5223E+00,-0.5293E+00,-0.5350E+00,-0.5395E+00,-0.5425E+00,
     *-0.5441E+00,-0.5441E+00,-0.5425E+00,-0.5393E+00,-0.5343E+00,
     *-0.5275E+00,-0.5189E+00,-0.5085E+00,-0.4962E+00,-0.4820E+00,
     *-0.4659E+00,-0.4481E+00,-0.4284E+00,-0.4071E+00,-0.3842E+00,
     *-0.3598E+00,-0.3341E+00,-0.3073E+00,-0.2796E+00,-0.2513E+00,
     *-0.2227E+00,-0.1941E+00,-0.1659E+00,-0.1385E+00,-0.1123E+00,
     *-0.8783E-01,-0.6549E-01,-0.4578E-01,-0.2912E-01,-0.1593E-01,
     *-0.6555E-02,-0.1252E-02,-0.3342E-20 /
        DATA ((QHR(i,j),j=1,83),i= 7, 7)/
     *-0.6691E-21,-0.3084E-03,-0.1623E-02,-0.3981E-02,-0.7372E-02,
     *-0.1178E-01,-0.1718E-01,-0.2356E-01,-0.3088E-01,-0.3911E-01,
     *-0.4822E-01,-0.5817E-01,-0.6892E-01,-0.8043E-01,-0.9266E-01,
     *-0.1056E+00,-0.1191E+00,-0.1332E+00,-0.1479E+00,-0.1630E+00,
     *-0.1786E+00,-0.1946E+00,-0.2109E+00,-0.2275E+00,-0.2444E+00,
     *-0.2614E+00,-0.2785E+00,-0.2957E+00,-0.3129E+00,-0.3300E+00,
     *-0.3470E+00,-0.3638E+00,-0.3803E+00,-0.3966E+00,-0.4124E+00,
     *-0.4278E+00,-0.4427E+00,-0.4569E+00,-0.4705E+00,-0.4833E+00,
     *-0.4952E+00,-0.5009E+00,-0.5063E+00,-0.5164E+00,-0.5254E+00,
     *-0.5332E+00,-0.5398E+00,-0.5452E+00,-0.5491E+00,-0.5516E+00,
     *-0.5526E+00,-0.5519E+00,-0.5496E+00,-0.5456E+00,-0.5399E+00,
     *-0.5323E+00,-0.5229E+00,-0.5116E+00,-0.4985E+00,-0.4835E+00,
     *-0.4667E+00,-0.4481E+00,-0.4277E+00,-0.4058E+00,-0.3823E+00,
     *-0.3574E+00,-0.3313E+00,-0.3041E+00,-0.2762E+00,-0.2478E+00,
     *-0.2192E+00,-0.1907E+00,-0.1627E+00,-0.1356E+00,-0.1098E+00,
     *-0.8571E-01,-0.6382E-01,-0.4454E-01,-0.2830E-01,-0.1547E-01,
     *-0.6359E-02,-0.1214E-02, 0.3529E-20 /
        DATA ((QHR(i,j),j=1,83),i= 8, 8)/
     * 0.1880E-20,-0.3196E-03,-0.1682E-02,-0.4127E-02,-0.7643E-02,
     *-0.1221E-01,-0.1782E-01,-0.2443E-01,-0.3203E-01,-0.4057E-01,
     *-0.5003E-01,-0.6036E-01,-0.7153E-01,-0.8348E-01,-0.9619E-01,
     *-0.1096E+00,-0.1237E+00,-0.1383E+00,-0.1535E+00,-0.1693E+00,
     *-0.1854E+00,-0.2020E+00,-0.2189E+00,-0.2361E+00,-0.2535E+00,
     *-0.2711E+00,-0.2888E+00,-0.3065E+00,-0.3242E+00,-0.3418E+00,
     *-0.3592E+00,-0.3765E+00,-0.3934E+00,-0.4099E+00,-0.4260E+00,
     *-0.4416E+00,-0.4566E+00,-0.4709E+00,-0.4845E+00,-0.4973E+00,
     *-0.5091E+00,-0.5147E+00,-0.5200E+00,-0.5298E+00,-0.5384E+00,
     *-0.5459E+00,-0.5520E+00,-0.5568E+00,-0.5601E+00,-0.5619E+00,
     *-0.5621E+00,-0.5607E+00,-0.5575E+00,-0.5526E+00,-0.5459E+00,
     *-0.5374E+00,-0.5271E+00,-0.5148E+00,-0.5007E+00,-0.4848E+00,
     *-0.4671E+00,-0.4476E+00,-0.4265E+00,-0.4038E+00,-0.3796E+00,
     *-0.3542E+00,-0.3277E+00,-0.3002E+00,-0.2721E+00,-0.2436E+00,
     *-0.2150E+00,-0.1867E+00,-0.1589E+00,-0.1322E+00,-0.1068E+00,
     *-0.8324E-01,-0.6187E-01,-0.4312E-01,-0.2736E-01,-0.1494E-01,
     *-0.6136E-02,-0.1171E-02, 0.4275E-20 /
        DATA ((QHR(i,j),j=1,83),i= 9, 9)/
     * 0.7396E-21,-0.3322E-03,-0.1749E-02,-0.4290E-02,-0.7945E-02,
     *-0.1270E-01,-0.1853E-01,-0.2541E-01,-0.3331E-01,-0.4220E-01,
     *-0.5204E-01,-0.6279E-01,-0.7442E-01,-0.8687E-01,-0.1001E+00,
     *-0.1141E+00,-0.1287E+00,-0.1440E+00,-0.1598E+00,-0.1761E+00,
     *-0.1930E+00,-0.2102E+00,-0.2277E+00,-0.2456E+00,-0.2636E+00,
     *-0.2818E+00,-0.3001E+00,-0.3184E+00,-0.3366E+00,-0.3547E+00,
     *-0.3727E+00,-0.3903E+00,-0.4076E+00,-0.4245E+00,-0.4409E+00,
     *-0.4567E+00,-0.4718E+00,-0.4862E+00,-0.4998E+00,-0.5125E+00,
     *-0.5242E+00,-0.5297E+00,-0.5348E+00,-0.5444E+00,-0.5526E+00,
     *-0.5596E+00,-0.5652E+00,-0.5694E+00,-0.5721E+00,-0.5731E+00,
     *-0.5725E+00,-0.5703E+00,-0.5662E+00,-0.5604E+00,-0.5527E+00,
     *-0.5432E+00,-0.5318E+00,-0.5186E+00,-0.5035E+00,-0.4866E+00,
     *-0.4680E+00,-0.4476E+00,-0.4257E+00,-0.4022E+00,-0.3774E+00,
     *-0.3514E+00,-0.3244E+00,-0.2966E+00,-0.2683E+00,-0.2397E+00,
     *-0.2111E+00,-0.1829E+00,-0.1554E+00,-0.1290E+00,-0.1041E+00,
     *-0.8096E-01,-0.6008E-01,-0.4181E-01,-0.2649E-01,-0.1445E-01,
     *-0.5930E-02,-0.1131E-02,-0.1693E-20 /
        DATA ((QHR(i,j),j=1,83),i=10,10)/
     *-0.6344E-21,-0.3452E-03,-0.1817E-02,-0.4459E-02,-0.8258E-02,
     *-0.1320E-01,-0.1926E-01,-0.2641E-01,-0.3463E-01,-0.4388E-01,
     *-0.5412E-01,-0.6530E-01,-0.7740E-01,-0.9035E-01,-0.1041E+00,
     *-0.1186E+00,-0.1339E+00,-0.1497E+00,-0.1662E+00,-0.1832E+00,
     *-0.2007E+00,-0.2185E+00,-0.2367E+00,-0.2552E+00,-0.2739E+00,
     *-0.2927E+00,-0.3116E+00,-0.3305E+00,-0.3493E+00,-0.3679E+00,
     *-0.3863E+00,-0.4044E+00,-0.4220E+00,-0.4393E+00,-0.4559E+00,
     *-0.4719E+00,-0.4872E+00,-0.5017E+00,-0.5152E+00,-0.5278E+00,
     *-0.5394E+00,-0.5448E+00,-0.5498E+00,-0.5590E+00,-0.5669E+00,
     *-0.5735E+00,-0.5785E+00,-0.5821E+00,-0.5841E+00,-0.5844E+00,
     *-0.5830E+00,-0.5799E+00,-0.5750E+00,-0.5682E+00,-0.5596E+00,
     *-0.5491E+00,-0.5367E+00,-0.5225E+00,-0.5065E+00,-0.4886E+00,
     *-0.4691E+00,-0.4479E+00,-0.4251E+00,-0.4010E+00,-0.3755E+00,
     *-0.3490E+00,-0.3216E+00,-0.2935E+00,-0.2649E+00,-0.2362E+00,
     *-0.2077E+00,-0.1796E+00,-0.1523E+00,-0.1262E+00,-0.1016E+00,
     *-0.7894E-01,-0.5849E-01,-0.4065E-01,-0.2573E-01,-0.1402E-01,
     *-0.5751E-02,-0.1096E-02,-0.4113E-20 /
        DATA ((QHR(i,j),j=1,83),i=11,11)/
     *-0.1154E-20,-0.3557E-03,-0.1872E-02,-0.4593E-02,-0.8508E-02,
     *-0.1360E-01,-0.1984E-01,-0.2722E-01,-0.3569E-01,-0.4522E-01,
     *-0.5577E-01,-0.6731E-01,-0.7977E-01,-0.9313E-01,-0.1073E+00,
     *-0.1223E+00,-0.1380E+00,-0.1543E+00,-0.1713E+00,-0.1888E+00,
     *-0.2068E+00,-0.2251E+00,-0.2439E+00,-0.2628E+00,-0.2820E+00,
     *-0.3013E+00,-0.3207E+00,-0.3400E+00,-0.3592E+00,-0.3782E+00,
     *-0.3970E+00,-0.4154E+00,-0.4333E+00,-0.4508E+00,-0.4676E+00,
     *-0.4837E+00,-0.4991E+00,-0.5136E+00,-0.5272E+00,-0.5397E+00,
     *-0.5511E+00,-0.5564E+00,-0.5613E+00,-0.5703E+00,-0.5778E+00,
     *-0.5840E+00,-0.5886E+00,-0.5917E+00,-0.5931E+00,-0.5929E+00,
     *-0.5908E+00,-0.5870E+00,-0.5814E+00,-0.5739E+00,-0.5645E+00,
     *-0.5533E+00,-0.5402E+00,-0.5252E+00,-0.5084E+00,-0.4898E+00,
     *-0.4696E+00,-0.4477E+00,-0.4244E+00,-0.3997E+00,-0.3738E+00,
     *-0.3469E+00,-0.3192E+00,-0.2908E+00,-0.2622E+00,-0.2335E+00,
     *-0.2049E+00,-0.1770E+00,-0.1499E+00,-0.1240E+00,-0.9976E-01,
     *-0.7738E-01,-0.5728E-01,-0.3977E-01,-0.2515E-01,-0.1369E-01,
     *-0.5614E-02,-0.1070E-02,-0.6524E-20 /
        DATA ((QHR(i,j),j=1,83),i=12,12)/
     * 0.2554E-21,-0.3620E-03,-0.1906E-02,-0.4675E-02,-0.8660E-02,
     *-0.1384E-01,-0.2020E-01,-0.2771E-01,-0.3633E-01,-0.4603E-01,
     *-0.5678E-01,-0.6852E-01,-0.8121E-01,-0.9481E-01,-0.1093E+00,
     *-0.1245E+00,-0.1405E+00,-0.1571E+00,-0.1744E+00,-0.1922E+00,
     *-0.2104E+00,-0.2291E+00,-0.2481E+00,-0.2674E+00,-0.2869E+00,
     *-0.3065E+00,-0.3261E+00,-0.3457E+00,-0.3652E+00,-0.3844E+00,
     *-0.4034E+00,-0.4220E+00,-0.4401E+00,-0.4576E+00,-0.4746E+00,
     *-0.4908E+00,-0.5062E+00,-0.5207E+00,-0.5342E+00,-0.5467E+00,
     *-0.5580E+00,-0.5632E+00,-0.5681E+00,-0.5768E+00,-0.5842E+00,
     *-0.5901E+00,-0.5945E+00,-0.5972E+00,-0.5983E+00,-0.5977E+00,
     *-0.5953E+00,-0.5911E+00,-0.5850E+00,-0.5771E+00,-0.5672E+00,
     *-0.5555E+00,-0.5419E+00,-0.5265E+00,-0.5093E+00,-0.4903E+00,
     *-0.4697E+00,-0.4474E+00,-0.4238E+00,-0.3988E+00,-0.3726E+00,
     *-0.3455E+00,-0.3176E+00,-0.2892E+00,-0.2604E+00,-0.2317E+00,
     *-0.2032E+00,-0.1754E+00,-0.1484E+00,-0.1227E+00,-0.9861E-01,
     *-0.7644E-01,-0.5654E-01,-0.3923E-01,-0.2480E-01,-0.1350E-01,
     *-0.5533E-02,-0.1054E-02, 0.1626E-20 /
        DATA ((QHR(i,j),j=1,83),i=13,13)/
     * 0.4116E-22,-0.3790E-03,-0.1995E-02,-0.4895E-02,-0.9068E-02,
     *-0.1449E-01,-0.2115E-01,-0.2901E-01,-0.3804E-01,-0.4821E-01,
     *-0.5946E-01,-0.7176E-01,-0.8506E-01,-0.9929E-01,-0.1144E+00,
     *-0.1304E+00,-0.1471E+00,-0.1645E+00,-0.1825E+00,-0.2011E+00,
     *-0.2202E+00,-0.2397E+00,-0.2595E+00,-0.2796E+00,-0.2998E+00,
     *-0.3202E+00,-0.3405E+00,-0.3608E+00,-0.3809E+00,-0.4007E+00,
     *-0.4202E+00,-0.4393E+00,-0.4578E+00,-0.4757E+00,-0.4929E+00,
     *-0.5093E+00,-0.5248E+00,-0.5393E+00,-0.5528E+00,-0.5651E+00,
     *-0.5761E+00,-0.5811E+00,-0.5858E+00,-0.5941E+00,-0.6010E+00,
     *-0.6062E+00,-0.6099E+00,-0.6118E+00,-0.6120E+00,-0.6105E+00,
     *-0.6071E+00,-0.6018E+00,-0.5946E+00,-0.5855E+00,-0.5746E+00,
     *-0.5617E+00,-0.5469E+00,-0.5304E+00,-0.5120E+00,-0.4920E+00,
     *-0.4703E+00,-0.4472E+00,-0.4226E+00,-0.3969E+00,-0.3701E+00,
     *-0.3424E+00,-0.3141E+00,-0.2854E+00,-0.2565E+00,-0.2277E+00,
     *-0.1993E+00,-0.1717E+00,-0.1450E+00,-0.1197E+00,-0.9599E-01,
     *-0.7429E-01,-0.5487E-01,-0.3802E-01,-0.2401E-01,-0.1305E-01,
     *-0.5347E-02,-0.1019E-02, 0.8105E-21 /
        DATA ((QHR(i,j),j=1,83),i=14,14)/
     * 0.2315E-20,-0.4024E-03,-0.2118E-02,-0.5198E-02,-0.9628E-02,
     *-0.1539E-01,-0.2246E-01,-0.3081E-01,-0.4040E-01,-0.5119E-01,
     *-0.6314E-01,-0.7620E-01,-0.9031E-01,-0.1054E+00,-0.1215E+00,
     *-0.1384E+00,-0.1561E+00,-0.1745E+00,-0.1936E+00,-0.2132E+00,
     *-0.2334E+00,-0.2540E+00,-0.2748E+00,-0.2960E+00,-0.3172E+00,
     *-0.3386E+00,-0.3598E+00,-0.3810E+00,-0.4019E+00,-0.4225E+00,
     *-0.4427E+00,-0.4623E+00,-0.4813E+00,-0.4996E+00,-0.5171E+00,
     *-0.5337E+00,-0.5493E+00,-0.5638E+00,-0.5770E+00,-0.5890E+00,
     *-0.5997E+00,-0.6045E+00,-0.6089E+00,-0.6165E+00,-0.6226E+00,
     *-0.6270E+00,-0.6296E+00,-0.6305E+00,-0.6295E+00,-0.6267E+00,
     *-0.6219E+00,-0.6152E+00,-0.6066E+00,-0.5961E+00,-0.5836E+00,
     *-0.5692E+00,-0.5530E+00,-0.5349E+00,-0.5152E+00,-0.4938E+00,
     *-0.4709E+00,-0.4466E+00,-0.4210E+00,-0.3943E+00,-0.3668E+00,
     *-0.3385E+00,-0.3097E+00,-0.2806E+00,-0.2516E+00,-0.2228E+00,
     *-0.1945E+00,-0.1671E+00,-0.1408E+00,-0.1160E+00,-0.9283E-01,
     *-0.7171E-01,-0.5287E-01,-0.3658E-01,-0.2307E-01,-0.1253E-01,
     *-0.5129E-02,-0.9767E-03, 0.1071E-20 /
        DATA ((QHR(i,j),j=1,83),i=15,15)/
     * 0.1785E-20,-0.4690E-03,-0.2469E-02,-0.6057E-02,-0.1122E-01,
     *-0.1793E-01,-0.2616E-01,-0.3588E-01,-0.4703E-01,-0.5958E-01,
     *-0.7346E-01,-0.8861E-01,-0.1050E+00,-0.1225E+00,-0.1410E+00,
     *-0.1605E+00,-0.1809E+00,-0.2021E+00,-0.2239E+00,-0.2464E+00,
     *-0.2693E+00,-0.2926E+00,-0.3162E+00,-0.3400E+00,-0.3638E+00,
     *-0.3875E+00,-0.4110E+00,-0.4342E+00,-0.4571E+00,-0.4793E+00,
     *-0.5009E+00,-0.5217E+00,-0.5417E+00,-0.5606E+00,-0.5784E+00,
     *-0.5950E+00,-0.6103E+00,-0.6242E+00,-0.6365E+00,-0.6473E+00,
     *-0.6564E+00,-0.6602E+00,-0.6637E+00,-0.6692E+00,-0.6728E+00,
     *-0.6744E+00,-0.6741E+00,-0.6718E+00,-0.6674E+00,-0.6610E+00,
     *-0.6526E+00,-0.6421E+00,-0.6297E+00,-0.6153E+00,-0.5990E+00,
     *-0.5808E+00,-0.5609E+00,-0.5394E+00,-0.5163E+00,-0.4919E+00,
     *-0.4662E+00,-0.4393E+00,-0.4116E+00,-0.3831E+00,-0.3541E+00,
     *-0.3247E+00,-0.2952E+00,-0.2659E+00,-0.2370E+00,-0.2086E+00,
     *-0.1811E+00,-0.1547E+00,-0.1297E+00,-0.1063E+00,-0.8467E-01,
     *-0.6512E-01,-0.4783E-01,-0.3298E-01,-0.2074E-01,-0.1124E-01,
     *-0.4594E-02,-0.8741E-03,-0.2349E-20 /
        DATA ((QHR(i,j),j=1,83),i=16,16)/
     *-0.1552E-21,-0.5045E-03,-0.2655E-02,-0.6514E-02,-0.1206E-01,
     *-0.1928E-01,-0.2813E-01,-0.3856E-01,-0.5054E-01,-0.6400E-01,
     *-0.7889E-01,-0.9513E-01,-0.1126E+00,-0.1313E+00,-0.1512E+00,
     *-0.1720E+00,-0.1937E+00,-0.2162E+00,-0.2395E+00,-0.2633E+00,
     *-0.2876E+00,-0.3122E+00,-0.3371E+00,-0.3621E+00,-0.3870E+00,
     *-0.4118E+00,-0.4363E+00,-0.4604E+00,-0.4840E+00,-0.5069E+00,
     *-0.5290E+00,-0.5502E+00,-0.5703E+00,-0.5893E+00,-0.6071E+00,
     *-0.6234E+00,-0.6383E+00,-0.6516E+00,-0.6633E+00,-0.6732E+00,
     *-0.6812E+00,-0.6845E+00,-0.6874E+00,-0.6916E+00,-0.6938E+00,
     *-0.6939E+00,-0.6920E+00,-0.6880E+00,-0.6819E+00,-0.6737E+00,
     *-0.6634E+00,-0.6511E+00,-0.6368E+00,-0.6206E+00,-0.6025E+00,
     *-0.5827E+00,-0.5612E+00,-0.5381E+00,-0.5137E+00,-0.4880E+00,
     *-0.4611E+00,-0.4334E+00,-0.4049E+00,-0.3758E+00,-0.3463E+00,
     *-0.3168E+00,-0.2872E+00,-0.2580E+00,-0.2293E+00,-0.2014E+00,
     *-0.1744E+00,-0.1487E+00,-0.1244E+00,-0.1017E+00,-0.8086E-01,
     *-0.6209E-01,-0.4553E-01,-0.3136E-01,-0.1970E-01,-0.1067E-01,
     *-0.4357E-02,-0.8287E-03, 0.2536E-20 /
        DATA ((QHR(i,j),j=1,83),i=17,17)/
     * 0.5632E-21,-0.5159E-03,-0.2715E-02,-0.6661E-02,-0.1234E-01,
     *-0.1971E-01,-0.2876E-01,-0.3943E-01,-0.5167E-01,-0.6542E-01,
     *-0.8063E-01,-0.9722E-01,-0.1151E+00,-0.1342E+00,-0.1544E+00,
     *-0.1756E+00,-0.1978E+00,-0.2208E+00,-0.2444E+00,-0.2687E+00,
     *-0.2934E+00,-0.3184E+00,-0.3437E+00,-0.3690E+00,-0.3943E+00,
     *-0.4194E+00,-0.4442E+00,-0.4686E+00,-0.4924E+00,-0.5155E+00,
     *-0.5377E+00,-0.5590E+00,-0.5792E+00,-0.5982E+00,-0.6159E+00,
     *-0.6322E+00,-0.6469E+00,-0.6600E+00,-0.6714E+00,-0.6810E+00,
     *-0.6888E+00,-0.6919E+00,-0.6946E+00,-0.6983E+00,-0.7001E+00,
     *-0.6998E+00,-0.6973E+00,-0.6928E+00,-0.6861E+00,-0.6774E+00,
     *-0.6665E+00,-0.6537E+00,-0.6388E+00,-0.6221E+00,-0.6035E+00,
     *-0.5831E+00,-0.5612E+00,-0.5377E+00,-0.5128E+00,-0.4868E+00,
     *-0.4596E+00,-0.4316E+00,-0.4029E+00,-0.3737E+00,-0.3441E+00,
     *-0.3145E+00,-0.2850E+00,-0.2558E+00,-0.2272E+00,-0.1993E+00,
     *-0.1725E+00,-0.1470E+00,-0.1229E+00,-0.1004E+00,-0.7981E-01,
     *-0.6125E-01,-0.4490E-01,-0.3091E-01,-0.1941E-01,-0.1051E-01,
     *-0.4292E-02,-0.8162E-03, 0.1507E-21 /
        DATA ((QHR(i,j),j=1,83),i=18,18)/
     * 0.7582E-21,-0.5405E-03,-0.2845E-02,-0.6979E-02,-0.1292E-01,
     *-0.2065E-01,-0.3012E-01,-0.4128E-01,-0.5409E-01,-0.6848E-01,
     *-0.8438E-01,-0.1017E+00,-0.1204E+00,-0.1403E+00,-0.1614E+00,
     *-0.1835E+00,-0.2065E+00,-0.2304E+00,-0.2550E+00,-0.2801E+00,
     *-0.3057E+00,-0.3316E+00,-0.3576E+00,-0.3837E+00,-0.4097E+00,
     *-0.4355E+00,-0.4609E+00,-0.4857E+00,-0.5099E+00,-0.5333E+00,
     *-0.5558E+00,-0.5773E+00,-0.5975E+00,-0.6165E+00,-0.6340E+00,
     *-0.6500E+00,-0.6644E+00,-0.6770E+00,-0.6878E+00,-0.6968E+00,
     *-0.7037E+00,-0.7064E+00,-0.7087E+00,-0.7115E+00,-0.7123E+00,
     *-0.7109E+00,-0.7074E+00,-0.7017E+00,-0.6939E+00,-0.6840E+00,
     *-0.6720E+00,-0.6580E+00,-0.6420E+00,-0.6241E+00,-0.6044E+00,
     *-0.5831E+00,-0.5602E+00,-0.5358E+00,-0.5102E+00,-0.4834E+00,
     *-0.4557E+00,-0.4272E+00,-0.3981E+00,-0.3686E+00,-0.3389E+00,
     *-0.3092E+00,-0.2798E+00,-0.2507E+00,-0.2224E+00,-0.1949E+00,
     *-0.1684E+00,-0.1433E+00,-0.1196E+00,-0.9766E-01,-0.7755E-01,
     *-0.5946E-01,-0.4355E-01,-0.2996E-01,-0.1880E-01,-0.1018E-01,
     *-0.4155E-02,-0.7900E-03,-0.5265E-20 /
        DATA ((QHR(i,j),j=1,83),i=19,19)/
     *-0.3864E-21,-0.5597E-03,-0.2946E-02,-0.7226E-02,-0.1338E-01,
     *-0.2138E-01,-0.3118E-01,-0.4273E-01,-0.5597E-01,-0.7085E-01,
     *-0.8727E-01,-0.1052E+00,-0.1244E+00,-0.1450E+00,-0.1667E+00,
     *-0.1895E+00,-0.2132E+00,-0.2378E+00,-0.2630E+00,-0.2888E+00,
     *-0.3150E+00,-0.3416E+00,-0.3682E+00,-0.3949E+00,-0.4214E+00,
     *-0.4476E+00,-0.4734E+00,-0.4986E+00,-0.5230E+00,-0.5466E+00,
     *-0.5693E+00,-0.5907E+00,-0.6110E+00,-0.6298E+00,-0.6472E+00,
     *-0.6629E+00,-0.6770E+00,-0.6892E+00,-0.6995E+00,-0.7079E+00,
     *-0.7143E+00,-0.7167E+00,-0.7185E+00,-0.7207E+00,-0.7207E+00,
     *-0.7185E+00,-0.7141E+00,-0.7076E+00,-0.6989E+00,-0.6881E+00,
     *-0.6752E+00,-0.6603E+00,-0.6435E+00,-0.6248E+00,-0.6044E+00,
     *-0.5823E+00,-0.5588E+00,-0.5338E+00,-0.5077E+00,-0.4804E+00,
     *-0.4523E+00,-0.4235E+00,-0.3942E+00,-0.3646E+00,-0.3348E+00,
     *-0.3051E+00,-0.2758E+00,-0.2469E+00,-0.2187E+00,-0.1915E+00,
     *-0.1654E+00,-0.1405E+00,-0.1172E+00,-0.9564E-01,-0.7589E-01,
     *-0.5815E-01,-0.4257E-01,-0.2927E-01,-0.1836E-01,-0.9935E-02,
     *-0.4055E-02,-0.7710E-03, 0.2937E-20 /
        DATA ((QHR(i,j),j=1,83),i=20,20)/
     *-0.3946E-21,-0.6127E-03,-0.3225E-02,-0.7908E-02,-0.1464E-01,
     *-0.2338E-01,-0.3409E-01,-0.4669E-01,-0.6114E-01,-0.7733E-01,
     *-0.9520E-01,-0.1146E+00,-0.1355E+00,-0.1577E+00,-0.1812E+00,
     *-0.2057E+00,-0.2312E+00,-0.2575E+00,-0.2845E+00,-0.3120E+00,
     *-0.3398E+00,-0.3678E+00,-0.3959E+00,-0.4238E+00,-0.4514E+00,
     *-0.4786E+00,-0.5052E+00,-0.5311E+00,-0.5560E+00,-0.5798E+00,
     *-0.6025E+00,-0.6238E+00,-0.6436E+00,-0.6619E+00,-0.6784E+00,
     *-0.6932E+00,-0.7060E+00,-0.7168E+00,-0.7256E+00,-0.7322E+00,
     *-0.7367E+00,-0.7381E+00,-0.7390E+00,-0.7390E+00,-0.7368E+00,
     *-0.7324E+00,-0.7257E+00,-0.7168E+00,-0.7058E+00,-0.6927E+00,
     *-0.6776E+00,-0.6605E+00,-0.6416E+00,-0.6210E+00,-0.5988E+00,
     *-0.5751E+00,-0.5500E+00,-0.5238E+00,-0.4966E+00,-0.4685E+00,
     *-0.4397E+00,-0.4105E+00,-0.3809E+00,-0.3512E+00,-0.3216E+00,
     *-0.2923E+00,-0.2635E+00,-0.2353E+00,-0.2079E+00,-0.1816E+00,
     *-0.1565E+00,-0.1327E+00,-0.1105E+00,-0.8997E-01,-0.7127E-01,
     *-0.5453E-01,-0.3987E-01,-0.2739E-01,-0.1717E-01,-0.9281E-02,
     *-0.3786E-02,-0.7197E-03,-0.1517E-20 /
c************** MIE (phase fun uh) ***************
        DATA ((UHR(i,j),j=1,83),i= 1, 1)/
     *-0.4446E+00,-0.4445E+00,-0.4440E+00,-0.4431E+00,-0.4418E+00,
     *-0.4401E+00,-0.4380E+00,-0.4355E+00,-0.4325E+00,-0.4291E+00,
     *-0.4253E+00,-0.4209E+00,-0.4160E+00,-0.4106E+00,-0.4047E+00,
     *-0.3982E+00,-0.3910E+00,-0.3833E+00,-0.3749E+00,-0.3658E+00,
     *-0.3560E+00,-0.3455E+00,-0.3341E+00,-0.3219E+00,-0.3088E+00,
     *-0.2948E+00,-0.2798E+00,-0.2637E+00,-0.2465E+00,-0.2281E+00,
     *-0.2084E+00,-0.1873E+00,-0.1648E+00,-0.1408E+00,-0.1151E+00,
     *-0.8759E-01,-0.5824E-01,-0.2689E-01, 0.6618E-02, 0.4241E-01,
     * 0.8066E-01, 0.1007E+00, 0.1215E+00, 0.1652E+00, 0.2118E+00,
     * 0.2615E+00, 0.3147E+00, 0.3714E+00, 0.4319E+00, 0.4964E+00,
     * 0.5652E+00, 0.6386E+00, 0.7166E+00, 0.7998E+00, 0.8881E+00,
     * 0.9821E+00, 0.1082E+01, 0.1187E+01, 0.1299E+01, 0.1418E+01,
     * 0.1543E+01, 0.1674E+01, 0.1813E+01, 0.1958E+01, 0.2110E+01,
     * 0.2268E+01, 0.2433E+01, 0.2603E+01, 0.2779E+01, 0.2958E+01,
     * 0.3141E+01, 0.3326E+01, 0.3510E+01, 0.3692E+01, 0.3870E+01,
     * 0.4039E+01, 0.4198E+01, 0.4342E+01, 0.4467E+01, 0.4568E+01,
     * 0.4642E+01, 0.4685E+01, 0.4695E+01 /
        DATA ((UHR(i,j),j=1,83),i= 2, 2)/
     *-0.4907E+00,-0.4905E+00,-0.4900E+00,-0.4890E+00,-0.4875E+00,
     *-0.4856E+00,-0.4832E+00,-0.4803E+00,-0.4770E+00,-0.4731E+00,
     *-0.4687E+00,-0.4637E+00,-0.4582E+00,-0.4521E+00,-0.4454E+00,
     *-0.4380E+00,-0.4300E+00,-0.4212E+00,-0.4118E+00,-0.4016E+00,
     *-0.3906E+00,-0.3787E+00,-0.3660E+00,-0.3524E+00,-0.3378E+00,
     *-0.3222E+00,-0.3054E+00,-0.2876E+00,-0.2686E+00,-0.2482E+00,
     *-0.2266E+00,-0.2035E+00,-0.1789E+00,-0.1527E+00,-0.1247E+00,
     *-0.9501E-01,-0.6336E-01,-0.2968E-01, 0.6164E-02, 0.4430E-01,
     * 0.8486E-01, 0.1061E+00, 0.1280E+00, 0.1739E+00, 0.2226E+00,
     * 0.2744E+00, 0.3294E+00, 0.3879E+00, 0.4499E+00, 0.5157E+00,
     * 0.5854E+00, 0.6593E+00, 0.7375E+00, 0.8203E+00, 0.9078E+00,
     * 0.1000E+01, 0.1098E+01, 0.1200E+01, 0.1308E+01, 0.1422E+01,
     * 0.1540E+01, 0.1665E+01, 0.1794E+01, 0.1929E+01, 0.2070E+01,
     * 0.2215E+01, 0.2364E+01, 0.2517E+01, 0.2674E+01, 0.2832E+01,
     * 0.2992E+01, 0.3152E+01, 0.3310E+01, 0.3465E+01, 0.3615E+01,
     * 0.3756E+01, 0.3887E+01, 0.4004E+01, 0.4104E+01, 0.4185E+01,
     * 0.4244E+01, 0.4277E+01, 0.4285E+01 /
        DATA ((UHR(i,j),j=1,83),i= 3, 3)/
     *-0.5012E+00,-0.5010E+00,-0.5005E+00,-0.4994E+00,-0.4979E+00,
     *-0.4960E+00,-0.4935E+00,-0.4905E+00,-0.4871E+00,-0.4831E+00,
     *-0.4786E+00,-0.4735E+00,-0.4678E+00,-0.4615E+00,-0.4546E+00,
     *-0.4470E+00,-0.4388E+00,-0.4298E+00,-0.4201E+00,-0.4097E+00,
     *-0.3984E+00,-0.3863E+00,-0.3732E+00,-0.3593E+00,-0.3443E+00,
     *-0.3283E+00,-0.3112E+00,-0.2930E+00,-0.2735E+00,-0.2528E+00,
     *-0.2307E+00,-0.2071E+00,-0.1821E+00,-0.1554E+00,-0.1270E+00,
     *-0.9675E-01,-0.6460E-01,-0.3042E-01, 0.5929E-02, 0.4456E-01,
     * 0.8562E-01, 0.1071E+00, 0.1292E+00, 0.1756E+00, 0.2248E+00,
     * 0.2770E+00, 0.3324E+00, 0.3912E+00, 0.4535E+00, 0.5195E+00,
     * 0.5894E+00, 0.6633E+00, 0.7415E+00, 0.8242E+00, 0.9114E+00,
     * 0.1003E+01, 0.1100E+01, 0.1202E+01, 0.1309E+01, 0.1421E+01,
     * 0.1539E+01, 0.1662E+01, 0.1789E+01, 0.1922E+01, 0.2060E+01,
     * 0.2202E+01, 0.2348E+01, 0.2498E+01, 0.2650E+01, 0.2805E+01,
     * 0.2960E+01, 0.3115E+01, 0.3268E+01, 0.3418E+01, 0.3561E+01,
     * 0.3697E+01, 0.3823E+01, 0.3935E+01, 0.4031E+01, 0.4108E+01,
     * 0.4163E+01, 0.4195E+01, 0.4203E+01 /
        DATA ((UHR(i,j),j=1,83),i= 4, 4)/
     *-0.5274E+00,-0.5272E+00,-0.5266E+00,-0.5255E+00,-0.5239E+00,
     *-0.5218E+00,-0.5191E+00,-0.5160E+00,-0.5123E+00,-0.5080E+00,
     *-0.5031E+00,-0.4977E+00,-0.4916E+00,-0.4849E+00,-0.4776E+00,
     *-0.4695E+00,-0.4607E+00,-0.4512E+00,-0.4409E+00,-0.4297E+00,
     *-0.4178E+00,-0.4049E+00,-0.3911E+00,-0.3763E+00,-0.3605E+00,
     *-0.3436E+00,-0.3256E+00,-0.3064E+00,-0.2859E+00,-0.2641E+00,
     *-0.2409E+00,-0.2163E+00,-0.1901E+00,-0.1622E+00,-0.1326E+00,
     *-0.1012E+00,-0.6781E-01,-0.3241E-01, 0.5143E-02, 0.4498E-01,
     * 0.8721E-01, 0.1093E+00, 0.1320E+00, 0.1794E+00, 0.2296E+00,
     * 0.2828E+00, 0.3391E+00, 0.3986E+00, 0.4616E+00, 0.5281E+00,
     * 0.5983E+00, 0.6723E+00, 0.7504E+00, 0.8327E+00, 0.9192E+00,
     * 0.1010E+01, 0.1106E+01, 0.1206E+01, 0.1310E+01, 0.1420E+01,
     * 0.1534E+01, 0.1653E+01, 0.1776E+01, 0.1904E+01, 0.2035E+01,
     * 0.2171E+01, 0.2309E+01, 0.2451E+01, 0.2594E+01, 0.2738E+01,
     * 0.2883E+01, 0.3027E+01, 0.3168E+01, 0.3305E+01, 0.3436E+01,
     * 0.3559E+01, 0.3673E+01, 0.3773E+01, 0.3859E+01, 0.3928E+01,
     * 0.3977E+01, 0.4005E+01, 0.4012E+01 /
        DATA ((UHR(i,j),j=1,83),i= 5, 5)/
     *-0.5491E+00,-0.5490E+00,-0.5483E+00,-0.5472E+00,-0.5455E+00,
     *-0.5432E+00,-0.5404E+00,-0.5371E+00,-0.5332E+00,-0.5287E+00,
     *-0.5235E+00,-0.5178E+00,-0.5114E+00,-0.5043E+00,-0.4966E+00,
     *-0.4881E+00,-0.4789E+00,-0.4688E+00,-0.4580E+00,-0.4463E+00,
     *-0.4338E+00,-0.4203E+00,-0.4058E+00,-0.3904E+00,-0.3739E+00,
     *-0.3562E+00,-0.3374E+00,-0.3174E+00,-0.2961E+00,-0.2735E+00,
     *-0.2494E+00,-0.2238E+00,-0.1967E+00,-0.1679E+00,-0.1373E+00,
     *-0.1049E+00,-0.7061E-01,-0.3424E-01, 0.4279E-02, 0.4506E-01,
     * 0.8821E-01, 0.1107E+00, 0.1339E+00, 0.1821E+00, 0.2332E+00,
     * 0.2871E+00, 0.3440E+00, 0.4041E+00, 0.4675E+00, 0.5343E+00,
     * 0.6047E+00, 0.6788E+00, 0.7567E+00, 0.8385E+00, 0.9244E+00,
     * 0.1014E+01, 0.1109E+01, 0.1207E+01, 0.1310E+01, 0.1417E+01,
     * 0.1529E+01, 0.1644E+01, 0.1764E+01, 0.1887E+01, 0.2014E+01,
     * 0.2144E+01, 0.2277E+01, 0.2412E+01, 0.2548E+01, 0.2685E+01,
     * 0.2822E+01, 0.2957E+01, 0.3089E+01, 0.3217E+01, 0.3339E+01,
     * 0.3453E+01, 0.3558E+01, 0.3650E+01, 0.3729E+01, 0.3791E+01,
     * 0.3836E+01, 0.3862E+01, 0.3868E+01 /
        DATA ((UHR(i,j),j=1,83),i= 6, 6)/
     *-0.5632E+00,-0.5630E+00,-0.5623E+00,-0.5611E+00,-0.5593E+00,
     *-0.5570E+00,-0.5541E+00,-0.5507E+00,-0.5466E+00,-0.5419E+00,
     *-0.5366E+00,-0.5307E+00,-0.5241E+00,-0.5168E+00,-0.5088E+00,
     *-0.5000E+00,-0.4905E+00,-0.4802E+00,-0.4690E+00,-0.4570E+00,
     *-0.4440E+00,-0.4302E+00,-0.4153E+00,-0.3994E+00,-0.3824E+00,
     *-0.3643E+00,-0.3450E+00,-0.3245E+00,-0.3027E+00,-0.2795E+00,
     *-0.2548E+00,-0.2287E+00,-0.2009E+00,-0.1715E+00,-0.1404E+00,
     *-0.1074E+00,-0.7246E-01,-0.3549E-01, 0.3626E-02, 0.4499E-01,
     * 0.8871E-01, 0.1115E+00, 0.1349E+00, 0.1837E+00, 0.2352E+00,
     * 0.2896E+00, 0.3469E+00, 0.4073E+00, 0.4710E+00, 0.5380E+00,
     * 0.6084E+00, 0.6825E+00, 0.7602E+00, 0.8418E+00, 0.9272E+00,
     * 0.1017E+01, 0.1110E+01, 0.1208E+01, 0.1309E+01, 0.1415E+01,
     * 0.1525E+01, 0.1638E+01, 0.1756E+01, 0.1876E+01, 0.2000E+01,
     * 0.2127E+01, 0.2256E+01, 0.2387E+01, 0.2519E+01, 0.2652E+01,
     * 0.2783E+01, 0.2913E+01, 0.3040E+01, 0.3163E+01, 0.3279E+01,
     * 0.3388E+01, 0.3488E+01, 0.3575E+01, 0.3650E+01, 0.3709E+01,
     * 0.3751E+01, 0.3775E+01, 0.3781E+01 /
        DATA ((UHR(i,j),j=1,83),i= 7, 7)/
     *-0.5829E+00,-0.5827E+00,-0.5820E+00,-0.5807E+00,-0.5789E+00,
     *-0.5764E+00,-0.5734E+00,-0.5697E+00,-0.5655E+00,-0.5606E+00,
     *-0.5550E+00,-0.5488E+00,-0.5419E+00,-0.5343E+00,-0.5259E+00,
     *-0.5167E+00,-0.5068E+00,-0.4960E+00,-0.4844E+00,-0.4718E+00,
     *-0.4583E+00,-0.4439E+00,-0.4284E+00,-0.4119E+00,-0.3943E+00,
     *-0.3755E+00,-0.3555E+00,-0.3342E+00,-0.3116E+00,-0.2876E+00,
     *-0.2622E+00,-0.2353E+00,-0.2067E+00,-0.1765E+00,-0.1445E+00,
     *-0.1106E+00,-0.7482E-01,-0.3700E-01, 0.2946E-02, 0.4512E-01,
     * 0.8964E-01, 0.1128E+00, 0.1366E+00, 0.1861E+00, 0.2383E+00,
     * 0.2932E+00, 0.3511E+00, 0.4119E+00, 0.4759E+00, 0.5431E+00,
     * 0.6136E+00, 0.6876E+00, 0.7651E+00, 0.8462E+00, 0.9311E+00,
     * 0.1020E+01, 0.1112E+01, 0.1208E+01, 0.1308E+01, 0.1412E+01,
     * 0.1519E+01, 0.1630E+01, 0.1744E+01, 0.1861E+01, 0.1981E+01,
     * 0.2103E+01, 0.2228E+01, 0.2353E+01, 0.2480E+01, 0.2606E+01,
     * 0.2731E+01, 0.2854E+01, 0.2974E+01, 0.3089E+01, 0.3199E+01,
     * 0.3300E+01, 0.3393E+01, 0.3474E+01, 0.3543E+01, 0.3598E+01,
     * 0.3637E+01, 0.3659E+01, 0.3664E+01 /
        DATA ((UHR(i,j),j=1,83),i= 8, 8)/
     *-0.6066E+00,-0.6064E+00,-0.6057E+00,-0.6043E+00,-0.6024E+00,
     *-0.5998E+00,-0.5966E+00,-0.5927E+00,-0.5882E+00,-0.5830E+00,
     *-0.5772E+00,-0.5706E+00,-0.5633E+00,-0.5552E+00,-0.5464E+00,
     *-0.5367E+00,-0.5263E+00,-0.5149E+00,-0.5027E+00,-0.4895E+00,
     *-0.4754E+00,-0.4602E+00,-0.4440E+00,-0.4267E+00,-0.4083E+00,
     *-0.3887E+00,-0.3678E+00,-0.3457E+00,-0.3222E+00,-0.2972E+00,
     *-0.2708E+00,-0.2429E+00,-0.2134E+00,-0.1821E+00,-0.1491E+00,
     *-0.1142E+00,-0.7744E-01,-0.3862E-01, 0.2302E-02, 0.4543E-01,
     * 0.9086E-01, 0.1145E+00, 0.1387E+00, 0.1890E+00, 0.2419E+00,
     * 0.2976E+00, 0.3560E+00, 0.4173E+00, 0.4816E+00, 0.5490E+00,
     * 0.6196E+00, 0.6934E+00, 0.7706E+00, 0.8512E+00, 0.9352E+00,
     * 0.1023E+01, 0.1114E+01, 0.1208E+01, 0.1306E+01, 0.1407E+01,
     * 0.1511E+01, 0.1619E+01, 0.1729E+01, 0.1842E+01, 0.1958E+01,
     * 0.2075E+01, 0.2194E+01, 0.2313E+01, 0.2433E+01, 0.2552E+01,
     * 0.2670E+01, 0.2785E+01, 0.2897E+01, 0.3005E+01, 0.3106E+01,
     * 0.3200E+01, 0.3285E+01, 0.3360E+01, 0.3423E+01, 0.3473E+01,
     * 0.3508E+01, 0.3528E+01, 0.3533E+01 /
        DATA ((UHR(i,j),j=1,83),i= 9, 9)/
     *-0.6338E+00,-0.6336E+00,-0.6328E+00,-0.6314E+00,-0.6293E+00,
     *-0.6265E+00,-0.6231E+00,-0.6190E+00,-0.6142E+00,-0.6087E+00,
     *-0.6025E+00,-0.5955E+00,-0.5878E+00,-0.5792E+00,-0.5699E+00,
     *-0.5597E+00,-0.5486E+00,-0.5367E+00,-0.5237E+00,-0.5099E+00,
     *-0.4950E+00,-0.4791E+00,-0.4620E+00,-0.4439E+00,-0.4246E+00,
     *-0.4041E+00,-0.3823E+00,-0.3591E+00,-0.3346E+00,-0.3087E+00,
     *-0.2813E+00,-0.2523E+00,-0.2217E+00,-0.1893E+00,-0.1553E+00,
     *-0.1193E+00,-0.8147E-01,-0.4160E-01, 0.3445E-03, 0.4446E-01,
     * 0.9084E-01, 0.1149E+00, 0.1396E+00, 0.1907E+00, 0.2444E+00,
     * 0.3007E+00, 0.3596E+00, 0.4214E+00, 0.4860E+00, 0.5535E+00,
     * 0.6240E+00, 0.6976E+00, 0.7743E+00, 0.8542E+00, 0.9372E+00,
     * 0.1023E+01, 0.1113E+01, 0.1205E+01, 0.1301E+01, 0.1399E+01,
     * 0.1501E+01, 0.1605E+01, 0.1711E+01, 0.1820E+01, 0.1930E+01,
     * 0.2042E+01, 0.2155E+01, 0.2268E+01, 0.2381E+01, 0.2493E+01,
     * 0.2604E+01, 0.2711E+01, 0.2815E+01, 0.2915E+01, 0.3008E+01,
     * 0.3095E+01, 0.3173E+01, 0.3241E+01, 0.3298E+01, 0.3343E+01,
     * 0.3375E+01, 0.3393E+01, 0.3398E+01 /
        DATA ((UHR(i,j),j=1,83),i=10,10)/
     *-0.6626E+00,-0.6624E+00,-0.6616E+00,-0.6600E+00,-0.6578E+00,
     *-0.6549E+00,-0.6513E+00,-0.6469E+00,-0.6418E+00,-0.6360E+00,
     *-0.6294E+00,-0.6220E+00,-0.6138E+00,-0.6047E+00,-0.5948E+00,
     *-0.5841E+00,-0.5724E+00,-0.5597E+00,-0.5461E+00,-0.5315E+00,
     *-0.5159E+00,-0.4991E+00,-0.4813E+00,-0.4623E+00,-0.4421E+00,
     *-0.4206E+00,-0.3978E+00,-0.3737E+00,-0.3482E+00,-0.3212E+00,
     *-0.2927E+00,-0.2627E+00,-0.2310E+00,-0.1976E+00,-0.1624E+00,
     *-0.1254E+00,-0.8653E-01,-0.4564E-01,-0.2696E-02, 0.4238E-01,
     * 0.8967E-01, 0.1142E+00, 0.1392E+00, 0.1912E+00, 0.2455E+00,
     * 0.3024E+00, 0.3619E+00, 0.4240E+00, 0.4888E+00, 0.5563E+00,
     * 0.6267E+00, 0.7000E+00, 0.7761E+00, 0.8552E+00, 0.9372E+00,
     * 0.1022E+01, 0.1110E+01, 0.1200E+01, 0.1293E+01, 0.1389E+01,
     * 0.1488E+01, 0.1588E+01, 0.1691E+01, 0.1795E+01, 0.1901E+01,
     * 0.2007E+01, 0.2114E+01, 0.2222E+01, 0.2328E+01, 0.2434E+01,
     * 0.2537E+01, 0.2637E+01, 0.2734E+01, 0.2826E+01, 0.2913E+01,
     * 0.2992E+01, 0.3063E+01, 0.3126E+01, 0.3178E+01, 0.3219E+01,
     * 0.3248E+01, 0.3264E+01, 0.3268E+01 /
        DATA ((UHR(i,j),j=1,83),i=11,11)/
     *-0.6857E+00,-0.6855E+00,-0.6846E+00,-0.6830E+00,-0.6807E+00,
     *-0.6776E+00,-0.6738E+00,-0.6692E+00,-0.6639E+00,-0.6578E+00,
     *-0.6508E+00,-0.6431E+00,-0.6345E+00,-0.6251E+00,-0.6147E+00,
     *-0.6035E+00,-0.5913E+00,-0.5781E+00,-0.5639E+00,-0.5487E+00,
     *-0.5324E+00,-0.5151E+00,-0.4965E+00,-0.4768E+00,-0.4559E+00,
     *-0.4336E+00,-0.4101E+00,-0.3852E+00,-0.3589E+00,-0.3311E+00,
     *-0.3018E+00,-0.2709E+00,-0.2383E+00,-0.2041E+00,-0.1681E+00,
     *-0.1302E+00,-0.9049E-01,-0.4880E-01,-0.5080E-02, 0.4074E-01,
     * 0.8872E-01, 0.1135E+00, 0.1389E+00, 0.1914E+00, 0.2463E+00,
     * 0.3036E+00, 0.3634E+00, 0.4258E+00, 0.4907E+00, 0.5583E+00,
     * 0.6285E+00, 0.7015E+00, 0.7771E+00, 0.8555E+00, 0.9366E+00,
     * 0.1020E+01, 0.1107E+01, 0.1196E+01, 0.1287E+01, 0.1381E+01,
     * 0.1477E+01, 0.1574E+01, 0.1674E+01, 0.1775E+01, 0.1877E+01,
     * 0.1980E+01, 0.2083E+01, 0.2185E+01, 0.2287E+01, 0.2387E+01,
     * 0.2486E+01, 0.2581E+01, 0.2672E+01, 0.2759E+01, 0.2840E+01,
     * 0.2914E+01, 0.2981E+01, 0.3039E+01, 0.3088E+01, 0.3126E+01,
     * 0.3152E+01, 0.3168E+01, 0.3171E+01 /
        DATA ((UHR(i,j),j=1,83),i=12,12)/
     *-0.6997E+00,-0.6995E+00,-0.6986E+00,-0.6969E+00,-0.6945E+00,
     *-0.6913E+00,-0.6874E+00,-0.6827E+00,-0.6772E+00,-0.6709E+00,
     *-0.6638E+00,-0.6559E+00,-0.6470E+00,-0.6373E+00,-0.6267E+00,
     *-0.6152E+00,-0.6027E+00,-0.5892E+00,-0.5746E+00,-0.5591E+00,
     *-0.5424E+00,-0.5246E+00,-0.5056E+00,-0.4855E+00,-0.4641E+00,
     *-0.4414E+00,-0.4174E+00,-0.3920E+00,-0.3652E+00,-0.3369E+00,
     *-0.3071E+00,-0.2756E+00,-0.2426E+00,-0.2078E+00,-0.1713E+00,
     *-0.1330E+00,-0.9274E-01,-0.5057E-01,-0.6389E-02, 0.3987E-01,
     * 0.8826E-01, 0.1133E+00, 0.1389E+00, 0.1917E+00, 0.2469E+00,
     * 0.3044E+00, 0.3644E+00, 0.4269E+00, 0.4919E+00, 0.5594E+00,
     * 0.6296E+00, 0.7023E+00, 0.7777E+00, 0.8557E+00, 0.9362E+00,
     * 0.1019E+01, 0.1105E+01, 0.1193E+01, 0.1283E+01, 0.1376E+01,
     * 0.1470E+01, 0.1566E+01, 0.1664E+01, 0.1763E+01, 0.1863E+01,
     * 0.1963E+01, 0.2064E+01, 0.2164E+01, 0.2263E+01, 0.2360E+01,
     * 0.2455E+01, 0.2547E+01, 0.2636E+01, 0.2719E+01, 0.2797E+01,
     * 0.2869E+01, 0.2933E+01, 0.2988E+01, 0.3035E+01, 0.3071E+01,
     * 0.3097E+01, 0.3111E+01, 0.3115E+01 /
        DATA ((UHR(i,j),j=1,83),i=13,13)/
     *-0.7383E+00,-0.7380E+00,-0.7370E+00,-0.7352E+00,-0.7326E+00,
     *-0.7292E+00,-0.7250E+00,-0.7199E+00,-0.7140E+00,-0.7072E+00,
     *-0.6996E+00,-0.6910E+00,-0.6816E+00,-0.6712E+00,-0.6598E+00,
     *-0.6475E+00,-0.6341E+00,-0.6197E+00,-0.6042E+00,-0.5877E+00,
     *-0.5700E+00,-0.5511E+00,-0.5310E+00,-0.5097E+00,-0.4871E+00,
     *-0.4632E+00,-0.4379E+00,-0.4112E+00,-0.3831E+00,-0.3535E+00,
     *-0.3223E+00,-0.2896E+00,-0.2552E+00,-0.2191E+00,-0.1812E+00,
     *-0.1416E+00,-0.1001E+00,-0.5672E-01,-0.1137E-01, 0.3599E-01,
     * 0.8541E-01, 0.1109E+00, 0.1369E+00, 0.1906E+00, 0.2465E+00,
     * 0.3047E+00, 0.3651E+00, 0.4278E+00, 0.4929E+00, 0.5603E+00,
     * 0.6300E+00, 0.7022E+00, 0.7767E+00, 0.8534E+00, 0.9325E+00,
     * 0.1014E+01, 0.1097E+01, 0.1183E+01, 0.1270E+01, 0.1359E+01,
     * 0.1450E+01, 0.1542E+01, 0.1635E+01, 0.1729E+01, 0.1823E+01,
     * 0.1918E+01, 0.2012E+01, 0.2105E+01, 0.2197E+01, 0.2287E+01,
     * 0.2375E+01, 0.2460E+01, 0.2540E+01, 0.2617E+01, 0.2687E+01,
     * 0.2752E+01, 0.2810E+01, 0.2859E+01, 0.2901E+01, 0.2933E+01,
     * 0.2956E+01, 0.2969E+01, 0.2972E+01 /
        DATA ((UHR(i,j),j=1,83),i=14,14)/
     *-0.7925E+00,-0.7922E+00,-0.7911E+00,-0.7891E+00,-0.7863E+00,
     *-0.7825E+00,-0.7778E+00,-0.7722E+00,-0.7657E+00,-0.7583E+00,
     *-0.7498E+00,-0.7405E+00,-0.7301E+00,-0.7187E+00,-0.7063E+00,
     *-0.6928E+00,-0.6782E+00,-0.6625E+00,-0.6457E+00,-0.6278E+00,
     *-0.6086E+00,-0.5882E+00,-0.5666E+00,-0.5436E+00,-0.5194E+00,
     *-0.4938E+00,-0.4668E+00,-0.4383E+00,-0.4084E+00,-0.3770E+00,
     *-0.3440E+00,-0.3095E+00,-0.2733E+00,-0.2354E+00,-0.1958E+00,
     *-0.1545E+00,-0.1113E+00,-0.6637E-01,-0.1952E-01, 0.2924E-01,
     * 0.7994E-01, 0.1060E+00, 0.1326E+00, 0.1873E+00, 0.2440E+00,
     * 0.3028E+00, 0.3637E+00, 0.4266E+00, 0.4916E+00, 0.5586E+00,
     * 0.6278E+00, 0.6989E+00, 0.7721E+00, 0.8472E+00, 0.9241E+00,
     * 0.1003E+01, 0.1083E+01, 0.1165E+01, 0.1249E+01, 0.1333E+01,
     * 0.1419E+01, 0.1506E+01, 0.1593E+01, 0.1680E+01, 0.1768E+01,
     * 0.1855E+01, 0.1941E+01, 0.2026E+01, 0.2110E+01, 0.2191E+01,
     * 0.2270E+01, 0.2345E+01, 0.2417E+01, 0.2484E+01, 0.2546E+01,
     * 0.2603E+01, 0.2653E+01, 0.2696E+01, 0.2732E+01, 0.2760E+01,
     * 0.2780E+01, 0.2791E+01, 0.2793E+01 /
        DATA ((UHR(i,j),j=1,83),i=15,15)/
     *-0.9497E+00,-0.9494E+00,-0.9479E+00,-0.9453E+00,-0.9416E+00,
     *-0.9367E+00,-0.9307E+00,-0.9234E+00,-0.9150E+00,-0.9055E+00,
     *-0.8947E+00,-0.8827E+00,-0.8695E+00,-0.8550E+00,-0.8393E+00,
     *-0.8223E+00,-0.8041E+00,-0.7845E+00,-0.7637E+00,-0.7415E+00,
     *-0.7179E+00,-0.6930E+00,-0.6667E+00,-0.6390E+00,-0.6099E+00,
     *-0.5793E+00,-0.5473E+00,-0.5138E+00,-0.4788E+00,-0.4423E+00,
     *-0.4042E+00,-0.3647E+00,-0.3235E+00,-0.2809E+00,-0.2366E+00,
     *-0.1908E+00,-0.1433E+00,-0.9431E-01,-0.4372E-01, 0.8459E-02,
     * 0.6221E-01, 0.8967E-01, 0.1175E+00, 0.1744E+00, 0.2327E+00,
     * 0.2926E+00, 0.3539E+00, 0.4166E+00, 0.4807E+00, 0.5461E+00,
     * 0.6127E+00, 0.6805E+00, 0.7494E+00, 0.8192E+00, 0.8899E+00,
     * 0.9614E+00, 0.1033E+01, 0.1106E+01, 0.1179E+01, 0.1252E+01,
     * 0.1325E+01, 0.1397E+01, 0.1470E+01, 0.1541E+01, 0.1612E+01,
     * 0.1681E+01, 0.1748E+01, 0.1814E+01, 0.1878E+01, 0.1939E+01,
     * 0.1998E+01, 0.2053E+01, 0.2105E+01, 0.2153E+01, 0.2197E+01,
     * 0.2236E+01, 0.2271E+01, 0.2301E+01, 0.2325E+01, 0.2344E+01,
     * 0.2357E+01, 0.2364E+01, 0.2366E+01 /
        DATA ((UHR(i,j),j=1,83),i=16,16)/
     *-0.1036E+01,-0.1036E+01,-0.1034E+01,-0.1031E+01,-0.1027E+01,
     *-0.1021E+01,-0.1015E+01,-0.1006E+01,-0.9969E+00,-0.9861E+00,
     *-0.9739E+00,-0.9604E+00,-0.9455E+00,-0.9292E+00,-0.9116E+00,
     *-0.8926E+00,-0.8722E+00,-0.8505E+00,-0.8273E+00,-0.8027E+00,
     *-0.7766E+00,-0.7492E+00,-0.7202E+00,-0.6899E+00,-0.6580E+00,
     *-0.6247E+00,-0.5900E+00,-0.5537E+00,-0.5160E+00,-0.4768E+00,
     *-0.4361E+00,-0.3939E+00,-0.3503E+00,-0.3051E+00,-0.2585E+00,
     *-0.2105E+00,-0.1610E+00,-0.1101E+00,-0.5777E-01,-0.4080E-02,
     * 0.5096E-01, 0.7897E-01, 0.1073E+00, 0.1649E+00, 0.2238E+00,
     * 0.2838E+00, 0.3450E+00, 0.4072E+00, 0.4705E+00, 0.5346E+00,
     * 0.5996E+00, 0.6654E+00, 0.7318E+00, 0.7987E+00, 0.8660E+00,
     * 0.9337E+00, 0.1001E+01, 0.1069E+01, 0.1137E+01, 0.1204E+01,
     * 0.1271E+01, 0.1337E+01, 0.1403E+01, 0.1467E+01, 0.1530E+01,
     * 0.1591E+01, 0.1651E+01, 0.1709E+01, 0.1764E+01, 0.1817E+01,
     * 0.1867E+01, 0.1915E+01, 0.1959E+01, 0.1999E+01, 0.2036E+01,
     * 0.2069E+01, 0.2098E+01, 0.2123E+01, 0.2143E+01, 0.2159E+01,
     * 0.2170E+01, 0.2176E+01, 0.2177E+01 /
        DATA ((UHR(i,j),j=1,83),i=17,17)/
     *-0.1065E+01,-0.1065E+01,-0.1063E+01,-0.1060E+01,-0.1056E+01,
     *-0.1050E+01,-0.1043E+01,-0.1034E+01,-0.1025E+01,-0.1013E+01,
     *-0.1001E+01,-0.9865E+00,-0.9711E+00,-0.9542E+00,-0.9360E+00,
     *-0.9163E+00,-0.8952E+00,-0.8727E+00,-0.8487E+00,-0.8233E+00,
     *-0.7964E+00,-0.7681E+00,-0.7383E+00,-0.7071E+00,-0.6743E+00,
     *-0.6401E+00,-0.6045E+00,-0.5673E+00,-0.5287E+00,-0.4886E+00,
     *-0.4471E+00,-0.4041E+00,-0.3596E+00,-0.3137E+00,-0.2664E+00,
     *-0.2177E+00,-0.1676E+00,-0.1161E+00,-0.6327E-01,-0.9138E-02,
     * 0.4626E-01, 0.7443E-01, 0.1029E+00, 0.1607E+00, 0.2197E+00,
     * 0.2797E+00, 0.3408E+00, 0.4028E+00, 0.4658E+00, 0.5295E+00,
     * 0.5939E+00, 0.6589E+00, 0.7245E+00, 0.7905E+00, 0.8568E+00,
     * 0.9232E+00, 0.9896E+00, 0.1056E+01, 0.1122E+01, 0.1188E+01,
     * 0.1253E+01, 0.1317E+01, 0.1380E+01, 0.1442E+01, 0.1503E+01,
     * 0.1562E+01, 0.1620E+01, 0.1675E+01, 0.1728E+01, 0.1779E+01,
     * 0.1827E+01, 0.1872E+01, 0.1914E+01, 0.1952E+01, 0.1987E+01,
     * 0.2018E+01, 0.2046E+01, 0.2069E+01, 0.2088E+01, 0.2103E+01,
     * 0.2113E+01, 0.2119E+01, 0.2120E+01 /
        DATA ((UHR(i,j),j=1,83),i=18,18)/
     *-0.1129E+01,-0.1129E+01,-0.1127E+01,-0.1124E+01,-0.1119E+01,
     *-0.1112E+01,-0.1105E+01,-0.1095E+01,-0.1085E+01,-0.1072E+01,
     *-0.1059E+01,-0.1043E+01,-0.1027E+01,-0.1009E+01,-0.9889E+00,
     *-0.9676E+00,-0.9449E+00,-0.9207E+00,-0.8950E+00,-0.8678E+00,
     *-0.8391E+00,-0.8089E+00,-0.7772E+00,-0.7440E+00,-0.7093E+00,
     *-0.6732E+00,-0.6356E+00,-0.5965E+00,-0.5559E+00,-0.5140E+00,
     *-0.4706E+00,-0.4258E+00,-0.3796E+00,-0.3321E+00,-0.2832E+00,
     *-0.2331E+00,-0.1816E+00,-0.1290E+00,-0.7509E-01,-0.2007E-01,
     * 0.3605E-01, 0.6451E-01, 0.9323E-01, 0.1514E+00, 0.2105E+00,
     * 0.2705E+00, 0.3313E+00, 0.3928E+00, 0.4550E+00, 0.5177E+00,
     * 0.5808E+00, 0.6444E+00, 0.7082E+00, 0.7721E+00, 0.8360E+00,
     * 0.8999E+00, 0.9635E+00, 0.1027E+01, 0.1089E+01, 0.1151E+01,
     * 0.1213E+01, 0.1273E+01, 0.1332E+01, 0.1390E+01, 0.1446E+01,
     * 0.1501E+01, 0.1553E+01, 0.1604E+01, 0.1652E+01, 0.1698E+01,
     * 0.1742E+01, 0.1782E+01, 0.1820E+01, 0.1855E+01, 0.1886E+01,
     * 0.1914E+01, 0.1938E+01, 0.1959E+01, 0.1976E+01, 0.1989E+01,
     * 0.1998E+01, 0.2003E+01, 0.2004E+01 /
        DATA ((UHR(i,j),j=1,83),i=19,19)/
     *-0.1180E+01,-0.1180E+01,-0.1178E+01,-0.1174E+01,-0.1169E+01,
     *-0.1162E+01,-0.1154E+01,-0.1144E+01,-0.1133E+01,-0.1120E+01,
     *-0.1105E+01,-0.1089E+01,-0.1071E+01,-0.1052E+01,-0.1031E+01,
     *-0.1009E+01,-0.9845E+00,-0.9589E+00,-0.9318E+00,-0.9032E+00,
     *-0.8730E+00,-0.8413E+00,-0.8080E+00,-0.7733E+00,-0.7370E+00,
     *-0.6993E+00,-0.6601E+00,-0.6195E+00,-0.5775E+00,-0.5340E+00,
     *-0.4892E+00,-0.4430E+00,-0.3955E+00,-0.3468E+00,-0.2967E+00,
     *-0.2455E+00,-0.1931E+00,-0.1395E+00,-0.8491E-01,-0.2925E-01,
     * 0.2737E-01, 0.5603E-01, 0.8491E-01, 0.1433E+00, 0.2025E+00,
     * 0.2623E+00, 0.3228E+00, 0.3839E+00, 0.4454E+00, 0.5073E+00,
     * 0.5694E+00, 0.6317E+00, 0.6941E+00, 0.7564E+00, 0.8186E+00,
     * 0.8804E+00, 0.9419E+00, 0.1003E+01, 0.1063E+01, 0.1122E+01,
     * 0.1181E+01, 0.1238E+01, 0.1294E+01, 0.1349E+01, 0.1402E+01,
     * 0.1453E+01, 0.1502E+01, 0.1550E+01, 0.1595E+01, 0.1638E+01,
     * 0.1678E+01, 0.1716E+01, 0.1750E+01, 0.1782E+01, 0.1811E+01,
     * 0.1836E+01, 0.1859E+01, 0.1878E+01, 0.1893E+01, 0.1905E+01,
     * 0.1913E+01, 0.1918E+01, 0.1919E+01 /
        DATA ((UHR(i,j),j=1,83),i=20,20)/
     *-0.1325E+01,-0.1324E+01,-0.1322E+01,-0.1317E+01,-0.1311E+01,
     *-0.1303E+01,-0.1294E+01,-0.1282E+01,-0.1268E+01,-0.1253E+01,
     *-0.1236E+01,-0.1217E+01,-0.1196E+01,-0.1173E+01,-0.1149E+01,
     *-0.1122E+01,-0.1095E+01,-0.1065E+01,-0.1034E+01,-0.1001E+01,
     *-0.9662E+00,-0.9301E+00,-0.8924E+00,-0.8531E+00,-0.8124E+00,
     *-0.7702E+00,-0.7266E+00,-0.6817E+00,-0.6354E+00,-0.5878E+00,
     *-0.5390E+00,-0.4890E+00,-0.4380E+00,-0.3858E+00,-0.3327E+00,
     *-0.2786E+00,-0.2236E+00,-0.1679E+00,-0.1114E+00,-0.5422E-01,
     * 0.3521E-02, 0.3259E-01, 0.6177E-01, 0.1204E+00, 0.1794E+00,
     * 0.2387E+00, 0.2981E+00, 0.3577E+00, 0.4171E+00, 0.4765E+00,
     * 0.5357E+00, 0.5945E+00, 0.6530E+00, 0.7109E+00, 0.7682E+00,
     * 0.8248E+00, 0.8805E+00, 0.9353E+00, 0.9890E+00, 0.1042E+01,
     * 0.1093E+01, 0.1143E+01, 0.1191E+01, 0.1238E+01, 0.1283E+01,
     * 0.1327E+01, 0.1368E+01, 0.1408E+01, 0.1445E+01, 0.1480E+01,
     * 0.1513E+01, 0.1544E+01, 0.1572E+01, 0.1597E+01, 0.1620E+01,
     * 0.1641E+01, 0.1658E+01, 0.1673E+01, 0.1685E+01, 0.1695E+01,
     * 0.1701E+01, 0.1705E+01, 0.1706E+01 /


      vi_m=6.05630412E-05
      vi(4)=vi_m
      do 1 i=1,20
       asy(4,i)=asy_m(i)
       ex(4,i)=ex_m(i)
       sc(4,i)=sc_m(i)
      do 1 j=1,nquad
      ph(i,j)=phr(i,j)
      qh(i,j)=qhr(i,j)
      uh(i,j)=uhr(i,j)
    1 continue
      return
      end
