      subroutine   dust

c - to vary the number of quadratures
      include "paramdef.inc"
      integer nquad
      common /num_quad/ nquad
      real ph,qh,uh
      common /sixs_aerbas/ ph(20,nqmax_p),qh(20,nqmax_p),uh(20,nqmax_p)
      real phr(20,nqdef_p),qhr(20,nqdef_p),uhr(20,nqdef_p)
c - to vary the number of quadratures
      real ex,sc,asy,vi
      common /sixs_coef/ ex(4,20),sc(4,20),asy(4,20),vi(4)
      real ex_m(20),sc_m(20),asy_m(20),vi_m
      integer i,j

c Dust model
c Parameters and refractive indices - G.A. d'Almeida, 'Atmospheric
c aerosols. Global climatology and radiative characteristics', 1991.
c Extinction coefficients are calculated in km-1

c*************** MIE (asy) ******************
      data (asy_m(j),j=1,20)/
     a 0.846,0.838,0.836,0.832,0.827,0.826,0.822,0.817,0.812,0.807,
     a 0.802,0.800,0.792,0.785,0.778,0.795,0.808,0.859,0.892,0.853/
c*************** MIE (ext&sca) ******************
        data (ex_m(j),sc_m(j),j=1,20) /
     a 0.8230388E+01,0.5565700E+01,0.8305723E+01,0.5744132E+01,
     a 0.8328883E+01,0.5786949E+01,0.8368396E+01,0.5888061E+01,
     a 0.8415968E+01,0.5976042E+01,0.8428650E+01,0.6028808E+01,
     a 0.8467864E+01,0.6112733E+01,0.8519962E+01,0.6215003E+01,
     a 0.8583242E+01,0.6333235E+01,0.8632867E+01,0.6450123E+01,
     a 0.8689027E+01,0.6547941E+01,0.8704309E+01,0.6603794E+01,
     a 0.8803438E+01,0.6771705E+01,0.8924636E+01,0.7002420E+01,
     a 0.9300344E+01,0.7719834E+01,0.9404915E+01,0.8043072E+01,
     a 0.9368683E+01,0.8084310E+01,0.8811917E+01,0.7738148E+01,
     a 0.7876924E+01,0.6921192E+01,0.7002555E+01,0.6187184E+01 /
c************** MIE (phase fun ph) ***************
        DATA ((PHR(i,j),j=1,83),i= 1, 1)/
     *0.3243E+00,0.3160E+00,0.3591E+00,0.3476E+00,0.3226E+00,
     *0.2902E+00,0.2596E+00,0.2419E+00,0.2232E+00,0.1846E+00,
     *0.1428E+00,0.1168E+00,0.9709E-01,0.8103E-01,0.7004E-01,
     *0.6320E-01,0.5814E-01,0.5326E-01,0.5106E-01,0.4940E-01,
     *0.4870E-01,0.4778E-01,0.4820E-01,0.4788E-01,0.4772E-01,
     *0.4784E-01,0.4869E-01,0.4996E-01,0.5202E-01,0.5280E-01,
     *0.5469E-01,0.5593E-01,0.5910E-01,0.6304E-01,0.6599E-01,
     *0.6985E-01,0.7474E-01,0.8012E-01,0.8582E-01,0.9162E-01,
     *0.9846E-01,0.1009E+00,0.1050E+00,0.1138E+00,0.1246E+00,
     *0.1362E+00,0.1473E+00,0.1611E+00,0.1732E+00,0.1897E+00,
     *0.2101E+00,0.2304E+00,0.2540E+00,0.2787E+00,0.3060E+00,
     *0.3378E+00,0.3659E+00,0.4035E+00,0.4393E+00,0.4858E+00,
     *0.5360E+00,0.5962E+00,0.6485E+00,0.7072E+00,0.7761E+00,
     *0.8649E+00,0.9362E+00,0.1036E+01,0.1154E+01,0.1261E+01,
     *0.1424E+01,0.1594E+01,0.1832E+01,0.2152E+01,0.2617E+01,
     *0.3335E+01,0.4608E+01,0.7076E+01,0.1268E+02,0.2842E+02,
     *0.8963E+02,0.5463E+03,0.5621E+04 /
        DATA ((PHR(i,j),j=1,83),i= 2, 2)/
     *0.3504E+00,0.3410E+00,0.3912E+00,0.3864E+00,0.3531E+00,
     *0.3218E+00,0.2983E+00,0.2747E+00,0.2390E+00,0.1973E+00,
     *0.1651E+00,0.1363E+00,0.1080E+00,0.8892E-01,0.7840E-01,
     *0.7077E-01,0.6358E-01,0.5933E-01,0.5510E-01,0.5225E-01,
     *0.5194E-01,0.5138E-01,0.5099E-01,0.5019E-01,0.5009E-01,
     *0.4996E-01,0.5225E-01,0.5356E-01,0.5519E-01,0.5641E-01,
     *0.5805E-01,0.6066E-01,0.6323E-01,0.6633E-01,0.6987E-01,
     *0.7371E-01,0.7894E-01,0.8533E-01,0.9124E-01,0.9803E-01,
     *0.1067E+00,0.1112E+00,0.1168E+00,0.1253E+00,0.1344E+00,
     *0.1455E+00,0.1616E+00,0.1759E+00,0.1898E+00,0.2075E+00,
     *0.2249E+00,0.2462E+00,0.2702E+00,0.2948E+00,0.3259E+00,
     *0.3559E+00,0.3928E+00,0.4306E+00,0.4753E+00,0.5264E+00,
     *0.5803E+00,0.6330E+00,0.6854E+00,0.7571E+00,0.8406E+00,
     *0.9153E+00,0.1007E+01,0.1116E+01,0.1225E+01,0.1362E+01,
     *0.1534E+01,0.1730E+01,0.1992E+01,0.2347E+01,0.2856E+01,
     *0.3662E+01,0.5080E+01,0.7789E+01,0.1392E+02,0.3064E+02,
     *0.9319E+02,0.5223E+03,0.4201E+04 /
        DATA ((PHR(i,j),j=1,83),i= 3, 3)/
     *0.3625E+00,0.3534E+00,0.4034E+00,0.3995E+00,0.3637E+00,
     *0.3363E+00,0.3122E+00,0.2775E+00,0.2391E+00,0.2059E+00,
     *0.1719E+00,0.1389E+00,0.1102E+00,0.9256E-01,0.8045E-01,
     *0.7120E-01,0.6493E-01,0.6051E-01,0.5595E-01,0.5397E-01,
     *0.5247E-01,0.5160E-01,0.5119E-01,0.5069E-01,0.5103E-01,
     *0.5174E-01,0.5266E-01,0.5382E-01,0.5511E-01,0.5686E-01,
     *0.5922E-01,0.6272E-01,0.6472E-01,0.6745E-01,0.7095E-01,
     *0.7540E-01,0.8057E-01,0.8557E-01,0.9202E-01,0.9913E-01,
     *0.1079E+00,0.1131E+00,0.1180E+00,0.1280E+00,0.1375E+00,
     *0.1498E+00,0.1650E+00,0.1798E+00,0.1974E+00,0.2154E+00,
     *0.2317E+00,0.2535E+00,0.2763E+00,0.3028E+00,0.3322E+00,
     *0.3624E+00,0.4018E+00,0.4391E+00,0.4861E+00,0.5328E+00,
     *0.5849E+00,0.6330E+00,0.6967E+00,0.7683E+00,0.8482E+00,
     *0.9209E+00,0.1022E+01,0.1127E+01,0.1239E+01,0.1390E+01,
     *0.1552E+01,0.1763E+01,0.2026E+01,0.2388E+01,0.2909E+01,
     *0.3740E+01,0.5173E+01,0.7947E+01,0.1419E+02,0.3113E+02,
     *0.9392E+02,0.5162E+03,0.3938E+04 /
        DATA ((PHR(i,j),j=1,83),i= 4, 4)/
     *0.3853E+00,0.3726E+00,0.4175E+00,0.4135E+00,0.3787E+00,
     *0.3464E+00,0.3207E+00,0.2931E+00,0.2550E+00,0.2139E+00,
     *0.1797E+00,0.1483E+00,0.1176E+00,0.9732E-01,0.8530E-01,
     *0.7638E-01,0.6854E-01,0.6361E-01,0.5873E-01,0.5571E-01,
     *0.5508E-01,0.5421E-01,0.5365E-01,0.5277E-01,0.5261E-01,
     *0.5262E-01,0.5491E-01,0.5623E-01,0.5787E-01,0.5919E-01,
     *0.6104E-01,0.6405E-01,0.6664E-01,0.6981E-01,0.7354E-01,
     *0.7771E-01,0.8325E-01,0.8967E-01,0.9601E-01,0.1033E+00,
     *0.1124E+00,0.1174E+00,0.1232E+00,0.1323E+00,0.1420E+00,
     *0.1538E+00,0.1704E+00,0.1854E+00,0.2008E+00,0.2193E+00,
     *0.2374E+00,0.2597E+00,0.2847E+00,0.3109E+00,0.3431E+00,
     *0.3746E+00,0.4137E+00,0.4531E+00,0.5002E+00,0.5529E+00,
     *0.6089E+00,0.6637E+00,0.7219E+00,0.7969E+00,0.8836E+00,
     *0.9625E+00,0.1062E+01,0.1176E+01,0.1292E+01,0.1441E+01,
     *0.1623E+01,0.1836E+01,0.2118E+01,0.2502E+01,0.3052E+01,
     *0.3928E+01,0.5455E+01,0.8364E+01,0.1487E+02,0.3227E+02,
     *0.9521E+02,0.4992E+03,0.3362E+04 /
        DATA ((PHR(i,j),j=1,83),i= 5, 5)/
     *0.4323E+00,0.4130E+00,0.4481E+00,0.4391E+00,0.4030E+00,
     *0.3689E+00,0.3346E+00,0.2956E+00,0.2650E+00,0.2299E+00,
     *0.1895E+00,0.1499E+00,0.1248E+00,0.1054E+00,0.8953E-01,
     *0.7772E-01,0.7041E-01,0.6557E-01,0.6245E-01,0.5991E-01,
     *0.5656E-01,0.5516E-01,0.5353E-01,0.5403E-01,0.5539E-01,
     *0.5675E-01,0.5634E-01,0.5705E-01,0.5789E-01,0.6072E-01,
     *0.6362E-01,0.6673E-01,0.6976E-01,0.7261E-01,0.7714E-01,
     *0.8242E-01,0.8687E-01,0.9191E-01,0.9852E-01,0.1069E+00,
     *0.1152E+00,0.1203E+00,0.1243E+00,0.1357E+00,0.1478E+00,
     *0.1610E+00,0.1739E+00,0.1898E+00,0.2107E+00,0.2298E+00,
     *0.2505E+00,0.2740E+00,0.2986E+00,0.3278E+00,0.3570E+00,
     *0.3904E+00,0.4300E+00,0.4704E+00,0.5168E+00,0.5611E+00,
     *0.6133E+00,0.6722E+00,0.7469E+00,0.8190E+00,0.8945E+00,
     *0.9850E+00,0.1095E+01,0.1201E+01,0.1334E+01,0.1497E+01,
     *0.1665E+01,0.1902E+01,0.2191E+01,0.2582E+01,0.3169E+01,
     *0.4088E+01,0.5645E+01,0.8690E+01,0.1539E+02,0.3319E+02,
     *0.9627E+02,0.4844E+03,0.2954E+04 /
        DATA ((PHR(i,j),j=1,83),i= 6, 6)/
     *0.4322E+00,0.4125E+00,0.4415E+00,0.4331E+00,0.4048E+00,
     *0.3649E+00,0.3299E+00,0.3059E+00,0.2776E+00,0.2307E+00,
     *0.1899E+00,0.1577E+00,0.1289E+00,0.1059E+00,0.9193E-01,
     *0.8229E-01,0.7362E-01,0.6746E-01,0.6315E-01,0.5925E-01,
     *0.5816E-01,0.5746E-01,0.5736E-01,0.5622E-01,0.5591E-01,
     *0.5538E-01,0.5713E-01,0.5920E-01,0.6115E-01,0.6213E-01,
     *0.6397E-01,0.6597E-01,0.6955E-01,0.7405E-01,0.7774E-01,
     *0.8200E-01,0.8777E-01,0.9513E-01,0.1018E+00,0.1088E+00,
     *0.1176E+00,0.1215E+00,0.1269E+00,0.1371E+00,0.1480E+00,
     *0.1606E+00,0.1760E+00,0.1924E+00,0.2063E+00,0.2261E+00,
     *0.2484E+00,0.2719E+00,0.2982E+00,0.3259E+00,0.3598E+00,
     *0.3945E+00,0.4314E+00,0.4746E+00,0.5205E+00,0.5758E+00,
     *0.6349E+00,0.6999E+00,0.7585E+00,0.8360E+00,0.9231E+00,
     *0.1018E+01,0.1115E+01,0.1236E+01,0.1371E+01,0.1516E+01,
     *0.1714E+01,0.1937E+01,0.2240E+01,0.2658E+01,0.3255E+01,
     *0.4189E+01,0.5828E+01,0.8933E+01,0.1574E+02,0.3370E+02,
     *0.9650E+02,0.4742E+03,0.2722E+04 /
        DATA ((PHR(i,j),j=1,83),i= 7, 7)/
     *0.4427E+00,0.4235E+00,0.4548E+00,0.4487E+00,0.4149E+00,
     *0.3774E+00,0.3463E+00,0.3185E+00,0.2823E+00,0.2372E+00,
     *0.2001E+00,0.1664E+00,0.1339E+00,0.1105E+00,0.9644E-01,
     *0.8606E-01,0.7676E-01,0.7074E-01,0.6528E-01,0.6130E-01,
     *0.6028E-01,0.5938E-01,0.5857E-01,0.5750E-01,0.5712E-01,
     *0.5693E-01,0.5924E-01,0.6095E-01,0.6269E-01,0.6402E-01,
     *0.6583E-01,0.6862E-01,0.7187E-01,0.7560E-01,0.7968E-01,
     *0.8408E-01,0.8997E-01,0.9726E-01,0.1040E+00,0.1117E+00,
     *0.1213E+00,0.1263E+00,0.1323E+00,0.1421E+00,0.1526E+00,
     *0.1652E+00,0.1823E+00,0.1986E+00,0.2143E+00,0.2342E+00,
     *0.2549E+00,0.2788E+00,0.3057E+00,0.3338E+00,0.3684E+00,
     *0.4027E+00,0.4431E+00,0.4859E+00,0.5350E+00,0.5914E+00,
     *0.6516E+00,0.7137E+00,0.7757E+00,0.8562E+00,0.9480E+00,
     *0.1039E+01,0.1145E+01,0.1269E+01,0.1401E+01,0.1560E+01,
     *0.1762E+01,0.1999E+01,0.2313E+01,0.2745E+01,0.3363E+01,
     *0.4342E+01,0.6041E+01,0.9239E+01,0.1624E+02,0.3442E+02,
     *0.9688E+02,0.4597E+03,0.2420E+04 /
        DATA ((PHR(i,j),j=1,83),i= 8, 8)/
     *0.4960E+00,0.4724E+00,0.4868E+00,0.4722E+00,0.4366E+00,
     *0.3942E+00,0.3518E+00,0.3219E+00,0.2946E+00,0.2565E+00,
     *0.2072E+00,0.1679E+00,0.1415E+00,0.1205E+00,0.1019E+00,
     *0.8837E-01,0.7963E-01,0.7300E-01,0.6925E-01,0.6632E-01,
     *0.6339E-01,0.6103E-01,0.5995E-01,0.6034E-01,0.5995E-01,
     *0.6075E-01,0.6106E-01,0.6174E-01,0.6349E-01,0.6621E-01,
     *0.6858E-01,0.7111E-01,0.7485E-01,0.7902E-01,0.8400E-01,
     *0.8898E-01,0.9450E-01,0.1006E+00,0.1081E+00,0.1161E+00,
     *0.1238E+00,0.1283E+00,0.1329E+00,0.1444E+00,0.1591E+00,
     *0.1731E+00,0.1860E+00,0.2023E+00,0.2216E+00,0.2414E+00,
     *0.2662E+00,0.2908E+00,0.3190E+00,0.3495E+00,0.3812E+00,
     *0.4204E+00,0.4577E+00,0.5039E+00,0.5500E+00,0.6028E+00,
     *0.6593E+00,0.7294E+00,0.8073E+00,0.8843E+00,0.9682E+00,
     *0.1073E+01,0.1179E+01,0.1307E+01,0.1456E+01,0.1621E+01,
     *0.1821E+01,0.2071E+01,0.2399E+01,0.2844E+01,0.3503E+01,
     *0.4528E+01,0.6274E+01,0.9620E+01,0.1680E+02,0.3529E+02,
     *0.9725E+02,0.4413E+03,0.2096E+04 /
        DATA ((PHR(i,j),j=1,83),i= 9, 9)/
     *0.5164E+00,0.4898E+00,0.5048E+00,0.4920E+00,0.4535E+00,
     *0.4158E+00,0.3775E+00,0.3353E+00,0.3016E+00,0.2648E+00,
     *0.2222E+00,0.1798E+00,0.1499E+00,0.1266E+00,0.1077E+00,
     *0.9357E-01,0.8409E-01,0.7747E-01,0.7286E-01,0.6935E-01,
     *0.6534E-01,0.6333E-01,0.6142E-01,0.6153E-01,0.6279E-01,
     *0.6407E-01,0.6367E-01,0.6438E-01,0.6546E-01,0.6841E-01,
     *0.7172E-01,0.7521E-01,0.7843E-01,0.8167E-01,0.8663E-01,
     *0.9257E-01,0.9782E-01,0.1034E+00,0.1107E+00,0.1199E+00,
     *0.1294E+00,0.1349E+00,0.1395E+00,0.1518E+00,0.1649E+00,
     *0.1796E+00,0.1944E+00,0.2118E+00,0.2338E+00,0.2546E+00,
     *0.2767E+00,0.3023E+00,0.3296E+00,0.3616E+00,0.3939E+00,
     *0.4303E+00,0.4737E+00,0.5181E+00,0.5693E+00,0.6201E+00,
     *0.6798E+00,0.7450E+00,0.8255E+00,0.9060E+00,0.9940E+00,
     *0.1096E+01,0.1217E+01,0.1341E+01,0.1493E+01,0.1679E+01,
     *0.1881E+01,0.2155E+01,0.2498E+01,0.2962E+01,0.3656E+01,
     *0.4736E+01,0.6551E+01,0.1001E+02,0.1740E+02,0.3608E+02,
     *0.9721E+02,0.4211E+03,0.1798E+04 /
        DATA ((PHR(i,j),j=1,83),i=10,10)/
     *0.5181E+00,0.4938E+00,0.5082E+00,0.4987E+00,0.4599E+00,
     *0.4226E+00,0.3885E+00,0.3506E+00,0.3106E+00,0.2717E+00,
     *0.2321E+00,0.1928E+00,0.1568E+00,0.1316E+00,0.1139E+00,
     *0.1003E+00,0.8989E-01,0.8219E-01,0.7531E-01,0.7122E-01,
     *0.6883E-01,0.6691E-01,0.6558E-01,0.6441E-01,0.6427E-01,
     *0.6474E-01,0.6628E-01,0.6768E-01,0.6929E-01,0.7105E-01,
     *0.7377E-01,0.7767E-01,0.8059E-01,0.8416E-01,0.8859E-01,
     *0.9403E-01,0.1004E+00,0.1069E+00,0.1145E+00,0.1234E+00,
     *0.1341E+00,0.1400E+00,0.1460E+00,0.1573E+00,0.1691E+00,
     *0.1837E+00,0.2016E+00,0.2190E+00,0.2387E+00,0.2603E+00,
     *0.2813E+00,0.3073E+00,0.3360E+00,0.3677E+00,0.4031E+00,
     *0.4403E+00,0.4856E+00,0.5309E+00,0.5851E+00,0.6432E+00,
     *0.7082E+00,0.7732E+00,0.8490E+00,0.9353E+00,0.1034E+01,
     *0.1134E+01,0.1258E+01,0.1392E+01,0.1543E+01,0.1733E+01,
     *0.1957E+01,0.2236E+01,0.2599E+01,0.3098E+01,0.3816E+01,
     *0.4950E+01,0.6868E+01,0.1043E+02,0.1800E+02,0.3673E+02,
     *0.9655E+02,0.3996E+03,0.1542E+04 /
        DATA ((PHR(i,j),j=1,83),i=11,11)/
     *0.5654E+00,0.5352E+00,0.5364E+00,0.5185E+00,0.4779E+00,
     *0.4371E+00,0.3962E+00,0.3542E+00,0.3207E+00,0.2835E+00,
     *0.2396E+00,0.1962E+00,0.1648E+00,0.1396E+00,0.1190E+00,
     *0.1033E+00,0.9258E-01,0.8497E-01,0.7979E-01,0.7564E-01,
     *0.7122E-01,0.6867E-01,0.6649E-01,0.6643E-01,0.6760E-01,
     *0.6877E-01,0.6842E-01,0.6902E-01,0.7022E-01,0.7329E-01,
     *0.7671E-01,0.8028E-01,0.8373E-01,0.8727E-01,0.9258E-01,
     *0.9880E-01,0.1043E+00,0.1104E+00,0.1180E+00,0.1276E+00,
     *0.1375E+00,0.1430E+00,0.1480E+00,0.1607E+00,0.1747E+00,
     *0.1900E+00,0.2054E+00,0.2236E+00,0.2462E+00,0.2678E+00,
     *0.2913E+00,0.3180E+00,0.3470E+00,0.3804E+00,0.4145E+00,
     *0.4529E+00,0.4978E+00,0.5447E+00,0.5982E+00,0.6525E+00,
     *0.7156E+00,0.7858E+00,0.8704E+00,0.9557E+00,0.1050E+01,
     *0.1160E+01,0.1288E+01,0.1423E+01,0.1587E+01,0.1787E+01,
     *0.2008E+01,0.2305E+01,0.2682E+01,0.3190E+01,0.3948E+01,
     *0.5119E+01,0.7074E+01,0.1074E+02,0.1842E+02,0.3725E+02,
     *0.9609E+02,0.3821E+03,0.1362E+04 /
        DATA ((PHR(i,j),j=1,83),i=12,12)/
     *0.5712E+00,0.5403E+00,0.5328E+00,0.5126E+00,0.4783E+00,
     *0.4312E+00,0.3866E+00,0.3578E+00,0.3308E+00,0.2870E+00,
     *0.2392E+00,0.2008E+00,0.1685E+00,0.1417E+00,0.1217E+00,
     *0.1072E+00,0.9605E-01,0.8694E-01,0.8090E-01,0.7628E-01,
     *0.7342E-01,0.7136E-01,0.7074E-01,0.6956E-01,0.6862E-01,
     *0.6817E-01,0.6912E-01,0.7099E-01,0.7334E-01,0.7487E-01,
     *0.7713E-01,0.7946E-01,0.8371E-01,0.8901E-01,0.9343E-01,
     *0.9861E-01,0.1053E+00,0.1133E+00,0.1214E+00,0.1294E+00,
     *0.1387E+00,0.1433E+00,0.1492E+00,0.1617E+00,0.1753E+00,
     *0.1900E+00,0.2060E+00,0.2246E+00,0.2423E+00,0.2649E+00,
     *0.2913E+00,0.3184E+00,0.3479E+00,0.3802E+00,0.4174E+00,
     *0.4590E+00,0.5009E+00,0.5516E+00,0.6042E+00,0.6657E+00,
     *0.7324E+00,0.8081E+00,0.8848E+00,0.9761E+00,0.1076E+01,
     *0.1191E+01,0.1311E+01,0.1459E+01,0.1627E+01,0.1813E+01,
     *0.2055E+01,0.2346E+01,0.2734E+01,0.3270E+01,0.4039E+01,
     *0.5228E+01,0.7250E+01,0.1098E+02,0.1869E+02,0.3749E+02,
     *0.9541E+02,0.3706E+03,0.1262E+04 /
        DATA ((PHR(i,j),j=1,83),i=13,13)/
     *0.5994E+00,0.5672E+00,0.5564E+00,0.5333E+00,0.4909E+00,
     *0.4489E+00,0.4085E+00,0.3701E+00,0.3386E+00,0.3018E+00,
     *0.2571E+00,0.2129E+00,0.1800E+00,0.1531E+00,0.1307E+00,
     *0.1135E+00,0.1015E+00,0.9286E-01,0.8691E-01,0.8209E-01,
     *0.7726E-01,0.7418E-01,0.7177E-01,0.7148E-01,0.7242E-01,
     *0.7340E-01,0.7313E-01,0.7361E-01,0.7490E-01,0.7806E-01,
     *0.8153E-01,0.8518E-01,0.8879E-01,0.9263E-01,0.9821E-01,
     *0.1046E+00,0.1104E+00,0.1168E+00,0.1248E+00,0.1347E+00,
     *0.1448E+00,0.1505E+00,0.1558E+00,0.1688E+00,0.1836E+00,
     *0.1994E+00,0.2154E+00,0.2344E+00,0.2573E+00,0.2798E+00,
     *0.3044E+00,0.3322E+00,0.3629E+00,0.3976E+00,0.4335E+00,
     *0.4739E+00,0.5205E+00,0.5700E+00,0.6259E+00,0.6838E+00,
     *0.7504E+00,0.8258E+00,0.9151E+00,0.1005E+01,0.1106E+01,
     *0.1225E+01,0.1361E+01,0.1508E+01,0.1687E+01,0.1901E+01,
     *0.2145E+01,0.2467E+01,0.2878E+01,0.3433E+01,0.4257E+01,
     *0.5517E+01,0.7603E+01,0.1145E+02,0.1933E+02,0.3806E+02,
     *0.9386E+02,0.3426E+03,0.1035E+04 /
        DATA ((PHR(i,j),j=1,83),i=14,14)/
     *0.5925E+00,0.5612E+00,0.5433E+00,0.5175E+00,0.4768E+00,
     *0.4387E+00,0.4069E+00,0.3811E+00,0.3563E+00,0.3207E+00,
     *0.2746E+00,0.2299E+00,0.1957E+00,0.1668E+00,0.1423E+00,
     *0.1235E+00,0.1101E+00,0.1005E+00,0.9362E-01,0.8802E-01,
     *0.8284E-01,0.7917E-01,0.7662E-01,0.7603E-01,0.7642E-01,
     *0.7699E-01,0.7689E-01,0.7716E-01,0.7850E-01,0.8175E-01,
     *0.8510E-01,0.8877E-01,0.9248E-01,0.9669E-01,0.1025E+00,
     *0.1088E+00,0.1148E+00,0.1216E+00,0.1299E+00,0.1397E+00,
     *0.1498E+00,0.1554E+00,0.1610E+00,0.1741E+00,0.1896E+00,
     *0.2057E+00,0.2219E+00,0.2414E+00,0.2644E+00,0.2876E+00,
     *0.3134E+00,0.3420E+00,0.3743E+00,0.4103E+00,0.4478E+00,
     *0.4910E+00,0.5389E+00,0.5917E+00,0.6500E+00,0.7120E+00,
     *0.7826E+00,0.8644E+00,0.9597E+00,0.1056E+01,0.1166E+01,
     *0.1294E+01,0.1439E+01,0.1603E+01,0.1799E+01,0.2028E+01,
     *0.2300E+01,0.2649E+01,0.3099E+01,0.3705E+01,0.4596E+01,
     *0.5941E+01,0.8148E+01,0.1214E+02,0.2012E+02,0.3851E+02,
     *0.9071E+02,0.3047E+03,0.7912E+03 /
        DATA ((PHR(i,j),j=1,83),i=15,15)/
     *0.3548E+00,0.3322E+00,0.3156E+00,0.3130E+00,0.3146E+00,
     *0.3242E+00,0.3406E+00,0.3519E+00,0.3468E+00,0.3281E+00,
     *0.2985E+00,0.2611E+00,0.2251E+00,0.1957E+00,0.1710E+00,
     *0.1500E+00,0.1331E+00,0.1188E+00,0.1074E+00,0.9941E-01,
     *0.9320E-01,0.8840E-01,0.8470E-01,0.8216E-01,0.8044E-01,
     *0.7981E-01,0.7995E-01,0.8090E-01,0.8223E-01,0.8385E-01,
     *0.8613E-01,0.8903E-01,0.9256E-01,0.9657E-01,0.1008E+00,
     *0.1064E+00,0.1129E+00,0.1194E+00,0.1269E+00,0.1367E+00,
     *0.1480E+00,0.1532E+00,0.1587E+00,0.1700E+00,0.1837E+00,
     *0.2002E+00,0.2178E+00,0.2371E+00,0.2589E+00,0.2826E+00,
     *0.3082E+00,0.3389E+00,0.3742E+00,0.4136E+00,0.4562E+00,
     *0.5038E+00,0.5594E+00,0.6209E+00,0.6897E+00,0.7698E+00,
     *0.8596E+00,0.9580E+00,0.1068E+01,0.1197E+01,0.1345E+01,
     *0.1516E+01,0.1708E+01,0.1928E+01,0.2190E+01,0.2507E+01,
     *0.2887E+01,0.3357E+01,0.3955E+01,0.4749E+01,0.5869E+01,
     *0.7494E+01,0.1000E+02,0.1421E+02,0.2196E+02,0.3805E+02,
     *0.7768E+02,0.2058E+03,0.3618E+03 /
        DATA ((PHR(i,j),j=1,83),i=16,16)/
     *0.2360E+00,0.2178E+00,0.1964E+00,0.1940E+00,0.2077E+00,
     *0.2326E+00,0.2537E+00,0.2599E+00,0.2539E+00,0.2416E+00,
     *0.2274E+00,0.2136E+00,0.1981E+00,0.1817E+00,0.1655E+00,
     *0.1485E+00,0.1334E+00,0.1212E+00,0.1102E+00,0.1012E+00,
     *0.9373E-01,0.8759E-01,0.8329E-01,0.8024E-01,0.7780E-01,
     *0.7591E-01,0.7502E-01,0.7500E-01,0.7553E-01,0.7636E-01,
     *0.7738E-01,0.7900E-01,0.8176E-01,0.8511E-01,0.8852E-01,
     *0.9255E-01,0.9769E-01,0.1034E+00,0.1099E+00,0.1173E+00,
     *0.1256E+00,0.1302E+00,0.1349E+00,0.1455E+00,0.1573E+00,
     *0.1705E+00,0.1857E+00,0.2032E+00,0.2229E+00,0.2451E+00,
     *0.2707E+00,0.3002E+00,0.3331E+00,0.3703E+00,0.4136E+00,
     *0.4634E+00,0.5194E+00,0.5833E+00,0.6567E+00,0.7427E+00,
     *0.8407E+00,0.9513E+00,0.1080E+01,0.1232E+01,0.1408E+01,
     *0.1610E+01,0.1848E+01,0.2126E+01,0.2459E+01,0.2857E+01,
     *0.3333E+01,0.3923E+01,0.4668E+01,0.5632E+01,0.6929E+01,
     *0.8742E+01,0.1144E+02,0.1576E+02,0.2321E+02,0.3766E+02,
     *0.7009E+02,0.1593E+03,0.2353E+03 /
        DATA ((PHR(i,j),j=1,83),i=17,17)/
     *0.2183E+00,0.1988E+00,0.1700E+00,0.1660E+00,0.1823E+00,
     *0.2040E+00,0.2133E+00,0.2101E+00,0.2010E+00,0.1911E+00,
     *0.1825E+00,0.1742E+00,0.1662E+00,0.1576E+00,0.1480E+00,
     *0.1385E+00,0.1282E+00,0.1175E+00,0.1079E+00,0.9907E-01,
     *0.9203E-01,0.8621E-01,0.8117E-01,0.7705E-01,0.7415E-01,
     *0.7245E-01,0.7116E-01,0.7028E-01,0.6998E-01,0.7034E-01,
     *0.7157E-01,0.7347E-01,0.7534E-01,0.7742E-01,0.8053E-01,
     *0.8427E-01,0.8810E-01,0.9260E-01,0.9819E-01,0.1043E+00,
     *0.1111E+00,0.1151E+00,0.1194E+00,0.1291E+00,0.1399E+00,
     *0.1522E+00,0.1664E+00,0.1824E+00,0.2005E+00,0.2217E+00,
     *0.2458E+00,0.2730E+00,0.3042E+00,0.3406E+00,0.3818E+00,
     *0.4287E+00,0.4834E+00,0.5473E+00,0.6205E+00,0.7037E+00,
     *0.8011E+00,0.9173E+00,0.1051E+01,0.1205E+01,0.1387E+01,
     *0.1603E+01,0.1858E+01,0.2161E+01,0.2522E+01,0.2956E+01,
     *0.3489E+01,0.4144E+01,0.4967E+01,0.6022E+01,0.7419E+01,
     *0.9362E+01,0.1219E+02,0.1659E+02,0.2403E+02,0.3801E+02,
     *0.6838E+02,0.1475E+03,0.2076E+03 /
        DATA ((PHR(i,j),j=1,83),i=18,18)/
     *0.1136E+00,0.1007E+00,0.8035E-01,0.8849E-01,0.1064E+00,
     *0.1102E+00,0.1035E+00,0.9485E-01,0.8717E-01,0.8152E-01,
     *0.7739E-01,0.7472E-01,0.7332E-01,0.7256E-01,0.7272E-01,
     *0.7329E-01,0.7381E-01,0.7415E-01,0.7411E-01,0.7328E-01,
     *0.7137E-01,0.6940E-01,0.6678E-01,0.6417E-01,0.6139E-01,
     *0.5880E-01,0.5642E-01,0.5471E-01,0.5351E-01,0.5247E-01,
     *0.5169E-01,0.5156E-01,0.5198E-01,0.5276E-01,0.5375E-01,
     *0.5520E-01,0.5741E-01,0.6010E-01,0.6304E-01,0.6663E-01,
     *0.7119E-01,0.7373E-01,0.7642E-01,0.8220E-01,0.8908E-01,
     *0.9734E-01,0.1067E+00,0.1172E+00,0.1298E+00,0.1444E+00,
     *0.1611E+00,0.1805E+00,0.2037E+00,0.2305E+00,0.2616E+00,
     *0.2986E+00,0.3423E+00,0.3937E+00,0.4552E+00,0.5280E+00,
     *0.6154E+00,0.7208E+00,0.8468E+00,0.1000E+01,0.1187E+01,
     *0.1415E+01,0.1694E+01,0.2039E+01,0.2466E+01,0.3001E+01,
     *0.3671E+01,0.4518E+01,0.5602E+01,0.7003E+01,0.8848E+01,
     *0.1134E+02,0.1481E+02,0.1990E+02,0.2793E+02,0.4185E+02,
     *0.6931E+02,0.1301E+03,0.1659E+03 /
        DATA ((PHR(i,j),j=1,83),i=19,19)/
     *0.6440E-01,0.5458E-01,0.4514E-01,0.5591E-01,0.5989E-01,
     *0.5586E-01,0.5049E-01,0.4611E-01,0.4284E-01,0.4062E-01,
     *0.3894E-01,0.3775E-01,0.3690E-01,0.3647E-01,0.3634E-01,
     *0.3638E-01,0.3668E-01,0.3732E-01,0.3816E-01,0.3919E-01,
     *0.4024E-01,0.4118E-01,0.4189E-01,0.4234E-01,0.4253E-01,
     *0.4238E-01,0.4189E-01,0.4135E-01,0.4079E-01,0.4021E-01,
     *0.3982E-01,0.3960E-01,0.3966E-01,0.4003E-01,0.4059E-01,
     *0.4140E-01,0.4262E-01,0.4421E-01,0.4610E-01,0.4841E-01,
     *0.5129E-01,0.5293E-01,0.5471E-01,0.5867E-01,0.6332E-01,
     *0.6885E-01,0.7527E-01,0.8266E-01,0.9136E-01,0.1016E+00,
     *0.1135E+00,0.1275E+00,0.1442E+00,0.1638E+00,0.1869E+00,
     *0.2147E+00,0.2479E+00,0.2875E+00,0.3358E+00,0.3941E+00,
     *0.4649E+00,0.5523E+00,0.6595E+00,0.7922E+00,0.9585E+00,
     *0.1167E+01,0.1430E+01,0.1764E+01,0.2193E+01,0.2746E+01,
     *0.3466E+01,0.4407E+01,0.5650E+01,0.7306E+01,0.9537E+01,
     *0.1259E+02,0.1684E+02,0.2294E+02,0.3214E+02,0.4711E+02,
     *0.7426E+02,0.1251E+03,0.1499E+03 /
        DATA ((PHR(i,j),j=1,83),i=20,20)/
     *0.7657E-01,0.7193E-01,0.6322E-01,0.6634E-01,0.7486E-01,
     *0.7879E-01,0.7773E-01,0.7451E-01,0.7098E-01,0.6784E-01,
     *0.6531E-01,0.6342E-01,0.6207E-01,0.6114E-01,0.6053E-01,
     *0.6011E-01,0.5981E-01,0.5950E-01,0.5911E-01,0.5850E-01,
     *0.5770E-01,0.5674E-01,0.5577E-01,0.5485E-01,0.5396E-01,
     *0.5316E-01,0.5249E-01,0.5211E-01,0.5200E-01,0.5210E-01,
     *0.5246E-01,0.5313E-01,0.5420E-01,0.5562E-01,0.5735E-01,
     *0.5946E-01,0.6211E-01,0.6525E-01,0.6887E-01,0.7309E-01,
     *0.7808E-01,0.8087E-01,0.8386E-01,0.9045E-01,0.9808E-01,
     *0.1070E+00,0.1172E+00,0.1290E+00,0.1427E+00,0.1586E+00,
     *0.1770E+00,0.1984E+00,0.2236E+00,0.2531E+00,0.2875E+00,
     *0.3284E+00,0.3765E+00,0.4337E+00,0.5020E+00,0.5834E+00,
     *0.6815E+00,0.7996E+00,0.9427E+00,0.1117E+01,0.1329E+01,
     *0.1591E+01,0.1913E+01,0.2312E+01,0.2810E+01,0.3431E+01,
     *0.4213E+01,0.5199E+01,0.6449E+01,0.8048E+01,0.1010E+02,
     *0.1275E+02,0.1625E+02,0.2095E+02,0.2740E+02,0.3686E+02,
     *0.5085E+02,0.6526E+02,0.6980E+02 /
c************** MIE (phase fun qh) ***************
        DATA ((QHR(i,j),j=1,83),i= 1, 1)/
     * 0.1268E-21, 0.2476E-01, 0.2255E-01,-0.8459E-02,-0.3700E-01,
     *-0.5391E-01,-0.5697E-01,-0.4863E-01,-0.2160E-01, 0.2527E-02,
     * 0.7879E-02, 0.8199E-02, 0.1009E-01, 0.1381E-01, 0.1060E-01,
     * 0.7513E-02, 0.6562E-02, 0.4469E-02, 0.4342E-02, 0.3870E-02,
     * 0.3488E-02, 0.1873E-02, 0.8242E-03, 0.1707E-03,-0.5390E-03,
     *-0.3612E-03,-0.2495E-03,-0.1048E-02,-0.1244E-02,-0.2457E-02,
     *-0.1549E-02,-0.4067E-02,-0.1796E-02,-0.2753E-02,-0.4492E-02,
     *-0.2752E-02,-0.4822E-02,-0.5504E-02,-0.3245E-02,-0.3857E-02,
     *-0.5823E-02,-0.2124E-02,-0.3315E-02,-0.1960E-02,-0.3327E-02,
     *-0.5509E-02,-0.3118E-02,-0.1082E-02, 0.3212E-03, 0.1378E-02,
     *-0.4333E-03,-0.2347E-02,-0.1399E-02,-0.2813E-02,-0.4009E-02,
     *-0.6005E-02,-0.5521E-02,-0.5109E-02,-0.7876E-02,-0.8446E-02,
     *-0.1587E-01,-0.2224E-01,-0.2776E-01,-0.2752E-01,-0.3971E-01,
     *-0.5038E-01,-0.5438E-01,-0.6782E-01,-0.8576E-01,-0.9301E-01,
     *-0.1103E+00,-0.1294E+00,-0.1358E+00,-0.1531E+00,-0.1867E+00,
     *-0.1947E+00,-0.2355E+00,-0.2765E+00,-0.2621E+00,-0.2857E+00,
     *-0.2604E+00, 0.8863E-01, 0.1341E-17 /
        DATA ((QHR(i,j),j=1,83),i= 2, 2)/
     * 0.8915E-21, 0.1047E-01, 0.8794E-02,-0.1221E-01,-0.2791E-01,
     *-0.4559E-01,-0.5726E-01,-0.4209E-01,-0.9986E-02, 0.8919E-02,
     * 0.1561E-01, 0.1519E-01, 0.1543E-01, 0.1286E-01, 0.1151E-01,
     * 0.1267E-01, 0.9975E-02, 0.7821E-02, 0.6247E-02, 0.5102E-02,
     * 0.5426E-02, 0.4434E-02, 0.4700E-02, 0.2735E-02, 0.2602E-02,
     * 0.1810E-03, 0.1072E-02,-0.1217E-03, 0.1517E-02, 0.4575E-03,
     * 0.1173E-02, 0.3590E-03,-0.1717E-02, 0.8142E-03,-0.8557E-03,
     *-0.1025E-03, 0.1248E-02,-0.1358E-02,-0.7803E-03, 0.7688E-03,
     *-0.7587E-03, 0.1022E-02,-0.2572E-02,-0.4315E-03, 0.1019E-02,
     * 0.1875E-02,-0.4092E-03,-0.6854E-03, 0.2913E-02, 0.5484E-02,
     * 0.6290E-02, 0.7964E-02, 0.8576E-02, 0.8700E-02, 0.9681E-02,
     * 0.7736E-02, 0.6657E-02, 0.1938E-02, 0.5279E-03,-0.5814E-02,
     *-0.1153E-01,-0.1495E-01,-0.1527E-01,-0.2602E-01,-0.3755E-01,
     *-0.4496E-01,-0.5354E-01,-0.7206E-01,-0.7231E-01,-0.8516E-01,
     *-0.1030E+00,-0.1099E+00,-0.1343E+00,-0.1605E+00,-0.1845E+00,
     *-0.2110E+00,-0.2412E+00,-0.2572E+00,-0.2445E+00,-0.2903E+00,
     *-0.2884E+00, 0.7441E-01,-0.6003E-17 /
        DATA ((QHR(i,j),j=1,83),i= 3, 3)/
     *-0.6146E-21, 0.1969E-01, 0.1817E-01,-0.6230E-02,-0.3044E-01,
     *-0.5209E-01,-0.5398E-01,-0.3391E-01,-0.7471E-02, 0.3891E-02,
     * 0.1574E-01, 0.2093E-01, 0.1697E-01, 0.1185E-01, 0.1116E-01,
     * 0.1147E-01, 0.1049E-01, 0.9795E-02, 0.7055E-02, 0.5709E-02,
     * 0.5082E-02, 0.4872E-02, 0.4787E-02, 0.3997E-02, 0.3696E-02,
     * 0.1473E-02, 0.1427E-02, 0.1349E-02, 0.1024E-02, 0.1414E-02,
     * 0.4724E-03, 0.1628E-02,-0.9738E-03, 0.7231E-03, 0.1648E-02,
     *-0.3753E-03, 0.1837E-02, 0.1687E-02,-0.4635E-03, 0.1536E-02,
     * 0.1999E-02, 0.5311E-03, 0.5462E-04,-0.1677E-03, 0.1806E-02,
     * 0.2745E-02, 0.1526E-02,-0.3013E-03,-0.2097E-03, 0.1492E-02,
     * 0.5193E-02, 0.7723E-02, 0.6748E-02, 0.7801E-02, 0.8641E-02,
     * 0.8715E-02, 0.6408E-02, 0.2116E-02,-0.3111E-03,-0.7032E-02,
     *-0.9027E-02,-0.1203E-01,-0.1565E-01,-0.2859E-01,-0.3260E-01,
     *-0.3945E-01,-0.5263E-01,-0.6436E-01,-0.6736E-01,-0.8161E-01,
     *-0.9714E-01,-0.1062E+00,-0.1375E+00,-0.1647E+00,-0.1723E+00,
     *-0.2120E+00,-0.2262E+00,-0.2233E+00,-0.2653E+00,-0.2455E+00,
     *-0.9803E-01, 0.1603E+00,-0.7181E-17 /
        DATA ((QHR(i,j),j=1,83),i= 4, 4)/
     *-0.8679E-21, 0.1142E-01, 0.1278E-01,-0.7503E-02,-0.2461E-01,
     *-0.4284E-01,-0.5172E-01,-0.3515E-01,-0.3311E-02, 0.1311E-01,
     * 0.2056E-01, 0.2022E-01, 0.1896E-01, 0.1540E-01, 0.1383E-01,
     * 0.1481E-01, 0.1219E-01, 0.1017E-01, 0.8202E-02, 0.6948E-02,
     * 0.6972E-02, 0.6190E-02, 0.6439E-02, 0.4648E-02, 0.4435E-02,
     * 0.1918E-02, 0.2660E-02, 0.1885E-02, 0.3190E-02, 0.2531E-02,
     * 0.3014E-02, 0.2541E-02, 0.3263E-03, 0.2842E-02, 0.1856E-02,
     * 0.2172E-02, 0.3738E-02, 0.1736E-02, 0.1778E-02, 0.3486E-02,
     * 0.2549E-02, 0.3672E-02, 0.7203E-03, 0.2449E-02, 0.3997E-02,
     * 0.5103E-02, 0.3269E-02, 0.2811E-02, 0.5948E-02, 0.8544E-02,
     * 0.9975E-02, 0.1191E-01, 0.1230E-01, 0.1287E-01, 0.1418E-01,
     * 0.1277E-01, 0.1147E-01, 0.6827E-02, 0.5626E-02,-0.7231E-03,
     *-0.5651E-02,-0.8878E-02,-0.9875E-02,-0.2113E-01,-0.3108E-01,
     *-0.3878E-01,-0.4865E-01,-0.6617E-01,-0.6580E-01,-0.7857E-01,
     *-0.9628E-01,-0.1027E+00,-0.1287E+00,-0.1558E+00,-0.1757E+00,
     *-0.2041E+00,-0.2289E+00,-0.2350E+00,-0.2259E+00,-0.2563E+00,
     *-0.2237E+00, 0.9307E-01,-0.3242E-17 /
        DATA ((QHR(i,j),j=1,83),i= 5, 5)/
     * 0.5549E-21, 0.2641E-01, 0.4434E-01, 0.1074E-01,-0.3317E-01,
     *-0.5365E-01,-0.4567E-01,-0.1946E-01,-0.4090E-02, 0.8491E-02,
     * 0.1844E-01, 0.2527E-01, 0.2248E-01, 0.1768E-01, 0.1647E-01,
     * 0.1332E-01, 0.1159E-01, 0.1144E-01, 0.9839E-02, 0.8875E-02,
     * 0.6834E-02, 0.6969E-02, 0.5712E-02, 0.6149E-02, 0.5588E-02,
     * 0.6110E-02, 0.4177E-02, 0.4484E-02, 0.2991E-02, 0.3738E-02,
     * 0.2014E-02, 0.4061E-02, 0.3613E-02, 0.2326E-02, 0.4274E-02,
     * 0.2807E-02, 0.3406E-02, 0.5575E-02, 0.4299E-02, 0.3577E-02,
     * 0.5900E-02, 0.3044E-02, 0.6663E-02, 0.4768E-02, 0.5320E-02,
     * 0.6569E-02, 0.7200E-02, 0.7851E-02, 0.5473E-02, 0.4245E-02,
     * 0.6273E-02, 0.7705E-02, 0.6867E-02, 0.7293E-02, 0.6801E-02,
     * 0.8444E-02, 0.6439E-02, 0.5860E-02, 0.3223E-02, 0.3031E-03,
     * 0.2250E-03,-0.3539E-02,-0.1139E-01,-0.1820E-01,-0.1868E-01,
     *-0.2639E-01,-0.3951E-01,-0.4185E-01,-0.5879E-01,-0.7798E-01,
     *-0.8801E-01,-0.1085E+00,-0.1288E+00,-0.1413E+00,-0.1492E+00,
     *-0.1788E+00,-0.1850E+00,-0.1963E+00,-0.2498E+00,-0.1505E+00,
     * 0.6993E-01, 0.2651E+00,-0.4398E-17 /
        DATA ((QHR(i,j),j=1,83),i= 6, 6)/
     * 0.3355E-21, 0.1874E-01, 0.2124E-01,-0.2990E-03,-0.2018E-01,
     *-0.3582E-01,-0.4506E-01,-0.3142E-01,-0.1718E-02, 0.2246E-01,
     * 0.2391E-01, 0.2167E-01, 0.2190E-01, 0.2166E-01, 0.1870E-01,
     * 0.1663E-01, 0.1396E-01, 0.1111E-01, 0.9925E-02, 0.8866E-02,
     * 0.9426E-02, 0.7567E-02, 0.7128E-02, 0.5710E-02, 0.5228E-02,
     * 0.4137E-02, 0.4865E-02, 0.3448E-02, 0.4953E-02, 0.4010E-02,
     * 0.5156E-02, 0.3211E-02, 0.3659E-02, 0.4971E-02, 0.3029E-02,
     * 0.4759E-02, 0.4766E-02, 0.2813E-02, 0.4695E-02, 0.5471E-02,
     * 0.3873E-02, 0.7237E-02, 0.4518E-02, 0.6216E-02, 0.7103E-02,
     * 0.7084E-02, 0.7509E-02, 0.8960E-02, 0.1228E-01, 0.1379E-01,
     * 0.1267E-01, 0.1310E-01, 0.1566E-01, 0.1553E-01, 0.1539E-01,
     * 0.1335E-01, 0.1344E-01, 0.1152E-01, 0.1025E-01, 0.8236E-02,
     * 0.1398E-02,-0.3515E-02,-0.5077E-02,-0.1056E-01,-0.2413E-01,
     *-0.3163E-01,-0.3768E-01,-0.5440E-01,-0.6391E-01,-0.7361E-01,
     *-0.9088E-01,-0.1041E+00,-0.1144E+00,-0.1350E+00,-0.1664E+00,
     *-0.1729E+00,-0.2081E+00,-0.2327E+00,-0.1805E+00,-0.2070E+00,
     *-0.2145E+00, 0.1464E+00, 0.1280E-17 /
        DATA ((QHR(i,j),j=1,83),i= 7, 7)/
     * 0.2263E-21, 0.1320E-01, 0.1774E-01,-0.1102E-03,-0.1613E-01,
     *-0.3241E-01,-0.4148E-01,-0.2489E-01, 0.6124E-02, 0.2474E-01,
     * 0.2857E-01, 0.2612E-01, 0.2471E-01, 0.2140E-01, 0.1898E-01,
     * 0.1882E-01, 0.1571E-01, 0.1304E-01, 0.1121E-01, 0.9889E-02,
     * 0.1011E-01, 0.8898E-02, 0.8921E-02, 0.7182E-02, 0.6796E-02,
     * 0.4625E-02, 0.5367E-02, 0.4419E-02, 0.6144E-02, 0.5411E-02,
     * 0.6249E-02, 0.5222E-02, 0.3798E-02, 0.6125E-02, 0.4896E-02,
     * 0.5991E-02, 0.7145E-02, 0.5129E-02, 0.5890E-02, 0.7235E-02,
     * 0.6232E-02, 0.8208E-02, 0.5417E-02, 0.7206E-02, 0.8669E-02,
     * 0.9760E-02, 0.8739E-02, 0.9252E-02, 0.1279E-01, 0.1504E-01,
     * 0.1547E-01, 0.1708E-01, 0.1849E-01, 0.1906E-01, 0.2030E-01,
     * 0.1875E-01, 0.1797E-01, 0.1404E-01, 0.1334E-01, 0.8714E-02,
     * 0.3267E-02,-0.4783E-03,-0.1286E-02,-0.1079E-01,-0.2215E-01,
     *-0.3003E-01,-0.3895E-01,-0.5641E-01,-0.5817E-01,-0.7001E-01,
     *-0.8741E-01,-0.9479E-01,-0.1152E+00,-0.1404E+00,-0.1631E+00,
     *-0.1828E+00,-0.2092E+00,-0.2178E+00,-0.1823E+00,-0.2122E+00,
     *-0.2078E+00, 0.1096E+00, 0.2688E-17 /
        DATA ((QHR(i,j),j=1,83),i= 8, 8)/
     *-0.1172E-20, 0.2621E-01, 0.5035E-01, 0.1893E-01,-0.2101E-01,
     *-0.3886E-01,-0.3113E-01,-0.1470E-01, 0.6290E-02, 0.2117E-01,
     * 0.2847E-01, 0.2779E-01, 0.2789E-01, 0.2736E-01, 0.2288E-01,
     * 0.1786E-01, 0.1574E-01, 0.1373E-01, 0.1353E-01, 0.1230E-01,
     * 0.1004E-01, 0.9056E-02, 0.7886E-02, 0.7899E-02, 0.7281E-02,
     * 0.8963E-02, 0.8128E-02, 0.8272E-02, 0.6622E-02, 0.6194E-02,
     * 0.6127E-02, 0.6022E-02, 0.8311E-02, 0.5975E-02, 0.6272E-02,
     * 0.7114E-02, 0.5577E-02, 0.7450E-02, 0.8602E-02, 0.7773E-02,
     * 0.8895E-02, 0.8417E-02, 0.1028E-01, 0.1081E-01, 0.9788E-02,
     * 0.9921E-02, 0.1222E-01, 0.1378E-01, 0.1380E-01, 0.1400E-01,
     * 0.1373E-01, 0.1269E-01, 0.1360E-01, 0.1369E-01, 0.1264E-01,
     * 0.1214E-01, 0.1224E-01, 0.1369E-01, 0.1118E-01, 0.1219E-01,
     * 0.1015E-01, 0.5442E-02,-0.3573E-02,-0.3473E-02,-0.1000E-01,
     *-0.1888E-01,-0.2498E-01,-0.3189E-01,-0.5337E-01,-0.6653E-01,
     *-0.7995E-01,-0.1041E+00,-0.1105E+00,-0.1158E+00,-0.1343E+00,
     *-0.1388E+00,-0.1523E+00,-0.1769E+00,-0.1698E+00,-0.1072E+00,
     * 0.1727E-01, 0.1725E+00, 0.5777E-17 /
        DATA ((QHR(i,j),j=1,83),i= 9, 9)/
     *-0.5743E-21, 0.2658E-01, 0.4799E-01, 0.2133E-01,-0.1628E-01,
     *-0.3471E-01,-0.2654E-01,-0.8060E-03, 0.1513E-01, 0.2537E-01,
     * 0.3273E-01, 0.3695E-01, 0.3215E-01, 0.2589E-01, 0.2356E-01,
     * 0.1992E-01, 0.1756E-01, 0.1675E-01, 0.1476E-01, 0.1358E-01,
     * 0.1168E-01, 0.1147E-01, 0.1027E-01, 0.1043E-01, 0.1003E-01,
     * 0.1019E-01, 0.8618E-02, 0.8749E-02, 0.7640E-02, 0.8194E-02,
     * 0.6869E-02, 0.8858E-02, 0.8320E-02, 0.7660E-02, 0.9486E-02,
     * 0.8386E-02, 0.9288E-02, 0.1118E-01, 0.1032E-01, 0.1004E-01,
     * 0.1187E-01, 0.9991E-02, 0.1288E-01, 0.1206E-01, 0.1274E-01,
     * 0.1348E-01, 0.1401E-01, 0.1469E-01, 0.1326E-01, 0.1307E-01,
     * 0.1588E-01, 0.1780E-01, 0.1682E-01, 0.1716E-01, 0.1738E-01,
     * 0.1952E-01, 0.1837E-01, 0.1788E-01, 0.1547E-01, 0.1178E-01,
     * 0.1121E-01, 0.7955E-02, 0.1397E-02,-0.5306E-02,-0.6195E-02,
     *-0.1378E-01,-0.2609E-01,-0.2939E-01,-0.4444E-01,-0.6240E-01,
     *-0.7218E-01,-0.8915E-01,-0.1097E+00,-0.1203E+00,-0.1240E+00,
     *-0.1513E+00,-0.1526E+00,-0.1536E+00,-0.1977E+00,-0.8945E-01,
     * 0.1337E+00, 0.2616E+00, 0.7570E-18 /
        DATA ((QHR(i,j),j=1,83),i=10,10)/
     *-0.4904E-21, 0.1744E-01, 0.2926E-01, 0.1488E-01,-0.3591E-02,
     *-0.1959E-01,-0.1971E-01, 0.3157E-03, 0.2603E-01, 0.3606E-01,
     * 0.4220E-01, 0.4120E-01, 0.3473E-01, 0.2781E-01, 0.2484E-01,
     * 0.2373E-01, 0.2128E-01, 0.1941E-01, 0.1650E-01, 0.1463E-01,
     * 0.1380E-01, 0.1319E-01, 0.1287E-01, 0.1178E-01, 0.1128E-01,
     * 0.9016E-02, 0.9107E-02, 0.9229E-02, 0.9540E-02, 0.9797E-02,
     * 0.9819E-02, 0.1013E-01, 0.8269E-02, 0.1005E-01, 0.1096E-01,
     * 0.1057E-01, 0.1216E-01, 0.1194E-01, 0.1127E-01, 0.1264E-01,
     * 0.1296E-01, 0.1291E-01, 0.1248E-01, 0.1347E-01, 0.1478E-01,
     * 0.1571E-01, 0.1539E-01, 0.1537E-01, 0.1705E-01, 0.1936E-01,
     * 0.2237E-01, 0.2453E-01, 0.2419E-01, 0.2550E-01, 0.2762E-01,
     * 0.2830E-01, 0.2694E-01, 0.2360E-01, 0.2251E-01, 0.1713E-01,
     * 0.1383E-01, 0.1067E-01, 0.8326E-02,-0.2010E-02,-0.7234E-02,
     *-0.1587E-01,-0.2868E-01,-0.4142E-01,-0.4308E-01,-0.5402E-01,
     *-0.6868E-01,-0.7470E-01,-0.1022E+00,-0.1270E+00,-0.1337E+00,
     *-0.1619E+00,-0.1699E+00,-0.1539E+00,-0.1567E+00,-0.1272E+00,
     *-0.8717E-02, 0.1571E+00, 0.2719E-17 /
        DATA ((QHR(i,j),j=1,83),i=11,11)/
     *-0.1071E-21, 0.2586E-01, 0.5239E-01, 0.2991E-01,-0.5289E-02,
     *-0.2169E-01,-0.1274E-01, 0.1198E-01, 0.2723E-01, 0.3617E-01,
     * 0.4163E-01, 0.4372E-01, 0.3843E-01, 0.3191E-01, 0.2863E-01,
     * 0.2415E-01, 0.2113E-01, 0.1978E-01, 0.1789E-01, 0.1657E-01,
     * 0.1451E-01, 0.1410E-01, 0.1280E-01, 0.1285E-01, 0.1251E-01,
     * 0.1290E-01, 0.1137E-01, 0.1142E-01, 0.1031E-01, 0.1065E-01,
     * 0.9588E-02, 0.1143E-01, 0.1127E-01, 0.1050E-01, 0.1210E-01,
     * 0.1144E-01, 0.1216E-01, 0.1408E-01, 0.1369E-01, 0.1331E-01,
     * 0.1500E-01, 0.1354E-01, 0.1626E-01, 0.1600E-01, 0.1651E-01,
     * 0.1701E-01, 0.1762E-01, 0.1858E-01, 0.1768E-01, 0.1778E-01,
     * 0.2046E-01, 0.2224E-01, 0.2141E-01, 0.2159E-01, 0.2189E-01,
     * 0.2413E-01, 0.2357E-01, 0.2375E-01, 0.2155E-01, 0.1819E-01,
     * 0.1756E-01, 0.1458E-01, 0.8183E-02, 0.2760E-02, 0.1497E-02,
     *-0.5853E-02,-0.1693E-01,-0.2007E-01,-0.3546E-01,-0.5307E-01,
     *-0.6244E-01,-0.7910E-01,-0.9680E-01,-0.1035E+00,-0.1067E+00,
     *-0.1290E+00,-0.1278E+00,-0.1274E+00,-0.1616E+00,-0.5051E-01,
     * 0.1614E+00, 0.2539E+00,-0.2801E-18 /
        DATA ((QHR(i,j),j=1,83),i=12,12)/
     * 0.1195E-20, 0.2337E-01, 0.4146E-01, 0.2593E-01, 0.4162E-02,
     *-0.8725E-02,-0.8606E-02, 0.4025E-02, 0.2814E-01, 0.4608E-01,
     * 0.4622E-01, 0.4163E-01, 0.3901E-01, 0.3714E-01, 0.3139E-01,
     * 0.2669E-01, 0.2362E-01, 0.2020E-01, 0.1838E-01, 0.1688E-01,
     * 0.1596E-01, 0.1429E-01, 0.1335E-01, 0.1243E-01, 0.1168E-01,
     * 0.1164E-01, 0.1192E-01, 0.1125E-01, 0.1151E-01, 0.1126E-01,
     * 0.1192E-01, 0.1064E-01, 0.1222E-01, 0.1246E-01, 0.1146E-01,
     * 0.1251E-01, 0.1208E-01, 0.1183E-01, 0.1354E-01, 0.1443E-01,
     * 0.1430E-01, 0.1616E-01, 0.1507E-01, 0.1574E-01, 0.1641E-01,
     * 0.1743E-01, 0.1950E-01, 0.2090E-01, 0.2259E-01, 0.2357E-01,
     * 0.2261E-01, 0.2303E-01, 0.2640E-01, 0.2738E-01, 0.2670E-01,
     * 0.2505E-01, 0.2563E-01, 0.2602E-01, 0.2495E-01, 0.2565E-01,
     * 0.2134E-01, 0.1729E-01, 0.1336E-01, 0.1032E-01,-0.2555E-03,
     *-0.6704E-02,-0.1122E-01,-0.2425E-01,-0.3827E-01,-0.4682E-01,
     *-0.6168E-01,-0.7880E-01,-0.8220E-01,-0.9563E-01,-0.1193E+00,
     *-0.1150E+00,-0.1342E+00,-0.1454E+00,-0.8839E-01,-0.7265E-01,
     *-0.3975E-01, 0.1465E+00,-0.9238E-18 /
        DATA ((QHR(i,j),j=1,83),i=13,13)/
     *-0.2802E-21, 0.2409E-01, 0.5438E-01, 0.3805E-01, 0.7287E-02,
     *-0.6781E-02, 0.2331E-02, 0.2494E-01, 0.3896E-01, 0.4654E-01,
     * 0.5034E-01, 0.5053E-01, 0.4468E-01, 0.3791E-01, 0.3378E-01,
     * 0.2862E-01, 0.2494E-01, 0.2303E-01, 0.2103E-01, 0.1951E-01,
     * 0.1736E-01, 0.1671E-01, 0.1536E-01, 0.1519E-01, 0.1491E-01,
     * 0.1537E-01, 0.1399E-01, 0.1388E-01, 0.1281E-01, 0.1291E-01,
     * 0.1206E-01, 0.1379E-01, 0.1385E-01, 0.1311E-01, 0.1437E-01,
     * 0.1403E-01, 0.1477E-01, 0.1656E-01, 0.1649E-01, 0.1624E-01,
     * 0.1775E-01, 0.1668E-01, 0.1908E-01, 0.1936E-01, 0.1989E-01,
     * 0.2018E-01, 0.2084E-01, 0.2196E-01, 0.2164E-01, 0.2215E-01,
     * 0.2476E-01, 0.2642E-01, 0.2579E-01, 0.2594E-01, 0.2639E-01,
     * 0.2864E-01, 0.2866E-01, 0.2937E-01, 0.2752E-01, 0.2461E-01,
     * 0.2407E-01, 0.2125E-01, 0.1523E-01, 0.1101E-01, 0.9503E-02,
     * 0.2281E-02,-0.7148E-02,-0.1019E-01,-0.2554E-01,-0.4225E-01,
     *-0.5133E-01,-0.6732E-01,-0.8226E-01,-0.8529E-01,-0.8863E-01,
     *-0.1055E+00,-0.1014E+00,-0.1001E+00,-0.1240E+00,-0.1593E-01,
     * 0.1754E+00, 0.2386E+00,-0.8006E-18 /
        DATA ((QHR(i,j),j=1,83),i=14,14)/
     * 0.7227E-21, 0.1962E-01, 0.5306E-01, 0.4545E-01, 0.2058E-01,
     * 0.9166E-02, 0.1769E-01, 0.3513E-01, 0.4622E-01, 0.5277E-01,
     * 0.5581E-01, 0.5464E-01, 0.4927E-01, 0.4313E-01, 0.3835E-01,
     * 0.3267E-01, 0.2844E-01, 0.2600E-01, 0.2379E-01, 0.2197E-01,
     * 0.1969E-01, 0.1876E-01, 0.1747E-01, 0.1693E-01, 0.1670E-01,
     * 0.1727E-01, 0.1623E-01, 0.1590E-01, 0.1470E-01, 0.1446E-01,
     * 0.1374E-01, 0.1538E-01, 0.1575E-01, 0.1494E-01, 0.1548E-01,
     * 0.1542E-01, 0.1628E-01, 0.1779E-01, 0.1797E-01, 0.1813E-01,
     * 0.1948E-01, 0.1875E-01, 0.2064E-01, 0.2149E-01, 0.2214E-01,
     * 0.2241E-01, 0.2331E-01, 0.2450E-01, 0.2494E-01, 0.2608E-01,
     * 0.2845E-01, 0.2964E-01, 0.2964E-01, 0.3016E-01, 0.3082E-01,
     * 0.3255E-01, 0.3317E-01, 0.3460E-01, 0.3345E-01, 0.3161E-01,
     * 0.3140E-01, 0.2850E-01, 0.2306E-01, 0.2084E-01, 0.1854E-01,
     * 0.1152E-01, 0.5739E-02, 0.1794E-02,-0.1378E-01,-0.2810E-01,
     *-0.3814E-01,-0.5394E-01,-0.6431E-01,-0.6360E-01,-0.6949E-01,
     *-0.7644E-01,-0.6970E-01,-0.7127E-01,-0.7447E-01, 0.1157E-01,
     * 0.1504E+00, 0.1925E+00, 0.8456E-18 /
        DATA ((QHR(i,j),j=1,83),i=15,15)/
     * 0.3341E-21, 0.1668E-03, 0.1905E-01, 0.3846E-01, 0.5060E-01,
     * 0.4795E-01, 0.3824E-01, 0.3434E-01, 0.3286E-01, 0.2928E-01,
     * 0.2950E-01, 0.3271E-01, 0.3308E-01, 0.3264E-01, 0.3297E-01,
     * 0.3119E-01, 0.2856E-01, 0.2664E-01, 0.2484E-01, 0.2333E-01,
     * 0.2166E-01, 0.1996E-01, 0.1800E-01, 0.1671E-01, 0.1536E-01,
     * 0.1453E-01, 0.1374E-01, 0.1380E-01, 0.1355E-01, 0.1344E-01,
     * 0.1313E-01, 0.1261E-01, 0.1256E-01, 0.1244E-01, 0.1323E-01,
     * 0.1401E-01, 0.1399E-01, 0.1446E-01, 0.1532E-01, 0.1538E-01,
     * 0.1533E-01, 0.1614E-01, 0.1667E-01, 0.1881E-01, 0.2027E-01,
     * 0.2104E-01, 0.2245E-01, 0.2493E-01, 0.2767E-01, 0.3004E-01,
     * 0.3304E-01, 0.3633E-01, 0.3829E-01, 0.3985E-01, 0.4270E-01,
     * 0.4578E-01, 0.4765E-01, 0.4812E-01, 0.4968E-01, 0.5035E-01,
     * 0.5016E-01, 0.5161E-01, 0.5113E-01, 0.4874E-01, 0.4621E-01,
     * 0.4301E-01, 0.3629E-01, 0.3227E-01, 0.2879E-01, 0.2171E-01,
     * 0.2015E-01, 0.1023E-01,-0.1314E-02,-0.4303E-02,-0.1217E-01,
     *-0.1671E-01,-0.4811E-02, 0.3506E-03, 0.1281E-01, 0.9823E-01,
     * 0.1908E+00, 0.1472E+00,-0.4975E-18 /
        DATA ((QHR(i,j),j=1,83),i=16,16)/
     * 0.4569E-22,-0.3494E-02, 0.4438E-02, 0.1387E-01, 0.1729E-01,
     * 0.1620E-01, 0.1017E-01,-0.2190E-02,-0.1421E-01,-0.2101E-01,
     *-0.2372E-01,-0.2141E-01,-0.1531E-01,-0.1001E-01,-0.4689E-02,
     * 0.1363E-02, 0.5275E-02, 0.7626E-02, 0.8819E-02, 0.8749E-02,
     * 0.8743E-02, 0.8694E-02, 0.8697E-02, 0.8481E-02, 0.7835E-02,
     * 0.7277E-02, 0.6824E-02, 0.6472E-02, 0.6108E-02, 0.5573E-02,
     * 0.5435E-02, 0.5348E-02, 0.5386E-02, 0.5309E-02, 0.5225E-02,
     * 0.5663E-02, 0.6047E-02, 0.6261E-02, 0.7047E-02, 0.8086E-02,
     * 0.8532E-02, 0.8645E-02, 0.9205E-02, 0.1082E-01, 0.1264E-01,
     * 0.1413E-01, 0.1593E-01, 0.1813E-01, 0.2008E-01, 0.2160E-01,
     * 0.2380E-01, 0.2666E-01, 0.2888E-01, 0.3036E-01, 0.3324E-01,
     * 0.3643E-01, 0.3835E-01, 0.4051E-01, 0.4391E-01, 0.4708E-01,
     * 0.4807E-01, 0.5076E-01, 0.5418E-01, 0.5633E-01, 0.5680E-01,
     * 0.5788E-01, 0.5680E-01, 0.5861E-01, 0.5881E-01, 0.5610E-01,
     * 0.5159E-01, 0.4816E-01, 0.4755E-01, 0.4797E-01, 0.4573E-01,
     * 0.4337E-01, 0.4462E-01, 0.5837E-01, 0.9104E-01, 0.1244E+00,
     * 0.1420E+00, 0.8351E-01, 0.2650E-18 /
        DATA ((QHR(i,j),j=1,83),i=17,17)/
     * 0.3013E-22,-0.6586E-02,-0.6701E-02, 0.3526E-02, 0.1083E-01,
     * 0.8649E-02,-0.1759E-02,-0.1359E-01,-0.2471E-01,-0.3343E-01,
     *-0.3760E-01,-0.3836E-01,-0.3670E-01,-0.3092E-01,-0.2429E-01,
     *-0.1861E-01,-0.1251E-01,-0.8017E-02,-0.4221E-02,-0.1206E-02,
     * 0.2898E-03, 0.1564E-02, 0.1966E-02, 0.1962E-02, 0.2216E-02,
     * 0.2135E-02, 0.1819E-02, 0.1428E-02, 0.1478E-02, 0.1519E-02,
     * 0.1486E-02, 0.1357E-02, 0.1147E-02, 0.1426E-02, 0.1829E-02,
     * 0.1888E-02, 0.2242E-02, 0.3050E-02, 0.3673E-02, 0.4362E-02,
     * 0.5665E-02, 0.6338E-02, 0.6978E-02, 0.7626E-02, 0.8406E-02,
     * 0.9918E-02, 0.1140E-01, 0.1239E-01, 0.1399E-01, 0.1624E-01,
     * 0.1771E-01, 0.1879E-01, 0.2146E-01, 0.2455E-01, 0.2607E-01,
     * 0.2811E-01, 0.3165E-01, 0.3450E-01, 0.3637E-01, 0.3955E-01,
     * 0.4360E-01, 0.4602E-01, 0.4828E-01, 0.5033E-01, 0.5366E-01,
     * 0.5725E-01, 0.6020E-01, 0.5813E-01, 0.5912E-01, 0.6185E-01,
     * 0.6386E-01, 0.6292E-01, 0.5653E-01, 0.5427E-01, 0.5557E-01,
     * 0.6068E-01, 0.6457E-01, 0.6750E-01, 0.5570E-01, 0.7216E-01,
     * 0.1193E+00, 0.7938E-01,-0.1204E-18 /
        DATA ((QHR(i,j),j=1,83),i=18,18)/
     *-0.8339E-22,-0.3001E-02,-0.1501E-02, 0.9853E-02, 0.1559E-01,
     * 0.1043E-01, 0.2577E-02,-0.3925E-02,-0.1012E-01,-0.1511E-01,
     *-0.2013E-01,-0.2543E-01,-0.2928E-01,-0.3297E-01,-0.3565E-01,
     *-0.3700E-01,-0.3797E-01,-0.3668E-01,-0.3487E-01,-0.3197E-01,
     *-0.2826E-01,-0.2552E-01,-0.2208E-01,-0.1931E-01,-0.1667E-01,
     *-0.1454E-01,-0.1253E-01,-0.1133E-01,-0.1019E-01,-0.9347E-02,
     *-0.8573E-02,-0.8007E-02,-0.7655E-02,-0.7264E-02,-0.6791E-02,
     *-0.6614E-02,-0.6553E-02,-0.6380E-02,-0.6260E-02,-0.6197E-02,
     *-0.6101E-02,-0.6076E-02,-0.6109E-02,-0.5996E-02,-0.5687E-02,
     *-0.5619E-02,-0.5624E-02,-0.5103E-02,-0.4600E-02,-0.4475E-02,
     *-0.3889E-02,-0.2786E-02,-0.2153E-02,-0.1486E-02, 0.5661E-05,
     * 0.1504E-02, 0.2807E-02, 0.4649E-02, 0.6591E-02, 0.9116E-02,
     * 0.1215E-01, 0.1426E-01, 0.1796E-01, 0.2280E-01, 0.2606E-01,
     * 0.3027E-01, 0.3632E-01, 0.4196E-01, 0.4816E-01, 0.5429E-01,
     * 0.6013E-01, 0.6981E-01, 0.7773E-01, 0.8519E-01, 0.9469E-01,
     * 0.1001E+00, 0.1114E+00, 0.1160E+00, 0.1219E+00, 0.1272E+00,
     * 0.8560E-01, 0.3885E-01,-0.3065E-18 /
        DATA ((QHR(i,j),j=1,83),i=19,19)/
     *-0.1652E-21,-0.3713E-04, 0.3969E-02, 0.7870E-02, 0.4872E-02,
     * 0.6642E-03,-0.2740E-02,-0.4686E-02,-0.6046E-02,-0.7327E-02,
     *-0.8648E-02,-0.9896E-02,-0.1121E-01,-0.1258E-01,-0.1432E-01,
     *-0.1624E-01,-0.1813E-01,-0.1998E-01,-0.2148E-01,-0.2289E-01,
     *-0.2360E-01,-0.2407E-01,-0.2368E-01,-0.2290E-01,-0.2176E-01,
     *-0.2038E-01,-0.1895E-01,-0.1772E-01,-0.1648E-01,-0.1539E-01,
     *-0.1445E-01,-0.1367E-01,-0.1312E-01,-0.1278E-01,-0.1244E-01,
     *-0.1223E-01,-0.1218E-01,-0.1215E-01,-0.1213E-01,-0.1218E-01,
     *-0.1234E-01,-0.1244E-01,-0.1256E-01,-0.1278E-01,-0.1301E-01,
     *-0.1334E-01,-0.1371E-01,-0.1394E-01,-0.1419E-01,-0.1459E-01,
     *-0.1482E-01,-0.1493E-01,-0.1521E-01,-0.1542E-01,-0.1534E-01,
     *-0.1540E-01,-0.1540E-01,-0.1501E-01,-0.1470E-01,-0.1420E-01,
     *-0.1317E-01,-0.1214E-01,-0.1083E-01,-0.8337E-02,-0.6306E-02,
     *-0.3129E-02, 0.1217E-02, 0.5563E-02, 0.1181E-01, 0.1875E-01,
     * 0.2696E-01, 0.3742E-01, 0.4885E-01, 0.6171E-01, 0.7738E-01,
     * 0.9339E-01, 0.1113E+00, 0.1272E+00, 0.1371E+00, 0.1355E+00,
     * 0.7581E-01, 0.2173E-01, 0.9486E-19 /
        DATA ((QHR(i,j),j=1,83),i=20,20)/
     *-0.4718E-22,-0.3367E-03, 0.9818E-03, 0.5409E-02, 0.7205E-02,
     * 0.4406E-02,-0.4729E-03,-0.5499E-02,-0.1012E-01,-0.1419E-01,
     *-0.1783E-01,-0.2108E-01,-0.2385E-01,-0.2614E-01,-0.2769E-01,
     *-0.2862E-01,-0.2888E-01,-0.2848E-01,-0.2766E-01,-0.2647E-01,
     *-0.2509E-01,-0.2369E-01,-0.2232E-01,-0.2109E-01,-0.2002E-01,
     *-0.1907E-01,-0.1834E-01,-0.1780E-01,-0.1737E-01,-0.1708E-01,
     *-0.1690E-01,-0.1683E-01,-0.1692E-01,-0.1707E-01,-0.1725E-01,
     *-0.1755E-01,-0.1795E-01,-0.1836E-01,-0.1885E-01,-0.1937E-01,
     *-0.1993E-01,-0.2026E-01,-0.2061E-01,-0.2125E-01,-0.2188E-01,
     *-0.2266E-01,-0.2344E-01,-0.2414E-01,-0.2489E-01,-0.2573E-01,
     *-0.2651E-01,-0.2712E-01,-0.2791E-01,-0.2868E-01,-0.2913E-01,
     *-0.2965E-01,-0.3011E-01,-0.3031E-01,-0.3038E-01,-0.3013E-01,
     *-0.2967E-01,-0.2892E-01,-0.2755E-01,-0.2562E-01,-0.2328E-01,
     *-0.2036E-01,-0.1595E-01,-0.1081E-01,-0.4895E-02, 0.2784E-02,
     * 0.1122E-01, 0.2192E-01, 0.3380E-01, 0.4555E-01, 0.5906E-01,
     * 0.7140E-01, 0.8277E-01, 0.9052E-01, 0.9304E-01, 0.8736E-01,
     * 0.5598E-01, 0.1352E-01,-0.1058E-18 /
c************** MIE (phase fun uh) ***************
        DATA ((UHR(i,j),j=1,83),i= 1, 1)/
     *-0.3243E+00,-0.2275E+00,-0.1795E-01, 0.4439E-01, 0.3578E-01,
     * 0.1267E-01,-0.1034E-01,-0.3552E-01,-0.5009E-01,-0.4099E-01,
     *-0.2721E-01,-0.2594E-01,-0.2533E-01,-0.2248E-01,-0.2150E-01,
     *-0.2233E-01,-0.2209E-01,-0.2106E-01,-0.2203E-01,-0.2200E-01,
     *-0.2227E-01,-0.2192E-01,-0.2216E-01,-0.2116E-01,-0.2043E-01,
     *-0.1964E-01,-0.1853E-01,-0.1754E-01,-0.1771E-01,-0.1472E-01,
     *-0.1352E-01,-0.9567E-02,-0.9255E-02,-0.6918E-02,-0.2846E-02,
     *-0.1439E-02, 0.4171E-02, 0.8762E-02, 0.1090E-01, 0.1840E-01,
     * 0.2884E-01, 0.2866E-01, 0.3381E-01, 0.3960E-01, 0.5157E-01,
     * 0.6634E-01, 0.7588E-01, 0.8726E-01, 0.9928E-01, 0.1166E+00,
     * 0.1371E+00, 0.1568E+00, 0.1820E+00, 0.2087E+00, 0.2357E+00,
     * 0.2673E+00, 0.2970E+00, 0.3342E+00, 0.3698E+00, 0.4180E+00,
     * 0.4708E+00, 0.5307E+00, 0.5840E+00, 0.6446E+00, 0.7125E+00,
     * 0.8015E+00, 0.8760E+00, 0.9746E+00, 0.1090E+01, 0.1199E+01,
     * 0.1360E+01, 0.1526E+01, 0.1764E+01, 0.2077E+01, 0.2534E+01,
     * 0.3247E+01, 0.4514E+01, 0.6968E+01, 0.1256E+02, 0.2829E+02,
     * 0.8949E+02, 0.5462E+03, 0.5621E+04 /
        DATA ((UHR(i,j),j=1,83),i= 2, 2)/
     *-0.3504E+00,-0.2583E+00,-0.4707E-01, 0.2789E-01, 0.3269E-01,
     * 0.1350E-01,-0.1829E-01,-0.4433E-01,-0.4210E-01,-0.3186E-01,
     *-0.3047E-01,-0.2724E-01,-0.2107E-01,-0.1830E-01,-0.1933E-01,
     *-0.2083E-01,-0.2007E-01,-0.1973E-01,-0.1893E-01,-0.1882E-01,
     *-0.1979E-01,-0.1974E-01,-0.2000E-01,-0.1834E-01,-0.1736E-01,
     *-0.1565E-01,-0.1667E-01,-0.1492E-01,-0.1470E-01,-0.1251E-01,
     *-0.1047E-01,-0.8317E-02,-0.4739E-02,-0.3179E-02, 0.2167E-02,
     * 0.5453E-02, 0.6826E-02, 0.1329E-01, 0.1912E-01, 0.2370E-01,
     * 0.3120E-01, 0.3354E-01, 0.4061E-01, 0.4866E-01, 0.5869E-01,
     * 0.6984E-01, 0.8732E-01, 0.1039E+00, 0.1181E+00, 0.1346E+00,
     * 0.1507E+00, 0.1733E+00, 0.1985E+00, 0.2222E+00, 0.2526E+00,
     * 0.2853E+00, 0.3221E+00, 0.3598E+00, 0.4059E+00, 0.4596E+00,
     * 0.5129E+00, 0.5654E+00, 0.6197E+00, 0.6905E+00, 0.7740E+00,
     * 0.8514E+00, 0.9416E+00, 0.1049E+01, 0.1159E+01, 0.1294E+01,
     * 0.1463E+01, 0.1657E+01, 0.1917E+01, 0.2262E+01, 0.2764E+01,
     * 0.3565E+01, 0.4972E+01, 0.7674E+01, 0.1379E+02, 0.3050E+02,
     * 0.9305E+02, 0.5222E+03, 0.4201E+04 /
        DATA ((UHR(i,j),j=1,83),i= 3, 3)/
     *-0.3625E+00,-0.2725E+00,-0.5735E-01, 0.2289E-01, 0.3027E-01,
     * 0.7699E-02,-0.2313E-01,-0.4096E-01,-0.3741E-01,-0.3494E-01,
     *-0.3292E-01,-0.2654E-01,-0.1916E-01,-0.1894E-01,-0.1920E-01,
     *-0.1882E-01,-0.1973E-01,-0.1992E-01,-0.1825E-01,-0.1880E-01,
     *-0.1896E-01,-0.1868E-01,-0.1895E-01,-0.1813E-01,-0.1723E-01,
     *-0.1625E-01,-0.1593E-01,-0.1448E-01,-0.1257E-01,-0.1157E-01,
     *-0.9595E-02,-0.9181E-02,-0.4405E-02,-0.2159E-02, 0.1466E-02,
     * 0.7070E-02, 0.8585E-02, 0.1377E-01, 0.2235E-01, 0.2656E-01,
     * 0.3128E-01, 0.3672E-01, 0.4147E-01, 0.5297E-01, 0.6060E-01,
     * 0.7029E-01, 0.8620E-01, 0.1049E+00, 0.1238E+00, 0.1412E+00,
     * 0.1578E+00, 0.1821E+00, 0.2055E+00, 0.2309E+00, 0.2616E+00,
     * 0.2932E+00, 0.3324E+00, 0.3703E+00, 0.4198E+00, 0.4665E+00,
     * 0.5173E+00, 0.5667E+00, 0.6307E+00, 0.7018E+00, 0.7826E+00,
     * 0.8565E+00, 0.9551E+00, 0.1059E+01, 0.1172E+01, 0.1320E+01,
     * 0.1479E+01, 0.1691E+01, 0.1946E+01, 0.2300E+01, 0.2815E+01,
     * 0.3638E+01, 0.5059E+01, 0.7829E+01, 0.1406E+02, 0.3097E+02,
     * 0.9377E+02, 0.5161E+03, 0.3938E+04 /
        DATA ((UHR(i,j),j=1,83),i= 4, 4)/
     *-0.3853E+00,-0.2956E+00,-0.7782E-01, 0.1077E-01, 0.2519E-01,
     * 0.1022E-01,-0.1947E-01,-0.4326E-01,-0.3956E-01,-0.3079E-01,
     *-0.2897E-01,-0.2497E-01,-0.1821E-01,-0.1610E-01,-0.1711E-01,
     *-0.1834E-01,-0.1796E-01,-0.1765E-01,-0.1662E-01,-0.1674E-01,
     *-0.1769E-01,-0.1750E-01,-0.1776E-01,-0.1617E-01,-0.1504E-01,
     *-0.1340E-01,-0.1434E-01,-0.1256E-01,-0.1194E-01,-0.9849E-02,
     *-0.7649E-02,-0.5715E-02,-0.1671E-02, 0.2362E-03, 0.5500E-02,
     * 0.9494E-02, 0.1093E-01, 0.1738E-01, 0.2426E-01, 0.2912E-01,
     * 0.3616E-01, 0.3928E-01, 0.4609E-01, 0.5536E-01, 0.6555E-01,
     * 0.7693E-01, 0.9465E-01, 0.1124E+00, 0.1284E+00, 0.1458E+00,
     * 0.1627E+00, 0.1869E+00, 0.2130E+00, 0.2380E+00, 0.2697E+00,
     * 0.3039E+00, 0.3427E+00, 0.3819E+00, 0.4307E+00, 0.4853E+00,
     * 0.5405E+00, 0.5953E+00, 0.6551E+00, 0.7291E+00, 0.8157E+00,
     * 0.8973E+00, 0.9948E+00, 0.1107E+01, 0.1224E+01, 0.1371E+01,
     * 0.1549E+01, 0.1760E+01, 0.2038E+01, 0.2412E+01, 0.2954E+01,
     * 0.3824E+01, 0.5340E+01, 0.8243E+01, 0.1474E+02, 0.3212E+02,
     * 0.9507E+02, 0.4991E+03, 0.3362E+04 /
        DATA ((UHR(i,j),j=1,83),i= 5, 5)/
     *-0.4323E+00,-0.3391E+00,-0.1088E+00,-0.3171E-02, 0.1441E-01,
     * 0.2126E-03,-0.1919E-01,-0.3340E-01,-0.3951E-01,-0.3483E-01,
     *-0.2856E-01,-0.1972E-01,-0.1776E-01,-0.1724E-01,-0.1587E-01,
     *-0.1416E-01,-0.1489E-01,-0.1631E-01,-0.1659E-01,-0.1658E-01,
     *-0.1541E-01,-0.1529E-01,-0.1377E-01,-0.1455E-01,-0.1482E-01,
     *-0.1458E-01,-0.1217E-01,-0.1104E-01,-0.7639E-02,-0.7120E-02,
     *-0.5115E-02,-0.3964E-02,-0.9363E-03, 0.3409E-02, 0.4963E-02,
     * 0.1041E-01, 0.1626E-01, 0.2074E-01, 0.2805E-01, 0.3467E-01,
     * 0.3989E-01, 0.4751E-01, 0.4928E-01, 0.6204E-01, 0.7210E-01,
     * 0.8275E-01, 0.9633E-01, 0.1117E+00, 0.1331E+00, 0.1533E+00,
     * 0.1769E+00, 0.2014E+00, 0.2260E+00, 0.2561E+00, 0.2881E+00,
     * 0.3213E+00, 0.3611E+00, 0.4039E+00, 0.4510E+00, 0.4938E+00,
     * 0.5458E+00, 0.6068E+00, 0.6804E+00, 0.7523E+00, 0.8294E+00,
     * 0.9173E+00, 0.1025E+01, 0.1132E+01, 0.1265E+01, 0.1425E+01,
     * 0.1592E+01, 0.1825E+01, 0.2104E+01, 0.2491E+01, 0.3067E+01,
     * 0.3976E+01, 0.5526E+01, 0.8562E+01, 0.1525E+02, 0.3304E+02,
     * 0.9614E+02, 0.4844E+03, 0.2954E+04 /
        DATA ((UHR(i,j),j=1,83),i= 6, 6)/
     *-0.4322E+00,-0.3413E+00,-0.1128E+00,-0.7923E-02, 0.1379E-01,
     * 0.7758E-02,-0.1261E-01,-0.3633E-01,-0.4292E-01,-0.2978E-01,
     *-0.2259E-01,-0.2031E-01,-0.1749E-01,-0.1337E-01,-0.1375E-01,
     *-0.1573E-01,-0.1481E-01,-0.1421E-01,-0.1481E-01,-0.1419E-01,
     *-0.1492E-01,-0.1523E-01,-0.1567E-01,-0.1377E-01,-0.1284E-01,
     *-0.1100E-01,-0.1088E-01,-0.9663E-02,-0.9634E-02,-0.6501E-02,
     *-0.4269E-02,-0.2647E-03, 0.1572E-02, 0.3747E-02, 0.9521E-02,
     * 0.1195E-01, 0.1610E-01, 0.2243E-01, 0.2677E-01, 0.3418E-01,
     * 0.4500E-01, 0.4617E-01, 0.5283E-01, 0.6081E-01, 0.7332E-01,
     * 0.8783E-01, 0.1031E+00, 0.1186E+00, 0.1329E+00, 0.1523E+00,
     * 0.1735E+00, 0.1964E+00, 0.2247E+00, 0.2529E+00, 0.2857E+00,
     * 0.3218E+00, 0.3602E+00, 0.4026E+00, 0.4483E+00, 0.5066E+00,
     * 0.5661E+00, 0.6303E+00, 0.6903E+00, 0.7684E+00, 0.8541E+00,
     * 0.9506E+00, 0.1049E+01, 0.1168E+01, 0.1300E+01, 0.1446E+01,
     * 0.1639E+01, 0.1858E+01, 0.2160E+01, 0.2567E+01, 0.3154E+01,
     * 0.4083E+01, 0.5714E+01, 0.8808E+01, 0.1561E+02, 0.3357E+02,
     * 0.9637E+02, 0.4741E+03, 0.2722E+04 /
        DATA ((UHR(i,j),j=1,83),i= 7, 7)/
     *-0.4427E+00,-0.3553E+00,-0.1299E+00,-0.2048E-01, 0.8951E-02,
     * 0.4957E-02,-0.1808E-01,-0.4058E-01,-0.3879E-01,-0.2715E-01,
     *-0.2400E-01,-0.2033E-01,-0.1474E-01,-0.1181E-01,-0.1288E-01,
     *-0.1461E-01,-0.1396E-01,-0.1361E-01,-0.1308E-01,-0.1296E-01,
     *-0.1394E-01,-0.1404E-01,-0.1414E-01,-0.1242E-01,-0.1119E-01,
     *-0.9432E-02,-0.1012E-01,-0.8492E-02,-0.7970E-02,-0.5433E-02,
     *-0.2901E-02, 0.4081E-05, 0.3413E-02, 0.5730E-02, 0.1153E-01,
     * 0.1514E-01, 0.1751E-01, 0.2428E-01, 0.3088E-01, 0.3701E-01,
     * 0.4562E-01, 0.4830E-01, 0.5523E-01, 0.6469E-01, 0.7658E-01,
     * 0.8945E-01, 0.1072E+00, 0.1249E+00, 0.1413E+00, 0.1601E+00,
     * 0.1794E+00, 0.2045E+00, 0.2329E+00, 0.2599E+00, 0.2936E+00,
     * 0.3306E+00, 0.3712E+00, 0.4133E+00, 0.4634E+00, 0.5224E+00,
     * 0.5817E+00, 0.6434E+00, 0.7071E+00, 0.7865E+00, 0.8777E+00,
     * 0.9707E+00, 0.1076E+01, 0.1197E+01, 0.1329E+01, 0.1486E+01,
     * 0.1684E+01, 0.1917E+01, 0.2228E+01, 0.2649E+01, 0.3257E+01,
     * 0.4231E+01, 0.5920E+01, 0.9113E+01, 0.1611E+02, 0.3427E+02,
     * 0.9675E+02, 0.4596E+03, 0.2420E+04 /
        DATA ((UHR(i,j),j=1,83),i= 8, 8)/
     *-0.4960E+00,-0.4083E+00,-0.1697E+00,-0.4294E-01,-0.5037E-02,
     *-0.4217E-02,-0.1286E-01,-0.3018E-01,-0.3998E-01,-0.3348E-01,
     *-0.1870E-01,-0.1341E-01,-0.1375E-01,-0.1335E-01,-0.1116E-01,
     *-0.9871E-02,-0.1029E-01,-0.1100E-01,-0.1255E-01,-0.1280E-01,
     *-0.1210E-01,-0.1134E-01,-0.1036E-01,-0.1091E-01,-0.1013E-01,
     *-0.9804E-02,-0.7304E-02,-0.5993E-02,-0.4045E-02,-0.2252E-02,
     * 0.5060E-04, 0.3228E-02, 0.5120E-02, 0.9411E-02, 0.1177E-01,
     * 0.1600E-01, 0.2377E-01, 0.2858E-01, 0.3357E-01, 0.4242E-01,
     * 0.5172E-01, 0.5684E-01, 0.6051E-01, 0.6992E-01, 0.8332E-01,
     * 0.9825E-01, 0.1103E+00, 0.1248E+00, 0.1436E+00, 0.1660E+00,
     * 0.1921E+00, 0.2160E+00, 0.2439E+00, 0.2774E+00, 0.3101E+00,
     * 0.3485E+00, 0.3871E+00, 0.4347E+00, 0.4801E+00, 0.5322E+00,
     * 0.5914E+00, 0.6611E+00, 0.7383E+00, 0.8166E+00, 0.9000E+00,
     * 0.1002E+01, 0.1109E+01, 0.1238E+01, 0.1383E+01, 0.1546E+01,
     * 0.1745E+01, 0.1989E+01, 0.2310E+01, 0.2749E+01, 0.3395E+01,
     * 0.4409E+01, 0.6153E+01, 0.9488E+01, 0.1667E+02, 0.3516E+02,
     * 0.9714E+02, 0.4412E+03, 0.2096E+04 /
        DATA ((UHR(i,j),j=1,83),i= 9, 9)/
     *-0.5164E+00,-0.4297E+00,-0.1933E+00,-0.5802E-01,-0.1449E-01,
     *-0.1248E-01,-0.2362E-01,-0.3299E-01,-0.3497E-01,-0.2895E-01,
     *-0.2253E-01,-0.1395E-01,-0.1104E-01,-0.1042E-01,-0.9425E-02,
     *-0.8193E-02,-0.9074E-02,-0.1039E-01,-0.1045E-01,-0.1053E-01,
     *-0.9603E-02,-0.9431E-02,-0.8129E-02,-0.8650E-02,-0.8813E-02,
     *-0.8393E-02,-0.6066E-02,-0.4523E-02,-0.1066E-02,-0.7197E-04,
     * 0.1953E-02, 0.3462E-02, 0.7174E-02, 0.1161E-01, 0.1407E-01,
     * 0.1987E-01, 0.2597E-01, 0.3146E-01, 0.3938E-01, 0.4644E-01,
     * 0.5292E-01, 0.6022E-01, 0.6336E-01, 0.7667E-01, 0.8780E-01,
     * 0.1000E+00, 0.1155E+00, 0.1330E+00, 0.1551E+00, 0.1766E+00,
     * 0.2015E+00, 0.2285E+00, 0.2559E+00, 0.2885E+00, 0.3234E+00,
     * 0.3596E+00, 0.4029E+00, 0.4494E+00, 0.5017E+00, 0.5508E+00,
     * 0.6100E+00, 0.6772E+00, 0.7563E+00, 0.8359E+00, 0.9253E+00,
     * 0.1024E+01, 0.1142E+01, 0.1267E+01, 0.1419E+01, 0.1601E+01,
     * 0.1801E+01, 0.2069E+01, 0.2401E+01, 0.2858E+01, 0.3541E+01,
     * 0.4609E+01, 0.6420E+01, 0.9875E+01, 0.1726E+02, 0.3593E+02,
     * 0.9709E+02, 0.4210E+03, 0.1798E+04 /
        DATA ((UHR(i,j),j=1,83),i=10,10)/
     *-0.5181E+00,-0.4384E+00,-0.2108E+00,-0.7562E-01,-0.2196E-01,
     *-0.1282E-01,-0.2630E-01,-0.3815E-01,-0.3195E-01,-0.2503E-01,
     *-0.2079E-01,-0.1406E-01,-0.7127E-02,-0.6479E-02,-0.7255E-02,
     *-0.7829E-02,-0.8612E-02,-0.8582E-02,-0.7332E-02,-0.7874E-02,
     *-0.8479E-02,-0.8158E-02,-0.8214E-02,-0.6986E-02,-0.5735E-02,
     *-0.4530E-02,-0.4489E-02,-0.2666E-02,-0.6568E-03, 0.1308E-02,
     * 0.3630E-02, 0.5450E-02, 0.1033E-01, 0.1366E-01, 0.1868E-01,
     * 0.2418E-01, 0.2711E-01, 0.3375E-01, 0.4277E-01, 0.4937E-01,
     * 0.5631E-01, 0.6125E-01, 0.6710E-01, 0.7970E-01, 0.9125E-01,
     * 0.1041E+00, 0.1221E+00, 0.1425E+00, 0.1631E+00, 0.1837E+00,
     * 0.2047E+00, 0.2335E+00, 0.2629E+00, 0.2932E+00, 0.3292E+00,
     * 0.3681E+00, 0.4129E+00, 0.4581E+00, 0.5142E+00, 0.5726E+00,
     * 0.6361E+00, 0.7018E+00, 0.7780E+00, 0.8627E+00, 0.9614E+00,
     * 0.1063E+01, 0.1183E+01, 0.1315E+01, 0.1466E+01, 0.1652E+01,
     * 0.1872E+01, 0.2149E+01, 0.2502E+01, 0.2988E+01, 0.3698E+01,
     * 0.4824E+01, 0.6732E+01, 0.1030E+02, 0.1786E+02, 0.3658E+02,
     * 0.9643E+02, 0.3996E+03, 0.1542E+04 /
        DATA ((UHR(i,j),j=1,83),i=11,11)/
     *-0.5654E+00,-0.4828E+00,-0.2465E+00,-0.9581E-01,-0.3659E-01,
     *-0.2283E-01,-0.2620E-01,-0.3239E-01,-0.3282E-01,-0.2550E-01,
     *-0.1786E-01,-0.9588E-02,-0.7054E-02,-0.6420E-02,-0.5374E-02,
     *-0.4197E-02,-0.5056E-02,-0.6425E-02,-0.6812E-02,-0.6876E-02,
     *-0.6017E-02,-0.5717E-02,-0.4357E-02,-0.4872E-02,-0.5091E-02,
     *-0.4568E-02,-0.2200E-02,-0.4823E-03, 0.2991E-02, 0.4298E-02,
     * 0.6428E-02, 0.8340E-02, 0.1206E-01, 0.1669E-01, 0.1942E-01,
     * 0.2527E-01, 0.3205E-01, 0.3803E-01, 0.4582E-01, 0.5340E-01,
     * 0.6080E-01, 0.6801E-01, 0.7166E-01, 0.8498E-01, 0.9705E-01,
     * 0.1104E+00, 0.1264E+00, 0.1444E+00, 0.1667E+00, 0.1891E+00,
     * 0.2154E+00, 0.2433E+00, 0.2723E+00, 0.3065E+00, 0.3430E+00,
     * 0.3811E+00, 0.4260E+00, 0.4750E+00, 0.5291E+00, 0.5819E+00,
     * 0.6447E+00, 0.7165E+00, 0.7996E+00, 0.8840E+00, 0.9791E+00,
     * 0.1086E+01, 0.1211E+01, 0.1346E+01, 0.1510E+01, 0.1705E+01,
     * 0.1925E+01, 0.2215E+01, 0.2579E+01, 0.3080E+01, 0.3826E+01,
     * 0.4986E+01, 0.6937E+01, 0.1060E+02, 0.1828E+02, 0.3712E+02,
     * 0.9598E+02, 0.3821E+03, 0.1362E+04 /
        DATA ((UHR(i,j),j=1,83),i=12,12)/
     *-0.5712E+00,-0.4907E+00,-0.2569E+00,-0.1062E+00,-0.4171E-01,
     *-0.1919E-01,-0.1819E-01,-0.2964E-01,-0.3479E-01,-0.2321E-01,
     *-0.1096E-01,-0.7853E-02,-0.6274E-02,-0.3348E-02,-0.2809E-02,
     *-0.4043E-02,-0.4110E-02,-0.3913E-02,-0.5076E-02,-0.5094E-02,
     *-0.5268E-02,-0.5347E-02,-0.5671E-02,-0.4336E-02,-0.3083E-02,
     *-0.1539E-02, 0.4284E-04, 0.1385E-02, 0.1904E-02, 0.5102E-02,
     * 0.8036E-02, 0.1239E-01, 0.1458E-01, 0.1793E-01, 0.2313E-01,
     * 0.2711E-01, 0.3347E-01, 0.3973E-01, 0.4503E-01, 0.5426E-01,
     * 0.6591E-01, 0.6919E-01, 0.7529E-01, 0.8497E-01, 0.9891E-01,
     * 0.1154E+00, 0.1306E+00, 0.1477E+00, 0.1660E+00, 0.1895E+00,
     * 0.2151E+00, 0.2408E+00, 0.2716E+00, 0.3057E+00, 0.3426E+00,
     * 0.3843E+00, 0.4279E+00, 0.4780E+00, 0.5297E+00, 0.5929E+00,
     * 0.6610E+00, 0.7352E+00, 0.8123E+00, 0.9047E+00, 0.1002E+01,
     * 0.1117E+01, 0.1239E+01, 0.1384E+01, 0.1548E+01, 0.1734E+01,
     * 0.1970E+01, 0.2254E+01, 0.2638E+01, 0.3163E+01, 0.3919E+01,
     * 0.5103E+01, 0.7120E+01, 0.1084E+02, 0.1855E+02, 0.3737E+02,
     * 0.9531E+02, 0.3706E+03, 0.1262E+04 /
        DATA ((UHR(i,j),j=1,83),i=13,13)/
     *-0.5994E+00,-0.5223E+00,-0.2911E+00,-0.1285E+00,-0.5458E-01,
     *-0.2960E-01,-0.2650E-01,-0.3047E-01,-0.2948E-01,-0.2136E-01,
     *-0.1299E-01,-0.5201E-02,-0.2967E-02,-0.2263E-02,-0.1152E-02,
     *-0.9091E-04,-0.9361E-03,-0.2342E-02,-0.2902E-02,-0.2954E-02,
     *-0.2203E-02,-0.1818E-02,-0.4951E-03,-0.9190E-03,-0.1151E-02,
     *-0.4745E-03, 0.1872E-02, 0.3777E-02, 0.7191E-02, 0.8798E-02,
     * 0.1108E-01, 0.1324E-01, 0.1705E-01, 0.2177E-01, 0.2486E-01,
     * 0.3082E-01, 0.3800E-01, 0.4450E-01, 0.5224E-01, 0.6014E-01,
     * 0.6843E-01, 0.7551E-01, 0.7977E-01, 0.9305E-01, 0.1059E+00,
     * 0.1202E+00, 0.1368E+00, 0.1554E+00, 0.1779E+00, 0.2012E+00,
     * 0.2285E+00, 0.2573E+00, 0.2878E+00, 0.3235E+00, 0.3616E+00,
     * 0.4016E+00, 0.4480E+00, 0.4997E+00, 0.5559E+00, 0.6121E+00,
     * 0.6787E+00, 0.7554E+00, 0.8431E+00, 0.9325E+00, 0.1034E+01,
     * 0.1149E+01, 0.1282E+01, 0.1430E+01, 0.1606E+01, 0.1816E+01,
     * 0.2058E+01, 0.2372E+01, 0.2772E+01, 0.3318E+01, 0.4130E+01,
     * 0.5378E+01, 0.7463E+01, 0.1131E+02, 0.1919E+02, 0.3793E+02,
     * 0.9376E+02, 0.3425E+03, 0.1035E+04 /
        DATA ((UHR(i,j),j=1,83),i=14,14)/
     *-0.5925E+00,-0.5233E+00,-0.3052E+00,-0.1376E+00,-0.5303E-01,
     *-0.2092E-01,-0.1634E-01,-0.2247E-01,-0.2243E-01,-0.1528E-01,
     *-0.6690E-02,-0.6130E-03, 0.5223E-03, 0.1365E-02, 0.2894E-02,
     * 0.3881E-02, 0.3137E-02, 0.1673E-02, 0.9269E-03, 0.9240E-03,
     * 0.1605E-02, 0.2073E-02, 0.3270E-02, 0.3030E-02, 0.2866E-02,
     * 0.3714E-02, 0.6027E-02, 0.8167E-02, 0.1134E-01, 0.1320E-01,
     * 0.1583E-01, 0.1807E-01, 0.2180E-01, 0.2645E-01, 0.2995E-01,
     * 0.3603E-01, 0.4340E-01, 0.5040E-01, 0.5794E-01, 0.6595E-01,
     * 0.7530E-01, 0.8223E-01, 0.8715E-01, 0.1000E+00, 0.1134E+00,
     * 0.1289E+00, 0.1456E+00, 0.1646E+00, 0.1870E+00, 0.2113E+00,
     * 0.2396E+00, 0.2686E+00, 0.3003E+00, 0.3377E+00, 0.3771E+00,
     * 0.4195E+00, 0.4673E+00, 0.5221E+00, 0.5802E+00, 0.6406E+00,
     * 0.7117E+00, 0.7941E+00, 0.8877E+00, 0.9832E+00, 0.1093E+01,
     * 0.1217E+01, 0.1360E+01, 0.1524E+01, 0.1717E+01, 0.1942E+01,
     * 0.2212E+01, 0.2553E+01, 0.2991E+01, 0.3590E+01, 0.4467E+01,
     * 0.5800E+01, 0.8007E+01, 0.1200E+02, 0.1999E+02, 0.3839E+02,
     * 0.9063E+02, 0.3047E+03, 0.7912E+03 /
        DATA ((UHR(i,j),j=1,83),i=15,15)/
     *-0.3548E+00,-0.3133E+00,-0.1695E+00,-0.4147E-01, 0.2811E-01,
     * 0.5365E-01, 0.5498E-01, 0.4910E-01, 0.4089E-01, 0.2886E-01,
     * 0.1992E-01, 0.1745E-01, 0.1560E-01, 0.1214E-01, 0.1022E-01,
     * 0.1022E-01, 0.9971E-02, 0.1037E-01, 0.1086E-01, 0.1077E-01,
     * 0.1081E-01, 0.1098E-01, 0.1189E-01, 0.1298E-01, 0.1421E-01,
     * 0.1496E-01, 0.1611E-01, 0.1744E-01, 0.1963E-01, 0.2220E-01,
     * 0.2459E-01, 0.2753E-01, 0.3145E-01, 0.3648E-01, 0.4139E-01,
     * 0.4626E-01, 0.5233E-01, 0.5903E-01, 0.6685E-01, 0.7655E-01,
     * 0.8663E-01, 0.9116E-01, 0.9689E-01, 0.1090E+00, 0.1238E+00,
     * 0.1401E+00, 0.1576E+00, 0.1777E+00, 0.2002E+00, 0.2237E+00,
     * 0.2495E+00, 0.2811E+00, 0.3166E+00, 0.3550E+00, 0.3976E+00,
     * 0.4460E+00, 0.5007E+00, 0.5613E+00, 0.6306E+00, 0.7101E+00,
     * 0.7984E+00, 0.8966E+00, 0.1006E+01, 0.1133E+01, 0.1280E+01,
     * 0.1451E+01, 0.1640E+01, 0.1857E+01, 0.2117E+01, 0.2431E+01,
     * 0.2808E+01, 0.3274E+01, 0.3864E+01, 0.4649E+01, 0.5758E+01,
     * 0.7369E+01, 0.9871E+01, 0.1408E+02, 0.2185E+02, 0.3797E+02,
     * 0.7764E+02, 0.2057E+03, 0.3618E+03 /
        DATA ((UHR(i,j),j=1,83),i=16,16)/
     *-0.2360E+00,-0.2085E+00,-0.1093E+00,-0.9279E-02, 0.5440E-01,
     * 0.8631E-01, 0.9693E-01, 0.9204E-01, 0.7919E-01, 0.6369E-01,
     * 0.4884E-01, 0.3684E-01, 0.2870E-01, 0.2269E-01, 0.1860E-01,
     * 0.1696E-01, 0.1574E-01, 0.1479E-01, 0.1490E-01, 0.1502E-01,
     * 0.1533E-01, 0.1562E-01, 0.1582E-01, 0.1641E-01, 0.1715E-01,
     * 0.1824E-01, 0.1966E-01, 0.2102E-01, 0.2260E-01, 0.2504E-01,
     * 0.2775E-01, 0.3076E-01, 0.3411E-01, 0.3785E-01, 0.4213E-01,
     * 0.4695E-01, 0.5213E-01, 0.5795E-01, 0.6486E-01, 0.7288E-01,
     * 0.8128E-01, 0.8575E-01, 0.9042E-01, 0.1016E+00, 0.1145E+00,
     * 0.1280E+00, 0.1429E+00, 0.1605E+00, 0.1804E+00, 0.2024E+00,
     * 0.2278E+00, 0.2574E+00, 0.2903E+00, 0.3266E+00, 0.3693E+00,
     * 0.4191E+00, 0.4750E+00, 0.5380E+00, 0.6111E+00, 0.6965E+00,
     * 0.7935E+00, 0.9035E+00, 0.1032E+01, 0.1183E+01, 0.1358E+01,
     * 0.1558E+01, 0.1794E+01, 0.2071E+01, 0.2403E+01, 0.2797E+01,
     * 0.3271E+01, 0.3859E+01, 0.4599E+01, 0.5559E+01, 0.6851E+01,
     * 0.8653E+01, 0.1135E+02, 0.1566E+02, 0.2312E+02, 0.3760E+02,
     * 0.7006E+02, 0.1593E+03, 0.2353E+03 /
        DATA ((UHR(i,j),j=1,83),i=17,17)/
     *-0.2183E+00,-0.1922E+00,-0.1014E+00,-0.8594E-02, 0.5487E-01,
     * 0.8811E-01, 0.9656E-01, 0.9036E-01, 0.7855E-01, 0.6551E-01,
     * 0.5402E-01, 0.4436E-01, 0.3628E-01, 0.3001E-01, 0.2499E-01,
     * 0.2102E-01, 0.1899E-01, 0.1769E-01, 0.1649E-01, 0.1642E-01,
     * 0.1624E-01, 0.1643E-01, 0.1715E-01, 0.1773E-01, 0.1847E-01,
     * 0.1943E-01, 0.2052E-01, 0.2214E-01, 0.2411E-01, 0.2589E-01,
     * 0.2770E-01, 0.3023E-01, 0.3331E-01, 0.3648E-01, 0.4012E-01,
     * 0.4457E-01, 0.4944E-01, 0.5497E-01, 0.6108E-01, 0.6756E-01,
     * 0.7513E-01, 0.7953E-01, 0.8416E-01, 0.9372E-01, 0.1040E+00,
     * 0.1166E+00, 0.1312E+00, 0.1468E+00, 0.1645E+00, 0.1859E+00,
     * 0.2099E+00, 0.2362E+00, 0.2671E+00, 0.3036E+00, 0.3446E+00,
     * 0.3907E+00, 0.4449E+00, 0.5082E+00, 0.5807E+00, 0.6637E+00,
     * 0.7606E+00, 0.8755E+00, 0.1008E+01, 0.1162E+01, 0.1342E+01,
     * 0.1557E+01, 0.1812E+01, 0.2113E+01, 0.2472E+01, 0.2904E+01,
     * 0.3435E+01, 0.4088E+01, 0.4909E+01, 0.5960E+01, 0.7354E+01,
     * 0.9292E+01, 0.1212E+02, 0.1651E+02, 0.2396E+02, 0.3795E+02,
     * 0.6835E+02, 0.1475E+03, 0.2076E+03 /
        DATA ((UHR(i,j),j=1,83),i=18,18)/
     *-0.1136E+00,-0.9834E-01,-0.4735E-01, 0.2310E-02, 0.3021E-01,
     * 0.3800E-01, 0.3552E-01, 0.3080E-01, 0.2686E-01, 0.2400E-01,
     * 0.2242E-01, 0.2143E-01, 0.2109E-01, 0.2134E-01, 0.2156E-01,
     * 0.2184E-01, 0.2211E-01, 0.2217E-01, 0.2205E-01, 0.2163E-01,
     * 0.2157E-01, 0.2118E-01, 0.2070E-01, 0.2043E-01, 0.2035E-01,
     * 0.2048E-01, 0.2086E-01, 0.2118E-01, 0.2152E-01, 0.2245E-01,
     * 0.2360E-01, 0.2479E-01, 0.2609E-01, 0.2761E-01, 0.2962E-01,
     * 0.3204E-01, 0.3453E-01, 0.3741E-01, 0.4108E-01, 0.4526E-01,
     * 0.4974E-01, 0.5223E-01, 0.5500E-01, 0.6123E-01, 0.6833E-01,
     * 0.7631E-01, 0.8562E-01, 0.9653E-01, 0.1090E+00, 0.1234E+00,
     * 0.1403E+00, 0.1598E+00, 0.1824E+00, 0.2092E+00, 0.2404E+00,
     * 0.2769E+00, 0.3203E+00, 0.3718E+00, 0.4326E+00, 0.5048E+00,
     * 0.5921E+00, 0.6970E+00, 0.8221E+00, 0.9752E+00, 0.1161E+01,
     * 0.1388E+01, 0.1667E+01, 0.2011E+01, 0.2437E+01, 0.2972E+01,
     * 0.3639E+01, 0.4486E+01, 0.5569E+01, 0.6969E+01, 0.8813E+01,
     * 0.1130E+02, 0.1477E+02, 0.1987E+02, 0.2790E+02, 0.4182E+02,
     * 0.6930E+02, 0.1301E+03, 0.1659E+03 /
        DATA ((UHR(i,j),j=1,83),i=19,19)/
     *-0.6440E-01,-0.5294E-01,-0.2004E-01, 0.5550E-02, 0.1412E-01,
     * 0.1288E-01, 0.9890E-02, 0.7319E-02, 0.5413E-02, 0.3973E-02,
     * 0.3066E-02, 0.2644E-02, 0.2585E-02, 0.2752E-02, 0.3260E-02,
     * 0.4136E-02, 0.5316E-02, 0.6561E-02, 0.7916E-02, 0.9371E-02,
     * 0.1068E-01, 0.1203E-01, 0.1312E-01, 0.1394E-01, 0.1455E-01,
     * 0.1502E-01, 0.1550E-01, 0.1597E-01, 0.1638E-01, 0.1691E-01,
     * 0.1750E-01, 0.1823E-01, 0.1908E-01, 0.2012E-01, 0.2138E-01,
     * 0.2297E-01, 0.2479E-01, 0.2682E-01, 0.2919E-01, 0.3198E-01,
     * 0.3513E-01, 0.3685E-01, 0.3872E-01, 0.4291E-01, 0.4782E-01,
     * 0.5345E-01, 0.5995E-01, 0.6758E-01, 0.7645E-01, 0.8673E-01,
     * 0.9874E-01, 0.1129E+00, 0.1295E+00, 0.1490E+00, 0.1722E+00,
     * 0.1999E+00, 0.2329E+00, 0.2725E+00, 0.3206E+00, 0.3785E+00,
     * 0.4492E+00, 0.5363E+00, 0.6430E+00, 0.7755E+00, 0.9413E+00,
     * 0.1149E+01, 0.1411E+01, 0.1745E+01, 0.2174E+01, 0.2726E+01,
     * 0.3444E+01, 0.4385E+01, 0.5628E+01, 0.7283E+01, 0.9514E+01,
     * 0.1256E+02, 0.1681E+02, 0.2292E+02, 0.3212E+02, 0.4710E+02,
     * 0.7426E+02, 0.1251E+03, 0.1499E+03 /
        DATA ((UHR(i,j),j=1,83),i=20,20)/
     *-0.7657E-01,-0.7138E-01,-0.5240E-01,-0.2943E-01,-0.1269E-01,
     *-0.4242E-02,-0.1328E-02,-0.8748E-03,-0.1035E-02,-0.1153E-02,
     *-0.1031E-02,-0.6918E-03,-0.9753E-04, 0.7330E-03, 0.1688E-02,
     * 0.2725E-02, 0.3713E-02, 0.4640E-02, 0.5533E-02, 0.6384E-02,
     * 0.7328E-02, 0.8258E-02, 0.9143E-02, 0.1007E-01, 0.1101E-01,
     * 0.1210E-01, 0.1330E-01, 0.1452E-01, 0.1583E-01, 0.1733E-01,
     * 0.1902E-01, 0.2087E-01, 0.2289E-01, 0.2513E-01, 0.2771E-01,
     * 0.3066E-01, 0.3391E-01, 0.3753E-01, 0.4172E-01, 0.4649E-01,
     * 0.5182E-01, 0.5475E-01, 0.5789E-01, 0.6486E-01, 0.7282E-01,
     * 0.8192E-01, 0.9229E-01, 0.1043E+00, 0.1182E+00, 0.1341E+00,
     * 0.1527E+00, 0.1743E+00, 0.1994E+00, 0.2288E+00, 0.2633E+00,
     * 0.3040E+00, 0.3520E+00, 0.4092E+00, 0.4772E+00, 0.5583E+00,
     * 0.6563E+00, 0.7741E+00, 0.9167E+00, 0.1091E+01, 0.1303E+01,
     * 0.1564E+01, 0.1886E+01, 0.2284E+01, 0.2782E+01, 0.3402E+01,
     * 0.4184E+01, 0.5170E+01, 0.6419E+01, 0.8020E+01, 0.1007E+02,
     * 0.1273E+02, 0.1622E+02, 0.2093E+02, 0.2739E+02, 0.3685E+02,
     * 0.5085E+02, 0.6526E+02, 0.6980E+02 /

      vi_m=18.2859898
      vi(1)=vi_m
      do 1 i=1,20
       asy(1,i)=asy_m(i)
       ex(1,i)=ex_m(i)
       sc(1,i)=sc_m(i)
      do 1 j=1,nquad
      ph(i,j)=phr(i,j)
      qh(i,j)=qhr(i,j)
      uh(i,j)=uhr(i,j)
    1 continue
      return
      end
