/*
 * Copyright (C) 2005-2024 Centre National d'Etudes Spatiales (CNES)
 *
 * This file is part of Orfeo Toolbox
 *
 *     https://www.orfeo-toolbox.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


#include "otbDataSpecP5B.h"

namespace otb
{

const DataSpec DataSpecP5B[] = {

    {400, 1.4955, 2.676E-02, 2.895E-01, 5.272E-01, 5.800E-05, 1.097E+02, 5.910E-01, 2.413E+00, 2.377E-01, 3.208E-02},
    {401, 1.4958, 3.113E-02, 2.796E-01, 5.262E-01, 5.852E-05, 1.037E+02, 5.980E-01, 2.413E+00, 2.373E-01, 3.195E-02},
    {402, 1.4960, 3.561E-02, 2.693E-01, 5.252E-01, 5.900E-05, 9.798E+01, 6.050E-01, 2.414E+00, 2.369E-01, 3.181E-02},
    {403, 1.4964, 3.972E-02, 2.601E-01, 5.242E-01, 5.989E-05, 9.244E+01, 6.120E-01, 2.414E+00, 2.365E-01, 3.168E-02},
    {404, 1.4971, 4.322E-02, 2.525E-01, 5.232E-01, 6.100E-05, 8.713E+01, 6.190E-01, 2.414E+00, 2.360E-01, 3.154E-02},
    {405, 1.4978, 4.606E-02, 2.456E-01, 5.222E-01, 6.203E-05, 8.231E+01, 6.260E-01, 2.415E+00, 2.356E-01, 3.141E-02},
    {406, 1.4986, 4.815E-02, 2.402E-01, 5.212E-01, 6.300E-05, 7.806E+01, 6.330E-01, 2.415E+00, 2.352E-01, 3.125E-02},
    {407, 1.4995, 5.007E-02, 2.352E-01, 5.202E-01, 6.399E-05, 7.404E+01, 6.400E-01, 2.415E+00, 2.348E-01, 3.108E-02},
    {408, 1.5006, 5.188E-02, 2.303E-01, 5.192E-01, 6.500E-05, 7.013E+01, 6.470E-01, 2.415E+00, 2.344E-01, 3.092E-02},
    {409, 1.5016, 5.346E-02, 2.255E-01, 5.182E-01, 6.603E-05, 6.654E+01, 6.540E-01, 2.416E+00, 2.340E-01, 3.076E-02},
    {410, 1.5024, 5.526E-02, 2.203E-01, 5.172E-01, 6.700E-05, 6.300E+01, 6.610E-01, 2.416E+00, 2.336E-01, 3.059E-02},
    {411, 1.5031, 5.721E-02, 2.151E-01, 5.162E-01, 6.790E-05, 5.954E+01, 6.680E-01, 2.416E+00, 2.332E-01, 3.044E-02},
    {412, 1.5041, 5.891E-02, 2.105E-01, 5.152E-01, 6.900E-05, 5.616E+01, 6.750E-01, 2.417E+00, 2.328E-01, 3.028E-02},
    {413, 1.5052, 6.004E-02, 2.069E-01, 5.142E-01, 7.050E-05, 5.300E+01, 6.820E-01, 2.417E+00, 2.324E-01, 3.012E-02},
    {414, 1.5065, 6.100E-02, 2.035E-01, 5.132E-01, 7.200E-05, 5.001E+01, 6.890E-01, 2.417E+00, 2.320E-01, 2.996E-02},
    {415, 1.5076, 6.189E-02, 2.002E-01, 5.122E-01, 7.312E-05, 4.723E+01, 6.960E-01, 2.418E+00, 2.316E-01, 2.980E-02},
    {416, 1.5088, 6.259E-02, 1.971E-01, 5.112E-01, 7.400E-05, 4.463E+01, 7.030E-01, 2.418E+00, 2.312E-01, 2.969E-02},
    {417, 1.5099, 6.318E-02, 1.943E-01, 5.102E-01, 7.490E-05, 4.220E+01, 7.100E-01, 2.418E+00, 2.308E-01, 2.957E-02},
    {418, 1.5110, 6.367E-02, 1.914E-01, 5.092E-01, 7.600E-05, 3.996E+01, 7.170E-01, 2.418E+00, 2.304E-01, 2.946E-02},
    {419, 1.5122, 6.416E-02, 1.889E-01, 5.082E-01, 7.740E-05, 3.780E+01, 7.240E-01, 2.419E+00, 2.299E-01, 2.934E-02},
    {420, 1.5134, 6.475E-02, 1.866E-01, 5.072E-01, 7.900E-05, 3.567E+01, 7.310E-01, 2.419E+00, 2.295E-01, 2.923E-02},
    {421, 1.5144, 6.555E-02, 1.844E-01, 5.062E-01, 8.063E-05, 3.362E+01, 7.376E-01, 2.418E+00, 2.290E-01, 2.911E-02},
    {422, 1.5156, 6.628E-02, 1.823E-01, 5.052E-01, 8.200E-05, 3.170E+01, 7.442E-01, 2.417E+00, 2.284E-01, 2.900E-02},
    {423, 1.5168, 6.690E-02, 1.805E-01, 5.042E-01, 8.297E-05, 2.993E+01, 7.508E-01, 2.416E+00, 2.278E-01, 2.888E-02},
    {424, 1.5181, 6.718E-02, 1.792E-01, 5.032E-01, 8.400E-05, 2.832E+01, 7.574E-01, 2.415E+00, 2.272E-01, 2.877E-02},
    {425, 1.5195, 6.747E-02, 1.777E-01, 5.022E-01, 8.551E-05, 2.679E+01, 7.640E-01, 2.414E+00, 2.267E-01, 2.865E-02},
    {426, 1.5206, 6.795E-02, 1.762E-01, 5.012E-01, 8.700E-05, 2.535E+01, 7.706E-01, 2.413E+00, 2.263E-01, 2.854E-02},
    {427, 1.5212, 6.855E-02, 1.747E-01, 5.002E-01, 8.800E-05, 2.402E+01, 7.772E-01, 2.412E+00, 2.259E-01, 2.842E-02},
    {428, 1.5219, 6.897E-02, 1.735E-01, 4.992E-01, 8.900E-05, 2.276E+01, 7.838E-01, 2.411E+00, 2.254E-01, 2.831E-02},
    {429, 1.5228, 6.931E-02, 1.724E-01, 4.982E-01, 9.050E-05, 2.150E+01, 7.904E-01, 2.410E+00, 2.250E-01, 2.819E-02},
    {430, 1.5235, 6.978E-02, 1.715E-01, 4.972E-01, 9.200E-05, 2.024E+01, 7.970E-01, 2.410E+00, 2.246E-01, 2.808E-02},
    {431, 1.5241, 7.037E-02, 1.707E-01, 4.960E-01, 9.300E-05, 1.901E+01, 8.036E-01, 2.409E+00, 2.243E-01, 2.793E-02},
    {432, 1.5249, 7.082E-02, 1.701E-01, 4.948E-01, 9.400E-05, 1.785E+01, 8.102E-01, 2.408E+00, 2.240E-01, 2.779E-02},
    {433, 1.5256, 7.114E-02, 1.694E-01, 4.936E-01, 9.550E-05, 1.676E+01, 8.168E-01, 2.407E+00, 2.237E-01, 2.764E-02},
    {434, 1.5262, 7.141E-02, 1.688E-01, 4.924E-01, 9.700E-05, 1.575E+01, 8.234E-01, 2.406E+00, 2.234E-01, 2.750E-02},
    {435, 1.5267, 7.160E-02, 1.682E-01, 4.912E-01, 9.801E-05, 1.481E+01, 8.300E-01, 2.405E+00, 2.231E-01, 2.735E-02},
    {436, 1.5272, 7.174E-02, 1.678E-01, 4.900E-01, 9.900E-05, 1.392E+01, 8.366E-01, 2.404E+00, 2.228E-01, 2.720E-02},
    {437, 1.5276, 7.177E-02, 1.674E-01, 4.888E-01, 1.005E-04, 1.312E+01, 8.432E-01, 2.403E+00, 2.224E-01, 2.705E-02},
    {438, 1.5279, 7.171E-02, 1.670E-01, 4.876E-01, 1.020E-04, 1.233E+01, 8.498E-01, 2.402E+00, 2.221E-01, 2.690E-02},
    {439, 1.5282, 7.155E-02, 1.667E-01, 4.864E-01, 1.031E-04, 1.161E+01, 8.564E-01, 2.401E+00, 2.218E-01, 2.675E-02},
    {440, 1.5286, 7.120E-02, 1.664E-01, 4.852E-01, 1.040E-04, 1.096E+01, 8.630E-01, 2.400E+00, 2.215E-01, 2.660E-02},
    {441, 1.5290, 7.048E-02, 1.659E-01, 4.840E-01, 1.050E-04, 1.041E+01, 8.743E-01, 2.412E+00, 2.215E-01, 2.646E-02},
    {442, 1.5292, 6.963E-02, 1.653E-01, 4.829E-01, 1.060E-04, 9.924E+00, 8.856E-01, 2.424E+00, 2.215E-01, 2.632E-02},
    {443, 1.5294, 6.883E-02, 1.647E-01, 4.817E-01, 1.070E-04, 9.410E+00, 8.969E-01, 2.435E+00, 2.215E-01, 2.618E-02},
    {444, 1.5294, 6.789E-02, 1.641E-01, 4.805E-01, 1.080E-04, 8.947E+00, 9.082E-01, 2.447E+00, 2.215E-01, 2.604E-02},
    {445, 1.5295, 6.685E-02, 1.632E-01, 4.793E-01, 1.090E-04, 8.508E+00, 9.195E-01, 2.459E+00, 2.214E-01, 2.590E-02},
    {446, 1.5293, 6.583E-02, 1.624E-01, 4.781E-01, 1.100E-04, 8.087E+00, 9.308E-01, 2.471E+00, 2.215E-01, 2.578E-02},
    {447, 1.5291, 6.480E-02, 1.615E-01, 4.769E-01, 1.110E-04, 7.640E+00, 9.421E-01, 2.483E+00, 2.215E-01, 2.566E-02},
    {448, 1.5289, 6.358E-02, 1.605E-01, 4.757E-01, 1.120E-04, 7.268E+00, 9.534E-01, 2.494E+00, 2.216E-01, 2.553E-02},
    {449, 1.5286, 6.225E-02, 1.592E-01, 4.745E-01, 1.130E-04, 6.939E+00, 9.647E-01, 2.506E+00, 2.217E-01, 2.541E-02},
    {450, 1.5282, 6.090E-02, 1.577E-01, 4.733E-01, 1.140E-04, 6.660E+00, 9.760E-01, 2.518E+00, 2.217E-01, 2.529E-02},
    {451, 1.5278, 5.956E-02, 1.561E-01, 4.720E-01, 1.150E-04, 6.422E+00, 9.873E-01, 2.530E+00, 2.218E-01, 2.523E-02},
    {452, 1.5273, 5.813E-02, 1.544E-01, 4.708E-01, 1.160E-04, 6.222E+00, 9.986E-01, 2.542E+00, 2.219E-01, 2.518E-02},
    {453, 1.5268, 5.677E-02, 1.528E-01, 4.695E-01, 1.170E-04, 6.010E+00, 1.010E+00, 2.553E+00, 2.219E-01, 2.513E-02},
    {454, 1.5262, 5.553E-02, 1.513E-01, 4.683E-01, 1.180E-04, 5.782E+00, 1.021E+00, 2.565E+00, 2.220E-01, 2.508E-02},
    {455, 1.5256, 5.439E-02, 1.497E-01, 4.670E-01, 1.190E-04, 5.573E+00, 1.033E+00, 2.577E+00, 2.221E-01, 2.502E-02},
    {456, 1.5249, 5.330E-02, 1.483E-01, 4.658E-01, 1.200E-04, 5.370E+00, 1.044E+00, 2.589E+00, 2.222E-01, 2.502E-02},
    {457, 1.5243, 5.224E-02, 1.468E-01, 4.645E-01, 1.210E-04, 5.173E+00, 1.055E+00, 2.601E+00, 2.224E-01, 2.502E-02},
    {458, 1.5237, 5.135E-02, 1.454E-01, 4.633E-01, 1.220E-04, 4.946E+00, 1.066E+00, 2.612E+00, 2.225E-01, 2.502E-02},
    {459, 1.5230, 5.056E-02, 1.440E-01, 4.620E-01, 1.230E-04, 4.761E+00, 1.078E+00, 2.624E+00, 2.227E-01, 2.501E-02},
    {460, 1.5224, 4.990E-02, 1.425E-01, 4.608E-01, 1.240E-04, 4.575E+00, 1.089E+00, 2.636E+00, 2.228E-01, 2.501E-02},
    {461, 1.5217, 4.934E-02, 1.411E-01, 4.597E-01, 1.250E-04, 4.419E+00, 1.094E+00, 2.634E+00, 2.230E-01, 2.501E-02},
    {462, 1.5210, 4.891E-02, 1.397E-01, 4.587E-01, 1.260E-04, 4.259E+00, 1.100E+00, 2.632E+00, 2.231E-01, 2.501E-02},
    {463, 1.5203, 4.852E-02, 1.384E-01, 4.577E-01, 1.270E-04, 4.117E+00, 1.105E+00, 2.630E+00, 2.233E-01, 2.500E-02},
    {464, 1.5196, 4.812E-02, 1.371E-01, 4.566E-01, 1.280E-04, 4.006E+00, 1.110E+00, 2.628E+00, 2.234E-01, 2.500E-02},
    {465, 1.5189, 4.767E-02, 1.358E-01, 4.556E-01, 1.289E-04, 3.945E+00, 1.116E+00, 2.626E+00, 2.236E-01, 2.500E-02},
    {466, 1.5184, 4.729E-02, 1.347E-01, 4.546E-01, 1.300E-04, 3.853E+00, 1.121E+00, 2.623E+00, 2.238E-01, 2.500E-02},
    {467, 1.5178, 4.698E-02, 1.335E-01, 4.535E-01, 1.315E-04, 3.784E+00, 1.126E+00, 2.621E+00, 2.240E-01, 2.499E-02},
    {468, 1.5173, 4.673E-02, 1.325E-01, 4.525E-01, 1.330E-04, 3.671E+00, 1.131E+00, 2.619E+00, 2.241E-01, 2.499E-02},
    {469, 1.5170, 4.647E-02, 1.316E-01, 4.515E-01, 1.340E-04, 3.554E+00, 1.137E+00, 2.617E+00, 2.243E-01, 2.499E-02},
    {470, 1.5166, 4.622E-02, 1.308E-01, 4.504E-01, 1.350E-04, 3.462E+00, 1.142E+00, 2.615E+00, 2.245E-01, 2.499E-02},
    {471, 1.5163, 4.606E-02, 1.302E-01, 4.494E-01, 1.364E-04, 3.363E+00, 1.147E+00, 2.613E+00, 2.247E-01, 2.498E-02},
    {472, 1.5159, 4.589E-02, 1.296E-01, 4.484E-01, 1.380E-04, 3.282E+00, 1.153E+00, 2.611E+00, 2.249E-01, 2.498E-02},
    {473, 1.5156, 4.570E-02, 1.292E-01, 4.473E-01, 1.396E-04, 3.184E+00, 1.158E+00, 2.609E+00, 2.251E-01, 2.498E-02},
    {474, 1.5153, 4.552E-02, 1.288E-01, 4.463E-01, 1.410E-04, 3.102E+00, 1.163E+00, 2.607E+00, 2.253E-01, 2.498E-02},
    {475, 1.5150, 4.535E-02, 1.285E-01, 4.453E-01, 1.424E-04, 3.051E+00, 1.169E+00, 2.605E+00, 2.256E-01, 2.497E-02},
    {476, 1.5148, 4.519E-02, 1.282E-01, 4.442E-01, 1.440E-04, 2.983E+00, 1.174E+00, 2.602E+00, 2.258E-01, 2.483E-02},
    {477, 1.5145, 4.492E-02, 1.280E-01, 4.432E-01, 1.459E-04, 2.947E+00, 1.179E+00, 2.600E+00, 2.260E-01, 2.468E-02},
    {478, 1.5142, 4.466E-02, 1.277E-01, 4.422E-01, 1.480E-04, 2.913E+00, 1.184E+00, 2.598E+00, 2.262E-01, 2.453E-02},
    {479, 1.5139, 4.442E-02, 1.274E-01, 4.411E-01, 1.499E-04, 2.869E+00, 1.190E+00, 2.596E+00, 2.264E-01, 2.438E-02},
    {480, 1.5135, 4.413E-02, 1.270E-01, 4.401E-01, 1.520E-04, 2.803E+00, 1.195E+00, 2.594E+00, 2.266E-01, 2.423E-02},
    {481, 1.5131, 4.373E-02, 1.265E-01, 4.388E-01, 1.544E-04, 2.777E+00, 1.194E+00, 2.579E+00, 2.269E-01, 2.423E-02},
    {482, 1.5125, 4.325E-02, 1.260E-01, 4.375E-01, 1.570E-04, 2.751E+00, 1.194E+00, 2.565E+00, 2.271E-01, 2.423E-02},
    {483, 1.5119, 4.275E-02, 1.253E-01, 4.362E-01, 1.596E-04, 2.726E+00, 1.193E+00, 2.550E+00, 2.273E-01, 2.423E-02},
    {484, 1.5111, 4.216E-02, 1.244E-01, 4.350E-01, 1.620E-04, 2.702E+00, 1.192E+00, 2.535E+00, 2.276E-01, 2.422E-02},
    {485, 1.5103, 4.149E-02, 1.234E-01, 4.337E-01, 1.643E-04, 2.679E+00, 1.191E+00, 2.521E+00, 2.278E-01, 2.422E-02},
    {486, 1.5092, 4.073E-02, 1.223E-01, 4.324E-01, 1.670E-04, 2.656E+00, 1.191E+00, 2.506E+00, 2.280E-01, 2.422E-02},
    {487, 1.5080, 3.989E-02, 1.211E-01, 4.311E-01, 1.704E-04, 2.634E+00, 1.190E+00, 2.491E+00, 2.283E-01, 2.422E-02},
    {488, 1.5067, 3.895E-02, 1.197E-01, 4.298E-01, 1.740E-04, 2.613E+00, 1.189E+00, 2.477E+00, 2.285E-01, 2.421E-02},
    {489, 1.5051, 3.791E-02, 1.182E-01, 4.285E-01, 1.775E-04, 2.593E+00, 1.188E+00, 2.462E+00, 2.287E-01, 2.421E-02},
    {490, 1.5034, 3.683E-02, 1.166E-01, 4.272E-01, 1.810E-04, 2.573E+00, 1.188E+00, 2.448E+00, 2.289E-01, 2.421E-02},
    {491, 1.5015, 3.571E-02, 1.150E-01, 4.260E-01, 1.849E-04, 2.554E+00, 1.187E+00, 2.433E+00, 2.293E-01, 2.450E-02},
    {492, 1.4994, 3.455E-02, 1.132E-01, 4.247E-01, 1.890E-04, 2.536E+00, 1.186E+00, 2.418E+00, 2.297E-01, 2.479E-02},
    {493, 1.4971, 3.335E-02, 1.114E-01, 4.234E-01, 1.934E-04, 2.519E+00, 1.185E+00, 2.404E+00, 2.302E-01, 2.508E-02},
    {494, 1.4947, 3.215E-02, 1.096E-01, 4.221E-01, 1.980E-04, 2.502E+00, 1.185E+00, 2.389E+00, 2.306E-01, 2.537E-02},
    {495, 1.4921, 3.094E-02, 1.076E-01, 4.208E-01, 2.031E-04, 2.486E+00, 1.184E+00, 2.374E+00, 2.310E-01, 2.566E-02},
    {496, 1.4894, 2.972E-02, 1.056E-01, 4.195E-01, 2.090E-04, 2.471E+00, 1.183E+00, 2.360E+00, 2.314E-01, 2.565E-02},
    {497, 1.4866, 2.850E-02, 1.035E-01, 4.183E-01, 2.158E-04, 2.457E+00, 1.182E+00, 2.345E+00, 2.319E-01, 2.565E-02},
    {498, 1.4837, 2.730E-02, 1.013E-01, 4.170E-01, 2.230E-04, 2.443E+00, 1.182E+00, 2.330E+00, 2.324E-01, 2.565E-02},
    {499, 1.4807, 2.615E-02, 9.901E-02, 4.157E-01, 2.303E-04, 2.430E+00, 1.181E+00, 2.316E+00, 2.329E-01, 2.565E-02},
    {500, 1.4776, 2.502E-02, 9.660E-02, 4.144E-01, 2.380E-04, 2.417E+00, 1.180E+00, 2.301E+00, 2.333E-01, 2.564E-02},
    {501, 1.4744, 2.392E-02, 9.420E-02, 4.135E-01, 2.463E-04, 2.405E+00, 1.180E+00, 2.290E+00, 2.340E-01, 2.564E-02},
    {502, 1.4712, 2.284E-02, 9.179E-02, 4.127E-01, 2.550E-04, 2.394E+00, 1.181E+00, 2.279E+00, 2.346E-01, 2.564E-02},
    {503, 1.4680, 2.179E-02, 8.939E-02, 4.118E-01, 2.640E-04, 2.384E+00, 1.181E+00, 2.268E+00, 2.353E-01, 2.564E-02},
    {504, 1.4647, 2.077E-02, 8.699E-02, 4.109E-01, 2.730E-04, 2.374E+00, 1.181E+00, 2.257E+00, 2.359E-01, 2.563E-02},
    {505, 1.4615, 1.979E-02, 8.460E-02, 4.100E-01, 2.819E-04, 2.365E+00, 1.182E+00, 2.246E+00, 2.366E-01, 2.563E-02},
    {506, 1.4583, 1.883E-02, 8.221E-02, 4.092E-01, 2.910E-04, 2.356E+00, 1.182E+00, 2.234E+00, 2.371E-01, 2.570E-02},
    {507, 1.4553, 1.790E-02, 7.983E-02, 4.083E-01, 3.004E-04, 2.348E+00, 1.182E+00, 2.223E+00, 2.376E-01, 2.577E-02},
    {508, 1.4523, 1.702E-02, 7.746E-02, 4.074E-01, 3.100E-04, 2.341E+00, 1.182E+00, 2.212E+00, 2.381E-01, 2.584E-02},
    {509, 1.4495, 1.617E-02, 7.510E-02, 4.065E-01, 3.194E-04, 2.334E+00, 1.183E+00, 2.201E+00, 2.387E-01, 2.591E-02},
    {510, 1.4468, 1.536E-02, 7.275E-02, 4.057E-01, 3.290E-04, 2.328E+00, 1.183E+00, 2.190E+00, 2.392E-01, 2.598E-02},
    {511, 1.4443, 1.458E-02, 7.041E-02, 4.047E-01, 3.390E-04, 2.323E+00, 1.183E+00, 2.179E+00, 2.396E-01, 2.598E-02},
    {512, 1.4419, 1.383E-02, 6.809E-02, 4.038E-01, 3.490E-04, 2.318E+00, 1.184E+00, 2.168E+00, 2.400E-01, 2.598E-02},
    {513, 1.4397, 1.312E-02, 6.578E-02, 4.028E-01, 3.588E-04, 2.314E+00, 1.184E+00, 2.157E+00, 2.405E-01, 2.598E-02},
    {514, 1.4377, 1.246E-02, 6.349E-02, 4.019E-01, 3.680E-04, 2.310E+00, 1.184E+00, 2.146E+00, 2.409E-01, 2.597E-02},
    {515, 1.4360, 1.183E-02, 6.122E-02, 4.009E-01, 3.767E-04, 2.307E+00, 1.185E+00, 2.135E+00, 2.413E-01, 2.597E-02},
    {516, 1.4344, 1.126E-02, 5.897E-02, 4.000E-01, 3.860E-04, 2.304E+00, 1.185E+00, 2.123E+00, 2.418E-01, 2.597E-02},
    {517, 1.4331, 1.074E-02, 5.673E-02, 3.990E-01, 3.962E-04, 2.302E+00, 1.185E+00, 2.112E+00, 2.422E-01, 2.597E-02},
    {518, 1.4319, 1.027E-02, 5.453E-02, 3.981E-01, 4.040E-04, 2.301E+00, 1.185E+00, 2.101E+00, 2.427E-01, 2.596E-02},
    {519, 1.4310, 9.855E-03, 5.234E-02, 3.971E-01, 4.069E-04, 2.300E+00, 1.186E+00, 2.090E+00, 2.431E-01, 2.596E-02},
    {520, 1.4302, 9.490E-03, 5.018E-02, 3.962E-01, 4.090E-04, 2.300E+00, 1.186E+00, 2.079E+00, 2.436E-01, 2.596E-02},
    {521, 1.4296, 9.176E-03, 4.805E-02, 3.952E-01, 4.138E-04, 2.300E+00, 1.191E+00, 2.076E+00, 2.441E-01, 2.596E-02},
    {522, 1.4291, 8.910E-03, 4.594E-02, 3.943E-01, 4.160E-04, 2.300E+00, 1.195E+00, 2.073E+00, 2.446E-01, 2.595E-02},
    {523, 1.4288, 8.698E-03, 4.387E-02, 3.933E-01, 4.112E-04, 2.300E+00, 1.200E+00, 2.070E+00, 2.452E-01, 2.595E-02},
    {524, 1.4286, 8.542E-03, 4.182E-02, 3.924E-01, 4.090E-04, 2.300E+00, 1.204E+00, 2.067E+00, 2.457E-01, 2.595E-02},
    {525, 1.4286, 8.437E-03, 3.981E-02, 3.914E-01, 4.176E-04, 2.300E+00, 1.209E+00, 2.064E+00, 2.462E-01, 2.595E-02},
    {526, 1.4286, 8.381E-03, 3.783E-02, 3.905E-01, 4.270E-04, 2.300E+00, 1.213E+00, 2.061E+00, 2.467E-01, 2.594E-02},
    {527, 1.4287, 8.373E-03, 3.588E-02, 3.895E-01, 4.268E-04, 2.300E+00, 1.218E+00, 2.058E+00, 2.472E-01, 2.594E-02},
    {528, 1.4288, 8.411E-03, 3.397E-02, 3.886E-01, 4.230E-04, 2.300E+00, 1.222E+00, 2.055E+00, 2.477E-01, 2.594E-02},
    {529, 1.4290, 8.486E-03, 3.210E-02, 3.876E-01, 4.237E-04, 2.300E+00, 1.227E+00, 2.052E+00, 2.482E-01, 2.594E-02},
    {530, 1.4292, 8.595E-03, 3.026E-02, 3.867E-01, 4.290E-04, 2.300E+00, 1.231E+00, 2.049E+00, 2.487E-01, 2.593E-02},
    {531, 1.4294, 8.735E-03, 2.847E-02, 3.846E-01, 4.371E-04, 2.300E+00, 1.236E+00, 2.045E+00, 2.492E-01, 2.593E-02},
    {532, 1.4296, 8.905E-03, 2.672E-02, 3.824E-01, 4.450E-04, 2.300E+00, 1.240E+00, 2.042E+00, 2.497E-01, 2.593E-02},
    {533, 1.4298, 9.098E-03, 2.501E-02, 3.803E-01, 4.506E-04, 2.300E+00, 1.245E+00, 2.039E+00, 2.502E-01, 2.593E-02},
    {534, 1.4300, 9.313E-03, 2.334E-02, 3.782E-01, 4.560E-04, 2.300E+00, 1.249E+00, 2.036E+00, 2.507E-01, 2.592E-02},
    {535, 1.4302, 9.544E-03, 2.172E-02, 3.760E-01, 4.631E-04, 2.300E+00, 1.254E+00, 2.033E+00, 2.512E-01, 2.592E-02},
    {536, 1.4303, 9.789E-03, 2.015E-02, 3.739E-01, 4.700E-04, 2.300E+00, 1.258E+00, 2.030E+00, 2.517E-01, 2.614E-02},
    {537, 1.4305, 1.004E-02, 1.863E-02, 3.718E-01, 4.748E-04, 2.300E+00, 1.263E+00, 2.027E+00, 2.522E-01, 2.635E-02},
    {538, 1.4306, 1.030E-02, 1.715E-02, 3.696E-01, 4.800E-04, 2.300E+00, 1.267E+00, 2.024E+00, 2.527E-01, 2.657E-02},
    {539, 1.4307, 1.056E-02, 1.573E-02, 3.675E-01, 4.879E-04, 2.300E+00, 1.272E+00, 2.021E+00, 2.532E-01, 2.679E-02},
    {540, 1.4308, 1.083E-02, 1.436E-02, 3.654E-01, 4.950E-04, 2.300E+00, 1.276E+00, 2.018E+00, 2.537E-01, 2.700E-02},
    {541, 1.4309, 1.108E-02, 1.304E-02, 3.639E-01, 4.983E-04, 2.300E+00, 1.278E+00, 2.011E+00, 2.542E-01, 2.700E-02},
    {542, 1.4309, 1.133E-02, 1.178E-02, 3.625E-01, 5.030E-04, 2.300E+00, 1.279E+00, 2.004E+00, 2.546E-01, 2.700E-02},
    {543, 1.4310, 1.157E-02, 1.057E-02, 3.611E-01, 5.141E-04, 2.300E+00, 1.281E+00, 1.997E+00, 2.551E-01, 2.700E-02},
    {544, 1.4310, 1.180E-02, 9.420E-03, 3.597E-01, 5.270E-04, 2.300E+00, 1.282E+00, 1.990E+00, 2.556E-01, 2.699E-02},
    {545, 1.4310, 1.201E-02, 8.330E-03, 3.582E-01, 5.363E-04, 2.300E+00, 1.284E+00, 1.983E+00, 2.561E-01, 2.699E-02},
    {546, 1.4309, 1.221E-02, 7.301E-03, 3.568E-01, 5.440E-04, 2.300E+00, 1.285E+00, 1.975E+00, 2.566E-01, 2.735E-02},
    {547, 1.4308, 1.239E-02, 6.334E-03, 3.554E-01, 5.532E-04, 2.300E+00, 1.287E+00, 1.968E+00, 2.571E-01, 2.772E-02},
    {548, 1.4307, 1.256E-02, 5.429E-03, 3.540E-01, 5.640E-04, 2.300E+00, 1.288E+00, 1.961E+00, 2.576E-01, 2.808E-02},
    {549, 1.4305, 1.271E-02, 4.589E-03, 3.525E-01, 5.759E-04, 2.300E+00, 1.290E+00, 1.954E+00, 2.582E-01, 2.844E-02},
    {550, 1.4303, 1.286E-02, 3.816E-03, 3.511E-01, 5.880E-04, 2.300E+00, 1.291E+00, 1.947E+00, 2.587E-01, 2.880E-02},
    {551, 1.4301, 1.300E-02, 3.109E-03, 3.500E-01, 5.998E-04, 2.300E+00, 1.293E+00, 1.940E+00, 2.592E-01, 2.880E-02},
    {552, 1.4298, 1.314E-02, 2.471E-03, 3.489E-01, 6.110E-04, 2.300E+00, 1.294E+00, 1.933E+00, 2.598E-01, 2.880E-02},
    {553, 1.4294, 1.327E-02, 1.903E-03, 3.478E-01, 6.215E-04, 2.300E+00, 1.296E+00, 1.926E+00, 2.603E-01, 2.879E-02},
    {554, 1.4290, 1.340E-02, 1.406E-03, 3.467E-01, 6.310E-04, 2.300E+00, 1.297E+00, 1.919E+00, 2.609E-01, 2.879E-02},
    {555, 1.4285, 1.353E-02, 9.822E-04, 3.456E-01, 6.391E-04, 2.300E+00, 1.299E+00, 1.912E+00, 2.614E-01, 2.879E-02},
    {556, 1.4280, 1.367E-02, 6.322E-04, 3.445E-01, 6.460E-04, 2.300E+00, 1.300E+00, 1.904E+00, 2.620E-01, 2.879E-02},
    {557, 1.4274, 1.380E-02, 3.577E-04, 3.434E-01, 6.520E-04, 2.300E+00, 1.302E+00, 1.897E+00, 2.626E-01, 2.878E-02},
    {558, 1.4268, 1.394E-02, 1.599E-04, 3.423E-01, 6.580E-04, 2.300E+00, 1.303E+00, 1.890E+00, 2.631E-01, 2.878E-02},
    {559, 1.4262, 1.408E-02, 4.019E-05, 3.412E-01, 6.647E-04, 2.300E+00, 1.305E+00, 1.883E+00, 2.637E-01, 2.878E-02},
    {560, 1.4255, 1.421E-02, 0.000E+00, 3.401E-01, 6.720E-04, 2.300E+00, 1.306E+00, 1.876E+00, 2.642E-01, 2.878E-02},
    {561, 1.4248, 1.435E-02, 0.000E+00, 3.383E-01, 6.793E-04, 2.300E+00, 1.309E+00, 1.871E+00, 2.647E-01, 2.877E-02},
    {562, 1.4241, 1.451E-02, 0.000E+00, 3.366E-01, 6.860E-04, 2.300E+00, 1.312E+00, 1.867E+00, 2.651E-01, 2.877E-02},
    {563, 1.4234, 1.469E-02, 0.000E+00, 3.348E-01, 6.920E-04, 2.300E+00, 1.314E+00, 1.862E+00, 2.655E-01, 2.877E-02},
    {564, 1.4227, 1.489E-02, 0.000E+00, 3.330E-01, 6.990E-04, 2.300E+00, 1.317E+00, 1.857E+00, 2.659E-01, 2.877E-02},
    {565, 1.4220, 1.511E-02, 0.000E+00, 3.312E-01, 7.084E-04, 2.300E+00, 1.320E+00, 1.852E+00, 2.664E-01, 2.877E-02},
    {566, 1.4213, 1.535E-02, 0.000E+00, 3.294E-01, 7.180E-04, 2.300E+00, 1.323E+00, 1.848E+00, 2.667E-01, 2.884E-02},
    {567, 1.4206, 1.561E-02, 0.000E+00, 3.276E-01, 7.257E-04, 2.300E+00, 1.325E+00, 1.843E+00, 2.671E-01, 2.891E-02},
    {568, 1.4199, 1.589E-02, 0.000E+00, 3.258E-01, 7.340E-04, 2.300E+00, 1.328E+00, 1.838E+00, 2.675E-01, 2.898E-02},
    {569, 1.4192, 1.619E-02, 0.000E+00, 3.241E-01, 7.455E-04, 2.300E+00, 1.331E+00, 1.833E+00, 2.679E-01, 2.905E-02},
    {570, 1.4185, 1.650E-02, 0.000E+00, 3.223E-01, 7.590E-04, 2.300E+00, 1.334E+00, 1.829E+00, 2.683E-01, 2.912E-02},
    {571, 1.4179, 1.683E-02, 0.000E+00, 3.202E-01, 7.729E-04, 2.300E+00, 1.336E+00, 1.824E+00, 2.686E-01, 2.912E-02},
    {572, 1.4173, 1.716E-02, 0.000E+00, 3.182E-01, 7.870E-04, 2.300E+00, 1.339E+00, 1.819E+00, 2.690E-01, 2.911E-02},
    {573, 1.4167, 1.749E-02, 0.000E+00, 3.162E-01, 8.020E-04, 2.300E+00, 1.342E+00, 1.814E+00, 2.694E-01, 2.911E-02},
    {574, 1.4161, 1.782E-02, 0.000E+00, 3.141E-01, 8.190E-04, 2.300E+00, 1.345E+00, 1.810E+00, 2.698E-01, 2.911E-02},
    {575, 1.4156, 1.814E-02, 0.000E+00, 3.121E-01, 8.386E-04, 2.300E+00, 1.347E+00, 1.805E+00, 2.702E-01, 2.911E-02},
    {576, 1.4151, 1.846E-02, 0.000E+00, 3.100E-01, 8.580E-04, 2.300E+00, 1.350E+00, 1.800E+00, 2.707E-01, 2.918E-02},
    {577, 1.4146, 1.876E-02, 0.000E+00, 3.080E-01, 8.754E-04, 2.300E+00, 1.353E+00, 1.795E+00, 2.712E-01, 2.926E-02},
    {578, 1.4141, 1.905E-02, 0.000E+00, 3.059E-01, 8.960E-04, 2.300E+00, 1.356E+00, 1.791E+00, 2.717E-01, 2.934E-02},
    {579, 1.4137, 1.933E-02, 0.000E+00, 3.039E-01, 9.238E-04, 2.300E+00, 1.358E+00, 1.786E+00, 2.722E-01, 2.942E-02},
    {580, 1.4133, 1.960E-02, 0.000E+00, 3.019E-01, 9.520E-04, 2.300E+00, 1.361E+00, 1.781E+00, 2.727E-01, 2.950E-02},
    {581, 1.4129, 1.986E-02, 0.000E+00, 2.999E-01, 9.745E-04, 2.300E+00, 1.361E+00, 1.774E+00, 2.732E-01, 2.978E-02},
    {582, 1.4126, 2.011E-02, 0.000E+00, 2.979E-01, 1.000E-03, 2.300E+00, 1.360E+00, 1.767E+00, 2.737E-01, 3.006E-02},
    {583, 1.4123, 2.035E-02, 0.000E+00, 2.959E-01, 1.037E-03, 2.300E+00, 1.360E+00, 1.760E+00, 2.742E-01, 3.034E-02},
    {584, 1.4120, 2.058E-02, 0.000E+00, 2.940E-01, 1.079E-03, 2.300E+00, 1.360E+00, 1.752E+00, 2.747E-01, 3.062E-02},
    {585, 1.4117, 2.079E-02, 0.000E+00, 2.920E-01, 1.119E-03, 2.300E+00, 1.359E+00, 1.745E+00, 2.752E-01, 3.090E-02},
    {586, 1.4114, 2.100E-02, 0.000E+00, 2.900E-01, 1.159E-03, 2.300E+00, 1.359E+00, 1.738E+00, 2.757E-01, 3.090E-02},
    {587, 1.4112, 2.120E-02, 0.000E+00, 2.881E-01, 1.204E-03, 2.300E+00, 1.359E+00, 1.731E+00, 2.762E-01, 3.090E-02},
    {588, 1.4109, 2.138E-02, 0.000E+00, 2.861E-01, 1.253E-03, 2.300E+00, 1.358E+00, 1.724E+00, 2.767E-01, 3.090E-02},
    {589, 1.4107, 2.155E-02, 0.000E+00, 2.841E-01, 1.304E-03, 2.300E+00, 1.358E+00, 1.717E+00, 2.772E-01, 3.089E-02},
    {590, 1.4105, 2.171E-02, 0.000E+00, 2.821E-01, 1.356E-03, 2.300E+00, 1.358E+00, 1.710E+00, 2.777E-01, 3.089E-02},
    {591, 1.4103, 2.185E-02, 0.000E+00, 2.803E-01, 1.408E-03, 2.300E+00, 1.357E+00, 1.702E+00, 2.782E-01, 3.089E-02},
    {592, 1.4101, 2.199E-02, 0.000E+00, 2.784E-01, 1.459E-03, 2.300E+00, 1.357E+00, 1.695E+00, 2.787E-01, 3.089E-02},
    {593, 1.4099, 2.211E-02, 0.000E+00, 2.766E-01, 1.510E-03, 2.300E+00, 1.356E+00, 1.688E+00, 2.792E-01, 3.088E-02},
    {594, 1.4097, 2.222E-02, 0.000E+00, 2.747E-01, 1.567E-03, 2.300E+00, 1.356E+00, 1.681E+00, 2.797E-01, 3.088E-02},
    {595, 1.4095, 2.231E-02, 0.000E+00, 2.728E-01, 1.635E-03, 2.300E+00, 1.356E+00, 1.674E+00, 2.802E-01, 3.088E-02},
    {596, 1.4093, 2.241E-02, 0.000E+00, 2.710E-01, 1.700E-03, 2.300E+00, 1.355E+00, 1.667E+00, 2.807E-01, 3.088E-02},
    {597, 1.4091, 2.250E-02, 0.000E+00, 2.691E-01, 1.758E-03, 2.300E+00, 1.355E+00, 1.659E+00, 2.812E-01, 3.087E-02},
    {598, 1.4089, 2.259E-02, 0.000E+00, 2.673E-01, 1.860E-03, 2.300E+00, 1.355E+00, 1.652E+00, 2.818E-01, 3.087E-02},
    {599, 1.4087, 2.269E-02, 0.000E+00, 2.654E-01, 2.042E-03, 2.300E+00, 1.354E+00, 1.645E+00, 2.823E-01, 3.087E-02},
    {600, 1.4086, 2.279E-02, 0.000E+00, 2.636E-01, 2.224E-03, 2.300E+00, 1.354E+00, 1.638E+00, 2.828E-01, 3.087E-02},
    {601, 1.4084, 2.291E-02, 0.000E+00, 2.618E-01, 2.323E-03, 2.300E+00, 1.356E+00, 1.635E+00, 2.833E-01, 3.098E-02},
    {602, 1.4082, 2.304E-02, 0.000E+00, 2.601E-01, 2.366E-03, 2.300E+00, 1.357E+00, 1.631E+00, 2.838E-01, 3.110E-02},
    {603, 1.4081, 2.319E-02, 0.000E+00, 2.584E-01, 2.400E-03, 2.300E+00, 1.359E+00, 1.628E+00, 2.844E-01, 3.122E-02},
    {604, 1.4079, 2.337E-02, 0.000E+00, 2.566E-01, 2.448E-03, 2.300E+00, 1.360E+00, 1.624E+00, 2.849E-01, 3.133E-02},
    {605, 1.4078, 2.356E-02, 0.000E+00, 2.549E-01, 2.519E-03, 2.300E+00, 1.362E+00, 1.621E+00, 2.855E-01, 3.145E-02},
    {606, 1.4077, 2.378E-02, 0.000E+00, 2.532E-01, 2.587E-03, 2.300E+00, 1.363E+00, 1.617E+00, 2.861E-01, 3.147E-02},
    {607, 1.4076, 2.403E-02, 0.000E+00, 2.515E-01, 2.629E-03, 2.300E+00, 1.365E+00, 1.614E+00, 2.866E-01, 3.150E-02},
    {608, 1.4075, 2.430E-02, 0.000E+00, 2.497E-01, 2.653E-03, 2.300E+00, 1.366E+00, 1.610E+00, 2.872E-01, 3.152E-02},
    {609, 1.4075, 2.459E-02, 0.000E+00, 2.480E-01, 2.674E-03, 2.300E+00, 1.368E+00, 1.607E+00, 2.878E-01, 3.155E-02},
    {610, 1.4075, 2.489E-02, 0.000E+00, 2.463E-01, 2.691E-03, 2.300E+00, 1.370E+00, 1.604E+00, 2.884E-01, 3.157E-02},
    {611, 1.4075, 2.520E-02, 0.000E+00, 2.447E-01, 2.704E-03, 2.300E+00, 1.371E+00, 1.600E+00, 2.890E-01, 3.157E-02},
    {612, 1.4075, 2.552E-02, 0.000E+00, 2.431E-01, 2.715E-03, 2.300E+00, 1.373E+00, 1.597E+00, 2.896E-01, 3.157E-02},
    {613, 1.4076, 2.586E-02, 0.000E+00, 2.414E-01, 2.727E-03, 2.300E+00, 1.374E+00, 1.593E+00, 2.902E-01, 3.156E-02},
    {614, 1.4077, 2.620E-02, 0.000E+00, 2.398E-01, 2.740E-03, 2.300E+00, 1.376E+00, 1.590E+00, 2.908E-01, 3.156E-02},
    {615, 1.4077, 2.654E-02, 0.000E+00, 2.382E-01, 2.753E-03, 2.300E+00, 1.377E+00, 1.586E+00, 2.913E-01, 3.156E-02},
    {616, 1.4078, 2.687E-02, 0.000E+00, 2.366E-01, 2.764E-03, 2.300E+00, 1.379E+00, 1.583E+00, 2.919E-01, 3.163E-02},
    {617, 1.4079, 2.719E-02, 0.000E+00, 2.350E-01, 2.775E-03, 2.300E+00, 1.380E+00, 1.579E+00, 2.924E-01, 3.170E-02},
    {618, 1.4080, 2.750E-02, 0.000E+00, 2.334E-01, 2.785E-03, 2.300E+00, 1.382E+00, 1.576E+00, 2.929E-01, 3.177E-02},
    {619, 1.4081, 2.778E-02, 0.000E+00, 2.318E-01, 2.797E-03, 2.300E+00, 1.383E+00, 1.572E+00, 2.934E-01, 3.184E-02},
    {620, 1.4082, 2.803E-02, 0.000E+00, 2.302E-01, 2.810E-03, 2.300E+00, 1.385E+00, 1.569E+00, 2.939E-01, 3.191E-02},
    {621, 1.4083, 2.826E-02, 0.000E+00, 2.288E-01, 2.824E-03, 2.300E+00, 1.385E+00, 1.564E+00, 2.944E-01, 3.198E-02},
    {622, 1.4083, 2.845E-02, 0.000E+00, 2.273E-01, 2.839E-03, 2.300E+00, 1.385E+00, 1.560E+00, 2.950E-01, 3.205E-02},
    {623, 1.4083, 2.862E-02, 0.000E+00, 2.258E-01, 2.854E-03, 2.300E+00, 1.385E+00, 1.555E+00, 2.955E-01, 3.212E-02},
    {624, 1.4083, 2.877E-02, 0.000E+00, 2.244E-01, 2.868E-03, 2.300E+00, 1.386E+00, 1.550E+00, 2.960E-01, 3.219E-02},
    {625, 1.4082, 2.888E-02, 0.000E+00, 2.229E-01, 2.881E-03, 2.300E+00, 1.386E+00, 1.546E+00, 2.965E-01, 3.227E-02},
    {626, 1.4082, 2.898E-02, 0.000E+00, 2.215E-01, 2.893E-03, 2.300E+00, 1.386E+00, 1.541E+00, 2.970E-01, 3.263E-02},
    {627, 1.4081, 2.905E-02, 0.000E+00, 2.200E-01, 2.907E-03, 2.300E+00, 1.386E+00, 1.536E+00, 2.975E-01, 3.299E-02},
    {628, 1.4079, 2.910E-02, 0.000E+00, 2.185E-01, 2.922E-03, 2.300E+00, 1.386E+00, 1.532E+00, 2.980E-01, 3.335E-02},
    {629, 1.4078, 2.916E-02, 0.000E+00, 2.171E-01, 2.938E-03, 2.300E+00, 1.386E+00, 1.527E+00, 2.985E-01, 3.371E-02},
    {630, 1.4077, 2.921E-02, 0.000E+00, 2.156E-01, 2.955E-03, 2.300E+00, 1.387E+00, 1.523E+00, 2.990E-01, 3.408E-02},
    {631, 1.4076, 2.928E-02, 0.000E+00, 2.143E-01, 2.972E-03, 2.300E+00, 1.387E+00, 1.518E+00, 2.995E-01, 3.407E-02},
    {632, 1.4076, 2.938E-02, 0.000E+00, 2.129E-01, 2.988E-03, 2.300E+00, 1.387E+00, 1.513E+00, 2.999E-01, 3.407E-02},
    {633, 1.4076, 2.951E-02, 0.000E+00, 2.115E-01, 3.000E-03, 2.300E+00, 1.387E+00, 1.509E+00, 3.004E-01, 3.407E-02},
    {634, 1.4078, 2.969E-02, 0.000E+00, 2.102E-01, 3.011E-03, 2.300E+00, 1.387E+00, 1.504E+00, 3.008E-01, 3.407E-02},
    {635, 1.4080, 2.993E-02, 0.000E+00, 2.088E-01, 3.023E-03, 2.300E+00, 1.387E+00, 1.499E+00, 3.013E-01, 3.406E-02},
    {636, 1.4083, 3.022E-02, 0.000E+00, 2.074E-01, 3.038E-03, 2.300E+00, 1.387E+00, 1.495E+00, 3.017E-01, 3.425E-02},
    {637, 1.4087, 3.059E-02, 0.000E+00, 2.061E-01, 3.057E-03, 2.300E+00, 1.388E+00, 1.490E+00, 3.022E-01, 3.443E-02},
    {638, 1.4093, 3.102E-02, 0.000E+00, 2.047E-01, 3.076E-03, 2.300E+00, 1.388E+00, 1.485E+00, 3.026E-01, 3.461E-02},
    {639, 1.4100, 3.152E-02, 0.000E+00, 2.033E-01, 3.094E-03, 2.300E+00, 1.388E+00, 1.481E+00, 3.030E-01, 3.479E-02},
    {640, 1.4108, 3.208E-02, 0.000E+00, 2.020E-01, 3.111E-03, 2.300E+00, 1.388E+00, 1.476E+00, 3.035E-01, 3.498E-02},
    {641, 1.4118, 3.269E-02, 0.000E+00, 2.007E-01, 3.127E-03, 2.300E+00, 1.387E+00, 1.470E+00, 3.039E-01, 3.515E-02},
    {642, 1.4128, 3.335E-02, 0.000E+00, 1.994E-01, 3.144E-03, 2.300E+00, 1.386E+00, 1.464E+00, 3.044E-01, 3.533E-02},
    {643, 1.4140, 3.405E-02, 0.000E+00, 1.981E-01, 3.162E-03, 2.300E+00, 1.384E+00, 1.458E+00, 3.048E-01, 3.551E-02},
    {644, 1.4153, 3.478E-02, 0.000E+00, 1.968E-01, 3.181E-03, 2.300E+00, 1.383E+00, 1.451E+00, 3.053E-01, 3.568E-02},
    {645, 1.4166, 3.552E-02, 0.000E+00, 1.955E-01, 3.202E-03, 2.300E+00, 1.382E+00, 1.445E+00, 3.057E-01, 3.586E-02},
    {646, 1.4179, 3.626E-02, 0.000E+00, 1.942E-01, 3.223E-03, 2.300E+00, 1.381E+00, 1.439E+00, 3.062E-01, 3.593E-02},
    {647, 1.4193, 3.698E-02, 0.000E+00, 1.929E-01, 3.242E-03, 2.300E+00, 1.379E+00, 1.433E+00, 3.066E-01, 3.600E-02},
    {648, 1.4206, 3.767E-02, 0.000E+00, 1.916E-01, 3.263E-03, 2.300E+00, 1.378E+00, 1.427E+00, 3.071E-01, 3.607E-02},
    {649, 1.4218, 3.831E-02, 0.000E+00, 1.903E-01, 3.289E-03, 2.300E+00, 1.377E+00, 1.421E+00, 3.075E-01, 3.614E-02},
    {650, 1.4229, 3.890E-02, 0.000E+00, 1.890E-01, 3.315E-03, 2.300E+00, 1.376E+00, 1.415E+00, 3.080E-01, 3.621E-02},
    {651, 1.4240, 3.943E-02, 0.000E+00, 1.878E-01, 3.338E-03, 2.300E+00, 1.374E+00, 1.408E+00, 3.086E-01, 3.636E-02},
    {652, 1.4250, 3.993E-02, 0.000E+00, 1.865E-01, 3.362E-03, 2.300E+00, 1.373E+00, 1.402E+00, 3.092E-01, 3.650E-02},
    {653, 1.4261, 4.043E-02, 0.000E+00, 1.853E-01, 3.390E-03, 2.300E+00, 1.372E+00, 1.396E+00, 3.097E-01, 3.664E-02},
    {654, 1.4272, 4.095E-02, 0.000E+00, 1.841E-01, 3.423E-03, 2.300E+00, 1.371E+00, 1.390E+00, 3.103E-01, 3.679E-02},
    {655, 1.4284, 4.152E-02, 0.000E+00, 1.829E-01, 3.461E-03, 2.300E+00, 1.369E+00, 1.384E+00, 3.109E-01, 3.693E-02},
    {656, 1.4298, 4.217E-02, 0.000E+00, 1.816E-01, 3.508E-03, 2.300E+00, 1.368E+00, 1.378E+00, 3.117E-01, 3.710E-02},
    {657, 1.4315, 4.293E-02, 0.000E+00, 1.804E-01, 3.567E-03, 2.300E+00, 1.367E+00, 1.371E+00, 3.125E-01, 3.727E-02},
    {658, 1.4335, 4.380E-02, 0.000E+00, 1.792E-01, 3.636E-03, 2.300E+00, 1.366E+00, 1.365E+00, 3.133E-01, 3.743E-02},
    {659, 1.4357, 4.478E-02, 0.000E+00, 1.780E-01, 3.712E-03, 2.300E+00, 1.364E+00, 1.359E+00, 3.141E-01, 3.760E-02},
    {660, 1.4383, 4.588E-02, 0.000E+00, 1.768E-01, 3.791E-03, 2.300E+00, 1.363E+00, 1.353E+00, 3.149E-01, 3.777E-02},
    {661, 1.4411, 4.709E-02, 0.000E+00, 1.755E-01, 3.866E-03, 2.300E+00, 1.364E+00, 1.350E+00, 3.156E-01, 3.782E-02},
    {662, 1.4442, 4.837E-02, 0.000E+00, 1.742E-01, 3.931E-03, 2.300E+00, 1.365E+00, 1.347E+00, 3.162E-01, 3.786E-02},
    {663, 1.4475, 4.970E-02, 0.000E+00, 1.729E-01, 3.981E-03, 2.300E+00, 1.366E+00, 1.344E+00, 3.169E-01, 3.791E-02},
    {664, 1.4509, 5.106E-02, 0.000E+00, 1.717E-01, 4.019E-03, 2.300E+00, 1.367E+00, 1.340E+00, 3.176E-01, 3.795E-02},
    {665, 1.4544, 5.239E-02, 0.000E+00, 1.704E-01, 4.049E-03, 2.300E+00, 1.368E+00, 1.337E+00, 3.182E-01, 3.800E-02},
    {666, 1.4579, 5.368E-02, 0.000E+00, 1.691E-01, 4.072E-03, 2.300E+00, 1.368E+00, 1.334E+00, 3.188E-01, 3.829E-02},
    {667, 1.4614, 5.488E-02, 0.000E+00, 1.679E-01, 4.087E-03, 2.300E+00, 1.369E+00, 1.331E+00, 3.193E-01, 3.858E-02},
    {668, 1.4649, 5.595E-02, 0.000E+00, 1.666E-01, 4.098E-03, 2.300E+00, 1.370E+00, 1.328E+00, 3.199E-01, 3.887E-02},
    {669, 1.4682, 5.688E-02, 0.000E+00, 1.653E-01, 4.109E-03, 2.300E+00, 1.371E+00, 1.325E+00, 3.204E-01, 3.916E-02},
    {670, 1.4714, 5.765E-02, 0.000E+00, 1.641E-01, 4.122E-03, 2.300E+00, 1.372E+00, 1.322E+00, 3.210E-01, 3.945E-02},
    {671, 1.4744, 5.826E-02, 0.000E+00, 1.627E-01, 4.137E-03, 2.300E+00, 1.373E+00, 1.318E+00, 3.216E-01, 3.944E-02},
    {672, 1.4773, 5.871E-02, 0.000E+00, 1.613E-01, 4.150E-03, 2.300E+00, 1.374E+00, 1.315E+00, 3.221E-01, 3.944E-02},
    {673, 1.4802, 5.900E-02, 0.000E+00, 1.600E-01, 4.160E-03, 2.300E+00, 1.375E+00, 1.312E+00, 3.227E-01, 3.944E-02},
    {674, 1.4830, 5.914E-02, 0.000E+00, 1.586E-01, 4.173E-03, 2.300E+00, 1.376E+00, 1.309E+00, 3.232E-01, 3.944E-02},
    {675, 1.4857, 5.914E-02, 0.000E+00, 1.572E-01, 4.196E-03, 2.300E+00, 1.377E+00, 1.306E+00, 3.238E-01, 3.943E-02},
    {676, 1.4884, 5.899E-02, 0.000E+00, 1.559E-01, 4.223E-03, 2.300E+00, 1.377E+00, 1.303E+00, 3.244E-01, 3.980E-02},
    {677, 1.4909, 5.868E-02, 0.000E+00, 1.545E-01, 4.248E-03, 2.300E+00, 1.378E+00, 1.299E+00, 3.250E-01, 4.016E-02},
    {678, 1.4932, 5.819E-02, 0.000E+00, 1.532E-01, 4.270E-03, 2.300E+00, 1.379E+00, 1.296E+00, 3.257E-01, 4.052E-02},
    {679, 1.4951, 5.748E-02, 0.000E+00, 1.518E-01, 4.293E-03, 2.300E+00, 1.380E+00, 1.293E+00, 3.263E-01, 4.088E-02},
    {680, 1.4963, 5.650E-02, 0.000E+00, 1.504E-01, 4.318E-03, 2.300E+00, 1.381E+00, 1.290E+00, 3.269E-01, 4.124E-02},
    {681, 1.4967, 5.522E-02, 0.000E+00, 1.491E-01, 4.347E-03, 2.300E+00, 1.375E+00, 1.281E+00, 3.275E-01, 4.131E-02},
    {682, 1.4958, 5.361E-02, 0.000E+00, 1.478E-01, 4.381E-03, 2.300E+00, 1.368E+00, 1.271E+00, 3.281E-01, 4.138E-02},
    {683, 1.4936, 5.168E-02, 0.000E+00, 1.464E-01, 4.418E-03, 2.300E+00, 1.362E+00, 1.262E+00, 3.288E-01, 4.146E-02},
    {684, 1.4899, 4.941E-02, 0.000E+00, 1.451E-01, 4.458E-03, 2.300E+00, 1.355E+00, 1.253E+00, 3.294E-01, 4.153E-02},
    {685, 1.4847, 4.689E-02, 0.000E+00, 1.437E-01, 4.500E-03, 2.300E+00, 1.349E+00, 1.243E+00, 3.300E-01, 4.160E-02},
    {686, 1.4780, 4.416E-02, 0.000E+00, 1.424E-01, 4.545E-03, 2.300E+00, 1.343E+00, 1.234E+00, 3.304E-01, 4.167E-02},
    {687, 1.4702, 4.128E-02, 0.000E+00, 1.411E-01, 4.594E-03, 2.300E+00, 1.336E+00, 1.225E+00, 3.309E-01, 4.174E-02},
    {688, 1.4618, 3.834E-02, 0.000E+00, 1.397E-01, 4.646E-03, 2.300E+00, 1.330E+00, 1.215E+00, 3.313E-01, 4.181E-02},
    {689, 1.4530, 3.541E-02, 0.000E+00, 1.384E-01, 4.701E-03, 2.300E+00, 1.323E+00, 1.206E+00, 3.317E-01, 4.188E-02},
    {690, 1.4445, 3.254E-02, 0.000E+00, 1.370E-01, 4.760E-03, 2.300E+00, 1.317E+00, 1.197E+00, 3.322E-01, 4.195E-02},
    {691, 1.4366, 2.978E-02, 0.000E+00, 1.358E-01, 4.827E-03, 2.300E+00, 1.311E+00, 1.187E+00, 3.325E-01, 4.195E-02},
    {692, 1.4296, 2.717E-02, 0.000E+00, 1.345E-01, 4.903E-03, 2.300E+00, 1.304E+00, 1.178E+00, 3.328E-01, 4.194E-02},
    {693, 1.4237, 2.473E-02, 0.000E+00, 1.333E-01, 4.986E-03, 2.300E+00, 1.298E+00, 1.168E+00, 3.332E-01, 4.194E-02},
    {694, 1.4190, 2.247E-02, 0.000E+00, 1.320E-01, 5.071E-03, 2.300E+00, 1.291E+00, 1.159E+00, 3.335E-01, 4.194E-02},
    {695, 1.4154, 2.039E-02, 0.000E+00, 1.308E-01, 5.154E-03, 2.300E+00, 1.285E+00, 1.150E+00, 3.338E-01, 4.194E-02},
    {696, 1.4129, 1.850E-02, 0.000E+00, 1.295E-01, 5.244E-03, 2.300E+00, 1.279E+00, 1.140E+00, 3.341E-01, 4.193E-02},
    {697, 1.4112, 1.678E-02, 0.000E+00, 1.283E-01, 5.351E-03, 2.300E+00, 1.272E+00, 1.131E+00, 3.345E-01, 4.193E-02},
    {698, 1.4104, 1.523E-02, 0.000E+00, 1.270E-01, 5.470E-03, 2.300E+00, 1.266E+00, 1.122E+00, 3.348E-01, 4.193E-02},
    {699, 1.4102, 1.384E-02, 0.000E+00, 1.258E-01, 5.594E-03, 2.300E+00, 1.259E+00, 1.112E+00, 3.351E-01, 4.193E-02},
    {700, 1.4106, 1.259E-02, 0.000E+00, 1.245E-01, 5.722E-03, 2.300E+00, 1.253E+00, 1.103E+00, 3.355E-01, 4.193E-02},
    {701, 1.4113, 1.147E-02, 0.000E+00, 1.234E-01, 5.855E-03, 2.300E+00, 1.236E+00, 1.085E+00, 3.361E-01, 4.214E-02},
    {702, 1.4124, 1.048E-02, 0.000E+00, 1.223E-01, 5.995E-03, 2.300E+00, 1.219E+00, 1.068E+00, 3.367E-01, 4.236E-02},
    {703, 1.4137, 9.594E-03, 0.000E+00, 1.212E-01, 6.146E-03, 2.300E+00, 1.201E+00, 1.050E+00, 3.373E-01, 4.257E-02},
    {704, 1.4152, 8.804E-03, 0.000E+00, 1.200E-01, 6.303E-03, 2.300E+00, 1.184E+00, 1.032E+00, 3.379E-01, 4.279E-02},
    {705, 1.4168, 8.099E-03, 0.000E+00, 1.189E-01, 6.463E-03, 2.300E+00, 1.167E+00, 1.014E+00, 3.385E-01, 4.301E-02},
    {706, 1.4186, 7.465E-03, 0.000E+00, 1.178E-01, 6.628E-03, 2.300E+00, 1.150E+00, 9.965E-01, 3.392E-01, 4.332E-02},
    {707, 1.4204, 6.892E-03, 0.000E+00, 1.167E-01, 6.804E-03, 2.300E+00, 1.133E+00, 9.788E-01, 3.398E-01, 4.363E-02},
    {708, 1.4222, 6.371E-03, 0.000E+00, 1.156E-01, 6.993E-03, 2.300E+00, 1.115E+00, 9.610E-01, 3.405E-01, 4.394E-02},
    {709, 1.4242, 5.897E-03, 0.000E+00, 1.144E-01, 7.197E-03, 2.300E+00, 1.098E+00, 9.433E-01, 3.412E-01, 4.426E-02},
    {710, 1.4261, 5.461E-03, 0.000E+00, 1.133E-01, 7.415E-03, 2.300E+00, 1.081E+00, 9.255E-01, 3.418E-01, 4.457E-02},
    {711, 1.4281, 5.061E-03, 0.000E+00, 1.122E-01, 7.647E-03, 2.300E+00, 1.064E+00, 9.078E-01, 3.424E-01, 4.462E-02},
    {712, 1.4301, 4.691E-03, 0.000E+00, 1.111E-01, 7.893E-03, 2.300E+00, 1.047E+00, 8.900E-01, 3.429E-01, 4.466E-02},
    {713, 1.4321, 4.348E-03, 0.000E+00, 1.100E-01, 8.157E-03, 2.300E+00, 1.029E+00, 8.723E-01, 3.434E-01, 4.471E-02},
    {714, 1.4341, 4.029E-03, 0.000E+00, 1.089E-01, 8.445E-03, 2.300E+00, 1.012E+00, 8.545E-01, 3.439E-01, 4.476E-02},
    {715, 1.4361, 3.733E-03, 0.000E+00, 1.078E-01, 8.763E-03, 2.300E+00, 9.950E-01, 8.368E-01, 3.444E-01, 4.480E-02},
    {716, 1.4382, 3.456E-03, 0.000E+00, 1.067E-01, 9.109E-03, 2.300E+00, 9.778E-01, 8.190E-01, 3.449E-01, 4.495E-02},
    {717, 1.4402, 3.199E-03, 0.000E+00, 1.056E-01, 9.479E-03, 2.300E+00, 9.606E-01, 8.013E-01, 3.454E-01, 4.509E-02},
    {718, 1.4422, 2.960E-03, 0.000E+00, 1.046E-01, 9.871E-03, 2.300E+00, 9.434E-01, 7.835E-01, 3.459E-01, 4.523E-02},
    {719, 1.4442, 2.736E-03, 0.000E+00, 1.035E-01, 1.029E-02, 2.300E+00, 9.262E-01, 7.658E-01, 3.464E-01, 4.538E-02},
    {720, 1.4462, 2.528E-03, 0.000E+00, 1.024E-01, 1.072E-02, 2.300E+00, 9.090E-01, 7.480E-01, 3.469E-01, 4.552E-02},
    {721, 1.4481, 2.334E-03, 0.000E+00, 1.013E-01, 1.119E-02, 2.300E+00, 9.248E-01, 7.579E-01, 3.476E-01, 4.566E-02},
    {722, 1.4500, 2.153E-03, 0.000E+00, 1.003E-01, 1.168E-02, 2.300E+00, 9.405E-01, 7.677E-01, 3.483E-01, 4.581E-02},
    {723, 1.4518, 1.985E-03, 0.000E+00, 9.931E-02, 1.218E-02, 2.300E+00, 9.563E-01, 7.776E-01, 3.490E-01, 4.595E-02},
    {724, 1.4536, 1.829E-03, 0.000E+00, 9.829E-02, 1.268E-02, 2.300E+00, 9.720E-01, 7.874E-01, 3.497E-01, 4.609E-02},
    {725, 1.4554, 1.683E-03, 0.000E+00, 9.727E-02, 1.319E-02, 2.300E+00, 9.878E-01, 7.973E-01, 3.504E-01, 4.624E-02},
    {726, 1.4571, 1.549E-03, 0.000E+00, 9.625E-02, 1.372E-02, 2.300E+00, 1.004E+00, 8.071E-01, 3.512E-01, 4.653E-02},
    {727, 1.4587, 1.424E-03, 0.000E+00, 9.524E-02, 1.428E-02, 2.300E+00, 1.019E+00, 8.170E-01, 3.520E-01, 4.682E-02},
    {728, 1.4603, 1.309E-03, 0.000E+00, 9.422E-02, 1.487E-02, 2.300E+00, 1.035E+00, 8.268E-01, 3.529E-01, 4.711E-02},
    {729, 1.4618, 1.202E-03, 0.000E+00, 9.320E-02, 1.551E-02, 2.300E+00, 1.051E+00, 8.367E-01, 3.537E-01, 4.739E-02},
    {730, 1.4632, 1.103E-03, 0.000E+00, 9.218E-02, 1.621E-02, 2.300E+00, 1.067E+00, 8.465E-01, 3.545E-01, 4.768E-02},
    {731, 1.4646, 1.012E-03, 0.000E+00, 9.120E-02, 1.699E-02, 2.300E+00, 1.082E+00, 8.564E-01, 3.549E-01, 4.805E-02},
    {732, 1.4659, 9.269E-04, 0.000E+00, 9.022E-02, 1.787E-02, 2.300E+00, 1.098E+00, 8.662E-01, 3.553E-01, 4.841E-02},
    {733, 1.4671, 8.485E-04, 0.000E+00, 8.924E-02, 1.886E-02, 2.300E+00, 1.114E+00, 8.761E-01, 3.557E-01, 4.877E-02},
    {734, 1.4683, 7.768E-04, 0.000E+00, 8.827E-02, 1.992E-02, 2.300E+00, 1.130E+00, 8.859E-01, 3.560E-01, 4.913E-02},
    {735, 1.4694, 7.110E-04, 0.000E+00, 8.729E-02, 2.101E-02, 2.300E+00, 1.145E+00, 8.958E-01, 3.564E-01, 4.949E-02},
    {736, 1.4704, 6.505E-04, 0.000E+00, 8.631E-02, 2.207E-02, 2.300E+00, 1.161E+00, 9.056E-01, 3.568E-01, 4.971E-02},
    {737, 1.4713, 5.948E-04, 0.000E+00, 8.533E-02, 2.306E-02, 2.300E+00, 1.177E+00, 9.155E-01, 3.572E-01, 4.993E-02},
    {738, 1.4721, 5.437E-04, 0.000E+00, 8.435E-02, 2.394E-02, 2.300E+00, 1.193E+00, 9.253E-01, 3.575E-01, 5.014E-02},
    {739, 1.4729, 4.967E-04, 0.000E+00, 8.337E-02, 2.469E-02, 2.300E+00, 1.208E+00, 9.352E-01, 3.579E-01, 5.036E-02},
    {740, 1.4736, 4.539E-04, 0.000E+00, 8.239E-02, 2.532E-02, 2.300E+00, 1.224E+00, 9.450E-01, 3.583E-01, 5.058E-02},
    {741, 1.4742, 4.150E-04, 0.000E+00, 8.155E-02, 2.583E-02, 2.300E+00, 1.182E+00, 9.114E-01, 3.587E-01, 5.073E-02},
    {742, 1.4747, 3.794E-04, 0.000E+00, 8.070E-02, 2.623E-02, 2.300E+00, 1.139E+00, 8.777E-01, 3.591E-01, 5.089E-02},
    {743, 1.4752, 3.471E-04, 0.000E+00, 7.985E-02, 2.652E-02, 2.300E+00, 1.097E+00, 8.441E-01, 3.595E-01, 5.105E-02},
    {744, 1.4756, 3.177E-04, 0.000E+00, 7.901E-02, 2.672E-02, 2.300E+00, 1.054E+00, 8.104E-01, 3.600E-01, 5.121E-02},
    {745, 1.4759, 2.909E-04, 0.000E+00, 7.816E-02, 2.689E-02, 2.300E+00, 1.012E+00, 7.768E-01, 3.604E-01, 5.136E-02},
    {746, 1.4762, 2.666E-04, 0.000E+00, 7.732E-02, 2.702E-02, 2.300E+00, 9.693E-01, 7.431E-01, 3.609E-01, 5.156E-02},
    {747, 1.4764, 2.450E-04, 0.000E+00, 7.647E-02, 2.713E-02, 2.300E+00, 9.269E-01, 7.095E-01, 3.615E-01, 5.175E-02},
    {748, 1.4765, 2.255E-04, 0.000E+00, 7.562E-02, 2.722E-02, 2.300E+00, 8.844E-01, 6.758E-01, 3.621E-01, 5.195E-02},
    {749, 1.4766, 2.079E-04, 0.000E+00, 7.478E-02, 2.728E-02, 2.300E+00, 8.420E-01, 6.422E-01, 3.626E-01, 5.214E-02},
    {750, 1.4766, 1.924E-04, 0.000E+00, 7.393E-02, 2.733E-02, 2.300E+00, 7.995E-01, 6.085E-01, 3.632E-01, 5.233E-02},
    {751, 1.4767, 1.773E-04, 0.000E+00, 7.319E-02, 2.738E-02, 2.300E+00, 7.571E-01, 5.749E-01, 3.637E-01, 5.253E-02},
    {752, 1.4767, 1.629E-04, 0.000E+00, 7.245E-02, 2.741E-02, 2.300E+00, 7.146E-01, 5.412E-01, 3.643E-01, 5.272E-02},
    {753, 1.4767, 1.493E-04, 0.000E+00, 7.171E-02, 2.745E-02, 2.300E+00, 6.722E-01, 5.076E-01, 3.649E-01, 5.292E-02},
    {754, 1.4767, 1.364E-04, 0.000E+00, 7.097E-02, 2.748E-02, 2.300E+00, 6.297E-01, 4.739E-01, 3.654E-01, 5.311E-02},
    {755, 1.4766, 1.243E-04, 0.000E+00, 7.023E-02, 2.751E-02, 2.300E+00, 5.873E-01, 4.403E-01, 3.660E-01, 5.330E-02},
    {756, 1.4766, 1.128E-04, 0.000E+00, 6.949E-02, 2.754E-02, 2.300E+00, 5.448E-01, 4.066E-01, 3.667E-01, 5.355E-02},
    {757, 1.4765, 1.020E-04, 0.000E+00, 6.875E-02, 2.758E-02, 2.300E+00, 5.024E-01, 3.730E-01, 3.674E-01, 5.380E-02},
    {758, 1.4764, 9.188E-05, 0.000E+00, 6.801E-02, 2.763E-02, 2.300E+00, 4.599E-01, 3.393E-01, 3.681E-01, 5.404E-02},
    {759, 1.4763, 8.240E-05, 0.000E+00, 6.727E-02, 2.767E-02, 2.300E+00, 4.175E-01, 3.057E-01, 3.688E-01, 5.429E-02},
    {760, 1.4762, 7.354E-05, 0.000E+00, 6.653E-02, 2.771E-02, 2.300E+00, 3.750E-01, 2.720E-01, 3.695E-01, 5.454E-02},
    {761, 1.4761, 6.529E-05, 0.000E+00, 6.586E-02, 2.773E-02, 2.300E+00, 4.185E-01, 3.015E-01, 3.700E-01, 5.461E-02},
    {762, 1.4759, 5.763E-05, 0.000E+00, 6.519E-02, 2.773E-02, 2.300E+00, 4.619E-01, 3.310E-01, 3.705E-01, 5.468E-02},
    {763, 1.4758, 5.054E-05, 0.000E+00, 6.452E-02, 2.774E-02, 2.300E+00, 5.054E-01, 3.605E-01, 3.710E-01, 5.475E-02},
    {764, 1.4756, 4.400E-05, 0.000E+00, 6.385E-02, 2.774E-02, 2.300E+00, 5.488E-01, 3.900E-01, 3.715E-01, 5.482E-02},
    {765, 1.4754, 3.800E-05, 0.000E+00, 6.318E-02, 2.773E-02, 2.300E+00, 5.923E-01, 4.195E-01, 3.719E-01, 5.489E-02},
    {766, 1.4752, 3.251E-05, 0.000E+00, 6.251E-02, 2.770E-02, 2.300E+00, 6.357E-01, 4.490E-01, 3.722E-01, 5.489E-02},
    {767, 1.4751, 2.753E-05, 0.000E+00, 6.184E-02, 2.766E-02, 2.300E+00, 6.792E-01, 4.785E-01, 3.725E-01, 5.488E-02},
    {768, 1.4748, 2.302E-05, 0.000E+00, 6.117E-02, 2.761E-02, 2.300E+00, 7.226E-01, 5.080E-01, 3.728E-01, 5.488E-02},
    {769, 1.4746, 1.898E-05, 0.000E+00, 6.050E-02, 2.757E-02, 2.300E+00, 7.661E-01, 5.375E-01, 3.731E-01, 5.488E-02},
    {770, 1.4744, 1.539E-05, 0.000E+00, 5.983E-02, 2.754E-02, 2.300E+00, 8.095E-01, 5.670E-01, 3.733E-01, 5.488E-02},
    {771, 1.4742, 1.222E-05, 0.000E+00, 5.913E-02, 2.752E-02, 2.300E+00, 8.530E-01, 5.965E-01, 3.736E-01, 5.490E-02},
    {772, 1.4739, 9.466E-06, 0.000E+00, 5.843E-02, 2.748E-02, 2.300E+00, 8.964E-01, 6.260E-01, 3.739E-01, 5.493E-02},
    {773, 1.4737, 7.101E-06, 0.000E+00, 5.773E-02, 2.741E-02, 2.300E+00, 9.399E-01, 6.555E-01, 3.742E-01, 5.496E-02},
    {774, 1.4734, 5.109E-06, 0.000E+00, 5.704E-02, 2.731E-02, 2.300E+00, 9.833E-01, 6.850E-01, 3.745E-01, 5.498E-02},
    {775, 1.4732, 3.473E-06, 0.000E+00, 5.634E-02, 2.720E-02, 2.300E+00, 1.027E+00, 7.145E-01, 3.747E-01, 5.501E-02},
    {776, 1.4729, 2.175E-06, 0.000E+00, 5.564E-02, 2.710E-02, 2.300E+00, 1.070E+00, 7.440E-01, 3.752E-01, 5.549E-02},
    {777, 1.4727, 1.196E-06, 0.000E+00, 5.494E-02, 2.701E-02, 2.300E+00, 1.114E+00, 7.735E-01, 3.758E-01, 5.597E-02},
    {778, 1.4725, 5.200E-07, 0.000E+00, 5.424E-02, 2.690E-02, 2.300E+00, 1.157E+00, 8.030E-01, 3.763E-01, 5.645E-02},
    {779, 1.4722, 1.270E-07, 0.000E+00, 5.354E-02, 2.675E-02, 2.300E+00, 1.201E+00, 8.325E-01, 3.768E-01, 5.692E-02},
    {780, 1.4720, 0.000E+00, 0.000E+00, 5.284E-02, 2.659E-02, 2.300E+00, 1.244E+00, 8.620E-01, 3.773E-01, 5.740E-02},
    {781, 1.4718, 0.000E+00, 0.000E+00, 5.226E-02, 2.645E-02, 2.300E+00, 1.242E+00, 8.586E-01, 3.778E-01, 5.753E-02},
    {782, 1.4716, 0.000E+00, 0.000E+00, 5.167E-02, 2.633E-02, 2.300E+00, 1.240E+00, 8.552E-01, 3.783E-01, 5.766E-02},
    {783, 1.4714, 0.000E+00, 0.000E+00, 5.109E-02, 2.624E-02, 2.300E+00, 1.238E+00, 8.518E-01, 3.789E-01, 5.778E-02},
    {784, 1.4712, 0.000E+00, 0.000E+00, 5.050E-02, 2.613E-02, 2.300E+00, 1.235E+00, 8.484E-01, 3.794E-01, 5.791E-02},
    {785, 1.4710, 0.000E+00, 0.000E+00, 4.992E-02, 2.593E-02, 2.300E+00, 1.233E+00, 8.450E-01, 3.799E-01, 5.804E-02},
    {786, 1.4708, 0.000E+00, 0.000E+00, 4.933E-02, 2.558E-02, 2.300E+00, 1.231E+00, 8.416E-01, 3.804E-01, 5.813E-02},
    {787, 1.4706, 0.000E+00, 0.000E+00, 4.874E-02, 2.523E-02, 2.300E+00, 1.229E+00, 8.382E-01, 3.808E-01, 5.821E-02},
    {788, 1.4703, 0.000E+00, 0.000E+00, 4.816E-02, 2.513E-02, 2.300E+00, 1.227E+00, 8.348E-01, 3.813E-01, 5.830E-02},
    {789, 1.4701, 0.000E+00, 0.000E+00, 4.757E-02, 2.501E-02, 2.300E+00, 1.225E+00, 8.314E-01, 3.817E-01, 5.839E-02},
    {790, 1.4700, 0.000E+00, 0.000E+00, 4.699E-02, 2.466E-02, 2.300E+00, 1.223E+00, 8.280E-01, 3.822E-01, 5.847E-02},
    {791, 1.4698, 0.000E+00, 0.000E+00, 4.646E-02, 2.447E-02, 2.300E+00, 1.220E+00, 8.246E-01, 3.825E-01, 5.884E-02},
    {792, 1.4696, 0.000E+00, 0.000E+00, 4.594E-02, 2.412E-02, 2.300E+00, 1.218E+00, 8.212E-01, 3.829E-01, 5.920E-02},
    {793, 1.4694, 0.000E+00, 0.000E+00, 4.542E-02, 2.389E-02, 2.300E+00, 1.216E+00, 8.178E-01, 3.832E-01, 5.956E-02},
    {794, 1.4692, 0.000E+00, 0.000E+00, 4.490E-02, 2.374E-02, 2.300E+00, 1.214E+00, 8.144E-01, 3.836E-01, 5.992E-02},
    {795, 1.4690, 0.000E+00, 0.000E+00, 4.437E-02, 2.355E-02, 2.300E+00, 1.212E+00, 8.110E-01, 3.839E-01, 6.028E-02},
    {796, 1.4688, 0.000E+00, 0.000E+00, 4.385E-02, 2.337E-02, 2.300E+00, 1.210E+00, 8.076E-01, 3.843E-01, 6.028E-02},
    {797, 1.4686, 0.000E+00, 0.000E+00, 4.333E-02, 2.318E-02, 2.300E+00, 1.207E+00, 8.042E-01, 3.846E-01, 6.028E-02},
    {798, 1.4684, 0.000E+00, 0.000E+00, 4.281E-02, 2.304E-02, 2.300E+00, 1.205E+00, 8.008E-01, 3.850E-01, 6.028E-02},
    {799, 1.4682, 0.000E+00, 0.000E+00, 4.228E-02, 2.281E-02, 2.300E+00, 1.203E+00, 7.974E-01, 3.853E-01, 6.027E-02},
    {800, 1.4681, 0.000E+00, 0.000E+00, 4.176E-02, 2.246E-02, 2.300E+00, 1.201E+00, 7.940E-01, 3.857E-01, 6.027E-02},
    {801, 1.4679, 0.000E+00, 0.000E+00, 4.128E-02, 2.243E-02, 2.300E+00, 1.188E+00, 7.840E-01, 3.862E-01, 6.063E-02},
    {802, 1.4677, 0.000E+00, 0.000E+00, 4.081E-02, 2.238E-02, 2.300E+00, 1.174E+00, 7.739E-01, 3.866E-01, 6.100E-02},
    {803, 1.4675, 0.000E+00, 0.000E+00, 4.033E-02, 2.222E-02, 2.300E+00, 1.161E+00, 7.639E-01, 3.871E-01, 6.136E-02},
    {804, 1.4674, 0.000E+00, 0.000E+00, 3.985E-02, 2.204E-02, 2.300E+00, 1.147E+00, 7.538E-01, 3.876E-01, 6.172E-02},
    {805, 1.4672, 0.000E+00, 0.000E+00, 3.937E-02, 2.201E-02, 2.300E+00, 1.134E+00, 7.438E-01, 3.881E-01, 6.208E-02},
    {806, 1.4670, 0.000E+00, 0.000E+00, 3.889E-02, 2.204E-02, 2.300E+00, 1.121E+00, 7.337E-01, 3.886E-01, 6.223E-02},
    {807, 1.4668, 0.000E+00, 0.000E+00, 3.841E-02, 2.196E-02, 2.300E+00, 1.107E+00, 7.237E-01, 3.891E-01, 6.237E-02},
    {808, 1.4666, 0.000E+00, 0.000E+00, 3.793E-02, 2.177E-02, 2.300E+00, 1.094E+00, 7.136E-01, 3.896E-01, 6.251E-02},
    {809, 1.4665, 0.000E+00, 0.000E+00, 3.746E-02, 2.190E-02, 2.300E+00, 1.080E+00, 7.036E-01, 3.901E-01, 6.266E-02},
    {810, 1.4663, 0.000E+00, 0.000E+00, 3.698E-02, 2.188E-02, 2.300E+00, 1.067E+00, 6.935E-01, 3.906E-01, 6.280E-02},
    {811, 1.4662, 0.000E+00, 0.000E+00, 3.657E-02, 2.188E-02, 2.300E+00, 1.054E+00, 6.835E-01, 3.911E-01, 6.280E-02},
    {812, 1.4660, 0.000E+00, 0.000E+00, 3.615E-02, 2.198E-02, 2.300E+00, 1.040E+00, 6.734E-01, 3.917E-01, 6.279E-02},
    {813, 1.4659, 0.000E+00, 0.000E+00, 3.574E-02, 2.210E-02, 2.300E+00, 1.027E+00, 6.634E-01, 3.922E-01, 6.279E-02},
    {814, 1.4657, 0.000E+00, 0.000E+00, 3.533E-02, 2.223E-02, 2.300E+00, 1.013E+00, 6.533E-01, 3.928E-01, 6.279E-02},
    {815, 1.4655, 0.000E+00, 0.000E+00, 3.492E-02, 2.233E-02, 2.300E+00, 1.000E+00, 6.433E-01, 3.933E-01, 6.279E-02},
    {816, 1.4654, 0.000E+00, 0.000E+00, 3.451E-02, 2.248E-02, 2.300E+00, 9.866E-01, 6.332E-01, 3.939E-01, 6.300E-02},
    {817, 1.4652, 0.000E+00, 0.000E+00, 3.409E-02, 2.276E-02, 2.300E+00, 9.732E-01, 6.232E-01, 3.944E-01, 6.322E-02},
    {818, 1.4651, 0.000E+00, 0.000E+00, 3.368E-02, 2.304E-02, 2.300E+00, 9.598E-01, 6.131E-01, 3.950E-01, 6.344E-02},
    {819, 1.4649, 0.000E+00, 0.000E+00, 3.327E-02, 2.311E-02, 2.300E+00, 9.464E-01, 6.031E-01, 3.955E-01, 6.365E-02},
    {820, 1.4648, 0.000E+00, 0.000E+00, 3.286E-02, 2.329E-02, 2.300E+00, 9.330E-01, 5.930E-01, 3.961E-01, 6.387E-02},
    {821, 1.4646, 0.000E+00, 0.000E+00, 3.249E-02, 2.388E-02, 2.300E+00, 9.416E-01, 5.972E-01, 3.966E-01, 6.433E-02},
    {822, 1.4645, 0.000E+00, 0.000E+00, 3.212E-02, 2.446E-02, 2.300E+00, 9.502E-01, 6.013E-01, 3.971E-01, 6.479E-02},
    {823, 1.4643, 0.000E+00, 0.000E+00, 3.175E-02, 2.475E-02, 2.300E+00, 9.588E-01, 6.055E-01, 3.976E-01, 6.525E-02},
    {824, 1.4641, 0.000E+00, 0.000E+00, 3.139E-02, 2.516E-02, 2.300E+00, 9.674E-01, 6.096E-01, 3.981E-01, 6.571E-02},
    {825, 1.4639, 0.000E+00, 0.000E+00, 3.102E-02, 2.620E-02, 2.300E+00, 9.760E-01, 6.138E-01, 3.987E-01, 6.616E-02},
    {826, 1.4638, 0.000E+00, 0.000E+00, 3.065E-02, 2.769E-02, 2.300E+00, 9.846E-01, 6.179E-01, 3.991E-01, 6.643E-02},
    {827, 1.4636, 0.000E+00, 0.000E+00, 3.028E-02, 2.830E-02, 2.300E+00, 9.932E-01, 6.221E-01, 3.995E-01, 6.669E-02},
    {828, 1.4635, 0.000E+00, 0.000E+00, 2.991E-02, 2.914E-02, 2.300E+00, 1.002E+00, 6.262E-01, 3.999E-01, 6.696E-02},
    {829, 1.4633, 0.000E+00, 0.000E+00, 2.954E-02, 3.108E-02, 2.300E+00, 1.010E+00, 6.304E-01, 4.003E-01, 6.722E-02},
    {830, 1.4631, 0.000E+00, 0.000E+00, 2.918E-02, 3.214E-02, 2.300E+00, 1.019E+00, 6.345E-01, 4.007E-01, 6.749E-02},
    {831, 1.4630, 0.000E+00, 0.000E+00, 2.885E-02, 3.297E-02, 2.300E+00, 1.028E+00, 6.387E-01, 4.010E-01, 6.749E-02},
    {832, 1.4628, 0.000E+00, 0.000E+00, 2.852E-02, 3.459E-02, 2.300E+00, 1.036E+00, 6.428E-01, 4.013E-01, 6.748E-02},
    {833, 1.4627, 0.000E+00, 0.000E+00, 2.819E-02, 3.606E-02, 2.300E+00, 1.045E+00, 6.470E-01, 4.015E-01, 6.748E-02},
    {834, 1.4626, 0.000E+00, 0.000E+00, 2.786E-02, 3.662E-02, 2.300E+00, 1.053E+00, 6.511E-01, 4.018E-01, 6.748E-02},
    {835, 1.4625, 0.000E+00, 0.000E+00, 2.753E-02, 3.702E-02, 2.300E+00, 1.062E+00, 6.553E-01, 4.021E-01, 6.748E-02},
    {836, 1.4623, 0.000E+00, 0.000E+00, 2.720E-02, 3.788E-02, 2.300E+00, 1.071E+00, 6.594E-01, 4.023E-01, 6.747E-02},
    {837, 1.4622, 0.000E+00, 0.000E+00, 2.688E-02, 3.829E-02, 2.300E+00, 1.079E+00, 6.636E-01, 4.026E-01, 6.747E-02},
    {838, 1.4620, 0.000E+00, 0.000E+00, 2.655E-02, 3.854E-02, 2.300E+00, 1.088E+00, 6.677E-01, 4.028E-01, 6.747E-02},
    {839, 1.4619, 0.000E+00, 0.000E+00, 2.622E-02, 3.909E-02, 2.300E+00, 1.096E+00, 6.719E-01, 4.031E-01, 6.747E-02},
    {840, 1.4617, 0.000E+00, 0.000E+00, 2.589E-02, 3.949E-02, 2.300E+00, 1.105E+00, 6.760E-01, 4.034E-01, 6.747E-02},
    {841, 1.4616, 0.000E+00, 0.000E+00, 2.559E-02, 3.972E-02, 2.300E+00, 1.105E+00, 6.752E-01, 4.038E-01, 6.776E-02},
    {842, 1.4614, 0.000E+00, 0.000E+00, 2.529E-02, 4.000E-02, 2.300E+00, 1.106E+00, 6.744E-01, 4.043E-01, 6.806E-02},
    {843, 1.4613, 0.000E+00, 0.000E+00, 2.499E-02, 4.040E-02, 2.300E+00, 1.106E+00, 6.736E-01, 4.047E-01, 6.836E-02},
    {844, 1.4611, 0.000E+00, 0.000E+00, 2.469E-02, 4.057E-02, 2.300E+00, 1.107E+00, 6.728E-01, 4.052E-01, 6.866E-02},
    {845, 1.4610, 0.000E+00, 0.000E+00, 2.440E-02, 4.075E-02, 2.300E+00, 1.107E+00, 6.720E-01, 4.056E-01, 6.896E-02},
    {846, 1.4608, 0.000E+00, 0.000E+00, 2.410E-02, 4.115E-02, 2.300E+00, 1.108E+00, 6.712E-01, 4.061E-01, 6.938E-02},
    {847, 1.4607, 0.000E+00, 0.000E+00, 2.380E-02, 4.127E-02, 2.300E+00, 1.108E+00, 6.704E-01, 4.066E-01, 6.981E-02},
    {848, 1.4605, 0.000E+00, 0.000E+00, 2.350E-02, 4.149E-02, 2.300E+00, 1.109E+00, 6.696E-01, 4.070E-01, 7.023E-02},
    {849, 1.4604, 0.000E+00, 0.000E+00, 2.320E-02, 4.204E-02, 2.300E+00, 1.109E+00, 6.688E-01, 4.075E-01, 7.066E-02},
    {850, 1.4602, 0.000E+00, 0.000E+00, 2.290E-02, 4.199E-02, 2.300E+00, 1.110E+00, 6.680E-01, 4.079E-01, 7.109E-02},
    {851, 1.4601, 0.000E+00, 0.000E+00, 2.264E-02, 4.223E-02, 2.300E+00, 1.110E+00, 6.672E-01, 4.082E-01, 7.108E-02},
    {852, 1.4600, 0.000E+00, 0.000E+00, 2.238E-02, 4.254E-02, 2.300E+00, 1.110E+00, 6.664E-01, 4.085E-01, 7.108E-02},
    {853, 1.4599, 0.000E+00, 0.000E+00, 2.212E-02, 4.272E-02, 2.300E+00, 1.111E+00, 6.656E-01, 4.088E-01, 7.108E-02},
    {854, 1.4597, 0.000E+00, 0.000E+00, 2.186E-02, 4.280E-02, 2.300E+00, 1.111E+00, 6.648E-01, 4.091E-01, 7.108E-02},
    {855, 1.4596, 0.000E+00, 0.000E+00, 2.159E-02, 4.306E-02, 2.300E+00, 1.112E+00, 6.640E-01, 4.094E-01, 7.107E-02},
    {856, 1.4595, 0.000E+00, 0.000E+00, 2.133E-02, 4.360E-02, 2.300E+00, 1.112E+00, 6.632E-01, 4.097E-01, 7.107E-02},
    {857, 1.4594, 0.000E+00, 0.000E+00, 2.107E-02, 4.369E-02, 2.300E+00, 1.113E+00, 6.624E-01, 4.099E-01, 7.107E-02},
    {858, 1.4592, 0.000E+00, 0.000E+00, 2.081E-02, 4.379E-02, 2.300E+00, 1.113E+00, 6.616E-01, 4.102E-01, 7.107E-02},
    {859, 1.4591, 0.000E+00, 0.000E+00, 2.055E-02, 4.433E-02, 2.300E+00, 1.114E+00, 6.608E-01, 4.104E-01, 7.106E-02},
    {860, 1.4589, 0.000E+00, 0.000E+00, 2.029E-02, 4.454E-02, 2.300E+00, 1.114E+00, 6.600E-01, 4.107E-01, 7.106E-02},
    {861, 1.4587, 0.000E+00, 0.000E+00, 2.006E-02, 4.466E-02, 2.300E+00, 1.114E+00, 6.580E-01, 4.110E-01, 7.113E-02},
    {862, 1.4586, 0.000E+00, 0.000E+00, 1.983E-02, 4.505E-02, 2.300E+00, 1.113E+00, 6.560E-01, 4.113E-01, 7.119E-02},
    {863, 1.4584, 0.000E+00, 0.000E+00, 1.961E-02, 4.527E-02, 2.300E+00, 1.113E+00, 6.540E-01, 4.116E-01, 7.126E-02},
    {864, 1.4583, 0.000E+00, 0.000E+00, 1.938E-02, 4.552E-02, 2.300E+00, 1.112E+00, 6.520E-01, 4.119E-01, 7.132E-02},
    {865, 1.4582, 0.000E+00, 0.000E+00, 1.915E-02, 4.605E-02, 2.300E+00, 1.112E+00, 6.500E-01, 4.122E-01, 7.139E-02},
    {866, 1.4582, 0.000E+00, 0.000E+00, 1.893E-02, 4.658E-02, 2.300E+00, 1.111E+00, 6.480E-01, 4.128E-01, 7.197E-02},
    {867, 1.4581, 0.000E+00, 0.000E+00, 1.870E-02, 4.691E-02, 2.300E+00, 1.111E+00, 6.460E-01, 4.134E-01, 7.256E-02},
    {868, 1.4580, 0.000E+00, 0.000E+00, 1.847E-02, 4.705E-02, 2.300E+00, 1.110E+00, 6.440E-01, 4.139E-01, 7.315E-02},
    {869, 1.4579, 0.000E+00, 0.000E+00, 1.825E-02, 4.713E-02, 2.300E+00, 1.110E+00, 6.420E-01, 4.145E-01, 7.373E-02},
    {870, 1.4577, 0.000E+00, 0.000E+00, 1.802E-02, 4.752E-02, 2.300E+00, 1.109E+00, 6.400E-01, 4.150E-01, 7.432E-02},
    {871, 1.4576, 0.000E+00, 0.000E+00, 1.782E-02, 4.833E-02, 2.300E+00, 1.109E+00, 6.380E-01, 4.155E-01, 7.432E-02},
    {872, 1.4574, 0.000E+00, 0.000E+00, 1.762E-02, 4.867E-02, 2.300E+00, 1.108E+00, 6.360E-01, 4.160E-01, 7.431E-02},
    {873, 1.4572, 0.000E+00, 0.000E+00, 1.742E-02, 4.894E-02, 2.300E+00, 1.108E+00, 6.340E-01, 4.165E-01, 7.431E-02},
    {874, 1.4571, 0.000E+00, 0.000E+00, 1.723E-02, 4.960E-02, 2.300E+00, 1.107E+00, 6.320E-01, 4.170E-01, 7.431E-02},
    {875, 1.4569, 0.000E+00, 0.000E+00, 1.703E-02, 5.006E-02, 2.300E+00, 1.107E+00, 6.300E-01, 4.175E-01, 7.431E-02},
    {876, 1.4568, 0.000E+00, 0.000E+00, 1.683E-02, 5.050E-02, 2.300E+00, 1.106E+00, 6.280E-01, 4.178E-01, 7.445E-02},
    {877, 1.4566, 0.000E+00, 0.000E+00, 1.663E-02, 5.115E-02, 2.300E+00, 1.106E+00, 6.260E-01, 4.182E-01, 7.459E-02},
    {878, 1.4565, 0.000E+00, 0.000E+00, 1.643E-02, 5.153E-02, 2.300E+00, 1.105E+00, 6.240E-01, 4.185E-01, 7.474E-02},
    {879, 1.4563, 0.000E+00, 0.000E+00, 1.623E-02, 5.204E-02, 2.300E+00, 1.105E+00, 6.220E-01, 4.189E-01, 7.488E-02},
    {880, 1.4562, 0.000E+00, 0.000E+00, 1.604E-02, 5.298E-02, 2.300E+00, 1.104E+00, 6.200E-01, 4.193E-01, 7.502E-02},
    {881, 1.4560, 0.000E+00, 0.000E+00, 1.586E-02, 5.346E-02, 2.300E+00, 1.087E+00, 6.094E-01, 4.196E-01, 7.521E-02},
    {882, 1.4559, 0.000E+00, 0.000E+00, 1.568E-02, 5.386E-02, 2.300E+00, 1.070E+00, 5.988E-01, 4.200E-01, 7.539E-02},
    {883, 1.4558, 0.000E+00, 0.000E+00, 1.551E-02, 5.465E-02, 2.300E+00, 1.053E+00, 5.882E-01, 4.204E-01, 7.558E-02},
    {884, 1.4556, 0.000E+00, 0.000E+00, 1.533E-02, 5.528E-02, 2.300E+00, 1.036E+00, 5.776E-01, 4.207E-01, 7.576E-02},
    {885, 1.4554, 0.000E+00, 0.000E+00, 1.516E-02, 5.566E-02, 2.300E+00, 1.019E+00, 5.670E-01, 4.211E-01, 7.595E-02},
    {886, 1.4553, 0.000E+00, 0.000E+00, 1.498E-02, 5.596E-02, 2.300E+00, 1.002E+00, 5.564E-01, 4.214E-01, 7.614E-02},
    {887, 1.4551, 0.000E+00, 0.000E+00, 1.481E-02, 5.653E-02, 2.300E+00, 9.850E-01, 5.458E-01, 4.217E-01, 7.632E-02},
    {888, 1.4550, 0.000E+00, 0.000E+00, 1.463E-02, 5.745E-02, 2.300E+00, 9.680E-01, 5.352E-01, 4.221E-01, 7.651E-02},
    {889, 1.4548, 0.000E+00, 0.000E+00, 1.446E-02, 5.789E-02, 2.300E+00, 9.510E-01, 5.246E-01, 4.224E-01, 7.670E-02},
    {890, 1.4547, 0.000E+00, 0.000E+00, 1.428E-02, 5.831E-02, 2.300E+00, 9.340E-01, 5.140E-01, 4.227E-01, 7.689E-02},
    {891, 1.4545, 0.000E+00, 0.000E+00, 1.414E-02, 5.924E-02, 2.300E+00, 9.170E-01, 5.034E-01, 4.230E-01, 7.717E-02},
    {892, 1.4544, 0.000E+00, 0.000E+00, 1.400E-02, 5.982E-02, 2.300E+00, 9.000E-01, 4.928E-01, 4.232E-01, 7.745E-02},
    {893, 1.4542, 0.000E+00, 0.000E+00, 1.385E-02, 6.009E-02, 2.300E+00, 8.830E-01, 4.822E-01, 4.235E-01, 7.772E-02},
    {894, 1.4541, 0.000E+00, 0.000E+00, 1.371E-02, 6.035E-02, 2.300E+00, 8.660E-01, 4.716E-01, 4.237E-01, 7.800E-02},
    {895, 1.4539, 0.000E+00, 0.000E+00, 1.357E-02, 6.094E-02, 2.300E+00, 8.490E-01, 4.610E-01, 4.240E-01, 7.828E-02},
    {896, 1.4538, 0.000E+00, 0.000E+00, 1.343E-02, 6.185E-02, 2.300E+00, 8.320E-01, 4.504E-01, 4.242E-01, 7.848E-02},
    {897, 1.4536, 0.000E+00, 0.000E+00, 1.328E-02, 6.226E-02, 2.300E+00, 8.150E-01, 4.398E-01, 4.245E-01, 7.867E-02},
    {898, 1.4535, 0.000E+00, 0.000E+00, 1.314E-02, 6.269E-02, 2.300E+00, 7.980E-01, 4.292E-01, 4.247E-01, 7.887E-02},
    {899, 1.4533, 0.000E+00, 0.000E+00, 1.300E-02, 6.360E-02, 2.300E+00, 7.810E-01, 4.186E-01, 4.250E-01, 7.907E-02},
    {900, 1.4532, 0.000E+00, 0.000E+00, 1.286E-02, 6.407E-02, 2.300E+00, 7.640E-01, 4.080E-01, 4.252E-01, 7.927E-02},
    {901, 1.4531, 0.000E+00, 0.000E+00, 1.275E-02, 6.458E-02, 2.300E+00, 7.758E-01, 4.130E-01, 4.255E-01, 7.943E-02},
    {902, 1.4529, 0.000E+00, 0.000E+00, 1.265E-02, 6.562E-02, 2.300E+00, 7.876E-01, 4.179E-01, 4.258E-01, 7.959E-02},
    {903, 1.4528, 0.000E+00, 0.000E+00, 1.255E-02, 6.636E-02, 2.300E+00, 7.994E-01, 4.229E-01, 4.261E-01, 7.975E-02},
    {904, 1.4526, 0.000E+00, 0.000E+00, 1.245E-02, 6.672E-02, 2.300E+00, 8.112E-01, 4.278E-01, 4.264E-01, 7.991E-02},
    {905, 1.4525, 0.000E+00, 0.000E+00, 1.235E-02, 6.699E-02, 2.300E+00, 8.230E-01, 4.328E-01, 4.267E-01, 8.007E-02},
    {906, 1.4524, 0.000E+00, 0.000E+00, 1.225E-02, 6.769E-02, 2.300E+00, 8.348E-01, 4.377E-01, 4.270E-01, 8.006E-02},
    {907, 1.4522, 0.000E+00, 0.000E+00, 1.215E-02, 6.900E-02, 2.300E+00, 8.466E-01, 4.427E-01, 4.274E-01, 8.006E-02},
    {908, 1.4521, 0.000E+00, 0.000E+00, 1.205E-02, 6.989E-02, 2.300E+00, 8.584E-01, 4.476E-01, 4.277E-01, 8.006E-02},
    {909, 1.4519, 0.000E+00, 0.000E+00, 1.195E-02, 7.037E-02, 2.300E+00, 8.702E-01, 4.526E-01, 4.281E-01, 8.006E-02},
    {910, 1.4518, 0.000E+00, 0.000E+00, 1.185E-02, 7.085E-02, 2.300E+00, 8.820E-01, 4.575E-01, 4.284E-01, 8.005E-02},
    {911, 1.4516, 0.000E+00, 0.000E+00, 1.175E-02, 7.187E-02, 2.300E+00, 8.938E-01, 4.625E-01, 4.288E-01, 8.022E-02},
    {912, 1.4515, 0.000E+00, 0.000E+00, 1.165E-02, 7.358E-02, 2.300E+00, 9.056E-01, 4.674E-01, 4.291E-01, 8.039E-02},
    {913, 1.4513, 0.000E+00, 0.000E+00, 1.155E-02, 7.486E-02, 2.300E+00, 9.174E-01, 4.724E-01, 4.295E-01, 8.056E-02},
    {914, 1.4512, 0.000E+00, 0.000E+00, 1.145E-02, 7.562E-02, 2.300E+00, 9.292E-01, 4.773E-01, 4.298E-01, 8.073E-02},
    {915, 1.4511, 0.000E+00, 0.000E+00, 1.135E-02, 7.630E-02, 2.300E+00, 9.410E-01, 4.823E-01, 4.302E-01, 8.090E-02},
    {916, 1.4509, 0.000E+00, 0.000E+00, 1.125E-02, 7.792E-02, 2.300E+00, 9.528E-01, 4.872E-01, 4.306E-01, 8.120E-02},
    {917, 1.4508, 0.000E+00, 0.000E+00, 1.115E-02, 8.085E-02, 2.300E+00, 9.646E-01, 4.922E-01, 4.311E-01, 8.151E-02},
    {918, 1.4506, 0.000E+00, 0.000E+00, 1.105E-02, 8.292E-02, 2.300E+00, 9.764E-01, 4.971E-01, 4.315E-01, 8.181E-02},
    {919, 1.4505, 0.000E+00, 0.000E+00, 1.096E-02, 8.410E-02, 2.300E+00, 9.882E-01, 5.021E-01, 4.319E-01, 8.212E-02},
    {920, 1.4503, 0.000E+00, 0.000E+00, 1.086E-02, 8.528E-02, 2.300E+00, 1.000E+00, 5.070E-01, 4.324E-01, 8.243E-02},
    {921, 1.4502, 0.000E+00, 0.000E+00, 1.076E-02, 8.801E-02, 2.300E+00, 9.771E-01, 4.948E-01, 4.328E-01, 8.272E-02},
    {922, 1.4500, 0.000E+00, 0.000E+00, 1.066E-02, 9.268E-02, 2.300E+00, 9.542E-01, 4.826E-01, 4.333E-01, 8.301E-02},
    {923, 1.4498, 0.000E+00, 0.000E+00, 1.056E-02, 9.584E-02, 2.300E+00, 9.313E-01, 4.704E-01, 4.337E-01, 8.330E-02},
    {924, 1.4497, 0.000E+00, 0.000E+00, 1.047E-02, 9.819E-02, 2.300E+00, 9.084E-01, 4.582E-01, 4.342E-01, 8.359E-02},
    {925, 1.4495, 0.000E+00, 0.000E+00, 1.037E-02, 1.012E-01, 2.300E+00, 8.855E-01, 4.460E-01, 4.346E-01, 8.389E-02},
    {926, 1.4493, 0.000E+00, 0.000E+00, 1.027E-02, 1.042E-01, 2.300E+00, 8.626E-01, 4.338E-01, 4.351E-01, 8.404E-02},
    {927, 1.4492, 0.000E+00, 0.000E+00, 1.017E-02, 1.066E-01, 2.300E+00, 8.397E-01, 4.216E-01, 4.355E-01, 8.419E-02},
    {928, 1.4491, 0.000E+00, 0.000E+00, 1.008E-02, 1.113E-01, 2.300E+00, 8.168E-01, 4.094E-01, 4.359E-01, 8.434E-02},
    {929, 1.4489, 0.000E+00, 0.000E+00, 9.980E-03, 1.194E-01, 2.300E+00, 7.939E-01, 3.972E-01, 4.364E-01, 8.449E-02},
    {930, 1.4488, 0.000E+00, 0.000E+00, 9.884E-03, 1.246E-01, 2.300E+00, 7.710E-01, 3.850E-01, 4.368E-01, 8.464E-02},
    {931, 1.4487, 0.000E+00, 0.000E+00, 9.787E-03, 1.281E-01, 2.300E+00, 7.481E-01, 3.728E-01, 4.370E-01, 8.495E-02},
    {932, 1.4485, 0.000E+00, 0.000E+00, 9.691E-03, 1.327E-01, 2.300E+00, 7.252E-01, 3.606E-01, 4.373E-01, 8.526E-02},
    {933, 1.4483, 0.000E+00, 0.000E+00, 9.595E-03, 1.374E-01, 2.300E+00, 7.023E-01, 3.484E-01, 4.376E-01, 8.557E-02},
    {934, 1.4481, 0.000E+00, 0.000E+00, 9.500E-03, 1.410E-01, 2.300E+00, 6.794E-01, 3.362E-01, 4.378E-01, 8.588E-02},
    {935, 1.4479, 0.000E+00, 0.000E+00, 9.404E-03, 1.465E-01, 2.300E+00, 6.565E-01, 3.240E-01, 4.381E-01, 8.619E-02},
    {936, 1.4478, 0.000E+00, 0.000E+00, 9.309E-03, 1.557E-01, 2.300E+00, 6.336E-01, 3.118E-01, 4.384E-01, 8.636E-02},
    {937, 1.4477, 0.000E+00, 0.000E+00, 9.214E-03, 1.635E-01, 2.300E+00, 6.107E-01, 2.996E-01, 4.386E-01, 8.653E-02},
    {938, 1.4476, 0.000E+00, 0.000E+00, 9.120E-03, 1.688E-01, 2.300E+00, 5.878E-01, 2.874E-01, 4.389E-01, 8.670E-02},
    {939, 1.4474, 0.000E+00, 0.000E+00, 9.025E-03, 1.732E-01, 2.300E+00, 5.649E-01, 2.752E-01, 4.392E-01, 8.686E-02},
    {940, 1.4472, 0.000E+00, 0.000E+00, 8.931E-03, 1.818E-01, 2.300E+00, 5.420E-01, 2.630E-01, 4.394E-01, 8.703E-02},
    {941, 1.4469, 0.000E+00, 0.000E+00, 8.837E-03, 1.963E-01, 2.300E+00, 5.412E-01, 2.621E-01, 4.397E-01, 8.737E-02},
    {942, 1.4466, 0.000E+00, 0.000E+00, 8.743E-03, 2.050E-01, 2.300E+00, 5.403E-01, 2.611E-01, 4.400E-01, 8.771E-02},
    {943, 1.4465, 0.000E+00, 0.000E+00, 8.650E-03, 2.106E-01, 2.300E+00, 5.395E-01, 2.602E-01, 4.403E-01, 8.804E-02},
    {944, 1.4463, 0.000E+00, 0.000E+00, 8.557E-03, 2.187E-01, 2.300E+00, 5.386E-01, 2.592E-01, 4.406E-01, 8.838E-02},
    {945, 1.4462, 0.000E+00, 0.000E+00, 8.464E-03, 2.287E-01, 2.300E+00, 5.378E-01, 2.583E-01, 4.409E-01, 8.872E-02},
    {946, 1.4461, 0.000E+00, 0.000E+00, 8.371E-03, 2.386E-01, 2.300E+00, 5.369E-01, 2.573E-01, 4.412E-01, 8.882E-02},
    {947, 1.4461, 0.000E+00, 0.000E+00, 8.279E-03, 2.468E-01, 2.300E+00, 5.361E-01, 2.564E-01, 4.415E-01, 8.893E-02},
    {948, 1.4461, 0.000E+00, 0.000E+00, 8.187E-03, 2.542E-01, 2.300E+00, 5.352E-01, 2.554E-01, 4.418E-01, 8.904E-02},
    {949, 1.4460, 0.000E+00, 0.000E+00, 8.095E-03, 2.701E-01, 2.300E+00, 5.344E-01, 2.545E-01, 4.421E-01, 8.914E-02},
    {950, 1.4457, 0.000E+00, 0.000E+00, 8.004E-03, 2.976E-01, 2.300E+00, 5.335E-01, 2.535E-01, 4.424E-01, 8.925E-02},
    {951, 1.4455, 0.000E+00, 0.000E+00, 7.913E-03, 3.153E-01, 2.300E+00, 5.327E-01, 2.526E-01, 4.427E-01, 8.947E-02},
    {952, 1.4453, 0.000E+00, 0.000E+00, 7.822E-03, 3.274E-01, 2.300E+00, 5.318E-01, 2.516E-01, 4.430E-01, 8.969E-02},
    {953, 1.4451, 0.000E+00, 0.000E+00, 7.732E-03, 3.438E-01, 2.300E+00, 5.310E-01, 2.507E-01, 4.433E-01, 8.991E-02},
    {954, 1.4450, 0.000E+00, 0.000E+00, 7.641E-03, 3.622E-01, 2.300E+00, 5.301E-01, 2.497E-01, 4.436E-01, 9.013E-02},
    {955, 1.4449, 0.000E+00, 0.000E+00, 7.552E-03, 3.785E-01, 2.300E+00, 5.293E-01, 2.488E-01, 4.438E-01, 9.035E-02},
    {956, 1.4448, 0.000E+00, 0.000E+00, 7.462E-03, 3.930E-01, 2.300E+00, 5.284E-01, 2.478E-01, 4.439E-01, 9.058E-02},
    {957, 1.4447, 0.000E+00, 0.000E+00, 7.373E-03, 4.068E-01, 2.300E+00, 5.276E-01, 2.469E-01, 4.440E-01, 9.081E-02},
    {958, 1.4445, 0.000E+00, 0.000E+00, 7.284E-03, 4.184E-01, 2.300E+00, 5.267E-01, 2.459E-01, 4.441E-01, 9.104E-02},
    {959, 1.4445, 0.000E+00, 0.000E+00, 7.195E-03, 4.273E-01, 2.300E+00, 5.259E-01, 2.450E-01, 4.441E-01, 9.127E-02},
    {960, 1.4445, 0.000E+00, 0.000E+00, 7.107E-03, 4.385E-01, 2.300E+00, 5.250E-01, 2.440E-01, 4.442E-01, 9.151E-02},
    {961, 1.4442, 0.000E+00, 0.000E+00, 7.019E-03, 4.538E-01, 2.300E+00, 5.362E-01, 2.484E-01, 4.443E-01, 9.189E-02},
    {962, 1.4440, 0.000E+00, 0.000E+00, 6.932E-03, 4.611E-01, 2.300E+00, 5.474E-01, 2.528E-01, 4.444E-01, 9.227E-02},
    {963, 1.4438, 0.000E+00, 0.000E+00, 6.844E-03, 4.633E-01, 2.300E+00, 5.586E-01, 2.572E-01, 4.445E-01, 9.265E-02},
    {964, 1.4437, 0.000E+00, 0.000E+00, 6.758E-03, 4.663E-01, 2.300E+00, 5.698E-01, 2.616E-01, 4.446E-01, 9.303E-02},
    {965, 1.4436, 0.000E+00, 0.000E+00, 6.671E-03, 4.701E-01, 2.300E+00, 5.810E-01, 2.660E-01, 4.447E-01, 9.341E-02},
    {966, 1.4436, 0.000E+00, 0.000E+00, 6.585E-03, 4.733E-01, 2.300E+00, 5.922E-01, 2.704E-01, 4.450E-01, 9.355E-02},
    {967, 1.4435, 0.000E+00, 0.000E+00, 6.499E-03, 4.756E-01, 2.300E+00, 6.034E-01, 2.748E-01, 4.453E-01, 9.369E-02},
    {968, 1.4434, 0.000E+00, 0.000E+00, 6.414E-03, 4.772E-01, 2.300E+00, 6.146E-01, 2.792E-01, 4.456E-01, 9.384E-02},
    {969, 1.4434, 0.000E+00, 0.000E+00, 6.329E-03, 4.785E-01, 2.300E+00, 6.258E-01, 2.836E-01, 4.459E-01, 9.398E-02},
    {970, 1.4434, 0.000E+00, 0.000E+00, 6.244E-03, 4.800E-01, 2.300E+00, 6.370E-01, 2.880E-01, 4.462E-01, 9.412E-02},
    {971, 1.4434, 0.000E+00, 0.000E+00, 6.160E-03, 4.814E-01, 2.300E+00, 6.482E-01, 2.924E-01, 4.465E-01, 9.437E-02},
    {972, 1.4432, 0.000E+00, 0.000E+00, 6.076E-03, 4.827E-01, 2.300E+00, 6.594E-01, 2.968E-01, 4.468E-01, 9.461E-02},
    {973, 1.4430, 0.000E+00, 0.000E+00, 5.993E-03, 4.843E-01, 2.300E+00, 6.706E-01, 3.012E-01, 4.471E-01, 9.485E-02},
    {974, 1.4428, 0.000E+00, 0.000E+00, 5.910E-03, 4.864E-01, 2.300E+00, 6.818E-01, 3.056E-01, 4.474E-01, 9.509E-02},
    {975, 1.4427, 0.000E+00, 0.000E+00, 5.827E-03, 4.870E-01, 2.300E+00, 6.930E-01, 3.100E-01, 4.477E-01, 9.534E-02},
    {976, 1.4426, 0.000E+00, 0.000E+00, 5.745E-03, 4.867E-01, 2.300E+00, 7.042E-01, 3.144E-01, 4.479E-01, 9.540E-02},
    {977, 1.4425, 0.000E+00, 0.000E+00, 5.663E-03, 4.864E-01, 2.300E+00, 7.154E-01, 3.188E-01, 4.482E-01, 9.546E-02},
    {978, 1.4423, 0.000E+00, 0.000E+00, 5.581E-03, 4.857E-01, 2.300E+00, 7.266E-01, 3.232E-01, 4.485E-01, 9.552E-02},
    {979, 1.4421, 0.000E+00, 0.000E+00, 5.500E-03, 4.841E-01, 2.300E+00, 7.378E-01, 3.276E-01, 4.487E-01, 9.558E-02},
    {980, 1.4420, 0.000E+00, 0.000E+00, 5.419E-03, 4.821E-01, 2.300E+00, 7.490E-01, 3.320E-01, 4.490E-01, 9.564E-02},
    {981, 1.4418, 0.000E+00, 0.000E+00, 5.339E-03, 4.804E-01, 2.300E+00, 7.564E-01, 3.344E-01, 4.492E-01, 9.569E-02},
    {982, 1.4416, 0.000E+00, 0.000E+00, 5.259E-03, 4.786E-01, 2.300E+00, 7.638E-01, 3.368E-01, 4.495E-01, 9.575E-02},
    {983, 1.4415, 0.000E+00, 0.000E+00, 5.180E-03, 4.764E-01, 2.300E+00, 7.712E-01, 3.392E-01, 4.497E-01, 9.580E-02},
    {984, 1.4414, 0.000E+00, 0.000E+00, 5.101E-03, 4.738E-01, 2.300E+00, 7.786E-01, 3.416E-01, 4.500E-01, 9.586E-02},
    {985, 1.4414, 0.000E+00, 0.000E+00, 5.023E-03, 4.710E-01, 2.300E+00, 7.860E-01, 3.440E-01, 4.502E-01, 9.591E-02},
    {986, 1.4414, 0.000E+00, 0.000E+00, 4.945E-03, 4.677E-01, 2.300E+00, 7.934E-01, 3.464E-01, 4.506E-01, 9.617E-02},
    {987, 1.4415, 0.000E+00, 0.000E+00, 4.867E-03, 4.641E-01, 2.300E+00, 8.008E-01, 3.488E-01, 4.509E-01, 9.643E-02},
    {988, 1.4416, 0.000E+00, 0.000E+00, 4.790E-03, 4.604E-01, 2.300E+00, 8.082E-01, 3.512E-01, 4.513E-01, 9.669E-02},
    {989, 1.4416, 0.000E+00, 0.000E+00, 4.713E-03, 4.570E-01, 2.300E+00, 8.156E-01, 3.536E-01, 4.516E-01, 9.695E-02},
    {990, 1.4415, 0.000E+00, 0.000E+00, 4.637E-03, 4.532E-01, 2.300E+00, 8.230E-01, 3.560E-01, 4.520E-01, 9.722E-02},
    {991, 1.4414, 0.000E+00, 0.000E+00, 4.561E-03, 4.482E-01, 2.300E+00, 8.304E-01, 3.584E-01, 4.525E-01, 9.797E-02},
    {992, 1.4413, 0.000E+00, 0.000E+00, 4.486E-03, 4.434E-01, 2.300E+00, 8.378E-01, 3.608E-01, 4.530E-01, 9.872E-02},
    {993, 1.4411, 0.000E+00, 0.000E+00, 4.411E-03, 4.397E-01, 2.300E+00, 8.452E-01, 3.632E-01, 4.535E-01, 9.947E-02},
    {994, 1.4409, 0.000E+00, 0.000E+00, 4.337E-03, 4.362E-01, 2.300E+00, 8.526E-01, 3.656E-01, 4.540E-01, 1.002E-01},
    {995, 1.4407, 0.000E+00, 0.000E+00, 4.263E-03, 4.316E-01, 2.300E+00, 8.600E-01, 3.680E-01, 4.545E-01, 1.010E-01},
    {996, 1.4405, 0.000E+00, 0.000E+00, 4.190E-03, 4.265E-01, 2.300E+00, 8.674E-01, 3.704E-01, 4.549E-01, 1.010E-01},
    {997, 1.4403, 0.000E+00, 0.000E+00, 4.117E-03, 4.215E-01, 2.300E+00, 8.748E-01, 3.728E-01, 4.553E-01, 1.010E-01},
    {998, 1.4401, 0.000E+00, 0.000E+00, 4.044E-03, 4.168E-01, 2.300E+00, 8.822E-01, 3.752E-01, 4.557E-01, 1.010E-01},
    {999, 1.4400, 0.000E+00, 0.000E+00, 3.972E-03, 4.121E-01, 2.300E+00, 8.896E-01, 3.776E-01, 4.561E-01, 1.010E-01},
    {1000, 1.4399, 0.000E+00, 0.000E+00, 3.901E-03, 4.072E-01, 2.300E+00, 8.970E-01, 3.800E-01, 4.565E-01, 1.010E-01},
    {1001, 1.4397, 0.000E+00, 0.000E+00, 3.830E-03, 4.017E-01, 2.300E+00, 8.952E-01, 3.786E-01, 4.568E-01, 1.010E-01},
    {1002, 1.4395, 0.000E+00, 0.000E+00, 3.760E-03, 3.963E-01, 2.300E+00, 8.933E-01, 3.771E-01, 4.571E-01, 1.011E-01},
    {1003, 1.4394, 0.000E+00, 0.000E+00, 3.690E-03, 3.915E-01, 2.300E+00, 8.915E-01, 3.757E-01, 4.573E-01, 1.011E-01},
    {1004, 1.4393, 0.000E+00, 0.000E+00, 3.620E-03, 3.868E-01, 2.300E+00, 8.896E-01, 3.742E-01, 4.576E-01, 1.012E-01},
    {1005, 1.4392, 0.000E+00, 0.000E+00, 3.552E-03, 3.816E-01, 2.300E+00, 8.878E-01, 3.728E-01, 4.579E-01, 1.012E-01},
    {1006, 1.4392, 0.000E+00, 0.000E+00, 3.483E-03, 3.760E-01, 2.300E+00, 8.859E-01, 3.713E-01, 4.579E-01, 1.015E-01},
    {1007, 1.4391, 0.000E+00, 0.000E+00, 3.416E-03, 3.701E-01, 2.300E+00, 8.841E-01, 3.699E-01, 4.580E-01, 1.017E-01},
    {1008, 1.4391, 0.000E+00, 0.000E+00, 3.348E-03, 3.640E-01, 2.300E+00, 8.822E-01, 3.684E-01, 4.580E-01, 1.019E-01},
    {1009, 1.4390, 0.000E+00, 0.000E+00, 3.282E-03, 3.581E-01, 2.300E+00, 8.804E-01, 3.670E-01, 4.580E-01, 1.022E-01},
    {1010, 1.4389, 0.000E+00, 0.000E+00, 3.215E-03, 3.521E-01, 2.300E+00, 8.785E-01, 3.655E-01, 4.581E-01, 1.024E-01},
    {1011, 1.4387, 0.000E+00, 0.000E+00, 3.150E-03, 3.461E-01, 2.300E+00, 8.767E-01, 3.641E-01, 4.582E-01, 1.026E-01},
    {1012, 1.4386, 0.000E+00, 0.000E+00, 3.085E-03, 3.402E-01, 2.300E+00, 8.748E-01, 3.626E-01, 4.583E-01, 1.028E-01},
    {1013, 1.4385, 0.000E+00, 0.000E+00, 3.020E-03, 3.349E-01, 2.300E+00, 8.730E-01, 3.612E-01, 4.584E-01, 1.031E-01},
    {1014, 1.4384, 0.000E+00, 0.000E+00, 2.956E-03, 3.297E-01, 2.300E+00, 8.711E-01, 3.597E-01, 4.585E-01, 1.033E-01},
    {1015, 1.4384, 0.000E+00, 0.000E+00, 2.893E-03, 3.243E-01, 2.300E+00, 8.693E-01, 3.583E-01, 4.586E-01, 1.035E-01},
    {1016, 1.4383, 0.000E+00, 0.000E+00, 2.830E-03, 3.191E-01, 2.300E+00, 8.674E-01, 3.568E-01, 4.589E-01, 1.035E-01},
    {1017, 1.4381, 0.000E+00, 0.000E+00, 2.768E-03, 3.141E-01, 2.300E+00, 8.656E-01, 3.554E-01, 4.591E-01, 1.035E-01},
    {1018, 1.4379, 0.000E+00, 0.000E+00, 2.706E-03, 3.086E-01, 2.300E+00, 8.637E-01, 3.539E-01, 4.594E-01, 1.035E-01},
    {1019, 1.4378, 0.000E+00, 0.000E+00, 2.645E-03, 3.022E-01, 2.300E+00, 8.619E-01, 3.525E-01, 4.597E-01, 1.035E-01},
    {1020, 1.4376, 0.000E+00, 0.000E+00, 2.585E-03, 2.957E-01, 2.300E+00, 8.600E-01, 3.510E-01, 4.599E-01, 1.035E-01},
    {1021, 1.4374, 0.000E+00, 0.000E+00, 2.525E-03, 2.897E-01, 2.300E+00, 8.588E-01, 3.499E-01, 4.602E-01, 1.035E-01},
    {1022, 1.4372, 0.000E+00, 0.000E+00, 2.465E-03, 2.840E-01, 2.300E+00, 8.575E-01, 3.487E-01, 4.604E-01, 1.035E-01},
    {1023, 1.4371, 0.000E+00, 0.000E+00, 2.407E-03, 2.782E-01, 2.300E+00, 8.563E-01, 3.476E-01, 4.606E-01, 1.035E-01},
    {1024, 1.4370, 0.000E+00, 0.000E+00, 2.348E-03, 2.724E-01, 2.300E+00, 8.550E-01, 3.464E-01, 4.608E-01, 1.035E-01},
    {1025, 1.4369, 0.000E+00, 0.000E+00, 2.291E-03, 2.672E-01, 2.300E+00, 8.538E-01, 3.453E-01, 4.611E-01, 1.035E-01},
    {1026, 1.4368, 0.000E+00, 0.000E+00, 2.234E-03, 2.621E-01, 2.300E+00, 8.525E-01, 3.441E-01, 4.613E-01, 1.042E-01},
    {1027, 1.4367, 0.000E+00, 0.000E+00, 2.178E-03, 2.566E-01, 2.300E+00, 8.513E-01, 3.430E-01, 4.614E-01, 1.049E-01},
    {1028, 1.4365, 0.000E+00, 0.000E+00, 2.122E-03, 2.506E-01, 2.300E+00, 8.500E-01, 3.418E-01, 4.616E-01, 1.056E-01},
    {1029, 1.4365, 0.000E+00, 0.000E+00, 2.067E-03, 2.444E-01, 2.300E+00, 8.488E-01, 3.407E-01, 4.618E-01, 1.063E-01},
    {1030, 1.4364, 0.000E+00, 0.000E+00, 2.012E-03, 2.391E-01, 2.300E+00, 8.475E-01, 3.395E-01, 4.620E-01, 1.070E-01},
    {1031, 1.4364, 0.000E+00, 0.000E+00, 1.959E-03, 2.357E-01, 2.300E+00, 8.463E-01, 3.384E-01, 4.622E-01, 1.075E-01},
    {1032, 1.4363, 0.000E+00, 0.000E+00, 1.905E-03, 2.331E-01, 2.300E+00, 8.450E-01, 3.372E-01, 4.623E-01, 1.080E-01},
    {1033, 1.4363, 0.000E+00, 0.000E+00, 1.853E-03, 2.299E-01, 2.300E+00, 8.438E-01, 3.361E-01, 4.625E-01, 1.086E-01},
    {1034, 1.4363, 0.000E+00, 0.000E+00, 1.801E-03, 2.251E-01, 2.300E+00, 8.425E-01, 3.349E-01, 4.627E-01, 1.091E-01},
    {1035, 1.4363, 0.000E+00, 0.000E+00, 1.750E-03, 2.198E-01, 2.300E+00, 8.413E-01, 3.338E-01, 4.628E-01, 1.096E-01},
    {1036, 1.4363, 0.000E+00, 0.000E+00, 1.699E-03, 2.151E-01, 2.300E+00, 8.400E-01, 3.326E-01, 4.628E-01, 1.096E-01},
    {1037, 1.4362, 0.000E+00, 0.000E+00, 1.649E-03, 2.109E-01, 2.300E+00, 8.388E-01, 3.315E-01, 4.627E-01, 1.096E-01},
    {1038, 1.4361, 0.000E+00, 0.000E+00, 1.600E-03, 2.064E-01, 2.300E+00, 8.375E-01, 3.303E-01, 4.627E-01, 1.096E-01},
    {1039, 1.4360, 0.000E+00, 0.000E+00, 1.551E-03, 2.020E-01, 2.300E+00, 8.363E-01, 3.292E-01, 4.627E-01, 1.096E-01},
    {1040, 1.4359, 0.000E+00, 0.000E+00, 1.503E-03, 1.981E-01, 2.300E+00, 8.350E-01, 3.280E-01, 4.626E-01, 1.096E-01},
    {1041, 1.4357, 0.000E+00, 0.000E+00, 1.456E-03, 1.944E-01, 2.300E+00, 8.333E-01, 3.268E-01, 4.626E-01, 1.096E-01},
    {1042, 1.4356, 0.000E+00, 0.000E+00, 1.409E-03, 1.904E-01, 2.300E+00, 8.316E-01, 3.256E-01, 4.626E-01, 1.096E-01},
    {1043, 1.4354, 0.000E+00, 0.000E+00, 1.363E-03, 1.868E-01, 2.300E+00, 8.299E-01, 3.244E-01, 4.625E-01, 1.096E-01},
    {1044, 1.4352, 0.000E+00, 0.000E+00, 1.318E-03, 1.841E-01, 2.300E+00, 8.282E-01, 3.232E-01, 4.625E-01, 1.096E-01},
    {1045, 1.4351, 0.000E+00, 0.000E+00, 1.274E-03, 1.818E-01, 2.300E+00, 8.265E-01, 3.220E-01, 4.625E-01, 1.096E-01},
    {1046, 1.4351, 0.000E+00, 0.000E+00, 1.230E-03, 1.790E-01, 2.300E+00, 8.248E-01, 3.208E-01, 4.625E-01, 1.096E-01},
    {1047, 1.4350, 0.000E+00, 0.000E+00, 1.187E-03, 1.752E-01, 2.300E+00, 8.231E-01, 3.196E-01, 4.626E-01, 1.096E-01},
    {1048, 1.4349, 0.000E+00, 0.000E+00, 1.144E-03, 1.715E-01, 2.300E+00, 8.214E-01, 3.184E-01, 4.626E-01, 1.096E-01},
    {1049, 1.4349, 0.000E+00, 0.000E+00, 1.102E-03, 1.687E-01, 2.300E+00, 8.197E-01, 3.172E-01, 4.627E-01, 1.096E-01},
    {1050, 1.4348, 0.000E+00, 0.000E+00, 1.061E-03, 1.664E-01, 2.300E+00, 8.180E-01, 3.160E-01, 4.628E-01, 1.096E-01},
    {1051, 1.4347, 0.000E+00, 0.000E+00, 1.021E-03, 1.639E-01, 2.300E+00, 8.163E-01, 3.148E-01, 4.628E-01, 1.097E-01},
    {1052, 1.4345, 0.000E+00, 0.000E+00, 9.811E-04, 1.613E-01, 2.300E+00, 8.146E-01, 3.136E-01, 4.629E-01, 1.099E-01},
    {1053, 1.4343, 0.000E+00, 0.000E+00, 9.422E-04, 1.586E-01, 2.300E+00, 8.129E-01, 3.124E-01, 4.630E-01, 1.100E-01},
    {1054, 1.4342, 0.000E+00, 0.000E+00, 9.040E-04, 1.562E-01, 2.300E+00, 8.112E-01, 3.112E-01, 4.631E-01, 1.102E-01},
    {1055, 1.4342, 0.000E+00, 0.000E+00, 8.665E-04, 1.545E-01, 2.300E+00, 8.095E-01, 3.100E-01, 4.631E-01, 1.103E-01},
    {1056, 1.4342, 0.000E+00, 0.000E+00, 8.297E-04, 1.532E-01, 2.300E+00, 8.078E-01, 3.088E-01, 4.632E-01, 1.105E-01},
    {1057, 1.4341, 0.000E+00, 0.000E+00, 7.937E-04, 1.522E-01, 2.300E+00, 8.061E-01, 3.076E-01, 4.633E-01, 1.108E-01},
    {1058, 1.4340, 0.000E+00, 0.000E+00, 7.584E-04, 1.510E-01, 2.300E+00, 8.044E-01, 3.064E-01, 4.634E-01, 1.110E-01},
    {1059, 1.4339, 0.000E+00, 0.000E+00, 7.239E-04, 1.495E-01, 2.300E+00, 8.027E-01, 3.052E-01, 4.635E-01, 1.112E-01},
    {1060, 1.4338, 0.000E+00, 0.000E+00, 6.901E-04, 1.475E-01, 2.300E+00, 8.010E-01, 3.040E-01, 4.636E-01, 1.114E-01},
    {1061, 1.4337, 0.000E+00, 0.000E+00, 6.571E-04, 1.457E-01, 2.300E+00, 7.977E-01, 3.023E-01, 4.640E-01, 1.118E-01},
    {1062, 1.4335, 0.000E+00, 0.000E+00, 6.248E-04, 1.447E-01, 2.300E+00, 7.944E-01, 3.006E-01, 4.645E-01, 1.121E-01},
    {1063, 1.4334, 0.000E+00, 0.000E+00, 5.933E-04, 1.442E-01, 2.300E+00, 7.911E-01, 2.989E-01, 4.649E-01, 1.125E-01},
    {1064, 1.4333, 0.000E+00, 0.000E+00, 5.626E-04, 1.438E-01, 2.300E+00, 7.878E-01, 2.972E-01, 4.653E-01, 1.129E-01},
    {1065, 1.4333, 0.000E+00, 0.000E+00, 5.326E-04, 1.433E-01, 2.300E+00, 7.845E-01, 2.955E-01, 4.658E-01, 1.132E-01},
    {1066, 1.4334, 0.000E+00, 0.000E+00, 5.034E-04, 1.426E-01, 2.300E+00, 7.812E-01, 2.938E-01, 4.661E-01, 1.132E-01},
    {1067, 1.4333, 0.000E+00, 0.000E+00, 4.750E-04, 1.418E-01, 2.300E+00, 7.779E-01, 2.921E-01, 4.664E-01, 1.132E-01},
    {1068, 1.4333, 0.000E+00, 0.000E+00, 4.473E-04, 1.412E-01, 2.300E+00, 7.746E-01, 2.904E-01, 4.667E-01, 1.132E-01},
    {1069, 1.4332, 0.000E+00, 0.000E+00, 4.205E-04, 1.410E-01, 2.300E+00, 7.713E-01, 2.887E-01, 4.670E-01, 1.132E-01},
    {1070, 1.4330, 0.000E+00, 0.000E+00, 3.944E-04, 1.409E-01, 2.300E+00, 7.680E-01, 2.870E-01, 4.673E-01, 1.132E-01},
    {1071, 1.4329, 0.000E+00, 0.000E+00, 3.691E-04, 1.408E-01, 2.300E+00, 7.647E-01, 2.853E-01, 4.673E-01, 1.135E-01},
    {1072, 1.4328, 0.000E+00, 0.000E+00, 3.446E-04, 1.406E-01, 2.300E+00, 7.614E-01, 2.836E-01, 4.674E-01, 1.138E-01},
    {1073, 1.4327, 0.000E+00, 0.000E+00, 3.210E-04, 1.405E-01, 2.300E+00, 7.581E-01, 2.819E-01, 4.675E-01, 1.141E-01},
    {1074, 1.4325, 0.000E+00, 0.000E+00, 2.981E-04, 1.408E-01, 2.300E+00, 7.548E-01, 2.802E-01, 4.676E-01, 1.144E-01},
    {1075, 1.4324, 0.000E+00, 0.000E+00, 2.760E-04, 1.414E-01, 2.300E+00, 7.515E-01, 2.785E-01, 4.677E-01, 1.146E-01},
    {1076, 1.4322, 0.000E+00, 0.000E+00, 2.548E-04, 1.426E-01, 2.300E+00, 7.482E-01, 2.768E-01, 4.677E-01, 1.148E-01},
    {1077, 1.4321, 0.000E+00, 0.000E+00, 2.344E-04, 1.435E-01, 2.300E+00, 7.449E-01, 2.751E-01, 4.678E-01, 1.150E-01},
    {1078, 1.4319, 0.000E+00, 0.000E+00, 2.148E-04, 1.438E-01, 2.300E+00, 7.416E-01, 2.734E-01, 4.679E-01, 1.152E-01},
    {1079, 1.4318, 0.000E+00, 0.000E+00, 1.960E-04, 1.439E-01, 2.300E+00, 7.383E-01, 2.717E-01, 4.680E-01, 1.154E-01},
    {1080, 1.4317, 0.000E+00, 0.000E+00, 1.780E-04, 1.443E-01, 2.300E+00, 7.350E-01, 2.700E-01, 4.681E-01, 1.156E-01},
    {1081, 1.4316, 0.000E+00, 0.000E+00, 1.609E-04, 1.456E-01, 2.300E+00, 7.326E-01, 2.687E-01, 4.682E-01, 1.158E-01},
    {1082, 1.4315, 0.000E+00, 0.000E+00, 1.446E-04, 1.475E-01, 2.300E+00, 7.302E-01, 2.674E-01, 4.684E-01, 1.160E-01},
    {1083, 1.4314, 0.000E+00, 0.000E+00, 1.292E-04, 1.498E-01, 2.300E+00, 7.278E-01, 2.661E-01, 4.685E-01, 1.162E-01},
    {1084, 1.4314, 0.000E+00, 0.000E+00, 1.146E-04, 1.519E-01, 2.300E+00, 7.254E-01, 2.648E-01, 4.687E-01, 1.163E-01},
    {1085, 1.4313, 0.000E+00, 0.000E+00, 1.009E-04, 1.534E-01, 2.300E+00, 7.230E-01, 2.635E-01, 4.688E-01, 1.165E-01},
    {1086, 1.4312, 0.000E+00, 0.000E+00, 8.804E-05, 1.547E-01, 2.300E+00, 7.206E-01, 2.622E-01, 4.690E-01, 1.168E-01},
    {1087, 1.4310, 0.000E+00, 0.000E+00, 7.603E-05, 1.561E-01, 2.300E+00, 7.182E-01, 2.609E-01, 4.692E-01, 1.171E-01},
    {1088, 1.4309, 0.000E+00, 0.000E+00, 6.488E-05, 1.580E-01, 2.300E+00, 7.158E-01, 2.596E-01, 4.694E-01, 1.174E-01},
    {1089, 1.4307, 0.000E+00, 0.000E+00, 5.460E-05, 1.604E-01, 2.300E+00, 7.134E-01, 2.583E-01, 4.696E-01, 1.176E-01},
    {1090, 1.4305, 0.000E+00, 0.000E+00, 4.519E-05, 1.632E-01, 2.300E+00, 7.110E-01, 2.570E-01, 4.698E-01, 1.179E-01},
    {1091, 1.4304, 0.000E+00, 0.000E+00, 3.666E-05, 1.659E-01, 2.300E+00, 7.086E-01, 2.557E-01, 4.701E-01, 1.182E-01},
    {1092, 1.4303, 0.000E+00, 0.000E+00, 2.901E-05, 1.677E-01, 2.300E+00, 7.062E-01, 2.544E-01, 4.704E-01, 1.184E-01},
    {1093, 1.4302, 0.000E+00, 0.000E+00, 2.225E-05, 1.693E-01, 2.300E+00, 7.038E-01, 2.531E-01, 4.708E-01, 1.186E-01},
    {1094, 1.4302, 0.000E+00, 0.000E+00, 1.637E-05, 1.712E-01, 2.300E+00, 7.014E-01, 2.518E-01, 4.711E-01, 1.188E-01},
    {1095, 1.4301, 0.000E+00, 0.000E+00, 1.138E-05, 1.739E-01, 2.300E+00, 6.990E-01, 2.505E-01, 4.714E-01, 1.191E-01},
    {1096, 1.4300, 0.000E+00, 0.000E+00, 7.297E-06, 1.777E-01, 2.300E+00, 6.966E-01, 2.492E-01, 4.715E-01, 1.191E-01},
    {1097, 1.4297, 0.000E+00, 0.000E+00, 4.111E-06, 1.824E-01, 2.300E+00, 6.942E-01, 2.479E-01, 4.716E-01, 1.192E-01},
    {1098, 1.4295, 0.000E+00, 0.000E+00, 1.830E-06, 1.866E-01, 2.300E+00, 6.918E-01, 2.466E-01, 4.716E-01, 1.193E-01},
    {1099, 1.4294, 0.000E+00, 0.000E+00, 4.581E-07, 1.890E-01, 2.300E+00, 6.894E-01, 2.453E-01, 4.717E-01, 1.194E-01},
    {1100, 1.4293, 0.000E+00, 0.000E+00, 0.000E+00, 1.906E-01, 2.300E+00, 6.870E-01, 2.440E-01, 4.718E-01, 1.195E-01},
    {1101, 1.4292, 0.000E+00, 0.000E+00, 0.000E+00, 1.929E-01, 2.300E+00, 6.634E-01, 2.356E-01, 4.717E-01, 1.196E-01},
    {1102, 1.4291, 0.000E+00, 0.000E+00, 0.000E+00, 1.967E-01, 2.300E+00, 6.397E-01, 2.271E-01, 4.717E-01, 1.197E-01},
    {1103, 1.4290, 0.000E+00, 0.000E+00, 0.000E+00, 2.005E-01, 2.300E+00, 6.161E-01, 2.187E-01, 4.716E-01, 1.199E-01},
    {1104, 1.4289, 0.000E+00, 0.000E+00, 0.000E+00, 2.031E-01, 2.300E+00, 5.924E-01, 2.102E-01, 4.716E-01, 1.200E-01},
    {1105, 1.4288, 0.000E+00, 0.000E+00, 0.000E+00, 2.051E-01, 2.300E+00, 5.688E-01, 2.018E-01, 4.715E-01, 1.202E-01},
    {1106, 1.4286, 0.000E+00, 0.000E+00, 0.000E+00, 2.079E-01, 2.300E+00, 5.451E-01, 1.933E-01, 4.718E-01, 1.204E-01},
    {1107, 1.4284, 0.000E+00, 0.000E+00, 0.000E+00, 2.123E-01, 2.300E+00, 5.215E-01, 1.849E-01, 4.720E-01, 1.206E-01},
    {1108, 1.4283, 0.000E+00, 0.000E+00, 0.000E+00, 2.166E-01, 2.300E+00, 4.978E-01, 1.764E-01, 4.723E-01, 1.209E-01},
    {1109, 1.4283, 0.000E+00, 0.000E+00, 0.000E+00, 2.196E-01, 2.300E+00, 4.742E-01, 1.680E-01, 4.725E-01, 1.211E-01},
    {1110, 1.4284, 0.000E+00, 0.000E+00, 0.000E+00, 2.219E-01, 2.300E+00, 4.505E-01, 1.595E-01, 4.728E-01, 1.213E-01},
    {1111, 1.4284, 0.000E+00, 0.000E+00, 0.000E+00, 2.251E-01, 2.300E+00, 4.269E-01, 1.511E-01, 4.731E-01, 1.215E-01},
    {1112, 1.4284, 0.000E+00, 0.000E+00, 0.000E+00, 2.298E-01, 2.300E+00, 4.032E-01, 1.426E-01, 4.733E-01, 1.217E-01},
    {1113, 1.4284, 0.000E+00, 0.000E+00, 0.000E+00, 2.337E-01, 2.300E+00, 3.796E-01, 1.342E-01, 4.736E-01, 1.218E-01},
    {1114, 1.4283, 0.000E+00, 0.000E+00, 0.000E+00, 2.346E-01, 2.300E+00, 3.559E-01, 1.257E-01, 4.739E-01, 1.220E-01},
    {1115, 1.4282, 0.000E+00, 0.000E+00, 0.000E+00, 2.342E-01, 2.300E+00, 3.323E-01, 1.173E-01, 4.742E-01, 1.221E-01},
    {1116, 1.4282, 0.000E+00, 0.000E+00, 0.000E+00, 2.353E-01, 2.300E+00, 3.086E-01, 1.088E-01, 4.743E-01, 1.223E-01},
    {1117, 1.4280, 0.000E+00, 0.000E+00, 0.000E+00, 2.397E-01, 2.300E+00, 2.850E-01, 1.004E-01, 4.745E-01, 1.225E-01},
    {1118, 1.4278, 0.000E+00, 0.000E+00, 0.000E+00, 2.450E-01, 2.300E+00, 2.613E-01, 9.190E-02, 4.746E-01, 1.226E-01},
    {1119, 1.4276, 0.000E+00, 0.000E+00, 0.000E+00, 2.491E-01, 2.300E+00, 2.377E-01, 8.345E-02, 4.748E-01, 1.228E-01},
    {1120, 1.4275, 0.000E+00, 0.000E+00, 0.000E+00, 2.528E-01, 2.300E+00, 2.140E-01, 7.500E-02, 4.749E-01, 1.229E-01},
    {1121, 1.4274, 0.000E+00, 0.000E+00, 0.000E+00, 2.578E-01, 2.300E+00, 2.231E-01, 7.790E-02, 4.749E-01, 1.231E-01},
    {1122, 1.4272, 0.000E+00, 0.000E+00, 0.000E+00, 2.650E-01, 2.300E+00, 2.321E-01, 8.080E-02, 4.749E-01, 1.233E-01},
    {1123, 1.4270, 0.000E+00, 0.000E+00, 0.000E+00, 2.719E-01, 2.300E+00, 2.412E-01, 8.370E-02, 4.749E-01, 1.234E-01},
    {1124, 1.4268, 0.000E+00, 0.000E+00, 0.000E+00, 2.765E-01, 2.300E+00, 2.502E-01, 8.660E-02, 4.749E-01, 1.236E-01},
    {1125, 1.4267, 0.000E+00, 0.000E+00, 0.000E+00, 2.811E-01, 2.300E+00, 2.593E-01, 8.950E-02, 4.749E-01, 1.238E-01},
    {1126, 1.4267, 0.000E+00, 0.000E+00, 0.000E+00, 2.891E-01, 2.300E+00, 2.683E-01, 9.240E-02, 4.749E-01, 1.240E-01},
    {1127, 1.4266, 0.000E+00, 0.000E+00, 0.000E+00, 3.023E-01, 2.300E+00, 2.774E-01, 9.530E-02, 4.749E-01, 1.241E-01},
    {1128, 1.4265, 0.000E+00, 0.000E+00, 0.000E+00, 3.164E-01, 2.300E+00, 2.864E-01, 9.820E-02, 4.749E-01, 1.243E-01},
    {1129, 1.4264, 0.000E+00, 0.000E+00, 0.000E+00, 3.271E-01, 2.300E+00, 2.955E-01, 1.011E-01, 4.749E-01, 1.245E-01},
    {1130, 1.4263, 0.000E+00, 0.000E+00, 0.000E+00, 3.378E-01, 2.300E+00, 3.045E-01, 1.040E-01, 4.749E-01, 1.246E-01},
    {1131, 1.4262, 0.000E+00, 0.000E+00, 0.000E+00, 3.533E-01, 2.300E+00, 3.136E-01, 1.069E-01, 4.751E-01, 1.248E-01},
    {1132, 1.4260, 0.000E+00, 0.000E+00, 0.000E+00, 3.770E-01, 2.300E+00, 3.226E-01, 1.098E-01, 4.753E-01, 1.250E-01},
    {1133, 1.4259, 0.000E+00, 0.000E+00, 0.000E+00, 4.037E-01, 2.300E+00, 3.317E-01, 1.127E-01, 4.755E-01, 1.252E-01},
    {1134, 1.4258, 0.000E+00, 0.000E+00, 0.000E+00, 4.281E-01, 2.300E+00, 3.407E-01, 1.156E-01, 4.757E-01, 1.253E-01},
    {1135, 1.4257, 0.000E+00, 0.000E+00, 0.000E+00, 4.502E-01, 2.300E+00, 3.498E-01, 1.185E-01, 4.759E-01, 1.255E-01},
    {1136, 1.4256, 0.000E+00, 0.000E+00, 0.000E+00, 4.712E-01, 2.300E+00, 3.588E-01, 1.214E-01, 4.761E-01, 1.257E-01},
    {1137, 1.4256, 0.000E+00, 0.000E+00, 0.000E+00, 4.932E-01, 2.300E+00, 3.679E-01, 1.243E-01, 4.764E-01, 1.259E-01},
    {1138, 1.4255, 0.000E+00, 0.000E+00, 0.000E+00, 5.202E-01, 2.300E+00, 3.769E-01, 1.272E-01, 4.766E-01, 1.261E-01},
    {1139, 1.4254, 0.000E+00, 0.000E+00, 0.000E+00, 5.572E-01, 2.300E+00, 3.860E-01, 1.301E-01, 4.768E-01, 1.263E-01},
    {1140, 1.4252, 0.000E+00, 0.000E+00, 0.000E+00, 6.052E-01, 2.300E+00, 3.950E-01, 1.330E-01, 4.770E-01, 1.265E-01},
    {1141, 1.4250, 0.000E+00, 0.000E+00, 0.000E+00, 6.520E-01, 2.300E+00, 3.950E-01, 1.328E-01, 4.773E-01, 1.267E-01},
    {1142, 1.4249, 0.000E+00, 0.000E+00, 0.000E+00, 6.863E-01, 2.300E+00, 3.949E-01, 1.326E-01, 4.775E-01, 1.268E-01},
    {1143, 1.4248, 0.000E+00, 0.000E+00, 0.000E+00, 7.159E-01, 2.300E+00, 3.949E-01, 1.324E-01, 4.777E-01, 1.269E-01},
    {1144, 1.4247, 0.000E+00, 0.000E+00, 0.000E+00, 7.535E-01, 2.300E+00, 3.948E-01, 1.322E-01, 4.779E-01, 1.271E-01},
    {1145, 1.4244, 0.000E+00, 0.000E+00, 0.000E+00, 8.064E-01, 2.300E+00, 3.948E-01, 1.320E-01, 4.782E-01, 1.272E-01},
    {1146, 1.4241, 0.000E+00, 0.000E+00, 0.000E+00, 8.597E-01, 2.300E+00, 3.947E-01, 1.318E-01, 4.784E-01, 1.274E-01},
    {1147, 1.4239, 0.000E+00, 0.000E+00, 0.000E+00, 8.981E-01, 2.300E+00, 3.947E-01, 1.316E-01, 4.786E-01, 1.275E-01},
    {1148, 1.4237, 0.000E+00, 0.000E+00, 0.000E+00, 9.253E-01, 2.300E+00, 3.946E-01, 1.314E-01, 4.788E-01, 1.277E-01},
    {1149, 1.4235, 0.000E+00, 0.000E+00, 0.000E+00, 9.493E-01, 2.300E+00, 3.946E-01, 1.312E-01, 4.791E-01, 1.278E-01},
    {1150, 1.4234, 0.000E+00, 0.000E+00, 0.000E+00, 9.769E-01, 2.300E+00, 3.945E-01, 1.310E-01, 4.793E-01, 1.279E-01},
    {1151, 1.4233, 0.000E+00, 0.000E+00, 0.000E+00, 1.008E+00, 2.300E+00, 3.945E-01, 1.308E-01, 4.793E-01, 1.281E-01},
    {1152, 1.4231, 0.000E+00, 0.000E+00, 0.000E+00, 1.041E+00, 2.300E+00, 3.944E-01, 1.306E-01, 4.794E-01, 1.282E-01},
    {1153, 1.4230, 0.000E+00, 0.000E+00, 0.000E+00, 1.073E+00, 2.300E+00, 3.944E-01, 1.304E-01, 4.794E-01, 1.284E-01},
    {1154, 1.4228, 0.000E+00, 0.000E+00, 0.000E+00, 1.100E+00, 2.300E+00, 3.943E-01, 1.302E-01, 4.795E-01, 1.285E-01},
    {1155, 1.4226, 0.000E+00, 0.000E+00, 0.000E+00, 1.119E+00, 2.300E+00, 3.943E-01, 1.300E-01, 4.796E-01, 1.287E-01},
    {1156, 1.4224, 0.000E+00, 0.000E+00, 0.000E+00, 1.131E+00, 2.300E+00, 3.942E-01, 1.298E-01, 4.795E-01, 1.288E-01},
    {1157, 1.4224, 0.000E+00, 0.000E+00, 0.000E+00, 1.140E+00, 2.300E+00, 3.942E-01, 1.296E-01, 4.795E-01, 1.290E-01},
    {1158, 1.4223, 0.000E+00, 0.000E+00, 0.000E+00, 1.150E+00, 2.300E+00, 3.941E-01, 1.294E-01, 4.795E-01, 1.291E-01},
    {1159, 1.4223, 0.000E+00, 0.000E+00, 0.000E+00, 1.160E+00, 2.300E+00, 3.941E-01, 1.292E-01, 4.795E-01, 1.293E-01},
    {1160, 1.4222, 0.000E+00, 0.000E+00, 0.000E+00, 1.170E+00, 2.300E+00, 3.940E-01, 1.290E-01, 4.795E-01, 1.294E-01},
    {1161, 1.4222, 0.000E+00, 0.000E+00, 0.000E+00, 1.181E+00, 2.300E+00, 4.020E-01, 1.314E-01, 4.799E-01, 1.296E-01},
    {1162, 1.4221, 0.000E+00, 0.000E+00, 0.000E+00, 1.190E+00, 2.300E+00, 4.099E-01, 1.337E-01, 4.802E-01, 1.297E-01},
    {1163, 1.4221, 0.000E+00, 0.000E+00, 0.000E+00, 1.194E+00, 2.300E+00, 4.179E-01, 1.361E-01, 4.805E-01, 1.299E-01},
    {1164, 1.4221, 0.000E+00, 0.000E+00, 0.000E+00, 1.196E+00, 2.300E+00, 4.258E-01, 1.384E-01, 4.808E-01, 1.300E-01},
    {1165, 1.4219, 0.000E+00, 0.000E+00, 0.000E+00, 1.197E+00, 2.300E+00, 4.338E-01, 1.408E-01, 4.811E-01, 1.302E-01},
    {1166, 1.4217, 0.000E+00, 0.000E+00, 0.000E+00, 1.200E+00, 2.300E+00, 4.417E-01, 1.431E-01, 4.811E-01, 1.303E-01},
    {1167, 1.4216, 0.000E+00, 0.000E+00, 0.000E+00, 1.203E+00, 2.300E+00, 4.497E-01, 1.455E-01, 4.811E-01, 1.304E-01},
    {1168, 1.4215, 0.000E+00, 0.000E+00, 0.000E+00, 1.205E+00, 2.300E+00, 4.576E-01, 1.478E-01, 4.811E-01, 1.306E-01},
    {1169, 1.4215, 0.000E+00, 0.000E+00, 0.000E+00, 1.206E+00, 2.300E+00, 4.656E-01, 1.502E-01, 4.811E-01, 1.307E-01},
    {1170, 1.4214, 0.000E+00, 0.000E+00, 0.000E+00, 1.207E+00, 2.300E+00, 4.735E-01, 1.525E-01, 4.811E-01, 1.309E-01},
    {1171, 1.4212, 0.000E+00, 0.000E+00, 0.000E+00, 1.213E+00, 2.300E+00, 4.815E-01, 1.549E-01, 4.813E-01, 1.310E-01},
    {1172, 1.4210, 0.000E+00, 0.000E+00, 0.000E+00, 1.223E+00, 2.300E+00, 4.894E-01, 1.572E-01, 4.815E-01, 1.312E-01},
    {1173, 1.4208, 0.000E+00, 0.000E+00, 0.000E+00, 1.232E+00, 2.300E+00, 4.974E-01, 1.596E-01, 4.816E-01, 1.314E-01},
    {1174, 1.4207, 0.000E+00, 0.000E+00, 0.000E+00, 1.234E+00, 2.300E+00, 5.053E-01, 1.619E-01, 4.818E-01, 1.316E-01},
    {1175, 1.4206, 0.000E+00, 0.000E+00, 0.000E+00, 1.232E+00, 2.300E+00, 5.133E-01, 1.643E-01, 4.820E-01, 1.318E-01},
    {1176, 1.4206, 0.000E+00, 0.000E+00, 0.000E+00, 1.229E+00, 2.300E+00, 5.212E-01, 1.666E-01, 4.825E-01, 1.320E-01},
    {1177, 1.4206, 0.000E+00, 0.000E+00, 0.000E+00, 1.230E+00, 2.300E+00, 5.292E-01, 1.690E-01, 4.829E-01, 1.322E-01},
    {1178, 1.4206, 0.000E+00, 0.000E+00, 0.000E+00, 1.233E+00, 2.300E+00, 5.371E-01, 1.713E-01, 4.833E-01, 1.323E-01},
    {1179, 1.4206, 0.000E+00, 0.000E+00, 0.000E+00, 1.236E+00, 2.300E+00, 5.451E-01, 1.737E-01, 4.838E-01, 1.325E-01},
    {1180, 1.4205, 0.000E+00, 0.000E+00, 0.000E+00, 1.239E+00, 2.300E+00, 5.530E-01, 1.760E-01, 4.842E-01, 1.327E-01},
    {1181, 1.4203, 0.000E+00, 0.000E+00, 0.000E+00, 1.241E+00, 2.300E+00, 5.526E-01, 1.757E-01, 4.845E-01, 1.329E-01},
    {1182, 1.4200, 0.000E+00, 0.000E+00, 0.000E+00, 1.244E+00, 2.300E+00, 5.522E-01, 1.754E-01, 4.847E-01, 1.331E-01},
    {1183, 1.4199, 0.000E+00, 0.000E+00, 0.000E+00, 1.248E+00, 2.300E+00, 5.518E-01, 1.751E-01, 4.850E-01, 1.334E-01},
    {1184, 1.4198, 0.000E+00, 0.000E+00, 0.000E+00, 1.252E+00, 2.300E+00, 5.514E-01, 1.748E-01, 4.852E-01, 1.336E-01},
    {1185, 1.4199, 0.000E+00, 0.000E+00, 0.000E+00, 1.256E+00, 2.300E+00, 5.510E-01, 1.745E-01, 4.855E-01, 1.338E-01},
    {1186, 1.4201, 0.000E+00, 0.000E+00, 0.000E+00, 1.258E+00, 2.300E+00, 5.506E-01, 1.742E-01, 4.857E-01, 1.340E-01},
    {1187, 1.4204, 0.000E+00, 0.000E+00, 0.000E+00, 1.260E+00, 2.300E+00, 5.502E-01, 1.739E-01, 4.858E-01, 1.343E-01},
    {1188, 1.4205, 0.000E+00, 0.000E+00, 0.000E+00, 1.262E+00, 2.300E+00, 5.498E-01, 1.736E-01, 4.860E-01, 1.346E-01},
    {1189, 1.4205, 0.000E+00, 0.000E+00, 0.000E+00, 1.265E+00, 2.300E+00, 5.494E-01, 1.733E-01, 4.862E-01, 1.348E-01},
    {1190, 1.4203, 0.000E+00, 0.000E+00, 0.000E+00, 1.267E+00, 2.300E+00, 5.490E-01, 1.730E-01, 4.864E-01, 1.351E-01},
    {1191, 1.4200, 0.000E+00, 0.000E+00, 0.000E+00, 1.270E+00, 2.300E+00, 5.486E-01, 1.727E-01, 4.863E-01, 1.352E-01},
    {1192, 1.4196, 0.000E+00, 0.000E+00, 0.000E+00, 1.272E+00, 2.300E+00, 5.482E-01, 1.724E-01, 4.863E-01, 1.353E-01},
    {1193, 1.4192, 0.000E+00, 0.000E+00, 0.000E+00, 1.275E+00, 2.300E+00, 5.478E-01, 1.721E-01, 4.863E-01, 1.353E-01},
    {1194, 1.4189, 0.000E+00, 0.000E+00, 0.000E+00, 1.277E+00, 2.300E+00, 5.474E-01, 1.718E-01, 4.863E-01, 1.354E-01},
    {1195, 1.4187, 0.000E+00, 0.000E+00, 0.000E+00, 1.280E+00, 2.300E+00, 5.470E-01, 1.715E-01, 4.863E-01, 1.355E-01},
    {1196, 1.4187, 0.000E+00, 0.000E+00, 0.000E+00, 1.282E+00, 2.300E+00, 5.466E-01, 1.712E-01, 4.863E-01, 1.358E-01},
    {1197, 1.4188, 0.000E+00, 0.000E+00, 0.000E+00, 1.283E+00, 2.300E+00, 5.462E-01, 1.709E-01, 4.864E-01, 1.361E-01},
    {1198, 1.4188, 0.000E+00, 0.000E+00, 0.000E+00, 1.283E+00, 2.300E+00, 5.458E-01, 1.706E-01, 4.864E-01, 1.364E-01},
    {1199, 1.4187, 0.000E+00, 0.000E+00, 0.000E+00, 1.279E+00, 2.300E+00, 5.454E-01, 1.703E-01, 4.864E-01, 1.367E-01},
    {1200, 1.4186, 0.000E+00, 0.000E+00, 0.000E+00, 1.272E+00, 2.300E+00, 5.450E-01, 1.700E-01, 4.864E-01, 1.369E-01},
    {1201, 1.4185, 0.000E+00, 0.000E+00, 0.000E+00, 1.266E+00, 2.300E+00, 5.477E-01, 1.707E-01, 4.866E-01, 1.371E-01},
    {1202, 1.4182, 0.000E+00, 0.000E+00, 0.000E+00, 1.267E+00, 2.301E+00, 5.504E-01, 1.713E-01, 4.868E-01, 1.373E-01},
    {1203, 1.4181, 0.000E+00, 0.000E+00, 0.000E+00, 1.271E+00, 2.301E+00, 5.531E-01, 1.720E-01, 4.870E-01, 1.374E-01},
    {1204, 1.4179, 0.000E+00, 0.000E+00, 0.000E+00, 1.273E+00, 2.302E+00, 5.558E-01, 1.726E-01, 4.872E-01, 1.376E-01},
    {1205, 1.4178, 0.000E+00, 0.000E+00, 0.000E+00, 1.271E+00, 2.303E+00, 5.585E-01, 1.733E-01, 4.874E-01, 1.377E-01},
    {1206, 1.4177, 0.000E+00, 0.000E+00, 0.000E+00, 1.265E+00, 2.305E+00, 5.612E-01, 1.739E-01, 4.875E-01, 1.383E-01},
    {1207, 1.4177, 0.000E+00, 0.000E+00, 0.000E+00, 1.260E+00, 2.306E+00, 5.639E-01, 1.746E-01, 4.875E-01, 1.388E-01},
    {1208, 1.4176, 0.000E+00, 0.000E+00, 0.000E+00, 1.258E+00, 2.308E+00, 5.666E-01, 1.752E-01, 4.876E-01, 1.394E-01},
    {1209, 1.4175, 0.000E+00, 0.000E+00, 0.000E+00, 1.258E+00, 2.310E+00, 5.693E-01, 1.759E-01, 4.877E-01, 1.399E-01},
    {1210, 1.4173, 0.000E+00, 0.000E+00, 0.000E+00, 1.257E+00, 2.312E+00, 5.720E-01, 1.765E-01, 4.877E-01, 1.405E-01},
    {1211, 1.4173, 0.000E+00, 0.000E+00, 0.000E+00, 1.252E+00, 2.315E+00, 5.747E-01, 1.772E-01, 4.878E-01, 1.407E-01},
    {1212, 1.4172, 0.000E+00, 0.000E+00, 0.000E+00, 1.247E+00, 2.317E+00, 5.774E-01, 1.778E-01, 4.878E-01, 1.409E-01},
    {1213, 1.4171, 0.000E+00, 0.000E+00, 0.000E+00, 1.243E+00, 2.320E+00, 5.801E-01, 1.785E-01, 4.878E-01, 1.411E-01},
    {1214, 1.4170, 0.000E+00, 0.000E+00, 0.000E+00, 1.243E+00, 2.323E+00, 5.828E-01, 1.791E-01, 4.878E-01, 1.412E-01},
    {1215, 1.4168, 0.000E+00, 0.000E+00, 0.000E+00, 1.243E+00, 2.327E+00, 5.855E-01, 1.798E-01, 4.879E-01, 1.414E-01},
    {1216, 1.4167, 0.000E+00, 0.000E+00, 0.000E+00, 1.240E+00, 2.330E+00, 5.882E-01, 1.804E-01, 4.881E-01, 1.415E-01},
    {1217, 1.4165, 0.000E+00, 0.000E+00, 0.000E+00, 1.233E+00, 2.334E+00, 5.909E-01, 1.811E-01, 4.884E-01, 1.415E-01},
    {1218, 1.4164, 0.000E+00, 0.000E+00, 0.000E+00, 1.224E+00, 2.338E+00, 5.936E-01, 1.817E-01, 4.887E-01, 1.415E-01},
    {1219, 1.4163, 0.000E+00, 0.000E+00, 0.000E+00, 1.216E+00, 2.342E+00, 5.963E-01, 1.824E-01, 4.889E-01, 1.416E-01},
    {1220, 1.4161, 0.000E+00, 0.000E+00, 0.000E+00, 1.214E+00, 2.346E+00, 5.990E-01, 1.830E-01, 4.892E-01, 1.416E-01},
    {1221, 1.4158, 0.000E+00, 0.000E+00, 0.000E+00, 1.214E+00, 2.350E+00, 5.984E-01, 1.826E-01, 4.893E-01, 1.420E-01},
    {1222, 1.4156, 0.000E+00, 0.000E+00, 0.000E+00, 1.213E+00, 2.354E+00, 5.978E-01, 1.822E-01, 4.893E-01, 1.423E-01},
    {1223, 1.4155, 0.000E+00, 0.000E+00, 0.000E+00, 1.210E+00, 2.359E+00, 5.972E-01, 1.818E-01, 4.894E-01, 1.427E-01},
    {1224, 1.4154, 0.000E+00, 0.000E+00, 0.000E+00, 1.205E+00, 2.364E+00, 5.966E-01, 1.814E-01, 4.895E-01, 1.431E-01},
    {1225, 1.4153, 0.000E+00, 0.000E+00, 0.000E+00, 1.200E+00, 2.369E+00, 5.960E-01, 1.810E-01, 4.896E-01, 1.434E-01},
    {1226, 1.4151, 0.000E+00, 0.000E+00, 0.000E+00, 1.199E+00, 2.374E+00, 5.954E-01, 1.806E-01, 4.897E-01, 1.438E-01},
    {1227, 1.4151, 0.000E+00, 0.000E+00, 0.000E+00, 1.198E+00, 2.379E+00, 5.948E-01, 1.802E-01, 4.897E-01, 1.442E-01},
    {1228, 1.4151, 0.000E+00, 0.000E+00, 0.000E+00, 1.197E+00, 2.384E+00, 5.942E-01, 1.798E-01, 4.898E-01, 1.445E-01},
    {1229, 1.4150, 0.000E+00, 0.000E+00, 0.000E+00, 1.194E+00, 2.389E+00, 5.936E-01, 1.794E-01, 4.899E-01, 1.449E-01},
    {1230, 1.4148, 0.000E+00, 0.000E+00, 0.000E+00, 1.189E+00, 2.395E+00, 5.930E-01, 1.790E-01, 4.900E-01, 1.453E-01},
    {1231, 1.4147, 0.000E+00, 0.000E+00, 0.000E+00, 1.184E+00, 2.400E+00, 5.924E-01, 1.786E-01, 4.901E-01, 1.453E-01},
    {1232, 1.4146, 0.000E+00, 0.000E+00, 0.000E+00, 1.180E+00, 2.406E+00, 5.918E-01, 1.782E-01, 4.902E-01, 1.452E-01},
    {1233, 1.4145, 0.000E+00, 0.000E+00, 0.000E+00, 1.176E+00, 2.412E+00, 5.912E-01, 1.778E-01, 4.903E-01, 1.452E-01},
    {1234, 1.4144, 0.000E+00, 0.000E+00, 0.000E+00, 1.171E+00, 2.418E+00, 5.906E-01, 1.774E-01, 4.904E-01, 1.452E-01},
    {1235, 1.4143, 0.000E+00, 0.000E+00, 0.000E+00, 1.166E+00, 2.423E+00, 5.900E-01, 1.770E-01, 4.905E-01, 1.452E-01},
    {1236, 1.4141, 0.000E+00, 0.000E+00, 0.000E+00, 1.161E+00, 2.430E+00, 5.894E-01, 1.766E-01, 4.907E-01, 1.453E-01},
    {1237, 1.4139, 0.000E+00, 0.000E+00, 0.000E+00, 1.158E+00, 2.436E+00, 5.888E-01, 1.762E-01, 4.909E-01, 1.454E-01},
    {1238, 1.4136, 0.000E+00, 0.000E+00, 0.000E+00, 1.157E+00, 2.442E+00, 5.882E-01, 1.758E-01, 4.912E-01, 1.455E-01},
    {1239, 1.4134, 0.000E+00, 0.000E+00, 0.000E+00, 1.157E+00, 2.448E+00, 5.876E-01, 1.754E-01, 4.914E-01, 1.455E-01},
    {1240, 1.4133, 0.000E+00, 0.000E+00, 0.000E+00, 1.155E+00, 2.454E+00, 5.870E-01, 1.750E-01, 4.916E-01, 1.456E-01},
    {1241, 1.4130, 0.000E+00, 0.000E+00, 0.000E+00, 1.152E+00, 2.461E+00, 5.848E-01, 1.742E-01, 4.919E-01, 1.456E-01},
    {1242, 1.4128, 0.000E+00, 0.000E+00, 0.000E+00, 1.148E+00, 2.467E+00, 5.825E-01, 1.734E-01, 4.921E-01, 1.456E-01},
    {1243, 1.4128, 0.000E+00, 0.000E+00, 0.000E+00, 1.142E+00, 2.473E+00, 5.803E-01, 1.726E-01, 4.924E-01, 1.456E-01},
    {1244, 1.4128, 0.000E+00, 0.000E+00, 0.000E+00, 1.138E+00, 2.480E+00, 5.780E-01, 1.718E-01, 4.926E-01, 1.456E-01},
    {1245, 1.4127, 0.000E+00, 0.000E+00, 0.000E+00, 1.133E+00, 2.486E+00, 5.758E-01, 1.710E-01, 4.929E-01, 1.456E-01},
    {1246, 1.4126, 0.000E+00, 0.000E+00, 0.000E+00, 1.130E+00, 2.493E+00, 5.735E-01, 1.702E-01, 4.929E-01, 1.458E-01},
    {1247, 1.4124, 0.000E+00, 0.000E+00, 0.000E+00, 1.126E+00, 2.499E+00, 5.713E-01, 1.694E-01, 4.929E-01, 1.460E-01},
    {1248, 1.4122, 0.000E+00, 0.000E+00, 0.000E+00, 1.123E+00, 2.506E+00, 5.690E-01, 1.686E-01, 4.930E-01, 1.462E-01},
    {1249, 1.4122, 0.000E+00, 0.000E+00, 0.000E+00, 1.120E+00, 2.512E+00, 5.668E-01, 1.678E-01, 4.930E-01, 1.464E-01},
    {1250, 1.4121, 0.000E+00, 0.000E+00, 0.000E+00, 1.116E+00, 2.519E+00, 5.645E-01, 1.670E-01, 4.930E-01, 1.467E-01},
    {1251, 1.4121, 0.000E+00, 0.000E+00, 0.000E+00, 1.111E+00, 2.525E+00, 5.623E-01, 1.662E-01, 4.929E-01, 1.469E-01},
    {1252, 1.4121, 0.000E+00, 0.000E+00, 0.000E+00, 1.107E+00, 2.532E+00, 5.600E-01, 1.654E-01, 4.928E-01, 1.471E-01},
    {1253, 1.4119, 0.000E+00, 0.000E+00, 0.000E+00, 1.103E+00, 2.538E+00, 5.578E-01, 1.646E-01, 4.927E-01, 1.474E-01},
    {1254, 1.4118, 0.000E+00, 0.000E+00, 0.000E+00, 1.101E+00, 2.545E+00, 5.555E-01, 1.638E-01, 4.926E-01, 1.476E-01},
    {1255, 1.4116, 0.000E+00, 0.000E+00, 0.000E+00, 1.101E+00, 2.551E+00, 5.533E-01, 1.630E-01, 4.924E-01, 1.478E-01},
    {1256, 1.4115, 0.000E+00, 0.000E+00, 0.000E+00, 1.101E+00, 2.558E+00, 5.510E-01, 1.622E-01, 4.926E-01, 1.479E-01},
    {1257, 1.4113, 0.000E+00, 0.000E+00, 0.000E+00, 1.101E+00, 2.564E+00, 5.488E-01, 1.614E-01, 4.928E-01, 1.479E-01},
    {1258, 1.4112, 0.000E+00, 0.000E+00, 0.000E+00, 1.100E+00, 2.570E+00, 5.465E-01, 1.606E-01, 4.930E-01, 1.480E-01},
    {1259, 1.4112, 0.000E+00, 0.000E+00, 0.000E+00, 1.098E+00, 2.577E+00, 5.443E-01, 1.598E-01, 4.932E-01, 1.480E-01},
    {1260, 1.4111, 0.000E+00, 0.000E+00, 0.000E+00, 1.094E+00, 2.583E+00, 5.420E-01, 1.590E-01, 4.934E-01, 1.481E-01},
    {1261, 1.4111, 0.000E+00, 0.000E+00, 0.000E+00, 1.089E+00, 2.589E+00, 5.406E-01, 1.585E-01, 4.935E-01, 1.481E-01},
    {1262, 1.4110, 0.000E+00, 0.000E+00, 0.000E+00, 1.085E+00, 2.595E+00, 5.392E-01, 1.579E-01, 4.936E-01, 1.481E-01},
    {1263, 1.4108, 0.000E+00, 0.000E+00, 0.000E+00, 1.084E+00, 2.601E+00, 5.378E-01, 1.574E-01, 4.937E-01, 1.481E-01},
    {1264, 1.4106, 0.000E+00, 0.000E+00, 0.000E+00, 1.083E+00, 2.607E+00, 5.364E-01, 1.568E-01, 4.938E-01, 1.481E-01},
    {1265, 1.4104, 0.000E+00, 0.000E+00, 0.000E+00, 1.083E+00, 2.613E+00, 5.350E-01, 1.563E-01, 4.939E-01, 1.481E-01},
    {1266, 1.4102, 0.000E+00, 0.000E+00, 0.000E+00, 1.082E+00, 2.619E+00, 5.336E-01, 1.557E-01, 4.939E-01, 1.481E-01},
    {1267, 1.4102, 0.000E+00, 0.000E+00, 0.000E+00, 1.081E+00, 2.625E+00, 5.322E-01, 1.552E-01, 4.940E-01, 1.481E-01},
    {1268, 1.4102, 0.000E+00, 0.000E+00, 0.000E+00, 1.080E+00, 2.631E+00, 5.308E-01, 1.546E-01, 4.940E-01, 1.481E-01},
    {1269, 1.4103, 0.000E+00, 0.000E+00, 0.000E+00, 1.079E+00, 2.636E+00, 5.294E-01, 1.541E-01, 4.941E-01, 1.481E-01},
    {1270, 1.4103, 0.000E+00, 0.000E+00, 0.000E+00, 1.080E+00, 2.642E+00, 5.280E-01, 1.535E-01, 4.941E-01, 1.481E-01},
    {1271, 1.4101, 0.000E+00, 0.000E+00, 0.000E+00, 1.083E+00, 2.647E+00, 5.266E-01, 1.530E-01, 4.942E-01, 1.483E-01},
    {1272, 1.4099, 0.000E+00, 0.000E+00, 0.000E+00, 1.087E+00, 2.652E+00, 5.252E-01, 1.524E-01, 4.943E-01, 1.485E-01},
    {1273, 1.4097, 0.000E+00, 0.000E+00, 0.000E+00, 1.093E+00, 2.657E+00, 5.238E-01, 1.519E-01, 4.945E-01, 1.487E-01},
    {1274, 1.4095, 0.000E+00, 0.000E+00, 0.000E+00, 1.099E+00, 2.662E+00, 5.224E-01, 1.513E-01, 4.946E-01, 1.489E-01},
    {1275, 1.4093, 0.000E+00, 0.000E+00, 0.000E+00, 1.104E+00, 2.667E+00, 5.210E-01, 1.508E-01, 4.947E-01, 1.491E-01},
    {1276, 1.4091, 0.000E+00, 0.000E+00, 0.000E+00, 1.107E+00, 2.672E+00, 5.196E-01, 1.502E-01, 4.948E-01, 1.492E-01},
    {1277, 1.4091, 0.000E+00, 0.000E+00, 0.000E+00, 1.109E+00, 2.677E+00, 5.182E-01, 1.497E-01, 4.950E-01, 1.493E-01},
    {1278, 1.4091, 0.000E+00, 0.000E+00, 0.000E+00, 1.111E+00, 2.681E+00, 5.168E-01, 1.491E-01, 4.951E-01, 1.494E-01},
    {1279, 1.4090, 0.000E+00, 0.000E+00, 0.000E+00, 1.115E+00, 2.685E+00, 5.154E-01, 1.486E-01, 4.953E-01, 1.494E-01},
    {1280, 1.4089, 0.000E+00, 0.000E+00, 0.000E+00, 1.121E+00, 2.689E+00, 5.140E-01, 1.480E-01, 4.954E-01, 1.495E-01},
    {1281, 1.4088, 0.000E+00, 0.000E+00, 0.000E+00, 1.129E+00, 2.693E+00, 5.114E-01, 1.472E-01, 4.957E-01, 1.499E-01},
    {1282, 1.4085, 0.000E+00, 0.000E+00, 0.000E+00, 1.137E+00, 2.697E+00, 5.088E-01, 1.463E-01, 4.959E-01, 1.502E-01},
    {1283, 1.4083, 0.000E+00, 0.000E+00, 0.000E+00, 1.147E+00, 2.701E+00, 5.062E-01, 1.455E-01, 4.962E-01, 1.506E-01},
    {1284, 1.4081, 0.000E+00, 0.000E+00, 0.000E+00, 1.156E+00, 2.704E+00, 5.036E-01, 1.446E-01, 4.965E-01, 1.510E-01},
    {1285, 1.4080, 0.000E+00, 0.000E+00, 0.000E+00, 1.164E+00, 2.707E+00, 5.010E-01, 1.438E-01, 4.967E-01, 1.513E-01},
    {1286, 1.4079, 0.000E+00, 0.000E+00, 0.000E+00, 1.170E+00, 2.711E+00, 4.984E-01, 1.429E-01, 4.969E-01, 1.513E-01},
    {1287, 1.4078, 0.000E+00, 0.000E+00, 0.000E+00, 1.175E+00, 2.713E+00, 4.958E-01, 1.421E-01, 4.972E-01, 1.513E-01},
    {1288, 1.4077, 0.000E+00, 0.000E+00, 0.000E+00, 1.181E+00, 2.716E+00, 4.932E-01, 1.412E-01, 4.974E-01, 1.513E-01},
    {1289, 1.4078, 0.000E+00, 0.000E+00, 0.000E+00, 1.188E+00, 2.719E+00, 4.906E-01, 1.404E-01, 4.976E-01, 1.513E-01},
    {1290, 1.4078, 0.000E+00, 0.000E+00, 0.000E+00, 1.196E+00, 2.721E+00, 4.880E-01, 1.395E-01, 4.979E-01, 1.513E-01},
    {1291, 1.4078, 0.000E+00, 0.000E+00, 0.000E+00, 1.206E+00, 2.723E+00, 4.854E-01, 1.387E-01, 4.980E-01, 1.513E-01},
    {1292, 1.4077, 0.000E+00, 0.000E+00, 0.000E+00, 1.216E+00, 2.725E+00, 4.828E-01, 1.378E-01, 4.982E-01, 1.513E-01},
    {1293, 1.4076, 0.000E+00, 0.000E+00, 0.000E+00, 1.227E+00, 2.726E+00, 4.802E-01, 1.370E-01, 4.984E-01, 1.513E-01},
    {1294, 1.4075, 0.000E+00, 0.000E+00, 0.000E+00, 1.239E+00, 2.728E+00, 4.776E-01, 1.361E-01, 4.986E-01, 1.513E-01},
    {1295, 1.4073, 0.000E+00, 0.000E+00, 0.000E+00, 1.252E+00, 2.729E+00, 4.750E-01, 1.353E-01, 4.988E-01, 1.513E-01},
    {1296, 1.4070, 0.000E+00, 0.000E+00, 0.000E+00, 1.267E+00, 2.730E+00, 4.724E-01, 1.344E-01, 4.987E-01, 1.517E-01},
    {1297, 1.4068, 0.000E+00, 0.000E+00, 0.000E+00, 1.283E+00, 2.730E+00, 4.698E-01, 1.336E-01, 4.987E-01, 1.521E-01},
    {1298, 1.4066, 0.000E+00, 0.000E+00, 0.000E+00, 1.297E+00, 2.731E+00, 4.672E-01, 1.327E-01, 4.987E-01, 1.525E-01},
    {1299, 1.4064, 0.000E+00, 0.000E+00, 0.000E+00, 1.310E+00, 2.731E+00, 4.646E-01, 1.319E-01, 4.987E-01, 1.529E-01},
    {1300, 1.4064, 0.000E+00, 0.000E+00, 0.000E+00, 1.323E+00, 2.721E+00, 4.620E-01, 1.310E-01, 4.987E-01, 1.533E-01},
    {1301, 1.4062, 0.000E+00, 0.000E+00, 0.000E+00, 1.336E+00, 2.736E+00, 4.553E-01, 1.291E-01, 4.987E-01, 1.533E-01},
    {1302, 1.4061, 0.000E+00, 0.000E+00, 0.000E+00, 1.351E+00, 2.728E+00, 4.485E-01, 1.271E-01, 4.987E-01, 1.533E-01},
    {1303, 1.4059, 0.000E+00, 0.000E+00, 0.000E+00, 1.370E+00, 2.719E+00, 4.418E-01, 1.252E-01, 4.987E-01, 1.534E-01},
    {1304, 1.4056, 0.000E+00, 0.000E+00, 0.000E+00, 1.392E+00, 2.712E+00, 4.350E-01, 1.232E-01, 4.987E-01, 1.534E-01},
    {1305, 1.4055, 0.000E+00, 0.000E+00, 0.000E+00, 1.416E+00, 2.698E+00, 4.283E-01, 1.213E-01, 4.987E-01, 1.535E-01},
    {1306, 1.4055, 0.000E+00, 0.000E+00, 0.000E+00, 1.440E+00, 2.702E+00, 4.215E-01, 1.193E-01, 4.987E-01, 1.535E-01},
    {1307, 1.4055, 0.000E+00, 0.000E+00, 0.000E+00, 1.465E+00, 2.691E+00, 4.148E-01, 1.174E-01, 4.987E-01, 1.535E-01},
    {1308, 1.4055, 0.000E+00, 0.000E+00, 0.000E+00, 1.489E+00, 2.688E+00, 4.080E-01, 1.154E-01, 4.987E-01, 1.534E-01},
    {1309, 1.4056, 0.000E+00, 0.000E+00, 0.000E+00, 1.511E+00, 2.686E+00, 4.013E-01, 1.135E-01, 4.987E-01, 1.534E-01},
    {1310, 1.4057, 0.000E+00, 0.000E+00, 0.000E+00, 1.532E+00, 2.682E+00, 3.945E-01, 1.115E-01, 4.987E-01, 1.534E-01},
    {1311, 1.4058, 0.000E+00, 0.000E+00, 0.000E+00, 1.555E+00, 2.676E+00, 3.878E-01, 1.096E-01, 4.987E-01, 1.534E-01},
    {1312, 1.4058, 0.000E+00, 0.000E+00, 0.000E+00, 1.580E+00, 2.675E+00, 3.810E-01, 1.076E-01, 4.987E-01, 1.534E-01},
    {1313, 1.4056, 0.000E+00, 0.000E+00, 0.000E+00, 1.610E+00, 2.677E+00, 3.743E-01, 1.057E-01, 4.987E-01, 1.534E-01},
    {1314, 1.4055, 0.000E+00, 0.000E+00, 0.000E+00, 1.642E+00, 2.670E+00, 3.675E-01, 1.037E-01, 4.987E-01, 1.534E-01},
    {1315, 1.4053, 0.000E+00, 0.000E+00, 0.000E+00, 1.672E+00, 2.671E+00, 3.608E-01, 1.018E-01, 4.987E-01, 1.534E-01},
    {1316, 1.4051, 0.000E+00, 0.000E+00, 0.000E+00, 1.701E+00, 2.668E+00, 3.540E-01, 9.980E-02, 4.987E-01, 1.534E-01},
    {1317, 1.4050, 0.000E+00, 0.000E+00, 0.000E+00, 1.728E+00, 2.670E+00, 3.473E-01, 9.785E-02, 4.987E-01, 1.534E-01},
    {1318, 1.4049, 0.000E+00, 0.000E+00, 0.000E+00, 1.758E+00, 2.674E+00, 3.405E-01, 9.590E-02, 4.987E-01, 1.534E-01},
    {1319, 1.4048, 0.000E+00, 0.000E+00, 0.000E+00, 1.791E+00, 2.674E+00, 3.338E-01, 9.395E-02, 4.987E-01, 1.534E-01},
    {1320, 1.4046, 0.000E+00, 0.000E+00, 0.000E+00, 1.831E+00, 2.683E+00, 3.270E-01, 9.200E-02, 4.987E-01, 1.534E-01},
    {1321, 1.4045, 0.000E+00, 0.000E+00, 0.000E+00, 1.872E+00, 2.674E+00, 3.239E-01, 9.110E-02, 4.987E-01, 1.534E-01},
    {1322, 1.4044, 0.000E+00, 0.000E+00, 0.000E+00, 1.911E+00, 2.675E+00, 3.207E-01, 9.020E-02, 4.987E-01, 1.534E-01},
    {1323, 1.4044, 0.000E+00, 0.000E+00, 0.000E+00, 1.943E+00, 2.682E+00, 3.176E-01, 8.930E-02, 4.987E-01, 1.534E-01},
    {1324, 1.4044, 0.000E+00, 0.000E+00, 0.000E+00, 1.974E+00, 2.683E+00, 3.144E-01, 8.840E-02, 4.987E-01, 1.534E-01},
    {1325, 1.4045, 0.000E+00, 0.000E+00, 0.000E+00, 2.007E+00, 2.665E+00, 3.113E-01, 8.750E-02, 4.987E-01, 1.534E-01},
    {1326, 1.4045, 0.000E+00, 0.000E+00, 0.000E+00, 2.047E+00, 2.661E+00, 3.081E-01, 8.660E-02, 4.986E-01, 1.534E-01},
    {1327, 1.4043, 0.000E+00, 0.000E+00, 0.000E+00, 2.098E+00, 2.668E+00, 3.050E-01, 8.570E-02, 4.986E-01, 1.534E-01},
    {1328, 1.4042, 0.000E+00, 0.000E+00, 0.000E+00, 2.153E+00, 2.670E+00, 3.018E-01, 8.480E-02, 4.986E-01, 1.534E-01},
    {1329, 1.4040, 0.000E+00, 0.000E+00, 0.000E+00, 2.203E+00, 2.674E+00, 2.987E-01, 8.390E-02, 4.986E-01, 1.534E-01},
    {1330, 1.4040, 0.000E+00, 0.000E+00, 0.000E+00, 2.243E+00, 2.664E+00, 2.955E-01, 8.300E-02, 4.986E-01, 1.534E-01},
    {1331, 1.4041, 0.000E+00, 0.000E+00, 0.000E+00, 2.277E+00, 2.661E+00, 2.924E-01, 8.210E-02, 4.987E-01, 1.534E-01},
    {1332, 1.4041, 0.000E+00, 0.000E+00, 0.000E+00, 2.312E+00, 2.665E+00, 2.892E-01, 8.120E-02, 4.987E-01, 1.534E-01},
    {1333, 1.4040, 0.000E+00, 0.000E+00, 0.000E+00, 2.357E+00, 2.668E+00, 2.861E-01, 8.030E-02, 4.987E-01, 1.534E-01},
    {1334, 1.4036, 0.000E+00, 0.000E+00, 0.000E+00, 2.415E+00, 2.681E+00, 2.829E-01, 7.940E-02, 4.987E-01, 1.534E-01},
    {1335, 1.4034, 0.000E+00, 0.000E+00, 0.000E+00, 2.479E+00, 2.686E+00, 2.798E-01, 7.850E-02, 4.987E-01, 1.534E-01},
    {1336, 1.4032, 0.000E+00, 0.000E+00, 0.000E+00, 2.540E+00, 2.684E+00, 2.766E-01, 7.760E-02, 4.989E-01, 1.532E-01},
    {1337, 1.4031, 0.000E+00, 0.000E+00, 0.000E+00, 2.590E+00, 2.697E+00, 2.735E-01, 7.670E-02, 4.990E-01, 1.531E-01},
    {1338, 1.4030, 0.000E+00, 0.000E+00, 0.000E+00, 2.631E+00, 2.712E+00, 2.703E-01, 7.580E-02, 4.991E-01, 1.529E-01},
    {1339, 1.4031, 0.000E+00, 0.000E+00, 0.000E+00, 2.666E+00, 2.720E+00, 2.672E-01, 7.490E-02, 4.993E-01, 1.527E-01},
    {1340, 1.4033, 0.000E+00, 0.000E+00, 0.000E+00, 2.701E+00, 2.717E+00, 2.640E-01, 7.400E-02, 4.994E-01, 1.526E-01},
    {1341, 1.4033, 0.000E+00, 0.000E+00, 0.000E+00, 2.738E+00, 2.726E+00, 2.512E-01, 7.040E-02, 4.996E-01, 1.523E-01},
    {1342, 1.4033, 0.000E+00, 0.000E+00, 0.000E+00, 2.780E+00, 2.744E+00, 2.383E-01, 6.680E-02, 4.997E-01, 1.520E-01},
    {1343, 1.4031, 0.000E+00, 0.000E+00, 0.000E+00, 2.829E+00, 2.743E+00, 2.255E-01, 6.320E-02, 4.999E-01, 1.517E-01},
    {1344, 1.4028, 0.000E+00, 0.000E+00, 0.000E+00, 2.889E+00, 2.751E+00, 2.126E-01, 5.960E-02, 5.000E-01, 1.515E-01},
    {1345, 1.4023, 0.000E+00, 0.000E+00, 0.000E+00, 2.960E+00, 2.763E+00, 1.998E-01, 5.600E-02, 5.002E-01, 1.512E-01},
    {1346, 1.4017, 0.000E+00, 0.000E+00, 0.000E+00, 3.033E+00, 2.778E+00, 1.869E-01, 5.240E-02, 5.002E-01, 1.510E-01},
    {1347, 1.4013, 0.000E+00, 0.000E+00, 0.000E+00, 3.097E+00, 2.793E+00, 1.741E-01, 4.880E-02, 5.003E-01, 1.509E-01},
    {1348, 1.4010, 0.000E+00, 0.000E+00, 0.000E+00, 3.146E+00, 2.818E+00, 1.612E-01, 4.520E-02, 5.003E-01, 1.507E-01},
    {1349, 1.4010, 0.000E+00, 0.000E+00, 0.000E+00, 3.181E+00, 2.835E+00, 1.484E-01, 4.160E-02, 5.003E-01, 1.506E-01},
    {1350, 1.4008, 0.000E+00, 0.000E+00, 0.000E+00, 3.226E+00, 2.865E+00, 1.355E-01, 3.800E-02, 5.004E-01, 1.504E-01},
    {1351, 1.4007, 0.000E+00, 0.000E+00, 0.000E+00, 3.267E+00, 2.879E+00, 1.227E-01, 3.440E-02, 5.004E-01, 1.504E-01},
    {1352, 1.4004, 0.000E+00, 0.000E+00, 0.000E+00, 3.319E+00, 2.899E+00, 1.098E-01, 3.080E-02, 5.004E-01, 1.504E-01},
    {1353, 1.4002, 0.000E+00, 0.000E+00, 0.000E+00, 3.363E+00, 2.918E+00, 9.695E-02, 2.720E-02, 5.004E-01, 1.504E-01},
    {1354, 1.4000, 0.000E+00, 0.000E+00, 0.000E+00, 3.412E+00, 2.936E+00, 8.410E-02, 2.360E-02, 5.004E-01, 1.504E-01},
    {1355, 1.4002, 0.000E+00, 0.000E+00, 0.000E+00, 3.449E+00, 2.953E+00, 7.125E-02, 2.000E-02, 5.004E-01, 1.504E-01},
    {1356, 1.4004, 0.000E+00, 0.000E+00, 0.000E+00, 3.504E+00, 2.966E+00, 5.840E-02, 1.640E-02, 5.002E-01, 1.500E-01},
    {1357, 1.4009, 0.000E+00, 0.000E+00, 0.000E+00, 3.544E+00, 2.977E+00, 4.555E-02, 1.280E-02, 5.000E-01, 1.497E-01},
    {1358, 1.4011, 0.000E+00, 0.000E+00, 0.000E+00, 3.600E+00, 2.981E+00, 3.270E-02, 9.200E-03, 4.998E-01, 1.493E-01},
    {1359, 1.4015, 0.000E+00, 0.000E+00, 0.000E+00, 3.648E+00, 2.942E+00, 1.985E-02, 5.600E-03, 4.996E-01, 1.489E-01},
    {1360, 1.4016, 0.000E+00, 0.000E+00, 0.000E+00, 3.701E+00, 2.887E+00, 7.000E-03, 2.000E-03, 4.995E-01, 1.486E-01},
    {1361, 1.4015, 0.000E+00, 0.000E+00, 0.000E+00, 3.752E+00, 2.864E+00, 6.800E-03, 1.950E-03, 4.993E-01, 1.481E-01},
    {1362, 1.4010, 0.000E+00, 0.000E+00, 0.000E+00, 3.802E+00, 2.877E+00, 6.600E-03, 1.900E-03, 4.992E-01, 1.476E-01},
    {1363, 1.4002, 0.000E+00, 0.000E+00, 0.000E+00, 3.871E+00, 2.886E+00, 6.400E-03, 1.850E-03, 4.991E-01, 1.471E-01},
    {1364, 1.3996, 0.000E+00, 0.000E+00, 0.000E+00, 3.927E+00, 2.888E+00, 6.200E-03, 1.800E-03, 4.990E-01, 1.466E-01},
    {1365, 1.3992, 0.000E+00, 0.000E+00, 0.000E+00, 3.985E+00, 2.891E+00, 6.000E-03, 1.750E-03, 4.989E-01, 1.461E-01},
    {1366, 1.3989, 0.000E+00, 0.000E+00, 0.000E+00, 4.064E+00, 2.899E+00, 5.800E-03, 1.700E-03, 4.989E-01, 1.454E-01},
    {1367, 1.3992, 0.000E+00, 0.000E+00, 0.000E+00, 4.125E+00, 2.887E+00, 5.600E-03, 1.650E-03, 4.989E-01, 1.447E-01},
    {1368, 1.3994, 0.000E+00, 0.000E+00, 0.000E+00, 4.216E+00, 2.884E+00, 5.400E-03, 1.600E-03, 4.989E-01, 1.440E-01},
    {1369, 1.3997, 0.000E+00, 0.000E+00, 0.000E+00, 4.302E+00, 2.900E+00, 5.200E-03, 1.550E-03, 4.989E-01, 1.433E-01},
    {1370, 1.4000, 0.000E+00, 0.000E+00, 0.000E+00, 4.389E+00, 2.929E+00, 5.000E-03, 1.500E-03, 4.989E-01, 1.425E-01},
    {1371, 1.4000, 0.000E+00, 0.000E+00, 0.000E+00, 4.504E+00, 2.969E+00, 4.800E-03, 1.450E-03, 4.989E-01, 1.414E-01},
    {1372, 1.4000, 0.000E+00, 0.000E+00, 0.000E+00, 4.630E+00, 3.014E+00, 4.600E-03, 1.400E-03, 4.989E-01, 1.403E-01},
    {1373, 1.4003, 0.000E+00, 0.000E+00, 0.000E+00, 4.737E+00, 3.053E+00, 4.400E-03, 1.350E-03, 4.989E-01, 1.392E-01},
    {1374, 1.4002, 0.000E+00, 0.000E+00, 0.000E+00, 4.904E+00, 3.075E+00, 4.200E-03, 1.300E-03, 4.989E-01, 1.381E-01},
    {1375, 1.3999, 0.000E+00, 0.000E+00, 0.000E+00, 5.092E+00, 3.111E+00, 4.000E-03, 1.250E-03, 4.989E-01, 1.370E-01},
    {1376, 1.4002, 0.000E+00, 0.000E+00, 0.000E+00, 5.260E+00, 3.128E+00, 3.800E-03, 1.200E-03, 4.988E-01, 1.363E-01},
    {1377, 1.4004, 0.000E+00, 0.000E+00, 0.000E+00, 5.479E+00, 3.130E+00, 3.600E-03, 1.150E-03, 4.988E-01, 1.355E-01},
    {1378, 1.4008, 0.000E+00, 0.000E+00, 0.000E+00, 5.720E+00, 3.103E+00, 3.400E-03, 1.100E-03, 4.988E-01, 1.348E-01},
    {1379, 1.4009, 0.000E+00, 0.000E+00, 0.000E+00, 6.006E+00, 3.051E+00, 3.200E-03, 1.050E-03, 4.988E-01, 1.340E-01},
    {1380, 1.4019, 0.000E+00, 0.000E+00, 0.000E+00, 6.242E+00, 2.979E+00, 3.000E-03, 1.000E-03, 4.988E-01, 1.332E-01},
    {1381, 1.4015, 0.000E+00, 0.000E+00, 0.000E+00, 6.580E+00, 2.941E+00, 3.900E-03, 1.250E-03, 4.979E-01, 1.321E-01},
    {1382, 1.4010, 0.000E+00, 0.000E+00, 0.000E+00, 6.927E+00, 2.920E+00, 4.800E-03, 1.500E-03, 4.970E-01, 1.309E-01},
    {1383, 1.4000, 0.000E+00, 0.000E+00, 0.000E+00, 7.313E+00, 2.931E+00, 5.700E-03, 1.750E-03, 4.962E-01, 1.298E-01},
    {1384, 1.4001, 0.000E+00, 0.000E+00, 0.000E+00, 7.633E+00, 2.950E+00, 6.600E-03, 2.000E-03, 4.953E-01, 1.287E-01},
    {1385, 1.3988, 0.000E+00, 0.000E+00, 0.000E+00, 8.089E+00, 2.978E+00, 7.500E-03, 2.250E-03, 4.944E-01, 1.275E-01},
    {1386, 1.3978, 0.000E+00, 0.000E+00, 0.000E+00, 8.545E+00, 3.025E+00, 8.400E-03, 2.500E-03, 4.940E-01, 1.264E-01},
    {1387, 1.3971, 0.000E+00, 0.000E+00, 0.000E+00, 9.030E+00, 3.048E+00, 9.300E-03, 2.750E-03, 4.937E-01, 1.252E-01},
    {1388, 1.3960, 0.000E+00, 0.000E+00, 0.000E+00, 9.591E+00, 3.066E+00, 1.020E-02, 3.000E-03, 4.933E-01, 1.240E-01},
    {1389, 1.3967, 0.000E+00, 0.000E+00, 0.000E+00, 1.002E+01, 3.087E+00, 1.110E-02, 3.250E-03, 4.930E-01, 1.229E-01},
    {1390, 1.3958, 0.000E+00, 0.000E+00, 0.000E+00, 1.063E+01, 3.099E+00, 1.200E-02, 3.500E-03, 4.926E-01, 1.217E-01},
    {1391, 1.3955, 0.000E+00, 0.000E+00, 0.000E+00, 1.122E+01, 3.090E+00, 1.290E-02, 3.750E-03, 4.926E-01, 1.209E-01},
    {1392, 1.3952, 0.000E+00, 0.000E+00, 0.000E+00, 1.184E+01, 3.088E+00, 1.380E-02, 4.000E-03, 4.926E-01, 1.201E-01},
    {1393, 1.3953, 0.000E+00, 0.000E+00, 0.000E+00, 1.245E+01, 3.081E+00, 1.470E-02, 4.250E-03, 4.926E-01, 1.193E-01},
    {1394, 1.3945, 0.000E+00, 0.000E+00, 0.000E+00, 1.316E+01, 3.085E+00, 1.560E-02, 4.500E-03, 4.926E-01, 1.185E-01},
    {1395, 1.3960, 0.000E+00, 0.000E+00, 0.000E+00, 1.369E+01, 3.071E+00, 1.650E-02, 4.750E-03, 4.926E-01, 1.178E-01},
    {1396, 1.3961, 0.000E+00, 0.000E+00, 0.000E+00, 1.434E+01, 3.065E+00, 1.740E-02, 5.000E-03, 4.926E-01, 1.169E-01},
    {1397, 1.3950, 0.000E+00, 0.000E+00, 0.000E+00, 1.509E+01, 3.069E+00, 1.830E-02, 5.250E-03, 4.926E-01, 1.161E-01},
    {1398, 1.3946, 0.000E+00, 0.000E+00, 0.000E+00, 1.578E+01, 3.067E+00, 1.920E-02, 5.500E-03, 4.926E-01, 1.152E-01},
    {1399, 1.3942, 0.000E+00, 0.000E+00, 0.000E+00, 1.646E+01, 3.085E+00, 2.010E-02, 5.750E-03, 4.926E-01, 1.143E-01},
    {1400, 1.3938, 0.000E+00, 0.000E+00, 0.000E+00, 1.714E+01, 3.094E+00, 2.100E-02, 6.000E-03, 4.926E-01, 1.135E-01},
    {1401, 1.3935, 0.000E+00, 0.000E+00, 0.000E+00, 1.781E+01, 3.110E+00, 2.095E-02, 5.950E-03, 4.926E-01, 1.128E-01},
    {1402, 1.3926, 0.000E+00, 0.000E+00, 0.000E+00, 1.854E+01, 3.136E+00, 2.090E-02, 5.900E-03, 4.926E-01, 1.122E-01},
    {1403, 1.3926, 0.000E+00, 0.000E+00, 0.000E+00, 1.919E+01, 3.149E+00, 2.085E-02, 5.850E-03, 4.926E-01, 1.116E-01},
    {1404, 1.3930, 0.000E+00, 0.000E+00, 0.000E+00, 1.980E+01, 3.158E+00, 2.080E-02, 5.800E-03, 4.926E-01, 1.109E-01},
    {1405, 1.3943, 0.000E+00, 0.000E+00, 0.000E+00, 2.029E+01, 3.191E+00, 2.075E-02, 5.750E-03, 4.926E-01, 1.103E-01},
    {1406, 1.3943, 0.000E+00, 0.000E+00, 0.000E+00, 2.089E+01, 3.230E+00, 2.070E-02, 5.700E-03, 4.926E-01, 1.098E-01},
    {1407, 1.3944, 0.000E+00, 0.000E+00, 0.000E+00, 2.146E+01, 3.265E+00, 2.065E-02, 5.650E-03, 4.926E-01, 1.093E-01},
    {1408, 1.3944, 0.000E+00, 0.000E+00, 0.000E+00, 2.202E+01, 3.298E+00, 2.060E-02, 5.600E-03, 4.926E-01, 1.088E-01},
    {1409, 1.3937, 0.000E+00, 0.000E+00, 0.000E+00, 2.260E+01, 3.356E+00, 2.055E-02, 5.550E-03, 4.926E-01, 1.083E-01},
    {1410, 1.3933, 0.000E+00, 0.000E+00, 0.000E+00, 2.313E+01, 3.419E+00, 2.050E-02, 5.500E-03, 4.925E-01, 1.078E-01},
    {1411, 1.3934, 0.000E+00, 0.000E+00, 0.000E+00, 2.360E+01, 3.476E+00, 2.045E-02, 5.450E-03, 4.933E-01, 1.070E-01},
    {1412, 1.3934, 0.000E+00, 0.000E+00, 0.000E+00, 2.407E+01, 3.534E+00, 2.040E-02, 5.400E-03, 4.940E-01, 1.062E-01},
    {1413, 1.3935, 0.000E+00, 0.000E+00, 0.000E+00, 2.450E+01, 3.584E+00, 2.035E-02, 5.350E-03, 4.947E-01, 1.054E-01},
    {1414, 1.3933, 0.000E+00, 0.000E+00, 0.000E+00, 2.493E+01, 3.632E+00, 2.030E-02, 5.300E-03, 4.955E-01, 1.046E-01},
    {1415, 1.3931, 0.000E+00, 0.000E+00, 0.000E+00, 2.533E+01, 3.708E+00, 2.025E-02, 5.250E-03, 4.962E-01, 1.039E-01},
    {1416, 1.3928, 0.000E+00, 0.000E+00, 0.000E+00, 2.571E+01, 3.775E+00, 2.020E-02, 5.200E-03, 4.968E-01, 1.037E-01},
    {1417, 1.3925, 0.000E+00, 0.000E+00, 0.000E+00, 2.606E+01, 3.847E+00, 2.015E-02, 5.150E-03, 4.974E-01, 1.036E-01},
    {1418, 1.3920, 0.000E+00, 0.000E+00, 0.000E+00, 2.641E+01, 3.931E+00, 2.010E-02, 5.100E-03, 4.980E-01, 1.035E-01},
    {1419, 1.3918, 0.000E+00, 0.000E+00, 0.000E+00, 2.673E+01, 3.987E+00, 2.005E-02, 5.050E-03, 4.986E-01, 1.034E-01},
    {1420, 1.3915, 0.000E+00, 0.000E+00, 0.000E+00, 2.701E+01, 4.071E+00, 2.000E-02, 5.000E-03, 4.992E-01, 1.032E-01},
    {1421, 1.3910, 0.000E+00, 0.000E+00, 0.000E+00, 2.729E+01, 4.156E+00, 2.170E-02, 5.450E-03, 4.994E-01, 1.029E-01},
    {1422, 1.3904, 0.000E+00, 0.000E+00, 0.000E+00, 2.756E+01, 4.242E+00, 2.340E-02, 5.900E-03, 4.997E-01, 1.026E-01},
    {1423, 1.3898, 0.000E+00, 0.000E+00, 0.000E+00, 2.782E+01, 4.320E+00, 2.510E-02, 6.350E-03, 4.999E-01, 1.024E-01},
    {1424, 1.3892, 0.000E+00, 0.000E+00, 0.000E+00, 2.806E+01, 4.395E+00, 2.680E-02, 6.800E-03, 5.001E-01, 1.021E-01},
    {1425, 1.3880, 0.000E+00, 0.000E+00, 0.000E+00, 2.835E+01, 4.480E+00, 2.850E-02, 7.250E-03, 5.003E-01, 1.018E-01},
    {1426, 1.3872, 0.000E+00, 0.000E+00, 0.000E+00, 2.856E+01, 4.561E+00, 3.020E-02, 7.700E-03, 5.004E-01, 1.016E-01},
    {1427, 1.3865, 0.000E+00, 0.000E+00, 0.000E+00, 2.875E+01, 4.638E+00, 3.190E-02, 8.150E-03, 5.005E-01, 1.015E-01},
    {1428, 1.3858, 0.000E+00, 0.000E+00, 0.000E+00, 2.892E+01, 4.708E+00, 3.360E-02, 8.600E-03, 5.006E-01, 1.013E-01},
    {1429, 1.3852, 0.000E+00, 0.000E+00, 0.000E+00, 2.908E+01, 4.782E+00, 3.530E-02, 9.050E-03, 5.006E-01, 1.012E-01},
    {1430, 1.3843, 0.000E+00, 0.000E+00, 0.000E+00, 2.926E+01, 4.846E+00, 3.700E-02, 9.500E-03, 5.007E-01, 1.010E-01},
    {1431, 1.3838, 0.000E+00, 0.000E+00, 0.000E+00, 2.940E+01, 4.906E+00, 3.870E-02, 9.950E-03, 5.007E-01, 1.010E-01},
    {1432, 1.3829, 0.000E+00, 0.000E+00, 0.000E+00, 2.956E+01, 4.974E+00, 4.040E-02, 1.040E-02, 5.008E-01, 1.010E-01},
    {1433, 1.3823, 0.000E+00, 0.000E+00, 0.000E+00, 2.966E+01, 5.026E+00, 4.210E-02, 1.085E-02, 5.008E-01, 1.010E-01},
    {1434, 1.3810, 0.000E+00, 0.000E+00, 0.000E+00, 2.982E+01, 5.071E+00, 4.380E-02, 1.130E-02, 5.008E-01, 1.010E-01},
    {1435, 1.3801, 0.000E+00, 0.000E+00, 0.000E+00, 2.993E+01, 5.131E+00, 4.550E-02, 1.175E-02, 5.008E-01, 1.010E-01},
    {1436, 1.3794, 0.000E+00, 0.000E+00, 0.000E+00, 3.003E+01, 5.179E+00, 4.720E-02, 1.220E-02, 5.008E-01, 1.010E-01},
    {1437, 1.3785, 0.000E+00, 0.000E+00, 0.000E+00, 3.014E+01, 5.220E+00, 4.890E-02, 1.265E-02, 5.008E-01, 1.010E-01},
    {1438, 1.3776, 0.000E+00, 0.000E+00, 0.000E+00, 3.023E+01, 5.271E+00, 5.060E-02, 1.310E-02, 5.008E-01, 1.010E-01},
    {1439, 1.3771, 0.000E+00, 0.000E+00, 0.000E+00, 3.029E+01, 5.322E+00, 5.230E-02, 1.355E-02, 5.008E-01, 1.010E-01},
    {1440, 1.3765, 0.000E+00, 0.000E+00, 0.000E+00, 3.036E+01, 5.358E+00, 5.400E-02, 1.400E-02, 5.008E-01, 1.010E-01},
    {1441, 1.3758, 0.000E+00, 0.000E+00, 0.000E+00, 3.042E+01, 5.403E+00, 5.795E-02, 1.505E-02, 5.008E-01, 1.010E-01},
    {1442, 1.3751, 0.000E+00, 0.000E+00, 0.000E+00, 3.046E+01, 5.441E+00, 6.190E-02, 1.610E-02, 5.008E-01, 1.010E-01},
    {1443, 1.3743, 0.000E+00, 0.000E+00, 0.000E+00, 3.049E+01, 5.460E+00, 6.585E-02, 1.715E-02, 5.008E-01, 1.010E-01},
    {1444, 1.3733, 0.000E+00, 0.000E+00, 0.000E+00, 3.052E+01, 5.481E+00, 6.980E-02, 1.820E-02, 5.008E-01, 1.010E-01},
    {1445, 1.3725, 0.000E+00, 0.000E+00, 0.000E+00, 3.053E+01, 5.500E+00, 7.375E-02, 1.925E-02, 5.008E-01, 1.010E-01},
    {1446, 1.3717, 0.000E+00, 0.000E+00, 0.000E+00, 3.055E+01, 5.523E+00, 7.770E-02, 2.030E-02, 5.007E-01, 1.012E-01},
    {1447, 1.3711, 0.000E+00, 0.000E+00, 0.000E+00, 3.056E+01, 5.548E+00, 8.165E-02, 2.135E-02, 5.006E-01, 1.014E-01},
    {1448, 1.3707, 0.000E+00, 0.000E+00, 0.000E+00, 3.056E+01, 5.560E+00, 8.560E-02, 2.240E-02, 5.006E-01, 1.016E-01},
    {1449, 1.3703, 0.000E+00, 0.000E+00, 0.000E+00, 3.055E+01, 5.575E+00, 8.955E-02, 2.345E-02, 5.005E-01, 1.019E-01},
    {1450, 1.3700, 0.000E+00, 0.000E+00, 0.000E+00, 3.054E+01, 5.582E+00, 9.350E-02, 2.450E-02, 5.004E-01, 1.021E-01},
    {1451, 1.3700, 0.000E+00, 0.000E+00, 0.000E+00, 3.051E+01, 5.597E+00, 9.745E-02, 2.555E-02, 5.004E-01, 1.021E-01},
    {1452, 1.3697, 0.000E+00, 0.000E+00, 0.000E+00, 3.049E+01, 5.611E+00, 1.014E-01, 2.660E-02, 5.005E-01, 1.021E-01},
    {1453, 1.3692, 0.000E+00, 0.000E+00, 0.000E+00, 3.045E+01, 5.639E+00, 1.054E-01, 2.765E-02, 5.005E-01, 1.021E-01},
    {1454, 1.3685, 0.000E+00, 0.000E+00, 0.000E+00, 3.041E+01, 5.653E+00, 1.093E-01, 2.870E-02, 5.006E-01, 1.021E-01},
    {1455, 1.3680, 0.000E+00, 0.000E+00, 0.000E+00, 3.035E+01, 5.675E+00, 1.133E-01, 2.975E-02, 5.006E-01, 1.021E-01},
    {1456, 1.3675, 0.000E+00, 0.000E+00, 0.000E+00, 3.029E+01, 5.682E+00, 1.172E-01, 3.080E-02, 5.008E-01, 1.021E-01},
    {1457, 1.3670, 0.000E+00, 0.000E+00, 0.000E+00, 3.023E+01, 5.685E+00, 1.212E-01, 3.185E-02, 5.011E-01, 1.021E-01},
    {1458, 1.3667, 0.000E+00, 0.000E+00, 0.000E+00, 3.014E+01, 5.680E+00, 1.251E-01, 3.290E-02, 5.014E-01, 1.021E-01},
    {1459, 1.3662, 0.000E+00, 0.000E+00, 0.000E+00, 3.006E+01, 5.689E+00, 1.291E-01, 3.395E-02, 5.016E-01, 1.020E-01},
    {1460, 1.3657, 0.000E+00, 0.000E+00, 0.000E+00, 2.998E+01, 5.711E+00, 1.330E-01, 3.500E-02, 5.019E-01, 1.020E-01},
    {1461, 1.3659, 0.000E+00, 0.000E+00, 0.000E+00, 2.983E+01, 5.723E+00, 1.327E-01, 3.495E-02, 5.020E-01, 1.023E-01},
    {1462, 1.3658, 0.000E+00, 0.000E+00, 0.000E+00, 2.971E+01, 5.715E+00, 1.324E-01, 3.490E-02, 5.022E-01, 1.026E-01},
    {1463, 1.3656, 0.000E+00, 0.000E+00, 0.000E+00, 2.957E+01, 5.716E+00, 1.321E-01, 3.485E-02, 5.023E-01, 1.029E-01},
    {1464, 1.3656, 0.000E+00, 0.000E+00, 0.000E+00, 2.936E+01, 5.732E+00, 1.318E-01, 3.480E-02, 5.025E-01, 1.032E-01},
    {1465, 1.3654, 0.000E+00, 0.000E+00, 0.000E+00, 2.917E+01, 5.741E+00, 1.315E-01, 3.475E-02, 5.026E-01, 1.035E-01},
    {1466, 1.3650, 0.000E+00, 0.000E+00, 0.000E+00, 2.899E+01, 5.743E+00, 1.312E-01, 3.470E-02, 5.027E-01, 1.036E-01},
    {1467, 1.3653, 0.000E+00, 0.000E+00, 0.000E+00, 2.872E+01, 5.752E+00, 1.309E-01, 3.465E-02, 5.028E-01, 1.037E-01},
    {1468, 1.3651, 0.000E+00, 0.000E+00, 0.000E+00, 2.851E+01, 5.745E+00, 1.306E-01, 3.460E-02, 5.029E-01, 1.037E-01},
    {1469, 1.3649, 0.000E+00, 0.000E+00, 0.000E+00, 2.829E+01, 5.744E+00, 1.303E-01, 3.455E-02, 5.031E-01, 1.038E-01},
    {1470, 1.3650, 0.000E+00, 0.000E+00, 0.000E+00, 2.800E+01, 5.757E+00, 1.300E-01, 3.450E-02, 5.032E-01, 1.039E-01},
    {1471, 1.3646, 0.000E+00, 0.000E+00, 0.000E+00, 2.777E+01, 5.766E+00, 1.297E-01, 3.445E-02, 5.032E-01, 1.049E-01},
    {1472, 1.3641, 0.000E+00, 0.000E+00, 0.000E+00, 2.754E+01, 5.780E+00, 1.294E-01, 3.440E-02, 5.033E-01, 1.059E-01},
    {1473, 1.3644, 0.000E+00, 0.000E+00, 0.000E+00, 2.722E+01, 5.787E+00, 1.291E-01, 3.435E-02, 5.033E-01, 1.069E-01},
    {1474, 1.3640, 0.000E+00, 0.000E+00, 0.000E+00, 2.699E+01, 5.798E+00, 1.288E-01, 3.430E-02, 5.034E-01, 1.079E-01},
    {1475, 1.3644, 0.000E+00, 0.000E+00, 0.000E+00, 2.664E+01, 5.810E+00, 1.285E-01, 3.425E-02, 5.034E-01, 1.088E-01},
    {1476, 1.3643, 0.000E+00, 0.000E+00, 0.000E+00, 2.638E+01, 5.808E+00, 1.282E-01, 3.420E-02, 5.032E-01, 1.092E-01},
    {1477, 1.3644, 0.000E+00, 0.000E+00, 0.000E+00, 2.611E+01, 5.815E+00, 1.279E-01, 3.415E-02, 5.030E-01, 1.096E-01},
    {1478, 1.3647, 0.000E+00, 0.000E+00, 0.000E+00, 2.581E+01, 5.825E+00, 1.276E-01, 3.410E-02, 5.028E-01, 1.100E-01},
    {1479, 1.3646, 0.000E+00, 0.000E+00, 0.000E+00, 2.555E+01, 5.824E+00, 1.273E-01, 3.405E-02, 5.026E-01, 1.104E-01},
    {1480, 1.3649, 0.000E+00, 0.000E+00, 0.000E+00, 2.522E+01, 5.827E+00, 1.270E-01, 3.400E-02, 5.024E-01, 1.107E-01},
    {1481, 1.3644, 0.000E+00, 0.000E+00, 0.000E+00, 2.497E+01, 5.854E+00, 1.384E-01, 3.690E-02, 5.022E-01, 1.108E-01},
    {1482, 1.3641, 0.000E+00, 0.000E+00, 0.000E+00, 2.468E+01, 5.878E+00, 1.497E-01, 3.980E-02, 5.020E-01, 1.108E-01},
    {1483, 1.3635, 0.000E+00, 0.000E+00, 0.000E+00, 2.443E+01, 5.900E+00, 1.611E-01, 4.270E-02, 5.019E-01, 1.108E-01},
    {1484, 1.3635, 0.000E+00, 0.000E+00, 0.000E+00, 2.413E+01, 5.908E+00, 1.724E-01, 4.560E-02, 5.017E-01, 1.108E-01},
    {1485, 1.3633, 0.000E+00, 0.000E+00, 0.000E+00, 2.388E+01, 5.922E+00, 1.838E-01, 4.850E-02, 5.015E-01, 1.108E-01},
    {1486, 1.3631, 0.000E+00, 0.000E+00, 0.000E+00, 2.364E+01, 5.940E+00, 1.951E-01, 5.140E-02, 5.017E-01, 1.114E-01},
    {1487, 1.3635, 0.000E+00, 0.000E+00, 0.000E+00, 2.332E+01, 5.962E+00, 2.065E-01, 5.430E-02, 5.019E-01, 1.120E-01},
    {1488, 1.3635, 0.000E+00, 0.000E+00, 0.000E+00, 2.307E+01, 5.963E+00, 2.178E-01, 5.720E-02, 5.021E-01, 1.126E-01},
    {1489, 1.3643, 0.000E+00, 0.000E+00, 0.000E+00, 2.274E+01, 5.966E+00, 2.292E-01, 6.010E-02, 5.023E-01, 1.133E-01},
    {1490, 1.3642, 0.000E+00, 0.000E+00, 0.000E+00, 2.250E+01, 5.982E+00, 2.405E-01, 6.300E-02, 5.025E-01, 1.139E-01},
    {1491, 1.3646, 0.000E+00, 0.000E+00, 0.000E+00, 2.218E+01, 5.990E+00, 2.519E-01, 6.590E-02, 5.027E-01, 1.144E-01},
    {1492, 1.3643, 0.000E+00, 0.000E+00, 0.000E+00, 2.193E+01, 5.994E+00, 2.632E-01, 6.880E-02, 5.029E-01, 1.150E-01},
    {1493, 1.3642, 0.000E+00, 0.000E+00, 0.000E+00, 2.163E+01, 6.016E+00, 2.746E-01, 7.170E-02, 5.031E-01, 1.156E-01},
    {1494, 1.3637, 0.000E+00, 0.000E+00, 0.000E+00, 2.139E+01, 6.014E+00, 2.859E-01, 7.460E-02, 5.033E-01, 1.161E-01},
    {1495, 1.3640, 0.000E+00, 0.000E+00, 0.000E+00, 2.107E+01, 6.025E+00, 2.973E-01, 7.750E-02, 5.035E-01, 1.167E-01},
    {1496, 1.3638, 0.000E+00, 0.000E+00, 0.000E+00, 2.082E+01, 6.008E+00, 3.086E-01, 8.040E-02, 5.036E-01, 1.171E-01},
    {1497, 1.3640, 0.000E+00, 0.000E+00, 0.000E+00, 2.052E+01, 6.022E+00, 3.200E-01, 8.330E-02, 5.037E-01, 1.175E-01},
    {1498, 1.3640, 0.000E+00, 0.000E+00, 0.000E+00, 2.025E+01, 6.021E+00, 3.313E-01, 8.620E-02, 5.038E-01, 1.180E-01},
    {1499, 1.3640, 0.000E+00, 0.000E+00, 0.000E+00, 2.001E+01, 6.027E+00, 3.427E-01, 8.910E-02, 5.040E-01, 1.184E-01},
    {1500, 1.3646, 0.000E+00, 0.000E+00, 0.000E+00, 1.972E+01, 6.027E+00, 3.540E-01, 9.200E-02, 5.041E-01, 1.188E-01},
    {1501, 1.3645, 0.000E+00, 0.000E+00, 0.000E+00, 1.951E+01, 6.035E+00, 3.541E-01, 9.200E-02, 5.039E-01, 1.192E-01},
    {1502, 1.3650, 0.000E+00, 0.000E+00, 0.000E+00, 1.924E+01, 6.025E+00, 3.541E-01, 9.200E-02, 5.037E-01, 1.196E-01},
    {1503, 1.3650, 0.000E+00, 0.000E+00, 0.000E+00, 1.900E+01, 6.009E+00, 3.542E-01, 9.200E-02, 5.036E-01, 1.200E-01},
    {1504, 1.3652, 0.000E+00, 0.000E+00, 0.000E+00, 1.874E+01, 5.989E+00, 3.542E-01, 9.200E-02, 5.034E-01, 1.204E-01},
    {1505, 1.3657, 0.000E+00, 0.000E+00, 0.000E+00, 1.847E+01, 5.987E+00, 3.543E-01, 9.200E-02, 5.033E-01, 1.208E-01},
    {1506, 1.3656, 0.000E+00, 0.000E+00, 0.000E+00, 1.827E+01, 5.984E+00, 3.543E-01, 9.200E-02, 5.035E-01, 1.212E-01},
    {1507, 1.3660, 0.000E+00, 0.000E+00, 0.000E+00, 1.802E+01, 5.971E+00, 3.544E-01, 9.200E-02, 5.036E-01, 1.216E-01},
    {1508, 1.3657, 0.000E+00, 0.000E+00, 0.000E+00, 1.784E+01, 5.971E+00, 3.544E-01, 9.200E-02, 5.038E-01, 1.220E-01},
    {1509, 1.3661, 0.000E+00, 0.000E+00, 0.000E+00, 1.758E+01, 5.973E+00, 3.545E-01, 9.200E-02, 5.040E-01, 1.223E-01},
    {1510, 1.3665, 0.000E+00, 0.000E+00, 0.000E+00, 1.734E+01, 5.951E+00, 3.545E-01, 9.200E-02, 5.042E-01, 1.227E-01},
    {1511, 1.3667, 0.000E+00, 0.000E+00, 0.000E+00, 1.712E+01, 5.952E+00, 3.546E-01, 9.200E-02, 5.044E-01, 1.233E-01},
    {1512, 1.3670, 0.000E+00, 0.000E+00, 0.000E+00, 1.688E+01, 5.939E+00, 3.546E-01, 9.200E-02, 5.047E-01, 1.239E-01},
    {1513, 1.3666, 0.000E+00, 0.000E+00, 0.000E+00, 1.671E+01, 5.933E+00, 3.547E-01, 9.200E-02, 5.049E-01, 1.245E-01},
    {1514, 1.3669, 0.000E+00, 0.000E+00, 0.000E+00, 1.647E+01, 5.931E+00, 3.547E-01, 9.200E-02, 5.051E-01, 1.251E-01},
    {1515, 1.3673, 0.000E+00, 0.000E+00, 0.000E+00, 1.623E+01, 5.925E+00, 3.548E-01, 9.200E-02, 5.054E-01, 1.257E-01},
    {1516, 1.3673, 0.000E+00, 0.000E+00, 0.000E+00, 1.606E+01, 5.909E+00, 3.548E-01, 9.200E-02, 5.057E-01, 1.262E-01},
    {1517, 1.3680, 0.000E+00, 0.000E+00, 0.000E+00, 1.583E+01, 5.897E+00, 3.549E-01, 9.200E-02, 5.061E-01, 1.268E-01},
    {1518, 1.3686, 0.000E+00, 0.000E+00, 0.000E+00, 1.562E+01, 5.884E+00, 3.549E-01, 9.200E-02, 5.065E-01, 1.274E-01},
    {1519, 1.3686, 0.000E+00, 0.000E+00, 0.000E+00, 1.545E+01, 5.881E+00, 3.550E-01, 9.200E-02, 5.068E-01, 1.279E-01},
    {1520, 1.3689, 0.000E+00, 0.000E+00, 0.000E+00, 1.525E+01, 5.876E+00, 3.550E-01, 9.200E-02, 5.072E-01, 1.285E-01},
    {1521, 1.3693, 0.000E+00, 0.000E+00, 0.000E+00, 1.504E+01, 5.856E+00, 3.556E-01, 9.210E-02, 5.072E-01, 1.291E-01},
    {1522, 1.3690, 0.000E+00, 0.000E+00, 0.000E+00, 1.489E+01, 5.843E+00, 3.561E-01, 9.220E-02, 5.073E-01, 1.298E-01},
    {1523, 1.3694, 0.000E+00, 0.000E+00, 0.000E+00, 1.468E+01, 5.830E+00, 3.567E-01, 9.230E-02, 5.073E-01, 1.305E-01},
    {1524, 1.3697, 0.000E+00, 0.000E+00, 0.000E+00, 1.447E+01, 5.818E+00, 3.572E-01, 9.240E-02, 5.073E-01, 1.311E-01},
    {1525, 1.3695, 0.000E+00, 0.000E+00, 0.000E+00, 1.432E+01, 5.807E+00, 3.578E-01, 9.250E-02, 5.074E-01, 1.318E-01},
    {1526, 1.3697, 0.000E+00, 0.000E+00, 0.000E+00, 1.413E+01, 5.799E+00, 3.583E-01, 9.260E-02, 5.072E-01, 1.321E-01},
    {1527, 1.3698, 0.000E+00, 0.000E+00, 0.000E+00, 1.395E+01, 5.792E+00, 3.589E-01, 9.270E-02, 5.071E-01, 1.324E-01},
    {1528, 1.3696, 0.000E+00, 0.000E+00, 0.000E+00, 1.381E+01, 5.776E+00, 3.594E-01, 9.280E-02, 5.069E-01, 1.327E-01},
    {1529, 1.3698, 0.000E+00, 0.000E+00, 0.000E+00, 1.364E+01, 5.783E+00, 3.600E-01, 9.290E-02, 5.068E-01, 1.329E-01},
    {1530, 1.3700, 0.000E+00, 0.000E+00, 0.000E+00, 1.348E+01, 5.776E+00, 3.605E-01, 9.300E-02, 5.067E-01, 1.332E-01},
    {1531, 1.3706, 0.000E+00, 0.000E+00, 0.000E+00, 1.329E+01, 5.767E+00, 3.611E-01, 9.310E-02, 5.067E-01, 1.337E-01},
    {1532, 1.3705, 0.000E+00, 0.000E+00, 0.000E+00, 1.316E+01, 5.762E+00, 3.616E-01, 9.320E-02, 5.067E-01, 1.342E-01},
    {1533, 1.3709, 0.000E+00, 0.000E+00, 0.000E+00, 1.298E+01, 5.769E+00, 3.622E-01, 9.330E-02, 5.067E-01, 1.347E-01},
    {1534, 1.3712, 0.000E+00, 0.000E+00, 0.000E+00, 1.282E+01, 5.756E+00, 3.627E-01, 9.340E-02, 5.067E-01, 1.352E-01},
    {1535, 1.3717, 0.000E+00, 0.000E+00, 0.000E+00, 1.265E+01, 5.762E+00, 3.633E-01, 9.350E-02, 5.067E-01, 1.357E-01},
    {1536, 1.3718, 0.000E+00, 0.000E+00, 0.000E+00, 1.254E+01, 5.737E+00, 3.638E-01, 9.360E-02, 5.068E-01, 1.360E-01},
    {1537, 1.3721, 0.000E+00, 0.000E+00, 0.000E+00, 1.238E+01, 5.740E+00, 3.644E-01, 9.370E-02, 5.070E-01, 1.363E-01},
    {1538, 1.3721, 0.000E+00, 0.000E+00, 0.000E+00, 1.223E+01, 5.757E+00, 3.649E-01, 9.380E-02, 5.071E-01, 1.366E-01},
    {1539, 1.3724, 0.000E+00, 0.000E+00, 0.000E+00, 1.206E+01, 5.756E+00, 3.655E-01, 9.390E-02, 5.072E-01, 1.369E-01},
    {1540, 1.3723, 0.000E+00, 0.000E+00, 0.000E+00, 1.193E+01, 5.751E+00, 3.660E-01, 9.400E-02, 5.074E-01, 1.372E-01},
    {1541, 1.3721, 0.000E+00, 0.000E+00, 0.000E+00, 1.181E+01, 5.754E+00, 3.659E-01, 9.390E-02, 5.075E-01, 1.377E-01},
    {1542, 1.3723, 0.000E+00, 0.000E+00, 0.000E+00, 1.166E+01, 5.751E+00, 3.658E-01, 9.380E-02, 5.076E-01, 1.381E-01},
    {1543, 1.3723, 0.000E+00, 0.000E+00, 0.000E+00, 1.152E+01, 5.750E+00, 3.657E-01, 9.370E-02, 5.078E-01, 1.385E-01},
    {1544, 1.3725, 0.000E+00, 0.000E+00, 0.000E+00, 1.137E+01, 5.744E+00, 3.656E-01, 9.360E-02, 5.079E-01, 1.390E-01},
    {1545, 1.3723, 0.000E+00, 0.000E+00, 0.000E+00, 1.126E+01, 5.744E+00, 3.655E-01, 9.350E-02, 5.080E-01, 1.394E-01},
    {1546, 1.3723, 0.000E+00, 0.000E+00, 0.000E+00, 1.114E+01, 5.754E+00, 3.654E-01, 9.340E-02, 5.080E-01, 1.396E-01},
    {1547, 1.3727, 0.000E+00, 0.000E+00, 0.000E+00, 1.100E+01, 5.744E+00, 3.653E-01, 9.330E-02, 5.079E-01, 1.398E-01},
    {1548, 1.3729, 0.000E+00, 0.000E+00, 0.000E+00, 1.088E+01, 5.735E+00, 3.652E-01, 9.320E-02, 5.078E-01, 1.400E-01},
    {1549, 1.3730, 0.000E+00, 0.000E+00, 0.000E+00, 1.075E+01, 5.740E+00, 3.651E-01, 9.310E-02, 5.077E-01, 1.403E-01},
    {1550, 1.3730, 0.000E+00, 0.000E+00, 0.000E+00, 1.064E+01, 5.732E+00, 3.650E-01, 9.300E-02, 5.077E-01, 1.405E-01},
    {1551, 1.3730, 0.000E+00, 0.000E+00, 0.000E+00, 1.054E+01, 5.728E+00, 3.649E-01, 9.290E-02, 5.075E-01, 1.407E-01},
    {1552, 1.3731, 0.000E+00, 0.000E+00, 0.000E+00, 1.044E+01, 5.731E+00, 3.648E-01, 9.280E-02, 5.074E-01, 1.410E-01},
    {1553, 1.3734, 0.000E+00, 0.000E+00, 0.000E+00, 1.032E+01, 5.724E+00, 3.647E-01, 9.270E-02, 5.073E-01, 1.413E-01},
    {1554, 1.3734, 0.000E+00, 0.000E+00, 0.000E+00, 1.022E+01, 5.724E+00, 3.646E-01, 9.260E-02, 5.072E-01, 1.415E-01},
    {1555, 1.3736, 0.000E+00, 0.000E+00, 0.000E+00, 1.011E+01, 5.715E+00, 3.645E-01, 9.250E-02, 5.071E-01, 1.418E-01},
    {1556, 1.3737, 0.000E+00, 0.000E+00, 0.000E+00, 1.001E+01, 5.697E+00, 3.644E-01, 9.240E-02, 5.072E-01, 1.424E-01},
    {1557, 1.3738, 0.000E+00, 0.000E+00, 0.000E+00, 9.912E+00, 5.693E+00, 3.643E-01, 9.230E-02, 5.074E-01, 1.429E-01},
    {1558, 1.3735, 0.000E+00, 0.000E+00, 0.000E+00, 9.839E+00, 5.703E+00, 3.642E-01, 9.220E-02, 5.075E-01, 1.435E-01},
    {1559, 1.3735, 0.000E+00, 0.000E+00, 0.000E+00, 9.754E+00, 5.700E+00, 3.641E-01, 9.210E-02, 5.077E-01, 1.440E-01},
    {1560, 1.3734, 0.000E+00, 0.000E+00, 0.000E+00, 9.660E+00, 5.713E+00, 3.640E-01, 9.200E-02, 5.078E-01, 1.446E-01},
    {1561, 1.3735, 0.000E+00, 0.000E+00, 0.000E+00, 9.563E+00, 5.728E+00, 3.626E-01, 9.155E-02, 5.079E-01, 1.451E-01},
    {1562, 1.3736, 0.000E+00, 0.000E+00, 0.000E+00, 9.477E+00, 5.731E+00, 3.611E-01, 9.110E-02, 5.080E-01, 1.455E-01},
    {1563, 1.3738, 0.000E+00, 0.000E+00, 0.000E+00, 9.383E+00, 5.735E+00, 3.597E-01, 9.065E-02, 5.082E-01, 1.460E-01},
    {1564, 1.3737, 0.000E+00, 0.000E+00, 0.000E+00, 9.305E+00, 5.743E+00, 3.582E-01, 9.020E-02, 5.083E-01, 1.465E-01},
    {1565, 1.3738, 0.000E+00, 0.000E+00, 0.000E+00, 9.202E+00, 5.754E+00, 3.568E-01, 8.975E-02, 5.084E-01, 1.470E-01},
    {1566, 1.3736, 0.000E+00, 0.000E+00, 0.000E+00, 9.133E+00, 5.753E+00, 3.553E-01, 8.930E-02, 5.084E-01, 1.475E-01},
    {1567, 1.3737, 0.000E+00, 0.000E+00, 0.000E+00, 9.047E+00, 5.744E+00, 3.539E-01, 8.885E-02, 5.084E-01, 1.480E-01},
    {1568, 1.3735, 0.000E+00, 0.000E+00, 0.000E+00, 8.977E+00, 5.746E+00, 3.524E-01, 8.840E-02, 5.084E-01, 1.485E-01},
    {1569, 1.3735, 0.000E+00, 0.000E+00, 0.000E+00, 8.898E+00, 5.746E+00, 3.510E-01, 8.795E-02, 5.084E-01, 1.489E-01},
    {1570, 1.3735, 0.000E+00, 0.000E+00, 0.000E+00, 8.820E+00, 5.746E+00, 3.495E-01, 8.750E-02, 5.084E-01, 1.494E-01},
    {1571, 1.3734, 0.000E+00, 0.000E+00, 0.000E+00, 8.742E+00, 5.750E+00, 3.481E-01, 8.705E-02, 5.084E-01, 1.498E-01},
    {1572, 1.3734, 0.000E+00, 0.000E+00, 0.000E+00, 8.665E+00, 5.749E+00, 3.466E-01, 8.660E-02, 5.084E-01, 1.501E-01},
    {1573, 1.3734, 0.000E+00, 0.000E+00, 0.000E+00, 8.588E+00, 5.743E+00, 3.452E-01, 8.615E-02, 5.084E-01, 1.504E-01},
    {1574, 1.3735, 0.000E+00, 0.000E+00, 0.000E+00, 8.509E+00, 5.740E+00, 3.437E-01, 8.570E-02, 5.084E-01, 1.508E-01},
    {1575, 1.3732, 0.000E+00, 0.000E+00, 0.000E+00, 8.448E+00, 5.747E+00, 3.423E-01, 8.525E-02, 5.084E-01, 1.511E-01},
    {1576, 1.3733, 0.000E+00, 0.000E+00, 0.000E+00, 8.364E+00, 5.739E+00, 3.408E-01, 8.480E-02, 5.084E-01, 1.512E-01},
    {1577, 1.3732, 0.000E+00, 0.000E+00, 0.000E+00, 8.295E+00, 5.755E+00, 3.394E-01, 8.435E-02, 5.084E-01, 1.513E-01},
    {1578, 1.3732, 0.000E+00, 0.000E+00, 0.000E+00, 8.234E+00, 5.749E+00, 3.379E-01, 8.390E-02, 5.085E-01, 1.515E-01},
    {1579, 1.3735, 0.000E+00, 0.000E+00, 0.000E+00, 8.157E+00, 5.753E+00, 3.365E-01, 8.345E-02, 5.085E-01, 1.516E-01},
    {1580, 1.3736, 0.000E+00, 0.000E+00, 0.000E+00, 8.104E+00, 5.745E+00, 3.350E-01, 8.300E-02, 5.085E-01, 1.517E-01},
    {1581, 1.3739, 0.000E+00, 0.000E+00, 0.000E+00, 8.036E+00, 5.732E+00, 3.350E-01, 8.290E-02, 5.087E-01, 1.517E-01},
    {1582, 1.3742, 0.000E+00, 0.000E+00, 0.000E+00, 7.959E+00, 5.735E+00, 3.349E-01, 8.280E-02, 5.089E-01, 1.517E-01},
    {1583, 1.3741, 0.000E+00, 0.000E+00, 0.000E+00, 7.890E+00, 5.724E+00, 3.349E-01, 8.270E-02, 5.090E-01, 1.517E-01},
    {1584, 1.3738, 0.000E+00, 0.000E+00, 0.000E+00, 7.834E+00, 5.725E+00, 3.348E-01, 8.260E-02, 5.092E-01, 1.517E-01},
    {1585, 1.3737, 0.000E+00, 0.000E+00, 0.000E+00, 7.773E+00, 5.712E+00, 3.348E-01, 8.250E-02, 5.094E-01, 1.517E-01},
    {1586, 1.3737, 0.000E+00, 0.000E+00, 0.000E+00, 7.712E+00, 5.702E+00, 3.347E-01, 8.240E-02, 5.096E-01, 1.517E-01},
    {1587, 1.3736, 0.000E+00, 0.000E+00, 0.000E+00, 7.654E+00, 5.700E+00, 3.347E-01, 8.230E-02, 5.097E-01, 1.517E-01},
    {1588, 1.3735, 0.000E+00, 0.000E+00, 0.000E+00, 7.609E+00, 5.699E+00, 3.346E-01, 8.220E-02, 5.099E-01, 1.517E-01},
    {1589, 1.3737, 0.000E+00, 0.000E+00, 0.000E+00, 7.548E+00, 5.686E+00, 3.346E-01, 8.210E-02, 5.101E-01, 1.517E-01},
    {1590, 1.3738, 0.000E+00, 0.000E+00, 0.000E+00, 7.495E+00, 5.685E+00, 3.345E-01, 8.200E-02, 5.103E-01, 1.517E-01},
    {1591, 1.3741, 0.000E+00, 0.000E+00, 0.000E+00, 7.432E+00, 5.672E+00, 3.345E-01, 8.190E-02, 5.103E-01, 1.521E-01},
    {1592, 1.3743, 0.000E+00, 0.000E+00, 0.000E+00, 7.374E+00, 5.659E+00, 3.344E-01, 8.180E-02, 5.104E-01, 1.525E-01},
    {1593, 1.3744, 0.000E+00, 0.000E+00, 0.000E+00, 7.315E+00, 5.627E+00, 3.344E-01, 8.170E-02, 5.104E-01, 1.530E-01},
    {1594, 1.3744, 0.000E+00, 0.000E+00, 0.000E+00, 7.252E+00, 5.613E+00, 3.343E-01, 8.160E-02, 5.105E-01, 1.534E-01},
    {1595, 1.3743, 0.000E+00, 0.000E+00, 0.000E+00, 7.203E+00, 5.590E+00, 3.343E-01, 8.150E-02, 5.106E-01, 1.538E-01},
    {1596, 1.3740, 0.000E+00, 0.000E+00, 0.000E+00, 7.164E+00, 5.591E+00, 3.342E-01, 8.140E-02, 5.103E-01, 1.541E-01},
    {1597, 1.3740, 0.000E+00, 0.000E+00, 0.000E+00, 7.124E+00, 5.563E+00, 3.342E-01, 8.130E-02, 5.101E-01, 1.544E-01},
    {1598, 1.3741, 0.000E+00, 0.000E+00, 0.000E+00, 7.084E+00, 5.552E+00, 3.341E-01, 8.120E-02, 5.099E-01, 1.547E-01},
    {1599, 1.3741, 0.000E+00, 0.000E+00, 0.000E+00, 7.041E+00, 5.525E+00, 3.341E-01, 8.110E-02, 5.097E-01, 1.550E-01},
    {1600, 1.3742, 0.000E+00, 0.000E+00, 0.000E+00, 6.987E+00, 5.517E+00, 3.340E-01, 8.100E-02, 5.095E-01, 1.553E-01},
    {1601, 1.3742, 0.000E+00, 0.000E+00, 0.000E+00, 6.943E+00, 5.506E+00, 3.338E-01, 8.085E-02, 5.093E-01, 1.555E-01},
    {1602, 1.3741, 0.000E+00, 0.000E+00, 0.000E+00, 6.910E+00, 5.494E+00, 3.335E-01, 8.070E-02, 5.091E-01, 1.557E-01},
    {1603, 1.3743, 0.000E+00, 0.000E+00, 0.000E+00, 6.865E+00, 5.459E+00, 3.333E-01, 8.055E-02, 5.089E-01, 1.558E-01},
    {1604, 1.3743, 0.000E+00, 0.000E+00, 0.000E+00, 6.828E+00, 5.450E+00, 3.330E-01, 8.040E-02, 5.087E-01, 1.560E-01},
    {1605, 1.3743, 0.000E+00, 0.000E+00, 0.000E+00, 6.776E+00, 5.438E+00, 3.328E-01, 8.025E-02, 5.085E-01, 1.562E-01},
    {1606, 1.3742, 0.000E+00, 0.000E+00, 0.000E+00, 6.742E+00, 5.428E+00, 3.325E-01, 8.010E-02, 5.086E-01, 1.568E-01},
    {1607, 1.3741, 0.000E+00, 0.000E+00, 0.000E+00, 6.714E+00, 5.407E+00, 3.323E-01, 7.995E-02, 5.087E-01, 1.573E-01},
    {1608, 1.3740, 0.000E+00, 0.000E+00, 0.000E+00, 6.695E+00, 5.391E+00, 3.320E-01, 7.980E-02, 5.088E-01, 1.578E-01},
    {1609, 1.3740, 0.000E+00, 0.000E+00, 0.000E+00, 6.654E+00, 5.382E+00, 3.318E-01, 7.965E-02, 5.089E-01, 1.584E-01},
    {1610, 1.3738, 0.000E+00, 0.000E+00, 0.000E+00, 6.630E+00, 5.376E+00, 3.315E-01, 7.950E-02, 5.090E-01, 1.589E-01},
    {1611, 1.3736, 0.000E+00, 0.000E+00, 0.000E+00, 6.599E+00, 5.358E+00, 3.313E-01, 7.935E-02, 5.091E-01, 1.590E-01},
    {1612, 1.3734, 0.000E+00, 0.000E+00, 0.000E+00, 6.567E+00, 5.347E+00, 3.310E-01, 7.920E-02, 5.092E-01, 1.590E-01},
    {1613, 1.3733, 0.000E+00, 0.000E+00, 0.000E+00, 6.526E+00, 5.333E+00, 3.308E-01, 7.905E-02, 5.093E-01, 1.591E-01},
    {1614, 1.3731, 0.000E+00, 0.000E+00, 0.000E+00, 6.501E+00, 5.319E+00, 3.305E-01, 7.890E-02, 5.095E-01, 1.592E-01},
    {1615, 1.3730, 0.000E+00, 0.000E+00, 0.000E+00, 6.474E+00, 5.301E+00, 3.303E-01, 7.875E-02, 5.096E-01, 1.592E-01},
    {1616, 1.3730, 0.000E+00, 0.000E+00, 0.000E+00, 6.449E+00, 5.292E+00, 3.300E-01, 7.860E-02, 5.095E-01, 1.594E-01},
    {1617, 1.3731, 0.000E+00, 0.000E+00, 0.000E+00, 6.420E+00, 5.284E+00, 3.298E-01, 7.845E-02, 5.093E-01, 1.595E-01},
    {1618, 1.3730, 0.000E+00, 0.000E+00, 0.000E+00, 6.401E+00, 5.274E+00, 3.295E-01, 7.830E-02, 5.092E-01, 1.597E-01},
    {1619, 1.3732, 0.000E+00, 0.000E+00, 0.000E+00, 6.363E+00, 5.258E+00, 3.293E-01, 7.815E-02, 5.091E-01, 1.598E-01},
    {1620, 1.3731, 0.000E+00, 0.000E+00, 0.000E+00, 6.345E+00, 5.253E+00, 3.290E-01, 7.800E-02, 5.090E-01, 1.600E-01},
    {1621, 1.3730, 0.000E+00, 0.000E+00, 0.000E+00, 6.309E+00, 5.249E+00, 3.280E-01, 7.770E-02, 5.089E-01, 1.600E-01},
    {1622, 1.3729, 0.000E+00, 0.000E+00, 0.000E+00, 6.282E+00, 5.233E+00, 3.270E-01, 7.740E-02, 5.087E-01, 1.600E-01},
    {1623, 1.3728, 0.000E+00, 0.000E+00, 0.000E+00, 6.250E+00, 5.222E+00, 3.260E-01, 7.710E-02, 5.086E-01, 1.600E-01},
    {1624, 1.3727, 0.000E+00, 0.000E+00, 0.000E+00, 6.214E+00, 5.211E+00, 3.250E-01, 7.680E-02, 5.085E-01, 1.600E-01},
    {1625, 1.3726, 0.000E+00, 0.000E+00, 0.000E+00, 6.186E+00, 5.204E+00, 3.240E-01, 7.650E-02, 5.084E-01, 1.600E-01},
    {1626, 1.3725, 0.000E+00, 0.000E+00, 0.000E+00, 6.163E+00, 5.210E+00, 3.230E-01, 7.620E-02, 5.083E-01, 1.603E-01},
    {1627, 1.3726, 0.000E+00, 0.000E+00, 0.000E+00, 6.130E+00, 5.200E+00, 3.220E-01, 7.590E-02, 5.083E-01, 1.606E-01},
    {1628, 1.3725, 0.000E+00, 0.000E+00, 0.000E+00, 6.121E+00, 5.193E+00, 3.210E-01, 7.560E-02, 5.083E-01, 1.608E-01},
    {1629, 1.3726, 0.000E+00, 0.000E+00, 0.000E+00, 6.091E+00, 5.186E+00, 3.200E-01, 7.530E-02, 5.082E-01, 1.611E-01},
    {1630, 1.3726, 0.000E+00, 0.000E+00, 0.000E+00, 6.076E+00, 5.177E+00, 3.190E-01, 7.500E-02, 5.082E-01, 1.614E-01},
    {1631, 1.3724, 0.000E+00, 0.000E+00, 0.000E+00, 6.053E+00, 5.175E+00, 3.180E-01, 7.470E-02, 5.082E-01, 1.618E-01},
    {1632, 1.3719, 0.000E+00, 0.000E+00, 0.000E+00, 6.048E+00, 5.178E+00, 3.170E-01, 7.440E-02, 5.082E-01, 1.621E-01},
    {1633, 1.3718, 0.000E+00, 0.000E+00, 0.000E+00, 6.016E+00, 5.173E+00, 3.160E-01, 7.410E-02, 5.082E-01, 1.625E-01},
    {1634, 1.3716, 0.000E+00, 0.000E+00, 0.000E+00, 6.005E+00, 5.152E+00, 3.150E-01, 7.380E-02, 5.082E-01, 1.628E-01},
    {1635, 1.3715, 0.000E+00, 0.000E+00, 0.000E+00, 5.982E+00, 5.135E+00, 3.140E-01, 7.350E-02, 5.082E-01, 1.631E-01},
    {1636, 1.3712, 0.000E+00, 0.000E+00, 0.000E+00, 5.973E+00, 5.139E+00, 3.130E-01, 7.320E-02, 5.082E-01, 1.631E-01},
    {1637, 1.3713, 0.000E+00, 0.000E+00, 0.000E+00, 5.947E+00, 5.128E+00, 3.120E-01, 7.290E-02, 5.082E-01, 1.632E-01},
    {1638, 1.3711, 0.000E+00, 0.000E+00, 0.000E+00, 5.940E+00, 5.121E+00, 3.110E-01, 7.260E-02, 5.082E-01, 1.632E-01},
    {1639, 1.3710, 0.000E+00, 0.000E+00, 0.000E+00, 5.919E+00, 5.114E+00, 3.100E-01, 7.230E-02, 5.082E-01, 1.632E-01},
    {1640, 1.3707, 0.000E+00, 0.000E+00, 0.000E+00, 5.911E+00, 5.126E+00, 3.090E-01, 7.200E-02, 5.082E-01, 1.632E-01},
    {1641, 1.3708, 0.000E+00, 0.000E+00, 0.000E+00, 5.887E+00, 5.107E+00, 3.089E-01, 7.190E-02, 5.082E-01, 1.632E-01},
    {1642, 1.3707, 0.000E+00, 0.000E+00, 0.000E+00, 5.875E+00, 5.104E+00, 3.087E-01, 7.180E-02, 5.082E-01, 1.632E-01},
    {1643, 1.3708, 0.000E+00, 0.000E+00, 0.000E+00, 5.846E+00, 5.100E+00, 3.086E-01, 7.170E-02, 5.082E-01, 1.632E-01},
    {1644, 1.3708, 0.000E+00, 0.000E+00, 0.000E+00, 5.826E+00, 5.109E+00, 3.084E-01, 7.160E-02, 5.082E-01, 1.632E-01},
    {1645, 1.3710, 0.000E+00, 0.000E+00, 0.000E+00, 5.798E+00, 5.114E+00, 3.083E-01, 7.150E-02, 5.082E-01, 1.632E-01},
    {1646, 1.3712, 0.000E+00, 0.000E+00, 0.000E+00, 5.787E+00, 5.112E+00, 3.081E-01, 7.140E-02, 5.085E-01, 1.632E-01},
    {1647, 1.3715, 0.000E+00, 0.000E+00, 0.000E+00, 5.751E+00, 5.128E+00, 3.080E-01, 7.130E-02, 5.089E-01, 1.632E-01},
    {1648, 1.3715, 0.000E+00, 0.000E+00, 0.000E+00, 5.746E+00, 5.136E+00, 3.078E-01, 7.120E-02, 5.092E-01, 1.632E-01},
    {1649, 1.3716, 0.000E+00, 0.000E+00, 0.000E+00, 5.718E+00, 5.131E+00, 3.077E-01, 7.110E-02, 5.096E-01, 1.632E-01},
    {1650, 1.3714, 0.000E+00, 0.000E+00, 0.000E+00, 5.705E+00, 5.152E+00, 3.075E-01, 7.100E-02, 5.099E-01, 1.632E-01},
    {1651, 1.3714, 0.000E+00, 0.000E+00, 0.000E+00, 5.685E+00, 5.175E+00, 3.074E-01, 7.090E-02, 5.101E-01, 1.633E-01},
    {1652, 1.3712, 0.000E+00, 0.000E+00, 0.000E+00, 5.684E+00, 5.193E+00, 3.072E-01, 7.080E-02, 5.104E-01, 1.635E-01},
    {1653, 1.3713, 0.000E+00, 0.000E+00, 0.000E+00, 5.657E+00, 5.200E+00, 3.071E-01, 7.070E-02, 5.106E-01, 1.636E-01},
    {1654, 1.3709, 0.000E+00, 0.000E+00, 0.000E+00, 5.658E+00, 5.244E+00, 3.069E-01, 7.060E-02, 5.109E-01, 1.638E-01},
    {1655, 1.3708, 0.000E+00, 0.000E+00, 0.000E+00, 5.644E+00, 5.257E+00, 3.068E-01, 7.050E-02, 5.111E-01, 1.639E-01},
    {1656, 1.3704, 0.000E+00, 0.000E+00, 0.000E+00, 5.648E+00, 5.273E+00, 3.066E-01, 7.040E-02, 5.109E-01, 1.639E-01},
    {1657, 1.3704, 0.000E+00, 0.000E+00, 0.000E+00, 5.626E+00, 5.289E+00, 3.065E-01, 7.030E-02, 5.107E-01, 1.639E-01},
    {1658, 1.3700, 0.000E+00, 0.000E+00, 0.000E+00, 5.626E+00, 5.335E+00, 3.063E-01, 7.020E-02, 5.106E-01, 1.639E-01},
    {1659, 1.3698, 0.000E+00, 0.000E+00, 0.000E+00, 5.619E+00, 5.366E+00, 3.062E-01, 7.010E-02, 5.104E-01, 1.639E-01},
    {1660, 1.3695, 0.000E+00, 0.000E+00, 0.000E+00, 5.618E+00, 5.389E+00, 3.060E-01, 7.000E-02, 5.102E-01, 1.639E-01},
    {1661, 1.3694, 0.000E+00, 0.000E+00, 0.000E+00, 5.603E+00, 5.427E+00, 3.054E-01, 6.975E-02, 5.100E-01, 1.639E-01},
    {1662, 1.3692, 0.000E+00, 0.000E+00, 0.000E+00, 5.614E+00, 5.453E+00, 3.047E-01, 6.950E-02, 5.098E-01, 1.639E-01},
    {1663, 1.3690, 0.000E+00, 0.000E+00, 0.000E+00, 5.597E+00, 5.490E+00, 3.041E-01, 6.925E-02, 5.097E-01, 1.639E-01},
    {1664, 1.3687, 0.000E+00, 0.000E+00, 0.000E+00, 5.603E+00, 5.522E+00, 3.034E-01, 6.900E-02, 5.095E-01, 1.639E-01},
    {1665, 1.3687, 0.000E+00, 0.000E+00, 0.000E+00, 5.582E+00, 5.562E+00, 3.028E-01, 6.875E-02, 5.093E-01, 1.639E-01},
    {1666, 1.3684, 0.000E+00, 0.000E+00, 0.000E+00, 5.584E+00, 5.605E+00, 3.021E-01, 6.850E-02, 5.091E-01, 1.639E-01},
    {1667, 1.3685, 0.000E+00, 0.000E+00, 0.000E+00, 5.564E+00, 5.652E+00, 3.015E-01, 6.825E-02, 5.090E-01, 1.639E-01},
    {1668, 1.3684, 0.000E+00, 0.000E+00, 0.000E+00, 5.563E+00, 5.698E+00, 3.008E-01, 6.800E-02, 5.088E-01, 1.639E-01},
    {1669, 1.3683, 0.000E+00, 0.000E+00, 0.000E+00, 5.547E+00, 5.744E+00, 3.002E-01, 6.775E-02, 5.086E-01, 1.639E-01},
    {1670, 1.3683, 0.000E+00, 0.000E+00, 0.000E+00, 5.545E+00, 5.743E+00, 2.995E-01, 6.750E-02, 5.084E-01, 1.639E-01},
    {1671, 1.3687, 0.000E+00, 0.000E+00, 0.000E+00, 5.536E+00, 5.642E+00, 2.989E-01, 6.725E-02, 5.083E-01, 1.639E-01},
    {1672, 1.3681, 0.000E+00, 0.000E+00, 0.000E+00, 5.542E+00, 5.689E+00, 2.982E-01, 6.700E-02, 5.083E-01, 1.639E-01},
    {1673, 1.3678, 0.000E+00, 0.000E+00, 0.000E+00, 5.529E+00, 5.722E+00, 2.976E-01, 6.675E-02, 5.082E-01, 1.639E-01},
    {1674, 1.3674, 0.000E+00, 0.000E+00, 0.000E+00, 5.532E+00, 5.755E+00, 2.969E-01, 6.650E-02, 5.081E-01, 1.639E-01},
    {1675, 1.3670, 0.000E+00, 0.000E+00, 0.000E+00, 5.525E+00, 5.798E+00, 2.963E-01, 6.625E-02, 5.081E-01, 1.639E-01},
    {1676, 1.3665, 0.000E+00, 0.000E+00, 0.000E+00, 5.533E+00, 5.847E+00, 2.956E-01, 6.600E-02, 5.081E-01, 1.639E-01},
    {1677, 1.3665, 0.000E+00, 0.000E+00, 0.000E+00, 5.528E+00, 5.875E+00, 2.950E-01, 6.575E-02, 5.081E-01, 1.639E-01},
    {1678, 1.3664, 0.000E+00, 0.000E+00, 0.000E+00, 5.529E+00, 5.918E+00, 2.943E-01, 6.550E-02, 5.080E-01, 1.638E-01},
    {1679, 1.3663, 0.000E+00, 0.000E+00, 0.000E+00, 5.516E+00, 5.971E+00, 2.937E-01, 6.525E-02, 5.080E-01, 1.638E-01},
    {1680, 1.3659, 0.000E+00, 0.000E+00, 0.000E+00, 5.524E+00, 6.022E+00, 2.930E-01, 6.500E-02, 5.080E-01, 1.638E-01},
    {1681, 1.3659, 0.000E+00, 0.000E+00, 0.000E+00, 5.516E+00, 6.061E+00, 2.923E-01, 6.480E-02, 5.080E-01, 1.639E-01},
    {1682, 1.3656, 0.000E+00, 0.000E+00, 0.000E+00, 5.526E+00, 6.116E+00, 2.915E-01, 6.460E-02, 5.080E-01, 1.640E-01},
    {1683, 1.3655, 0.000E+00, 0.000E+00, 0.000E+00, 5.520E+00, 6.173E+00, 2.908E-01, 6.440E-02, 5.080E-01, 1.641E-01},
    {1684, 1.3654, 0.000E+00, 0.000E+00, 0.000E+00, 5.520E+00, 6.214E+00, 2.900E-01, 6.420E-02, 5.080E-01, 1.641E-01},
    {1685, 1.3655, 0.000E+00, 0.000E+00, 0.000E+00, 5.516E+00, 6.266E+00, 2.893E-01, 6.400E-02, 5.080E-01, 1.642E-01},
    {1686, 1.3654, 0.000E+00, 0.000E+00, 0.000E+00, 5.522E+00, 6.319E+00, 2.885E-01, 6.380E-02, 5.080E-01, 1.642E-01},
    {1687, 1.3654, 0.000E+00, 0.000E+00, 0.000E+00, 5.511E+00, 6.381E+00, 2.878E-01, 6.360E-02, 5.080E-01, 1.642E-01},
    {1688, 1.3651, 0.000E+00, 0.000E+00, 0.000E+00, 5.527E+00, 6.426E+00, 2.870E-01, 6.340E-02, 5.080E-01, 1.642E-01},
    {1689, 1.3651, 0.000E+00, 0.000E+00, 0.000E+00, 5.511E+00, 6.486E+00, 2.863E-01, 6.320E-02, 5.080E-01, 1.642E-01},
    {1690, 1.3648, 0.000E+00, 0.000E+00, 0.000E+00, 5.519E+00, 6.541E+00, 2.855E-01, 6.300E-02, 5.080E-01, 1.642E-01},
    {1691, 1.3648, 0.000E+00, 0.000E+00, 0.000E+00, 5.515E+00, 6.579E+00, 2.848E-01, 6.280E-02, 5.082E-01, 1.643E-01},
    {1692, 1.3647, 0.000E+00, 0.000E+00, 0.000E+00, 5.520E+00, 6.616E+00, 2.840E-01, 6.260E-02, 5.084E-01, 1.643E-01},
    {1693, 1.3648, 0.000E+00, 0.000E+00, 0.000E+00, 5.510E+00, 6.666E+00, 2.833E-01, 6.240E-02, 5.086E-01, 1.644E-01},
    {1694, 1.3647, 0.000E+00, 0.000E+00, 0.000E+00, 5.518E+00, 6.728E+00, 2.825E-01, 6.220E-02, 5.088E-01, 1.645E-01},
    {1695, 1.3647, 0.000E+00, 0.000E+00, 0.000E+00, 5.523E+00, 6.771E+00, 2.818E-01, 6.200E-02, 5.090E-01, 1.645E-01},
    {1696, 1.3646, 0.000E+00, 0.000E+00, 0.000E+00, 5.538E+00, 6.807E+00, 2.810E-01, 6.180E-02, 5.093E-01, 1.645E-01},
    {1697, 1.3647, 0.000E+00, 0.000E+00, 0.000E+00, 5.535E+00, 6.858E+00, 2.803E-01, 6.160E-02, 5.095E-01, 1.645E-01},
    {1698, 1.3646, 0.000E+00, 0.000E+00, 0.000E+00, 5.544E+00, 6.907E+00, 2.795E-01, 6.140E-02, 5.098E-01, 1.645E-01},
    {1699, 1.3644, 0.000E+00, 0.000E+00, 0.000E+00, 5.557E+00, 6.959E+00, 2.788E-01, 6.120E-02, 5.101E-01, 1.645E-01},
    {1700, 1.3640, 0.000E+00, 0.000E+00, 0.000E+00, 5.571E+00, 7.006E+00, 2.780E-01, 6.100E-02, 5.103E-01, 1.645E-01},
    {1701, 1.3638, 0.000E+00, 0.000E+00, 0.000E+00, 5.583E+00, 7.052E+00, 2.777E-01, 6.090E-02, 5.106E-01, 1.645E-01},
    {1702, 1.3635, 0.000E+00, 0.000E+00, 0.000E+00, 5.606E+00, 7.093E+00, 2.774E-01, 6.080E-02, 5.108E-01, 1.645E-01},
    {1703, 1.3634, 0.000E+00, 0.000E+00, 0.000E+00, 5.607E+00, 7.136E+00, 2.771E-01, 6.070E-02, 5.111E-01, 1.645E-01},
    {1704, 1.3632, 0.000E+00, 0.000E+00, 0.000E+00, 5.629E+00, 7.164E+00, 2.768E-01, 6.060E-02, 5.114E-01, 1.645E-01},
    {1705, 1.3631, 0.000E+00, 0.000E+00, 0.000E+00, 5.636E+00, 7.199E+00, 2.765E-01, 6.050E-02, 5.116E-01, 1.645E-01},
    {1706, 1.3628, 0.000E+00, 0.000E+00, 0.000E+00, 5.664E+00, 7.232E+00, 2.762E-01, 6.040E-02, 5.117E-01, 1.645E-01},
    {1707, 1.3629, 0.000E+00, 0.000E+00, 0.000E+00, 5.670E+00, 7.266E+00, 2.759E-01, 6.030E-02, 5.118E-01, 1.645E-01},
    {1708, 1.3627, 0.000E+00, 0.000E+00, 0.000E+00, 5.693E+00, 7.315E+00, 2.756E-01, 6.020E-02, 5.119E-01, 1.645E-01},
    {1709, 1.3629, 0.000E+00, 0.000E+00, 0.000E+00, 5.702E+00, 7.340E+00, 2.753E-01, 6.010E-02, 5.120E-01, 1.645E-01},
    {1710, 1.3629, 0.000E+00, 0.000E+00, 0.000E+00, 5.733E+00, 7.361E+00, 2.750E-01, 6.000E-02, 5.121E-01, 1.645E-01},
    {1711, 1.3627, 0.000E+00, 0.000E+00, 0.000E+00, 5.752E+00, 7.399E+00, 2.747E-01, 5.990E-02, 5.122E-01, 1.645E-01},
    {1712, 1.3625, 0.000E+00, 0.000E+00, 0.000E+00, 5.766E+00, 7.440E+00, 2.744E-01, 5.980E-02, 5.122E-01, 1.645E-01},
    {1713, 1.3625, 0.000E+00, 0.000E+00, 0.000E+00, 5.776E+00, 7.473E+00, 2.741E-01, 5.970E-02, 5.122E-01, 1.645E-01},
    {1714, 1.3623, 0.000E+00, 0.000E+00, 0.000E+00, 5.797E+00, 7.505E+00, 2.738E-01, 5.960E-02, 5.123E-01, 1.645E-01},
    {1715, 1.3622, 0.000E+00, 0.000E+00, 0.000E+00, 5.811E+00, 7.525E+00, 2.735E-01, 5.950E-02, 5.123E-01, 1.645E-01},
    {1716, 1.3619, 0.000E+00, 0.000E+00, 0.000E+00, 5.829E+00, 7.557E+00, 2.732E-01, 5.940E-02, 5.120E-01, 1.642E-01},
    {1717, 1.3620, 0.000E+00, 0.000E+00, 0.000E+00, 5.842E+00, 7.579E+00, 2.729E-01, 5.930E-02, 5.116E-01, 1.639E-01},
    {1718, 1.3619, 0.000E+00, 0.000E+00, 0.000E+00, 5.877E+00, 7.604E+00, 2.726E-01, 5.920E-02, 5.113E-01, 1.636E-01},
    {1719, 1.3619, 0.000E+00, 0.000E+00, 0.000E+00, 5.891E+00, 7.633E+00, 2.723E-01, 5.910E-02, 5.110E-01, 1.633E-01},
    {1720, 1.3616, 0.000E+00, 0.000E+00, 0.000E+00, 5.930E+00, 7.653E+00, 2.720E-01, 5.900E-02, 5.107E-01, 1.630E-01},
    {1721, 1.3615, 0.000E+00, 0.000E+00, 0.000E+00, 5.945E+00, 7.674E+00, 2.689E-01, 5.830E-02, 5.104E-01, 1.630E-01},
    {1722, 1.3612, 0.000E+00, 0.000E+00, 0.000E+00, 5.972E+00, 7.691E+00, 2.658E-01, 5.760E-02, 5.102E-01, 1.630E-01},
    {1723, 1.3611, 0.000E+00, 0.000E+00, 0.000E+00, 5.999E+00, 7.699E+00, 2.627E-01, 5.690E-02, 5.100E-01, 1.630E-01},
    {1724, 1.3611, 0.000E+00, 0.000E+00, 0.000E+00, 6.025E+00, 7.708E+00, 2.596E-01, 5.620E-02, 5.098E-01, 1.630E-01},
    {1725, 1.3612, 0.000E+00, 0.000E+00, 0.000E+00, 6.051E+00, 7.721E+00, 2.565E-01, 5.550E-02, 5.095E-01, 1.630E-01},
    {1726, 1.3613, 0.000E+00, 0.000E+00, 0.000E+00, 6.087E+00, 7.730E+00, 2.534E-01, 5.480E-02, 5.096E-01, 1.629E-01},
    {1727, 1.3617, 0.000E+00, 0.000E+00, 0.000E+00, 6.096E+00, 7.729E+00, 2.503E-01, 5.410E-02, 5.096E-01, 1.627E-01},
    {1728, 1.3617, 0.000E+00, 0.000E+00, 0.000E+00, 6.136E+00, 7.712E+00, 2.472E-01, 5.340E-02, 5.097E-01, 1.626E-01},
    {1729, 1.3618, 0.000E+00, 0.000E+00, 0.000E+00, 6.166E+00, 7.702E+00, 2.441E-01, 5.270E-02, 5.097E-01, 1.624E-01},
    {1730, 1.3618, 0.000E+00, 0.000E+00, 0.000E+00, 6.198E+00, 7.695E+00, 2.410E-01, 5.200E-02, 5.098E-01, 1.623E-01},
    {1731, 1.3617, 0.000E+00, 0.000E+00, 0.000E+00, 6.219E+00, 7.670E+00, 2.379E-01, 5.130E-02, 5.095E-01, 1.623E-01},
    {1732, 1.3615, 0.000E+00, 0.000E+00, 0.000E+00, 6.256E+00, 7.644E+00, 2.348E-01, 5.060E-02, 5.092E-01, 1.623E-01},
    {1733, 1.3616, 0.000E+00, 0.000E+00, 0.000E+00, 6.284E+00, 7.618E+00, 2.317E-01, 4.990E-02, 5.089E-01, 1.623E-01},
    {1734, 1.3615, 0.000E+00, 0.000E+00, 0.000E+00, 6.335E+00, 7.585E+00, 2.286E-01, 4.920E-02, 5.086E-01, 1.623E-01},
    {1735, 1.3616, 0.000E+00, 0.000E+00, 0.000E+00, 6.369E+00, 7.555E+00, 2.255E-01, 4.850E-02, 5.083E-01, 1.623E-01},
    {1736, 1.3618, 0.000E+00, 0.000E+00, 0.000E+00, 6.392E+00, 7.517E+00, 2.224E-01, 4.780E-02, 5.085E-01, 1.617E-01},
    {1737, 1.3617, 0.000E+00, 0.000E+00, 0.000E+00, 6.445E+00, 7.479E+00, 2.193E-01, 4.710E-02, 5.086E-01, 1.612E-01},
    {1738, 1.3616, 0.000E+00, 0.000E+00, 0.000E+00, 6.493E+00, 7.451E+00, 2.162E-01, 4.640E-02, 5.088E-01, 1.607E-01},
    {1739, 1.3616, 0.000E+00, 0.000E+00, 0.000E+00, 6.517E+00, 7.435E+00, 2.131E-01, 4.570E-02, 5.090E-01, 1.602E-01},
    {1740, 1.3613, 0.000E+00, 0.000E+00, 0.000E+00, 6.571E+00, 7.408E+00, 2.100E-01, 4.500E-02, 5.091E-01, 1.597E-01},
    {1741, 1.3612, 0.000E+00, 0.000E+00, 0.000E+00, 6.617E+00, 7.379E+00, 2.119E-01, 4.535E-02, 5.092E-01, 1.597E-01},
    {1742, 1.3612, 0.000E+00, 0.000E+00, 0.000E+00, 6.658E+00, 7.363E+00, 2.138E-01, 4.570E-02, 5.093E-01, 1.597E-01},
    {1743, 1.3616, 0.000E+00, 0.000E+00, 0.000E+00, 6.689E+00, 7.347E+00, 2.157E-01, 4.605E-02, 5.094E-01, 1.597E-01},
    {1744, 1.3616, 0.000E+00, 0.000E+00, 0.000E+00, 6.748E+00, 7.332E+00, 2.176E-01, 4.640E-02, 5.095E-01, 1.597E-01},
    {1745, 1.3617, 0.000E+00, 0.000E+00, 0.000E+00, 6.796E+00, 7.332E+00, 2.195E-01, 4.675E-02, 5.096E-01, 1.597E-01},
    {1746, 1.3618, 0.000E+00, 0.000E+00, 0.000E+00, 6.842E+00, 7.332E+00, 2.214E-01, 4.710E-02, 5.096E-01, 1.597E-01},
    {1747, 1.3621, 0.000E+00, 0.000E+00, 0.000E+00, 6.897E+00, 7.304E+00, 2.233E-01, 4.745E-02, 5.096E-01, 1.597E-01},
    {1748, 1.3623, 0.000E+00, 0.000E+00, 0.000E+00, 6.955E+00, 7.295E+00, 2.252E-01, 4.780E-02, 5.096E-01, 1.597E-01},
    {1749, 1.3625, 0.000E+00, 0.000E+00, 0.000E+00, 7.003E+00, 7.296E+00, 2.271E-01, 4.815E-02, 5.096E-01, 1.597E-01},
    {1750, 1.3626, 0.000E+00, 0.000E+00, 0.000E+00, 7.054E+00, 7.291E+00, 2.290E-01, 4.850E-02, 5.096E-01, 1.597E-01},
    {1751, 1.3626, 0.000E+00, 0.000E+00, 0.000E+00, 7.111E+00, 7.292E+00, 2.309E-01, 4.885E-02, 5.097E-01, 1.594E-01},
    {1752, 1.3625, 0.000E+00, 0.000E+00, 0.000E+00, 7.179E+00, 7.292E+00, 2.328E-01, 4.920E-02, 5.098E-01, 1.592E-01},
    {1753, 1.3627, 0.000E+00, 0.000E+00, 0.000E+00, 7.235E+00, 7.281E+00, 2.347E-01, 4.955E-02, 5.099E-01, 1.590E-01},
    {1754, 1.3633, 0.000E+00, 0.000E+00, 0.000E+00, 7.274E+00, 7.283E+00, 2.366E-01, 4.990E-02, 5.101E-01, 1.588E-01},
    {1755, 1.3637, 0.000E+00, 0.000E+00, 0.000E+00, 7.339E+00, 7.264E+00, 2.385E-01, 5.025E-02, 5.102E-01, 1.586E-01},
    {1756, 1.3637, 0.000E+00, 0.000E+00, 0.000E+00, 7.414E+00, 7.250E+00, 2.404E-01, 5.060E-02, 5.102E-01, 1.585E-01},
    {1757, 1.3636, 0.000E+00, 0.000E+00, 0.000E+00, 7.481E+00, 7.240E+00, 2.423E-01, 5.095E-02, 5.103E-01, 1.585E-01},
    {1758, 1.3635, 0.000E+00, 0.000E+00, 0.000E+00, 7.536E+00, 7.228E+00, 2.442E-01, 5.130E-02, 5.103E-01, 1.584E-01},
    {1759, 1.3633, 0.000E+00, 0.000E+00, 0.000E+00, 7.594E+00, 7.210E+00, 2.461E-01, 5.165E-02, 5.104E-01, 1.584E-01},
    {1760, 1.3630, 0.000E+00, 0.000E+00, 0.000E+00, 7.669E+00, 7.186E+00, 2.480E-01, 5.200E-02, 5.105E-01, 1.584E-01},
    {1761, 1.3629, 0.000E+00, 0.000E+00, 0.000E+00, 7.734E+00, 7.164E+00, 2.427E-01, 5.085E-02, 5.102E-01, 1.580E-01},
    {1762, 1.3632, 0.000E+00, 0.000E+00, 0.000E+00, 7.776E+00, 7.143E+00, 2.373E-01, 4.970E-02, 5.100E-01, 1.576E-01},
    {1763, 1.3636, 0.000E+00, 0.000E+00, 0.000E+00, 7.833E+00, 7.114E+00, 2.320E-01, 4.855E-02, 5.098E-01, 1.572E-01},
    {1764, 1.3641, 0.000E+00, 0.000E+00, 0.000E+00, 7.893E+00, 7.101E+00, 2.266E-01, 4.740E-02, 5.096E-01, 1.568E-01},
    {1765, 1.3646, 0.000E+00, 0.000E+00, 0.000E+00, 7.952E+00, 7.069E+00, 2.213E-01, 4.625E-02, 5.094E-01, 1.563E-01},
    {1766, 1.3651, 0.000E+00, 0.000E+00, 0.000E+00, 8.000E+00, 7.038E+00, 2.159E-01, 4.510E-02, 5.092E-01, 1.559E-01},
    {1767, 1.3653, 0.000E+00, 0.000E+00, 0.000E+00, 8.045E+00, 7.003E+00, 2.106E-01, 4.395E-02, 5.090E-01, 1.555E-01},
    {1768, 1.3648, 0.000E+00, 0.000E+00, 0.000E+00, 8.103E+00, 6.974E+00, 2.052E-01, 4.280E-02, 5.088E-01, 1.550E-01},
    {1769, 1.3640, 0.000E+00, 0.000E+00, 0.000E+00, 8.155E+00, 6.928E+00, 1.999E-01, 4.165E-02, 5.086E-01, 1.546E-01},
    {1770, 1.3630, 0.000E+00, 0.000E+00, 0.000E+00, 8.205E+00, 6.889E+00, 1.945E-01, 4.050E-02, 5.084E-01, 1.541E-01},
    {1771, 1.3620, 0.000E+00, 0.000E+00, 0.000E+00, 8.241E+00, 6.839E+00, 1.892E-01, 3.935E-02, 5.082E-01, 1.541E-01},
    {1772, 1.3615, 0.000E+00, 0.000E+00, 0.000E+00, 8.264E+00, 6.793E+00, 1.838E-01, 3.820E-02, 5.081E-01, 1.541E-01},
    {1773, 1.3608, 0.000E+00, 0.000E+00, 0.000E+00, 8.321E+00, 6.764E+00, 1.785E-01, 3.705E-02, 5.079E-01, 1.541E-01},
    {1774, 1.3608, 0.000E+00, 0.000E+00, 0.000E+00, 8.352E+00, 6.729E+00, 1.731E-01, 3.590E-02, 5.078E-01, 1.541E-01},
    {1775, 1.3611, 0.000E+00, 0.000E+00, 0.000E+00, 8.394E+00, 6.694E+00, 1.678E-01, 3.475E-02, 5.076E-01, 1.541E-01},
    {1776, 1.3617, 0.000E+00, 0.000E+00, 0.000E+00, 8.430E+00, 6.661E+00, 1.624E-01, 3.360E-02, 5.078E-01, 1.541E-01},
    {1777, 1.3628, 0.000E+00, 0.000E+00, 0.000E+00, 8.448E+00, 6.613E+00, 1.571E-01, 3.245E-02, 5.079E-01, 1.541E-01},
    {1778, 1.3638, 0.000E+00, 0.000E+00, 0.000E+00, 8.477E+00, 6.572E+00, 1.517E-01, 3.130E-02, 5.081E-01, 1.541E-01},
    {1779, 1.3645, 0.000E+00, 0.000E+00, 0.000E+00, 8.512E+00, 6.546E+00, 1.464E-01, 3.015E-02, 5.082E-01, 1.541E-01},
    {1780, 1.3649, 0.000E+00, 0.000E+00, 0.000E+00, 8.535E+00, 6.522E+00, 1.410E-01, 2.900E-02, 5.084E-01, 1.541E-01},
    {1781, 1.3646, 0.000E+00, 0.000E+00, 0.000E+00, 8.562E+00, 6.507E+00, 1.356E-01, 2.790E-02, 5.086E-01, 1.541E-01},
    {1782, 1.3637, 0.000E+00, 0.000E+00, 0.000E+00, 8.593E+00, 6.482E+00, 1.302E-01, 2.680E-02, 5.088E-01, 1.541E-01},
    {1783, 1.3625, 0.000E+00, 0.000E+00, 0.000E+00, 8.618E+00, 6.484E+00, 1.248E-01, 2.570E-02, 5.091E-01, 1.541E-01},
    {1784, 1.3613, 0.000E+00, 0.000E+00, 0.000E+00, 8.640E+00, 6.479E+00, 1.194E-01, 2.460E-02, 5.093E-01, 1.541E-01},
    {1785, 1.3601, 0.000E+00, 0.000E+00, 0.000E+00, 8.670E+00, 6.494E+00, 1.140E-01, 2.350E-02, 5.095E-01, 1.541E-01},
    {1786, 1.3595, 0.000E+00, 0.000E+00, 0.000E+00, 8.689E+00, 6.496E+00, 1.086E-01, 2.240E-02, 5.095E-01, 1.541E-01},
    {1787, 1.3593, 0.000E+00, 0.000E+00, 0.000E+00, 8.720E+00, 6.491E+00, 1.032E-01, 2.130E-02, 5.095E-01, 1.541E-01},
    {1788, 1.3599, 0.000E+00, 0.000E+00, 0.000E+00, 8.738E+00, 6.461E+00, 9.780E-02, 2.020E-02, 5.095E-01, 1.541E-01},
    {1789, 1.3607, 0.000E+00, 0.000E+00, 0.000E+00, 8.755E+00, 6.440E+00, 9.240E-02, 1.910E-02, 5.095E-01, 1.541E-01},
    {1790, 1.3614, 0.000E+00, 0.000E+00, 0.000E+00, 8.777E+00, 6.430E+00, 8.700E-02, 1.800E-02, 5.095E-01, 1.541E-01},
    {1791, 1.3623, 0.000E+00, 0.000E+00, 0.000E+00, 8.778E+00, 6.413E+00, 8.160E-02, 1.690E-02, 5.095E-01, 1.541E-01},
    {1792, 1.3627, 0.000E+00, 0.000E+00, 0.000E+00, 8.778E+00, 6.421E+00, 7.620E-02, 1.580E-02, 5.095E-01, 1.541E-01},
    {1793, 1.3627, 0.000E+00, 0.000E+00, 0.000E+00, 8.794E+00, 6.399E+00, 7.080E-02, 1.470E-02, 5.095E-01, 1.541E-01},
    {1794, 1.3624, 0.000E+00, 0.000E+00, 0.000E+00, 8.805E+00, 6.379E+00, 6.540E-02, 1.360E-02, 5.095E-01, 1.541E-01},
    {1795, 1.3622, 0.000E+00, 0.000E+00, 0.000E+00, 8.807E+00, 6.365E+00, 6.000E-02, 1.250E-02, 5.095E-01, 1.541E-01},
    {1796, 1.3619, 0.000E+00, 0.000E+00, 0.000E+00, 8.809E+00, 6.372E+00, 5.460E-02, 1.140E-02, 5.095E-01, 1.541E-01},
    {1797, 1.3616, 0.000E+00, 0.000E+00, 0.000E+00, 8.811E+00, 6.346E+00, 4.920E-02, 1.030E-02, 5.095E-01, 1.541E-01},
    {1798, 1.3616, 0.000E+00, 0.000E+00, 0.000E+00, 8.799E+00, 6.321E+00, 4.380E-02, 9.200E-03, 5.095E-01, 1.541E-01},
    {1799, 1.3617, 0.000E+00, 0.000E+00, 0.000E+00, 8.795E+00, 6.310E+00, 3.840E-02, 8.100E-03, 5.095E-01, 1.541E-01},
    {1800, 1.3619, 0.000E+00, 0.000E+00, 0.000E+00, 8.789E+00, 6.314E+00, 3.300E-02, 7.000E-03, 5.095E-01, 1.541E-01},
    {1801, 1.3621, 0.000E+00, 0.000E+00, 0.000E+00, 8.779E+00, 6.282E+00, 3.160E-02, 6.700E-03, 5.095E-01, 1.540E-01},
    {1802, 1.3622, 0.000E+00, 0.000E+00, 0.000E+00, 8.767E+00, 6.277E+00, 3.020E-02, 6.400E-03, 5.095E-01, 1.539E-01},
    {1803, 1.3626, 0.000E+00, 0.000E+00, 0.000E+00, 8.754E+00, 6.270E+00, 2.880E-02, 6.100E-03, 5.095E-01, 1.538E-01},
    {1804, 1.3630, 0.000E+00, 0.000E+00, 0.000E+00, 8.750E+00, 6.258E+00, 2.740E-02, 5.800E-03, 5.095E-01, 1.538E-01},
    {1805, 1.3635, 0.000E+00, 0.000E+00, 0.000E+00, 8.738E+00, 6.242E+00, 2.600E-02, 5.500E-03, 5.094E-01, 1.537E-01},
    {1806, 1.3637, 0.000E+00, 0.000E+00, 0.000E+00, 8.739E+00, 6.234E+00, 2.460E-02, 5.200E-03, 5.094E-01, 1.537E-01},
    {1807, 1.3639, 0.000E+00, 0.000E+00, 0.000E+00, 8.735E+00, 6.221E+00, 2.320E-02, 4.900E-03, 5.094E-01, 1.537E-01},
    {1808, 1.3636, 0.000E+00, 0.000E+00, 0.000E+00, 8.744E+00, 6.231E+00, 2.180E-02, 4.600E-03, 5.094E-01, 1.537E-01},
    {1809, 1.3632, 0.000E+00, 0.000E+00, 0.000E+00, 8.753E+00, 6.221E+00, 2.040E-02, 4.300E-03, 5.094E-01, 1.537E-01},
    {1810, 1.3629, 0.000E+00, 0.000E+00, 0.000E+00, 8.755E+00, 6.205E+00, 1.900E-02, 4.000E-03, 5.094E-01, 1.537E-01},
    {1811, 1.3625, 0.000E+00, 0.000E+00, 0.000E+00, 8.780E+00, 6.192E+00, 1.760E-02, 3.700E-03, 5.090E-01, 1.537E-01},
    {1812, 1.3623, 0.000E+00, 0.000E+00, 0.000E+00, 8.787E+00, 6.192E+00, 1.620E-02, 3.400E-03, 5.086E-01, 1.537E-01},
    {1813, 1.3625, 0.000E+00, 0.000E+00, 0.000E+00, 8.790E+00, 6.179E+00, 1.480E-02, 3.100E-03, 5.082E-01, 1.537E-01},
    {1814, 1.3628, 0.000E+00, 0.000E+00, 0.000E+00, 8.798E+00, 6.159E+00, 1.340E-02, 2.800E-03, 5.078E-01, 1.537E-01},
    {1815, 1.3634, 0.000E+00, 0.000E+00, 0.000E+00, 8.794E+00, 6.143E+00, 1.200E-02, 2.500E-03, 5.074E-01, 1.537E-01},
    {1816, 1.3638, 0.000E+00, 0.000E+00, 0.000E+00, 8.811E+00, 6.143E+00, 1.060E-02, 2.200E-03, 5.073E-01, 1.536E-01},
    {1817, 1.3645, 0.000E+00, 0.000E+00, 0.000E+00, 8.820E+00, 6.120E+00, 9.200E-03, 1.900E-03, 5.072E-01, 1.535E-01},
    {1818, 1.3649, 0.000E+00, 0.000E+00, 0.000E+00, 8.836E+00, 6.098E+00, 7.800E-03, 1.600E-03, 5.071E-01, 1.534E-01},
    {1819, 1.3652, 0.000E+00, 0.000E+00, 0.000E+00, 8.845E+00, 6.087E+00, 6.400E-03, 1.300E-03, 5.070E-01, 1.534E-01},
    {1820, 1.3652, 0.000E+00, 0.000E+00, 0.000E+00, 8.854E+00, 6.063E+00, 5.000E-03, 1.000E-03, 5.069E-01, 1.533E-01},
    {1821, 1.3650, 0.000E+00, 0.000E+00, 0.000E+00, 8.858E+00, 6.056E+00, 4.900E-03, 1.000E-03, 5.071E-01, 1.533E-01},
    {1822, 1.3645, 0.000E+00, 0.000E+00, 0.000E+00, 8.868E+00, 6.053E+00, 4.800E-03, 1.000E-03, 5.074E-01, 1.533E-01},
    {1823, 1.3642, 0.000E+00, 0.000E+00, 0.000E+00, 8.869E+00, 6.040E+00, 4.700E-03, 1.000E-03, 5.076E-01, 1.533E-01},
    {1824, 1.3639, 0.000E+00, 0.000E+00, 0.000E+00, 8.884E+00, 6.044E+00, 4.600E-03, 1.000E-03, 5.079E-01, 1.533E-01},
    {1825, 1.3638, 0.000E+00, 0.000E+00, 0.000E+00, 8.888E+00, 6.007E+00, 4.500E-03, 1.000E-03, 5.082E-01, 1.533E-01},
    {1826, 1.3636, 0.000E+00, 0.000E+00, 0.000E+00, 8.900E+00, 5.996E+00, 4.400E-03, 1.000E-03, 5.081E-01, 1.531E-01},
    {1827, 1.3634, 0.000E+00, 0.000E+00, 0.000E+00, 8.922E+00, 5.994E+00, 4.300E-03, 1.000E-03, 5.081E-01, 1.528E-01},
    {1828, 1.3631, 0.000E+00, 0.000E+00, 0.000E+00, 8.951E+00, 5.997E+00, 4.200E-03, 1.000E-03, 5.080E-01, 1.526E-01},
    {1829, 1.3632, 0.000E+00, 0.000E+00, 0.000E+00, 8.973E+00, 5.975E+00, 4.100E-03, 1.000E-03, 5.080E-01, 1.524E-01},
    {1830, 1.3631, 0.000E+00, 0.000E+00, 0.000E+00, 9.010E+00, 5.954E+00, 4.000E-03, 1.000E-03, 5.079E-01, 1.522E-01},
    {1831, 1.3630, 0.000E+00, 0.000E+00, 0.000E+00, 9.034E+00, 5.946E+00, 3.900E-03, 1.000E-03, 5.076E-01, 1.519E-01},
    {1832, 1.3624, 0.000E+00, 0.000E+00, 0.000E+00, 9.110E+00, 5.927E+00, 3.800E-03, 1.000E-03, 5.073E-01, 1.517E-01},
    {1833, 1.3623, 0.000E+00, 0.000E+00, 0.000E+00, 9.146E+00, 5.914E+00, 3.700E-03, 1.000E-03, 5.070E-01, 1.515E-01},
    {1834, 1.3623, 0.000E+00, 0.000E+00, 0.000E+00, 9.195E+00, 5.890E+00, 3.600E-03, 1.000E-03, 5.067E-01, 1.512E-01},
    {1835, 1.3623, 0.000E+00, 0.000E+00, 0.000E+00, 9.259E+00, 5.873E+00, 3.500E-03, 1.000E-03, 5.064E-01, 1.510E-01},
    {1836, 1.3626, 0.000E+00, 0.000E+00, 0.000E+00, 9.315E+00, 5.832E+00, 3.400E-03, 1.000E-03, 5.066E-01, 1.504E-01},
    {1837, 1.3629, 0.000E+00, 0.000E+00, 0.000E+00, 9.380E+00, 5.794E+00, 3.300E-03, 1.000E-03, 5.069E-01, 1.497E-01},
    {1838, 1.3629, 0.000E+00, 0.000E+00, 0.000E+00, 9.457E+00, 5.768E+00, 3.200E-03, 1.000E-03, 5.071E-01, 1.491E-01},
    {1839, 1.3630, 0.000E+00, 0.000E+00, 0.000E+00, 9.535E+00, 5.728E+00, 3.100E-03, 1.000E-03, 5.073E-01, 1.484E-01},
    {1840, 1.3628, 0.000E+00, 0.000E+00, 0.000E+00, 9.633E+00, 5.681E+00, 3.000E-03, 1.000E-03, 5.076E-01, 1.478E-01},
    {1841, 1.3622, 0.000E+00, 0.000E+00, 0.000E+00, 9.723E+00, 5.680E+00, 2.900E-03, 9.500E-04, 5.079E-01, 1.473E-01},
    {1842, 1.3615, 0.000E+00, 0.000E+00, 0.000E+00, 9.824E+00, 5.655E+00, 2.800E-03, 9.000E-04, 5.083E-01, 1.468E-01},
    {1843, 1.3607, 0.000E+00, 0.000E+00, 0.000E+00, 9.935E+00, 5.648E+00, 2.700E-03, 8.500E-04, 5.087E-01, 1.463E-01},
    {1844, 1.3601, 0.000E+00, 0.000E+00, 0.000E+00, 1.005E+01, 5.620E+00, 2.600E-03, 8.000E-04, 5.091E-01, 1.458E-01},
    {1845, 1.3597, 0.000E+00, 0.000E+00, 0.000E+00, 1.018E+01, 5.594E+00, 2.500E-03, 7.500E-04, 5.095E-01, 1.453E-01},
    {1846, 1.3597, 0.000E+00, 0.000E+00, 0.000E+00, 1.031E+01, 5.567E+00, 2.400E-03, 7.000E-04, 5.097E-01, 1.441E-01},
    {1847, 1.3599, 0.000E+00, 0.000E+00, 0.000E+00, 1.042E+01, 5.557E+00, 2.300E-03, 6.500E-04, 5.100E-01, 1.429E-01},
    {1848, 1.3597, 0.000E+00, 0.000E+00, 0.000E+00, 1.059E+01, 5.552E+00, 2.200E-03, 6.000E-04, 5.103E-01, 1.417E-01},
    {1849, 1.3597, 0.000E+00, 0.000E+00, 0.000E+00, 1.075E+01, 5.553E+00, 2.100E-03, 5.500E-04, 5.105E-01, 1.404E-01},
    {1850, 1.3595, 0.000E+00, 0.000E+00, 0.000E+00, 1.094E+01, 5.539E+00, 2.000E-03, 5.000E-04, 5.108E-01, 1.392E-01},
    {1851, 1.3599, 0.000E+00, 0.000E+00, 0.000E+00, 1.110E+01, 5.523E+00, 1.900E-03, 4.500E-04, 5.110E-01, 1.384E-01},
    {1852, 1.3593, 0.000E+00, 0.000E+00, 0.000E+00, 1.139E+01, 5.507E+00, 1.800E-03, 4.000E-04, 5.112E-01, 1.375E-01},
    {1853, 1.3597, 0.000E+00, 0.000E+00, 0.000E+00, 1.160E+01, 5.505E+00, 1.700E-03, 3.500E-04, 5.115E-01, 1.366E-01},
    {1854, 1.3602, 0.000E+00, 0.000E+00, 0.000E+00, 1.184E+01, 5.487E+00, 1.600E-03, 3.000E-04, 5.117E-01, 1.358E-01},
    {1855, 1.3613, 0.000E+00, 0.000E+00, 0.000E+00, 1.208E+01, 5.474E+00, 1.500E-03, 2.500E-04, 5.119E-01, 1.349E-01},
    {1856, 1.3625, 0.000E+00, 0.000E+00, 0.000E+00, 1.235E+01, 5.462E+00, 1.400E-03, 2.000E-04, 5.122E-01, 1.341E-01},
    {1857, 1.3633, 0.000E+00, 0.000E+00, 0.000E+00, 1.266E+01, 5.450E+00, 1.300E-03, 1.500E-04, 5.125E-01, 1.332E-01},
    {1858, 1.3638, 0.000E+00, 0.000E+00, 0.000E+00, 1.301E+01, 5.448E+00, 1.200E-03, 1.000E-04, 5.128E-01, 1.323E-01},
    {1859, 1.3645, 0.000E+00, 0.000E+00, 0.000E+00, 1.334E+01, 5.441E+00, 1.100E-03, 5.000E-05, 5.131E-01, 1.315E-01},
    {1860, 1.3643, 0.000E+00, 0.000E+00, 0.000E+00, 1.375E+01, 5.440E+00, 1.000E-03, 1.000E-04, 5.134E-01, 1.306E-01},
    {1861, 1.3648, 0.000E+00, 0.000E+00, 0.000E+00, 1.412E+01, 5.442E+00, 1.900E-03, 2.000E-04, 5.138E-01, 1.287E-01},
    {1862, 1.3629, 0.000E+00, 0.000E+00, 0.000E+00, 1.478E+01, 5.449E+00, 2.800E-03, 4.000E-04, 5.142E-01, 1.269E-01},
    {1863, 1.3632, 0.000E+00, 0.000E+00, 0.000E+00, 1.529E+01, 5.466E+00, 3.700E-03, 6.000E-04, 5.147E-01, 1.250E-01},
    {1864, 1.3635, 0.000E+00, 0.000E+00, 0.000E+00, 1.586E+01, 5.461E+00, 4.600E-03, 8.000E-04, 5.151E-01, 1.231E-01},
    {1865, 1.3645, 0.000E+00, 0.000E+00, 0.000E+00, 1.641E+01, 5.452E+00, 5.500E-03, 1.000E-03, 5.155E-01, 1.212E-01},
    {1866, 1.3647, 0.000E+00, 0.000E+00, 0.000E+00, 1.709E+01, 5.445E+00, 6.400E-03, 1.200E-03, 5.153E-01, 1.192E-01},
    {1867, 1.3662, 0.000E+00, 0.000E+00, 0.000E+00, 1.774E+01, 5.412E+00, 7.300E-03, 1.400E-03, 5.152E-01, 1.171E-01},
    {1868, 1.3668, 0.000E+00, 0.000E+00, 0.000E+00, 1.853E+01, 5.379E+00, 8.200E-03, 1.600E-03, 5.150E-01, 1.151E-01},
    {1869, 1.3684, 0.000E+00, 0.000E+00, 0.000E+00, 1.925E+01, 5.280E+00, 9.100E-03, 1.800E-03, 5.148E-01, 1.131E-01},
    {1870, 1.3653, 0.000E+00, 0.000E+00, 0.000E+00, 2.051E+01, 5.228E+00, 1.000E-02, 2.000E-03, 5.146E-01, 1.111E-01},
    {1871, 1.3658, 0.000E+00, 0.000E+00, 0.000E+00, 2.148E+01, 5.199E+00, 1.090E-02, 2.200E-03, 5.142E-01, 1.077E-01},
    {1872, 1.3663, 0.000E+00, 0.000E+00, 0.000E+00, 2.250E+01, 5.171E+00, 1.180E-02, 2.400E-03, 5.137E-01, 1.044E-01},
    {1873, 1.3663, 0.000E+00, 0.000E+00, 0.000E+00, 2.367E+01, 5.139E+00, 1.270E-02, 2.600E-03, 5.133E-01, 1.010E-01},
    {1874, 1.3671, 0.000E+00, 0.000E+00, 0.000E+00, 2.483E+01, 5.124E+00, 1.360E-02, 2.800E-03, 5.128E-01, 9.765E-02},
    {1875, 1.3668, 0.000E+00, 0.000E+00, 0.000E+00, 2.622E+01, 5.112E+00, 1.450E-02, 3.000E-03, 5.124E-01, 9.430E-02},
    {1876, 1.3680, 0.000E+00, 0.000E+00, 0.000E+00, 2.751E+01, 5.129E+00, 1.540E-02, 3.200E-03, 5.102E-01, 9.322E-02},
    {1877, 1.3626, 0.000E+00, 0.000E+00, 0.000E+00, 2.972E+01, 5.144E+00, 1.630E-02, 3.400E-03, 5.081E-01, 9.214E-02},
    {1878, 1.3620, 0.000E+00, 0.000E+00, 0.000E+00, 3.144E+01, 5.173E+00, 1.720E-02, 3.600E-03, 5.059E-01, 9.106E-02},
    {1879, 1.3624, 0.000E+00, 0.000E+00, 0.000E+00, 3.317E+01, 5.176E+00, 1.810E-02, 3.800E-03, 5.037E-01, 8.998E-02},
    {1880, 1.3627, 0.000E+00, 0.000E+00, 0.000E+00, 3.504E+01, 5.185E+00, 1.900E-02, 4.000E-03, 5.016E-01, 8.890E-02},
    {1881, 1.3617, 0.000E+00, 0.000E+00, 0.000E+00, 3.725E+01, 5.183E+00, 1.810E-02, 3.800E-03, 5.016E-01, 8.870E-02},
    {1882, 1.3628, 0.000E+00, 0.000E+00, 0.000E+00, 3.927E+01, 5.200E+00, 1.720E-02, 3.600E-03, 5.016E-01, 8.850E-02},
    {1883, 1.3562, 0.000E+00, 0.000E+00, 0.000E+00, 4.269E+01, 5.202E+00, 1.630E-02, 3.400E-03, 5.015E-01, 8.829E-02},
    {1884, 1.3557, 0.000E+00, 0.000E+00, 0.000E+00, 4.530E+01, 5.204E+00, 1.540E-02, 3.200E-03, 5.015E-01, 8.809E-02},
    {1885, 1.3558, 0.000E+00, 0.000E+00, 0.000E+00, 4.789E+01, 5.224E+00, 1.450E-02, 3.000E-03, 5.015E-01, 8.789E-02},
    {1886, 1.3559, 0.000E+00, 0.000E+00, 0.000E+00, 5.060E+01, 5.244E+00, 1.360E-02, 2.800E-03, 5.019E-01, 8.823E-02},
    {1887, 1.3555, 0.000E+00, 0.000E+00, 0.000E+00, 5.360E+01, 5.297E+00, 1.270E-02, 2.600E-03, 5.023E-01, 8.857E-02},
    {1888, 1.3508, 0.000E+00, 0.000E+00, 0.000E+00, 5.761E+01, 5.318E+00, 1.180E-02, 2.400E-03, 5.026E-01, 8.891E-02},
    {1889, 1.3504, 0.000E+00, 0.000E+00, 0.000E+00, 6.088E+01, 5.375E+00, 1.090E-02, 2.200E-03, 5.030E-01, 8.924E-02},
    {1890, 1.3511, 0.000E+00, 0.000E+00, 0.000E+00, 6.401E+01, 5.441E+00, 1.000E-02, 2.000E-03, 5.034E-01, 8.958E-02},
    {1891, 1.3520, 0.000E+00, 0.000E+00, 0.000E+00, 6.720E+01, 5.491E+00, 9.100E-03, 1.800E-03, 5.038E-01, 9.038E-02},
    {1892, 1.3525, 0.000E+00, 0.000E+00, 0.000E+00, 7.059E+01, 5.561E+00, 8.200E-03, 1.600E-03, 5.042E-01, 9.118E-02},
    {1893, 1.3493, 0.000E+00, 0.000E+00, 0.000E+00, 7.497E+01, 5.629E+00, 7.300E-03, 1.400E-03, 5.046E-01, 9.198E-02},
    {1894, 1.3503, 0.000E+00, 0.000E+00, 0.000E+00, 7.841E+01, 5.687E+00, 6.400E-03, 1.200E-03, 5.050E-01, 9.278E-02},
    {1895, 1.3524, 0.000E+00, 0.000E+00, 0.000E+00, 8.157E+01, 5.757E+00, 5.500E-03, 1.000E-03, 5.055E-01, 9.358E-02},
    {1896, 1.3546, 0.000E+00, 0.000E+00, 0.000E+00, 8.469E+01, 5.830E+00, 4.600E-03, 8.000E-04, 5.061E-01, 9.411E-02},
    {1897, 1.3578, 0.000E+00, 0.000E+00, 0.000E+00, 8.752E+01, 5.911E+00, 3.700E-03, 6.000E-04, 5.067E-01, 9.464E-02},
    {1898, 1.3556, 0.000E+00, 0.000E+00, 0.000E+00, 9.189E+01, 5.998E+00, 2.800E-03, 4.000E-04, 5.073E-01, 9.518E-02},
    {1899, 1.3583, 0.000E+00, 0.000E+00, 0.000E+00, 9.456E+01, 6.090E+00, 1.900E-03, 2.000E-04, 5.080E-01, 9.571E-02},
    {1900, 1.3601, 0.000E+00, 0.000E+00, 0.000E+00, 9.722E+01, 6.193E+00, 1.000E-03, 0.000E+00, 5.086E-01, 9.624E-02},
    {1901, 1.3610, 0.000E+00, 0.000E+00, 0.000E+00, 9.995E+01, 6.330E+00, 1.000E-03, 0.000E+00, 5.086E-01, 9.694E-02},
    {1902, 1.3595, 0.000E+00, 0.000E+00, 0.000E+00, 1.033E+02, 6.449E+00, 1.000E-03, 0.000E+00, 5.086E-01, 9.765E-02},
    {1903, 1.3599, 0.000E+00, 0.000E+00, 0.000E+00, 1.057E+02, 6.581E+00, 1.000E-03, 0.000E+00, 5.085E-01, 9.835E-02},
    {1904, 1.3606, 0.000E+00, 0.000E+00, 0.000E+00, 1.078E+02, 6.710E+00, 1.000E-03, 0.000E+00, 5.085E-01, 9.905E-02},
    {1905, 1.3611, 0.000E+00, 0.000E+00, 0.000E+00, 1.097E+02, 6.838E+00, 1.000E-03, 0.000E+00, 5.085E-01, 9.975E-02},
    {1906, 1.3598, 0.000E+00, 0.000E+00, 0.000E+00, 1.123E+02, 6.970E+00, 1.000E-03, 0.000E+00, 5.081E-01, 9.931E-02},
    {1907, 1.3600, 0.000E+00, 0.000E+00, 0.000E+00, 1.140E+02, 7.107E+00, 1.000E-03, 0.000E+00, 5.076E-01, 9.886E-02},
    {1908, 1.3601, 0.000E+00, 0.000E+00, 0.000E+00, 1.157E+02, 7.238E+00, 1.000E-03, 0.000E+00, 5.072E-01, 9.842E-02},
    {1909, 1.3606, 0.000E+00, 0.000E+00, 0.000E+00, 1.171E+02, 7.388E+00, 1.000E-03, 0.000E+00, 5.068E-01, 9.797E-02},
    {1910, 1.3599, 0.000E+00, 0.000E+00, 0.000E+00, 1.190E+02, 7.506E+00, 1.000E-03, 0.000E+00, 5.064E-01, 9.752E-02},
    {1911, 1.3600, 0.000E+00, 0.000E+00, 0.000E+00, 1.203E+02, 7.635E+00, 1.000E-03, 0.000E+00, 5.059E-01, 9.511E-02},
    {1912, 1.3603, 0.000E+00, 0.000E+00, 0.000E+00, 1.215E+02, 7.767E+00, 1.000E-03, 0.000E+00, 5.055E-01, 9.269E-02},
    {1913, 1.3608, 0.000E+00, 0.000E+00, 0.000E+00, 1.226E+02, 7.874E+00, 1.000E-03, 0.000E+00, 5.051E-01, 9.027E-02},
    {1914, 1.3606, 0.000E+00, 0.000E+00, 0.000E+00, 1.240E+02, 7.977E+00, 1.000E-03, 0.000E+00, 5.047E-01, 8.786E-02},
    {1915, 1.3613, 0.000E+00, 0.000E+00, 0.000E+00, 1.248E+02, 8.071E+00, 1.000E-03, 0.000E+00, 5.042E-01, 8.544E-02},
    {1916, 1.3615, 0.000E+00, 0.000E+00, 0.000E+00, 1.257E+02, 8.150E+00, 1.000E-03, 0.000E+00, 5.038E-01, 8.363E-02},
    {1917, 1.3614, 0.000E+00, 0.000E+00, 0.000E+00, 1.265E+02, 8.220E+00, 1.000E-03, 0.000E+00, 5.034E-01, 8.182E-02},
    {1918, 1.3606, 0.000E+00, 0.000E+00, 0.000E+00, 1.275E+02, 8.292E+00, 1.000E-03, 0.000E+00, 5.030E-01, 8.002E-02},
    {1919, 1.3600, 0.000E+00, 0.000E+00, 0.000E+00, 1.281E+02, 8.350E+00, 1.000E-03, 0.000E+00, 5.027E-01, 7.821E-02},
    {1920, 1.3591, 0.000E+00, 0.000E+00, 0.000E+00, 1.286E+02, 8.449E+00, 1.000E-03, 0.000E+00, 5.023E-01, 7.640E-02},
    {1921, 1.3582, 0.000E+00, 0.000E+00, 0.000E+00, 1.292E+02, 8.521E+00, 1.250E-03, 5.000E-05, 5.019E-01, 7.433E-02},
    {1922, 1.3573, 0.000E+00, 0.000E+00, 0.000E+00, 1.296E+02, 8.583E+00, 1.500E-03, 1.000E-04, 5.015E-01, 7.226E-02},
    {1923, 1.3564, 0.000E+00, 0.000E+00, 0.000E+00, 1.299E+02, 8.666E+00, 1.750E-03, 1.500E-04, 5.011E-01, 7.020E-02},
    {1924, 1.3556, 0.000E+00, 0.000E+00, 0.000E+00, 1.303E+02, 8.723E+00, 2.000E-03, 2.000E-04, 5.007E-01, 6.813E-02},
    {1925, 1.3547, 0.000E+00, 0.000E+00, 0.000E+00, 1.304E+02, 8.759E+00, 2.250E-03, 2.500E-04, 5.003E-01, 6.606E-02},
    {1926, 1.3538, 0.000E+00, 0.000E+00, 0.000E+00, 1.306E+02, 8.821E+00, 2.500E-03, 3.000E-04, 5.003E-01, 6.446E-02},
    {1927, 1.3530, 0.000E+00, 0.000E+00, 0.000E+00, 1.306E+02, 8.864E+00, 2.750E-03, 3.500E-04, 5.003E-01, 6.285E-02},
    {1928, 1.3522, 0.000E+00, 0.000E+00, 0.000E+00, 1.306E+02, 8.909E+00, 3.000E-03, 4.000E-04, 5.003E-01, 6.124E-02},
    {1929, 1.3513, 0.000E+00, 0.000E+00, 0.000E+00, 1.305E+02, 8.941E+00, 3.250E-03, 4.500E-04, 5.003E-01, 5.963E-02},
    {1930, 1.3505, 0.000E+00, 0.000E+00, 0.000E+00, 1.304E+02, 8.949E+00, 3.500E-03, 5.000E-04, 5.003E-01, 5.802E-02},
    {1931, 1.3497, 0.000E+00, 0.000E+00, 0.000E+00, 1.301E+02, 8.955E+00, 3.750E-03, 5.500E-04, 4.992E-01, 5.701E-02},
    {1932, 1.3489, 0.000E+00, 0.000E+00, 0.000E+00, 1.299E+02, 8.983E+00, 4.000E-03, 6.000E-04, 4.980E-01, 5.600E-02},
    {1933, 1.3481, 0.000E+00, 0.000E+00, 0.000E+00, 1.296E+02, 9.022E+00, 4.250E-03, 6.500E-04, 4.969E-01, 5.499E-02},
    {1934, 1.3473, 0.000E+00, 0.000E+00, 0.000E+00, 1.291E+02, 9.043E+00, 4.500E-03, 7.000E-04, 4.958E-01, 5.398E-02},
    {1935, 1.3465, 0.000E+00, 0.000E+00, 0.000E+00, 1.287E+02, 9.044E+00, 4.750E-03, 7.500E-04, 4.946E-01, 5.297E-02},
    {1936, 1.3457, 0.000E+00, 0.000E+00, 0.000E+00, 1.282E+02, 9.028E+00, 5.000E-03, 8.000E-04, 4.943E-01, 5.225E-02},
    {1937, 1.3450, 0.000E+00, 0.000E+00, 0.000E+00, 1.275E+02, 9.034E+00, 5.250E-03, 8.500E-04, 4.939E-01, 5.154E-02},
    {1938, 1.3442, 0.000E+00, 0.000E+00, 0.000E+00, 1.270E+02, 9.052E+00, 5.500E-03, 9.000E-04, 4.935E-01, 5.083E-02},
    {1939, 1.3434, 0.000E+00, 0.000E+00, 0.000E+00, 1.264E+02, 9.048E+00, 5.750E-03, 9.500E-04, 4.931E-01, 5.011E-02},
    {1940, 1.3427, 0.000E+00, 0.000E+00, 0.000E+00, 1.256E+02, 9.041E+00, 6.000E-03, 1.000E-03, 4.927E-01, 4.940E-02},
    {1941, 1.3420, 0.000E+00, 0.000E+00, 0.000E+00, 1.249E+02, 9.037E+00, 7.100E-03, 1.200E-03, 4.924E-01, 4.883E-02},
    {1942, 1.3412, 0.000E+00, 0.000E+00, 0.000E+00, 1.242E+02, 9.036E+00, 8.200E-03, 1.400E-03, 4.920E-01, 4.826E-02},
    {1943, 1.3405, 0.000E+00, 0.000E+00, 0.000E+00, 1.232E+02, 9.035E+00, 9.300E-03, 1.600E-03, 4.916E-01, 4.769E-02},
    {1944, 1.3398, 0.000E+00, 0.000E+00, 0.000E+00, 1.224E+02, 9.021E+00, 1.040E-02, 1.800E-03, 4.912E-01, 4.712E-02},
    {1945, 1.3391, 0.000E+00, 0.000E+00, 0.000E+00, 1.216E+02, 9.016E+00, 1.150E-02, 2.000E-03, 4.908E-01, 4.655E-02},
    {1946, 1.3384, 0.000E+00, 0.000E+00, 0.000E+00, 1.206E+02, 9.008E+00, 1.260E-02, 2.200E-03, 4.907E-01, 4.626E-02},
    {1947, 1.3377, 0.000E+00, 0.000E+00, 0.000E+00, 1.197E+02, 8.970E+00, 1.370E-02, 2.400E-03, 4.905E-01, 4.597E-02},
    {1948, 1.3371, 0.000E+00, 0.000E+00, 0.000E+00, 1.190E+02, 8.974E+00, 1.480E-02, 2.600E-03, 4.904E-01, 4.567E-02},
    {1949, 1.3364, 0.000E+00, 0.000E+00, 0.000E+00, 1.178E+02, 8.953E+00, 1.590E-02, 2.800E-03, 4.902E-01, 4.538E-02},
    {1950, 1.3357, 0.000E+00, 0.000E+00, 0.000E+00, 1.170E+02, 8.957E+00, 1.700E-02, 3.000E-03, 4.901E-01, 4.508E-02},
    {1951, 1.3351, 0.000E+00, 0.000E+00, 0.000E+00, 1.157E+02, 8.937E+00, 1.810E-02, 3.200E-03, 4.902E-01, 4.508E-02},
    {1952, 1.3344, 0.000E+00, 0.000E+00, 0.000E+00, 1.149E+02, 8.923E+00, 1.920E-02, 3.400E-03, 4.903E-01, 4.508E-02},
    {1953, 1.3338, 0.000E+00, 0.000E+00, 0.000E+00, 1.140E+02, 8.912E+00, 2.030E-02, 3.600E-03, 4.904E-01, 4.508E-02},
    {1954, 1.3332, 0.000E+00, 0.000E+00, 0.000E+00, 1.128E+02, 8.895E+00, 2.140E-02, 3.800E-03, 4.905E-01, 4.507E-02},
    {1955, 1.3326, 0.000E+00, 0.000E+00, 0.000E+00, 1.118E+02, 8.891E+00, 2.250E-02, 4.000E-03, 4.906E-01, 4.507E-02},
    {1956, 1.3320, 0.000E+00, 0.000E+00, 0.000E+00, 1.110E+02, 8.880E+00, 2.360E-02, 4.200E-03, 4.905E-01, 4.529E-02},
    {1957, 1.3314, 0.000E+00, 0.000E+00, 0.000E+00, 1.097E+02, 8.867E+00, 2.470E-02, 4.400E-03, 4.904E-01, 4.550E-02},
    {1958, 1.3308, 0.000E+00, 0.000E+00, 0.000E+00, 1.088E+02, 8.855E+00, 2.580E-02, 4.600E-03, 4.902E-01, 4.572E-02},
    {1959, 1.3302, 0.000E+00, 0.000E+00, 0.000E+00, 1.076E+02, 8.852E+00, 2.690E-02, 4.800E-03, 4.901E-01, 4.594E-02},
    {1960, 1.3297, 0.000E+00, 0.000E+00, 0.000E+00, 1.066E+02, 8.861E+00, 2.800E-02, 5.000E-03, 4.900E-01, 4.615E-02},
    {1961, 1.3291, 0.000E+00, 0.000E+00, 0.000E+00, 1.058E+02, 8.864E+00, 3.150E-02, 5.650E-03, 4.900E-01, 4.615E-02},
    {1962, 1.3286, 0.000E+00, 0.000E+00, 0.000E+00, 1.044E+02, 8.876E+00, 3.500E-02, 6.300E-03, 4.900E-01, 4.615E-02},
    {1963, 1.3280, 0.000E+00, 0.000E+00, 0.000E+00, 1.036E+02, 8.869E+00, 3.850E-02, 6.950E-03, 4.900E-01, 4.615E-02},
    {1964, 1.3275, 0.000E+00, 0.000E+00, 0.000E+00, 1.023E+02, 8.872E+00, 4.200E-02, 7.600E-03, 4.900E-01, 4.614E-02},
    {1965, 1.3270, 0.000E+00, 0.000E+00, 0.000E+00, 1.014E+02, 8.855E+00, 4.550E-02, 8.250E-03, 4.900E-01, 4.614E-02},
    {1966, 1.3265, 0.000E+00, 0.000E+00, 0.000E+00, 1.005E+02, 8.828E+00, 4.900E-02, 8.900E-03, 4.902E-01, 4.614E-02},
    {1967, 1.3260, 0.000E+00, 0.000E+00, 0.000E+00, 9.928E+01, 8.839E+00, 5.250E-02, 9.550E-03, 4.904E-01, 4.614E-02},
    {1968, 1.3255, 0.000E+00, 0.000E+00, 0.000E+00, 9.831E+01, 8.855E+00, 5.600E-02, 1.020E-02, 4.906E-01, 4.613E-02},
    {1969, 1.3251, 0.000E+00, 0.000E+00, 0.000E+00, 9.711E+01, 8.856E+00, 5.950E-02, 1.085E-02, 4.907E-01, 4.613E-02},
    {1970, 1.3246, 0.000E+00, 0.000E+00, 0.000E+00, 9.631E+01, 8.833E+00, 6.300E-02, 1.150E-02, 4.909E-01, 4.613E-02},
    {1971, 1.3242, 0.000E+00, 0.000E+00, 0.000E+00, 9.488E+01, 8.842E+00, 6.650E-02, 1.215E-02, 4.911E-01, 4.613E-02},
    {1972, 1.3237, 0.000E+00, 0.000E+00, 0.000E+00, 9.412E+01, 8.843E+00, 7.000E-02, 1.280E-02, 4.913E-01, 4.612E-02},
    {1973, 1.3233, 0.000E+00, 0.000E+00, 0.000E+00, 9.341E+01, 8.830E+00, 7.350E-02, 1.345E-02, 4.914E-01, 4.612E-02},
    {1974, 1.3229, 0.000E+00, 0.000E+00, 0.000E+00, 9.206E+01, 8.808E+00, 7.700E-02, 1.410E-02, 4.916E-01, 4.612E-02},
    {1975, 1.3225, 0.000E+00, 0.000E+00, 0.000E+00, 9.121E+01, 8.818E+00, 8.050E-02, 1.475E-02, 4.918E-01, 4.612E-02},
    {1976, 1.3221, 0.000E+00, 0.000E+00, 0.000E+00, 9.009E+01, 8.807E+00, 8.400E-02, 1.540E-02, 4.930E-01, 4.626E-02},
    {1977, 1.3217, 0.000E+00, 0.000E+00, 0.000E+00, 8.929E+01, 8.797E+00, 8.750E-02, 1.605E-02, 4.941E-01, 4.640E-02},
    {1978, 1.3213, 0.000E+00, 0.000E+00, 0.000E+00, 8.804E+01, 8.794E+00, 9.100E-02, 1.670E-02, 4.953E-01, 4.655E-02},
    {1979, 1.3209, 0.000E+00, 0.000E+00, 0.000E+00, 8.725E+01, 8.791E+00, 9.450E-02, 1.735E-02, 4.964E-01, 4.669E-02},
    {1980, 1.3206, 0.000E+00, 0.000E+00, 0.000E+00, 8.611E+01, 8.795E+00, 9.800E-02, 1.800E-02, 4.976E-01, 4.683E-02},
    {1981, 1.3203, 0.000E+00, 0.000E+00, 0.000E+00, 8.532E+01, 8.771E+00, 9.720E-02, 1.785E-02, 4.976E-01, 4.731E-02},
    {1982, 1.3199, 0.000E+00, 0.000E+00, 0.000E+00, 8.460E+01, 8.754E+00, 9.640E-02, 1.770E-02, 4.976E-01, 4.779E-02},
    {1983, 1.3196, 0.000E+00, 0.000E+00, 0.000E+00, 8.336E+01, 8.759E+00, 9.560E-02, 1.755E-02, 4.976E-01, 4.827E-02},
    {1984, 1.3193, 0.000E+00, 0.000E+00, 0.000E+00, 8.262E+01, 8.760E+00, 9.480E-02, 1.740E-02, 4.976E-01, 4.875E-02},
    {1985, 1.3190, 0.000E+00, 0.000E+00, 0.000E+00, 8.151E+01, 8.746E+00, 9.400E-02, 1.725E-02, 4.977E-01, 4.922E-02},
    {1986, 1.3187, 0.000E+00, 0.000E+00, 0.000E+00, 8.076E+01, 8.762E+00, 9.320E-02, 1.710E-02, 4.977E-01, 4.965E-02},
    {1987, 1.3185, 0.000E+00, 0.000E+00, 0.000E+00, 7.973E+01, 8.778E+00, 9.240E-02, 1.695E-02, 4.977E-01, 5.009E-02},
    {1988, 1.3182, 0.000E+00, 0.000E+00, 0.000E+00, 7.904E+01, 8.790E+00, 9.160E-02, 1.680E-02, 4.977E-01, 5.052E-02},
    {1989, 1.3180, 0.000E+00, 0.000E+00, 0.000E+00, 7.800E+01, 8.795E+00, 9.080E-02, 1.665E-02, 4.977E-01, 5.095E-02},
    {1990, 1.3177, 0.000E+00, 0.000E+00, 0.000E+00, 7.723E+01, 8.811E+00, 9.000E-02, 1.650E-02, 4.977E-01, 5.138E-02},
    {1991, 1.3175, 0.000E+00, 0.000E+00, 0.000E+00, 7.628E+01, 8.848E+00, 8.920E-02, 1.635E-02, 4.977E-01, 5.192E-02},
    {1992, 1.3173, 0.000E+00, 0.000E+00, 0.000E+00, 7.557E+01, 8.874E+00, 8.840E-02, 1.620E-02, 4.978E-01, 5.246E-02},
    {1993, 1.3171, 0.000E+00, 0.000E+00, 0.000E+00, 7.463E+01, 8.885E+00, 8.760E-02, 1.605E-02, 4.978E-01, 5.299E-02},
    {1994, 1.3169, 0.000E+00, 0.000E+00, 0.000E+00, 7.392E+01, 8.913E+00, 8.680E-02, 1.590E-02, 4.978E-01, 5.353E-02},
    {1995, 1.3168, 0.000E+00, 0.000E+00, 0.000E+00, 7.298E+01, 8.944E+00, 8.600E-02, 1.575E-02, 4.978E-01, 5.407E-02},
    {1996, 1.3166, 0.000E+00, 0.000E+00, 0.000E+00, 7.234E+01, 8.980E+00, 8.520E-02, 1.560E-02, 4.978E-01, 5.463E-02},
    {1997, 1.3165, 0.000E+00, 0.000E+00, 0.000E+00, 7.141E+01, 8.988E+00, 8.440E-02, 1.545E-02, 4.978E-01, 5.518E-02},
    {1998, 1.3163, 0.000E+00, 0.000E+00, 0.000E+00, 7.082E+01, 9.001E+00, 8.360E-02, 1.530E-02, 4.978E-01, 5.574E-02},
    {1999, 1.3162, 0.000E+00, 0.000E+00, 0.000E+00, 6.986E+01, 9.034E+00, 8.280E-02, 1.515E-02, 4.978E-01, 5.630E-02},
    {2000, 1.3161, 0.000E+00, 0.000E+00, 0.000E+00, 6.924E+01, 9.076E+00, 8.200E-02, 1.500E-02, 4.979E-01, 5.685E-02},
    {2001, 1.3160, 0.000E+00, 0.000E+00, 0.000E+00, 6.865E+01, 9.111E+00, 8.015E-02, 1.465E-02, 4.981E-01, 5.702E-02},
    {2002, 1.3159, 0.000E+00, 0.000E+00, 0.000E+00, 6.779E+01, 9.141E+00, 7.830E-02, 1.430E-02, 4.983E-01, 5.720E-02},
    {2003, 1.3159, 0.000E+00, 0.000E+00, 0.000E+00, 6.688E+01, 9.171E+00, 7.645E-02, 1.395E-02, 4.985E-01, 5.737E-02},
    {2004, 1.3158, 0.000E+00, 0.000E+00, 0.000E+00, 6.634E+01, 9.214E+00, 7.460E-02, 1.360E-02, 4.986E-01, 5.754E-02},
    {2005, 1.3157, 0.000E+00, 0.000E+00, 0.000E+00, 6.548E+01, 9.255E+00, 7.275E-02, 1.325E-02, 4.988E-01, 5.771E-02},
    {2006, 1.3156, 0.000E+00, 0.000E+00, 0.000E+00, 6.490E+01, 9.303E+00, 7.090E-02, 1.290E-02, 4.991E-01, 5.807E-02},
    {2007, 1.3155, 0.000E+00, 0.000E+00, 0.000E+00, 6.412E+01, 9.356E+00, 6.905E-02, 1.255E-02, 4.994E-01, 5.843E-02},
    {2008, 1.3154, 0.000E+00, 0.000E+00, 0.000E+00, 6.358E+01, 9.406E+00, 6.720E-02, 1.220E-02, 4.996E-01, 5.879E-02},
    {2009, 1.3153, 0.000E+00, 0.000E+00, 0.000E+00, 6.281E+01, 9.448E+00, 6.535E-02, 1.185E-02, 4.999E-01, 5.916E-02},
    {2010, 1.3152, 0.000E+00, 0.000E+00, 0.000E+00, 6.232E+01, 9.516E+00, 6.350E-02, 1.150E-02, 5.002E-01, 5.952E-02},
    {2011, 1.3151, 0.000E+00, 0.000E+00, 0.000E+00, 6.156E+01, 9.578E+00, 6.165E-02, 1.115E-02, 5.004E-01, 6.013E-02},
    {2012, 1.3150, 0.000E+00, 0.000E+00, 0.000E+00, 6.105E+01, 9.638E+00, 5.980E-02, 1.080E-02, 5.006E-01, 6.073E-02},
    {2013, 1.3150, 0.000E+00, 0.000E+00, 0.000E+00, 6.029E+01, 9.692E+00, 5.795E-02, 1.045E-02, 5.009E-01, 6.134E-02},
    {2014, 1.3149, 0.000E+00, 0.000E+00, 0.000E+00, 5.980E+01, 9.763E+00, 5.610E-02, 1.010E-02, 5.011E-01, 6.194E-02},
    {2015, 1.3148, 0.000E+00, 0.000E+00, 0.000E+00, 5.907E+01, 9.845E+00, 5.425E-02, 9.750E-03, 5.013E-01, 6.255E-02},
    {2016, 1.3147, 0.000E+00, 0.000E+00, 0.000E+00, 5.857E+01, 9.953E+00, 5.240E-02, 9.400E-03, 5.016E-01, 6.301E-02},
    {2017, 1.3146, 0.000E+00, 0.000E+00, 0.000E+00, 5.788E+01, 1.004E+01, 5.055E-02, 9.050E-03, 5.018E-01, 6.347E-02},
    {2018, 1.3146, 0.000E+00, 0.000E+00, 0.000E+00, 5.746E+01, 1.014E+01, 4.870E-02, 8.700E-03, 5.021E-01, 6.393E-02},
    {2019, 1.3145, 0.000E+00, 0.000E+00, 0.000E+00, 5.680E+01, 1.027E+01, 4.685E-02, 8.350E-03, 5.023E-01, 6.439E-02},
    {2020, 1.3144, 0.000E+00, 0.000E+00, 0.000E+00, 5.632E+01, 1.039E+01, 4.500E-02, 8.000E-03, 5.025E-01, 6.486E-02},
    {2021, 1.3143, 0.000E+00, 0.000E+00, 0.000E+00, 5.566E+01, 1.052E+01, 4.965E-02, 8.800E-03, 5.028E-01, 6.524E-02},
    {2022, 1.3142, 0.000E+00, 0.000E+00, 0.000E+00, 5.503E+01, 1.063E+01, 5.430E-02, 9.600E-03, 5.030E-01, 6.563E-02},
    {2023, 1.3141, 0.000E+00, 0.000E+00, 0.000E+00, 5.463E+01, 1.077E+01, 5.895E-02, 1.040E-02, 5.033E-01, 6.601E-02},
    {2024, 1.3140, 0.000E+00, 0.000E+00, 0.000E+00, 5.398E+01, 1.091E+01, 6.360E-02, 1.120E-02, 5.035E-01, 6.640E-02},
    {2025, 1.3139, 0.000E+00, 0.000E+00, 0.000E+00, 5.356E+01, 1.103E+01, 6.825E-02, 1.200E-02, 5.037E-01, 6.679E-02},
    {2026, 1.3138, 0.000E+00, 0.000E+00, 0.000E+00, 5.294E+01, 1.119E+01, 7.290E-02, 1.280E-02, 5.038E-01, 6.720E-02},
    {2027, 1.3137, 0.000E+00, 0.000E+00, 0.000E+00, 5.256E+01, 1.135E+01, 7.755E-02, 1.360E-02, 5.038E-01, 6.761E-02},
    {2028, 1.3136, 0.000E+00, 0.000E+00, 0.000E+00, 5.197E+01, 1.150E+01, 8.220E-02, 1.440E-02, 5.039E-01, 6.802E-02},
    {2029, 1.3135, 0.000E+00, 0.000E+00, 0.000E+00, 5.138E+01, 1.165E+01, 8.685E-02, 1.520E-02, 5.039E-01, 6.843E-02},
    {2030, 1.3134, 0.000E+00, 0.000E+00, 0.000E+00, 5.098E+01, 1.181E+01, 9.150E-02, 1.600E-02, 5.040E-01, 6.885E-02},
    {2031, 1.3133, 0.000E+00, 0.000E+00, 0.000E+00, 5.047E+01, 1.201E+01, 9.615E-02, 1.680E-02, 5.040E-01, 6.943E-02},
    {2032, 1.3132, 0.000E+00, 0.000E+00, 0.000E+00, 5.006E+01, 1.217E+01, 1.008E-01, 1.760E-02, 5.040E-01, 7.002E-02},
    {2033, 1.3131, 0.000E+00, 0.000E+00, 0.000E+00, 4.951E+01, 1.234E+01, 1.055E-01, 1.840E-02, 5.040E-01, 7.060E-02},
    {2034, 1.3130, 0.000E+00, 0.000E+00, 0.000E+00, 4.915E+01, 1.251E+01, 1.101E-01, 1.920E-02, 5.040E-01, 7.119E-02},
    {2035, 1.3129, 0.000E+00, 0.000E+00, 0.000E+00, 4.860E+01, 1.269E+01, 1.148E-01, 2.000E-02, 5.040E-01, 7.177E-02},
    {2036, 1.3128, 0.000E+00, 0.000E+00, 0.000E+00, 4.806E+01, 1.287E+01, 1.194E-01, 2.080E-02, 5.044E-01, 7.267E-02},
    {2037, 1.3127, 0.000E+00, 0.000E+00, 0.000E+00, 4.773E+01, 1.307E+01, 1.241E-01, 2.160E-02, 5.049E-01, 7.356E-02},
    {2038, 1.3126, 0.000E+00, 0.000E+00, 0.000E+00, 4.718E+01, 1.325E+01, 1.287E-01, 2.240E-02, 5.053E-01, 7.445E-02},
    {2039, 1.3125, 0.000E+00, 0.000E+00, 0.000E+00, 4.685E+01, 1.346E+01, 1.334E-01, 2.320E-02, 5.058E-01, 7.534E-02},
    {2040, 1.3124, 0.000E+00, 0.000E+00, 0.000E+00, 4.635E+01, 1.364E+01, 1.380E-01, 2.400E-02, 5.062E-01, 7.623E-02},
    {2041, 1.3123, 0.000E+00, 0.000E+00, 0.000E+00, 4.584E+01, 1.384E+01, 1.363E-01, 2.370E-02, 5.065E-01, 7.693E-02},
    {2042, 1.3122, 0.000E+00, 0.000E+00, 0.000E+00, 4.553E+01, 1.403E+01, 1.346E-01, 2.340E-02, 5.068E-01, 7.764E-02},
    {2043, 1.3121, 0.000E+00, 0.000E+00, 0.000E+00, 4.503E+01, 1.423E+01, 1.329E-01, 2.310E-02, 5.070E-01, 7.834E-02},
    {2044, 1.3120, 0.000E+00, 0.000E+00, 0.000E+00, 4.473E+01, 1.441E+01, 1.312E-01, 2.280E-02, 5.073E-01, 7.904E-02},
    {2045, 1.3119, 0.000E+00, 0.000E+00, 0.000E+00, 4.426E+01, 1.461E+01, 1.295E-01, 2.250E-02, 5.076E-01, 7.974E-02},
    {2046, 1.3118, 0.000E+00, 0.000E+00, 0.000E+00, 4.379E+01, 1.481E+01, 1.278E-01, 2.220E-02, 5.076E-01, 8.027E-02},
    {2047, 1.3117, 0.000E+00, 0.000E+00, 0.000E+00, 4.348E+01, 1.499E+01, 1.261E-01, 2.190E-02, 5.076E-01, 8.080E-02},
    {2048, 1.3116, 0.000E+00, 0.000E+00, 0.000E+00, 4.302E+01, 1.517E+01, 1.244E-01, 2.160E-02, 5.076E-01, 8.133E-02},
    {2049, 1.3115, 0.000E+00, 0.000E+00, 0.000E+00, 4.273E+01, 1.534E+01, 1.227E-01, 2.130E-02, 5.076E-01, 8.186E-02},
    {2050, 1.3114, 0.000E+00, 0.000E+00, 0.000E+00, 4.228E+01, 1.554E+01, 1.210E-01, 2.100E-02, 5.076E-01, 8.239E-02},
    {2051, 1.3113, 0.000E+00, 0.000E+00, 0.000E+00, 4.186E+01, 1.571E+01, 1.193E-01, 2.070E-02, 5.077E-01, 8.283E-02},
    {2052, 1.3112, 0.000E+00, 0.000E+00, 0.000E+00, 4.155E+01, 1.591E+01, 1.176E-01, 2.040E-02, 5.078E-01, 8.327E-02},
    {2053, 1.3110, 0.000E+00, 0.000E+00, 0.000E+00, 4.115E+01, 1.607E+01, 1.159E-01, 2.010E-02, 5.079E-01, 8.371E-02},
    {2054, 1.3109, 0.000E+00, 0.000E+00, 0.000E+00, 4.072E+01, 1.622E+01, 1.142E-01, 1.980E-02, 5.080E-01, 8.415E-02},
    {2055, 1.3108, 0.000E+00, 0.000E+00, 0.000E+00, 4.046E+01, 1.637E+01, 1.125E-01, 1.950E-02, 5.081E-01, 8.459E-02},
    {2056, 1.3107, 0.000E+00, 0.000E+00, 0.000E+00, 4.002E+01, 1.653E+01, 1.108E-01, 1.920E-02, 5.085E-01, 8.514E-02},
    {2057, 1.3106, 0.000E+00, 0.000E+00, 0.000E+00, 3.975E+01, 1.667E+01, 1.091E-01, 1.890E-02, 5.089E-01, 8.570E-02},
    {2058, 1.3105, 0.000E+00, 0.000E+00, 0.000E+00, 3.934E+01, 1.678E+01, 1.074E-01, 1.860E-02, 5.093E-01, 8.626E-02},
    {2059, 1.3104, 0.000E+00, 0.000E+00, 0.000E+00, 3.894E+01, 1.690E+01, 1.057E-01, 1.830E-02, 5.097E-01, 8.681E-02},
    {2060, 1.3103, 0.000E+00, 0.000E+00, 0.000E+00, 3.868E+01, 1.698E+01, 1.040E-01, 1.800E-02, 5.101E-01, 8.737E-02},
    {2061, 1.3102, 0.000E+00, 0.000E+00, 0.000E+00, 3.827E+01, 1.708E+01, 1.054E-01, 1.825E-02, 5.100E-01, 8.764E-02},
    {2062, 1.3101, 0.000E+00, 0.000E+00, 0.000E+00, 3.790E+01, 1.718E+01, 1.068E-01, 1.850E-02, 5.100E-01, 8.791E-02},
    {2063, 1.3099, 0.000E+00, 0.000E+00, 0.000E+00, 3.762E+01, 1.725E+01, 1.082E-01, 1.875E-02, 5.099E-01, 8.817E-02},
    {2064, 1.3098, 0.000E+00, 0.000E+00, 0.000E+00, 3.726E+01, 1.734E+01, 1.096E-01, 1.900E-02, 5.098E-01, 8.844E-02},
    {2065, 1.3097, 0.000E+00, 0.000E+00, 0.000E+00, 3.687E+01, 1.739E+01, 1.110E-01, 1.925E-02, 5.098E-01, 8.871E-02},
    {2066, 1.3096, 0.000E+00, 0.000E+00, 0.000E+00, 3.664E+01, 1.748E+01, 1.124E-01, 1.950E-02, 5.095E-01, 8.911E-02},
    {2067, 1.3095, 0.000E+00, 0.000E+00, 0.000E+00, 3.628E+01, 1.755E+01, 1.138E-01, 1.975E-02, 5.092E-01, 8.951E-02},
    {2068, 1.3094, 0.000E+00, 0.000E+00, 0.000E+00, 3.592E+01, 1.761E+01, 1.152E-01, 2.000E-02, 5.089E-01, 8.992E-02},
    {2069, 1.3093, 0.000E+00, 0.000E+00, 0.000E+00, 3.568E+01, 1.767E+01, 1.166E-01, 2.025E-02, 5.086E-01, 9.032E-02},
    {2070, 1.3092, 0.000E+00, 0.000E+00, 0.000E+00, 3.536E+01, 1.771E+01, 1.180E-01, 2.050E-02, 5.083E-01, 9.072E-02},
    {2071, 1.3091, 0.000E+00, 0.000E+00, 0.000E+00, 3.499E+01, 1.777E+01, 1.194E-01, 2.075E-02, 5.080E-01, 9.072E-02},
    {2072, 1.3090, 0.000E+00, 0.000E+00, 0.000E+00, 3.479E+01, 1.783E+01, 1.208E-01, 2.100E-02, 5.078E-01, 9.072E-02},
    {2073, 1.3088, 0.000E+00, 0.000E+00, 0.000E+00, 3.447E+01, 1.787E+01, 1.222E-01, 2.125E-02, 5.076E-01, 9.071E-02},
    {2074, 1.3087, 0.000E+00, 0.000E+00, 0.000E+00, 3.413E+01, 1.794E+01, 1.236E-01, 2.150E-02, 5.073E-01, 9.071E-02},
    {2075, 1.3086, 0.000E+00, 0.000E+00, 0.000E+00, 3.392E+01, 1.795E+01, 1.250E-01, 2.175E-02, 5.071E-01, 9.071E-02},
    {2076, 1.3085, 0.000E+00, 0.000E+00, 0.000E+00, 3.363E+01, 1.799E+01, 1.264E-01, 2.200E-02, 5.071E-01, 9.089E-02},
    {2077, 1.3084, 0.000E+00, 0.000E+00, 0.000E+00, 3.329E+01, 1.805E+01, 1.278E-01, 2.225E-02, 5.071E-01, 9.107E-02},
    {2078, 1.3082, 0.000E+00, 0.000E+00, 0.000E+00, 3.309E+01, 1.809E+01, 1.292E-01, 2.250E-02, 5.071E-01, 9.125E-02},
    {2079, 1.3081, 0.000E+00, 0.000E+00, 0.000E+00, 3.280E+01, 1.813E+01, 1.306E-01, 2.275E-02, 5.071E-01, 9.143E-02},
    {2080, 1.3080, 0.000E+00, 0.000E+00, 0.000E+00, 3.251E+01, 1.820E+01, 1.320E-01, 2.300E-02, 5.071E-01, 9.162E-02},
    {2081, 1.3079, 0.000E+00, 0.000E+00, 0.000E+00, 3.231E+01, 1.827E+01, 1.317E-01, 2.290E-02, 5.071E-01, 9.209E-02},
    {2082, 1.3078, 0.000E+00, 0.000E+00, 0.000E+00, 3.200E+01, 1.830E+01, 1.314E-01, 2.280E-02, 5.071E-01, 9.256E-02},
    {2083, 1.3076, 0.000E+00, 0.000E+00, 0.000E+00, 3.172E+01, 1.835E+01, 1.311E-01, 2.270E-02, 5.070E-01, 9.303E-02},
    {2084, 1.3075, 0.000E+00, 0.000E+00, 0.000E+00, 3.154E+01, 1.841E+01, 1.308E-01, 2.260E-02, 5.070E-01, 9.350E-02},
    {2085, 1.3074, 0.000E+00, 0.000E+00, 0.000E+00, 3.127E+01, 1.846E+01, 1.305E-01, 2.250E-02, 5.070E-01, 9.397E-02},
    {2086, 1.3073, 0.000E+00, 0.000E+00, 0.000E+00, 3.097E+01, 1.852E+01, 1.302E-01, 2.240E-02, 5.070E-01, 9.447E-02},
    {2087, 1.3072, 0.000E+00, 0.000E+00, 0.000E+00, 3.071E+01, 1.856E+01, 1.299E-01, 2.230E-02, 5.069E-01, 9.496E-02},
    {2088, 1.3070, 0.000E+00, 0.000E+00, 0.000E+00, 3.052E+01, 1.861E+01, 1.296E-01, 2.220E-02, 5.069E-01, 9.546E-02},
    {2089, 1.3069, 0.000E+00, 0.000E+00, 0.000E+00, 3.025E+01, 1.866E+01, 1.293E-01, 2.210E-02, 5.068E-01, 9.596E-02},
    {2090, 1.3068, 0.000E+00, 0.000E+00, 0.000E+00, 2.999E+01, 1.871E+01, 1.290E-01, 2.200E-02, 5.068E-01, 9.646E-02},
    {2091, 1.3067, 0.000E+00, 0.000E+00, 0.000E+00, 2.980E+01, 1.876E+01, 1.287E-01, 2.190E-02, 5.067E-01, 9.691E-02},
    {2092, 1.3066, 0.000E+00, 0.000E+00, 0.000E+00, 2.958E+01, 1.881E+01, 1.284E-01, 2.180E-02, 5.067E-01, 9.737E-02},
    {2093, 1.3064, 0.000E+00, 0.000E+00, 0.000E+00, 2.929E+01, 1.885E+01, 1.281E-01, 2.170E-02, 5.066E-01, 9.782E-02},
    {2094, 1.3063, 0.000E+00, 0.000E+00, 0.000E+00, 2.906E+01, 1.890E+01, 1.278E-01, 2.160E-02, 5.066E-01, 9.827E-02},
    {2095, 1.3062, 0.000E+00, 0.000E+00, 0.000E+00, 2.888E+01, 1.896E+01, 1.275E-01, 2.150E-02, 5.065E-01, 9.872E-02},
    {2096, 1.3061, 0.000E+00, 0.000E+00, 0.000E+00, 2.865E+01, 1.903E+01, 1.272E-01, 2.140E-02, 5.064E-01, 9.886E-02},
    {2097, 1.3060, 0.000E+00, 0.000E+00, 0.000E+00, 2.840E+01, 1.907E+01, 1.269E-01, 2.130E-02, 5.062E-01, 9.899E-02},
    {2098, 1.3059, 0.000E+00, 0.000E+00, 0.000E+00, 2.822E+01, 1.911E+01, 1.266E-01, 2.120E-02, 5.061E-01, 9.913E-02},
    {2099, 1.3058, 0.000E+00, 0.000E+00, 0.000E+00, 2.799E+01, 1.916E+01, 1.263E-01, 2.110E-02, 5.059E-01, 9.926E-02},
    {2100, 1.3057, 0.000E+00, 0.000E+00, 0.000E+00, 2.776E+01, 1.921E+01, 1.260E-01, 2.100E-02, 5.058E-01, 9.940E-02},
    {2101, 1.3056, 0.000E+00, 0.000E+00, 0.000E+00, 2.751E+01, 1.927E+01, 1.262E-01, 2.105E-02, 5.054E-01, 9.976E-02},
    {2102, 1.3055, 0.000E+00, 0.000E+00, 0.000E+00, 2.737E+01, 1.929E+01, 1.264E-01, 2.110E-02, 5.050E-01, 1.001E-01},
    {2103, 1.3053, 0.000E+00, 0.000E+00, 0.000E+00, 2.713E+01, 1.932E+01, 1.266E-01, 2.115E-02, 5.047E-01, 1.005E-01},
    {2104, 1.3052, 0.000E+00, 0.000E+00, 0.000E+00, 2.692E+01, 1.935E+01, 1.268E-01, 2.120E-02, 5.043E-01, 1.008E-01},
    {2105, 1.3051, 0.000E+00, 0.000E+00, 0.000E+00, 2.671E+01, 1.936E+01, 1.270E-01, 2.125E-02, 5.039E-01, 1.012E-01},
    {2106, 1.3050, 0.000E+00, 0.000E+00, 0.000E+00, 2.657E+01, 1.940E+01, 1.272E-01, 2.130E-02, 5.043E-01, 1.018E-01},
    {2107, 1.3049, 0.000E+00, 0.000E+00, 0.000E+00, 2.637E+01, 1.943E+01, 1.274E-01, 2.135E-02, 5.047E-01, 1.025E-01},
    {2108, 1.3047, 0.000E+00, 0.000E+00, 0.000E+00, 2.617E+01, 1.947E+01, 1.276E-01, 2.140E-02, 5.050E-01, 1.031E-01},
    {2109, 1.3046, 0.000E+00, 0.000E+00, 0.000E+00, 2.597E+01, 1.951E+01, 1.278E-01, 2.145E-02, 5.054E-01, 1.037E-01},
    {2110, 1.3045, 0.000E+00, 0.000E+00, 0.000E+00, 2.584E+01, 1.953E+01, 1.280E-01, 2.150E-02, 5.058E-01, 1.043E-01},
    {2111, 1.3044, 0.000E+00, 0.000E+00, 0.000E+00, 2.565E+01, 1.956E+01, 1.282E-01, 2.155E-02, 5.056E-01, 1.045E-01},
    {2112, 1.3043, 0.000E+00, 0.000E+00, 0.000E+00, 2.547E+01, 1.960E+01, 1.284E-01, 2.160E-02, 5.055E-01, 1.047E-01},
    {2113, 1.3041, 0.000E+00, 0.000E+00, 0.000E+00, 2.528E+01, 1.961E+01, 1.286E-01, 2.165E-02, 5.054E-01, 1.049E-01},
    {2114, 1.3040, 0.000E+00, 0.000E+00, 0.000E+00, 2.518E+01, 1.962E+01, 1.288E-01, 2.170E-02, 5.052E-01, 1.051E-01},
    {2115, 1.3039, 0.000E+00, 0.000E+00, 0.000E+00, 2.501E+01, 1.966E+01, 1.290E-01, 2.175E-02, 5.051E-01, 1.053E-01},
    {2116, 1.3038, 0.000E+00, 0.000E+00, 0.000E+00, 2.485E+01, 1.966E+01, 1.292E-01, 2.180E-02, 5.050E-01, 1.059E-01},
    {2117, 1.3037, 0.000E+00, 0.000E+00, 0.000E+00, 2.466E+01, 1.969E+01, 1.294E-01, 2.185E-02, 5.048E-01, 1.064E-01},
    {2118, 1.3035, 0.000E+00, 0.000E+00, 0.000E+00, 2.455E+01, 1.970E+01, 1.296E-01, 2.190E-02, 5.047E-01, 1.070E-01},
    {2119, 1.3034, 0.000E+00, 0.000E+00, 0.000E+00, 2.438E+01, 1.972E+01, 1.298E-01, 2.195E-02, 5.046E-01, 1.075E-01},
    {2120, 1.3033, 0.000E+00, 0.000E+00, 0.000E+00, 2.420E+01, 1.974E+01, 1.300E-01, 2.200E-02, 5.044E-01, 1.081E-01},
    {2121, 1.3032, 0.000E+00, 0.000E+00, 0.000E+00, 2.401E+01, 1.974E+01, 1.301E-01, 2.200E-02, 5.047E-01, 1.081E-01},
    {2122, 1.3031, 0.000E+00, 0.000E+00, 0.000E+00, 2.386E+01, 1.976E+01, 1.301E-01, 2.200E-02, 5.051E-01, 1.081E-01},
    {2123, 1.3029, 0.000E+00, 0.000E+00, 0.000E+00, 2.374E+01, 1.978E+01, 1.302E-01, 2.200E-02, 5.054E-01, 1.081E-01},
    {2124, 1.3028, 0.000E+00, 0.000E+00, 0.000E+00, 2.358E+01, 1.979E+01, 1.302E-01, 2.200E-02, 5.057E-01, 1.081E-01},
    {2125, 1.3027, 0.000E+00, 0.000E+00, 0.000E+00, 2.342E+01, 1.982E+01, 1.303E-01, 2.200E-02, 5.060E-01, 1.081E-01},
    {2126, 1.3026, 0.000E+00, 0.000E+00, 0.000E+00, 2.328E+01, 1.982E+01, 1.303E-01, 2.200E-02, 5.055E-01, 1.086E-01},
    {2127, 1.3025, 0.000E+00, 0.000E+00, 0.000E+00, 2.318E+01, 1.983E+01, 1.304E-01, 2.200E-02, 5.050E-01, 1.092E-01},
    {2128, 1.3023, 0.000E+00, 0.000E+00, 0.000E+00, 2.304E+01, 1.986E+01, 1.304E-01, 2.200E-02, 5.045E-01, 1.098E-01},
    {2129, 1.3022, 0.000E+00, 0.000E+00, 0.000E+00, 2.289E+01, 1.988E+01, 1.305E-01, 2.200E-02, 5.040E-01, 1.103E-01},
    {2130, 1.3021, 0.000E+00, 0.000E+00, 0.000E+00, 2.275E+01, 1.989E+01, 1.305E-01, 2.200E-02, 5.035E-01, 1.109E-01},
    {2131, 1.3020, 0.000E+00, 0.000E+00, 0.000E+00, 2.262E+01, 1.989E+01, 1.306E-01, 2.200E-02, 5.039E-01, 1.111E-01},
    {2132, 1.3019, 0.000E+00, 0.000E+00, 0.000E+00, 2.252E+01, 1.993E+01, 1.306E-01, 2.200E-02, 5.043E-01, 1.114E-01},
    {2133, 1.3017, 0.000E+00, 0.000E+00, 0.000E+00, 2.239E+01, 1.993E+01, 1.307E-01, 2.200E-02, 5.047E-01, 1.116E-01},
    {2134, 1.3016, 0.000E+00, 0.000E+00, 0.000E+00, 2.227E+01, 1.997E+01, 1.307E-01, 2.200E-02, 5.051E-01, 1.118E-01},
    {2135, 1.3015, 0.000E+00, 0.000E+00, 0.000E+00, 2.214E+01, 2.001E+01, 1.308E-01, 2.200E-02, 5.055E-01, 1.121E-01},
    {2136, 1.3014, 0.000E+00, 0.000E+00, 0.000E+00, 2.202E+01, 2.001E+01, 1.308E-01, 2.200E-02, 5.053E-01, 1.121E-01},
    {2137, 1.3013, 0.000E+00, 0.000E+00, 0.000E+00, 2.194E+01, 2.004E+01, 1.309E-01, 2.200E-02, 5.051E-01, 1.122E-01},
    {2138, 1.3011, 0.000E+00, 0.000E+00, 0.000E+00, 2.183E+01, 2.007E+01, 1.309E-01, 2.200E-02, 5.048E-01, 1.123E-01},
    {2139, 1.3010, 0.000E+00, 0.000E+00, 0.000E+00, 2.172E+01, 2.011E+01, 1.310E-01, 2.200E-02, 5.046E-01, 1.124E-01},
    {2140, 1.3009, 0.000E+00, 0.000E+00, 0.000E+00, 2.162E+01, 2.013E+01, 1.310E-01, 2.200E-02, 5.044E-01, 1.124E-01},
    {2141, 1.3008, 0.000E+00, 0.000E+00, 0.000E+00, 2.150E+01, 2.015E+01, 1.301E-01, 2.185E-02, 5.041E-01, 1.128E-01},
    {2142, 1.3007, 0.000E+00, 0.000E+00, 0.000E+00, 2.140E+01, 2.017E+01, 1.292E-01, 2.170E-02, 5.037E-01, 1.132E-01},
    {2143, 1.3005, 0.000E+00, 0.000E+00, 0.000E+00, 2.133E+01, 2.019E+01, 1.283E-01, 2.155E-02, 5.034E-01, 1.136E-01},
    {2144, 1.3004, 0.000E+00, 0.000E+00, 0.000E+00, 2.123E+01, 2.022E+01, 1.274E-01, 2.140E-02, 5.031E-01, 1.140E-01},
    {2145, 1.3003, 0.000E+00, 0.000E+00, 0.000E+00, 2.112E+01, 2.023E+01, 1.265E-01, 2.125E-02, 5.028E-01, 1.144E-01},
    {2146, 1.3002, 0.000E+00, 0.000E+00, 0.000E+00, 2.102E+01, 2.023E+01, 1.256E-01, 2.110E-02, 5.024E-01, 1.145E-01},
    {2147, 1.3001, 0.000E+00, 0.000E+00, 0.000E+00, 2.091E+01, 2.026E+01, 1.247E-01, 2.095E-02, 5.021E-01, 1.146E-01},
    {2148, 1.2999, 0.000E+00, 0.000E+00, 0.000E+00, 2.085E+01, 2.027E+01, 1.238E-01, 2.080E-02, 5.018E-01, 1.147E-01},
    {2149, 1.2998, 0.000E+00, 0.000E+00, 0.000E+00, 2.077E+01, 2.029E+01, 1.229E-01, 2.065E-02, 5.015E-01, 1.148E-01},
    {2150, 1.2997, 0.000E+00, 0.000E+00, 0.000E+00, 2.067E+01, 2.028E+01, 1.220E-01, 2.050E-02, 5.011E-01, 1.150E-01},
    {2151, 1.2996, 0.000E+00, 0.000E+00, 0.000E+00, 2.058E+01, 2.027E+01, 1.211E-01, 2.035E-02, 5.009E-01, 1.149E-01},
    {2152, 1.2995, 0.000E+00, 0.000E+00, 0.000E+00, 2.049E+01, 2.029E+01, 1.202E-01, 2.020E-02, 5.007E-01, 1.149E-01},
    {2153, 1.2993, 0.000E+00, 0.000E+00, 0.000E+00, 2.040E+01, 2.029E+01, 1.193E-01, 2.005E-02, 5.005E-01, 1.149E-01},
    {2154, 1.2992, 0.000E+00, 0.000E+00, 0.000E+00, 2.033E+01, 2.031E+01, 1.184E-01, 1.990E-02, 5.003E-01, 1.149E-01},
    {2155, 1.2991, 0.000E+00, 0.000E+00, 0.000E+00, 2.027E+01, 2.029E+01, 1.175E-01, 1.975E-02, 5.000E-01, 1.149E-01},
    {2156, 1.2990, 0.000E+00, 0.000E+00, 0.000E+00, 2.018E+01, 2.026E+01, 1.166E-01, 1.960E-02, 4.998E-01, 1.149E-01},
    {2157, 1.2989, 0.000E+00, 0.000E+00, 0.000E+00, 2.010E+01, 2.030E+01, 1.157E-01, 1.945E-02, 4.996E-01, 1.149E-01},
    {2158, 1.2987, 0.000E+00, 0.000E+00, 0.000E+00, 2.002E+01, 2.030E+01, 1.148E-01, 1.930E-02, 4.994E-01, 1.149E-01},
    {2159, 1.2986, 0.000E+00, 0.000E+00, 0.000E+00, 1.995E+01, 2.030E+01, 1.139E-01, 1.915E-02, 4.992E-01, 1.149E-01},
    {2160, 1.2985, 0.000E+00, 0.000E+00, 0.000E+00, 1.987E+01, 2.030E+01, 1.130E-01, 1.900E-02, 4.990E-01, 1.149E-01},
    {2161, 1.2984, 0.000E+00, 0.000E+00, 0.000E+00, 1.983E+01, 2.031E+01, 1.129E-01, 1.895E-02, 4.988E-01, 1.149E-01},
    {2162, 1.2983, 0.000E+00, 0.000E+00, 0.000E+00, 1.976E+01, 2.029E+01, 1.127E-01, 1.890E-02, 4.986E-01, 1.149E-01},
    {2163, 1.2981, 0.000E+00, 0.000E+00, 0.000E+00, 1.969E+01, 2.029E+01, 1.126E-01, 1.885E-02, 4.984E-01, 1.149E-01},
    {2164, 1.2980, 0.000E+00, 0.000E+00, 0.000E+00, 1.963E+01, 2.026E+01, 1.124E-01, 1.880E-02, 4.981E-01, 1.149E-01},
    {2165, 1.2979, 0.000E+00, 0.000E+00, 0.000E+00, 1.958E+01, 2.025E+01, 1.123E-01, 1.875E-02, 4.979E-01, 1.149E-01},
    {2166, 1.2978, 0.000E+00, 0.000E+00, 0.000E+00, 1.952E+01, 2.023E+01, 1.121E-01, 1.870E-02, 4.978E-01, 1.149E-01},
    {2167, 1.2977, 0.000E+00, 0.000E+00, 0.000E+00, 1.946E+01, 2.020E+01, 1.120E-01, 1.865E-02, 4.976E-01, 1.149E-01},
    {2168, 1.2975, 0.000E+00, 0.000E+00, 0.000E+00, 1.942E+01, 2.016E+01, 1.118E-01, 1.860E-02, 4.974E-01, 1.149E-01},
    {2169, 1.2974, 0.000E+00, 0.000E+00, 0.000E+00, 1.938E+01, 2.015E+01, 1.117E-01, 1.855E-02, 4.972E-01, 1.149E-01},
    {2170, 1.2973, 0.000E+00, 0.000E+00, 0.000E+00, 1.933E+01, 2.012E+01, 1.115E-01, 1.850E-02, 4.970E-01, 1.149E-01},
    {2171, 1.2972, 0.000E+00, 0.000E+00, 0.000E+00, 1.928E+01, 2.009E+01, 1.114E-01, 1.845E-02, 4.972E-01, 1.149E-01},
    {2172, 1.2970, 0.000E+00, 0.000E+00, 0.000E+00, 1.923E+01, 2.007E+01, 1.112E-01, 1.840E-02, 4.974E-01, 1.149E-01},
    {2173, 1.2969, 0.000E+00, 0.000E+00, 0.000E+00, 1.918E+01, 2.003E+01, 1.111E-01, 1.835E-02, 4.975E-01, 1.149E-01},
    {2174, 1.2967, 0.000E+00, 0.000E+00, 0.000E+00, 1.913E+01, 1.998E+01, 1.109E-01, 1.830E-02, 4.977E-01, 1.149E-01},
    {2175, 1.2966, 0.000E+00, 0.000E+00, 0.000E+00, 1.909E+01, 1.995E+01, 1.108E-01, 1.825E-02, 4.979E-01, 1.149E-01},
    {2176, 1.2965, 0.000E+00, 0.000E+00, 0.000E+00, 1.904E+01, 1.991E+01, 1.106E-01, 1.820E-02, 4.979E-01, 1.149E-01},
    {2177, 1.2964, 0.000E+00, 0.000E+00, 0.000E+00, 1.900E+01, 1.986E+01, 1.105E-01, 1.815E-02, 4.979E-01, 1.149E-01},
    {2178, 1.2962, 0.000E+00, 0.000E+00, 0.000E+00, 1.896E+01, 1.980E+01, 1.103E-01, 1.810E-02, 4.979E-01, 1.149E-01},
    {2179, 1.2961, 0.000E+00, 0.000E+00, 0.000E+00, 1.889E+01, 1.975E+01, 1.102E-01, 1.805E-02, 4.979E-01, 1.149E-01},
    {2180, 1.2960, 0.000E+00, 0.000E+00, 0.000E+00, 1.884E+01, 1.969E+01, 1.100E-01, 1.800E-02, 4.979E-01, 1.149E-01},
    {2181, 1.2959, 0.000E+00, 0.000E+00, 0.000E+00, 1.880E+01, 1.964E+01, 1.094E-01, 1.790E-02, 4.963E-01, 1.149E-01},
    {2182, 1.2958, 0.000E+00, 0.000E+00, 0.000E+00, 1.874E+01, 1.959E+01, 1.087E-01, 1.780E-02, 4.946E-01, 1.150E-01},
    {2183, 1.2957, 0.000E+00, 0.000E+00, 0.000E+00, 1.870E+01, 1.953E+01, 1.081E-01, 1.770E-02, 4.929E-01, 1.151E-01},
    {2184, 1.2956, 0.000E+00, 0.000E+00, 0.000E+00, 1.866E+01, 1.947E+01, 1.074E-01, 1.760E-02, 4.912E-01, 1.152E-01},
    {2185, 1.2955, 0.000E+00, 0.000E+00, 0.000E+00, 1.860E+01, 1.941E+01, 1.068E-01, 1.750E-02, 4.895E-01, 1.152E-01},
    {2186, 1.2954, 0.000E+00, 0.000E+00, 0.000E+00, 1.856E+01, 1.936E+01, 1.061E-01, 1.740E-02, 4.889E-01, 1.155E-01},
    {2187, 1.2953, 0.000E+00, 0.000E+00, 0.000E+00, 1.852E+01, 1.931E+01, 1.055E-01, 1.730E-02, 4.883E-01, 1.157E-01},
    {2188, 1.2951, 0.000E+00, 0.000E+00, 0.000E+00, 1.849E+01, 1.922E+01, 1.048E-01, 1.720E-02, 4.877E-01, 1.160E-01},
    {2189, 1.2950, 0.000E+00, 0.000E+00, 0.000E+00, 1.845E+01, 1.918E+01, 1.042E-01, 1.710E-02, 4.871E-01, 1.163E-01},
    {2190, 1.2949, 0.000E+00, 0.000E+00, 0.000E+00, 1.843E+01, 1.912E+01, 1.035E-01, 1.700E-02, 4.865E-01, 1.165E-01},
    {2191, 1.2948, 0.000E+00, 0.000E+00, 0.000E+00, 1.839E+01, 1.905E+01, 1.029E-01, 1.690E-02, 4.859E-01, 1.165E-01},
    {2192, 1.2947, 0.000E+00, 0.000E+00, 0.000E+00, 1.837E+01, 1.899E+01, 1.022E-01, 1.680E-02, 4.854E-01, 1.166E-01},
    {2193, 1.2945, 0.000E+00, 0.000E+00, 0.000E+00, 1.837E+01, 1.890E+01, 1.016E-01, 1.670E-02, 4.848E-01, 1.166E-01},
    {2194, 1.2944, 0.000E+00, 0.000E+00, 0.000E+00, 1.838E+01, 1.885E+01, 1.009E-01, 1.660E-02, 4.842E-01, 1.166E-01},
    {2195, 1.2943, 0.000E+00, 0.000E+00, 0.000E+00, 1.837E+01, 1.881E+01, 1.003E-01, 1.650E-02, 4.836E-01, 1.167E-01},
    {2196, 1.2942, 0.000E+00, 0.000E+00, 0.000E+00, 1.836E+01, 1.874E+01, 9.960E-02, 1.640E-02, 4.833E-01, 1.174E-01},
    {2197, 1.2941, 0.000E+00, 0.000E+00, 0.000E+00, 1.835E+01, 1.867E+01, 9.895E-02, 1.630E-02, 4.830E-01, 1.181E-01},
    {2198, 1.2939, 0.000E+00, 0.000E+00, 0.000E+00, 1.835E+01, 1.861E+01, 9.830E-02, 1.620E-02, 4.827E-01, 1.188E-01},
    {2199, 1.2938, 0.000E+00, 0.000E+00, 0.000E+00, 1.835E+01, 1.858E+01, 9.765E-02, 1.610E-02, 4.824E-01, 1.196E-01},
    {2200, 1.2937, 0.000E+00, 0.000E+00, 0.000E+00, 1.834E+01, 1.852E+01, 9.700E-02, 1.600E-02, 4.821E-01, 1.203E-01},
    {2201, 1.2936, 0.000E+00, 0.000E+00, 0.000E+00, 1.833E+01, 1.846E+01, 9.775E-02, 1.610E-02, 4.820E-01, 1.201E-01},
    {2202, 1.2935, 0.000E+00, 0.000E+00, 0.000E+00, 1.833E+01, 1.840E+01, 9.850E-02, 1.620E-02, 4.819E-01, 1.200E-01},
    {2203, 1.2933, 0.000E+00, 0.000E+00, 0.000E+00, 1.833E+01, 1.834E+01, 9.925E-02, 1.630E-02, 4.818E-01, 1.199E-01},
    {2204, 1.2932, 0.000E+00, 0.000E+00, 0.000E+00, 1.834E+01, 1.829E+01, 1.000E-01, 1.640E-02, 4.817E-01, 1.197E-01},
    {2205, 1.2931, 0.000E+00, 0.000E+00, 0.000E+00, 1.833E+01, 1.824E+01, 1.008E-01, 1.650E-02, 4.816E-01, 1.196E-01},
    {2206, 1.2930, 0.000E+00, 0.000E+00, 0.000E+00, 1.834E+01, 1.818E+01, 1.015E-01, 1.660E-02, 4.816E-01, 1.191E-01},
    {2207, 1.2928, 0.000E+00, 0.000E+00, 0.000E+00, 1.834E+01, 1.813E+01, 1.023E-01, 1.670E-02, 4.815E-01, 1.186E-01},
    {2208, 1.2927, 0.000E+00, 0.000E+00, 0.000E+00, 1.832E+01, 1.807E+01, 1.030E-01, 1.680E-02, 4.815E-01, 1.181E-01},
    {2209, 1.2925, 0.000E+00, 0.000E+00, 0.000E+00, 1.831E+01, 1.803E+01, 1.038E-01, 1.690E-02, 4.815E-01, 1.176E-01},
    {2210, 1.2924, 0.000E+00, 0.000E+00, 0.000E+00, 1.829E+01, 1.798E+01, 1.045E-01, 1.700E-02, 4.815E-01, 1.171E-01},
    {2211, 1.2923, 0.000E+00, 0.000E+00, 0.000E+00, 1.828E+01, 1.792E+01, 1.053E-01, 1.710E-02, 4.817E-01, 1.167E-01},
    {2212, 1.2922, 0.000E+00, 0.000E+00, 0.000E+00, 1.828E+01, 1.787E+01, 1.060E-01, 1.720E-02, 4.818E-01, 1.163E-01},
    {2213, 1.2920, 0.000E+00, 0.000E+00, 0.000E+00, 1.829E+01, 1.782E+01, 1.068E-01, 1.730E-02, 4.820E-01, 1.159E-01},
    {2214, 1.2919, 0.000E+00, 0.000E+00, 0.000E+00, 1.829E+01, 1.780E+01, 1.075E-01, 1.740E-02, 4.821E-01, 1.156E-01},
    {2215, 1.2918, 0.000E+00, 0.000E+00, 0.000E+00, 1.830E+01, 1.775E+01, 1.083E-01, 1.750E-02, 4.823E-01, 1.152E-01},
    {2216, 1.2917, 0.000E+00, 0.000E+00, 0.000E+00, 1.832E+01, 1.773E+01, 1.090E-01, 1.760E-02, 4.827E-01, 1.152E-01},
    {2217, 1.2916, 0.000E+00, 0.000E+00, 0.000E+00, 1.835E+01, 1.768E+01, 1.098E-01, 1.770E-02, 4.831E-01, 1.152E-01},
    {2218, 1.2914, 0.000E+00, 0.000E+00, 0.000E+00, 1.836E+01, 1.768E+01, 1.105E-01, 1.780E-02, 4.836E-01, 1.151E-01},
    {2219, 1.2913, 0.000E+00, 0.000E+00, 0.000E+00, 1.837E+01, 1.766E+01, 1.113E-01, 1.790E-02, 4.840E-01, 1.151E-01},
    {2220, 1.2912, 0.000E+00, 0.000E+00, 0.000E+00, 1.837E+01, 1.763E+01, 1.120E-01, 1.800E-02, 4.844E-01, 1.151E-01},
    {2221, 1.2911, 0.000E+00, 0.000E+00, 0.000E+00, 1.838E+01, 1.762E+01, 1.118E-01, 1.795E-02, 4.849E-01, 1.151E-01},
    {2222, 1.2910, 0.000E+00, 0.000E+00, 0.000E+00, 1.837E+01, 1.763E+01, 1.115E-01, 1.790E-02, 4.853E-01, 1.151E-01},
    {2223, 1.2908, 0.000E+00, 0.000E+00, 0.000E+00, 1.840E+01, 1.764E+01, 1.113E-01, 1.785E-02, 4.858E-01, 1.151E-01},
    {2224, 1.2907, 0.000E+00, 0.000E+00, 0.000E+00, 1.842E+01, 1.764E+01, 1.110E-01, 1.780E-02, 4.862E-01, 1.151E-01},
    {2225, 1.2906, 0.000E+00, 0.000E+00, 0.000E+00, 1.843E+01, 1.766E+01, 1.108E-01, 1.775E-02, 4.867E-01, 1.151E-01},
    {2226, 1.2905, 0.000E+00, 0.000E+00, 0.000E+00, 1.846E+01, 1.770E+01, 1.105E-01, 1.770E-02, 4.873E-01, 1.151E-01},
    {2227, 1.2904, 0.000E+00, 0.000E+00, 0.000E+00, 1.849E+01, 1.774E+01, 1.103E-01, 1.765E-02, 4.879E-01, 1.151E-01},
    {2228, 1.2902, 0.000E+00, 0.000E+00, 0.000E+00, 1.851E+01, 1.779E+01, 1.100E-01, 1.760E-02, 4.884E-01, 1.151E-01},
    {2229, 1.2901, 0.000E+00, 0.000E+00, 0.000E+00, 1.854E+01, 1.786E+01, 1.098E-01, 1.755E-02, 4.890E-01, 1.151E-01},
    {2230, 1.2900, 0.000E+00, 0.000E+00, 0.000E+00, 1.857E+01, 1.795E+01, 1.095E-01, 1.750E-02, 4.896E-01, 1.151E-01},
    {2231, 1.2899, 0.000E+00, 0.000E+00, 0.000E+00, 1.858E+01, 1.803E+01, 1.093E-01, 1.745E-02, 4.902E-01, 1.151E-01},
    {2232, 1.2898, 0.000E+00, 0.000E+00, 0.000E+00, 1.860E+01, 1.814E+01, 1.090E-01, 1.740E-02, 4.908E-01, 1.151E-01},
    {2233, 1.2896, 0.000E+00, 0.000E+00, 0.000E+00, 1.864E+01, 1.825E+01, 1.088E-01, 1.735E-02, 4.914E-01, 1.151E-01},
    {2234, 1.2895, 0.000E+00, 0.000E+00, 0.000E+00, 1.865E+01, 1.836E+01, 1.085E-01, 1.730E-02, 4.920E-01, 1.151E-01},
    {2235, 1.2894, 0.000E+00, 0.000E+00, 0.000E+00, 1.867E+01, 1.851E+01, 1.083E-01, 1.725E-02, 4.926E-01, 1.151E-01},
    {2236, 1.2893, 0.000E+00, 0.000E+00, 0.000E+00, 1.870E+01, 1.866E+01, 1.080E-01, 1.720E-02, 4.924E-01, 1.151E-01},
    {2237, 1.2892, 0.000E+00, 0.000E+00, 0.000E+00, 1.875E+01, 1.881E+01, 1.078E-01, 1.715E-02, 4.922E-01, 1.151E-01},
    {2238, 1.2890, 0.000E+00, 0.000E+00, 0.000E+00, 1.879E+01, 1.895E+01, 1.075E-01, 1.710E-02, 4.920E-01, 1.151E-01},
    {2239, 1.2889, 0.000E+00, 0.000E+00, 0.000E+00, 1.883E+01, 1.913E+01, 1.073E-01, 1.705E-02, 4.919E-01, 1.151E-01},
    {2240, 1.2888, 0.000E+00, 0.000E+00, 0.000E+00, 1.888E+01, 1.931E+01, 1.070E-01, 1.700E-02, 4.917E-01, 1.151E-01},
    {2241, 1.2887, 0.000E+00, 0.000E+00, 0.000E+00, 1.893E+01, 1.951E+01, 1.065E-01, 1.695E-02, 4.914E-01, 1.151E-01},
    {2242, 1.2886, 0.000E+00, 0.000E+00, 0.000E+00, 1.897E+01, 1.972E+01, 1.059E-01, 1.690E-02, 4.911E-01, 1.151E-01},
    {2243, 1.2884, 0.000E+00, 0.000E+00, 0.000E+00, 1.903E+01, 1.994E+01, 1.054E-01, 1.685E-02, 4.908E-01, 1.151E-01},
    {2244, 1.2883, 0.000E+00, 0.000E+00, 0.000E+00, 1.908E+01, 2.017E+01, 1.048E-01, 1.680E-02, 4.905E-01, 1.151E-01},
    {2245, 1.2882, 0.000E+00, 0.000E+00, 0.000E+00, 1.913E+01, 2.040E+01, 1.043E-01, 1.675E-02, 4.902E-01, 1.151E-01},
    {2246, 1.2881, 0.000E+00, 0.000E+00, 0.000E+00, 1.919E+01, 2.065E+01, 1.037E-01, 1.670E-02, 4.902E-01, 1.151E-01},
    {2247, 1.2880, 0.000E+00, 0.000E+00, 0.000E+00, 1.924E+01, 2.089E+01, 1.032E-01, 1.665E-02, 4.902E-01, 1.151E-01},
    {2248, 1.2878, 0.000E+00, 0.000E+00, 0.000E+00, 1.929E+01, 2.114E+01, 1.026E-01, 1.660E-02, 4.902E-01, 1.151E-01},
    {2249, 1.2877, 0.000E+00, 0.000E+00, 0.000E+00, 1.934E+01, 2.140E+01, 1.021E-01, 1.655E-02, 4.901E-01, 1.151E-01},
    {2250, 1.2876, 0.000E+00, 0.000E+00, 0.000E+00, 1.940E+01, 2.163E+01, 1.015E-01, 1.650E-02, 4.901E-01, 1.151E-01},
    {2251, 1.2875, 0.000E+00, 0.000E+00, 0.000E+00, 1.946E+01, 2.186E+01, 1.010E-01, 1.645E-02, 4.901E-01, 1.150E-01},
    {2252, 1.2874, 0.000E+00, 0.000E+00, 0.000E+00, 1.951E+01, 2.210E+01, 1.004E-01, 1.640E-02, 4.900E-01, 1.149E-01},
    {2253, 1.2873, 0.000E+00, 0.000E+00, 0.000E+00, 1.961E+01, 2.236E+01, 9.985E-02, 1.635E-02, 4.899E-01, 1.148E-01},
    {2254, 1.2872, 0.000E+00, 0.000E+00, 0.000E+00, 1.966E+01, 2.262E+01, 9.930E-02, 1.630E-02, 4.898E-01, 1.148E-01},
    {2255, 1.2871, 0.000E+00, 0.000E+00, 0.000E+00, 1.973E+01, 2.290E+01, 9.875E-02, 1.625E-02, 4.897E-01, 1.147E-01},
    {2256, 1.2870, 0.000E+00, 0.000E+00, 0.000E+00, 1.980E+01, 2.313E+01, 9.820E-02, 1.620E-02, 4.895E-01, 1.141E-01},
    {2257, 1.2869, 0.000E+00, 0.000E+00, 0.000E+00, 1.985E+01, 2.339E+01, 9.765E-02, 1.615E-02, 4.893E-01, 1.134E-01},
    {2258, 1.2867, 0.000E+00, 0.000E+00, 0.000E+00, 1.991E+01, 2.361E+01, 9.710E-02, 1.610E-02, 4.891E-01, 1.128E-01},
    {2259, 1.2866, 0.000E+00, 0.000E+00, 0.000E+00, 1.997E+01, 2.386E+01, 9.655E-02, 1.605E-02, 4.889E-01, 1.121E-01},
    {2260, 1.2865, 0.000E+00, 0.000E+00, 0.000E+00, 2.004E+01, 2.410E+01, 9.600E-02, 1.600E-02, 4.887E-01, 1.115E-01},
    {2261, 1.2864, 0.000E+00, 0.000E+00, 0.000E+00, 2.013E+01, 2.434E+01, 9.590E-02, 1.595E-02, 4.889E-01, 1.115E-01},
    {2262, 1.2863, 0.000E+00, 0.000E+00, 0.000E+00, 2.020E+01, 2.455E+01, 9.580E-02, 1.590E-02, 4.892E-01, 1.115E-01},
    {2263, 1.2862, 0.000E+00, 0.000E+00, 0.000E+00, 2.027E+01, 2.479E+01, 9.570E-02, 1.585E-02, 4.894E-01, 1.114E-01},
    {2264, 1.2861, 0.000E+00, 0.000E+00, 0.000E+00, 2.038E+01, 2.499E+01, 9.560E-02, 1.580E-02, 4.896E-01, 1.114E-01},
    {2265, 1.2860, 0.000E+00, 0.000E+00, 0.000E+00, 2.046E+01, 2.521E+01, 9.550E-02, 1.575E-02, 4.898E-01, 1.114E-01},
    {2266, 1.2859, 0.000E+00, 0.000E+00, 0.000E+00, 2.054E+01, 2.541E+01, 9.540E-02, 1.570E-02, 4.900E-01, 1.111E-01},
    {2267, 1.2858, 0.000E+00, 0.000E+00, 0.000E+00, 2.062E+01, 2.562E+01, 9.530E-02, 1.565E-02, 4.902E-01, 1.108E-01},
    {2268, 1.2856, 0.000E+00, 0.000E+00, 0.000E+00, 2.071E+01, 2.583E+01, 9.520E-02, 1.560E-02, 4.904E-01, 1.105E-01},
    {2269, 1.2855, 0.000E+00, 0.000E+00, 0.000E+00, 2.079E+01, 2.605E+01, 9.510E-02, 1.555E-02, 4.906E-01, 1.102E-01},
    {2270, 1.2854, 0.000E+00, 0.000E+00, 0.000E+00, 2.087E+01, 2.626E+01, 9.500E-02, 1.550E-02, 4.908E-01, 1.099E-01},
    {2271, 1.2853, 0.000E+00, 0.000E+00, 0.000E+00, 2.094E+01, 2.643E+01, 9.490E-02, 1.545E-02, 4.910E-01, 1.097E-01},
    {2272, 1.2852, 0.000E+00, 0.000E+00, 0.000E+00, 2.103E+01, 2.657E+01, 9.480E-02, 1.540E-02, 4.912E-01, 1.095E-01},
    {2273, 1.2850, 0.000E+00, 0.000E+00, 0.000E+00, 2.111E+01, 2.674E+01, 9.470E-02, 1.535E-02, 4.914E-01, 1.093E-01},
    {2274, 1.2849, 0.000E+00, 0.000E+00, 0.000E+00, 2.126E+01, 2.688E+01, 9.460E-02, 1.530E-02, 4.916E-01, 1.091E-01},
    {2275, 1.2848, 0.000E+00, 0.000E+00, 0.000E+00, 2.135E+01, 2.701E+01, 9.450E-02, 1.525E-02, 4.918E-01, 1.089E-01},
    {2276, 1.2847, 0.000E+00, 0.000E+00, 0.000E+00, 2.145E+01, 2.718E+01, 9.440E-02, 1.520E-02, 4.920E-01, 1.086E-01},
    {2277, 1.2846, 0.000E+00, 0.000E+00, 0.000E+00, 2.153E+01, 2.732E+01, 9.430E-02, 1.515E-02, 4.923E-01, 1.084E-01},
    {2278, 1.2845, 0.000E+00, 0.000E+00, 0.000E+00, 2.164E+01, 2.742E+01, 9.420E-02, 1.510E-02, 4.925E-01, 1.082E-01},
    {2279, 1.2844, 0.000E+00, 0.000E+00, 0.000E+00, 2.174E+01, 2.754E+01, 9.410E-02, 1.505E-02, 4.927E-01, 1.079E-01},
    {2280, 1.2843, 0.000E+00, 0.000E+00, 0.000E+00, 2.183E+01, 2.763E+01, 9.400E-02, 1.500E-02, 4.929E-01, 1.077E-01},
    {2281, 1.2842, 0.000E+00, 0.000E+00, 0.000E+00, 2.192E+01, 2.777E+01, 9.355E-02, 1.495E-02, 4.926E-01, 1.074E-01},
    {2282, 1.2841, 0.000E+00, 0.000E+00, 0.000E+00, 2.202E+01, 2.794E+01, 9.310E-02, 1.490E-02, 4.924E-01, 1.071E-01},
    {2283, 1.2840, 0.000E+00, 0.000E+00, 0.000E+00, 2.212E+01, 2.804E+01, 9.265E-02, 1.485E-02, 4.921E-01, 1.068E-01},
    {2284, 1.2839, 0.000E+00, 0.000E+00, 0.000E+00, 2.223E+01, 2.821E+01, 9.220E-02, 1.480E-02, 4.919E-01, 1.064E-01},
    {2285, 1.2838, 0.000E+00, 0.000E+00, 0.000E+00, 2.234E+01, 2.836E+01, 9.175E-02, 1.475E-02, 4.916E-01, 1.061E-01},
    {2286, 1.2837, 0.000E+00, 0.000E+00, 0.000E+00, 2.245E+01, 2.850E+01, 9.130E-02, 1.470E-02, 4.910E-01, 1.056E-01},
    {2287, 1.2836, 0.000E+00, 0.000E+00, 0.000E+00, 2.264E+01, 2.863E+01, 9.085E-02, 1.465E-02, 4.904E-01, 1.051E-01},
    {2288, 1.2834, 0.000E+00, 0.000E+00, 0.000E+00, 2.276E+01, 2.878E+01, 9.040E-02, 1.460E-02, 4.898E-01, 1.046E-01},
    {2289, 1.2833, 0.000E+00, 0.000E+00, 0.000E+00, 2.287E+01, 2.896E+01, 8.995E-02, 1.455E-02, 4.892E-01, 1.041E-01},
    {2290, 1.2832, 0.000E+00, 0.000E+00, 0.000E+00, 2.301E+01, 2.913E+01, 8.950E-02, 1.450E-02, 4.886E-01, 1.036E-01},
    {2291, 1.2831, 0.000E+00, 0.000E+00, 0.000E+00, 2.313E+01, 2.922E+01, 8.905E-02, 1.445E-02, 4.885E-01, 1.029E-01},
    {2292, 1.2830, 0.000E+00, 0.000E+00, 0.000E+00, 2.327E+01, 2.937E+01, 8.860E-02, 1.440E-02, 4.884E-01, 1.021E-01},
    {2293, 1.2829, 0.000E+00, 0.000E+00, 0.000E+00, 2.338E+01, 2.947E+01, 8.815E-02, 1.435E-02, 4.883E-01, 1.013E-01},
    {2294, 1.2828, 0.000E+00, 0.000E+00, 0.000E+00, 2.351E+01, 2.960E+01, 8.770E-02, 1.430E-02, 4.882E-01, 1.005E-01},
    {2295, 1.2827, 0.000E+00, 0.000E+00, 0.000E+00, 2.363E+01, 2.970E+01, 8.725E-02, 1.425E-02, 4.882E-01, 9.971E-02},
    {2296, 1.2826, 0.000E+00, 0.000E+00, 0.000E+00, 2.377E+01, 2.982E+01, 8.680E-02, 1.420E-02, 4.879E-01, 9.941E-02},
    {2297, 1.2825, 0.000E+00, 0.000E+00, 0.000E+00, 2.385E+01, 2.997E+01, 8.635E-02, 1.415E-02, 4.875E-01, 9.910E-02},
    {2298, 1.2824, 0.000E+00, 0.000E+00, 0.000E+00, 2.409E+01, 3.006E+01, 8.590E-02, 1.410E-02, 4.872E-01, 9.879E-02},
    {2299, 1.2823, 0.000E+00, 0.000E+00, 0.000E+00, 2.418E+01, 3.018E+01, 8.545E-02, 1.405E-02, 4.869E-01, 9.849E-02},
    {2300, 1.2822, 0.000E+00, 0.000E+00, 0.000E+00, 2.433E+01, 3.028E+01, 8.500E-02, 1.400E-02, 4.866E-01, 9.818E-02},
    {2301, 1.2821, 0.000E+00, 0.000E+00, 0.000E+00, 2.444E+01, 3.040E+01, 8.430E-02, 1.385E-02, 4.863E-01, 9.818E-02},
    {2302, 1.2820, 0.000E+00, 0.000E+00, 0.000E+00, 2.459E+01, 3.053E+01, 8.360E-02, 1.370E-02, 4.860E-01, 9.818E-02},
    {2303, 1.2818, 0.000E+00, 0.000E+00, 0.000E+00, 2.470E+01, 3.060E+01, 8.290E-02, 1.355E-02, 4.857E-01, 9.817E-02},
    {2304, 1.2817, 0.000E+00, 0.000E+00, 0.000E+00, 2.485E+01, 3.066E+01, 8.220E-02, 1.340E-02, 4.853E-01, 9.817E-02},
    {2305, 1.2816, 0.000E+00, 0.000E+00, 0.000E+00, 2.495E+01, 3.070E+01, 8.150E-02, 1.325E-02, 4.850E-01, 9.817E-02},
    {2306, 1.2815, 0.000E+00, 0.000E+00, 0.000E+00, 2.523E+01, 3.076E+01, 8.080E-02, 1.310E-02, 4.847E-01, 9.817E-02},
    {2307, 1.2814, 0.000E+00, 0.000E+00, 0.000E+00, 2.534E+01, 3.078E+01, 8.010E-02, 1.295E-02, 4.844E-01, 9.817E-02},
    {2308, 1.2813, 0.000E+00, 0.000E+00, 0.000E+00, 2.549E+01, 3.075E+01, 7.940E-02, 1.280E-02, 4.841E-01, 9.816E-02},
    {2309, 1.2812, 0.000E+00, 0.000E+00, 0.000E+00, 2.564E+01, 3.074E+01, 7.870E-02, 1.265E-02, 4.838E-01, 9.816E-02},
    {2310, 1.2811, 0.000E+00, 0.000E+00, 0.000E+00, 2.579E+01, 3.072E+01, 7.800E-02, 1.250E-02, 4.835E-01, 9.816E-02},
    {2311, 1.2810, 0.000E+00, 0.000E+00, 0.000E+00, 2.592E+01, 3.065E+01, 7.730E-02, 1.235E-02, 4.832E-01, 9.809E-02},
    {2312, 1.2809, 0.000E+00, 0.000E+00, 0.000E+00, 2.611E+01, 3.058E+01, 7.660E-02, 1.220E-02, 4.830E-01, 9.802E-02},
    {2313, 1.2808, 0.000E+00, 0.000E+00, 0.000E+00, 2.623E+01, 3.051E+01, 7.590E-02, 1.205E-02, 4.828E-01, 9.795E-02},
    {2314, 1.2807, 0.000E+00, 0.000E+00, 0.000E+00, 2.653E+01, 3.045E+01, 7.520E-02, 1.190E-02, 4.825E-01, 9.788E-02},
    {2315, 1.2806, 0.000E+00, 0.000E+00, 0.000E+00, 2.664E+01, 3.034E+01, 7.450E-02, 1.175E-02, 4.823E-01, 9.781E-02},
    {2316, 1.2805, 0.000E+00, 0.000E+00, 0.000E+00, 2.681E+01, 3.029E+01, 7.380E-02, 1.160E-02, 4.823E-01, 9.741E-02},
    {2317, 1.2804, 0.000E+00, 0.000E+00, 0.000E+00, 2.695E+01, 3.023E+01, 7.310E-02, 1.145E-02, 4.823E-01, 9.700E-02},
    {2318, 1.2803, 0.000E+00, 0.000E+00, 0.000E+00, 2.712E+01, 3.015E+01, 7.240E-02, 1.130E-02, 4.823E-01, 9.660E-02},
    {2319, 1.2802, 0.000E+00, 0.000E+00, 0.000E+00, 2.727E+01, 3.004E+01, 7.170E-02, 1.115E-02, 4.823E-01, 9.620E-02},
    {2320, 1.2801, 0.000E+00, 0.000E+00, 0.000E+00, 2.744E+01, 3.000E+01, 7.100E-02, 1.100E-02, 4.823E-01, 9.580E-02},
    {2321, 1.2800, 0.000E+00, 0.000E+00, 0.000E+00, 2.756E+01, 2.998E+01, 7.105E-02, 1.100E-02, 4.823E-01, 9.537E-02},
    {2322, 1.2799, 0.000E+00, 0.000E+00, 0.000E+00, 2.789E+01, 2.991E+01, 7.110E-02, 1.100E-02, 4.823E-01, 9.495E-02},
    {2323, 1.2799, 0.000E+00, 0.000E+00, 0.000E+00, 2.802E+01, 2.986E+01, 7.115E-02, 1.100E-02, 4.823E-01, 9.453E-02},
    {2324, 1.2798, 0.000E+00, 0.000E+00, 0.000E+00, 2.819E+01, 2.984E+01, 7.120E-02, 1.100E-02, 4.823E-01, 9.411E-02},
    {2325, 1.2797, 0.000E+00, 0.000E+00, 0.000E+00, 2.838E+01, 2.981E+01, 7.125E-02, 1.100E-02, 4.823E-01, 9.369E-02},
    {2326, 1.2796, 0.000E+00, 0.000E+00, 0.000E+00, 2.855E+01, 2.976E+01, 7.130E-02, 1.100E-02, 4.822E-01, 9.319E-02},
    {2327, 1.2795, 0.000E+00, 0.000E+00, 0.000E+00, 2.869E+01, 2.973E+01, 7.135E-02, 1.100E-02, 4.822E-01, 9.269E-02},
    {2328, 1.2795, 0.000E+00, 0.000E+00, 0.000E+00, 2.903E+01, 2.976E+01, 7.140E-02, 1.100E-02, 4.822E-01, 9.219E-02},
    {2329, 1.2794, 0.000E+00, 0.000E+00, 0.000E+00, 2.916E+01, 2.977E+01, 7.145E-02, 1.100E-02, 4.822E-01, 9.169E-02},
    {2330, 1.2793, 0.000E+00, 0.000E+00, 0.000E+00, 2.934E+01, 2.979E+01, 7.150E-02, 1.100E-02, 4.822E-01, 9.118E-02},
    {2331, 1.2792, 0.000E+00, 0.000E+00, 0.000E+00, 2.951E+01, 2.981E+01, 7.155E-02, 1.100E-02, 4.817E-01, 9.118E-02},
    {2332, 1.2791, 0.000E+00, 0.000E+00, 0.000E+00, 2.969E+01, 2.985E+01, 7.160E-02, 1.100E-02, 4.813E-01, 9.118E-02},
    {2333, 1.2791, 0.000E+00, 0.000E+00, 0.000E+00, 2.988E+01, 2.989E+01, 7.165E-02, 1.100E-02, 4.809E-01, 9.118E-02},
    {2334, 1.2790, 0.000E+00, 0.000E+00, 0.000E+00, 3.002E+01, 2.999E+01, 7.170E-02, 1.100E-02, 4.805E-01, 9.117E-02},
    {2335, 1.2789, 0.000E+00, 0.000E+00, 0.000E+00, 3.038E+01, 3.000E+01, 7.175E-02, 1.100E-02, 4.801E-01, 9.117E-02},
    {2336, 1.2788, 0.000E+00, 0.000E+00, 0.000E+00, 3.054E+01, 3.005E+01, 7.180E-02, 1.100E-02, 4.797E-01, 9.078E-02},
    {2337, 1.2788, 0.000E+00, 0.000E+00, 0.000E+00, 3.073E+01, 3.007E+01, 7.185E-02, 1.100E-02, 4.793E-01, 9.039E-02},
    {2338, 1.2787, 0.000E+00, 0.000E+00, 0.000E+00, 3.092E+01, 3.011E+01, 7.190E-02, 1.100E-02, 4.789E-01, 9.000E-02},
    {2339, 1.2787, 0.000E+00, 0.000E+00, 0.000E+00, 3.107E+01, 3.017E+01, 7.195E-02, 1.100E-02, 4.785E-01, 8.961E-02},
    {2340, 1.2786, 0.000E+00, 0.000E+00, 0.000E+00, 3.145E+01, 3.022E+01, 7.200E-02, 1.100E-02, 4.781E-01, 8.922E-02},
    {2341, 1.2785, 0.000E+00, 0.000E+00, 0.000E+00, 3.160E+01, 3.023E+01, 7.195E-02, 1.100E-02, 4.778E-01, 8.888E-02},
    {2342, 1.2785, 0.000E+00, 0.000E+00, 0.000E+00, 3.180E+01, 3.029E+01, 7.190E-02, 1.100E-02, 4.776E-01, 8.853E-02},
    {2343, 1.2784, 0.000E+00, 0.000E+00, 0.000E+00, 3.199E+01, 3.028E+01, 7.185E-02, 1.100E-02, 4.773E-01, 8.819E-02},
    {2344, 1.2784, 0.000E+00, 0.000E+00, 0.000E+00, 3.219E+01, 3.029E+01, 7.180E-02, 1.100E-02, 4.771E-01, 8.785E-02},
    {2345, 1.2783, 0.000E+00, 0.000E+00, 0.000E+00, 3.238E+01, 3.027E+01, 7.175E-02, 1.100E-02, 4.768E-01, 8.750E-02},
    {2346, 1.2782, 0.000E+00, 0.000E+00, 0.000E+00, 3.272E+01, 3.027E+01, 7.170E-02, 1.100E-02, 4.769E-01, 8.779E-02},
    {2347, 1.2781, 0.000E+00, 0.000E+00, 0.000E+00, 3.290E+01, 3.024E+01, 7.165E-02, 1.100E-02, 4.770E-01, 8.808E-02},
    {2348, 1.2780, 0.000E+00, 0.000E+00, 0.000E+00, 3.311E+01, 3.019E+01, 7.160E-02, 1.100E-02, 4.770E-01, 8.837E-02},
    {2349, 1.2779, 0.000E+00, 0.000E+00, 0.000E+00, 3.331E+01, 3.010E+01, 7.155E-02, 1.100E-02, 4.771E-01, 8.866E-02},
    {2350, 1.2778, 0.000E+00, 0.000E+00, 0.000E+00, 3.348E+01, 3.010E+01, 7.150E-02, 1.100E-02, 4.772E-01, 8.895E-02},
    {2351, 1.2777, 0.000E+00, 0.000E+00, 0.000E+00, 3.388E+01, 3.003E+01, 7.145E-02, 1.100E-02, 4.773E-01, 8.865E-02},
    {2352, 1.2776, 0.000E+00, 0.000E+00, 0.000E+00, 3.404E+01, 2.993E+01, 7.140E-02, 1.100E-02, 4.773E-01, 8.836E-02},
    {2353, 1.2776, 0.000E+00, 0.000E+00, 0.000E+00, 3.426E+01, 2.983E+01, 7.135E-02, 1.100E-02, 4.774E-01, 8.807E-02},
    {2354, 1.2775, 0.000E+00, 0.000E+00, 0.000E+00, 3.447E+01, 2.984E+01, 7.130E-02, 1.100E-02, 4.775E-01, 8.777E-02},
    {2355, 1.2774, 0.000E+00, 0.000E+00, 0.000E+00, 3.468E+01, 2.975E+01, 7.125E-02, 1.100E-02, 4.775E-01, 8.748E-02},
    {2356, 1.2773, 0.000E+00, 0.000E+00, 0.000E+00, 3.486E+01, 2.966E+01, 7.120E-02, 1.100E-02, 4.776E-01, 8.680E-02},
    {2357, 1.2772, 0.000E+00, 0.000E+00, 0.000E+00, 3.528E+01, 2.958E+01, 7.115E-02, 1.100E-02, 4.777E-01, 8.613E-02},
    {2358, 1.2771, 0.000E+00, 0.000E+00, 0.000E+00, 3.547E+01, 2.948E+01, 7.110E-02, 1.100E-02, 4.778E-01, 8.546E-02},
    {2359, 1.2770, 0.000E+00, 0.000E+00, 0.000E+00, 3.570E+01, 2.930E+01, 7.105E-02, 1.100E-02, 4.779E-01, 8.478E-02},
    {2360, 1.2769, 0.000E+00, 0.000E+00, 0.000E+00, 3.592E+01, 2.926E+01, 7.100E-02, 1.100E-02, 4.780E-01, 8.411E-02},
    {2361, 1.2768, 0.000E+00, 0.000E+00, 0.000E+00, 3.610E+01, 2.920E+01, 7.025E-02, 1.090E-02, 4.778E-01, 8.332E-02},
    {2362, 1.2767, 0.000E+00, 0.000E+00, 0.000E+00, 3.656E+01, 2.913E+01, 6.950E-02, 1.080E-02, 4.777E-01, 8.254E-02},
    {2363, 1.2766, 0.000E+00, 0.000E+00, 0.000E+00, 3.675E+01, 2.902E+01, 6.875E-02, 1.070E-02, 4.776E-01, 8.176E-02},
    {2364, 1.2765, 0.000E+00, 0.000E+00, 0.000E+00, 3.697E+01, 2.890E+01, 6.800E-02, 1.060E-02, 4.774E-01, 8.097E-02},
    {2365, 1.2764, 0.000E+00, 0.000E+00, 0.000E+00, 3.716E+01, 2.882E+01, 6.725E-02, 1.050E-02, 4.773E-01, 8.019E-02},
    {2366, 1.2763, 0.000E+00, 0.000E+00, 0.000E+00, 3.761E+01, 2.872E+01, 6.650E-02, 1.040E-02, 4.770E-01, 8.011E-02},
    {2367, 1.2762, 0.000E+00, 0.000E+00, 0.000E+00, 3.777E+01, 2.873E+01, 6.575E-02, 1.030E-02, 4.767E-01, 8.003E-02},
    {2368, 1.2761, 0.000E+00, 0.000E+00, 0.000E+00, 3.801E+01, 2.870E+01, 6.500E-02, 1.020E-02, 4.765E-01, 7.995E-02},
    {2369, 1.2760, 0.000E+00, 0.000E+00, 0.000E+00, 3.827E+01, 2.865E+01, 6.425E-02, 1.010E-02, 4.762E-01, 7.987E-02},
    {2370, 1.2759, 0.000E+00, 0.000E+00, 0.000E+00, 3.848E+01, 2.858E+01, 6.350E-02, 1.000E-02, 4.759E-01, 7.979E-02},
    {2371, 1.2758, 0.000E+00, 0.000E+00, 0.000E+00, 3.892E+01, 2.854E+01, 6.275E-02, 9.900E-03, 4.756E-01, 7.946E-02},
    {2372, 1.2757, 0.000E+00, 0.000E+00, 0.000E+00, 3.913E+01, 2.850E+01, 6.200E-02, 9.800E-03, 4.754E-01, 7.914E-02},
    {2373, 1.2757, 0.000E+00, 0.000E+00, 0.000E+00, 3.938E+01, 2.846E+01, 6.125E-02, 9.700E-03, 4.751E-01, 7.882E-02},
    {2374, 1.2756, 0.000E+00, 0.000E+00, 0.000E+00, 3.957E+01, 2.838E+01, 6.050E-02, 9.600E-03, 4.748E-01, 7.849E-02},
    {2375, 1.2755, 0.000E+00, 0.000E+00, 0.000E+00, 4.007E+01, 2.834E+01, 5.975E-02, 9.500E-03, 4.745E-01, 7.817E-02},
    {2376, 1.2754, 0.000E+00, 0.000E+00, 0.000E+00, 4.024E+01, 2.823E+01, 5.900E-02, 9.400E-03, 4.747E-01, 7.754E-02},
    {2377, 1.2753, 0.000E+00, 0.000E+00, 0.000E+00, 4.050E+01, 2.820E+01, 5.825E-02, 9.300E-03, 4.748E-01, 7.691E-02},
    {2378, 1.2753, 0.000E+00, 0.000E+00, 0.000E+00, 4.078E+01, 2.817E+01, 5.750E-02, 9.200E-03, 4.749E-01, 7.628E-02},
    {2379, 1.2752, 0.000E+00, 0.000E+00, 0.000E+00, 4.096E+01, 2.809E+01, 5.675E-02, 9.100E-03, 4.750E-01, 7.565E-02},
    {2380, 1.2751, 0.000E+00, 0.000E+00, 0.000E+00, 4.147E+01, 2.803E+01, 5.600E-02, 9.000E-03, 4.752E-01, 7.502E-02},
    {2381, 1.2750, 0.000E+00, 0.000E+00, 0.000E+00, 4.167E+01, 2.803E+01, 5.685E-02, 9.100E-03, 4.752E-01, 7.496E-02},
    {2382, 1.2749, 0.000E+00, 0.000E+00, 0.000E+00, 4.196E+01, 2.801E+01, 5.770E-02, 9.200E-03, 4.753E-01, 7.489E-02},
    {2383, 1.2749, 0.000E+00, 0.000E+00, 0.000E+00, 4.220E+01, 2.794E+01, 5.855E-02, 9.300E-03, 4.754E-01, 7.483E-02},
    {2384, 1.2748, 0.000E+00, 0.000E+00, 0.000E+00, 4.268E+01, 2.791E+01, 5.940E-02, 9.400E-03, 4.755E-01, 7.476E-02},
    {2385, 1.2747, 0.000E+00, 0.000E+00, 0.000E+00, 4.293E+01, 2.790E+01, 6.025E-02, 9.500E-03, 4.755E-01, 7.470E-02},
    {2386, 1.2746, 0.000E+00, 0.000E+00, 0.000E+00, 4.319E+01, 2.784E+01, 6.110E-02, 9.600E-03, 4.752E-01, 7.394E-02},
    {2387, 1.2745, 0.000E+00, 0.000E+00, 0.000E+00, 4.342E+01, 2.779E+01, 6.195E-02, 9.700E-03, 4.748E-01, 7.318E-02},
    {2388, 1.2745, 0.000E+00, 0.000E+00, 0.000E+00, 4.388E+01, 2.781E+01, 6.280E-02, 9.800E-03, 4.744E-01, 7.242E-02},
    {2389, 1.2744, 0.000E+00, 0.000E+00, 0.000E+00, 4.413E+01, 2.782E+01, 6.365E-02, 9.900E-03, 4.740E-01, 7.167E-02},
    {2390, 1.2743, 0.000E+00, 0.000E+00, 0.000E+00, 4.439E+01, 2.781E+01, 6.450E-02, 1.000E-02, 4.736E-01, 7.091E-02},
    {2391, 1.2742, 0.000E+00, 0.000E+00, 0.000E+00, 4.464E+01, 2.781E+01, 6.535E-02, 1.010E-02, 4.736E-01, 7.083E-02},
    {2392, 1.2742, 0.000E+00, 0.000E+00, 0.000E+00, 4.513E+01, 2.783E+01, 6.620E-02, 1.020E-02, 4.735E-01, 7.074E-02},
    {2393, 1.2741, 0.000E+00, 0.000E+00, 0.000E+00, 4.538E+01, 2.785E+01, 6.705E-02, 1.030E-02, 4.734E-01, 7.066E-02},
    {2394, 1.2741, 0.000E+00, 0.000E+00, 0.000E+00, 4.565E+01, 2.785E+01, 6.790E-02, 1.040E-02, 4.734E-01, 7.058E-02},
    {2395, 1.2740, 0.000E+00, 0.000E+00, 0.000E+00, 4.590E+01, 2.782E+01, 6.875E-02, 1.050E-02, 4.733E-01, 7.050E-02},
    {2396, 1.2739, 0.000E+00, 0.000E+00, 0.000E+00, 4.638E+01, 2.782E+01, 6.960E-02, 1.060E-02, 4.731E-01, 7.015E-02},
    {2397, 1.2739, 0.000E+00, 0.000E+00, 0.000E+00, 4.663E+01, 2.779E+01, 7.045E-02, 1.070E-02, 4.729E-01, 6.981E-02},
    {2398, 1.2738, 0.000E+00, 0.000E+00, 0.000E+00, 4.690E+01, 2.779E+01, 7.130E-02, 1.080E-02, 4.727E-01, 6.946E-02},
    {2399, 1.2738, 0.000E+00, 0.000E+00, 0.000E+00, 4.714E+01, 2.778E+01, 7.215E-02, 1.090E-02, 4.725E-01, 6.912E-02},
    {2400, 1.2737, 0.000E+00, 0.000E+00, 0.000E+00, 4.764E+01, 2.783E+01, 7.300E-02, 1.100E-02, 4.723E-01, 6.878E-02},
    {2401, 1.2736, 0.000E+00, 0.000E+00, 0.000E+00, 4.787E+01, 2.784E+01, 7.085E-02, 1.070E-02, 4.718E-01, 6.878E-02},
    {2402, 1.2736, 0.000E+00, 0.000E+00, 0.000E+00, 4.817E+01, 2.788E+01, 6.870E-02, 1.040E-02, 4.714E-01, 6.877E-02},
    {2403, 1.2735, 0.000E+00, 0.000E+00, 0.000E+00, 4.836E+01, 2.791E+01, 6.655E-02, 1.010E-02, 4.709E-01, 6.877E-02},
    {2404, 1.2735, 0.000E+00, 0.000E+00, 0.000E+00, 4.894E+01, 2.799E+01, 6.440E-02, 9.800E-03, 4.704E-01, 6.877E-02},
    {2405, 1.2734, 0.000E+00, 0.000E+00, 0.000E+00, 4.917E+01, 2.804E+01, 6.225E-02, 9.500E-03, 4.699E-01, 6.877E-02},
    {2406, 1.2733, 0.000E+00, 0.000E+00, 0.000E+00, 4.940E+01, 2.812E+01, 6.010E-02, 9.200E-03, 4.695E-01, 6.803E-02},
    {2407, 1.2733, 0.000E+00, 0.000E+00, 0.000E+00, 4.997E+01, 2.811E+01, 5.795E-02, 8.900E-03, 4.691E-01, 6.730E-02},
    {2408, 1.2732, 0.000E+00, 0.000E+00, 0.000E+00, 5.021E+01, 2.819E+01, 5.580E-02, 8.600E-03, 4.686E-01, 6.657E-02},
    {2409, 1.2732, 0.000E+00, 0.000E+00, 0.000E+00, 5.050E+01, 2.819E+01, 5.365E-02, 8.300E-03, 4.682E-01, 6.584E-02},
    {2410, 1.2731, 0.000E+00, 0.000E+00, 0.000E+00, 5.078E+01, 2.817E+01, 5.150E-02, 8.000E-03, 4.678E-01, 6.511E-02},
    {2411, 1.2730, 0.000E+00, 0.000E+00, 0.000E+00, 5.131E+01, 2.817E+01, 4.935E-02, 7.700E-03, 4.678E-01, 6.445E-02},
    {2412, 1.2730, 0.000E+00, 0.000E+00, 0.000E+00, 5.159E+01, 2.831E+01, 4.720E-02, 7.400E-03, 4.678E-01, 6.379E-02},
    {2413, 1.2729, 0.000E+00, 0.000E+00, 0.000E+00, 5.191E+01, 2.837E+01, 4.505E-02, 7.100E-03, 4.678E-01, 6.313E-02},
    {2414, 1.2729, 0.000E+00, 0.000E+00, 0.000E+00, 5.246E+01, 2.848E+01, 4.290E-02, 6.800E-03, 4.678E-01, 6.247E-02},
    {2415, 1.2728, 0.000E+00, 0.000E+00, 0.000E+00, 5.275E+01, 2.853E+01, 4.075E-02, 6.500E-03, 4.678E-01, 6.182E-02},
    {2416, 1.2727, 0.000E+00, 0.000E+00, 0.000E+00, 5.310E+01, 2.859E+01, 3.860E-02, 6.200E-03, 4.678E-01, 6.167E-02},
    {2417, 1.2727, 0.000E+00, 0.000E+00, 0.000E+00, 5.339E+01, 2.870E+01, 3.645E-02, 5.900E-03, 4.677E-01, 6.153E-02},
    {2418, 1.2726, 0.000E+00, 0.000E+00, 0.000E+00, 5.401E+01, 2.874E+01, 3.430E-02, 5.600E-03, 4.677E-01, 6.138E-02},
    {2419, 1.2726, 0.000E+00, 0.000E+00, 0.000E+00, 5.429E+01, 2.887E+01, 3.215E-02, 5.300E-03, 4.677E-01, 6.124E-02},
    {2420, 1.2725, 0.000E+00, 0.000E+00, 0.000E+00, 5.462E+01, 2.898E+01, 3.000E-02, 5.000E-03, 4.677E-01, 6.110E-02},
    {2421, 1.2725, 0.000E+00, 0.000E+00, 0.000E+00, 5.523E+01, 2.910E+01, 3.195E-02, 5.250E-03, 4.675E-01, 6.018E-02},
    {2422, 1.2724, 0.000E+00, 0.000E+00, 0.000E+00, 5.555E+01, 2.923E+01, 3.390E-02, 5.500E-03, 4.673E-01, 5.927E-02},
    {2423, 1.2724, 0.000E+00, 0.000E+00, 0.000E+00, 5.588E+01, 2.934E+01, 3.585E-02, 5.750E-03, 4.671E-01, 5.835E-02},
    {2424, 1.2723, 0.000E+00, 0.000E+00, 0.000E+00, 5.618E+01, 2.944E+01, 3.780E-02, 6.000E-03, 4.668E-01, 5.743E-02},
    {2425, 1.2723, 0.000E+00, 0.000E+00, 0.000E+00, 5.686E+01, 2.959E+01, 3.975E-02, 6.250E-03, 4.666E-01, 5.652E-02},
    {2426, 1.2722, 0.000E+00, 0.000E+00, 0.000E+00, 5.713E+01, 2.973E+01, 4.170E-02, 6.500E-03, 4.662E-01, 5.619E-02},
    {2427, 1.2722, 0.000E+00, 0.000E+00, 0.000E+00, 5.746E+01, 2.987E+01, 4.365E-02, 6.750E-03, 4.658E-01, 5.585E-02},
    {2428, 1.2721, 0.000E+00, 0.000E+00, 0.000E+00, 5.808E+01, 3.002E+01, 4.560E-02, 7.000E-03, 4.653E-01, 5.552E-02},
    {2429, 1.2721, 0.000E+00, 0.000E+00, 0.000E+00, 5.841E+01, 3.016E+01, 4.755E-02, 7.250E-03, 4.649E-01, 5.519E-02},
    {2430, 1.2720, 0.000E+00, 0.000E+00, 0.000E+00, 5.878E+01, 3.035E+01, 4.950E-02, 7.500E-03, 4.645E-01, 5.485E-02},
    {2431, 1.2720, 0.000E+00, 0.000E+00, 0.000E+00, 5.946E+01, 3.043E+01, 5.145E-02, 7.750E-03, 4.640E-01, 5.485E-02},
    {2432, 1.2719, 0.000E+00, 0.000E+00, 0.000E+00, 5.976E+01, 3.064E+01, 5.340E-02, 8.000E-03, 4.636E-01, 5.485E-02},
    {2433, 1.2719, 0.000E+00, 0.000E+00, 0.000E+00, 6.009E+01, 3.084E+01, 5.535E-02, 8.250E-03, 4.632E-01, 5.485E-02},
    {2434, 1.2718, 0.000E+00, 0.000E+00, 0.000E+00, 6.039E+01, 3.098E+01, 5.730E-02, 8.500E-03, 4.627E-01, 5.484E-02},
    {2435, 1.2718, 0.000E+00, 0.000E+00, 0.000E+00, 6.107E+01, 3.122E+01, 5.925E-02, 8.750E-03, 4.623E-01, 5.484E-02},
    {2436, 1.2717, 0.000E+00, 0.000E+00, 0.000E+00, 6.146E+01, 3.132E+01, 6.120E-02, 9.000E-03, 4.620E-01, 5.455E-02},
    {2437, 1.2717, 0.000E+00, 0.000E+00, 0.000E+00, 6.180E+01, 3.151E+01, 6.315E-02, 9.250E-03, 4.616E-01, 5.425E-02},
    {2438, 1.2716, 0.000E+00, 0.000E+00, 0.000E+00, 6.250E+01, 3.164E+01, 6.510E-02, 9.500E-03, 4.613E-01, 5.396E-02},
    {2439, 1.2716, 0.000E+00, 0.000E+00, 0.000E+00, 6.286E+01, 3.184E+01, 6.705E-02, 9.750E-03, 4.609E-01, 5.366E-02},
    {2440, 1.2715, 0.000E+00, 0.000E+00, 0.000E+00, 6.316E+01, 3.204E+01, 6.900E-02, 1.000E-02, 4.606E-01, 5.337E-02},
    {2441, 1.2715, 0.000E+00, 0.000E+00, 0.000E+00, 6.392E+01, 3.221E+01, 6.755E-02, 9.800E-03, 4.602E-01, 5.337E-02},
    {2442, 1.2714, 0.000E+00, 0.000E+00, 0.000E+00, 6.427E+01, 3.233E+01, 6.610E-02, 9.600E-03, 4.599E-01, 5.337E-02},
    {2443, 1.2714, 0.000E+00, 0.000E+00, 0.000E+00, 6.462E+01, 3.255E+01, 6.465E-02, 9.400E-03, 4.595E-01, 5.336E-02},
    {2444, 1.2713, 0.000E+00, 0.000E+00, 0.000E+00, 6.539E+01, 3.282E+01, 6.320E-02, 9.200E-03, 4.592E-01, 5.336E-02},
    {2445, 1.2713, 0.000E+00, 0.000E+00, 0.000E+00, 6.574E+01, 3.315E+01, 6.175E-02, 9.000E-03, 4.588E-01, 5.336E-02},
    {2446, 1.2713, 0.000E+00, 0.000E+00, 0.000E+00, 6.609E+01, 3.339E+01, 6.030E-02, 8.800E-03, 4.585E-01, 5.316E-02},
    {2447, 1.2713, 0.000E+00, 0.000E+00, 0.000E+00, 6.685E+01, 3.360E+01, 5.885E-02, 8.600E-03, 4.581E-01, 5.297E-02},
    {2448, 1.2712, 0.000E+00, 0.000E+00, 0.000E+00, 6.725E+01, 3.384E+01, 5.740E-02, 8.400E-03, 4.578E-01, 5.278E-02},
    {2449, 1.2712, 0.000E+00, 0.000E+00, 0.000E+00, 6.759E+01, 3.410E+01, 5.595E-02, 8.200E-03, 4.574E-01, 5.258E-02},
    {2450, 1.2712, 0.000E+00, 0.000E+00, 0.000E+00, 6.842E+01, 3.426E+01, 5.450E-02, 8.000E-03, 4.571E-01, 5.239E-02},
    {2451, 1.2712, 0.000E+00, 0.000E+00, 0.000E+00, 6.881E+01, 3.452E+01, 5.305E-02, 7.800E-03, 4.567E-01, 5.192E-02},
    {2452, 1.2711, 0.000E+00, 0.000E+00, 0.000E+00, 6.918E+01, 3.472E+01, 5.160E-02, 7.600E-03, 4.564E-01, 5.145E-02},
    {2453, 1.2711, 0.000E+00, 0.000E+00, 0.000E+00, 7.009E+01, 3.497E+01, 5.015E-02, 7.400E-03, 4.561E-01, 5.099E-02},
    {2454, 1.2710, 0.000E+00, 0.000E+00, 0.000E+00, 7.046E+01, 3.519E+01, 4.870E-02, 7.200E-03, 4.557E-01, 5.052E-02},
    {2455, 1.2710, 0.000E+00, 0.000E+00, 0.000E+00, 7.084E+01, 3.539E+01, 4.725E-02, 7.000E-03, 4.554E-01, 5.005E-02},
    {2456, 1.2710, 0.000E+00, 0.000E+00, 0.000E+00, 7.174E+01, 3.561E+01, 4.580E-02, 6.800E-03, 4.551E-01, 4.963E-02},
    {2457, 1.2710, 0.000E+00, 0.000E+00, 0.000E+00, 7.212E+01, 3.578E+01, 4.435E-02, 6.600E-03, 4.548E-01, 4.921E-02},
    {2458, 1.2709, 0.000E+00, 0.000E+00, 0.000E+00, 7.249E+01, 3.604E+01, 4.290E-02, 6.400E-03, 4.545E-01, 4.878E-02},
    {2459, 1.2709, 0.000E+00, 0.000E+00, 0.000E+00, 7.340E+01, 3.618E+01, 4.145E-02, 6.200E-03, 4.541E-01, 4.836E-02},
    {2460, 1.2709, 0.000E+00, 0.000E+00, 0.000E+00, 7.381E+01, 3.636E+01, 4.000E-02, 6.000E-03, 4.538E-01, 4.793E-02},
    {2461, 1.2709, 0.000E+00, 0.000E+00, 0.000E+00, 7.423E+01, 3.660E+01, 3.960E-02, 5.950E-03, 4.535E-01, 4.777E-02},
    {2462, 1.2709, 0.000E+00, 0.000E+00, 0.000E+00, 7.514E+01, 3.674E+01, 3.920E-02, 5.900E-03, 4.532E-01, 4.761E-02},
    {2463, 1.2708, 0.000E+00, 0.000E+00, 0.000E+00, 7.554E+01, 3.682E+01, 3.880E-02, 5.850E-03, 4.529E-01, 4.744E-02},
    {2464, 1.2708, 0.000E+00, 0.000E+00, 0.000E+00, 7.591E+01, 3.699E+01, 3.840E-02, 5.800E-03, 4.526E-01, 4.728E-02},
    {2465, 1.2708, 0.000E+00, 0.000E+00, 0.000E+00, 7.675E+01, 3.711E+01, 3.800E-02, 5.750E-03, 4.523E-01, 4.711E-02},
    {2466, 1.2708, 0.000E+00, 0.000E+00, 0.000E+00, 7.718E+01, 3.735E+01, 3.760E-02, 5.700E-03, 4.522E-01, 4.727E-02},
    {2467, 1.2708, 0.000E+00, 0.000E+00, 0.000E+00, 7.801E+01, 3.758E+01, 3.720E-02, 5.650E-03, 4.521E-01, 4.743E-02},
    {2468, 1.2708, 0.000E+00, 0.000E+00, 0.000E+00, 7.839E+01, 3.792E+01, 3.680E-02, 5.600E-03, 4.521E-01, 4.759E-02},
    {2469, 1.2708, 0.000E+00, 0.000E+00, 0.000E+00, 7.880E+01, 3.796E+01, 3.640E-02, 5.550E-03, 4.520E-01, 4.774E-02},
    {2470, 1.2708, 0.000E+00, 0.000E+00, 0.000E+00, 7.970E+01, 3.812E+01, 3.600E-02, 5.500E-03, 4.519E-01, 4.790E-02},
    {2471, 1.2708, 0.000E+00, 0.000E+00, 0.000E+00, 8.005E+01, 3.821E+01, 3.560E-02, 5.450E-03, 4.518E-01, 4.796E-02},
    {2472, 1.2708, 0.000E+00, 0.000E+00, 0.000E+00, 8.046E+01, 3.833E+01, 3.520E-02, 5.400E-03, 4.518E-01, 4.801E-02},
    {2473, 1.2708, 0.000E+00, 0.000E+00, 0.000E+00, 8.136E+01, 3.856E+01, 3.480E-02, 5.350E-03, 4.517E-01, 4.807E-02},
    {2474, 1.2708, 0.000E+00, 0.000E+00, 0.000E+00, 8.173E+01, 3.874E+01, 3.440E-02, 5.300E-03, 4.516E-01, 4.813E-02},
    {2475, 1.2708, 0.000E+00, 0.000E+00, 0.000E+00, 8.215E+01, 3.877E+01, 3.400E-02, 5.250E-03, 4.516E-01, 4.818E-02},
    {2476, 1.2708, 0.000E+00, 0.000E+00, 0.000E+00, 8.295E+01, 3.884E+01, 3.360E-02, 5.200E-03, 4.513E-01, 4.833E-02},
    {2477, 1.2709, 0.000E+00, 0.000E+00, 0.000E+00, 8.338E+01, 3.883E+01, 3.320E-02, 5.150E-03, 4.510E-01, 4.847E-02},
    {2478, 1.2709, 0.000E+00, 0.000E+00, 0.000E+00, 8.423E+01, 3.879E+01, 3.280E-02, 5.100E-03, 4.507E-01, 4.861E-02},
    {2479, 1.2710, 0.000E+00, 0.000E+00, 0.000E+00, 8.474E+01, 3.886E+01, 3.240E-02, 5.050E-03, 4.505E-01, 4.876E-02},
    {2480, 1.2710, 0.000E+00, 0.000E+00, 0.000E+00, 8.510E+01, 3.900E+01, 3.200E-02, 5.000E-03, 4.502E-01, 4.890E-02},
    {2481, 1.2711, 0.000E+00, 0.000E+00, 0.000E+00, 8.584E+01, 3.900E+01, 3.110E-02, 4.850E-03, 4.499E-01, 4.904E-02},
    {2482, 1.2712, 0.000E+00, 0.000E+00, 0.000E+00, 8.617E+01, 3.906E+01, 3.020E-02, 4.700E-03, 4.497E-01, 4.919E-02},
    {2483, 1.2712, 0.000E+00, 0.000E+00, 0.000E+00, 8.637E+01, 3.905E+01, 2.930E-02, 4.550E-03, 4.494E-01, 4.933E-02},
    {2484, 1.2713, 0.000E+00, 0.000E+00, 0.000E+00, 8.708E+01, 3.916E+01, 2.840E-02, 4.400E-03, 4.491E-01, 4.947E-02},
    {2485, 1.2714, 0.000E+00, 0.000E+00, 0.000E+00, 8.762E+01, 3.928E+01, 2.750E-02, 4.250E-03, 4.488E-01, 4.962E-02},
    {2486, 1.2715, 0.000E+00, 0.000E+00, 0.000E+00, 8.884E+01, 3.948E+01, 2.660E-02, 4.100E-03, 4.487E-01, 4.961E-02},
    {2487, 1.2716, 0.000E+00, 0.000E+00, 0.000E+00, 8.904E+01, 3.943E+01, 2.570E-02, 3.950E-03, 4.486E-01, 4.961E-02},
    {2488, 1.2717, 0.000E+00, 0.000E+00, 0.000E+00, 8.945E+01, 3.951E+01, 2.480E-02, 3.800E-03, 4.485E-01, 4.961E-02},
    {2489, 1.2718, 0.000E+00, 0.000E+00, 0.000E+00, 9.055E+01, 3.964E+01, 2.390E-02, 3.650E-03, 4.483E-01, 4.961E-02},
    {2490, 1.2719, 0.000E+00, 0.000E+00, 0.000E+00, 9.089E+01, 3.953E+01, 2.300E-02, 3.500E-03, 4.482E-01, 4.960E-02},
    {2491, 1.2720, 0.000E+00, 0.000E+00, 0.000E+00, 9.134E+01, 3.960E+01, 2.210E-02, 3.350E-03, 4.482E-01, 4.960E-02},
    {2492, 1.2722, 0.000E+00, 0.000E+00, 0.000E+00, 9.204E+01, 3.958E+01, 2.120E-02, 3.200E-03, 4.482E-01, 4.960E-02},
    {2493, 1.2723, 0.000E+00, 0.000E+00, 0.000E+00, 9.244E+01, 3.954E+01, 2.030E-02, 3.050E-03, 4.482E-01, 4.960E-02},
    {2494, 1.2725, 0.000E+00, 0.000E+00, 0.000E+00, 9.308E+01, 3.940E+01, 1.940E-02, 2.900E-03, 4.482E-01, 4.959E-02},
    {2495, 1.2726, 0.000E+00, 0.000E+00, 0.000E+00, 9.333E+01, 3.936E+01, 1.850E-02, 2.750E-03, 4.482E-01, 4.959E-02},
    {2496, 1.2728, 0.000E+00, 0.000E+00, 0.000E+00, 9.358E+01, 3.917E+01, 1.760E-02, 2.600E-03, 4.478E-01, 4.944E-02},
    {2497, 1.2730, 0.000E+00, 0.000E+00, 0.000E+00, 9.416E+01, 3.926E+01, 1.670E-02, 2.450E-03, 4.475E-01, 4.930E-02},
    {2498, 1.2732, 0.000E+00, 0.000E+00, 0.000E+00, 9.448E+01, 3.893E+01, 1.580E-02, 2.300E-03, 4.471E-01, 4.915E-02},
    {2499, 1.2734, 0.000E+00, 0.000E+00, 0.000E+00, 9.499E+01, 3.921E+01, 1.490E-02, 2.150E-03, 4.467E-01, 4.900E-02},
    {2500, 1.2736, 0.000E+00, 0.000E+00, 0.000E+00, 9.530E+01, 3.871E+01, 1.400E-02, 2.000E-03, 4.464E-01, 4.885E-02}

};
}
