/**
 * Agent Skill Templates
 *
 * Templates for generating Agent Skills compatible with:
 * - Claude Code
 * - Cursor (Settings → Rules → Import Settings)
 * - Windsurf
 * - Other Agent Skills-compatible editors
 */
export interface SkillTemplate {
    name: string;
    description: string;
    instructions: string;
}
/**
 * Template for openspec-explore skill
 * Explore mode - adaptive thinking partner for exploring ideas and problems
 */
export declare function getExploreSkillTemplate(): SkillTemplate;
/**
 * Template for openspec-new-change skill
 * Based on /opsx:new command
 */
export declare function getNewChangeSkillTemplate(): SkillTemplate;
/**
 * Template for openspec-continue-change skill
 * Based on /opsx:continue command
 */
export declare function getContinueChangeSkillTemplate(): SkillTemplate;
/**
 * Template for openspec-apply-change skill
 * For implementing tasks from a completed (or in-progress) change
 */
export declare function getApplyChangeSkillTemplate(): SkillTemplate;
/**
 * Template for openspec-ff-change skill
 * Fast-forward through artifact creation
 */
export declare function getFfChangeSkillTemplate(): SkillTemplate;
/**
 * Template for openspec-sync-specs skill
 * For syncing delta specs from a change to main specs (agent-driven)
 */
export declare function getSyncSpecsSkillTemplate(): SkillTemplate;
export interface CommandTemplate {
    name: string;
    description: string;
    category: string;
    tags: string[];
    content: string;
}
/**
 * Template for /opsx:explore slash command
 * Explore mode - adaptive thinking partner
 */
export declare function getOpsxExploreCommandTemplate(): CommandTemplate;
/**
 * Template for /opsx:new slash command
 */
export declare function getOpsxNewCommandTemplate(): CommandTemplate;
/**
 * Template for /opsx:continue slash command
 */
export declare function getOpsxContinueCommandTemplate(): CommandTemplate;
/**
 * Template for /opsx:apply slash command
 */
export declare function getOpsxApplyCommandTemplate(): CommandTemplate;
/**
 * Template for /opsx:ff slash command
 */
export declare function getOpsxFfCommandTemplate(): CommandTemplate;
/**
 * Template for openspec-archive-change skill
 * For archiving completed changes in the experimental workflow
 */
export declare function getArchiveChangeSkillTemplate(): SkillTemplate;
/**
 * Template for /opsx:sync slash command
 */
export declare function getOpsxSyncCommandTemplate(): CommandTemplate;
/**
 * Template for /opsx:archive slash command
 */
export declare function getOpsxArchiveCommandTemplate(): CommandTemplate;
//# sourceMappingURL=skill-templates.d.ts.map