/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.SSLLogger;

public class HandshakeOutStream
extends ByteArrayOutputStream {
    OutputRecord outputRecord;

    HandshakeOutStream(OutputRecord outputRecord) {
        this.outputRecord = outputRecord;
    }

    void complete() throws IOException {
        if (this.size() < 4) {
            throw new RuntimeException("handshake message is not available");
        }
        if (this.outputRecord != null) {
            if (!this.outputRecord.isClosed()) {
                this.outputRecord.encodeHandshake(this.buf, 0, this.count);
            } else if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                SSLLogger.warning("outbound has closed, ignore outbound handshake messages", ByteBuffer.wrap(this.buf, 0, this.count));
            }
            this.reset();
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        HandshakeOutStream.checkOverflow(n2, 0x1000000);
        super.write(byArray, n, n2);
    }

    @Override
    public void flush() throws IOException {
        if (this.outputRecord != null) {
            this.outputRecord.flush();
        }
    }

    void putInt8(int n) throws IOException {
        HandshakeOutStream.checkOverflow(n, 256);
        super.write(n);
    }

    void putInt16(int n) throws IOException {
        HandshakeOutStream.checkOverflow(n, 65536);
        super.write(n >> 8);
        super.write(n);
    }

    void putInt24(int n) throws IOException {
        HandshakeOutStream.checkOverflow(n, 0x1000000);
        super.write(n >> 16);
        super.write(n >> 8);
        super.write(n);
    }

    void putInt32(int n) throws IOException {
        super.write(n >> 24);
        super.write(n >> 16);
        super.write(n >> 8);
        super.write(n);
    }

    void putBytes8(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.putInt8(0);
        } else {
            this.putInt8(byArray.length);
            super.write(byArray, 0, byArray.length);
        }
    }

    public void putBytes16(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.putInt16(0);
        } else {
            this.putInt16(byArray.length);
            super.write(byArray, 0, byArray.length);
        }
    }

    void putBytes24(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.putInt24(0);
        } else {
            this.putInt24(byArray.length);
            super.write(byArray, 0, byArray.length);
        }
    }

    private static void checkOverflow(int n, int n2) {
        if (n >= n2) {
            throw new RuntimeException("Field length overflow, the field length (" + n + ") should be less than " + n2);
        }
    }
}

