/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr;

import java.time.Duration;
import java.util.Map;
import jdk.Exported;

@Exported
public abstract class EventSettings {
    EventSettings() {
    }

    public final EventSettings withStackTrace() {
        return this.with("stackTrace", "true");
    }

    public final EventSettings withoutStackTrace() {
        return this.with("stackTrace", "false");
    }

    public final EventSettings withoutThreshold() {
        return this.with("threshold", "0 s");
    }

    public final EventSettings withPeriod(Duration duration) {
        return this.with("period", duration.toNanos() + " ns");
    }

    public final EventSettings withThreshold(Duration duration) {
        if (duration == null) {
            return this.with("threshold", "0 ns");
        }
        return this.with("threshold", duration.toNanos() + " ns");
    }

    public abstract EventSettings with(String var1, String var2);

    abstract Map<String, String> toMap();
}

