/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_en extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "Nauru";
        final String metaValue_TK = "Tokelau";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ar = "Arabic";
        final String metaValue_hy = "Armenian";
        final String metaValue_ae = "Avestan";
        final String metaValue_ban = "Balinese";
        final String metaValue_bn = "Bangla";
        final String metaValue_zbl = "Blissymbols";
        final String metaValue_bug = "Buginese";
        final String metaValue_ccp = "Chakma";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Coptic";
        final String metaValue_ka = "Georgian";
        final String metaValue_got = "Gothic";
        final String metaValue_el = "Greek";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebrew";
        final String metaValue_jv = "Javanese";
        final String metaValue_ja = "Japanese";
        final String metaValue_kaw = "Kawi";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korean";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_lo = "Lao";
        final String metaValue_la = "Latin";
        final String metaValue_mak = "Makasar";
        final String metaValue_men = "Mende";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongolian";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_or = "Odia";
        final String metaValue_osa = "Osage";
        final String metaValue_phn = "Phoenician";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_si = "Sinhala";
        final String metaValue_su = "Sundanese";
        final String metaValue_syr = "Syriac";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_tl = "Tagalog";
        final String metaValue_th = "Thai";
        final String metaValue_bo = "Tibetan";
        final String metaValue_uga = "Ugaritic";
        final String metaValue_vai = "Vai";
        final String metaValue_peo = "Old Persian";
        final String metaValue_ssy = "Saho";
        final Object[][] data = new Object[][] {
            { "001", "world" },
            { "002", "Africa" },
            { "003", "North America" },
            { "005", "South America" },
            { "009", "Oceania" },
            { "011", "Western Africa" },
            { "013", "Central America" },
            { "014", "Eastern Africa" },
            { "015", "Northern Africa" },
            { "017", "Middle Africa" },
            { "018", "Southern Africa" },
            { "019", "Americas" },
            { "021", "Northern America" },
            { "029", "Caribbean" },
            { "030", "Eastern Asia" },
            { "034", "Southern Asia" },
            { "035", "Southeast Asia" },
            { "039", "Southern Europe" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Micronesian Region" },
            { "061", "Polynesia" },
            { "142", "Asia" },
            { "143", "Central Asia" },
            { "145", "Western Asia" },
            { "150", "Europe" },
            { "151", "Eastern Europe" },
            { "154", "Northern Europe" },
            { "155", "Western Europe" },
            { "202", "Sub-Saharan Africa" },
            { "419", "Latin America" },
            { "AC", "Ascension Island" },
            { "AD", "Andorra" },
            { "AE", "United Arab Emirates" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua & Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "AS", "American Samoa" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land Islands" },
            { "AZ", "Azerbaijan" },
            { "BA", "Bosnia & Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgium" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet Island" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Cocos (Keeling) Islands" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Central African Republic" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Switzerland" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cook Islands" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Clipperton Island" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas Island" },
            { "CY", "Cyprus" },
            { "CZ", "Czechia" },
            { "DE", "Germany" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Denmark" },
            { "DM", "Dominica" },
            { "DO", "Dominican Republic" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta & Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estonia" },
            { "EG", "Egypt" },
            { "EH", "Western Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Spain" },
            { "ET", "Ethiopia" },
            { "EU", "European Union" },
            { "EZ", "Eurozone" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falkland Islands" },
            { "FM", "Micronesia" },
            { "FO", "Faroe Islands" },
            { "FR", "France" },
            { "GA", "Gabon" },
            { "GB", "United Kingdom" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "French Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorial Guinea" },
            { "GR", "Greece" },
            { "GS", "South Georgia & South Sandwich Islands" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Heard & McDonald Islands" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "HT", "Haiti" },
            { "HU", "Hungary" },
            { "IC", "Canary Islands" },
            { "ID", "Indonesia" },
            { "IE", "Ireland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "British Indian Ocean Territory" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Iceland" },
            { "IT", "Italy" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "KN", "St. Kitts & Nevis" },
            { "KP", "North Korea" },
            { "KR", "South Korea" },
            { "KW", "Kuwait" },
            { "KY", "Cayman Islands" },
            { "KZ", "Kazakhstan" },
            { "LA", "Laos" },
            { "LB", "Lebanon" },
            { "LC", "St. Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lithuania" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "LY", "Libya" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagascar" },
            { "MH", "Marshall Islands" },
            { "MK", "North Macedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "MO", "Macao SAR China" },
            { "MP", "Northern Mariana Islands" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "New Caledonia" },
            { "NE", "Niger" },
            { "NF", "Norfolk Island" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Netherlands" },
            { "NO", "Norway" },
            { "NP", "Nepal" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "NZ", "New Zealand" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "French Polynesia" },
            { "PG", "Papua New Guinea" },
            { "PH", "Philippines" },
            { "PK", "Pakistan" },
            { "PL", "Poland" },
            { "PM", "St. Pierre & Miquelon" },
            { "PN", "Pitcairn Islands" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinian Territories" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Outlying Oceania" },
            { "RE", "R\u00e9union" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Russia" },
            { "RW", "Rwanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Solomon Islands" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", "Sweden" },
            { "SG", "Singapore" },
            { "SH", "St. Helena" },
            { "SI", "Slovenia" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "South Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 & Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks & Caicos Islands" },
            { "TD", "Chad" },
            { "TF", "French Southern Territories" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tajikistan" },
            { "TK", metaValue_TK },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "T\u00fcrkiye" },
            { "TT", "Trinidad & Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Ukraine" },
            { "UG", "Uganda" },
            { "UM", "U.S. Outlying Islands" },
            { "UN", "United Nations" },
            { "US", "United States" },
            { "UY", "Uruguay" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatican City" },
            { "VC", "St. Vincent & Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "British Virgin Islands" },
            { "VI", "U.S. Virgin Islands" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis & Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-Accents" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Yemen" },
            { "YT", "Mayotte" },
            { "ZA", "South Africa" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Unknown Region" },
            { "aa", "Afar" },
            { "ab", "Abkhazian" },
            { "ae", metaValue_ae },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amharic" },
            { "an", "Aragonese" },
            { "ar", metaValue_ar },
            { "as", "Assamese" },
            { "av", "Avaric" },
            { "ay", "Aymara" },
            { "az", "Azerbaijani" },
            { "ba", "Bashkir" },
            { "be", "Belarusian" },
            { "bg", "Bulgarian" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "Breton" },
            { "bs", "Bosnian" },
            { "ca", "Catalan" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "co", "Corsican" },
            { "cr", "Cree" },
            { "cs", "Czech" },
            { "cu", "Church Slavic" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "da", "Danish" },
            { "de", "German" },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "English" },
            { "eo", "Esperanto" },
            { "es", "Spanish" },
            { "et", "Estonian" },
            { "eu", "Basque" },
            { "fa", "Persian" },
            { "ff", "Fula" },
            { "fi", "Finnish" },
            { "fj", "Fijian" },
            { "fo", "Faroese" },
            { "fr", "French" },
            { "fy", "Western Frisian" },
            { "ga", "Irish" },
            { "gd", "Scottish Gaelic" },
            { "gl", "Galician" },
            { "gn", "Guarani" },
            { "gu", metaValue_gu },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "ho", "Hiri Motu" },
            { "hr", "Croatian" },
            { "ht", "Haitian Creole" },
            { "hu", "Hungarian" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indonesian" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "ik", "Inupiaq" },
            { "io", "Ido" },
            { "is", "Icelandic" },
            { "it", "Italian" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "Kongo" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "ku", "Kurdish" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kyrgyz" },
            { "la", metaValue_la },
            { "lb", "Luxembourgish" },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "ln", "Lingala" },
            { "lo", metaValue_lo },
            { "lt", "Lithuanian" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latvian" },
            { "mg", "Malagasy" },
            { "mh", "Marshallese" },
            { "mi", "M\u0101ori" },
            { "mk", "Macedonian" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malay" },
            { "mt", "Maltese" },
            { "my", "Burmese" },
            { "na", metaValue_NR },
            { "nb", "Norwegian Bokm\u00e5l" },
            { "nd", "North Ndebele" },
            { "ne", "Nepali" },
            { "ng", "Ndonga" },
            { "nl", "Dutch" },
            { "nn", "Norwegian Nynorsk" },
            { "no", "Norwegian" },
            { "nr", "South Ndebele" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Occitan" },
            { "oj", "Ojibwa" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Ossetic" },
            { "pa", "Punjabi" },
            { "pi", "Pali" },
            { "pl", "Polish" },
            { "ps", "Pashto" },
            { "pt", "Portuguese" },
            { "qu", "Quechua" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "ro", "Romanian" },
            { "ru", "Russian" },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskrit" },
            { "sc", "Sardinian" },
            { "sd", "Sindhi" },
            { "se", "Northern Sami" },
            { "sg", "Sango" },
            { "sh", "Serbo-Croatian" },
            { "si", metaValue_si },
            { "sk", "Slovak" },
            { "sl", "Slovenian" },
            { "sm", "Samoan" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "sq", "Albanian" },
            { "sr", "Serbian" },
            { "ss", "Swati" },
            { "st", "Southern Sotho" },
            { "su", metaValue_su },
            { "sv", "Swedish" },
            { "sw", "Swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "ti", "Tigrinya" },
            { "tk", "Turkmen" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", "Tongan" },
            { "tr", "Turkish" },
            { "ts", "Tsonga" },
            { "tt", "Tatar" },
            { "tw", "Twi" },
            { "ty", "Tahitian" },
            { "ug", "Uyghur" },
            { "uk", "Ukrainian" },
            { "ur", "Urdu" },
            { "uz", "Uzbek" },
            { "ve", "Venda" },
            { "vi", "Vietnamese" },
            { "vo", "Volap\u00fck" },
            { "wa", "Walloon" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", "Chinese" },
            { "zu", "Zulu" },
            { "ace", "Acehnese" },
            { "ach", "Acoli" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "aeb", "Tunisian Arabic" },
            { "afh", "Afrihili" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "akk", "Akkadian" },
            { "akz", "Alabama" },
            { "ale", "Aleut" },
            { "aln", "Gheg Albanian" },
            { "alt", "Southern Altai" },
            { "ang", "Old English" },
            { "ann", "Obolo" },
            { "anp", "Angika" },
            { "arc", "Aramaic" },
            { "arn", "Mapuche" },
            { "aro", "Araona" },
            { "arp", "Arapaho" },
            { "arq", "Algerian Arabic" },
            { "ars", "Najdi Arabic" },
            { "arw", "Arawak" },
            { "ary", "Moroccan Arabic" },
            { "arz", "Egyptian Arabic" },
            { "asa", "Asu" },
            { "ase", "American Sign Language" },
            { "ast", "Asturian" },
            { "atj", "Atikamekw" },
            { "avk", "Kotava" },
            { "awa", "Awadhi" },
            { "bal", "Baluchi" },
            { "ban", metaValue_ban },
            { "bar", "Bavarian" },
            { "bas", "Basaa" },
            { "bax", "Bamun" },
            { "bbc", "Batak Toba" },
            { "bbj", "Ghomala" },
            { "bej", "Beja" },
            { "bem", "Bemba" },
            { "bew", "Betawi" },
            { "bez", "Bena" },
            { "bfd", "Bafut" },
            { "bfq", "Badaga" },
            { "bgc", "Haryanvi" },
            { "bgn", "Western Balochi" },
            { "bho", "Bhojpuri" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "bjn", "Banjar" },
            { "bkm", "Kom" },
            { "bla", "Siksik\u00e1" },
            { "blo", "Anii" },
            { "blt", "Tai Dam" },
            { "bpy", "Bishnupriya" },
            { "bqi", "Bakhtiari" },
            { "bra", "Braj" },
            { "brh", "Brahui" },
            { "brx", "Bodo" },
            { "bss", "Akoose" },
            { "bua", "Buriat" },
            { "bug", metaValue_bug },
            { "bum", "Bulu" },
            { "byn", "Blin" },
            { "byv", "Medumba" },
            { "cad", "Caddo" },
            { "car", "Carib" },
            { "cay", "Cayuga" },
            { "cch", "Atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "Cebuano" },
            { "cgg", "Chiga" },
            { "chb", "Chibcha" },
            { "chg", "Chagatai" },
            { "chk", "Chuukese" },
            { "chm", "Mari" },
            { "chn", "Chinook Jargon" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyenne" },
            { "cic", "Chickasaw" },
            { "ckb", "Central Kurdish" },
            { "clc", "Chilcotin" },
            { "cop", metaValue_cop },
            { "cps", "Capiznon" },
            { "crg", "Michif" },
            { "crh", "Crimean Tatar" },
            { "crj", "Southern East Cree" },
            { "crk", "Plains Cree" },
            { "crl", "Northern East Cree" },
            { "crm", "Moose Cree" },
            { "crr", "Carolina Algonquian" },
            { "crs", "Seselwa Creole French" },
            { "csb", "Kashubian" },
            { "csw", "Swampy Cree" },
            { "cwd", "Woods Cree" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "del", "Delaware" },
            { "den", "Slave" },
            { "dgr", "Dogrib" },
            { "din", "Dinka" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Lower Sorbian" },
            { "dtp", "Central Dusun" },
            { "dua", "Duala" },
            { "dum", "Middle Dutch" },
            { "dyo", "Jola-Fonyi" },
            { "dyu", "Dyula" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "egl", "Emilian" },
            { "egy", "Ancient Egyptian" },
            { "eka", "Ekajuk" },
            { "elx", "Elamite" },
            { "enm", "Middle English" },
            { "esu", "Central Yupik" },
            { "ewo", "Ewondo" },
            { "ext", "Extremaduran" },
            { "fan", "Fang" },
            { "fat", "Fanti" },
            { "fil", "Filipino" },
            { "fit", "Tornedalen Finnish" },
            { "fon", "Fon" },
            { "frc", "Cajun French" },
            { "frm", "Middle French" },
            { "fro", "Old French" },
            { "frp", "Arpitan" },
            { "frr", "Northern Frisian" },
            { "frs", "Eastern Frisian" },
            { "fur", "Friulian" },
            { "gaa", "Ga" },
            { "gag", "Gagauz" },
            { "gan", "Gan Chinese" },
            { "gay", "Gayo" },
            { "gba", "Gbaya" },
            { "gbz", "Zoroastrian Dari" },
            { "gez", "Geez" },
            { "gil", "Gilbertese" },
            { "glk", "Gilaki" },
            { "gmh", "Middle High German" },
            { "goh", "Old High German" },
            { "gom", "Goan Konkani" },
            { "gon", "Gondi" },
            { "gor", "Gorontalo" },
            { "got", metaValue_got },
            { "grb", "Grebo" },
            { "grc", "Ancient Greek" },
            { "gsw", "Swiss German" },
            { "guc", "Wayuu" },
            { "gur", "Frafra" },
            { "guz", "Gusii" },
            { "gwi", "Gwich\u02bcin" },
            { "hai", "Haida" },
            { "hak", "Hakka Chinese" },
            { "haw", "Hawaiian" },
            { "hax", "Southern Haida" },
            { "hdn", "Northern Haida" },
            { "hif", "Fiji Hindi" },
            { "hil", "Hiligaynon" },
            { "hit", "Hittite" },
            { "hmn", "Hmong" },
            { "hnj", "Hmong Njua" },
            { "hsb", "Upper Sorbian" },
            { "hsn", "Xiang Chinese" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ike", "Eastern Canadian Inuktitut" },
            { "ikt", "Western Canadian Inuktitut" },
            { "ilo", "Iloko" },
            { "inh", "Ingush" },
            { "izh", "Ingrian" },
            { "jam", "Jamaican Creole English" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "jpr", "Judeo-Persian" },
            { "jrb", "Judeo-Arabic" },
            { "jut", "Jutish" },
            { "kaa", "Kara-Kalpak" },
            { "kab", "Kabyle" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kaw", metaValue_kaw },
            { "kbd", "Kabardian" },
            { "kbl", "Kanembu" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabuverdianu" },
            { "ken", "Kenyang" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi" },
            { "kho", "Khotanese" },
            { "khq", "Koyra Chiini" },
            { "khw", "Khowar" },
            { "kiu", "Kirmanjki" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "koi", "Komi-Permyak" },
            { "kok", "Konkani" },
            { "kos", "Kosraean" },
            { "kpe", metaValue_kpe },
            { "krc", "Karachay-Balkar" },
            { "kri", "Krio" },
            { "krj", "Kinaray-a" },
            { "krl", "Karelian" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Colognian" },
            { "kum", "Kumyk" },
            { "kut", "Kutenai" },
            { "kwk", "Kwak\u02bcwala" },
            { "kxv", "Kuvi" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lah", "Western Panjabi" },
            { "lam", "Lamba" },
            { "lez", "Lezghian" },
            { "lfn", "Lingua Franca Nova" },
            { "lij", "Ligurian" },
            { "lil", "Lillooet" },
            { "liv", "Livonian" },
            { "lkt", "Lakota" },
            { "lmo", "Lombard" },
            { "lol", "Mongo" },
            { "lou", "Louisiana Creole" },
            { "loz", "Lozi" },
            { "lrc", "Northern Luri" },
            { "lsm", "Saamia" },
            { "ltg", "Latgalian" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseno" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Mizo" },
            { "luy", "Luyia" },
            { "lzh", "Literary Chinese" },
            { "lzz", "Laz" },
            { "mad", "Madurese" },
            { "maf", "Mafa" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", metaValue_mak },
            { "man", "Mandingo" },
            { "mas", "Masai" },
            { "mde", "Maba" },
            { "mdf", "Moksha" },
            { "mdr", "Mandar" },
            { "men", metaValue_men },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mga", "Middle Irish" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta\u02bc" },
            { "mic", "Mi'kmaw" },
            { "min", "Minangkabau" },
            { "mnc", "Manchu" },
            { "mni", "Manipuri" },
            { "moe", "Innu-aimun" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mrj", "Western Mari" },
            { "mua", "Mundang" },
            { "mul", "Multiple languages" },
            { "mus", "Muscogee" },
            { "mwl", "Mirandese" },
            { "mwr", "Marwari" },
            { "mwv", "Mentawai" },
            { "mye", "Myene" },
            { "myv", "Erzya" },
            { "mzn", "Mazanderani" },
            { "nan", "Min Nan Chinese" },
            { "nap", "Neapolitan" },
            { "naq", "Nama" },
            { "nds", "Low German" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "niu", "Niuean" },
            { "njo", "Ao Naga" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "non", "Old Norse" },
            { "nov", "Novial" },
            { "nqo", metaValue_nqo },
            { "nso", "Northern Sotho" },
            { "nus", "Nuer" },
            { "nwc", "Classical Newari" },
            { "nym", "Nyamwezi" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "ojb", "Northwestern Ojibwa" },
            { "ojc", "Central Ojibwa" },
            { "ojg", "Eastern Ojibwa" },
            { "ojs", "Oji-Cree" },
            { "ojw", "Western Ojibwa" },
            { "oka", "Okanagan" },
            { "osa", metaValue_osa },
            { "ota", "Ottoman Turkish" },
            { "pag", "Pangasinan" },
            { "pal", "Pahlavi" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palauan" },
            { "pcd", "Picard" },
            { "pcm", "Nigerian Pidgin" },
            { "pdc", "Pennsylvania German" },
            { "pdt", "Plautdietsch" },
            { "peo", metaValue_peo },
            { "pfl", "Palatine German" },
            { "phn", metaValue_phn },
            { "pis", "Pijin" },
            { "pms", "Piedmontese" },
            { "pnt", "Pontic" },
            { "pon", "Pohnpeian" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Prussian" },
            { "pro", "Old Proven\u00e7al" },
            { "quc", "K\u02bciche\u02bc" },
            { "qug", "Chimborazo Highland Quichua" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanui" },
            { "rar", "Rarotongan" },
            { "rgn", "Romagnol" },
            { "rhg", "Rohingya" },
            { "rif", "Riffian" },
            { "rof", "Rombo" },
            { "rom", "Romany" },
            { "rtm", "Rotuman" },
            { "rue", "Rusyn" },
            { "rug", "Roviana" },
            { "rup", "Aromanian" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Yakut" },
            { "sam", "Samaritan Aramaic" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "saz", metaValue_saz },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sicilian" },
            { "sco", "Scots" },
            { "sdc", "Sassarese Sardinian" },
            { "sdh", "Southern Kurdish" },
            { "see", "Seneca" },
            { "seh", "Sena" },
            { "sei", "Seri" },
            { "sel", "Selkup" },
            { "ses", "Koyraboro Senni" },
            { "sga", "Old Irish" },
            { "sgs", "Samogitian" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "shu", "Chadian Arabic" },
            { "sid", "Sidamo" },
            { "slh", "Southern Lushootseed" },
            { "sli", "Lower Silesian" },
            { "sly", "Selayar" },
            { "sma", "Southern Sami" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "sms", "Skolt Sami" },
            { "snk", "Soninke" },
            { "sog", "Sogdien" },
            { "srn", "Sranan Tongo" },
            { "srr", "Serer" },
            { "ssy", metaValue_ssy },
            { "stq", "Saterland Frisian" },
            { "str", "Straits Salish" },
            { "suk", "Sukuma" },
            { "sus", "Susu" },
            { "sux", "Sumerian" },
            { "swb", "Comorian" },
            { "syc", "Classical Syriac" },
            { "syr", metaValue_syr },
            { "szl", "Silesian" },
            { "tce", "Southern Tutchone" },
            { "tcy", "Tulu" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "ter", "Tereno" },
            { "tet", "Tetum" },
            { "tgx", "Tagish" },
            { "tht", "Tahltan" },
            { "tig", "Tigre" },
            { "tiv", "Tiv" },
            { "tkl", metaValue_TK },
            { "tkr", "Tsakhur" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tly", "Talysh" },
            { "tmh", "Tamashek" },
            { "tog", "Nyasa Tonga" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "tru", "Turoyo" },
            { "trv", "Taroko" },
            { "trw", "Torwali" },
            { "tsd", "Tsakonian" },
            { "tsi", "Tsimshian" },
            { "ttm", "Northern Tutchone" },
            { "ttt", "Muslim Tat" },
            { "tum", "Tumbuka" },
            { "tvl", metaValue_TV },
            { "twq", "Tasawaq" },
            { "tyv", "Tuvinian" },
            { "tzm", "Central Atlas Tamazight" },
            { "udm", "Udmurt" },
            { "uga", metaValue_uga },
            { "umb", "Umbundu" },
            { "und", "Unknown language" },
            { "vai", metaValue_vai },
            { "vec", "Venetian" },
            { "vep", "Veps" },
            { "vls", "West Flemish" },
            { "vmf", "Main-Franconian" },
            { "vmw", "Makhuwa" },
            { "vot", "Votic" },
            { "vro", "V\u00f5ro" },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Wolaytta" },
            { "war", "Waray" },
            { "was", "Washo" },
            { "wbp", "Warlpiri" },
            { "wuu", "Wu Chinese" },
            { "xal", "Kalmyk" },
            { "xmf", "Mingrelian" },
            { "xnr", "Kangri" },
            { "xog", "Soga" },
            { "yao", "Yao" },
            { "yap", "Yapese" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Cantonese" },
            { "zap", "Zapotec" },
            { "zbl", metaValue_zbl },
            { "zea", "Zeelandic" },
            { "zen", "Zenaga" },
            { "zgh", "Standard Moroccan Tamazight" },
            { "zun", "Zuni" },
            { "zxx", "No linguistic content" },
            { "zza", "Zaza" },
            { "Adlm", "Adlam" },
            { "Afak", "Afaka" },
            { "Aghb", "Caucasian Albanian" },
            { "Ahom", "Ahom" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastaliq" },
            { "Armi", "Imperial Aramaic" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", "Bamum" },
            { "Bass", "Bassa Vah" },
            { "Batk", "Batak" },
            { "Beng", metaValue_bn },
            { "Bhks", "Bhaiksuki" },
            { "Blis", metaValue_zbl },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "Buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Unified Canadian Aboriginal Syllabics" },
            { "Cari", "Carian" },
            { "Cham", "Cham" },
            { "Cher", metaValue_chr },
            { "Chrs", "Chorasmian" },
            { "Cirt", "Cirth" },
            { "Copt", metaValue_cop },
            { "Cpmn", "Cypro-Minoan" },
            { "Cprt", "Cypriot" },
            { "Cyrl", "Cyrillic" },
            { "Cyrs", "Old Church Slavonic Cyrillic" },
            { "Deva", "Devanagari" },
            { "Diak", "Dives Akuru" },
            { "Dogr", "Dogra" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Duployan shorthand" },
            { "Egyd", "Egyptian demotic" },
            { "Egyh", "Egyptian hieratic" },
            { "Egyp", "Egyptian hieroglyphs" },
            { "Elba", "Elbasan" },
            { "Elym", "Elymaic" },
            { "Ethi", "Ethiopic" },
            { "Geok", "Georgian Khutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "Glagolitic" },
            { "Gong", "Gunjala Gondi" },
            { "Gonm", "Masaram Gondi" },
            { "Goth", metaValue_got },
            { "Gran", "Grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "Gurmukhi" },
            { "Hanb", "Han with Bopomofo" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "Simplified" },
            { "Hant", "Traditional" },
            { "Hatr", "Hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hluw", "Anatolian Hieroglyphs" },
            { "Hmng", "Pahawh Hmong" },
            { "Hmnp", "Nyiakeng Puachue Hmong" },
            { "Hrkt", "Japanese syllabaries" },
            { "Hung", "Old Hungarian" },
            { "Inds", "Indus" },
            { "Ital", "Old Italic" },
            { "Jamo", "Jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "Jurchen" },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Kawi", metaValue_kaw },
            { "Khar", "Kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "Khojki" },
            { "Kits", "Khitan small script" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", metaValue_kpe },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "Fraktur Latin" },
            { "Latg", "Gaelic Latin" },
            { "Latn", metaValue_la },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lisu", "Fraser" },
            { "Loma", "Loma" },
            { "Lyci", "Lycian" },
            { "Lydi", "Lydian" },
            { "Mahj", "Mahajani" },
            { "Maka", metaValue_mak },
            { "Mand", "Mandaean" },
            { "Mani", "Manichaean" },
            { "Marc", "Marchen" },
            { "Maya", "Mayan hieroglyphs" },
            { "Medf", "Medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "Meroitic Cursive" },
            { "Mero", "Meroitic" },
            { "Mlym", metaValue_ml },
            { "Modi", "Modi" },
            { "Mong", metaValue_mn },
            { "Moon", "Moon" },
            { "Mroo", "Mro" },
            { "Mtei", "Meitei Mayek" },
            { "Mult", "Multani" },
            { "Mymr", "Myanmar" },
            { "Nagm", "Nag Mundari" },
            { "Nand", "Nandinagari" },
            { "Narb", "Old North Arabian" },
            { "Nbat", "Nabataean" },
            { "Newa", "Newa" },
            { "Nkgb", "Naxi Geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "N\u00fcshu" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orkhon" },
            { "Orya", metaValue_or },
            { "Osge", metaValue_osa },
            { "Osma", "Osmanya" },
            { "Ougr", "Old Uyghur" },
            { "Palm", "Palmyrene" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "Old Permic" },
            { "Phag", "Phags-pa" },
            { "Phli", "Inscriptional Pahlavi" },
            { "Phlp", "Psalter Pahlavi" },
            { "Phlv", "Book Pahlavi" },
            { "Phnx", metaValue_phn },
            { "Plrd", "Pollard Phonetic" },
            { "Prti", "Inscriptional Parthian" },
            { "Qaag", "Zawgyi" },
            { "Rjng", "Rejang" },
            { "Rohg", "Hanifi" },
            { "Roro", "Rongorongo" },
            { "Runr", "Runic" },
            { "Samr", "Samaritan" },
            { "Sara", "Sarati" },
            { "Sarb", "Old South Arabian" },
            { "Saur", metaValue_saz },
            { "Sgnw", "SignWriting" },
            { "Shaw", "Shavian" },
            { "Shrd", "Sharada" },
            { "Sidd", "Siddham" },
            { "Sind", "Khudawadi" },
            { "Sinh", metaValue_si },
            { "Sogd", "Sogdian" },
            { "Sogo", "Old Sogdian" },
            { "Sora", "Sora Sompeng" },
            { "Soyo", "Soyombo" },
            { "Sund", metaValue_su },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "Estrangelo Syriac" },
            { "Syrj", "Western Syriac" },
            { "Syrn", "Eastern Syriac" },
            { "Tagb", "Tagbanwa" },
            { "Takr", "Takri" },
            { "Tale", "Tai Le" },
            { "Talu", "New Tai Lue" },
            { "Taml", metaValue_ta },
            { "Tang", "Tangut" },
            { "Tavt", "Tai Viet" },
            { "Telu", metaValue_te },
            { "Teng", "Tengwar" },
            { "Tfng", "Tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "Thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "Tirhuta" },
            { "Tnsa", "Tangsa" },
            { "Toto", "Toto" },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "Visible Speech" },
            { "Vith", "Vithkuqi" },
            { "Wara", "Varang Kshiti" },
            { "Wcho", "Wancho" },
            { "Wole", "Woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "Sumero-Akkadian Cuneiform" },
            { "Yezi", "Yezidi" },
            { "Yiii", "Yi" },
            { "Zanb", "Zanabazar Square" },
            { "Zinh", "Inherited" },
            { "Zmth", "Mathematical Notation" },
            { "Zsye", "Emoji" },
            { "Zsym", "Symbols" },
            { "Zxxx", "Unwritten" },
            { "Zyyy", "Common" },
            { "Zzzz", "Unknown Script" },
            { "de_AT", "Austrian German" },
            { "de_CH", "Swiss High German" },
            { "en_AU", "Australian English" },
            { "en_CA", "Canadian English" },
            { "en_GB", "British English" },
            { "en_US", "American English" },
            { "es_ES", "European Spanish" },
            { "es_MX", "Mexican Spanish" },
            { "fa_AF", "Dari" },
            { "fr_CA", "Canadian French" },
            { "fr_CH", "Swiss French" },
            { "nl_BE", "Flemish" },
            { "pt_BR", "Brazilian Portuguese" },
            { "pt_PT", "European Portuguese" },
            { "ro_MD", "Moldavian" },
            { "sr_ME", "Montenegrin" },
            { "sw_CD", "Congo Swahili" },
            { "%%1901", "Traditional German orthography" },
            { "%%1994", "Standardized Resian orthography" },
            { "%%1996", "German orthography of 1996" },
            { "ar_001", "Modern Standard Arabic" },
            { "es_419", "Latin American Spanish" },
            { "key.ca", "Calendar" },
            { "key.cf", "Currency Format" },
            { "key.co", "Sort Order" },
            { "key.cu", "Currency" },
            { "key.d0", "Transform Destination" },
            { "key.dx", "Dictionary Break Exclusions" },
            { "key.em", "Emoji Presentation Style" },
            { "key.fw", "First day of week" },
            { "key.h0", "Mixed-in" },
            { "key.hc", "Hour Cycle (12 vs 24)" },
            { "key.i0", "Input Method" },
            { "key.k0", "Keyboard" },
            { "key.kv", "Highest Ignored" },
            { "key.lb", "Line Break Style" },
            { "key.lw", "Line Breaks In Words Setting" },
            { "key.m0", "Transform Rules" },
            { "key.ms", "Measurement System" },
            { "key.mu", "Measurement Unit" },
            { "key.nu", "Numbers" },
            { "key.rg", "Region For Supplemental Data" },
            { "key.s0", "Transform Source" },
            { "key.sd", "Region Subdivision" },
            { "key.ss", "Sentence Break Suppressions Type" },
            { "key.t0", "Machine Translated" },
            { "key.tz", "Time Zone" },
            { "key.va", "Locale Variant" },
            { "key.x0", "Private-Use Transform" },
            { "nds_NL", "Low Saxon" },
            { "%%ALUKU", "Aluku dialect" },
            { "%%BARLA", "Barlavento dialect group of Kabuverdianu" },
            { "%%BISKE", "San Giorgio/Bila dialect" },
            { "%%BOONT", "Boontling" },
            { "%%KKCOR", "Common Orthography" },
            { "%%KSCOR", "Standard Orthography" },
            { "%%LIPAW", "The Lipovaz dialect of Resian" },
            { "%%NEDIS", "Natisone dialect" },
            { "%%NJIVA", "Gniva/Njiva dialect" },
            { "%%NULIK", "Modern Volap\u00fck" },
            { "%%OSOJS", "Oseacco/Osojane dialect" },
            { "%%POSIX", "Computer" },
            { "%%RIGIK", "Classic Volap\u00fck" },
            { "%%ROZAJ", "Resian" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Stolvizza/Solbica dialect" },
            { "%%SOTAV", "Sotavento dialect group of Kabuverdianu" },
            { "%%UCCOR", "Unified Orthography" },
            { "hi_Latn", "Hindi (Latin)" },
            { "zh_Hans", "Simplified Chinese" },
            { "zh_Hant", "Traditional Chinese" },
            { "%%AO1990", "Portuguese Language Orthographic Agreement of 1990" },
            { "%%DAJNKO", "Dajnko alphabet" },
            { "%%EKAVSK", "Serbian with Ekavian pronunciation" },
            { "%%FONIPA", "IPA Phonetics" },
            { "%%FONUPA", "UPA Phonetics" },
            { "%%NDYUKA", "Ndyuka dialect" },
            { "%%PAMAKA", "Pamaka dialect" },
            { "%%PINYIN", "Pinyin Romanization" },
            { "%%SCOUSE", "Scouse" },
            { "%%TARASK", "Taraskievica orthography" },
            { "%%UCRCOR", "Unified Revised Orthography" },
            { "%%UNIFON", "Unifon phonetic alphabet" },
            { "%%ABL1943", "Orthographic formulation of 1943" },
            { "%%ALALC97", "ALA-LC Romanization, 1997 edition" },
            { "%%AREVELA", "Eastern Armenian" },
            { "%%AREVMDA", "Western Armenian" },
            { "%%BALANKA", "Balanka dialect of Anii" },
            { "%%BOHORIC", "Bohori\u010d alphabet" },
            { "%%EMODENG", "Early Modern English" },
            { "%%HEPBURN", "Hepburn romanization" },
            { "%%METELKO", "Metelko alphabet" },
            { "%%MONOTON", "Monotonic" },
            { "%%POLYTON", "Polytonic" },
            { "%%REVISED", "Revised Orthography" },
            { "%%1606NICT", "Late Middle French to 1606" },
            { "%%1694ACAD", "Early Modern French" },
            { "%%1959ACAD", "Academic" },
            { "%%BAKU1926", "Unified Turkic Latin Alphabet" },
            { "%%COLB1945", "Portuguese-Brazilian Orthographic Convention of 1945" },
            { "%%IJEKAVSK", "Serbian with Ijekavian pronunciation" },
            { "%%OXENDICT", "Oxford English Dictionary spelling" },
            { "%%SCOTLAND", "Scottish Standard English" },
            { "%%VALENCIA", "Valencian" },
            { "%%WADEGILE", "Wade-Giles Romanization" },
            { "type.ca.roc", "Minguo Calendar" },
            { "type.co.eor", "European Ordering Rules" },
            { "type.d0.fcc", "To Unicode FCC" },
            { "type.d0.fcd", "To Unicode FCD" },
            { "type.d0.hex", "To Hexadecimal Codes" },
            { "type.d0.nfc", "To Unicode NFC" },
            { "type.d0.nfd", "To Unicode NFD" },
            { "type.fw.fri", "First Day of Week Is Friday" },
            { "type.fw.mon", "First Day of Week Is Monday" },
            { "type.fw.sat", "First Day of Week Is Saturday" },
            { "type.fw.sun", "First Day of Week Is Sunday" },
            { "type.fw.thu", "First Day of Week Is Thursday" },
            { "type.fw.tue", "First Day of Week Is Tuesday" },
            { "type.fw.wed", "First Day of Week Is Wednesday" },
            { "type.hc.h11", "12 Hour System (0\u201311)" },
            { "type.hc.h12", "12 Hour System (1\u201312)" },
            { "type.hc.h23", "24 Hour System (0\u201323)" },
            { "type.hc.h24", "24 Hour System (1\u201324)" },
            { "type.i0.und", "Unspecified Input Method" },
            { "type.k0.osx", "macOS Keyboard" },
            { "type.k0.und", "Unspecified Keyboard" },
            { "type.k0.var", "Keyboard Variant" },
            { "type.m0.bgn", "US BGN Transliteration" },
            { "type.m0.c11", "Hex transform using C11 syntax" },
            { "type.m0.css", "Hex transform using CSS syntax" },
            { "type.m0.din", "German DIN Transliteration" },
            { "type.m0.iso", "ISO Transliteration" },
            { "type.m0.mns", "Mongolian National Standard Transliteration" },
            { "type.m0.xml", "Hex transform using XML syntax" },
            { "type.s0.hex", "From Hexadecimal Codes" },
            { "type.t0.und", "Unspecified Machine Translation" },
            { "type.d0.nfkc", "To Unicode NFKC" },
            { "type.d0.nfkd", "To Unicode NFKD" },
            { "type.d0.null", "No Change" },
            { "type.em.text", "Prefer Text Presentation For Emoji Characters" },
            { "type.i0.wubi", "Wubi Input Method" },
            { "type.k0.ta99", "Tamil 99 Keyboard" },
            { "type.k0.viqr", "Vietnamese VIQR Keyboard" },
            { "type.m0.ewts", "Extended Wylie Transliteration Scheme" },
            { "type.m0.gost", "CIS GOST Transliteration" },
            { "type.m0.iast", "International Alphabet of Sanskrit Transliteration" },
            { "type.m0.java", "Hex transform using Java syntax" },
            { "type.m0.mcst", "Korean MCST Transliteration" },
            { "type.m0.perl", "Hex transform using Perl syntax" },
            { "type.m0.sera", "System for Ethiopic Representation in ASCII" },
            { "type.nu.adlm", "Adlam Digits" },
            { "type.nu.ahom", "Ahom Digits" },
            { "type.nu.arab", "Arabic-Indic Digits" },
            { "type.nu.armn", "Armenian Numerals" },
            { "type.nu.bali", "Balinese Digits" },
            { "type.nu.beng", "Bangla Digits" },
            { "type.nu.bhks", "Bhaiksuki Digits" },
            { "type.nu.brah", "Brahmi Digits" },
            { "type.nu.cakm", "Chakma Digits" },
            { "type.nu.cham", "Cham Digits" },
            { "type.nu.cyrl", "Cyrillic Numerals" },
            { "type.nu.deva", "Devanagari Digits" },
            { "type.nu.diak", "Dives Akuru Digits" },
            { "type.nu.ethi", "Ethiopic Numerals" },
            { "type.nu.geor", "Georgian Numerals" },
            { "type.nu.gong", "Gunjala Gondi digits" },
            { "type.nu.gonm", "Masaram Gondi digits" },
            { "type.nu.grek", "Greek Numerals" },
            { "type.nu.gujr", "Gujarati Digits" },
            { "type.nu.guru", "Gurmukhi Digits" },
            { "type.nu.hans", "Simplified Chinese Numerals" },
            { "type.nu.hant", "Traditional Chinese Numerals" },
            { "type.nu.hebr", "Hebrew Numerals" },
            { "type.nu.hmng", "Pahawh Hmong Digits" },
            { "type.nu.hmnp", "Nyiakeng Puachue Hmong Digits" },
            { "type.nu.java", "Javanese Digits" },
            { "type.nu.jpan", "Japanese Numerals" },
            { "type.nu.kali", "Kayah Li Digits" },
            { "type.nu.kawi", "Kawi Digits" },
            { "type.nu.khmr", "Khmer Digits" },
            { "type.nu.knda", "Kannada Digits" },
            { "type.nu.lana", "Tai Tham Hora Digits" },
            { "type.nu.laoo", "Lao Digits" },
            { "type.nu.latn", "Western Digits" },
            { "type.nu.lepc", "Lepcha Digits" },
            { "type.nu.limb", "Limbu Digits" },
            { "type.nu.mlym", "Malayalam Digits" },
            { "type.nu.modi", "Modi Digits" },
            { "type.nu.mong", "Mongolian Digits" },
            { "type.nu.mroo", "Mro Digits" },
            { "type.nu.mtei", "Meetei Mayek Digits" },
            { "type.nu.mymr", "Myanmar Digits" },
            { "type.nu.nagm", "Nag Mundari Digits" },
            { "type.nu.newa", "Newa Digits" },
            { "type.nu.nkoo", "N\u2019Ko Digits" },
            { "type.nu.olck", "Ol Chiki Digits" },
            { "type.nu.orya", "Odia Digits" },
            { "type.nu.osma", "Osmanya Digits" },
            { "type.nu.rohg", "Hanifi Rohingya digits" },
            { "type.nu.saur", "Saurashtra Digits" },
            { "type.nu.shrd", "Sharada Digits" },
            { "type.nu.sind", "Khudawadi Digits" },
            { "type.nu.sinh", "Sinhala Lith Digits" },
            { "type.nu.sora", "Sora Sompeng Digits" },
            { "type.nu.sund", "Sundanese Digits" },
            { "type.nu.takr", "Takri Digits" },
            { "type.nu.talu", "New Tai Lue Digits" },
            { "type.nu.taml", "Traditional Tamil Numerals" },
            { "type.nu.telu", "Telugu Digits" },
            { "type.nu.thai", "Thai Digits" },
            { "type.nu.tibt", "Tibetan Digits" },
            { "type.nu.tirh", "Tirhuta Digits" },
            { "type.nu.tnsa", "Tangsa Digits" },
            { "type.nu.vaii", "Vai Digits" },
            { "type.nu.wara", "Warang Citi Digits" },
            { "type.nu.wcho", "Wancho Digits" },
            { "type.ss.none", "Sentence Breaks Without Abbreviation Handling" },
            { "type.ca.dangi", "Dangi Calendar" },
            { "type.co.ducet", "Default Unicode Sort Order" },
            { "type.co.emoji", "Emoji Sort Order" },
            { "type.d0.ascii", "To ASCII" },
            { "type.d0.digit", "To Digit Form Of Accent" },
            { "type.d0.lower", "To Lowercase" },
            { "type.d0.morse", "To Morse Code" },
            { "type.d0.title", "To Titlecase" },
            { "type.d0.upper", "To Uppercase" },
            { "type.em.emoji", "Prefer Emoji Presentation For Emoji Characters" },
            { "type.k0.el220", "Greek 220 Keyboard" },
            { "type.k0.el319", "Greek 319 Keyboard" },
            { "type.k0.isiri", "Persian ISIRI Keyboard" },
            { "type.k0.patta", "Thai Pattachote Keyboard" },
            { "type.kv.punct", "Ignore Symbols affects spaces and punctuation only" },
            { "type.kv.space", "Ignore Symbols affects spaces only" },
            { "type.lb.loose", "Loose Line Break Style" },
            { "type.m0.plain", "Hex transform with no surrounding syntax" },
            { "type.m0.satts", "Standard Arabic Technical Transliteration" },
            { "type.m0.xml10", "Hex transform using XML decimal syntax" },
            { "type.nu.roman", "Roman Numerals" },
            { "type.s0.ascii", "From ASCII" },
            { "type.s0.morse", "From Morse Code" },
            { "type.va.posix", "POSIX Compliant Locale" },
            { "type.ca.coptic", "Coptic Calendar" },
            { "type.ca.hebrew", "Hebrew Calendar" },
            { "type.ca.indian", "Indian National Calendar" },
            { "type.co.compat", "Previous Sort Order, for compatibility" },
            { "type.co.pinyin", "Pinyin Sort Order" },
            { "type.co.search", "General-Purpose Search" },
            { "type.co.stroke", "Stroke Sort Order" },
            { "type.co.unihan", "Radical-Stroke Sort Order" },
            { "type.co.zhuyin", "Zhuyin Sort Order" },
            { "type.d0.fwidth", "To Fullwidth" },
            { "type.d0.hwidth", "To Halfwidth" },
            { "type.d0.remove", "To Empty String" },
            { "type.d0.zawgyi", "To Zawgyi Myanmar Encoding" },
            { "type.h0.hybrid", "Hybrid" },
            { "type.i0.pinyin", "Pinyin Input Method" },
            { "type.k0.101key", "101-Key Keyboard" },
            { "type.k0.102key", "102-Key Keyboard" },
            { "type.k0.600dpi", "600 dpi Keyboard" },
            { "type.k0.768dpi", "768 dpi Keyboard" },
            { "type.k0.azerty", "AZERTY-Based Keyboard" },
            { "type.k0.dvorak", "Dvorak Keyboard" },
            { "type.k0.legacy", "Legacy Keyboard" },
            { "type.k0.lt1205", "Lithuanian LST 1205 Keyboard" },
            { "type.k0.lt1582", "Lithuanian LST 1582 Keyboard" },
            { "type.k0.nutaaq", "Inuktitut Nutaaq Keyboard" },
            { "type.k0.qwerty", "QWERTY-Based Keyboard" },
            { "type.k0.qwertz", "QWERTZ-Based Keyboard" },
            { "type.kv.symbol", "Ignore Symbols affects spaces, punctuation, non-currency symbols" },
            { "type.lb.normal", "Normal Line Break Style" },
            { "type.lb.strict", "Strict Line Break Style" },
            { "type.lw.normal", "Normal Line Breaks For Words" },
            { "type.lw.phrase", "Prevent Line Breaks In Phrases" },
            { "type.m0.alaloc", "US ALA-LOC Transliteration" },
            { "type.m0.es3842", "Ethiopian Standards Agency ES 3842:2014 Ethiopic-Latin Transliteration" },
            { "type.m0.gurage", "Gurage Legacy to Modern Transliteration" },
            { "type.m0.iesjes", "IES/JES Amharic Transliteration" },
            { "type.m0.ungegn", "UN GEGN Transliteration" },
            { "type.ms.metric", "Metric System" },
            { "type.mu.kelvin", "Kelvin" },
            { "type.nu.native", "Native Digits" },
            { "type.s0.zawgyi", "From Zawgyi Myanmar Encoding" },
            { "type.ca.chinese", "Chinese Calendar" },
            { "type.ca.islamic", "Hijri Calendar" },
            { "type.ca.iso8601", "ISO-8601 Calendar" },
            { "type.ca.persian", "Persian Calendar" },
            { "type.cf.account", "Accounting Currency Format" },
            { "type.co.big5han", "Traditional Chinese Sort Order - Big5" },
            { "type.d0.accents", "To Accented Characters From ASCII Sequence" },
            { "type.d0.npinyin", "To Pinyin With Numeric Tones" },
            { "type.d0.publish", "To Publishing Characters From ASCII" },
            { "type.em.default", "Use Default Presentation For Emoji Characters" },
            { "type.k0.android", "Android Keyboard" },
            { "type.k0.colemak", "Colemak Keyboard" },
            { "type.k0.dvorakl", "Dvorak Left-Handed Keyboard" },
            { "type.k0.dvorakr", "Dvorak Right-Handed Keyboard" },
            { "type.k0.windows", "Windows Keyboard" },
            { "type.lw.keepall", "Prevent Line Breaks In All Words" },
            { "type.m0.lambdin", "Thomas Oden Lambdin Ethiopic-Latin Transliteration" },
            { "type.m0.percent", "Hex transform using percent syntax" },
            { "type.m0.unicode", "Hex transform using Unicode syntax" },
            { "type.m0.xaleget", "Eritrean Ministry of Education Blin-Latin Transliteration" },
            { "type.mu.celsius", "Celsius" },
            { "type.nu.arabext", "Extended Arabic-Indic Digits" },
            { "type.nu.armnlow", "Armenian Lowercase Numerals" },
            { "type.nu.finance", "Financial Numerals" },
            { "type.nu.greklow", "Greek Lowercase Numerals" },
            { "type.nu.hanidec", "Chinese Decimal Numerals" },
            { "type.nu.hansfin", "Simplified Chinese Financial Numerals" },
            { "type.nu.hantfin", "Traditional Chinese Financial Numerals" },
            { "type.nu.jpanfin", "Japanese Financial Numerals" },
            { "type.nu.mathdbl", "Mathematical Double-Struck Digits" },
            { "type.nu.segment", "Segmented Digits" },
            { "type.nu.tamldec", "Tamil Digits" },
            { "type.s0.accents", "From Accented Characters To ASCII Sequence" },
            { "type.s0.npinyin", "From Pinyin With Numeric Tones" },
            { "type.s0.publish", "From Publishing Punctuation To ASCII" },
            { "type.ca.buddhist", "Buddhist Calendar" },
            { "type.ca.ethiopic", "Ethiopic Calendar" },
            { "type.ca.japanese", "Japanese Calendar" },
            { "type.cf.standard", "Standard Currency Format" },
            { "type.co.phonetic", "Phonetic Sort Order" },
            { "type.co.searchjl", "Search By Hangul Initial Consonant" },
            { "type.co.standard", "Standard Sort Order" },
            { "type.d0.casefold", "To Casefolded" },
            { "type.d0.charname", "To Unicode Character Names" },
            { "type.i0.handwrit", "Handwriting Input Method" },
            { "type.k0.chromeos", "ChromeOS Keyboard" },
            { "type.k0.extended", "Keyboard With Many Extra Characters" },
            { "type.k0.googlevk", "Google Virtual Keyboard" },
            { "type.kv.currency", "Ignore Symbols affects spaces, punctuation, all symbols" },
            { "type.lw.breakall", "Allow Line Breaks In All Words" },
            { "type.m0.aethiopi", "Encylopedia Aethiopica Transliteration" },
            { "type.m0.betamets", "Beta Ma\u1e63\u0101\u1e25\u01ddft Transliteration" },
            { "type.m0.buckwalt", "Buckwalter Arabic Transliteration" },
            { "type.m0.gutgarts", "Yaros Gutgarts Ethiopic-Cyrillic Transliteration" },
            { "type.m0.prprname", "Personal name transliteration variant" },
            { "type.m0.tekieali", "Tekie Alibekit Blin-Latin Transliteration" },
            { "type.ms.uksystem", "Imperial Measurement System" },
            { "type.ms.ussystem", "US Measurement System" },
            { "type.mu.fahrenhe", "Fahrenheit" },
            { "type.nu.fullwide", "Full-Width Digits" },
            { "type.nu.hanidays", "Chinese Calendar Day-of-Month Numerals" },
            { "type.nu.jpanyear", "Japanese Calendar Gannen Year Numerals" },
            { "type.nu.lanatham", "Tai Tham Tham Digits" },
            { "type.nu.mathbold", "Mathematical Bold Digits" },
            { "type.nu.mathmono", "Mathematical Monospace Digits" },
            { "type.nu.mathsanb", "Mathematical Sans-Serif Bold Digits" },
            { "type.nu.mathsans", "Mathematical Sans-Serif Digits" },
            { "type.nu.mymrshan", "Myanmar Shan Digits" },
            { "type.nu.mymrtlng", "Myanmar Tai Laing Digits" },
            { "type.nu.romanlow", "Roman Lowercase Numerals" },
            { "type.ss.standard", "Suppress Sentence Breaks After Standard Abbreviations" },
            { "type.ca.gregorian", "Gregorian Calendar" },
            { "type.co.gb2312han", "Simplified Chinese Sort Order - GB2312" },
            { "type.co.phonebook", "Phonebook Sort Order" },
            { "type.co.dictionary", "Dictionary Sort Order" },
            { "type.co.traditional", "Traditional Sort Order" },
            { "type.nu.traditional", "Traditional Numerals" },
            { "type.ca.islamic-rgsa", "Hijri Calendar (Saudi Arabia, sighting)" },
            { "type.ca.islamic-tbla", "Hijri Calendar (tabular, astronomical epoch)" },
            { "type.ca.islamic-civil", "Hijri Calendar (tabular, civil epoch)" },
            { "type.ca.islamic-umalqura", "Hijri Calendar (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Ethiopic Amete Alem Calendar" },
        };
        return data;
    }
}
