/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ms extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Waktu Min Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Waktu Piawai Acre",
               "",
               "Waktu Musim Panas Acre",
               "",
               "Waktu Acre",
               "",
            };
        final String[] Apia = new String[] {
               "Waktu Piawai Apia",
               "",
               "Waktu Siang Apia",
               "",
               "Waktu Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Waktu Piawai Kepulauan Cook",
               "",
               "Waktu Musim Panas Separuh Kepulauan Cook",
               "",
               "Waktu Kepulauan Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Waktu Piawai Cuba",
               "CST",
               "Waktu Siang Cuba",
               "CDT",
               "Waktu Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Waktu Piawai Fiji",
               "",
               "Waktu Musim Panas Fiji",
               "",
               "Waktu Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Waktu Piawai Teluk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Waktu Piawai Hovd",
               "",
               "Waktu Musim Panas Hovd",
               "",
               "Waktu Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Waktu Piawai Iran",
               "",
               "Waktu Siang Iran",
               "",
               "Waktu Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Waktu Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Waktu Piawai Omsk",
               "",
               "Waktu Musim Panas Omsk",
               "",
               "Waktu Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Waktu Piawai Peru",
               "",
               "Waktu Musim Panas Peru",
               "",
               "Waktu Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Waktu Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Waktu Pulau Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Waktu Piawai Chile",
               "",
               "Waktu Musim Panas Chile",
               "",
               "Waktu Chile",
               "",
            };
        final String[] China = new String[] {
               "Waktu Piawai China",
               "CST",
               "Waktu Siang China",
               "CDT",
               "Waktu China",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Waktu Kepulauan Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Waktu Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Waktu Piawai India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Waktu Piawai Jepun",
               "JST",
               "Waktu Siang Jepun",
               "JDT",
               "Waktu Jepun",
               "JT",
            };
        final String[] Korea = new String[] {
               "Waktu Piawai Korea",
               "KST",
               "Waktu Siang Korea",
               "KST",
               "Waktu Korea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Waktu Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Waktu Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Waktu Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Waktu Piawai Samoa",
               "SST",
               "Waktu Musim Panas Samoa",
               "SST",
               "Waktu Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Waktu Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Waktu Piawai Tonga",
               "",
               "Waktu Musim Panas Tonga",
               "",
               "Waktu Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Masa Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Waktu Piawai Alaska",
               "AKST",
               "Waktu Siang Alaska",
               "AKDT",
               "Waktu Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Waktu Piawai Amazon",
               "",
               "Waktu Musim Panas Amazon",
               "",
               "Waktu Amazon",
               "",
            };
        final String[] Anadyr = new String[] {
               "Waktu Piawai Anadyr",
               "",
               "Waktu Musim Panas Anadyr",
               "",
               "Waktu Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Waktu Piawai Azores",
               "",
               "Waktu Musim Panas Azores",
               "",
               "Waktu Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Waktu Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Waktu Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Waktu Piawai Pulau Easter",
               "",
               "Waktu Musim Panas Pulau Easter",
               "",
               "Waktu Pulau Easter",
               "",
            };
        final String[] Guyana = new String[] {
               "Waktu Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Waktu Piawai Israel",
               "IST",
               "Waktu Siang Israel",
               "IDT",
               "Waktu Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Waktu Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Waktu Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Waktu Piawai Moscow",
               "MSK",
               "Waktu Musim Panas Moscow",
               "MSK",
               "Waktu Moscow",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Waktu Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Waktu Piawai Samara",
               "",
               "Waktu Musim Panas Samara",
               "",
               "Waktu Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Waktu Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Waktu Piawai Taipei",
               "CST",
               "Waktu Siang Taipei",
               "CDT",
               "Waktu Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Waktu Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Waktu Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Waktu Wallis dan Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Waktu Piawai Arab",
               "",
               "Waktu Siang Arab",
               "",
               "Waktu Arab",
               "",
            };
        final String[] Armenia = new String[] {
               "Waktu Piawai Armenia",
               "",
               "Waktu Musim Panas Armenia",
               "",
               "Waktu Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Waktu Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Waktu Piawai Chatham",
               "",
               "Waktu Siang Chatham",
               "",
               "Waktu Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Waktu Universal Selaras",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Waktu Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Waktu Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Waktu Piawai Georgia",
               "",
               "Waktu Musim Panas Georgia",
               "",
               "Waktu Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Waktu Piawai Irkutsk",
               "",
               "Waktu Musim Panas Irkutsk",
               "",
               "Waktu Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Waktu Piawai Magadan",
               "",
               "Waktu Musim Panas Magadan",
               "",
               "Waktu Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Waktu Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Waktu Piawai Kepulauan Norfolk",
               "",
               "Waktu Siang Kepulauan Norfolk",
               "",
               "Waktu Kepulauan Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Waktu Piawai Fernando de Noronha",
               "",
               "Waktu Musim Panas Fernando de Noronha",
               "",
               "Waktu Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Waktu Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Waktu Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Waktu Kepulauan Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Waktu Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Waktu Piawai Uruguay",
               "",
               "Waktu Musim Panas Uruguay",
               "",
               "Waktu Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Waktu Piawai Vanuatu",
               "",
               "Waktu Musim Panas Vanuatu",
               "",
               "Waktu Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Waktu Piawai Yakutsk",
               "",
               "Waktu Musim Panas Yakutsk",
               "",
               "Waktu Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Waktu Piawai Atlantik",
               "AST",
               "Waktu Siang Atlantik",
               "ADT",
               "Waktu Atlantik",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Waktu Piawai Brasilia",
               "",
               "Waktu Musim Panas Brasilia",
               "",
               "Waktu Brasilia",
               "",
            };
        final String[] Chamorro = new String[] {
               "Waktu Piawai Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Waktu Piawai Colombia",
               "",
               "Waktu Musim Panas Colombia",
               "",
               "Waktu Colombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Waktu Piawai Kepulauan Falkland",
               "",
               "Waktu Musim Panas Kepulauan Falkland",
               "",
               "Waktu Kepulauan Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "Waktu Malaysia",
               "MYT",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Waktu Maldives",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Waktu Piawai Ulan Bator",
               "",
               "Waktu Musim Panas Ulan Bator",
               "",
               "Waktu Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Waktu Piawai Pakistan",
               "PKT",
               "Waktu Musim Panas Pakistan",
               "PKST",
               "Waktu Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Waktu Piawai Paraguay",
               "",
               "Waktu Musim Panas Paraguay",
               "",
               "Waktu Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Waktu Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Waktu Piawai Sakhalin",
               "",
               "Waktu Musim Panas Sakhalin",
               "",
               "Waktu Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Waktu Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Waktu Piawai Argentina",
               "",
               "Waktu Musim Panas Argentina",
               "",
               "Waktu Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Waktu Pulau Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Waktu Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Waktu Piawai Hong Kong",
               "HKT",
               "Waktu Musim Panas Hong Kong",
               "HKST",
               "Waktu Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Waktu Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Waktu Piawai Petropavlovsk-Kamchatski",
               "",
               "Waktu Musim Panas Petropavlovsk-Kamchatski",
               "",
               "Waktu Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Waktu Kyrgystan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Waktu Piawai Lord Howe",
               "",
               "Waktu Siang Lord Howe",
               "",
               "Waktu Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Waktu Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Waktu Piawai Mauritius",
               "",
               "Waktu Musim Panas Mauritius",
               "",
               "Waktu Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Waktu Piawai Singapura",
               "SGT",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Waktu Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Waktu Piawai Volgograd",
               "MSK",
               "Waktu Musim Panas Volgograd",
               "MSK",
               "Waktu Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Waktu Piawai Azerbaijan",
               "",
               "Waktu Musim Panas Azerbaijan",
               "",
               "Waktu Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Waktu Piawai Bangladesh",
               "",
               "Waktu Musim Panas Bangladesh",
               "",
               "Waktu Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Waktu Piawai Tanjung Verde",
               "",
               "Waktu Musim Panas Tanjung Verde",
               "",
               "Waktu Tanjung Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Waktu Timor Timur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Waktu Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Waktu Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Waktu Piawai Uzbekistan",
               "",
               "Waktu Musim Panas Uzbekistan",
               "",
               "Waktu Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Waktu Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Waktu Piawai Krasnoyarsk",
               "",
               "Waktu Musim Panas Krasnoyarsk",
               "",
               "Waktu Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Waktu Piawai New Zealand",
               "NZST",
               "Waktu Siang New Zealand",
               "NZDT",
               "Waktu New Zealand",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Waktu Piawai Novosibirsk",
               "",
               "Waktu Musim Panas Novosibirsk",
               "",
               "Waktu Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Waktu Piawai Filipina",
               "PST",
               "Waktu Musim Panas Filipina",
               "PDT",
               "Waktu Filipina",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Waktu Piawai Vladivostok",
               "",
               "Waktu Musim Panas Vladivostok",
               "",
               "Waktu Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Waktu Lautan Hindi",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Waktu Kepulauan Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Waktu Piawai Newfoundland",
               "NST",
               "Waktu Siang Newfoundland",
               "NDT",
               "Waktu Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Waktu Piawai Turkmenistan",
               "",
               "Waktu Musim Panas Turkmenistan",
               "",
               "Waktu Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Waktu Guyana Perancis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Waktu Piawai New Caledonia",
               "",
               "Waktu Musim Panas New Caledonia",
               "",
               "Waktu New Caledonia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Waktu Georgia Selatan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Waktu Piawai Yekaterinburg",
               "",
               "Waktu Musim Panas Yekaterinburg",
               "",
               "Waktu Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Waktu Afrika Tengah",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Waktu Afrika Timur",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Waktu Piawai Afrika Barat",
               "WAT",
               "Waktu Musim Panas Afrika Barat",
               "WAT",
               "Waktu Afrika Barat",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Waktu Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Waktu Piawai Eropah Tengah",
               "CET",
               "Waktu Musim Panas Eropah Tengah",
               "CEST",
               "Waktu Eropah Tengah",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Waktu Piawai Eropah Timur",
               "EET",
               "Waktu Musim Panas Eropah Timur",
               "EEST",
               "Waktu Eropah Timur",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Waktu Piawai Eropah Barat",
               "WET",
               "Waktu Musim Panas Eropah Barat",
               "WEST",
               "Waktu Eropah Barat",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Waktu Piawai Pasifik Mexico",
               "MST",
               "Waktu Siang Pasifik Mexico",
               "MDT",
               "Waktu Pasifik Mexico",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Waktu Piawai Afrika Selatan",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Waktu Piawai Pusat",
               "CST",
               "Waktu Siang Tengah",
               "CDT",
               "Waktu Pusat",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Waktu Piawai Timur",
               "EST",
               "Waktu Siang Timur",
               "EST",
               "Waktu Timur",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Waktu Piawai Pasifik",
               "PST",
               "Waktu Siang Pasifik",
               "PDT",
               "Waktu Pasifik",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Waktu Perancis Selatan dan Antartika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Waktu Kepulauan Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Waktu Piawai Hawaii-Aleutian",
               "HST",
               "Waktu Siang Hawaii-Aleutian",
               "HST",
               "Waktu Hawaii-Aleutian",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Waktu Kepulauan Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Waktu Piawai Saint Pierre dan Miquelon",
               "",
               "Waktu Siang Saint Pierre dan Miquelon",
               "",
               "Waktu Saint Pierre dan Miquelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Waktu Piawai Pergunungan",
               "MST",
               "Waktu Siang Pergunungan",
               "MST",
               "Waktu Pergunungan",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Waktu Kepulauan Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Waktu Piawai Barat Laut Mexico",
               "",
               "Waktu Siang Barat Laut Mexico",
               "",
               "Waktu Barat Laut Mexico",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Waktu Papua New Guinea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Waktu Piawai Australia Tengah",
               "ACST",
               "Waktu Siang Australia Tengah",
               "ACDT",
               "Waktu Australia Tengah",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Waktu Piawai Timur Australia",
               "AEST",
               "Waktu Siang Australia Timur",
               "AEDT",
               "Waktu Australia Timur",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Waktu Piawai Australia Barat",
               "AWST",
               "Waktu Siang Australia Barat",
               "AWDT",
               "Waktu Australia Barat",
               "AWT",
            };
        final String[] Greenland_Eastern = new String[] {
               "Waktu Piawai Greenland Timur",
               "",
               "Waktu Musim Panas Greenland Timur",
               "",
               "Waktu Greenland Timur",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "Waktu Piawai Greenland Barat",
               "",
               "Waktu Musim Panas Greenland Barat",
               "",
               "Waktu Greenland Barat",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Waktu Indonesia Tengah",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Waktu Indonesia Timur",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Waktu Indonesia Barat",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Waktu Kazakhstan Timur",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Waktu Kazakhstan Barat",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Waktu Piawai Barat Tengah Australia",
               "",
               "Waktu Siang Barat Tengah Australia",
               "",
               "Waktu Barat Tengah Australia",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "JST", Japan },
            { "MIT", Apia },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "SST", Solomon },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UTC", ETC_UTC },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Truk },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kuching", Malaysia },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Ust-Nera", Vladivostok },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Waktu Min Greenwich",
                    "GMT",
                    "Waktu Piawai Ireland",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey", GMT },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Waktu Min Greenwich",
                    "GMT",
                    "Waktu Musim Panas British",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "Asia/Chongqing", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Waktu Min Greenwich",
                    "GMT",
                    "Waktu Musim Panas British",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Pacific/Easter", Easter },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Ponape },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Pacific/Wallis", Wallis },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Godthab", Greenland_Western },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/Perth", Australia_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Etc/Unknown", "Bandar Tidak Diketahui" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Africa/Cairo", "Kaherah" },
            { "timezone.excity.Asia/Damascus", "Damsyik" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Jerusalem", "Baitulmuqaddis" },
            { "timezone.excity.Asia/Singapore", "Singapura" },
            { "timezone.excity.Australia/Currie", "Currie" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.America/Glace_Bay", "Teluk Glace" },
            { "timezone.excity.America/Goose_Bay", "Teluk Goose" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.America/Rainy_River", "Sungai Rainy" },
            { "timezone.excity.America/Santa_Isabel", "Santa Isabel" },
            { "timezone.excity.America/Cambridge_Bay", "Teluk Cambridge" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barthelemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
        };
        return data;
    }
}
