/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mi extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AZ = "Atepaih\u0101nia";
        final String metaValue_DE = "Tiamana";
        final String metaValue_FR = "W\u012bw\u012b";
        final String metaValue_HU = "Hanekari";
        final String metaValue_IS = "Tiorangi";
        final String metaValue_GG = "K\u014dnihi";
        final String metaValue_LU = "Rakapu\u014d";
        final String metaValue_CA = "K\u0101nata";
        final String metaValue_LT = "Ritu\u0101nia";
        final String metaValue_LV = "R\u0101whia";
        final String metaValue_MN = "Mong\u014dria";
        final String metaValue_MT = "M\u0101rata";
        final String metaValue_NR = "Nauru";
        final String metaValue_NO = "N\u014dwei";
        final String metaValue_RO = "Romeinia";
        final String metaValue_SK = "Horow\u0101kia";
        final String metaValue_SI = "Horowinia";
        final String metaValue_WS = "H\u0101moa";
        final String metaValue_RS = "Hirupia";
        final String metaValue_SE = "Huitene";
        final String metaValue_TO = "Tonga";
        final String metaValue_TR = "T\u0101kei";
        final String metaValue_UA = "Ukareinga";
        final String metaValue_VN = "Whitin\u0101mu";
        final String metaValue_PW = "P\u0101rau";
        final String metaValue_hy = "\u0100meniana";
        final String metaValue_ccp = "Tiakam\u0101";
        final String metaValue_ka = "H\u014driana";
        final String metaValue_el = "Kariki";
        final String metaValue_gu = "Kutar\u0101ti";
        final String metaValue_he = "H\u012bperu";
        final String metaValue_ja = "Hapanihi";
        final String metaValue_km = "Kim\u0113ra";
        final String metaValue_ko = "K\u014dreana";
        final String metaValue_lo = "Rao";
        final String metaValue_la = "R\u0101tini";
        final String metaValue_nqo = "Unuk\u014d";
        final String metaValue_syr = "H\u012briaka";
        final String metaValue_te = "Teruku";
        final String metaValue_th = "Tai";
        final String metaValue_bo = "Tipete";
        final String metaValue_vai = "Wai";
        final Object[][] data = new Object[][] {
            { "001", "te ao" },
            { "002", "\u0100wherika" },
            { "003", "Amerika ki te Raki" },
            { "005", "Amerika ki te Tonga" },
            { "009", "Ng\u0101 Moutere-a-Kiwa" },
            { "011", "\u0100wherika ki te Uru" },
            { "013", "Te Puku o Amerika" },
            { "014", "\u0100wherika ki te R\u0101whiti" },
            { "015", "\u0100wherika ki te Raki" },
            { "017", "Te Pokap\u016b o \u0100wherika" },
            { "018", "\u0100wherika Whakatetonga" },
            { "019", "Amerika" },
            { "021", "Te Raki o Amerika" },
            { "029", "Karap\u012bana" },
            { "030", "\u0100hia ki te R\u0101whiti" },
            { "034", "\u0100hia ki te Tonga" },
            { "035", "\u0100hia ki te Tonga-m\u0101-r\u0101whiti" },
            { "039", "\u016aropi ki te Tonga" },
            { "053", "Atareiria" },
            { "054", "Meran\u012bhia" },
            { "057", "Te Rohe o Mekan\u0113hia" },
            { "061", "Te Moana-nui-a-Kiwa" },
            { "142", "\u0100hia" },
            { "143", "Te Puku o \u0100hia" },
            { "145", "\u0100hia ki te Uru" },
            { "150", "\u016aropi" },
            { "151", "\u016aropi ki te R\u0101whiti" },
            { "154", "\u016aropi ki te Raki" },
            { "155", "\u016aropi ki te Uru" },
            { "202", "\u0100wherika ki te Tonga o Te Hah\u0101ra" },
            { "419", "Amerika R\u0101tini" },
            { "AC", "Te Moutere Aupikinga" },
            { "AD", "Anat\u014dra" },
            { "AE", "Kotahitanga o ng\u0101 Whenua o \u0100rapi" },
            { "AF", "Awhekenet\u0101na" },
            { "AG", "Motu Nehe me P\u0101puta" },
            { "AI", "Anguira" },
            { "AL", "Arapeinia" },
            { "AM", "\u0100menia" },
            { "AO", "Anakora" },
            { "AQ", "Te K\u014dpakatanga ki te Tonga" },
            { "AR", "\u0100ketina" },
            { "AS", "H\u0101moa-Amerika" },
            { "AT", "Ataria" },
            { "AU", "Ahitereiria" },
            { "AW", "Ar\u016bpa" },
            { "AX", "Motu \u014crana" },
            { "AZ", metaValue_AZ },
            { "BA", "P\u014dngia-Herek\u014dwini" },
            { "BB", "Papatohe" },
            { "BD", "P\u0101karat\u0113hi" },
            { "BE", "Peretiama" },
            { "BF", "P\u0101kina Wharo" },
            { "BG", "Puruk\u0101ria" },
            { "BH", "P\u0101reina" },
            { "BI", "Puruniti" },
            { "BJ", "Pen\u012bna" },
            { "BL", "Hato P\u0101teremi" },
            { "BM", "P\u0101mura" },
            { "BN", "Poronai" },
            { "BO", "Poriwia" },
            { "BQ", "Karap\u012bana H\u014drana" },
            { "BR", "Par\u012bhi" },
            { "BS", "Pahama" },
            { "BT", "P\u016btana" },
            { "BV", "Motu P\u016bwei" },
            { "BW", "Poriwana" },
            { "BY", "P\u0113rara" },
            { "BZ", "Per\u012bhi" },
            { "CA", metaValue_CA },
            { "CC", "Ng\u0101 Moutere Kokoko (Kirini)" },
            { "CD", "K\u014dngo - Kinih\u0101ha" },
            { "CF", "Te Whenua T\u016bhake o \u0100wherika Waenga" },
            { "CG", "K\u014dngo - P\u0101rawhe" },
            { "CH", "Huiterangi" },
            { "CI", "Te Tai Rei" },
            { "CK", "Kuki Airani" },
            { "CL", "Hiri" },
            { "CM", "Kamar\u016bna" },
            { "CN", "Haina" },
            { "CO", "Korom\u014dpia" },
            { "CP", "Te Moutere Kiripetone" },
            { "CR", "Koto R\u012bka" },
            { "CU", "Kiupa" },
            { "CV", "Te K\u016brae Matomato" },
            { "CW", "Kurahao" },
            { "CX", "Te Moutere Kirihimete" },
            { "CY", "Haipara" },
            { "CZ", "Tiekia" },
            { "DE", metaValue_DE },
            { "DG", "Tieko K\u0101hia" },
            { "DJ", "Tip\u016bti" },
            { "DK", "Tenem\u0101ka" },
            { "DM", "Tominika" },
            { "DO", "Te Whenua T\u016bhake o Tominika" },
            { "DZ", "Aratiria" },
            { "EA", "H\u016bta me Merera" },
            { "EC", "Ekuatoa" },
            { "EE", "Et\u014dnia" },
            { "EG", "\u012ahipa" },
            { "EH", "Hah\u0101ra ki te Tonga" },
            { "ER", "Erit\u0113ria" },
            { "ES", "Peina" },
            { "ET", "Etiopia" },
            { "EU", "Te Uniana o \u016aropi" },
            { "EZ", "Te Rohe o \u016aropi" },
            { "FI", "Whinarana" },
            { "FJ", "Wh\u012bt\u012b" },
            { "FK", "Motu Wh\u0101karangi" },
            { "FM", "Mekan\u0113hia" },
            { "FO", "Motu Wharau" },
            { "FR", metaValue_FR },
            { "GA", "K\u0101pona" },
            { "GB", "Te Hononga o Piritene" },
            { "GD", "Keren\u0101ta" },
            { "GE", "H\u014dria" },
            { "GF", "Ki\u0101na W\u012bw\u012b" },
            { "GG", metaValue_GG },
            { "GH", "K\u0101na" },
            { "GI", "K\u0101maka" },
            { "GL", "Whenuak\u0101riki" },
            { "GM", "Kamopia" },
            { "GN", "Kini" },
            { "GP", "Kuatarupa" },
            { "GQ", "Kini Ekuatoria" },
            { "GR", "Kirihi" },
            { "GS", "H\u014dria ki te Tonga me ng\u0101 Motu Hanawiti ki te Tonga" },
            { "GT", "Kuatam\u0101ra" },
            { "GU", "Kuama" },
            { "GW", "Kini-Pihao" },
            { "GY", "Kaiana" },
            { "HK", "Hongipua Haina" },
            { "HM", "Ng\u0101 Moutere Heriti me Makit\u0101nara" },
            { "HN", "Honotura" },
            { "HR", "Koro\u0101tia" },
            { "HT", "Haiti" },
            { "HU", metaValue_HU },
            { "IC", "Motu Kan\u0113re" },
            { "ID", "Initon\u012bhia" },
            { "IE", "Airani" },
            { "IL", "Iharaira" },
            { "IM", "Te Moutere Mana" },
            { "IN", "Inia" },
            { "IO", "Te Rohe o te Moana \u012aniana Piritihi" },
            { "IQ", "Ir\u0101ka" },
            { "IR", "Ir\u0101na" },
            { "IS", metaValue_IS },
            { "IT", "It\u0101ria" },
            { "JE", "T\u014drehe" },
            { "JM", "Hemeika" },
            { "JO", "H\u014drano" },
            { "JP", "Hapani" },
            { "KE", "Kenia" },
            { "KG", "Kikit\u0101nga" },
            { "KH", "Kamap\u014dtia" },
            { "KI", "Kiripati" },
            { "KM", "Komoro" },
            { "KN", "Hato Kiti me Newhi" },
            { "KP", "K\u014drea ki te Raki" },
            { "KR", "K\u014drea ki te Tonga" },
            { "KW", "K\u016bweiti" },
            { "KY", "Ng\u0101 Motu Keimana" },
            { "KZ", "Katat\u0101nga" },
            { "LA", "R\u0101oho" },
            { "LB", "Repanona" },
            { "LC", "Hato Ruhia" },
            { "LI", "R\u012bkenetaina" },
            { "LK", "Hiri R\u0101naka" },
            { "LR", "Raipiria" },
            { "LS", "Teroto" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", metaValue_LV },
            { "LY", "Ripia" },
            { "MA", "Moroko" },
            { "MC", "Mon\u0101ko" },
            { "MD", "Morotawa" },
            { "ME", "Maungakororiko" },
            { "MF", "Hato M\u0101tene" },
            { "MG", "Matak\u0101hika" },
            { "MH", "Ng\u0101 Motu M\u0101hara" },
            { "MK", "Maker\u014dnia ki te Raki" },
            { "ML", "M\u0101ri" },
            { "MM", "P\u0113ma" },
            { "MN", metaValue_MN },
            { "MO", "Makau Haina" },
            { "MP", "Ng\u0101 Motu Mariana ki te Raki" },
            { "MQ", "M\u0101tiniki" },
            { "MR", "Maurit\u0101nia" },
            { "MS", "Monoter\u0101" },
            { "MT", metaValue_MT },
            { "MU", "Marihi" },
            { "MV", "M\u0101ratiri" },
            { "MW", "Mar\u0101wi" },
            { "MX", "M\u0113hiko" },
            { "MY", "Mareia" },
            { "MZ", "Mohapiki" },
            { "NA", "Namipia" },
            { "NC", "Whenua Kanaki" },
            { "NE", "Ng\u0101ika" },
            { "NF", "Te Moutere N\u014dpoke" },
            { "NG", "Ng\u0101itiria" },
            { "NI", "Nikar\u0101hua" },
            { "NL", "H\u014drana" },
            { "NO", metaValue_NO },
            { "NP", "Nep\u014dra" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "NZ", "Aotearoa" },
            { "OM", "\u014cmana" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Poron\u0113hia W\u012bw\u012b" },
            { "PG", "Papua N\u016bkini" },
            { "PH", "Pirip\u012bni" },
            { "PK", "Pakit\u0101ne" },
            { "PL", "P\u014drana" },
            { "PM", "Hato Piere & Mikerona" },
            { "PN", "Pitikeina" },
            { "PR", "Peta Riko" },
            { "PS", "Ng\u0101 Rohe o Parihitini" },
            { "PT", "Potukara" },
            { "PW", metaValue_PW },
            { "PY", "Parakai" },
            { "QA", "Kat\u0101" },
            { "QO", "Ng\u0101 Moutere-a-Kiwa o Waho atu" },
            { "RE", "Re\u016bnio" },
            { "RO", metaValue_RO },
            { "RS", metaValue_RS },
            { "RU", "R\u016bhia" },
            { "RW", "R\u0101wana" },
            { "SA", "Hauri Ar\u0101pia" },
            { "SB", "Ng\u0101 Motu Horomona" },
            { "SC", "Heikere" },
            { "SD", "H\u016bt\u0101ne" },
            { "SE", metaValue_SE },
            { "SG", "Hingapoa" },
            { "SH", "Hato H\u0113rena" },
            { "SI", metaValue_SI },
            { "SJ", "Heopara me Iana Maiana" },
            { "SK", metaValue_SK },
            { "SL", "Te Araone" },
            { "SM", "Hana Marino" },
            { "SN", "Henekara" },
            { "SO", "H\u016bm\u0101rie" },
            { "SR", "Huriname" },
            { "SS", "H\u016bt\u0101ne ki te Tonga" },
            { "ST", "Hato Tomei me Pirinipei" },
            { "SV", "Whakaora" },
            { "SX", "Hiti M\u0101tene" },
            { "SY", "Hiria" },
            { "SZ", "Ehiwatini" },
            { "TA", "Tiritana da Kunia" },
            { "TC", "Koru-K\u0101koa" },
            { "TD", "K\u0101ta" },
            { "TF", "Ng\u0101 Rohe o W\u012bw\u012b ki te Tonga" },
            { "TG", "Toko" },
            { "TH", "Tairanga" },
            { "TJ", "Takirit\u0101nga" },
            { "TK", "Tokerau" },
            { "TL", "T\u012bmoa ki te R\u0101whiti" },
            { "TM", "Tukumanat\u0101nga" },
            { "TN", "T\u016bnihia" },
            { "TO", metaValue_TO },
            { "TR", metaValue_TR },
            { "TT", "Tirinaki T\u014dpako" },
            { "TV", "T\u016bwaru" },
            { "TW", "Taiwana" },
            { "TZ", "T\u0101nahia" },
            { "UA", metaValue_UA },
            { "UG", "Uk\u0101nga" },
            { "UM", "Ng\u0101 Moutere Amerika o Waho" },
            { "UN", "Te R\u016bnanga Whakakotahi i ng\u0101 Iwi o te Ao" },
            { "US", "Hononga o Amerika" },
            { "UY", "Urukoi" },
            { "UZ", "Uhipeket\u0101ne" },
            { "VA", "Te Poho-o-Pita" },
            { "VC", "Hato W\u0113neti me Keret\u012bni" },
            { "VE", "Peneh\u016bera" },
            { "VG", "Ng\u0101 Moutere Puhi Piritene" },
            { "VI", "Ng\u0101 Moutere Puhi Amerika" },
            { "VN", metaValue_VN },
            { "VU", "Whenuat\u016b" },
            { "WF", "Warihi me Whutuna" },
            { "WS", metaValue_WS },
            { "XA", "Mita kikoika" },
            { "XB", "Piri Kikoika" },
            { "XK", "K\u014dhoro" },
            { "YE", "\u012amene" },
            { "YT", "M\u0101iota" },
            { "ZA", "\u0100wherika ki te Tonga" },
            { "ZM", "T\u0101mipia" },
            { "ZW", "Timuwawe" },
            { "ZZ", "Rohe T\u0113 M\u014dhiotia" },
            { "ab", "Apak\u0101hiana" },
            { "af", "Awherik\u0101na" },
            { "ak", "\u0100kana" },
            { "am", "Amahereka" },
            { "an", "Arakonihi" },
            { "ar", "\u0100rapi" },
            { "as", "\u0100ham\u0113hi" },
            { "av", "\u0100wh\u0101riki" },
            { "ay", "Aim\u0101ra" },
            { "az", metaValue_AZ },
            { "ba", "P\u0101k\u012bra" },
            { "be", "Perar\u016bhiana" },
            { "bg", "Puruk\u0101riana" },
            { "bi", "Pihir\u0101ma" },
            { "bm", "P\u0101para" },
            { "bn", "P\u0101kara" },
            { "bo", metaValue_bo },
            { "br", "Peretana" },
            { "bs", "P\u014dngiana" },
            { "ca", "Katarana" },
            { "ce", "Tietiene" },
            { "ch", "Tiamoro" },
            { "co", "K\u014dhikana" },
            { "cs", "Tieke" },
            { "cv", "Tiuwh\u0101hi" },
            { "cy", "Werehi" },
            { "da", "Teina" },
            { "de", metaValue_DE },
            { "dv", "T\u012bwhehi" },
            { "dz", "Tonoka" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "Ingarihi" },
            { "eo", "Eheper\u0101to" },
            { "es", "P\u0101niora" },
            { "et", "Et\u014dniana" },
            { "eu", "P\u0101kihi" },
            { "fa", "P\u0101hiana" },
            { "ff", "Wh\u016bra" },
            { "fi", "Whinir\u0101nia" },
            { "fj", "Wh\u012bt\u012bana" },
            { "fo", "Wharo\u012bhi" },
            { "fr", metaValue_FR },
            { "fy", "Whir\u012bhiana ki te Uru" },
            { "ga", "Airihi" },
            { "gd", "Keiriki Kotimana" },
            { "gl", "Kar\u012bhia" },
            { "gn", "Kuaran\u012b" },
            { "gu", metaValue_gu },
            { "gv", "Manaki" },
            { "ha", "Hauha" },
            { "he", metaValue_he },
            { "hi", "H\u012bni" },
            { "hr", "Koro\u0101tiana" },
            { "ht", "Kere\u014d Haiti" },
            { "hu", metaValue_HU },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Inar\u012bngua" },
            { "id", "Initon\u012bhiana" },
            { "ig", "Ikapo" },
            { "ii", "H\u012bhuana E\u012b" },
            { "io", "\u012ato" },
            { "is", metaValue_IS },
            { "it", "It\u0101riana" },
            { "iu", "Inukitet\u016bta" },
            { "ja", metaValue_ja },
            { "jv", "H\u0101whanihi" },
            { "ka", metaValue_ka },
            { "ki", "Kik\u016biu" },
            { "kj", "Kuoni\u0101ma" },
            { "kk", "Kah\u0101ka" },
            { "kl", "Karar\u012bhutu" },
            { "km", metaValue_km },
            { "kn", "Kanara" },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kahimiri" },
            { "ku", "K\u016brihi" },
            { "kv", "Komi" },
            { "kw", metaValue_GG },
            { "ky", "Kiakihi" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "lg", metaValue_CA },
            { "li", "Rip\u016bkuihi" },
            { "ln", "Ring\u0101ra" },
            { "lo", metaValue_lo },
            { "lt", metaValue_LT },
            { "lu", "Rupa Katanga" },
            { "lv", metaValue_LV },
            { "mg", "Marak\u0101hi" },
            { "mh", "Marar\u012bhi" },
            { "mi", "M\u0101ori" },
            { "mk", "Maker\u014dnia" },
            { "ml", "Marei\u0101rama" },
            { "mn", metaValue_MN },
            { "mr", "Marati" },
            { "ms", "Marei" },
            { "mt", metaValue_MT },
            { "my", "P\u0113m\u012bhi" },
            { "na", metaValue_NR },
            { "nb", "Pakam\u014d N\u014dwei" },
            { "nd", "Enetep\u0113ra ki te Raki" },
            { "ne", "Nepari" },
            { "ng", "Nat\u014dka" },
            { "nl", "Tati" },
            { "nn", "N\u012bn\u014dka N\u014dwei" },
            { "no", metaValue_NO },
            { "nr", "Enetep\u0113ra ki te Tonga" },
            { "nv", "Nawah\u014d" },
            { "ny", "Ni\u0101nia" },
            { "oc", "\u014ckitana" },
            { "om", "\u014cromo" },
            { "or", "\u014ctia" },
            { "os", "\u014ct\u012btiki" },
            { "pa", "Punutapi" },
            { "pl", "P\u014drihi" },
            { "ps", "P\u0101hit\u014d" },
            { "pt", "P\u014dtuk\u012bhi" },
            { "qu", "K\u0113tua" },
            { "rm", "Rom\u0101nihi" },
            { "rn", "R\u016bniti" },
            { "ro", metaValue_RO },
            { "ru", "Ruhiana" },
            { "rw", "Kiniaw\u0101na" },
            { "sa", "Hanahiti" },
            { "sc", "H\u0101rinia" },
            { "sd", "Hiniti" },
            { "se", "Hami ki te Raki" },
            { "sg", "H\u0101ngo" },
            { "si", "Hinih\u0101ra" },
            { "sk", metaValue_SK },
            { "sl", metaValue_SI },
            { "sm", metaValue_WS },
            { "sn", "H\u014dna" },
            { "so", "Ham\u0101ri" },
            { "sq", "Arapeiniana" },
            { "sr", metaValue_RS },
            { "ss", "W\u0101ti" },
            { "st", "H\u014dto ki te Tonga" },
            { "su", "Hunan\u012bhi" },
            { "sv", metaValue_SE },
            { "sw", "W\u0101h\u012bri" },
            { "ta", "Tamira" },
            { "te", metaValue_te },
            { "tg", "T\u0101hiki" },
            { "th", metaValue_th },
            { "ti", "Tekirinia" },
            { "tk", "T\u0101kamana" },
            { "tn", "Haw\u0101na" },
            { "to", metaValue_TO },
            { "tr", metaValue_TR },
            { "ts", "Honga" },
            { "tt", "Tat\u0101" },
            { "ty", "Tahiti" },
            { "ug", "W\u012bkura" },
            { "uk", metaValue_UA },
            { "ur", "\u016arutu" },
            { "uz", "\u016apeke" },
            { "ve", "W\u0113nera" },
            { "vi", metaValue_VN },
            { "wa", "War\u016bna" },
            { "wo", "Warawhe" },
            { "xh", "T\u014dha" },
            { "yi", "Irihi" },
            { "yo", "\u014cr\u016bpa" },
            { "zh", "Hainamana" },
            { "zu", "T\u016bru" },
            { "ace", "Akan\u012bhi" },
            { "ada", "At\u0101ngami" },
            { "ady", "\u0100teke" },
            { "agq", "\u0100keme" },
            { "ain", "Ainu" },
            { "ale", "Ariuta" },
            { "alt", "\u0100tai ki te Tonga" },
            { "ann", "\u014cporo" },
            { "anp", "Anahika" },
            { "arn", "Map\u016bte" },
            { "arp", "Arapaho" },
            { "ars", "Arapika Nah\u0101ri" },
            { "asa", "Ahu" },
            { "ast", "Ahit\u016briana" },
            { "atj", "Atikameke" },
            { "awa", "Aw\u0101ti" },
            { "ban", "P\u0101rin\u012bhi" },
            { "bas", "Pah\u0101" },
            { "bem", "Pema" },
            { "bez", "Pena" },
            { "bgc", "Herianawhi" },
            { "bho", "P\u014dhipuri" },
            { "bin", "Pini" },
            { "bla", "Hihika" },
            { "brx", "P\u014dto" },
            { "bug", "Puken\u012bhi" },
            { "byn", "Pirina" },
            { "cay", "Kei\u016bka" },
            { "ccp", metaValue_ccp },
            { "ceb", "Hepuano" },
            { "cgg", "Tieka" },
            { "chk", "Tiuk\u012bhi" },
            { "chm", "Mari" },
            { "cho", "Tiokat\u014d" },
            { "chp", "Tiepewaiana" },
            { "chr", "Tierok\u012b" },
            { "chy", "Haiene" },
            { "ckb", "K\u016brihi Waenga" },
            { "clc", "Tiekautini" },
            { "crg", "M\u012btiwhi" },
            { "crj", "Kir\u012b Tonga-m\u0101-R\u0101whiti" },
            { "crk", "Pareina Kir\u012b" },
            { "crl", "Kir\u012b Raki-m\u0101-R\u0101whiti" },
            { "crm", "M\u016bhi Kir\u012b" },
            { "crr", "Arak\u014dkiana Kararaina" },
            { "csw", "W\u0101pi Kir\u012b" },
            { "dak", "Tak\u014dta" },
            { "dar", "T\u0101kawa" },
            { "dav", "Taita" },
            { "dgr", "T\u014dkiripi" },
            { "dje", "T\u0101ma" },
            { "doi", "T\u014dkiri" },
            { "dsb", "H\u014dpiana Hakahaka" },
            { "dua", "Tu\u0101ra" },
            { "dyo", "Hora-Wh\u014dni" },
            { "dzg", "Tah\u0101ka" },
            { "ebu", "Emep\u016b" },
            { "efi", "Ewhiki" },
            { "eka", "Ekatika" },
            { "ewo", "Ew\u0101to" },
            { "fil", "Pirip\u012bno" },
            { "fon", "Wh\u0101na" },
            { "frc", "W\u012bw\u012b Keihana" },
            { "frr", "Whir\u012bhiana ki te Raki" },
            { "fur", "Whiri\u016briana" },
            { "gaa", "K\u0101" },
            { "gez", "K\u012bhi" },
            { "gil", "Kiripat\u012bhi" },
            { "gor", "Kor\u014dtaro" },
            { "gsw", "Tiamana Huiterangi" },
            { "guz", "K\u016bh\u012b" },
            { "gwi", "Kuit\u012bna" },
            { "hai", "Heira" },
            { "haw", "W\u0101hu" },
            { "hax", "Haira ki te Tonga" },
            { "hil", "Hirikaina" },
            { "hmn", "M\u014dnga" },
            { "hsb", "H\u014dpiana Maunga" },
            { "hup", "Hupa" },
            { "hur", "H\u0101komerema" },
            { "iba", "\u012apana" },
            { "ibb", "Ip\u012bpio" },
            { "ikt", "Inukitet\u016bta K\u0101nata ki te Uru" },
            { "ilo", "Iroko" },
            { "inh", "Inguihi" },
            { "jbo", "R\u014dp\u0101na" },
            { "jgo", "Nak\u014dma" },
            { "jmc", "M\u0101kame" },
            { "kab", "Kap\u0101iro" },
            { "kac", "Kat\u012bana" },
            { "kaj", "Heiho" },
            { "kam", "K\u0101mapa" },
            { "kbd", "Kap\u0101riana" },
            { "kcg", "Tiapa" },
            { "kde", "Makonote" },
            { "kea", "Kapuw\u0113tianu" },
            { "kfo", "Koro" },
            { "kgp", "Keinganga" },
            { "kha", "Kahi" },
            { "khq", "K\u014dira T\u012bni" },
            { "kkj", "Kako" },
            { "kln", "Karenini" },
            { "kmb", "Kimipunu" },
            { "kok", "K\u014dkani" },
            { "kpe", "Kep\u0113re" },
            { "krc", "Karatai-P\u0101ka" },
            { "krl", "Kareriana" },
            { "kru", "Kuruka" },
            { "ksb", "Hap\u0101ra" },
            { "ksf", "P\u0101whia" },
            { "ksh", "Kor\u014dniana" },
            { "kum", "Kumiki" },
            { "kwk", "Kuakawara" },
            { "lad", "Ratino" },
            { "lag", "Rangi" },
            { "lez", "R\u0113hiana" },
            { "lil", "Riruete" },
            { "lkt", "Rak\u014dta" },
            { "lou", "Kre\u014dro Ruihiana" },
            { "loz", "Rohi" },
            { "lrc", "Ruri ki te Raki" },
            { "lsm", "H\u0101mia" },
            { "lua", "Rupa Rurua" },
            { "lun", "Runa" },
            { "luo", "Ruo" },
            { "lus", "M\u012bho" },
            { "luy", "R\u016bia" },
            { "mad", "Matur\u012bhi" },
            { "mag", "Mak\u0101hi" },
            { "mai", "Maitiri" },
            { "mak", "Makah\u0101" },
            { "mas", "M\u0101hai" },
            { "mdf", "M\u014dkaha" },
            { "men", "Men\u0113te" },
            { "mer", "Meru" },
            { "mfe", "Morihiene" },
            { "mgh", "Makuwa-M\u0113to" },
            { "mgo", "Meta" },
            { "mic", "M\u012bkam\u0101" },
            { "min", "Min\u0101kapao" },
            { "mni", "Manipuri" },
            { "moe", "Inu-aimuna" },
            { "moh", "Mauh\u014dka" },
            { "mos", "Mohi" },
            { "mua", "M\u016bnatanga" },
            { "mul", "Ng\u0101 reo maha" },
            { "mus", "Muk\u014dki" },
            { "mwl", "Miranat\u012bhi" },
            { "myv", "Ereh\u012ba" },
            { "mzn", "Mahaterani" },
            { "nap", "Neaporitana" },
            { "naq", "Nama" },
            { "nds", "Tiamana Hakahaka" },
            { "new", "Newari" },
            { "nia", "Ni\u0101hi" },
            { "niu", "Niueana" },
            { "nmg", "Kuahio" },
            { "nnh", "Nekiep\u016bna" },
            { "nog", "N\u014dkai" },
            { "nqo", metaValue_nqo },
            { "nso", "Hoto ki te Raki" },
            { "nus", "Nua" },
            { "nyn", "Ni\u0101nakore" },
            { "ojb", "\u014ct\u012bpia Raki-m\u0101-Uru" },
            { "ojc", "Oh\u012bpawe Waenga" },
            { "ojs", "\u014cti-Kir\u012b" },
            { "ojw", "\u014ch\u012bpiwa ki te Uru" },
            { "oka", "\u014ckanakana" },
            { "pag", "P\u0101ngahina" },
            { "pam", "Pamapaka" },
            { "pap", "Papiam\u0113to" },
            { "pau", metaValue_PW },
            { "pcm", "Ng\u0101itiriana K\u014drapurapu" },
            { "pis", "P\u012btini" },
            { "pqm", "Marahiti-Pehamakoare" },
            { "raj", "Ratiahitani" },
            { "rap", "Rapanui" },
            { "rar", "Rarotonga" },
            { "rhg", "Rohingia" },
            { "rof", "Romopo" },
            { "rup", "Aromeiniana" },
            { "rwk", "Rawa" },
            { "sad", "H\u0101tawe" },
            { "sah", "Hak\u016bta" },
            { "saq", "H\u0101mapuru" },
            { "sat", "Hat\u0101ri" },
            { "sba", "Nek\u0101pei" },
            { "sbp", "H\u0101ngu" },
            { "scn", "Hihiriana" },
            { "sco", "Kotimana" },
            { "seh", "Hena" },
            { "ses", "K\u014diraporo Heni" },
            { "shi", "T\u0101hehita" },
            { "shn", "H\u0101na" },
            { "slh", "Rat\u016bti ki te Tonga" },
            { "smn", "Inari Hami" },
            { "sms", "Hakoto H\u0101mi" },
            { "snk", "Hon\u012bke" },
            { "srn", "Har\u0101na Tongo" },
            { "str", "H\u0101rihi Kuititanga" },
            { "suk", "Hukuma" },
            { "swb", "Kom\u014driana" },
            { "syr", metaValue_syr },
            { "tce", "Tat\u014dne ki te Tonga" },
            { "tem", "T\u012bmene" },
            { "teo", "Teho" },
            { "tet", "Tetumu" },
            { "tgx", "T\u0101kihi" },
            { "tht", "T\u0101tana" },
            { "tig", "T\u012bkara" },
            { "tlh", "Kir\u012bngona" },
            { "tli", "Tir\u012bkiti" },
            { "tok", "Toki Pona" },
            { "tpi", "Toko P\u012bhini" },
            { "trv", "Taroko" },
            { "ttm", "T\u016btone ki te Raki" },
            { "tum", "Tum\u016bka" },
            { "tvl", "Tuwaru" },
            { "twq", "Tahawaka" },
            { "tyv", "Tuw\u012bniana" },
            { "tzm", "Tamah\u012bta Te Puku o Atarihi" },
            { "udm", "\u016amutu" },
            { "umb", "\u016apunu" },
            { "und", "Reo T\u0113 M\u014dhiotia" },
            { "vai", metaValue_vai },
            { "vun", "Whunio" },
            { "wae", "W\u0101here" },
            { "wal", "Wareita" },
            { "war", "Warei" },
            { "wuu", "Hainamana W\u016b" },
            { "xal", "Karamiki" },
            { "xog", "Hoka" },
            { "yav", "Angapene" },
            { "ybb", "Emapa" },
            { "yrl", "N\u012bk\u0101t\u016b" },
            { "yue", "Katon\u012bhi" },
            { "zgh", "Moroko Tamatai" },
            { "zun", "Tuni" },
            { "zxx", "Wetereo kiko kore" },
            { "zza", "T\u0101t\u0101" },
            { "Adlm", "Atarama" },
            { "Arab", "Arapika" },
            { "Aran", "N\u0101tarika" },
            { "Armn", metaValue_hy },
            { "Beng", "P\u0101ngara" },
            { "Bopo", "Papamawha" },
            { "Brai", "Tuhi Matap\u014d" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Ng\u0101 K\u016boro o ng\u0101 Iwi Taketake o K\u0101nata kua paiheretia" },
            { "Cher", "Terok\u012b" },
            { "Cyrl", "H\u012bririki" },
            { "Deva", "Tewhang\u0101ngari" },
            { "Ethi", "Etiopika" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "K\u016bmuki" },
            { "Hanb", "Hana me te Papamawha" },
            { "Hang", "H\u0101ng\u016b" },
            { "Hani", "Hana" },
            { "Hans", "M\u0101m\u0101" },
            { "Hant", "Tuku iho" },
            { "Hebr", metaValue_he },
            { "Hira", "Hirakana" },
            { "Hrkt", "K\u016boro Hapanihi" },
            { "Jamo", "Hamo" },
            { "Jpan", metaValue_ja },
            { "Kana", "Katakana" },
            { "Khmr", metaValue_km },
            { "Knda", "Kan\u0101ra" },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", "Marai\u0101rama" },
            { "Mong", metaValue_MN },
            { "Mtei", "Meitei Maeke" },
            { "Mymr", "Mienem\u0101" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "\u014ctiki" },
            { "Orya", "Otia" },
            { "Rohg", "H\u0101niwhi" },
            { "Sinh", "Hin\u0101ra" },
            { "Sund", "Hunanihi" },
            { "Syrc", metaValue_syr },
            { "Taml", "Tamiera" },
            { "Telu", metaValue_te },
            { "Tfng", "Tiwhin\u0101" },
            { "Thaa", "T\u0101na" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "E\u012b" },
            { "Zmth", "Reo Tohu P\u0101ngarau" },
            { "Zsye", "Emohi" },
            { "Zsym", "Tohu" },
            { "Zxxx", "Tuhikore" },
            { "Zyyy", "Komona" },
            { "Zzzz", "Momotuhi T\u0113 M\u014dhiotia" },
            { "de_AT", "Tiamana Ateriana" },
            { "de_CH", "Tiamana \u014ckawa Huiterangi" },
            { "en_AU", "Ingarihi Ahitereiriana" },
            { "en_CA", "Ingarihi K\u0101nata" },
            { "en_GB", "Ingarihi Piritene" },
            { "en_US", "Ingarihi Amerikana" },
            { "es_ES", "P\u0101niora \u016aropi" },
            { "es_MX", "P\u0101niora Mehikana" },
            { "fa_AF", "T\u0101ri" },
            { "fr_CA", "W\u012bw\u012b K\u0101nata" },
            { "fr_CH", "W\u012bw\u012b Huiterangi" },
            { "nl_BE", "Tati Wh\u0113mirihi" },
            { "pt_BR", "P\u014dtuk\u012bhi Parahi" },
            { "pt_PT", "P\u014dtuk\u012bhi Uropi" },
            { "ar_001", "\u0100rapi Moroko" },
            { "es_419", "P\u0101niora Amerikana ki te Tonga" },
            { "key.ca", "Maramataka" },
            { "key.cf", "H\u014dputu Moni" },
            { "key.co", "Raupapa K\u014dmaka" },
            { "key.cu", "Momo Moni" },
            { "key.hc", "Hurihanga Haora (12, 24 r\u0101nei)" },
            { "key.lb", "H\u0101tuhi Whati R\u0101rangi" },
            { "key.ms", "P\u016bnaha Inenga" },
            { "key.nu", "Tau" },
            { "zh_Hans", "Hainamana M\u0101m\u0101" },
            { "zh_Hant", "Hainamana Tukuiho" },
            { "type.ca.roc", "Maramataka Minguo" },
            { "type.hc.h11", "P\u016bnaha Haora 12 (0\u201311)" },
            { "type.hc.h12", "P\u016bnaha Haora 12 (1\u201312)" },
            { "type.hc.h23", "P\u016bnaha Haora 24 (0\u201323)" },
            { "type.hc.h24", "P\u016bnaha Haora 24 (1\u201324)" },
            { "type.nu.arab", "Mati Arap\u012b-\u012ania" },
            { "type.nu.armn", "Tohutau \u0100menia" },
            { "type.nu.beng", "Mati P\u0101kara" },
            { "type.nu.cakm", "Mati Tiakama" },
            { "type.nu.deva", "Mati Tewanakari" },
            { "type.nu.ethi", "Tohutau Etiopia" },
            { "type.nu.geor", "Tohutau H\u014driana" },
            { "type.nu.grek", "Tohutau Kariki" },
            { "type.nu.gujr", "Mati Kuharati" },
            { "type.nu.guru", "Mati Kuramuki" },
            { "type.nu.hans", "Tohutau Haina M\u0101m\u0101" },
            { "type.nu.hant", "Tohutau Haina Tukuiho" },
            { "type.nu.hebr", "Tohutau H\u012bperu" },
            { "type.nu.java", "Mati Tiawha" },
            { "type.nu.jpan", "Tohutau Hapanihi" },
            { "type.nu.khmr", "Mati Kim\u0113ra" },
            { "type.nu.knda", "Mati Kan\u0101ta" },
            { "type.nu.laoo", "Mati Rao" },
            { "type.nu.latn", "Ng\u0101 Mati P\u0101keh\u0101" },
            { "type.nu.mlym", "Mati Maraiarama" },
            { "type.nu.mtei", "Mati M\u0113tei Maieka" },
            { "type.nu.mymr", "Mati P\u0113ma" },
            { "type.nu.olck", "Mati Oro Tieki" },
            { "type.nu.orya", "Mati Oria" },
            { "type.nu.taml", "Tohutau Tamira Tukuiho" },
            { "type.nu.telu", "Mati Teruku" },
            { "type.nu.thai", "Mati Tai" },
            { "type.nu.tibt", "Mati T\u012bpete" },
            { "type.nu.vaii", "Mati Wai" },
            { "type.ca.dangi", "Maramataka Tangi" },
            { "type.co.ducet", "Raupapa K\u014dmaka Unicode Taunoa" },
            { "type.lb.loose", "H\u0101tuhi Whati R\u0101rangi Tangatanga" },
            { "type.nu.roman", "Tohutau R\u014dmana" },
            { "type.ca.coptic", "Maramataka Kopitika" },
            { "type.ca.hebrew", "Maramataka H\u012bperu" },
            { "type.co.search", "Rapunga Arowh\u0101nui" },
            { "type.lb.normal", "H\u0101tuhi Whati R\u0101rangi Taunoa" },
            { "type.lb.strict", "H\u0101tuhi Whati R\u0101rangi P\u0101kaha" },
            { "type.ms.metric", "P\u016bnaha Ngahuru" },
            { "type.ca.chinese", "Maramataka Haina" },
            { "type.ca.islamic", "Maramataka Hitiuri" },
            { "type.ca.iso8601", "Maramataka ISO-8601" },
            { "type.ca.persian", "Maramataka P\u0101hia" },
            { "type.cf.account", "H\u014dputu Moni Mahi Kaute" },
            { "type.nu.arabext", "Mati Arap\u012b-\u012ania Whakaroa" },
            { "type.nu.armnlow", "Tohutau \u0100menia P\u016briki" },
            { "type.nu.greklow", "Tohutau Kariki P\u016briki" },
            { "type.nu.hanidec", "Tohutau Haina \u0101-ira" },
            { "type.nu.hansfin", "Tohutau Ahumoni Haina M\u0101m\u0101" },
            { "type.nu.hantfin", "Tohutau Ahumoni Haina Tukuiho" },
            { "type.nu.jpanfin", "Tohutau Ahumoni Hapanihi" },
            { "type.nu.tamldec", "Mati Tamira" },
            { "type.ca.buddhist", "Maramataka Puta" },
            { "type.ca.ethiopic", "Maramataka Etiopia" },
            { "type.ca.japanese", "Maramataka Hapanihi" },
            { "type.cf.standard", "H\u014dputu Moni Arowh\u0101nui" },
            { "type.co.standard", "Raupapa K\u014dmaka Arowh\u0101nui" },
            { "type.ms.uksystem", "P\u016bnaha Inenga Emepaea" },
            { "type.ms.ussystem", "P\u016bnenga Inenga Amerika" },
            { "type.nu.fullwide", "Mati Wh\u0101nui Rawa" },
            { "type.nu.romanlow", "Tohutau R\u014dmana P\u016briki" },
            { "type.ca.gregorian", "Maramataka P\u0101keh\u0101" },
            { "type.ca.islamic-civil", "Maramataka Hitiuri (t\u016btohi, w\u0101 o nai\u0101nei)" },
            { "type.ca.islamic-umalqura", "Maramataka Hitiuri (Uma ara Kura)" },
            { "type.ca.ethiopic-amete-alem", "Maramataka Etiopia Amete Arema" },
        };
        return data;
    }
}
