//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// <complex>

// template<Arithmetic T>
//   T
//   norm(T x);

#include "support/test_complex.h"

#include "../cases.h"

template <class T>
void
test(T x, ::std::enable_if_t<std::is_integral_v<T>>* = 0)
{
    static_assert((std::is_same_v<decltype(dpl::norm(x)), double>));
    assert(dpl::norm(x) == dpl::norm(dpl::complex<double>(static_cast<double>(x), 0)));
}

template <class T>
void
test(T x, ::std::enable_if_t<!std::is_integral_v<T>>* = 0)
{
    static_assert((std::is_same_v<decltype(dpl::norm(x)), T>));
    assert(dpl::norm(x) == dpl::norm(dpl::complex<T>(x, 0)));
}

template <class T>
void
test()
{
    test<T>(0);
    test<T>(1);
    test<T>(10);
}

ONEDPL_TEST_NUM_MAIN
{
    test<float>();
    IF_DOUBLE_SUPPORT(test<double>())
    IF_LONG_DOUBLE_SUPPORT(test<long double>())
    IF_DOUBLE_SUPPORT(test<int>();
                      test<unsigned>();
                      test<long long>());

  return 0;
}
