# oneAPI DPC++ Library (oneDPL) <img align="right" width="200" height="100" src=https://github.com/uxlfoundation/artwork/blob/main/foundation/uxl-foundation-logo-horizontal-color.svg>
[![Apache License Version 2.0](https://img.shields.io/badge/license-Apache_2.0-green.svg)](LICENSE.txt) [![oneDPL CI](https://github.com/uxlfoundation/oneDPL/actions/workflows/ci-testing.yml/badge.svg)](https://github.com/uxlfoundation/oneDPL/actions/workflows/ci-testing.yml?query=branch%3Amaster)
[![Join the community on GitHub Discussions](https://badgen.net/badge/join%20the%20discussion/on%20github/blue?icon=github)](https://github.com/uxlfoundation/oneDPL/discussions)
[![OpenSSF Scorecard](https://api.securityscorecards.dev/projects/github.com/uxlfoundation/oneDPL/badge)](https://securityscorecards.dev/viewer/?uri=github.com/uxlfoundation/oneDPL)

oneDPL is part of the [UXL Foundation] and is an implementation of the
[oneAPI specification] for the oneDPL component.

[UXL Foundation]: http://www.uxlfoundation.org
[oneAPI specification]: https://oneapi-spec.uxlfoundation.org

oneDPL works with the Intel® oneAPI DPC++/C++ Compiler to provide high-productivity
APIs to developers, which can minimize Data Parallel C++ (DPC++) programming efforts
across devices for high performance parallel applications.

## Prerequisites
Install the Intel® oneAPI Base Toolkit (Base Kit) to use oneDPL. Refer to the specific
[system requirements](https://software.intel.com/content/www/us/en/develop/articles/intel-oneapi-dpcpp-system-requirements.html)
for more information.

## Release Information
Visit the latest [Release Notes](https://github.com/uxlfoundation/oneDPL/blob/main/documentation/release_notes.rst).

## License
oneDPL is licensed under [Apache License Version 2.0 with LLVM exceptions](https://github.com/uxlfoundation/oneDPL/blob/main/LICENSE.txt).
Refer to the [LICENSE](LICENSE.txt) file for the full license text and copyright notice.

## Security
See the [Intel Security Center](https://www.intel.com/content/www/us/en/security-center/default.html)
for information on how to report a potential security issue or vulnerability.
You can also view the [Security Policy](SECURITY.md).

## Contributing
See [CONTRIBUTING.md](https://github.com/uxlfoundation/oneDPL/blob/main/CONTRIBUTING.md) for details.

## Documentation

See the full documentation set for [oneDPL](https://uxlfoundation.github.io/oneDPL).

## Samples
You can find oneDPL samples at the [oneDPL Samples](https://github.com/oneapi-src/oneAPI-samples/tree/master/Libraries/oneDPL) page.

## Support and Contribution
Please report issues and suggestions via [GitHub issues](https://github.com/uxlfoundation/oneDPL/issues).

You can also contact oneDPL developers via [UXL Foundation Slack](https://slack-invite.uxlfoundation.org/) using
the [#onedpl](https://uxlfoundation.slack.com/channels/onedpl) channel.

## Governance

The oneDPL project is governed by the [UXL Foundation] and you can get involved in
this project. Members can join the Open Source and Specification Working Group
meetings to participate in discussions on the evolution of oneDPL and other oneAPI components
governed by the [UXL Foundation]. See [How to Contribute] for more details.

You can also join the [mailing lists for the UXL Foundation] to be informed
of when meetings are happening and receive the latest information and
discussions.

[How to Contribute]: https://www.oneapi.io/community/how-to-contribute/
[mailing lists for the UXL Foundation]: https://lists.uxlfoundation.org/g/main/subgroups

------------------------------------------------------------------------
Intel and the Intel logo are trademarks of Intel Corporation or its subsidiaries in the U.S. and/or other countries.

\* Other names and brands may be claimed as the property of others.
