import { spawnPromisified } from '../common/index.mjs';
import * as fixtures from '../common/fixtures.mjs';
import assert from 'node:assert';
import { execPath } from 'node:process';
import { describe, it } from 'node:test';


describe('ESM: non-js extensions fail', { concurrency: !process.env.TEST_PARALLEL }, () => {
  it(async () => {
    const { code, stderr, signal } = await spawnPromisified(execPath, [
      '--input-type=module',
      '--eval',
      `import ${JSON.stringify(fixtures.fileURL('es-modules', 'file.unknown'))}`,
    ]);

    assert.match(stderr, /ERR_UNKNOWN_FILE_EXTENSION/);
    assert.strictEqual(code, 1);
    assert.strictEqual(signal, null);
  });
});
