<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/integrations/active_directory.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/metadata.yaml"
sidebar_label: "Active Directory"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Windows Systems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Active Directory


<img src="https://netdata.cloud/img/windows.svg" width="150"/>


Plugin: windows.plugin
Module: PerflibAD

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Active Directory IO and queries.


It queries DirectoryServices object from Perflib in order to gather the metrics.


This collector is only supported on the following platforms:

- windows

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

The collector automatically detects all of the metrics, no further configuration is required.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Active Directory

These metrics refer to Active Directory.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| ad.directory_operations | read, write, search | operations/s |
| ad.name_cache_lookups | lookups | lookups/s |
| ad.dra_replication_properties_updated | inbound | properties/s |
| ad.dra_replication_properties_filtered | inbound | properties/s |
| ad.dra_replication_intersite_compressed_traffic | inbound, outbound | bytes/s |
| ad.dra_replication_intrasite_compressed_traffic | inbound, outbound | bytes/s |
| ad.dra_replication_pending_syncs | pending | syncs |
| ad.dra_replication_pending_syncs | pending | syncs |
| ad.dra_replication_sync_requests | request | requests/s |
| ad.dra_replication_sync_objects_remaining | object | objects |
| ad.dra_replication_sync_objects_remaining | object | objects |
| ad.name_cache_hits | hits | hits/s |
| ad.ds_threads | thread | threads |
| ad.ldap_last_bind_time | last_bind | seconds |
| ad.ldap_searches | searches | searches/s |
| ad.atq_average_request_latency | time | seconds |



## Alerts

There are no alerts configured by default for this integration.


## Setup


### Prerequisites

No action required.

### Configuration

#### Options





| Option | Description | Default | Required |
|:-----|:------------|:--------|:---------:|
| update every | Data collection frequency. | 10 | no |




#### via File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:windows:PerflibAD]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```

##### Examples
There are no configuration examples.


