<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/rethinkdb/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/rethinkdb/metadata.yaml"
sidebar_label: "RethinkDB"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Databases"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# RethinkDB


<img src="https://netdata.cloud/img/rethinkdb.png" width="150"/>


Plugin: go.d.plugin
Module: rethinkdb

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

It collects cluster-wide metrics such as server status, client connections, active clients, query rate, and document read/write rates.
For each server, it offers similar metrics.


The data is gathered by querying the stats table in RethinkDB, which stores real-time statistics related to the cluster and its individual servers.


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

If no configuration is given, collector will attempt to connect to RethinkDB instance on `127.0.0.1:28015` address.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per RethinkDB instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| rethinkdb.cluster_servers_stats_request | success, timeout | servers |
| rethinkdb.cluster_client_connections | connections | connections |
| rethinkdb.cluster_active_clients | active | clients |
| rethinkdb.cluster_queries | queries | queries/s |
| rethinkdb.cluster_documents | read, written | documents/s |

### Per server

These metrics refer to the server (cluster member).

Labels:

| Label      | Description     |
|:-----------|:----------------|
| server_uuid | Server UUID. |
| server_name | Server name. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| rethinkdb.server_stats_request_status | success, timeout | status |
| rethinkdb.server_client_connections | connections | connections |
| rethinkdb.server_active_clients | active | clients |
| rethinkdb.server_queries | queries | queries/s |
| rethinkdb.server_documents | read, written | documents/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/rethinkdb.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name1
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/rethinkdb.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| address | The IP address and port where the RethinkDB service listens for connections. | 127.0.0.1:28015 | yes |
| timeout | Connection, read, and write timeout duration in seconds. The timeout includes name resolution. | 1 | no |
| username | Username used for authentication. |  | no |
| password | Password used for authentication. |  | no |

</details>

#### Examples

##### Basic

A basic example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:28015

```
</details>

##### With authentication

An example configuration with authentication.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:28015
    username: name
    password: pass

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:28015

  - name: remote
    address: 203.0.113.0:28015

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `rethinkdb` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m rethinkdb
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m rethinkdb -j jobName
  ```

### Getting Logs

If you're encountering problems with the `rethinkdb` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep rethinkdb
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep rethinkdb /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep rethinkdb
```


