// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef NETDATA_EBPF_MDFLUSH_H
#define NETDATA_EBPF_MDFLUSH_H 1

// Module name & description
#define NETDATA_EBPF_MODULE_NAME_MDFLUSH "mdflush"
#define NETDATA_EBPF_MD_MODULE_DESC "Show information about multi-device software flushes."

// charts
#define NETDATA_MDFLUSH_GLOBAL_CHART "mdflush"

// configuration file
#define NETDATA_DIRECTORY_MDFLUSH_CONFIG_FILE "mdflush.conf"

// copy of mdflush types from kernel-collectors repo.
typedef uint32_t mdflush_ebpf_key_t;
typedef uint64_t mdflush_ebpf_val_t;

typedef struct netdata_mdflush {
    // must be at top for simplified AVL tree usage.
    // if it's not at the top, we need to use `containerof` for almost all ops.
    avl_t avl;

    // key & name of device.
    // the name is generated by the key, usually as `md<unit>`.
    uint32_t unit;
    char disk_name[32];

    // have we defined the dimension for this device yet?
    bool dim_exists;

    // incremental flush count value.
    uint64_t cnt;
} netdata_mdflush_t;

enum netdata_mdflush_targets {
    NETDATA_MD_FLUSH_REQUEST,

    NETDATA_MD_FLUSH_END
};

void *ebpf_mdflush_thread(void *ptr);

extern struct config mdflush_config;
extern netdata_ebpf_targets_t mdflush_targets[];

#endif
