<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/nats/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/nats/metadata.yaml"
sidebar_label: "NATS"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Message Brokers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# NATS


<img src="https://netdata.cloud/img/nats.svg" width="150"/>


Plugin: go.d.plugin
Module: nats

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors the activity and performance of NATS servers.


It sends HTTP requests to the NATS HTTP server's dedicated [monitoring port](https://docs.nats.io/running-a-nats-service/nats_admin/monitoring#monitoring-nats).


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

The collector can automatically detect NATS instances running on:

- localhost that are listening on port 8222
- within Docker containers


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per server

These metrics refer to NATS servers.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| cluster_name | The name of the NATS cluster this server belongs to. |
| server_id | A unique identifier for a server within the NATS cluster. |
| server_name | The configured name of the NATS server. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nats.server_traffic | received, sent | bytes/s |
| nats.server_messages | received, sent | messages/s |
| nats.server_connections | active | connections |
| nats.server_connections_rate | connections | connections/s |
| nats.server_health_probe_status | ok, error | status |
| nats.server_cpu_usage | used | percent |
| nats.server_mem_usage | used | bytes |
| nats.server_uptime | uptime | seconds |
| nats.jetstream_streams | active | streams |
| nats.jetstream_streams_storage_bytes | used | bytes |
| nats.jetstream_streams_storage_messages | stored | messaged |
| nats.jetstream_consumers | active | consumers |
| nats.jetstream_api_requests | requests | requests/s |
| nats.jetstream_api_errors | errors | errors/s |
| nats.jetstream_api_inflight | inflight | requests |
| nats.jetstream_memory_used | used | bytes |
| nats.jetstream_storage_used | used | bytes |

### Per http endpoint

These metrics refer to HTTP endpoints.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| cluster_name | The name of the NATS cluster this server belongs to. |
| server_id | A unique identifier for a server within the NATS cluster. |
| server_name | The configured name of the NATS server. |
| http_endpoint | HTTP endpoint path. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nats.http_endpoint_requests | requests | requests/s |

### Per account

These metrics refer to [Accounts](https://docs.nats.io/running-a-nats-service/nats_admin/monitoring#account-statistics).

Labels:

| Label      | Description     |
|:-----------|:----------------|
| cluster_name | The name of the NATS cluster this server belongs to. |
| server_id | A unique identifier for a server within the NATS cluster. |
| server_name | The configured name of the NATS server. |
| account | Account name. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nats.account_traffic | received, sent | bytes/s |
| nats.account_messages | received, sent | messages/s |
| nats.account_connections | active | connections |
| nats.account_connections_rate | connections | connections/s |
| nats.account_subscriptions | active | subscriptions |
| nats.account_slow_consumers | slow | consumers/s |
| nats.account_leaf_nodes | leafnode | servers |

### Per route

These metrics refer to [Routes](https://docs.nats.io/running-a-nats-service/nats_admin/monitoring#route-information).

Labels:

| Label      | Description     |
|:-----------|:----------------|
| cluster_name | The name of the NATS cluster this server belongs to. |
| server_id | A unique identifier for a server within the NATS cluster. |
| server_name | The configured name of the NATS server. |
| route_id | A unique identifier for a route within the NATS cluster. |
| remote_id | he unique identifier of the remote server connected via the route. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nats.route_traffic | in, out | bytes/s |
| nats.route_messages | in, out | messages/s |
| nats.route_subscriptions | active | subscriptions |

### Per inbound gateway connection

These metrics refer to [Inbound Gateway Connections](https://docs.nats.io/running-a-nats-service/nats_admin/monitoring#gateway-information).

Labels:

| Label      | Description     |
|:-----------|:----------------|
| cluster_name | The name of the NATS cluster this server belongs to. |
| server_id | A unique identifier for a server within the NATS cluster. |
| server_name | The configured name of the NATS server. |
| gateway | The name of the local gateway. |
| remote_gateway | The name of the remote gateway. |
| cid | A unique identifier for the connection. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nats.inbound_gateway_conn_traffic | in, out | bytes/s |
| nats.inbound_gateway_conn_messages | in, out | messages/s |
| nats.inbound_gateway_conn_subscriptions | active | subscriptions |
| nats.inbound_gateway_conn_uptime | uptime | seconds |

### Per outbound gateway connection

These metrics refer to [Outbound Gateway Connections](https://docs.nats.io/running-a-nats-service/nats_admin/monitoring#gateway-information).

Labels:

| Label      | Description     |
|:-----------|:----------------|
| cluster_name | The name of the NATS cluster this server belongs to. |
| server_id | A unique identifier for a server within the NATS cluster. |
| server_name | The configured name of the NATS server. |
| gateway | The name of the local gateway. |
| remote_gateway | The name of the remote gateway. |
| cid | A unique identifier for the connection. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nats.outbound_gateway_conn_traffic | in, out | bytes/s |
| nats.outbound_gateway_conn_messages | in, out | messages/s |
| nats.outbound_gateway_conn_subscriptions | active | subscriptions |
| nats.outbound_gateway_conn_uptime | uptime | seconds |

### Per leaf node connection

These metrics refer to [Leaf Node Connections](https://docs.nats.io/running-a-nats-service/nats_admin/monitoring#leaf-node-information).

Labels:

| Label      | Description     |
|:-----------|:----------------|
| cluster_name | The name of the NATS cluster this server belongs to. |
| server_id | A unique identifier for a server within the NATS cluster. |
| server_name | The configured name of the NATS server. |
| remote_name | Unique identifier of the remote leaf node server, either its configured name or automatically assigned ID. |
| account | Name of the associated account. |
| ip | IP address of the remote server. |
| port | Port used for the connection to the remote server. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| nats.leaf_node_conn_traffic | in, out | bytes/s |
| nats.leaf_node_conn_messages | in, out | messages/s |
| nats.leaf_node_conn_subscriptions | active | subscriptions |
| nats.leaf_node_conn_rtt | rtt | microseconds |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Enable NATS monitoring

See [Enable monitoring](https://docs.nats.io/running-a-nats-service/nats_admin/monitoring#enabling-monitoring).



### Configuration

#### File

The configuration file name for this integration is `go.d/nats.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name1
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/nats.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| url | Server URL. | http://127.0.0.1:8222 | yes |
| timeout | HTTP request timeout. | 1 | no |
| healthz_check | Controls the behavior of the `/healthz` endpoint [health check](https://docs.nats.io/running-a-nats-service/nats_admin/monitoring#health). | default | no |
| username | Username for basic HTTP authentication. |  | no |
| password | Password for basic HTTP authentication. |  | no |
| proxy_url | Proxy URL. |  | no |
| proxy_username | Username for proxy basic HTTP authentication. |  | no |
| proxy_password | Password for proxy basic HTTP authentication. |  | no |
| method | HTTP request method. | GET | no |
| body | HTTP request body. |  | no |
| headers | HTTP request headers. |  | no |
| not_follow_redirects | Redirect handling policy. Controls whether the client follows redirects. | no | no |
| tls_skip_verify | Server certificate chain and hostname validation policy. Controls whether the client performs this check. | no | no |
| tls_ca | Certification authority that the client uses when verifying the server's certificates. |  | no |
| tls_cert | Client TLS certificate. |  | no |
| tls_key | Client TLS key. |  | no |

</details>

#### Examples

##### Basic

A basic example configuration.

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8222

```
##### HTTP authentication

Basic HTTP authentication.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8222
    username: username
    password: password

```
</details>

##### HTTPS with self-signed certificate

NATS with enabled HTTPS and self-signed certificate.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8222
    tls_skip_verify: yes

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8222

  - name: remote
    url: http://192.0.2.1:8222

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `nats` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m nats
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m nats -j jobName
  ```

### Getting Logs

If you're encountering problems with the `nats` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep nats
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep nats /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep nats
```


