# Nodes tab

The **Nodes tab** provides a live, centralized view of every node in your [Room](/docs/netdata-cloud/organize-your-infrastructure-invite-your-team.md#rooms), allowing you to filter, sort, and interact with key node information.

:::tip

All configurations on this page are persistent and visible to all users in the Room.

:::

| Section                              | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                            |
|--------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Center information view**          | Displays one row per node. You can configure and filter the view to focus on the information that matters most.                                                                                                                                                                                                                                                                                                                                                        |
| **Filtering and adjusting the view** | Use the top right-hand corner options to: <br/>• Order nodes by **status** or **alert status** <br/>• Select which charts to display as quick reference points                                                                                                                                                                                                                                                                                                         |
| **Node row actions**                 | For each node, you can: <br/>• View status <br/>• Open the single node dashboard <br/>• Access node details via the sidebar <br/>• View active alerts <br/>• Check Machine Learning status <br/>• Check Functions capability status <br/>• Add configuration (beta) <br/>• [Add alert silencing rules](/docs/alerts-and-notifications/notifications/centralized-cloud-notifications/manage-alert-notification-silencing-rules.md) <br/>• View key collected attributes |
| **Right-hand bar**                   | Offers additional filtering and information options for the nodes displayed in the center view.                                                                                                                                                                                                                                                                                                                                                                        |
| **Node hierarchy (right bar)**       | Displays a hierarchy of the nodes based on the selected ordering, making it easier to locate specific nodes by name.                                                                                                                                                                                                                                                                                                                                                   |
| **Filters sub-tab**                  | Allows filtering of nodes by: <br/>• Host labels <br/>• Node status <br/>• Netdata version <br/>• Individual nodes                                                                                                                                                                                                                                                                                                                                                     |
| **Alerts sub-tab**                   | Displays Room alerts and additional details for each alert.                                                                                                                                                                                                                                                                                                                                                                                                            |
| **Info sub-tab**                     | Shows detailed node information when you click the info (`i`) icon next to a node's name.                                                                                                                                                                                                                                                                                                                                                                              |