 import sonarjs from 'eslint-plugin-sonarjs';

export default [
  {
    files: ['**/*.js'],
    plugins: {
      sonarjs
    },
    languageOptions: {
      ecmaVersion: 2022,
      sourceType: 'module',
      globals: {
        // Browser globals
        window: 'readonly',
        document: 'readonly',
        console: 'readonly',
        localStorage: 'readonly',
        sessionStorage: 'readonly',
        fetch: 'readonly',
        WebSocket: 'readonly',
        setTimeout: 'readonly',
        clearTimeout: 'readonly',
        setInterval: 'readonly',
        clearInterval: 'readonly',
        requestAnimationFrame: 'readonly',
        cancelAnimationFrame: 'readonly',
        navigator: 'readonly',
        location: 'readonly',
        history: 'readonly',
        screen: 'readonly',
        alert: 'readonly',
        confirm: 'readonly',
        prompt: 'readonly',
        HTMLElement: 'readonly',
        HTMLDivElement: 'readonly',
        HTMLButtonElement: 'readonly',
        HTMLInputElement: 'readonly',
        HTMLTextAreaElement: 'readonly',
        HTMLSelectElement: 'readonly',
        HTMLSpanElement: 'readonly',
        HTMLAnchorElement: 'readonly',
        HTMLImageElement: 'readonly',
        HTMLCanvasElement: 'readonly',
        Element: 'readonly',
        Node: 'readonly',
        NodeList: 'readonly',
        DOMParser: 'readonly',
        XMLSerializer: 'readonly',
        ResizeObserver: 'readonly',
        MutationObserver: 'readonly',
        IntersectionObserver: 'readonly',
        FileReader: 'readonly',
        FormData: 'readonly',
        Blob: 'readonly',
        File: 'readonly',
        // Event types
        Event: 'readonly',
        CustomEvent: 'readonly',
        MouseEvent: 'readonly',
        KeyboardEvent: 'readonly',
        FocusEvent: 'readonly',
        InputEvent: 'readonly',
        DragEvent: 'readonly',
        ClipboardEvent: 'readonly',
        // ES globals
        globalThis: 'readonly',
        Date: 'readonly',
        JSON: 'readonly',
        Map: 'readonly',
        Set: 'readonly',
        WeakMap: 'readonly',
        WeakSet: 'readonly',
        Promise: 'readonly',
        Error: 'readonly',
        TypeError: 'readonly',
        ReferenceError: 'readonly',
        SyntaxError: 'readonly',
        Object: 'readonly',
        Array: 'readonly',
        String: 'readonly',
        Number: 'readonly',
        Boolean: 'readonly',
        Symbol: 'readonly',
        Math: 'readonly',
        RegExp: 'readonly',
        parseInt: 'readonly',
        parseFloat: 'readonly',
        isNaN: 'readonly',
        isFinite: 'readonly',
        Infinity: 'readonly',
        NaN: 'readonly',
        undefined: 'readonly',
        Intl: 'readonly',
        URL: 'readonly',
        URLSearchParams: 'readonly',
        Headers: 'readonly',
        Request: 'readonly',
        Response: 'readonly',
        AbortController: 'readonly',
        AbortSignal: 'readonly',
        TextEncoder: 'readonly',
        TextDecoder: 'readonly',
        btoa: 'readonly',
        atob: 'readonly',
        queueMicrotask: 'readonly',
        // App-specific globals
        marked: 'readonly',
        createLLMProvider: 'readonly',
        MCPClient: 'readonly'
      }
    },
    rules: {
      // Error detection
      'no-unused-vars': ['error', { 
        'argsIgnorePattern': '^_',
        'varsIgnorePattern': '^_',
        'caughtErrorsIgnorePattern': '^_',
        'ignoreRestSiblings': true
      }],
      'no-unused-private-class-members': 'error',
      'no-console': 'off',
      'no-constant-condition': ['error', { 'checkLoops': false }],
      'no-empty': ['error', { 'allowEmptyCatch': true }],
      'no-extra-semi': 'error',
      'no-unreachable': 'error',
      'no-unsafe-negation': 'error',
      'no-case-declarations': 'off',
      'no-fallthrough': 'error',
      'no-duplicate-case': 'error',
      'no-dupe-keys': 'error',
      'no-dupe-args': 'error',
      'no-dupe-class-members': 'error',
      'no-sparse-arrays': 'error',
      'no-func-assign': 'error',
      'no-invalid-regexp': 'error',
      'no-unexpected-multiline': 'error',
      'no-global-assign': 'error',
      'no-self-assign': 'error',
      'no-self-compare': 'error',
      'no-unmodified-loop-condition': 'error',
      'use-isnan': 'error',
      'valid-typeof': 'error',
      
      // Best practices
      'semi': ['error', 'always'],
      'quotes': ['error', 'single', { 'avoidEscape': true, 'allowTemplateLiterals': true }],
      'prefer-const': 'error',
      'no-var': 'error',
      'eqeqeq': ['error', 'smart'],
      'no-eval': 'error',
      'no-implied-eval': 'error',
      'no-new-func': 'error',
      'no-return-await': 'error',
      'no-throw-literal': 'error',
      'no-useless-return': 'error',
      'radix': 'error',
      'no-param-reassign': ['error', { 'props': false }],
      'no-redeclare': 'error',
      'no-shadow': ['warn', { 'builtinGlobals': false, 'hoist': 'functions' }],
      'no-use-before-define': ['error', { 'functions': false, 'classes': true, 'variables': true }],
      
      // Async/Promise rules
      'no-async-promise-executor': 'error',
      'no-await-in-loop': 'warn',
      'no-promise-executor-return': 'error',
      'prefer-promise-reject-errors': 'error',
      'require-await': 'off', // Sometimes async is used for API consistency
      
      // Style (minimal)
      'array-callback-return': ['error', { 'allowImplicit': false }],
      'consistent-return': 'off', // Too restrictive for our codebase
      'curly': ['error', 'multi-line'],
      'default-case': 'warn',
      'default-param-last': 'error',
      'dot-notation': ['error', { 'allowKeywords': true }],
      'no-lonely-if': 'error',
      'no-useless-catch': 'warn',
      'no-useless-concat': 'error',
      'no-useless-escape': 'error',
      'object-shorthand': ['error', 'always', { 'avoidQuotes': true }],
      'prefer-arrow-callback': ['error', { 'allowNamedFunctions': true }],
      
      // ES6+
      'arrow-spacing': 'error',
      'no-duplicate-imports': 'error',
      'no-useless-computed-key': 'error',
      'no-useless-constructor': 'error',
      'no-useless-rename': 'error',
      'prefer-rest-params': 'error',
      'prefer-spread': 'error',
      'rest-spread-spacing': ['error', 'never'],
      'template-curly-spacing': ['error', 'never'],
      
      // SonarJS duplicate detection rules
      'sonarjs/no-identical-functions': 'error',
      'sonarjs/no-duplicated-branches': 'error',
      'sonarjs/no-identical-conditions': 'error',
      'sonarjs/no-identical-expressions': 'error',
      
      // SonarJS code quality rules
      'sonarjs/no-redundant-assignments': 'error',
      'sonarjs/no-unused-collection': 'error',
      'sonarjs/no-useless-catch': 'error',
      'sonarjs/prefer-immediate-return': 'warn',
      'sonarjs/no-all-duplicated-branches': 'error',
      'sonarjs/no-element-overwrite': 'error',
      'sonarjs/no-empty-collection': 'warn',
      'sonarjs/no-one-iteration-loop': 'error',
      'sonarjs/no-redundant-jump': 'error',
      'sonarjs/prefer-object-literal': 'warn',
      'sonarjs/prefer-single-boolean-return': 'warn'
    }
  }
];