<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/proc.plugin/integrations/system_statistics.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/proc.plugin/metadata.yaml"
sidebar_label: "System statistics"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Linux Systems/System"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# System statistics


<img src="https://netdata.cloud/img/linuxserver.svg" width="150"/>


Plugin: proc.plugin
Module: /proc/stat

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

CPU utilization, states and frequencies and key Linux system performance metrics.

The `/proc/stat` file provides various types of system statistics:

- The overall system CPU usage statistics
- Per CPU core statistics
- The total context switching of the system
- The total number of processes running
- The total CPU interrupts
- The total CPU softirqs

The collector also reads:

- `/proc/schedstat` for statistics about the process scheduler in the Linux kernel.
- `/sys/devices/system/cpu/[X]/thermal_throttle/core_throttle_count` to get the count of thermal throttling events for a specific CPU core on Linux systems.
- `/sys/devices/system/cpu/[X]/thermal_throttle/package_throttle_count` to get the count of thermal throttling events for a specific CPU package on a Linux system.
- `/sys/devices/system/cpu/[X]/cpufreq/scaling_cur_freq` to get the current operating frequency of a specific CPU core.
- `/sys/devices/system/cpu/[X]/cpufreq/stats/time_in_state` to get the amount of time the CPU has spent in each of its available frequency states.
- `/sys/devices/system/cpu/[X]/cpuidle/state[X]/name` to get the names of the idle states for each CPU core in a Linux system.
- `/sys/devices/system/cpu/[X]/cpuidle/state[X]/time` to get the total time each specific CPU core has spent in each idle state since the system was started.




This collector is only supported on the following platforms:

- linux

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

The collector auto-detects all metrics. No configuration is needed.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The collector disables cpu frequency and idle state monitoring when there are more than 128 CPU cores available.



## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per System statistics instance



This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.cpu | guest_nice, guest, steal, softirq, irq, user, system, nice, iowait, idle | percentage |
| system.intr | interrupts | interrupts/s |
| system.ctxt | switches | context switches/s |
| system.forks | started | processes/s |
| system.processes | running, blocked | processes |
| cpu.core_throttling | a dimension per cpu core | events/s |
| cpu.package_throttling | a dimension per package | events/s |
| cpu.cpufreq | a dimension per cpu core | MHz |

### Per cpu core



Labels:

| Label      | Description     |
|:-----------|:----------------|
| cpu | TBD |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| cpu.cpu | guest_nice, guest, steal, softirq, irq, user, system, nice, iowait, idle | percentage |
| cpuidle.cpu_cstate_residency_time | a dimension per c-state | percentage |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ 10min_cpu_usage ](https://github.com/netdata/netdata/blob/master/src/health/health.d/cpu.conf) | system.cpu | average CPU utilization over the last 10 minutes (excluding iowait, nice and steal) |
| [ 10min_cpu_iowait ](https://github.com/netdata/netdata/blob/master/src/health/health.d/cpu.conf) | system.cpu | average CPU iowait time over the last 10 minutes |
| [ 20min_steal_cpu ](https://github.com/netdata/netdata/blob/master/src/health/health.d/cpu.conf) | system.cpu | average CPU steal time over the last 20 minutes |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `plugin:proc:/proc/stat` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options



There are no configuration options.

#### Examples
There are no configuration examples.


