/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.prefix.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.repository.metadata.io.MetadataReader;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.plugin.prefix.PluginPrefixRequest;
import org.apache.maven.plugin.prefix.PluginPrefixResolver;
import org.apache.maven.plugin.prefix.PluginPrefixResult;
import org.apache.maven.plugin.prefix.internal.DefaultPluginPrefixResult;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultPluginPrefixResolver
implements PluginPrefixResolver {
    private static final String REPOSITORY_CONTEXT = "plugin";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BuildPluginManager pluginManager;
    private final RepositorySystem repositorySystem;
    private final MetadataReader metadataReader;

    @Inject
    public DefaultPluginPrefixResolver(BuildPluginManager pluginManager, RepositorySystem repositorySystem, MetadataReader metadataReader) {
        this.pluginManager = pluginManager;
        this.repositorySystem = repositorySystem;
        this.metadataReader = metadataReader;
    }

    @Override
    public PluginPrefixResult resolve(PluginPrefixRequest request) throws NoPluginFoundForPrefixException {
        this.logger.debug("Resolving plugin prefix {} from {}", (Object)request.getPrefix(), request.getPluginGroups());
        PluginPrefixResult result = this.resolveFromProject(request);
        if (result == null) {
            result = this.resolveFromRepository(request);
            if (result == null) {
                throw new NoPluginFoundForPrefixException(request.getPrefix(), request.getPluginGroups(), request.getRepositorySession().getLocalRepository(), request.getRepositories());
            }
            this.logger.debug("Resolved plugin prefix {} to {}:{} from repository {}", new Object[]{request.getPrefix(), result.getGroupId(), result.getArtifactId(), result.getRepository() != null ? result.getRepository().getId() : "null"});
        } else {
            this.logger.debug("Resolved plugin prefix {} to {}:{} from POM {}", new Object[]{request.getPrefix(), result.getGroupId(), result.getArtifactId(), request.getPom()});
        }
        return result;
    }

    private PluginPrefixResult resolveFromProject(PluginPrefixRequest request) {
        Build build;
        PluginPrefixResult result = null;
        if (request.getPom() != null && request.getPom().getBuild() != null && (result = this.resolveFromProject(request, (build = request.getPom().getBuild()).getPlugins())) == null && build.getPluginManagement() != null) {
            result = this.resolveFromProject(request, build.getPluginManagement().getPlugins());
        }
        return result;
    }

    private PluginPrefixResult resolveFromProject(PluginPrefixRequest request, List<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            try {
                PluginDescriptor pluginDescriptor = this.pluginManager.loadPlugin(plugin, request.getRepositories(), request.getRepositorySession());
                if (!request.getPrefix().equals(pluginDescriptor.getGoalPrefix())) continue;
                return new DefaultPluginPrefixResult(plugin);
            }
            catch (Exception e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("Failed to retrieve plugin descriptor for {}: {}", new Object[]{plugin.getId(), e.getMessage(), e});
                    continue;
                }
                this.logger.warn("Failed to retrieve plugin descriptor for {}: {}", (Object)plugin.getId(), (Object)e.getMessage());
            }
        }
        return null;
    }

    private PluginPrefixResult resolveFromRepository(PluginPrefixRequest request) {
        RequestTrace trace = RequestTrace.newChild(null, (Object)request);
        ArrayList<MetadataRequest> requests = new ArrayList<MetadataRequest>();
        for (String pluginGroup : request.getPluginGroups()) {
            DefaultMetadata metadata = new DefaultMetadata(pluginGroup, "maven-metadata.xml", Metadata.Nature.RELEASE_OR_SNAPSHOT);
            requests.add(new MetadataRequest((Metadata)metadata, null, REPOSITORY_CONTEXT).setTrace(trace));
            for (RemoteRepository repository : request.getRepositories()) {
                requests.add(new MetadataRequest((Metadata)metadata, repository, REPOSITORY_CONTEXT).setTrace(trace));
            }
        }
        List results = this.repositorySystem.resolveMetadata(request.getRepositorySession(), requests);
        requests.clear();
        PluginPrefixResult result = this.processResults(request, trace, results, requests);
        if (result != null) {
            return result;
        }
        if (!request.getRepositorySession().isOffline() && !requests.isEmpty()) {
            DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(request.getRepositorySession());
            session.setUpdatePolicy("always");
            results = this.repositorySystem.resolveMetadata((RepositorySystemSession)session, requests);
            return this.processResults(request, trace, results, null);
        }
        return null;
    }

    private PluginPrefixResult processResults(PluginPrefixRequest request, RequestTrace trace, List<MetadataResult> results, List<MetadataRequest> requests) {
        for (MetadataResult res : results) {
            Metadata metadata = res.getMetadata();
            if (metadata != null) {
                PluginPrefixResult result;
                RemoteRepository repository = res.getRequest().getRepository();
                if (repository == null) {
                    repository = request.getRepositorySession().getLocalRepository();
                }
                if ((result = this.resolveFromRepository(request, trace, metadata.getGroupId(), metadata, (ArtifactRepository)repository)) != null) {
                    return result;
                }
            }
            if (requests == null || res.isUpdated()) continue;
            requests.add(res.getRequest());
        }
        return null;
    }

    private PluginPrefixResult resolveFromRepository(PluginPrefixRequest request, RequestTrace trace, String pluginGroup, Metadata metadata, ArtifactRepository repository) {
        if (metadata != null && metadata.getFile() != null && metadata.getFile().isFile()) {
            try {
                Map<String, Boolean> options = Collections.singletonMap("org.apache.maven.artifact.repository.metadata.io.isStrict", Boolean.FALSE);
                org.apache.maven.artifact.repository.metadata.Metadata pluginGroupMetadata = this.metadataReader.read(metadata.getFile(), options);
                List plugins = pluginGroupMetadata.getPlugins();
                if (plugins != null) {
                    for (org.apache.maven.artifact.repository.metadata.Plugin plugin : plugins) {
                        if (!request.getPrefix().equals(plugin.getPrefix())) continue;
                        return new DefaultPluginPrefixResult(pluginGroup, plugin.getArtifactId(), repository);
                    }
                }
            }
            catch (IOException e) {
                this.invalidMetadata(request.getRepositorySession(), trace, metadata, repository, e);
            }
        }
        return null;
    }

    private void invalidMetadata(RepositorySystemSession session, RequestTrace trace, Metadata metadata, ArtifactRepository repository, Exception exception) {
        RepositoryListener listener = session.getRepositoryListener();
        if (listener != null) {
            RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.METADATA_INVALID);
            event.setTrace(trace);
            event.setMetadata(metadata);
            event.setException(exception);
            event.setRepository(repository);
            listener.metadataInvalid(event.build());
        }
    }
}

