/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.model.profile;

import java.util.Objects;
import java.util.Optional;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Activation;
import org.apache.maven.api.model.Profile;
import org.apache.maven.api.services.ModelProblemCollector;
import org.apache.maven.api.services.model.ProfileActivationContext;
import org.apache.maven.api.services.model.ProfileActivator;

@Named(value="packaging")
@Singleton
public class PackagingProfileActivator
implements ProfileActivator {
    @Override
    public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        return PackagingProfileActivator.getActivationPackaging(profile).map(p -> PackagingProfileActivator.isPackaging(context, p)).orElse(false);
    }

    @Override
    public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
        return PackagingProfileActivator.getActivationPackaging(profile).isPresent();
    }

    private static boolean isPackaging(ProfileActivationContext context, String p) {
        String packaging = context.getModelPackaging();
        return Objects.equals(p, packaging);
    }

    private static Optional<String> getActivationPackaging(Profile profile) {
        return Optional.ofNullable(profile).map(Profile::getActivation).map(Activation::getPackaging);
    }
}

