function _mergeNamespaces(n, m2) {
  for (var i = 0; i < m2.length; i++) {
    const e = m2[i];
    if (typeof e !== "string" && !Array.isArray(e)) {
      for (const k2 in e) {
        if (k2 !== "default" && !(k2 in n)) {
          const d2 = Object.getOwnPropertyDescriptor(e, k2);
          if (d2) {
            Object.defineProperty(n, k2, d2.get ? d2 : {
              enumerable: true,
              get: () => e[k2]
            });
          }
        }
      }
    }
  }
  return Object.freeze(Object.defineProperty(n, Symbol.toStringTag, { value: "Module" }));
}
(function polyfill() {
  const relList = document.createElement("link").relList;
  if (relList && relList.supports && relList.supports("modulepreload")) return;
  for (const link of document.querySelectorAll('link[rel="modulepreload"]')) processPreload(link);
  new MutationObserver((mutations) => {
    for (const mutation of mutations) {
      if (mutation.type !== "childList") continue;
      for (const node of mutation.addedNodes) if (node.tagName === "LINK" && node.rel === "modulepreload") processPreload(node);
    }
  }).observe(document, {
    childList: true,
    subtree: true
  });
  function getFetchOpts(link) {
    const fetchOpts = {};
    if (link.integrity) fetchOpts.integrity = link.integrity;
    if (link.referrerPolicy) fetchOpts.referrerPolicy = link.referrerPolicy;
    if (link.crossOrigin === "use-credentials") fetchOpts.credentials = "include";
    else if (link.crossOrigin === "anonymous") fetchOpts.credentials = "omit";
    else fetchOpts.credentials = "same-origin";
    return fetchOpts;
  }
  function processPreload(link) {
    if (link.ep) return;
    link.ep = true;
    const fetchOpts = getFetchOpts(link);
    fetch(link.href, fetchOpts);
  }
})();
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs(x2) {
  return x2 && x2.__esModule && Object.prototype.hasOwnProperty.call(x2, "default") ? x2["default"] : x2;
}
var jsxRuntime = { exports: {} };
var reactJsxRuntime_production_min = {};
var react = { exports: {} };
var react_production_min = {};
var hasRequiredReact_production_min;
function requireReact_production_min() {
  if (hasRequiredReact_production_min) return react_production_min;
  hasRequiredReact_production_min = 1;
  var l = /* @__PURE__ */ Symbol.for("react.element"), n = /* @__PURE__ */ Symbol.for("react.portal"), p2 = /* @__PURE__ */ Symbol.for("react.fragment"), q2 = /* @__PURE__ */ Symbol.for("react.strict_mode"), r2 = /* @__PURE__ */ Symbol.for("react.profiler"), t = /* @__PURE__ */ Symbol.for("react.provider"), u2 = /* @__PURE__ */ Symbol.for("react.context"), v = /* @__PURE__ */ Symbol.for("react.forward_ref"), w2 = /* @__PURE__ */ Symbol.for("react.suspense"), x2 = /* @__PURE__ */ Symbol.for("react.memo"), y2 = /* @__PURE__ */ Symbol.for("react.lazy"), z2 = Symbol.iterator;
  function A2(a2) {
    if (null === a2 || "object" !== typeof a2) return null;
    a2 = z2 && a2[z2] || a2["@@iterator"];
    return "function" === typeof a2 ? a2 : null;
  }
  var B2 = { isMounted: function() {
    return false;
  }, enqueueForceUpdate: function() {
  }, enqueueReplaceState: function() {
  }, enqueueSetState: function() {
  } }, C = Object.assign, D2 = {};
  function E2(a2, b, e) {
    this.props = a2;
    this.context = b;
    this.refs = D2;
    this.updater = e || B2;
  }
  E2.prototype.isReactComponent = {};
  E2.prototype.setState = function(a2, b) {
    if ("object" !== typeof a2 && "function" !== typeof a2 && null != a2) throw Error("setState(...): takes an object of state variables to update or a function which returns an object of state variables.");
    this.updater.enqueueSetState(this, a2, b, "setState");
  };
  E2.prototype.forceUpdate = function(a2) {
    this.updater.enqueueForceUpdate(this, a2, "forceUpdate");
  };
  function F2() {
  }
  F2.prototype = E2.prototype;
  function G2(a2, b, e) {
    this.props = a2;
    this.context = b;
    this.refs = D2;
    this.updater = e || B2;
  }
  var H2 = G2.prototype = new F2();
  H2.constructor = G2;
  C(H2, E2.prototype);
  H2.isPureReactComponent = true;
  var I2 = Array.isArray, J2 = Object.prototype.hasOwnProperty, K2 = { current: null }, L2 = { key: true, ref: true, __self: true, __source: true };
  function M2(a2, b, e) {
    var d2, c = {}, k2 = null, h2 = null;
    if (null != b) for (d2 in void 0 !== b.ref && (h2 = b.ref), void 0 !== b.key && (k2 = "" + b.key), b) J2.call(b, d2) && !L2.hasOwnProperty(d2) && (c[d2] = b[d2]);
    var g2 = arguments.length - 2;
    if (1 === g2) c.children = e;
    else if (1 < g2) {
      for (var f2 = Array(g2), m2 = 0; m2 < g2; m2++) f2[m2] = arguments[m2 + 2];
      c.children = f2;
    }
    if (a2 && a2.defaultProps) for (d2 in g2 = a2.defaultProps, g2) void 0 === c[d2] && (c[d2] = g2[d2]);
    return { $$typeof: l, type: a2, key: k2, ref: h2, props: c, _owner: K2.current };
  }
  function N2(a2, b) {
    return { $$typeof: l, type: a2.type, key: b, ref: a2.ref, props: a2.props, _owner: a2._owner };
  }
  function O(a2) {
    return "object" === typeof a2 && null !== a2 && a2.$$typeof === l;
  }
  function escape2(a2) {
    var b = { "=": "=0", ":": "=2" };
    return "$" + a2.replace(/[=:]/g, function(a3) {
      return b[a3];
    });
  }
  var P2 = /\/+/g;
  function Q2(a2, b) {
    return "object" === typeof a2 && null !== a2 && null != a2.key ? escape2("" + a2.key) : b.toString(36);
  }
  function R2(a2, b, e, d2, c) {
    var k2 = typeof a2;
    if ("undefined" === k2 || "boolean" === k2) a2 = null;
    var h2 = false;
    if (null === a2) h2 = true;
    else switch (k2) {
      case "string":
      case "number":
        h2 = true;
        break;
      case "object":
        switch (a2.$$typeof) {
          case l:
          case n:
            h2 = true;
        }
    }
    if (h2) return h2 = a2, c = c(h2), a2 = "" === d2 ? "." + Q2(h2, 0) : d2, I2(c) ? (e = "", null != a2 && (e = a2.replace(P2, "$&/") + "/"), R2(c, b, e, "", function(a3) {
      return a3;
    })) : null != c && (O(c) && (c = N2(c, e + (!c.key || h2 && h2.key === c.key ? "" : ("" + c.key).replace(P2, "$&/") + "/") + a2)), b.push(c)), 1;
    h2 = 0;
    d2 = "" === d2 ? "." : d2 + ":";
    if (I2(a2)) for (var g2 = 0; g2 < a2.length; g2++) {
      k2 = a2[g2];
      var f2 = d2 + Q2(k2, g2);
      h2 += R2(k2, b, e, f2, c);
    }
    else if (f2 = A2(a2), "function" === typeof f2) for (a2 = f2.call(a2), g2 = 0; !(k2 = a2.next()).done; ) k2 = k2.value, f2 = d2 + Q2(k2, g2++), h2 += R2(k2, b, e, f2, c);
    else if ("object" === k2) throw b = String(a2), Error("Objects are not valid as a React child (found: " + ("[object Object]" === b ? "object with keys {" + Object.keys(a2).join(", ") + "}" : b) + "). If you meant to render a collection of children, use an array instead.");
    return h2;
  }
  function S2(a2, b, e) {
    if (null == a2) return a2;
    var d2 = [], c = 0;
    R2(a2, d2, "", "", function(a3) {
      return b.call(e, a3, c++);
    });
    return d2;
  }
  function T2(a2) {
    if (-1 === a2._status) {
      var b = a2._result;
      b = b();
      b.then(function(b2) {
        if (0 === a2._status || -1 === a2._status) a2._status = 1, a2._result = b2;
      }, function(b2) {
        if (0 === a2._status || -1 === a2._status) a2._status = 2, a2._result = b2;
      });
      -1 === a2._status && (a2._status = 0, a2._result = b);
    }
    if (1 === a2._status) return a2._result.default;
    throw a2._result;
  }
  var U2 = { current: null }, V2 = { transition: null }, W2 = { ReactCurrentDispatcher: U2, ReactCurrentBatchConfig: V2, ReactCurrentOwner: K2 };
  function X2() {
    throw Error("act(...) is not supported in production builds of React.");
  }
  react_production_min.Children = { map: S2, forEach: function(a2, b, e) {
    S2(a2, function() {
      b.apply(this, arguments);
    }, e);
  }, count: function(a2) {
    var b = 0;
    S2(a2, function() {
      b++;
    });
    return b;
  }, toArray: function(a2) {
    return S2(a2, function(a3) {
      return a3;
    }) || [];
  }, only: function(a2) {
    if (!O(a2)) throw Error("React.Children.only expected to receive a single React element child.");
    return a2;
  } };
  react_production_min.Component = E2;
  react_production_min.Fragment = p2;
  react_production_min.Profiler = r2;
  react_production_min.PureComponent = G2;
  react_production_min.StrictMode = q2;
  react_production_min.Suspense = w2;
  react_production_min.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED = W2;
  react_production_min.act = X2;
  react_production_min.cloneElement = function(a2, b, e) {
    if (null === a2 || void 0 === a2) throw Error("React.cloneElement(...): The argument must be a React element, but you passed " + a2 + ".");
    var d2 = C({}, a2.props), c = a2.key, k2 = a2.ref, h2 = a2._owner;
    if (null != b) {
      void 0 !== b.ref && (k2 = b.ref, h2 = K2.current);
      void 0 !== b.key && (c = "" + b.key);
      if (a2.type && a2.type.defaultProps) var g2 = a2.type.defaultProps;
      for (f2 in b) J2.call(b, f2) && !L2.hasOwnProperty(f2) && (d2[f2] = void 0 === b[f2] && void 0 !== g2 ? g2[f2] : b[f2]);
    }
    var f2 = arguments.length - 2;
    if (1 === f2) d2.children = e;
    else if (1 < f2) {
      g2 = Array(f2);
      for (var m2 = 0; m2 < f2; m2++) g2[m2] = arguments[m2 + 2];
      d2.children = g2;
    }
    return { $$typeof: l, type: a2.type, key: c, ref: k2, props: d2, _owner: h2 };
  };
  react_production_min.createContext = function(a2) {
    a2 = { $$typeof: u2, _currentValue: a2, _currentValue2: a2, _threadCount: 0, Provider: null, Consumer: null, _defaultValue: null, _globalName: null };
    a2.Provider = { $$typeof: t, _context: a2 };
    return a2.Consumer = a2;
  };
  react_production_min.createElement = M2;
  react_production_min.createFactory = function(a2) {
    var b = M2.bind(null, a2);
    b.type = a2;
    return b;
  };
  react_production_min.createRef = function() {
    return { current: null };
  };
  react_production_min.forwardRef = function(a2) {
    return { $$typeof: v, render: a2 };
  };
  react_production_min.isValidElement = O;
  react_production_min.lazy = function(a2) {
    return { $$typeof: y2, _payload: { _status: -1, _result: a2 }, _init: T2 };
  };
  react_production_min.memo = function(a2, b) {
    return { $$typeof: x2, type: a2, compare: void 0 === b ? null : b };
  };
  react_production_min.startTransition = function(a2) {
    var b = V2.transition;
    V2.transition = {};
    try {
      a2();
    } finally {
      V2.transition = b;
    }
  };
  react_production_min.unstable_act = X2;
  react_production_min.useCallback = function(a2, b) {
    return U2.current.useCallback(a2, b);
  };
  react_production_min.useContext = function(a2) {
    return U2.current.useContext(a2);
  };
  react_production_min.useDebugValue = function() {
  };
  react_production_min.useDeferredValue = function(a2) {
    return U2.current.useDeferredValue(a2);
  };
  react_production_min.useEffect = function(a2, b) {
    return U2.current.useEffect(a2, b);
  };
  react_production_min.useId = function() {
    return U2.current.useId();
  };
  react_production_min.useImperativeHandle = function(a2, b, e) {
    return U2.current.useImperativeHandle(a2, b, e);
  };
  react_production_min.useInsertionEffect = function(a2, b) {
    return U2.current.useInsertionEffect(a2, b);
  };
  react_production_min.useLayoutEffect = function(a2, b) {
    return U2.current.useLayoutEffect(a2, b);
  };
  react_production_min.useMemo = function(a2, b) {
    return U2.current.useMemo(a2, b);
  };
  react_production_min.useReducer = function(a2, b, e) {
    return U2.current.useReducer(a2, b, e);
  };
  react_production_min.useRef = function(a2) {
    return U2.current.useRef(a2);
  };
  react_production_min.useState = function(a2) {
    return U2.current.useState(a2);
  };
  react_production_min.useSyncExternalStore = function(a2, b, e) {
    return U2.current.useSyncExternalStore(a2, b, e);
  };
  react_production_min.useTransition = function() {
    return U2.current.useTransition();
  };
  react_production_min.version = "18.3.1";
  return react_production_min;
}
var hasRequiredReact;
function requireReact() {
  if (hasRequiredReact) return react.exports;
  hasRequiredReact = 1;
  {
    react.exports = requireReact_production_min();
  }
  return react.exports;
}
var hasRequiredReactJsxRuntime_production_min;
function requireReactJsxRuntime_production_min() {
  if (hasRequiredReactJsxRuntime_production_min) return reactJsxRuntime_production_min;
  hasRequiredReactJsxRuntime_production_min = 1;
  var f2 = requireReact(), k2 = /* @__PURE__ */ Symbol.for("react.element"), l = /* @__PURE__ */ Symbol.for("react.fragment"), m2 = Object.prototype.hasOwnProperty, n = f2.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED.ReactCurrentOwner, p2 = { key: true, ref: true, __self: true, __source: true };
  function q2(c, a2, g2) {
    var b, d2 = {}, e = null, h2 = null;
    void 0 !== g2 && (e = "" + g2);
    void 0 !== a2.key && (e = "" + a2.key);
    void 0 !== a2.ref && (h2 = a2.ref);
    for (b in a2) m2.call(a2, b) && !p2.hasOwnProperty(b) && (d2[b] = a2[b]);
    if (c && c.defaultProps) for (b in a2 = c.defaultProps, a2) void 0 === d2[b] && (d2[b] = a2[b]);
    return { $$typeof: k2, type: c, key: e, ref: h2, props: d2, _owner: n.current };
  }
  reactJsxRuntime_production_min.Fragment = l;
  reactJsxRuntime_production_min.jsx = q2;
  reactJsxRuntime_production_min.jsxs = q2;
  return reactJsxRuntime_production_min;
}
var hasRequiredJsxRuntime;
function requireJsxRuntime() {
  if (hasRequiredJsxRuntime) return jsxRuntime.exports;
  hasRequiredJsxRuntime = 1;
  {
    jsxRuntime.exports = requireReactJsxRuntime_production_min();
  }
  return jsxRuntime.exports;
}
var jsxRuntimeExports = requireJsxRuntime();
var reactExports = requireReact();
const React = /* @__PURE__ */ getDefaultExportFromCjs(reactExports);
const React$1 = /* @__PURE__ */ _mergeNamespaces({
  __proto__: null,
  default: React
}, [reactExports]);
var client = {};
var reactDom = { exports: {} };
var reactDom_production_min = {};
var scheduler = { exports: {} };
var scheduler_production_min = {};
var hasRequiredScheduler_production_min;
function requireScheduler_production_min() {
  if (hasRequiredScheduler_production_min) return scheduler_production_min;
  hasRequiredScheduler_production_min = 1;
  (function(exports$1) {
    function f2(a2, b) {
      var c = a2.length;
      a2.push(b);
      a: for (; 0 < c; ) {
        var d2 = c - 1 >>> 1, e = a2[d2];
        if (0 < g2(e, b)) a2[d2] = b, a2[c] = e, c = d2;
        else break a;
      }
    }
    function h2(a2) {
      return 0 === a2.length ? null : a2[0];
    }
    function k2(a2) {
      if (0 === a2.length) return null;
      var b = a2[0], c = a2.pop();
      if (c !== b) {
        a2[0] = c;
        a: for (var d2 = 0, e = a2.length, w2 = e >>> 1; d2 < w2; ) {
          var m2 = 2 * (d2 + 1) - 1, C = a2[m2], n = m2 + 1, x2 = a2[n];
          if (0 > g2(C, c)) n < e && 0 > g2(x2, C) ? (a2[d2] = x2, a2[n] = c, d2 = n) : (a2[d2] = C, a2[m2] = c, d2 = m2);
          else if (n < e && 0 > g2(x2, c)) a2[d2] = x2, a2[n] = c, d2 = n;
          else break a;
        }
      }
      return b;
    }
    function g2(a2, b) {
      var c = a2.sortIndex - b.sortIndex;
      return 0 !== c ? c : a2.id - b.id;
    }
    if ("object" === typeof performance && "function" === typeof performance.now) {
      var l = performance;
      exports$1.unstable_now = function() {
        return l.now();
      };
    } else {
      var p2 = Date, q2 = p2.now();
      exports$1.unstable_now = function() {
        return p2.now() - q2;
      };
    }
    var r2 = [], t = [], u2 = 1, v = null, y2 = 3, z2 = false, A2 = false, B2 = false, D2 = "function" === typeof setTimeout ? setTimeout : null, E2 = "function" === typeof clearTimeout ? clearTimeout : null, F2 = "undefined" !== typeof setImmediate ? setImmediate : null;
    "undefined" !== typeof navigator && void 0 !== navigator.scheduling && void 0 !== navigator.scheduling.isInputPending && navigator.scheduling.isInputPending.bind(navigator.scheduling);
    function G2(a2) {
      for (var b = h2(t); null !== b; ) {
        if (null === b.callback) k2(t);
        else if (b.startTime <= a2) k2(t), b.sortIndex = b.expirationTime, f2(r2, b);
        else break;
        b = h2(t);
      }
    }
    function H2(a2) {
      B2 = false;
      G2(a2);
      if (!A2) if (null !== h2(r2)) A2 = true, I2(J2);
      else {
        var b = h2(t);
        null !== b && K2(H2, b.startTime - a2);
      }
    }
    function J2(a2, b) {
      A2 = false;
      B2 && (B2 = false, E2(L2), L2 = -1);
      z2 = true;
      var c = y2;
      try {
        G2(b);
        for (v = h2(r2); null !== v && (!(v.expirationTime > b) || a2 && !M2()); ) {
          var d2 = v.callback;
          if ("function" === typeof d2) {
            v.callback = null;
            y2 = v.priorityLevel;
            var e = d2(v.expirationTime <= b);
            b = exports$1.unstable_now();
            "function" === typeof e ? v.callback = e : v === h2(r2) && k2(r2);
            G2(b);
          } else k2(r2);
          v = h2(r2);
        }
        if (null !== v) var w2 = true;
        else {
          var m2 = h2(t);
          null !== m2 && K2(H2, m2.startTime - b);
          w2 = false;
        }
        return w2;
      } finally {
        v = null, y2 = c, z2 = false;
      }
    }
    var N2 = false, O = null, L2 = -1, P2 = 5, Q2 = -1;
    function M2() {
      return exports$1.unstable_now() - Q2 < P2 ? false : true;
    }
    function R2() {
      if (null !== O) {
        var a2 = exports$1.unstable_now();
        Q2 = a2;
        var b = true;
        try {
          b = O(true, a2);
        } finally {
          b ? S2() : (N2 = false, O = null);
        }
      } else N2 = false;
    }
    var S2;
    if ("function" === typeof F2) S2 = function() {
      F2(R2);
    };
    else if ("undefined" !== typeof MessageChannel) {
      var T2 = new MessageChannel(), U2 = T2.port2;
      T2.port1.onmessage = R2;
      S2 = function() {
        U2.postMessage(null);
      };
    } else S2 = function() {
      D2(R2, 0);
    };
    function I2(a2) {
      O = a2;
      N2 || (N2 = true, S2());
    }
    function K2(a2, b) {
      L2 = D2(function() {
        a2(exports$1.unstable_now());
      }, b);
    }
    exports$1.unstable_IdlePriority = 5;
    exports$1.unstable_ImmediatePriority = 1;
    exports$1.unstable_LowPriority = 4;
    exports$1.unstable_NormalPriority = 3;
    exports$1.unstable_Profiling = null;
    exports$1.unstable_UserBlockingPriority = 2;
    exports$1.unstable_cancelCallback = function(a2) {
      a2.callback = null;
    };
    exports$1.unstable_continueExecution = function() {
      A2 || z2 || (A2 = true, I2(J2));
    };
    exports$1.unstable_forceFrameRate = function(a2) {
      0 > a2 || 125 < a2 ? console.error("forceFrameRate takes a positive int between 0 and 125, forcing frame rates higher than 125 fps is not supported") : P2 = 0 < a2 ? Math.floor(1e3 / a2) : 5;
    };
    exports$1.unstable_getCurrentPriorityLevel = function() {
      return y2;
    };
    exports$1.unstable_getFirstCallbackNode = function() {
      return h2(r2);
    };
    exports$1.unstable_next = function(a2) {
      switch (y2) {
        case 1:
        case 2:
        case 3:
          var b = 3;
          break;
        default:
          b = y2;
      }
      var c = y2;
      y2 = b;
      try {
        return a2();
      } finally {
        y2 = c;
      }
    };
    exports$1.unstable_pauseExecution = function() {
    };
    exports$1.unstable_requestPaint = function() {
    };
    exports$1.unstable_runWithPriority = function(a2, b) {
      switch (a2) {
        case 1:
        case 2:
        case 3:
        case 4:
        case 5:
          break;
        default:
          a2 = 3;
      }
      var c = y2;
      y2 = a2;
      try {
        return b();
      } finally {
        y2 = c;
      }
    };
    exports$1.unstable_scheduleCallback = function(a2, b, c) {
      var d2 = exports$1.unstable_now();
      "object" === typeof c && null !== c ? (c = c.delay, c = "number" === typeof c && 0 < c ? d2 + c : d2) : c = d2;
      switch (a2) {
        case 1:
          var e = -1;
          break;
        case 2:
          e = 250;
          break;
        case 5:
          e = 1073741823;
          break;
        case 4:
          e = 1e4;
          break;
        default:
          e = 5e3;
      }
      e = c + e;
      a2 = { id: u2++, callback: b, priorityLevel: a2, startTime: c, expirationTime: e, sortIndex: -1 };
      c > d2 ? (a2.sortIndex = c, f2(t, a2), null === h2(r2) && a2 === h2(t) && (B2 ? (E2(L2), L2 = -1) : B2 = true, K2(H2, c - d2))) : (a2.sortIndex = e, f2(r2, a2), A2 || z2 || (A2 = true, I2(J2)));
      return a2;
    };
    exports$1.unstable_shouldYield = M2;
    exports$1.unstable_wrapCallback = function(a2) {
      var b = y2;
      return function() {
        var c = y2;
        y2 = b;
        try {
          return a2.apply(this, arguments);
        } finally {
          y2 = c;
        }
      };
    };
  })(scheduler_production_min);
  return scheduler_production_min;
}
var hasRequiredScheduler;
function requireScheduler() {
  if (hasRequiredScheduler) return scheduler.exports;
  hasRequiredScheduler = 1;
  {
    scheduler.exports = requireScheduler_production_min();
  }
  return scheduler.exports;
}
var hasRequiredReactDom_production_min;
function requireReactDom_production_min() {
  if (hasRequiredReactDom_production_min) return reactDom_production_min;
  hasRequiredReactDom_production_min = 1;
  var aa2 = requireReact(), ca2 = requireScheduler();
  function p2(a2) {
    for (var b = "https://reactjs.org/docs/error-decoder.html?invariant=" + a2, c = 1; c < arguments.length; c++) b += "&args[]=" + encodeURIComponent(arguments[c]);
    return "Minified React error #" + a2 + "; visit " + b + " for the full message or use the non-minified dev environment for full errors and additional helpful warnings.";
  }
  var da2 = /* @__PURE__ */ new Set(), ea2 = {};
  function fa2(a2, b) {
    ha2(a2, b);
    ha2(a2 + "Capture", b);
  }
  function ha2(a2, b) {
    ea2[a2] = b;
    for (a2 = 0; a2 < b.length; a2++) da2.add(b[a2]);
  }
  var ia2 = !("undefined" === typeof window || "undefined" === typeof window.document || "undefined" === typeof window.document.createElement), ja2 = Object.prototype.hasOwnProperty, ka = /^[:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD][:A-Z_a-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02FF\u0370-\u037D\u037F-\u1FFF\u200C-\u200D\u2070-\u218F\u2C00-\u2FEF\u3001-\uD7FF\uF900-\uFDCF\uFDF0-\uFFFD\-.0-9\u00B7\u0300-\u036F\u203F-\u2040]*$/, la2 = {}, ma2 = {};
  function oa2(a2) {
    if (ja2.call(ma2, a2)) return true;
    if (ja2.call(la2, a2)) return false;
    if (ka.test(a2)) return ma2[a2] = true;
    la2[a2] = true;
    return false;
  }
  function pa2(a2, b, c, d2) {
    if (null !== c && 0 === c.type) return false;
    switch (typeof b) {
      case "function":
      case "symbol":
        return true;
      case "boolean":
        if (d2) return false;
        if (null !== c) return !c.acceptsBooleans;
        a2 = a2.toLowerCase().slice(0, 5);
        return "data-" !== a2 && "aria-" !== a2;
      default:
        return false;
    }
  }
  function qa2(a2, b, c, d2) {
    if (null === b || "undefined" === typeof b || pa2(a2, b, c, d2)) return true;
    if (d2) return false;
    if (null !== c) switch (c.type) {
      case 3:
        return !b;
      case 4:
        return false === b;
      case 5:
        return isNaN(b);
      case 6:
        return isNaN(b) || 1 > b;
    }
    return false;
  }
  function v(a2, b, c, d2, e, f2, g2) {
    this.acceptsBooleans = 2 === b || 3 === b || 4 === b;
    this.attributeName = d2;
    this.attributeNamespace = e;
    this.mustUseProperty = c;
    this.propertyName = a2;
    this.type = b;
    this.sanitizeURL = f2;
    this.removeEmptyString = g2;
  }
  var z2 = {};
  "children dangerouslySetInnerHTML defaultValue defaultChecked innerHTML suppressContentEditableWarning suppressHydrationWarning style".split(" ").forEach(function(a2) {
    z2[a2] = new v(a2, 0, false, a2, null, false, false);
  });
  [["acceptCharset", "accept-charset"], ["className", "class"], ["htmlFor", "for"], ["httpEquiv", "http-equiv"]].forEach(function(a2) {
    var b = a2[0];
    z2[b] = new v(b, 1, false, a2[1], null, false, false);
  });
  ["contentEditable", "draggable", "spellCheck", "value"].forEach(function(a2) {
    z2[a2] = new v(a2, 2, false, a2.toLowerCase(), null, false, false);
  });
  ["autoReverse", "externalResourcesRequired", "focusable", "preserveAlpha"].forEach(function(a2) {
    z2[a2] = new v(a2, 2, false, a2, null, false, false);
  });
  "allowFullScreen async autoFocus autoPlay controls default defer disabled disablePictureInPicture disableRemotePlayback formNoValidate hidden loop noModule noValidate open playsInline readOnly required reversed scoped seamless itemScope".split(" ").forEach(function(a2) {
    z2[a2] = new v(a2, 3, false, a2.toLowerCase(), null, false, false);
  });
  ["checked", "multiple", "muted", "selected"].forEach(function(a2) {
    z2[a2] = new v(a2, 3, true, a2, null, false, false);
  });
  ["capture", "download"].forEach(function(a2) {
    z2[a2] = new v(a2, 4, false, a2, null, false, false);
  });
  ["cols", "rows", "size", "span"].forEach(function(a2) {
    z2[a2] = new v(a2, 6, false, a2, null, false, false);
  });
  ["rowSpan", "start"].forEach(function(a2) {
    z2[a2] = new v(a2, 5, false, a2.toLowerCase(), null, false, false);
  });
  var ra2 = /[\-:]([a-z])/g;
  function sa2(a2) {
    return a2[1].toUpperCase();
  }
  "accent-height alignment-baseline arabic-form baseline-shift cap-height clip-path clip-rule color-interpolation color-interpolation-filters color-profile color-rendering dominant-baseline enable-background fill-opacity fill-rule flood-color flood-opacity font-family font-size font-size-adjust font-stretch font-style font-variant font-weight glyph-name glyph-orientation-horizontal glyph-orientation-vertical horiz-adv-x horiz-origin-x image-rendering letter-spacing lighting-color marker-end marker-mid marker-start overline-position overline-thickness paint-order panose-1 pointer-events rendering-intent shape-rendering stop-color stop-opacity strikethrough-position strikethrough-thickness stroke-dasharray stroke-dashoffset stroke-linecap stroke-linejoin stroke-miterlimit stroke-opacity stroke-width text-anchor text-decoration text-rendering underline-position underline-thickness unicode-bidi unicode-range units-per-em v-alphabetic v-hanging v-ideographic v-mathematical vector-effect vert-adv-y vert-origin-x vert-origin-y word-spacing writing-mode xmlns:xlink x-height".split(" ").forEach(function(a2) {
    var b = a2.replace(
      ra2,
      sa2
    );
    z2[b] = new v(b, 1, false, a2, null, false, false);
  });
  "xlink:actuate xlink:arcrole xlink:role xlink:show xlink:title xlink:type".split(" ").forEach(function(a2) {
    var b = a2.replace(ra2, sa2);
    z2[b] = new v(b, 1, false, a2, "http://www.w3.org/1999/xlink", false, false);
  });
  ["xml:base", "xml:lang", "xml:space"].forEach(function(a2) {
    var b = a2.replace(ra2, sa2);
    z2[b] = new v(b, 1, false, a2, "http://www.w3.org/XML/1998/namespace", false, false);
  });
  ["tabIndex", "crossOrigin"].forEach(function(a2) {
    z2[a2] = new v(a2, 1, false, a2.toLowerCase(), null, false, false);
  });
  z2.xlinkHref = new v("xlinkHref", 1, false, "xlink:href", "http://www.w3.org/1999/xlink", true, false);
  ["src", "href", "action", "formAction"].forEach(function(a2) {
    z2[a2] = new v(a2, 1, false, a2.toLowerCase(), null, true, true);
  });
  function ta2(a2, b, c, d2) {
    var e = z2.hasOwnProperty(b) ? z2[b] : null;
    if (null !== e ? 0 !== e.type : d2 || !(2 < b.length) || "o" !== b[0] && "O" !== b[0] || "n" !== b[1] && "N" !== b[1]) qa2(b, c, e, d2) && (c = null), d2 || null === e ? oa2(b) && (null === c ? a2.removeAttribute(b) : a2.setAttribute(b, "" + c)) : e.mustUseProperty ? a2[e.propertyName] = null === c ? 3 === e.type ? false : "" : c : (b = e.attributeName, d2 = e.attributeNamespace, null === c ? a2.removeAttribute(b) : (e = e.type, c = 3 === e || 4 === e && true === c ? "" : "" + c, d2 ? a2.setAttributeNS(d2, b, c) : a2.setAttribute(b, c)));
  }
  var ua2 = aa2.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED, va2 = /* @__PURE__ */ Symbol.for("react.element"), wa = /* @__PURE__ */ Symbol.for("react.portal"), ya = /* @__PURE__ */ Symbol.for("react.fragment"), za = /* @__PURE__ */ Symbol.for("react.strict_mode"), Aa2 = /* @__PURE__ */ Symbol.for("react.profiler"), Ba2 = /* @__PURE__ */ Symbol.for("react.provider"), Ca2 = /* @__PURE__ */ Symbol.for("react.context"), Da = /* @__PURE__ */ Symbol.for("react.forward_ref"), Ea = /* @__PURE__ */ Symbol.for("react.suspense"), Fa2 = /* @__PURE__ */ Symbol.for("react.suspense_list"), Ga2 = /* @__PURE__ */ Symbol.for("react.memo"), Ha2 = /* @__PURE__ */ Symbol.for("react.lazy");
  var Ia = /* @__PURE__ */ Symbol.for("react.offscreen");
  var Ja2 = Symbol.iterator;
  function Ka2(a2) {
    if (null === a2 || "object" !== typeof a2) return null;
    a2 = Ja2 && a2[Ja2] || a2["@@iterator"];
    return "function" === typeof a2 ? a2 : null;
  }
  var A2 = Object.assign, La2;
  function Ma2(a2) {
    if (void 0 === La2) try {
      throw Error();
    } catch (c) {
      var b = c.stack.trim().match(/\n( *(at )?)/);
      La2 = b && b[1] || "";
    }
    return "\n" + La2 + a2;
  }
  var Na = false;
  function Oa(a2, b) {
    if (!a2 || Na) return "";
    Na = true;
    var c = Error.prepareStackTrace;
    Error.prepareStackTrace = void 0;
    try {
      if (b) if (b = function() {
        throw Error();
      }, Object.defineProperty(b.prototype, "props", { set: function() {
        throw Error();
      } }), "object" === typeof Reflect && Reflect.construct) {
        try {
          Reflect.construct(b, []);
        } catch (l) {
          var d2 = l;
        }
        Reflect.construct(a2, [], b);
      } else {
        try {
          b.call();
        } catch (l) {
          d2 = l;
        }
        a2.call(b.prototype);
      }
      else {
        try {
          throw Error();
        } catch (l) {
          d2 = l;
        }
        a2();
      }
    } catch (l) {
      if (l && d2 && "string" === typeof l.stack) {
        for (var e = l.stack.split("\n"), f2 = d2.stack.split("\n"), g2 = e.length - 1, h2 = f2.length - 1; 1 <= g2 && 0 <= h2 && e[g2] !== f2[h2]; ) h2--;
        for (; 1 <= g2 && 0 <= h2; g2--, h2--) if (e[g2] !== f2[h2]) {
          if (1 !== g2 || 1 !== h2) {
            do
              if (g2--, h2--, 0 > h2 || e[g2] !== f2[h2]) {
                var k2 = "\n" + e[g2].replace(" at new ", " at ");
                a2.displayName && k2.includes("<anonymous>") && (k2 = k2.replace("<anonymous>", a2.displayName));
                return k2;
              }
            while (1 <= g2 && 0 <= h2);
          }
          break;
        }
      }
    } finally {
      Na = false, Error.prepareStackTrace = c;
    }
    return (a2 = a2 ? a2.displayName || a2.name : "") ? Ma2(a2) : "";
  }
  function Pa(a2) {
    switch (a2.tag) {
      case 5:
        return Ma2(a2.type);
      case 16:
        return Ma2("Lazy");
      case 13:
        return Ma2("Suspense");
      case 19:
        return Ma2("SuspenseList");
      case 0:
      case 2:
      case 15:
        return a2 = Oa(a2.type, false), a2;
      case 11:
        return a2 = Oa(a2.type.render, false), a2;
      case 1:
        return a2 = Oa(a2.type, true), a2;
      default:
        return "";
    }
  }
  function Qa2(a2) {
    if (null == a2) return null;
    if ("function" === typeof a2) return a2.displayName || a2.name || null;
    if ("string" === typeof a2) return a2;
    switch (a2) {
      case ya:
        return "Fragment";
      case wa:
        return "Portal";
      case Aa2:
        return "Profiler";
      case za:
        return "StrictMode";
      case Ea:
        return "Suspense";
      case Fa2:
        return "SuspenseList";
    }
    if ("object" === typeof a2) switch (a2.$$typeof) {
      case Ca2:
        return (a2.displayName || "Context") + ".Consumer";
      case Ba2:
        return (a2._context.displayName || "Context") + ".Provider";
      case Da:
        var b = a2.render;
        a2 = a2.displayName;
        a2 || (a2 = b.displayName || b.name || "", a2 = "" !== a2 ? "ForwardRef(" + a2 + ")" : "ForwardRef");
        return a2;
      case Ga2:
        return b = a2.displayName || null, null !== b ? b : Qa2(a2.type) || "Memo";
      case Ha2:
        b = a2._payload;
        a2 = a2._init;
        try {
          return Qa2(a2(b));
        } catch (c) {
        }
    }
    return null;
  }
  function Ra(a2) {
    var b = a2.type;
    switch (a2.tag) {
      case 24:
        return "Cache";
      case 9:
        return (b.displayName || "Context") + ".Consumer";
      case 10:
        return (b._context.displayName || "Context") + ".Provider";
      case 18:
        return "DehydratedFragment";
      case 11:
        return a2 = b.render, a2 = a2.displayName || a2.name || "", b.displayName || ("" !== a2 ? "ForwardRef(" + a2 + ")" : "ForwardRef");
      case 7:
        return "Fragment";
      case 5:
        return b;
      case 4:
        return "Portal";
      case 3:
        return "Root";
      case 6:
        return "Text";
      case 16:
        return Qa2(b);
      case 8:
        return b === za ? "StrictMode" : "Mode";
      case 22:
        return "Offscreen";
      case 12:
        return "Profiler";
      case 21:
        return "Scope";
      case 13:
        return "Suspense";
      case 19:
        return "SuspenseList";
      case 25:
        return "TracingMarker";
      case 1:
      case 0:
      case 17:
      case 2:
      case 14:
      case 15:
        if ("function" === typeof b) return b.displayName || b.name || null;
        if ("string" === typeof b) return b;
    }
    return null;
  }
  function Sa(a2) {
    switch (typeof a2) {
      case "boolean":
      case "number":
      case "string":
      case "undefined":
        return a2;
      case "object":
        return a2;
      default:
        return "";
    }
  }
  function Ta(a2) {
    var b = a2.type;
    return (a2 = a2.nodeName) && "input" === a2.toLowerCase() && ("checkbox" === b || "radio" === b);
  }
  function Ua(a2) {
    var b = Ta(a2) ? "checked" : "value", c = Object.getOwnPropertyDescriptor(a2.constructor.prototype, b), d2 = "" + a2[b];
    if (!a2.hasOwnProperty(b) && "undefined" !== typeof c && "function" === typeof c.get && "function" === typeof c.set) {
      var e = c.get, f2 = c.set;
      Object.defineProperty(a2, b, { configurable: true, get: function() {
        return e.call(this);
      }, set: function(a3) {
        d2 = "" + a3;
        f2.call(this, a3);
      } });
      Object.defineProperty(a2, b, { enumerable: c.enumerable });
      return { getValue: function() {
        return d2;
      }, setValue: function(a3) {
        d2 = "" + a3;
      }, stopTracking: function() {
        a2._valueTracker = null;
        delete a2[b];
      } };
    }
  }
  function Va2(a2) {
    a2._valueTracker || (a2._valueTracker = Ua(a2));
  }
  function Wa2(a2) {
    if (!a2) return false;
    var b = a2._valueTracker;
    if (!b) return true;
    var c = b.getValue();
    var d2 = "";
    a2 && (d2 = Ta(a2) ? a2.checked ? "true" : "false" : a2.value);
    a2 = d2;
    return a2 !== c ? (b.setValue(a2), true) : false;
  }
  function Xa2(a2) {
    a2 = a2 || ("undefined" !== typeof document ? document : void 0);
    if ("undefined" === typeof a2) return null;
    try {
      return a2.activeElement || a2.body;
    } catch (b) {
      return a2.body;
    }
  }
  function Ya2(a2, b) {
    var c = b.checked;
    return A2({}, b, { defaultChecked: void 0, defaultValue: void 0, value: void 0, checked: null != c ? c : a2._wrapperState.initialChecked });
  }
  function Za2(a2, b) {
    var c = null == b.defaultValue ? "" : b.defaultValue, d2 = null != b.checked ? b.checked : b.defaultChecked;
    c = Sa(null != b.value ? b.value : c);
    a2._wrapperState = { initialChecked: d2, initialValue: c, controlled: "checkbox" === b.type || "radio" === b.type ? null != b.checked : null != b.value };
  }
  function ab(a2, b) {
    b = b.checked;
    null != b && ta2(a2, "checked", b, false);
  }
  function bb(a2, b) {
    ab(a2, b);
    var c = Sa(b.value), d2 = b.type;
    if (null != c) if ("number" === d2) {
      if (0 === c && "" === a2.value || a2.value != c) a2.value = "" + c;
    } else a2.value !== "" + c && (a2.value = "" + c);
    else if ("submit" === d2 || "reset" === d2) {
      a2.removeAttribute("value");
      return;
    }
    b.hasOwnProperty("value") ? cb(a2, b.type, c) : b.hasOwnProperty("defaultValue") && cb(a2, b.type, Sa(b.defaultValue));
    null == b.checked && null != b.defaultChecked && (a2.defaultChecked = !!b.defaultChecked);
  }
  function db(a2, b, c) {
    if (b.hasOwnProperty("value") || b.hasOwnProperty("defaultValue")) {
      var d2 = b.type;
      if (!("submit" !== d2 && "reset" !== d2 || void 0 !== b.value && null !== b.value)) return;
      b = "" + a2._wrapperState.initialValue;
      c || b === a2.value || (a2.value = b);
      a2.defaultValue = b;
    }
    c = a2.name;
    "" !== c && (a2.name = "");
    a2.defaultChecked = !!a2._wrapperState.initialChecked;
    "" !== c && (a2.name = c);
  }
  function cb(a2, b, c) {
    if ("number" !== b || Xa2(a2.ownerDocument) !== a2) null == c ? a2.defaultValue = "" + a2._wrapperState.initialValue : a2.defaultValue !== "" + c && (a2.defaultValue = "" + c);
  }
  var eb = Array.isArray;
  function fb(a2, b, c, d2) {
    a2 = a2.options;
    if (b) {
      b = {};
      for (var e = 0; e < c.length; e++) b["$" + c[e]] = true;
      for (c = 0; c < a2.length; c++) e = b.hasOwnProperty("$" + a2[c].value), a2[c].selected !== e && (a2[c].selected = e), e && d2 && (a2[c].defaultSelected = true);
    } else {
      c = "" + Sa(c);
      b = null;
      for (e = 0; e < a2.length; e++) {
        if (a2[e].value === c) {
          a2[e].selected = true;
          d2 && (a2[e].defaultSelected = true);
          return;
        }
        null !== b || a2[e].disabled || (b = a2[e]);
      }
      null !== b && (b.selected = true);
    }
  }
  function gb(a2, b) {
    if (null != b.dangerouslySetInnerHTML) throw Error(p2(91));
    return A2({}, b, { value: void 0, defaultValue: void 0, children: "" + a2._wrapperState.initialValue });
  }
  function hb(a2, b) {
    var c = b.value;
    if (null == c) {
      c = b.children;
      b = b.defaultValue;
      if (null != c) {
        if (null != b) throw Error(p2(92));
        if (eb(c)) {
          if (1 < c.length) throw Error(p2(93));
          c = c[0];
        }
        b = c;
      }
      null == b && (b = "");
      c = b;
    }
    a2._wrapperState = { initialValue: Sa(c) };
  }
  function ib(a2, b) {
    var c = Sa(b.value), d2 = Sa(b.defaultValue);
    null != c && (c = "" + c, c !== a2.value && (a2.value = c), null == b.defaultValue && a2.defaultValue !== c && (a2.defaultValue = c));
    null != d2 && (a2.defaultValue = "" + d2);
  }
  function jb(a2) {
    var b = a2.textContent;
    b === a2._wrapperState.initialValue && "" !== b && null !== b && (a2.value = b);
  }
  function kb(a2) {
    switch (a2) {
      case "svg":
        return "http://www.w3.org/2000/svg";
      case "math":
        return "http://www.w3.org/1998/Math/MathML";
      default:
        return "http://www.w3.org/1999/xhtml";
    }
  }
  function lb(a2, b) {
    return null == a2 || "http://www.w3.org/1999/xhtml" === a2 ? kb(b) : "http://www.w3.org/2000/svg" === a2 && "foreignObject" === b ? "http://www.w3.org/1999/xhtml" : a2;
  }
  var mb, nb = (function(a2) {
    return "undefined" !== typeof MSApp && MSApp.execUnsafeLocalFunction ? function(b, c, d2, e) {
      MSApp.execUnsafeLocalFunction(function() {
        return a2(b, c, d2, e);
      });
    } : a2;
  })(function(a2, b) {
    if ("http://www.w3.org/2000/svg" !== a2.namespaceURI || "innerHTML" in a2) a2.innerHTML = b;
    else {
      mb = mb || document.createElement("div");
      mb.innerHTML = "<svg>" + b.valueOf().toString() + "</svg>";
      for (b = mb.firstChild; a2.firstChild; ) a2.removeChild(a2.firstChild);
      for (; b.firstChild; ) a2.appendChild(b.firstChild);
    }
  });
  function ob(a2, b) {
    if (b) {
      var c = a2.firstChild;
      if (c && c === a2.lastChild && 3 === c.nodeType) {
        c.nodeValue = b;
        return;
      }
    }
    a2.textContent = b;
  }
  var pb = {
    animationIterationCount: true,
    aspectRatio: true,
    borderImageOutset: true,
    borderImageSlice: true,
    borderImageWidth: true,
    boxFlex: true,
    boxFlexGroup: true,
    boxOrdinalGroup: true,
    columnCount: true,
    columns: true,
    flex: true,
    flexGrow: true,
    flexPositive: true,
    flexShrink: true,
    flexNegative: true,
    flexOrder: true,
    gridArea: true,
    gridRow: true,
    gridRowEnd: true,
    gridRowSpan: true,
    gridRowStart: true,
    gridColumn: true,
    gridColumnEnd: true,
    gridColumnSpan: true,
    gridColumnStart: true,
    fontWeight: true,
    lineClamp: true,
    lineHeight: true,
    opacity: true,
    order: true,
    orphans: true,
    tabSize: true,
    widows: true,
    zIndex: true,
    zoom: true,
    fillOpacity: true,
    floodOpacity: true,
    stopOpacity: true,
    strokeDasharray: true,
    strokeDashoffset: true,
    strokeMiterlimit: true,
    strokeOpacity: true,
    strokeWidth: true
  }, qb = ["Webkit", "ms", "Moz", "O"];
  Object.keys(pb).forEach(function(a2) {
    qb.forEach(function(b) {
      b = b + a2.charAt(0).toUpperCase() + a2.substring(1);
      pb[b] = pb[a2];
    });
  });
  function rb(a2, b, c) {
    return null == b || "boolean" === typeof b || "" === b ? "" : c || "number" !== typeof b || 0 === b || pb.hasOwnProperty(a2) && pb[a2] ? ("" + b).trim() : b + "px";
  }
  function sb(a2, b) {
    a2 = a2.style;
    for (var c in b) if (b.hasOwnProperty(c)) {
      var d2 = 0 === c.indexOf("--"), e = rb(c, b[c], d2);
      "float" === c && (c = "cssFloat");
      d2 ? a2.setProperty(c, e) : a2[c] = e;
    }
  }
  var tb = A2({ menuitem: true }, { area: true, base: true, br: true, col: true, embed: true, hr: true, img: true, input: true, keygen: true, link: true, meta: true, param: true, source: true, track: true, wbr: true });
  function ub(a2, b) {
    if (b) {
      if (tb[a2] && (null != b.children || null != b.dangerouslySetInnerHTML)) throw Error(p2(137, a2));
      if (null != b.dangerouslySetInnerHTML) {
        if (null != b.children) throw Error(p2(60));
        if ("object" !== typeof b.dangerouslySetInnerHTML || !("__html" in b.dangerouslySetInnerHTML)) throw Error(p2(61));
      }
      if (null != b.style && "object" !== typeof b.style) throw Error(p2(62));
    }
  }
  function vb(a2, b) {
    if (-1 === a2.indexOf("-")) return "string" === typeof b.is;
    switch (a2) {
      case "annotation-xml":
      case "color-profile":
      case "font-face":
      case "font-face-src":
      case "font-face-uri":
      case "font-face-format":
      case "font-face-name":
      case "missing-glyph":
        return false;
      default:
        return true;
    }
  }
  var wb = null;
  function xb(a2) {
    a2 = a2.target || a2.srcElement || window;
    a2.correspondingUseElement && (a2 = a2.correspondingUseElement);
    return 3 === a2.nodeType ? a2.parentNode : a2;
  }
  var yb = null, zb = null, Ab = null;
  function Bb(a2) {
    if (a2 = Cb(a2)) {
      if ("function" !== typeof yb) throw Error(p2(280));
      var b = a2.stateNode;
      b && (b = Db(b), yb(a2.stateNode, a2.type, b));
    }
  }
  function Eb(a2) {
    zb ? Ab ? Ab.push(a2) : Ab = [a2] : zb = a2;
  }
  function Fb() {
    if (zb) {
      var a2 = zb, b = Ab;
      Ab = zb = null;
      Bb(a2);
      if (b) for (a2 = 0; a2 < b.length; a2++) Bb(b[a2]);
    }
  }
  function Gb(a2, b) {
    return a2(b);
  }
  function Hb() {
  }
  var Ib = false;
  function Jb(a2, b, c) {
    if (Ib) return a2(b, c);
    Ib = true;
    try {
      return Gb(a2, b, c);
    } finally {
      if (Ib = false, null !== zb || null !== Ab) Hb(), Fb();
    }
  }
  function Kb(a2, b) {
    var c = a2.stateNode;
    if (null === c) return null;
    var d2 = Db(c);
    if (null === d2) return null;
    c = d2[b];
    a: switch (b) {
      case "onClick":
      case "onClickCapture":
      case "onDoubleClick":
      case "onDoubleClickCapture":
      case "onMouseDown":
      case "onMouseDownCapture":
      case "onMouseMove":
      case "onMouseMoveCapture":
      case "onMouseUp":
      case "onMouseUpCapture":
      case "onMouseEnter":
        (d2 = !d2.disabled) || (a2 = a2.type, d2 = !("button" === a2 || "input" === a2 || "select" === a2 || "textarea" === a2));
        a2 = !d2;
        break a;
      default:
        a2 = false;
    }
    if (a2) return null;
    if (c && "function" !== typeof c) throw Error(p2(231, b, typeof c));
    return c;
  }
  var Lb = false;
  if (ia2) try {
    var Mb = {};
    Object.defineProperty(Mb, "passive", { get: function() {
      Lb = true;
    } });
    window.addEventListener("test", Mb, Mb);
    window.removeEventListener("test", Mb, Mb);
  } catch (a2) {
    Lb = false;
  }
  function Nb(a2, b, c, d2, e, f2, g2, h2, k2) {
    var l = Array.prototype.slice.call(arguments, 3);
    try {
      b.apply(c, l);
    } catch (m2) {
      this.onError(m2);
    }
  }
  var Ob = false, Pb = null, Qb = false, Rb = null, Sb = { onError: function(a2) {
    Ob = true;
    Pb = a2;
  } };
  function Tb(a2, b, c, d2, e, f2, g2, h2, k2) {
    Ob = false;
    Pb = null;
    Nb.apply(Sb, arguments);
  }
  function Ub(a2, b, c, d2, e, f2, g2, h2, k2) {
    Tb.apply(this, arguments);
    if (Ob) {
      if (Ob) {
        var l = Pb;
        Ob = false;
        Pb = null;
      } else throw Error(p2(198));
      Qb || (Qb = true, Rb = l);
    }
  }
  function Vb(a2) {
    var b = a2, c = a2;
    if (a2.alternate) for (; b.return; ) b = b.return;
    else {
      a2 = b;
      do
        b = a2, 0 !== (b.flags & 4098) && (c = b.return), a2 = b.return;
      while (a2);
    }
    return 3 === b.tag ? c : null;
  }
  function Wb(a2) {
    if (13 === a2.tag) {
      var b = a2.memoizedState;
      null === b && (a2 = a2.alternate, null !== a2 && (b = a2.memoizedState));
      if (null !== b) return b.dehydrated;
    }
    return null;
  }
  function Xb(a2) {
    if (Vb(a2) !== a2) throw Error(p2(188));
  }
  function Yb(a2) {
    var b = a2.alternate;
    if (!b) {
      b = Vb(a2);
      if (null === b) throw Error(p2(188));
      return b !== a2 ? null : a2;
    }
    for (var c = a2, d2 = b; ; ) {
      var e = c.return;
      if (null === e) break;
      var f2 = e.alternate;
      if (null === f2) {
        d2 = e.return;
        if (null !== d2) {
          c = d2;
          continue;
        }
        break;
      }
      if (e.child === f2.child) {
        for (f2 = e.child; f2; ) {
          if (f2 === c) return Xb(e), a2;
          if (f2 === d2) return Xb(e), b;
          f2 = f2.sibling;
        }
        throw Error(p2(188));
      }
      if (c.return !== d2.return) c = e, d2 = f2;
      else {
        for (var g2 = false, h2 = e.child; h2; ) {
          if (h2 === c) {
            g2 = true;
            c = e;
            d2 = f2;
            break;
          }
          if (h2 === d2) {
            g2 = true;
            d2 = e;
            c = f2;
            break;
          }
          h2 = h2.sibling;
        }
        if (!g2) {
          for (h2 = f2.child; h2; ) {
            if (h2 === c) {
              g2 = true;
              c = f2;
              d2 = e;
              break;
            }
            if (h2 === d2) {
              g2 = true;
              d2 = f2;
              c = e;
              break;
            }
            h2 = h2.sibling;
          }
          if (!g2) throw Error(p2(189));
        }
      }
      if (c.alternate !== d2) throw Error(p2(190));
    }
    if (3 !== c.tag) throw Error(p2(188));
    return c.stateNode.current === c ? a2 : b;
  }
  function Zb(a2) {
    a2 = Yb(a2);
    return null !== a2 ? $b(a2) : null;
  }
  function $b(a2) {
    if (5 === a2.tag || 6 === a2.tag) return a2;
    for (a2 = a2.child; null !== a2; ) {
      var b = $b(a2);
      if (null !== b) return b;
      a2 = a2.sibling;
    }
    return null;
  }
  var ac2 = ca2.unstable_scheduleCallback, bc2 = ca2.unstable_cancelCallback, cc2 = ca2.unstable_shouldYield, dc2 = ca2.unstable_requestPaint, B2 = ca2.unstable_now, ec2 = ca2.unstable_getCurrentPriorityLevel, fc2 = ca2.unstable_ImmediatePriority, gc2 = ca2.unstable_UserBlockingPriority, hc2 = ca2.unstable_NormalPriority, ic2 = ca2.unstable_LowPriority, jc2 = ca2.unstable_IdlePriority, kc2 = null, lc2 = null;
  function mc2(a2) {
    if (lc2 && "function" === typeof lc2.onCommitFiberRoot) try {
      lc2.onCommitFiberRoot(kc2, a2, void 0, 128 === (a2.current.flags & 128));
    } catch (b) {
    }
  }
  var oc2 = Math.clz32 ? Math.clz32 : nc2, pc2 = Math.log, qc2 = Math.LN2;
  function nc2(a2) {
    a2 >>>= 0;
    return 0 === a2 ? 32 : 31 - (pc2(a2) / qc2 | 0) | 0;
  }
  var rc2 = 64, sc2 = 4194304;
  function tc2(a2) {
    switch (a2 & -a2) {
      case 1:
        return 1;
      case 2:
        return 2;
      case 4:
        return 4;
      case 8:
        return 8;
      case 16:
        return 16;
      case 32:
        return 32;
      case 64:
      case 128:
      case 256:
      case 512:
      case 1024:
      case 2048:
      case 4096:
      case 8192:
      case 16384:
      case 32768:
      case 65536:
      case 131072:
      case 262144:
      case 524288:
      case 1048576:
      case 2097152:
        return a2 & 4194240;
      case 4194304:
      case 8388608:
      case 16777216:
      case 33554432:
      case 67108864:
        return a2 & 130023424;
      case 134217728:
        return 134217728;
      case 268435456:
        return 268435456;
      case 536870912:
        return 536870912;
      case 1073741824:
        return 1073741824;
      default:
        return a2;
    }
  }
  function uc2(a2, b) {
    var c = a2.pendingLanes;
    if (0 === c) return 0;
    var d2 = 0, e = a2.suspendedLanes, f2 = a2.pingedLanes, g2 = c & 268435455;
    if (0 !== g2) {
      var h2 = g2 & ~e;
      0 !== h2 ? d2 = tc2(h2) : (f2 &= g2, 0 !== f2 && (d2 = tc2(f2)));
    } else g2 = c & ~e, 0 !== g2 ? d2 = tc2(g2) : 0 !== f2 && (d2 = tc2(f2));
    if (0 === d2) return 0;
    if (0 !== b && b !== d2 && 0 === (b & e) && (e = d2 & -d2, f2 = b & -b, e >= f2 || 16 === e && 0 !== (f2 & 4194240))) return b;
    0 !== (d2 & 4) && (d2 |= c & 16);
    b = a2.entangledLanes;
    if (0 !== b) for (a2 = a2.entanglements, b &= d2; 0 < b; ) c = 31 - oc2(b), e = 1 << c, d2 |= a2[c], b &= ~e;
    return d2;
  }
  function vc2(a2, b) {
    switch (a2) {
      case 1:
      case 2:
      case 4:
        return b + 250;
      case 8:
      case 16:
      case 32:
      case 64:
      case 128:
      case 256:
      case 512:
      case 1024:
      case 2048:
      case 4096:
      case 8192:
      case 16384:
      case 32768:
      case 65536:
      case 131072:
      case 262144:
      case 524288:
      case 1048576:
      case 2097152:
        return b + 5e3;
      case 4194304:
      case 8388608:
      case 16777216:
      case 33554432:
      case 67108864:
        return -1;
      case 134217728:
      case 268435456:
      case 536870912:
      case 1073741824:
        return -1;
      default:
        return -1;
    }
  }
  function wc2(a2, b) {
    for (var c = a2.suspendedLanes, d2 = a2.pingedLanes, e = a2.expirationTimes, f2 = a2.pendingLanes; 0 < f2; ) {
      var g2 = 31 - oc2(f2), h2 = 1 << g2, k2 = e[g2];
      if (-1 === k2) {
        if (0 === (h2 & c) || 0 !== (h2 & d2)) e[g2] = vc2(h2, b);
      } else k2 <= b && (a2.expiredLanes |= h2);
      f2 &= ~h2;
    }
  }
  function xc2(a2) {
    a2 = a2.pendingLanes & -1073741825;
    return 0 !== a2 ? a2 : a2 & 1073741824 ? 1073741824 : 0;
  }
  function yc2() {
    var a2 = rc2;
    rc2 <<= 1;
    0 === (rc2 & 4194240) && (rc2 = 64);
    return a2;
  }
  function zc2(a2) {
    for (var b = [], c = 0; 31 > c; c++) b.push(a2);
    return b;
  }
  function Ac2(a2, b, c) {
    a2.pendingLanes |= b;
    536870912 !== b && (a2.suspendedLanes = 0, a2.pingedLanes = 0);
    a2 = a2.eventTimes;
    b = 31 - oc2(b);
    a2[b] = c;
  }
  function Bc2(a2, b) {
    var c = a2.pendingLanes & ~b;
    a2.pendingLanes = b;
    a2.suspendedLanes = 0;
    a2.pingedLanes = 0;
    a2.expiredLanes &= b;
    a2.mutableReadLanes &= b;
    a2.entangledLanes &= b;
    b = a2.entanglements;
    var d2 = a2.eventTimes;
    for (a2 = a2.expirationTimes; 0 < c; ) {
      var e = 31 - oc2(c), f2 = 1 << e;
      b[e] = 0;
      d2[e] = -1;
      a2[e] = -1;
      c &= ~f2;
    }
  }
  function Cc2(a2, b) {
    var c = a2.entangledLanes |= b;
    for (a2 = a2.entanglements; c; ) {
      var d2 = 31 - oc2(c), e = 1 << d2;
      e & b | a2[d2] & b && (a2[d2] |= b);
      c &= ~e;
    }
  }
  var C = 0;
  function Dc2(a2) {
    a2 &= -a2;
    return 1 < a2 ? 4 < a2 ? 0 !== (a2 & 268435455) ? 16 : 536870912 : 4 : 1;
  }
  var Ec2, Fc2, Gc2, Hc2, Ic2, Jc2 = false, Kc2 = [], Lc2 = null, Mc2 = null, Nc2 = null, Oc2 = /* @__PURE__ */ new Map(), Pc2 = /* @__PURE__ */ new Map(), Qc2 = [], Rc2 = "mousedown mouseup touchcancel touchend touchstart auxclick dblclick pointercancel pointerdown pointerup dragend dragstart drop compositionend compositionstart keydown keypress keyup input textInput copy cut paste click change contextmenu reset submit".split(" ");
  function Sc2(a2, b) {
    switch (a2) {
      case "focusin":
      case "focusout":
        Lc2 = null;
        break;
      case "dragenter":
      case "dragleave":
        Mc2 = null;
        break;
      case "mouseover":
      case "mouseout":
        Nc2 = null;
        break;
      case "pointerover":
      case "pointerout":
        Oc2.delete(b.pointerId);
        break;
      case "gotpointercapture":
      case "lostpointercapture":
        Pc2.delete(b.pointerId);
    }
  }
  function Tc2(a2, b, c, d2, e, f2) {
    if (null === a2 || a2.nativeEvent !== f2) return a2 = { blockedOn: b, domEventName: c, eventSystemFlags: d2, nativeEvent: f2, targetContainers: [e] }, null !== b && (b = Cb(b), null !== b && Fc2(b)), a2;
    a2.eventSystemFlags |= d2;
    b = a2.targetContainers;
    null !== e && -1 === b.indexOf(e) && b.push(e);
    return a2;
  }
  function Uc2(a2, b, c, d2, e) {
    switch (b) {
      case "focusin":
        return Lc2 = Tc2(Lc2, a2, b, c, d2, e), true;
      case "dragenter":
        return Mc2 = Tc2(Mc2, a2, b, c, d2, e), true;
      case "mouseover":
        return Nc2 = Tc2(Nc2, a2, b, c, d2, e), true;
      case "pointerover":
        var f2 = e.pointerId;
        Oc2.set(f2, Tc2(Oc2.get(f2) || null, a2, b, c, d2, e));
        return true;
      case "gotpointercapture":
        return f2 = e.pointerId, Pc2.set(f2, Tc2(Pc2.get(f2) || null, a2, b, c, d2, e)), true;
    }
    return false;
  }
  function Vc2(a2) {
    var b = Wc2(a2.target);
    if (null !== b) {
      var c = Vb(b);
      if (null !== c) {
        if (b = c.tag, 13 === b) {
          if (b = Wb(c), null !== b) {
            a2.blockedOn = b;
            Ic2(a2.priority, function() {
              Gc2(c);
            });
            return;
          }
        } else if (3 === b && c.stateNode.current.memoizedState.isDehydrated) {
          a2.blockedOn = 3 === c.tag ? c.stateNode.containerInfo : null;
          return;
        }
      }
    }
    a2.blockedOn = null;
  }
  function Xc2(a2) {
    if (null !== a2.blockedOn) return false;
    for (var b = a2.targetContainers; 0 < b.length; ) {
      var c = Yc2(a2.domEventName, a2.eventSystemFlags, b[0], a2.nativeEvent);
      if (null === c) {
        c = a2.nativeEvent;
        var d2 = new c.constructor(c.type, c);
        wb = d2;
        c.target.dispatchEvent(d2);
        wb = null;
      } else return b = Cb(c), null !== b && Fc2(b), a2.blockedOn = c, false;
      b.shift();
    }
    return true;
  }
  function Zc2(a2, b, c) {
    Xc2(a2) && c.delete(b);
  }
  function $c2() {
    Jc2 = false;
    null !== Lc2 && Xc2(Lc2) && (Lc2 = null);
    null !== Mc2 && Xc2(Mc2) && (Mc2 = null);
    null !== Nc2 && Xc2(Nc2) && (Nc2 = null);
    Oc2.forEach(Zc2);
    Pc2.forEach(Zc2);
  }
  function ad2(a2, b) {
    a2.blockedOn === b && (a2.blockedOn = null, Jc2 || (Jc2 = true, ca2.unstable_scheduleCallback(ca2.unstable_NormalPriority, $c2)));
  }
  function bd2(a2) {
    function b(b2) {
      return ad2(b2, a2);
    }
    if (0 < Kc2.length) {
      ad2(Kc2[0], a2);
      for (var c = 1; c < Kc2.length; c++) {
        var d2 = Kc2[c];
        d2.blockedOn === a2 && (d2.blockedOn = null);
      }
    }
    null !== Lc2 && ad2(Lc2, a2);
    null !== Mc2 && ad2(Mc2, a2);
    null !== Nc2 && ad2(Nc2, a2);
    Oc2.forEach(b);
    Pc2.forEach(b);
    for (c = 0; c < Qc2.length; c++) d2 = Qc2[c], d2.blockedOn === a2 && (d2.blockedOn = null);
    for (; 0 < Qc2.length && (c = Qc2[0], null === c.blockedOn); ) Vc2(c), null === c.blockedOn && Qc2.shift();
  }
  var cd2 = ua2.ReactCurrentBatchConfig, dd2 = true;
  function ed2(a2, b, c, d2) {
    var e = C, f2 = cd2.transition;
    cd2.transition = null;
    try {
      C = 1, fd2(a2, b, c, d2);
    } finally {
      C = e, cd2.transition = f2;
    }
  }
  function gd2(a2, b, c, d2) {
    var e = C, f2 = cd2.transition;
    cd2.transition = null;
    try {
      C = 4, fd2(a2, b, c, d2);
    } finally {
      C = e, cd2.transition = f2;
    }
  }
  function fd2(a2, b, c, d2) {
    if (dd2) {
      var e = Yc2(a2, b, c, d2);
      if (null === e) hd2(a2, b, d2, id2, c), Sc2(a2, d2);
      else if (Uc2(e, a2, b, c, d2)) d2.stopPropagation();
      else if (Sc2(a2, d2), b & 4 && -1 < Rc2.indexOf(a2)) {
        for (; null !== e; ) {
          var f2 = Cb(e);
          null !== f2 && Ec2(f2);
          f2 = Yc2(a2, b, c, d2);
          null === f2 && hd2(a2, b, d2, id2, c);
          if (f2 === e) break;
          e = f2;
        }
        null !== e && d2.stopPropagation();
      } else hd2(a2, b, d2, null, c);
    }
  }
  var id2 = null;
  function Yc2(a2, b, c, d2) {
    id2 = null;
    a2 = xb(d2);
    a2 = Wc2(a2);
    if (null !== a2) if (b = Vb(a2), null === b) a2 = null;
    else if (c = b.tag, 13 === c) {
      a2 = Wb(b);
      if (null !== a2) return a2;
      a2 = null;
    } else if (3 === c) {
      if (b.stateNode.current.memoizedState.isDehydrated) return 3 === b.tag ? b.stateNode.containerInfo : null;
      a2 = null;
    } else b !== a2 && (a2 = null);
    id2 = a2;
    return null;
  }
  function jd2(a2) {
    switch (a2) {
      case "cancel":
      case "click":
      case "close":
      case "contextmenu":
      case "copy":
      case "cut":
      case "auxclick":
      case "dblclick":
      case "dragend":
      case "dragstart":
      case "drop":
      case "focusin":
      case "focusout":
      case "input":
      case "invalid":
      case "keydown":
      case "keypress":
      case "keyup":
      case "mousedown":
      case "mouseup":
      case "paste":
      case "pause":
      case "play":
      case "pointercancel":
      case "pointerdown":
      case "pointerup":
      case "ratechange":
      case "reset":
      case "resize":
      case "seeked":
      case "submit":
      case "touchcancel":
      case "touchend":
      case "touchstart":
      case "volumechange":
      case "change":
      case "selectionchange":
      case "textInput":
      case "compositionstart":
      case "compositionend":
      case "compositionupdate":
      case "beforeblur":
      case "afterblur":
      case "beforeinput":
      case "blur":
      case "fullscreenchange":
      case "focus":
      case "hashchange":
      case "popstate":
      case "select":
      case "selectstart":
        return 1;
      case "drag":
      case "dragenter":
      case "dragexit":
      case "dragleave":
      case "dragover":
      case "mousemove":
      case "mouseout":
      case "mouseover":
      case "pointermove":
      case "pointerout":
      case "pointerover":
      case "scroll":
      case "toggle":
      case "touchmove":
      case "wheel":
      case "mouseenter":
      case "mouseleave":
      case "pointerenter":
      case "pointerleave":
        return 4;
      case "message":
        switch (ec2()) {
          case fc2:
            return 1;
          case gc2:
            return 4;
          case hc2:
          case ic2:
            return 16;
          case jc2:
            return 536870912;
          default:
            return 16;
        }
      default:
        return 16;
    }
  }
  var kd2 = null, ld2 = null, md2 = null;
  function nd2() {
    if (md2) return md2;
    var a2, b = ld2, c = b.length, d2, e = "value" in kd2 ? kd2.value : kd2.textContent, f2 = e.length;
    for (a2 = 0; a2 < c && b[a2] === e[a2]; a2++) ;
    var g2 = c - a2;
    for (d2 = 1; d2 <= g2 && b[c - d2] === e[f2 - d2]; d2++) ;
    return md2 = e.slice(a2, 1 < d2 ? 1 - d2 : void 0);
  }
  function od2(a2) {
    var b = a2.keyCode;
    "charCode" in a2 ? (a2 = a2.charCode, 0 === a2 && 13 === b && (a2 = 13)) : a2 = b;
    10 === a2 && (a2 = 13);
    return 32 <= a2 || 13 === a2 ? a2 : 0;
  }
  function pd2() {
    return true;
  }
  function qd2() {
    return false;
  }
  function rd2(a2) {
    function b(b2, d2, e, f2, g2) {
      this._reactName = b2;
      this._targetInst = e;
      this.type = d2;
      this.nativeEvent = f2;
      this.target = g2;
      this.currentTarget = null;
      for (var c in a2) a2.hasOwnProperty(c) && (b2 = a2[c], this[c] = b2 ? b2(f2) : f2[c]);
      this.isDefaultPrevented = (null != f2.defaultPrevented ? f2.defaultPrevented : false === f2.returnValue) ? pd2 : qd2;
      this.isPropagationStopped = qd2;
      return this;
    }
    A2(b.prototype, { preventDefault: function() {
      this.defaultPrevented = true;
      var a3 = this.nativeEvent;
      a3 && (a3.preventDefault ? a3.preventDefault() : "unknown" !== typeof a3.returnValue && (a3.returnValue = false), this.isDefaultPrevented = pd2);
    }, stopPropagation: function() {
      var a3 = this.nativeEvent;
      a3 && (a3.stopPropagation ? a3.stopPropagation() : "unknown" !== typeof a3.cancelBubble && (a3.cancelBubble = true), this.isPropagationStopped = pd2);
    }, persist: function() {
    }, isPersistent: pd2 });
    return b;
  }
  var sd2 = { eventPhase: 0, bubbles: 0, cancelable: 0, timeStamp: function(a2) {
    return a2.timeStamp || Date.now();
  }, defaultPrevented: 0, isTrusted: 0 }, td2 = rd2(sd2), ud2 = A2({}, sd2, { view: 0, detail: 0 }), vd2 = rd2(ud2), wd2, xd2, yd2, Ad2 = A2({}, ud2, { screenX: 0, screenY: 0, clientX: 0, clientY: 0, pageX: 0, pageY: 0, ctrlKey: 0, shiftKey: 0, altKey: 0, metaKey: 0, getModifierState: zd2, button: 0, buttons: 0, relatedTarget: function(a2) {
    return void 0 === a2.relatedTarget ? a2.fromElement === a2.srcElement ? a2.toElement : a2.fromElement : a2.relatedTarget;
  }, movementX: function(a2) {
    if ("movementX" in a2) return a2.movementX;
    a2 !== yd2 && (yd2 && "mousemove" === a2.type ? (wd2 = a2.screenX - yd2.screenX, xd2 = a2.screenY - yd2.screenY) : xd2 = wd2 = 0, yd2 = a2);
    return wd2;
  }, movementY: function(a2) {
    return "movementY" in a2 ? a2.movementY : xd2;
  } }), Bd2 = rd2(Ad2), Cd2 = A2({}, Ad2, { dataTransfer: 0 }), Dd2 = rd2(Cd2), Ed2 = A2({}, ud2, { relatedTarget: 0 }), Fd2 = rd2(Ed2), Gd2 = A2({}, sd2, { animationName: 0, elapsedTime: 0, pseudoElement: 0 }), Hd2 = rd2(Gd2), Id2 = A2({}, sd2, { clipboardData: function(a2) {
    return "clipboardData" in a2 ? a2.clipboardData : window.clipboardData;
  } }), Jd2 = rd2(Id2), Kd2 = A2({}, sd2, { data: 0 }), Ld2 = rd2(Kd2), Md2 = {
    Esc: "Escape",
    Spacebar: " ",
    Left: "ArrowLeft",
    Up: "ArrowUp",
    Right: "ArrowRight",
    Down: "ArrowDown",
    Del: "Delete",
    Win: "OS",
    Menu: "ContextMenu",
    Apps: "ContextMenu",
    Scroll: "ScrollLock",
    MozPrintableKey: "Unidentified"
  }, Nd2 = {
    8: "Backspace",
    9: "Tab",
    12: "Clear",
    13: "Enter",
    16: "Shift",
    17: "Control",
    18: "Alt",
    19: "Pause",
    20: "CapsLock",
    27: "Escape",
    32: " ",
    33: "PageUp",
    34: "PageDown",
    35: "End",
    36: "Home",
    37: "ArrowLeft",
    38: "ArrowUp",
    39: "ArrowRight",
    40: "ArrowDown",
    45: "Insert",
    46: "Delete",
    112: "F1",
    113: "F2",
    114: "F3",
    115: "F4",
    116: "F5",
    117: "F6",
    118: "F7",
    119: "F8",
    120: "F9",
    121: "F10",
    122: "F11",
    123: "F12",
    144: "NumLock",
    145: "ScrollLock",
    224: "Meta"
  }, Od2 = { Alt: "altKey", Control: "ctrlKey", Meta: "metaKey", Shift: "shiftKey" };
  function Pd2(a2) {
    var b = this.nativeEvent;
    return b.getModifierState ? b.getModifierState(a2) : (a2 = Od2[a2]) ? !!b[a2] : false;
  }
  function zd2() {
    return Pd2;
  }
  var Qd2 = A2({}, ud2, { key: function(a2) {
    if (a2.key) {
      var b = Md2[a2.key] || a2.key;
      if ("Unidentified" !== b) return b;
    }
    return "keypress" === a2.type ? (a2 = od2(a2), 13 === a2 ? "Enter" : String.fromCharCode(a2)) : "keydown" === a2.type || "keyup" === a2.type ? Nd2[a2.keyCode] || "Unidentified" : "";
  }, code: 0, location: 0, ctrlKey: 0, shiftKey: 0, altKey: 0, metaKey: 0, repeat: 0, locale: 0, getModifierState: zd2, charCode: function(a2) {
    return "keypress" === a2.type ? od2(a2) : 0;
  }, keyCode: function(a2) {
    return "keydown" === a2.type || "keyup" === a2.type ? a2.keyCode : 0;
  }, which: function(a2) {
    return "keypress" === a2.type ? od2(a2) : "keydown" === a2.type || "keyup" === a2.type ? a2.keyCode : 0;
  } }), Rd2 = rd2(Qd2), Sd2 = A2({}, Ad2, { pointerId: 0, width: 0, height: 0, pressure: 0, tangentialPressure: 0, tiltX: 0, tiltY: 0, twist: 0, pointerType: 0, isPrimary: 0 }), Td2 = rd2(Sd2), Ud2 = A2({}, ud2, { touches: 0, targetTouches: 0, changedTouches: 0, altKey: 0, metaKey: 0, ctrlKey: 0, shiftKey: 0, getModifierState: zd2 }), Vd2 = rd2(Ud2), Wd2 = A2({}, sd2, { propertyName: 0, elapsedTime: 0, pseudoElement: 0 }), Xd2 = rd2(Wd2), Yd2 = A2({}, Ad2, {
    deltaX: function(a2) {
      return "deltaX" in a2 ? a2.deltaX : "wheelDeltaX" in a2 ? -a2.wheelDeltaX : 0;
    },
    deltaY: function(a2) {
      return "deltaY" in a2 ? a2.deltaY : "wheelDeltaY" in a2 ? -a2.wheelDeltaY : "wheelDelta" in a2 ? -a2.wheelDelta : 0;
    },
    deltaZ: 0,
    deltaMode: 0
  }), Zd2 = rd2(Yd2), $d2 = [9, 13, 27, 32], ae2 = ia2 && "CompositionEvent" in window, be2 = null;
  ia2 && "documentMode" in document && (be2 = document.documentMode);
  var ce2 = ia2 && "TextEvent" in window && !be2, de2 = ia2 && (!ae2 || be2 && 8 < be2 && 11 >= be2), ee2 = String.fromCharCode(32), fe2 = false;
  function ge2(a2, b) {
    switch (a2) {
      case "keyup":
        return -1 !== $d2.indexOf(b.keyCode);
      case "keydown":
        return 229 !== b.keyCode;
      case "keypress":
      case "mousedown":
      case "focusout":
        return true;
      default:
        return false;
    }
  }
  function he2(a2) {
    a2 = a2.detail;
    return "object" === typeof a2 && "data" in a2 ? a2.data : null;
  }
  var ie2 = false;
  function je2(a2, b) {
    switch (a2) {
      case "compositionend":
        return he2(b);
      case "keypress":
        if (32 !== b.which) return null;
        fe2 = true;
        return ee2;
      case "textInput":
        return a2 = b.data, a2 === ee2 && fe2 ? null : a2;
      default:
        return null;
    }
  }
  function ke2(a2, b) {
    if (ie2) return "compositionend" === a2 || !ae2 && ge2(a2, b) ? (a2 = nd2(), md2 = ld2 = kd2 = null, ie2 = false, a2) : null;
    switch (a2) {
      case "paste":
        return null;
      case "keypress":
        if (!(b.ctrlKey || b.altKey || b.metaKey) || b.ctrlKey && b.altKey) {
          if (b.char && 1 < b.char.length) return b.char;
          if (b.which) return String.fromCharCode(b.which);
        }
        return null;
      case "compositionend":
        return de2 && "ko" !== b.locale ? null : b.data;
      default:
        return null;
    }
  }
  var le2 = { color: true, date: true, datetime: true, "datetime-local": true, email: true, month: true, number: true, password: true, range: true, search: true, tel: true, text: true, time: true, url: true, week: true };
  function me2(a2) {
    var b = a2 && a2.nodeName && a2.nodeName.toLowerCase();
    return "input" === b ? !!le2[a2.type] : "textarea" === b ? true : false;
  }
  function ne2(a2, b, c, d2) {
    Eb(d2);
    b = oe2(b, "onChange");
    0 < b.length && (c = new td2("onChange", "change", null, c, d2), a2.push({ event: c, listeners: b }));
  }
  var pe2 = null, qe2 = null;
  function re2(a2) {
    se2(a2, 0);
  }
  function te2(a2) {
    var b = ue2(a2);
    if (Wa2(b)) return a2;
  }
  function ve2(a2, b) {
    if ("change" === a2) return b;
  }
  var we2 = false;
  if (ia2) {
    var xe2;
    if (ia2) {
      var ye2 = "oninput" in document;
      if (!ye2) {
        var ze2 = document.createElement("div");
        ze2.setAttribute("oninput", "return;");
        ye2 = "function" === typeof ze2.oninput;
      }
      xe2 = ye2;
    } else xe2 = false;
    we2 = xe2 && (!document.documentMode || 9 < document.documentMode);
  }
  function Ae() {
    pe2 && (pe2.detachEvent("onpropertychange", Be2), qe2 = pe2 = null);
  }
  function Be2(a2) {
    if ("value" === a2.propertyName && te2(qe2)) {
      var b = [];
      ne2(b, qe2, a2, xb(a2));
      Jb(re2, b);
    }
  }
  function Ce2(a2, b, c) {
    "focusin" === a2 ? (Ae(), pe2 = b, qe2 = c, pe2.attachEvent("onpropertychange", Be2)) : "focusout" === a2 && Ae();
  }
  function De2(a2) {
    if ("selectionchange" === a2 || "keyup" === a2 || "keydown" === a2) return te2(qe2);
  }
  function Ee2(a2, b) {
    if ("click" === a2) return te2(b);
  }
  function Fe2(a2, b) {
    if ("input" === a2 || "change" === a2) return te2(b);
  }
  function Ge2(a2, b) {
    return a2 === b && (0 !== a2 || 1 / a2 === 1 / b) || a2 !== a2 && b !== b;
  }
  var He2 = "function" === typeof Object.is ? Object.is : Ge2;
  function Ie2(a2, b) {
    if (He2(a2, b)) return true;
    if ("object" !== typeof a2 || null === a2 || "object" !== typeof b || null === b) return false;
    var c = Object.keys(a2), d2 = Object.keys(b);
    if (c.length !== d2.length) return false;
    for (d2 = 0; d2 < c.length; d2++) {
      var e = c[d2];
      if (!ja2.call(b, e) || !He2(a2[e], b[e])) return false;
    }
    return true;
  }
  function Je2(a2) {
    for (; a2 && a2.firstChild; ) a2 = a2.firstChild;
    return a2;
  }
  function Ke(a2, b) {
    var c = Je2(a2);
    a2 = 0;
    for (var d2; c; ) {
      if (3 === c.nodeType) {
        d2 = a2 + c.textContent.length;
        if (a2 <= b && d2 >= b) return { node: c, offset: b - a2 };
        a2 = d2;
      }
      a: {
        for (; c; ) {
          if (c.nextSibling) {
            c = c.nextSibling;
            break a;
          }
          c = c.parentNode;
        }
        c = void 0;
      }
      c = Je2(c);
    }
  }
  function Le2(a2, b) {
    return a2 && b ? a2 === b ? true : a2 && 3 === a2.nodeType ? false : b && 3 === b.nodeType ? Le2(a2, b.parentNode) : "contains" in a2 ? a2.contains(b) : a2.compareDocumentPosition ? !!(a2.compareDocumentPosition(b) & 16) : false : false;
  }
  function Me2() {
    for (var a2 = window, b = Xa2(); b instanceof a2.HTMLIFrameElement; ) {
      try {
        var c = "string" === typeof b.contentWindow.location.href;
      } catch (d2) {
        c = false;
      }
      if (c) a2 = b.contentWindow;
      else break;
      b = Xa2(a2.document);
    }
    return b;
  }
  function Ne(a2) {
    var b = a2 && a2.nodeName && a2.nodeName.toLowerCase();
    return b && ("input" === b && ("text" === a2.type || "search" === a2.type || "tel" === a2.type || "url" === a2.type || "password" === a2.type) || "textarea" === b || "true" === a2.contentEditable);
  }
  function Oe(a2) {
    var b = Me2(), c = a2.focusedElem, d2 = a2.selectionRange;
    if (b !== c && c && c.ownerDocument && Le2(c.ownerDocument.documentElement, c)) {
      if (null !== d2 && Ne(c)) {
        if (b = d2.start, a2 = d2.end, void 0 === a2 && (a2 = b), "selectionStart" in c) c.selectionStart = b, c.selectionEnd = Math.min(a2, c.value.length);
        else if (a2 = (b = c.ownerDocument || document) && b.defaultView || window, a2.getSelection) {
          a2 = a2.getSelection();
          var e = c.textContent.length, f2 = Math.min(d2.start, e);
          d2 = void 0 === d2.end ? f2 : Math.min(d2.end, e);
          !a2.extend && f2 > d2 && (e = d2, d2 = f2, f2 = e);
          e = Ke(c, f2);
          var g2 = Ke(
            c,
            d2
          );
          e && g2 && (1 !== a2.rangeCount || a2.anchorNode !== e.node || a2.anchorOffset !== e.offset || a2.focusNode !== g2.node || a2.focusOffset !== g2.offset) && (b = b.createRange(), b.setStart(e.node, e.offset), a2.removeAllRanges(), f2 > d2 ? (a2.addRange(b), a2.extend(g2.node, g2.offset)) : (b.setEnd(g2.node, g2.offset), a2.addRange(b)));
        }
      }
      b = [];
      for (a2 = c; a2 = a2.parentNode; ) 1 === a2.nodeType && b.push({ element: a2, left: a2.scrollLeft, top: a2.scrollTop });
      "function" === typeof c.focus && c.focus();
      for (c = 0; c < b.length; c++) a2 = b[c], a2.element.scrollLeft = a2.left, a2.element.scrollTop = a2.top;
    }
  }
  var Pe2 = ia2 && "documentMode" in document && 11 >= document.documentMode, Qe2 = null, Re2 = null, Se2 = null, Te2 = false;
  function Ue(a2, b, c) {
    var d2 = c.window === c ? c.document : 9 === c.nodeType ? c : c.ownerDocument;
    Te2 || null == Qe2 || Qe2 !== Xa2(d2) || (d2 = Qe2, "selectionStart" in d2 && Ne(d2) ? d2 = { start: d2.selectionStart, end: d2.selectionEnd } : (d2 = (d2.ownerDocument && d2.ownerDocument.defaultView || window).getSelection(), d2 = { anchorNode: d2.anchorNode, anchorOffset: d2.anchorOffset, focusNode: d2.focusNode, focusOffset: d2.focusOffset }), Se2 && Ie2(Se2, d2) || (Se2 = d2, d2 = oe2(Re2, "onSelect"), 0 < d2.length && (b = new td2("onSelect", "select", null, b, c), a2.push({ event: b, listeners: d2 }), b.target = Qe2)));
  }
  function Ve2(a2, b) {
    var c = {};
    c[a2.toLowerCase()] = b.toLowerCase();
    c["Webkit" + a2] = "webkit" + b;
    c["Moz" + a2] = "moz" + b;
    return c;
  }
  var We = { animationend: Ve2("Animation", "AnimationEnd"), animationiteration: Ve2("Animation", "AnimationIteration"), animationstart: Ve2("Animation", "AnimationStart"), transitionend: Ve2("Transition", "TransitionEnd") }, Xe2 = {}, Ye2 = {};
  ia2 && (Ye2 = document.createElement("div").style, "AnimationEvent" in window || (delete We.animationend.animation, delete We.animationiteration.animation, delete We.animationstart.animation), "TransitionEvent" in window || delete We.transitionend.transition);
  function Ze2(a2) {
    if (Xe2[a2]) return Xe2[a2];
    if (!We[a2]) return a2;
    var b = We[a2], c;
    for (c in b) if (b.hasOwnProperty(c) && c in Ye2) return Xe2[a2] = b[c];
    return a2;
  }
  var $e2 = Ze2("animationend"), af = Ze2("animationiteration"), bf = Ze2("animationstart"), cf = Ze2("transitionend"), df = /* @__PURE__ */ new Map(), ef = "abort auxClick cancel canPlay canPlayThrough click close contextMenu copy cut drag dragEnd dragEnter dragExit dragLeave dragOver dragStart drop durationChange emptied encrypted ended error gotPointerCapture input invalid keyDown keyPress keyUp load loadedData loadedMetadata loadStart lostPointerCapture mouseDown mouseMove mouseOut mouseOver mouseUp paste pause play playing pointerCancel pointerDown pointerMove pointerOut pointerOver pointerUp progress rateChange reset resize seeked seeking stalled submit suspend timeUpdate touchCancel touchEnd touchStart volumeChange scroll toggle touchMove waiting wheel".split(" ");
  function ff(a2, b) {
    df.set(a2, b);
    fa2(b, [a2]);
  }
  for (var gf = 0; gf < ef.length; gf++) {
    var hf = ef[gf], jf2 = hf.toLowerCase(), kf2 = hf[0].toUpperCase() + hf.slice(1);
    ff(jf2, "on" + kf2);
  }
  ff($e2, "onAnimationEnd");
  ff(af, "onAnimationIteration");
  ff(bf, "onAnimationStart");
  ff("dblclick", "onDoubleClick");
  ff("focusin", "onFocus");
  ff("focusout", "onBlur");
  ff(cf, "onTransitionEnd");
  ha2("onMouseEnter", ["mouseout", "mouseover"]);
  ha2("onMouseLeave", ["mouseout", "mouseover"]);
  ha2("onPointerEnter", ["pointerout", "pointerover"]);
  ha2("onPointerLeave", ["pointerout", "pointerover"]);
  fa2("onChange", "change click focusin focusout input keydown keyup selectionchange".split(" "));
  fa2("onSelect", "focusout contextmenu dragend focusin keydown keyup mousedown mouseup selectionchange".split(" "));
  fa2("onBeforeInput", ["compositionend", "keypress", "textInput", "paste"]);
  fa2("onCompositionEnd", "compositionend focusout keydown keypress keyup mousedown".split(" "));
  fa2("onCompositionStart", "compositionstart focusout keydown keypress keyup mousedown".split(" "));
  fa2("onCompositionUpdate", "compositionupdate focusout keydown keypress keyup mousedown".split(" "));
  var lf = "abort canplay canplaythrough durationchange emptied encrypted ended error loadeddata loadedmetadata loadstart pause play playing progress ratechange resize seeked seeking stalled suspend timeupdate volumechange waiting".split(" "), mf = new Set("cancel close invalid load scroll toggle".split(" ").concat(lf));
  function nf(a2, b, c) {
    var d2 = a2.type || "unknown-event";
    a2.currentTarget = c;
    Ub(d2, b, void 0, a2);
    a2.currentTarget = null;
  }
  function se2(a2, b) {
    b = 0 !== (b & 4);
    for (var c = 0; c < a2.length; c++) {
      var d2 = a2[c], e = d2.event;
      d2 = d2.listeners;
      a: {
        var f2 = void 0;
        if (b) for (var g2 = d2.length - 1; 0 <= g2; g2--) {
          var h2 = d2[g2], k2 = h2.instance, l = h2.currentTarget;
          h2 = h2.listener;
          if (k2 !== f2 && e.isPropagationStopped()) break a;
          nf(e, h2, l);
          f2 = k2;
        }
        else for (g2 = 0; g2 < d2.length; g2++) {
          h2 = d2[g2];
          k2 = h2.instance;
          l = h2.currentTarget;
          h2 = h2.listener;
          if (k2 !== f2 && e.isPropagationStopped()) break a;
          nf(e, h2, l);
          f2 = k2;
        }
      }
    }
    if (Qb) throw a2 = Rb, Qb = false, Rb = null, a2;
  }
  function D2(a2, b) {
    var c = b[of];
    void 0 === c && (c = b[of] = /* @__PURE__ */ new Set());
    var d2 = a2 + "__bubble";
    c.has(d2) || (pf(b, a2, 2, false), c.add(d2));
  }
  function qf2(a2, b, c) {
    var d2 = 0;
    b && (d2 |= 4);
    pf(c, a2, d2, b);
  }
  var rf = "_reactListening" + Math.random().toString(36).slice(2);
  function sf(a2) {
    if (!a2[rf]) {
      a2[rf] = true;
      da2.forEach(function(b2) {
        "selectionchange" !== b2 && (mf.has(b2) || qf2(b2, false, a2), qf2(b2, true, a2));
      });
      var b = 9 === a2.nodeType ? a2 : a2.ownerDocument;
      null === b || b[rf] || (b[rf] = true, qf2("selectionchange", false, b));
    }
  }
  function pf(a2, b, c, d2) {
    switch (jd2(b)) {
      case 1:
        var e = ed2;
        break;
      case 4:
        e = gd2;
        break;
      default:
        e = fd2;
    }
    c = e.bind(null, b, c, a2);
    e = void 0;
    !Lb || "touchstart" !== b && "touchmove" !== b && "wheel" !== b || (e = true);
    d2 ? void 0 !== e ? a2.addEventListener(b, c, { capture: true, passive: e }) : a2.addEventListener(b, c, true) : void 0 !== e ? a2.addEventListener(b, c, { passive: e }) : a2.addEventListener(b, c, false);
  }
  function hd2(a2, b, c, d2, e) {
    var f2 = d2;
    if (0 === (b & 1) && 0 === (b & 2) && null !== d2) a: for (; ; ) {
      if (null === d2) return;
      var g2 = d2.tag;
      if (3 === g2 || 4 === g2) {
        var h2 = d2.stateNode.containerInfo;
        if (h2 === e || 8 === h2.nodeType && h2.parentNode === e) break;
        if (4 === g2) for (g2 = d2.return; null !== g2; ) {
          var k2 = g2.tag;
          if (3 === k2 || 4 === k2) {
            if (k2 = g2.stateNode.containerInfo, k2 === e || 8 === k2.nodeType && k2.parentNode === e) return;
          }
          g2 = g2.return;
        }
        for (; null !== h2; ) {
          g2 = Wc2(h2);
          if (null === g2) return;
          k2 = g2.tag;
          if (5 === k2 || 6 === k2) {
            d2 = f2 = g2;
            continue a;
          }
          h2 = h2.parentNode;
        }
      }
      d2 = d2.return;
    }
    Jb(function() {
      var d3 = f2, e2 = xb(c), g3 = [];
      a: {
        var h3 = df.get(a2);
        if (void 0 !== h3) {
          var k3 = td2, n = a2;
          switch (a2) {
            case "keypress":
              if (0 === od2(c)) break a;
            case "keydown":
            case "keyup":
              k3 = Rd2;
              break;
            case "focusin":
              n = "focus";
              k3 = Fd2;
              break;
            case "focusout":
              n = "blur";
              k3 = Fd2;
              break;
            case "beforeblur":
            case "afterblur":
              k3 = Fd2;
              break;
            case "click":
              if (2 === c.button) break a;
            case "auxclick":
            case "dblclick":
            case "mousedown":
            case "mousemove":
            case "mouseup":
            case "mouseout":
            case "mouseover":
            case "contextmenu":
              k3 = Bd2;
              break;
            case "drag":
            case "dragend":
            case "dragenter":
            case "dragexit":
            case "dragleave":
            case "dragover":
            case "dragstart":
            case "drop":
              k3 = Dd2;
              break;
            case "touchcancel":
            case "touchend":
            case "touchmove":
            case "touchstart":
              k3 = Vd2;
              break;
            case $e2:
            case af:
            case bf:
              k3 = Hd2;
              break;
            case cf:
              k3 = Xd2;
              break;
            case "scroll":
              k3 = vd2;
              break;
            case "wheel":
              k3 = Zd2;
              break;
            case "copy":
            case "cut":
            case "paste":
              k3 = Jd2;
              break;
            case "gotpointercapture":
            case "lostpointercapture":
            case "pointercancel":
            case "pointerdown":
            case "pointermove":
            case "pointerout":
            case "pointerover":
            case "pointerup":
              k3 = Td2;
          }
          var t = 0 !== (b & 4), J2 = !t && "scroll" === a2, x2 = t ? null !== h3 ? h3 + "Capture" : null : h3;
          t = [];
          for (var w2 = d3, u2; null !== w2; ) {
            u2 = w2;
            var F2 = u2.stateNode;
            5 === u2.tag && null !== F2 && (u2 = F2, null !== x2 && (F2 = Kb(w2, x2), null != F2 && t.push(tf(w2, F2, u2))));
            if (J2) break;
            w2 = w2.return;
          }
          0 < t.length && (h3 = new k3(h3, n, null, c, e2), g3.push({ event: h3, listeners: t }));
        }
      }
      if (0 === (b & 7)) {
        a: {
          h3 = "mouseover" === a2 || "pointerover" === a2;
          k3 = "mouseout" === a2 || "pointerout" === a2;
          if (h3 && c !== wb && (n = c.relatedTarget || c.fromElement) && (Wc2(n) || n[uf])) break a;
          if (k3 || h3) {
            h3 = e2.window === e2 ? e2 : (h3 = e2.ownerDocument) ? h3.defaultView || h3.parentWindow : window;
            if (k3) {
              if (n = c.relatedTarget || c.toElement, k3 = d3, n = n ? Wc2(n) : null, null !== n && (J2 = Vb(n), n !== J2 || 5 !== n.tag && 6 !== n.tag)) n = null;
            } else k3 = null, n = d3;
            if (k3 !== n) {
              t = Bd2;
              F2 = "onMouseLeave";
              x2 = "onMouseEnter";
              w2 = "mouse";
              if ("pointerout" === a2 || "pointerover" === a2) t = Td2, F2 = "onPointerLeave", x2 = "onPointerEnter", w2 = "pointer";
              J2 = null == k3 ? h3 : ue2(k3);
              u2 = null == n ? h3 : ue2(n);
              h3 = new t(F2, w2 + "leave", k3, c, e2);
              h3.target = J2;
              h3.relatedTarget = u2;
              F2 = null;
              Wc2(e2) === d3 && (t = new t(x2, w2 + "enter", n, c, e2), t.target = u2, t.relatedTarget = J2, F2 = t);
              J2 = F2;
              if (k3 && n) b: {
                t = k3;
                x2 = n;
                w2 = 0;
                for (u2 = t; u2; u2 = vf(u2)) w2++;
                u2 = 0;
                for (F2 = x2; F2; F2 = vf(F2)) u2++;
                for (; 0 < w2 - u2; ) t = vf(t), w2--;
                for (; 0 < u2 - w2; ) x2 = vf(x2), u2--;
                for (; w2--; ) {
                  if (t === x2 || null !== x2 && t === x2.alternate) break b;
                  t = vf(t);
                  x2 = vf(x2);
                }
                t = null;
              }
              else t = null;
              null !== k3 && wf2(g3, h3, k3, t, false);
              null !== n && null !== J2 && wf2(g3, J2, n, t, true);
            }
          }
        }
        a: {
          h3 = d3 ? ue2(d3) : window;
          k3 = h3.nodeName && h3.nodeName.toLowerCase();
          if ("select" === k3 || "input" === k3 && "file" === h3.type) var na2 = ve2;
          else if (me2(h3)) if (we2) na2 = Fe2;
          else {
            na2 = De2;
            var xa = Ce2;
          }
          else (k3 = h3.nodeName) && "input" === k3.toLowerCase() && ("checkbox" === h3.type || "radio" === h3.type) && (na2 = Ee2);
          if (na2 && (na2 = na2(a2, d3))) {
            ne2(g3, na2, c, e2);
            break a;
          }
          xa && xa(a2, h3, d3);
          "focusout" === a2 && (xa = h3._wrapperState) && xa.controlled && "number" === h3.type && cb(h3, "number", h3.value);
        }
        xa = d3 ? ue2(d3) : window;
        switch (a2) {
          case "focusin":
            if (me2(xa) || "true" === xa.contentEditable) Qe2 = xa, Re2 = d3, Se2 = null;
            break;
          case "focusout":
            Se2 = Re2 = Qe2 = null;
            break;
          case "mousedown":
            Te2 = true;
            break;
          case "contextmenu":
          case "mouseup":
          case "dragend":
            Te2 = false;
            Ue(g3, c, e2);
            break;
          case "selectionchange":
            if (Pe2) break;
          case "keydown":
          case "keyup":
            Ue(g3, c, e2);
        }
        var $a;
        if (ae2) b: {
          switch (a2) {
            case "compositionstart":
              var ba = "onCompositionStart";
              break b;
            case "compositionend":
              ba = "onCompositionEnd";
              break b;
            case "compositionupdate":
              ba = "onCompositionUpdate";
              break b;
          }
          ba = void 0;
        }
        else ie2 ? ge2(a2, c) && (ba = "onCompositionEnd") : "keydown" === a2 && 229 === c.keyCode && (ba = "onCompositionStart");
        ba && (de2 && "ko" !== c.locale && (ie2 || "onCompositionStart" !== ba ? "onCompositionEnd" === ba && ie2 && ($a = nd2()) : (kd2 = e2, ld2 = "value" in kd2 ? kd2.value : kd2.textContent, ie2 = true)), xa = oe2(d3, ba), 0 < xa.length && (ba = new Ld2(ba, a2, null, c, e2), g3.push({ event: ba, listeners: xa }), $a ? ba.data = $a : ($a = he2(c), null !== $a && (ba.data = $a))));
        if ($a = ce2 ? je2(a2, c) : ke2(a2, c)) d3 = oe2(d3, "onBeforeInput"), 0 < d3.length && (e2 = new Ld2("onBeforeInput", "beforeinput", null, c, e2), g3.push({ event: e2, listeners: d3 }), e2.data = $a);
      }
      se2(g3, b);
    });
  }
  function tf(a2, b, c) {
    return { instance: a2, listener: b, currentTarget: c };
  }
  function oe2(a2, b) {
    for (var c = b + "Capture", d2 = []; null !== a2; ) {
      var e = a2, f2 = e.stateNode;
      5 === e.tag && null !== f2 && (e = f2, f2 = Kb(a2, c), null != f2 && d2.unshift(tf(a2, f2, e)), f2 = Kb(a2, b), null != f2 && d2.push(tf(a2, f2, e)));
      a2 = a2.return;
    }
    return d2;
  }
  function vf(a2) {
    if (null === a2) return null;
    do
      a2 = a2.return;
    while (a2 && 5 !== a2.tag);
    return a2 ? a2 : null;
  }
  function wf2(a2, b, c, d2, e) {
    for (var f2 = b._reactName, g2 = []; null !== c && c !== d2; ) {
      var h2 = c, k2 = h2.alternate, l = h2.stateNode;
      if (null !== k2 && k2 === d2) break;
      5 === h2.tag && null !== l && (h2 = l, e ? (k2 = Kb(c, f2), null != k2 && g2.unshift(tf(c, k2, h2))) : e || (k2 = Kb(c, f2), null != k2 && g2.push(tf(c, k2, h2))));
      c = c.return;
    }
    0 !== g2.length && a2.push({ event: b, listeners: g2 });
  }
  var xf2 = /\r\n?/g, yf = /\u0000|\uFFFD/g;
  function zf2(a2) {
    return ("string" === typeof a2 ? a2 : "" + a2).replace(xf2, "\n").replace(yf, "");
  }
  function Af2(a2, b, c) {
    b = zf2(b);
    if (zf2(a2) !== b && c) throw Error(p2(425));
  }
  function Bf2() {
  }
  var Cf2 = null, Df2 = null;
  function Ef2(a2, b) {
    return "textarea" === a2 || "noscript" === a2 || "string" === typeof b.children || "number" === typeof b.children || "object" === typeof b.dangerouslySetInnerHTML && null !== b.dangerouslySetInnerHTML && null != b.dangerouslySetInnerHTML.__html;
  }
  var Ff2 = "function" === typeof setTimeout ? setTimeout : void 0, Gf2 = "function" === typeof clearTimeout ? clearTimeout : void 0, Hf2 = "function" === typeof Promise ? Promise : void 0, Jf2 = "function" === typeof queueMicrotask ? queueMicrotask : "undefined" !== typeof Hf2 ? function(a2) {
    return Hf2.resolve(null).then(a2).catch(If2);
  } : Ff2;
  function If2(a2) {
    setTimeout(function() {
      throw a2;
    });
  }
  function Kf2(a2, b) {
    var c = b, d2 = 0;
    do {
      var e = c.nextSibling;
      a2.removeChild(c);
      if (e && 8 === e.nodeType) if (c = e.data, "/$" === c) {
        if (0 === d2) {
          a2.removeChild(e);
          bd2(b);
          return;
        }
        d2--;
      } else "$" !== c && "$?" !== c && "$!" !== c || d2++;
      c = e;
    } while (c);
    bd2(b);
  }
  function Lf2(a2) {
    for (; null != a2; a2 = a2.nextSibling) {
      var b = a2.nodeType;
      if (1 === b || 3 === b) break;
      if (8 === b) {
        b = a2.data;
        if ("$" === b || "$!" === b || "$?" === b) break;
        if ("/$" === b) return null;
      }
    }
    return a2;
  }
  function Mf2(a2) {
    a2 = a2.previousSibling;
    for (var b = 0; a2; ) {
      if (8 === a2.nodeType) {
        var c = a2.data;
        if ("$" === c || "$!" === c || "$?" === c) {
          if (0 === b) return a2;
          b--;
        } else "/$" === c && b++;
      }
      a2 = a2.previousSibling;
    }
    return null;
  }
  var Nf2 = Math.random().toString(36).slice(2), Of2 = "__reactFiber$" + Nf2, Pf2 = "__reactProps$" + Nf2, uf = "__reactContainer$" + Nf2, of = "__reactEvents$" + Nf2, Qf2 = "__reactListeners$" + Nf2, Rf2 = "__reactHandles$" + Nf2;
  function Wc2(a2) {
    var b = a2[Of2];
    if (b) return b;
    for (var c = a2.parentNode; c; ) {
      if (b = c[uf] || c[Of2]) {
        c = b.alternate;
        if (null !== b.child || null !== c && null !== c.child) for (a2 = Mf2(a2); null !== a2; ) {
          if (c = a2[Of2]) return c;
          a2 = Mf2(a2);
        }
        return b;
      }
      a2 = c;
      c = a2.parentNode;
    }
    return null;
  }
  function Cb(a2) {
    a2 = a2[Of2] || a2[uf];
    return !a2 || 5 !== a2.tag && 6 !== a2.tag && 13 !== a2.tag && 3 !== a2.tag ? null : a2;
  }
  function ue2(a2) {
    if (5 === a2.tag || 6 === a2.tag) return a2.stateNode;
    throw Error(p2(33));
  }
  function Db(a2) {
    return a2[Pf2] || null;
  }
  var Sf2 = [], Tf2 = -1;
  function Uf2(a2) {
    return { current: a2 };
  }
  function E2(a2) {
    0 > Tf2 || (a2.current = Sf2[Tf2], Sf2[Tf2] = null, Tf2--);
  }
  function G2(a2, b) {
    Tf2++;
    Sf2[Tf2] = a2.current;
    a2.current = b;
  }
  var Vf2 = {}, H2 = Uf2(Vf2), Wf2 = Uf2(false), Xf2 = Vf2;
  function Yf2(a2, b) {
    var c = a2.type.contextTypes;
    if (!c) return Vf2;
    var d2 = a2.stateNode;
    if (d2 && d2.__reactInternalMemoizedUnmaskedChildContext === b) return d2.__reactInternalMemoizedMaskedChildContext;
    var e = {}, f2;
    for (f2 in c) e[f2] = b[f2];
    d2 && (a2 = a2.stateNode, a2.__reactInternalMemoizedUnmaskedChildContext = b, a2.__reactInternalMemoizedMaskedChildContext = e);
    return e;
  }
  function Zf2(a2) {
    a2 = a2.childContextTypes;
    return null !== a2 && void 0 !== a2;
  }
  function $f() {
    E2(Wf2);
    E2(H2);
  }
  function ag2(a2, b, c) {
    if (H2.current !== Vf2) throw Error(p2(168));
    G2(H2, b);
    G2(Wf2, c);
  }
  function bg2(a2, b, c) {
    var d2 = a2.stateNode;
    b = b.childContextTypes;
    if ("function" !== typeof d2.getChildContext) return c;
    d2 = d2.getChildContext();
    for (var e in d2) if (!(e in b)) throw Error(p2(108, Ra(a2) || "Unknown", e));
    return A2({}, c, d2);
  }
  function cg2(a2) {
    a2 = (a2 = a2.stateNode) && a2.__reactInternalMemoizedMergedChildContext || Vf2;
    Xf2 = H2.current;
    G2(H2, a2);
    G2(Wf2, Wf2.current);
    return true;
  }
  function dg2(a2, b, c) {
    var d2 = a2.stateNode;
    if (!d2) throw Error(p2(169));
    c ? (a2 = bg2(a2, b, Xf2), d2.__reactInternalMemoizedMergedChildContext = a2, E2(Wf2), E2(H2), G2(H2, a2)) : E2(Wf2);
    G2(Wf2, c);
  }
  var eg2 = null, fg2 = false, gg2 = false;
  function hg2(a2) {
    null === eg2 ? eg2 = [a2] : eg2.push(a2);
  }
  function ig2(a2) {
    fg2 = true;
    hg2(a2);
  }
  function jg2() {
    if (!gg2 && null !== eg2) {
      gg2 = true;
      var a2 = 0, b = C;
      try {
        var c = eg2;
        for (C = 1; a2 < c.length; a2++) {
          var d2 = c[a2];
          do
            d2 = d2(true);
          while (null !== d2);
        }
        eg2 = null;
        fg2 = false;
      } catch (e) {
        throw null !== eg2 && (eg2 = eg2.slice(a2 + 1)), ac2(fc2, jg2), e;
      } finally {
        C = b, gg2 = false;
      }
    }
    return null;
  }
  var kg2 = [], lg2 = 0, mg2 = null, ng2 = 0, og2 = [], pg2 = 0, qg2 = null, rg2 = 1, sg2 = "";
  function tg2(a2, b) {
    kg2[lg2++] = ng2;
    kg2[lg2++] = mg2;
    mg2 = a2;
    ng2 = b;
  }
  function ug2(a2, b, c) {
    og2[pg2++] = rg2;
    og2[pg2++] = sg2;
    og2[pg2++] = qg2;
    qg2 = a2;
    var d2 = rg2;
    a2 = sg2;
    var e = 32 - oc2(d2) - 1;
    d2 &= ~(1 << e);
    c += 1;
    var f2 = 32 - oc2(b) + e;
    if (30 < f2) {
      var g2 = e - e % 5;
      f2 = (d2 & (1 << g2) - 1).toString(32);
      d2 >>= g2;
      e -= g2;
      rg2 = 1 << 32 - oc2(b) + e | c << e | d2;
      sg2 = f2 + a2;
    } else rg2 = 1 << f2 | c << e | d2, sg2 = a2;
  }
  function vg3(a2) {
    null !== a2.return && (tg2(a2, 1), ug2(a2, 1, 0));
  }
  function wg2(a2) {
    for (; a2 === mg2; ) mg2 = kg2[--lg2], kg2[lg2] = null, ng2 = kg2[--lg2], kg2[lg2] = null;
    for (; a2 === qg2; ) qg2 = og2[--pg2], og2[pg2] = null, sg2 = og2[--pg2], og2[pg2] = null, rg2 = og2[--pg2], og2[pg2] = null;
  }
  var xg2 = null, yg2 = null, I2 = false, zg2 = null;
  function Ag2(a2, b) {
    var c = Bg2(5, null, null, 0);
    c.elementType = "DELETED";
    c.stateNode = b;
    c.return = a2;
    b = a2.deletions;
    null === b ? (a2.deletions = [c], a2.flags |= 16) : b.push(c);
  }
  function Cg2(a2, b) {
    switch (a2.tag) {
      case 5:
        var c = a2.type;
        b = 1 !== b.nodeType || c.toLowerCase() !== b.nodeName.toLowerCase() ? null : b;
        return null !== b ? (a2.stateNode = b, xg2 = a2, yg2 = Lf2(b.firstChild), true) : false;
      case 6:
        return b = "" === a2.pendingProps || 3 !== b.nodeType ? null : b, null !== b ? (a2.stateNode = b, xg2 = a2, yg2 = null, true) : false;
      case 13:
        return b = 8 !== b.nodeType ? null : b, null !== b ? (c = null !== qg2 ? { id: rg2, overflow: sg2 } : null, a2.memoizedState = { dehydrated: b, treeContext: c, retryLane: 1073741824 }, c = Bg2(18, null, null, 0), c.stateNode = b, c.return = a2, a2.child = c, xg2 = a2, yg2 = null, true) : false;
      default:
        return false;
    }
  }
  function Dg2(a2) {
    return 0 !== (a2.mode & 1) && 0 === (a2.flags & 128);
  }
  function Eg2(a2) {
    if (I2) {
      var b = yg2;
      if (b) {
        var c = b;
        if (!Cg2(a2, b)) {
          if (Dg2(a2)) throw Error(p2(418));
          b = Lf2(c.nextSibling);
          var d2 = xg2;
          b && Cg2(a2, b) ? Ag2(d2, c) : (a2.flags = a2.flags & -4097 | 2, I2 = false, xg2 = a2);
        }
      } else {
        if (Dg2(a2)) throw Error(p2(418));
        a2.flags = a2.flags & -4097 | 2;
        I2 = false;
        xg2 = a2;
      }
    }
  }
  function Fg2(a2) {
    for (a2 = a2.return; null !== a2 && 5 !== a2.tag && 3 !== a2.tag && 13 !== a2.tag; ) a2 = a2.return;
    xg2 = a2;
  }
  function Gg2(a2) {
    if (a2 !== xg2) return false;
    if (!I2) return Fg2(a2), I2 = true, false;
    var b;
    (b = 3 !== a2.tag) && !(b = 5 !== a2.tag) && (b = a2.type, b = "head" !== b && "body" !== b && !Ef2(a2.type, a2.memoizedProps));
    if (b && (b = yg2)) {
      if (Dg2(a2)) throw Hg2(), Error(p2(418));
      for (; b; ) Ag2(a2, b), b = Lf2(b.nextSibling);
    }
    Fg2(a2);
    if (13 === a2.tag) {
      a2 = a2.memoizedState;
      a2 = null !== a2 ? a2.dehydrated : null;
      if (!a2) throw Error(p2(317));
      a: {
        a2 = a2.nextSibling;
        for (b = 0; a2; ) {
          if (8 === a2.nodeType) {
            var c = a2.data;
            if ("/$" === c) {
              if (0 === b) {
                yg2 = Lf2(a2.nextSibling);
                break a;
              }
              b--;
            } else "$" !== c && "$!" !== c && "$?" !== c || b++;
          }
          a2 = a2.nextSibling;
        }
        yg2 = null;
      }
    } else yg2 = xg2 ? Lf2(a2.stateNode.nextSibling) : null;
    return true;
  }
  function Hg2() {
    for (var a2 = yg2; a2; ) a2 = Lf2(a2.nextSibling);
  }
  function Ig2() {
    yg2 = xg2 = null;
    I2 = false;
  }
  function Jg2(a2) {
    null === zg2 ? zg2 = [a2] : zg2.push(a2);
  }
  var Kg2 = ua2.ReactCurrentBatchConfig;
  function Lg2(a2, b, c) {
    a2 = c.ref;
    if (null !== a2 && "function" !== typeof a2 && "object" !== typeof a2) {
      if (c._owner) {
        c = c._owner;
        if (c) {
          if (1 !== c.tag) throw Error(p2(309));
          var d2 = c.stateNode;
        }
        if (!d2) throw Error(p2(147, a2));
        var e = d2, f2 = "" + a2;
        if (null !== b && null !== b.ref && "function" === typeof b.ref && b.ref._stringRef === f2) return b.ref;
        b = function(a3) {
          var b2 = e.refs;
          null === a3 ? delete b2[f2] : b2[f2] = a3;
        };
        b._stringRef = f2;
        return b;
      }
      if ("string" !== typeof a2) throw Error(p2(284));
      if (!c._owner) throw Error(p2(290, a2));
    }
    return a2;
  }
  function Mg2(a2, b) {
    a2 = Object.prototype.toString.call(b);
    throw Error(p2(31, "[object Object]" === a2 ? "object with keys {" + Object.keys(b).join(", ") + "}" : a2));
  }
  function Ng2(a2) {
    var b = a2._init;
    return b(a2._payload);
  }
  function Og2(a2) {
    function b(b2, c2) {
      if (a2) {
        var d3 = b2.deletions;
        null === d3 ? (b2.deletions = [c2], b2.flags |= 16) : d3.push(c2);
      }
    }
    function c(c2, d3) {
      if (!a2) return null;
      for (; null !== d3; ) b(c2, d3), d3 = d3.sibling;
      return null;
    }
    function d2(a3, b2) {
      for (a3 = /* @__PURE__ */ new Map(); null !== b2; ) null !== b2.key ? a3.set(b2.key, b2) : a3.set(b2.index, b2), b2 = b2.sibling;
      return a3;
    }
    function e(a3, b2) {
      a3 = Pg2(a3, b2);
      a3.index = 0;
      a3.sibling = null;
      return a3;
    }
    function f2(b2, c2, d3) {
      b2.index = d3;
      if (!a2) return b2.flags |= 1048576, c2;
      d3 = b2.alternate;
      if (null !== d3) return d3 = d3.index, d3 < c2 ? (b2.flags |= 2, c2) : d3;
      b2.flags |= 2;
      return c2;
    }
    function g2(b2) {
      a2 && null === b2.alternate && (b2.flags |= 2);
      return b2;
    }
    function h2(a3, b2, c2, d3) {
      if (null === b2 || 6 !== b2.tag) return b2 = Qg2(c2, a3.mode, d3), b2.return = a3, b2;
      b2 = e(b2, c2);
      b2.return = a3;
      return b2;
    }
    function k2(a3, b2, c2, d3) {
      var f3 = c2.type;
      if (f3 === ya) return m2(a3, b2, c2.props.children, d3, c2.key);
      if (null !== b2 && (b2.elementType === f3 || "object" === typeof f3 && null !== f3 && f3.$$typeof === Ha2 && Ng2(f3) === b2.type)) return d3 = e(b2, c2.props), d3.ref = Lg2(a3, b2, c2), d3.return = a3, d3;
      d3 = Rg2(c2.type, c2.key, c2.props, null, a3.mode, d3);
      d3.ref = Lg2(a3, b2, c2);
      d3.return = a3;
      return d3;
    }
    function l(a3, b2, c2, d3) {
      if (null === b2 || 4 !== b2.tag || b2.stateNode.containerInfo !== c2.containerInfo || b2.stateNode.implementation !== c2.implementation) return b2 = Sg2(c2, a3.mode, d3), b2.return = a3, b2;
      b2 = e(b2, c2.children || []);
      b2.return = a3;
      return b2;
    }
    function m2(a3, b2, c2, d3, f3) {
      if (null === b2 || 7 !== b2.tag) return b2 = Tg2(c2, a3.mode, d3, f3), b2.return = a3, b2;
      b2 = e(b2, c2);
      b2.return = a3;
      return b2;
    }
    function q2(a3, b2, c2) {
      if ("string" === typeof b2 && "" !== b2 || "number" === typeof b2) return b2 = Qg2("" + b2, a3.mode, c2), b2.return = a3, b2;
      if ("object" === typeof b2 && null !== b2) {
        switch (b2.$$typeof) {
          case va2:
            return c2 = Rg2(b2.type, b2.key, b2.props, null, a3.mode, c2), c2.ref = Lg2(a3, null, b2), c2.return = a3, c2;
          case wa:
            return b2 = Sg2(b2, a3.mode, c2), b2.return = a3, b2;
          case Ha2:
            var d3 = b2._init;
            return q2(a3, d3(b2._payload), c2);
        }
        if (eb(b2) || Ka2(b2)) return b2 = Tg2(b2, a3.mode, c2, null), b2.return = a3, b2;
        Mg2(a3, b2);
      }
      return null;
    }
    function r2(a3, b2, c2, d3) {
      var e2 = null !== b2 ? b2.key : null;
      if ("string" === typeof c2 && "" !== c2 || "number" === typeof c2) return null !== e2 ? null : h2(a3, b2, "" + c2, d3);
      if ("object" === typeof c2 && null !== c2) {
        switch (c2.$$typeof) {
          case va2:
            return c2.key === e2 ? k2(a3, b2, c2, d3) : null;
          case wa:
            return c2.key === e2 ? l(a3, b2, c2, d3) : null;
          case Ha2:
            return e2 = c2._init, r2(
              a3,
              b2,
              e2(c2._payload),
              d3
            );
        }
        if (eb(c2) || Ka2(c2)) return null !== e2 ? null : m2(a3, b2, c2, d3, null);
        Mg2(a3, c2);
      }
      return null;
    }
    function y2(a3, b2, c2, d3, e2) {
      if ("string" === typeof d3 && "" !== d3 || "number" === typeof d3) return a3 = a3.get(c2) || null, h2(b2, a3, "" + d3, e2);
      if ("object" === typeof d3 && null !== d3) {
        switch (d3.$$typeof) {
          case va2:
            return a3 = a3.get(null === d3.key ? c2 : d3.key) || null, k2(b2, a3, d3, e2);
          case wa:
            return a3 = a3.get(null === d3.key ? c2 : d3.key) || null, l(b2, a3, d3, e2);
          case Ha2:
            var f3 = d3._init;
            return y2(a3, b2, c2, f3(d3._payload), e2);
        }
        if (eb(d3) || Ka2(d3)) return a3 = a3.get(c2) || null, m2(b2, a3, d3, e2, null);
        Mg2(b2, d3);
      }
      return null;
    }
    function n(e2, g3, h3, k3) {
      for (var l2 = null, m3 = null, u2 = g3, w2 = g3 = 0, x2 = null; null !== u2 && w2 < h3.length; w2++) {
        u2.index > w2 ? (x2 = u2, u2 = null) : x2 = u2.sibling;
        var n2 = r2(e2, u2, h3[w2], k3);
        if (null === n2) {
          null === u2 && (u2 = x2);
          break;
        }
        a2 && u2 && null === n2.alternate && b(e2, u2);
        g3 = f2(n2, g3, w2);
        null === m3 ? l2 = n2 : m3.sibling = n2;
        m3 = n2;
        u2 = x2;
      }
      if (w2 === h3.length) return c(e2, u2), I2 && tg2(e2, w2), l2;
      if (null === u2) {
        for (; w2 < h3.length; w2++) u2 = q2(e2, h3[w2], k3), null !== u2 && (g3 = f2(u2, g3, w2), null === m3 ? l2 = u2 : m3.sibling = u2, m3 = u2);
        I2 && tg2(e2, w2);
        return l2;
      }
      for (u2 = d2(e2, u2); w2 < h3.length; w2++) x2 = y2(u2, e2, w2, h3[w2], k3), null !== x2 && (a2 && null !== x2.alternate && u2.delete(null === x2.key ? w2 : x2.key), g3 = f2(x2, g3, w2), null === m3 ? l2 = x2 : m3.sibling = x2, m3 = x2);
      a2 && u2.forEach(function(a3) {
        return b(e2, a3);
      });
      I2 && tg2(e2, w2);
      return l2;
    }
    function t(e2, g3, h3, k3) {
      var l2 = Ka2(h3);
      if ("function" !== typeof l2) throw Error(p2(150));
      h3 = l2.call(h3);
      if (null == h3) throw Error(p2(151));
      for (var u2 = l2 = null, m3 = g3, w2 = g3 = 0, x2 = null, n2 = h3.next(); null !== m3 && !n2.done; w2++, n2 = h3.next()) {
        m3.index > w2 ? (x2 = m3, m3 = null) : x2 = m3.sibling;
        var t2 = r2(e2, m3, n2.value, k3);
        if (null === t2) {
          null === m3 && (m3 = x2);
          break;
        }
        a2 && m3 && null === t2.alternate && b(e2, m3);
        g3 = f2(t2, g3, w2);
        null === u2 ? l2 = t2 : u2.sibling = t2;
        u2 = t2;
        m3 = x2;
      }
      if (n2.done) return c(
        e2,
        m3
      ), I2 && tg2(e2, w2), l2;
      if (null === m3) {
        for (; !n2.done; w2++, n2 = h3.next()) n2 = q2(e2, n2.value, k3), null !== n2 && (g3 = f2(n2, g3, w2), null === u2 ? l2 = n2 : u2.sibling = n2, u2 = n2);
        I2 && tg2(e2, w2);
        return l2;
      }
      for (m3 = d2(e2, m3); !n2.done; w2++, n2 = h3.next()) n2 = y2(m3, e2, w2, n2.value, k3), null !== n2 && (a2 && null !== n2.alternate && m3.delete(null === n2.key ? w2 : n2.key), g3 = f2(n2, g3, w2), null === u2 ? l2 = n2 : u2.sibling = n2, u2 = n2);
      a2 && m3.forEach(function(a3) {
        return b(e2, a3);
      });
      I2 && tg2(e2, w2);
      return l2;
    }
    function J2(a3, d3, f3, h3) {
      "object" === typeof f3 && null !== f3 && f3.type === ya && null === f3.key && (f3 = f3.props.children);
      if ("object" === typeof f3 && null !== f3) {
        switch (f3.$$typeof) {
          case va2:
            a: {
              for (var k3 = f3.key, l2 = d3; null !== l2; ) {
                if (l2.key === k3) {
                  k3 = f3.type;
                  if (k3 === ya) {
                    if (7 === l2.tag) {
                      c(a3, l2.sibling);
                      d3 = e(l2, f3.props.children);
                      d3.return = a3;
                      a3 = d3;
                      break a;
                    }
                  } else if (l2.elementType === k3 || "object" === typeof k3 && null !== k3 && k3.$$typeof === Ha2 && Ng2(k3) === l2.type) {
                    c(a3, l2.sibling);
                    d3 = e(l2, f3.props);
                    d3.ref = Lg2(a3, l2, f3);
                    d3.return = a3;
                    a3 = d3;
                    break a;
                  }
                  c(a3, l2);
                  break;
                } else b(a3, l2);
                l2 = l2.sibling;
              }
              f3.type === ya ? (d3 = Tg2(f3.props.children, a3.mode, h3, f3.key), d3.return = a3, a3 = d3) : (h3 = Rg2(f3.type, f3.key, f3.props, null, a3.mode, h3), h3.ref = Lg2(a3, d3, f3), h3.return = a3, a3 = h3);
            }
            return g2(a3);
          case wa:
            a: {
              for (l2 = f3.key; null !== d3; ) {
                if (d3.key === l2) if (4 === d3.tag && d3.stateNode.containerInfo === f3.containerInfo && d3.stateNode.implementation === f3.implementation) {
                  c(a3, d3.sibling);
                  d3 = e(d3, f3.children || []);
                  d3.return = a3;
                  a3 = d3;
                  break a;
                } else {
                  c(a3, d3);
                  break;
                }
                else b(a3, d3);
                d3 = d3.sibling;
              }
              d3 = Sg2(f3, a3.mode, h3);
              d3.return = a3;
              a3 = d3;
            }
            return g2(a3);
          case Ha2:
            return l2 = f3._init, J2(a3, d3, l2(f3._payload), h3);
        }
        if (eb(f3)) return n(a3, d3, f3, h3);
        if (Ka2(f3)) return t(a3, d3, f3, h3);
        Mg2(a3, f3);
      }
      return "string" === typeof f3 && "" !== f3 || "number" === typeof f3 ? (f3 = "" + f3, null !== d3 && 6 === d3.tag ? (c(a3, d3.sibling), d3 = e(d3, f3), d3.return = a3, a3 = d3) : (c(a3, d3), d3 = Qg2(f3, a3.mode, h3), d3.return = a3, a3 = d3), g2(a3)) : c(a3, d3);
    }
    return J2;
  }
  var Ug2 = Og2(true), Vg2 = Og2(false), Wg2 = Uf2(null), Xg2 = null, Yg2 = null, Zg2 = null;
  function $g2() {
    Zg2 = Yg2 = Xg2 = null;
  }
  function ah2(a2) {
    var b = Wg2.current;
    E2(Wg2);
    a2._currentValue = b;
  }
  function bh2(a2, b, c) {
    for (; null !== a2; ) {
      var d2 = a2.alternate;
      (a2.childLanes & b) !== b ? (a2.childLanes |= b, null !== d2 && (d2.childLanes |= b)) : null !== d2 && (d2.childLanes & b) !== b && (d2.childLanes |= b);
      if (a2 === c) break;
      a2 = a2.return;
    }
  }
  function ch2(a2, b) {
    Xg2 = a2;
    Zg2 = Yg2 = null;
    a2 = a2.dependencies;
    null !== a2 && null !== a2.firstContext && (0 !== (a2.lanes & b) && (dh2 = true), a2.firstContext = null);
  }
  function eh2(a2) {
    var b = a2._currentValue;
    if (Zg2 !== a2) if (a2 = { context: a2, memoizedValue: b, next: null }, null === Yg2) {
      if (null === Xg2) throw Error(p2(308));
      Yg2 = a2;
      Xg2.dependencies = { lanes: 0, firstContext: a2 };
    } else Yg2 = Yg2.next = a2;
    return b;
  }
  var fh2 = null;
  function gh2(a2) {
    null === fh2 ? fh2 = [a2] : fh2.push(a2);
  }
  function hh2(a2, b, c, d2) {
    var e = b.interleaved;
    null === e ? (c.next = c, gh2(b)) : (c.next = e.next, e.next = c);
    b.interleaved = c;
    return ih2(a2, d2);
  }
  function ih2(a2, b) {
    a2.lanes |= b;
    var c = a2.alternate;
    null !== c && (c.lanes |= b);
    c = a2;
    for (a2 = a2.return; null !== a2; ) a2.childLanes |= b, c = a2.alternate, null !== c && (c.childLanes |= b), c = a2, a2 = a2.return;
    return 3 === c.tag ? c.stateNode : null;
  }
  var jh = false;
  function kh(a2) {
    a2.updateQueue = { baseState: a2.memoizedState, firstBaseUpdate: null, lastBaseUpdate: null, shared: { pending: null, interleaved: null, lanes: 0 }, effects: null };
  }
  function lh2(a2, b) {
    a2 = a2.updateQueue;
    b.updateQueue === a2 && (b.updateQueue = { baseState: a2.baseState, firstBaseUpdate: a2.firstBaseUpdate, lastBaseUpdate: a2.lastBaseUpdate, shared: a2.shared, effects: a2.effects });
  }
  function mh2(a2, b) {
    return { eventTime: a2, lane: b, tag: 0, payload: null, callback: null, next: null };
  }
  function nh2(a2, b, c) {
    var d2 = a2.updateQueue;
    if (null === d2) return null;
    d2 = d2.shared;
    if (0 !== (K2 & 2)) {
      var e = d2.pending;
      null === e ? b.next = b : (b.next = e.next, e.next = b);
      d2.pending = b;
      return ih2(a2, c);
    }
    e = d2.interleaved;
    null === e ? (b.next = b, gh2(d2)) : (b.next = e.next, e.next = b);
    d2.interleaved = b;
    return ih2(a2, c);
  }
  function oh2(a2, b, c) {
    b = b.updateQueue;
    if (null !== b && (b = b.shared, 0 !== (c & 4194240))) {
      var d2 = b.lanes;
      d2 &= a2.pendingLanes;
      c |= d2;
      b.lanes = c;
      Cc2(a2, c);
    }
  }
  function ph2(a2, b) {
    var c = a2.updateQueue, d2 = a2.alternate;
    if (null !== d2 && (d2 = d2.updateQueue, c === d2)) {
      var e = null, f2 = null;
      c = c.firstBaseUpdate;
      if (null !== c) {
        do {
          var g2 = { eventTime: c.eventTime, lane: c.lane, tag: c.tag, payload: c.payload, callback: c.callback, next: null };
          null === f2 ? e = f2 = g2 : f2 = f2.next = g2;
          c = c.next;
        } while (null !== c);
        null === f2 ? e = f2 = b : f2 = f2.next = b;
      } else e = f2 = b;
      c = { baseState: d2.baseState, firstBaseUpdate: e, lastBaseUpdate: f2, shared: d2.shared, effects: d2.effects };
      a2.updateQueue = c;
      return;
    }
    a2 = c.lastBaseUpdate;
    null === a2 ? c.firstBaseUpdate = b : a2.next = b;
    c.lastBaseUpdate = b;
  }
  function qh(a2, b, c, d2) {
    var e = a2.updateQueue;
    jh = false;
    var f2 = e.firstBaseUpdate, g2 = e.lastBaseUpdate, h2 = e.shared.pending;
    if (null !== h2) {
      e.shared.pending = null;
      var k2 = h2, l = k2.next;
      k2.next = null;
      null === g2 ? f2 = l : g2.next = l;
      g2 = k2;
      var m2 = a2.alternate;
      null !== m2 && (m2 = m2.updateQueue, h2 = m2.lastBaseUpdate, h2 !== g2 && (null === h2 ? m2.firstBaseUpdate = l : h2.next = l, m2.lastBaseUpdate = k2));
    }
    if (null !== f2) {
      var q2 = e.baseState;
      g2 = 0;
      m2 = l = k2 = null;
      h2 = f2;
      do {
        var r2 = h2.lane, y2 = h2.eventTime;
        if ((d2 & r2) === r2) {
          null !== m2 && (m2 = m2.next = {
            eventTime: y2,
            lane: 0,
            tag: h2.tag,
            payload: h2.payload,
            callback: h2.callback,
            next: null
          });
          a: {
            var n = a2, t = h2;
            r2 = b;
            y2 = c;
            switch (t.tag) {
              case 1:
                n = t.payload;
                if ("function" === typeof n) {
                  q2 = n.call(y2, q2, r2);
                  break a;
                }
                q2 = n;
                break a;
              case 3:
                n.flags = n.flags & -65537 | 128;
              case 0:
                n = t.payload;
                r2 = "function" === typeof n ? n.call(y2, q2, r2) : n;
                if (null === r2 || void 0 === r2) break a;
                q2 = A2({}, q2, r2);
                break a;
              case 2:
                jh = true;
            }
          }
          null !== h2.callback && 0 !== h2.lane && (a2.flags |= 64, r2 = e.effects, null === r2 ? e.effects = [h2] : r2.push(h2));
        } else y2 = { eventTime: y2, lane: r2, tag: h2.tag, payload: h2.payload, callback: h2.callback, next: null }, null === m2 ? (l = m2 = y2, k2 = q2) : m2 = m2.next = y2, g2 |= r2;
        h2 = h2.next;
        if (null === h2) if (h2 = e.shared.pending, null === h2) break;
        else r2 = h2, h2 = r2.next, r2.next = null, e.lastBaseUpdate = r2, e.shared.pending = null;
      } while (1);
      null === m2 && (k2 = q2);
      e.baseState = k2;
      e.firstBaseUpdate = l;
      e.lastBaseUpdate = m2;
      b = e.shared.interleaved;
      if (null !== b) {
        e = b;
        do
          g2 |= e.lane, e = e.next;
        while (e !== b);
      } else null === f2 && (e.shared.lanes = 0);
      rh2 |= g2;
      a2.lanes = g2;
      a2.memoizedState = q2;
    }
  }
  function sh2(a2, b, c) {
    a2 = b.effects;
    b.effects = null;
    if (null !== a2) for (b = 0; b < a2.length; b++) {
      var d2 = a2[b], e = d2.callback;
      if (null !== e) {
        d2.callback = null;
        d2 = c;
        if ("function" !== typeof e) throw Error(p2(191, e));
        e.call(d2);
      }
    }
  }
  var th2 = {}, uh2 = Uf2(th2), vh2 = Uf2(th2), wh = Uf2(th2);
  function xh2(a2) {
    if (a2 === th2) throw Error(p2(174));
    return a2;
  }
  function yh2(a2, b) {
    G2(wh, b);
    G2(vh2, a2);
    G2(uh2, th2);
    a2 = b.nodeType;
    switch (a2) {
      case 9:
      case 11:
        b = (b = b.documentElement) ? b.namespaceURI : lb(null, "");
        break;
      default:
        a2 = 8 === a2 ? b.parentNode : b, b = a2.namespaceURI || null, a2 = a2.tagName, b = lb(b, a2);
    }
    E2(uh2);
    G2(uh2, b);
  }
  function zh2() {
    E2(uh2);
    E2(vh2);
    E2(wh);
  }
  function Ah(a2) {
    xh2(wh.current);
    var b = xh2(uh2.current);
    var c = lb(b, a2.type);
    b !== c && (G2(vh2, a2), G2(uh2, c));
  }
  function Bh(a2) {
    vh2.current === a2 && (E2(uh2), E2(vh2));
  }
  var L2 = Uf2(0);
  function Ch(a2) {
    for (var b = a2; null !== b; ) {
      if (13 === b.tag) {
        var c = b.memoizedState;
        if (null !== c && (c = c.dehydrated, null === c || "$?" === c.data || "$!" === c.data)) return b;
      } else if (19 === b.tag && void 0 !== b.memoizedProps.revealOrder) {
        if (0 !== (b.flags & 128)) return b;
      } else if (null !== b.child) {
        b.child.return = b;
        b = b.child;
        continue;
      }
      if (b === a2) break;
      for (; null === b.sibling; ) {
        if (null === b.return || b.return === a2) return null;
        b = b.return;
      }
      b.sibling.return = b.return;
      b = b.sibling;
    }
    return null;
  }
  var Dh = [];
  function Eh2() {
    for (var a2 = 0; a2 < Dh.length; a2++) Dh[a2]._workInProgressVersionPrimary = null;
    Dh.length = 0;
  }
  var Fh = ua2.ReactCurrentDispatcher, Gh = ua2.ReactCurrentBatchConfig, Hh = 0, M2 = null, N2 = null, O = null, Ih2 = false, Jh = false, Kh = 0, Lh = 0;
  function P2() {
    throw Error(p2(321));
  }
  function Mh(a2, b) {
    if (null === b) return false;
    for (var c = 0; c < b.length && c < a2.length; c++) if (!He2(a2[c], b[c])) return false;
    return true;
  }
  function Nh(a2, b, c, d2, e, f2) {
    Hh = f2;
    M2 = b;
    b.memoizedState = null;
    b.updateQueue = null;
    b.lanes = 0;
    Fh.current = null === a2 || null === a2.memoizedState ? Oh2 : Ph;
    a2 = c(d2, e);
    if (Jh) {
      f2 = 0;
      do {
        Jh = false;
        Kh = 0;
        if (25 <= f2) throw Error(p2(301));
        f2 += 1;
        O = N2 = null;
        b.updateQueue = null;
        Fh.current = Qh;
        a2 = c(d2, e);
      } while (Jh);
    }
    Fh.current = Rh;
    b = null !== N2 && null !== N2.next;
    Hh = 0;
    O = N2 = M2 = null;
    Ih2 = false;
    if (b) throw Error(p2(300));
    return a2;
  }
  function Sh2() {
    var a2 = 0 !== Kh;
    Kh = 0;
    return a2;
  }
  function Th2() {
    var a2 = { memoizedState: null, baseState: null, baseQueue: null, queue: null, next: null };
    null === O ? M2.memoizedState = O = a2 : O = O.next = a2;
    return O;
  }
  function Uh2() {
    if (null === N2) {
      var a2 = M2.alternate;
      a2 = null !== a2 ? a2.memoizedState : null;
    } else a2 = N2.next;
    var b = null === O ? M2.memoizedState : O.next;
    if (null !== b) O = b, N2 = a2;
    else {
      if (null === a2) throw Error(p2(310));
      N2 = a2;
      a2 = { memoizedState: N2.memoizedState, baseState: N2.baseState, baseQueue: N2.baseQueue, queue: N2.queue, next: null };
      null === O ? M2.memoizedState = O = a2 : O = O.next = a2;
    }
    return O;
  }
  function Vh(a2, b) {
    return "function" === typeof b ? b(a2) : b;
  }
  function Wh(a2) {
    var b = Uh2(), c = b.queue;
    if (null === c) throw Error(p2(311));
    c.lastRenderedReducer = a2;
    var d2 = N2, e = d2.baseQueue, f2 = c.pending;
    if (null !== f2) {
      if (null !== e) {
        var g2 = e.next;
        e.next = f2.next;
        f2.next = g2;
      }
      d2.baseQueue = e = f2;
      c.pending = null;
    }
    if (null !== e) {
      f2 = e.next;
      d2 = d2.baseState;
      var h2 = g2 = null, k2 = null, l = f2;
      do {
        var m2 = l.lane;
        if ((Hh & m2) === m2) null !== k2 && (k2 = k2.next = { lane: 0, action: l.action, hasEagerState: l.hasEagerState, eagerState: l.eagerState, next: null }), d2 = l.hasEagerState ? l.eagerState : a2(d2, l.action);
        else {
          var q2 = {
            lane: m2,
            action: l.action,
            hasEagerState: l.hasEagerState,
            eagerState: l.eagerState,
            next: null
          };
          null === k2 ? (h2 = k2 = q2, g2 = d2) : k2 = k2.next = q2;
          M2.lanes |= m2;
          rh2 |= m2;
        }
        l = l.next;
      } while (null !== l && l !== f2);
      null === k2 ? g2 = d2 : k2.next = h2;
      He2(d2, b.memoizedState) || (dh2 = true);
      b.memoizedState = d2;
      b.baseState = g2;
      b.baseQueue = k2;
      c.lastRenderedState = d2;
    }
    a2 = c.interleaved;
    if (null !== a2) {
      e = a2;
      do
        f2 = e.lane, M2.lanes |= f2, rh2 |= f2, e = e.next;
      while (e !== a2);
    } else null === e && (c.lanes = 0);
    return [b.memoizedState, c.dispatch];
  }
  function Xh(a2) {
    var b = Uh2(), c = b.queue;
    if (null === c) throw Error(p2(311));
    c.lastRenderedReducer = a2;
    var d2 = c.dispatch, e = c.pending, f2 = b.memoizedState;
    if (null !== e) {
      c.pending = null;
      var g2 = e = e.next;
      do
        f2 = a2(f2, g2.action), g2 = g2.next;
      while (g2 !== e);
      He2(f2, b.memoizedState) || (dh2 = true);
      b.memoizedState = f2;
      null === b.baseQueue && (b.baseState = f2);
      c.lastRenderedState = f2;
    }
    return [f2, d2];
  }
  function Yh() {
  }
  function Zh(a2, b) {
    var c = M2, d2 = Uh2(), e = b(), f2 = !He2(d2.memoizedState, e);
    f2 && (d2.memoizedState = e, dh2 = true);
    d2 = d2.queue;
    $h2(ai2.bind(null, c, d2, a2), [a2]);
    if (d2.getSnapshot !== b || f2 || null !== O && O.memoizedState.tag & 1) {
      c.flags |= 2048;
      bi2(9, ci2.bind(null, c, d2, e, b), void 0, null);
      if (null === Q2) throw Error(p2(349));
      0 !== (Hh & 30) || di2(c, b, e);
    }
    return e;
  }
  function di2(a2, b, c) {
    a2.flags |= 16384;
    a2 = { getSnapshot: b, value: c };
    b = M2.updateQueue;
    null === b ? (b = { lastEffect: null, stores: null }, M2.updateQueue = b, b.stores = [a2]) : (c = b.stores, null === c ? b.stores = [a2] : c.push(a2));
  }
  function ci2(a2, b, c, d2) {
    b.value = c;
    b.getSnapshot = d2;
    ei2(b) && fi2(a2);
  }
  function ai2(a2, b, c) {
    return c(function() {
      ei2(b) && fi2(a2);
    });
  }
  function ei2(a2) {
    var b = a2.getSnapshot;
    a2 = a2.value;
    try {
      var c = b();
      return !He2(a2, c);
    } catch (d2) {
      return true;
    }
  }
  function fi2(a2) {
    var b = ih2(a2, 1);
    null !== b && gi2(b, a2, 1, -1);
  }
  function hi2(a2) {
    var b = Th2();
    "function" === typeof a2 && (a2 = a2());
    b.memoizedState = b.baseState = a2;
    a2 = { pending: null, interleaved: null, lanes: 0, dispatch: null, lastRenderedReducer: Vh, lastRenderedState: a2 };
    b.queue = a2;
    a2 = a2.dispatch = ii2.bind(null, M2, a2);
    return [b.memoizedState, a2];
  }
  function bi2(a2, b, c, d2) {
    a2 = { tag: a2, create: b, destroy: c, deps: d2, next: null };
    b = M2.updateQueue;
    null === b ? (b = { lastEffect: null, stores: null }, M2.updateQueue = b, b.lastEffect = a2.next = a2) : (c = b.lastEffect, null === c ? b.lastEffect = a2.next = a2 : (d2 = c.next, c.next = a2, a2.next = d2, b.lastEffect = a2));
    return a2;
  }
  function ji2() {
    return Uh2().memoizedState;
  }
  function ki2(a2, b, c, d2) {
    var e = Th2();
    M2.flags |= a2;
    e.memoizedState = bi2(1 | b, c, void 0, void 0 === d2 ? null : d2);
  }
  function li2(a2, b, c, d2) {
    var e = Uh2();
    d2 = void 0 === d2 ? null : d2;
    var f2 = void 0;
    if (null !== N2) {
      var g2 = N2.memoizedState;
      f2 = g2.destroy;
      if (null !== d2 && Mh(d2, g2.deps)) {
        e.memoizedState = bi2(b, c, f2, d2);
        return;
      }
    }
    M2.flags |= a2;
    e.memoizedState = bi2(1 | b, c, f2, d2);
  }
  function mi2(a2, b) {
    return ki2(8390656, 8, a2, b);
  }
  function $h2(a2, b) {
    return li2(2048, 8, a2, b);
  }
  function ni2(a2, b) {
    return li2(4, 2, a2, b);
  }
  function oi2(a2, b) {
    return li2(4, 4, a2, b);
  }
  function pi2(a2, b) {
    if ("function" === typeof b) return a2 = a2(), b(a2), function() {
      b(null);
    };
    if (null !== b && void 0 !== b) return a2 = a2(), b.current = a2, function() {
      b.current = null;
    };
  }
  function qi2(a2, b, c) {
    c = null !== c && void 0 !== c ? c.concat([a2]) : null;
    return li2(4, 4, pi2.bind(null, b, a2), c);
  }
  function ri2() {
  }
  function si2(a2, b) {
    var c = Uh2();
    b = void 0 === b ? null : b;
    var d2 = c.memoizedState;
    if (null !== d2 && null !== b && Mh(b, d2[1])) return d2[0];
    c.memoizedState = [a2, b];
    return a2;
  }
  function ti2(a2, b) {
    var c = Uh2();
    b = void 0 === b ? null : b;
    var d2 = c.memoizedState;
    if (null !== d2 && null !== b && Mh(b, d2[1])) return d2[0];
    a2 = a2();
    c.memoizedState = [a2, b];
    return a2;
  }
  function ui2(a2, b, c) {
    if (0 === (Hh & 21)) return a2.baseState && (a2.baseState = false, dh2 = true), a2.memoizedState = c;
    He2(c, b) || (c = yc2(), M2.lanes |= c, rh2 |= c, a2.baseState = true);
    return b;
  }
  function vi2(a2, b) {
    var c = C;
    C = 0 !== c && 4 > c ? c : 4;
    a2(true);
    var d2 = Gh.transition;
    Gh.transition = {};
    try {
      a2(false), b();
    } finally {
      C = c, Gh.transition = d2;
    }
  }
  function wi2() {
    return Uh2().memoizedState;
  }
  function xi2(a2, b, c) {
    var d2 = yi2(a2);
    c = { lane: d2, action: c, hasEagerState: false, eagerState: null, next: null };
    if (zi2(a2)) Ai2(b, c);
    else if (c = hh2(a2, b, c, d2), null !== c) {
      var e = R2();
      gi2(c, a2, d2, e);
      Bi2(c, b, d2);
    }
  }
  function ii2(a2, b, c) {
    var d2 = yi2(a2), e = { lane: d2, action: c, hasEagerState: false, eagerState: null, next: null };
    if (zi2(a2)) Ai2(b, e);
    else {
      var f2 = a2.alternate;
      if (0 === a2.lanes && (null === f2 || 0 === f2.lanes) && (f2 = b.lastRenderedReducer, null !== f2)) try {
        var g2 = b.lastRenderedState, h2 = f2(g2, c);
        e.hasEagerState = true;
        e.eagerState = h2;
        if (He2(h2, g2)) {
          var k2 = b.interleaved;
          null === k2 ? (e.next = e, gh2(b)) : (e.next = k2.next, k2.next = e);
          b.interleaved = e;
          return;
        }
      } catch (l) {
      } finally {
      }
      c = hh2(a2, b, e, d2);
      null !== c && (e = R2(), gi2(c, a2, d2, e), Bi2(c, b, d2));
    }
  }
  function zi2(a2) {
    var b = a2.alternate;
    return a2 === M2 || null !== b && b === M2;
  }
  function Ai2(a2, b) {
    Jh = Ih2 = true;
    var c = a2.pending;
    null === c ? b.next = b : (b.next = c.next, c.next = b);
    a2.pending = b;
  }
  function Bi2(a2, b, c) {
    if (0 !== (c & 4194240)) {
      var d2 = b.lanes;
      d2 &= a2.pendingLanes;
      c |= d2;
      b.lanes = c;
      Cc2(a2, c);
    }
  }
  var Rh = { readContext: eh2, useCallback: P2, useContext: P2, useEffect: P2, useImperativeHandle: P2, useInsertionEffect: P2, useLayoutEffect: P2, useMemo: P2, useReducer: P2, useRef: P2, useState: P2, useDebugValue: P2, useDeferredValue: P2, useTransition: P2, useMutableSource: P2, useSyncExternalStore: P2, useId: P2, unstable_isNewReconciler: false }, Oh2 = { readContext: eh2, useCallback: function(a2, b) {
    Th2().memoizedState = [a2, void 0 === b ? null : b];
    return a2;
  }, useContext: eh2, useEffect: mi2, useImperativeHandle: function(a2, b, c) {
    c = null !== c && void 0 !== c ? c.concat([a2]) : null;
    return ki2(
      4194308,
      4,
      pi2.bind(null, b, a2),
      c
    );
  }, useLayoutEffect: function(a2, b) {
    return ki2(4194308, 4, a2, b);
  }, useInsertionEffect: function(a2, b) {
    return ki2(4, 2, a2, b);
  }, useMemo: function(a2, b) {
    var c = Th2();
    b = void 0 === b ? null : b;
    a2 = a2();
    c.memoizedState = [a2, b];
    return a2;
  }, useReducer: function(a2, b, c) {
    var d2 = Th2();
    b = void 0 !== c ? c(b) : b;
    d2.memoizedState = d2.baseState = b;
    a2 = { pending: null, interleaved: null, lanes: 0, dispatch: null, lastRenderedReducer: a2, lastRenderedState: b };
    d2.queue = a2;
    a2 = a2.dispatch = xi2.bind(null, M2, a2);
    return [d2.memoizedState, a2];
  }, useRef: function(a2) {
    var b = Th2();
    a2 = { current: a2 };
    return b.memoizedState = a2;
  }, useState: hi2, useDebugValue: ri2, useDeferredValue: function(a2) {
    return Th2().memoizedState = a2;
  }, useTransition: function() {
    var a2 = hi2(false), b = a2[0];
    a2 = vi2.bind(null, a2[1]);
    Th2().memoizedState = a2;
    return [b, a2];
  }, useMutableSource: function() {
  }, useSyncExternalStore: function(a2, b, c) {
    var d2 = M2, e = Th2();
    if (I2) {
      if (void 0 === c) throw Error(p2(407));
      c = c();
    } else {
      c = b();
      if (null === Q2) throw Error(p2(349));
      0 !== (Hh & 30) || di2(d2, b, c);
    }
    e.memoizedState = c;
    var f2 = { value: c, getSnapshot: b };
    e.queue = f2;
    mi2(ai2.bind(
      null,
      d2,
      f2,
      a2
    ), [a2]);
    d2.flags |= 2048;
    bi2(9, ci2.bind(null, d2, f2, c, b), void 0, null);
    return c;
  }, useId: function() {
    var a2 = Th2(), b = Q2.identifierPrefix;
    if (I2) {
      var c = sg2;
      var d2 = rg2;
      c = (d2 & ~(1 << 32 - oc2(d2) - 1)).toString(32) + c;
      b = ":" + b + "R" + c;
      c = Kh++;
      0 < c && (b += "H" + c.toString(32));
      b += ":";
    } else c = Lh++, b = ":" + b + "r" + c.toString(32) + ":";
    return a2.memoizedState = b;
  }, unstable_isNewReconciler: false }, Ph = {
    readContext: eh2,
    useCallback: si2,
    useContext: eh2,
    useEffect: $h2,
    useImperativeHandle: qi2,
    useInsertionEffect: ni2,
    useLayoutEffect: oi2,
    useMemo: ti2,
    useReducer: Wh,
    useRef: ji2,
    useState: function() {
      return Wh(Vh);
    },
    useDebugValue: ri2,
    useDeferredValue: function(a2) {
      var b = Uh2();
      return ui2(b, N2.memoizedState, a2);
    },
    useTransition: function() {
      var a2 = Wh(Vh)[0], b = Uh2().memoizedState;
      return [a2, b];
    },
    useMutableSource: Yh,
    useSyncExternalStore: Zh,
    useId: wi2,
    unstable_isNewReconciler: false
  }, Qh = { readContext: eh2, useCallback: si2, useContext: eh2, useEffect: $h2, useImperativeHandle: qi2, useInsertionEffect: ni2, useLayoutEffect: oi2, useMemo: ti2, useReducer: Xh, useRef: ji2, useState: function() {
    return Xh(Vh);
  }, useDebugValue: ri2, useDeferredValue: function(a2) {
    var b = Uh2();
    return null === N2 ? b.memoizedState = a2 : ui2(b, N2.memoizedState, a2);
  }, useTransition: function() {
    var a2 = Xh(Vh)[0], b = Uh2().memoizedState;
    return [a2, b];
  }, useMutableSource: Yh, useSyncExternalStore: Zh, useId: wi2, unstable_isNewReconciler: false };
  function Ci2(a2, b) {
    if (a2 && a2.defaultProps) {
      b = A2({}, b);
      a2 = a2.defaultProps;
      for (var c in a2) void 0 === b[c] && (b[c] = a2[c]);
      return b;
    }
    return b;
  }
  function Di2(a2, b, c, d2) {
    b = a2.memoizedState;
    c = c(d2, b);
    c = null === c || void 0 === c ? b : A2({}, b, c);
    a2.memoizedState = c;
    0 === a2.lanes && (a2.updateQueue.baseState = c);
  }
  var Ei2 = { isMounted: function(a2) {
    return (a2 = a2._reactInternals) ? Vb(a2) === a2 : false;
  }, enqueueSetState: function(a2, b, c) {
    a2 = a2._reactInternals;
    var d2 = R2(), e = yi2(a2), f2 = mh2(d2, e);
    f2.payload = b;
    void 0 !== c && null !== c && (f2.callback = c);
    b = nh2(a2, f2, e);
    null !== b && (gi2(b, a2, e, d2), oh2(b, a2, e));
  }, enqueueReplaceState: function(a2, b, c) {
    a2 = a2._reactInternals;
    var d2 = R2(), e = yi2(a2), f2 = mh2(d2, e);
    f2.tag = 1;
    f2.payload = b;
    void 0 !== c && null !== c && (f2.callback = c);
    b = nh2(a2, f2, e);
    null !== b && (gi2(b, a2, e, d2), oh2(b, a2, e));
  }, enqueueForceUpdate: function(a2, b) {
    a2 = a2._reactInternals;
    var c = R2(), d2 = yi2(a2), e = mh2(c, d2);
    e.tag = 2;
    void 0 !== b && null !== b && (e.callback = b);
    b = nh2(a2, e, d2);
    null !== b && (gi2(b, a2, d2, c), oh2(b, a2, d2));
  } };
  function Fi2(a2, b, c, d2, e, f2, g2) {
    a2 = a2.stateNode;
    return "function" === typeof a2.shouldComponentUpdate ? a2.shouldComponentUpdate(d2, f2, g2) : b.prototype && b.prototype.isPureReactComponent ? !Ie2(c, d2) || !Ie2(e, f2) : true;
  }
  function Gi2(a2, b, c) {
    var d2 = false, e = Vf2;
    var f2 = b.contextType;
    "object" === typeof f2 && null !== f2 ? f2 = eh2(f2) : (e = Zf2(b) ? Xf2 : H2.current, d2 = b.contextTypes, f2 = (d2 = null !== d2 && void 0 !== d2) ? Yf2(a2, e) : Vf2);
    b = new b(c, f2);
    a2.memoizedState = null !== b.state && void 0 !== b.state ? b.state : null;
    b.updater = Ei2;
    a2.stateNode = b;
    b._reactInternals = a2;
    d2 && (a2 = a2.stateNode, a2.__reactInternalMemoizedUnmaskedChildContext = e, a2.__reactInternalMemoizedMaskedChildContext = f2);
    return b;
  }
  function Hi2(a2, b, c, d2) {
    a2 = b.state;
    "function" === typeof b.componentWillReceiveProps && b.componentWillReceiveProps(c, d2);
    "function" === typeof b.UNSAFE_componentWillReceiveProps && b.UNSAFE_componentWillReceiveProps(c, d2);
    b.state !== a2 && Ei2.enqueueReplaceState(b, b.state, null);
  }
  function Ii2(a2, b, c, d2) {
    var e = a2.stateNode;
    e.props = c;
    e.state = a2.memoizedState;
    e.refs = {};
    kh(a2);
    var f2 = b.contextType;
    "object" === typeof f2 && null !== f2 ? e.context = eh2(f2) : (f2 = Zf2(b) ? Xf2 : H2.current, e.context = Yf2(a2, f2));
    e.state = a2.memoizedState;
    f2 = b.getDerivedStateFromProps;
    "function" === typeof f2 && (Di2(a2, b, f2, c), e.state = a2.memoizedState);
    "function" === typeof b.getDerivedStateFromProps || "function" === typeof e.getSnapshotBeforeUpdate || "function" !== typeof e.UNSAFE_componentWillMount && "function" !== typeof e.componentWillMount || (b = e.state, "function" === typeof e.componentWillMount && e.componentWillMount(), "function" === typeof e.UNSAFE_componentWillMount && e.UNSAFE_componentWillMount(), b !== e.state && Ei2.enqueueReplaceState(e, e.state, null), qh(a2, c, e, d2), e.state = a2.memoizedState);
    "function" === typeof e.componentDidMount && (a2.flags |= 4194308);
  }
  function Ji2(a2, b) {
    try {
      var c = "", d2 = b;
      do
        c += Pa(d2), d2 = d2.return;
      while (d2);
      var e = c;
    } catch (f2) {
      e = "\nError generating stack: " + f2.message + "\n" + f2.stack;
    }
    return { value: a2, source: b, stack: e, digest: null };
  }
  function Ki2(a2, b, c) {
    return { value: a2, source: null, stack: null != c ? c : null, digest: null != b ? b : null };
  }
  function Li2(a2, b) {
    try {
      console.error(b.value);
    } catch (c) {
      setTimeout(function() {
        throw c;
      });
    }
  }
  var Mi2 = "function" === typeof WeakMap ? WeakMap : Map;
  function Ni2(a2, b, c) {
    c = mh2(-1, c);
    c.tag = 3;
    c.payload = { element: null };
    var d2 = b.value;
    c.callback = function() {
      Oi2 || (Oi2 = true, Pi2 = d2);
      Li2(a2, b);
    };
    return c;
  }
  function Qi2(a2, b, c) {
    c = mh2(-1, c);
    c.tag = 3;
    var d2 = a2.type.getDerivedStateFromError;
    if ("function" === typeof d2) {
      var e = b.value;
      c.payload = function() {
        return d2(e);
      };
      c.callback = function() {
        Li2(a2, b);
      };
    }
    var f2 = a2.stateNode;
    null !== f2 && "function" === typeof f2.componentDidCatch && (c.callback = function() {
      Li2(a2, b);
      "function" !== typeof d2 && (null === Ri2 ? Ri2 = /* @__PURE__ */ new Set([this]) : Ri2.add(this));
      var c2 = b.stack;
      this.componentDidCatch(b.value, { componentStack: null !== c2 ? c2 : "" });
    });
    return c;
  }
  function Si2(a2, b, c) {
    var d2 = a2.pingCache;
    if (null === d2) {
      d2 = a2.pingCache = new Mi2();
      var e = /* @__PURE__ */ new Set();
      d2.set(b, e);
    } else e = d2.get(b), void 0 === e && (e = /* @__PURE__ */ new Set(), d2.set(b, e));
    e.has(c) || (e.add(c), a2 = Ti2.bind(null, a2, b, c), b.then(a2, a2));
  }
  function Ui2(a2) {
    do {
      var b;
      if (b = 13 === a2.tag) b = a2.memoizedState, b = null !== b ? null !== b.dehydrated ? true : false : true;
      if (b) return a2;
      a2 = a2.return;
    } while (null !== a2);
    return null;
  }
  function Vi2(a2, b, c, d2, e) {
    if (0 === (a2.mode & 1)) return a2 === b ? a2.flags |= 65536 : (a2.flags |= 128, c.flags |= 131072, c.flags &= -52805, 1 === c.tag && (null === c.alternate ? c.tag = 17 : (b = mh2(-1, 1), b.tag = 2, nh2(c, b, 1))), c.lanes |= 1), a2;
    a2.flags |= 65536;
    a2.lanes = e;
    return a2;
  }
  var Wi2 = ua2.ReactCurrentOwner, dh2 = false;
  function Xi2(a2, b, c, d2) {
    b.child = null === a2 ? Vg2(b, null, c, d2) : Ug2(b, a2.child, c, d2);
  }
  function Yi2(a2, b, c, d2, e) {
    c = c.render;
    var f2 = b.ref;
    ch2(b, e);
    d2 = Nh(a2, b, c, d2, f2, e);
    c = Sh2();
    if (null !== a2 && !dh2) return b.updateQueue = a2.updateQueue, b.flags &= -2053, a2.lanes &= ~e, Zi2(a2, b, e);
    I2 && c && vg3(b);
    b.flags |= 1;
    Xi2(a2, b, d2, e);
    return b.child;
  }
  function $i2(a2, b, c, d2, e) {
    if (null === a2) {
      var f2 = c.type;
      if ("function" === typeof f2 && !aj(f2) && void 0 === f2.defaultProps && null === c.compare && void 0 === c.defaultProps) return b.tag = 15, b.type = f2, bj(a2, b, f2, d2, e);
      a2 = Rg2(c.type, null, d2, b, b.mode, e);
      a2.ref = b.ref;
      a2.return = b;
      return b.child = a2;
    }
    f2 = a2.child;
    if (0 === (a2.lanes & e)) {
      var g2 = f2.memoizedProps;
      c = c.compare;
      c = null !== c ? c : Ie2;
      if (c(g2, d2) && a2.ref === b.ref) return Zi2(a2, b, e);
    }
    b.flags |= 1;
    a2 = Pg2(f2, d2);
    a2.ref = b.ref;
    a2.return = b;
    return b.child = a2;
  }
  function bj(a2, b, c, d2, e) {
    if (null !== a2) {
      var f2 = a2.memoizedProps;
      if (Ie2(f2, d2) && a2.ref === b.ref) if (dh2 = false, b.pendingProps = d2 = f2, 0 !== (a2.lanes & e)) 0 !== (a2.flags & 131072) && (dh2 = true);
      else return b.lanes = a2.lanes, Zi2(a2, b, e);
    }
    return cj(a2, b, c, d2, e);
  }
  function dj(a2, b, c) {
    var d2 = b.pendingProps, e = d2.children, f2 = null !== a2 ? a2.memoizedState : null;
    if ("hidden" === d2.mode) if (0 === (b.mode & 1)) b.memoizedState = { baseLanes: 0, cachePool: null, transitions: null }, G2(ej, fj), fj |= c;
    else {
      if (0 === (c & 1073741824)) return a2 = null !== f2 ? f2.baseLanes | c : c, b.lanes = b.childLanes = 1073741824, b.memoizedState = { baseLanes: a2, cachePool: null, transitions: null }, b.updateQueue = null, G2(ej, fj), fj |= a2, null;
      b.memoizedState = { baseLanes: 0, cachePool: null, transitions: null };
      d2 = null !== f2 ? f2.baseLanes : c;
      G2(ej, fj);
      fj |= d2;
    }
    else null !== f2 ? (d2 = f2.baseLanes | c, b.memoizedState = null) : d2 = c, G2(ej, fj), fj |= d2;
    Xi2(a2, b, e, c);
    return b.child;
  }
  function gj(a2, b) {
    var c = b.ref;
    if (null === a2 && null !== c || null !== a2 && a2.ref !== c) b.flags |= 512, b.flags |= 2097152;
  }
  function cj(a2, b, c, d2, e) {
    var f2 = Zf2(c) ? Xf2 : H2.current;
    f2 = Yf2(b, f2);
    ch2(b, e);
    c = Nh(a2, b, c, d2, f2, e);
    d2 = Sh2();
    if (null !== a2 && !dh2) return b.updateQueue = a2.updateQueue, b.flags &= -2053, a2.lanes &= ~e, Zi2(a2, b, e);
    I2 && d2 && vg3(b);
    b.flags |= 1;
    Xi2(a2, b, c, e);
    return b.child;
  }
  function hj(a2, b, c, d2, e) {
    if (Zf2(c)) {
      var f2 = true;
      cg2(b);
    } else f2 = false;
    ch2(b, e);
    if (null === b.stateNode) ij(a2, b), Gi2(b, c, d2), Ii2(b, c, d2, e), d2 = true;
    else if (null === a2) {
      var g2 = b.stateNode, h2 = b.memoizedProps;
      g2.props = h2;
      var k2 = g2.context, l = c.contextType;
      "object" === typeof l && null !== l ? l = eh2(l) : (l = Zf2(c) ? Xf2 : H2.current, l = Yf2(b, l));
      var m2 = c.getDerivedStateFromProps, q2 = "function" === typeof m2 || "function" === typeof g2.getSnapshotBeforeUpdate;
      q2 || "function" !== typeof g2.UNSAFE_componentWillReceiveProps && "function" !== typeof g2.componentWillReceiveProps || (h2 !== d2 || k2 !== l) && Hi2(b, g2, d2, l);
      jh = false;
      var r2 = b.memoizedState;
      g2.state = r2;
      qh(b, d2, g2, e);
      k2 = b.memoizedState;
      h2 !== d2 || r2 !== k2 || Wf2.current || jh ? ("function" === typeof m2 && (Di2(b, c, m2, d2), k2 = b.memoizedState), (h2 = jh || Fi2(b, c, h2, d2, r2, k2, l)) ? (q2 || "function" !== typeof g2.UNSAFE_componentWillMount && "function" !== typeof g2.componentWillMount || ("function" === typeof g2.componentWillMount && g2.componentWillMount(), "function" === typeof g2.UNSAFE_componentWillMount && g2.UNSAFE_componentWillMount()), "function" === typeof g2.componentDidMount && (b.flags |= 4194308)) : ("function" === typeof g2.componentDidMount && (b.flags |= 4194308), b.memoizedProps = d2, b.memoizedState = k2), g2.props = d2, g2.state = k2, g2.context = l, d2 = h2) : ("function" === typeof g2.componentDidMount && (b.flags |= 4194308), d2 = false);
    } else {
      g2 = b.stateNode;
      lh2(a2, b);
      h2 = b.memoizedProps;
      l = b.type === b.elementType ? h2 : Ci2(b.type, h2);
      g2.props = l;
      q2 = b.pendingProps;
      r2 = g2.context;
      k2 = c.contextType;
      "object" === typeof k2 && null !== k2 ? k2 = eh2(k2) : (k2 = Zf2(c) ? Xf2 : H2.current, k2 = Yf2(b, k2));
      var y2 = c.getDerivedStateFromProps;
      (m2 = "function" === typeof y2 || "function" === typeof g2.getSnapshotBeforeUpdate) || "function" !== typeof g2.UNSAFE_componentWillReceiveProps && "function" !== typeof g2.componentWillReceiveProps || (h2 !== q2 || r2 !== k2) && Hi2(b, g2, d2, k2);
      jh = false;
      r2 = b.memoizedState;
      g2.state = r2;
      qh(b, d2, g2, e);
      var n = b.memoizedState;
      h2 !== q2 || r2 !== n || Wf2.current || jh ? ("function" === typeof y2 && (Di2(b, c, y2, d2), n = b.memoizedState), (l = jh || Fi2(b, c, l, d2, r2, n, k2) || false) ? (m2 || "function" !== typeof g2.UNSAFE_componentWillUpdate && "function" !== typeof g2.componentWillUpdate || ("function" === typeof g2.componentWillUpdate && g2.componentWillUpdate(d2, n, k2), "function" === typeof g2.UNSAFE_componentWillUpdate && g2.UNSAFE_componentWillUpdate(d2, n, k2)), "function" === typeof g2.componentDidUpdate && (b.flags |= 4), "function" === typeof g2.getSnapshotBeforeUpdate && (b.flags |= 1024)) : ("function" !== typeof g2.componentDidUpdate || h2 === a2.memoizedProps && r2 === a2.memoizedState || (b.flags |= 4), "function" !== typeof g2.getSnapshotBeforeUpdate || h2 === a2.memoizedProps && r2 === a2.memoizedState || (b.flags |= 1024), b.memoizedProps = d2, b.memoizedState = n), g2.props = d2, g2.state = n, g2.context = k2, d2 = l) : ("function" !== typeof g2.componentDidUpdate || h2 === a2.memoizedProps && r2 === a2.memoizedState || (b.flags |= 4), "function" !== typeof g2.getSnapshotBeforeUpdate || h2 === a2.memoizedProps && r2 === a2.memoizedState || (b.flags |= 1024), d2 = false);
    }
    return jj(a2, b, c, d2, f2, e);
  }
  function jj(a2, b, c, d2, e, f2) {
    gj(a2, b);
    var g2 = 0 !== (b.flags & 128);
    if (!d2 && !g2) return e && dg2(b, c, false), Zi2(a2, b, f2);
    d2 = b.stateNode;
    Wi2.current = b;
    var h2 = g2 && "function" !== typeof c.getDerivedStateFromError ? null : d2.render();
    b.flags |= 1;
    null !== a2 && g2 ? (b.child = Ug2(b, a2.child, null, f2), b.child = Ug2(b, null, h2, f2)) : Xi2(a2, b, h2, f2);
    b.memoizedState = d2.state;
    e && dg2(b, c, true);
    return b.child;
  }
  function kj(a2) {
    var b = a2.stateNode;
    b.pendingContext ? ag2(a2, b.pendingContext, b.pendingContext !== b.context) : b.context && ag2(a2, b.context, false);
    yh2(a2, b.containerInfo);
  }
  function lj(a2, b, c, d2, e) {
    Ig2();
    Jg2(e);
    b.flags |= 256;
    Xi2(a2, b, c, d2);
    return b.child;
  }
  var mj = { dehydrated: null, treeContext: null, retryLane: 0 };
  function nj(a2) {
    return { baseLanes: a2, cachePool: null, transitions: null };
  }
  function oj(a2, b, c) {
    var d2 = b.pendingProps, e = L2.current, f2 = false, g2 = 0 !== (b.flags & 128), h2;
    (h2 = g2) || (h2 = null !== a2 && null === a2.memoizedState ? false : 0 !== (e & 2));
    if (h2) f2 = true, b.flags &= -129;
    else if (null === a2 || null !== a2.memoizedState) e |= 1;
    G2(L2, e & 1);
    if (null === a2) {
      Eg2(b);
      a2 = b.memoizedState;
      if (null !== a2 && (a2 = a2.dehydrated, null !== a2)) return 0 === (b.mode & 1) ? b.lanes = 1 : "$!" === a2.data ? b.lanes = 8 : b.lanes = 1073741824, null;
      g2 = d2.children;
      a2 = d2.fallback;
      return f2 ? (d2 = b.mode, f2 = b.child, g2 = { mode: "hidden", children: g2 }, 0 === (d2 & 1) && null !== f2 ? (f2.childLanes = 0, f2.pendingProps = g2) : f2 = pj(g2, d2, 0, null), a2 = Tg2(a2, d2, c, null), f2.return = b, a2.return = b, f2.sibling = a2, b.child = f2, b.child.memoizedState = nj(c), b.memoizedState = mj, a2) : qj(b, g2);
    }
    e = a2.memoizedState;
    if (null !== e && (h2 = e.dehydrated, null !== h2)) return rj(a2, b, g2, d2, h2, e, c);
    if (f2) {
      f2 = d2.fallback;
      g2 = b.mode;
      e = a2.child;
      h2 = e.sibling;
      var k2 = { mode: "hidden", children: d2.children };
      0 === (g2 & 1) && b.child !== e ? (d2 = b.child, d2.childLanes = 0, d2.pendingProps = k2, b.deletions = null) : (d2 = Pg2(e, k2), d2.subtreeFlags = e.subtreeFlags & 14680064);
      null !== h2 ? f2 = Pg2(h2, f2) : (f2 = Tg2(f2, g2, c, null), f2.flags |= 2);
      f2.return = b;
      d2.return = b;
      d2.sibling = f2;
      b.child = d2;
      d2 = f2;
      f2 = b.child;
      g2 = a2.child.memoizedState;
      g2 = null === g2 ? nj(c) : { baseLanes: g2.baseLanes | c, cachePool: null, transitions: g2.transitions };
      f2.memoizedState = g2;
      f2.childLanes = a2.childLanes & ~c;
      b.memoizedState = mj;
      return d2;
    }
    f2 = a2.child;
    a2 = f2.sibling;
    d2 = Pg2(f2, { mode: "visible", children: d2.children });
    0 === (b.mode & 1) && (d2.lanes = c);
    d2.return = b;
    d2.sibling = null;
    null !== a2 && (c = b.deletions, null === c ? (b.deletions = [a2], b.flags |= 16) : c.push(a2));
    b.child = d2;
    b.memoizedState = null;
    return d2;
  }
  function qj(a2, b) {
    b = pj({ mode: "visible", children: b }, a2.mode, 0, null);
    b.return = a2;
    return a2.child = b;
  }
  function sj(a2, b, c, d2) {
    null !== d2 && Jg2(d2);
    Ug2(b, a2.child, null, c);
    a2 = qj(b, b.pendingProps.children);
    a2.flags |= 2;
    b.memoizedState = null;
    return a2;
  }
  function rj(a2, b, c, d2, e, f2, g2) {
    if (c) {
      if (b.flags & 256) return b.flags &= -257, d2 = Ki2(Error(p2(422))), sj(a2, b, g2, d2);
      if (null !== b.memoizedState) return b.child = a2.child, b.flags |= 128, null;
      f2 = d2.fallback;
      e = b.mode;
      d2 = pj({ mode: "visible", children: d2.children }, e, 0, null);
      f2 = Tg2(f2, e, g2, null);
      f2.flags |= 2;
      d2.return = b;
      f2.return = b;
      d2.sibling = f2;
      b.child = d2;
      0 !== (b.mode & 1) && Ug2(b, a2.child, null, g2);
      b.child.memoizedState = nj(g2);
      b.memoizedState = mj;
      return f2;
    }
    if (0 === (b.mode & 1)) return sj(a2, b, g2, null);
    if ("$!" === e.data) {
      d2 = e.nextSibling && e.nextSibling.dataset;
      if (d2) var h2 = d2.dgst;
      d2 = h2;
      f2 = Error(p2(419));
      d2 = Ki2(f2, d2, void 0);
      return sj(a2, b, g2, d2);
    }
    h2 = 0 !== (g2 & a2.childLanes);
    if (dh2 || h2) {
      d2 = Q2;
      if (null !== d2) {
        switch (g2 & -g2) {
          case 4:
            e = 2;
            break;
          case 16:
            e = 8;
            break;
          case 64:
          case 128:
          case 256:
          case 512:
          case 1024:
          case 2048:
          case 4096:
          case 8192:
          case 16384:
          case 32768:
          case 65536:
          case 131072:
          case 262144:
          case 524288:
          case 1048576:
          case 2097152:
          case 4194304:
          case 8388608:
          case 16777216:
          case 33554432:
          case 67108864:
            e = 32;
            break;
          case 536870912:
            e = 268435456;
            break;
          default:
            e = 0;
        }
        e = 0 !== (e & (d2.suspendedLanes | g2)) ? 0 : e;
        0 !== e && e !== f2.retryLane && (f2.retryLane = e, ih2(a2, e), gi2(d2, a2, e, -1));
      }
      tj();
      d2 = Ki2(Error(p2(421)));
      return sj(a2, b, g2, d2);
    }
    if ("$?" === e.data) return b.flags |= 128, b.child = a2.child, b = uj.bind(null, a2), e._reactRetry = b, null;
    a2 = f2.treeContext;
    yg2 = Lf2(e.nextSibling);
    xg2 = b;
    I2 = true;
    zg2 = null;
    null !== a2 && (og2[pg2++] = rg2, og2[pg2++] = sg2, og2[pg2++] = qg2, rg2 = a2.id, sg2 = a2.overflow, qg2 = b);
    b = qj(b, d2.children);
    b.flags |= 4096;
    return b;
  }
  function vj(a2, b, c) {
    a2.lanes |= b;
    var d2 = a2.alternate;
    null !== d2 && (d2.lanes |= b);
    bh2(a2.return, b, c);
  }
  function wj(a2, b, c, d2, e) {
    var f2 = a2.memoizedState;
    null === f2 ? a2.memoizedState = { isBackwards: b, rendering: null, renderingStartTime: 0, last: d2, tail: c, tailMode: e } : (f2.isBackwards = b, f2.rendering = null, f2.renderingStartTime = 0, f2.last = d2, f2.tail = c, f2.tailMode = e);
  }
  function xj(a2, b, c) {
    var d2 = b.pendingProps, e = d2.revealOrder, f2 = d2.tail;
    Xi2(a2, b, d2.children, c);
    d2 = L2.current;
    if (0 !== (d2 & 2)) d2 = d2 & 1 | 2, b.flags |= 128;
    else {
      if (null !== a2 && 0 !== (a2.flags & 128)) a: for (a2 = b.child; null !== a2; ) {
        if (13 === a2.tag) null !== a2.memoizedState && vj(a2, c, b);
        else if (19 === a2.tag) vj(a2, c, b);
        else if (null !== a2.child) {
          a2.child.return = a2;
          a2 = a2.child;
          continue;
        }
        if (a2 === b) break a;
        for (; null === a2.sibling; ) {
          if (null === a2.return || a2.return === b) break a;
          a2 = a2.return;
        }
        a2.sibling.return = a2.return;
        a2 = a2.sibling;
      }
      d2 &= 1;
    }
    G2(L2, d2);
    if (0 === (b.mode & 1)) b.memoizedState = null;
    else switch (e) {
      case "forwards":
        c = b.child;
        for (e = null; null !== c; ) a2 = c.alternate, null !== a2 && null === Ch(a2) && (e = c), c = c.sibling;
        c = e;
        null === c ? (e = b.child, b.child = null) : (e = c.sibling, c.sibling = null);
        wj(b, false, e, c, f2);
        break;
      case "backwards":
        c = null;
        e = b.child;
        for (b.child = null; null !== e; ) {
          a2 = e.alternate;
          if (null !== a2 && null === Ch(a2)) {
            b.child = e;
            break;
          }
          a2 = e.sibling;
          e.sibling = c;
          c = e;
          e = a2;
        }
        wj(b, true, c, null, f2);
        break;
      case "together":
        wj(b, false, null, null, void 0);
        break;
      default:
        b.memoizedState = null;
    }
    return b.child;
  }
  function ij(a2, b) {
    0 === (b.mode & 1) && null !== a2 && (a2.alternate = null, b.alternate = null, b.flags |= 2);
  }
  function Zi2(a2, b, c) {
    null !== a2 && (b.dependencies = a2.dependencies);
    rh2 |= b.lanes;
    if (0 === (c & b.childLanes)) return null;
    if (null !== a2 && b.child !== a2.child) throw Error(p2(153));
    if (null !== b.child) {
      a2 = b.child;
      c = Pg2(a2, a2.pendingProps);
      b.child = c;
      for (c.return = b; null !== a2.sibling; ) a2 = a2.sibling, c = c.sibling = Pg2(a2, a2.pendingProps), c.return = b;
      c.sibling = null;
    }
    return b.child;
  }
  function yj(a2, b, c) {
    switch (b.tag) {
      case 3:
        kj(b);
        Ig2();
        break;
      case 5:
        Ah(b);
        break;
      case 1:
        Zf2(b.type) && cg2(b);
        break;
      case 4:
        yh2(b, b.stateNode.containerInfo);
        break;
      case 10:
        var d2 = b.type._context, e = b.memoizedProps.value;
        G2(Wg2, d2._currentValue);
        d2._currentValue = e;
        break;
      case 13:
        d2 = b.memoizedState;
        if (null !== d2) {
          if (null !== d2.dehydrated) return G2(L2, L2.current & 1), b.flags |= 128, null;
          if (0 !== (c & b.child.childLanes)) return oj(a2, b, c);
          G2(L2, L2.current & 1);
          a2 = Zi2(a2, b, c);
          return null !== a2 ? a2.sibling : null;
        }
        G2(L2, L2.current & 1);
        break;
      case 19:
        d2 = 0 !== (c & b.childLanes);
        if (0 !== (a2.flags & 128)) {
          if (d2) return xj(a2, b, c);
          b.flags |= 128;
        }
        e = b.memoizedState;
        null !== e && (e.rendering = null, e.tail = null, e.lastEffect = null);
        G2(L2, L2.current);
        if (d2) break;
        else return null;
      case 22:
      case 23:
        return b.lanes = 0, dj(a2, b, c);
    }
    return Zi2(a2, b, c);
  }
  var zj, Aj, Bj, Cj;
  zj = function(a2, b) {
    for (var c = b.child; null !== c; ) {
      if (5 === c.tag || 6 === c.tag) a2.appendChild(c.stateNode);
      else if (4 !== c.tag && null !== c.child) {
        c.child.return = c;
        c = c.child;
        continue;
      }
      if (c === b) break;
      for (; null === c.sibling; ) {
        if (null === c.return || c.return === b) return;
        c = c.return;
      }
      c.sibling.return = c.return;
      c = c.sibling;
    }
  };
  Aj = function() {
  };
  Bj = function(a2, b, c, d2) {
    var e = a2.memoizedProps;
    if (e !== d2) {
      a2 = b.stateNode;
      xh2(uh2.current);
      var f2 = null;
      switch (c) {
        case "input":
          e = Ya2(a2, e);
          d2 = Ya2(a2, d2);
          f2 = [];
          break;
        case "select":
          e = A2({}, e, { value: void 0 });
          d2 = A2({}, d2, { value: void 0 });
          f2 = [];
          break;
        case "textarea":
          e = gb(a2, e);
          d2 = gb(a2, d2);
          f2 = [];
          break;
        default:
          "function" !== typeof e.onClick && "function" === typeof d2.onClick && (a2.onclick = Bf2);
      }
      ub(c, d2);
      var g2;
      c = null;
      for (l in e) if (!d2.hasOwnProperty(l) && e.hasOwnProperty(l) && null != e[l]) if ("style" === l) {
        var h2 = e[l];
        for (g2 in h2) h2.hasOwnProperty(g2) && (c || (c = {}), c[g2] = "");
      } else "dangerouslySetInnerHTML" !== l && "children" !== l && "suppressContentEditableWarning" !== l && "suppressHydrationWarning" !== l && "autoFocus" !== l && (ea2.hasOwnProperty(l) ? f2 || (f2 = []) : (f2 = f2 || []).push(l, null));
      for (l in d2) {
        var k2 = d2[l];
        h2 = null != e ? e[l] : void 0;
        if (d2.hasOwnProperty(l) && k2 !== h2 && (null != k2 || null != h2)) if ("style" === l) if (h2) {
          for (g2 in h2) !h2.hasOwnProperty(g2) || k2 && k2.hasOwnProperty(g2) || (c || (c = {}), c[g2] = "");
          for (g2 in k2) k2.hasOwnProperty(g2) && h2[g2] !== k2[g2] && (c || (c = {}), c[g2] = k2[g2]);
        } else c || (f2 || (f2 = []), f2.push(
          l,
          c
        )), c = k2;
        else "dangerouslySetInnerHTML" === l ? (k2 = k2 ? k2.__html : void 0, h2 = h2 ? h2.__html : void 0, null != k2 && h2 !== k2 && (f2 = f2 || []).push(l, k2)) : "children" === l ? "string" !== typeof k2 && "number" !== typeof k2 || (f2 = f2 || []).push(l, "" + k2) : "suppressContentEditableWarning" !== l && "suppressHydrationWarning" !== l && (ea2.hasOwnProperty(l) ? (null != k2 && "onScroll" === l && D2("scroll", a2), f2 || h2 === k2 || (f2 = [])) : (f2 = f2 || []).push(l, k2));
      }
      c && (f2 = f2 || []).push("style", c);
      var l = f2;
      if (b.updateQueue = l) b.flags |= 4;
    }
  };
  Cj = function(a2, b, c, d2) {
    c !== d2 && (b.flags |= 4);
  };
  function Dj(a2, b) {
    if (!I2) switch (a2.tailMode) {
      case "hidden":
        b = a2.tail;
        for (var c = null; null !== b; ) null !== b.alternate && (c = b), b = b.sibling;
        null === c ? a2.tail = null : c.sibling = null;
        break;
      case "collapsed":
        c = a2.tail;
        for (var d2 = null; null !== c; ) null !== c.alternate && (d2 = c), c = c.sibling;
        null === d2 ? b || null === a2.tail ? a2.tail = null : a2.tail.sibling = null : d2.sibling = null;
    }
  }
  function S2(a2) {
    var b = null !== a2.alternate && a2.alternate.child === a2.child, c = 0, d2 = 0;
    if (b) for (var e = a2.child; null !== e; ) c |= e.lanes | e.childLanes, d2 |= e.subtreeFlags & 14680064, d2 |= e.flags & 14680064, e.return = a2, e = e.sibling;
    else for (e = a2.child; null !== e; ) c |= e.lanes | e.childLanes, d2 |= e.subtreeFlags, d2 |= e.flags, e.return = a2, e = e.sibling;
    a2.subtreeFlags |= d2;
    a2.childLanes = c;
    return b;
  }
  function Ej(a2, b, c) {
    var d2 = b.pendingProps;
    wg2(b);
    switch (b.tag) {
      case 2:
      case 16:
      case 15:
      case 0:
      case 11:
      case 7:
      case 8:
      case 12:
      case 9:
      case 14:
        return S2(b), null;
      case 1:
        return Zf2(b.type) && $f(), S2(b), null;
      case 3:
        d2 = b.stateNode;
        zh2();
        E2(Wf2);
        E2(H2);
        Eh2();
        d2.pendingContext && (d2.context = d2.pendingContext, d2.pendingContext = null);
        if (null === a2 || null === a2.child) Gg2(b) ? b.flags |= 4 : null === a2 || a2.memoizedState.isDehydrated && 0 === (b.flags & 256) || (b.flags |= 1024, null !== zg2 && (Fj(zg2), zg2 = null));
        Aj(a2, b);
        S2(b);
        return null;
      case 5:
        Bh(b);
        var e = xh2(wh.current);
        c = b.type;
        if (null !== a2 && null != b.stateNode) Bj(a2, b, c, d2, e), a2.ref !== b.ref && (b.flags |= 512, b.flags |= 2097152);
        else {
          if (!d2) {
            if (null === b.stateNode) throw Error(p2(166));
            S2(b);
            return null;
          }
          a2 = xh2(uh2.current);
          if (Gg2(b)) {
            d2 = b.stateNode;
            c = b.type;
            var f2 = b.memoizedProps;
            d2[Of2] = b;
            d2[Pf2] = f2;
            a2 = 0 !== (b.mode & 1);
            switch (c) {
              case "dialog":
                D2("cancel", d2);
                D2("close", d2);
                break;
              case "iframe":
              case "object":
              case "embed":
                D2("load", d2);
                break;
              case "video":
              case "audio":
                for (e = 0; e < lf.length; e++) D2(lf[e], d2);
                break;
              case "source":
                D2("error", d2);
                break;
              case "img":
              case "image":
              case "link":
                D2(
                  "error",
                  d2
                );
                D2("load", d2);
                break;
              case "details":
                D2("toggle", d2);
                break;
              case "input":
                Za2(d2, f2);
                D2("invalid", d2);
                break;
              case "select":
                d2._wrapperState = { wasMultiple: !!f2.multiple };
                D2("invalid", d2);
                break;
              case "textarea":
                hb(d2, f2), D2("invalid", d2);
            }
            ub(c, f2);
            e = null;
            for (var g2 in f2) if (f2.hasOwnProperty(g2)) {
              var h2 = f2[g2];
              "children" === g2 ? "string" === typeof h2 ? d2.textContent !== h2 && (true !== f2.suppressHydrationWarning && Af2(d2.textContent, h2, a2), e = ["children", h2]) : "number" === typeof h2 && d2.textContent !== "" + h2 && (true !== f2.suppressHydrationWarning && Af2(
                d2.textContent,
                h2,
                a2
              ), e = ["children", "" + h2]) : ea2.hasOwnProperty(g2) && null != h2 && "onScroll" === g2 && D2("scroll", d2);
            }
            switch (c) {
              case "input":
                Va2(d2);
                db(d2, f2, true);
                break;
              case "textarea":
                Va2(d2);
                jb(d2);
                break;
              case "select":
              case "option":
                break;
              default:
                "function" === typeof f2.onClick && (d2.onclick = Bf2);
            }
            d2 = e;
            b.updateQueue = d2;
            null !== d2 && (b.flags |= 4);
          } else {
            g2 = 9 === e.nodeType ? e : e.ownerDocument;
            "http://www.w3.org/1999/xhtml" === a2 && (a2 = kb(c));
            "http://www.w3.org/1999/xhtml" === a2 ? "script" === c ? (a2 = g2.createElement("div"), a2.innerHTML = "<script><\/script>", a2 = a2.removeChild(a2.firstChild)) : "string" === typeof d2.is ? a2 = g2.createElement(c, { is: d2.is }) : (a2 = g2.createElement(c), "select" === c && (g2 = a2, d2.multiple ? g2.multiple = true : d2.size && (g2.size = d2.size))) : a2 = g2.createElementNS(a2, c);
            a2[Of2] = b;
            a2[Pf2] = d2;
            zj(a2, b, false, false);
            b.stateNode = a2;
            a: {
              g2 = vb(c, d2);
              switch (c) {
                case "dialog":
                  D2("cancel", a2);
                  D2("close", a2);
                  e = d2;
                  break;
                case "iframe":
                case "object":
                case "embed":
                  D2("load", a2);
                  e = d2;
                  break;
                case "video":
                case "audio":
                  for (e = 0; e < lf.length; e++) D2(lf[e], a2);
                  e = d2;
                  break;
                case "source":
                  D2("error", a2);
                  e = d2;
                  break;
                case "img":
                case "image":
                case "link":
                  D2(
                    "error",
                    a2
                  );
                  D2("load", a2);
                  e = d2;
                  break;
                case "details":
                  D2("toggle", a2);
                  e = d2;
                  break;
                case "input":
                  Za2(a2, d2);
                  e = Ya2(a2, d2);
                  D2("invalid", a2);
                  break;
                case "option":
                  e = d2;
                  break;
                case "select":
                  a2._wrapperState = { wasMultiple: !!d2.multiple };
                  e = A2({}, d2, { value: void 0 });
                  D2("invalid", a2);
                  break;
                case "textarea":
                  hb(a2, d2);
                  e = gb(a2, d2);
                  D2("invalid", a2);
                  break;
                default:
                  e = d2;
              }
              ub(c, e);
              h2 = e;
              for (f2 in h2) if (h2.hasOwnProperty(f2)) {
                var k2 = h2[f2];
                "style" === f2 ? sb(a2, k2) : "dangerouslySetInnerHTML" === f2 ? (k2 = k2 ? k2.__html : void 0, null != k2 && nb(a2, k2)) : "children" === f2 ? "string" === typeof k2 ? ("textarea" !== c || "" !== k2) && ob(a2, k2) : "number" === typeof k2 && ob(a2, "" + k2) : "suppressContentEditableWarning" !== f2 && "suppressHydrationWarning" !== f2 && "autoFocus" !== f2 && (ea2.hasOwnProperty(f2) ? null != k2 && "onScroll" === f2 && D2("scroll", a2) : null != k2 && ta2(a2, f2, k2, g2));
              }
              switch (c) {
                case "input":
                  Va2(a2);
                  db(a2, d2, false);
                  break;
                case "textarea":
                  Va2(a2);
                  jb(a2);
                  break;
                case "option":
                  null != d2.value && a2.setAttribute("value", "" + Sa(d2.value));
                  break;
                case "select":
                  a2.multiple = !!d2.multiple;
                  f2 = d2.value;
                  null != f2 ? fb(a2, !!d2.multiple, f2, false) : null != d2.defaultValue && fb(
                    a2,
                    !!d2.multiple,
                    d2.defaultValue,
                    true
                  );
                  break;
                default:
                  "function" === typeof e.onClick && (a2.onclick = Bf2);
              }
              switch (c) {
                case "button":
                case "input":
                case "select":
                case "textarea":
                  d2 = !!d2.autoFocus;
                  break a;
                case "img":
                  d2 = true;
                  break a;
                default:
                  d2 = false;
              }
            }
            d2 && (b.flags |= 4);
          }
          null !== b.ref && (b.flags |= 512, b.flags |= 2097152);
        }
        S2(b);
        return null;
      case 6:
        if (a2 && null != b.stateNode) Cj(a2, b, a2.memoizedProps, d2);
        else {
          if ("string" !== typeof d2 && null === b.stateNode) throw Error(p2(166));
          c = xh2(wh.current);
          xh2(uh2.current);
          if (Gg2(b)) {
            d2 = b.stateNode;
            c = b.memoizedProps;
            d2[Of2] = b;
            if (f2 = d2.nodeValue !== c) {
              if (a2 = xg2, null !== a2) switch (a2.tag) {
                case 3:
                  Af2(d2.nodeValue, c, 0 !== (a2.mode & 1));
                  break;
                case 5:
                  true !== a2.memoizedProps.suppressHydrationWarning && Af2(d2.nodeValue, c, 0 !== (a2.mode & 1));
              }
            }
            f2 && (b.flags |= 4);
          } else d2 = (9 === c.nodeType ? c : c.ownerDocument).createTextNode(d2), d2[Of2] = b, b.stateNode = d2;
        }
        S2(b);
        return null;
      case 13:
        E2(L2);
        d2 = b.memoizedState;
        if (null === a2 || null !== a2.memoizedState && null !== a2.memoizedState.dehydrated) {
          if (I2 && null !== yg2 && 0 !== (b.mode & 1) && 0 === (b.flags & 128)) Hg2(), Ig2(), b.flags |= 98560, f2 = false;
          else if (f2 = Gg2(b), null !== d2 && null !== d2.dehydrated) {
            if (null === a2) {
              if (!f2) throw Error(p2(318));
              f2 = b.memoizedState;
              f2 = null !== f2 ? f2.dehydrated : null;
              if (!f2) throw Error(p2(317));
              f2[Of2] = b;
            } else Ig2(), 0 === (b.flags & 128) && (b.memoizedState = null), b.flags |= 4;
            S2(b);
            f2 = false;
          } else null !== zg2 && (Fj(zg2), zg2 = null), f2 = true;
          if (!f2) return b.flags & 65536 ? b : null;
        }
        if (0 !== (b.flags & 128)) return b.lanes = c, b;
        d2 = null !== d2;
        d2 !== (null !== a2 && null !== a2.memoizedState) && d2 && (b.child.flags |= 8192, 0 !== (b.mode & 1) && (null === a2 || 0 !== (L2.current & 1) ? 0 === T2 && (T2 = 3) : tj()));
        null !== b.updateQueue && (b.flags |= 4);
        S2(b);
        return null;
      case 4:
        return zh2(), Aj(a2, b), null === a2 && sf(b.stateNode.containerInfo), S2(b), null;
      case 10:
        return ah2(b.type._context), S2(b), null;
      case 17:
        return Zf2(b.type) && $f(), S2(b), null;
      case 19:
        E2(L2);
        f2 = b.memoizedState;
        if (null === f2) return S2(b), null;
        d2 = 0 !== (b.flags & 128);
        g2 = f2.rendering;
        if (null === g2) if (d2) Dj(f2, false);
        else {
          if (0 !== T2 || null !== a2 && 0 !== (a2.flags & 128)) for (a2 = b.child; null !== a2; ) {
            g2 = Ch(a2);
            if (null !== g2) {
              b.flags |= 128;
              Dj(f2, false);
              d2 = g2.updateQueue;
              null !== d2 && (b.updateQueue = d2, b.flags |= 4);
              b.subtreeFlags = 0;
              d2 = c;
              for (c = b.child; null !== c; ) f2 = c, a2 = d2, f2.flags &= 14680066, g2 = f2.alternate, null === g2 ? (f2.childLanes = 0, f2.lanes = a2, f2.child = null, f2.subtreeFlags = 0, f2.memoizedProps = null, f2.memoizedState = null, f2.updateQueue = null, f2.dependencies = null, f2.stateNode = null) : (f2.childLanes = g2.childLanes, f2.lanes = g2.lanes, f2.child = g2.child, f2.subtreeFlags = 0, f2.deletions = null, f2.memoizedProps = g2.memoizedProps, f2.memoizedState = g2.memoizedState, f2.updateQueue = g2.updateQueue, f2.type = g2.type, a2 = g2.dependencies, f2.dependencies = null === a2 ? null : { lanes: a2.lanes, firstContext: a2.firstContext }), c = c.sibling;
              G2(L2, L2.current & 1 | 2);
              return b.child;
            }
            a2 = a2.sibling;
          }
          null !== f2.tail && B2() > Gj && (b.flags |= 128, d2 = true, Dj(f2, false), b.lanes = 4194304);
        }
        else {
          if (!d2) if (a2 = Ch(g2), null !== a2) {
            if (b.flags |= 128, d2 = true, c = a2.updateQueue, null !== c && (b.updateQueue = c, b.flags |= 4), Dj(f2, true), null === f2.tail && "hidden" === f2.tailMode && !g2.alternate && !I2) return S2(b), null;
          } else 2 * B2() - f2.renderingStartTime > Gj && 1073741824 !== c && (b.flags |= 128, d2 = true, Dj(f2, false), b.lanes = 4194304);
          f2.isBackwards ? (g2.sibling = b.child, b.child = g2) : (c = f2.last, null !== c ? c.sibling = g2 : b.child = g2, f2.last = g2);
        }
        if (null !== f2.tail) return b = f2.tail, f2.rendering = b, f2.tail = b.sibling, f2.renderingStartTime = B2(), b.sibling = null, c = L2.current, G2(L2, d2 ? c & 1 | 2 : c & 1), b;
        S2(b);
        return null;
      case 22:
      case 23:
        return Hj(), d2 = null !== b.memoizedState, null !== a2 && null !== a2.memoizedState !== d2 && (b.flags |= 8192), d2 && 0 !== (b.mode & 1) ? 0 !== (fj & 1073741824) && (S2(b), b.subtreeFlags & 6 && (b.flags |= 8192)) : S2(b), null;
      case 24:
        return null;
      case 25:
        return null;
    }
    throw Error(p2(156, b.tag));
  }
  function Ij(a2, b) {
    wg2(b);
    switch (b.tag) {
      case 1:
        return Zf2(b.type) && $f(), a2 = b.flags, a2 & 65536 ? (b.flags = a2 & -65537 | 128, b) : null;
      case 3:
        return zh2(), E2(Wf2), E2(H2), Eh2(), a2 = b.flags, 0 !== (a2 & 65536) && 0 === (a2 & 128) ? (b.flags = a2 & -65537 | 128, b) : null;
      case 5:
        return Bh(b), null;
      case 13:
        E2(L2);
        a2 = b.memoizedState;
        if (null !== a2 && null !== a2.dehydrated) {
          if (null === b.alternate) throw Error(p2(340));
          Ig2();
        }
        a2 = b.flags;
        return a2 & 65536 ? (b.flags = a2 & -65537 | 128, b) : null;
      case 19:
        return E2(L2), null;
      case 4:
        return zh2(), null;
      case 10:
        return ah2(b.type._context), null;
      case 22:
      case 23:
        return Hj(), null;
      case 24:
        return null;
      default:
        return null;
    }
  }
  var Jj = false, U2 = false, Kj = "function" === typeof WeakSet ? WeakSet : Set, V2 = null;
  function Lj(a2, b) {
    var c = a2.ref;
    if (null !== c) if ("function" === typeof c) try {
      c(null);
    } catch (d2) {
      W2(a2, b, d2);
    }
    else c.current = null;
  }
  function Mj(a2, b, c) {
    try {
      c();
    } catch (d2) {
      W2(a2, b, d2);
    }
  }
  var Nj = false;
  function Oj(a2, b) {
    Cf2 = dd2;
    a2 = Me2();
    if (Ne(a2)) {
      if ("selectionStart" in a2) var c = { start: a2.selectionStart, end: a2.selectionEnd };
      else a: {
        c = (c = a2.ownerDocument) && c.defaultView || window;
        var d2 = c.getSelection && c.getSelection();
        if (d2 && 0 !== d2.rangeCount) {
          c = d2.anchorNode;
          var e = d2.anchorOffset, f2 = d2.focusNode;
          d2 = d2.focusOffset;
          try {
            c.nodeType, f2.nodeType;
          } catch (F2) {
            c = null;
            break a;
          }
          var g2 = 0, h2 = -1, k2 = -1, l = 0, m2 = 0, q2 = a2, r2 = null;
          b: for (; ; ) {
            for (var y2; ; ) {
              q2 !== c || 0 !== e && 3 !== q2.nodeType || (h2 = g2 + e);
              q2 !== f2 || 0 !== d2 && 3 !== q2.nodeType || (k2 = g2 + d2);
              3 === q2.nodeType && (g2 += q2.nodeValue.length);
              if (null === (y2 = q2.firstChild)) break;
              r2 = q2;
              q2 = y2;
            }
            for (; ; ) {
              if (q2 === a2) break b;
              r2 === c && ++l === e && (h2 = g2);
              r2 === f2 && ++m2 === d2 && (k2 = g2);
              if (null !== (y2 = q2.nextSibling)) break;
              q2 = r2;
              r2 = q2.parentNode;
            }
            q2 = y2;
          }
          c = -1 === h2 || -1 === k2 ? null : { start: h2, end: k2 };
        } else c = null;
      }
      c = c || { start: 0, end: 0 };
    } else c = null;
    Df2 = { focusedElem: a2, selectionRange: c };
    dd2 = false;
    for (V2 = b; null !== V2; ) if (b = V2, a2 = b.child, 0 !== (b.subtreeFlags & 1028) && null !== a2) a2.return = b, V2 = a2;
    else for (; null !== V2; ) {
      b = V2;
      try {
        var n = b.alternate;
        if (0 !== (b.flags & 1024)) switch (b.tag) {
          case 0:
          case 11:
          case 15:
            break;
          case 1:
            if (null !== n) {
              var t = n.memoizedProps, J2 = n.memoizedState, x2 = b.stateNode, w2 = x2.getSnapshotBeforeUpdate(b.elementType === b.type ? t : Ci2(b.type, t), J2);
              x2.__reactInternalSnapshotBeforeUpdate = w2;
            }
            break;
          case 3:
            var u2 = b.stateNode.containerInfo;
            1 === u2.nodeType ? u2.textContent = "" : 9 === u2.nodeType && u2.documentElement && u2.removeChild(u2.documentElement);
            break;
          case 5:
          case 6:
          case 4:
          case 17:
            break;
          default:
            throw Error(p2(163));
        }
      } catch (F2) {
        W2(b, b.return, F2);
      }
      a2 = b.sibling;
      if (null !== a2) {
        a2.return = b.return;
        V2 = a2;
        break;
      }
      V2 = b.return;
    }
    n = Nj;
    Nj = false;
    return n;
  }
  function Pj(a2, b, c) {
    var d2 = b.updateQueue;
    d2 = null !== d2 ? d2.lastEffect : null;
    if (null !== d2) {
      var e = d2 = d2.next;
      do {
        if ((e.tag & a2) === a2) {
          var f2 = e.destroy;
          e.destroy = void 0;
          void 0 !== f2 && Mj(b, c, f2);
        }
        e = e.next;
      } while (e !== d2);
    }
  }
  function Qj(a2, b) {
    b = b.updateQueue;
    b = null !== b ? b.lastEffect : null;
    if (null !== b) {
      var c = b = b.next;
      do {
        if ((c.tag & a2) === a2) {
          var d2 = c.create;
          c.destroy = d2();
        }
        c = c.next;
      } while (c !== b);
    }
  }
  function Rj(a2) {
    var b = a2.ref;
    if (null !== b) {
      var c = a2.stateNode;
      switch (a2.tag) {
        case 5:
          a2 = c;
          break;
        default:
          a2 = c;
      }
      "function" === typeof b ? b(a2) : b.current = a2;
    }
  }
  function Sj(a2) {
    var b = a2.alternate;
    null !== b && (a2.alternate = null, Sj(b));
    a2.child = null;
    a2.deletions = null;
    a2.sibling = null;
    5 === a2.tag && (b = a2.stateNode, null !== b && (delete b[Of2], delete b[Pf2], delete b[of], delete b[Qf2], delete b[Rf2]));
    a2.stateNode = null;
    a2.return = null;
    a2.dependencies = null;
    a2.memoizedProps = null;
    a2.memoizedState = null;
    a2.pendingProps = null;
    a2.stateNode = null;
    a2.updateQueue = null;
  }
  function Tj(a2) {
    return 5 === a2.tag || 3 === a2.tag || 4 === a2.tag;
  }
  function Uj(a2) {
    a: for (; ; ) {
      for (; null === a2.sibling; ) {
        if (null === a2.return || Tj(a2.return)) return null;
        a2 = a2.return;
      }
      a2.sibling.return = a2.return;
      for (a2 = a2.sibling; 5 !== a2.tag && 6 !== a2.tag && 18 !== a2.tag; ) {
        if (a2.flags & 2) continue a;
        if (null === a2.child || 4 === a2.tag) continue a;
        else a2.child.return = a2, a2 = a2.child;
      }
      if (!(a2.flags & 2)) return a2.stateNode;
    }
  }
  function Vj(a2, b, c) {
    var d2 = a2.tag;
    if (5 === d2 || 6 === d2) a2 = a2.stateNode, b ? 8 === c.nodeType ? c.parentNode.insertBefore(a2, b) : c.insertBefore(a2, b) : (8 === c.nodeType ? (b = c.parentNode, b.insertBefore(a2, c)) : (b = c, b.appendChild(a2)), c = c._reactRootContainer, null !== c && void 0 !== c || null !== b.onclick || (b.onclick = Bf2));
    else if (4 !== d2 && (a2 = a2.child, null !== a2)) for (Vj(a2, b, c), a2 = a2.sibling; null !== a2; ) Vj(a2, b, c), a2 = a2.sibling;
  }
  function Wj(a2, b, c) {
    var d2 = a2.tag;
    if (5 === d2 || 6 === d2) a2 = a2.stateNode, b ? c.insertBefore(a2, b) : c.appendChild(a2);
    else if (4 !== d2 && (a2 = a2.child, null !== a2)) for (Wj(a2, b, c), a2 = a2.sibling; null !== a2; ) Wj(a2, b, c), a2 = a2.sibling;
  }
  var X2 = null, Xj = false;
  function Yj(a2, b, c) {
    for (c = c.child; null !== c; ) Zj(a2, b, c), c = c.sibling;
  }
  function Zj(a2, b, c) {
    if (lc2 && "function" === typeof lc2.onCommitFiberUnmount) try {
      lc2.onCommitFiberUnmount(kc2, c);
    } catch (h2) {
    }
    switch (c.tag) {
      case 5:
        U2 || Lj(c, b);
      case 6:
        var d2 = X2, e = Xj;
        X2 = null;
        Yj(a2, b, c);
        X2 = d2;
        Xj = e;
        null !== X2 && (Xj ? (a2 = X2, c = c.stateNode, 8 === a2.nodeType ? a2.parentNode.removeChild(c) : a2.removeChild(c)) : X2.removeChild(c.stateNode));
        break;
      case 18:
        null !== X2 && (Xj ? (a2 = X2, c = c.stateNode, 8 === a2.nodeType ? Kf2(a2.parentNode, c) : 1 === a2.nodeType && Kf2(a2, c), bd2(a2)) : Kf2(X2, c.stateNode));
        break;
      case 4:
        d2 = X2;
        e = Xj;
        X2 = c.stateNode.containerInfo;
        Xj = true;
        Yj(a2, b, c);
        X2 = d2;
        Xj = e;
        break;
      case 0:
      case 11:
      case 14:
      case 15:
        if (!U2 && (d2 = c.updateQueue, null !== d2 && (d2 = d2.lastEffect, null !== d2))) {
          e = d2 = d2.next;
          do {
            var f2 = e, g2 = f2.destroy;
            f2 = f2.tag;
            void 0 !== g2 && (0 !== (f2 & 2) ? Mj(c, b, g2) : 0 !== (f2 & 4) && Mj(c, b, g2));
            e = e.next;
          } while (e !== d2);
        }
        Yj(a2, b, c);
        break;
      case 1:
        if (!U2 && (Lj(c, b), d2 = c.stateNode, "function" === typeof d2.componentWillUnmount)) try {
          d2.props = c.memoizedProps, d2.state = c.memoizedState, d2.componentWillUnmount();
        } catch (h2) {
          W2(c, b, h2);
        }
        Yj(a2, b, c);
        break;
      case 21:
        Yj(a2, b, c);
        break;
      case 22:
        c.mode & 1 ? (U2 = (d2 = U2) || null !== c.memoizedState, Yj(a2, b, c), U2 = d2) : Yj(a2, b, c);
        break;
      default:
        Yj(a2, b, c);
    }
  }
  function ak(a2) {
    var b = a2.updateQueue;
    if (null !== b) {
      a2.updateQueue = null;
      var c = a2.stateNode;
      null === c && (c = a2.stateNode = new Kj());
      b.forEach(function(b2) {
        var d2 = bk.bind(null, a2, b2);
        c.has(b2) || (c.add(b2), b2.then(d2, d2));
      });
    }
  }
  function ck(a2, b) {
    var c = b.deletions;
    if (null !== c) for (var d2 = 0; d2 < c.length; d2++) {
      var e = c[d2];
      try {
        var f2 = a2, g2 = b, h2 = g2;
        a: for (; null !== h2; ) {
          switch (h2.tag) {
            case 5:
              X2 = h2.stateNode;
              Xj = false;
              break a;
            case 3:
              X2 = h2.stateNode.containerInfo;
              Xj = true;
              break a;
            case 4:
              X2 = h2.stateNode.containerInfo;
              Xj = true;
              break a;
          }
          h2 = h2.return;
        }
        if (null === X2) throw Error(p2(160));
        Zj(f2, g2, e);
        X2 = null;
        Xj = false;
        var k2 = e.alternate;
        null !== k2 && (k2.return = null);
        e.return = null;
      } catch (l) {
        W2(e, b, l);
      }
    }
    if (b.subtreeFlags & 12854) for (b = b.child; null !== b; ) dk(b, a2), b = b.sibling;
  }
  function dk(a2, b) {
    var c = a2.alternate, d2 = a2.flags;
    switch (a2.tag) {
      case 0:
      case 11:
      case 14:
      case 15:
        ck(b, a2);
        ek(a2);
        if (d2 & 4) {
          try {
            Pj(3, a2, a2.return), Qj(3, a2);
          } catch (t) {
            W2(a2, a2.return, t);
          }
          try {
            Pj(5, a2, a2.return);
          } catch (t) {
            W2(a2, a2.return, t);
          }
        }
        break;
      case 1:
        ck(b, a2);
        ek(a2);
        d2 & 512 && null !== c && Lj(c, c.return);
        break;
      case 5:
        ck(b, a2);
        ek(a2);
        d2 & 512 && null !== c && Lj(c, c.return);
        if (a2.flags & 32) {
          var e = a2.stateNode;
          try {
            ob(e, "");
          } catch (t) {
            W2(a2, a2.return, t);
          }
        }
        if (d2 & 4 && (e = a2.stateNode, null != e)) {
          var f2 = a2.memoizedProps, g2 = null !== c ? c.memoizedProps : f2, h2 = a2.type, k2 = a2.updateQueue;
          a2.updateQueue = null;
          if (null !== k2) try {
            "input" === h2 && "radio" === f2.type && null != f2.name && ab(e, f2);
            vb(h2, g2);
            var l = vb(h2, f2);
            for (g2 = 0; g2 < k2.length; g2 += 2) {
              var m2 = k2[g2], q2 = k2[g2 + 1];
              "style" === m2 ? sb(e, q2) : "dangerouslySetInnerHTML" === m2 ? nb(e, q2) : "children" === m2 ? ob(e, q2) : ta2(e, m2, q2, l);
            }
            switch (h2) {
              case "input":
                bb(e, f2);
                break;
              case "textarea":
                ib(e, f2);
                break;
              case "select":
                var r2 = e._wrapperState.wasMultiple;
                e._wrapperState.wasMultiple = !!f2.multiple;
                var y2 = f2.value;
                null != y2 ? fb(e, !!f2.multiple, y2, false) : r2 !== !!f2.multiple && (null != f2.defaultValue ? fb(
                  e,
                  !!f2.multiple,
                  f2.defaultValue,
                  true
                ) : fb(e, !!f2.multiple, f2.multiple ? [] : "", false));
            }
            e[Pf2] = f2;
          } catch (t) {
            W2(a2, a2.return, t);
          }
        }
        break;
      case 6:
        ck(b, a2);
        ek(a2);
        if (d2 & 4) {
          if (null === a2.stateNode) throw Error(p2(162));
          e = a2.stateNode;
          f2 = a2.memoizedProps;
          try {
            e.nodeValue = f2;
          } catch (t) {
            W2(a2, a2.return, t);
          }
        }
        break;
      case 3:
        ck(b, a2);
        ek(a2);
        if (d2 & 4 && null !== c && c.memoizedState.isDehydrated) try {
          bd2(b.containerInfo);
        } catch (t) {
          W2(a2, a2.return, t);
        }
        break;
      case 4:
        ck(b, a2);
        ek(a2);
        break;
      case 13:
        ck(b, a2);
        ek(a2);
        e = a2.child;
        e.flags & 8192 && (f2 = null !== e.memoizedState, e.stateNode.isHidden = f2, !f2 || null !== e.alternate && null !== e.alternate.memoizedState || (fk = B2()));
        d2 & 4 && ak(a2);
        break;
      case 22:
        m2 = null !== c && null !== c.memoizedState;
        a2.mode & 1 ? (U2 = (l = U2) || m2, ck(b, a2), U2 = l) : ck(b, a2);
        ek(a2);
        if (d2 & 8192) {
          l = null !== a2.memoizedState;
          if ((a2.stateNode.isHidden = l) && !m2 && 0 !== (a2.mode & 1)) for (V2 = a2, m2 = a2.child; null !== m2; ) {
            for (q2 = V2 = m2; null !== V2; ) {
              r2 = V2;
              y2 = r2.child;
              switch (r2.tag) {
                case 0:
                case 11:
                case 14:
                case 15:
                  Pj(4, r2, r2.return);
                  break;
                case 1:
                  Lj(r2, r2.return);
                  var n = r2.stateNode;
                  if ("function" === typeof n.componentWillUnmount) {
                    d2 = r2;
                    c = r2.return;
                    try {
                      b = d2, n.props = b.memoizedProps, n.state = b.memoizedState, n.componentWillUnmount();
                    } catch (t) {
                      W2(d2, c, t);
                    }
                  }
                  break;
                case 5:
                  Lj(r2, r2.return);
                  break;
                case 22:
                  if (null !== r2.memoizedState) {
                    gk(q2);
                    continue;
                  }
              }
              null !== y2 ? (y2.return = r2, V2 = y2) : gk(q2);
            }
            m2 = m2.sibling;
          }
          a: for (m2 = null, q2 = a2; ; ) {
            if (5 === q2.tag) {
              if (null === m2) {
                m2 = q2;
                try {
                  e = q2.stateNode, l ? (f2 = e.style, "function" === typeof f2.setProperty ? f2.setProperty("display", "none", "important") : f2.display = "none") : (h2 = q2.stateNode, k2 = q2.memoizedProps.style, g2 = void 0 !== k2 && null !== k2 && k2.hasOwnProperty("display") ? k2.display : null, h2.style.display = rb("display", g2));
                } catch (t) {
                  W2(a2, a2.return, t);
                }
              }
            } else if (6 === q2.tag) {
              if (null === m2) try {
                q2.stateNode.nodeValue = l ? "" : q2.memoizedProps;
              } catch (t) {
                W2(a2, a2.return, t);
              }
            } else if ((22 !== q2.tag && 23 !== q2.tag || null === q2.memoizedState || q2 === a2) && null !== q2.child) {
              q2.child.return = q2;
              q2 = q2.child;
              continue;
            }
            if (q2 === a2) break a;
            for (; null === q2.sibling; ) {
              if (null === q2.return || q2.return === a2) break a;
              m2 === q2 && (m2 = null);
              q2 = q2.return;
            }
            m2 === q2 && (m2 = null);
            q2.sibling.return = q2.return;
            q2 = q2.sibling;
          }
        }
        break;
      case 19:
        ck(b, a2);
        ek(a2);
        d2 & 4 && ak(a2);
        break;
      case 21:
        break;
      default:
        ck(
          b,
          a2
        ), ek(a2);
    }
  }
  function ek(a2) {
    var b = a2.flags;
    if (b & 2) {
      try {
        a: {
          for (var c = a2.return; null !== c; ) {
            if (Tj(c)) {
              var d2 = c;
              break a;
            }
            c = c.return;
          }
          throw Error(p2(160));
        }
        switch (d2.tag) {
          case 5:
            var e = d2.stateNode;
            d2.flags & 32 && (ob(e, ""), d2.flags &= -33);
            var f2 = Uj(a2);
            Wj(a2, f2, e);
            break;
          case 3:
          case 4:
            var g2 = d2.stateNode.containerInfo, h2 = Uj(a2);
            Vj(a2, h2, g2);
            break;
          default:
            throw Error(p2(161));
        }
      } catch (k2) {
        W2(a2, a2.return, k2);
      }
      a2.flags &= -3;
    }
    b & 4096 && (a2.flags &= -4097);
  }
  function hk(a2, b, c) {
    V2 = a2;
    ik(a2);
  }
  function ik(a2, b, c) {
    for (var d2 = 0 !== (a2.mode & 1); null !== V2; ) {
      var e = V2, f2 = e.child;
      if (22 === e.tag && d2) {
        var g2 = null !== e.memoizedState || Jj;
        if (!g2) {
          var h2 = e.alternate, k2 = null !== h2 && null !== h2.memoizedState || U2;
          h2 = Jj;
          var l = U2;
          Jj = g2;
          if ((U2 = k2) && !l) for (V2 = e; null !== V2; ) g2 = V2, k2 = g2.child, 22 === g2.tag && null !== g2.memoizedState ? jk(e) : null !== k2 ? (k2.return = g2, V2 = k2) : jk(e);
          for (; null !== f2; ) V2 = f2, ik(f2), f2 = f2.sibling;
          V2 = e;
          Jj = h2;
          U2 = l;
        }
        kk(a2);
      } else 0 !== (e.subtreeFlags & 8772) && null !== f2 ? (f2.return = e, V2 = f2) : kk(a2);
    }
  }
  function kk(a2) {
    for (; null !== V2; ) {
      var b = V2;
      if (0 !== (b.flags & 8772)) {
        var c = b.alternate;
        try {
          if (0 !== (b.flags & 8772)) switch (b.tag) {
            case 0:
            case 11:
            case 15:
              U2 || Qj(5, b);
              break;
            case 1:
              var d2 = b.stateNode;
              if (b.flags & 4 && !U2) if (null === c) d2.componentDidMount();
              else {
                var e = b.elementType === b.type ? c.memoizedProps : Ci2(b.type, c.memoizedProps);
                d2.componentDidUpdate(e, c.memoizedState, d2.__reactInternalSnapshotBeforeUpdate);
              }
              var f2 = b.updateQueue;
              null !== f2 && sh2(b, f2, d2);
              break;
            case 3:
              var g2 = b.updateQueue;
              if (null !== g2) {
                c = null;
                if (null !== b.child) switch (b.child.tag) {
                  case 5:
                    c = b.child.stateNode;
                    break;
                  case 1:
                    c = b.child.stateNode;
                }
                sh2(b, g2, c);
              }
              break;
            case 5:
              var h2 = b.stateNode;
              if (null === c && b.flags & 4) {
                c = h2;
                var k2 = b.memoizedProps;
                switch (b.type) {
                  case "button":
                  case "input":
                  case "select":
                  case "textarea":
                    k2.autoFocus && c.focus();
                    break;
                  case "img":
                    k2.src && (c.src = k2.src);
                }
              }
              break;
            case 6:
              break;
            case 4:
              break;
            case 12:
              break;
            case 13:
              if (null === b.memoizedState) {
                var l = b.alternate;
                if (null !== l) {
                  var m2 = l.memoizedState;
                  if (null !== m2) {
                    var q2 = m2.dehydrated;
                    null !== q2 && bd2(q2);
                  }
                }
              }
              break;
            case 19:
            case 17:
            case 21:
            case 22:
            case 23:
            case 25:
              break;
            default:
              throw Error(p2(163));
          }
          U2 || b.flags & 512 && Rj(b);
        } catch (r2) {
          W2(b, b.return, r2);
        }
      }
      if (b === a2) {
        V2 = null;
        break;
      }
      c = b.sibling;
      if (null !== c) {
        c.return = b.return;
        V2 = c;
        break;
      }
      V2 = b.return;
    }
  }
  function gk(a2) {
    for (; null !== V2; ) {
      var b = V2;
      if (b === a2) {
        V2 = null;
        break;
      }
      var c = b.sibling;
      if (null !== c) {
        c.return = b.return;
        V2 = c;
        break;
      }
      V2 = b.return;
    }
  }
  function jk(a2) {
    for (; null !== V2; ) {
      var b = V2;
      try {
        switch (b.tag) {
          case 0:
          case 11:
          case 15:
            var c = b.return;
            try {
              Qj(4, b);
            } catch (k2) {
              W2(b, c, k2);
            }
            break;
          case 1:
            var d2 = b.stateNode;
            if ("function" === typeof d2.componentDidMount) {
              var e = b.return;
              try {
                d2.componentDidMount();
              } catch (k2) {
                W2(b, e, k2);
              }
            }
            var f2 = b.return;
            try {
              Rj(b);
            } catch (k2) {
              W2(b, f2, k2);
            }
            break;
          case 5:
            var g2 = b.return;
            try {
              Rj(b);
            } catch (k2) {
              W2(b, g2, k2);
            }
        }
      } catch (k2) {
        W2(b, b.return, k2);
      }
      if (b === a2) {
        V2 = null;
        break;
      }
      var h2 = b.sibling;
      if (null !== h2) {
        h2.return = b.return;
        V2 = h2;
        break;
      }
      V2 = b.return;
    }
  }
  var lk = Math.ceil, mk = ua2.ReactCurrentDispatcher, nk = ua2.ReactCurrentOwner, ok = ua2.ReactCurrentBatchConfig, K2 = 0, Q2 = null, Y2 = null, Z2 = 0, fj = 0, ej = Uf2(0), T2 = 0, pk = null, rh2 = 0, qk = 0, rk = 0, sk = null, tk = null, fk = 0, Gj = Infinity, uk = null, Oi2 = false, Pi2 = null, Ri2 = null, vk = false, wk = null, xk = 0, yk = 0, zk = null, Ak = -1, Bk = 0;
  function R2() {
    return 0 !== (K2 & 6) ? B2() : -1 !== Ak ? Ak : Ak = B2();
  }
  function yi2(a2) {
    if (0 === (a2.mode & 1)) return 1;
    if (0 !== (K2 & 2) && 0 !== Z2) return Z2 & -Z2;
    if (null !== Kg2.transition) return 0 === Bk && (Bk = yc2()), Bk;
    a2 = C;
    if (0 !== a2) return a2;
    a2 = window.event;
    a2 = void 0 === a2 ? 16 : jd2(a2.type);
    return a2;
  }
  function gi2(a2, b, c, d2) {
    if (50 < yk) throw yk = 0, zk = null, Error(p2(185));
    Ac2(a2, c, d2);
    if (0 === (K2 & 2) || a2 !== Q2) a2 === Q2 && (0 === (K2 & 2) && (qk |= c), 4 === T2 && Ck(a2, Z2)), Dk(a2, d2), 1 === c && 0 === K2 && 0 === (b.mode & 1) && (Gj = B2() + 500, fg2 && jg2());
  }
  function Dk(a2, b) {
    var c = a2.callbackNode;
    wc2(a2, b);
    var d2 = uc2(a2, a2 === Q2 ? Z2 : 0);
    if (0 === d2) null !== c && bc2(c), a2.callbackNode = null, a2.callbackPriority = 0;
    else if (b = d2 & -d2, a2.callbackPriority !== b) {
      null != c && bc2(c);
      if (1 === b) 0 === a2.tag ? ig2(Ek.bind(null, a2)) : hg2(Ek.bind(null, a2)), Jf2(function() {
        0 === (K2 & 6) && jg2();
      }), c = null;
      else {
        switch (Dc2(d2)) {
          case 1:
            c = fc2;
            break;
          case 4:
            c = gc2;
            break;
          case 16:
            c = hc2;
            break;
          case 536870912:
            c = jc2;
            break;
          default:
            c = hc2;
        }
        c = Fk(c, Gk.bind(null, a2));
      }
      a2.callbackPriority = b;
      a2.callbackNode = c;
    }
  }
  function Gk(a2, b) {
    Ak = -1;
    Bk = 0;
    if (0 !== (K2 & 6)) throw Error(p2(327));
    var c = a2.callbackNode;
    if (Hk() && a2.callbackNode !== c) return null;
    var d2 = uc2(a2, a2 === Q2 ? Z2 : 0);
    if (0 === d2) return null;
    if (0 !== (d2 & 30) || 0 !== (d2 & a2.expiredLanes) || b) b = Ik(a2, d2);
    else {
      b = d2;
      var e = K2;
      K2 |= 2;
      var f2 = Jk();
      if (Q2 !== a2 || Z2 !== b) uk = null, Gj = B2() + 500, Kk(a2, b);
      do
        try {
          Lk();
          break;
        } catch (h2) {
          Mk(a2, h2);
        }
      while (1);
      $g2();
      mk.current = f2;
      K2 = e;
      null !== Y2 ? b = 0 : (Q2 = null, Z2 = 0, b = T2);
    }
    if (0 !== b) {
      2 === b && (e = xc2(a2), 0 !== e && (d2 = e, b = Nk(a2, e)));
      if (1 === b) throw c = pk, Kk(a2, 0), Ck(a2, d2), Dk(a2, B2()), c;
      if (6 === b) Ck(a2, d2);
      else {
        e = a2.current.alternate;
        if (0 === (d2 & 30) && !Ok(e) && (b = Ik(a2, d2), 2 === b && (f2 = xc2(a2), 0 !== f2 && (d2 = f2, b = Nk(a2, f2))), 1 === b)) throw c = pk, Kk(a2, 0), Ck(a2, d2), Dk(a2, B2()), c;
        a2.finishedWork = e;
        a2.finishedLanes = d2;
        switch (b) {
          case 0:
          case 1:
            throw Error(p2(345));
          case 2:
            Pk(a2, tk, uk);
            break;
          case 3:
            Ck(a2, d2);
            if ((d2 & 130023424) === d2 && (b = fk + 500 - B2(), 10 < b)) {
              if (0 !== uc2(a2, 0)) break;
              e = a2.suspendedLanes;
              if ((e & d2) !== d2) {
                R2();
                a2.pingedLanes |= a2.suspendedLanes & e;
                break;
              }
              a2.timeoutHandle = Ff2(Pk.bind(null, a2, tk, uk), b);
              break;
            }
            Pk(a2, tk, uk);
            break;
          case 4:
            Ck(a2, d2);
            if ((d2 & 4194240) === d2) break;
            b = a2.eventTimes;
            for (e = -1; 0 < d2; ) {
              var g2 = 31 - oc2(d2);
              f2 = 1 << g2;
              g2 = b[g2];
              g2 > e && (e = g2);
              d2 &= ~f2;
            }
            d2 = e;
            d2 = B2() - d2;
            d2 = (120 > d2 ? 120 : 480 > d2 ? 480 : 1080 > d2 ? 1080 : 1920 > d2 ? 1920 : 3e3 > d2 ? 3e3 : 4320 > d2 ? 4320 : 1960 * lk(d2 / 1960)) - d2;
            if (10 < d2) {
              a2.timeoutHandle = Ff2(Pk.bind(null, a2, tk, uk), d2);
              break;
            }
            Pk(a2, tk, uk);
            break;
          case 5:
            Pk(a2, tk, uk);
            break;
          default:
            throw Error(p2(329));
        }
      }
    }
    Dk(a2, B2());
    return a2.callbackNode === c ? Gk.bind(null, a2) : null;
  }
  function Nk(a2, b) {
    var c = sk;
    a2.current.memoizedState.isDehydrated && (Kk(a2, b).flags |= 256);
    a2 = Ik(a2, b);
    2 !== a2 && (b = tk, tk = c, null !== b && Fj(b));
    return a2;
  }
  function Fj(a2) {
    null === tk ? tk = a2 : tk.push.apply(tk, a2);
  }
  function Ok(a2) {
    for (var b = a2; ; ) {
      if (b.flags & 16384) {
        var c = b.updateQueue;
        if (null !== c && (c = c.stores, null !== c)) for (var d2 = 0; d2 < c.length; d2++) {
          var e = c[d2], f2 = e.getSnapshot;
          e = e.value;
          try {
            if (!He2(f2(), e)) return false;
          } catch (g2) {
            return false;
          }
        }
      }
      c = b.child;
      if (b.subtreeFlags & 16384 && null !== c) c.return = b, b = c;
      else {
        if (b === a2) break;
        for (; null === b.sibling; ) {
          if (null === b.return || b.return === a2) return true;
          b = b.return;
        }
        b.sibling.return = b.return;
        b = b.sibling;
      }
    }
    return true;
  }
  function Ck(a2, b) {
    b &= ~rk;
    b &= ~qk;
    a2.suspendedLanes |= b;
    a2.pingedLanes &= ~b;
    for (a2 = a2.expirationTimes; 0 < b; ) {
      var c = 31 - oc2(b), d2 = 1 << c;
      a2[c] = -1;
      b &= ~d2;
    }
  }
  function Ek(a2) {
    if (0 !== (K2 & 6)) throw Error(p2(327));
    Hk();
    var b = uc2(a2, 0);
    if (0 === (b & 1)) return Dk(a2, B2()), null;
    var c = Ik(a2, b);
    if (0 !== a2.tag && 2 === c) {
      var d2 = xc2(a2);
      0 !== d2 && (b = d2, c = Nk(a2, d2));
    }
    if (1 === c) throw c = pk, Kk(a2, 0), Ck(a2, b), Dk(a2, B2()), c;
    if (6 === c) throw Error(p2(345));
    a2.finishedWork = a2.current.alternate;
    a2.finishedLanes = b;
    Pk(a2, tk, uk);
    Dk(a2, B2());
    return null;
  }
  function Qk(a2, b) {
    var c = K2;
    K2 |= 1;
    try {
      return a2(b);
    } finally {
      K2 = c, 0 === K2 && (Gj = B2() + 500, fg2 && jg2());
    }
  }
  function Rk(a2) {
    null !== wk && 0 === wk.tag && 0 === (K2 & 6) && Hk();
    var b = K2;
    K2 |= 1;
    var c = ok.transition, d2 = C;
    try {
      if (ok.transition = null, C = 1, a2) return a2();
    } finally {
      C = d2, ok.transition = c, K2 = b, 0 === (K2 & 6) && jg2();
    }
  }
  function Hj() {
    fj = ej.current;
    E2(ej);
  }
  function Kk(a2, b) {
    a2.finishedWork = null;
    a2.finishedLanes = 0;
    var c = a2.timeoutHandle;
    -1 !== c && (a2.timeoutHandle = -1, Gf2(c));
    if (null !== Y2) for (c = Y2.return; null !== c; ) {
      var d2 = c;
      wg2(d2);
      switch (d2.tag) {
        case 1:
          d2 = d2.type.childContextTypes;
          null !== d2 && void 0 !== d2 && $f();
          break;
        case 3:
          zh2();
          E2(Wf2);
          E2(H2);
          Eh2();
          break;
        case 5:
          Bh(d2);
          break;
        case 4:
          zh2();
          break;
        case 13:
          E2(L2);
          break;
        case 19:
          E2(L2);
          break;
        case 10:
          ah2(d2.type._context);
          break;
        case 22:
        case 23:
          Hj();
      }
      c = c.return;
    }
    Q2 = a2;
    Y2 = a2 = Pg2(a2.current, null);
    Z2 = fj = b;
    T2 = 0;
    pk = null;
    rk = qk = rh2 = 0;
    tk = sk = null;
    if (null !== fh2) {
      for (b = 0; b < fh2.length; b++) if (c = fh2[b], d2 = c.interleaved, null !== d2) {
        c.interleaved = null;
        var e = d2.next, f2 = c.pending;
        if (null !== f2) {
          var g2 = f2.next;
          f2.next = e;
          d2.next = g2;
        }
        c.pending = d2;
      }
      fh2 = null;
    }
    return a2;
  }
  function Mk(a2, b) {
    do {
      var c = Y2;
      try {
        $g2();
        Fh.current = Rh;
        if (Ih2) {
          for (var d2 = M2.memoizedState; null !== d2; ) {
            var e = d2.queue;
            null !== e && (e.pending = null);
            d2 = d2.next;
          }
          Ih2 = false;
        }
        Hh = 0;
        O = N2 = M2 = null;
        Jh = false;
        Kh = 0;
        nk.current = null;
        if (null === c || null === c.return) {
          T2 = 1;
          pk = b;
          Y2 = null;
          break;
        }
        a: {
          var f2 = a2, g2 = c.return, h2 = c, k2 = b;
          b = Z2;
          h2.flags |= 32768;
          if (null !== k2 && "object" === typeof k2 && "function" === typeof k2.then) {
            var l = k2, m2 = h2, q2 = m2.tag;
            if (0 === (m2.mode & 1) && (0 === q2 || 11 === q2 || 15 === q2)) {
              var r2 = m2.alternate;
              r2 ? (m2.updateQueue = r2.updateQueue, m2.memoizedState = r2.memoizedState, m2.lanes = r2.lanes) : (m2.updateQueue = null, m2.memoizedState = null);
            }
            var y2 = Ui2(g2);
            if (null !== y2) {
              y2.flags &= -257;
              Vi2(y2, g2, h2, f2, b);
              y2.mode & 1 && Si2(f2, l, b);
              b = y2;
              k2 = l;
              var n = b.updateQueue;
              if (null === n) {
                var t = /* @__PURE__ */ new Set();
                t.add(k2);
                b.updateQueue = t;
              } else n.add(k2);
              break a;
            } else {
              if (0 === (b & 1)) {
                Si2(f2, l, b);
                tj();
                break a;
              }
              k2 = Error(p2(426));
            }
          } else if (I2 && h2.mode & 1) {
            var J2 = Ui2(g2);
            if (null !== J2) {
              0 === (J2.flags & 65536) && (J2.flags |= 256);
              Vi2(J2, g2, h2, f2, b);
              Jg2(Ji2(k2, h2));
              break a;
            }
          }
          f2 = k2 = Ji2(k2, h2);
          4 !== T2 && (T2 = 2);
          null === sk ? sk = [f2] : sk.push(f2);
          f2 = g2;
          do {
            switch (f2.tag) {
              case 3:
                f2.flags |= 65536;
                b &= -b;
                f2.lanes |= b;
                var x2 = Ni2(f2, k2, b);
                ph2(f2, x2);
                break a;
              case 1:
                h2 = k2;
                var w2 = f2.type, u2 = f2.stateNode;
                if (0 === (f2.flags & 128) && ("function" === typeof w2.getDerivedStateFromError || null !== u2 && "function" === typeof u2.componentDidCatch && (null === Ri2 || !Ri2.has(u2)))) {
                  f2.flags |= 65536;
                  b &= -b;
                  f2.lanes |= b;
                  var F2 = Qi2(f2, h2, b);
                  ph2(f2, F2);
                  break a;
                }
            }
            f2 = f2.return;
          } while (null !== f2);
        }
        Sk(c);
      } catch (na2) {
        b = na2;
        Y2 === c && null !== c && (Y2 = c = c.return);
        continue;
      }
      break;
    } while (1);
  }
  function Jk() {
    var a2 = mk.current;
    mk.current = Rh;
    return null === a2 ? Rh : a2;
  }
  function tj() {
    if (0 === T2 || 3 === T2 || 2 === T2) T2 = 4;
    null === Q2 || 0 === (rh2 & 268435455) && 0 === (qk & 268435455) || Ck(Q2, Z2);
  }
  function Ik(a2, b) {
    var c = K2;
    K2 |= 2;
    var d2 = Jk();
    if (Q2 !== a2 || Z2 !== b) uk = null, Kk(a2, b);
    do
      try {
        Tk();
        break;
      } catch (e) {
        Mk(a2, e);
      }
    while (1);
    $g2();
    K2 = c;
    mk.current = d2;
    if (null !== Y2) throw Error(p2(261));
    Q2 = null;
    Z2 = 0;
    return T2;
  }
  function Tk() {
    for (; null !== Y2; ) Uk(Y2);
  }
  function Lk() {
    for (; null !== Y2 && !cc2(); ) Uk(Y2);
  }
  function Uk(a2) {
    var b = Vk(a2.alternate, a2, fj);
    a2.memoizedProps = a2.pendingProps;
    null === b ? Sk(a2) : Y2 = b;
    nk.current = null;
  }
  function Sk(a2) {
    var b = a2;
    do {
      var c = b.alternate;
      a2 = b.return;
      if (0 === (b.flags & 32768)) {
        if (c = Ej(c, b, fj), null !== c) {
          Y2 = c;
          return;
        }
      } else {
        c = Ij(c, b);
        if (null !== c) {
          c.flags &= 32767;
          Y2 = c;
          return;
        }
        if (null !== a2) a2.flags |= 32768, a2.subtreeFlags = 0, a2.deletions = null;
        else {
          T2 = 6;
          Y2 = null;
          return;
        }
      }
      b = b.sibling;
      if (null !== b) {
        Y2 = b;
        return;
      }
      Y2 = b = a2;
    } while (null !== b);
    0 === T2 && (T2 = 5);
  }
  function Pk(a2, b, c) {
    var d2 = C, e = ok.transition;
    try {
      ok.transition = null, C = 1, Wk(a2, b, c, d2);
    } finally {
      ok.transition = e, C = d2;
    }
    return null;
  }
  function Wk(a2, b, c, d2) {
    do
      Hk();
    while (null !== wk);
    if (0 !== (K2 & 6)) throw Error(p2(327));
    c = a2.finishedWork;
    var e = a2.finishedLanes;
    if (null === c) return null;
    a2.finishedWork = null;
    a2.finishedLanes = 0;
    if (c === a2.current) throw Error(p2(177));
    a2.callbackNode = null;
    a2.callbackPriority = 0;
    var f2 = c.lanes | c.childLanes;
    Bc2(a2, f2);
    a2 === Q2 && (Y2 = Q2 = null, Z2 = 0);
    0 === (c.subtreeFlags & 2064) && 0 === (c.flags & 2064) || vk || (vk = true, Fk(hc2, function() {
      Hk();
      return null;
    }));
    f2 = 0 !== (c.flags & 15990);
    if (0 !== (c.subtreeFlags & 15990) || f2) {
      f2 = ok.transition;
      ok.transition = null;
      var g2 = C;
      C = 1;
      var h2 = K2;
      K2 |= 4;
      nk.current = null;
      Oj(a2, c);
      dk(c, a2);
      Oe(Df2);
      dd2 = !!Cf2;
      Df2 = Cf2 = null;
      a2.current = c;
      hk(c);
      dc2();
      K2 = h2;
      C = g2;
      ok.transition = f2;
    } else a2.current = c;
    vk && (vk = false, wk = a2, xk = e);
    f2 = a2.pendingLanes;
    0 === f2 && (Ri2 = null);
    mc2(c.stateNode);
    Dk(a2, B2());
    if (null !== b) for (d2 = a2.onRecoverableError, c = 0; c < b.length; c++) e = b[c], d2(e.value, { componentStack: e.stack, digest: e.digest });
    if (Oi2) throw Oi2 = false, a2 = Pi2, Pi2 = null, a2;
    0 !== (xk & 1) && 0 !== a2.tag && Hk();
    f2 = a2.pendingLanes;
    0 !== (f2 & 1) ? a2 === zk ? yk++ : (yk = 0, zk = a2) : yk = 0;
    jg2();
    return null;
  }
  function Hk() {
    if (null !== wk) {
      var a2 = Dc2(xk), b = ok.transition, c = C;
      try {
        ok.transition = null;
        C = 16 > a2 ? 16 : a2;
        if (null === wk) var d2 = false;
        else {
          a2 = wk;
          wk = null;
          xk = 0;
          if (0 !== (K2 & 6)) throw Error(p2(331));
          var e = K2;
          K2 |= 4;
          for (V2 = a2.current; null !== V2; ) {
            var f2 = V2, g2 = f2.child;
            if (0 !== (V2.flags & 16)) {
              var h2 = f2.deletions;
              if (null !== h2) {
                for (var k2 = 0; k2 < h2.length; k2++) {
                  var l = h2[k2];
                  for (V2 = l; null !== V2; ) {
                    var m2 = V2;
                    switch (m2.tag) {
                      case 0:
                      case 11:
                      case 15:
                        Pj(8, m2, f2);
                    }
                    var q2 = m2.child;
                    if (null !== q2) q2.return = m2, V2 = q2;
                    else for (; null !== V2; ) {
                      m2 = V2;
                      var r2 = m2.sibling, y2 = m2.return;
                      Sj(m2);
                      if (m2 === l) {
                        V2 = null;
                        break;
                      }
                      if (null !== r2) {
                        r2.return = y2;
                        V2 = r2;
                        break;
                      }
                      V2 = y2;
                    }
                  }
                }
                var n = f2.alternate;
                if (null !== n) {
                  var t = n.child;
                  if (null !== t) {
                    n.child = null;
                    do {
                      var J2 = t.sibling;
                      t.sibling = null;
                      t = J2;
                    } while (null !== t);
                  }
                }
                V2 = f2;
              }
            }
            if (0 !== (f2.subtreeFlags & 2064) && null !== g2) g2.return = f2, V2 = g2;
            else b: for (; null !== V2; ) {
              f2 = V2;
              if (0 !== (f2.flags & 2048)) switch (f2.tag) {
                case 0:
                case 11:
                case 15:
                  Pj(9, f2, f2.return);
              }
              var x2 = f2.sibling;
              if (null !== x2) {
                x2.return = f2.return;
                V2 = x2;
                break b;
              }
              V2 = f2.return;
            }
          }
          var w2 = a2.current;
          for (V2 = w2; null !== V2; ) {
            g2 = V2;
            var u2 = g2.child;
            if (0 !== (g2.subtreeFlags & 2064) && null !== u2) u2.return = g2, V2 = u2;
            else b: for (g2 = w2; null !== V2; ) {
              h2 = V2;
              if (0 !== (h2.flags & 2048)) try {
                switch (h2.tag) {
                  case 0:
                  case 11:
                  case 15:
                    Qj(9, h2);
                }
              } catch (na2) {
                W2(h2, h2.return, na2);
              }
              if (h2 === g2) {
                V2 = null;
                break b;
              }
              var F2 = h2.sibling;
              if (null !== F2) {
                F2.return = h2.return;
                V2 = F2;
                break b;
              }
              V2 = h2.return;
            }
          }
          K2 = e;
          jg2();
          if (lc2 && "function" === typeof lc2.onPostCommitFiberRoot) try {
            lc2.onPostCommitFiberRoot(kc2, a2);
          } catch (na2) {
          }
          d2 = true;
        }
        return d2;
      } finally {
        C = c, ok.transition = b;
      }
    }
    return false;
  }
  function Xk(a2, b, c) {
    b = Ji2(c, b);
    b = Ni2(a2, b, 1);
    a2 = nh2(a2, b, 1);
    b = R2();
    null !== a2 && (Ac2(a2, 1, b), Dk(a2, b));
  }
  function W2(a2, b, c) {
    if (3 === a2.tag) Xk(a2, a2, c);
    else for (; null !== b; ) {
      if (3 === b.tag) {
        Xk(b, a2, c);
        break;
      } else if (1 === b.tag) {
        var d2 = b.stateNode;
        if ("function" === typeof b.type.getDerivedStateFromError || "function" === typeof d2.componentDidCatch && (null === Ri2 || !Ri2.has(d2))) {
          a2 = Ji2(c, a2);
          a2 = Qi2(b, a2, 1);
          b = nh2(b, a2, 1);
          a2 = R2();
          null !== b && (Ac2(b, 1, a2), Dk(b, a2));
          break;
        }
      }
      b = b.return;
    }
  }
  function Ti2(a2, b, c) {
    var d2 = a2.pingCache;
    null !== d2 && d2.delete(b);
    b = R2();
    a2.pingedLanes |= a2.suspendedLanes & c;
    Q2 === a2 && (Z2 & c) === c && (4 === T2 || 3 === T2 && (Z2 & 130023424) === Z2 && 500 > B2() - fk ? Kk(a2, 0) : rk |= c);
    Dk(a2, b);
  }
  function Yk(a2, b) {
    0 === b && (0 === (a2.mode & 1) ? b = 1 : (b = sc2, sc2 <<= 1, 0 === (sc2 & 130023424) && (sc2 = 4194304)));
    var c = R2();
    a2 = ih2(a2, b);
    null !== a2 && (Ac2(a2, b, c), Dk(a2, c));
  }
  function uj(a2) {
    var b = a2.memoizedState, c = 0;
    null !== b && (c = b.retryLane);
    Yk(a2, c);
  }
  function bk(a2, b) {
    var c = 0;
    switch (a2.tag) {
      case 13:
        var d2 = a2.stateNode;
        var e = a2.memoizedState;
        null !== e && (c = e.retryLane);
        break;
      case 19:
        d2 = a2.stateNode;
        break;
      default:
        throw Error(p2(314));
    }
    null !== d2 && d2.delete(b);
    Yk(a2, c);
  }
  var Vk;
  Vk = function(a2, b, c) {
    if (null !== a2) if (a2.memoizedProps !== b.pendingProps || Wf2.current) dh2 = true;
    else {
      if (0 === (a2.lanes & c) && 0 === (b.flags & 128)) return dh2 = false, yj(a2, b, c);
      dh2 = 0 !== (a2.flags & 131072) ? true : false;
    }
    else dh2 = false, I2 && 0 !== (b.flags & 1048576) && ug2(b, ng2, b.index);
    b.lanes = 0;
    switch (b.tag) {
      case 2:
        var d2 = b.type;
        ij(a2, b);
        a2 = b.pendingProps;
        var e = Yf2(b, H2.current);
        ch2(b, c);
        e = Nh(null, b, d2, a2, e, c);
        var f2 = Sh2();
        b.flags |= 1;
        "object" === typeof e && null !== e && "function" === typeof e.render && void 0 === e.$$typeof ? (b.tag = 1, b.memoizedState = null, b.updateQueue = null, Zf2(d2) ? (f2 = true, cg2(b)) : f2 = false, b.memoizedState = null !== e.state && void 0 !== e.state ? e.state : null, kh(b), e.updater = Ei2, b.stateNode = e, e._reactInternals = b, Ii2(b, d2, a2, c), b = jj(null, b, d2, true, f2, c)) : (b.tag = 0, I2 && f2 && vg3(b), Xi2(null, b, e, c), b = b.child);
        return b;
      case 16:
        d2 = b.elementType;
        a: {
          ij(a2, b);
          a2 = b.pendingProps;
          e = d2._init;
          d2 = e(d2._payload);
          b.type = d2;
          e = b.tag = Zk(d2);
          a2 = Ci2(d2, a2);
          switch (e) {
            case 0:
              b = cj(null, b, d2, a2, c);
              break a;
            case 1:
              b = hj(null, b, d2, a2, c);
              break a;
            case 11:
              b = Yi2(null, b, d2, a2, c);
              break a;
            case 14:
              b = $i2(null, b, d2, Ci2(d2.type, a2), c);
              break a;
          }
          throw Error(p2(
            306,
            d2,
            ""
          ));
        }
        return b;
      case 0:
        return d2 = b.type, e = b.pendingProps, e = b.elementType === d2 ? e : Ci2(d2, e), cj(a2, b, d2, e, c);
      case 1:
        return d2 = b.type, e = b.pendingProps, e = b.elementType === d2 ? e : Ci2(d2, e), hj(a2, b, d2, e, c);
      case 3:
        a: {
          kj(b);
          if (null === a2) throw Error(p2(387));
          d2 = b.pendingProps;
          f2 = b.memoizedState;
          e = f2.element;
          lh2(a2, b);
          qh(b, d2, null, c);
          var g2 = b.memoizedState;
          d2 = g2.element;
          if (f2.isDehydrated) if (f2 = { element: d2, isDehydrated: false, cache: g2.cache, pendingSuspenseBoundaries: g2.pendingSuspenseBoundaries, transitions: g2.transitions }, b.updateQueue.baseState = f2, b.memoizedState = f2, b.flags & 256) {
            e = Ji2(Error(p2(423)), b);
            b = lj(a2, b, d2, c, e);
            break a;
          } else if (d2 !== e) {
            e = Ji2(Error(p2(424)), b);
            b = lj(a2, b, d2, c, e);
            break a;
          } else for (yg2 = Lf2(b.stateNode.containerInfo.firstChild), xg2 = b, I2 = true, zg2 = null, c = Vg2(b, null, d2, c), b.child = c; c; ) c.flags = c.flags & -3 | 4096, c = c.sibling;
          else {
            Ig2();
            if (d2 === e) {
              b = Zi2(a2, b, c);
              break a;
            }
            Xi2(a2, b, d2, c);
          }
          b = b.child;
        }
        return b;
      case 5:
        return Ah(b), null === a2 && Eg2(b), d2 = b.type, e = b.pendingProps, f2 = null !== a2 ? a2.memoizedProps : null, g2 = e.children, Ef2(d2, e) ? g2 = null : null !== f2 && Ef2(d2, f2) && (b.flags |= 32), gj(a2, b), Xi2(a2, b, g2, c), b.child;
      case 6:
        return null === a2 && Eg2(b), null;
      case 13:
        return oj(a2, b, c);
      case 4:
        return yh2(b, b.stateNode.containerInfo), d2 = b.pendingProps, null === a2 ? b.child = Ug2(b, null, d2, c) : Xi2(a2, b, d2, c), b.child;
      case 11:
        return d2 = b.type, e = b.pendingProps, e = b.elementType === d2 ? e : Ci2(d2, e), Yi2(a2, b, d2, e, c);
      case 7:
        return Xi2(a2, b, b.pendingProps, c), b.child;
      case 8:
        return Xi2(a2, b, b.pendingProps.children, c), b.child;
      case 12:
        return Xi2(a2, b, b.pendingProps.children, c), b.child;
      case 10:
        a: {
          d2 = b.type._context;
          e = b.pendingProps;
          f2 = b.memoizedProps;
          g2 = e.value;
          G2(Wg2, d2._currentValue);
          d2._currentValue = g2;
          if (null !== f2) if (He2(f2.value, g2)) {
            if (f2.children === e.children && !Wf2.current) {
              b = Zi2(a2, b, c);
              break a;
            }
          } else for (f2 = b.child, null !== f2 && (f2.return = b); null !== f2; ) {
            var h2 = f2.dependencies;
            if (null !== h2) {
              g2 = f2.child;
              for (var k2 = h2.firstContext; null !== k2; ) {
                if (k2.context === d2) {
                  if (1 === f2.tag) {
                    k2 = mh2(-1, c & -c);
                    k2.tag = 2;
                    var l = f2.updateQueue;
                    if (null !== l) {
                      l = l.shared;
                      var m2 = l.pending;
                      null === m2 ? k2.next = k2 : (k2.next = m2.next, m2.next = k2);
                      l.pending = k2;
                    }
                  }
                  f2.lanes |= c;
                  k2 = f2.alternate;
                  null !== k2 && (k2.lanes |= c);
                  bh2(
                    f2.return,
                    c,
                    b
                  );
                  h2.lanes |= c;
                  break;
                }
                k2 = k2.next;
              }
            } else if (10 === f2.tag) g2 = f2.type === b.type ? null : f2.child;
            else if (18 === f2.tag) {
              g2 = f2.return;
              if (null === g2) throw Error(p2(341));
              g2.lanes |= c;
              h2 = g2.alternate;
              null !== h2 && (h2.lanes |= c);
              bh2(g2, c, b);
              g2 = f2.sibling;
            } else g2 = f2.child;
            if (null !== g2) g2.return = f2;
            else for (g2 = f2; null !== g2; ) {
              if (g2 === b) {
                g2 = null;
                break;
              }
              f2 = g2.sibling;
              if (null !== f2) {
                f2.return = g2.return;
                g2 = f2;
                break;
              }
              g2 = g2.return;
            }
            f2 = g2;
          }
          Xi2(a2, b, e.children, c);
          b = b.child;
        }
        return b;
      case 9:
        return e = b.type, d2 = b.pendingProps.children, ch2(b, c), e = eh2(e), d2 = d2(e), b.flags |= 1, Xi2(a2, b, d2, c), b.child;
      case 14:
        return d2 = b.type, e = Ci2(d2, b.pendingProps), e = Ci2(d2.type, e), $i2(a2, b, d2, e, c);
      case 15:
        return bj(a2, b, b.type, b.pendingProps, c);
      case 17:
        return d2 = b.type, e = b.pendingProps, e = b.elementType === d2 ? e : Ci2(d2, e), ij(a2, b), b.tag = 1, Zf2(d2) ? (a2 = true, cg2(b)) : a2 = false, ch2(b, c), Gi2(b, d2, e), Ii2(b, d2, e, c), jj(null, b, d2, true, a2, c);
      case 19:
        return xj(a2, b, c);
      case 22:
        return dj(a2, b, c);
    }
    throw Error(p2(156, b.tag));
  };
  function Fk(a2, b) {
    return ac2(a2, b);
  }
  function $k(a2, b, c, d2) {
    this.tag = a2;
    this.key = c;
    this.sibling = this.child = this.return = this.stateNode = this.type = this.elementType = null;
    this.index = 0;
    this.ref = null;
    this.pendingProps = b;
    this.dependencies = this.memoizedState = this.updateQueue = this.memoizedProps = null;
    this.mode = d2;
    this.subtreeFlags = this.flags = 0;
    this.deletions = null;
    this.childLanes = this.lanes = 0;
    this.alternate = null;
  }
  function Bg2(a2, b, c, d2) {
    return new $k(a2, b, c, d2);
  }
  function aj(a2) {
    a2 = a2.prototype;
    return !(!a2 || !a2.isReactComponent);
  }
  function Zk(a2) {
    if ("function" === typeof a2) return aj(a2) ? 1 : 0;
    if (void 0 !== a2 && null !== a2) {
      a2 = a2.$$typeof;
      if (a2 === Da) return 11;
      if (a2 === Ga2) return 14;
    }
    return 2;
  }
  function Pg2(a2, b) {
    var c = a2.alternate;
    null === c ? (c = Bg2(a2.tag, b, a2.key, a2.mode), c.elementType = a2.elementType, c.type = a2.type, c.stateNode = a2.stateNode, c.alternate = a2, a2.alternate = c) : (c.pendingProps = b, c.type = a2.type, c.flags = 0, c.subtreeFlags = 0, c.deletions = null);
    c.flags = a2.flags & 14680064;
    c.childLanes = a2.childLanes;
    c.lanes = a2.lanes;
    c.child = a2.child;
    c.memoizedProps = a2.memoizedProps;
    c.memoizedState = a2.memoizedState;
    c.updateQueue = a2.updateQueue;
    b = a2.dependencies;
    c.dependencies = null === b ? null : { lanes: b.lanes, firstContext: b.firstContext };
    c.sibling = a2.sibling;
    c.index = a2.index;
    c.ref = a2.ref;
    return c;
  }
  function Rg2(a2, b, c, d2, e, f2) {
    var g2 = 2;
    d2 = a2;
    if ("function" === typeof a2) aj(a2) && (g2 = 1);
    else if ("string" === typeof a2) g2 = 5;
    else a: switch (a2) {
      case ya:
        return Tg2(c.children, e, f2, b);
      case za:
        g2 = 8;
        e |= 8;
        break;
      case Aa2:
        return a2 = Bg2(12, c, b, e | 2), a2.elementType = Aa2, a2.lanes = f2, a2;
      case Ea:
        return a2 = Bg2(13, c, b, e), a2.elementType = Ea, a2.lanes = f2, a2;
      case Fa2:
        return a2 = Bg2(19, c, b, e), a2.elementType = Fa2, a2.lanes = f2, a2;
      case Ia:
        return pj(c, e, f2, b);
      default:
        if ("object" === typeof a2 && null !== a2) switch (a2.$$typeof) {
          case Ba2:
            g2 = 10;
            break a;
          case Ca2:
            g2 = 9;
            break a;
          case Da:
            g2 = 11;
            break a;
          case Ga2:
            g2 = 14;
            break a;
          case Ha2:
            g2 = 16;
            d2 = null;
            break a;
        }
        throw Error(p2(130, null == a2 ? a2 : typeof a2, ""));
    }
    b = Bg2(g2, c, b, e);
    b.elementType = a2;
    b.type = d2;
    b.lanes = f2;
    return b;
  }
  function Tg2(a2, b, c, d2) {
    a2 = Bg2(7, a2, d2, b);
    a2.lanes = c;
    return a2;
  }
  function pj(a2, b, c, d2) {
    a2 = Bg2(22, a2, d2, b);
    a2.elementType = Ia;
    a2.lanes = c;
    a2.stateNode = { isHidden: false };
    return a2;
  }
  function Qg2(a2, b, c) {
    a2 = Bg2(6, a2, null, b);
    a2.lanes = c;
    return a2;
  }
  function Sg2(a2, b, c) {
    b = Bg2(4, null !== a2.children ? a2.children : [], a2.key, b);
    b.lanes = c;
    b.stateNode = { containerInfo: a2.containerInfo, pendingChildren: null, implementation: a2.implementation };
    return b;
  }
  function al2(a2, b, c, d2, e) {
    this.tag = b;
    this.containerInfo = a2;
    this.finishedWork = this.pingCache = this.current = this.pendingChildren = null;
    this.timeoutHandle = -1;
    this.callbackNode = this.pendingContext = this.context = null;
    this.callbackPriority = 0;
    this.eventTimes = zc2(0);
    this.expirationTimes = zc2(-1);
    this.entangledLanes = this.finishedLanes = this.mutableReadLanes = this.expiredLanes = this.pingedLanes = this.suspendedLanes = this.pendingLanes = 0;
    this.entanglements = zc2(0);
    this.identifierPrefix = d2;
    this.onRecoverableError = e;
    this.mutableSourceEagerHydrationData = null;
  }
  function bl2(a2, b, c, d2, e, f2, g2, h2, k2) {
    a2 = new al2(a2, b, c, h2, k2);
    1 === b ? (b = 1, true === f2 && (b |= 8)) : b = 0;
    f2 = Bg2(3, null, null, b);
    a2.current = f2;
    f2.stateNode = a2;
    f2.memoizedState = { element: d2, isDehydrated: c, cache: null, transitions: null, pendingSuspenseBoundaries: null };
    kh(f2);
    return a2;
  }
  function cl2(a2, b, c) {
    var d2 = 3 < arguments.length && void 0 !== arguments[3] ? arguments[3] : null;
    return { $$typeof: wa, key: null == d2 ? null : "" + d2, children: a2, containerInfo: b, implementation: c };
  }
  function dl2(a2) {
    if (!a2) return Vf2;
    a2 = a2._reactInternals;
    a: {
      if (Vb(a2) !== a2 || 1 !== a2.tag) throw Error(p2(170));
      var b = a2;
      do {
        switch (b.tag) {
          case 3:
            b = b.stateNode.context;
            break a;
          case 1:
            if (Zf2(b.type)) {
              b = b.stateNode.__reactInternalMemoizedMergedChildContext;
              break a;
            }
        }
        b = b.return;
      } while (null !== b);
      throw Error(p2(171));
    }
    if (1 === a2.tag) {
      var c = a2.type;
      if (Zf2(c)) return bg2(a2, c, b);
    }
    return b;
  }
  function el2(a2, b, c, d2, e, f2, g2, h2, k2) {
    a2 = bl2(c, d2, true, a2, e, f2, g2, h2, k2);
    a2.context = dl2(null);
    c = a2.current;
    d2 = R2();
    e = yi2(c);
    f2 = mh2(d2, e);
    f2.callback = void 0 !== b && null !== b ? b : null;
    nh2(c, f2, e);
    a2.current.lanes = e;
    Ac2(a2, e, d2);
    Dk(a2, d2);
    return a2;
  }
  function fl2(a2, b, c, d2) {
    var e = b.current, f2 = R2(), g2 = yi2(e);
    c = dl2(c);
    null === b.context ? b.context = c : b.pendingContext = c;
    b = mh2(f2, g2);
    b.payload = { element: a2 };
    d2 = void 0 === d2 ? null : d2;
    null !== d2 && (b.callback = d2);
    a2 = nh2(e, b, g2);
    null !== a2 && (gi2(a2, e, g2, f2), oh2(a2, e, g2));
    return g2;
  }
  function gl2(a2) {
    a2 = a2.current;
    if (!a2.child) return null;
    switch (a2.child.tag) {
      case 5:
        return a2.child.stateNode;
      default:
        return a2.child.stateNode;
    }
  }
  function hl2(a2, b) {
    a2 = a2.memoizedState;
    if (null !== a2 && null !== a2.dehydrated) {
      var c = a2.retryLane;
      a2.retryLane = 0 !== c && c < b ? c : b;
    }
  }
  function il2(a2, b) {
    hl2(a2, b);
    (a2 = a2.alternate) && hl2(a2, b);
  }
  function jl2() {
    return null;
  }
  var kl2 = "function" === typeof reportError ? reportError : function(a2) {
    console.error(a2);
  };
  function ll2(a2) {
    this._internalRoot = a2;
  }
  ml2.prototype.render = ll2.prototype.render = function(a2) {
    var b = this._internalRoot;
    if (null === b) throw Error(p2(409));
    fl2(a2, b, null, null);
  };
  ml2.prototype.unmount = ll2.prototype.unmount = function() {
    var a2 = this._internalRoot;
    if (null !== a2) {
      this._internalRoot = null;
      var b = a2.containerInfo;
      Rk(function() {
        fl2(null, a2, null, null);
      });
      b[uf] = null;
    }
  };
  function ml2(a2) {
    this._internalRoot = a2;
  }
  ml2.prototype.unstable_scheduleHydration = function(a2) {
    if (a2) {
      var b = Hc2();
      a2 = { blockedOn: null, target: a2, priority: b };
      for (var c = 0; c < Qc2.length && 0 !== b && b < Qc2[c].priority; c++) ;
      Qc2.splice(c, 0, a2);
      0 === c && Vc2(a2);
    }
  };
  function nl2(a2) {
    return !(!a2 || 1 !== a2.nodeType && 9 !== a2.nodeType && 11 !== a2.nodeType);
  }
  function ol2(a2) {
    return !(!a2 || 1 !== a2.nodeType && 9 !== a2.nodeType && 11 !== a2.nodeType && (8 !== a2.nodeType || " react-mount-point-unstable " !== a2.nodeValue));
  }
  function pl2() {
  }
  function ql2(a2, b, c, d2, e) {
    if (e) {
      if ("function" === typeof d2) {
        var f2 = d2;
        d2 = function() {
          var a3 = gl2(g2);
          f2.call(a3);
        };
      }
      var g2 = el2(b, d2, a2, 0, null, false, false, "", pl2);
      a2._reactRootContainer = g2;
      a2[uf] = g2.current;
      sf(8 === a2.nodeType ? a2.parentNode : a2);
      Rk();
      return g2;
    }
    for (; e = a2.lastChild; ) a2.removeChild(e);
    if ("function" === typeof d2) {
      var h2 = d2;
      d2 = function() {
        var a3 = gl2(k2);
        h2.call(a3);
      };
    }
    var k2 = bl2(a2, 0, false, null, null, false, false, "", pl2);
    a2._reactRootContainer = k2;
    a2[uf] = k2.current;
    sf(8 === a2.nodeType ? a2.parentNode : a2);
    Rk(function() {
      fl2(b, k2, c, d2);
    });
    return k2;
  }
  function rl2(a2, b, c, d2, e) {
    var f2 = c._reactRootContainer;
    if (f2) {
      var g2 = f2;
      if ("function" === typeof e) {
        var h2 = e;
        e = function() {
          var a3 = gl2(g2);
          h2.call(a3);
        };
      }
      fl2(b, g2, a2, e);
    } else g2 = ql2(c, b, a2, e, d2);
    return gl2(g2);
  }
  Ec2 = function(a2) {
    switch (a2.tag) {
      case 3:
        var b = a2.stateNode;
        if (b.current.memoizedState.isDehydrated) {
          var c = tc2(b.pendingLanes);
          0 !== c && (Cc2(b, c | 1), Dk(b, B2()), 0 === (K2 & 6) && (Gj = B2() + 500, jg2()));
        }
        break;
      case 13:
        Rk(function() {
          var b2 = ih2(a2, 1);
          if (null !== b2) {
            var c2 = R2();
            gi2(b2, a2, 1, c2);
          }
        }), il2(a2, 1);
    }
  };
  Fc2 = function(a2) {
    if (13 === a2.tag) {
      var b = ih2(a2, 134217728);
      if (null !== b) {
        var c = R2();
        gi2(b, a2, 134217728, c);
      }
      il2(a2, 134217728);
    }
  };
  Gc2 = function(a2) {
    if (13 === a2.tag) {
      var b = yi2(a2), c = ih2(a2, b);
      if (null !== c) {
        var d2 = R2();
        gi2(c, a2, b, d2);
      }
      il2(a2, b);
    }
  };
  Hc2 = function() {
    return C;
  };
  Ic2 = function(a2, b) {
    var c = C;
    try {
      return C = a2, b();
    } finally {
      C = c;
    }
  };
  yb = function(a2, b, c) {
    switch (b) {
      case "input":
        bb(a2, c);
        b = c.name;
        if ("radio" === c.type && null != b) {
          for (c = a2; c.parentNode; ) c = c.parentNode;
          c = c.querySelectorAll("input[name=" + JSON.stringify("" + b) + '][type="radio"]');
          for (b = 0; b < c.length; b++) {
            var d2 = c[b];
            if (d2 !== a2 && d2.form === a2.form) {
              var e = Db(d2);
              if (!e) throw Error(p2(90));
              Wa2(d2);
              bb(d2, e);
            }
          }
        }
        break;
      case "textarea":
        ib(a2, c);
        break;
      case "select":
        b = c.value, null != b && fb(a2, !!c.multiple, b, false);
    }
  };
  Gb = Qk;
  Hb = Rk;
  var sl2 = { usingClientEntryPoint: false, Events: [Cb, ue2, Db, Eb, Fb, Qk] }, tl2 = { findFiberByHostInstance: Wc2, bundleType: 0, version: "18.3.1", rendererPackageName: "react-dom" };
  var ul2 = { bundleType: tl2.bundleType, version: tl2.version, rendererPackageName: tl2.rendererPackageName, rendererConfig: tl2.rendererConfig, overrideHookState: null, overrideHookStateDeletePath: null, overrideHookStateRenamePath: null, overrideProps: null, overridePropsDeletePath: null, overridePropsRenamePath: null, setErrorHandler: null, setSuspenseHandler: null, scheduleUpdate: null, currentDispatcherRef: ua2.ReactCurrentDispatcher, findHostInstanceByFiber: function(a2) {
    a2 = Zb(a2);
    return null === a2 ? null : a2.stateNode;
  }, findFiberByHostInstance: tl2.findFiberByHostInstance || jl2, findHostInstancesForRefresh: null, scheduleRefresh: null, scheduleRoot: null, setRefreshHandler: null, getCurrentFiber: null, reconcilerVersion: "18.3.1-next-f1338f8080-20240426" };
  if ("undefined" !== typeof __REACT_DEVTOOLS_GLOBAL_HOOK__) {
    var vl2 = __REACT_DEVTOOLS_GLOBAL_HOOK__;
    if (!vl2.isDisabled && vl2.supportsFiber) try {
      kc2 = vl2.inject(ul2), lc2 = vl2;
    } catch (a2) {
    }
  }
  reactDom_production_min.__SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED = sl2;
  reactDom_production_min.createPortal = function(a2, b) {
    var c = 2 < arguments.length && void 0 !== arguments[2] ? arguments[2] : null;
    if (!nl2(b)) throw Error(p2(200));
    return cl2(a2, b, null, c);
  };
  reactDom_production_min.createRoot = function(a2, b) {
    if (!nl2(a2)) throw Error(p2(299));
    var c = false, d2 = "", e = kl2;
    null !== b && void 0 !== b && (true === b.unstable_strictMode && (c = true), void 0 !== b.identifierPrefix && (d2 = b.identifierPrefix), void 0 !== b.onRecoverableError && (e = b.onRecoverableError));
    b = bl2(a2, 1, false, null, null, c, false, d2, e);
    a2[uf] = b.current;
    sf(8 === a2.nodeType ? a2.parentNode : a2);
    return new ll2(b);
  };
  reactDom_production_min.findDOMNode = function(a2) {
    if (null == a2) return null;
    if (1 === a2.nodeType) return a2;
    var b = a2._reactInternals;
    if (void 0 === b) {
      if ("function" === typeof a2.render) throw Error(p2(188));
      a2 = Object.keys(a2).join(",");
      throw Error(p2(268, a2));
    }
    a2 = Zb(b);
    a2 = null === a2 ? null : a2.stateNode;
    return a2;
  };
  reactDom_production_min.flushSync = function(a2) {
    return Rk(a2);
  };
  reactDom_production_min.hydrate = function(a2, b, c) {
    if (!ol2(b)) throw Error(p2(200));
    return rl2(null, a2, b, true, c);
  };
  reactDom_production_min.hydrateRoot = function(a2, b, c) {
    if (!nl2(a2)) throw Error(p2(405));
    var d2 = null != c && c.hydratedSources || null, e = false, f2 = "", g2 = kl2;
    null !== c && void 0 !== c && (true === c.unstable_strictMode && (e = true), void 0 !== c.identifierPrefix && (f2 = c.identifierPrefix), void 0 !== c.onRecoverableError && (g2 = c.onRecoverableError));
    b = el2(b, null, a2, 1, null != c ? c : null, e, false, f2, g2);
    a2[uf] = b.current;
    sf(a2);
    if (d2) for (a2 = 0; a2 < d2.length; a2++) c = d2[a2], e = c._getVersion, e = e(c._source), null == b.mutableSourceEagerHydrationData ? b.mutableSourceEagerHydrationData = [c, e] : b.mutableSourceEagerHydrationData.push(
      c,
      e
    );
    return new ml2(b);
  };
  reactDom_production_min.render = function(a2, b, c) {
    if (!ol2(b)) throw Error(p2(200));
    return rl2(null, a2, b, false, c);
  };
  reactDom_production_min.unmountComponentAtNode = function(a2) {
    if (!ol2(a2)) throw Error(p2(40));
    return a2._reactRootContainer ? (Rk(function() {
      rl2(null, null, a2, false, function() {
        a2._reactRootContainer = null;
        a2[uf] = null;
      });
    }), true) : false;
  };
  reactDom_production_min.unstable_batchedUpdates = Qk;
  reactDom_production_min.unstable_renderSubtreeIntoContainer = function(a2, b, c, d2) {
    if (!ol2(c)) throw Error(p2(200));
    if (null == a2 || void 0 === a2._reactInternals) throw Error(p2(38));
    return rl2(a2, b, c, false, d2);
  };
  reactDom_production_min.version = "18.3.1-next-f1338f8080-20240426";
  return reactDom_production_min;
}
var hasRequiredReactDom;
function requireReactDom() {
  if (hasRequiredReactDom) return reactDom.exports;
  hasRequiredReactDom = 1;
  function checkDCE() {
    if (typeof __REACT_DEVTOOLS_GLOBAL_HOOK__ === "undefined" || typeof __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE !== "function") {
      return;
    }
    try {
      __REACT_DEVTOOLS_GLOBAL_HOOK__.checkDCE(checkDCE);
    } catch (err) {
      console.error(err);
    }
  }
  {
    checkDCE();
    reactDom.exports = requireReactDom_production_min();
  }
  return reactDom.exports;
}
var hasRequiredClient;
function requireClient() {
  if (hasRequiredClient) return client;
  hasRequiredClient = 1;
  var m2 = requireReactDom();
  {
    client.createRoot = m2.createRoot;
    client.hydrateRoot = m2.hydrateRoot;
  }
  return client;
}
var clientExports = requireClient();
const TOAST_LIMIT = 1;
const TOAST_REMOVE_DELAY = 1e6;
let count$2 = 0;
function genId() {
  count$2 = (count$2 + 1) % Number.MAX_SAFE_INTEGER;
  return count$2.toString();
}
const toastTimeouts = /* @__PURE__ */ new Map();
const addToRemoveQueue = (toastId) => {
  if (toastTimeouts.has(toastId)) {
    return;
  }
  const timeout = setTimeout(() => {
    toastTimeouts.delete(toastId);
    dispatch({
      type: "REMOVE_TOAST",
      toastId
    });
  }, TOAST_REMOVE_DELAY);
  toastTimeouts.set(toastId, timeout);
};
const reducer = (state, action) => {
  switch (action.type) {
    case "ADD_TOAST":
      return {
        ...state,
        toasts: [action.toast, ...state.toasts].slice(0, TOAST_LIMIT)
      };
    case "UPDATE_TOAST":
      return {
        ...state,
        toasts: state.toasts.map(
          (t) => t.id === action.toast.id ? { ...t, ...action.toast } : t
        )
      };
    case "DISMISS_TOAST": {
      const { toastId } = action;
      if (toastId) {
        addToRemoveQueue(toastId);
      } else {
        state.toasts.forEach((toast2) => {
          addToRemoveQueue(toast2.id);
        });
      }
      return {
        ...state,
        toasts: state.toasts.map(
          (t) => t.id === toastId || toastId === void 0 ? {
            ...t,
            open: false
          } : t
        )
      };
    }
    case "REMOVE_TOAST":
      if (action.toastId === void 0) {
        return {
          ...state,
          toasts: []
        };
      }
      return {
        ...state,
        toasts: state.toasts.filter((t) => t.id !== action.toastId)
      };
  }
};
const listeners = [];
let memoryState = { toasts: [] };
function dispatch(action) {
  memoryState = reducer(memoryState, action);
  listeners.forEach((listener) => {
    listener(memoryState);
  });
}
function toast({ ...props }) {
  const id2 = genId();
  const update = (props2) => dispatch({
    type: "UPDATE_TOAST",
    toast: { ...props2, id: id2 }
  });
  const dismiss = () => dispatch({ type: "DISMISS_TOAST", toastId: id2 });
  dispatch({
    type: "ADD_TOAST",
    toast: {
      ...props,
      id: id2,
      open: true,
      onOpenChange: (open) => {
        if (!open) dismiss();
      }
    }
  });
  return {
    id: id2,
    dismiss,
    update
  };
}
function useToast() {
  const [state, setState] = reactExports.useState(memoryState);
  reactExports.useEffect(() => {
    listeners.push(setState);
    return () => {
      const index2 = listeners.indexOf(setState);
      if (index2 > -1) {
        listeners.splice(index2, 1);
      }
    };
  }, [state]);
  return {
    ...state,
    toast,
    dismiss: (toastId) => dispatch({ type: "DISMISS_TOAST", toastId })
  };
}
var reactDomExports = requireReactDom();
const ReactDOM = /* @__PURE__ */ getDefaultExportFromCjs(reactDomExports);
function composeEventHandlers(originalEventHandler, ourEventHandler, { checkForDefaultPrevented = true } = {}) {
  return function handleEvent(event) {
    originalEventHandler?.(event);
    if (checkForDefaultPrevented === false || !event.defaultPrevented) {
      return ourEventHandler?.(event);
    }
  };
}
function setRef(ref2, value) {
  if (typeof ref2 === "function") {
    return ref2(value);
  } else if (ref2 !== null && ref2 !== void 0) {
    ref2.current = value;
  }
}
function composeRefs(...refs) {
  return (node) => {
    let hasCleanup = false;
    const cleanups = refs.map((ref2) => {
      const cleanup = setRef(ref2, node);
      if (!hasCleanup && typeof cleanup == "function") {
        hasCleanup = true;
      }
      return cleanup;
    });
    if (hasCleanup) {
      return () => {
        for (let i = 0; i < cleanups.length; i++) {
          const cleanup = cleanups[i];
          if (typeof cleanup == "function") {
            cleanup();
          } else {
            setRef(refs[i], null);
          }
        }
      };
    }
  };
}
function useComposedRefs(...refs) {
  return reactExports.useCallback(composeRefs(...refs), refs);
}
function createContext2(rootComponentName, defaultContext) {
  const Context = reactExports.createContext(defaultContext);
  const Provider2 = (props) => {
    const { children, ...context } = props;
    const value = reactExports.useMemo(() => context, Object.values(context));
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Context.Provider, { value, children });
  };
  Provider2.displayName = rootComponentName + "Provider";
  function useContext2(consumerName) {
    const context = reactExports.useContext(Context);
    if (context) return context;
    if (defaultContext !== void 0) return defaultContext;
    throw new Error(`\`${consumerName}\` must be used within \`${rootComponentName}\``);
  }
  return [Provider2, useContext2];
}
function createContextScope(scopeName, createContextScopeDeps = []) {
  let defaultContexts = [];
  function createContext3(rootComponentName, defaultContext) {
    const BaseContext = reactExports.createContext(defaultContext);
    const index2 = defaultContexts.length;
    defaultContexts = [...defaultContexts, defaultContext];
    const Provider2 = (props) => {
      const { scope: scope2, children, ...context } = props;
      const Context = scope2?.[scopeName]?.[index2] || BaseContext;
      const value = reactExports.useMemo(() => context, Object.values(context));
      return /* @__PURE__ */ jsxRuntimeExports.jsx(Context.Provider, { value, children });
    };
    Provider2.displayName = rootComponentName + "Provider";
    function useContext2(consumerName, scope2) {
      const Context = scope2?.[scopeName]?.[index2] || BaseContext;
      const context = reactExports.useContext(Context);
      if (context) return context;
      if (defaultContext !== void 0) return defaultContext;
      throw new Error(`\`${consumerName}\` must be used within \`${rootComponentName}\``);
    }
    return [Provider2, useContext2];
  }
  const createScope = () => {
    const scopeContexts = defaultContexts.map((defaultContext) => {
      return reactExports.createContext(defaultContext);
    });
    return function useScope(scope2) {
      const contexts = scope2?.[scopeName] || scopeContexts;
      return reactExports.useMemo(
        () => ({ [`__scope${scopeName}`]: { ...scope2, [scopeName]: contexts } }),
        [scope2, contexts]
      );
    };
  };
  createScope.scopeName = scopeName;
  return [createContext3, composeContextScopes(createScope, ...createContextScopeDeps)];
}
function composeContextScopes(...scopes) {
  const baseScope = scopes[0];
  if (scopes.length === 1) return baseScope;
  const createScope = () => {
    const scopeHooks = scopes.map((createScope2) => ({
      useScope: createScope2(),
      scopeName: createScope2.scopeName
    }));
    return function useComposedScopes(overrideScopes) {
      const nextScopes = scopeHooks.reduce((nextScopes2, { useScope, scopeName }) => {
        const scopeProps = useScope(overrideScopes);
        const currentScope = scopeProps[`__scope${scopeName}`];
        return { ...nextScopes2, ...currentScope };
      }, {});
      return reactExports.useMemo(() => ({ [`__scope${baseScope.scopeName}`]: nextScopes }), [nextScopes]);
    };
  };
  createScope.scopeName = baseScope.scopeName;
  return createScope;
}
// @__NO_SIDE_EFFECTS__
function createSlot$5(ownerName) {
  const SlotClone = /* @__PURE__ */ createSlotClone$5(ownerName);
  const Slot2 = reactExports.forwardRef((props, forwardedRef) => {
    const { children, ...slotProps } = props;
    const childrenArray = reactExports.Children.toArray(children);
    const slottable = childrenArray.find(isSlottable$5);
    if (slottable) {
      const newElement = slottable.props.children;
      const newChildren = childrenArray.map((child) => {
        if (child === slottable) {
          if (reactExports.Children.count(newElement) > 1) return reactExports.Children.only(null);
          return reactExports.isValidElement(newElement) ? newElement.props.children : null;
        } else {
          return child;
        }
      });
      return /* @__PURE__ */ jsxRuntimeExports.jsx(SlotClone, { ...slotProps, ref: forwardedRef, children: reactExports.isValidElement(newElement) ? reactExports.cloneElement(newElement, void 0, newChildren) : null });
    }
    return /* @__PURE__ */ jsxRuntimeExports.jsx(SlotClone, { ...slotProps, ref: forwardedRef, children });
  });
  Slot2.displayName = `${ownerName}.Slot`;
  return Slot2;
}
// @__NO_SIDE_EFFECTS__
function createSlotClone$5(ownerName) {
  const SlotClone = reactExports.forwardRef((props, forwardedRef) => {
    const { children, ...slotProps } = props;
    if (reactExports.isValidElement(children)) {
      const childrenRef = getElementRef$6(children);
      const props2 = mergeProps$5(slotProps, children.props);
      if (children.type !== reactExports.Fragment) {
        props2.ref = forwardedRef ? composeRefs(forwardedRef, childrenRef) : childrenRef;
      }
      return reactExports.cloneElement(children, props2);
    }
    return reactExports.Children.count(children) > 1 ? reactExports.Children.only(null) : null;
  });
  SlotClone.displayName = `${ownerName}.SlotClone`;
  return SlotClone;
}
var SLOTTABLE_IDENTIFIER$6 = /* @__PURE__ */ Symbol("radix.slottable");
function isSlottable$5(child) {
  return reactExports.isValidElement(child) && typeof child.type === "function" && "__radixId" in child.type && child.type.__radixId === SLOTTABLE_IDENTIFIER$6;
}
function mergeProps$5(slotProps, childProps) {
  const overrideProps = { ...childProps };
  for (const propName in childProps) {
    const slotPropValue = slotProps[propName];
    const childPropValue = childProps[propName];
    const isHandler = /^on[A-Z]/.test(propName);
    if (isHandler) {
      if (slotPropValue && childPropValue) {
        overrideProps[propName] = (...args) => {
          const result = childPropValue(...args);
          slotPropValue(...args);
          return result;
        };
      } else if (slotPropValue) {
        overrideProps[propName] = slotPropValue;
      }
    } else if (propName === "style") {
      overrideProps[propName] = { ...slotPropValue, ...childPropValue };
    } else if (propName === "className") {
      overrideProps[propName] = [slotPropValue, childPropValue].filter(Boolean).join(" ");
    }
  }
  return { ...slotProps, ...overrideProps };
}
function getElementRef$6(element) {
  let getter = Object.getOwnPropertyDescriptor(element.props, "ref")?.get;
  let mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
  if (mayWarn) {
    return element.ref;
  }
  getter = Object.getOwnPropertyDescriptor(element, "ref")?.get;
  mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
  if (mayWarn) {
    return element.props.ref;
  }
  return element.props.ref || element.ref;
}
function createCollection(name2) {
  const PROVIDER_NAME2 = name2 + "CollectionProvider";
  const [createCollectionContext, createCollectionScope2] = createContextScope(PROVIDER_NAME2);
  const [CollectionProviderImpl, useCollectionContext] = createCollectionContext(
    PROVIDER_NAME2,
    { collectionRef: { current: null }, itemMap: /* @__PURE__ */ new Map() }
  );
  const CollectionProvider = (props) => {
    const { scope: scope2, children } = props;
    const ref2 = React.useRef(null);
    const itemMap = React.useRef(/* @__PURE__ */ new Map()).current;
    return /* @__PURE__ */ jsxRuntimeExports.jsx(CollectionProviderImpl, { scope: scope2, itemMap, collectionRef: ref2, children });
  };
  CollectionProvider.displayName = PROVIDER_NAME2;
  const COLLECTION_SLOT_NAME = name2 + "CollectionSlot";
  const CollectionSlotImpl = /* @__PURE__ */ createSlot$5(COLLECTION_SLOT_NAME);
  const CollectionSlot = React.forwardRef(
    (props, forwardedRef) => {
      const { scope: scope2, children } = props;
      const context = useCollectionContext(COLLECTION_SLOT_NAME, scope2);
      const composedRefs = useComposedRefs(forwardedRef, context.collectionRef);
      return /* @__PURE__ */ jsxRuntimeExports.jsx(CollectionSlotImpl, { ref: composedRefs, children });
    }
  );
  CollectionSlot.displayName = COLLECTION_SLOT_NAME;
  const ITEM_SLOT_NAME = name2 + "CollectionItemSlot";
  const ITEM_DATA_ATTR = "data-radix-collection-item";
  const CollectionItemSlotImpl = /* @__PURE__ */ createSlot$5(ITEM_SLOT_NAME);
  const CollectionItemSlot = React.forwardRef(
    (props, forwardedRef) => {
      const { scope: scope2, children, ...itemData } = props;
      const ref2 = React.useRef(null);
      const composedRefs = useComposedRefs(forwardedRef, ref2);
      const context = useCollectionContext(ITEM_SLOT_NAME, scope2);
      React.useEffect(() => {
        context.itemMap.set(ref2, { ref: ref2, ...itemData });
        return () => void context.itemMap.delete(ref2);
      });
      return /* @__PURE__ */ jsxRuntimeExports.jsx(CollectionItemSlotImpl, { ...{ [ITEM_DATA_ATTR]: "" }, ref: composedRefs, children });
    }
  );
  CollectionItemSlot.displayName = ITEM_SLOT_NAME;
  function useCollection2(scope2) {
    const context = useCollectionContext(name2 + "CollectionConsumer", scope2);
    const getItems = React.useCallback(() => {
      const collectionNode = context.collectionRef.current;
      if (!collectionNode) return [];
      const orderedNodes = Array.from(collectionNode.querySelectorAll(`[${ITEM_DATA_ATTR}]`));
      const items2 = Array.from(context.itemMap.values());
      const orderedItems = items2.sort(
        (a2, b) => orderedNodes.indexOf(a2.ref.current) - orderedNodes.indexOf(b.ref.current)
      );
      return orderedItems;
    }, [context.collectionRef, context.itemMap]);
    return getItems;
  }
  return [
    { Provider: CollectionProvider, Slot: CollectionSlot, ItemSlot: CollectionItemSlot },
    useCollection2,
    createCollectionScope2
  ];
}
// @__NO_SIDE_EFFECTS__
function createSlot$4(ownerName) {
  const SlotClone = /* @__PURE__ */ createSlotClone$4(ownerName);
  const Slot2 = reactExports.forwardRef((props, forwardedRef) => {
    const { children, ...slotProps } = props;
    const childrenArray = reactExports.Children.toArray(children);
    const slottable = childrenArray.find(isSlottable$4);
    if (slottable) {
      const newElement = slottable.props.children;
      const newChildren = childrenArray.map((child) => {
        if (child === slottable) {
          if (reactExports.Children.count(newElement) > 1) return reactExports.Children.only(null);
          return reactExports.isValidElement(newElement) ? newElement.props.children : null;
        } else {
          return child;
        }
      });
      return /* @__PURE__ */ jsxRuntimeExports.jsx(SlotClone, { ...slotProps, ref: forwardedRef, children: reactExports.isValidElement(newElement) ? reactExports.cloneElement(newElement, void 0, newChildren) : null });
    }
    return /* @__PURE__ */ jsxRuntimeExports.jsx(SlotClone, { ...slotProps, ref: forwardedRef, children });
  });
  Slot2.displayName = `${ownerName}.Slot`;
  return Slot2;
}
// @__NO_SIDE_EFFECTS__
function createSlotClone$4(ownerName) {
  const SlotClone = reactExports.forwardRef((props, forwardedRef) => {
    const { children, ...slotProps } = props;
    if (reactExports.isValidElement(children)) {
      const childrenRef = getElementRef$5(children);
      const props2 = mergeProps$4(slotProps, children.props);
      if (children.type !== reactExports.Fragment) {
        props2.ref = forwardedRef ? composeRefs(forwardedRef, childrenRef) : childrenRef;
      }
      return reactExports.cloneElement(children, props2);
    }
    return reactExports.Children.count(children) > 1 ? reactExports.Children.only(null) : null;
  });
  SlotClone.displayName = `${ownerName}.SlotClone`;
  return SlotClone;
}
var SLOTTABLE_IDENTIFIER$5 = /* @__PURE__ */ Symbol("radix.slottable");
function isSlottable$4(child) {
  return reactExports.isValidElement(child) && typeof child.type === "function" && "__radixId" in child.type && child.type.__radixId === SLOTTABLE_IDENTIFIER$5;
}
function mergeProps$4(slotProps, childProps) {
  const overrideProps = { ...childProps };
  for (const propName in childProps) {
    const slotPropValue = slotProps[propName];
    const childPropValue = childProps[propName];
    const isHandler = /^on[A-Z]/.test(propName);
    if (isHandler) {
      if (slotPropValue && childPropValue) {
        overrideProps[propName] = (...args) => {
          const result = childPropValue(...args);
          slotPropValue(...args);
          return result;
        };
      } else if (slotPropValue) {
        overrideProps[propName] = slotPropValue;
      }
    } else if (propName === "style") {
      overrideProps[propName] = { ...slotPropValue, ...childPropValue };
    } else if (propName === "className") {
      overrideProps[propName] = [slotPropValue, childPropValue].filter(Boolean).join(" ");
    }
  }
  return { ...slotProps, ...overrideProps };
}
function getElementRef$5(element) {
  let getter = Object.getOwnPropertyDescriptor(element.props, "ref")?.get;
  let mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
  if (mayWarn) {
    return element.ref;
  }
  getter = Object.getOwnPropertyDescriptor(element, "ref")?.get;
  mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
  if (mayWarn) {
    return element.props.ref;
  }
  return element.props.ref || element.ref;
}
var NODES$1 = [
  "a",
  "button",
  "div",
  "form",
  "h2",
  "h3",
  "img",
  "input",
  "label",
  "li",
  "nav",
  "ol",
  "p",
  "select",
  "span",
  "svg",
  "ul"
];
var Primitive$1 = NODES$1.reduce((primitive, node) => {
  const Slot2 = /* @__PURE__ */ createSlot$4(`Primitive.${node}`);
  const Node2 = reactExports.forwardRef((props, forwardedRef) => {
    const { asChild, ...primitiveProps } = props;
    const Comp = asChild ? Slot2 : node;
    if (typeof window !== "undefined") {
      window[/* @__PURE__ */ Symbol.for("radix-ui")] = true;
    }
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Comp, { ...primitiveProps, ref: forwardedRef });
  });
  Node2.displayName = `Primitive.${node}`;
  return { ...primitive, [node]: Node2 };
}, {});
function dispatchDiscreteCustomEvent(target, event) {
  if (target) reactDomExports.flushSync(() => target.dispatchEvent(event));
}
function useCallbackRef$1(callback) {
  const callbackRef = reactExports.useRef(callback);
  reactExports.useEffect(() => {
    callbackRef.current = callback;
  });
  return reactExports.useMemo(() => (...args) => callbackRef.current?.(...args), []);
}
function useEscapeKeydown(onEscapeKeyDownProp, ownerDocument = globalThis?.document) {
  const onEscapeKeyDown = useCallbackRef$1(onEscapeKeyDownProp);
  reactExports.useEffect(() => {
    const handleKeyDown = (event) => {
      if (event.key === "Escape") {
        onEscapeKeyDown(event);
      }
    };
    ownerDocument.addEventListener("keydown", handleKeyDown, { capture: true });
    return () => ownerDocument.removeEventListener("keydown", handleKeyDown, { capture: true });
  }, [onEscapeKeyDown, ownerDocument]);
}
var DISMISSABLE_LAYER_NAME = "DismissableLayer";
var CONTEXT_UPDATE = "dismissableLayer.update";
var POINTER_DOWN_OUTSIDE = "dismissableLayer.pointerDownOutside";
var FOCUS_OUTSIDE = "dismissableLayer.focusOutside";
var originalBodyPointerEvents;
var DismissableLayerContext = reactExports.createContext({
  layers: /* @__PURE__ */ new Set(),
  layersWithOutsidePointerEventsDisabled: /* @__PURE__ */ new Set(),
  branches: /* @__PURE__ */ new Set()
});
var DismissableLayer = reactExports.forwardRef(
  (props, forwardedRef) => {
    const {
      disableOutsidePointerEvents = false,
      onEscapeKeyDown,
      onPointerDownOutside,
      onFocusOutside,
      onInteractOutside,
      onDismiss,
      ...layerProps
    } = props;
    const context = reactExports.useContext(DismissableLayerContext);
    const [node, setNode] = reactExports.useState(null);
    const ownerDocument = node?.ownerDocument ?? globalThis?.document;
    const [, force] = reactExports.useState({});
    const composedRefs = useComposedRefs(forwardedRef, (node2) => setNode(node2));
    const layers = Array.from(context.layers);
    const [highestLayerWithOutsidePointerEventsDisabled] = [...context.layersWithOutsidePointerEventsDisabled].slice(-1);
    const highestLayerWithOutsidePointerEventsDisabledIndex = layers.indexOf(highestLayerWithOutsidePointerEventsDisabled);
    const index2 = node ? layers.indexOf(node) : -1;
    const isBodyPointerEventsDisabled = context.layersWithOutsidePointerEventsDisabled.size > 0;
    const isPointerEventsEnabled = index2 >= highestLayerWithOutsidePointerEventsDisabledIndex;
    const pointerDownOutside = usePointerDownOutside((event) => {
      const target = event.target;
      const isPointerDownOnBranch = [...context.branches].some((branch) => branch.contains(target));
      if (!isPointerEventsEnabled || isPointerDownOnBranch) return;
      onPointerDownOutside?.(event);
      onInteractOutside?.(event);
      if (!event.defaultPrevented) onDismiss?.();
    }, ownerDocument);
    const focusOutside = useFocusOutside((event) => {
      const target = event.target;
      const isFocusInBranch = [...context.branches].some((branch) => branch.contains(target));
      if (isFocusInBranch) return;
      onFocusOutside?.(event);
      onInteractOutside?.(event);
      if (!event.defaultPrevented) onDismiss?.();
    }, ownerDocument);
    useEscapeKeydown((event) => {
      const isHighestLayer = index2 === context.layers.size - 1;
      if (!isHighestLayer) return;
      onEscapeKeyDown?.(event);
      if (!event.defaultPrevented && onDismiss) {
        event.preventDefault();
        onDismiss();
      }
    }, ownerDocument);
    reactExports.useEffect(() => {
      if (!node) return;
      if (disableOutsidePointerEvents) {
        if (context.layersWithOutsidePointerEventsDisabled.size === 0) {
          originalBodyPointerEvents = ownerDocument.body.style.pointerEvents;
          ownerDocument.body.style.pointerEvents = "none";
        }
        context.layersWithOutsidePointerEventsDisabled.add(node);
      }
      context.layers.add(node);
      dispatchUpdate();
      return () => {
        if (disableOutsidePointerEvents && context.layersWithOutsidePointerEventsDisabled.size === 1) {
          ownerDocument.body.style.pointerEvents = originalBodyPointerEvents;
        }
      };
    }, [node, ownerDocument, disableOutsidePointerEvents, context]);
    reactExports.useEffect(() => {
      return () => {
        if (!node) return;
        context.layers.delete(node);
        context.layersWithOutsidePointerEventsDisabled.delete(node);
        dispatchUpdate();
      };
    }, [node, context]);
    reactExports.useEffect(() => {
      const handleUpdate = () => force({});
      document.addEventListener(CONTEXT_UPDATE, handleUpdate);
      return () => document.removeEventListener(CONTEXT_UPDATE, handleUpdate);
    }, []);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(
      Primitive$1.div,
      {
        ...layerProps,
        ref: composedRefs,
        style: {
          pointerEvents: isBodyPointerEventsDisabled ? isPointerEventsEnabled ? "auto" : "none" : void 0,
          ...props.style
        },
        onFocusCapture: composeEventHandlers(props.onFocusCapture, focusOutside.onFocusCapture),
        onBlurCapture: composeEventHandlers(props.onBlurCapture, focusOutside.onBlurCapture),
        onPointerDownCapture: composeEventHandlers(
          props.onPointerDownCapture,
          pointerDownOutside.onPointerDownCapture
        )
      }
    );
  }
);
DismissableLayer.displayName = DISMISSABLE_LAYER_NAME;
var BRANCH_NAME = "DismissableLayerBranch";
var DismissableLayerBranch = reactExports.forwardRef((props, forwardedRef) => {
  const context = reactExports.useContext(DismissableLayerContext);
  const ref2 = reactExports.useRef(null);
  const composedRefs = useComposedRefs(forwardedRef, ref2);
  reactExports.useEffect(() => {
    const node = ref2.current;
    if (node) {
      context.branches.add(node);
      return () => {
        context.branches.delete(node);
      };
    }
  }, [context.branches]);
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Primitive$1.div, { ...props, ref: composedRefs });
});
DismissableLayerBranch.displayName = BRANCH_NAME;
function usePointerDownOutside(onPointerDownOutside, ownerDocument = globalThis?.document) {
  const handlePointerDownOutside = useCallbackRef$1(onPointerDownOutside);
  const isPointerInsideReactTreeRef = reactExports.useRef(false);
  const handleClickRef = reactExports.useRef(() => {
  });
  reactExports.useEffect(() => {
    const handlePointerDown = (event) => {
      if (event.target && !isPointerInsideReactTreeRef.current) {
        let handleAndDispatchPointerDownOutsideEvent2 = function() {
          handleAndDispatchCustomEvent$1(
            POINTER_DOWN_OUTSIDE,
            handlePointerDownOutside,
            eventDetail,
            { discrete: true }
          );
        };
        const eventDetail = { originalEvent: event };
        if (event.pointerType === "touch") {
          ownerDocument.removeEventListener("click", handleClickRef.current);
          handleClickRef.current = handleAndDispatchPointerDownOutsideEvent2;
          ownerDocument.addEventListener("click", handleClickRef.current, { once: true });
        } else {
          handleAndDispatchPointerDownOutsideEvent2();
        }
      } else {
        ownerDocument.removeEventListener("click", handleClickRef.current);
      }
      isPointerInsideReactTreeRef.current = false;
    };
    const timerId = window.setTimeout(() => {
      ownerDocument.addEventListener("pointerdown", handlePointerDown);
    }, 0);
    return () => {
      window.clearTimeout(timerId);
      ownerDocument.removeEventListener("pointerdown", handlePointerDown);
      ownerDocument.removeEventListener("click", handleClickRef.current);
    };
  }, [ownerDocument, handlePointerDownOutside]);
  return {
    // ensures we check React component tree (not just DOM tree)
    onPointerDownCapture: () => isPointerInsideReactTreeRef.current = true
  };
}
function useFocusOutside(onFocusOutside, ownerDocument = globalThis?.document) {
  const handleFocusOutside = useCallbackRef$1(onFocusOutside);
  const isFocusInsideReactTreeRef = reactExports.useRef(false);
  reactExports.useEffect(() => {
    const handleFocus = (event) => {
      if (event.target && !isFocusInsideReactTreeRef.current) {
        const eventDetail = { originalEvent: event };
        handleAndDispatchCustomEvent$1(FOCUS_OUTSIDE, handleFocusOutside, eventDetail, {
          discrete: false
        });
      }
    };
    ownerDocument.addEventListener("focusin", handleFocus);
    return () => ownerDocument.removeEventListener("focusin", handleFocus);
  }, [ownerDocument, handleFocusOutside]);
  return {
    onFocusCapture: () => isFocusInsideReactTreeRef.current = true,
    onBlurCapture: () => isFocusInsideReactTreeRef.current = false
  };
}
function dispatchUpdate() {
  const event = new CustomEvent(CONTEXT_UPDATE);
  document.dispatchEvent(event);
}
function handleAndDispatchCustomEvent$1(name2, handler, detail, { discrete }) {
  const target = detail.originalEvent.target;
  const event = new CustomEvent(name2, { bubbles: false, cancelable: true, detail });
  if (handler) target.addEventListener(name2, handler, { once: true });
  if (discrete) {
    dispatchDiscreteCustomEvent(target, event);
  } else {
    target.dispatchEvent(event);
  }
}
var Root$6 = DismissableLayer;
var Branch = DismissableLayerBranch;
var useLayoutEffect2 = globalThis?.document ? reactExports.useLayoutEffect : () => {
};
var PORTAL_NAME$4 = "Portal";
var Portal$3 = reactExports.forwardRef((props, forwardedRef) => {
  const { container: containerProp, ...portalProps } = props;
  const [mounted, setMounted] = reactExports.useState(false);
  useLayoutEffect2(() => setMounted(true), []);
  const container = containerProp || mounted && globalThis?.document?.body;
  return container ? ReactDOM.createPortal(/* @__PURE__ */ jsxRuntimeExports.jsx(Primitive$1.div, { ...portalProps, ref: forwardedRef }), container) : null;
});
Portal$3.displayName = PORTAL_NAME$4;
function useStateMachine(initialState, machine) {
  return reactExports.useReducer((state, event) => {
    const nextState = machine[state][event];
    return nextState ?? state;
  }, initialState);
}
var Presence = (props) => {
  const { present, children } = props;
  const presence = usePresence(present);
  const child = typeof children === "function" ? children({ present: presence.isPresent }) : reactExports.Children.only(children);
  const ref2 = useComposedRefs(presence.ref, getElementRef$4(child));
  const forceMount = typeof children === "function";
  return forceMount || presence.isPresent ? reactExports.cloneElement(child, { ref: ref2 }) : null;
};
Presence.displayName = "Presence";
function usePresence(present) {
  const [node, setNode] = reactExports.useState();
  const stylesRef = reactExports.useRef(null);
  const prevPresentRef = reactExports.useRef(present);
  const prevAnimationNameRef = reactExports.useRef("none");
  const initialState = present ? "mounted" : "unmounted";
  const [state, send] = useStateMachine(initialState, {
    mounted: {
      UNMOUNT: "unmounted",
      ANIMATION_OUT: "unmountSuspended"
    },
    unmountSuspended: {
      MOUNT: "mounted",
      ANIMATION_END: "unmounted"
    },
    unmounted: {
      MOUNT: "mounted"
    }
  });
  reactExports.useEffect(() => {
    const currentAnimationName = getAnimationName(stylesRef.current);
    prevAnimationNameRef.current = state === "mounted" ? currentAnimationName : "none";
  }, [state]);
  useLayoutEffect2(() => {
    const styles = stylesRef.current;
    const wasPresent = prevPresentRef.current;
    const hasPresentChanged = wasPresent !== present;
    if (hasPresentChanged) {
      const prevAnimationName = prevAnimationNameRef.current;
      const currentAnimationName = getAnimationName(styles);
      if (present) {
        send("MOUNT");
      } else if (currentAnimationName === "none" || styles?.display === "none") {
        send("UNMOUNT");
      } else {
        const isAnimating = prevAnimationName !== currentAnimationName;
        if (wasPresent && isAnimating) {
          send("ANIMATION_OUT");
        } else {
          send("UNMOUNT");
        }
      }
      prevPresentRef.current = present;
    }
  }, [present, send]);
  useLayoutEffect2(() => {
    if (node) {
      let timeoutId;
      const ownerWindow = node.ownerDocument.defaultView ?? window;
      const handleAnimationEnd = (event) => {
        const currentAnimationName = getAnimationName(stylesRef.current);
        const isCurrentAnimation = currentAnimationName.includes(CSS.escape(event.animationName));
        if (event.target === node && isCurrentAnimation) {
          send("ANIMATION_END");
          if (!prevPresentRef.current) {
            const currentFillMode = node.style.animationFillMode;
            node.style.animationFillMode = "forwards";
            timeoutId = ownerWindow.setTimeout(() => {
              if (node.style.animationFillMode === "forwards") {
                node.style.animationFillMode = currentFillMode;
              }
            });
          }
        }
      };
      const handleAnimationStart = (event) => {
        if (event.target === node) {
          prevAnimationNameRef.current = getAnimationName(stylesRef.current);
        }
      };
      node.addEventListener("animationstart", handleAnimationStart);
      node.addEventListener("animationcancel", handleAnimationEnd);
      node.addEventListener("animationend", handleAnimationEnd);
      return () => {
        ownerWindow.clearTimeout(timeoutId);
        node.removeEventListener("animationstart", handleAnimationStart);
        node.removeEventListener("animationcancel", handleAnimationEnd);
        node.removeEventListener("animationend", handleAnimationEnd);
      };
    } else {
      send("ANIMATION_END");
    }
  }, [node, send]);
  return {
    isPresent: ["mounted", "unmountSuspended"].includes(state),
    ref: reactExports.useCallback((node2) => {
      stylesRef.current = node2 ? getComputedStyle(node2) : null;
      setNode(node2);
    }, [])
  };
}
function getAnimationName(styles) {
  return styles?.animationName || "none";
}
function getElementRef$4(element) {
  let getter = Object.getOwnPropertyDescriptor(element.props, "ref")?.get;
  let mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
  if (mayWarn) {
    return element.ref;
  }
  getter = Object.getOwnPropertyDescriptor(element, "ref")?.get;
  mayWarn = getter && "isReactWarning" in getter && getter.isReactWarning;
  if (mayWarn) {
    return element.props.ref;
  }
  return element.props.ref || element.ref;
}
var useInsertionEffect = React$1[" useInsertionEffect ".trim().toString()] || useLayoutEffect2;
function useControllableState({
  prop,
  defaultProp,
  onChange = () => {
  },
  caller
}) {
  const [uncontrolledProp, setUncontrolledProp, onChangeRef] = useUncontrolledState({
    defaultProp,
    onChange
  });
  const isControlled = prop !== void 0;
  const value = isControlled ? prop : uncontrolledProp;
  {
    const isControlledRef = reactExports.useRef(prop !== void 0);
    reactExports.useEffect(() => {
      const wasControlled = isControlledRef.current;
      if (wasControlled !== isControlled) {
        const from = wasControlled ? "controlled" : "uncontrolled";
        const to2 = isControlled ? "controlled" : "uncontrolled";
        console.warn(
          `${caller} is changing from ${from} to ${to2}. Components should not switch from controlled to uncontrolled (or vice versa). Decide between using a controlled or uncontrolled value for the lifetime of the component.`
        );
      }
      isControlledRef.current = isControlled;
    }, [isControlled, caller]);
  }
  const setValue = reactExports.useCallback(
    (nextValue) => {
      if (isControlled) {
        const value2 = isFunction$1(nextValue) ? nextValue(prop) : nextValue;
        if (value2 !== prop) {
          onChangeRef.current?.(value2);
        }
      } else {
        setUncontrolledProp(nextValue);
      }
    },
    [isControlled, prop, setUncontrolledProp, onChangeRef]
  );
  return [value, setValue];
}
function useUncontrolledState({
  defaultProp,
  onChange
}) {
  const [value, setValue] = reactExports.useState(defaultProp);
  const prevValueRef = reactExports.useRef(value);
  const onChangeRef = reactExports.useRef(onChange);
  useInsertionEffect(() => {
    onChangeRef.current = onChange;
  }, [onChange]);
  reactExports.useEffect(() => {
    if (prevValueRef.current !== value) {
      onChangeRef.current?.(value);
      prevValueRef.current = value;
    }
  }, [value, prevValueRef]);
  return [value, setValue, onChangeRef];
}
function isFunction$1(value) {
  return typeof value === "function";
}
var VISUALLY_HIDDEN_STYLES = Object.freeze({
  // See: https://github.com/twbs/bootstrap/blob/main/scss/mixins/_visually-hidden.scss
  position: "absolute",
  border: 0,
  width: 1,
  height: 1,
  padding: 0,
  margin: -1,
  overflow: "hidden",
  clip: "rect(0, 0, 0, 0)",
  whiteSpace: "nowrap",
  wordWrap: "normal"
});
var NAME$2 = "VisuallyHidden";
var VisuallyHidden = reactExports.forwardRef(
  (props, forwardedRef) => {
    return /* @__PURE__ */ jsxRuntimeExports.jsx(
      Primitive$1.span,
      {
        ...props,
        ref: forwardedRef,
        style: { ...VISUALLY_HIDDEN_STYLES, ...props.style }
      }
    );
  }
);
VisuallyHidden.displayName = NAME$2;
var Root$5 = VisuallyHidden;
var PROVIDER_NAME$1 = "ToastProvider";
var [Collection$2, useCollection$2, createCollectionScope$2] = createCollection("Toast");
var [createToastContext] = createContextScope("Toast", [createCollectionScope$2]);
var [ToastProviderProvider, useToastProviderContext] = createToastContext(PROVIDER_NAME$1);
var ToastProvider$1 = (props) => {
  const {
    __scopeToast,
    label = "Notification",
    duration: duration2 = 5e3,
    swipeDirection = "right",
    swipeThreshold = 50,
    children
  } = props;
  const [viewport, setViewport] = reactExports.useState(null);
  const [toastCount, setToastCount] = reactExports.useState(0);
  const isFocusedToastEscapeKeyDownRef = reactExports.useRef(false);
  const isClosePausedRef = reactExports.useRef(false);
  if (!label.trim()) {
    console.error(
      `Invalid prop \`label\` supplied to \`${PROVIDER_NAME$1}\`. Expected non-empty \`string\`.`
    );
  }
  return /* @__PURE__ */ jsxRuntimeExports.jsx(Collection$2.Provider, { scope: __scopeToast, children: /* @__PURE__ */ jsxRuntimeExports.jsx(
    ToastProviderProvider,
    {
      scope: __scopeToast,
      label,
      duration: duration2,
      swipeDirection,
      swipeThreshold,
      toastCount,
      viewport,
      onViewportChange: setViewport,
      onToastAdd: reactExports.useCallback(() => setToastCount((prevCount) => prevCount + 1), []),
      onToastRemove: reactExports.useCallback(() => setToastCount((prevCount) => prevCount - 1), []),
      isFocusedToastEscapeKeyDownRef,
      isClosePausedRef,
      children
    }
  ) });
};
ToastProvider$1.displayName = PROVIDER_NAME$1;
var VIEWPORT_NAME$1 = "ToastViewport";
var VIEWPORT_DEFAULT_HOTKEY = ["F8"];
var VIEWPORT_PAUSE = "toast.viewportPause";
var VIEWPORT_RESUME = "toast.viewportResume";
var ToastViewport$1 = reactExports.forwardRef(
  (props, forwardedRef) => {
    const {
      __scopeToast,
      hotkey = VIEWPORT_DEFAULT_HOTKEY,
      label = "Notifications ({hotkey})",
      ...viewportProps
    } = props;
    const context = useToastProviderContext(VIEWPORT_NAME$1, __scopeToast);
    const getItems = useCollection$2(__scopeToast);
    const wrapperRef = reactExports.useRef(null);
    const headFocusProxyRef = reactExports.useRef(null);
    const tailFocusProxyRef = reactExports.useRef(null);
    const ref2 = reactExports.useRef(null);
    const composedRefs = useComposedRefs(forwardedRef, ref2, context.onViewportChange);
    const hotkeyLabel = hotkey.join("+").replace(/Key/g, "").replace(/Digit/g, "");
    const hasToasts = context.toastCount > 0;
    reactExports.useEffect(() => {
      const handleKeyDown = (event) => {
        const isHotkeyPressed = hotkey.length !== 0 && hotkey.every((key) => event[key] || event.code === key);
        if (isHotkeyPressed) ref2.current?.focus();
      };
      document.addEventListener("keydown", handleKeyDown);
      return () => document.removeEventListener("keydown", handleKeyDown);
    }, [hotkey]);
    reactExports.useEffect(() => {
      const wrapper = wrapperRef.current;
      const viewport = ref2.current;
      if (hasToasts && wrapper && viewport) {
        const handlePause = () => {
          if (!context.isClosePausedRef.current) {
            const pauseEvent = new CustomEvent(VIEWPORT_PAUSE);
            viewport.dispatchEvent(pauseEvent);
            context.isClosePausedRef.current = true;
          }
        };
        const handleResume = () => {
          if (context.isClosePausedRef.current) {
            const resumeEvent = new CustomEvent(VIEWPORT_RESUME);
            viewport.dispatchEvent(resumeEvent);
            context.isClosePausedRef.current = false;
          }
        };
        const handleFocusOutResume = (event) => {
          const isFocusMovingOutside = !wrapper.contains(event.relatedTarget);
          if (isFocusMovingOutside) handleResume();
        };
        const handlePointerLeaveResume = () => {
          const isFocusInside = wrapper.contains(document.activeElement);
          if (!isFocusInside) handleResume();
        };
        wrapper.addEventListener("focusin", handlePause);
        wrapper.addEventListener("focusout", handleFocusOutResume);
        wrapper.addEventListener("pointermove", handlePause);
        wrapper.addEventListener("pointerleave", handlePointerLeaveResume);
        window.addEventListener("blur", handlePause);
        window.addEventListener("focus", handleResume);
        return () => {
          wrapper.removeEventListener("focusin", handlePause);
          wrapper.removeEventListener("focusout", handleFocusOutResume);
          wrapper.removeEventListener("pointermove", handlePause);
          wrapper.removeEventListener("pointerleave", handlePointerLeaveResume);
          window.removeEventListener("blur", handlePause);
          window.removeEventListener("focus", handleResume);
        };
      }
    }, [hasToasts, context.isClosePausedRef]);
    const getSortedTabbableCandidates = reactExports.useCallback(
      ({ tabbingDirection }) => {
        const toastItems = getItems();
        const tabbableCandidates = toastItems.map((toastItem) => {
          const toastNode = toastItem.ref.current;
          const toastTabbableCandidates = [toastNode, ...getTabbableCandidates$1(toastNode)];
          return tabbingDirection === "forwards" ? toastTabbableCandidates : toastTabbableCandidates.reverse();
        });
        return (tabbingDirection === "forwards" ? tabbableCandidates.reverse() : tabbableCandidates).flat();
      },
      [getItems]
    );
    reactExports.useEffect(() => {
      const viewport = ref2.current;
      if (viewport) {
        const handleKeyDown = (event) => {
          const isMetaKey = event.altKey || event.ctrlKey || event.metaKey;
          const isTabKey = event.key === "Tab" && !isMetaKey;
          if (isTabKey) {
            const focusedElement = document.activeElement;
            const isTabbingBackwards = event.shiftKey;
            const targetIsViewport = event.target === viewport;
            if (targetIsViewport && isTabbingBackwards) {
              headFocusProxyRef.current?.focus();
              return;
            }
            const tabbingDirection = isTabbingBackwards ? "backwards" : "forwards";
            const sortedCandidates = getSortedTabbableCandidates({ tabbingDirection });
            const index2 = sortedCandidates.findIndex((candidate) => candidate === focusedElement);
            if (focusFirst$2(sortedCandidates.slice(index2 + 1))) {
              event.preventDefault();
            } else {
              isTabbingBackwards ? headFocusProxyRef.current?.focus() : tailFocusProxyRef.current?.focus();
            }
          }
        };
        viewport.addEventListener("keydown", handleKeyDown);
        return () => viewport.removeEventListener("keydown", handleKeyDown);
      }
    }, [getItems, getSortedTabbableCandidates]);
    return /* @__PURE__ */ jsxRuntimeExports.jsxs(
      Branch,
      {
        ref: wrapperRef,
        role: "region",
        "aria-label": label.replace("{hotkey}", hotkeyLabel),
        tabIndex: -1,
        style: { pointerEvents: hasToasts ? void 0 : "none" },
        children: [
          hasToasts && /* @__PURE__ */ jsxRuntimeExports.jsx(
            FocusProxy,
            {
              ref: headFocusProxyRef,
              onFocusFromOutsideViewport: () => {
                const tabbableCandidates = getSortedTabbableCandidates({
                  tabbingDirection: "forwards"
                });
                focusFirst$2(tabbableCandidates);
              }
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsx(Collection$2.Slot, { scope: __scopeToast, children: /* @__PURE__ */ jsxRuntimeExports.jsx(Primitive$1.ol, { tabIndex: -1, ...viewportProps, ref: composedRefs }) }),
          hasToasts && /* @__PURE__ */ jsxRuntimeExports.jsx(
            FocusProxy,
            {
              ref: tailFocusProxyRef,
              onFocusFromOutsideViewport: () => {
                const tabbableCandidates = getSortedTabbableCandidates({
                  tabbingDirection: "backwards"
                });
                focusFirst$2(tabbableCandidates);
              }
            }
          )
        ]
      }
    );
  }
);
ToastViewport$1.displayName = VIEWPORT_NAME$1;
var FOCUS_PROXY_NAME = "ToastFocusProxy";
var FocusProxy = reactExports.forwardRef(
  (props, forwardedRef) => {
    const { __scopeToast, onFocusFromOutsideViewport, ...proxyProps } = props;
    const context = useToastProviderContext(FOCUS_PROXY_NAME, __scopeToast);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(
      VisuallyHidden,
      {
        tabIndex: 0,
        ...proxyProps,
        ref: forwardedRef,
        style: { position: "fixed" },
        onFocus: (event) => {
          const prevFocusedElement = event.relatedTarget;
          const isFocusFromOutsideViewport = !context.viewport?.contains(prevFocusedElement);
          if (isFocusFromOutsideViewport) onFocusFromOutsideViewport();
        }
      }
    );
  }
);
FocusProxy.displayName = FOCUS_PROXY_NAME;
var TOAST_NAME = "Toast";
var TOAST_SWIPE_START = "toast.swipeStart";
var TOAST_SWIPE_MOVE = "toast.swipeMove";
var TOAST_SWIPE_CANCEL = "toast.swipeCancel";
var TOAST_SWIPE_END = "toast.swipeEnd";
var Toast$1 = reactExports.forwardRef(
  (props, forwardedRef) => {
    const { forceMount, open: openProp, defaultOpen, onOpenChange, ...toastProps } = props;
    const [open, setOpen] = useControllableState({
      prop: openProp,
      defaultProp: defaultOpen ?? true,
      onChange: onOpenChange,
      caller: TOAST_NAME
    });
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Presence, { present: forceMount || open, children: /* @__PURE__ */ jsxRuntimeExports.jsx(
      ToastImpl,
      {
        open,
        ...toastProps,
        ref: forwardedRef,
        onClose: () => setOpen(false),
        onPause: useCallbackRef$1(props.onPause),
        onResume: useCallbackRef$1(props.onResume),
        onSwipeStart: composeEventHandlers(props.onSwipeStart, (event) => {
          event.currentTarget.setAttribute("data-swipe", "start");
        }),
        onSwipeMove: composeEventHandlers(props.onSwipeMove, (event) => {
          const { x: x2, y: y2 } = event.detail.delta;
          event.currentTarget.setAttribute("data-swipe", "move");
          event.currentTarget.style.setProperty("--radix-toast-swipe-move-x", `${x2}px`);
          event.currentTarget.style.setProperty("--radix-toast-swipe-move-y", `${y2}px`);
        }),
        onSwipeCancel: composeEventHandlers(props.onSwipeCancel, (event) => {
          event.currentTarget.setAttribute("data-swipe", "cancel");
          event.currentTarget.style.removeProperty("--radix-toast-swipe-move-x");
          event.currentTarget.style.removeProperty("--radix-toast-swipe-move-y");
          event.currentTarget.style.removeProperty("--radix-toast-swipe-end-x");
          event.currentTarget.style.removeProperty("--radix-toast-swipe-end-y");
        }),
        onSwipeEnd: composeEventHandlers(props.onSwipeEnd, (event) => {
          const { x: x2, y: y2 } = event.detail.delta;
          event.currentTarget.setAttribute("data-swipe", "end");
          event.currentTarget.style.removeProperty("--radix-toast-swipe-move-x");
          event.currentTarget.style.removeProperty("--radix-toast-swipe-move-y");
          event.currentTarget.style.setProperty("--radix-toast-swipe-end-x", `${x2}px`);
          event.currentTarget.style.setProperty("--radix-toast-swipe-end-y", `${y2}px`);
          setOpen(false);
        })
      }
    ) });
  }
);
Toast$1.displayName = TOAST_NAME;
var [ToastInteractiveProvider, useToastInteractiveContext] = createToastContext(TOAST_NAME, {
  onClose() {
  }
});
var ToastImpl = reactExports.forwardRef(
  (props, forwardedRef) => {
    const {
      __scopeToast,
      type: type2 = "foreground",
      duration: durationProp,
      open,
      onClose,
      onEscapeKeyDown,
      onPause,
      onResume,
      onSwipeStart,
      onSwipeMove,
      onSwipeCancel,
      onSwipeEnd,
      ...toastProps
    } = props;
    const context = useToastProviderContext(TOAST_NAME, __scopeToast);
    const [node, setNode] = reactExports.useState(null);
    const composedRefs = useComposedRefs(forwardedRef, (node2) => setNode(node2));
    const pointerStartRef = reactExports.useRef(null);
    const swipeDeltaRef = reactExports.useRef(null);
    const duration2 = durationProp || context.duration;
    const closeTimerStartTimeRef = reactExports.useRef(0);
    const closeTimerRemainingTimeRef = reactExports.useRef(duration2);
    const closeTimerRef = reactExports.useRef(0);
    const { onToastAdd, onToastRemove } = context;
    const handleClose = useCallbackRef$1(() => {
      const isFocusInToast = node?.contains(document.activeElement);
      if (isFocusInToast) context.viewport?.focus();
      onClose();
    });
    const startTimer = reactExports.useCallback(
      (duration22) => {
        if (!duration22 || duration22 === Infinity) return;
        window.clearTimeout(closeTimerRef.current);
        closeTimerStartTimeRef.current = (/* @__PURE__ */ new Date()).getTime();
        closeTimerRef.current = window.setTimeout(handleClose, duration22);
      },
      [handleClose]
    );
    reactExports.useEffect(() => {
      const viewport = context.viewport;
      if (viewport) {
        const handleResume = () => {
          startTimer(closeTimerRemainingTimeRef.current);
          onResume?.();
        };
        const handlePause = () => {
          const elapsedTime = (/* @__PURE__ */ new Date()).getTime() - closeTimerStartTimeRef.current;
          closeTimerRemainingTimeRef.current = closeTimerRemainingTimeRef.current - elapsedTime;
          window.clearTimeout(closeTimerRef.current);
          onPause?.();
        };
        viewport.addEventListener(VIEWPORT_PAUSE, handlePause);
        viewport.addEventListener(VIEWPORT_RESUME, handleResume);
        return () => {
          viewport.removeEventListener(VIEWPORT_PAUSE, handlePause);
          viewport.removeEventListener(VIEWPORT_RESUME, handleResume);
        };
      }
    }, [context.viewport, duration2, onPause, onResume, startTimer]);
    reactExports.useEffect(() => {
      if (open && !context.isClosePausedRef.current) startTimer(duration2);
    }, [open, duration2, context.isClosePausedRef, startTimer]);
    reactExports.useEffect(() => {
      onToastAdd();
      return () => onToastRemove();
    }, [onToastAdd, onToastRemove]);
    const announceTextContent = reactExports.useMemo(() => {
      return node ? getAnnounceTextContent(node) : null;
    }, [node]);
    if (!context.viewport) return null;
    return /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
      announceTextContent && /* @__PURE__ */ jsxRuntimeExports.jsx(
        ToastAnnounce,
        {
          __scopeToast,
          role: "status",
          "aria-live": type2 === "foreground" ? "assertive" : "polite",
          children: announceTextContent
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsx(ToastInteractiveProvider, { scope: __scopeToast, onClose: handleClose, children: reactDomExports.createPortal(
        /* @__PURE__ */ jsxRuntimeExports.jsx(Collection$2.ItemSlot, { scope: __scopeToast, children: /* @__PURE__ */ jsxRuntimeExports.jsx(
          Root$6,
          {
            asChild: true,
            onEscapeKeyDown: composeEventHandlers(onEscapeKeyDown, () => {
              if (!context.isFocusedToastEscapeKeyDownRef.current) handleClose();
              context.isFocusedToastEscapeKeyDownRef.current = false;
            }),
            children: /* @__PURE__ */ jsxRuntimeExports.jsx(
              Primitive$1.li,
              {
                tabIndex: 0,
                "data-state": open ? "open" : "closed",
                "data-swipe-direction": context.swipeDirection,
                ...toastProps,
                ref: composedRefs,
                style: { userSelect: "none", touchAction: "none", ...props.style },
                onKeyDown: composeEventHandlers(props.onKeyDown, (event) => {
                  if (event.key !== "Escape") return;
                  onEscapeKeyDown?.(event.nativeEvent);
                  if (!event.nativeEvent.defaultPrevented) {
                    context.isFocusedToastEscapeKeyDownRef.current = true;
                    handleClose();
                  }
                }),
                onPointerDown: composeEventHandlers(props.onPointerDown, (event) => {
                  if (event.button !== 0) return;
                  pointerStartRef.current = { x: event.clientX, y: event.clientY };
                }),
                onPointerMove: composeEventHandlers(props.onPointerMove, (event) => {
                  if (!pointerStartRef.current) return;
                  const x2 = event.clientX - pointerStartRef.current.x;
                  const y2 = event.clientY - pointerStartRef.current.y;
                  const hasSwipeMoveStarted = Boolean(swipeDeltaRef.current);
                  const isHorizontalSwipe = ["left", "right"].includes(context.swipeDirection);
                  const clamp2 = ["left", "up"].includes(context.swipeDirection) ? Math.min : Math.max;
                  const clampedX = isHorizontalSwipe ? clamp2(0, x2) : 0;
                  const clampedY = !isHorizontalSwipe ? clamp2(0, y2) : 0;
                  const moveStartBuffer = event.pointerType === "touch" ? 10 : 2;
                  const delta = { x: clampedX, y: clampedY };
                  const eventDetail = { originalEvent: event, delta };
                  if (hasSwipeMoveStarted) {
                    swipeDeltaRef.current = delta;
                    handleAndDispatchCustomEvent(TOAST_SWIPE_MOVE, onSwipeMove, eventDetail, {
                      discrete: false
                    });
                  } else if (isDeltaInDirection(delta, context.swipeDirection, moveStartBuffer)) {
                    swipeDeltaRef.current = delta;
                    handleAndDispatchCustomEvent(TOAST_SWIPE_START, onSwipeStart, eventDetail, {
                      discrete: false
                    });
                    event.target.setPointerCapture(event.pointerId);
                  } else if (Math.abs(x2) > moveStartBuffer || Math.abs(y2) > moveStartBuffer) {
                    pointerStartRef.current = null;
                  }
                }),
                onPointerUp: composeEventHandlers(props.onPointerUp, (event) => {
                  const delta = swipeDeltaRef.current;
                  const target = event.target;
                  if (target.hasPointerCapture(event.pointerId)) {
                    target.releasePointerCapture(event.pointerId);
                  }
                  swipeDeltaRef.current = null;
                  pointerStartRef.current = null;
                  if (delta) {
                    const toast2 = event.currentTarget;
                    const eventDetail = { originalEvent: event, delta };
                    if (isDeltaInDirection(delta, context.swipeDirection, context.swipeThreshold)) {
                      handleAndDispatchCustomEvent(TOAST_SWIPE_END, onSwipeEnd, eventDetail, {
                        discrete: true
                      });
                    } else {
                      handleAndDispatchCustomEvent(
                        TOAST_SWIPE_CANCEL,
                        onSwipeCancel,
                        eventDetail,
                        {
                          discrete: true
                        }
                      );
                    }
                    toast2.addEventListener("click", (event2) => event2.preventDefault(), {
                      once: true
                    });
                  }
                })
              }
            )
          }
        ) }),
        context.viewport
      ) })
    ] });
  }
);
var ToastAnnounce = (props) => {
  const { __scopeToast, children, ...announceProps } = props;
  const context = useToastProviderContext(TOAST_NAME, __scopeToast);
  const [renderAnnounceText, setRenderAnnounceText] = reactExports.useState(false);
  const [isAnnounced, setIsAnnounced] = reactExports.useState(false);
  useNextFrame(() => setRenderAnnounceText(true));
  reactExports.useEffect(() => {
    const timer = window.setTimeout(() => setIsAnnounced(true), 1e3);
    return () => window.clearTimeout(timer);
  }, []);
  return isAnnounced ? null : /* @__PURE__ */ jsxRuntimeExports.jsx(Portal$3, { asChild: true, children: /* @__PURE__ */ jsxRuntimeExports.jsx(VisuallyHidden, { ...announceProps, children: renderAnnounceText && /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
    context.label,
    " ",
    children
  ] }) }) });
};
var TITLE_NAME$1 = "ToastTitle";
var ToastTitle$1 = reactExports.forwardRef(
  (props, forwardedRef) => {
    const { __scopeToast, ...titleProps } = props;
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Primitive$1.div, { ...titleProps, ref: forwardedRef });
  }
);
ToastTitle$1.displayName = TITLE_NAME$1;
var DESCRIPTION_NAME$1 = "ToastDescription";
var ToastDescription$1 = reactExports.forwardRef(
  (props, forwardedRef) => {
    const { __scopeToast, ...descriptionProps } = props;
    return /* @__PURE__ */ jsxRuntimeExports.jsx(Primitive$1.div, { ...descriptionProps, ref: forwardedRef });
  }
);
ToastDescription$1.displayName = DESCRIPTION_NAME$1;
var ACTION_NAME = "ToastAction";
var ToastAction$1 = reactExports.forwardRef(
  (props, forwardedRef) => {
    const { altText, ...actionProps } = props;
    if (!altText.trim()) {
      console.error(
        `Invalid prop \`altText\` supplied to \`${ACTION_NAME}\`. Expected non-empty \`string\`.`
      );
      return null;
    }
    return /* @__PURE__ */ jsxRuntimeExports.jsx(ToastAnnounceExclude, { altText, asChild: true, children: /* @__PURE__ */ jsxRuntimeExports.jsx(ToastClose$1, { ...actionProps, ref: forwardedRef }) });
  }
);
ToastAction$1.displayName = ACTION_NAME;
var CLOSE_NAME$2 = "ToastClose";
var ToastClose$1 = reactExports.forwardRef(
  (props, forwardedRef) => {
    const { __scopeToast, ...closeProps } = props;
    const interactiveContext = useToastInteractiveContext(CLOSE_NAME$2, __scopeToast);
    return /* @__PURE__ */ jsxRuntimeExports.jsx(ToastAnnounceExclude, { asChild: true, children: /* @__PURE__ */ jsxRuntimeExports.jsx(
      Primitive$1.button,
      {
        type: "button",
        ...closeProps,
        ref: forwardedRef,
        onClick: composeEventHandlers(props.onClick, interactiveContext.onClose)
      }
    ) });
  }
);
ToastClose$1.displayName = CLOSE_NAME$2;
var ToastAnnounceExclude = reactExports.forwardRef((props, forwardedRef) => {
  const { __scopeToast, altText, ...announceExcludeProps } = props;
  return /* @__PURE__ */ jsxRuntimeExports.jsx(
    Primitive$1.div,
    {
      "data-radix-toast-announce-exclude": "",
      "data-radix-toast-announce-alt": altText || void 0,
      ...announceExcludeProps,
      ref: forwardedRef
    }
  );
});
function getAnnounceTextContent(container) {
  const textContent = [];
  const childNodes = Array.from(container.childNodes);
  childNodes.forEach((node) => {
    if (node.nodeType === node.TEXT_NODE && node.textContent) textContent.push(node.textContent);
    if (isHTMLElement$1(node)) {
      const isHidden2 = node.ariaHidden || node.hidden || node.style.display === "none";
      const isExcluded = node.dataset.radixToastAnnounceExclude === "";
      if (!isHidden2) {
        if (isExcluded) {
          const altText = node.dataset.radixToastAnnounceAlt;
          if (altText) textContent.push(altText);
        } else {
          textContent.push(...getAnnounceTextContent(node));
        }
      }
    }
  });
  return textContent;
}
function handleAndDispatchCustomEvent(name2, handler, detail, { discrete }) {
  const currentTarget = detail.originalEvent.currentTarget;
  const event = new CustomEvent(name2, { bubbles: true, cancelable: true, detail });
  if (handler) currentTarget.addEventListener(name2, handler, { once: true });
  if (discrete) {
    dispatchDiscreteCustomEvent(currentTarget, event);
  } else {
    currentTarget.dispatchEvent(event);
  }
}
var isDeltaInDirection = (delta, direction, threshold = 0) => {
  const deltaX = Math.abs(delta.x);
  const deltaY = Math.abs(delta.y);
  const isDeltaX = deltaX > deltaY;
  if (direction === "left" || direction === "right") {
    return isDeltaX && deltaX > threshold;
  } else {
    return !isDeltaX && deltaY > threshold;
  }
};
function useNextFrame(callback = () => {
}) {
  const fn2 = useCallbackRef$1(callback);
  useLayoutEffect2(() => {
    let raf1 = 0;
    let raf2 = 0;
    raf1 = window.requestAnimationFrame(() => raf2 = window.requestAnimationFrame(fn2));
    return () => {
      window.cancelAnimationFrame(raf1);
      window.cancelAnimationFrame(raf2);
    };
  }, [fn2]);
}
function isHTMLElement$1(node) {
  return node.nodeType === node.ELEMENT_NODE;
}
function getTabbableCandidates$1(container) {
  const nodes = [];
  const walker = document.createTreeWalker(container, NodeFilter.SHOW_ELEMENT, {
    acceptNode: (node) => {
      const isHiddenInput = node.tagName === "INPUT" && node.type === "hidden";
      if (node.disabled || node.hidden || isHiddenInput) return NodeFilter.FILTER_SKIP;
      return node.tabIndex >= 0 ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_SKIP;
    }
  });
  while (walker.nextNode()) nodes.push(walker.currentNode);
  return nodes;
}
function focusFirst$2(candidates) {
  const previouslyFocusedElement = document.activeElement;
  return candidates.some((candidate) => {
    if (candidate === previouslyFocusedElement) return true;
    candidate.focus();
    return document.activeElement !== previouslyFocusedElement;
  });
}
var Provider$1 = ToastProvider$1;
var Viewport$1 = ToastViewport$1;
var Root2$4 = Toast$1;
var Title$1 = ToastTitle$1;
var Description$1 = ToastDescription$1;
var Action = ToastAction$1;
var Close$1 = ToastClose$1;
function r(e) {
  var t, f2, n = "";
  if ("string" == typeof e || "number" == typeof e) n += e;
  else if ("object" == typeof e) if (Array.isArray(e)) {
    var o = e.length;
    for (t = 0; t < o; t++) e[t] && (f2 = r(e[t])) && (n && (n += " "), n += f2);
  } else for (f2 in e) e[f2] && (n && (n += " "), n += f2);
  return n;
}
function clsx() {
  for (var e, t, f2 = 0, n = "", o = arguments.length; f2 < o; f2++) (e = arguments[f2]) && (t = r(e)) && (n && (n += " "), n += t);
  return n;
}
const falsyToString = (value) => typeof value === "boolean" ? `${value}` : value === 0 ? "0" : value;
const cx = clsx;
const cva = (base, config2) => (props) => {
  var _config_compoundVariants;
  if ((config2 === null || config2 === void 0 ? void 0 : config2.variants) == null) return cx(base, props === null || props === void 0 ? void 0 : props.class, props === null || props === void 0 ? void 0 : props.className);
  const { variants, defaultVariants } = config2;
  const getVariantClassNames = Object.keys(variants).map((variant) => {
    const variantProp = props === null || props === void 0 ? void 0 : props[variant];
    const defaultVariantProp = defaultVariants === null || defaultVariants === void 0 ? void 0 : defaultVariants[variant];
    if (variantProp === null) return null;
    const variantKey = falsyToString(variantProp) || falsyToString(defaultVariantProp);
    return variants[variant][variantKey];
  });
  const propsWithoutUndefined = props && Object.entries(props).reduce((acc, param) => {
    let [key, value] = param;
    if (value === void 0) {
      return acc;
    }
    acc[key] = value;
    return acc;
  }, {});
  const getCompoundVariantClassNames = config2 === null || config2 === void 0 ? void 0 : (_config_compoundVariants = config2.compoundVariants) === null || _config_compoundVariants === void 0 ? void 0 : _config_compoundVariants.reduce((acc, param) => {
    let { class: cvClass, className: cvClassName, ...compoundVariantOptions } = param;
    return Object.entries(compoundVariantOptions).every((param2) => {
      let [key, value] = param2;
      return Array.isArray(value) ? value.includes({
        ...defaultVariants,
        ...propsWithoutUndefined
      }[key]) : {
        ...defaultVariants,
        ...propsWithoutUndefined
      }[key] === value;
    }) ? [
      ...acc,
      cvClass,
      cvClassName
    ] : acc;
  }, []);
  return cx(base, getVariantClassNames, getCompoundVariantClassNames, props === null || props === void 0 ? void 0 : props.class, props === null || props === void 0 ? void 0 : props.className);
};
const CLASS_PART_SEPARATOR = "-";
const createClassGroupUtils = (config2) => {
  const classMap = createClassMap(config2);
  const {
    conflictingClassGroups,
    conflictingClassGroupModifiers
  } = config2;
  const getClassGroupId = (className) => {
    const classParts = className.split(CLASS_PART_SEPARATOR);
    if (classParts[0] === "" && classParts.length !== 1) {
      classParts.shift();
    }
    return getGroupRecursive(classParts, classMap) || getGroupIdForArbitraryProperty(className);
  };
  const getConflictingClassGroupIds = (classGroupId, hasPostfixModifier) => {
    const conflicts = conflictingClassGroups[classGroupId] || [];
    if (hasPostfixModifier && conflictingClassGroupModifiers[classGroupId]) {
      return [...conflicts, ...conflictingClassGroupModifiers[classGroupId]];
    }
    return conflicts;
  };
  return {
    getClassGroupId,
    getConflictingClassGroupIds
  };
};
const getGroupRecursive = (classParts, classPartObject) => {
  if (classParts.length === 0) {
    return classPartObject.classGroupId;
  }
  const currentClassPart = classParts[0];
  const nextClassPartObject = classPartObject.nextPart.get(currentClassPart);
  const classGroupFromNextClassPart = nextClassPartObject ? getGroupRecursive(classParts.slice(1), nextClassPartObject) : void 0;
  if (classGroupFromNextClassPart) {
    return classGroupFromNextClassPart;
  }
  if (classPartObject.validators.length === 0) {
    return void 0;
  }
  const classRest = classParts.join(CLASS_PART_SEPARATOR);
  return classPartObject.validators.find(({
    validator
  }) => validator(classRest))?.classGroupId;
};
const arbitraryPropertyRegex = /^\[(.+)\]$/;
const getGroupIdForArbitraryProperty = (className) => {
  if (arbitraryPropertyRegex.test(className)) {
    const arbitraryPropertyClassName = arbitraryPropertyRegex.exec(className)[1];
    const property = arbitraryPropertyClassName?.substring(0, arbitraryPropertyClassName.indexOf(":"));
    if (property) {
      return "arbitrary.." + property;
    }
  }
};
const createClassMap = (config2) => {
  const {
    theme,
    prefix
  } = config2;
  const classMap = {
    nextPart: /* @__PURE__ */ new Map(),
    validators: []
  };
  const prefixedClassGroupEntries = getPrefixedClassGroupEntries(Object.entries(config2.classGroups), prefix);
  prefixedClassGroupEntries.forEach(([classGroupId, classGroup]) => {
    processClassesRecursively(classGroup, classMap, classGroupId, theme);
  });
  return classMap;
};
const processClassesRecursively = (classGroup, classPartObject, classGroupId, theme) => {
  classGroup.forEach((classDefinition) => {
    if (typeof classDefinition === "string") {
      const classPartObjectToEdit = classDefinition === "" ? classPartObject : getPart(classPartObject, classDefinition);
      classPartObjectToEdit.classGroupId = classGroupId;
      return;
    }
    if (typeof classDefinition === "function") {
      if (isThemeGetter(classDefinition)) {
        processClassesRecursively(classDefinition(theme), classPartObject, classGroupId, theme);
        return;
      }
      classPartObject.validators.push({
        validator: classDefinition,
        classGroupId
      });
      return;
    }
    Object.entries(classDefinition).forEach(([key, classGroup2]) => {
      processClassesRecursively(classGroup2, getPart(classPartObject, key), classGroupId, theme);
    });
  });
};
const getPart = (classPartObject, path) => {
  let currentClassPartObject = classPartObject;
  path.split(CLASS_PART_SEPARATOR).forEach((pathPart) => {
    if (!currentClassPartObject.nextPart.has(pathPart)) {
      currentClassPartObject.nextPart.set(pathPart, {
        nextPart: /* @__PURE__ */ new Map(),
        validators: []
      });
    }
    currentClassPartObject = currentClassPartObject.nextPart.get(pathPart);
  });
  return currentClassPartObject;
};
const isThemeGetter = (func) => func.isThemeGetter;
const getPrefixedClassGroupEntries = (classGroupEntries, prefix) => {
  if (!prefix) {
    return classGroupEntries;
  }
  return classGroupEntries.map(([classGroupId, classGroup]) => {
    const prefixedClassGroup = classGroup.map((classDefinition) => {
      if (typeof classDefinition === "string") {
        return prefix + classDefinition;
      }
      if (typeof classDefinition === "object") {
        return Object.fromEntries(Object.entries(classDefinition).map(([key, value]) => [prefix + key, value]));
      }
      return classDefinition;
    });
    return [classGroupId, prefixedClassGroup];
  });
};
const createLruCache = (maxCacheSize) => {
  if (maxCacheSize < 1) {
    return {
      get: () => void 0,
      set: () => {
      }
    };
  }
  let cacheSize = 0;
  let cache2 = /* @__PURE__ */ new Map();
  let previousCache = /* @__PURE__ */ new Map();
  const update = (key, value) => {
    cache2.set(key, value);
    cacheSize++;
    if (cacheSize > maxCacheSize) {
      cacheSize = 0;
      previousCache = cache2;
      cache2 = /* @__PURE__ */ new Map();
    }
  };
  return {
    get(key) {
      let value = cache2.get(key);
      if (value !== void 0) {
        return value;
      }
      if ((value = previousCache.get(key)) !== void 0) {
        update(key, value);
        return value;
      }
    },
    set(key, value) {
      if (cache2.has(key)) {
        cache2.set(key, value);
      } else {
        update(key, value);
      }
    }
  };
};
const IMPORTANT_MODIFIER = "!";
const createParseClassName = (config2) => {
  const {
    separator,
    experimentalParseClassName
  } = config2;
  const isSeparatorSingleCharacter = separator.length === 1;
  const firstSeparatorCharacter = separator[0];
  const separatorLength = separator.length;
  const parseClassName = (className) => {
    const modifiers = [];
    let bracketDepth = 0;
    let modifierStart = 0;
    let postfixModifierPosition;
    for (let index2 = 0; index2 < className.length; index2++) {
      let currentCharacter = className[index2];
      if (bracketDepth === 0) {
        if (currentCharacter === firstSeparatorCharacter && (isSeparatorSingleCharacter || className.slice(index2, index2 + separatorLength) === separator)) {
          modifiers.push(className.slice(modifierStart, index2));
          modifierStart = index2 + separatorLength;
          continue;
        }
        if (currentCharacter === "/") {
          postfixModifierPosition = index2;
          continue;
        }
      }
      if (currentCharacter === "[") {
        bracketDepth++;
      } else if (currentCharacter === "]") {
        bracketDepth--;
      }
    }
    const baseClassNameWithImportantModifier = modifiers.length === 0 ? className : className.substring(modifierStart);
    const hasImportantModifier = baseClassNameWithImportantModifier.startsWith(IMPORTANT_MODIFIER);
    const baseClassName = hasImportantModifier ? baseClassNameWithImportantModifier.substring(1) : baseClassNameWithImportantModifier;
    const maybePostfixModifierPosition = postfixModifierPosition && postfixModifierPosition > modifierStart ? postfixModifierPosition - modifierStart : void 0;
    return {
      modifiers,
      hasImportantModifier,
      baseClassName,
      maybePostfixModifierPosition
    };
  };
  if (experimentalParseClassName) {
    return (className) => experimentalParseClassName({
      className,
      parseClassName
    });
  }
  return parseClassName;
};
const sortModifiers = (modifiers) => {
  if (modifiers.length <= 1) {
    return modifiers;
  }
  const sortedModifiers = [];
  let unsortedModifiers = [];
  modifiers.forEach((modifier) => {
    const isArbitraryVariant = modifier[0] === "[";
    if (isArbitraryVariant) {
      sortedModifiers.push(...unsortedModifiers.sort(), modifier);
      unsortedModifiers = [];
    } else {
      unsortedModifiers.push(modifier);
    }
  });
  sortedModifiers.push(...unsortedModifiers.sort());
  return sortedModifiers;
};
const createConfigUtils = (config2) => ({
  cache: createLruCache(config2.cacheSize),
  parseClassName: createParseClassName(config2),
  ...createClassGroupUtils(config2)
});
const SPLIT_CLASSES_REGEX = /\s+/;
const mergeClassList = (classList, configUtils) => {
  const {
    parseClassName,
    getClassGroupId,
    getConflictingClassGroupIds
  } = configUtils;
  const classGroupsInConflict = [];
  const classNames = classList.trim().split(SPLIT_CLASSES_REGEX);
  let result = "";
  for (let index2 = classNames.length - 1; index2 >= 0; index2 -= 1) {
    const originalClassName = classNames[index2];
    const {
      modifiers,
      hasImportantModifier,
      baseClassName,
      maybePostfixModifierPosition
    } = parseClassName(originalClassName);
    let hasPostfixModifier = Boolean(maybePostfixModifierPosition);
    let classGroupId = getClassGroupId(hasPostfixModifier ? baseClassName.substring(0, maybePostfixModifierPosition) : baseClassName);
    if (!classGroupId) {
      if (!hasPostfixModifier) {
        result = originalClassName + (result.length > 0 ? " " + result : result);
        continue;
      }
      classGroupId = getClassGroupId(baseClassName);
      if (!classGroupId) {
        result = originalClassName + (result.length > 0 ? " " + result : result);
        continue;
      }
      hasPostfixModifier = false;
    }
    const variantModifier = sortModifiers(modifiers).join(":");
    const modifierId = hasImportantModifier ? variantModifier + IMPORTANT_MODIFIER : variantModifier;
    const classId = modifierId + classGroupId;
    if (classGroupsInConflict.includes(classId)) {
      continue;
    }
    classGroupsInConflict.push(classId);
    const conflictGroups = getConflictingClassGroupIds(classGroupId, hasPostfixModifier);
    for (let i = 0; i < conflictGroups.length; ++i) {
      const group = conflictGroups[i];
      classGroupsInConflict.push(modifierId + group);
    }
    result = originalClassName + (result.length > 0 ? " " + result : result);
  }
  return result;
};
function twJoin() {
  let index2 = 0;
  let argument;
  let resolvedValue;
  let string2 = "";
  while (index2 < arguments.length) {
    if (argument = arguments[index2++]) {
      if (resolvedValue = toValue(argument)) {
        string2 && (string2 += " ");
        string2 += resolvedValue;
      }
    }
  }
  return string2;
}
const toValue = (mix) => {
  if (typeof mix === "string") {
    return mix;
  }
  let resolvedValue;
  let string2 = "";
  for (let k2 = 0; k2 < mix.length; k2++) {
    if (mix[k2]) {
      if (resolvedValue = toValue(mix[k2])) {
        string2 && (string2 += " ");
        string2 += resolvedValue;
      }
    }
  }
  return string2;
};
function createTailwindMerge(createConfigFirst, ...createConfigRest) {
  let configUtils;
  let cacheGet;
  let cacheSet;
  let functionToCall = initTailwindMerge;
  function initTailwindMerge(classList) {
    const config2 = createConfigRest.reduce((previousConfig, createConfigCurrent) => createConfigCurrent(previousConfig), createConfigFirst());
    configUtils = createConfigUtils(config2);
    cacheGet = configUtils.cache.get;
    cacheSet = configUtils.cache.set;
    functionToCall = tailwindMerge;
    return tailwindMerge(classList);
  }
  function tailwindMerge(classList) {
    const cachedResult = cacheGet(classList);
    if (cachedResult) {
      return cachedResult;
    }
    const result = mergeClassList(classList, configUtils);
    cacheSet(classList, result);
    return result;
  }
  return function callTailwindMerge() {
    return functionToCall(twJoin.apply(null, arguments));
  };
}
const fromTheme = (key) => {
  const themeGetter = (theme) => theme[key] || [];
  themeGetter.isThemeGetter = true;
  return themeGetter;
};
const arbitraryValueRegex = /^\[(?:([a-z-]+):)?(.+)\]$/i;
const fractionRegex = /^\d+\/\d+$/;
const stringLengths = /* @__PURE__ */ new Set(["px", "full", "screen"]);
const tshirtUnitRegex = /^(\d+(\.\d+)?)?(xs|sm|md|lg|xl)$/;
const lengthUnitRegex = /\d+(%|px|r?em|[sdl]?v([hwib]|min|max)|pt|pc|in|cm|mm|cap|ch|ex|r?lh|cq(w|h|i|b|min|max))|\b(calc|min|max|clamp)\(.+\)|^0$/;
const colorFunctionRegex = /^(rgba?|hsla?|hwb|(ok)?(lab|lch)|color-mix)\(.+\)$/;
const shadowRegex = /^(inset_)?-?((\d+)?\.?(\d+)[a-z]+|0)_-?((\d+)?\.?(\d+)[a-z]+|0)/;
const imageRegex = /^(url|image|image-set|cross-fade|element|(repeating-)?(linear|radial|conic)-gradient)\(.+\)$/;
const isLength = (value) => isNumber(value) || stringLengths.has(value) || fractionRegex.test(value);
const isArbitraryLength = (value) => getIsArbitraryValue(value, "length", isLengthOnly);
const isNumber = (value) => Boolean(value) && !Number.isNaN(Number(value));
const isArbitraryNumber = (value) => getIsArbitraryValue(value, "number", isNumber);
const isInteger = (value) => Boolean(value) && Number.isInteger(Number(value));
const isPercent = (value) => value.endsWith("%") && isNumber(value.slice(0, -1));
const isArbitraryValue = (value) => arbitraryValueRegex.test(value);
const isTshirtSize = (value) => tshirtUnitRegex.test(value);
const sizeLabels = /* @__PURE__ */ new Set(["length", "size", "percentage"]);
const isArbitrarySize = (value) => getIsArbitraryValue(value, sizeLabels, isNever);
const isArbitraryPosition = (value) => getIsArbitraryValue(value, "position", isNever);
const imageLabels = /* @__PURE__ */ new Set(["image", "url"]);
const isArbitraryImage = (value) => getIsArbitraryValue(value, imageLabels, isImage);
const isArbitraryShadow = (value) => getIsArbitraryValue(value, "", isShadow);
const isAny = () => true;
const getIsArbitraryValue = (value, label, testValue) => {
  const result = arbitraryValueRegex.exec(value);
  if (result) {
    if (result[1]) {
      return typeof label === "string" ? result[1] === label : label.has(result[1]);
    }
    return testValue(result[2]);
  }
  return false;
};
const isLengthOnly = (value) => (
  // `colorFunctionRegex` check is necessary because color functions can have percentages in them which which would be incorrectly classified as lengths.
  // For example, `hsl(0 0% 0%)` would be classified as a length without this check.
  // I could also use lookbehind assertion in `lengthUnitRegex` but that isn't supported widely enough.
  lengthUnitRegex.test(value) && !colorFunctionRegex.test(value)
);
const isNever = () => false;
const isShadow = (value) => shadowRegex.test(value);
const isImage = (value) => imageRegex.test(value);
const getDefaultConfig = () => {
  const colors = fromTheme("colors");
  const spacing = fromTheme("spacing");
  const blur = fromTheme("blur");
  const brightness = fromTheme("brightness");
  const borderColor = fromTheme("borderColor");
  const borderRadius = fromTheme("borderRadius");
  const borderSpacing = fromTheme("borderSpacing");
  const borderWidth = fromTheme("borderWidth");
  const contrast = fromTheme("contrast");
  const grayscale = fromTheme("grayscale");
  const hueRotate = fromTheme("hueRotate");
  const invert = fromTheme("invert");
  const gap = fromTheme("gap");
  const gradientColorStops = fromTheme("gradientColorStops");
  const gradientColorStopPositions = fromTheme("gradientColorStopPositions");
  const inset = fromTheme("inset");
  const margin = fromTheme("margin");
  const opacity = fromTheme("opacity");
  const padding = fromTheme("padding");
  const saturate = fromTheme("saturate");
  const scale = fromTheme("scale");
  const sepia = fromTheme("sepia");
  const skew = fromTheme("skew");
  const space = fromTheme("space");
  const translate = fromTheme("translate");
  const getOverscroll = () => ["auto", "contain", "none"];
  const getOverflow = () => ["auto", "hidden", "clip", "visible", "scroll"];
  const getSpacingWithAutoAndArbitrary = () => ["auto", isArbitraryValue, spacing];
  const getSpacingWithArbitrary = () => [isArbitraryValue, spacing];
  const getLengthWithEmptyAndArbitrary = () => ["", isLength, isArbitraryLength];
  const getNumberWithAutoAndArbitrary = () => ["auto", isNumber, isArbitraryValue];
  const getPositions = () => ["bottom", "center", "left", "left-bottom", "left-top", "right", "right-bottom", "right-top", "top"];
  const getLineStyles = () => ["solid", "dashed", "dotted", "double", "none"];
  const getBlendModes = () => ["normal", "multiply", "screen", "overlay", "darken", "lighten", "color-dodge", "color-burn", "hard-light", "soft-light", "difference", "exclusion", "hue", "saturation", "color", "luminosity"];
  const getAlign = () => ["start", "end", "center", "between", "around", "evenly", "stretch"];
  const getZeroAndEmpty = () => ["", "0", isArbitraryValue];
  const getBreaks = () => ["auto", "avoid", "all", "avoid-page", "page", "left", "right", "column"];
  const getNumberAndArbitrary = () => [isNumber, isArbitraryValue];
  return {
    cacheSize: 500,
    separator: ":",
    theme: {
      colors: [isAny],
      spacing: [isLength, isArbitraryLength],
      blur: ["none", "", isTshirtSize, isArbitraryValue],
      brightness: getNumberAndArbitrary(),
      borderColor: [colors],
      borderRadius: ["none", "", "full", isTshirtSize, isArbitraryValue],
      borderSpacing: getSpacingWithArbitrary(),
      borderWidth: getLengthWithEmptyAndArbitrary(),
      contrast: getNumberAndArbitrary(),
      grayscale: getZeroAndEmpty(),
      hueRotate: getNumberAndArbitrary(),
      invert: getZeroAndEmpty(),
      gap: getSpacingWithArbitrary(),
      gradientColorStops: [colors],
      gradientColorStopPositions: [isPercent, isArbitraryLength],
      inset: getSpacingWithAutoAndArbitrary(),
      margin: getSpacingWithAutoAndArbitrary(),
      opacity: getNumberAndArbitrary(),
      padding: getSpacingWithArbitrary(),
      saturate: getNumberAndArbitrary(),
      scale: getNumberAndArbitrary(),
      sepia: getZeroAndEmpty(),
      skew: getNumberAndArbitrary(),
      space: getSpacingWithArbitrary(),
      translate: getSpacingWithArbitrary()
    },
    classGroups: {
      // Layout
      /**
       * Aspect Ratio
       * @see https://tailwindcss.com/docs/aspect-ratio
       */
      aspect: [{
        aspect: ["auto", "square", "video", isArbitraryValue]
      }],
      /**
       * Container
       * @see https://tailwindcss.com/docs/container
       */
      container: ["container"],
      /**
       * Columns
       * @see https://tailwindcss.com/docs/columns
       */
      columns: [{
        columns: [isTshirtSize]
      }],
      /**
       * Break After
       * @see https://tailwindcss.com/docs/break-after
       */
      "break-after": [{
        "break-after": getBreaks()
      }],
      /**
       * Break Before
       * @see https://tailwindcss.com/docs/break-before
       */
      "break-before": [{
        "break-before": getBreaks()
      }],
      /**
       * Break Inside
       * @see https://tailwindcss.com/docs/break-inside
       */
      "break-inside": [{
        "break-inside": ["auto", "avoid", "avoid-page", "avoid-column"]
      }],
      /**
       * Box Decoration Break
       * @see https://tailwindcss.com/docs/box-decoration-break
       */
      "box-decoration": [{
        "box-decoration": ["slice", "clone"]
      }],
      /**
       * Box Sizing
       * @see https://tailwindcss.com/docs/box-sizing
       */
      box: [{
        box: ["border", "content"]
      }],
      /**
       * Display
       * @see https://tailwindcss.com/docs/display
       */
      display: ["block", "inline-block", "inline", "flex", "inline-flex", "table", "inline-table", "table-caption", "table-cell", "table-column", "table-column-group", "table-footer-group", "table-header-group", "table-row-group", "table-row", "flow-root", "grid", "inline-grid", "contents", "list-item", "hidden"],
      /**
       * Floats
       * @see https://tailwindcss.com/docs/float
       */
      float: [{
        float: ["right", "left", "none", "start", "end"]
      }],
      /**
       * Clear
       * @see https://tailwindcss.com/docs/clear
       */
      clear: [{
        clear: ["left", "right", "both", "none", "start", "end"]
      }],
      /**
       * Isolation
       * @see https://tailwindcss.com/docs/isolation
       */
      isolation: ["isolate", "isolation-auto"],
      /**
       * Object Fit
       * @see https://tailwindcss.com/docs/object-fit
       */
      "object-fit": [{
        object: ["contain", "cover", "fill", "none", "scale-down"]
      }],
      /**
       * Object Position
       * @see https://tailwindcss.com/docs/object-position
       */
      "object-position": [{
        object: [...getPositions(), isArbitraryValue]
      }],
      /**
       * Overflow
       * @see https://tailwindcss.com/docs/overflow
       */
      overflow: [{
        overflow: getOverflow()
      }],
      /**
       * Overflow X
       * @see https://tailwindcss.com/docs/overflow
       */
      "overflow-x": [{
        "overflow-x": getOverflow()
      }],
      /**
       * Overflow Y
       * @see https://tailwindcss.com/docs/overflow
       */
      "overflow-y": [{
        "overflow-y": getOverflow()
      }],
      /**
       * Overscroll Behavior
       * @see https://tailwindcss.com/docs/overscroll-behavior
       */
      overscroll: [{
        overscroll: getOverscroll()
      }],
      /**
       * Overscroll Behavior X
       * @see https://tailwindcss.com/docs/overscroll-behavior
       */
      "overscroll-x": [{
        "overscroll-x": getOverscroll()
      }],
      /**
       * Overscroll Behavior Y
       * @see https://tailwindcss.com/docs/overscroll-behavior
       */
      "overscroll-y": [{
        "overscroll-y": getOverscroll()
      }],
      /**
       * Position
       * @see https://tailwindcss.com/docs/position
       */
      position: ["static", "fixed", "absolute", "relative", "sticky"],
      /**
       * Top / Right / Bottom / Left
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      inset: [{
        inset: [inset]
      }],
      /**
       * Right / Left
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      "inset-x": [{
        "inset-x": [inset]
      }],
      /**
       * Top / Bottom
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      "inset-y": [{
        "inset-y": [inset]
      }],
      /**
       * Start
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      start: [{
        start: [inset]
      }],
      /**
       * End
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      end: [{
        end: [inset]
      }],
      /**
       * Top
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      top: [{
        top: [inset]
      }],
      /**
       * Right
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      right: [{
        right: [inset]
      }],
      /**
       * Bottom
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      bottom: [{
        bottom: [inset]
      }],
      /**
       * Left
       * @see https://tailwindcss.com/docs/top-right-bottom-left
       */
      left: [{
        left: [inset]
      }],
      /**
       * Visibility
       * @see https://tailwindcss.com/docs/visibility
       */
      visibility: ["visible", "invisible", "collapse"],
      /**
       * Z-Index
       * @see https://tailwindcss.com/docs/z-index
       */
      z: [{
        z: ["auto", isInteger, isArbitraryValue]
      }],
      // Flexbox and Grid
      /**
       * Flex Basis
       * @see https://tailwindcss.com/docs/flex-basis
       */
      basis: [{
        basis: getSpacingWithAutoAndArbitrary()
      }],
      /**
       * Flex Direction
       * @see https://tailwindcss.com/docs/flex-direction
       */
      "flex-direction": [{
        flex: ["row", "row-reverse", "col", "col-reverse"]
      }],
      /**
       * Flex Wrap
       * @see https://tailwindcss.com/docs/flex-wrap
       */
      "flex-wrap": [{
        flex: ["wrap", "wrap-reverse", "nowrap"]
      }],
      /**
       * Flex
       * @see https://tailwindcss.com/docs/flex
       */
      flex: [{
        flex: ["1", "auto", "initial", "none", isArbitraryValue]
      }],
      /**
       * Flex Grow
       * @see https://tailwindcss.com/docs/flex-grow
       */
      grow: [{
        grow: getZeroAndEmpty()
      }],
      /**
       * Flex Shrink
       * @see https://tailwindcss.com/docs/flex-shrink
       */
      shrink: [{
        shrink: getZeroAndEmpty()
      }],
      /**
       * Order
       * @see https://tailwindcss.com/docs/order
       */
      order: [{
        order: ["first", "last", "none", isInteger, isArbitraryValue]
      }],
      /**
       * Grid Template Columns
       * @see https://tailwindcss.com/docs/grid-template-columns
       */
      "grid-cols": [{
        "grid-cols": [isAny]
      }],
      /**
       * Grid Column Start / End
       * @see https://tailwindcss.com/docs/grid-column
       */
      "col-start-end": [{
        col: ["auto", {
          span: ["full", isInteger, isArbitraryValue]
        }, isArbitraryValue]
      }],
      /**
       * Grid Column Start
       * @see https://tailwindcss.com/docs/grid-column
       */
      "col-start": [{
        "col-start": getNumberWithAutoAndArbitrary()
      }],
      /**
       * Grid Column End
       * @see https://tailwindcss.com/docs/grid-column
       */
      "col-end": [{
        "col-end": getNumberWithAutoAndArbitrary()
      }],
      /**
       * Grid Template Rows
       * @see https://tailwindcss.com/docs/grid-template-rows
       */
      "grid-rows": [{
        "grid-rows": [isAny]
      }],
      /**
       * Grid Row Start / End
       * @see https://tailwindcss.com/docs/grid-row
       */
      "row-start-end": [{
        row: ["auto", {
          span: [isInteger, isArbitraryValue]
        }, isArbitraryValue]
      }],
      /**
       * Grid Row Start
       * @see https://tailwindcss.com/docs/grid-row
       */
      "row-start": [{
        "row-start": getNumberWithAutoAndArbitrary()
      }],
      /**
       * Grid Row End
       * @see https://tailwindcss.com/docs/grid-row
       */
      "row-end": [{
        "row-end": getNumberWithAutoAndArbitrary()
      }],
      /**
       * Grid Auto Flow
       * @see https://tailwindcss.com/docs/grid-auto-flow
       */
      "grid-flow": [{
        "grid-flow": ["row", "col", "dense", "row-dense", "col-dense"]
      }],
      /**
       * Grid Auto Columns
       * @see https://tailwindcss.com/docs/grid-auto-columns
       */
      "auto-cols": [{
        "auto-cols": ["auto", "min", "max", "fr", isArbitraryValue]
      }],
      /**
       * Grid Auto Rows
       * @see https://tailwindcss.com/docs/grid-auto-rows
       */
      "auto-rows": [{
        "auto-rows": ["auto", "min", "max", "fr", isArbitraryValue]
      }],
      /**
       * Gap
       * @see https://tailwindcss.com/docs/gap
       */
      gap: [{
        gap: [gap]
      }],
      /**
       * Gap X
       * @see https://tailwindcss.com/docs/gap
       */
      "gap-x": [{
        "gap-x": [gap]
      }],
      /**
       * Gap Y
       * @see https://tailwindcss.com/docs/gap
       */
      "gap-y": [{
        "gap-y": [gap]
      }],
      /**
       * Justify Content
       * @see https://tailwindcss.com/docs/justify-content
       */
      "justify-content": [{
        justify: ["normal", ...getAlign()]
      }],
      /**
       * Justify Items
       * @see https://tailwindcss.com/docs/justify-items
       */
      "justify-items": [{
        "justify-items": ["start", "end", "center", "stretch"]
      }],
      /**
       * Justify Self
       * @see https://tailwindcss.com/docs/justify-self
       */
      "justify-self": [{
        "justify-self": ["auto", "start", "end", "center", "stretch"]
      }],
      /**
       * Align Content
       * @see https://tailwindcss.com/docs/align-content
       */
      "align-content": [{
        content: ["normal", ...getAlign(), "baseline"]
      }],
      /**
       * Align Items
       * @see https://tailwindcss.com/docs/align-items
       */
      "align-items": [{
        items: ["start", "end", "center", "baseline", "stretch"]
      }],
      /**
       * Align Self
       * @see https://tailwindcss.com/docs/align-self
       */
      "align-self": [{
        self: ["auto", "start", "end", "center", "stretch", "baseline"]
      }],
      /**
       * Place Content
       * @see https://tailwindcss.com/docs/place-content
       */
      "place-content": [{
        "place-content": [...getAlign(), "baseline"]
      }],
      /**
       * Place Items
       * @see https://tailwindcss.com/docs/place-items
       */
      "place-items": [{
        "place-items": ["start", "end", "center", "baseline", "stretch"]
      }],
      /**
       * Place Self
       * @see https://tailwindcss.com/docs/place-self
       */
      "place-self": [{
        "place-self": ["auto", "start", "end", "center", "stretch"]
      }],
      // Spacing
      /**
       * Padding
       * @see https://tailwindcss.com/docs/padding
       */
      p: [{
        p: [padding]
      }],
      /**
       * Padding X
       * @see https://tailwindcss.com/docs/padding
       */
      px: [{
        px: [padding]
      }],
      /**
       * Padding Y
       * @see https://tailwindcss.com/docs/padding
       */
      py: [{
        py: [padding]
      }],
      /**
       * Padding Start
       * @see https://tailwindcss.com/docs/padding
       */
      ps: [{
        ps: [padding]
      }],
      /**
       * Padding End
       * @see https://tailwindcss.com/docs/padding
       */
      pe: [{
        pe: [padding]
      }],
      /**
       * Padding Top
       * @see https://tailwindcss.com/docs/padding
       */
      pt: [{
        pt: [padding]
      }],
      /**
       * Padding Right
       * @see https://tailwindcss.com/docs/padding
       */
      pr: [{
        pr: [padding]
      }],
      /**
       * Padding Bottom
       * @see https://tailwindcss.com/docs/padding
       */
      pb: [{
        pb: [padding]
      }],
      /**
       * Padding Left
       * @see https://tailwindcss.com/docs/padding
       */
      pl: [{
        pl: [padding]
      }],
      /**
       * Margin
       * @see https://tailwindcss.com/docs/margin
       */
      m: [{
        m: [margin]
      }],
      /**
       * Margin X
       * @see https://tailwindcss.com/docs/margin
       */
      mx: [{
        mx: [margin]
      }],
      /**
       * Margin Y
       * @see https://tailwindcss.com/docs/margin
       */
      my: [{
        my: [margin]
      }],
      /**
       * Margin Start
       * @see https://tailwindcss.com/docs/margin
       */
      ms: [{
        ms: [margin]
      }],
      /**
       * Margin End
       * @see https://tailwindcss.com/docs/margin
       */
      me: [{
        me: [margin]
      }],
      /**
       * Margin Top
       * @see https://tailwindcss.com/docs/margin
       */
      mt: [{
        mt: [margin]
      }],
      /**
       * Margin Right
       * @see https://tailwindcss.com/docs/margin
       */
      mr: [{
        mr: [margin]
      }],
      /**
       * Margin Bottom
       * @see https://tailwindcss.com/docs/margin
       */
      mb: [{
        mb: [margin]
      }],
      /**
       * Margin Left
       * @see https://tailwindcss.com/docs/margin
       */
      ml: [{
        ml: [margin]
      }],
      /**
       * Space Between X
       * @see https://tailwindcss.com/docs/space
       */
      "space-x": [{
        "space-x": [space]
      }],
      /**
       * Space Between X Reverse
       * @see https://tailwindcss.com/docs/space
       */
      "space-x-reverse": ["space-x-reverse"],
      /**
       * Space Between Y
       * @see https://tailwindcss.com/docs/space
       */
      "space-y": [{
        "space-y": [space]
      }],
      /**
       * Space Between Y Reverse
       * @see https://tailwindcss.com/docs/space
       */
      "space-y-reverse": ["space-y-reverse"],
      // Sizing
      /**
       * Width
       * @see https://tailwindcss.com/docs/width
       */
      w: [{
        w: ["auto", "min", "max", "fit", "svw", "lvw", "dvw", isArbitraryValue, spacing]
      }],
      /**
       * Min-Width
       * @see https://tailwindcss.com/docs/min-width
       */
      "min-w": [{
        "min-w": [isArbitraryValue, spacing, "min", "max", "fit"]
      }],
      /**
       * Max-Width
       * @see https://tailwindcss.com/docs/max-width
       */
      "max-w": [{
        "max-w": [isArbitraryValue, spacing, "none", "full", "min", "max", "fit", "prose", {
          screen: [isTshirtSize]
        }, isTshirtSize]
      }],
      /**
       * Height
       * @see https://tailwindcss.com/docs/height
       */
      h: [{
        h: [isArbitraryValue, spacing, "auto", "min", "max", "fit", "svh", "lvh", "dvh"]
      }],
      /**
       * Min-Height
       * @see https://tailwindcss.com/docs/min-height
       */
      "min-h": [{
        "min-h": [isArbitraryValue, spacing, "min", "max", "fit", "svh", "lvh", "dvh"]
      }],
      /**
       * Max-Height
       * @see https://tailwindcss.com/docs/max-height
       */
      "max-h": [{
        "max-h": [isArbitraryValue, spacing, "min", "max", "fit", "svh", "lvh", "dvh"]
      }],
      /**
       * Size
       * @see https://tailwindcss.com/docs/size
       */
      size: [{
        size: [isArbitraryValue, spacing, "auto", "min", "max", "fit"]
      }],
      // Typography
      /**
       * Font Size
       * @see https://tailwindcss.com/docs/font-size
       */
      "font-size": [{
        text: ["base", isTshirtSize, isArbitraryLength]
      }],
      /**
       * Font Smoothing
       * @see https://tailwindcss.com/docs/font-smoothing
       */
      "font-smoothing": ["antialiased", "subpixel-antialiased"],
      /**
       * Font Style
       * @see https://tailwindcss.com/docs/font-style
       */
      "font-style": ["italic", "not-italic"],
      /**
       * Font Weight
       * @see https://tailwindcss.com/docs/font-weight
       */
      "font-weight": [{
        font: ["thin", "extralight", "light", "normal", "medium", "semibold", "bold", "extrabold", "black", isArbitraryNumber]
      }],
      /**
       * Font Family
       * @see https://tailwindcss.com/docs/font-family
       */
      "font-family": [{
        font: [isAny]
      }],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-normal": ["normal-nums"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-ordinal": ["ordinal"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-slashed-zero": ["slashed-zero"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-figure": ["lining-nums", "oldstyle-nums"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-spacing": ["proportional-nums", "tabular-nums"],
      /**
       * Font Variant Numeric
       * @see https://tailwindcss.com/docs/font-variant-numeric
       */
      "fvn-fraction": ["diagonal-fractions", "stacked-fractions"],
      /**
       * Letter Spacing
       * @see https://tailwindcss.com/docs/letter-spacing
       */
      tracking: [{
        tracking: ["tighter", "tight", "normal", "wide", "wider", "widest", isArbitraryValue]
      }],
      /**
       * Line Clamp
       * @see https://tailwindcss.com/docs/line-clamp
       */
      "line-clamp": [{
        "line-clamp": ["none", isNumber, isArbitraryNumber]
      }],
      /**
       * Line Height
       * @see https://tailwindcss.com/docs/line-height
       */
      leading: [{
        leading: ["none", "tight", "snug", "normal", "relaxed", "loose", isLength, isArbitraryValue]
      }],
      /**
       * List Style Image
       * @see https://tailwindcss.com/docs/list-style-image
       */
      "list-image": [{
        "list-image": ["none", isArbitraryValue]
      }],
      /**
       * List Style Type
       * @see https://tailwindcss.com/docs/list-style-type
       */
      "list-style-type": [{
        list: ["none", "disc", "decimal", isArbitraryValue]
      }],
      /**
       * List Style Position
       * @see https://tailwindcss.com/docs/list-style-position
       */
      "list-style-position": [{
        list: ["inside", "outside"]
      }],
      /**
       * Placeholder Color
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/placeholder-color
       */
      "placeholder-color": [{
        placeholder: [colors]
      }],
      /**
       * Placeholder Opacity
       * @see https://tailwindcss.com/docs/placeholder-opacity
       */
      "placeholder-opacity": [{
        "placeholder-opacity": [opacity]
      }],
      /**
       * Text Alignment
       * @see https://tailwindcss.com/docs/text-align
       */
      "text-alignment": [{
        text: ["left", "center", "right", "justify", "start", "end"]
      }],
      /**
       * Text Color
       * @see https://tailwindcss.com/docs/text-color
       */
      "text-color": [{
        text: [colors]
      }],
      /**
       * Text Opacity
       * @see https://tailwindcss.com/docs/text-opacity
       */
      "text-opacity": [{
        "text-opacity": [opacity]
      }],
      /**
       * Text Decoration
       * @see https://tailwindcss.com/docs/text-decoration
       */
      "text-decoration": ["underline", "overline", "line-through", "no-underline"],
      /**
       * Text Decoration Style
       * @see https://tailwindcss.com/docs/text-decoration-style
       */
      "text-decoration-style": [{
        decoration: [...getLineStyles(), "wavy"]
      }],
      /**
       * Text Decoration Thickness
       * @see https://tailwindcss.com/docs/text-decoration-thickness
       */
      "text-decoration-thickness": [{
        decoration: ["auto", "from-font", isLength, isArbitraryLength]
      }],
      /**
       * Text Underline Offset
       * @see https://tailwindcss.com/docs/text-underline-offset
       */
      "underline-offset": [{
        "underline-offset": ["auto", isLength, isArbitraryValue]
      }],
      /**
       * Text Decoration Color
       * @see https://tailwindcss.com/docs/text-decoration-color
       */
      "text-decoration-color": [{
        decoration: [colors]
      }],
      /**
       * Text Transform
       * @see https://tailwindcss.com/docs/text-transform
       */
      "text-transform": ["uppercase", "lowercase", "capitalize", "normal-case"],
      /**
       * Text Overflow
       * @see https://tailwindcss.com/docs/text-overflow
       */
      "text-overflow": ["truncate", "text-ellipsis", "text-clip"],
      /**
       * Text Wrap
       * @see https://tailwindcss.com/docs/text-wrap
       */
      "text-wrap": [{
        text: ["wrap", "nowrap", "balance", "pretty"]
      }],
      /**
       * Text Indent
       * @see https://tailwindcss.com/docs/text-indent
       */
      indent: [{
        indent: getSpacingWithArbitrary()
      }],
      /**
       * Vertical Alignment
       * @see https://tailwindcss.com/docs/vertical-align
       */
      "vertical-align": [{
        align: ["baseline", "top", "middle", "bottom", "text-top", "text-bottom", "sub", "super", isArbitraryValue]
      }],
      /**
       * Whitespace
       * @see https://tailwindcss.com/docs/whitespace
       */
      whitespace: [{
        whitespace: ["normal", "nowrap", "pre", "pre-line", "pre-wrap", "break-spaces"]
      }],
      /**
       * Word Break
       * @see https://tailwindcss.com/docs/word-break
       */
      break: [{
        break: ["normal", "words", "all", "keep"]
      }],
      /**
       * Hyphens
       * @see https://tailwindcss.com/docs/hyphens
       */
      hyphens: [{
        hyphens: ["none", "manual", "auto"]
      }],
      /**
       * Content
       * @see https://tailwindcss.com/docs/content
       */
      content: [{
        content: ["none", isArbitraryValue]
      }],
      // Backgrounds
      /**
       * Background Attachment
       * @see https://tailwindcss.com/docs/background-attachment
       */
      "bg-attachment": [{
        bg: ["fixed", "local", "scroll"]
      }],
      /**
       * Background Clip
       * @see https://tailwindcss.com/docs/background-clip
       */
      "bg-clip": [{
        "bg-clip": ["border", "padding", "content", "text"]
      }],
      /**
       * Background Opacity
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/background-opacity
       */
      "bg-opacity": [{
        "bg-opacity": [opacity]
      }],
      /**
       * Background Origin
       * @see https://tailwindcss.com/docs/background-origin
       */
      "bg-origin": [{
        "bg-origin": ["border", "padding", "content"]
      }],
      /**
       * Background Position
       * @see https://tailwindcss.com/docs/background-position
       */
      "bg-position": [{
        bg: [...getPositions(), isArbitraryPosition]
      }],
      /**
       * Background Repeat
       * @see https://tailwindcss.com/docs/background-repeat
       */
      "bg-repeat": [{
        bg: ["no-repeat", {
          repeat: ["", "x", "y", "round", "space"]
        }]
      }],
      /**
       * Background Size
       * @see https://tailwindcss.com/docs/background-size
       */
      "bg-size": [{
        bg: ["auto", "cover", "contain", isArbitrarySize]
      }],
      /**
       * Background Image
       * @see https://tailwindcss.com/docs/background-image
       */
      "bg-image": [{
        bg: ["none", {
          "gradient-to": ["t", "tr", "r", "br", "b", "bl", "l", "tl"]
        }, isArbitraryImage]
      }],
      /**
       * Background Color
       * @see https://tailwindcss.com/docs/background-color
       */
      "bg-color": [{
        bg: [colors]
      }],
      /**
       * Gradient Color Stops From Position
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-from-pos": [{
        from: [gradientColorStopPositions]
      }],
      /**
       * Gradient Color Stops Via Position
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-via-pos": [{
        via: [gradientColorStopPositions]
      }],
      /**
       * Gradient Color Stops To Position
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-to-pos": [{
        to: [gradientColorStopPositions]
      }],
      /**
       * Gradient Color Stops From
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-from": [{
        from: [gradientColorStops]
      }],
      /**
       * Gradient Color Stops Via
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-via": [{
        via: [gradientColorStops]
      }],
      /**
       * Gradient Color Stops To
       * @see https://tailwindcss.com/docs/gradient-color-stops
       */
      "gradient-to": [{
        to: [gradientColorStops]
      }],
      // Borders
      /**
       * Border Radius
       * @see https://tailwindcss.com/docs/border-radius
       */
      rounded: [{
        rounded: [borderRadius]
      }],
      /**
       * Border Radius Start
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-s": [{
        "rounded-s": [borderRadius]
      }],
      /**
       * Border Radius End
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-e": [{
        "rounded-e": [borderRadius]
      }],
      /**
       * Border Radius Top
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-t": [{
        "rounded-t": [borderRadius]
      }],
      /**
       * Border Radius Right
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-r": [{
        "rounded-r": [borderRadius]
      }],
      /**
       * Border Radius Bottom
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-b": [{
        "rounded-b": [borderRadius]
      }],
      /**
       * Border Radius Left
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-l": [{
        "rounded-l": [borderRadius]
      }],
      /**
       * Border Radius Start Start
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-ss": [{
        "rounded-ss": [borderRadius]
      }],
      /**
       * Border Radius Start End
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-se": [{
        "rounded-se": [borderRadius]
      }],
      /**
       * Border Radius End End
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-ee": [{
        "rounded-ee": [borderRadius]
      }],
      /**
       * Border Radius End Start
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-es": [{
        "rounded-es": [borderRadius]
      }],
      /**
       * Border Radius Top Left
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-tl": [{
        "rounded-tl": [borderRadius]
      }],
      /**
       * Border Radius Top Right
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-tr": [{
        "rounded-tr": [borderRadius]
      }],
      /**
       * Border Radius Bottom Right
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-br": [{
        "rounded-br": [borderRadius]
      }],
      /**
       * Border Radius Bottom Left
       * @see https://tailwindcss.com/docs/border-radius
       */
      "rounded-bl": [{
        "rounded-bl": [borderRadius]
      }],
      /**
       * Border Width
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w": [{
        border: [borderWidth]
      }],
      /**
       * Border Width X
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-x": [{
        "border-x": [borderWidth]
      }],
      /**
       * Border Width Y
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-y": [{
        "border-y": [borderWidth]
      }],
      /**
       * Border Width Start
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-s": [{
        "border-s": [borderWidth]
      }],
      /**
       * Border Width End
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-e": [{
        "border-e": [borderWidth]
      }],
      /**
       * Border Width Top
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-t": [{
        "border-t": [borderWidth]
      }],
      /**
       * Border Width Right
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-r": [{
        "border-r": [borderWidth]
      }],
      /**
       * Border Width Bottom
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-b": [{
        "border-b": [borderWidth]
      }],
      /**
       * Border Width Left
       * @see https://tailwindcss.com/docs/border-width
       */
      "border-w-l": [{
        "border-l": [borderWidth]
      }],
      /**
       * Border Opacity
       * @see https://tailwindcss.com/docs/border-opacity
       */
      "border-opacity": [{
        "border-opacity": [opacity]
      }],
      /**
       * Border Style
       * @see https://tailwindcss.com/docs/border-style
       */
      "border-style": [{
        border: [...getLineStyles(), "hidden"]
      }],
      /**
       * Divide Width X
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-x": [{
        "divide-x": [borderWidth]
      }],
      /**
       * Divide Width X Reverse
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-x-reverse": ["divide-x-reverse"],
      /**
       * Divide Width Y
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-y": [{
        "divide-y": [borderWidth]
      }],
      /**
       * Divide Width Y Reverse
       * @see https://tailwindcss.com/docs/divide-width
       */
      "divide-y-reverse": ["divide-y-reverse"],
      /**
       * Divide Opacity
       * @see https://tailwindcss.com/docs/divide-opacity
       */
      "divide-opacity": [{
        "divide-opacity": [opacity]
      }],
      /**
       * Divide Style
       * @see https://tailwindcss.com/docs/divide-style
       */
      "divide-style": [{
        divide: getLineStyles()
      }],
      /**
       * Border Color
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color": [{
        border: [borderColor]
      }],
      /**
       * Border Color X
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-x": [{
        "border-x": [borderColor]
      }],
      /**
       * Border Color Y
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-y": [{
        "border-y": [borderColor]
      }],
      /**
       * Border Color S
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-s": [{
        "border-s": [borderColor]
      }],
      /**
       * Border Color E
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-e": [{
        "border-e": [borderColor]
      }],
      /**
       * Border Color Top
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-t": [{
        "border-t": [borderColor]
      }],
      /**
       * Border Color Right
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-r": [{
        "border-r": [borderColor]
      }],
      /**
       * Border Color Bottom
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-b": [{
        "border-b": [borderColor]
      }],
      /**
       * Border Color Left
       * @see https://tailwindcss.com/docs/border-color
       */
      "border-color-l": [{
        "border-l": [borderColor]
      }],
      /**
       * Divide Color
       * @see https://tailwindcss.com/docs/divide-color
       */
      "divide-color": [{
        divide: [borderColor]
      }],
      /**
       * Outline Style
       * @see https://tailwindcss.com/docs/outline-style
       */
      "outline-style": [{
        outline: ["", ...getLineStyles()]
      }],
      /**
       * Outline Offset
       * @see https://tailwindcss.com/docs/outline-offset
       */
      "outline-offset": [{
        "outline-offset": [isLength, isArbitraryValue]
      }],
      /**
       * Outline Width
       * @see https://tailwindcss.com/docs/outline-width
       */
      "outline-w": [{
        outline: [isLength, isArbitraryLength]
      }],
      /**
       * Outline Color
       * @see https://tailwindcss.com/docs/outline-color
       */
      "outline-color": [{
        outline: [colors]
      }],
      /**
       * Ring Width
       * @see https://tailwindcss.com/docs/ring-width
       */
      "ring-w": [{
        ring: getLengthWithEmptyAndArbitrary()
      }],
      /**
       * Ring Width Inset
       * @see https://tailwindcss.com/docs/ring-width
       */
      "ring-w-inset": ["ring-inset"],
      /**
       * Ring Color
       * @see https://tailwindcss.com/docs/ring-color
       */
      "ring-color": [{
        ring: [colors]
      }],
      /**
       * Ring Opacity
       * @see https://tailwindcss.com/docs/ring-opacity
       */
      "ring-opacity": [{
        "ring-opacity": [opacity]
      }],
      /**
       * Ring Offset Width
       * @see https://tailwindcss.com/docs/ring-offset-width
       */
      "ring-offset-w": [{
        "ring-offset": [isLength, isArbitraryLength]
      }],
      /**
       * Ring Offset Color
       * @see https://tailwindcss.com/docs/ring-offset-color
       */
      "ring-offset-color": [{
        "ring-offset": [colors]
      }],
      // Effects
      /**
       * Box Shadow
       * @see https://tailwindcss.com/docs/box-shadow
       */
      shadow: [{
        shadow: ["", "inner", "none", isTshirtSize, isArbitraryShadow]
      }],
      /**
       * Box Shadow Color
       * @see https://tailwindcss.com/docs/box-shadow-color
       */
      "shadow-color": [{
        shadow: [isAny]
      }],
      /**
       * Opacity
       * @see https://tailwindcss.com/docs/opacity
       */
      opacity: [{
        opacity: [opacity]
      }],
      /**
       * Mix Blend Mode
       * @see https://tailwindcss.com/docs/mix-blend-mode
       */
      "mix-blend": [{
        "mix-blend": [...getBlendModes(), "plus-lighter", "plus-darker"]
      }],
      /**
       * Background Blend Mode
       * @see https://tailwindcss.com/docs/background-blend-mode
       */
      "bg-blend": [{
        "bg-blend": getBlendModes()
      }],
      // Filters
      /**
       * Filter
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/filter
       */
      filter: [{
        filter: ["", "none"]
      }],
      /**
       * Blur
       * @see https://tailwindcss.com/docs/blur
       */
      blur: [{
        blur: [blur]
      }],
      /**
       * Brightness
       * @see https://tailwindcss.com/docs/brightness
       */
      brightness: [{
        brightness: [brightness]
      }],
      /**
       * Contrast
       * @see https://tailwindcss.com/docs/contrast
       */
      contrast: [{
        contrast: [contrast]
      }],
      /**
       * Drop Shadow
       * @see https://tailwindcss.com/docs/drop-shadow
       */
      "drop-shadow": [{
        "drop-shadow": ["", "none", isTshirtSize, isArbitraryValue]
      }],
      /**
       * Grayscale
       * @see https://tailwindcss.com/docs/grayscale
       */
      grayscale: [{
        grayscale: [grayscale]
      }],
      /**
       * Hue Rotate
       * @see https://tailwindcss.com/docs/hue-rotate
       */
      "hue-rotate": [{
        "hue-rotate": [hueRotate]
      }],
      /**
       * Invert
       * @see https://tailwindcss.com/docs/invert
       */
      invert: [{
        invert: [invert]
      }],
      /**
       * Saturate
       * @see https://tailwindcss.com/docs/saturate
       */
      saturate: [{
        saturate: [saturate]
      }],
      /**
       * Sepia
       * @see https://tailwindcss.com/docs/sepia
       */
      sepia: [{
        sepia: [sepia]
      }],
      /**
       * Backdrop Filter
       * @deprecated since Tailwind CSS v3.0.0
       * @see https://tailwindcss.com/docs/backdrop-filter
       */
      "backdrop-filter": [{
        "backdrop-filter": ["", "none"]
      }],
      /**
       * Backdrop Blur
       * @see https://tailwindcss.com/docs/backdrop-blur
       */
      "backdrop-blur": [{
        "backdrop-blur": [blur]
      }],
      /**
       * Backdrop Brightness
       * @see https://tailwindcss.com/docs/backdrop-brightness
       */
      "backdrop-brightness": [{
        "backdrop-brightness": [brightness]
      }],
      /**
       * Backdrop Contrast
       * @see https://tailwindcss.com/docs/backdrop-contrast
       */
      "backdrop-contrast": [{
        "backdrop-contrast": [contrast]
      }],
      /**
       * Backdrop Grayscale
       * @see https://tailwindcss.com/docs/backdrop-grayscale
       */
      "backdrop-grayscale": [{
        "backdrop-grayscale": [grayscale]
      }],
      /**
       * Backdrop Hue Rotate
       * @see https://tailwindcss.com/docs/backdrop-hue-rotate
       */
      "backdrop-hue-rotate": [{
        "backdrop-hue-rotate": [hueRotate]
      }],
      /**
       * Backdrop Invert
       * @see https://tailwindcss.com/docs/backdrop-invert
       */
      "backdrop-invert": [{
        "backdrop-invert": [invert]
      }],
      /**
       * Backdrop Opacity
       * @see https://tailwindcss.com/docs/backdrop-opacity
       */
      "backdrop-opacity": [{
        "backdrop-opacity": [opacity]
      }],
      /**
       * Backdrop Saturate
       * @see https://tailwindcss.com/docs/backdrop-saturate
       */
      "backdrop-saturate": [{
        "backdrop-saturate": [saturate]
      }],
      /**
       * Backdrop Sepia
       * @see https://tailwindcss.com/docs/backdrop-sepia
       */
      "backdrop-sepia": [{
        "backdrop-sepia": [sepia]
      }],
      // Tables
      /**
       * Border Collapse
       * @see https://tailwindcss.com/docs/border-collapse
       */
      "border-collapse": [{
        border: ["collapse", "separate"]
      }],
      /**
       * Border Spacing
       * @see https://tailwindcss.com/docs/border-spacing
       */
      "border-spacing": [{
        "border-spacing": [borderSpacing]
      }],
      /**
       * Border Spacing X
       * @see https://tailwindcss.com/docs/border-spacing
       */
      "border-spacing-x": [{
        "border-spacing-x": [borderSpacing]
      }],
      /**
       * Border Spacing Y
       * @see https://tailwindcss.com/docs/border-spacing
       */
      "border-spacing-y": [{
        "border-spacing-y": [borderSpacing]
      }],
      /**
       * Table Layout
       * @see https://tailwindcss.com/docs/table-layout
       */
      "table-layout": [{
        table: ["auto", "fixed"]
      }],
      /**
       * Caption Side
       * @see https://tailwindcss.com/docs/caption-side
       */
      caption: [{
        caption: ["top", "bottom"]
      }],
      // Transitions and Animation
      /**
       * Tranisition Property
       * @see https://tailwindcss.com/docs/transition-property
       */
      transition: [{
        transition: ["none", "all", "", "colors", "opacity", "shadow", "transform", isArbitraryValue]
      }],
      /**
       * Transition Duration
       * @see https://tailwindcss.com/docs/transition-duration
       */
      duration: [{
        duration: getNumberAndArbitrary()
      }],
      /**
       * Transition Timing Function
       * @see https://tailwindcss.com/docs/transition-timing-function
       */
      ease: [{
        ease: ["linear", "in", "out", "in-out", isArbitraryValue]
      }],
      /**
       * Transition Delay
       * @see https://tailwindcss.com/docs/transition-delay
       */
      delay: [{
        delay: getNumberAndArbitrary()
      }],
      /**
       * Animation
       * @see https://tailwindcss.com/docs/animation
       */
      animate: [{
        animate: ["none", "spin", "ping", "pulse", "bounce", isArbitraryValue]
      }],
      // Transforms
      /**
       * Transform
       * @see https://tailwindcss.com/docs/transform
       */
      transform: [{
        transform: ["", "gpu", "none"]
      }],
      /**
       * Scale
       * @see https://tailwindcss.com/docs/scale
       */
      scale: [{
        scale: [scale]
      }],
      /**
       * Scale X
       * @see https://tailwindcss.com/docs/scale
       */
      "scale-x": [{
        "scale-x": [scale]
      }],
      /**
       * Scale Y
       * @see https://tailwindcss.com/docs/scale
       */
      "scale-y": [{
        "scale-y": [scale]
      }],
      /**
       * Rotate
       * @see https://tailwindcss.com/docs/rotate
       */
      rotate: [{
        rotate: [isInteger, isArbitraryValue]
      }],
      /**
       * Translate X
       * @see https://tailwindcss.com/docs/translate
       */
      "translate-x": [{
        "translate-x": [translate]
      }],
      /**
       * Translate Y
       * @see https://tailwindcss.com/docs/translate
       */
      "translate-y": [{
        "translate-y": [translate]
      }],
      /**
       * Skew X
       * @see https://tailwindcss.com/docs/skew
       */
      "skew-x": [{
        "skew-x": [skew]
      }],
      /**
       * Skew Y
       * @see https://tailwindcss.com/docs/skew
       */
      "skew-y": [{
        "skew-y": [skew]
      }],
      /**
       * Transform Origin
       * @see https://tailwindcss.com/docs/transform-origin
       */
      "transform-origin": [{
        origin: ["center", "top", "top-right", "right", "bottom-right", "bottom", "bottom-left", "left", "top-left", isArbitraryValue]
      }],
      // Interactivity
      /**
       * Accent Color
       * @see https://tailwindcss.com/docs/accent-color
       */
      accent: [{
        accent: ["auto", colors]
      }],
      /**
       * Appearance
       * @see https://tailwindcss.com/docs/appearance
       */
      appearance: [{
        appearance: ["none", "auto"]
      }],
      /**
       * Cursor
       * @see https://tailwindcss.com/docs/cursor
       */
      cursor: [{
        cursor: ["auto", "default", "pointer", "wait", "text", "move", "help", "not-allowed", "none", "context-menu", "progress", "cell", "crosshair", "vertical-text", "alias", "copy", "no-drop", "grab", "grabbing", "all-scroll", "col-resize", "row-resize", "n-resize", "e-resize", "s-resize", "w-resize", "ne-resize", "nw-resize", "se-resize", "sw-resize", "ew-resize", "ns-resize", "nesw-resize", "nwse-resize", "zoom-in", "zoom-out", isArbitraryValue]
      }],
      /**
       * Caret Color
       * @see https://tailwindcss.com/docs/just-in-time-mode#caret-color-utilities
       */
      "caret-color": [{
        caret: [colors]
      }],
      /**
       * Pointer Events
       * @see https://tailwindcss.com/docs/pointer-events
       */
      "pointer-events": [{
        "pointer-events": ["none", "auto"]
      }],
      /**
       * Resize
       * @see https://tailwindcss.com/docs/resize
       */
      resize: [{
        resize: ["none", "y", "x", ""]
      }],
      /**
       * Scroll Behavior
       * @see https://tailwindcss.com/docs/scroll-behavior
       */
      "scroll-behavior": [{
        scroll: ["auto", "smooth"]
      }],
      /**
       * Scroll Margin
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-m": [{
        "scroll-m": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Margin X
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mx": [{
        "scroll-mx": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Margin Y
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-my": [{
        "scroll-my": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Margin Start
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-ms": [{
        "scroll-ms": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Margin End
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-me": [{
        "scroll-me": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Margin Top
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mt": [{
        "scroll-mt": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Margin Right
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mr": [{
        "scroll-mr": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Margin Bottom
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-mb": [{
        "scroll-mb": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Margin Left
       * @see https://tailwindcss.com/docs/scroll-margin
       */
      "scroll-ml": [{
        "scroll-ml": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Padding
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-p": [{
        "scroll-p": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Padding X
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-px": [{
        "scroll-px": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Padding Y
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-py": [{
        "scroll-py": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Padding Start
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-ps": [{
        "scroll-ps": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Padding End
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pe": [{
        "scroll-pe": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Padding Top
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pt": [{
        "scroll-pt": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Padding Right
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pr": [{
        "scroll-pr": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Padding Bottom
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pb": [{
        "scroll-pb": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Padding Left
       * @see https://tailwindcss.com/docs/scroll-padding
       */
      "scroll-pl": [{
        "scroll-pl": getSpacingWithArbitrary()
      }],
      /**
       * Scroll Snap Align
       * @see https://tailwindcss.com/docs/scroll-snap-align
       */
      "snap-align": [{
        snap: ["start", "end", "center", "align-none"]
      }],
      /**
       * Scroll Snap Stop
       * @see https://tailwindcss.com/docs/scroll-snap-stop
       */
      "snap-stop": [{
        snap: ["normal", "always"]
      }],
      /**
       * Scroll Snap Type
       * @see https://tailwindcss.com/docs/scroll-snap-type
       */
      "snap-type": [{
        snap: ["none", "x", "y", "both"]
      }],
      /**
       * Scroll Snap Type Strictness
       * @see https://tailwindcss.com/docs/scroll-snap-type
       */
      "snap-strictness": [{
        snap: ["mandatory", "proximity"]
      }],
      /**
       * Touch Action
       * @see https://tailwindcss.com/docs/touch-action
       */
      touch: [{
        touch: ["auto", "none", "manipulation"]
      }],
      /**
       * Touch Action X
       * @see https://tailwindcss.com/docs/touch-action
       */
      "touch-x": [{
        "touch-pan": ["x", "left", "right"]
      }],
      /**
       * Touch Action Y
       * @see https://tailwindcss.com/docs/touch-action
       */
      "touch-y": [{
        "touch-pan": ["y", "up", "down"]
      }],
      /**
       * Touch Action Pinch Zoom
       * @see https://tailwindcss.com/docs/touch-action
       */
      "touch-pz": ["touch-pinch-zoom"],
      /**
       * User Select
       * @see https://tailwindcss.com/docs/user-select
       */
      select: [{
        select: ["none", "text", "all", "auto"]
      }],
      /**
       * Will Change
       * @see https://tailwindcss.com/docs/will-change
       */
      "will-change": [{
        "will-change": ["auto", "scroll", "contents", "transform", isArbitraryValue]
      }],
      // SVG
      /**
       * Fill
       * @see https://tailwindcss.com/docs/fill
       */
      fill: [{
        fill: [colors, "none"]
      }],
      /**
       * Stroke Width
       * @see https://tailwindcss.com/docs/stroke-width
       */
      "stroke-w": [{
        stroke: [isLength, isArbitraryLength, isArbitraryNumber]
      }],
      /**
       * Stroke
       * @see https://tailwindcss.com/docs/stroke
       */
      stroke: [{
        stroke: [colors, "none"]
      }],
      // Accessibility
      /**
       * Screen Readers
       * @see https://tailwindcss.com/docs/screen-readers
       */
      sr: ["sr-only", "not-sr-only"],
      /**
       * Forced Color Adjust
       * @see https://tailwindcss.com/docs/forced-color-adjust
       */
      "forced-color-adjust": [{
        "forced-color-adjust": ["auto", "none"]
      }]
    },
    conflictingClassGroups: {
      overflow: ["overflow-x", "overflow-y"],
      overscroll: ["overscroll-x", "overscroll-y"],
      inset: ["inset-x", "inset-y", "start", "end", "top", "right", "bottom", "left"],
      "inset-x": ["right", "left"],
      "inset-y": ["top", "bottom"],
      flex: ["basis", "grow", "shrink"],
      gap: ["gap-x", "gap-y"],
      p: ["px", "py", "ps", "pe", "pt", "pr", "pb", "pl"],
      px: ["pr", "pl"],
      py: ["pt", "pb"],
      m: ["mx", "my", "ms", "me", "mt", "mr", "mb", "ml"],
      mx: ["mr", "ml"],
      my: ["mt", "mb"],
      size: ["w", "h"],
      "font-size": ["leading"],
      "fvn-normal": ["fvn-ordinal", "fvn-slashed-zero", "fvn-figure", "fvn-spacing", "fvn-fraction"],
      "fvn-ordinal": ["fvn-normal"],
      "fvn-slashed-zero": ["fvn-normal"],
      "fvn-figure": ["fvn-normal"],
      "fvn-spacing": ["fvn-normal"],
      "fvn-fraction": ["fvn-normal"],
      "line-clamp": ["display", "overflow"],
      rounded: ["rounded-s", "rounded-e", "rounded-t", "rounded-r", "rounded-b", "rounded-l", "rounded-ss", "rounded-se", "rounded-ee", "rounded-es", "rounded-tl", "rounded-tr", "rounded-br", "rounded-bl"],
      "rounded-s": ["rounded-ss", "rounded-es"],
      "rounded-e": ["rounded-se", "rounded-ee"],
      "rounded-t": ["rounded-tl", "rounded-tr"],
      "rounded-r": ["rounded-tr", "rounded-br"],
      "rounded-b": ["rounded-br", "rounded-bl"],
      "rounded-l": ["rounded-tl", "rounded-bl"],
      "border-spacing": ["border-spacing-x", "border-spacing-y"],
      "border-w": ["border-w-s", "border-w-e", "border-w-t", "border-w-r", "border-w-b", "border-w-l"],
      "border-w-x": ["border-w-r", "border-w-l"],
      "border-w-y": ["border-w-t", "border-w-b"],
      "border-color": ["border-color-s", "border-color-e", "border-color-t", "border-color-r", "border-color-b", "border-color-l"],
      "border-color-x": ["border-color-r", "border-color-l"],
      "border-color-y": ["border-color-t", "border-color-b"],
      "scroll-m": ["scroll-mx", "scroll-my", "scroll-ms", "scroll-me", "scroll-mt", "scroll-mr", "scroll-mb", "scroll-ml"],
      "scroll-mx": ["scroll-mr", "scroll-ml"],
      "scroll-my": ["scroll-mt", "scroll-mb"],
      "scroll-p": ["scroll-px", "scroll-py", "scroll-ps", "scroll-pe", "scroll-pt", "scroll-pr", "scroll-pb", "scroll-pl"],
      "scroll-px": ["scroll-pr", "scroll-pl"],
      "scroll-py": ["scroll-pt", "scroll-pb"],
      touch: ["touch-x", "touch-y", "touch-pz"],
      "touch-x": ["touch"],
      "touch-y": ["touch"],
      "touch-pz": ["touch"]
    },
    conflictingClassGroupModifiers: {
      "font-size": ["leading"]
    }
  };
};
const twMerge = /* @__PURE__ */ createTailwindMerge(getDefaultConfig);
function cn$2(...inputs) {
  return twMerge(clsx(inputs));
}
function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;
  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }
  return target;
}
var _excluded$Q = ["color"];
var CaretSortIcon = /* @__PURE__ */ reactExports.forwardRef(function(_ref, forwardedRef) {
  var _ref$color = _ref.color, color = _ref$color === void 0 ? "currentColor" : _ref$color, props = _objectWithoutPropertiesLoose(_ref, _excluded$Q);
  return reactExports.createElement("svg", Object.assign({
    width: "15",
    height: "15",
    viewBox: "0 0 15 15",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, props, {
    ref: forwardedRef
  }), reactExports.createElement("path", {
    d: "M4.93179 5.43179C4.75605 5.60753 4.75605 5.89245 4.93179 6.06819C5.10753 6.24392 5.39245 6.24392 5.56819 6.06819L7.49999 4.13638L9.43179 6.06819C9.60753 6.24392 9.89245 6.24392 10.0682 6.06819C10.2439 5.89245 10.2439 5.60753 10.0682 5.43179L7.81819 3.18179C7.73379 3.0974 7.61933 3.04999 7.49999 3.04999C7.38064 3.04999 7.26618 3.0974 7.18179 3.18179L4.93179 5.43179ZM10.0682 9.56819C10.2439 9.39245 10.2439 9.10753 10.0682 8.93179C9.89245 8.75606 9.60753 8.75606 9.43179 8.93179L7.49999 10.8636L5.56819 8.93179C5.39245 8.75606 5.10753 8.75606 4.93179 8.93179C4.75605 9.10753 4.75605 9.39245 4.93179 9.56819L7.18179 11.8182C7.35753 11.9939 7.64245 11.9939 7.81819 11.8182L10.0682 9.56819Z",
    fill: color,
    fillRule: "evenodd",
    clipRule: "evenodd"
  }));
});
var _excluded$T = ["color"];
var CheckIcon = /* @__PURE__ */ reactExports.forwardRef(function(_ref, forwardedRef) {
  var _ref$color = _ref.color, color = _ref$color === void 0 ? "currentColor" : _ref$color, props = _objectWithoutPropertiesLoose(_ref, _excluded$T);
  return reactExports.createElement("svg", Object.assign({
    width: "15",
    height: "15",
    viewBox: "0 0 15 15",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, props, {
    ref: forwardedRef
  }), reactExports.createElement("path", {
    d: "M11.4669 3.72684C11.7558 3.91574 11.8369 4.30308 11.648 4.59198L7.39799 11.092C7.29783 11.2452 7.13556 11.3467 6.95402 11.3699C6.77247 11.3931 6.58989 11.3355 6.45446 11.2124L3.70446 8.71241C3.44905 8.48022 3.43023 8.08494 3.66242 7.82953C3.89461 7.57412 4.28989 7.55529 4.5453 7.78749L6.75292 9.79441L10.6018 3.90792C10.7907 3.61902 11.178 3.53795 11.4669 3.72684Z",
    fill: color,
    fillRule: "evenodd",
    clipRule: "evenodd"
  }));
});
var _excluded$W = ["color"];
var ChevronDownIcon = /* @__PURE__ */ reactExports.forwardRef(function(_ref, forwardedRef) {
  var _ref$color = _ref.color, color = _ref$color === void 0 ? "currentColor" : _ref$color, props = _objectWithoutPropertiesLoose(_ref, _excluded$W);
  return reactExports.createElement("svg", Object.assign({
    width: "15",
    height: "15",
    viewBox: "0 0 15 15",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, props, {
    ref: forwardedRef
  }), reactExports.createElement("path", {
    d: "M3.13523 6.15803C3.3241 5.95657 3.64052 5.94637 3.84197 6.13523L7.5 9.56464L11.158 6.13523C11.3595 5.94637 11.6759 5.95657 11.8648 6.15803C12.0536 6.35949 12.0434 6.67591 11.842 6.86477L7.84197 10.6148C7.64964 10.7951 7.35036 10.7951 7.15803 10.6148L3.15803 6.86477C2.95657 6.67591 2.94637 6.35949 3.13523 6.15803Z",
    fill: color,
    fillRule: "evenodd",
    clipRule: "evenodd"
  }));
});
var _excluded$Z = ["color"];
var ChevronUpIcon = /* @__PURE__ */ reactExports.forwardRef(function(_ref, forwardedRef) {
  var _ref$color = _ref.color, color = _ref$color === void 0 ? "currentColor" : _ref$color, props = _objectWithoutPropertiesLoose(_ref, _excluded$Z);
  return reactExports.createElement("svg", Object.assign({
    width: "15",
    height: "15",
    viewBox: "0 0 15 15",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, props, {
    ref: forwardedRef
  }), reactExports.createElement("path", {
    d: "M3.13523 8.84197C3.3241 9.04343 3.64052 9.05363 3.84197 8.86477L7.5 5.43536L11.158 8.86477C11.3595 9.05363 11.6759 9.04343 11.8648 8.84197C12.0536 8.64051 12.0434 8.32409 11.842 8.13523L7.84197 4.38523C7.64964 4.20492 7.35036 4.20492 7.15803 4.38523L3.15803 8.13523C2.95657 8.32409 2.94637 8.64051 3.13523 8.84197Z",
    fill: color,
    fillRule: "evenodd",
    clipRule: "evenodd"
  }));
});
var _excluded$1r = ["color"];
var Cross2Icon = /* @__PURE__ */ reactExports.forwardRef(function(_ref, forwardedRef) {
  var _ref$color = _ref.color, color = _ref$color === void 0 ? "currentColor" : _ref$color, props = _objectWithoutPropertiesLoose(_ref, _excluded$1r);
  return reactExports.createElement("svg", Object.assign({
    width: "15",
    height: "15",
    viewBox: "0 0 15 15",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, props, {
    ref: forwardedRef
  }), reactExports.createElement("path", {
    d: "M11.7816 4.03157C12.0062 3.80702 12.0062 3.44295 11.7816 3.2184C11.5571 2.99385 11.193 2.99385 10.9685 3.2184L7.50005 6.68682L4.03164 3.2184C3.80708 2.99385 3.44301 2.99385 3.21846 3.2184C2.99391 3.44295 2.99391 3.80702 3.21846 4.03157L6.68688 7.49999L3.21846 10.9684C2.99391 11.193 2.99391 11.557 3.21846 11.7816C3.44301 12.0061 3.80708 12.0061 4.03164 11.7816L7.50005 8.31316L10.9685 11.7816C11.193 12.0061 11.5571 12.0061 11.7816 11.7816C12.0062 11.557 12.0062 11.193 11.7816 10.9684L8.31322 7.49999L11.7816 4.03157Z",
    fill: color,
    fillRule: "evenodd",
    clipRule: "evenodd"
  }));
});
var _excluded$33 = ["color"];
var MagnifyingGlassIcon = /* @__PURE__ */ reactExports.forwardRef(function(_ref, forwardedRef) {
  var _ref$color = _ref.color, color = _ref$color === void 0 ? "currentColor" : _ref$color, props = _objectWithoutPropertiesLoose(_ref, _excluded$33);
  return reactExports.createElement("svg", Object.assign({
    width: "15",
    height: "15",
    viewBox: "0 0 15 15",
    fill: "none",
    xmlns: "http://www.w3.org/2000/svg"
  }, props, {
    ref: forwardedRef
  }), reactExports.createElement("path", {
    d: "M10 6.5C10 8.433 8.433 10 6.5 10C4.567 10 3 8.433 3 6.5C3 4.567 4.567 3 6.5 3C8.433 3 10 4.567 10 6.5ZM9.30884 10.0159C8.53901 10.6318 7.56251 11 6.5 11C4.01472 11 2 8.98528 2 6.5C2 4.01472 4.01472 2 6.5 2C8.98528 2 11 4.01472 11 6.5C11 7.56251 10.6318 8.53901 10.0159 9.30884L12.8536 12.1464C13.0488 12.3417 13.0488 12.6583 12.8536 12.8536C12.6583 13.0488 12.3417 13.0488 12.1464 12.8536L9.30884 10.0159Z",
    fill: color,
    fillRule: "evenodd",
    clipRule: "evenodd"
  }));
});
const ToastProvider = Provider$1;
const ToastViewport = reactExports.forwardRef(({ className, ...props }, ref2) => /* @__PURE__ */ jsxRuntimeExports.jsx(
  Viewport$1,
  {
    ref: ref2,
    className: cn$2(
      "fixed top-0 z-[100] flex max-h-screen w-full flex-col-reverse p-4 sm:bottom-0 sm:right-0 sm:top-auto sm:flex-col md:max-w-[420px]",
      className
    ),
    ...props
  }
));
ToastViewport.displayName = Viewport$1.displayName;
const toastVariants = cva(
  "group pointer-events-auto relative flex w-full items-center justify-between space-x-2 overflow-hidden rounded-md border p-4 pr-6 shadow-lg transition-all data-[swipe=cancel]:translate-x-0 data-[swipe=end]:translate-x-[var(--radix-toast-swipe-end-x)] data-[swipe=move]:translate-x-[var(--radix-toast-swipe-move-x)] data-[swipe=move]:transition-none data-[state=open]:animate-in data-[state=closed]:animate-out data-[swipe=end]:animate-out data-[state=closed]:fade-out-80 data-[state=closed]:slide-out-to-right-full data-[state=open]:slide-in-from-top-full data-[state=open]:sm:slide-in-from-bottom-full",
  {
    variants: {
      variant: {
        default: "border bg-background text-foreground",
        destructive: "destructive group border-destructive bg-destructive text-destructive-foreground"
      }
    },
    defaultVariants: {
      variant: "default"
    }
  }
);
const Toast = reactExports.forwardRef(({ className, variant, ...props }, ref2) => {
  return /* @__PURE__ */ jsxRuntimeExports.jsx(
    Root2$4,
    {
      ref: ref2,
      className: cn$2(toastVariants({ variant }), className),
      ...props
    }
  );
});
Toast.displayName = Root2$4.displayName;
const ToastAction = reactExports.forwardRef(({ className, ...props }, ref2) => /* @__PURE__ */ jsxRuntimeExports.jsx(
  Action,
  {
    ref: ref2,
    className: cn$2(
      "inline-flex h-8 shrink-0 items-center justify-center rounded-md border bg-transparent px-3 text-sm font-medium transition-colors hover:bg-secondary focus:outline-none focus:ring-1 focus:ring-ring disabled:pointer-events-none disabled:opacity-50 group-[.destructive]:border-muted/40 group-[.destructive]:hover:border-destructive/30 group-[.destructive]:hover:bg-destructive group-[.destructive]:hover:text-destructive-foreground group-[.destructive]:focus:ring-destructive",
      className
    ),
    ...props
  }
));
ToastAction.displayName = Action.displayName;
const ToastClose = reactExports.forwardRef(({ className, ...props }, ref2) => /* @__PURE__ */ jsxRuntimeExports.jsx(
  Close$1,
  {
    ref: ref2,
    className: cn$2(
      "absolute right-1 top-1 rounded-md p-1 text-foreground/50 opacity-0 transition-opacity hover:text-foreground focus:opacity-100 focus:outline-none focus:ring-1 group-hover:opacity-100 group-[.destructive]:text-red-300 group-[.destructive]:hover:text-red-50 group-[.destructive]:focus:ring-red-400 group-[.destructive]:focus:ring-offset-red-600",
      className
    ),
    "toast-close": "",
    ...props,
    children: /* @__PURE__ */ jsxRuntimeExports.jsx(Cross2Icon, { className: "h-4 w-4" })
  }
));
ToastClose.displayName = Close$1.displayName;
const ToastTitle = reactExports.forwardRef(({ className, ...props }, ref2) => /* @__PURE__ */ jsxRuntimeExports.jsx(
  Title$1,
  {
    ref: ref2,
    className: cn$2("text-sm font-semibold [&+div]:text-xs", className),
    ...props
  }
));
ToastTitle.displayName = Title$1.displayName;
const ToastDescription = reactExports.forwardRef(({ className, ...props }, ref2) => /* @__PURE__ */ jsxRuntimeExports.jsx(
  Description$1,
  {
    ref: ref2,
    className: cn$2("text-sm opacity-90", className),
    ...props
  }
));
ToastDescription.displayName = Description$1.displayName;
function Toaster() {
  const { toasts } = useToast();
  return /* @__PURE__ */ jsxRuntimeExports.jsxs(ToastProvider, { children: [
    toasts.map(function({ id: id2, title: title2, description: description2, action, ...props }) {
      return /* @__PURE__ */ jsxRuntimeExports.jsxs(Toast, { ...props, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid gap-1", children: [
          title2 && /* @__PURE__ */ jsxRuntimeExports.jsx(ToastTitle, { children: title2 }),
          description2 && /* @__PURE__ */ jsxRuntimeExports.jsx(ToastDescription, { children: description2 })
        ] }),
        action,
        /* @__PURE__ */ jsxRuntimeExports.jsx(ToastClose, {})
      ] }, id2);
    }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(ToastViewport, {})
  ] });
}
const scriptRel = "modulepreload";
const assetsURL = function(dep) {
  return "/" + dep;
};
const seen = {};
const __vitePreload = function preload(baseModule, deps, importerUrl) {
  let promise = Promise.resolve();
  if (deps && deps.length > 0) {
    let allSettled = function(promises$2) {
      return Promise.all(promises$2.map((p2) => Promise.resolve(p2).then((value$1) => ({
        status: "fulfilled",
        value: value$1
      }), (reason) => ({
        status: "rejected",
        reason
      }))));
    };
    document.getElementsByTagName("link");
    const cspNonceMeta = document.querySelector("meta[property=csp-nonce]");
    const cspNonce = cspNonceMeta?.nonce || cspNonceMeta?.getAttribute("nonce");
    promise = allSettled(deps.map((dep) => {
      dep = assetsURL(dep);
      if (dep in seen) return;
      seen[dep] = true;
      const isCss = dep.endsWith(".css");
      const cssSelector = isCss ? '[rel="stylesheet"]' : "";
      if (document.querySelector(`link[href="${dep}"]${cssSelector}`)) return;
      const link = document.createElement("link");
      link.rel = isCss ? "stylesheet" : scriptRel;
      if (!isCss) link.as = "script";
      link.crossOrigin = "";
      link.href = dep;
      if (cspNonce) link.setAttribute("nonce", cspNonce);
      document.head.appendChild(link);
      if (isCss) return new Promise((res, rej) => {
        link.addEventListener("load", res);
        link.addEventListener("error", () => rej(/* @__PURE__ */ new Error(`Unable to preload CSS for ${dep}`)));
      });
    }));
  }
  function handlePreloadError(err$2) {
    const e$1 = new Event("vite:preloadError", { cancelable: true });
    e$1.payload = err$2;
    window.dispatchEvent(e$1);
    if (!e$1.defaultPrevented) throw err$2;
  }
  return promise.then((res) => {
    for (const item of res || []) {
      if (item.status !== "rejected") continue;
      handlePreloadError(item.reason);
    }
    return baseModule().catch(handlePreloadError);
  });
};
const NEVER = Object.freeze({
  status: "aborted"
});
function $constructor(name2, initializer2, params) {
  function init(inst, def) {
    var _a2;
    Object.defineProperty(inst, "_zod", {
      value: inst._zod ?? {},
      enumerable: false
    });
    (_a2 = inst._zod).traits ?? (_a2.traits = /* @__PURE__ */ new Set());
    inst._zod.traits.add(name2);
    initializer2(inst, def);
    for (const k2 in _2.prototype) {
      if (!(k2 in inst))
        Object.defineProperty(inst, k2, { value: _2.prototype[k2].bind(inst) });
    }
    inst._zod.constr = _2;
    inst._zod.def = def;
  }
  const Parent = params?.Parent ?? Object;
  class Definition extends Parent {
  }
  Object.defineProperty(Definition, "name", { value: name2 });
  function _2(def) {
    var _a2;
    const inst = params?.Parent ? new Definition() : this;
    init(inst, def);
    (_a2 = inst._zod).deferred ?? (_a2.deferred = []);
    for (const fn2 of inst._zod.deferred) {
      fn2();
    }
    return inst;
  }
  Object.defineProperty(_2, "init", { value: init });
  Object.defineProperty(_2, Symbol.hasInstance, {
    value: (inst) => {
      if (params?.Parent && inst instanceof params.Parent)
        return true;
      return inst?._zod?.traits?.has(name2);
    }
  });
  Object.defineProperty(_2, "name", { value: name2 });
  return _2;
}
class $ZodAsyncError extends Error {
  constructor() {
    super(`Encountered Promise during synchronous parse. Use .parseAsync() instead.`);
  }
}
const globalConfig = {};
function config(newConfig) {
  return globalConfig;
}
function getEnumValues(entries) {
  const numericValues = Object.values(entries).filter((v) => typeof v === "number");
  const values = Object.entries(entries).filter(([k2, _2]) => numericValues.indexOf(+k2) === -1).map(([_2, v]) => v);
  return values;
}
function jsonStringifyReplacer(_2, value) {
  if (typeof value === "bigint")
    return value.toString();
  return value;
}
function cached(getter) {
  return {
    get value() {
      {
        const value = getter();
        Object.defineProperty(this, "value", { value });
        return value;
      }
    }
  };
}
function nullish(input) {
  return input === null || input === void 0;
}
function cleanRegex(source) {
  const start = source.startsWith("^") ? 1 : 0;
  const end = source.endsWith("$") ? source.length - 1 : source.length;
  return source.slice(start, end);
}
function floatSafeRemainder$1(val, step) {
  const valDecCount = (val.toString().split(".")[1] || "").length;
  const stepDecCount = (step.toString().split(".")[1] || "").length;
  const decCount = valDecCount > stepDecCount ? valDecCount : stepDecCount;
  const valInt = Number.parseInt(val.toFixed(decCount).replace(".", ""));
  const stepInt = Number.parseInt(step.toFixed(decCount).replace(".", ""));
  return valInt % stepInt / 10 ** decCount;
}
function defineLazy(object2, key, getter) {
  Object.defineProperty(object2, key, {
    get() {
      {
        const value = getter();
        object2[key] = value;
        return value;
      }
    },
    set(v) {
      Object.defineProperty(object2, key, {
        value: v
        // configurable: true,
      });
    },
    configurable: true
  });
}
function assignProp(target, prop, value) {
  Object.defineProperty(target, prop, {
    value,
    writable: true,
    enumerable: true,
    configurable: true
  });
}
function esc(str) {
  return JSON.stringify(str);
}
const captureStackTrace = Error.captureStackTrace ? Error.captureStackTrace : (..._args) => {
};
function isObject(data2) {
  return typeof data2 === "object" && data2 !== null && !Array.isArray(data2);
}
const allowsEval = cached(() => {
  if (typeof navigator !== "undefined" && navigator?.userAgent?.includes("Cloudflare")) {
    return false;
  }
  try {
    const F2 = Function;
    new F2("");
    return true;
  } catch (_2) {
    return false;
  }
});
function isPlainObject$1(o) {
  if (isObject(o) === false)
    return false;
  const ctor = o.constructor;
  if (ctor === void 0)
    return true;
  const prot = ctor.prototype;
  if (isObject(prot) === false)
    return false;
  if (Object.prototype.hasOwnProperty.call(prot, "isPrototypeOf") === false) {
    return false;
  }
  return true;
}
const propertyKeyTypes = /* @__PURE__ */ new Set(["string", "number", "symbol"]);
function escapeRegex(str) {
  return str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
}
function clone(inst, def, params) {
  const cl2 = new inst._zod.constr(def ?? inst._zod.def);
  if (!def || params?.parent)
    cl2._zod.parent = inst;
  return cl2;
}
function normalizeParams(_params) {
  const params = _params;
  if (!params)
    return {};
  if (typeof params === "string")
    return { error: () => params };
  if (params?.message !== void 0) {
    if (params?.error !== void 0)
      throw new Error("Cannot specify both `message` and `error` params");
    params.error = params.message;
  }
  delete params.message;
  if (typeof params.error === "string")
    return { ...params, error: () => params.error };
  return params;
}
function optionalKeys(shape) {
  return Object.keys(shape).filter((k2) => {
    return shape[k2]._zod.optin === "optional" && shape[k2]._zod.optout === "optional";
  });
}
const NUMBER_FORMAT_RANGES = {
  safeint: [Number.MIN_SAFE_INTEGER, Number.MAX_SAFE_INTEGER],
  int32: [-2147483648, 2147483647],
  uint32: [0, 4294967295],
  float32: [-34028234663852886e22, 34028234663852886e22],
  float64: [-Number.MAX_VALUE, Number.MAX_VALUE]
};
function pick(schema, mask) {
  const newShape = {};
  const currDef = schema._zod.def;
  for (const key in mask) {
    if (!(key in currDef.shape)) {
      throw new Error(`Unrecognized key: "${key}"`);
    }
    if (!mask[key])
      continue;
    newShape[key] = currDef.shape[key];
  }
  return clone(schema, {
    ...schema._zod.def,
    shape: newShape,
    checks: []
  });
}
function omit(schema, mask) {
  const newShape = { ...schema._zod.def.shape };
  const currDef = schema._zod.def;
  for (const key in mask) {
    if (!(key in currDef.shape)) {
      throw new Error(`Unrecognized key: "${key}"`);
    }
    if (!mask[key])
      continue;
    delete newShape[key];
  }
  return clone(schema, {
    ...schema._zod.def,
    shape: newShape,
    checks: []
  });
}
function extend(schema, shape) {
  if (!isPlainObject$1(shape)) {
    throw new Error("Invalid input to extend: expected a plain object");
  }
  const def = {
    ...schema._zod.def,
    get shape() {
      const _shape = { ...schema._zod.def.shape, ...shape };
      assignProp(this, "shape", _shape);
      return _shape;
    },
    checks: []
    // delete existing checks
  };
  return clone(schema, def);
}
function merge(a2, b) {
  return clone(a2, {
    ...a2._zod.def,
    get shape() {
      const _shape = { ...a2._zod.def.shape, ...b._zod.def.shape };
      assignProp(this, "shape", _shape);
      return _shape;
    },
    catchall: b._zod.def.catchall,
    checks: []
    // delete existing checks
  });
}
function partial(Class, schema, mask) {
  const oldShape = schema._zod.def.shape;
  const shape = { ...oldShape };
  if (mask) {
    for (const key in mask) {
      if (!(key in oldShape)) {
        throw new Error(`Unrecognized key: "${key}"`);
      }
      if (!mask[key])
        continue;
      shape[key] = Class ? new Class({
        type: "optional",
        innerType: oldShape[key]
      }) : oldShape[key];
    }
  } else {
    for (const key in oldShape) {
      shape[key] = Class ? new Class({
        type: "optional",
        innerType: oldShape[key]
      }) : oldShape[key];
    }
  }
  return clone(schema, {
    ...schema._zod.def,
    shape,
    checks: []
  });
}
function required$6(Class, schema, mask) {
  const oldShape = schema._zod.def.shape;
  const shape = { ...oldShape };
  if (mask) {
    for (const key in mask) {
      if (!(key in shape)) {
        throw new Error(`Unrecognized key: "${key}"`);
      }
      if (!mask[key])
        continue;
      shape[key] = new Class({
        type: "nonoptional",
        innerType: oldShape[key]
      });
    }
  } else {
    for (const key in oldShape) {
      shape[key] = new Class({
        type: "nonoptional",
        innerType: oldShape[key]
      });
    }
  }
  return clone(schema, {
    ...schema._zod.def,
    shape,
    // optional: [],
    checks: []
  });
}
function aborted(x2, startIndex = 0) {
  for (let i = startIndex; i < x2.issues.length; i++) {
    if (x2.issues[i]?.continue !== true)
      return true;
  }
  return false;
}
function prefixIssues(path, issues) {
  return issues.map((iss) => {
    var _a2;
    (_a2 = iss).path ?? (_a2.path = []);
    iss.path.unshift(path);
    return iss;
  });
}
function unwrapMessage(message) {
  return typeof message === "string" ? message : message?.message;
}
function finalizeIssue(iss, ctx, config2) {
  const full = { ...iss, path: iss.path ?? [] };
  if (!iss.message) {
    const message = unwrapMessage(iss.inst?._zod.def?.error?.(iss)) ?? unwrapMessage(ctx?.error?.(iss)) ?? unwrapMessage(config2.customError?.(iss)) ?? unwrapMessage(config2.localeError?.(iss)) ?? "Invalid input";
    full.message = message;
  }
  delete full.inst;
  delete full.continue;
  if (!ctx?.reportInput) {
    delete full.input;
  }
  return full;
}
function getLengthableOrigin(input) {
  if (Array.isArray(input))
    return "array";
  if (typeof input === "string")
    return "string";
  return "unknown";
}
function issue(...args) {
  const [iss, input, inst] = args;
  if (typeof iss === "string") {
    return {
      message: iss,
      code: "custom",
      input,
      inst
    };
  }
  return { ...iss };
}
const initializer$1 = (inst, def) => {
  inst.name = "$ZodError";
  Object.defineProperty(inst, "_zod", {
    value: inst._zod,
    enumerable: false
  });
  Object.defineProperty(inst, "issues", {
    value: def,
    enumerable: false
  });
  Object.defineProperty(inst, "message", {
    get() {
      return JSON.stringify(def, jsonStringifyReplacer, 2);
    },
    enumerable: true
    // configurable: false,
  });
  Object.defineProperty(inst, "toString", {
    value: () => inst.message,
    enumerable: false
  });
};
const $ZodError = $constructor("$ZodError", initializer$1);
const $ZodRealError = $constructor("$ZodError", initializer$1, { Parent: Error });
function flattenError$1(error, mapper = (issue2) => issue2.message) {
  const fieldErrors = {};
  const formErrors = [];
  for (const sub of error.issues) {
    if (sub.path.length > 0) {
      fieldErrors[sub.path[0]] = fieldErrors[sub.path[0]] || [];
      fieldErrors[sub.path[0]].push(mapper(sub));
    } else {
      formErrors.push(mapper(sub));
    }
  }
  return { formErrors, fieldErrors };
}
function formatError(error, _mapper) {
  const mapper = _mapper || function(issue2) {
    return issue2.message;
  };
  const fieldErrors = { _errors: [] };
  const processError = (error2) => {
    for (const issue2 of error2.issues) {
      if (issue2.code === "invalid_union" && issue2.errors.length) {
        issue2.errors.map((issues) => processError({ issues }));
      } else if (issue2.code === "invalid_key") {
        processError({ issues: issue2.issues });
      } else if (issue2.code === "invalid_element") {
        processError({ issues: issue2.issues });
      } else if (issue2.path.length === 0) {
        fieldErrors._errors.push(mapper(issue2));
      } else {
        let curr = fieldErrors;
        let i = 0;
        while (i < issue2.path.length) {
          const el2 = issue2.path[i];
          const terminal = i === issue2.path.length - 1;
          if (!terminal) {
            curr[el2] = curr[el2] || { _errors: [] };
          } else {
            curr[el2] = curr[el2] || { _errors: [] };
            curr[el2]._errors.push(mapper(issue2));
          }
          curr = curr[el2];
          i++;
        }
      }
    }
  };
  processError(error);
  return fieldErrors;
}
const _parse = (_Err) => (schema, value, _ctx, _params) => {
  const ctx = _ctx ? Object.assign(_ctx, { async: false }) : { async: false };
  const result = schema._zod.run({ value, issues: [] }, ctx);
  if (result instanceof Promise) {
    throw new $ZodAsyncError();
  }
  if (result.issues.length) {
    const e = new (_params?.Err ?? _Err)(result.issues.map((iss) => finalizeIssue(iss, ctx, config())));
    captureStackTrace(e, _params?.callee);
    throw e;
  }
  return result.value;
};
const _parseAsync = (_Err) => async (schema, value, _ctx, params) => {
  const ctx = _ctx ? Object.assign(_ctx, { async: true }) : { async: true };
  let result = schema._zod.run({ value, issues: [] }, ctx);
  if (result instanceof Promise)
    result = await result;
  if (result.issues.length) {
    const e = new (params?.Err ?? _Err)(result.issues.map((iss) => finalizeIssue(iss, ctx, config())));
    captureStackTrace(e, params?.callee);
    throw e;
  }
  return result.value;
};
const _safeParse = (_Err) => (schema, value, _ctx) => {
  const ctx = _ctx ? { ..._ctx, async: false } : { async: false };
  const result = schema._zod.run({ value, issues: [] }, ctx);
  if (result instanceof Promise) {
    throw new $ZodAsyncError();
  }
  return result.issues.length ? {
    success: false,
    error: new (_Err ?? $ZodError)(result.issues.map((iss) => finalizeIssue(iss, ctx, config())))
  } : { success: true, data: result.value };
};
const safeParse$2 = /* @__PURE__ */ _safeParse($ZodRealError);
const _safeParseAsync = (_Err) => async (schema, value, _ctx) => {
  const ctx = _ctx ? Object.assign(_ctx, { async: true }) : { async: true };
  let result = schema._zod.run({ value, issues: [] }, ctx);
  if (result instanceof Promise)
    result = await result;
  return result.issues.length ? {
    success: false,
    error: new _Err(result.issues.map((iss) => finalizeIssue(iss, ctx, config())))
  } : { success: true, data: result.value };
};
const safeParseAsync$1 = /* @__PURE__ */ _safeParseAsync($ZodRealError);
const cuid = /^[cC][^\s-]{8,}$/;
const cuid2 = /^[0-9a-z]+$/;
const ulid = /^[0-9A-HJKMNP-TV-Za-hjkmnp-tv-z]{26}$/;
const xid = /^[0-9a-vA-V]{20}$/;
const ksuid = /^[A-Za-z0-9]{27}$/;
const nanoid = /^[a-zA-Z0-9_-]{21}$/;
const duration$1 = /^P(?:(\d+W)|(?!.*W)(?=\d|T\d)(\d+Y)?(\d+M)?(\d+D)?(T(?=\d)(\d+H)?(\d+M)?(\d+([.,]\d+)?S)?)?)$/;
const guid = /^([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$/;
const uuid = (version2) => {
  if (!version2)
    return /^([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-8][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}|00000000-0000-0000-0000-000000000000)$/;
  return new RegExp(`^([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-${version2}[0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12})$`);
};
const email = /^(?!\.)(?!.*\.\.)([A-Za-z0-9_'+\-\.]*)[A-Za-z0-9_+-]@([A-Za-z0-9][A-Za-z0-9\-]*\.)+[A-Za-z]{2,}$/;
const _emoji$1 = `^(\\p{Extended_Pictographic}|\\p{Emoji_Component})+$`;
function emoji() {
  return new RegExp(_emoji$1, "u");
}
const ipv4 = /^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/;
const ipv6 = /^(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|::|([0-9a-fA-F]{1,4})?::([0-9a-fA-F]{1,4}:?){0,6})$/;
const cidrv4 = /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\/([0-9]|[1-2][0-9]|3[0-2])$/;
const cidrv6 = /^(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|::|([0-9a-fA-F]{1,4})?::([0-9a-fA-F]{1,4}:?){0,6})\/(12[0-8]|1[01][0-9]|[1-9]?[0-9])$/;
const base64 = /^$|^(?:[0-9a-zA-Z+/]{4})*(?:(?:[0-9a-zA-Z+/]{2}==)|(?:[0-9a-zA-Z+/]{3}=))?$/;
const base64url = /^[A-Za-z0-9_-]*$/;
const hostname = /^([a-zA-Z0-9-]+\.)*[a-zA-Z0-9-]+$/;
const e164 = /^\+(?:[0-9]){6,14}[0-9]$/;
const dateSource = `(?:(?:\\d\\d[2468][048]|\\d\\d[13579][26]|\\d\\d0[48]|[02468][048]00|[13579][26]00)-02-29|\\d{4}-(?:(?:0[13578]|1[02])-(?:0[1-9]|[12]\\d|3[01])|(?:0[469]|11)-(?:0[1-9]|[12]\\d|30)|(?:02)-(?:0[1-9]|1\\d|2[0-8])))`;
const date$1 = /* @__PURE__ */ new RegExp(`^${dateSource}$`);
function timeSource(args) {
  const hhmm = `(?:[01]\\d|2[0-3]):[0-5]\\d`;
  const regex = typeof args.precision === "number" ? args.precision === -1 ? `${hhmm}` : args.precision === 0 ? `${hhmm}:[0-5]\\d` : `${hhmm}:[0-5]\\d\\.\\d{${args.precision}}` : `${hhmm}(?::[0-5]\\d(?:\\.\\d+)?)?`;
  return regex;
}
function time$1(args) {
  return new RegExp(`^${timeSource(args)}$`);
}
function datetime$1(args) {
  const time2 = timeSource({ precision: args.precision });
  const opts = ["Z"];
  if (args.local)
    opts.push("");
  if (args.offset)
    opts.push(`([+-]\\d{2}:\\d{2})`);
  const timeRegex2 = `${time2}(?:${opts.join("|")})`;
  return new RegExp(`^${dateSource}T(?:${timeRegex2})$`);
}
const string$1 = (params) => {
  const regex = params ? `[\\s\\S]{${params?.minimum ?? 0},${params?.maximum ?? ""}}` : `[\\s\\S]*`;
  return new RegExp(`^${regex}$`);
};
const integer = /^\d+$/;
const number$2 = /^-?\d+(?:\.\d+)?/i;
const boolean$1 = /true|false/i;
const _null$2 = /null/i;
const lowercase = /^[^A-Z]*$/;
const uppercase = /^[^a-z]*$/;
const $ZodCheck = /* @__PURE__ */ $constructor("$ZodCheck", (inst, def) => {
  var _a2;
  inst._zod ?? (inst._zod = {});
  inst._zod.def = def;
  (_a2 = inst._zod).onattach ?? (_a2.onattach = []);
});
const numericOriginMap = {
  number: "number",
  bigint: "bigint",
  object: "date"
};
const $ZodCheckLessThan = /* @__PURE__ */ $constructor("$ZodCheckLessThan", (inst, def) => {
  $ZodCheck.init(inst, def);
  const origin = numericOriginMap[typeof def.value];
  inst._zod.onattach.push((inst2) => {
    const bag = inst2._zod.bag;
    const curr = (def.inclusive ? bag.maximum : bag.exclusiveMaximum) ?? Number.POSITIVE_INFINITY;
    if (def.value < curr) {
      if (def.inclusive)
        bag.maximum = def.value;
      else
        bag.exclusiveMaximum = def.value;
    }
  });
  inst._zod.check = (payload) => {
    if (def.inclusive ? payload.value <= def.value : payload.value < def.value) {
      return;
    }
    payload.issues.push({
      origin,
      code: "too_big",
      maximum: def.value,
      input: payload.value,
      inclusive: def.inclusive,
      inst,
      continue: !def.abort
    });
  };
});
const $ZodCheckGreaterThan = /* @__PURE__ */ $constructor("$ZodCheckGreaterThan", (inst, def) => {
  $ZodCheck.init(inst, def);
  const origin = numericOriginMap[typeof def.value];
  inst._zod.onattach.push((inst2) => {
    const bag = inst2._zod.bag;
    const curr = (def.inclusive ? bag.minimum : bag.exclusiveMinimum) ?? Number.NEGATIVE_INFINITY;
    if (def.value > curr) {
      if (def.inclusive)
        bag.minimum = def.value;
      else
        bag.exclusiveMinimum = def.value;
    }
  });
  inst._zod.check = (payload) => {
    if (def.inclusive ? payload.value >= def.value : payload.value > def.value) {
      return;
    }
    payload.issues.push({
      origin,
      code: "too_small",
      minimum: def.value,
      input: payload.value,
      inclusive: def.inclusive,
      inst,
      continue: !def.abort
    });
  };
});
const $ZodCheckMultipleOf = /* @__PURE__ */ $constructor("$ZodCheckMultipleOf", (inst, def) => {
  $ZodCheck.init(inst, def);
  inst._zod.onattach.push((inst2) => {
    var _a2;
    (_a2 = inst2._zod.bag).multipleOf ?? (_a2.multipleOf = def.value);
  });
  inst._zod.check = (payload) => {
    if (typeof payload.value !== typeof def.value)
      throw new Error("Cannot mix number and bigint in multiple_of check.");
    const isMultiple = typeof payload.value === "bigint" ? payload.value % def.value === BigInt(0) : floatSafeRemainder$1(payload.value, def.value) === 0;
    if (isMultiple)
      return;
    payload.issues.push({
      origin: typeof payload.value,
      code: "not_multiple_of",
      divisor: def.value,
      input: payload.value,
      inst,
      continue: !def.abort
    });
  };
});
const $ZodCheckNumberFormat = /* @__PURE__ */ $constructor("$ZodCheckNumberFormat", (inst, def) => {
  $ZodCheck.init(inst, def);
  def.format = def.format || "float64";
  const isInt = def.format?.includes("int");
  const origin = isInt ? "int" : "number";
  const [minimum, maximum] = NUMBER_FORMAT_RANGES[def.format];
  inst._zod.onattach.push((inst2) => {
    const bag = inst2._zod.bag;
    bag.format = def.format;
    bag.minimum = minimum;
    bag.maximum = maximum;
    if (isInt)
      bag.pattern = integer;
  });
  inst._zod.check = (payload) => {
    const input = payload.value;
    if (isInt) {
      if (!Number.isInteger(input)) {
        payload.issues.push({
          expected: origin,
          format: def.format,
          code: "invalid_type",
          input,
          inst
        });
        return;
      }
      if (!Number.isSafeInteger(input)) {
        if (input > 0) {
          payload.issues.push({
            input,
            code: "too_big",
            maximum: Number.MAX_SAFE_INTEGER,
            note: "Integers must be within the safe integer range.",
            inst,
            origin,
            continue: !def.abort
          });
        } else {
          payload.issues.push({
            input,
            code: "too_small",
            minimum: Number.MIN_SAFE_INTEGER,
            note: "Integers must be within the safe integer range.",
            inst,
            origin,
            continue: !def.abort
          });
        }
        return;
      }
    }
    if (input < minimum) {
      payload.issues.push({
        origin: "number",
        input,
        code: "too_small",
        minimum,
        inclusive: true,
        inst,
        continue: !def.abort
      });
    }
    if (input > maximum) {
      payload.issues.push({
        origin: "number",
        input,
        code: "too_big",
        maximum,
        inst
      });
    }
  };
});
const $ZodCheckMaxLength = /* @__PURE__ */ $constructor("$ZodCheckMaxLength", (inst, def) => {
  var _a2;
  $ZodCheck.init(inst, def);
  (_a2 = inst._zod.def).when ?? (_a2.when = (payload) => {
    const val = payload.value;
    return !nullish(val) && val.length !== void 0;
  });
  inst._zod.onattach.push((inst2) => {
    const curr = inst2._zod.bag.maximum ?? Number.POSITIVE_INFINITY;
    if (def.maximum < curr)
      inst2._zod.bag.maximum = def.maximum;
  });
  inst._zod.check = (payload) => {
    const input = payload.value;
    const length = input.length;
    if (length <= def.maximum)
      return;
    const origin = getLengthableOrigin(input);
    payload.issues.push({
      origin,
      code: "too_big",
      maximum: def.maximum,
      inclusive: true,
      input,
      inst,
      continue: !def.abort
    });
  };
});
const $ZodCheckMinLength = /* @__PURE__ */ $constructor("$ZodCheckMinLength", (inst, def) => {
  var _a2;
  $ZodCheck.init(inst, def);
  (_a2 = inst._zod.def).when ?? (_a2.when = (payload) => {
    const val = payload.value;
    return !nullish(val) && val.length !== void 0;
  });
  inst._zod.onattach.push((inst2) => {
    const curr = inst2._zod.bag.minimum ?? Number.NEGATIVE_INFINITY;
    if (def.minimum > curr)
      inst2._zod.bag.minimum = def.minimum;
  });
  inst._zod.check = (payload) => {
    const input = payload.value;
    const length = input.length;
    if (length >= def.minimum)
      return;
    const origin = getLengthableOrigin(input);
    payload.issues.push({
      origin,
      code: "too_small",
      minimum: def.minimum,
      inclusive: true,
      input,
      inst,
      continue: !def.abort
    });
  };
});
const $ZodCheckLengthEquals = /* @__PURE__ */ $constructor("$ZodCheckLengthEquals", (inst, def) => {
  var _a2;
  $ZodCheck.init(inst, def);
  (_a2 = inst._zod.def).when ?? (_a2.when = (payload) => {
    const val = payload.value;
    return !nullish(val) && val.length !== void 0;
  });
  inst._zod.onattach.push((inst2) => {
    const bag = inst2._zod.bag;
    bag.minimum = def.length;
    bag.maximum = def.length;
    bag.length = def.length;
  });
  inst._zod.check = (payload) => {
    const input = payload.value;
    const length = input.length;
    if (length === def.length)
      return;
    const origin = getLengthableOrigin(input);
    const tooBig = length > def.length;
    payload.issues.push({
      origin,
      ...tooBig ? { code: "too_big", maximum: def.length } : { code: "too_small", minimum: def.length },
      inclusive: true,
      exact: true,
      input: payload.value,
      inst,
      continue: !def.abort
    });
  };
});
const $ZodCheckStringFormat = /* @__PURE__ */ $constructor("$ZodCheckStringFormat", (inst, def) => {
  var _a2, _b;
  $ZodCheck.init(inst, def);
  inst._zod.onattach.push((inst2) => {
    const bag = inst2._zod.bag;
    bag.format = def.format;
    if (def.pattern) {
      bag.patterns ?? (bag.patterns = /* @__PURE__ */ new Set());
      bag.patterns.add(def.pattern);
    }
  });
  if (def.pattern)
    (_a2 = inst._zod).check ?? (_a2.check = (payload) => {
      def.pattern.lastIndex = 0;
      if (def.pattern.test(payload.value))
        return;
      payload.issues.push({
        origin: "string",
        code: "invalid_format",
        format: def.format,
        input: payload.value,
        ...def.pattern ? { pattern: def.pattern.toString() } : {},
        inst,
        continue: !def.abort
      });
    });
  else
    (_b = inst._zod).check ?? (_b.check = () => {
    });
});
const $ZodCheckRegex = /* @__PURE__ */ $constructor("$ZodCheckRegex", (inst, def) => {
  $ZodCheckStringFormat.init(inst, def);
  inst._zod.check = (payload) => {
    def.pattern.lastIndex = 0;
    if (def.pattern.test(payload.value))
      return;
    payload.issues.push({
      origin: "string",
      code: "invalid_format",
      format: "regex",
      input: payload.value,
      pattern: def.pattern.toString(),
      inst,
      continue: !def.abort
    });
  };
});
const $ZodCheckLowerCase = /* @__PURE__ */ $constructor("$ZodCheckLowerCase", (inst, def) => {
  def.pattern ?? (def.pattern = lowercase);
  $ZodCheckStringFormat.init(inst, def);
});
const $ZodCheckUpperCase = /* @__PURE__ */ $constructor("$ZodCheckUpperCase", (inst, def) => {
  def.pattern ?? (def.pattern = uppercase);
  $ZodCheckStringFormat.init(inst, def);
});
const $ZodCheckIncludes = /* @__PURE__ */ $constructor("$ZodCheckIncludes", (inst, def) => {
  $ZodCheck.init(inst, def);
  const escapedRegex = escapeRegex(def.includes);
  const pattern2 = new RegExp(typeof def.position === "number" ? `^.{${def.position}}${escapedRegex}` : escapedRegex);
  def.pattern = pattern2;
  inst._zod.onattach.push((inst2) => {
    const bag = inst2._zod.bag;
    bag.patterns ?? (bag.patterns = /* @__PURE__ */ new Set());
    bag.patterns.add(pattern2);
  });
  inst._zod.check = (payload) => {
    if (payload.value.includes(def.includes, def.position))
      return;
    payload.issues.push({
      origin: "string",
      code: "invalid_format",
      format: "includes",
      includes: def.includes,
      input: payload.value,
      inst,
      continue: !def.abort
    });
  };
});
const $ZodCheckStartsWith = /* @__PURE__ */ $constructor("$ZodCheckStartsWith", (inst, def) => {
  $ZodCheck.init(inst, def);
  const pattern2 = new RegExp(`^${escapeRegex(def.prefix)}.*`);
  def.pattern ?? (def.pattern = pattern2);
  inst._zod.onattach.push((inst2) => {
    const bag = inst2._zod.bag;
    bag.patterns ?? (bag.patterns = /* @__PURE__ */ new Set());
    bag.patterns.add(pattern2);
  });
  inst._zod.check = (payload) => {
    if (payload.value.startsWith(def.prefix))
      return;
    payload.issues.push({
      origin: "string",
      code: "invalid_format",
      format: "starts_with",
      prefix: def.prefix,
      input: payload.value,
      inst,
      continue: !def.abort
    });
  };
});
const $ZodCheckEndsWith = /* @__PURE__ */ $constructor("$ZodCheckEndsWith", (inst, def) => {
  $ZodCheck.init(inst, def);
  const pattern2 = new RegExp(`.*${escapeRegex(def.suffix)}$`);
  def.pattern ?? (def.pattern = pattern2);
  inst._zod.onattach.push((inst2) => {
    const bag = inst2._zod.bag;
    bag.patterns ?? (bag.patterns = /* @__PURE__ */ new Set());
    bag.patterns.add(pattern2);
  });
  inst._zod.check = (payload) => {
    if (payload.value.endsWith(def.suffix))
      return;
    payload.issues.push({
      origin: "string",
      code: "invalid_format",
      format: "ends_with",
      suffix: def.suffix,
      input: payload.value,
      inst,
      continue: !def.abort
    });
  };
});
const $ZodCheckOverwrite = /* @__PURE__ */ $constructor("$ZodCheckOverwrite", (inst, def) => {
  $ZodCheck.init(inst, def);
  inst._zod.check = (payload) => {
    payload.value = def.tx(payload.value);
  };
});
class Doc {
  constructor(args = []) {
    this.content = [];
    this.indent = 0;
    if (this)
      this.args = args;
  }
  indented(fn2) {
    this.indent += 1;
    fn2(this);
    this.indent -= 1;
  }
  write(arg) {
    if (typeof arg === "function") {
      arg(this, { execution: "sync" });
      arg(this, { execution: "async" });
      return;
    }
    const content = arg;
    const lines = content.split("\n").filter((x2) => x2);
    const minIndent = Math.min(...lines.map((x2) => x2.length - x2.trimStart().length));
    const dedented = lines.map((x2) => x2.slice(minIndent)).map((x2) => " ".repeat(this.indent * 2) + x2);
    for (const line of dedented) {
      this.content.push(line);
    }
  }
  compile() {
    const F2 = Function;
    const args = this?.args;
    const content = this?.content ?? [``];
    const lines = [...content.map((x2) => `  ${x2}`)];
    return new F2(...args, lines.join("\n"));
  }
}
const version$2 = {
  major: 4,
  minor: 0,
  patch: 0
};
const $ZodType = /* @__PURE__ */ $constructor("$ZodType", (inst, def) => {
  var _a2;
  inst ?? (inst = {});
  inst._zod.def = def;
  inst._zod.bag = inst._zod.bag || {};
  inst._zod.version = version$2;
  const checks = [...inst._zod.def.checks ?? []];
  if (inst._zod.traits.has("$ZodCheck")) {
    checks.unshift(inst);
  }
  for (const ch2 of checks) {
    for (const fn2 of ch2._zod.onattach) {
      fn2(inst);
    }
  }
  if (checks.length === 0) {
    (_a2 = inst._zod).deferred ?? (_a2.deferred = []);
    inst._zod.deferred?.push(() => {
      inst._zod.run = inst._zod.parse;
    });
  } else {
    const runChecks = (payload, checks2, ctx) => {
      let isAborted2 = aborted(payload);
      let asyncResult;
      for (const ch2 of checks2) {
        if (ch2._zod.def.when) {
          const shouldRun = ch2._zod.def.when(payload);
          if (!shouldRun)
            continue;
        } else if (isAborted2) {
          continue;
        }
        const currLen = payload.issues.length;
        const _2 = ch2._zod.check(payload);
        if (_2 instanceof Promise && ctx?.async === false) {
          throw new $ZodAsyncError();
        }
        if (asyncResult || _2 instanceof Promise) {
          asyncResult = (asyncResult ?? Promise.resolve()).then(async () => {
            await _2;
            const nextLen = payload.issues.length;
            if (nextLen === currLen)
              return;
            if (!isAborted2)
              isAborted2 = aborted(payload, currLen);
          });
        } else {
          const nextLen = payload.issues.length;
          if (nextLen === currLen)
            continue;
          if (!isAborted2)
            isAborted2 = aborted(payload, currLen);
        }
      }
      if (asyncResult) {
        return asyncResult.then(() => {
          return payload;
        });
      }
      return payload;
    };
    inst._zod.run = (payload, ctx) => {
      const result = inst._zod.parse(payload, ctx);
      if (result instanceof Promise) {
        if (ctx.async === false)
          throw new $ZodAsyncError();
        return result.then((result2) => runChecks(result2, checks, ctx));
      }
      return runChecks(result, checks, ctx);
    };
  }
  inst["~standard"] = {
    validate: (value) => {
      try {
        const r2 = safeParse$2(inst, value);
        return r2.success ? { value: r2.data } : { issues: r2.error?.issues };
      } catch (_2) {
        return safeParseAsync$1(inst, value).then((r2) => r2.success ? { value: r2.data } : { issues: r2.error?.issues });
      }
    },
    vendor: "zod",
    version: 1
  };
});
const $ZodString = /* @__PURE__ */ $constructor("$ZodString", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.pattern = [...inst?._zod.bag?.patterns ?? []].pop() ?? string$1(inst._zod.bag);
  inst._zod.parse = (payload, _2) => {
    if (def.coerce)
      try {
        payload.value = String(payload.value);
      } catch (_3) {
      }
    if (typeof payload.value === "string")
      return payload;
    payload.issues.push({
      expected: "string",
      code: "invalid_type",
      input: payload.value,
      inst
    });
    return payload;
  };
});
const $ZodStringFormat = /* @__PURE__ */ $constructor("$ZodStringFormat", (inst, def) => {
  $ZodCheckStringFormat.init(inst, def);
  $ZodString.init(inst, def);
});
const $ZodGUID = /* @__PURE__ */ $constructor("$ZodGUID", (inst, def) => {
  def.pattern ?? (def.pattern = guid);
  $ZodStringFormat.init(inst, def);
});
const $ZodUUID = /* @__PURE__ */ $constructor("$ZodUUID", (inst, def) => {
  if (def.version) {
    const versionMap = {
      v1: 1,
      v2: 2,
      v3: 3,
      v4: 4,
      v5: 5,
      v6: 6,
      v7: 7,
      v8: 8
    };
    const v = versionMap[def.version];
    if (v === void 0)
      throw new Error(`Invalid UUID version: "${def.version}"`);
    def.pattern ?? (def.pattern = uuid(v));
  } else
    def.pattern ?? (def.pattern = uuid());
  $ZodStringFormat.init(inst, def);
});
const $ZodEmail = /* @__PURE__ */ $constructor("$ZodEmail", (inst, def) => {
  def.pattern ?? (def.pattern = email);
  $ZodStringFormat.init(inst, def);
});
const $ZodURL = /* @__PURE__ */ $constructor("$ZodURL", (inst, def) => {
  $ZodStringFormat.init(inst, def);
  inst._zod.check = (payload) => {
    try {
      const orig = payload.value;
      const url2 = new URL(orig);
      const href = url2.href;
      if (def.hostname) {
        def.hostname.lastIndex = 0;
        if (!def.hostname.test(url2.hostname)) {
          payload.issues.push({
            code: "invalid_format",
            format: "url",
            note: "Invalid hostname",
            pattern: hostname.source,
            input: payload.value,
            inst,
            continue: !def.abort
          });
        }
      }
      if (def.protocol) {
        def.protocol.lastIndex = 0;
        if (!def.protocol.test(url2.protocol.endsWith(":") ? url2.protocol.slice(0, -1) : url2.protocol)) {
          payload.issues.push({
            code: "invalid_format",
            format: "url",
            note: "Invalid protocol",
            pattern: def.protocol.source,
            input: payload.value,
            inst,
            continue: !def.abort
          });
        }
      }
      if (!orig.endsWith("/") && href.endsWith("/")) {
        payload.value = href.slice(0, -1);
      } else {
        payload.value = href;
      }
      return;
    } catch (_2) {
      payload.issues.push({
        code: "invalid_format",
        format: "url",
        input: payload.value,
        inst,
        continue: !def.abort
      });
    }
  };
});
const $ZodEmoji = /* @__PURE__ */ $constructor("$ZodEmoji", (inst, def) => {
  def.pattern ?? (def.pattern = emoji());
  $ZodStringFormat.init(inst, def);
});
const $ZodNanoID = /* @__PURE__ */ $constructor("$ZodNanoID", (inst, def) => {
  def.pattern ?? (def.pattern = nanoid);
  $ZodStringFormat.init(inst, def);
});
const $ZodCUID = /* @__PURE__ */ $constructor("$ZodCUID", (inst, def) => {
  def.pattern ?? (def.pattern = cuid);
  $ZodStringFormat.init(inst, def);
});
const $ZodCUID2 = /* @__PURE__ */ $constructor("$ZodCUID2", (inst, def) => {
  def.pattern ?? (def.pattern = cuid2);
  $ZodStringFormat.init(inst, def);
});
const $ZodULID = /* @__PURE__ */ $constructor("$ZodULID", (inst, def) => {
  def.pattern ?? (def.pattern = ulid);
  $ZodStringFormat.init(inst, def);
});
const $ZodXID = /* @__PURE__ */ $constructor("$ZodXID", (inst, def) => {
  def.pattern ?? (def.pattern = xid);
  $ZodStringFormat.init(inst, def);
});
const $ZodKSUID = /* @__PURE__ */ $constructor("$ZodKSUID", (inst, def) => {
  def.pattern ?? (def.pattern = ksuid);
  $ZodStringFormat.init(inst, def);
});
const $ZodISODateTime = /* @__PURE__ */ $constructor("$ZodISODateTime", (inst, def) => {
  def.pattern ?? (def.pattern = datetime$1(def));
  $ZodStringFormat.init(inst, def);
});
const $ZodISODate = /* @__PURE__ */ $constructor("$ZodISODate", (inst, def) => {
  def.pattern ?? (def.pattern = date$1);
  $ZodStringFormat.init(inst, def);
});
const $ZodISOTime = /* @__PURE__ */ $constructor("$ZodISOTime", (inst, def) => {
  def.pattern ?? (def.pattern = time$1(def));
  $ZodStringFormat.init(inst, def);
});
const $ZodISODuration = /* @__PURE__ */ $constructor("$ZodISODuration", (inst, def) => {
  def.pattern ?? (def.pattern = duration$1);
  $ZodStringFormat.init(inst, def);
});
const $ZodIPv4 = /* @__PURE__ */ $constructor("$ZodIPv4", (inst, def) => {
  def.pattern ?? (def.pattern = ipv4);
  $ZodStringFormat.init(inst, def);
  inst._zod.onattach.push((inst2) => {
    const bag = inst2._zod.bag;
    bag.format = `ipv4`;
  });
});
const $ZodIPv6 = /* @__PURE__ */ $constructor("$ZodIPv6", (inst, def) => {
  def.pattern ?? (def.pattern = ipv6);
  $ZodStringFormat.init(inst, def);
  inst._zod.onattach.push((inst2) => {
    const bag = inst2._zod.bag;
    bag.format = `ipv6`;
  });
  inst._zod.check = (payload) => {
    try {
      new URL(`http://[${payload.value}]`);
    } catch {
      payload.issues.push({
        code: "invalid_format",
        format: "ipv6",
        input: payload.value,
        inst,
        continue: !def.abort
      });
    }
  };
});
const $ZodCIDRv4 = /* @__PURE__ */ $constructor("$ZodCIDRv4", (inst, def) => {
  def.pattern ?? (def.pattern = cidrv4);
  $ZodStringFormat.init(inst, def);
});
const $ZodCIDRv6 = /* @__PURE__ */ $constructor("$ZodCIDRv6", (inst, def) => {
  def.pattern ?? (def.pattern = cidrv6);
  $ZodStringFormat.init(inst, def);
  inst._zod.check = (payload) => {
    const [address, prefix] = payload.value.split("/");
    try {
      if (!prefix)
        throw new Error();
      const prefixNum = Number(prefix);
      if (`${prefixNum}` !== prefix)
        throw new Error();
      if (prefixNum < 0 || prefixNum > 128)
        throw new Error();
      new URL(`http://[${address}]`);
    } catch {
      payload.issues.push({
        code: "invalid_format",
        format: "cidrv6",
        input: payload.value,
        inst,
        continue: !def.abort
      });
    }
  };
});
function isValidBase64(data2) {
  if (data2 === "")
    return true;
  if (data2.length % 4 !== 0)
    return false;
  try {
    atob(data2);
    return true;
  } catch {
    return false;
  }
}
const $ZodBase64 = /* @__PURE__ */ $constructor("$ZodBase64", (inst, def) => {
  def.pattern ?? (def.pattern = base64);
  $ZodStringFormat.init(inst, def);
  inst._zod.onattach.push((inst2) => {
    inst2._zod.bag.contentEncoding = "base64";
  });
  inst._zod.check = (payload) => {
    if (isValidBase64(payload.value))
      return;
    payload.issues.push({
      code: "invalid_format",
      format: "base64",
      input: payload.value,
      inst,
      continue: !def.abort
    });
  };
});
function isValidBase64URL(data2) {
  if (!base64url.test(data2))
    return false;
  const base642 = data2.replace(/[-_]/g, (c) => c === "-" ? "+" : "/");
  const padded = base642.padEnd(Math.ceil(base642.length / 4) * 4, "=");
  return isValidBase64(padded);
}
const $ZodBase64URL = /* @__PURE__ */ $constructor("$ZodBase64URL", (inst, def) => {
  def.pattern ?? (def.pattern = base64url);
  $ZodStringFormat.init(inst, def);
  inst._zod.onattach.push((inst2) => {
    inst2._zod.bag.contentEncoding = "base64url";
  });
  inst._zod.check = (payload) => {
    if (isValidBase64URL(payload.value))
      return;
    payload.issues.push({
      code: "invalid_format",
      format: "base64url",
      input: payload.value,
      inst,
      continue: !def.abort
    });
  };
});
const $ZodE164 = /* @__PURE__ */ $constructor("$ZodE164", (inst, def) => {
  def.pattern ?? (def.pattern = e164);
  $ZodStringFormat.init(inst, def);
});
function isValidJWT$1(token, algorithm = null) {
  try {
    const tokensParts = token.split(".");
    if (tokensParts.length !== 3)
      return false;
    const [header] = tokensParts;
    if (!header)
      return false;
    const parsedHeader = JSON.parse(atob(header));
    if ("typ" in parsedHeader && parsedHeader?.typ !== "JWT")
      return false;
    if (!parsedHeader.alg)
      return false;
    if (algorithm && (!("alg" in parsedHeader) || parsedHeader.alg !== algorithm))
      return false;
    return true;
  } catch {
    return false;
  }
}
const $ZodJWT = /* @__PURE__ */ $constructor("$ZodJWT", (inst, def) => {
  $ZodStringFormat.init(inst, def);
  inst._zod.check = (payload) => {
    if (isValidJWT$1(payload.value, def.alg))
      return;
    payload.issues.push({
      code: "invalid_format",
      format: "jwt",
      input: payload.value,
      inst,
      continue: !def.abort
    });
  };
});
const $ZodNumber = /* @__PURE__ */ $constructor("$ZodNumber", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.pattern = inst._zod.bag.pattern ?? number$2;
  inst._zod.parse = (payload, _ctx) => {
    if (def.coerce)
      try {
        payload.value = Number(payload.value);
      } catch (_2) {
      }
    const input = payload.value;
    if (typeof input === "number" && !Number.isNaN(input) && Number.isFinite(input)) {
      return payload;
    }
    const received = typeof input === "number" ? Number.isNaN(input) ? "NaN" : !Number.isFinite(input) ? "Infinity" : void 0 : void 0;
    payload.issues.push({
      expected: "number",
      code: "invalid_type",
      input,
      inst,
      ...received ? { received } : {}
    });
    return payload;
  };
});
const $ZodNumberFormat = /* @__PURE__ */ $constructor("$ZodNumber", (inst, def) => {
  $ZodCheckNumberFormat.init(inst, def);
  $ZodNumber.init(inst, def);
});
const $ZodBoolean = /* @__PURE__ */ $constructor("$ZodBoolean", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.pattern = boolean$1;
  inst._zod.parse = (payload, _ctx) => {
    if (def.coerce)
      try {
        payload.value = Boolean(payload.value);
      } catch (_2) {
      }
    const input = payload.value;
    if (typeof input === "boolean")
      return payload;
    payload.issues.push({
      expected: "boolean",
      code: "invalid_type",
      input,
      inst
    });
    return payload;
  };
});
const $ZodNull = /* @__PURE__ */ $constructor("$ZodNull", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.pattern = _null$2;
  inst._zod.values = /* @__PURE__ */ new Set([null]);
  inst._zod.parse = (payload, _ctx) => {
    const input = payload.value;
    if (input === null)
      return payload;
    payload.issues.push({
      expected: "null",
      code: "invalid_type",
      input,
      inst
    });
    return payload;
  };
});
const $ZodAny = /* @__PURE__ */ $constructor("$ZodAny", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.parse = (payload) => payload;
});
const $ZodUnknown = /* @__PURE__ */ $constructor("$ZodUnknown", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.parse = (payload) => payload;
});
const $ZodNever = /* @__PURE__ */ $constructor("$ZodNever", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.parse = (payload, _ctx) => {
    payload.issues.push({
      expected: "never",
      code: "invalid_type",
      input: payload.value,
      inst
    });
    return payload;
  };
});
function handleArrayResult(result, final, index2) {
  if (result.issues.length) {
    final.issues.push(...prefixIssues(index2, result.issues));
  }
  final.value[index2] = result.value;
}
const $ZodArray = /* @__PURE__ */ $constructor("$ZodArray", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.parse = (payload, ctx) => {
    const input = payload.value;
    if (!Array.isArray(input)) {
      payload.issues.push({
        expected: "array",
        code: "invalid_type",
        input,
        inst
      });
      return payload;
    }
    payload.value = Array(input.length);
    const proms = [];
    for (let i = 0; i < input.length; i++) {
      const item = input[i];
      const result = def.element._zod.run({
        value: item,
        issues: []
      }, ctx);
      if (result instanceof Promise) {
        proms.push(result.then((result2) => handleArrayResult(result2, payload, i)));
      } else {
        handleArrayResult(result, payload, i);
      }
    }
    if (proms.length) {
      return Promise.all(proms).then(() => payload);
    }
    return payload;
  };
});
function handleObjectResult(result, final, key) {
  if (result.issues.length) {
    final.issues.push(...prefixIssues(key, result.issues));
  }
  final.value[key] = result.value;
}
function handleOptionalObjectResult(result, final, key, input) {
  if (result.issues.length) {
    if (input[key] === void 0) {
      if (key in input) {
        final.value[key] = void 0;
      } else {
        final.value[key] = result.value;
      }
    } else {
      final.issues.push(...prefixIssues(key, result.issues));
    }
  } else if (result.value === void 0) {
    if (key in input)
      final.value[key] = void 0;
  } else {
    final.value[key] = result.value;
  }
}
const $ZodObject = /* @__PURE__ */ $constructor("$ZodObject", (inst, def) => {
  $ZodType.init(inst, def);
  const _normalized = cached(() => {
    const keys = Object.keys(def.shape);
    for (const k2 of keys) {
      if (!(def.shape[k2] instanceof $ZodType)) {
        throw new Error(`Invalid element at key "${k2}": expected a Zod schema`);
      }
    }
    const okeys = optionalKeys(def.shape);
    return {
      shape: def.shape,
      keys,
      keySet: new Set(keys),
      numKeys: keys.length,
      optionalKeys: new Set(okeys)
    };
  });
  defineLazy(inst._zod, "propValues", () => {
    const shape = def.shape;
    const propValues = {};
    for (const key in shape) {
      const field = shape[key]._zod;
      if (field.values) {
        propValues[key] ?? (propValues[key] = /* @__PURE__ */ new Set());
        for (const v of field.values)
          propValues[key].add(v);
      }
    }
    return propValues;
  });
  const generateFastpass = (shape) => {
    const doc = new Doc(["shape", "payload", "ctx"]);
    const normalized = _normalized.value;
    const parseStr = (key) => {
      const k2 = esc(key);
      return `shape[${k2}]._zod.run({ value: input[${k2}], issues: [] }, ctx)`;
    };
    doc.write(`const input = payload.value;`);
    const ids = /* @__PURE__ */ Object.create(null);
    let counter = 0;
    for (const key of normalized.keys) {
      ids[key] = `key_${counter++}`;
    }
    doc.write(`const newResult = {}`);
    for (const key of normalized.keys) {
      if (normalized.optionalKeys.has(key)) {
        const id2 = ids[key];
        doc.write(`const ${id2} = ${parseStr(key)};`);
        const k2 = esc(key);
        doc.write(`
        if (${id2}.issues.length) {
          if (input[${k2}] === undefined) {
            if (${k2} in input) {
              newResult[${k2}] = undefined;
            }
          } else {
            payload.issues = payload.issues.concat(
              ${id2}.issues.map((iss) => ({
                ...iss,
                path: iss.path ? [${k2}, ...iss.path] : [${k2}],
              }))
            );
          }
        } else if (${id2}.value === undefined) {
          if (${k2} in input) newResult[${k2}] = undefined;
        } else {
          newResult[${k2}] = ${id2}.value;
        }
        `);
      } else {
        const id2 = ids[key];
        doc.write(`const ${id2} = ${parseStr(key)};`);
        doc.write(`
          if (${id2}.issues.length) payload.issues = payload.issues.concat(${id2}.issues.map(iss => ({
            ...iss,
            path: iss.path ? [${esc(key)}, ...iss.path] : [${esc(key)}]
          })));`);
        doc.write(`newResult[${esc(key)}] = ${id2}.value`);
      }
    }
    doc.write(`payload.value = newResult;`);
    doc.write(`return payload;`);
    const fn2 = doc.compile();
    return (payload, ctx) => fn2(shape, payload, ctx);
  };
  let fastpass;
  const isObject$1 = isObject;
  const jit = !globalConfig.jitless;
  const allowsEval$1 = allowsEval;
  const fastEnabled = jit && allowsEval$1.value;
  const catchall = def.catchall;
  let value;
  inst._zod.parse = (payload, ctx) => {
    value ?? (value = _normalized.value);
    const input = payload.value;
    if (!isObject$1(input)) {
      payload.issues.push({
        expected: "object",
        code: "invalid_type",
        input,
        inst
      });
      return payload;
    }
    const proms = [];
    if (jit && fastEnabled && ctx?.async === false && ctx.jitless !== true) {
      if (!fastpass)
        fastpass = generateFastpass(def.shape);
      payload = fastpass(payload, ctx);
    } else {
      payload.value = {};
      const shape = value.shape;
      for (const key of value.keys) {
        const el2 = shape[key];
        const r2 = el2._zod.run({ value: input[key], issues: [] }, ctx);
        const isOptional = el2._zod.optin === "optional" && el2._zod.optout === "optional";
        if (r2 instanceof Promise) {
          proms.push(r2.then((r3) => isOptional ? handleOptionalObjectResult(r3, payload, key, input) : handleObjectResult(r3, payload, key)));
        } else if (isOptional) {
          handleOptionalObjectResult(r2, payload, key, input);
        } else {
          handleObjectResult(r2, payload, key);
        }
      }
    }
    if (!catchall) {
      return proms.length ? Promise.all(proms).then(() => payload) : payload;
    }
    const unrecognized = [];
    const keySet = value.keySet;
    const _catchall = catchall._zod;
    const t = _catchall.def.type;
    for (const key of Object.keys(input)) {
      if (keySet.has(key))
        continue;
      if (t === "never") {
        unrecognized.push(key);
        continue;
      }
      const r2 = _catchall.run({ value: input[key], issues: [] }, ctx);
      if (r2 instanceof Promise) {
        proms.push(r2.then((r3) => handleObjectResult(r3, payload, key)));
      } else {
        handleObjectResult(r2, payload, key);
      }
    }
    if (unrecognized.length) {
      payload.issues.push({
        code: "unrecognized_keys",
        keys: unrecognized,
        input,
        inst
      });
    }
    if (!proms.length)
      return payload;
    return Promise.all(proms).then(() => {
      return payload;
    });
  };
});
function handleUnionResults(results, final, inst, ctx) {
  for (const result of results) {
    if (result.issues.length === 0) {
      final.value = result.value;
      return final;
    }
  }
  final.issues.push({
    code: "invalid_union",
    input: final.value,
    inst,
    errors: results.map((result) => result.issues.map((iss) => finalizeIssue(iss, ctx, config())))
  });
  return final;
}
const $ZodUnion = /* @__PURE__ */ $constructor("$ZodUnion", (inst, def) => {
  $ZodType.init(inst, def);
  defineLazy(inst._zod, "optin", () => def.options.some((o) => o._zod.optin === "optional") ? "optional" : void 0);
  defineLazy(inst._zod, "optout", () => def.options.some((o) => o._zod.optout === "optional") ? "optional" : void 0);
  defineLazy(inst._zod, "values", () => {
    if (def.options.every((o) => o._zod.values)) {
      return new Set(def.options.flatMap((option) => Array.from(option._zod.values)));
    }
    return void 0;
  });
  defineLazy(inst._zod, "pattern", () => {
    if (def.options.every((o) => o._zod.pattern)) {
      const patterns = def.options.map((o) => o._zod.pattern);
      return new RegExp(`^(${patterns.map((p2) => cleanRegex(p2.source)).join("|")})$`);
    }
    return void 0;
  });
  inst._zod.parse = (payload, ctx) => {
    let async2 = false;
    const results = [];
    for (const option of def.options) {
      const result = option._zod.run({
        value: payload.value,
        issues: []
      }, ctx);
      if (result instanceof Promise) {
        results.push(result);
        async2 = true;
      } else {
        if (result.issues.length === 0)
          return result;
        results.push(result);
      }
    }
    if (!async2)
      return handleUnionResults(results, payload, inst, ctx);
    return Promise.all(results).then((results2) => {
      return handleUnionResults(results2, payload, inst, ctx);
    });
  };
});
const $ZodDiscriminatedUnion = /* @__PURE__ */ $constructor("$ZodDiscriminatedUnion", (inst, def) => {
  $ZodUnion.init(inst, def);
  const _super = inst._zod.parse;
  defineLazy(inst._zod, "propValues", () => {
    const propValues = {};
    for (const option of def.options) {
      const pv2 = option._zod.propValues;
      if (!pv2 || Object.keys(pv2).length === 0)
        throw new Error(`Invalid discriminated union option at index "${def.options.indexOf(option)}"`);
      for (const [k2, v] of Object.entries(pv2)) {
        if (!propValues[k2])
          propValues[k2] = /* @__PURE__ */ new Set();
        for (const val of v) {
          propValues[k2].add(val);
        }
      }
    }
    return propValues;
  });
  const disc = cached(() => {
    const opts = def.options;
    const map = /* @__PURE__ */ new Map();
    for (const o of opts) {
      const values = o._zod.propValues[def.discriminator];
      if (!values || values.size === 0)
        throw new Error(`Invalid discriminated union option at index "${def.options.indexOf(o)}"`);
      for (const v of values) {
        if (map.has(v)) {
          throw new Error(`Duplicate discriminator value "${String(v)}"`);
        }
        map.set(v, o);
      }
    }
    return map;
  });
  inst._zod.parse = (payload, ctx) => {
    const input = payload.value;
    if (!isObject(input)) {
      payload.issues.push({
        code: "invalid_type",
        expected: "object",
        input,
        inst
      });
      return payload;
    }
    const opt = disc.value.get(input?.[def.discriminator]);
    if (opt) {
      return opt._zod.run(payload, ctx);
    }
    if (def.unionFallback) {
      return _super(payload, ctx);
    }
    payload.issues.push({
      code: "invalid_union",
      errors: [],
      note: "No matching discriminator",
      input,
      path: [def.discriminator],
      inst
    });
    return payload;
  };
});
const $ZodIntersection = /* @__PURE__ */ $constructor("$ZodIntersection", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.parse = (payload, ctx) => {
    const input = payload.value;
    const left = def.left._zod.run({ value: input, issues: [] }, ctx);
    const right = def.right._zod.run({ value: input, issues: [] }, ctx);
    const async2 = left instanceof Promise || right instanceof Promise;
    if (async2) {
      return Promise.all([left, right]).then(([left2, right2]) => {
        return handleIntersectionResults(payload, left2, right2);
      });
    }
    return handleIntersectionResults(payload, left, right);
  };
});
function mergeValues$1(a2, b) {
  if (a2 === b) {
    return { valid: true, data: a2 };
  }
  if (a2 instanceof Date && b instanceof Date && +a2 === +b) {
    return { valid: true, data: a2 };
  }
  if (isPlainObject$1(a2) && isPlainObject$1(b)) {
    const bKeys = Object.keys(b);
    const sharedKeys = Object.keys(a2).filter((key) => bKeys.indexOf(key) !== -1);
    const newObj = { ...a2, ...b };
    for (const key of sharedKeys) {
      const sharedValue = mergeValues$1(a2[key], b[key]);
      if (!sharedValue.valid) {
        return {
          valid: false,
          mergeErrorPath: [key, ...sharedValue.mergeErrorPath]
        };
      }
      newObj[key] = sharedValue.data;
    }
    return { valid: true, data: newObj };
  }
  if (Array.isArray(a2) && Array.isArray(b)) {
    if (a2.length !== b.length) {
      return { valid: false, mergeErrorPath: [] };
    }
    const newArray = [];
    for (let index2 = 0; index2 < a2.length; index2++) {
      const itemA = a2[index2];
      const itemB = b[index2];
      const sharedValue = mergeValues$1(itemA, itemB);
      if (!sharedValue.valid) {
        return {
          valid: false,
          mergeErrorPath: [index2, ...sharedValue.mergeErrorPath]
        };
      }
      newArray.push(sharedValue.data);
    }
    return { valid: true, data: newArray };
  }
  return { valid: false, mergeErrorPath: [] };
}
function handleIntersectionResults(result, left, right) {
  if (left.issues.length) {
    result.issues.push(...left.issues);
  }
  if (right.issues.length) {
    result.issues.push(...right.issues);
  }
  if (aborted(result))
    return result;
  const merged = mergeValues$1(left.value, right.value);
  if (!merged.valid) {
    throw new Error(`Unmergable intersection. Error path: ${JSON.stringify(merged.mergeErrorPath)}`);
  }
  result.value = merged.data;
  return result;
}
const $ZodRecord = /* @__PURE__ */ $constructor("$ZodRecord", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.parse = (payload, ctx) => {
    const input = payload.value;
    if (!isPlainObject$1(input)) {
      payload.issues.push({
        expected: "record",
        code: "invalid_type",
        input,
        inst
      });
      return payload;
    }
    const proms = [];
    if (def.keyType._zod.values) {
      const values = def.keyType._zod.values;
      payload.value = {};
      for (const key of values) {
        if (typeof key === "string" || typeof key === "number" || typeof key === "symbol") {
          const result = def.valueType._zod.run({ value: input[key], issues: [] }, ctx);
          if (result instanceof Promise) {
            proms.push(result.then((result2) => {
              if (result2.issues.length) {
                payload.issues.push(...prefixIssues(key, result2.issues));
              }
              payload.value[key] = result2.value;
            }));
          } else {
            if (result.issues.length) {
              payload.issues.push(...prefixIssues(key, result.issues));
            }
            payload.value[key] = result.value;
          }
        }
      }
      let unrecognized;
      for (const key in input) {
        if (!values.has(key)) {
          unrecognized = unrecognized ?? [];
          unrecognized.push(key);
        }
      }
      if (unrecognized && unrecognized.length > 0) {
        payload.issues.push({
          code: "unrecognized_keys",
          input,
          inst,
          keys: unrecognized
        });
      }
    } else {
      payload.value = {};
      for (const key of Reflect.ownKeys(input)) {
        if (key === "__proto__")
          continue;
        const keyResult = def.keyType._zod.run({ value: key, issues: [] }, ctx);
        if (keyResult instanceof Promise) {
          throw new Error("Async schemas not supported in object keys currently");
        }
        if (keyResult.issues.length) {
          payload.issues.push({
            origin: "record",
            code: "invalid_key",
            issues: keyResult.issues.map((iss) => finalizeIssue(iss, ctx, config())),
            input: key,
            path: [key],
            inst
          });
          payload.value[keyResult.value] = keyResult.value;
          continue;
        }
        const result = def.valueType._zod.run({ value: input[key], issues: [] }, ctx);
        if (result instanceof Promise) {
          proms.push(result.then((result2) => {
            if (result2.issues.length) {
              payload.issues.push(...prefixIssues(key, result2.issues));
            }
            payload.value[keyResult.value] = result2.value;
          }));
        } else {
          if (result.issues.length) {
            payload.issues.push(...prefixIssues(key, result.issues));
          }
          payload.value[keyResult.value] = result.value;
        }
      }
    }
    if (proms.length) {
      return Promise.all(proms).then(() => payload);
    }
    return payload;
  };
});
const $ZodEnum = /* @__PURE__ */ $constructor("$ZodEnum", (inst, def) => {
  $ZodType.init(inst, def);
  const values = getEnumValues(def.entries);
  inst._zod.values = new Set(values);
  inst._zod.pattern = new RegExp(`^(${values.filter((k2) => propertyKeyTypes.has(typeof k2)).map((o) => typeof o === "string" ? escapeRegex(o) : o.toString()).join("|")})$`);
  inst._zod.parse = (payload, _ctx) => {
    const input = payload.value;
    if (inst._zod.values.has(input)) {
      return payload;
    }
    payload.issues.push({
      code: "invalid_value",
      values,
      input,
      inst
    });
    return payload;
  };
});
const $ZodLiteral = /* @__PURE__ */ $constructor("$ZodLiteral", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.values = new Set(def.values);
  inst._zod.pattern = new RegExp(`^(${def.values.map((o) => typeof o === "string" ? escapeRegex(o) : o ? o.toString() : String(o)).join("|")})$`);
  inst._zod.parse = (payload, _ctx) => {
    const input = payload.value;
    if (inst._zod.values.has(input)) {
      return payload;
    }
    payload.issues.push({
      code: "invalid_value",
      values: def.values,
      input,
      inst
    });
    return payload;
  };
});
const $ZodTransform = /* @__PURE__ */ $constructor("$ZodTransform", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.parse = (payload, _ctx) => {
    const _out = def.transform(payload.value, payload);
    if (_ctx.async) {
      const output = _out instanceof Promise ? _out : Promise.resolve(_out);
      return output.then((output2) => {
        payload.value = output2;
        return payload;
      });
    }
    if (_out instanceof Promise) {
      throw new $ZodAsyncError();
    }
    payload.value = _out;
    return payload;
  };
});
const $ZodOptional = /* @__PURE__ */ $constructor("$ZodOptional", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.optin = "optional";
  inst._zod.optout = "optional";
  defineLazy(inst._zod, "values", () => {
    return def.innerType._zod.values ? /* @__PURE__ */ new Set([...def.innerType._zod.values, void 0]) : void 0;
  });
  defineLazy(inst._zod, "pattern", () => {
    const pattern2 = def.innerType._zod.pattern;
    return pattern2 ? new RegExp(`^(${cleanRegex(pattern2.source)})?$`) : void 0;
  });
  inst._zod.parse = (payload, ctx) => {
    if (def.innerType._zod.optin === "optional") {
      return def.innerType._zod.run(payload, ctx);
    }
    if (payload.value === void 0) {
      return payload;
    }
    return def.innerType._zod.run(payload, ctx);
  };
});
const $ZodNullable = /* @__PURE__ */ $constructor("$ZodNullable", (inst, def) => {
  $ZodType.init(inst, def);
  defineLazy(inst._zod, "optin", () => def.innerType._zod.optin);
  defineLazy(inst._zod, "optout", () => def.innerType._zod.optout);
  defineLazy(inst._zod, "pattern", () => {
    const pattern2 = def.innerType._zod.pattern;
    return pattern2 ? new RegExp(`^(${cleanRegex(pattern2.source)}|null)$`) : void 0;
  });
  defineLazy(inst._zod, "values", () => {
    return def.innerType._zod.values ? /* @__PURE__ */ new Set([...def.innerType._zod.values, null]) : void 0;
  });
  inst._zod.parse = (payload, ctx) => {
    if (payload.value === null)
      return payload;
    return def.innerType._zod.run(payload, ctx);
  };
});
const $ZodDefault = /* @__PURE__ */ $constructor("$ZodDefault", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.optin = "optional";
  defineLazy(inst._zod, "values", () => def.innerType._zod.values);
  inst._zod.parse = (payload, ctx) => {
    if (payload.value === void 0) {
      payload.value = def.defaultValue;
      return payload;
    }
    const result = def.innerType._zod.run(payload, ctx);
    if (result instanceof Promise) {
      return result.then((result2) => handleDefaultResult(result2, def));
    }
    return handleDefaultResult(result, def);
  };
});
function handleDefaultResult(payload, def) {
  if (payload.value === void 0) {
    payload.value = def.defaultValue;
  }
  return payload;
}
const $ZodPrefault = /* @__PURE__ */ $constructor("$ZodPrefault", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.optin = "optional";
  defineLazy(inst._zod, "values", () => def.innerType._zod.values);
  inst._zod.parse = (payload, ctx) => {
    if (payload.value === void 0) {
      payload.value = def.defaultValue;
    }
    return def.innerType._zod.run(payload, ctx);
  };
});
const $ZodNonOptional = /* @__PURE__ */ $constructor("$ZodNonOptional", (inst, def) => {
  $ZodType.init(inst, def);
  defineLazy(inst._zod, "values", () => {
    const v = def.innerType._zod.values;
    return v ? new Set([...v].filter((x2) => x2 !== void 0)) : void 0;
  });
  inst._zod.parse = (payload, ctx) => {
    const result = def.innerType._zod.run(payload, ctx);
    if (result instanceof Promise) {
      return result.then((result2) => handleNonOptionalResult(result2, inst));
    }
    return handleNonOptionalResult(result, inst);
  };
});
function handleNonOptionalResult(payload, inst) {
  if (!payload.issues.length && payload.value === void 0) {
    payload.issues.push({
      code: "invalid_type",
      expected: "nonoptional",
      input: payload.value,
      inst
    });
  }
  return payload;
}
const $ZodCatch = /* @__PURE__ */ $constructor("$ZodCatch", (inst, def) => {
  $ZodType.init(inst, def);
  inst._zod.optin = "optional";
  defineLazy(inst._zod, "optout", () => def.innerType._zod.optout);
  defineLazy(inst._zod, "values", () => def.innerType._zod.values);
  inst._zod.parse = (payload, ctx) => {
    const result = def.innerType._zod.run(payload, ctx);
    if (result instanceof Promise) {
      return result.then((result2) => {
        payload.value = result2.value;
        if (result2.issues.length) {
          payload.value = def.catchValue({
            ...payload,
            error: {
              issues: result2.issues.map((iss) => finalizeIssue(iss, ctx, config()))
            },
            input: payload.value
          });
          payload.issues = [];
        }
        return payload;
      });
    }
    payload.value = result.value;
    if (result.issues.length) {
      payload.value = def.catchValue({
        ...payload,
        error: {
          issues: result.issues.map((iss) => finalizeIssue(iss, ctx, config()))
        },
        input: payload.value
      });
      payload.issues = [];
    }
    return payload;
  };
});
const $ZodPipe = /* @__PURE__ */ $constructor("$ZodPipe", (inst, def) => {
  $ZodType.init(inst, def);
  defineLazy(inst._zod, "values", () => def.in._zod.values);
  defineLazy(inst._zod, "optin", () => def.in._zod.optin);
  defineLazy(inst._zod, "optout", () => def.out._zod.optout);
  inst._zod.parse = (payload, ctx) => {
    const left = def.in._zod.run(payload, ctx);
    if (left instanceof Promise) {
      return left.then((left2) => handlePipeResult(left2, def, ctx));
    }
    return handlePipeResult(left, def, ctx);
  };
});
function handlePipeResult(left, def, ctx) {
  if (aborted(left)) {
    return left;
  }
  return def.out._zod.run({ value: left.value, issues: left.issues }, ctx);
}
const $ZodReadonly = /* @__PURE__ */ $constructor("$ZodReadonly", (inst, def) => {
  $ZodType.init(inst, def);
  defineLazy(inst._zod, "propValues", () => def.innerType._zod.propValues);
  defineLazy(inst._zod, "values", () => def.innerType._zod.values);
  defineLazy(inst._zod, "optin", () => def.innerType._zod.optin);
  defineLazy(inst._zod, "optout", () => def.innerType._zod.optout);
  inst._zod.parse = (payload, ctx) => {
    const result = def.innerType._zod.run(payload, ctx);
    if (result instanceof Promise) {
      return result.then(handleReadonlyResult);
    }
    return handleReadonlyResult(result);
  };
});
function handleReadonlyResult(payload) {
  payload.value = Object.freeze(payload.value);
  return payload;
}
const $ZodCustom = /* @__PURE__ */ $constructor("$ZodCustom", (inst, def) => {
  $ZodCheck.init(inst, def);
  $ZodType.init(inst, def);
  inst._zod.parse = (payload, _2) => {
    return payload;
  };
  inst._zod.check = (payload) => {
    const input = payload.value;
    const r2 = def.fn(input);
    if (r2 instanceof Promise) {
      return r2.then((r3) => handleRefineResult(r3, payload, input, inst));
    }
    handleRefineResult(r2, payload, input, inst);
    return;
  };
});
function handleRefineResult(result, payload, input, inst) {
  if (!result) {
    const _iss = {
      code: "custom",
      input,
      inst,
      // incorporates params.error into issue reporting
      path: [...inst._zod.def.path ?? []],
      // incorporates params.error into issue reporting
      continue: !inst._zod.def.abort
      // params: inst._zod.def.params,
    };
    if (inst._zod.def.params)
      _iss.params = inst._zod.def.params;
    payload.issues.push(issue(_iss));
  }
}
class $ZodRegistry {
  constructor() {
    this._map = /* @__PURE__ */ new Map();
    this._idmap = /* @__PURE__ */ new Map();
  }
  add(schema, ..._meta) {
    const meta = _meta[0];
    this._map.set(schema, meta);
    if (meta && typeof meta === "object" && "id" in meta) {
      if (this._idmap.has(meta.id)) {
        throw new Error(`ID ${meta.id} already exists in the registry`);
      }
      this._idmap.set(meta.id, schema);
    }
    return this;
  }
  clear() {
    this._map = /* @__PURE__ */ new Map();
    this._idmap = /* @__PURE__ */ new Map();
    return this;
  }
  remove(schema) {
    const meta = this._map.get(schema);
    if (meta && typeof meta === "object" && "id" in meta) {
      this._idmap.delete(meta.id);
    }
    this._map.delete(schema);
    return this;
  }
  get(schema) {
    const p2 = schema._zod.parent;
    if (p2) {
      const pm2 = { ...this.get(p2) ?? {} };
      delete pm2.id;
      return { ...pm2, ...this._map.get(schema) };
    }
    return this._map.get(schema);
  }
  has(schema) {
    return this._map.has(schema);
  }
}
function registry() {
  return new $ZodRegistry();
}
const globalRegistry = /* @__PURE__ */ registry();
function _string(Class, params) {
  return new Class({
    type: "string",
    ...normalizeParams(params)
  });
}
function _email(Class, params) {
  return new Class({
    type: "string",
    format: "email",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _guid(Class, params) {
  return new Class({
    type: "string",
    format: "guid",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _uuid(Class, params) {
  return new Class({
    type: "string",
    format: "uuid",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _uuidv4(Class, params) {
  return new Class({
    type: "string",
    format: "uuid",
    check: "string_format",
    abort: false,
    version: "v4",
    ...normalizeParams(params)
  });
}
function _uuidv6(Class, params) {
  return new Class({
    type: "string",
    format: "uuid",
    check: "string_format",
    abort: false,
    version: "v6",
    ...normalizeParams(params)
  });
}
function _uuidv7(Class, params) {
  return new Class({
    type: "string",
    format: "uuid",
    check: "string_format",
    abort: false,
    version: "v7",
    ...normalizeParams(params)
  });
}
function _url$1(Class, params) {
  return new Class({
    type: "string",
    format: "url",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _emoji(Class, params) {
  return new Class({
    type: "string",
    format: "emoji",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _nanoid(Class, params) {
  return new Class({
    type: "string",
    format: "nanoid",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _cuid(Class, params) {
  return new Class({
    type: "string",
    format: "cuid",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _cuid2(Class, params) {
  return new Class({
    type: "string",
    format: "cuid2",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _ulid(Class, params) {
  return new Class({
    type: "string",
    format: "ulid",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _xid(Class, params) {
  return new Class({
    type: "string",
    format: "xid",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _ksuid(Class, params) {
  return new Class({
    type: "string",
    format: "ksuid",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _ipv4(Class, params) {
  return new Class({
    type: "string",
    format: "ipv4",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _ipv6(Class, params) {
  return new Class({
    type: "string",
    format: "ipv6",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _cidrv4(Class, params) {
  return new Class({
    type: "string",
    format: "cidrv4",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _cidrv6(Class, params) {
  return new Class({
    type: "string",
    format: "cidrv6",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _base64(Class, params) {
  return new Class({
    type: "string",
    format: "base64",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _base64url(Class, params) {
  return new Class({
    type: "string",
    format: "base64url",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _e164(Class, params) {
  return new Class({
    type: "string",
    format: "e164",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _jwt(Class, params) {
  return new Class({
    type: "string",
    format: "jwt",
    check: "string_format",
    abort: false,
    ...normalizeParams(params)
  });
}
function _isoDateTime(Class, params) {
  return new Class({
    type: "string",
    format: "datetime",
    check: "string_format",
    offset: false,
    local: false,
    precision: null,
    ...normalizeParams(params)
  });
}
function _isoDate(Class, params) {
  return new Class({
    type: "string",
    format: "date",
    check: "string_format",
    ...normalizeParams(params)
  });
}
function _isoTime(Class, params) {
  return new Class({
    type: "string",
    format: "time",
    check: "string_format",
    precision: null,
    ...normalizeParams(params)
  });
}
function _isoDuration(Class, params) {
  return new Class({
    type: "string",
    format: "duration",
    check: "string_format",
    ...normalizeParams(params)
  });
}
function _number(Class, params) {
  return new Class({
    type: "number",
    checks: [],
    ...normalizeParams(params)
  });
}
function _coercedNumber(Class, params) {
  return new Class({
    type: "number",
    coerce: true,
    checks: [],
    ...normalizeParams(params)
  });
}
function _int(Class, params) {
  return new Class({
    type: "number",
    check: "number_format",
    abort: false,
    format: "safeint",
    ...normalizeParams(params)
  });
}
function _boolean(Class, params) {
  return new Class({
    type: "boolean",
    ...normalizeParams(params)
  });
}
function _null$1(Class, params) {
  return new Class({
    type: "null",
    ...normalizeParams(params)
  });
}
function _any(Class) {
  return new Class({
    type: "any"
  });
}
function _unknown(Class) {
  return new Class({
    type: "unknown"
  });
}
function _never(Class, params) {
  return new Class({
    type: "never",
    ...normalizeParams(params)
  });
}
function _lt(value, params) {
  return new $ZodCheckLessThan({
    check: "less_than",
    ...normalizeParams(params),
    value,
    inclusive: false
  });
}
function _lte(value, params) {
  return new $ZodCheckLessThan({
    check: "less_than",
    ...normalizeParams(params),
    value,
    inclusive: true
  });
}
function _gt(value, params) {
  return new $ZodCheckGreaterThan({
    check: "greater_than",
    ...normalizeParams(params),
    value,
    inclusive: false
  });
}
function _gte(value, params) {
  return new $ZodCheckGreaterThan({
    check: "greater_than",
    ...normalizeParams(params),
    value,
    inclusive: true
  });
}
function _multipleOf(value, params) {
  return new $ZodCheckMultipleOf({
    check: "multiple_of",
    ...normalizeParams(params),
    value
  });
}
function _maxLength(maximum, params) {
  const ch2 = new $ZodCheckMaxLength({
    check: "max_length",
    ...normalizeParams(params),
    maximum
  });
  return ch2;
}
function _minLength(minimum, params) {
  return new $ZodCheckMinLength({
    check: "min_length",
    ...normalizeParams(params),
    minimum
  });
}
function _length(length, params) {
  return new $ZodCheckLengthEquals({
    check: "length_equals",
    ...normalizeParams(params),
    length
  });
}
function _regex(pattern2, params) {
  return new $ZodCheckRegex({
    check: "string_format",
    format: "regex",
    ...normalizeParams(params),
    pattern: pattern2
  });
}
function _lowercase(params) {
  return new $ZodCheckLowerCase({
    check: "string_format",
    format: "lowercase",
    ...normalizeParams(params)
  });
}
function _uppercase(params) {
  return new $ZodCheckUpperCase({
    check: "string_format",
    format: "uppercase",
    ...normalizeParams(params)
  });
}
function _includes(includes, params) {
  return new $ZodCheckIncludes({
    check: "string_format",
    format: "includes",
    ...normalizeParams(params),
    includes
  });
}
function _startsWith(prefix, params) {
  return new $ZodCheckStartsWith({
    check: "string_format",
    format: "starts_with",
    ...normalizeParams(params),
    prefix
  });
}
function _endsWith(suffix, params) {
  return new $ZodCheckEndsWith({
    check: "string_format",
    format: "ends_with",
    ...normalizeParams(params),
    suffix
  });
}
function _overwrite(tx) {
  return new $ZodCheckOverwrite({
    check: "overwrite",
    tx
  });
}
function _normalize(form) {
  return _overwrite((input) => input.normalize(form));
}
function _trim() {
  return _overwrite((input) => input.trim());
}
function _toLowerCase() {
  return _overwrite((input) => input.toLowerCase());
}
function _toUpperCase() {
  return _overwrite((input) => input.toUpperCase());
}
function _array(Class, element, params) {
  return new Class({
    type: "array",
    element,
    // get element() {
    //   return element;
    // },
    ...normalizeParams(params)
  });
}
function _custom(Class, fn2, _params) {
  const norm = normalizeParams(_params);
  norm.abort ?? (norm.abort = true);
  const schema = new Class({
    type: "custom",
    check: "custom",
    fn: fn2,
    ...norm
  });
  return schema;
}
function _refine(Class, fn2, _params) {
  const schema = new Class({
    type: "custom",
    check: "custom",
    fn: fn2,
    ...normalizeParams(_params)
  });
  return schema;
}
const ZodISODateTime = /* @__PURE__ */ $constructor("ZodISODateTime", (inst, def) => {
  $ZodISODateTime.init(inst, def);
  ZodStringFormat.init(inst, def);
});
function datetime(params) {
  return _isoDateTime(ZodISODateTime, params);
}
const ZodISODate = /* @__PURE__ */ $constructor("ZodISODate", (inst, def) => {
  $ZodISODate.init(inst, def);
  ZodStringFormat.init(inst, def);
});
function date(params) {
  return _isoDate(ZodISODate, params);
}
const ZodISOTime = /* @__PURE__ */ $constructor("ZodISOTime", (inst, def) => {
  $ZodISOTime.init(inst, def);
  ZodStringFormat.init(inst, def);
});
function time(params) {
  return _isoTime(ZodISOTime, params);
}
const ZodISODuration = /* @__PURE__ */ $constructor("ZodISODuration", (inst, def) => {
  $ZodISODuration.init(inst, def);
  ZodStringFormat.init(inst, def);
});
function duration(params) {
  return _isoDuration(ZodISODuration, params);
}
const initializer = (inst, issues) => {
  $ZodError.init(inst, issues);
  inst.name = "ZodError";
  Object.defineProperties(inst, {
    format: {
      value: (mapper) => formatError(inst, mapper)
      // enumerable: false,
    },
    flatten: {
      value: (mapper) => flattenError$1(inst, mapper)
      // enumerable: false,
    },
    addIssue: {
      value: (issue2) => inst.issues.push(issue2)
      // enumerable: false,
    },
    addIssues: {
      value: (issues2) => inst.issues.push(...issues2)
      // enumerable: false,
    },
    isEmpty: {
      get() {
        return inst.issues.length === 0;
      }
      // enumerable: false,
    }
  });
};
const ZodRealError = $constructor("ZodError", initializer, {
  Parent: Error
});
const parse$1 = /* @__PURE__ */ _parse(ZodRealError);
const parseAsync = /* @__PURE__ */ _parseAsync(ZodRealError);
const safeParse$1 = /* @__PURE__ */ _safeParse(ZodRealError);
const safeParseAsync = /* @__PURE__ */ _safeParseAsync(ZodRealError);
const ZodType$1 = /* @__PURE__ */ $constructor("ZodType", (inst, def) => {
  $ZodType.init(inst, def);
  inst.def = def;
  Object.defineProperty(inst, "_def", { value: def });
  inst.check = (...checks) => {
    return inst.clone(
      {
        ...def,
        checks: [
          ...def.checks ?? [],
          ...checks.map((ch2) => typeof ch2 === "function" ? { _zod: { check: ch2, def: { check: "custom" }, onattach: [] } } : ch2)
        ]
      }
      // { parent: true }
    );
  };
  inst.clone = (def2, params) => clone(inst, def2, params);
  inst.brand = () => inst;
  inst.register = ((reg, meta) => {
    reg.add(inst, meta);
    return inst;
  });
  inst.parse = (data2, params) => parse$1(inst, data2, params, { callee: inst.parse });
  inst.safeParse = (data2, params) => safeParse$1(inst, data2, params);
  inst.parseAsync = async (data2, params) => parseAsync(inst, data2, params, { callee: inst.parseAsync });
  inst.safeParseAsync = async (data2, params) => safeParseAsync(inst, data2, params);
  inst.spa = inst.safeParseAsync;
  inst.refine = (check2, params) => inst.check(refine(check2, params));
  inst.superRefine = (refinement) => inst.check(superRefine(refinement));
  inst.overwrite = (fn2) => inst.check(_overwrite(fn2));
  inst.optional = () => optional(inst);
  inst.nullable = () => nullable(inst);
  inst.nullish = () => optional(nullable(inst));
  inst.nonoptional = (params) => nonoptional(inst, params);
  inst.array = () => array(inst);
  inst.or = (arg) => union([inst, arg]);
  inst.and = (arg) => intersection(inst, arg);
  inst.transform = (tx) => pipe(inst, transform(tx));
  inst.default = (def2) => _default(inst, def2);
  inst.prefault = (def2) => prefault(inst, def2);
  inst.catch = (params) => _catch(inst, params);
  inst.pipe = (target) => pipe(inst, target);
  inst.readonly = () => readonly(inst);
  inst.describe = (description2) => {
    const cl2 = inst.clone();
    globalRegistry.add(cl2, { description: description2 });
    return cl2;
  };
  Object.defineProperty(inst, "description", {
    get() {
      return globalRegistry.get(inst)?.description;
    },
    configurable: true
  });
  inst.meta = (...args) => {
    if (args.length === 0) {
      return globalRegistry.get(inst);
    }
    const cl2 = inst.clone();
    globalRegistry.add(cl2, args[0]);
    return cl2;
  };
  inst.isOptional = () => inst.safeParse(void 0).success;
  inst.isNullable = () => inst.safeParse(null).success;
  return inst;
});
const _ZodString = /* @__PURE__ */ $constructor("_ZodString", (inst, def) => {
  $ZodString.init(inst, def);
  ZodType$1.init(inst, def);
  const bag = inst._zod.bag;
  inst.format = bag.format ?? null;
  inst.minLength = bag.minimum ?? null;
  inst.maxLength = bag.maximum ?? null;
  inst.regex = (...args) => inst.check(_regex(...args));
  inst.includes = (...args) => inst.check(_includes(...args));
  inst.startsWith = (...args) => inst.check(_startsWith(...args));
  inst.endsWith = (...args) => inst.check(_endsWith(...args));
  inst.min = (...args) => inst.check(_minLength(...args));
  inst.max = (...args) => inst.check(_maxLength(...args));
  inst.length = (...args) => inst.check(_length(...args));
  inst.nonempty = (...args) => inst.check(_minLength(1, ...args));
  inst.lowercase = (params) => inst.check(_lowercase(params));
  inst.uppercase = (params) => inst.check(_uppercase(params));
  inst.trim = () => inst.check(_trim());
  inst.normalize = (...args) => inst.check(_normalize(...args));
  inst.toLowerCase = () => inst.check(_toLowerCase());
  inst.toUpperCase = () => inst.check(_toUpperCase());
});
const ZodString$1 = /* @__PURE__ */ $constructor("ZodString", (inst, def) => {
  $ZodString.init(inst, def);
  _ZodString.init(inst, def);
  inst.email = (params) => inst.check(_email(ZodEmail, params));
  inst.url = (params) => inst.check(_url$1(ZodURL, params));
  inst.jwt = (params) => inst.check(_jwt(ZodJWT, params));
  inst.emoji = (params) => inst.check(_emoji(ZodEmoji, params));
  inst.guid = (params) => inst.check(_guid(ZodGUID, params));
  inst.uuid = (params) => inst.check(_uuid(ZodUUID, params));
  inst.uuidv4 = (params) => inst.check(_uuidv4(ZodUUID, params));
  inst.uuidv6 = (params) => inst.check(_uuidv6(ZodUUID, params));
  inst.uuidv7 = (params) => inst.check(_uuidv7(ZodUUID, params));
  inst.nanoid = (params) => inst.check(_nanoid(ZodNanoID, params));
  inst.guid = (params) => inst.check(_guid(ZodGUID, params));
  inst.cuid = (params) => inst.check(_cuid(ZodCUID, params));
  inst.cuid2 = (params) => inst.check(_cuid2(ZodCUID2, params));
  inst.ulid = (params) => inst.check(_ulid(ZodULID, params));
  inst.base64 = (params) => inst.check(_base64(ZodBase64, params));
  inst.base64url = (params) => inst.check(_base64url(ZodBase64URL, params));
  inst.xid = (params) => inst.check(_xid(ZodXID, params));
  inst.ksuid = (params) => inst.check(_ksuid(ZodKSUID, params));
  inst.ipv4 = (params) => inst.check(_ipv4(ZodIPv4, params));
  inst.ipv6 = (params) => inst.check(_ipv6(ZodIPv6, params));
  inst.cidrv4 = (params) => inst.check(_cidrv4(ZodCIDRv4, params));
  inst.cidrv6 = (params) => inst.check(_cidrv6(ZodCIDRv6, params));
  inst.e164 = (params) => inst.check(_e164(ZodE164, params));
  inst.datetime = (params) => inst.check(datetime(params));
  inst.date = (params) => inst.check(date(params));
  inst.time = (params) => inst.check(time(params));
  inst.duration = (params) => inst.check(duration(params));
});
function string(params) {
  return _string(ZodString$1, params);
}
const ZodStringFormat = /* @__PURE__ */ $constructor("ZodStringFormat", (inst, def) => {
  $ZodStringFormat.init(inst, def);
  _ZodString.init(inst, def);
});
const ZodEmail = /* @__PURE__ */ $constructor("ZodEmail", (inst, def) => {
  $ZodEmail.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodGUID = /* @__PURE__ */ $constructor("ZodGUID", (inst, def) => {
  $ZodGUID.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodUUID = /* @__PURE__ */ $constructor("ZodUUID", (inst, def) => {
  $ZodUUID.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodURL = /* @__PURE__ */ $constructor("ZodURL", (inst, def) => {
  $ZodURL.init(inst, def);
  ZodStringFormat.init(inst, def);
});
function url(params) {
  return _url$1(ZodURL, params);
}
const ZodEmoji = /* @__PURE__ */ $constructor("ZodEmoji", (inst, def) => {
  $ZodEmoji.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodNanoID = /* @__PURE__ */ $constructor("ZodNanoID", (inst, def) => {
  $ZodNanoID.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodCUID = /* @__PURE__ */ $constructor("ZodCUID", (inst, def) => {
  $ZodCUID.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodCUID2 = /* @__PURE__ */ $constructor("ZodCUID2", (inst, def) => {
  $ZodCUID2.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodULID = /* @__PURE__ */ $constructor("ZodULID", (inst, def) => {
  $ZodULID.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodXID = /* @__PURE__ */ $constructor("ZodXID", (inst, def) => {
  $ZodXID.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodKSUID = /* @__PURE__ */ $constructor("ZodKSUID", (inst, def) => {
  $ZodKSUID.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodIPv4 = /* @__PURE__ */ $constructor("ZodIPv4", (inst, def) => {
  $ZodIPv4.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodIPv6 = /* @__PURE__ */ $constructor("ZodIPv6", (inst, def) => {
  $ZodIPv6.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodCIDRv4 = /* @__PURE__ */ $constructor("ZodCIDRv4", (inst, def) => {
  $ZodCIDRv4.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodCIDRv6 = /* @__PURE__ */ $constructor("ZodCIDRv6", (inst, def) => {
  $ZodCIDRv6.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodBase64 = /* @__PURE__ */ $constructor("ZodBase64", (inst, def) => {
  $ZodBase64.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodBase64URL = /* @__PURE__ */ $constructor("ZodBase64URL", (inst, def) => {
  $ZodBase64URL.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodE164 = /* @__PURE__ */ $constructor("ZodE164", (inst, def) => {
  $ZodE164.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodJWT = /* @__PURE__ */ $constructor("ZodJWT", (inst, def) => {
  $ZodJWT.init(inst, def);
  ZodStringFormat.init(inst, def);
});
const ZodNumber$1 = /* @__PURE__ */ $constructor("ZodNumber", (inst, def) => {
  $ZodNumber.init(inst, def);
  ZodType$1.init(inst, def);
  inst.gt = (value, params) => inst.check(_gt(value, params));
  inst.gte = (value, params) => inst.check(_gte(value, params));
  inst.min = (value, params) => inst.check(_gte(value, params));
  inst.lt = (value, params) => inst.check(_lt(value, params));
  inst.lte = (value, params) => inst.check(_lte(value, params));
  inst.max = (value, params) => inst.check(_lte(value, params));
  inst.int = (params) => inst.check(int(params));
  inst.safe = (params) => inst.check(int(params));
  inst.positive = (params) => inst.check(_gt(0, params));
  inst.nonnegative = (params) => inst.check(_gte(0, params));
  inst.negative = (params) => inst.check(_lt(0, params));
  inst.nonpositive = (params) => inst.check(_lte(0, params));
  inst.multipleOf = (value, params) => inst.check(_multipleOf(value, params));
  inst.step = (value, params) => inst.check(_multipleOf(value, params));
  inst.finite = () => inst;
  const bag = inst._zod.bag;
  inst.minValue = Math.max(bag.minimum ?? Number.NEGATIVE_INFINITY, bag.exclusiveMinimum ?? Number.NEGATIVE_INFINITY) ?? null;
  inst.maxValue = Math.min(bag.maximum ?? Number.POSITIVE_INFINITY, bag.exclusiveMaximum ?? Number.POSITIVE_INFINITY) ?? null;
  inst.isInt = (bag.format ?? "").includes("int") || Number.isSafeInteger(bag.multipleOf ?? 0.5);
  inst.isFinite = true;
  inst.format = bag.format ?? null;
});
function number$1(params) {
  return _number(ZodNumber$1, params);
}
const ZodNumberFormat = /* @__PURE__ */ $constructor("ZodNumberFormat", (inst, def) => {
  $ZodNumberFormat.init(inst, def);
  ZodNumber$1.init(inst, def);
});
function int(params) {
  return _int(ZodNumberFormat, params);
}
const ZodBoolean$1 = /* @__PURE__ */ $constructor("ZodBoolean", (inst, def) => {
  $ZodBoolean.init(inst, def);
  ZodType$1.init(inst, def);
});
function boolean(params) {
  return _boolean(ZodBoolean$1, params);
}
const ZodNull$1 = /* @__PURE__ */ $constructor("ZodNull", (inst, def) => {
  $ZodNull.init(inst, def);
  ZodType$1.init(inst, def);
});
function _null(params) {
  return _null$1(ZodNull$1, params);
}
const ZodAny$1 = /* @__PURE__ */ $constructor("ZodAny", (inst, def) => {
  $ZodAny.init(inst, def);
  ZodType$1.init(inst, def);
});
function any() {
  return _any(ZodAny$1);
}
const ZodUnknown$1 = /* @__PURE__ */ $constructor("ZodUnknown", (inst, def) => {
  $ZodUnknown.init(inst, def);
  ZodType$1.init(inst, def);
});
function unknown() {
  return _unknown(ZodUnknown$1);
}
const ZodNever$1 = /* @__PURE__ */ $constructor("ZodNever", (inst, def) => {
  $ZodNever.init(inst, def);
  ZodType$1.init(inst, def);
});
function never(params) {
  return _never(ZodNever$1, params);
}
const ZodArray$1 = /* @__PURE__ */ $constructor("ZodArray", (inst, def) => {
  $ZodArray.init(inst, def);
  ZodType$1.init(inst, def);
  inst.element = def.element;
  inst.min = (minLength, params) => inst.check(_minLength(minLength, params));
  inst.nonempty = (params) => inst.check(_minLength(1, params));
  inst.max = (maxLength, params) => inst.check(_maxLength(maxLength, params));
  inst.length = (len, params) => inst.check(_length(len, params));
  inst.unwrap = () => inst.element;
});
function array(element, params) {
  return _array(ZodArray$1, element, params);
}
const ZodObject$1 = /* @__PURE__ */ $constructor("ZodObject", (inst, def) => {
  $ZodObject.init(inst, def);
  ZodType$1.init(inst, def);
  defineLazy(inst, "shape", () => def.shape);
  inst.keyof = () => _enum$3(Object.keys(inst._zod.def.shape));
  inst.catchall = (catchall) => inst.clone({ ...inst._zod.def, catchall });
  inst.passthrough = () => inst.clone({ ...inst._zod.def, catchall: unknown() });
  inst.loose = () => inst.clone({ ...inst._zod.def, catchall: unknown() });
  inst.strict = () => inst.clone({ ...inst._zod.def, catchall: never() });
  inst.strip = () => inst.clone({ ...inst._zod.def, catchall: void 0 });
  inst.extend = (incoming) => {
    return extend(inst, incoming);
  };
  inst.merge = (other) => merge(inst, other);
  inst.pick = (mask) => pick(inst, mask);
  inst.omit = (mask) => omit(inst, mask);
  inst.partial = (...args) => partial(ZodOptional$1, inst, args[0]);
  inst.required = (...args) => required$6(ZodNonOptional, inst, args[0]);
});
function object(shape, params) {
  const def = {
    type: "object",
    get shape() {
      assignProp(this, "shape", { ...shape });
      return this.shape;
    },
    ...normalizeParams(params)
  };
  return new ZodObject$1(def);
}
function looseObject(shape, params) {
  return new ZodObject$1({
    type: "object",
    get shape() {
      assignProp(this, "shape", { ...shape });
      return this.shape;
    },
    catchall: unknown(),
    ...normalizeParams(params)
  });
}
const ZodUnion$1 = /* @__PURE__ */ $constructor("ZodUnion", (inst, def) => {
  $ZodUnion.init(inst, def);
  ZodType$1.init(inst, def);
  inst.options = def.options;
});
function union(options, params) {
  return new ZodUnion$1({
    type: "union",
    options,
    ...normalizeParams(params)
  });
}
const ZodDiscriminatedUnion = /* @__PURE__ */ $constructor("ZodDiscriminatedUnion", (inst, def) => {
  ZodUnion$1.init(inst, def);
  $ZodDiscriminatedUnion.init(inst, def);
});
function discriminatedUnion(discriminator2, options, params) {
  return new ZodDiscriminatedUnion({
    type: "union",
    options,
    discriminator: discriminator2,
    ...normalizeParams(params)
  });
}
const ZodIntersection$1 = /* @__PURE__ */ $constructor("ZodIntersection", (inst, def) => {
  $ZodIntersection.init(inst, def);
  ZodType$1.init(inst, def);
});
function intersection(left, right) {
  return new ZodIntersection$1({
    type: "intersection",
    left,
    right
  });
}
const ZodRecord = /* @__PURE__ */ $constructor("ZodRecord", (inst, def) => {
  $ZodRecord.init(inst, def);
  ZodType$1.init(inst, def);
  inst.keyType = def.keyType;
  inst.valueType = def.valueType;
});
function record(keyType, valueType, params) {
  return new ZodRecord({
    type: "record",
    keyType,
    valueType,
    ...normalizeParams(params)
  });
}
const ZodEnum$1 = /* @__PURE__ */ $constructor("ZodEnum", (inst, def) => {
  $ZodEnum.init(inst, def);
  ZodType$1.init(inst, def);
  inst.enum = def.entries;
  inst.options = Object.values(def.entries);
  const keys = new Set(Object.keys(def.entries));
  inst.extract = (values, params) => {
    const newEntries = {};
    for (const value of values) {
      if (keys.has(value)) {
        newEntries[value] = def.entries[value];
      } else
        throw new Error(`Key ${value} not found in enum`);
    }
    return new ZodEnum$1({
      ...def,
      checks: [],
      ...normalizeParams(params),
      entries: newEntries
    });
  };
  inst.exclude = (values, params) => {
    const newEntries = { ...def.entries };
    for (const value of values) {
      if (keys.has(value)) {
        delete newEntries[value];
      } else
        throw new Error(`Key ${value} not found in enum`);
    }
    return new ZodEnum$1({
      ...def,
      checks: [],
      ...normalizeParams(params),
      entries: newEntries
    });
  };
});
function _enum$3(values, params) {
  const entries = Array.isArray(values) ? Object.fromEntries(values.map((v) => [v, v])) : values;
  return new ZodEnum$1({
    type: "enum",
    entries,
    ...normalizeParams(params)
  });
}
const ZodLiteral$1 = /* @__PURE__ */ $constructor("ZodLiteral", (inst, def) => {
  $ZodLiteral.init(inst, def);
  ZodType$1.init(inst, def);
  inst.values = new Set(def.values);
  Object.defineProperty(inst, "value", {
    get() {
      if (def.values.length > 1) {
        throw new Error("This schema contains multiple valid literal values. Use `.values` instead.");
      }
      return def.values[0];
    }
  });
});
function literal(value, params) {
  return new ZodLiteral$1({
    type: "literal",
    values: Array.isArray(value) ? value : [value],
    ...normalizeParams(params)
  });
}
const ZodTransform = /* @__PURE__ */ $constructor("ZodTransform", (inst, def) => {
  $ZodTransform.init(inst, def);
  ZodType$1.init(inst, def);
  inst._zod.parse = (payload, _ctx) => {
    payload.addIssue = (issue$1) => {
      if (typeof issue$1 === "string") {
        payload.issues.push(issue(issue$1, payload.value, def));
      } else {
        const _issue = issue$1;
        if (_issue.fatal)
          _issue.continue = false;
        _issue.code ?? (_issue.code = "custom");
        _issue.input ?? (_issue.input = payload.value);
        _issue.inst ?? (_issue.inst = inst);
        _issue.continue ?? (_issue.continue = true);
        payload.issues.push(issue(_issue));
      }
    };
    const output = def.transform(payload.value, payload);
    if (output instanceof Promise) {
      return output.then((output2) => {
        payload.value = output2;
        return payload;
      });
    }
    payload.value = output;
    return payload;
  };
});
function transform(fn2) {
  return new ZodTransform({
    type: "transform",
    transform: fn2
  });
}
const ZodOptional$1 = /* @__PURE__ */ $constructor("ZodOptional", (inst, def) => {
  $ZodOptional.init(inst, def);
  ZodType$1.init(inst, def);
  inst.unwrap = () => inst._zod.def.innerType;
});
function optional(innerType) {
  return new ZodOptional$1({
    type: "optional",
    innerType
  });
}
const ZodNullable$1 = /* @__PURE__ */ $constructor("ZodNullable", (inst, def) => {
  $ZodNullable.init(inst, def);
  ZodType$1.init(inst, def);
  inst.unwrap = () => inst._zod.def.innerType;
});
function nullable(innerType) {
  return new ZodNullable$1({
    type: "nullable",
    innerType
  });
}
const ZodDefault$1 = /* @__PURE__ */ $constructor("ZodDefault", (inst, def) => {
  $ZodDefault.init(inst, def);
  ZodType$1.init(inst, def);
  inst.unwrap = () => inst._zod.def.innerType;
  inst.removeDefault = inst.unwrap;
});
function _default(innerType, defaultValue) {
  return new ZodDefault$1({
    type: "default",
    innerType,
    get defaultValue() {
      return typeof defaultValue === "function" ? defaultValue() : defaultValue;
    }
  });
}
const ZodPrefault = /* @__PURE__ */ $constructor("ZodPrefault", (inst, def) => {
  $ZodPrefault.init(inst, def);
  ZodType$1.init(inst, def);
  inst.unwrap = () => inst._zod.def.innerType;
});
function prefault(innerType, defaultValue) {
  return new ZodPrefault({
    type: "prefault",
    innerType,
    get defaultValue() {
      return typeof defaultValue === "function" ? defaultValue() : defaultValue;
    }
  });
}
const ZodNonOptional = /* @__PURE__ */ $constructor("ZodNonOptional", (inst, def) => {
  $ZodNonOptional.init(inst, def);
  ZodType$1.init(inst, def);
  inst.unwrap = () => inst._zod.def.innerType;
});
function nonoptional(innerType, params) {
  return new ZodNonOptional({
    type: "nonoptional",
    innerType,
    ...normalizeParams(params)
  });
}
const ZodCatch$1 = /* @__PURE__ */ $constructor("ZodCatch", (inst, def) => {
  $ZodCatch.init(inst, def);
  ZodType$1.init(inst, def);
  inst.unwrap = () => inst._zod.def.innerType;
  inst.removeCatch = inst.unwrap;
});
function _catch(innerType, catchValue) {
  return new ZodCatch$1({
    type: "catch",
    innerType,
    catchValue: typeof catchValue === "function" ? catchValue : () => catchValue
  });
}
const ZodPipe = /* @__PURE__ */ $constructor("ZodPipe", (inst, def) => {
  $ZodPipe.init(inst, def);
  ZodType$1.init(inst, def);
  inst.in = def.in;
  inst.out = def.out;
});
function pipe(in_, out) {
  return new ZodPipe({
    type: "pipe",
    in: in_,
    out
    // ...util.normalizeParams(params),
  });
}
const ZodReadonly$1 = /* @__PURE__ */ $constructor("ZodReadonly", (inst, def) => {
  $ZodReadonly.init(inst, def);
  ZodType$1.init(inst, def);
});
function readonly(innerType) {
  return new ZodReadonly$1({
    type: "readonly",
    innerType
  });
}
const ZodCustom = /* @__PURE__ */ $constructor("ZodCustom", (inst, def) => {
  $ZodCustom.init(inst, def);
  ZodType$1.init(inst, def);
});
function check(fn2) {
  const ch2 = new $ZodCheck({
    check: "custom"
    // ...util.normalizeParams(params),
  });
  ch2._zod.check = fn2;
  return ch2;
}
function custom$1(fn2, _params) {
  return _custom(ZodCustom, fn2 ?? (() => true), _params);
}
function refine(fn2, _params = {}) {
  return _refine(ZodCustom, fn2, _params);
}
function superRefine(fn2) {
  const ch2 = check((payload) => {
    payload.addIssue = (issue$1) => {
      if (typeof issue$1 === "string") {
        payload.issues.push(issue(issue$1, payload.value, ch2._zod.def));
      } else {
        const _issue = issue$1;
        if (_issue.fatal)
          _issue.continue = false;
        _issue.code ?? (_issue.code = "custom");
        _issue.input ?? (_issue.input = payload.value);
        _issue.inst ?? (_issue.inst = ch2);
        _issue.continue ?? (_issue.continue = !ch2._zod.def.abort);
        payload.issues.push(issue(_issue));
      }
    };
    return fn2(payload.value, payload);
  });
  return ch2;
}
function preprocess(fn2, schema) {
  return pipe(transform(fn2), schema);
}
const ZodIssueCode$1 = {
  custom: "custom"
};
function number(params) {
  return _coercedNumber(ZodNumber$1, params);
}
const LATEST_PROTOCOL_VERSION = "2025-11-25";
const SUPPORTED_PROTOCOL_VERSIONS = [LATEST_PROTOCOL_VERSION, "2025-06-18", "2025-03-26", "2024-11-05", "2024-10-07"];
const RELATED_TASK_META_KEY = "io.modelcontextprotocol/related-task";
const JSONRPC_VERSION = "2.0";
const AssertObjectSchema = custom$1((v) => v !== null && (typeof v === "object" || typeof v === "function"));
const ProgressTokenSchema = union([string(), number$1().int()]);
const CursorSchema = string();
looseObject({
  /**
   * Time in milliseconds to keep task results available after completion.
   * If null, the task has unlimited lifetime until manually cleaned up.
   */
  ttl: union([number$1(), _null()]).optional(),
  /**
   * Time in milliseconds to wait between task status requests.
   */
  pollInterval: number$1().optional()
});
const TaskMetadataSchema = object({
  ttl: number$1().optional()
});
const RelatedTaskMetadataSchema = object({
  taskId: string()
});
const RequestMetaSchema = looseObject({
  /**
   * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
   */
  progressToken: ProgressTokenSchema.optional(),
  /**
   * If specified, this request is related to the provided task.
   */
  [RELATED_TASK_META_KEY]: RelatedTaskMetadataSchema.optional()
});
const BaseRequestParamsSchema = object({
  /**
   * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
   */
  _meta: RequestMetaSchema.optional()
});
const TaskAugmentedRequestParamsSchema = BaseRequestParamsSchema.extend({
  /**
   * If specified, the caller is requesting task-augmented execution for this request.
   * The request will return a CreateTaskResult immediately, and the actual result can be
   * retrieved later via tasks/result.
   *
   * Task augmentation is subject to capability negotiation - receivers MUST declare support
   * for task augmentation of specific request types in their capabilities.
   */
  task: TaskMetadataSchema.optional()
});
const isTaskAugmentedRequestParams = (value) => TaskAugmentedRequestParamsSchema.safeParse(value).success;
const RequestSchema = object({
  method: string(),
  params: BaseRequestParamsSchema.loose().optional()
});
const NotificationsParamsSchema = object({
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: RequestMetaSchema.optional()
});
const NotificationSchema = object({
  method: string(),
  params: NotificationsParamsSchema.loose().optional()
});
const ResultSchema = looseObject({
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: RequestMetaSchema.optional()
});
const RequestIdSchema = union([string(), number$1().int()]);
const JSONRPCRequestSchema = object({
  jsonrpc: literal(JSONRPC_VERSION),
  id: RequestIdSchema,
  ...RequestSchema.shape
}).strict();
const isJSONRPCRequest = (value) => JSONRPCRequestSchema.safeParse(value).success;
const JSONRPCNotificationSchema = object({
  jsonrpc: literal(JSONRPC_VERSION),
  ...NotificationSchema.shape
}).strict();
const isJSONRPCNotification = (value) => JSONRPCNotificationSchema.safeParse(value).success;
const JSONRPCResultResponseSchema = object({
  jsonrpc: literal(JSONRPC_VERSION),
  id: RequestIdSchema,
  result: ResultSchema
}).strict();
const isJSONRPCResultResponse = (value) => JSONRPCResultResponseSchema.safeParse(value).success;
var ErrorCode;
(function(ErrorCode2) {
  ErrorCode2[ErrorCode2["ConnectionClosed"] = -32e3] = "ConnectionClosed";
  ErrorCode2[ErrorCode2["RequestTimeout"] = -32001] = "RequestTimeout";
  ErrorCode2[ErrorCode2["ParseError"] = -32700] = "ParseError";
  ErrorCode2[ErrorCode2["InvalidRequest"] = -32600] = "InvalidRequest";
  ErrorCode2[ErrorCode2["MethodNotFound"] = -32601] = "MethodNotFound";
  ErrorCode2[ErrorCode2["InvalidParams"] = -32602] = "InvalidParams";
  ErrorCode2[ErrorCode2["InternalError"] = -32603] = "InternalError";
  ErrorCode2[ErrorCode2["UrlElicitationRequired"] = -32042] = "UrlElicitationRequired";
})(ErrorCode || (ErrorCode = {}));
const JSONRPCErrorResponseSchema = object({
  jsonrpc: literal(JSONRPC_VERSION),
  id: RequestIdSchema.optional(),
  error: object({
    /**
     * The error type that occurred.
     */
    code: number$1().int(),
    /**
     * A short description of the error. The message SHOULD be limited to a concise single sentence.
     */
    message: string(),
    /**
     * Additional information about the error. The value of this member is defined by the sender (e.g. detailed error information, nested errors etc.).
     */
    data: unknown().optional()
  })
}).strict();
const isJSONRPCErrorResponse = (value) => JSONRPCErrorResponseSchema.safeParse(value).success;
const JSONRPCMessageSchema = union([
  JSONRPCRequestSchema,
  JSONRPCNotificationSchema,
  JSONRPCResultResponseSchema,
  JSONRPCErrorResponseSchema
]);
union([JSONRPCResultResponseSchema, JSONRPCErrorResponseSchema]);
const EmptyResultSchema = ResultSchema.strict();
const CancelledNotificationParamsSchema = NotificationsParamsSchema.extend({
  /**
   * The ID of the request to cancel.
   *
   * This MUST correspond to the ID of a request previously issued in the same direction.
   */
  requestId: RequestIdSchema.optional(),
  /**
   * An optional string describing the reason for the cancellation. This MAY be logged or presented to the user.
   */
  reason: string().optional()
});
const CancelledNotificationSchema = NotificationSchema.extend({
  method: literal("notifications/cancelled"),
  params: CancelledNotificationParamsSchema
});
const IconSchema = object({
  /**
   * URL or data URI for the icon.
   */
  src: string(),
  /**
   * Optional MIME type for the icon.
   */
  mimeType: string().optional(),
  /**
   * Optional array of strings that specify sizes at which the icon can be used.
   * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
   *
   * If not provided, the client should assume that the icon can be used at any size.
   */
  sizes: array(string()).optional(),
  /**
   * Optional specifier for the theme this icon is designed for. `light` indicates
   * the icon is designed to be used with a light background, and `dark` indicates
   * the icon is designed to be used with a dark background.
   *
   * If not provided, the client should assume the icon can be used with any theme.
   */
  theme: _enum$3(["light", "dark"]).optional()
});
const IconsSchema = object({
  /**
   * Optional set of sized icons that the client can display in a user interface.
   *
   * Clients that support rendering icons MUST support at least the following MIME types:
   * - `image/png` - PNG images (safe, universal compatibility)
   * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
   *
   * Clients that support rendering icons SHOULD also support:
   * - `image/svg+xml` - SVG images (scalable but requires security precautions)
   * - `image/webp` - WebP images (modern, efficient format)
   */
  icons: array(IconSchema).optional()
});
const BaseMetadataSchema = object({
  /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
  name: string(),
  /**
   * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
   * even by those unfamiliar with domain-specific terminology.
   *
   * If not provided, the name should be used for display (except for Tool,
   * where `annotations.title` should be given precedence over using `name`,
   * if present).
   */
  title: string().optional()
});
const ImplementationSchema = BaseMetadataSchema.extend({
  ...BaseMetadataSchema.shape,
  ...IconsSchema.shape,
  version: string(),
  /**
   * An optional URL of the website for this implementation.
   */
  websiteUrl: string().optional(),
  /**
   * An optional human-readable description of what this implementation does.
   *
   * This can be used by clients or servers to provide context about their purpose
   * and capabilities. For example, a server might describe the types of resources
   * or tools it provides, while a client might describe its intended use case.
   */
  description: string().optional()
});
const FormElicitationCapabilitySchema = intersection(object({
  applyDefaults: boolean().optional()
}), record(string(), unknown()));
const ElicitationCapabilitySchema = preprocess((value) => {
  if (value && typeof value === "object" && !Array.isArray(value)) {
    if (Object.keys(value).length === 0) {
      return { form: {} };
    }
  }
  return value;
}, intersection(object({
  form: FormElicitationCapabilitySchema.optional(),
  url: AssertObjectSchema.optional()
}), record(string(), unknown()).optional()));
const ClientTasksCapabilitySchema = looseObject({
  /**
   * Present if the client supports listing tasks.
   */
  list: AssertObjectSchema.optional(),
  /**
   * Present if the client supports cancelling tasks.
   */
  cancel: AssertObjectSchema.optional(),
  /**
   * Capabilities for task creation on specific request types.
   */
  requests: looseObject({
    /**
     * Task support for sampling requests.
     */
    sampling: looseObject({
      createMessage: AssertObjectSchema.optional()
    }).optional(),
    /**
     * Task support for elicitation requests.
     */
    elicitation: looseObject({
      create: AssertObjectSchema.optional()
    }).optional()
  }).optional()
});
const ServerTasksCapabilitySchema = looseObject({
  /**
   * Present if the server supports listing tasks.
   */
  list: AssertObjectSchema.optional(),
  /**
   * Present if the server supports cancelling tasks.
   */
  cancel: AssertObjectSchema.optional(),
  /**
   * Capabilities for task creation on specific request types.
   */
  requests: looseObject({
    /**
     * Task support for tool requests.
     */
    tools: looseObject({
      call: AssertObjectSchema.optional()
    }).optional()
  }).optional()
});
const ClientCapabilitiesSchema = object({
  /**
   * Experimental, non-standard capabilities that the client supports.
   */
  experimental: record(string(), AssertObjectSchema).optional(),
  /**
   * Present if the client supports sampling from an LLM.
   */
  sampling: object({
    /**
     * Present if the client supports context inclusion via includeContext parameter.
     * If not declared, servers SHOULD only use `includeContext: "none"` (or omit it).
     */
    context: AssertObjectSchema.optional(),
    /**
     * Present if the client supports tool use via tools and toolChoice parameters.
     */
    tools: AssertObjectSchema.optional()
  }).optional(),
  /**
   * Present if the client supports eliciting user input.
   */
  elicitation: ElicitationCapabilitySchema.optional(),
  /**
   * Present if the client supports listing roots.
   */
  roots: object({
    /**
     * Whether the client supports issuing notifications for changes to the roots list.
     */
    listChanged: boolean().optional()
  }).optional(),
  /**
   * Present if the client supports task creation.
   */
  tasks: ClientTasksCapabilitySchema.optional()
});
const InitializeRequestParamsSchema = BaseRequestParamsSchema.extend({
  /**
   * The latest version of the Model Context Protocol that the client supports. The client MAY decide to support older versions as well.
   */
  protocolVersion: string(),
  capabilities: ClientCapabilitiesSchema,
  clientInfo: ImplementationSchema
});
const InitializeRequestSchema = RequestSchema.extend({
  method: literal("initialize"),
  params: InitializeRequestParamsSchema
});
const ServerCapabilitiesSchema = object({
  /**
   * Experimental, non-standard capabilities that the server supports.
   */
  experimental: record(string(), AssertObjectSchema).optional(),
  /**
   * Present if the server supports sending log messages to the client.
   */
  logging: AssertObjectSchema.optional(),
  /**
   * Present if the server supports sending completions to the client.
   */
  completions: AssertObjectSchema.optional(),
  /**
   * Present if the server offers any prompt templates.
   */
  prompts: object({
    /**
     * Whether this server supports issuing notifications for changes to the prompt list.
     */
    listChanged: boolean().optional()
  }).optional(),
  /**
   * Present if the server offers any resources to read.
   */
  resources: object({
    /**
     * Whether this server supports clients subscribing to resource updates.
     */
    subscribe: boolean().optional(),
    /**
     * Whether this server supports issuing notifications for changes to the resource list.
     */
    listChanged: boolean().optional()
  }).optional(),
  /**
   * Present if the server offers any tools to call.
   */
  tools: object({
    /**
     * Whether this server supports issuing notifications for changes to the tool list.
     */
    listChanged: boolean().optional()
  }).optional(),
  /**
   * Present if the server supports task creation.
   */
  tasks: ServerTasksCapabilitySchema.optional()
});
const InitializeResultSchema = ResultSchema.extend({
  /**
   * The version of the Model Context Protocol that the server wants to use. This may not match the version that the client requested. If the client cannot support this version, it MUST disconnect.
   */
  protocolVersion: string(),
  capabilities: ServerCapabilitiesSchema,
  serverInfo: ImplementationSchema,
  /**
   * Instructions describing how to use the server and its features.
   *
   * This can be used by clients to improve the LLM's understanding of available tools, resources, etc. It can be thought of like a "hint" to the model. For example, this information MAY be added to the system prompt.
   */
  instructions: string().optional()
});
const InitializedNotificationSchema = NotificationSchema.extend({
  method: literal("notifications/initialized"),
  params: NotificationsParamsSchema.optional()
});
const isInitializedNotification = (value) => InitializedNotificationSchema.safeParse(value).success;
const PingRequestSchema = RequestSchema.extend({
  method: literal("ping"),
  params: BaseRequestParamsSchema.optional()
});
const ProgressSchema = object({
  /**
   * The progress thus far. This should increase every time progress is made, even if the total is unknown.
   */
  progress: number$1(),
  /**
   * Total number of items to process (or total progress required), if known.
   */
  total: optional(number$1()),
  /**
   * An optional message describing the current progress.
   */
  message: optional(string())
});
const ProgressNotificationParamsSchema = object({
  ...NotificationsParamsSchema.shape,
  ...ProgressSchema.shape,
  /**
   * The progress token which was given in the initial request, used to associate this notification with the request that is proceeding.
   */
  progressToken: ProgressTokenSchema
});
const ProgressNotificationSchema = NotificationSchema.extend({
  method: literal("notifications/progress"),
  params: ProgressNotificationParamsSchema
});
const PaginatedRequestParamsSchema = BaseRequestParamsSchema.extend({
  /**
   * An opaque token representing the current pagination position.
   * If provided, the server should return results starting after this cursor.
   */
  cursor: CursorSchema.optional()
});
const PaginatedRequestSchema = RequestSchema.extend({
  params: PaginatedRequestParamsSchema.optional()
});
const PaginatedResultSchema = ResultSchema.extend({
  /**
   * An opaque token representing the pagination position after the last returned result.
   * If present, there may be more results available.
   */
  nextCursor: CursorSchema.optional()
});
const TaskStatusSchema = _enum$3(["working", "input_required", "completed", "failed", "cancelled"]);
const TaskSchema = object({
  taskId: string(),
  status: TaskStatusSchema,
  /**
   * Time in milliseconds to keep task results available after completion.
   * If null, the task has unlimited lifetime until manually cleaned up.
   */
  ttl: union([number$1(), _null()]),
  /**
   * ISO 8601 timestamp when the task was created.
   */
  createdAt: string(),
  /**
   * ISO 8601 timestamp when the task was last updated.
   */
  lastUpdatedAt: string(),
  pollInterval: optional(number$1()),
  /**
   * Optional diagnostic message for failed tasks or other status information.
   */
  statusMessage: optional(string())
});
const CreateTaskResultSchema = ResultSchema.extend({
  task: TaskSchema
});
const TaskStatusNotificationParamsSchema = NotificationsParamsSchema.merge(TaskSchema);
const TaskStatusNotificationSchema = NotificationSchema.extend({
  method: literal("notifications/tasks/status"),
  params: TaskStatusNotificationParamsSchema
});
const GetTaskRequestSchema = RequestSchema.extend({
  method: literal("tasks/get"),
  params: BaseRequestParamsSchema.extend({
    taskId: string()
  })
});
const GetTaskResultSchema = ResultSchema.merge(TaskSchema);
const GetTaskPayloadRequestSchema = RequestSchema.extend({
  method: literal("tasks/result"),
  params: BaseRequestParamsSchema.extend({
    taskId: string()
  })
});
ResultSchema.loose();
const ListTasksRequestSchema = PaginatedRequestSchema.extend({
  method: literal("tasks/list")
});
const ListTasksResultSchema = PaginatedResultSchema.extend({
  tasks: array(TaskSchema)
});
const CancelTaskRequestSchema = RequestSchema.extend({
  method: literal("tasks/cancel"),
  params: BaseRequestParamsSchema.extend({
    taskId: string()
  })
});
const CancelTaskResultSchema = ResultSchema.merge(TaskSchema);
const ResourceContentsSchema = object({
  /**
   * The URI of this resource.
   */
  uri: string(),
  /**
   * The MIME type of this resource, if known.
   */
  mimeType: optional(string()),
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: record(string(), unknown()).optional()
});
const TextResourceContentsSchema = ResourceContentsSchema.extend({
  /**
   * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
   */
  text: string()
});
const Base64Schema = string().refine((val) => {
  try {
    atob(val);
    return true;
  } catch {
    return false;
  }
}, { message: "Invalid Base64 string" });
const BlobResourceContentsSchema = ResourceContentsSchema.extend({
  /**
   * A base64-encoded string representing the binary data of the item.
   */
  blob: Base64Schema
});
const RoleSchema = _enum$3(["user", "assistant"]);
const AnnotationsSchema = object({
  /**
   * Intended audience(s) for the resource.
   */
  audience: array(RoleSchema).optional(),
  /**
   * Importance hint for the resource, from 0 (least) to 1 (most).
   */
  priority: number$1().min(0).max(1).optional(),
  /**
   * ISO 8601 timestamp for the most recent modification.
   */
  lastModified: datetime({ offset: true }).optional()
});
const ResourceSchema = object({
  ...BaseMetadataSchema.shape,
  ...IconsSchema.shape,
  /**
   * The URI of this resource.
   */
  uri: string(),
  /**
   * A description of what this resource represents.
   *
   * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
   */
  description: optional(string()),
  /**
   * The MIME type of this resource, if known.
   */
  mimeType: optional(string()),
  /**
   * Optional annotations for the client.
   */
  annotations: AnnotationsSchema.optional(),
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: optional(looseObject({}))
});
const ResourceTemplateSchema = object({
  ...BaseMetadataSchema.shape,
  ...IconsSchema.shape,
  /**
   * A URI template (according to RFC 6570) that can be used to construct resource URIs.
   */
  uriTemplate: string(),
  /**
   * A description of what this template is for.
   *
   * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
   */
  description: optional(string()),
  /**
   * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
   */
  mimeType: optional(string()),
  /**
   * Optional annotations for the client.
   */
  annotations: AnnotationsSchema.optional(),
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: optional(looseObject({}))
});
const ListResourcesRequestSchema = PaginatedRequestSchema.extend({
  method: literal("resources/list")
});
const ListResourcesResultSchema = PaginatedResultSchema.extend({
  resources: array(ResourceSchema)
});
const ListResourceTemplatesRequestSchema = PaginatedRequestSchema.extend({
  method: literal("resources/templates/list")
});
const ListResourceTemplatesResultSchema = PaginatedResultSchema.extend({
  resourceTemplates: array(ResourceTemplateSchema)
});
const ResourceRequestParamsSchema = BaseRequestParamsSchema.extend({
  /**
   * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
   *
   * @format uri
   */
  uri: string()
});
const ReadResourceRequestParamsSchema = ResourceRequestParamsSchema;
const ReadResourceRequestSchema = RequestSchema.extend({
  method: literal("resources/read"),
  params: ReadResourceRequestParamsSchema
});
const ReadResourceResultSchema = ResultSchema.extend({
  contents: array(union([TextResourceContentsSchema, BlobResourceContentsSchema]))
});
const ResourceListChangedNotificationSchema = NotificationSchema.extend({
  method: literal("notifications/resources/list_changed"),
  params: NotificationsParamsSchema.optional()
});
const SubscribeRequestParamsSchema = ResourceRequestParamsSchema;
const SubscribeRequestSchema = RequestSchema.extend({
  method: literal("resources/subscribe"),
  params: SubscribeRequestParamsSchema
});
const UnsubscribeRequestParamsSchema = ResourceRequestParamsSchema;
const UnsubscribeRequestSchema = RequestSchema.extend({
  method: literal("resources/unsubscribe"),
  params: UnsubscribeRequestParamsSchema
});
const ResourceUpdatedNotificationParamsSchema = NotificationsParamsSchema.extend({
  /**
   * The URI of the resource that has been updated. This might be a sub-resource of the one that the client actually subscribed to.
   */
  uri: string()
});
const ResourceUpdatedNotificationSchema = NotificationSchema.extend({
  method: literal("notifications/resources/updated"),
  params: ResourceUpdatedNotificationParamsSchema
});
const PromptArgumentSchema = object({
  /**
   * The name of the argument.
   */
  name: string(),
  /**
   * A human-readable description of the argument.
   */
  description: optional(string()),
  /**
   * Whether this argument must be provided.
   */
  required: optional(boolean())
});
const PromptSchema = object({
  ...BaseMetadataSchema.shape,
  ...IconsSchema.shape,
  /**
   * An optional description of what this prompt provides
   */
  description: optional(string()),
  /**
   * A list of arguments to use for templating the prompt.
   */
  arguments: optional(array(PromptArgumentSchema)),
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: optional(looseObject({}))
});
const ListPromptsRequestSchema = PaginatedRequestSchema.extend({
  method: literal("prompts/list")
});
const ListPromptsResultSchema = PaginatedResultSchema.extend({
  prompts: array(PromptSchema)
});
const GetPromptRequestParamsSchema = BaseRequestParamsSchema.extend({
  /**
   * The name of the prompt or prompt template.
   */
  name: string(),
  /**
   * Arguments to use for templating the prompt.
   */
  arguments: record(string(), string()).optional()
});
const GetPromptRequestSchema = RequestSchema.extend({
  method: literal("prompts/get"),
  params: GetPromptRequestParamsSchema
});
const TextContentSchema = object({
  type: literal("text"),
  /**
   * The text content of the message.
   */
  text: string(),
  /**
   * Optional annotations for the client.
   */
  annotations: AnnotationsSchema.optional(),
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: record(string(), unknown()).optional()
});
const ImageContentSchema = object({
  type: literal("image"),
  /**
   * The base64-encoded image data.
   */
  data: Base64Schema,
  /**
   * The MIME type of the image. Different providers may support different image types.
   */
  mimeType: string(),
  /**
   * Optional annotations for the client.
   */
  annotations: AnnotationsSchema.optional(),
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: record(string(), unknown()).optional()
});
const AudioContentSchema = object({
  type: literal("audio"),
  /**
   * The base64-encoded audio data.
   */
  data: Base64Schema,
  /**
   * The MIME type of the audio. Different providers may support different audio types.
   */
  mimeType: string(),
  /**
   * Optional annotations for the client.
   */
  annotations: AnnotationsSchema.optional(),
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: record(string(), unknown()).optional()
});
const ToolUseContentSchema = object({
  type: literal("tool_use"),
  /**
   * The name of the tool to invoke.
   * Must match a tool name from the request's tools array.
   */
  name: string(),
  /**
   * Unique identifier for this tool call.
   * Used to correlate with ToolResultContent in subsequent messages.
   */
  id: string(),
  /**
   * Arguments to pass to the tool.
   * Must conform to the tool's inputSchema.
   */
  input: record(string(), unknown()),
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: record(string(), unknown()).optional()
});
const EmbeddedResourceSchema = object({
  type: literal("resource"),
  resource: union([TextResourceContentsSchema, BlobResourceContentsSchema]),
  /**
   * Optional annotations for the client.
   */
  annotations: AnnotationsSchema.optional(),
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: record(string(), unknown()).optional()
});
const ResourceLinkSchema = ResourceSchema.extend({
  type: literal("resource_link")
});
const ContentBlockSchema = union([
  TextContentSchema,
  ImageContentSchema,
  AudioContentSchema,
  ResourceLinkSchema,
  EmbeddedResourceSchema
]);
const PromptMessageSchema = object({
  role: RoleSchema,
  content: ContentBlockSchema
});
const GetPromptResultSchema = ResultSchema.extend({
  /**
   * An optional description for the prompt.
   */
  description: string().optional(),
  messages: array(PromptMessageSchema)
});
const PromptListChangedNotificationSchema = NotificationSchema.extend({
  method: literal("notifications/prompts/list_changed"),
  params: NotificationsParamsSchema.optional()
});
const ToolAnnotationsSchema = object({
  /**
   * A human-readable title for the tool.
   */
  title: string().optional(),
  /**
   * If true, the tool does not modify its environment.
   *
   * Default: false
   */
  readOnlyHint: boolean().optional(),
  /**
   * If true, the tool may perform destructive updates to its environment.
   * If false, the tool performs only additive updates.
   *
   * (This property is meaningful only when `readOnlyHint == false`)
   *
   * Default: true
   */
  destructiveHint: boolean().optional(),
  /**
   * If true, calling the tool repeatedly with the same arguments
   * will have no additional effect on the its environment.
   *
   * (This property is meaningful only when `readOnlyHint == false`)
   *
   * Default: false
   */
  idempotentHint: boolean().optional(),
  /**
   * If true, this tool may interact with an "open world" of external
   * entities. If false, the tool's domain of interaction is closed.
   * For example, the world of a web search tool is open, whereas that
   * of a memory tool is not.
   *
   * Default: true
   */
  openWorldHint: boolean().optional()
});
const ToolExecutionSchema = object({
  /**
   * Indicates the tool's preference for task-augmented execution.
   * - "required": Clients MUST invoke the tool as a task
   * - "optional": Clients MAY invoke the tool as a task or normal request
   * - "forbidden": Clients MUST NOT attempt to invoke the tool as a task
   *
   * If not present, defaults to "forbidden".
   */
  taskSupport: _enum$3(["required", "optional", "forbidden"]).optional()
});
const ToolSchema = object({
  ...BaseMetadataSchema.shape,
  ...IconsSchema.shape,
  /**
   * A human-readable description of the tool.
   */
  description: string().optional(),
  /**
   * A JSON Schema 2020-12 object defining the expected parameters for the tool.
   * Must have type: 'object' at the root level per MCP spec.
   */
  inputSchema: object({
    type: literal("object"),
    properties: record(string(), AssertObjectSchema).optional(),
    required: array(string()).optional()
  }).catchall(unknown()),
  /**
   * An optional JSON Schema 2020-12 object defining the structure of the tool's output
   * returned in the structuredContent field of a CallToolResult.
   * Must have type: 'object' at the root level per MCP spec.
   */
  outputSchema: object({
    type: literal("object"),
    properties: record(string(), AssertObjectSchema).optional(),
    required: array(string()).optional()
  }).catchall(unknown()).optional(),
  /**
   * Optional additional tool information.
   */
  annotations: ToolAnnotationsSchema.optional(),
  /**
   * Execution-related properties for this tool.
   */
  execution: ToolExecutionSchema.optional(),
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: record(string(), unknown()).optional()
});
const ListToolsRequestSchema = PaginatedRequestSchema.extend({
  method: literal("tools/list")
});
const ListToolsResultSchema = PaginatedResultSchema.extend({
  tools: array(ToolSchema)
});
const CallToolResultSchema = ResultSchema.extend({
  /**
   * A list of content objects that represent the result of the tool call.
   *
   * If the Tool does not define an outputSchema, this field MUST be present in the result.
   * For backwards compatibility, this field is always present, but it may be empty.
   */
  content: array(ContentBlockSchema).default([]),
  /**
   * An object containing structured tool output.
   *
   * If the Tool defines an outputSchema, this field MUST be present in the result, and contain a JSON object that matches the schema.
   */
  structuredContent: record(string(), unknown()).optional(),
  /**
   * Whether the tool call ended in an error.
   *
   * If not set, this is assumed to be false (the call was successful).
   *
   * Any errors that originate from the tool SHOULD be reported inside the result
   * object, with `isError` set to true, _not_ as an MCP protocol-level error
   * response. Otherwise, the LLM would not be able to see that an error occurred
   * and self-correct.
   *
   * However, any errors in _finding_ the tool, an error indicating that the
   * server does not support tool calls, or any other exceptional conditions,
   * should be reported as an MCP error response.
   */
  isError: boolean().optional()
});
const CompatibilityCallToolResultSchema = CallToolResultSchema.or(ResultSchema.extend({
  toolResult: unknown()
}));
const CallToolRequestParamsSchema = TaskAugmentedRequestParamsSchema.extend({
  /**
   * The name of the tool to call.
   */
  name: string(),
  /**
   * Arguments to pass to the tool.
   */
  arguments: record(string(), unknown()).optional()
});
const CallToolRequestSchema = RequestSchema.extend({
  method: literal("tools/call"),
  params: CallToolRequestParamsSchema
});
const ToolListChangedNotificationSchema = NotificationSchema.extend({
  method: literal("notifications/tools/list_changed"),
  params: NotificationsParamsSchema.optional()
});
const ListChangedOptionsBaseSchema = object({
  /**
   * If true, the list will be refreshed automatically when a list changed notification is received.
   * The callback will be called with the updated list.
   *
   * If false, the callback will be called with null items, allowing manual refresh.
   *
   * @default true
   */
  autoRefresh: boolean().default(true),
  /**
   * Debounce time in milliseconds for list changed notification processing.
   *
   * Multiple notifications received within this timeframe will only trigger one refresh.
   * Set to 0 to disable debouncing.
   *
   * @default 300
   */
  debounceMs: number$1().int().nonnegative().default(300)
});
const LoggingLevelSchema = _enum$3(["debug", "info", "notice", "warning", "error", "critical", "alert", "emergency"]);
const SetLevelRequestParamsSchema = BaseRequestParamsSchema.extend({
  /**
   * The level of logging that the client wants to receive from the server. The server should send all logs at this level and higher (i.e., more severe) to the client as notifications/logging/message.
   */
  level: LoggingLevelSchema
});
const SetLevelRequestSchema = RequestSchema.extend({
  method: literal("logging/setLevel"),
  params: SetLevelRequestParamsSchema
});
const LoggingMessageNotificationParamsSchema = NotificationsParamsSchema.extend({
  /**
   * The severity of this log message.
   */
  level: LoggingLevelSchema,
  /**
   * An optional name of the logger issuing this message.
   */
  logger: string().optional(),
  /**
   * The data to be logged, such as a string message or an object. Any JSON serializable type is allowed here.
   */
  data: unknown()
});
const LoggingMessageNotificationSchema = NotificationSchema.extend({
  method: literal("notifications/message"),
  params: LoggingMessageNotificationParamsSchema
});
const ModelHintSchema = object({
  /**
   * A hint for a model name.
   */
  name: string().optional()
});
const ModelPreferencesSchema = object({
  /**
   * Optional hints to use for model selection.
   */
  hints: array(ModelHintSchema).optional(),
  /**
   * How much to prioritize cost when selecting a model.
   */
  costPriority: number$1().min(0).max(1).optional(),
  /**
   * How much to prioritize sampling speed (latency) when selecting a model.
   */
  speedPriority: number$1().min(0).max(1).optional(),
  /**
   * How much to prioritize intelligence and capabilities when selecting a model.
   */
  intelligencePriority: number$1().min(0).max(1).optional()
});
const ToolChoiceSchema = object({
  /**
   * Controls when tools are used:
   * - "auto": Model decides whether to use tools (default)
   * - "required": Model MUST use at least one tool before completing
   * - "none": Model MUST NOT use any tools
   */
  mode: _enum$3(["auto", "required", "none"]).optional()
});
const ToolResultContentSchema = object({
  type: literal("tool_result"),
  toolUseId: string().describe("The unique identifier for the corresponding tool call."),
  content: array(ContentBlockSchema).default([]),
  structuredContent: object({}).loose().optional(),
  isError: boolean().optional(),
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: record(string(), unknown()).optional()
});
const SamplingContentSchema = discriminatedUnion("type", [TextContentSchema, ImageContentSchema, AudioContentSchema]);
const SamplingMessageContentBlockSchema = discriminatedUnion("type", [
  TextContentSchema,
  ImageContentSchema,
  AudioContentSchema,
  ToolUseContentSchema,
  ToolResultContentSchema
]);
const SamplingMessageSchema = object({
  role: RoleSchema,
  content: union([SamplingMessageContentBlockSchema, array(SamplingMessageContentBlockSchema)]),
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: record(string(), unknown()).optional()
});
const CreateMessageRequestParamsSchema = TaskAugmentedRequestParamsSchema.extend({
  messages: array(SamplingMessageSchema),
  /**
   * The server's preferences for which model to select. The client MAY modify or omit this request.
   */
  modelPreferences: ModelPreferencesSchema.optional(),
  /**
   * An optional system prompt the server wants to use for sampling. The client MAY modify or omit this prompt.
   */
  systemPrompt: string().optional(),
  /**
   * A request to include context from one or more MCP servers (including the caller), to be attached to the prompt.
   * The client MAY ignore this request.
   *
   * Default is "none". Values "thisServer" and "allServers" are soft-deprecated. Servers SHOULD only use these values if the client
   * declares ClientCapabilities.sampling.context. These values may be removed in future spec releases.
   */
  includeContext: _enum$3(["none", "thisServer", "allServers"]).optional(),
  temperature: number$1().optional(),
  /**
   * The requested maximum number of tokens to sample (to prevent runaway completions).
   *
   * The client MAY choose to sample fewer tokens than the requested maximum.
   */
  maxTokens: number$1().int(),
  stopSequences: array(string()).optional(),
  /**
   * Optional metadata to pass through to the LLM provider. The format of this metadata is provider-specific.
   */
  metadata: AssertObjectSchema.optional(),
  /**
   * Tools that the model may use during generation.
   * The client MUST return an error if this field is provided but ClientCapabilities.sampling.tools is not declared.
   */
  tools: array(ToolSchema).optional(),
  /**
   * Controls how the model uses tools.
   * The client MUST return an error if this field is provided but ClientCapabilities.sampling.tools is not declared.
   * Default is `{ mode: "auto" }`.
   */
  toolChoice: ToolChoiceSchema.optional()
});
const CreateMessageRequestSchema = RequestSchema.extend({
  method: literal("sampling/createMessage"),
  params: CreateMessageRequestParamsSchema
});
const CreateMessageResultSchema = ResultSchema.extend({
  /**
   * The name of the model that generated the message.
   */
  model: string(),
  /**
   * The reason why sampling stopped, if known.
   *
   * Standard values:
   * - "endTurn": Natural end of the assistant's turn
   * - "stopSequence": A stop sequence was encountered
   * - "maxTokens": Maximum token limit was reached
   *
   * This field is an open string to allow for provider-specific stop reasons.
   */
  stopReason: optional(_enum$3(["endTurn", "stopSequence", "maxTokens"]).or(string())),
  role: RoleSchema,
  /**
   * Response content. Single content block (text, image, or audio).
   */
  content: SamplingContentSchema
});
const CreateMessageResultWithToolsSchema = ResultSchema.extend({
  /**
   * The name of the model that generated the message.
   */
  model: string(),
  /**
   * The reason why sampling stopped, if known.
   *
   * Standard values:
   * - "endTurn": Natural end of the assistant's turn
   * - "stopSequence": A stop sequence was encountered
   * - "maxTokens": Maximum token limit was reached
   * - "toolUse": The model wants to use one or more tools
   *
   * This field is an open string to allow for provider-specific stop reasons.
   */
  stopReason: optional(_enum$3(["endTurn", "stopSequence", "maxTokens", "toolUse"]).or(string())),
  role: RoleSchema,
  /**
   * Response content. May be a single block or array. May include ToolUseContent if stopReason is "toolUse".
   */
  content: union([SamplingMessageContentBlockSchema, array(SamplingMessageContentBlockSchema)])
});
const BooleanSchemaSchema = object({
  type: literal("boolean"),
  title: string().optional(),
  description: string().optional(),
  default: boolean().optional()
});
const StringSchemaSchema = object({
  type: literal("string"),
  title: string().optional(),
  description: string().optional(),
  minLength: number$1().optional(),
  maxLength: number$1().optional(),
  format: _enum$3(["email", "uri", "date", "date-time"]).optional(),
  default: string().optional()
});
const NumberSchemaSchema = object({
  type: _enum$3(["number", "integer"]),
  title: string().optional(),
  description: string().optional(),
  minimum: number$1().optional(),
  maximum: number$1().optional(),
  default: number$1().optional()
});
const UntitledSingleSelectEnumSchemaSchema = object({
  type: literal("string"),
  title: string().optional(),
  description: string().optional(),
  enum: array(string()),
  default: string().optional()
});
const TitledSingleSelectEnumSchemaSchema = object({
  type: literal("string"),
  title: string().optional(),
  description: string().optional(),
  oneOf: array(object({
    const: string(),
    title: string()
  })),
  default: string().optional()
});
const LegacyTitledEnumSchemaSchema = object({
  type: literal("string"),
  title: string().optional(),
  description: string().optional(),
  enum: array(string()),
  enumNames: array(string()).optional(),
  default: string().optional()
});
const SingleSelectEnumSchemaSchema = union([UntitledSingleSelectEnumSchemaSchema, TitledSingleSelectEnumSchemaSchema]);
const UntitledMultiSelectEnumSchemaSchema = object({
  type: literal("array"),
  title: string().optional(),
  description: string().optional(),
  minItems: number$1().optional(),
  maxItems: number$1().optional(),
  items: object({
    type: literal("string"),
    enum: array(string())
  }),
  default: array(string()).optional()
});
const TitledMultiSelectEnumSchemaSchema = object({
  type: literal("array"),
  title: string().optional(),
  description: string().optional(),
  minItems: number$1().optional(),
  maxItems: number$1().optional(),
  items: object({
    anyOf: array(object({
      const: string(),
      title: string()
    }))
  }),
  default: array(string()).optional()
});
const MultiSelectEnumSchemaSchema = union([UntitledMultiSelectEnumSchemaSchema, TitledMultiSelectEnumSchemaSchema]);
const EnumSchemaSchema = union([LegacyTitledEnumSchemaSchema, SingleSelectEnumSchemaSchema, MultiSelectEnumSchemaSchema]);
const PrimitiveSchemaDefinitionSchema = union([EnumSchemaSchema, BooleanSchemaSchema, StringSchemaSchema, NumberSchemaSchema]);
const ElicitRequestFormParamsSchema = TaskAugmentedRequestParamsSchema.extend({
  /**
   * The elicitation mode.
   *
   * Optional for backward compatibility. Clients MUST treat missing mode as "form".
   */
  mode: literal("form").optional(),
  /**
   * The message to present to the user describing what information is being requested.
   */
  message: string(),
  /**
   * A restricted subset of JSON Schema.
   * Only top-level properties are allowed, without nesting.
   */
  requestedSchema: object({
    type: literal("object"),
    properties: record(string(), PrimitiveSchemaDefinitionSchema),
    required: array(string()).optional()
  })
});
const ElicitRequestURLParamsSchema = TaskAugmentedRequestParamsSchema.extend({
  /**
   * The elicitation mode.
   */
  mode: literal("url"),
  /**
   * The message to present to the user explaining why the interaction is needed.
   */
  message: string(),
  /**
   * The ID of the elicitation, which must be unique within the context of the server.
   * The client MUST treat this ID as an opaque value.
   */
  elicitationId: string(),
  /**
   * The URL that the user should navigate to.
   */
  url: string().url()
});
const ElicitRequestParamsSchema = union([ElicitRequestFormParamsSchema, ElicitRequestURLParamsSchema]);
const ElicitRequestSchema = RequestSchema.extend({
  method: literal("elicitation/create"),
  params: ElicitRequestParamsSchema
});
const ElicitationCompleteNotificationParamsSchema = NotificationsParamsSchema.extend({
  /**
   * The ID of the elicitation that completed.
   */
  elicitationId: string()
});
const ElicitationCompleteNotificationSchema = NotificationSchema.extend({
  method: literal("notifications/elicitation/complete"),
  params: ElicitationCompleteNotificationParamsSchema
});
const ElicitResultSchema = ResultSchema.extend({
  /**
   * The user action in response to the elicitation.
   * - "accept": User submitted the form/confirmed the action
   * - "decline": User explicitly decline the action
   * - "cancel": User dismissed without making an explicit choice
   */
  action: _enum$3(["accept", "decline", "cancel"]),
  /**
   * The submitted form data, only present when action is "accept".
   * Contains values matching the requested schema.
   * Per MCP spec, content is "typically omitted" for decline/cancel actions.
   * We normalize null to undefined for leniency while maintaining type compatibility.
   */
  content: preprocess((val) => val === null ? void 0 : val, record(string(), union([string(), number$1(), boolean(), array(string())])).optional())
});
const ResourceTemplateReferenceSchema = object({
  type: literal("ref/resource"),
  /**
   * The URI or URI template of the resource.
   */
  uri: string()
});
const PromptReferenceSchema = object({
  type: literal("ref/prompt"),
  /**
   * The name of the prompt or prompt template
   */
  name: string()
});
const CompleteRequestParamsSchema = BaseRequestParamsSchema.extend({
  ref: union([PromptReferenceSchema, ResourceTemplateReferenceSchema]),
  /**
   * The argument's information
   */
  argument: object({
    /**
     * The name of the argument
     */
    name: string(),
    /**
     * The value of the argument to use for completion matching.
     */
    value: string()
  }),
  context: object({
    /**
     * Previously-resolved variables in a URI template or prompt.
     */
    arguments: record(string(), string()).optional()
  }).optional()
});
const CompleteRequestSchema = RequestSchema.extend({
  method: literal("completion/complete"),
  params: CompleteRequestParamsSchema
});
const CompleteResultSchema = ResultSchema.extend({
  completion: looseObject({
    /**
     * An array of completion values. Must not exceed 100 items.
     */
    values: array(string()).max(100),
    /**
     * The total number of completion options available. This can exceed the number of values actually sent in the response.
     */
    total: optional(number$1().int()),
    /**
     * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
     */
    hasMore: optional(boolean())
  })
});
const RootSchema = object({
  /**
   * The URI identifying the root. This *must* start with file:// for now.
   */
  uri: string().startsWith("file://"),
  /**
   * An optional name for the root.
   */
  name: string().optional(),
  /**
   * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
   * for notes on _meta usage.
   */
  _meta: record(string(), unknown()).optional()
});
const ListRootsRequestSchema = RequestSchema.extend({
  method: literal("roots/list"),
  params: BaseRequestParamsSchema.optional()
});
const ListRootsResultSchema = ResultSchema.extend({
  roots: array(RootSchema)
});
const RootsListChangedNotificationSchema = NotificationSchema.extend({
  method: literal("notifications/roots/list_changed"),
  params: NotificationsParamsSchema.optional()
});
union([
  PingRequestSchema,
  InitializeRequestSchema,
  CompleteRequestSchema,
  SetLevelRequestSchema,
  GetPromptRequestSchema,
  ListPromptsRequestSchema,
  ListResourcesRequestSchema,
  ListResourceTemplatesRequestSchema,
  ReadResourceRequestSchema,
  SubscribeRequestSchema,
  UnsubscribeRequestSchema,
  CallToolRequestSchema,
  ListToolsRequestSchema,
  GetTaskRequestSchema,
  GetTaskPayloadRequestSchema,
  ListTasksRequestSchema,
  CancelTaskRequestSchema
]);
union([
  CancelledNotificationSchema,
  ProgressNotificationSchema,
  InitializedNotificationSchema,
  RootsListChangedNotificationSchema,
  TaskStatusNotificationSchema
]);
union([
  EmptyResultSchema,
  CreateMessageResultSchema,
  CreateMessageResultWithToolsSchema,
  ElicitResultSchema,
  ListRootsResultSchema,
  GetTaskResultSchema,
  ListTasksResultSchema,
  CreateTaskResultSchema
]);
union([
  PingRequestSchema,
  CreateMessageRequestSchema,
  ElicitRequestSchema,
  ListRootsRequestSchema,
  GetTaskRequestSchema,
  GetTaskPayloadRequestSchema,
  ListTasksRequestSchema,
  CancelTaskRequestSchema
]);
union([
  CancelledNotificationSchema,
  ProgressNotificationSchema,
  LoggingMessageNotificationSchema,
  ResourceUpdatedNotificationSchema,
  ResourceListChangedNotificationSchema,
  ToolListChangedNotificationSchema,
  PromptListChangedNotificationSchema,
  TaskStatusNotificationSchema,
  ElicitationCompleteNotificationSchema
]);
union([
  EmptyResultSchema,
  InitializeResultSchema,
  CompleteResultSchema,
  GetPromptResultSchema,
  ListPromptsResultSchema,
  ListResourcesResultSchema,
  ListResourceTemplatesResultSchema,
  ReadResourceResultSchema,
  CallToolResultSchema,
  ListToolsResultSchema,
  GetTaskResultSchema,
  ListTasksResultSchema,
  CreateTaskResultSchema
]);
class McpError extends Error {
  constructor(code2, message, data2) {
    super(`MCP error ${code2}: ${message}`);
    this.code = code2;
    this.data = data2;
    this.name = "McpError";
  }
  /**
   * Factory method to create the appropriate error type based on the error code and data
   */
  static fromError(code2, message, data2) {
    if (code2 === ErrorCode.UrlElicitationRequired && data2) {
      const errorData = data2;
      if (errorData.elicitations) {
        return new UrlElicitationRequiredError(errorData.elicitations, message);
      }
    }
    return new McpError(code2, message, data2);
  }
}
class UrlElicitationRequiredError extends McpError {
  constructor(elicitations, message = `URL elicitation${elicitations.length > 1 ? "s" : ""} required`) {
    super(ErrorCode.UrlElicitationRequired, message, {
      elicitations
    });
  }
  get elicitations() {
    return this.data?.elicitations ?? [];
  }
}
const SafeUrlSchema = url().superRefine((val, ctx) => {
  if (!URL.canParse(val)) {
    ctx.addIssue({
      code: ZodIssueCode$1.custom,
      message: "URL must be parseable",
      fatal: true
    });
    return NEVER;
  }
}).refine((url2) => {
  const u2 = new URL(url2);
  return u2.protocol !== "javascript:" && u2.protocol !== "data:" && u2.protocol !== "vbscript:";
}, { message: "URL cannot use javascript:, data:, or vbscript: scheme" });
const OAuthProtectedResourceMetadataSchema = looseObject({
  resource: string().url(),
  authorization_servers: array(SafeUrlSchema).optional(),
  jwks_uri: string().url().optional(),
  scopes_supported: array(string()).optional(),
  bearer_methods_supported: array(string()).optional(),
  resource_signing_alg_values_supported: array(string()).optional(),
  resource_name: string().optional(),
  resource_documentation: string().optional(),
  resource_policy_uri: string().url().optional(),
  resource_tos_uri: string().url().optional(),
  tls_client_certificate_bound_access_tokens: boolean().optional(),
  authorization_details_types_supported: array(string()).optional(),
  dpop_signing_alg_values_supported: array(string()).optional(),
  dpop_bound_access_tokens_required: boolean().optional()
});
const OAuthMetadataSchema = looseObject({
  issuer: string(),
  authorization_endpoint: SafeUrlSchema,
  token_endpoint: SafeUrlSchema,
  registration_endpoint: SafeUrlSchema.optional(),
  scopes_supported: array(string()).optional(),
  response_types_supported: array(string()),
  response_modes_supported: array(string()).optional(),
  grant_types_supported: array(string()).optional(),
  token_endpoint_auth_methods_supported: array(string()).optional(),
  token_endpoint_auth_signing_alg_values_supported: array(string()).optional(),
  service_documentation: SafeUrlSchema.optional(),
  revocation_endpoint: SafeUrlSchema.optional(),
  revocation_endpoint_auth_methods_supported: array(string()).optional(),
  revocation_endpoint_auth_signing_alg_values_supported: array(string()).optional(),
  introspection_endpoint: string().optional(),
  introspection_endpoint_auth_methods_supported: array(string()).optional(),
  introspection_endpoint_auth_signing_alg_values_supported: array(string()).optional(),
  code_challenge_methods_supported: array(string()).optional(),
  client_id_metadata_document_supported: boolean().optional()
});
const OpenIdProviderMetadataSchema = looseObject({
  issuer: string(),
  authorization_endpoint: SafeUrlSchema,
  token_endpoint: SafeUrlSchema,
  userinfo_endpoint: SafeUrlSchema.optional(),
  jwks_uri: SafeUrlSchema,
  registration_endpoint: SafeUrlSchema.optional(),
  scopes_supported: array(string()).optional(),
  response_types_supported: array(string()),
  response_modes_supported: array(string()).optional(),
  grant_types_supported: array(string()).optional(),
  acr_values_supported: array(string()).optional(),
  subject_types_supported: array(string()),
  id_token_signing_alg_values_supported: array(string()),
  id_token_encryption_alg_values_supported: array(string()).optional(),
  id_token_encryption_enc_values_supported: array(string()).optional(),
  userinfo_signing_alg_values_supported: array(string()).optional(),
  userinfo_encryption_alg_values_supported: array(string()).optional(),
  userinfo_encryption_enc_values_supported: array(string()).optional(),
  request_object_signing_alg_values_supported: array(string()).optional(),
  request_object_encryption_alg_values_supported: array(string()).optional(),
  request_object_encryption_enc_values_supported: array(string()).optional(),
  token_endpoint_auth_methods_supported: array(string()).optional(),
  token_endpoint_auth_signing_alg_values_supported: array(string()).optional(),
  display_values_supported: array(string()).optional(),
  claim_types_supported: array(string()).optional(),
  claims_supported: array(string()).optional(),
  service_documentation: string().optional(),
  claims_locales_supported: array(string()).optional(),
  ui_locales_supported: array(string()).optional(),
  claims_parameter_supported: boolean().optional(),
  request_parameter_supported: boolean().optional(),
  request_uri_parameter_supported: boolean().optional(),
  require_request_uri_registration: boolean().optional(),
  op_policy_uri: SafeUrlSchema.optional(),
  op_tos_uri: SafeUrlSchema.optional(),
  client_id_metadata_document_supported: boolean().optional()
});
const OpenIdProviderDiscoveryMetadataSchema = object({
  ...OpenIdProviderMetadataSchema.shape,
  ...OAuthMetadataSchema.pick({
    code_challenge_methods_supported: true
  }).shape
});
const OAuthTokensSchema = object({
  access_token: string(),
  id_token: string().optional(),
  // Optional for OAuth 2.1, but necessary in OpenID Connect
  token_type: string(),
  expires_in: number().optional(),
  scope: string().optional(),
  refresh_token: string().optional()
}).strip();
const OAuthErrorResponseSchema = object({
  error: string(),
  error_description: string().optional(),
  error_uri: string().optional()
});
const OptionalSafeUrlSchema = SafeUrlSchema.optional().or(literal("").transform(() => void 0));
const OAuthClientMetadataSchema = object({
  redirect_uris: array(SafeUrlSchema),
  token_endpoint_auth_method: string().optional(),
  grant_types: array(string()).optional(),
  response_types: array(string()).optional(),
  client_name: string().optional(),
  client_uri: SafeUrlSchema.optional(),
  logo_uri: OptionalSafeUrlSchema,
  scope: string().optional(),
  contacts: array(string()).optional(),
  tos_uri: OptionalSafeUrlSchema,
  policy_uri: string().optional(),
  jwks_uri: SafeUrlSchema.optional(),
  jwks: any().optional(),
  software_id: string().optional(),
  software_version: string().optional(),
  software_statement: string().optional()
}).strip();
const OAuthClientInformationSchema = object({
  client_id: string(),
  client_secret: string().optional(),
  client_id_issued_at: number$1().optional(),
  client_secret_expires_at: number$1().optional()
}).strip();
const OAuthClientInformationFullSchema = OAuthClientMetadataSchema.merge(OAuthClientInformationSchema);
object({
  error: string(),
  error_description: string().optional()
}).strip();
object({
  token: string(),
  token_type_hint: string().optional()
}).strip();
const name = "@modelcontextprotocol/inspector-client";
const version$1 = "0.21.1";
const packageJson = {
  name,
  version: version$1
};
const CLIENT_IDENTITY = (() => {
  const [, name2 = packageJson.name] = packageJson.name.split("/");
  const version2 = packageJson.version;
  return { name: name2, version: version2 };
})();
const SESSION_KEYS = {
  CODE_VERIFIER: "mcp_code_verifier",
  SERVER_URL: "mcp_server_url",
  TOKENS: "mcp_tokens",
  CLIENT_INFORMATION: "mcp_client_information",
  PREREGISTERED_CLIENT_INFORMATION: "mcp_preregistered_client_information",
  SERVER_METADATA: "mcp_server_metadata",
  AUTH_DEBUGGER_STATE: "mcp_auth_debugger_state",
  SCOPE: "mcp_scope"
};
const getServerSpecificKey = (baseKey, serverUrl) => {
  if (!serverUrl) return baseKey;
  return `[${serverUrl}] ${baseKey}`;
};
const DEFAULT_MCP_PROXY_LISTEN_PORT = "6277";
const DEFAULT_INSPECTOR_CONFIG = {
  MCP_SERVER_REQUEST_TIMEOUT: {
    label: "Request Timeout",
    description: "Client-side timeout (ms) - Inspector will cancel requests after this time",
    value: 3e5,
    // 5 minutes - increased to support elicitation and other long-running tools
    is_session_item: false
  },
  MCP_REQUEST_TIMEOUT_RESET_ON_PROGRESS: {
    label: "Reset Timeout on Progress",
    description: "Reset timeout on progress notifications",
    value: true,
    is_session_item: false
  },
  MCP_REQUEST_MAX_TOTAL_TIMEOUT: {
    label: "Maximum Total Timeout",
    description: "Maximum total timeout for requests sent to the MCP server (ms) (Use with progress notifications)",
    value: 6e4,
    is_session_item: false
  },
  MCP_PROXY_FULL_ADDRESS: {
    label: "Inspector Proxy Address",
    description: "Set this if you are running the MCP Inspector Proxy on a non-default address. Example: http://10.1.1.22:5577",
    value: "",
    is_session_item: false
  },
  MCP_PROXY_AUTH_TOKEN: {
    label: "Proxy Session Token",
    description: "Session token for authenticating with the MCP Proxy Server (displayed in proxy console on startup)",
    value: "",
    is_session_item: true
  },
  MCP_TASK_TTL: {
    label: "Task TTL",
    description: "Default Time-to-Live (TTL) in milliseconds for newly created tasks",
    value: 6e4,
    is_session_item: false
  }
};
const META_PREFIX_LABEL_REGEX = /^[a-z](?:[a-z\d-]*[a-z\d])?$/i;
const META_NAME_REGEX = /^[a-z\d](?:[a-z\d._-]*[a-z\d])?$/i;
const RESERVED_NAMESPACE_LABELS = ["modelcontextprotocol", "mcp"];
const RESERVED_NAMESPACE_MESSAGE = 'Keys using the "modelcontextprotocol.*" or "mcp.*" namespaces are reserved by MCP and cannot be used.';
const META_NAME_RULES_MESSAGE = "Names must begin and end with an alphanumeric character and may only contain alphanumerics, hyphens (-), underscores (_), or dots (.) in between.";
const META_PREFIX_RULES_MESSAGE = "Prefixes must be dot-separated labels that start with a letter and end with a letter or digit (e.g. example.domain/).";
const getPrefixSegment = (key) => {
  const trimmedKey = key.trim();
  const slashIndex = trimmedKey.indexOf("/");
  if (slashIndex === -1) {
    return null;
  }
  return trimmedKey.slice(0, slashIndex);
};
const normalizeSegment = (segment) => {
  if (!segment) return null;
  let normalized = segment.trim().toLowerCase();
  if (!normalized) return null;
  const schemeIndex = normalized.indexOf("://");
  if (schemeIndex !== -1) {
    normalized = normalized.slice(schemeIndex + 3);
  }
  const stopChars = ["?", "#", ":"];
  let endIndex = normalized.length;
  stopChars.forEach((char) => {
    const idx = normalized.indexOf(char);
    if (idx !== -1 && idx < endIndex) {
      endIndex = idx;
    }
  });
  return normalized.slice(0, endIndex) || null;
};
const splitLabels = (segment) => {
  const normalized = normalizeSegment(segment);
  if (!normalized) return null;
  const labels = normalized.split(".");
  if (labels.length === 0 || labels.some((label) => !label || !META_PREFIX_LABEL_REGEX.test(label))) {
    return null;
  }
  return labels;
};
const isReservedMetaKey = (key) => {
  const trimmedKey = key.trim();
  if (!trimmedKey) {
    return false;
  }
  const candidateSegment = getPrefixSegment(trimmedKey) ?? trimmedKey;
  const labels = splitLabels(candidateSegment);
  if (!labels || labels.length < 2) {
    return false;
  }
  for (let i = 0; i < labels.length - 1; i += 1) {
    const current = labels[i];
    const next = labels[i + 1];
    if (RESERVED_NAMESPACE_LABELS.includes(current) && META_PREFIX_LABEL_REGEX.test(next)) {
      return true;
    }
  }
  return false;
};
const hasValidMetaPrefix = (key) => {
  const prefixSegment = getPrefixSegment(key);
  if (prefixSegment === null) {
    return true;
  }
  return splitLabels(prefixSegment) !== null;
};
const extractMetaName = (key) => {
  const trimmedKey = key.trim();
  if (!trimmedKey) return "";
  const slashIndex = trimmedKey.lastIndexOf("/");
  if (slashIndex === -1) {
    return trimmedKey;
  }
  return trimmedKey.slice(slashIndex + 1);
};
const hasValidMetaName = (key) => {
  const name2 = extractMetaName(key);
  if (!name2) return false;
  return META_NAME_REGEX.test(name2);
};
var util$3;
(function(util2) {
  util2.assertEqual = (_2) => {
  };
  function assertIs(_arg) {
  }
  util2.assertIs = assertIs;
  function assertNever(_x) {
    throw new Error();
  }
  util2.assertNever = assertNever;
  util2.arrayToEnum = (items2) => {
    const obj = {};
    for (const item of items2) {
      obj[item] = item;
    }
    return obj;
  };
  util2.getValidEnumValues = (obj) => {
    const validKeys = util2.objectKeys(obj).filter((k2) => typeof obj[obj[k2]] !== "number");
    const filtered = {};
    for (const k2 of validKeys) {
      filtered[k2] = obj[k2];
    }
    return util2.objectValues(filtered);
  };
  util2.objectValues = (obj) => {
    return util2.objectKeys(obj).map(function(e) {
      return obj[e];
    });
  };
  util2.objectKeys = typeof Object.keys === "function" ? (obj) => Object.keys(obj) : (object2) => {
    const keys = [];
    for (const key in object2) {
      if (Object.prototype.hasOwnProperty.call(object2, key)) {
        keys.push(key);
      }
    }
    return keys;
  };
  util2.find = (arr, checker) => {
    for (const item of arr) {
      if (checker(item))
        return item;
    }
    return void 0;
  };
  util2.isInteger = typeof Number.isInteger === "function" ? (val) => Number.isInteger(val) : (val) => typeof val === "number" && Number.isFinite(val) && Math.floor(val) === val;
  function joinValues(array2, separator = " | ") {
    return array2.map((val) => typeof val === "string" ? `'${val}'` : val).join(separator);
  }
  util2.joinValues = joinValues;
  util2.jsonStringifyReplacer = (_2, value) => {
    if (typeof value === "bigint") {
      return value.toString();
    }
    return value;
  };
})(util$3 || (util$3 = {}));
var objectUtil;
(function(objectUtil2) {
  objectUtil2.mergeShapes = (first, second) => {
    return {
      ...first,
      ...second
      // second overwrites first
    };
  };
})(objectUtil || (objectUtil = {}));
const ZodParsedType = util$3.arrayToEnum([
  "string",
  "nan",
  "number",
  "integer",
  "float",
  "boolean",
  "date",
  "bigint",
  "symbol",
  "function",
  "undefined",
  "null",
  "array",
  "object",
  "unknown",
  "promise",
  "void",
  "never",
  "map",
  "set"
]);
const getParsedType = (data2) => {
  const t = typeof data2;
  switch (t) {
    case "undefined":
      return ZodParsedType.undefined;
    case "string":
      return ZodParsedType.string;
    case "number":
      return Number.isNaN(data2) ? ZodParsedType.nan : ZodParsedType.number;
    case "boolean":
      return ZodParsedType.boolean;
    case "function":
      return ZodParsedType.function;
    case "bigint":
      return ZodParsedType.bigint;
    case "symbol":
      return ZodParsedType.symbol;
    case "object":
      if (Array.isArray(data2)) {
        return ZodParsedType.array;
      }
      if (data2 === null) {
        return ZodParsedType.null;
      }
      if (data2.then && typeof data2.then === "function" && data2.catch && typeof data2.catch === "function") {
        return ZodParsedType.promise;
      }
      if (typeof Map !== "undefined" && data2 instanceof Map) {
        return ZodParsedType.map;
      }
      if (typeof Set !== "undefined" && data2 instanceof Set) {
        return ZodParsedType.set;
      }
      if (typeof Date !== "undefined" && data2 instanceof Date) {
        return ZodParsedType.date;
      }
      return ZodParsedType.object;
    default:
      return ZodParsedType.unknown;
  }
};
const ZodIssueCode = util$3.arrayToEnum([
  "invalid_type",
  "invalid_literal",
  "custom",
  "invalid_union",
  "invalid_union_discriminator",
  "invalid_enum_value",
  "unrecognized_keys",
  "invalid_arguments",
  "invalid_return_type",
  "invalid_date",
  "invalid_string",
  "too_small",
  "too_big",
  "invalid_intersection_types",
  "not_multiple_of",
  "not_finite"
]);
class ZodError extends Error {
  get errors() {
    return this.issues;
  }
  constructor(issues) {
    super();
    this.issues = [];
    this.addIssue = (sub) => {
      this.issues = [...this.issues, sub];
    };
    this.addIssues = (subs = []) => {
      this.issues = [...this.issues, ...subs];
    };
    const actualProto = new.target.prototype;
    if (Object.setPrototypeOf) {
      Object.setPrototypeOf(this, actualProto);
    } else {
      this.__proto__ = actualProto;
    }
    this.name = "ZodError";
    this.issues = issues;
  }
  format(_mapper) {
    const mapper = _mapper || function(issue2) {
      return issue2.message;
    };
    const fieldErrors = { _errors: [] };
    const processError = (error) => {
      for (const issue2 of error.issues) {
        if (issue2.code === "invalid_union") {
          issue2.unionErrors.map(processError);
        } else if (issue2.code === "invalid_return_type") {
          processError(issue2.returnTypeError);
        } else if (issue2.code === "invalid_arguments") {
          processError(issue2.argumentsError);
        } else if (issue2.path.length === 0) {
          fieldErrors._errors.push(mapper(issue2));
        } else {
          let curr = fieldErrors;
          let i = 0;
          while (i < issue2.path.length) {
            const el2 = issue2.path[i];
            const terminal = i === issue2.path.length - 1;
            if (!terminal) {
              curr[el2] = curr[el2] || { _errors: [] };
            } else {
              curr[el2] = curr[el2] || { _errors: [] };
              curr[el2]._errors.push(mapper(issue2));
            }
            curr = curr[el2];
            i++;
          }
        }
      }
    };
    processError(this);
    return fieldErrors;
  }
  static assert(value) {
    if (!(value instanceof ZodError)) {
      throw new Error(`Not a ZodError: ${value}`);
    }
  }
  toString() {
    return this.message;
  }
  get message() {
    return JSON.stringify(this.issues, util$3.jsonStringifyReplacer, 2);
  }
  get isEmpty() {
    return this.issues.length === 0;
  }
  flatten(mapper = (issue2) => issue2.message) {
    const fieldErrors = {};
    const formErrors = [];
    for (const sub of this.issues) {
      if (sub.path.length > 0) {
        const firstEl = sub.path[0];
        fieldErrors[firstEl] = fieldErrors[firstEl] || [];
        fieldErrors[firstEl].push(mapper(sub));
      } else {
        formErrors.push(mapper(sub));
      }
    }
    return { formErrors, fieldErrors };
  }
  get formErrors() {
    return this.flatten();
  }
}
ZodError.create = (issues) => {
  const error = new ZodError(issues);
  return error;
};
const errorMap = (issue2, _ctx) => {
  let message;
  switch (issue2.code) {
    case ZodIssueCode.invalid_type:
      if (issue2.received === ZodParsedType.undefined) {
        message = "Required";
      } else {
        message = `Expected ${issue2.expected}, received ${issue2.received}`;
      }
      break;
    case ZodIssueCode.invalid_literal:
      message = `Invalid literal value, expected ${JSON.stringify(issue2.expected, util$3.jsonStringifyReplacer)}`;
      break;
    case ZodIssueCode.unrecognized_keys:
      message = `Unrecognized key(s) in object: ${util$3.joinValues(issue2.keys, ", ")}`;
      break;
    case ZodIssueCode.invalid_union:
      message = `Invalid input`;
      break;
    case ZodIssueCode.invalid_union_discriminator:
      message = `Invalid discriminator value. Expected ${util$3.joinValues(issue2.options)}`;
      break;
    case ZodIssueCode.invalid_enum_value:
      message = `Invalid enum value. Expected ${util$3.joinValues(issue2.options)}, received '${issue2.received}'`;
      break;
    case ZodIssueCode.invalid_arguments:
      message = `Invalid function arguments`;
      break;
    case ZodIssueCode.invalid_return_type:
      message = `Invalid function return type`;
      break;
    case ZodIssueCode.invalid_date:
      message = `Invalid date`;
      break;
    case ZodIssueCode.invalid_string:
      if (typeof issue2.validation === "object") {
        if ("includes" in issue2.validation) {
          message = `Invalid input: must include "${issue2.validation.includes}"`;
          if (typeof issue2.validation.position === "number") {
            message = `${message} at one or more positions greater than or equal to ${issue2.validation.position}`;
          }
        } else if ("startsWith" in issue2.validation) {
          message = `Invalid input: must start with "${issue2.validation.startsWith}"`;
        } else if ("endsWith" in issue2.validation) {
          message = `Invalid input: must end with "${issue2.validation.endsWith}"`;
        } else {
          util$3.assertNever(issue2.validation);
        }
      } else if (issue2.validation !== "regex") {
        message = `Invalid ${issue2.validation}`;
      } else {
        message = "Invalid";
      }
      break;
    case ZodIssueCode.too_small:
      if (issue2.type === "array")
        message = `Array must contain ${issue2.exact ? "exactly" : issue2.inclusive ? `at least` : `more than`} ${issue2.minimum} element(s)`;
      else if (issue2.type === "string")
        message = `String must contain ${issue2.exact ? "exactly" : issue2.inclusive ? `at least` : `over`} ${issue2.minimum} character(s)`;
      else if (issue2.type === "number")
        message = `Number must be ${issue2.exact ? `exactly equal to ` : issue2.inclusive ? `greater than or equal to ` : `greater than `}${issue2.minimum}`;
      else if (issue2.type === "bigint")
        message = `Number must be ${issue2.exact ? `exactly equal to ` : issue2.inclusive ? `greater than or equal to ` : `greater than `}${issue2.minimum}`;
      else if (issue2.type === "date")
        message = `Date must be ${issue2.exact ? `exactly equal to ` : issue2.inclusive ? `greater than or equal to ` : `greater than `}${new Date(Number(issue2.minimum))}`;
      else
        message = "Invalid input";
      break;
    case ZodIssueCode.too_big:
      if (issue2.type === "array")
        message = `Array must contain ${issue2.exact ? `exactly` : issue2.inclusive ? `at most` : `less than`} ${issue2.maximum} element(s)`;
      else if (issue2.type === "string")
        message = `String must contain ${issue2.exact ? `exactly` : issue2.inclusive ? `at most` : `under`} ${issue2.maximum} character(s)`;
      else if (issue2.type === "number")
        message = `Number must be ${issue2.exact ? `exactly` : issue2.inclusive ? `less than or equal to` : `less than`} ${issue2.maximum}`;
      else if (issue2.type === "bigint")
        message = `BigInt must be ${issue2.exact ? `exactly` : issue2.inclusive ? `less than or equal to` : `less than`} ${issue2.maximum}`;
      else if (issue2.type === "date")
        message = `Date must be ${issue2.exact ? `exactly` : issue2.inclusive ? `smaller than or equal to` : `smaller than`} ${new Date(Number(issue2.maximum))}`;
      else
        message = "Invalid input";
      break;
    case ZodIssueCode.custom:
      message = `Invalid input`;
      break;
    case ZodIssueCode.invalid_intersection_types:
      message = `Intersection results could not be merged`;
      break;
    case ZodIssueCode.not_multiple_of:
      message = `Number must be a multiple of ${issue2.multipleOf}`;
      break;
    case ZodIssueCode.not_finite:
      message = "Number must be finite";
      break;
    default:
      message = _ctx.defaultError;
      util$3.assertNever(issue2);
  }
  return { message };
};
let overrideErrorMap = errorMap;
function getErrorMap() {
  return overrideErrorMap;
}
const makeIssue = (params) => {
  const { data: data2, path, errorMaps, issueData } = params;
  const fullPath = [...path, ...issueData.path || []];
  const fullIssue = {
    ...issueData,
    path: fullPath
  };
  if (issueData.message !== void 0) {
    return {
      ...issueData,
      path: fullPath,
      message: issueData.message
    };
  }
  let errorMessage = "";
  const maps = errorMaps.filter((m2) => !!m2).slice().reverse();
  for (const map of maps) {
    errorMessage = map(fullIssue, { data: data2, defaultError: errorMessage }).message;
  }
  return {
    ...issueData,
    path: fullPath,
    message: errorMessage
  };
};
function addIssueToContext(ctx, issueData) {
  const overrideMap = getErrorMap();
  const issue2 = makeIssue({
    issueData,
    data: ctx.data,
    path: ctx.path,
    errorMaps: [
      ctx.common.contextualErrorMap,
      // contextual error map is first priority
      ctx.schemaErrorMap,
      // then schema-bound map if available
      overrideMap,
      // then global override map
      overrideMap === errorMap ? void 0 : errorMap
      // then global default map
    ].filter((x2) => !!x2)
  });
  ctx.common.issues.push(issue2);
}
class ParseStatus {
  constructor() {
    this.value = "valid";
  }
  dirty() {
    if (this.value === "valid")
      this.value = "dirty";
  }
  abort() {
    if (this.value !== "aborted")
      this.value = "aborted";
  }
  static mergeArray(status, results) {
    const arrayValue = [];
    for (const s2 of results) {
      if (s2.status === "aborted")
        return INVALID;
      if (s2.status === "dirty")
        status.dirty();
      arrayValue.push(s2.value);
    }
    return { status: status.value, value: arrayValue };
  }
  static async mergeObjectAsync(status, pairs) {
    const syncPairs = [];
    for (const pair of pairs) {
      const key = await pair.key;
      const value = await pair.value;
      syncPairs.push({
        key,
        value
      });
    }
    return ParseStatus.mergeObjectSync(status, syncPairs);
  }
  static mergeObjectSync(status, pairs) {
    const finalObject = {};
    for (const pair of pairs) {
      const { key, value } = pair;
      if (key.status === "aborted")
        return INVALID;
      if (value.status === "aborted")
        return INVALID;
      if (key.status === "dirty")
        status.dirty();
      if (value.status === "dirty")
        status.dirty();
      if (key.value !== "__proto__" && (typeof value.value !== "undefined" || pair.alwaysSet)) {
        finalObject[key.value] = value.value;
      }
    }
    return { status: status.value, value: finalObject };
  }
}
const INVALID = Object.freeze({
  status: "aborted"
});
const DIRTY = (value) => ({ status: "dirty", value });
const OK = (value) => ({ status: "valid", value });
const isAborted = (x2) => x2.status === "aborted";
const isDirty = (x2) => x2.status === "dirty";
const isValid = (x2) => x2.status === "valid";
const isAsync = (x2) => typeof Promise !== "undefined" && x2 instanceof Promise;
var errorUtil;
(function(errorUtil2) {
  errorUtil2.errToObj = (message) => typeof message === "string" ? { message } : message || {};
  errorUtil2.toString = (message) => typeof message === "string" ? message : message?.message;
})(errorUtil || (errorUtil = {}));
class ParseInputLazyPath {
  constructor(parent, value, path, key) {
    this._cachedPath = [];
    this.parent = parent;
    this.data = value;
    this._path = path;
    this._key = key;
  }
  get path() {
    if (!this._cachedPath.length) {
      if (Array.isArray(this._key)) {
        this._cachedPath.push(...this._path, ...this._key);
      } else {
        this._cachedPath.push(...this._path, this._key);
      }
    }
    return this._cachedPath;
  }
}
const handleResult = (ctx, result) => {
  if (isValid(result)) {
    return { success: true, data: result.value };
  } else {
    if (!ctx.common.issues.length) {
      throw new Error("Validation failed but no issues detected.");
    }
    return {
      success: false,
      get error() {
        if (this._error)
          return this._error;
        const error = new ZodError(ctx.common.issues);
        this._error = error;
        return this._error;
      }
    };
  }
};
function processCreateParams(params) {
  if (!params)
    return {};
  const { errorMap: errorMap2, invalid_type_error, required_error, description: description2 } = params;
  if (errorMap2 && (invalid_type_error || required_error)) {
    throw new Error(`Can't use "invalid_type_error" or "required_error" in conjunction with custom error map.`);
  }
  if (errorMap2)
    return { errorMap: errorMap2, description: description2 };
  const customMap = (iss, ctx) => {
    const { message } = params;
    if (iss.code === "invalid_enum_value") {
      return { message: message ?? ctx.defaultError };
    }
    if (typeof ctx.data === "undefined") {
      return { message: message ?? required_error ?? ctx.defaultError };
    }
    if (iss.code !== "invalid_type")
      return { message: ctx.defaultError };
    return { message: message ?? invalid_type_error ?? ctx.defaultError };
  };
  return { errorMap: customMap, description: description2 };
}
class ZodType {
  get description() {
    return this._def.description;
  }
  _getType(input) {
    return getParsedType(input.data);
  }
  _getOrReturnCtx(input, ctx) {
    return ctx || {
      common: input.parent.common,
      data: input.data,
      parsedType: getParsedType(input.data),
      schemaErrorMap: this._def.errorMap,
      path: input.path,
      parent: input.parent
    };
  }
  _processInputParams(input) {
    return {
      status: new ParseStatus(),
      ctx: {
        common: input.parent.common,
        data: input.data,
        parsedType: getParsedType(input.data),
        schemaErrorMap: this._def.errorMap,
        path: input.path,
        parent: input.parent
      }
    };
  }
  _parseSync(input) {
    const result = this._parse(input);
    if (isAsync(result)) {
      throw new Error("Synchronous parse encountered promise.");
    }
    return result;
  }
  _parseAsync(input) {
    const result = this._parse(input);
    return Promise.resolve(result);
  }
  parse(data2, params) {
    const result = this.safeParse(data2, params);
    if (result.success)
      return result.data;
    throw result.error;
  }
  safeParse(data2, params) {
    const ctx = {
      common: {
        issues: [],
        async: params?.async ?? false,
        contextualErrorMap: params?.errorMap
      },
      path: params?.path || [],
      schemaErrorMap: this._def.errorMap,
      parent: null,
      data: data2,
      parsedType: getParsedType(data2)
    };
    const result = this._parseSync({ data: data2, path: ctx.path, parent: ctx });
    return handleResult(ctx, result);
  }
  "~validate"(data2) {
    const ctx = {
      common: {
        issues: [],
        async: !!this["~standard"].async
      },
      path: [],
      schemaErrorMap: this._def.errorMap,
      parent: null,
      data: data2,
      parsedType: getParsedType(data2)
    };
    if (!this["~standard"].async) {
      try {
        const result = this._parseSync({ data: data2, path: [], parent: ctx });
        return isValid(result) ? {
          value: result.value
        } : {
          issues: ctx.common.issues
        };
      } catch (err) {
        if (err?.message?.toLowerCase()?.includes("encountered")) {
          this["~standard"].async = true;
        }
        ctx.common = {
          issues: [],
          async: true
        };
      }
    }
    return this._parseAsync({ data: data2, path: [], parent: ctx }).then((result) => isValid(result) ? {
      value: result.value
    } : {
      issues: ctx.common.issues
    });
  }
  async parseAsync(data2, params) {
    const result = await this.safeParseAsync(data2, params);
    if (result.success)
      return result.data;
    throw result.error;
  }
  async safeParseAsync(data2, params) {
    const ctx = {
      common: {
        issues: [],
        contextualErrorMap: params?.errorMap,
        async: true
      },
      path: params?.path || [],
      schemaErrorMap: this._def.errorMap,
      parent: null,
      data: data2,
      parsedType: getParsedType(data2)
    };
    const maybeAsyncResult = this._parse({ data: data2, path: ctx.path, parent: ctx });
    const result = await (isAsync(maybeAsyncResult) ? maybeAsyncResult : Promise.resolve(maybeAsyncResult));
    return handleResult(ctx, result);
  }
  refine(check2, message) {
    const getIssueProperties = (val) => {
      if (typeof message === "string" || typeof message === "undefined") {
        return { message };
      } else if (typeof message === "function") {
        return message(val);
      } else {
        return message;
      }
    };
    return this._refinement((val, ctx) => {
      const result = check2(val);
      const setError = () => ctx.addIssue({
        code: ZodIssueCode.custom,
        ...getIssueProperties(val)
      });
      if (typeof Promise !== "undefined" && result instanceof Promise) {
        return result.then((data2) => {
          if (!data2) {
            setError();
            return false;
          } else {
            return true;
          }
        });
      }
      if (!result) {
        setError();
        return false;
      } else {
        return true;
      }
    });
  }
  refinement(check2, refinementData) {
    return this._refinement((val, ctx) => {
      if (!check2(val)) {
        ctx.addIssue(typeof refinementData === "function" ? refinementData(val, ctx) : refinementData);
        return false;
      } else {
        return true;
      }
    });
  }
  _refinement(refinement) {
    return new ZodEffects({
      schema: this,
      typeName: ZodFirstPartyTypeKind.ZodEffects,
      effect: { type: "refinement", refinement }
    });
  }
  superRefine(refinement) {
    return this._refinement(refinement);
  }
  constructor(def) {
    this.spa = this.safeParseAsync;
    this._def = def;
    this.parse = this.parse.bind(this);
    this.safeParse = this.safeParse.bind(this);
    this.parseAsync = this.parseAsync.bind(this);
    this.safeParseAsync = this.safeParseAsync.bind(this);
    this.spa = this.spa.bind(this);
    this.refine = this.refine.bind(this);
    this.refinement = this.refinement.bind(this);
    this.superRefine = this.superRefine.bind(this);
    this.optional = this.optional.bind(this);
    this.nullable = this.nullable.bind(this);
    this.nullish = this.nullish.bind(this);
    this.array = this.array.bind(this);
    this.promise = this.promise.bind(this);
    this.or = this.or.bind(this);
    this.and = this.and.bind(this);
    this.transform = this.transform.bind(this);
    this.brand = this.brand.bind(this);
    this.default = this.default.bind(this);
    this.catch = this.catch.bind(this);
    this.describe = this.describe.bind(this);
    this.pipe = this.pipe.bind(this);
    this.readonly = this.readonly.bind(this);
    this.isNullable = this.isNullable.bind(this);
    this.isOptional = this.isOptional.bind(this);
    this["~standard"] = {
      version: 1,
      vendor: "zod",
      validate: (data2) => this["~validate"](data2)
    };
  }
  optional() {
    return ZodOptional.create(this, this._def);
  }
  nullable() {
    return ZodNullable.create(this, this._def);
  }
  nullish() {
    return this.nullable().optional();
  }
  array() {
    return ZodArray.create(this);
  }
  promise() {
    return ZodPromise.create(this, this._def);
  }
  or(option) {
    return ZodUnion.create([this, option], this._def);
  }
  and(incoming) {
    return ZodIntersection.create(this, incoming, this._def);
  }
  transform(transform2) {
    return new ZodEffects({
      ...processCreateParams(this._def),
      schema: this,
      typeName: ZodFirstPartyTypeKind.ZodEffects,
      effect: { type: "transform", transform: transform2 }
    });
  }
  default(def) {
    const defaultValueFunc = typeof def === "function" ? def : () => def;
    return new ZodDefault({
      ...processCreateParams(this._def),
      innerType: this,
      defaultValue: defaultValueFunc,
      typeName: ZodFirstPartyTypeKind.ZodDefault
    });
  }
  brand() {
    return new ZodBranded({
      typeName: ZodFirstPartyTypeKind.ZodBranded,
      type: this,
      ...processCreateParams(this._def)
    });
  }
  catch(def) {
    const catchValueFunc = typeof def === "function" ? def : () => def;
    return new ZodCatch({
      ...processCreateParams(this._def),
      innerType: this,
      catchValue: catchValueFunc,
      typeName: ZodFirstPartyTypeKind.ZodCatch
    });
  }
  describe(description2) {
    const This = this.constructor;
    return new This({
      ...this._def,
      description: description2
    });
  }
  pipe(target) {
    return ZodPipeline.create(this, target);
  }
  readonly() {
    return ZodReadonly.create(this);
  }
  isOptional() {
    return this.safeParse(void 0).success;
  }
  isNullable() {
    return this.safeParse(null).success;
  }
}
const cuidRegex = /^c[^\s-]{8,}$/i;
const cuid2Regex = /^[0-9a-z]+$/;
const ulidRegex = /^[0-9A-HJKMNP-TV-Z]{26}$/i;
const uuidRegex = /^[0-9a-fA-F]{8}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{4}\b-[0-9a-fA-F]{12}$/i;
const nanoidRegex = /^[a-z0-9_-]{21}$/i;
const jwtRegex = /^[A-Za-z0-9-_]+\.[A-Za-z0-9-_]+\.[A-Za-z0-9-_]*$/;
const durationRegex = /^[-+]?P(?!$)(?:(?:[-+]?\d+Y)|(?:[-+]?\d+[.,]\d+Y$))?(?:(?:[-+]?\d+M)|(?:[-+]?\d+[.,]\d+M$))?(?:(?:[-+]?\d+W)|(?:[-+]?\d+[.,]\d+W$))?(?:(?:[-+]?\d+D)|(?:[-+]?\d+[.,]\d+D$))?(?:T(?=[\d+-])(?:(?:[-+]?\d+H)|(?:[-+]?\d+[.,]\d+H$))?(?:(?:[-+]?\d+M)|(?:[-+]?\d+[.,]\d+M$))?(?:[-+]?\d+(?:[.,]\d+)?S)?)??$/;
const emailRegex = /^(?!\.)(?!.*\.\.)([A-Z0-9_'+\-\.]*)[A-Z0-9_+-]@([A-Z0-9][A-Z0-9\-]*\.)+[A-Z]{2,}$/i;
const _emojiRegex = `^(\\p{Extended_Pictographic}|\\p{Emoji_Component})+$`;
let emojiRegex;
const ipv4Regex = /^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/;
const ipv4CidrRegex = /^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\/(3[0-2]|[12]?[0-9])$/;
const ipv6Regex = /^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))$/;
const ipv6CidrRegex = /^(([0-9a-fA-F]{1,4}:){7,7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]{1,}|::(ffff(:0{1,4}){0,1}:){0,1}((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9])\.){3,3}(25[0-5]|(2[0-4]|1{0,1}[0-9]){0,1}[0-9]))\/(12[0-8]|1[01][0-9]|[1-9]?[0-9])$/;
const base64Regex = /^([0-9a-zA-Z+/]{4})*(([0-9a-zA-Z+/]{2}==)|([0-9a-zA-Z+/]{3}=))?$/;
const base64urlRegex = /^([0-9a-zA-Z-_]{4})*(([0-9a-zA-Z-_]{2}(==)?)|([0-9a-zA-Z-_]{3}(=)?))?$/;
const dateRegexSource = `((\\d\\d[2468][048]|\\d\\d[13579][26]|\\d\\d0[48]|[02468][048]00|[13579][26]00)-02-29|\\d{4}-((0[13578]|1[02])-(0[1-9]|[12]\\d|3[01])|(0[469]|11)-(0[1-9]|[12]\\d|30)|(02)-(0[1-9]|1\\d|2[0-8])))`;
const dateRegex = new RegExp(`^${dateRegexSource}$`);
function timeRegexSource(args) {
  let secondsRegexSource = `[0-5]\\d`;
  if (args.precision) {
    secondsRegexSource = `${secondsRegexSource}\\.\\d{${args.precision}}`;
  } else if (args.precision == null) {
    secondsRegexSource = `${secondsRegexSource}(\\.\\d+)?`;
  }
  const secondsQuantifier = args.precision ? "+" : "?";
  return `([01]\\d|2[0-3]):[0-5]\\d(:${secondsRegexSource})${secondsQuantifier}`;
}
function timeRegex(args) {
  return new RegExp(`^${timeRegexSource(args)}$`);
}
function datetimeRegex(args) {
  let regex = `${dateRegexSource}T${timeRegexSource(args)}`;
  const opts = [];
  opts.push(args.local ? `Z?` : `Z`);
  if (args.offset)
    opts.push(`([+-]\\d{2}:?\\d{2})`);
  regex = `${regex}(${opts.join("|")})`;
  return new RegExp(`^${regex}$`);
}
function isValidIP(ip2, version2) {
  if ((version2 === "v4" || !version2) && ipv4Regex.test(ip2)) {
    return true;
  }
  if ((version2 === "v6" || !version2) && ipv6Regex.test(ip2)) {
    return true;
  }
  return false;
}
function isValidJWT(jwt, alg) {
  if (!jwtRegex.test(jwt))
    return false;
  try {
    const [header] = jwt.split(".");
    if (!header)
      return false;
    const base642 = header.replace(/-/g, "+").replace(/_/g, "/").padEnd(header.length + (4 - header.length % 4) % 4, "=");
    const decoded = JSON.parse(atob(base642));
    if (typeof decoded !== "object" || decoded === null)
      return false;
    if ("typ" in decoded && decoded?.typ !== "JWT")
      return false;
    if (!decoded.alg)
      return false;
    if (alg && decoded.alg !== alg)
      return false;
    return true;
  } catch {
    return false;
  }
}
function isValidCidr(ip2, version2) {
  if ((version2 === "v4" || !version2) && ipv4CidrRegex.test(ip2)) {
    return true;
  }
  if ((version2 === "v6" || !version2) && ipv6CidrRegex.test(ip2)) {
    return true;
  }
  return false;
}
class ZodString extends ZodType {
  _parse(input) {
    if (this._def.coerce) {
      input.data = String(input.data);
    }
    const parsedType = this._getType(input);
    if (parsedType !== ZodParsedType.string) {
      const ctx2 = this._getOrReturnCtx(input);
      addIssueToContext(ctx2, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.string,
        received: ctx2.parsedType
      });
      return INVALID;
    }
    const status = new ParseStatus();
    let ctx = void 0;
    for (const check2 of this._def.checks) {
      if (check2.kind === "min") {
        if (input.data.length < check2.value) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_small,
            minimum: check2.value,
            type: "string",
            inclusive: true,
            exact: false,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "max") {
        if (input.data.length > check2.value) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_big,
            maximum: check2.value,
            type: "string",
            inclusive: true,
            exact: false,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "length") {
        const tooBig = input.data.length > check2.value;
        const tooSmall = input.data.length < check2.value;
        if (tooBig || tooSmall) {
          ctx = this._getOrReturnCtx(input, ctx);
          if (tooBig) {
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_big,
              maximum: check2.value,
              type: "string",
              inclusive: true,
              exact: true,
              message: check2.message
            });
          } else if (tooSmall) {
            addIssueToContext(ctx, {
              code: ZodIssueCode.too_small,
              minimum: check2.value,
              type: "string",
              inclusive: true,
              exact: true,
              message: check2.message
            });
          }
          status.dirty();
        }
      } else if (check2.kind === "email") {
        if (!emailRegex.test(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "email",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "emoji") {
        if (!emojiRegex) {
          emojiRegex = new RegExp(_emojiRegex, "u");
        }
        if (!emojiRegex.test(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "emoji",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "uuid") {
        if (!uuidRegex.test(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "uuid",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "nanoid") {
        if (!nanoidRegex.test(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "nanoid",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "cuid") {
        if (!cuidRegex.test(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "cuid",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "cuid2") {
        if (!cuid2Regex.test(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "cuid2",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "ulid") {
        if (!ulidRegex.test(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "ulid",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "url") {
        try {
          new URL(input.data);
        } catch {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "url",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "regex") {
        check2.regex.lastIndex = 0;
        const testResult = check2.regex.test(input.data);
        if (!testResult) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "regex",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "trim") {
        input.data = input.data.trim();
      } else if (check2.kind === "includes") {
        if (!input.data.includes(check2.value, check2.position)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_string,
            validation: { includes: check2.value, position: check2.position },
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "toLowerCase") {
        input.data = input.data.toLowerCase();
      } else if (check2.kind === "toUpperCase") {
        input.data = input.data.toUpperCase();
      } else if (check2.kind === "startsWith") {
        if (!input.data.startsWith(check2.value)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_string,
            validation: { startsWith: check2.value },
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "endsWith") {
        if (!input.data.endsWith(check2.value)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_string,
            validation: { endsWith: check2.value },
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "datetime") {
        const regex = datetimeRegex(check2);
        if (!regex.test(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_string,
            validation: "datetime",
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "date") {
        const regex = dateRegex;
        if (!regex.test(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_string,
            validation: "date",
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "time") {
        const regex = timeRegex(check2);
        if (!regex.test(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_string,
            validation: "time",
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "duration") {
        if (!durationRegex.test(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "duration",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "ip") {
        if (!isValidIP(input.data, check2.version)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "ip",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "jwt") {
        if (!isValidJWT(input.data, check2.alg)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "jwt",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "cidr") {
        if (!isValidCidr(input.data, check2.version)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "cidr",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "base64") {
        if (!base64Regex.test(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "base64",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "base64url") {
        if (!base64urlRegex.test(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            validation: "base64url",
            code: ZodIssueCode.invalid_string,
            message: check2.message
          });
          status.dirty();
        }
      } else {
        util$3.assertNever(check2);
      }
    }
    return { status: status.value, value: input.data };
  }
  _regex(regex, validation2, message) {
    return this.refinement((data2) => regex.test(data2), {
      validation: validation2,
      code: ZodIssueCode.invalid_string,
      ...errorUtil.errToObj(message)
    });
  }
  _addCheck(check2) {
    return new ZodString({
      ...this._def,
      checks: [...this._def.checks, check2]
    });
  }
  email(message) {
    return this._addCheck({ kind: "email", ...errorUtil.errToObj(message) });
  }
  url(message) {
    return this._addCheck({ kind: "url", ...errorUtil.errToObj(message) });
  }
  emoji(message) {
    return this._addCheck({ kind: "emoji", ...errorUtil.errToObj(message) });
  }
  uuid(message) {
    return this._addCheck({ kind: "uuid", ...errorUtil.errToObj(message) });
  }
  nanoid(message) {
    return this._addCheck({ kind: "nanoid", ...errorUtil.errToObj(message) });
  }
  cuid(message) {
    return this._addCheck({ kind: "cuid", ...errorUtil.errToObj(message) });
  }
  cuid2(message) {
    return this._addCheck({ kind: "cuid2", ...errorUtil.errToObj(message) });
  }
  ulid(message) {
    return this._addCheck({ kind: "ulid", ...errorUtil.errToObj(message) });
  }
  base64(message) {
    return this._addCheck({ kind: "base64", ...errorUtil.errToObj(message) });
  }
  base64url(message) {
    return this._addCheck({
      kind: "base64url",
      ...errorUtil.errToObj(message)
    });
  }
  jwt(options) {
    return this._addCheck({ kind: "jwt", ...errorUtil.errToObj(options) });
  }
  ip(options) {
    return this._addCheck({ kind: "ip", ...errorUtil.errToObj(options) });
  }
  cidr(options) {
    return this._addCheck({ kind: "cidr", ...errorUtil.errToObj(options) });
  }
  datetime(options) {
    if (typeof options === "string") {
      return this._addCheck({
        kind: "datetime",
        precision: null,
        offset: false,
        local: false,
        message: options
      });
    }
    return this._addCheck({
      kind: "datetime",
      precision: typeof options?.precision === "undefined" ? null : options?.precision,
      offset: options?.offset ?? false,
      local: options?.local ?? false,
      ...errorUtil.errToObj(options?.message)
    });
  }
  date(message) {
    return this._addCheck({ kind: "date", message });
  }
  time(options) {
    if (typeof options === "string") {
      return this._addCheck({
        kind: "time",
        precision: null,
        message: options
      });
    }
    return this._addCheck({
      kind: "time",
      precision: typeof options?.precision === "undefined" ? null : options?.precision,
      ...errorUtil.errToObj(options?.message)
    });
  }
  duration(message) {
    return this._addCheck({ kind: "duration", ...errorUtil.errToObj(message) });
  }
  regex(regex, message) {
    return this._addCheck({
      kind: "regex",
      regex,
      ...errorUtil.errToObj(message)
    });
  }
  includes(value, options) {
    return this._addCheck({
      kind: "includes",
      value,
      position: options?.position,
      ...errorUtil.errToObj(options?.message)
    });
  }
  startsWith(value, message) {
    return this._addCheck({
      kind: "startsWith",
      value,
      ...errorUtil.errToObj(message)
    });
  }
  endsWith(value, message) {
    return this._addCheck({
      kind: "endsWith",
      value,
      ...errorUtil.errToObj(message)
    });
  }
  min(minLength, message) {
    return this._addCheck({
      kind: "min",
      value: minLength,
      ...errorUtil.errToObj(message)
    });
  }
  max(maxLength, message) {
    return this._addCheck({
      kind: "max",
      value: maxLength,
      ...errorUtil.errToObj(message)
    });
  }
  length(len, message) {
    return this._addCheck({
      kind: "length",
      value: len,
      ...errorUtil.errToObj(message)
    });
  }
  /**
   * Equivalent to `.min(1)`
   */
  nonempty(message) {
    return this.min(1, errorUtil.errToObj(message));
  }
  trim() {
    return new ZodString({
      ...this._def,
      checks: [...this._def.checks, { kind: "trim" }]
    });
  }
  toLowerCase() {
    return new ZodString({
      ...this._def,
      checks: [...this._def.checks, { kind: "toLowerCase" }]
    });
  }
  toUpperCase() {
    return new ZodString({
      ...this._def,
      checks: [...this._def.checks, { kind: "toUpperCase" }]
    });
  }
  get isDatetime() {
    return !!this._def.checks.find((ch2) => ch2.kind === "datetime");
  }
  get isDate() {
    return !!this._def.checks.find((ch2) => ch2.kind === "date");
  }
  get isTime() {
    return !!this._def.checks.find((ch2) => ch2.kind === "time");
  }
  get isDuration() {
    return !!this._def.checks.find((ch2) => ch2.kind === "duration");
  }
  get isEmail() {
    return !!this._def.checks.find((ch2) => ch2.kind === "email");
  }
  get isURL() {
    return !!this._def.checks.find((ch2) => ch2.kind === "url");
  }
  get isEmoji() {
    return !!this._def.checks.find((ch2) => ch2.kind === "emoji");
  }
  get isUUID() {
    return !!this._def.checks.find((ch2) => ch2.kind === "uuid");
  }
  get isNANOID() {
    return !!this._def.checks.find((ch2) => ch2.kind === "nanoid");
  }
  get isCUID() {
    return !!this._def.checks.find((ch2) => ch2.kind === "cuid");
  }
  get isCUID2() {
    return !!this._def.checks.find((ch2) => ch2.kind === "cuid2");
  }
  get isULID() {
    return !!this._def.checks.find((ch2) => ch2.kind === "ulid");
  }
  get isIP() {
    return !!this._def.checks.find((ch2) => ch2.kind === "ip");
  }
  get isCIDR() {
    return !!this._def.checks.find((ch2) => ch2.kind === "cidr");
  }
  get isBase64() {
    return !!this._def.checks.find((ch2) => ch2.kind === "base64");
  }
  get isBase64url() {
    return !!this._def.checks.find((ch2) => ch2.kind === "base64url");
  }
  get minLength() {
    let min2 = null;
    for (const ch2 of this._def.checks) {
      if (ch2.kind === "min") {
        if (min2 === null || ch2.value > min2)
          min2 = ch2.value;
      }
    }
    return min2;
  }
  get maxLength() {
    let max2 = null;
    for (const ch2 of this._def.checks) {
      if (ch2.kind === "max") {
        if (max2 === null || ch2.value < max2)
          max2 = ch2.value;
      }
    }
    return max2;
  }
}
ZodString.create = (params) => {
  return new ZodString({
    checks: [],
    typeName: ZodFirstPartyTypeKind.ZodString,
    coerce: params?.coerce ?? false,
    ...processCreateParams(params)
  });
};
function floatSafeRemainder(val, step) {
  const valDecCount = (val.toString().split(".")[1] || "").length;
  const stepDecCount = (step.toString().split(".")[1] || "").length;
  const decCount = valDecCount > stepDecCount ? valDecCount : stepDecCount;
  const valInt = Number.parseInt(val.toFixed(decCount).replace(".", ""));
  const stepInt = Number.parseInt(step.toFixed(decCount).replace(".", ""));
  return valInt % stepInt / 10 ** decCount;
}
class ZodNumber extends ZodType {
  constructor() {
    super(...arguments);
    this.min = this.gte;
    this.max = this.lte;
    this.step = this.multipleOf;
  }
  _parse(input) {
    if (this._def.coerce) {
      input.data = Number(input.data);
    }
    const parsedType = this._getType(input);
    if (parsedType !== ZodParsedType.number) {
      const ctx2 = this._getOrReturnCtx(input);
      addIssueToContext(ctx2, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.number,
        received: ctx2.parsedType
      });
      return INVALID;
    }
    let ctx = void 0;
    const status = new ParseStatus();
    for (const check2 of this._def.checks) {
      if (check2.kind === "int") {
        if (!util$3.isInteger(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.invalid_type,
            expected: "integer",
            received: "float",
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "min") {
        const tooSmall = check2.inclusive ? input.data < check2.value : input.data <= check2.value;
        if (tooSmall) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_small,
            minimum: check2.value,
            type: "number",
            inclusive: check2.inclusive,
            exact: false,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "max") {
        const tooBig = check2.inclusive ? input.data > check2.value : input.data >= check2.value;
        if (tooBig) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_big,
            maximum: check2.value,
            type: "number",
            inclusive: check2.inclusive,
            exact: false,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "multipleOf") {
        if (floatSafeRemainder(input.data, check2.value) !== 0) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.not_multiple_of,
            multipleOf: check2.value,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "finite") {
        if (!Number.isFinite(input.data)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.not_finite,
            message: check2.message
          });
          status.dirty();
        }
      } else {
        util$3.assertNever(check2);
      }
    }
    return { status: status.value, value: input.data };
  }
  gte(value, message) {
    return this.setLimit("min", value, true, errorUtil.toString(message));
  }
  gt(value, message) {
    return this.setLimit("min", value, false, errorUtil.toString(message));
  }
  lte(value, message) {
    return this.setLimit("max", value, true, errorUtil.toString(message));
  }
  lt(value, message) {
    return this.setLimit("max", value, false, errorUtil.toString(message));
  }
  setLimit(kind, value, inclusive, message) {
    return new ZodNumber({
      ...this._def,
      checks: [
        ...this._def.checks,
        {
          kind,
          value,
          inclusive,
          message: errorUtil.toString(message)
        }
      ]
    });
  }
  _addCheck(check2) {
    return new ZodNumber({
      ...this._def,
      checks: [...this._def.checks, check2]
    });
  }
  int(message) {
    return this._addCheck({
      kind: "int",
      message: errorUtil.toString(message)
    });
  }
  positive(message) {
    return this._addCheck({
      kind: "min",
      value: 0,
      inclusive: false,
      message: errorUtil.toString(message)
    });
  }
  negative(message) {
    return this._addCheck({
      kind: "max",
      value: 0,
      inclusive: false,
      message: errorUtil.toString(message)
    });
  }
  nonpositive(message) {
    return this._addCheck({
      kind: "max",
      value: 0,
      inclusive: true,
      message: errorUtil.toString(message)
    });
  }
  nonnegative(message) {
    return this._addCheck({
      kind: "min",
      value: 0,
      inclusive: true,
      message: errorUtil.toString(message)
    });
  }
  multipleOf(value, message) {
    return this._addCheck({
      kind: "multipleOf",
      value,
      message: errorUtil.toString(message)
    });
  }
  finite(message) {
    return this._addCheck({
      kind: "finite",
      message: errorUtil.toString(message)
    });
  }
  safe(message) {
    return this._addCheck({
      kind: "min",
      inclusive: true,
      value: Number.MIN_SAFE_INTEGER,
      message: errorUtil.toString(message)
    })._addCheck({
      kind: "max",
      inclusive: true,
      value: Number.MAX_SAFE_INTEGER,
      message: errorUtil.toString(message)
    });
  }
  get minValue() {
    let min2 = null;
    for (const ch2 of this._def.checks) {
      if (ch2.kind === "min") {
        if (min2 === null || ch2.value > min2)
          min2 = ch2.value;
      }
    }
    return min2;
  }
  get maxValue() {
    let max2 = null;
    for (const ch2 of this._def.checks) {
      if (ch2.kind === "max") {
        if (max2 === null || ch2.value < max2)
          max2 = ch2.value;
      }
    }
    return max2;
  }
  get isInt() {
    return !!this._def.checks.find((ch2) => ch2.kind === "int" || ch2.kind === "multipleOf" && util$3.isInteger(ch2.value));
  }
  get isFinite() {
    let max2 = null;
    let min2 = null;
    for (const ch2 of this._def.checks) {
      if (ch2.kind === "finite" || ch2.kind === "int" || ch2.kind === "multipleOf") {
        return true;
      } else if (ch2.kind === "min") {
        if (min2 === null || ch2.value > min2)
          min2 = ch2.value;
      } else if (ch2.kind === "max") {
        if (max2 === null || ch2.value < max2)
          max2 = ch2.value;
      }
    }
    return Number.isFinite(min2) && Number.isFinite(max2);
  }
}
ZodNumber.create = (params) => {
  return new ZodNumber({
    checks: [],
    typeName: ZodFirstPartyTypeKind.ZodNumber,
    coerce: params?.coerce || false,
    ...processCreateParams(params)
  });
};
class ZodBigInt extends ZodType {
  constructor() {
    super(...arguments);
    this.min = this.gte;
    this.max = this.lte;
  }
  _parse(input) {
    if (this._def.coerce) {
      try {
        input.data = BigInt(input.data);
      } catch {
        return this._getInvalidInput(input);
      }
    }
    const parsedType = this._getType(input);
    if (parsedType !== ZodParsedType.bigint) {
      return this._getInvalidInput(input);
    }
    let ctx = void 0;
    const status = new ParseStatus();
    for (const check2 of this._def.checks) {
      if (check2.kind === "min") {
        const tooSmall = check2.inclusive ? input.data < check2.value : input.data <= check2.value;
        if (tooSmall) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_small,
            type: "bigint",
            minimum: check2.value,
            inclusive: check2.inclusive,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "max") {
        const tooBig = check2.inclusive ? input.data > check2.value : input.data >= check2.value;
        if (tooBig) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_big,
            type: "bigint",
            maximum: check2.value,
            inclusive: check2.inclusive,
            message: check2.message
          });
          status.dirty();
        }
      } else if (check2.kind === "multipleOf") {
        if (input.data % check2.value !== BigInt(0)) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.not_multiple_of,
            multipleOf: check2.value,
            message: check2.message
          });
          status.dirty();
        }
      } else {
        util$3.assertNever(check2);
      }
    }
    return { status: status.value, value: input.data };
  }
  _getInvalidInput(input) {
    const ctx = this._getOrReturnCtx(input);
    addIssueToContext(ctx, {
      code: ZodIssueCode.invalid_type,
      expected: ZodParsedType.bigint,
      received: ctx.parsedType
    });
    return INVALID;
  }
  gte(value, message) {
    return this.setLimit("min", value, true, errorUtil.toString(message));
  }
  gt(value, message) {
    return this.setLimit("min", value, false, errorUtil.toString(message));
  }
  lte(value, message) {
    return this.setLimit("max", value, true, errorUtil.toString(message));
  }
  lt(value, message) {
    return this.setLimit("max", value, false, errorUtil.toString(message));
  }
  setLimit(kind, value, inclusive, message) {
    return new ZodBigInt({
      ...this._def,
      checks: [
        ...this._def.checks,
        {
          kind,
          value,
          inclusive,
          message: errorUtil.toString(message)
        }
      ]
    });
  }
  _addCheck(check2) {
    return new ZodBigInt({
      ...this._def,
      checks: [...this._def.checks, check2]
    });
  }
  positive(message) {
    return this._addCheck({
      kind: "min",
      value: BigInt(0),
      inclusive: false,
      message: errorUtil.toString(message)
    });
  }
  negative(message) {
    return this._addCheck({
      kind: "max",
      value: BigInt(0),
      inclusive: false,
      message: errorUtil.toString(message)
    });
  }
  nonpositive(message) {
    return this._addCheck({
      kind: "max",
      value: BigInt(0),
      inclusive: true,
      message: errorUtil.toString(message)
    });
  }
  nonnegative(message) {
    return this._addCheck({
      kind: "min",
      value: BigInt(0),
      inclusive: true,
      message: errorUtil.toString(message)
    });
  }
  multipleOf(value, message) {
    return this._addCheck({
      kind: "multipleOf",
      value,
      message: errorUtil.toString(message)
    });
  }
  get minValue() {
    let min2 = null;
    for (const ch2 of this._def.checks) {
      if (ch2.kind === "min") {
        if (min2 === null || ch2.value > min2)
          min2 = ch2.value;
      }
    }
    return min2;
  }
  get maxValue() {
    let max2 = null;
    for (const ch2 of this._def.checks) {
      if (ch2.kind === "max") {
        if (max2 === null || ch2.value < max2)
          max2 = ch2.value;
      }
    }
    return max2;
  }
}
ZodBigInt.create = (params) => {
  return new ZodBigInt({
    checks: [],
    typeName: ZodFirstPartyTypeKind.ZodBigInt,
    coerce: params?.coerce ?? false,
    ...processCreateParams(params)
  });
};
class ZodBoolean extends ZodType {
  _parse(input) {
    if (this._def.coerce) {
      input.data = Boolean(input.data);
    }
    const parsedType = this._getType(input);
    if (parsedType !== ZodParsedType.boolean) {
      const ctx = this._getOrReturnCtx(input);
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.boolean,
        received: ctx.parsedType
      });
      return INVALID;
    }
    return OK(input.data);
  }
}
ZodBoolean.create = (params) => {
  return new ZodBoolean({
    typeName: ZodFirstPartyTypeKind.ZodBoolean,
    coerce: params?.coerce || false,
    ...processCreateParams(params)
  });
};
class ZodDate extends ZodType {
  _parse(input) {
    if (this._def.coerce) {
      input.data = new Date(input.data);
    }
    const parsedType = this._getType(input);
    if (parsedType !== ZodParsedType.date) {
      const ctx2 = this._getOrReturnCtx(input);
      addIssueToContext(ctx2, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.date,
        received: ctx2.parsedType
      });
      return INVALID;
    }
    if (Number.isNaN(input.data.getTime())) {
      const ctx2 = this._getOrReturnCtx(input);
      addIssueToContext(ctx2, {
        code: ZodIssueCode.invalid_date
      });
      return INVALID;
    }
    const status = new ParseStatus();
    let ctx = void 0;
    for (const check2 of this._def.checks) {
      if (check2.kind === "min") {
        if (input.data.getTime() < check2.value) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_small,
            message: check2.message,
            inclusive: true,
            exact: false,
            minimum: check2.value,
            type: "date"
          });
          status.dirty();
        }
      } else if (check2.kind === "max") {
        if (input.data.getTime() > check2.value) {
          ctx = this._getOrReturnCtx(input, ctx);
          addIssueToContext(ctx, {
            code: ZodIssueCode.too_big,
            message: check2.message,
            inclusive: true,
            exact: false,
            maximum: check2.value,
            type: "date"
          });
          status.dirty();
        }
      } else {
        util$3.assertNever(check2);
      }
    }
    return {
      status: status.value,
      value: new Date(input.data.getTime())
    };
  }
  _addCheck(check2) {
    return new ZodDate({
      ...this._def,
      checks: [...this._def.checks, check2]
    });
  }
  min(minDate, message) {
    return this._addCheck({
      kind: "min",
      value: minDate.getTime(),
      message: errorUtil.toString(message)
    });
  }
  max(maxDate, message) {
    return this._addCheck({
      kind: "max",
      value: maxDate.getTime(),
      message: errorUtil.toString(message)
    });
  }
  get minDate() {
    let min2 = null;
    for (const ch2 of this._def.checks) {
      if (ch2.kind === "min") {
        if (min2 === null || ch2.value > min2)
          min2 = ch2.value;
      }
    }
    return min2 != null ? new Date(min2) : null;
  }
  get maxDate() {
    let max2 = null;
    for (const ch2 of this._def.checks) {
      if (ch2.kind === "max") {
        if (max2 === null || ch2.value < max2)
          max2 = ch2.value;
      }
    }
    return max2 != null ? new Date(max2) : null;
  }
}
ZodDate.create = (params) => {
  return new ZodDate({
    checks: [],
    coerce: params?.coerce || false,
    typeName: ZodFirstPartyTypeKind.ZodDate,
    ...processCreateParams(params)
  });
};
class ZodSymbol extends ZodType {
  _parse(input) {
    const parsedType = this._getType(input);
    if (parsedType !== ZodParsedType.symbol) {
      const ctx = this._getOrReturnCtx(input);
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.symbol,
        received: ctx.parsedType
      });
      return INVALID;
    }
    return OK(input.data);
  }
}
ZodSymbol.create = (params) => {
  return new ZodSymbol({
    typeName: ZodFirstPartyTypeKind.ZodSymbol,
    ...processCreateParams(params)
  });
};
class ZodUndefined extends ZodType {
  _parse(input) {
    const parsedType = this._getType(input);
    if (parsedType !== ZodParsedType.undefined) {
      const ctx = this._getOrReturnCtx(input);
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.undefined,
        received: ctx.parsedType
      });
      return INVALID;
    }
    return OK(input.data);
  }
}
ZodUndefined.create = (params) => {
  return new ZodUndefined({
    typeName: ZodFirstPartyTypeKind.ZodUndefined,
    ...processCreateParams(params)
  });
};
class ZodNull extends ZodType {
  _parse(input) {
    const parsedType = this._getType(input);
    if (parsedType !== ZodParsedType.null) {
      const ctx = this._getOrReturnCtx(input);
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.null,
        received: ctx.parsedType
      });
      return INVALID;
    }
    return OK(input.data);
  }
}
ZodNull.create = (params) => {
  return new ZodNull({
    typeName: ZodFirstPartyTypeKind.ZodNull,
    ...processCreateParams(params)
  });
};
class ZodAny extends ZodType {
  constructor() {
    super(...arguments);
    this._any = true;
  }
  _parse(input) {
    return OK(input.data);
  }
}
ZodAny.create = (params) => {
  return new ZodAny({
    typeName: ZodFirstPartyTypeKind.ZodAny,
    ...processCreateParams(params)
  });
};
class ZodUnknown extends ZodType {
  constructor() {
    super(...arguments);
    this._unknown = true;
  }
  _parse(input) {
    return OK(input.data);
  }
}
ZodUnknown.create = (params) => {
  return new ZodUnknown({
    typeName: ZodFirstPartyTypeKind.ZodUnknown,
    ...processCreateParams(params)
  });
};
class ZodNever extends ZodType {
  _parse(input) {
    const ctx = this._getOrReturnCtx(input);
    addIssueToContext(ctx, {
      code: ZodIssueCode.invalid_type,
      expected: ZodParsedType.never,
      received: ctx.parsedType
    });
    return INVALID;
  }
}
ZodNever.create = (params) => {
  return new ZodNever({
    typeName: ZodFirstPartyTypeKind.ZodNever,
    ...processCreateParams(params)
  });
};
class ZodVoid extends ZodType {
  _parse(input) {
    const parsedType = this._getType(input);
    if (parsedType !== ZodParsedType.undefined) {
      const ctx = this._getOrReturnCtx(input);
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.void,
        received: ctx.parsedType
      });
      return INVALID;
    }
    return OK(input.data);
  }
}
ZodVoid.create = (params) => {
  return new ZodVoid({
    typeName: ZodFirstPartyTypeKind.ZodVoid,
    ...processCreateParams(params)
  });
};
class ZodArray extends ZodType {
  _parse(input) {
    const { ctx, status } = this._processInputParams(input);
    const def = this._def;
    if (ctx.parsedType !== ZodParsedType.array) {
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.array,
        received: ctx.parsedType
      });
      return INVALID;
    }
    if (def.exactLength !== null) {
      const tooBig = ctx.data.length > def.exactLength.value;
      const tooSmall = ctx.data.length < def.exactLength.value;
      if (tooBig || tooSmall) {
        addIssueToContext(ctx, {
          code: tooBig ? ZodIssueCode.too_big : ZodIssueCode.too_small,
          minimum: tooSmall ? def.exactLength.value : void 0,
          maximum: tooBig ? def.exactLength.value : void 0,
          type: "array",
          inclusive: true,
          exact: true,
          message: def.exactLength.message
        });
        status.dirty();
      }
    }
    if (def.minLength !== null) {
      if (ctx.data.length < def.minLength.value) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.too_small,
          minimum: def.minLength.value,
          type: "array",
          inclusive: true,
          exact: false,
          message: def.minLength.message
        });
        status.dirty();
      }
    }
    if (def.maxLength !== null) {
      if (ctx.data.length > def.maxLength.value) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.too_big,
          maximum: def.maxLength.value,
          type: "array",
          inclusive: true,
          exact: false,
          message: def.maxLength.message
        });
        status.dirty();
      }
    }
    if (ctx.common.async) {
      return Promise.all([...ctx.data].map((item, i) => {
        return def.type._parseAsync(new ParseInputLazyPath(ctx, item, ctx.path, i));
      })).then((result2) => {
        return ParseStatus.mergeArray(status, result2);
      });
    }
    const result = [...ctx.data].map((item, i) => {
      return def.type._parseSync(new ParseInputLazyPath(ctx, item, ctx.path, i));
    });
    return ParseStatus.mergeArray(status, result);
  }
  get element() {
    return this._def.type;
  }
  min(minLength, message) {
    return new ZodArray({
      ...this._def,
      minLength: { value: minLength, message: errorUtil.toString(message) }
    });
  }
  max(maxLength, message) {
    return new ZodArray({
      ...this._def,
      maxLength: { value: maxLength, message: errorUtil.toString(message) }
    });
  }
  length(len, message) {
    return new ZodArray({
      ...this._def,
      exactLength: { value: len, message: errorUtil.toString(message) }
    });
  }
  nonempty(message) {
    return this.min(1, message);
  }
}
ZodArray.create = (schema, params) => {
  return new ZodArray({
    type: schema,
    minLength: null,
    maxLength: null,
    exactLength: null,
    typeName: ZodFirstPartyTypeKind.ZodArray,
    ...processCreateParams(params)
  });
};
function deepPartialify(schema) {
  if (schema instanceof ZodObject) {
    const newShape = {};
    for (const key in schema.shape) {
      const fieldSchema = schema.shape[key];
      newShape[key] = ZodOptional.create(deepPartialify(fieldSchema));
    }
    return new ZodObject({
      ...schema._def,
      shape: () => newShape
    });
  } else if (schema instanceof ZodArray) {
    return new ZodArray({
      ...schema._def,
      type: deepPartialify(schema.element)
    });
  } else if (schema instanceof ZodOptional) {
    return ZodOptional.create(deepPartialify(schema.unwrap()));
  } else if (schema instanceof ZodNullable) {
    return ZodNullable.create(deepPartialify(schema.unwrap()));
  } else if (schema instanceof ZodTuple) {
    return ZodTuple.create(schema.items.map((item) => deepPartialify(item)));
  } else {
    return schema;
  }
}
class ZodObject extends ZodType {
  constructor() {
    super(...arguments);
    this._cached = null;
    this.nonstrict = this.passthrough;
    this.augment = this.extend;
  }
  _getCached() {
    if (this._cached !== null)
      return this._cached;
    const shape = this._def.shape();
    const keys = util$3.objectKeys(shape);
    this._cached = { shape, keys };
    return this._cached;
  }
  _parse(input) {
    const parsedType = this._getType(input);
    if (parsedType !== ZodParsedType.object) {
      const ctx2 = this._getOrReturnCtx(input);
      addIssueToContext(ctx2, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.object,
        received: ctx2.parsedType
      });
      return INVALID;
    }
    const { status, ctx } = this._processInputParams(input);
    const { shape, keys: shapeKeys } = this._getCached();
    const extraKeys = [];
    if (!(this._def.catchall instanceof ZodNever && this._def.unknownKeys === "strip")) {
      for (const key in ctx.data) {
        if (!shapeKeys.includes(key)) {
          extraKeys.push(key);
        }
      }
    }
    const pairs = [];
    for (const key of shapeKeys) {
      const keyValidator = shape[key];
      const value = ctx.data[key];
      pairs.push({
        key: { status: "valid", value: key },
        value: keyValidator._parse(new ParseInputLazyPath(ctx, value, ctx.path, key)),
        alwaysSet: key in ctx.data
      });
    }
    if (this._def.catchall instanceof ZodNever) {
      const unknownKeys = this._def.unknownKeys;
      if (unknownKeys === "passthrough") {
        for (const key of extraKeys) {
          pairs.push({
            key: { status: "valid", value: key },
            value: { status: "valid", value: ctx.data[key] }
          });
        }
      } else if (unknownKeys === "strict") {
        if (extraKeys.length > 0) {
          addIssueToContext(ctx, {
            code: ZodIssueCode.unrecognized_keys,
            keys: extraKeys
          });
          status.dirty();
        }
      } else if (unknownKeys === "strip") ;
      else {
        throw new Error(`Internal ZodObject error: invalid unknownKeys value.`);
      }
    } else {
      const catchall = this._def.catchall;
      for (const key of extraKeys) {
        const value = ctx.data[key];
        pairs.push({
          key: { status: "valid", value: key },
          value: catchall._parse(
            new ParseInputLazyPath(ctx, value, ctx.path, key)
            //, ctx.child(key), value, getParsedType(value)
          ),
          alwaysSet: key in ctx.data
        });
      }
    }
    if (ctx.common.async) {
      return Promise.resolve().then(async () => {
        const syncPairs = [];
        for (const pair of pairs) {
          const key = await pair.key;
          const value = await pair.value;
          syncPairs.push({
            key,
            value,
            alwaysSet: pair.alwaysSet
          });
        }
        return syncPairs;
      }).then((syncPairs) => {
        return ParseStatus.mergeObjectSync(status, syncPairs);
      });
    } else {
      return ParseStatus.mergeObjectSync(status, pairs);
    }
  }
  get shape() {
    return this._def.shape();
  }
  strict(message) {
    errorUtil.errToObj;
    return new ZodObject({
      ...this._def,
      unknownKeys: "strict",
      ...message !== void 0 ? {
        errorMap: (issue2, ctx) => {
          const defaultError = this._def.errorMap?.(issue2, ctx).message ?? ctx.defaultError;
          if (issue2.code === "unrecognized_keys")
            return {
              message: errorUtil.errToObj(message).message ?? defaultError
            };
          return {
            message: defaultError
          };
        }
      } : {}
    });
  }
  strip() {
    return new ZodObject({
      ...this._def,
      unknownKeys: "strip"
    });
  }
  passthrough() {
    return new ZodObject({
      ...this._def,
      unknownKeys: "passthrough"
    });
  }
  // const AugmentFactory =
  //   <Def extends ZodObjectDef>(def: Def) =>
  //   <Augmentation extends ZodRawShape>(
  //     augmentation: Augmentation
  //   ): ZodObject<
  //     extendShape<ReturnType<Def["shape"]>, Augmentation>,
  //     Def["unknownKeys"],
  //     Def["catchall"]
  //   > => {
  //     return new ZodObject({
  //       ...def,
  //       shape: () => ({
  //         ...def.shape(),
  //         ...augmentation,
  //       }),
  //     }) as any;
  //   };
  extend(augmentation) {
    return new ZodObject({
      ...this._def,
      shape: () => ({
        ...this._def.shape(),
        ...augmentation
      })
    });
  }
  /**
   * Prior to zod@1.0.12 there was a bug in the
   * inferred type of merged objects. Please
   * upgrade if you are experiencing issues.
   */
  merge(merging) {
    const merged = new ZodObject({
      unknownKeys: merging._def.unknownKeys,
      catchall: merging._def.catchall,
      shape: () => ({
        ...this._def.shape(),
        ...merging._def.shape()
      }),
      typeName: ZodFirstPartyTypeKind.ZodObject
    });
    return merged;
  }
  // merge<
  //   Incoming extends AnyZodObject,
  //   Augmentation extends Incoming["shape"],
  //   NewOutput extends {
  //     [k in keyof Augmentation | keyof Output]: k extends keyof Augmentation
  //       ? Augmentation[k]["_output"]
  //       : k extends keyof Output
  //       ? Output[k]
  //       : never;
  //   },
  //   NewInput extends {
  //     [k in keyof Augmentation | keyof Input]: k extends keyof Augmentation
  //       ? Augmentation[k]["_input"]
  //       : k extends keyof Input
  //       ? Input[k]
  //       : never;
  //   }
  // >(
  //   merging: Incoming
  // ): ZodObject<
  //   extendShape<T, ReturnType<Incoming["_def"]["shape"]>>,
  //   Incoming["_def"]["unknownKeys"],
  //   Incoming["_def"]["catchall"],
  //   NewOutput,
  //   NewInput
  // > {
  //   const merged: any = new ZodObject({
  //     unknownKeys: merging._def.unknownKeys,
  //     catchall: merging._def.catchall,
  //     shape: () =>
  //       objectUtil.mergeShapes(this._def.shape(), merging._def.shape()),
  //     typeName: ZodFirstPartyTypeKind.ZodObject,
  //   }) as any;
  //   return merged;
  // }
  setKey(key, schema) {
    return this.augment({ [key]: schema });
  }
  // merge<Incoming extends AnyZodObject>(
  //   merging: Incoming
  // ): //ZodObject<T & Incoming["_shape"], UnknownKeys, Catchall> = (merging) => {
  // ZodObject<
  //   extendShape<T, ReturnType<Incoming["_def"]["shape"]>>,
  //   Incoming["_def"]["unknownKeys"],
  //   Incoming["_def"]["catchall"]
  // > {
  //   // const mergedShape = objectUtil.mergeShapes(
  //   //   this._def.shape(),
  //   //   merging._def.shape()
  //   // );
  //   const merged: any = new ZodObject({
  //     unknownKeys: merging._def.unknownKeys,
  //     catchall: merging._def.catchall,
  //     shape: () =>
  //       objectUtil.mergeShapes(this._def.shape(), merging._def.shape()),
  //     typeName: ZodFirstPartyTypeKind.ZodObject,
  //   }) as any;
  //   return merged;
  // }
  catchall(index2) {
    return new ZodObject({
      ...this._def,
      catchall: index2
    });
  }
  pick(mask) {
    const shape = {};
    for (const key of util$3.objectKeys(mask)) {
      if (mask[key] && this.shape[key]) {
        shape[key] = this.shape[key];
      }
    }
    return new ZodObject({
      ...this._def,
      shape: () => shape
    });
  }
  omit(mask) {
    const shape = {};
    for (const key of util$3.objectKeys(this.shape)) {
      if (!mask[key]) {
        shape[key] = this.shape[key];
      }
    }
    return new ZodObject({
      ...this._def,
      shape: () => shape
    });
  }
  /**
   * @deprecated
   */
  deepPartial() {
    return deepPartialify(this);
  }
  partial(mask) {
    const newShape = {};
    for (const key of util$3.objectKeys(this.shape)) {
      const fieldSchema = this.shape[key];
      if (mask && !mask[key]) {
        newShape[key] = fieldSchema;
      } else {
        newShape[key] = fieldSchema.optional();
      }
    }
    return new ZodObject({
      ...this._def,
      shape: () => newShape
    });
  }
  required(mask) {
    const newShape = {};
    for (const key of util$3.objectKeys(this.shape)) {
      if (mask && !mask[key]) {
        newShape[key] = this.shape[key];
      } else {
        const fieldSchema = this.shape[key];
        let newField = fieldSchema;
        while (newField instanceof ZodOptional) {
          newField = newField._def.innerType;
        }
        newShape[key] = newField;
      }
    }
    return new ZodObject({
      ...this._def,
      shape: () => newShape
    });
  }
  keyof() {
    return createZodEnum(util$3.objectKeys(this.shape));
  }
}
ZodObject.create = (shape, params) => {
  return new ZodObject({
    shape: () => shape,
    unknownKeys: "strip",
    catchall: ZodNever.create(),
    typeName: ZodFirstPartyTypeKind.ZodObject,
    ...processCreateParams(params)
  });
};
ZodObject.strictCreate = (shape, params) => {
  return new ZodObject({
    shape: () => shape,
    unknownKeys: "strict",
    catchall: ZodNever.create(),
    typeName: ZodFirstPartyTypeKind.ZodObject,
    ...processCreateParams(params)
  });
};
ZodObject.lazycreate = (shape, params) => {
  return new ZodObject({
    shape,
    unknownKeys: "strip",
    catchall: ZodNever.create(),
    typeName: ZodFirstPartyTypeKind.ZodObject,
    ...processCreateParams(params)
  });
};
class ZodUnion extends ZodType {
  _parse(input) {
    const { ctx } = this._processInputParams(input);
    const options = this._def.options;
    function handleResults(results) {
      for (const result of results) {
        if (result.result.status === "valid") {
          return result.result;
        }
      }
      for (const result of results) {
        if (result.result.status === "dirty") {
          ctx.common.issues.push(...result.ctx.common.issues);
          return result.result;
        }
      }
      const unionErrors = results.map((result) => new ZodError(result.ctx.common.issues));
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_union,
        unionErrors
      });
      return INVALID;
    }
    if (ctx.common.async) {
      return Promise.all(options.map(async (option) => {
        const childCtx = {
          ...ctx,
          common: {
            ...ctx.common,
            issues: []
          },
          parent: null
        };
        return {
          result: await option._parseAsync({
            data: ctx.data,
            path: ctx.path,
            parent: childCtx
          }),
          ctx: childCtx
        };
      })).then(handleResults);
    } else {
      let dirty = void 0;
      const issues = [];
      for (const option of options) {
        const childCtx = {
          ...ctx,
          common: {
            ...ctx.common,
            issues: []
          },
          parent: null
        };
        const result = option._parseSync({
          data: ctx.data,
          path: ctx.path,
          parent: childCtx
        });
        if (result.status === "valid") {
          return result;
        } else if (result.status === "dirty" && !dirty) {
          dirty = { result, ctx: childCtx };
        }
        if (childCtx.common.issues.length) {
          issues.push(childCtx.common.issues);
        }
      }
      if (dirty) {
        ctx.common.issues.push(...dirty.ctx.common.issues);
        return dirty.result;
      }
      const unionErrors = issues.map((issues2) => new ZodError(issues2));
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_union,
        unionErrors
      });
      return INVALID;
    }
  }
  get options() {
    return this._def.options;
  }
}
ZodUnion.create = (types2, params) => {
  return new ZodUnion({
    options: types2,
    typeName: ZodFirstPartyTypeKind.ZodUnion,
    ...processCreateParams(params)
  });
};
function mergeValues(a2, b) {
  const aType = getParsedType(a2);
  const bType = getParsedType(b);
  if (a2 === b) {
    return { valid: true, data: a2 };
  } else if (aType === ZodParsedType.object && bType === ZodParsedType.object) {
    const bKeys = util$3.objectKeys(b);
    const sharedKeys = util$3.objectKeys(a2).filter((key) => bKeys.indexOf(key) !== -1);
    const newObj = { ...a2, ...b };
    for (const key of sharedKeys) {
      const sharedValue = mergeValues(a2[key], b[key]);
      if (!sharedValue.valid) {
        return { valid: false };
      }
      newObj[key] = sharedValue.data;
    }
    return { valid: true, data: newObj };
  } else if (aType === ZodParsedType.array && bType === ZodParsedType.array) {
    if (a2.length !== b.length) {
      return { valid: false };
    }
    const newArray = [];
    for (let index2 = 0; index2 < a2.length; index2++) {
      const itemA = a2[index2];
      const itemB = b[index2];
      const sharedValue = mergeValues(itemA, itemB);
      if (!sharedValue.valid) {
        return { valid: false };
      }
      newArray.push(sharedValue.data);
    }
    return { valid: true, data: newArray };
  } else if (aType === ZodParsedType.date && bType === ZodParsedType.date && +a2 === +b) {
    return { valid: true, data: a2 };
  } else {
    return { valid: false };
  }
}
class ZodIntersection extends ZodType {
  _parse(input) {
    const { status, ctx } = this._processInputParams(input);
    const handleParsed = (parsedLeft, parsedRight) => {
      if (isAborted(parsedLeft) || isAborted(parsedRight)) {
        return INVALID;
      }
      const merged = mergeValues(parsedLeft.value, parsedRight.value);
      if (!merged.valid) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.invalid_intersection_types
        });
        return INVALID;
      }
      if (isDirty(parsedLeft) || isDirty(parsedRight)) {
        status.dirty();
      }
      return { status: status.value, value: merged.data };
    };
    if (ctx.common.async) {
      return Promise.all([
        this._def.left._parseAsync({
          data: ctx.data,
          path: ctx.path,
          parent: ctx
        }),
        this._def.right._parseAsync({
          data: ctx.data,
          path: ctx.path,
          parent: ctx
        })
      ]).then(([left, right]) => handleParsed(left, right));
    } else {
      return handleParsed(this._def.left._parseSync({
        data: ctx.data,
        path: ctx.path,
        parent: ctx
      }), this._def.right._parseSync({
        data: ctx.data,
        path: ctx.path,
        parent: ctx
      }));
    }
  }
}
ZodIntersection.create = (left, right, params) => {
  return new ZodIntersection({
    left,
    right,
    typeName: ZodFirstPartyTypeKind.ZodIntersection,
    ...processCreateParams(params)
  });
};
class ZodTuple extends ZodType {
  _parse(input) {
    const { status, ctx } = this._processInputParams(input);
    if (ctx.parsedType !== ZodParsedType.array) {
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.array,
        received: ctx.parsedType
      });
      return INVALID;
    }
    if (ctx.data.length < this._def.items.length) {
      addIssueToContext(ctx, {
        code: ZodIssueCode.too_small,
        minimum: this._def.items.length,
        inclusive: true,
        exact: false,
        type: "array"
      });
      return INVALID;
    }
    const rest = this._def.rest;
    if (!rest && ctx.data.length > this._def.items.length) {
      addIssueToContext(ctx, {
        code: ZodIssueCode.too_big,
        maximum: this._def.items.length,
        inclusive: true,
        exact: false,
        type: "array"
      });
      status.dirty();
    }
    const items2 = [...ctx.data].map((item, itemIndex) => {
      const schema = this._def.items[itemIndex] || this._def.rest;
      if (!schema)
        return null;
      return schema._parse(new ParseInputLazyPath(ctx, item, ctx.path, itemIndex));
    }).filter((x2) => !!x2);
    if (ctx.common.async) {
      return Promise.all(items2).then((results) => {
        return ParseStatus.mergeArray(status, results);
      });
    } else {
      return ParseStatus.mergeArray(status, items2);
    }
  }
  get items() {
    return this._def.items;
  }
  rest(rest) {
    return new ZodTuple({
      ...this._def,
      rest
    });
  }
}
ZodTuple.create = (schemas, params) => {
  if (!Array.isArray(schemas)) {
    throw new Error("You must pass an array of schemas to z.tuple([ ... ])");
  }
  return new ZodTuple({
    items: schemas,
    typeName: ZodFirstPartyTypeKind.ZodTuple,
    rest: null,
    ...processCreateParams(params)
  });
};
class ZodMap extends ZodType {
  get keySchema() {
    return this._def.keyType;
  }
  get valueSchema() {
    return this._def.valueType;
  }
  _parse(input) {
    const { status, ctx } = this._processInputParams(input);
    if (ctx.parsedType !== ZodParsedType.map) {
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.map,
        received: ctx.parsedType
      });
      return INVALID;
    }
    const keyType = this._def.keyType;
    const valueType = this._def.valueType;
    const pairs = [...ctx.data.entries()].map(([key, value], index2) => {
      return {
        key: keyType._parse(new ParseInputLazyPath(ctx, key, ctx.path, [index2, "key"])),
        value: valueType._parse(new ParseInputLazyPath(ctx, value, ctx.path, [index2, "value"]))
      };
    });
    if (ctx.common.async) {
      const finalMap = /* @__PURE__ */ new Map();
      return Promise.resolve().then(async () => {
        for (const pair of pairs) {
          const key = await pair.key;
          const value = await pair.value;
          if (key.status === "aborted" || value.status === "aborted") {
            return INVALID;
          }
          if (key.status === "dirty" || value.status === "dirty") {
            status.dirty();
          }
          finalMap.set(key.value, value.value);
        }
        return { status: status.value, value: finalMap };
      });
    } else {
      const finalMap = /* @__PURE__ */ new Map();
      for (const pair of pairs) {
        const key = pair.key;
        const value = pair.value;
        if (key.status === "aborted" || value.status === "aborted") {
          return INVALID;
        }
        if (key.status === "dirty" || value.status === "dirty") {
          status.dirty();
        }
        finalMap.set(key.value, value.value);
      }
      return { status: status.value, value: finalMap };
    }
  }
}
ZodMap.create = (keyType, valueType, params) => {
  return new ZodMap({
    valueType,
    keyType,
    typeName: ZodFirstPartyTypeKind.ZodMap,
    ...processCreateParams(params)
  });
};
class ZodSet extends ZodType {
  _parse(input) {
    const { status, ctx } = this._processInputParams(input);
    if (ctx.parsedType !== ZodParsedType.set) {
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.set,
        received: ctx.parsedType
      });
      return INVALID;
    }
    const def = this._def;
    if (def.minSize !== null) {
      if (ctx.data.size < def.minSize.value) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.too_small,
          minimum: def.minSize.value,
          type: "set",
          inclusive: true,
          exact: false,
          message: def.minSize.message
        });
        status.dirty();
      }
    }
    if (def.maxSize !== null) {
      if (ctx.data.size > def.maxSize.value) {
        addIssueToContext(ctx, {
          code: ZodIssueCode.too_big,
          maximum: def.maxSize.value,
          type: "set",
          inclusive: true,
          exact: false,
          message: def.maxSize.message
        });
        status.dirty();
      }
    }
    const valueType = this._def.valueType;
    function finalizeSet(elements2) {
      const parsedSet = /* @__PURE__ */ new Set();
      for (const element of elements2) {
        if (element.status === "aborted")
          return INVALID;
        if (element.status === "dirty")
          status.dirty();
        parsedSet.add(element.value);
      }
      return { status: status.value, value: parsedSet };
    }
    const elements = [...ctx.data.values()].map((item, i) => valueType._parse(new ParseInputLazyPath(ctx, item, ctx.path, i)));
    if (ctx.common.async) {
      return Promise.all(elements).then((elements2) => finalizeSet(elements2));
    } else {
      return finalizeSet(elements);
    }
  }
  min(minSize, message) {
    return new ZodSet({
      ...this._def,
      minSize: { value: minSize, message: errorUtil.toString(message) }
    });
  }
  max(maxSize, message) {
    return new ZodSet({
      ...this._def,
      maxSize: { value: maxSize, message: errorUtil.toString(message) }
    });
  }
  size(size2, message) {
    return this.min(size2, message).max(size2, message);
  }
  nonempty(message) {
    return this.min(1, message);
  }
}
ZodSet.create = (valueType, params) => {
  return new ZodSet({
    valueType,
    minSize: null,
    maxSize: null,
    typeName: ZodFirstPartyTypeKind.ZodSet,
    ...processCreateParams(params)
  });
};
class ZodLazy extends ZodType {
  get schema() {
    return this._def.getter();
  }
  _parse(input) {
    const { ctx } = this._processInputParams(input);
    const lazySchema = this._def.getter();
    return lazySchema._parse({ data: ctx.data, path: ctx.path, parent: ctx });
  }
}
ZodLazy.create = (getter, params) => {
  return new ZodLazy({
    getter,
    typeName: ZodFirstPartyTypeKind.ZodLazy,
    ...processCreateParams(params)
  });
};
class ZodLiteral extends ZodType {
  _parse(input) {
    if (input.data !== this._def.value) {
      const ctx = this._getOrReturnCtx(input);
      addIssueToContext(ctx, {
        received: ctx.data,
        code: ZodIssueCode.invalid_literal,
        expected: this._def.value
      });
      return INVALID;
    }
    return { status: "valid", value: input.data };
  }
  get value() {
    return this._def.value;
  }
}
ZodLiteral.create = (value, params) => {
  return new ZodLiteral({
    value,
    typeName: ZodFirstPartyTypeKind.ZodLiteral,
    ...processCreateParams(params)
  });
};
function createZodEnum(values, params) {
  return new ZodEnum({
    values,
    typeName: ZodFirstPartyTypeKind.ZodEnum,
    ...processCreateParams(params)
  });
}
class ZodEnum extends ZodType {
  _parse(input) {
    if (typeof input.data !== "string") {
      const ctx = this._getOrReturnCtx(input);
      const expectedValues = this._def.values;
      addIssueToContext(ctx, {
        expected: util$3.joinValues(expectedValues),
        received: ctx.parsedType,
        code: ZodIssueCode.invalid_type
      });
      return INVALID;
    }
    if (!this._cache) {
      this._cache = new Set(this._def.values);
    }
    if (!this._cache.has(input.data)) {
      const ctx = this._getOrReturnCtx(input);
      const expectedValues = this._def.values;
      addIssueToContext(ctx, {
        received: ctx.data,
        code: ZodIssueCode.invalid_enum_value,
        options: expectedValues
      });
      return INVALID;
    }
    return OK(input.data);
  }
  get options() {
    return this._def.values;
  }
  get enum() {
    const enumValues = {};
    for (const val of this._def.values) {
      enumValues[val] = val;
    }
    return enumValues;
  }
  get Values() {
    const enumValues = {};
    for (const val of this._def.values) {
      enumValues[val] = val;
    }
    return enumValues;
  }
  get Enum() {
    const enumValues = {};
    for (const val of this._def.values) {
      enumValues[val] = val;
    }
    return enumValues;
  }
  extract(values, newDef = this._def) {
    return ZodEnum.create(values, {
      ...this._def,
      ...newDef
    });
  }
  exclude(values, newDef = this._def) {
    return ZodEnum.create(this.options.filter((opt) => !values.includes(opt)), {
      ...this._def,
      ...newDef
    });
  }
}
ZodEnum.create = createZodEnum;
class ZodNativeEnum extends ZodType {
  _parse(input) {
    const nativeEnumValues = util$3.getValidEnumValues(this._def.values);
    const ctx = this._getOrReturnCtx(input);
    if (ctx.parsedType !== ZodParsedType.string && ctx.parsedType !== ZodParsedType.number) {
      const expectedValues = util$3.objectValues(nativeEnumValues);
      addIssueToContext(ctx, {
        expected: util$3.joinValues(expectedValues),
        received: ctx.parsedType,
        code: ZodIssueCode.invalid_type
      });
      return INVALID;
    }
    if (!this._cache) {
      this._cache = new Set(util$3.getValidEnumValues(this._def.values));
    }
    if (!this._cache.has(input.data)) {
      const expectedValues = util$3.objectValues(nativeEnumValues);
      addIssueToContext(ctx, {
        received: ctx.data,
        code: ZodIssueCode.invalid_enum_value,
        options: expectedValues
      });
      return INVALID;
    }
    return OK(input.data);
  }
  get enum() {
    return this._def.values;
  }
}
ZodNativeEnum.create = (values, params) => {
  return new ZodNativeEnum({
    values,
    typeName: ZodFirstPartyTypeKind.ZodNativeEnum,
    ...processCreateParams(params)
  });
};
class ZodPromise extends ZodType {
  unwrap() {
    return this._def.type;
  }
  _parse(input) {
    const { ctx } = this._processInputParams(input);
    if (ctx.parsedType !== ZodParsedType.promise && ctx.common.async === false) {
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.promise,
        received: ctx.parsedType
      });
      return INVALID;
    }
    const promisified = ctx.parsedType === ZodParsedType.promise ? ctx.data : Promise.resolve(ctx.data);
    return OK(promisified.then((data2) => {
      return this._def.type.parseAsync(data2, {
        path: ctx.path,
        errorMap: ctx.common.contextualErrorMap
      });
    }));
  }
}
ZodPromise.create = (schema, params) => {
  return new ZodPromise({
    type: schema,
    typeName: ZodFirstPartyTypeKind.ZodPromise,
    ...processCreateParams(params)
  });
};
class ZodEffects extends ZodType {
  innerType() {
    return this._def.schema;
  }
  sourceType() {
    return this._def.schema._def.typeName === ZodFirstPartyTypeKind.ZodEffects ? this._def.schema.sourceType() : this._def.schema;
  }
  _parse(input) {
    const { status, ctx } = this._processInputParams(input);
    const effect = this._def.effect || null;
    const checkCtx = {
      addIssue: (arg) => {
        addIssueToContext(ctx, arg);
        if (arg.fatal) {
          status.abort();
        } else {
          status.dirty();
        }
      },
      get path() {
        return ctx.path;
      }
    };
    checkCtx.addIssue = checkCtx.addIssue.bind(checkCtx);
    if (effect.type === "preprocess") {
      const processed = effect.transform(ctx.data, checkCtx);
      if (ctx.common.async) {
        return Promise.resolve(processed).then(async (processed2) => {
          if (status.value === "aborted")
            return INVALID;
          const result = await this._def.schema._parseAsync({
            data: processed2,
            path: ctx.path,
            parent: ctx
          });
          if (result.status === "aborted")
            return INVALID;
          if (result.status === "dirty")
            return DIRTY(result.value);
          if (status.value === "dirty")
            return DIRTY(result.value);
          return result;
        });
      } else {
        if (status.value === "aborted")
          return INVALID;
        const result = this._def.schema._parseSync({
          data: processed,
          path: ctx.path,
          parent: ctx
        });
        if (result.status === "aborted")
          return INVALID;
        if (result.status === "dirty")
          return DIRTY(result.value);
        if (status.value === "dirty")
          return DIRTY(result.value);
        return result;
      }
    }
    if (effect.type === "refinement") {
      const executeRefinement = (acc) => {
        const result = effect.refinement(acc, checkCtx);
        if (ctx.common.async) {
          return Promise.resolve(result);
        }
        if (result instanceof Promise) {
          throw new Error("Async refinement encountered during synchronous parse operation. Use .parseAsync instead.");
        }
        return acc;
      };
      if (ctx.common.async === false) {
        const inner = this._def.schema._parseSync({
          data: ctx.data,
          path: ctx.path,
          parent: ctx
        });
        if (inner.status === "aborted")
          return INVALID;
        if (inner.status === "dirty")
          status.dirty();
        executeRefinement(inner.value);
        return { status: status.value, value: inner.value };
      } else {
        return this._def.schema._parseAsync({ data: ctx.data, path: ctx.path, parent: ctx }).then((inner) => {
          if (inner.status === "aborted")
            return INVALID;
          if (inner.status === "dirty")
            status.dirty();
          return executeRefinement(inner.value).then(() => {
            return { status: status.value, value: inner.value };
          });
        });
      }
    }
    if (effect.type === "transform") {
      if (ctx.common.async === false) {
        const base = this._def.schema._parseSync({
          data: ctx.data,
          path: ctx.path,
          parent: ctx
        });
        if (!isValid(base))
          return INVALID;
        const result = effect.transform(base.value, checkCtx);
        if (result instanceof Promise) {
          throw new Error(`Asynchronous transform encountered during synchronous parse operation. Use .parseAsync instead.`);
        }
        return { status: status.value, value: result };
      } else {
        return this._def.schema._parseAsync({ data: ctx.data, path: ctx.path, parent: ctx }).then((base) => {
          if (!isValid(base))
            return INVALID;
          return Promise.resolve(effect.transform(base.value, checkCtx)).then((result) => ({
            status: status.value,
            value: result
          }));
        });
      }
    }
    util$3.assertNever(effect);
  }
}
ZodEffects.create = (schema, effect, params) => {
  return new ZodEffects({
    schema,
    typeName: ZodFirstPartyTypeKind.ZodEffects,
    effect,
    ...processCreateParams(params)
  });
};
ZodEffects.createWithPreprocess = (preprocess2, schema, params) => {
  return new ZodEffects({
    schema,
    effect: { type: "preprocess", transform: preprocess2 },
    typeName: ZodFirstPartyTypeKind.ZodEffects,
    ...processCreateParams(params)
  });
};
class ZodOptional extends ZodType {
  _parse(input) {
    const parsedType = this._getType(input);
    if (parsedType === ZodParsedType.undefined) {
      return OK(void 0);
    }
    return this._def.innerType._parse(input);
  }
  unwrap() {
    return this._def.innerType;
  }
}
ZodOptional.create = (type2, params) => {
  return new ZodOptional({
    innerType: type2,
    typeName: ZodFirstPartyTypeKind.ZodOptional,
    ...processCreateParams(params)
  });
};
class ZodNullable extends ZodType {
  _parse(input) {
    const parsedType = this._getType(input);
    if (parsedType === ZodParsedType.null) {
      return OK(null);
    }
    return this._def.innerType._parse(input);
  }
  unwrap() {
    return this._def.innerType;
  }
}
ZodNullable.create = (type2, params) => {
  return new ZodNullable({
    innerType: type2,
    typeName: ZodFirstPartyTypeKind.ZodNullable,
    ...processCreateParams(params)
  });
};
class ZodDefault extends ZodType {
  _parse(input) {
    const { ctx } = this._processInputParams(input);
    let data2 = ctx.data;
    if (ctx.parsedType === ZodParsedType.undefined) {
      data2 = this._def.defaultValue();
    }
    return this._def.innerType._parse({
      data: data2,
      path: ctx.path,
      parent: ctx
    });
  }
  removeDefault() {
    return this._def.innerType;
  }
}
ZodDefault.create = (type2, params) => {
  return new ZodDefault({
    innerType: type2,
    typeName: ZodFirstPartyTypeKind.ZodDefault,
    defaultValue: typeof params.default === "function" ? params.default : () => params.default,
    ...processCreateParams(params)
  });
};
class ZodCatch extends ZodType {
  _parse(input) {
    const { ctx } = this._processInputParams(input);
    const newCtx = {
      ...ctx,
      common: {
        ...ctx.common,
        issues: []
      }
    };
    const result = this._def.innerType._parse({
      data: newCtx.data,
      path: newCtx.path,
      parent: {
        ...newCtx
      }
    });
    if (isAsync(result)) {
      return result.then((result2) => {
        return {
          status: "valid",
          value: result2.status === "valid" ? result2.value : this._def.catchValue({
            get error() {
              return new ZodError(newCtx.common.issues);
            },
            input: newCtx.data
          })
        };
      });
    } else {
      return {
        status: "valid",
        value: result.status === "valid" ? result.value : this._def.catchValue({
          get error() {
            return new ZodError(newCtx.common.issues);
          },
          input: newCtx.data
        })
      };
    }
  }
  removeCatch() {
    return this._def.innerType;
  }
}
ZodCatch.create = (type2, params) => {
  return new ZodCatch({
    innerType: type2,
    typeName: ZodFirstPartyTypeKind.ZodCatch,
    catchValue: typeof params.catch === "function" ? params.catch : () => params.catch,
    ...processCreateParams(params)
  });
};
class ZodNaN extends ZodType {
  _parse(input) {
    const parsedType = this._getType(input);
    if (parsedType !== ZodParsedType.nan) {
      const ctx = this._getOrReturnCtx(input);
      addIssueToContext(ctx, {
        code: ZodIssueCode.invalid_type,
        expected: ZodParsedType.nan,
        received: ctx.parsedType
      });
      return INVALID;
    }
    return { status: "valid", value: input.data };
  }
}
ZodNaN.create = (params) => {
  return new ZodNaN({
    typeName: ZodFirstPartyTypeKind.ZodNaN,
    ...processCreateParams(params)
  });
};
class ZodBranded extends ZodType {
  _parse(input) {
    const { ctx } = this._processInputParams(input);
    const data2 = ctx.data;
    return this._def.type._parse({
      data: data2,
      path: ctx.path,
      parent: ctx
    });
  }
  unwrap() {
    return this._def.type;
  }
}
class ZodPipeline extends ZodType {
  _parse(input) {
    const { status, ctx } = this._processInputParams(input);
    if (ctx.common.async) {
      const handleAsync = async () => {
        const inResult = await this._def.in._parseAsync({
          data: ctx.data,
          path: ctx.path,
          parent: ctx
        });
        if (inResult.status === "aborted")
          return INVALID;
        if (inResult.status === "dirty") {
          status.dirty();
          return DIRTY(inResult.value);
        } else {
          return this._def.out._parseAsync({
            data: inResult.value,
            path: ctx.path,
            parent: ctx
          });
        }
      };
      return handleAsync();
    } else {
      const inResult = this._def.in._parseSync({
        data: ctx.data,
        path: ctx.path,
        parent: ctx
      });
      if (inResult.status === "aborted")
        return INVALID;
      if (inResult.status === "dirty") {
        status.dirty();
        return {
          status: "dirty",
          value: inResult.value
        };
      } else {
        return this._def.out._parseSync({
          data: inResult.value,
          path: ctx.path,
          parent: ctx
        });
      }
    }
  }
  static create(a2, b) {
    return new ZodPipeline({
      in: a2,
      out: b,
      typeName: ZodFirstPartyTypeKind.ZodPipeline
    });
  }
}
class ZodReadonly extends ZodType {
  _parse(input) {
    const result = this._def.innerType._parse(input);
    const freeze = (data2) => {
      if (isValid(data2)) {
        data2.value = Object.freeze(data2.value);
      }
      return data2;
    };
    return isAsync(result) ? result.then((data2) => freeze(data2)) : freeze(result);
  }
  unwrap() {
    return this._def.innerType;
  }
}
ZodReadonly.create = (type2, params) => {
  return new ZodReadonly({
    innerType: type2,
    typeName: ZodFirstPartyTypeKind.ZodReadonly,
    ...processCreateParams(params)
  });
};
var ZodFirstPartyTypeKind;
(function(ZodFirstPartyTypeKind2) {
  ZodFirstPartyTypeKind2["ZodString"] = "ZodString";
  ZodFirstPartyTypeKind2["ZodNumber"] = "ZodNumber";
  ZodFirstPartyTypeKind2["ZodNaN"] = "ZodNaN";
  ZodFirstPartyTypeKind2["ZodBigInt"] = "ZodBigInt";
  ZodFirstPartyTypeKind2["ZodBoolean"] = "ZodBoolean";
  ZodFirstPartyTypeKind2["ZodDate"] = "ZodDate";
  ZodFirstPartyTypeKind2["ZodSymbol"] = "ZodSymbol";
  ZodFirstPartyTypeKind2["ZodUndefined"] = "ZodUndefined";
  ZodFirstPartyTypeKind2["ZodNull"] = "ZodNull";
  ZodFirstPartyTypeKind2["ZodAny"] = "ZodAny";
  ZodFirstPartyTypeKind2["ZodUnknown"] = "ZodUnknown";
  ZodFirstPartyTypeKind2["ZodNever"] = "ZodNever";
  ZodFirstPartyTypeKind2["ZodVoid"] = "ZodVoid";
  ZodFirstPartyTypeKind2["ZodArray"] = "ZodArray";
  ZodFirstPartyTypeKind2["ZodObject"] = "ZodObject";
  ZodFirstPartyTypeKind2["ZodUnion"] = "ZodUnion";
  ZodFirstPartyTypeKind2["ZodDiscriminatedUnion"] = "ZodDiscriminatedUnion";
  ZodFirstPartyTypeKind2["ZodIntersection"] = "ZodIntersection";
  ZodFirstPartyTypeKind2["ZodTuple"] = "ZodTuple";
  ZodFirstPartyTypeKind2["ZodRecord"] = "ZodRecord";
  ZodFirstPartyTypeKind2["ZodMap"] = "ZodMap";
  ZodFirstPartyTypeKind2["ZodSet"] = "ZodSet";
  ZodFirstPartyTypeKind2["ZodFunction"] = "ZodFunction";
  ZodFirstPartyTypeKind2["ZodLazy"] = "ZodLazy";
  ZodFirstPartyTypeKind2["ZodLiteral"] = "ZodLiteral";
  ZodFirstPartyTypeKind2["ZodEnum"] = "ZodEnum";
  ZodFirstPartyTypeKind2["ZodEffects"] = "ZodEffects";
  ZodFirstPartyTypeKind2["ZodNativeEnum"] = "ZodNativeEnum";
  ZodFirstPartyTypeKind2["ZodOptional"] = "ZodOptional";
  ZodFirstPartyTypeKind2["ZodNullable"] = "ZodNullable";
  ZodFirstPartyTypeKind2["ZodDefault"] = "ZodDefault";
  ZodFirstPartyTypeKind2["ZodCatch"] = "ZodCatch";
  ZodFirstPartyTypeKind2["ZodPromise"] = "ZodPromise";
  ZodFirstPartyTypeKind2["ZodBranded"] = "ZodBranded";
  ZodFirstPartyTypeKind2["ZodPipeline"] = "ZodPipeline";
  ZodFirstPartyTypeKind2["ZodReadonly"] = "ZodReadonly";
})(ZodFirstPartyTypeKind || (ZodFirstPartyTypeKind = {}));
ZodNever.create;
ZodArray.create;
const objectType = ZodObject.create;
ZodUnion.create;
ZodIntersection.create;
ZodTuple.create;
ZodEnum.create;
ZodPromise.create;
ZodOptional.create;
ZodNullable.create;
function isZ4Schema(s2) {
  const schema = s2;
  return !!schema._zod;
}
function safeParse(schema, data2) {
  if (isZ4Schema(schema)) {
    const result2 = safeParse$2(schema, data2);
    return result2;
  }
  const v3Schema = schema;
  const result = v3Schema.safeParse(data2);
  return result;
}
function getObjectShape(schema) {
  if (!schema)
    return void 0;
  let rawShape;
  if (isZ4Schema(schema)) {
    const v4Schema = schema;
    rawShape = v4Schema._zod?.def?.shape;
  } else {
    const v3Schema = schema;
    rawShape = v3Schema.shape;
  }
  if (!rawShape)
    return void 0;
  if (typeof rawShape === "function") {
    try {
      return rawShape();
    } catch {
      return void 0;
    }
  }
  return rawShape;
}
function getLiteralValue(schema) {
  if (isZ4Schema(schema)) {
    const v4Schema = schema;
    const def2 = v4Schema._zod?.def;
    if (def2) {
      if (def2.value !== void 0)
        return def2.value;
      if (Array.isArray(def2.values) && def2.values.length > 0) {
        return def2.values[0];
      }
    }
  }
  const v3Schema = schema;
  const def = v3Schema._def;
  if (def) {
    if (def.value !== void 0)
      return def.value;
    if (Array.isArray(def.values) && def.values.length > 0) {
      return def.values[0];
    }
  }
  const directValue = schema.value;
  if (directValue !== void 0)
    return directValue;
  return void 0;
}
function isTerminal(status) {
  return status === "completed" || status === "failed" || status === "cancelled";
}
new Set("ABCDEFGHIJKLMNOPQRSTUVXYZabcdefghijklmnopqrstuvxyz0123456789");
function getMethodLiteral(schema) {
  const shape = getObjectShape(schema);
  const methodSchema = shape?.method;
  if (!methodSchema) {
    throw new Error("Schema is missing a method literal");
  }
  const value = getLiteralValue(methodSchema);
  if (typeof value !== "string") {
    throw new Error("Schema method literal must be a string");
  }
  return value;
}
function parseWithCompat(schema, data2) {
  const result = safeParse(schema, data2);
  if (!result.success) {
    throw result.error;
  }
  return result.data;
}
const DEFAULT_REQUEST_TIMEOUT_MSEC = 6e4;
class Protocol {
  constructor(_options) {
    this._options = _options;
    this._requestMessageId = 0;
    this._requestHandlers = /* @__PURE__ */ new Map();
    this._requestHandlerAbortControllers = /* @__PURE__ */ new Map();
    this._notificationHandlers = /* @__PURE__ */ new Map();
    this._responseHandlers = /* @__PURE__ */ new Map();
    this._progressHandlers = /* @__PURE__ */ new Map();
    this._timeoutInfo = /* @__PURE__ */ new Map();
    this._pendingDebouncedNotifications = /* @__PURE__ */ new Set();
    this._taskProgressTokens = /* @__PURE__ */ new Map();
    this._requestResolvers = /* @__PURE__ */ new Map();
    this.setNotificationHandler(CancelledNotificationSchema, (notification) => {
      this._oncancel(notification);
    });
    this.setNotificationHandler(ProgressNotificationSchema, (notification) => {
      this._onprogress(notification);
    });
    this.setRequestHandler(
      PingRequestSchema,
      // Automatic pong by default.
      (_request) => ({})
    );
    this._taskStore = _options?.taskStore;
    this._taskMessageQueue = _options?.taskMessageQueue;
    if (this._taskStore) {
      this.setRequestHandler(GetTaskRequestSchema, async (request, extra) => {
        const task = await this._taskStore.getTask(request.params.taskId, extra.sessionId);
        if (!task) {
          throw new McpError(ErrorCode.InvalidParams, "Failed to retrieve task: Task not found");
        }
        return {
          ...task
        };
      });
      this.setRequestHandler(GetTaskPayloadRequestSchema, async (request, extra) => {
        const handleTaskResult = async () => {
          const taskId = request.params.taskId;
          if (this._taskMessageQueue) {
            let queuedMessage;
            while (queuedMessage = await this._taskMessageQueue.dequeue(taskId, extra.sessionId)) {
              if (queuedMessage.type === "response" || queuedMessage.type === "error") {
                const message = queuedMessage.message;
                const requestId = message.id;
                const resolver = this._requestResolvers.get(requestId);
                if (resolver) {
                  this._requestResolvers.delete(requestId);
                  if (queuedMessage.type === "response") {
                    resolver(message);
                  } else {
                    const errorMessage = message;
                    const error = new McpError(errorMessage.error.code, errorMessage.error.message, errorMessage.error.data);
                    resolver(error);
                  }
                } else {
                  const messageType = queuedMessage.type === "response" ? "Response" : "Error";
                  this._onerror(new Error(`${messageType} handler missing for request ${requestId}`));
                }
                continue;
              }
              await this._transport?.send(queuedMessage.message, { relatedRequestId: extra.requestId });
            }
          }
          const task = await this._taskStore.getTask(taskId, extra.sessionId);
          if (!task) {
            throw new McpError(ErrorCode.InvalidParams, `Task not found: ${taskId}`);
          }
          if (!isTerminal(task.status)) {
            await this._waitForTaskUpdate(taskId, extra.signal);
            return await handleTaskResult();
          }
          if (isTerminal(task.status)) {
            const result = await this._taskStore.getTaskResult(taskId, extra.sessionId);
            this._clearTaskQueue(taskId);
            return {
              ...result,
              _meta: {
                ...result._meta,
                [RELATED_TASK_META_KEY]: {
                  taskId
                }
              }
            };
          }
          return await handleTaskResult();
        };
        return await handleTaskResult();
      });
      this.setRequestHandler(ListTasksRequestSchema, async (request, extra) => {
        try {
          const { tasks, nextCursor } = await this._taskStore.listTasks(request.params?.cursor, extra.sessionId);
          return {
            tasks,
            nextCursor,
            _meta: {}
          };
        } catch (error) {
          throw new McpError(ErrorCode.InvalidParams, `Failed to list tasks: ${error instanceof Error ? error.message : String(error)}`);
        }
      });
      this.setRequestHandler(CancelTaskRequestSchema, async (request, extra) => {
        try {
          const task = await this._taskStore.getTask(request.params.taskId, extra.sessionId);
          if (!task) {
            throw new McpError(ErrorCode.InvalidParams, `Task not found: ${request.params.taskId}`);
          }
          if (isTerminal(task.status)) {
            throw new McpError(ErrorCode.InvalidParams, `Cannot cancel task in terminal status: ${task.status}`);
          }
          await this._taskStore.updateTaskStatus(request.params.taskId, "cancelled", "Client cancelled task execution.", extra.sessionId);
          this._clearTaskQueue(request.params.taskId);
          const cancelledTask = await this._taskStore.getTask(request.params.taskId, extra.sessionId);
          if (!cancelledTask) {
            throw new McpError(ErrorCode.InvalidParams, `Task not found after cancellation: ${request.params.taskId}`);
          }
          return {
            _meta: {},
            ...cancelledTask
          };
        } catch (error) {
          if (error instanceof McpError) {
            throw error;
          }
          throw new McpError(ErrorCode.InvalidRequest, `Failed to cancel task: ${error instanceof Error ? error.message : String(error)}`);
        }
      });
    }
  }
  async _oncancel(notification) {
    if (!notification.params.requestId) {
      return;
    }
    const controller = this._requestHandlerAbortControllers.get(notification.params.requestId);
    controller?.abort(notification.params.reason);
  }
  _setupTimeout(messageId, timeout, maxTotalTimeout, onTimeout, resetTimeoutOnProgress = false) {
    this._timeoutInfo.set(messageId, {
      timeoutId: setTimeout(onTimeout, timeout),
      startTime: Date.now(),
      timeout,
      maxTotalTimeout,
      resetTimeoutOnProgress,
      onTimeout
    });
  }
  _resetTimeout(messageId) {
    const info = this._timeoutInfo.get(messageId);
    if (!info)
      return false;
    const totalElapsed = Date.now() - info.startTime;
    if (info.maxTotalTimeout && totalElapsed >= info.maxTotalTimeout) {
      this._timeoutInfo.delete(messageId);
      throw McpError.fromError(ErrorCode.RequestTimeout, "Maximum total timeout exceeded", {
        maxTotalTimeout: info.maxTotalTimeout,
        totalElapsed
      });
    }
    clearTimeout(info.timeoutId);
    info.timeoutId = setTimeout(info.onTimeout, info.timeout);
    return true;
  }
  _cleanupTimeout(messageId) {
    const info = this._timeoutInfo.get(messageId);
    if (info) {
      clearTimeout(info.timeoutId);
      this._timeoutInfo.delete(messageId);
    }
  }
  /**
   * Attaches to the given transport, starts it, and starts listening for messages.
   *
   * The Protocol object assumes ownership of the Transport, replacing any callbacks that have already been set, and expects that it is the only user of the Transport instance going forward.
   */
  async connect(transport) {
    if (this._transport) {
      throw new Error("Already connected to a transport. Call close() before connecting to a new transport, or use a separate Protocol instance per connection.");
    }
    this._transport = transport;
    const _onclose = this.transport?.onclose;
    this._transport.onclose = () => {
      _onclose?.();
      this._onclose();
    };
    const _onerror = this.transport?.onerror;
    this._transport.onerror = (error) => {
      _onerror?.(error);
      this._onerror(error);
    };
    const _onmessage = this._transport?.onmessage;
    this._transport.onmessage = (message, extra) => {
      _onmessage?.(message, extra);
      if (isJSONRPCResultResponse(message) || isJSONRPCErrorResponse(message)) {
        this._onresponse(message);
      } else if (isJSONRPCRequest(message)) {
        this._onrequest(message, extra);
      } else if (isJSONRPCNotification(message)) {
        this._onnotification(message);
      } else {
        this._onerror(new Error(`Unknown message type: ${JSON.stringify(message)}`));
      }
    };
    await this._transport.start();
  }
  _onclose() {
    const responseHandlers = this._responseHandlers;
    this._responseHandlers = /* @__PURE__ */ new Map();
    this._progressHandlers.clear();
    this._taskProgressTokens.clear();
    this._pendingDebouncedNotifications.clear();
    for (const controller of this._requestHandlerAbortControllers.values()) {
      controller.abort();
    }
    this._requestHandlerAbortControllers.clear();
    const error = McpError.fromError(ErrorCode.ConnectionClosed, "Connection closed");
    this._transport = void 0;
    this.onclose?.();
    for (const handler of responseHandlers.values()) {
      handler(error);
    }
  }
  _onerror(error) {
    this.onerror?.(error);
  }
  _onnotification(notification) {
    const handler = this._notificationHandlers.get(notification.method) ?? this.fallbackNotificationHandler;
    if (handler === void 0) {
      return;
    }
    Promise.resolve().then(() => handler(notification)).catch((error) => this._onerror(new Error(`Uncaught error in notification handler: ${error}`)));
  }
  _onrequest(request, extra) {
    const handler = this._requestHandlers.get(request.method) ?? this.fallbackRequestHandler;
    const capturedTransport = this._transport;
    const relatedTaskId = request.params?._meta?.[RELATED_TASK_META_KEY]?.taskId;
    if (handler === void 0) {
      const errorResponse = {
        jsonrpc: "2.0",
        id: request.id,
        error: {
          code: ErrorCode.MethodNotFound,
          message: "Method not found"
        }
      };
      if (relatedTaskId && this._taskMessageQueue) {
        this._enqueueTaskMessage(relatedTaskId, {
          type: "error",
          message: errorResponse,
          timestamp: Date.now()
        }, capturedTransport?.sessionId).catch((error) => this._onerror(new Error(`Failed to enqueue error response: ${error}`)));
      } else {
        capturedTransport?.send(errorResponse).catch((error) => this._onerror(new Error(`Failed to send an error response: ${error}`)));
      }
      return;
    }
    const abortController = new AbortController();
    this._requestHandlerAbortControllers.set(request.id, abortController);
    const taskCreationParams = isTaskAugmentedRequestParams(request.params) ? request.params.task : void 0;
    const taskStore = this._taskStore ? this.requestTaskStore(request, capturedTransport?.sessionId) : void 0;
    const fullExtra = {
      signal: abortController.signal,
      sessionId: capturedTransport?.sessionId,
      _meta: request.params?._meta,
      sendNotification: async (notification) => {
        if (abortController.signal.aborted)
          return;
        const notificationOptions = { relatedRequestId: request.id };
        if (relatedTaskId) {
          notificationOptions.relatedTask = { taskId: relatedTaskId };
        }
        await this.notification(notification, notificationOptions);
      },
      sendRequest: async (r2, resultSchema, options) => {
        if (abortController.signal.aborted) {
          throw new McpError(ErrorCode.ConnectionClosed, "Request was cancelled");
        }
        const requestOptions = { ...options, relatedRequestId: request.id };
        if (relatedTaskId && !requestOptions.relatedTask) {
          requestOptions.relatedTask = { taskId: relatedTaskId };
        }
        const effectiveTaskId = requestOptions.relatedTask?.taskId ?? relatedTaskId;
        if (effectiveTaskId && taskStore) {
          await taskStore.updateTaskStatus(effectiveTaskId, "input_required");
        }
        return await this.request(r2, resultSchema, requestOptions);
      },
      authInfo: extra?.authInfo,
      requestId: request.id,
      requestInfo: extra?.requestInfo,
      taskId: relatedTaskId,
      taskStore,
      taskRequestedTtl: taskCreationParams?.ttl,
      closeSSEStream: extra?.closeSSEStream,
      closeStandaloneSSEStream: extra?.closeStandaloneSSEStream
    };
    Promise.resolve().then(() => {
      if (taskCreationParams) {
        this.assertTaskHandlerCapability(request.method);
      }
    }).then(() => handler(request, fullExtra)).then(async (result) => {
      if (abortController.signal.aborted) {
        return;
      }
      const response = {
        result,
        jsonrpc: "2.0",
        id: request.id
      };
      if (relatedTaskId && this._taskMessageQueue) {
        await this._enqueueTaskMessage(relatedTaskId, {
          type: "response",
          message: response,
          timestamp: Date.now()
        }, capturedTransport?.sessionId);
      } else {
        await capturedTransport?.send(response);
      }
    }, async (error) => {
      if (abortController.signal.aborted) {
        return;
      }
      const errorResponse = {
        jsonrpc: "2.0",
        id: request.id,
        error: {
          code: Number.isSafeInteger(error["code"]) ? error["code"] : ErrorCode.InternalError,
          message: error.message ?? "Internal error",
          ...error["data"] !== void 0 && { data: error["data"] }
        }
      };
      if (relatedTaskId && this._taskMessageQueue) {
        await this._enqueueTaskMessage(relatedTaskId, {
          type: "error",
          message: errorResponse,
          timestamp: Date.now()
        }, capturedTransport?.sessionId);
      } else {
        await capturedTransport?.send(errorResponse);
      }
    }).catch((error) => this._onerror(new Error(`Failed to send response: ${error}`))).finally(() => {
      this._requestHandlerAbortControllers.delete(request.id);
    });
  }
  _onprogress(notification) {
    const { progressToken, ...params } = notification.params;
    const messageId = Number(progressToken);
    const handler = this._progressHandlers.get(messageId);
    if (!handler) {
      this._onerror(new Error(`Received a progress notification for an unknown token: ${JSON.stringify(notification)}`));
      return;
    }
    const responseHandler = this._responseHandlers.get(messageId);
    const timeoutInfo = this._timeoutInfo.get(messageId);
    if (timeoutInfo && responseHandler && timeoutInfo.resetTimeoutOnProgress) {
      try {
        this._resetTimeout(messageId);
      } catch (error) {
        this._responseHandlers.delete(messageId);
        this._progressHandlers.delete(messageId);
        this._cleanupTimeout(messageId);
        responseHandler(error);
        return;
      }
    }
    handler(params);
  }
  _onresponse(response) {
    const messageId = Number(response.id);
    const resolver = this._requestResolvers.get(messageId);
    if (resolver) {
      this._requestResolvers.delete(messageId);
      if (isJSONRPCResultResponse(response)) {
        resolver(response);
      } else {
        const error = new McpError(response.error.code, response.error.message, response.error.data);
        resolver(error);
      }
      return;
    }
    const handler = this._responseHandlers.get(messageId);
    if (handler === void 0) {
      this._onerror(new Error(`Received a response for an unknown message ID: ${JSON.stringify(response)}`));
      return;
    }
    this._responseHandlers.delete(messageId);
    this._cleanupTimeout(messageId);
    let isTaskResponse = false;
    if (isJSONRPCResultResponse(response) && response.result && typeof response.result === "object") {
      const result = response.result;
      if (result.task && typeof result.task === "object") {
        const task = result.task;
        if (typeof task.taskId === "string") {
          isTaskResponse = true;
          this._taskProgressTokens.set(task.taskId, messageId);
        }
      }
    }
    if (!isTaskResponse) {
      this._progressHandlers.delete(messageId);
    }
    if (isJSONRPCResultResponse(response)) {
      handler(response);
    } else {
      const error = McpError.fromError(response.error.code, response.error.message, response.error.data);
      handler(error);
    }
  }
  get transport() {
    return this._transport;
  }
  /**
   * Closes the connection.
   */
  async close() {
    await this._transport?.close();
  }
  /**
   * Sends a request and returns an AsyncGenerator that yields response messages.
   * The generator is guaranteed to end with either a 'result' or 'error' message.
   *
   * @example
   * ```typescript
   * const stream = protocol.requestStream(request, resultSchema, options);
   * for await (const message of stream) {
   *   switch (message.type) {
   *     case 'taskCreated':
   *       console.log('Task created:', message.task.taskId);
   *       break;
   *     case 'taskStatus':
   *       console.log('Task status:', message.task.status);
   *       break;
   *     case 'result':
   *       console.log('Final result:', message.result);
   *       break;
   *     case 'error':
   *       console.error('Error:', message.error);
   *       break;
   *   }
   * }
   * ```
   *
   * @experimental Use `client.experimental.tasks.requestStream()` to access this method.
   */
  async *requestStream(request, resultSchema, options) {
    const { task } = options ?? {};
    if (!task) {
      try {
        const result = await this.request(request, resultSchema, options);
        yield { type: "result", result };
      } catch (error) {
        yield {
          type: "error",
          error: error instanceof McpError ? error : new McpError(ErrorCode.InternalError, String(error))
        };
      }
      return;
    }
    let taskId;
    try {
      const createResult = await this.request(request, CreateTaskResultSchema, options);
      if (createResult.task) {
        taskId = createResult.task.taskId;
        yield { type: "taskCreated", task: createResult.task };
      } else {
        throw new McpError(ErrorCode.InternalError, "Task creation did not return a task");
      }
      while (true) {
        const task2 = await this.getTask({ taskId }, options);
        yield { type: "taskStatus", task: task2 };
        if (isTerminal(task2.status)) {
          if (task2.status === "completed") {
            const result = await this.getTaskResult({ taskId }, resultSchema, options);
            yield { type: "result", result };
          } else if (task2.status === "failed") {
            yield {
              type: "error",
              error: new McpError(ErrorCode.InternalError, `Task ${taskId} failed`)
            };
          } else if (task2.status === "cancelled") {
            yield {
              type: "error",
              error: new McpError(ErrorCode.InternalError, `Task ${taskId} was cancelled`)
            };
          }
          return;
        }
        if (task2.status === "input_required") {
          const result = await this.getTaskResult({ taskId }, resultSchema, options);
          yield { type: "result", result };
          return;
        }
        const pollInterval = task2.pollInterval ?? this._options?.defaultTaskPollInterval ?? 1e3;
        await new Promise((resolve2) => setTimeout(resolve2, pollInterval));
        options?.signal?.throwIfAborted();
      }
    } catch (error) {
      yield {
        type: "error",
        error: error instanceof McpError ? error : new McpError(ErrorCode.InternalError, String(error))
      };
    }
  }
  /**
   * Sends a request and waits for a response.
   *
   * Do not use this method to emit notifications! Use notification() instead.
   */
  request(request, resultSchema, options) {
    const { relatedRequestId, resumptionToken, onresumptiontoken, task, relatedTask } = options ?? {};
    return new Promise((resolve2, reject) => {
      const earlyReject = (error) => {
        reject(error);
      };
      if (!this._transport) {
        earlyReject(new Error("Not connected"));
        return;
      }
      if (this._options?.enforceStrictCapabilities === true) {
        try {
          this.assertCapabilityForMethod(request.method);
          if (task) {
            this.assertTaskCapability(request.method);
          }
        } catch (e) {
          earlyReject(e);
          return;
        }
      }
      options?.signal?.throwIfAborted();
      const messageId = this._requestMessageId++;
      const jsonrpcRequest = {
        ...request,
        jsonrpc: "2.0",
        id: messageId
      };
      if (options?.onprogress) {
        this._progressHandlers.set(messageId, options.onprogress);
        jsonrpcRequest.params = {
          ...request.params,
          _meta: {
            ...request.params?._meta || {},
            progressToken: messageId
          }
        };
      }
      if (task) {
        jsonrpcRequest.params = {
          ...jsonrpcRequest.params,
          task
        };
      }
      if (relatedTask) {
        jsonrpcRequest.params = {
          ...jsonrpcRequest.params,
          _meta: {
            ...jsonrpcRequest.params?._meta || {},
            [RELATED_TASK_META_KEY]: relatedTask
          }
        };
      }
      const cancel = (reason) => {
        this._responseHandlers.delete(messageId);
        this._progressHandlers.delete(messageId);
        this._cleanupTimeout(messageId);
        this._transport?.send({
          jsonrpc: "2.0",
          method: "notifications/cancelled",
          params: {
            requestId: messageId,
            reason: String(reason)
          }
        }, { relatedRequestId, resumptionToken, onresumptiontoken }).catch((error2) => this._onerror(new Error(`Failed to send cancellation: ${error2}`)));
        const error = reason instanceof McpError ? reason : new McpError(ErrorCode.RequestTimeout, String(reason));
        reject(error);
      };
      this._responseHandlers.set(messageId, (response) => {
        if (options?.signal?.aborted) {
          return;
        }
        if (response instanceof Error) {
          return reject(response);
        }
        try {
          const parseResult = safeParse(resultSchema, response.result);
          if (!parseResult.success) {
            reject(parseResult.error);
          } else {
            resolve2(parseResult.data);
          }
        } catch (error) {
          reject(error);
        }
      });
      options?.signal?.addEventListener("abort", () => {
        cancel(options?.signal?.reason);
      });
      const timeout = options?.timeout ?? DEFAULT_REQUEST_TIMEOUT_MSEC;
      const timeoutHandler = () => cancel(McpError.fromError(ErrorCode.RequestTimeout, "Request timed out", { timeout }));
      this._setupTimeout(messageId, timeout, options?.maxTotalTimeout, timeoutHandler, options?.resetTimeoutOnProgress ?? false);
      const relatedTaskId = relatedTask?.taskId;
      if (relatedTaskId) {
        const responseResolver = (response) => {
          const handler = this._responseHandlers.get(messageId);
          if (handler) {
            handler(response);
          } else {
            this._onerror(new Error(`Response handler missing for side-channeled request ${messageId}`));
          }
        };
        this._requestResolvers.set(messageId, responseResolver);
        this._enqueueTaskMessage(relatedTaskId, {
          type: "request",
          message: jsonrpcRequest,
          timestamp: Date.now()
        }).catch((error) => {
          this._cleanupTimeout(messageId);
          reject(error);
        });
      } else {
        this._transport.send(jsonrpcRequest, { relatedRequestId, resumptionToken, onresumptiontoken }).catch((error) => {
          this._cleanupTimeout(messageId);
          reject(error);
        });
      }
    });
  }
  /**
   * Gets the current status of a task.
   *
   * @experimental Use `client.experimental.tasks.getTask()` to access this method.
   */
  async getTask(params, options) {
    return this.request({ method: "tasks/get", params }, GetTaskResultSchema, options);
  }
  /**
   * Retrieves the result of a completed task.
   *
   * @experimental Use `client.experimental.tasks.getTaskResult()` to access this method.
   */
  async getTaskResult(params, resultSchema, options) {
    return this.request({ method: "tasks/result", params }, resultSchema, options);
  }
  /**
   * Lists tasks, optionally starting from a pagination cursor.
   *
   * @experimental Use `client.experimental.tasks.listTasks()` to access this method.
   */
  async listTasks(params, options) {
    return this.request({ method: "tasks/list", params }, ListTasksResultSchema, options);
  }
  /**
   * Cancels a specific task.
   *
   * @experimental Use `client.experimental.tasks.cancelTask()` to access this method.
   */
  async cancelTask(params, options) {
    return this.request({ method: "tasks/cancel", params }, CancelTaskResultSchema, options);
  }
  /**
   * Emits a notification, which is a one-way message that does not expect a response.
   */
  async notification(notification, options) {
    if (!this._transport) {
      throw new Error("Not connected");
    }
    this.assertNotificationCapability(notification.method);
    const relatedTaskId = options?.relatedTask?.taskId;
    if (relatedTaskId) {
      const jsonrpcNotification2 = {
        ...notification,
        jsonrpc: "2.0",
        params: {
          ...notification.params,
          _meta: {
            ...notification.params?._meta || {},
            [RELATED_TASK_META_KEY]: options.relatedTask
          }
        }
      };
      await this._enqueueTaskMessage(relatedTaskId, {
        type: "notification",
        message: jsonrpcNotification2,
        timestamp: Date.now()
      });
      return;
    }
    const debouncedMethods = this._options?.debouncedNotificationMethods ?? [];
    const canDebounce = debouncedMethods.includes(notification.method) && !notification.params && !options?.relatedRequestId && !options?.relatedTask;
    if (canDebounce) {
      if (this._pendingDebouncedNotifications.has(notification.method)) {
        return;
      }
      this._pendingDebouncedNotifications.add(notification.method);
      Promise.resolve().then(() => {
        this._pendingDebouncedNotifications.delete(notification.method);
        if (!this._transport) {
          return;
        }
        let jsonrpcNotification2 = {
          ...notification,
          jsonrpc: "2.0"
        };
        if (options?.relatedTask) {
          jsonrpcNotification2 = {
            ...jsonrpcNotification2,
            params: {
              ...jsonrpcNotification2.params,
              _meta: {
                ...jsonrpcNotification2.params?._meta || {},
                [RELATED_TASK_META_KEY]: options.relatedTask
              }
            }
          };
        }
        this._transport?.send(jsonrpcNotification2, options).catch((error) => this._onerror(error));
      });
      return;
    }
    let jsonrpcNotification = {
      ...notification,
      jsonrpc: "2.0"
    };
    if (options?.relatedTask) {
      jsonrpcNotification = {
        ...jsonrpcNotification,
        params: {
          ...jsonrpcNotification.params,
          _meta: {
            ...jsonrpcNotification.params?._meta || {},
            [RELATED_TASK_META_KEY]: options.relatedTask
          }
        }
      };
    }
    await this._transport.send(jsonrpcNotification, options);
  }
  /**
   * Registers a handler to invoke when this protocol object receives a request with the given method.
   *
   * Note that this will replace any previous request handler for the same method.
   */
  setRequestHandler(requestSchema, handler) {
    const method = getMethodLiteral(requestSchema);
    this.assertRequestHandlerCapability(method);
    this._requestHandlers.set(method, (request, extra) => {
      const parsed = parseWithCompat(requestSchema, request);
      return Promise.resolve(handler(parsed, extra));
    });
  }
  /**
   * Removes the request handler for the given method.
   */
  removeRequestHandler(method) {
    this._requestHandlers.delete(method);
  }
  /**
   * Asserts that a request handler has not already been set for the given method, in preparation for a new one being automatically installed.
   */
  assertCanSetRequestHandler(method) {
    if (this._requestHandlers.has(method)) {
      throw new Error(`A request handler for ${method} already exists, which would be overridden`);
    }
  }
  /**
   * Registers a handler to invoke when this protocol object receives a notification with the given method.
   *
   * Note that this will replace any previous notification handler for the same method.
   */
  setNotificationHandler(notificationSchema, handler) {
    const method = getMethodLiteral(notificationSchema);
    this._notificationHandlers.set(method, (notification) => {
      const parsed = parseWithCompat(notificationSchema, notification);
      return Promise.resolve(handler(parsed));
    });
  }
  /**
   * Removes the notification handler for the given method.
   */
  removeNotificationHandler(method) {
    this._notificationHandlers.delete(method);
  }
  /**
   * Cleans up the progress handler associated with a task.
   * This should be called when a task reaches a terminal status.
   */
  _cleanupTaskProgressHandler(taskId) {
    const progressToken = this._taskProgressTokens.get(taskId);
    if (progressToken !== void 0) {
      this._progressHandlers.delete(progressToken);
      this._taskProgressTokens.delete(taskId);
    }
  }
  /**
   * Enqueues a task-related message for side-channel delivery via tasks/result.
   * @param taskId The task ID to associate the message with
   * @param message The message to enqueue
   * @param sessionId Optional session ID for binding the operation to a specific session
   * @throws Error if taskStore is not configured or if enqueue fails (e.g., queue overflow)
   *
   * Note: If enqueue fails, it's the TaskMessageQueue implementation's responsibility to handle
   * the error appropriately (e.g., by failing the task, logging, etc.). The Protocol layer
   * simply propagates the error.
   */
  async _enqueueTaskMessage(taskId, message, sessionId) {
    if (!this._taskStore || !this._taskMessageQueue) {
      throw new Error("Cannot enqueue task message: taskStore and taskMessageQueue are not configured");
    }
    const maxQueueSize = this._options?.maxTaskQueueSize;
    await this._taskMessageQueue.enqueue(taskId, message, sessionId, maxQueueSize);
  }
  /**
   * Clears the message queue for a task and rejects any pending request resolvers.
   * @param taskId The task ID whose queue should be cleared
   * @param sessionId Optional session ID for binding the operation to a specific session
   */
  async _clearTaskQueue(taskId, sessionId) {
    if (this._taskMessageQueue) {
      const messages = await this._taskMessageQueue.dequeueAll(taskId, sessionId);
      for (const message of messages) {
        if (message.type === "request" && isJSONRPCRequest(message.message)) {
          const requestId = message.message.id;
          const resolver = this._requestResolvers.get(requestId);
          if (resolver) {
            resolver(new McpError(ErrorCode.InternalError, "Task cancelled or completed"));
            this._requestResolvers.delete(requestId);
          } else {
            this._onerror(new Error(`Resolver missing for request ${requestId} during task ${taskId} cleanup`));
          }
        }
      }
    }
  }
  /**
   * Waits for a task update (new messages or status change) with abort signal support.
   * Uses polling to check for updates at the task's configured poll interval.
   * @param taskId The task ID to wait for
   * @param signal Abort signal to cancel the wait
   * @returns Promise that resolves when an update occurs or rejects if aborted
   */
  async _waitForTaskUpdate(taskId, signal) {
    let interval = this._options?.defaultTaskPollInterval ?? 1e3;
    try {
      const task = await this._taskStore?.getTask(taskId);
      if (task?.pollInterval) {
        interval = task.pollInterval;
      }
    } catch {
    }
    return new Promise((resolve2, reject) => {
      if (signal.aborted) {
        reject(new McpError(ErrorCode.InvalidRequest, "Request cancelled"));
        return;
      }
      const timeoutId = setTimeout(resolve2, interval);
      signal.addEventListener("abort", () => {
        clearTimeout(timeoutId);
        reject(new McpError(ErrorCode.InvalidRequest, "Request cancelled"));
      }, { once: true });
    });
  }
  requestTaskStore(request, sessionId) {
    const taskStore = this._taskStore;
    if (!taskStore) {
      throw new Error("No task store configured");
    }
    return {
      createTask: async (taskParams) => {
        if (!request) {
          throw new Error("No request provided");
        }
        return await taskStore.createTask(taskParams, request.id, {
          method: request.method,
          params: request.params
        }, sessionId);
      },
      getTask: async (taskId) => {
        const task = await taskStore.getTask(taskId, sessionId);
        if (!task) {
          throw new McpError(ErrorCode.InvalidParams, "Failed to retrieve task: Task not found");
        }
        return task;
      },
      storeTaskResult: async (taskId, status, result) => {
        await taskStore.storeTaskResult(taskId, status, result, sessionId);
        const task = await taskStore.getTask(taskId, sessionId);
        if (task) {
          const notification = TaskStatusNotificationSchema.parse({
            method: "notifications/tasks/status",
            params: task
          });
          await this.notification(notification);
          if (isTerminal(task.status)) {
            this._cleanupTaskProgressHandler(taskId);
          }
        }
      },
      getTaskResult: (taskId) => {
        return taskStore.getTaskResult(taskId, sessionId);
      },
      updateTaskStatus: async (taskId, status, statusMessage) => {
        const task = await taskStore.getTask(taskId, sessionId);
        if (!task) {
          throw new McpError(ErrorCode.InvalidParams, `Task "${taskId}" not found - it may have been cleaned up`);
        }
        if (isTerminal(task.status)) {
          throw new McpError(ErrorCode.InvalidParams, `Cannot update task "${taskId}" from terminal status "${task.status}" to "${status}". Terminal states (completed, failed, cancelled) cannot transition to other states.`);
        }
        await taskStore.updateTaskStatus(taskId, status, statusMessage, sessionId);
        const updatedTask = await taskStore.getTask(taskId, sessionId);
        if (updatedTask) {
          const notification = TaskStatusNotificationSchema.parse({
            method: "notifications/tasks/status",
            params: updatedTask
          });
          await this.notification(notification);
          if (isTerminal(updatedTask.status)) {
            this._cleanupTaskProgressHandler(taskId);
          }
        }
      },
      listTasks: (cursor) => {
        return taskStore.listTasks(cursor, sessionId);
      }
    };
  }
}
function isPlainObject(value) {
  return value !== null && typeof value === "object" && !Array.isArray(value);
}
function mergeCapabilities(base, additional) {
  const result = { ...base };
  for (const key in additional) {
    const k2 = key;
    const addValue = additional[k2];
    if (addValue === void 0)
      continue;
    const baseValue = result[k2];
    if (isPlainObject(baseValue) && isPlainObject(addValue)) {
      result[k2] = { ...baseValue, ...addValue };
    } else {
      result[k2] = addValue;
    }
  }
  return result;
}
var ZI = Object.defineProperty;
var s = (r2, i) => {
  for (var o in i) ZI(r2, o, { get: i[o], enumerable: true, configurable: true, set: (t) => i[o] = () => t });
};
var g = {};
s(g, { xor: () => gI, xid: () => Al$1, void: () => iI, uuidv7: () => Pl$1, uuidv6: () => zl$1, uuidv4: () => Sl$1, uuid: () => Ol$1, util: () => k$3, url: () => jl$1, uppercase: () => Yr$1, unknown: () => Nr$1, union: () => lv$1, undefined: () => rI, ulid: () => Xl$1, uint64: () => pl$1, uint32: () => yl$1, tuple: () => Fg$1, trim: () => Hr$1, treeifyError: () => Av$1, transform: () => cv$1, toUpperCase: () => mr$1, toLowerCase: () => Mr$1, toJSONSchema: () => Fi$1, templateLiteral: () => SI, symbol: () => sl$1, superRefine: () => le$2, success: () => wI, stringbool: () => WI, stringFormat: () => ml$1, string: () => Ri$1, strictObject: () => $I, startsWith: () => Tr$1, slugify: () => Rr$1, size: () => Dr$1, setErrorMap: () => Fc$1, set: () => _I, safeParseAsync: () => Ig$1, safeParse: () => lg$1, safeEncodeAsync: () => wg$1, safeEncode: () => Dg$1, safeDecodeAsync: () => Ng$1, safeDecode: () => kg$1, registry: () => gi$1, regexes: () => x$1, regex: () => Vr$1, refine: () => ee$2, record: () => qg$1, readonly: () => ve$1, property: () => Ki$1, promise: () => zI, prettifyError: () => Vv$1, preprocess: () => AI, prefault: () => hg$1, positive: () => Wi$1, pipe: () => Gn$1, partialRecord: () => lI, parseAsync: () => eg$1, parse: () => gg$1, overwrite: () => d, optional: () => Ln$1, object: () => tI, number: () => Sg$1, nullish: () => kI, nullable: () => En$1, null: () => Lg$1, normalize: () => Br$1, nonpositive: () => Ai$1, nonoptional: () => ag$1, nonnegative: () => Vi$1, never: () => ev$1, negative: () => Xi$1, nativeEnum: () => bI, nanoid: () => El$1, nan: () => NI, multipleOf: () => ur, minSize: () => a, minLength: () => nr, mime: () => qr$1, meta: () => EI, maxSize: () => gr$1, maxLength: () => kr$1, map: () => cI, mac: () => Yl$1, lte: () => m$2, lt: () => y$1, lowercase: () => Kr$1, looseRecord: () => II, looseObject: () => uI, locales: () => Sn$1, literal: () => UI, length: () => wr$1, lazy: () => $e$1, ksuid: () => Vl$1, keyof: () => oI, jwt: () => Ml$1, json: () => XI, iso: () => dr, ipv6: () => Ql$1, ipv4: () => Kl$1, intersection: () => Qg$1, int64: () => al$1, int32: () => fl$1, int: () => xi$1, instanceof: () => GI, includes: () => Qr$1, httpUrl: () => Jl$1, hostname: () => Rl$1, hex: () => xl$1, hash: () => Zl$1, guid: () => Nl$1, gte: () => Q, gt: () => h$1, globalRegistry: () => V, getErrorMap: () => qc$1, function: () => PI, fromJSONSchema: () => KI, formatError: () => ln$1, float64: () => Cl$1, float32: () => dl$1, flattenError: () => en$1, file: () => DI, exactOptional: () => Zg$1, enum: () => Iv$1, endsWith: () => Fr$1, encodeAsync: () => bg$1, encode: () => cg$1, emoji: () => Ll$1, email: () => wl$1, e164: () => Hl$1, discriminatedUnion: () => eI, describe: () => LI, decodeAsync: () => Ug$1, decode: () => _g$1, date: () => vI, custom: () => JI, cuid2: () => Wl$1, cuid: () => Gl$1, core: () => ir, config: () => A$1, coerce: () => ce$1, codec: () => OI, clone: () => Y$2, cidrv6: () => Fl$1, cidrv4: () => Tl$1, check: () => jI, catch: () => re$1, boolean: () => zg$1, bigint: () => hl$1, base64url: () => Bl$1, base64: () => ql$1, array: () => An$1, any: () => nI, _function: () => PI, _default: () => fg$1, _ZodString: () => Zi$1, ZodXor: () => Vg$1, ZodXID: () => pi$1, ZodVoid: () => Xg$1, ZodUnknown: () => Gg$1, ZodUnion: () => Kn$1, ZodUndefined: () => jg$1, ZodUUID: () => p$2, ZodURL: () => Wn$1, ZodULID: () => ai$1, ZodType: () => P$1, ZodTuple: () => Tg$1, ZodTransform: () => Rg$1, ZodTemplateLiteral: () => oe, ZodSymbol: () => Pg$1, ZodSuccess: () => pg$1, ZodStringFormat: () => G$1, ZodString: () => fr$1, ZodSet: () => Hg$1, ZodRecord: () => Yn$1, ZodRealError: () => H$2, ZodReadonly: () => ie$1, ZodPromise: () => ue$2, ZodPrefault: () => yg$1, ZodPipe: () => Uv$1, ZodOptional: () => _v$1, ZodObject: () => Vn$1, ZodNumberFormat: () => Or$1, ZodNumber: () => hr$1, ZodNullable: () => dg$1, ZodNull: () => Jg$1, ZodNonOptional: () => bv$1, ZodNever: () => Wg$1, ZodNanoID: () => fi$1, ZodNaN: () => ne, ZodMap: () => Bg$1, ZodMAC: () => Og$1, ZodLiteral: () => Mg$1, ZodLazy: () => te, ZodKSUID: () => si, ZodJWT: () => uv$1, ZodIssueCode: () => Tc$1, ZodIntersection: () => Yg$1, ZodISOTime: () => Mi$1, ZodISODuration: () => mi$1, ZodISODateTime: () => Bi$1, ZodISODate: () => Hi$1, ZodIPv6: () => nv$1, ZodIPv4: () => rv$1, ZodGUID: () => Jn$1, ZodFunction: () => ge, ZodFirstPartyTypeKind: () => Ie$2, ZodFile: () => mg$1, ZodExactOptional: () => xg$1, ZodError: () => Yc$1, ZodEnum: () => Cr$1, ZodEmoji: () => Ci$1, ZodEmail: () => di$1, ZodE164: () => $v$1, ZodDiscriminatedUnion: () => Kg$1, ZodDefault: () => Cg$1, ZodDate: () => Xn$1, ZodCustomStringFormat: () => yr, ZodCustom: () => Qn$1, ZodCodec: () => Dv$1, ZodCatch: () => sg$1, ZodCUID2: () => hi$1, ZodCUID: () => yi$1, ZodCIDRv6: () => vv$1, ZodCIDRv4: () => iv$1, ZodBoolean: () => ar, ZodBigIntFormat: () => gv$1, ZodBigInt: () => pr$1, ZodBase64URL: () => tv$1, ZodBase64: () => ov$1, ZodArray: () => Ag$1, ZodAny: () => Eg$1, TimePrecision: () => F$, NEVER: () => Ov$1, $output: () => A$, $input: () => V$, $brand: () => Sv$1 });
var ir = {};
s(ir, { version: () => Eo$1, util: () => k$3, treeifyError: () => Av$1, toJSONSchema: () => Fi$1, toDotPath: () => Me$2, safeParseAsync: () => Yv$1, safeParse: () => Kv$1, safeEncodeAsync: () => B4, safeEncode: () => F4, safeDecodeAsync: () => H4, safeDecode: () => q4, registry: () => gi$1, regexes: () => x$1, process: () => L$1, prettifyError: () => Vv$1, parseAsync: () => Hn$1, parse: () => Bn$1, meta: () => ku$1, locales: () => Sn$1, isValidJWT: () => $l$1, isValidBase64URL: () => tl$1, isValidBase64: () => ho$1, initializeContext: () => er, globalRegistry: () => V, globalConfig: () => rn$1, formatError: () => ln$1, flattenError: () => en$1, finalize: () => Ir$1, extractDefs: () => lr, encodeAsync: () => Q4, encode: () => K4, describe: () => Du$1, decodeAsync: () => T4, decode: () => Y4, createToJSONSchemaMethod: () => Nu$1, createStandardJSONSchemaMethod: () => Zr$1, config: () => A$1, clone: () => Y$2, _xor: () => lc$1, _xid: () => Ni$1, _void: () => uu$1, _uuidv7: () => _i$1, _uuidv6: () => ci$1, _uuidv4: () => Ii$1, _uuid: () => li$1, _url: () => Pn$1, _uppercase: () => Yr$1, _unknown: () => tu$1, _union: () => ec$1, _undefined: () => iu$1, _ulid: () => wi$1, _uint64: () => ru$1, _uint32: () => f$, _tuple: () => _c$1, _trim: () => Hr$1, _transform: () => Oc$1, _toUpperCase: () => mr$1, _toLowerCase: () => Mr$1, _templateLiteral: () => Wc$1, _symbol: () => nu$1, _superRefine: () => Uu$1, _success: () => Jc$1, _stringbool: () => wu$1, _stringFormat: () => xr$1, _string: () => Y$, _startsWith: () => Tr$1, _slugify: () => Rr$1, _size: () => Dr$1, _set: () => Dc$1, _safeParseAsync: () => Wr$1, _safeParse: () => Gr$1, _safeEncodeAsync: () => Cn$1, _safeEncode: () => Zn$1, _safeDecodeAsync: () => fn$1, _safeDecode: () => dn$1, _regex: () => Vr$1, _refine: () => bu$1, _record: () => bc$1, _readonly: () => Gc$1, _property: () => Ki$1, _promise: () => Ac$1, _positive: () => Wi$1, _pipe: () => Ec$1, _parseAsync: () => Er$1, _parse: () => Lr$1, _overwrite: () => d, _optional: () => Sc$1, _number: () => m$, _nullable: () => zc$1, _null: () => vu$1, _normalize: () => Br$1, _nonpositive: () => Ai$1, _nonoptional: () => jc$1, _nonnegative: () => Vi$1, _never: () => $u$1, _negative: () => Xi$1, _nativeEnum: () => wc$1, _nanoid: () => Ui$1, _nan: () => lu$1, _multipleOf: () => ur, _minSize: () => a, _minLength: () => nr, _min: () => Q, _mime: () => qr$1, _maxSize: () => gr$1, _maxLength: () => kr$1, _max: () => m$2, _map: () => Uc$1, _mac: () => T$, _lte: () => m$2, _lt: () => y$1, _lowercase: () => Kr$1, _literal: () => Nc$1, _length: () => wr$1, _lazy: () => Xc$1, _ksuid: () => Oi$1, _jwt: () => Gi$1, _isoTime: () => H$, _isoDuration: () => M$, _isoDateTime: () => q$, _isoDate: () => B$, _ipv6: () => zi$1, _ipv4: () => Si$1, _intersection: () => cc$1, _int64: () => s$, _int32: () => C$, _int: () => x$, _includes: () => Qr$1, _guid: () => zn$1, _gte: () => Q, _gt: () => h$1, _float64: () => d$, _float32: () => Z$, _file: () => cu$1, _enum: () => kc$1, _endsWith: () => Fr$1, _encodeAsync: () => Rn$1, _encode: () => Mn$1, _emoji: () => bi$1, _email: () => ei$1, _e164: () => Ei$1, _discriminatedUnion: () => Ic$1, _default: () => Pc$1, _decodeAsync: () => xn$1, _decode: () => mn$1, _date: () => gu$1, _custom: () => _u$1, _cuid2: () => ki$1, _cuid: () => Di$1, _coercedString: () => Q$, _coercedNumber: () => R$, _coercedDate: () => eu$1, _coercedBoolean: () => h$, _coercedBigint: () => p$, _cidrv6: () => ji$1, _cidrv4: () => Pi$1, _check: () => Ul$1, _catch: () => Lc$1, _boolean: () => y$, _bigint: () => a$, _base64url: () => Li$1, _base64: () => Ji$1, _array: () => Iu$1, _any: () => ou$1, TimePrecision: () => F$, NEVER: () => Ov$1, JSONSchemaGenerator: () => vg$1, JSONSchema: () => Dl$1, Doc: () => pn$1, $output: () => A$, $input: () => V$, $constructor: () => I, $brand: () => Sv$1, $ZodXor: () => bt, $ZodXID: () => qo$1, $ZodVoid: () => lt$1, $ZodUnknown: () => gt$1, $ZodUnion: () => Un$1, $ZodUndefined: () => tt$1, $ZodUUID: () => Xo$1, $ZodURL: () => Vo$1, $ZodULID: () => Fo$1, $ZodType: () => z$1, $ZodTuple: () => $i$1, $ZodTransform: () => Pt$1, $ZodTemplateLiteral: () => Yt$1, $ZodSymbol: () => ot$1, $ZodSuccess: () => Wt$1, $ZodStringFormat: () => E, $ZodString: () => Ur$1, $ZodSet: () => Nt$1, $ZodRegistry: () => K$, $ZodRecord: () => kt$1, $ZodRealError: () => B$3, $ZodReadonly: () => Kt$1, $ZodPromise: () => Tt$1, $ZodPrefault: () => Et$1, $ZodPipe: () => Vt, $ZodOptional: () => ui, $ZodObjectJIT: () => _t, $ZodObject: () => el$1, $ZodNumberFormat: () => it$1, $ZodNumber: () => oi, $ZodNullable: () => Jt, $ZodNull: () => $t$1, $ZodNonOptional: () => Gt, $ZodNever: () => et$1, $ZodNanoID: () => Yo$1, $ZodNaN: () => At$1, $ZodMap: () => wt$1, $ZodMAC: () => Co$1, $ZodLiteral: () => St$1, $ZodLazy: () => Ft$1, $ZodKSUID: () => Bo$1, $ZodJWT: () => rt$1, $ZodIntersection: () => Dt$1, $ZodISOTime: () => mo, $ZodISODuration: () => Ro$1, $ZodISODateTime: () => Ho$1, $ZodISODate: () => Mo$1, $ZodIPv6: () => Zo$1, $ZodIPv4: () => xo$1, $ZodGUID: () => Wo$1, $ZodFunction: () => Qt$1, $ZodFile: () => zt$1, $ZodExactOptional: () => jt$1, $ZodError: () => gn$1, $ZodEnum: () => Ot$1, $ZodEncodeError: () => cr, $ZodEmoji: () => Ko$1, $ZodEmail: () => Ao$1, $ZodE164: () => so, $ZodDiscriminatedUnion: () => Ut$1, $ZodDefault: () => Lt$1, $ZodDate: () => It$1, $ZodCustomStringFormat: () => nt$1, $ZodCustom: () => qt$1, $ZodCodec: () => Dn$1, $ZodCheckUpperCase: () => Oo$1, $ZodCheckStringFormat: () => Xr$1, $ZodCheckStartsWith: () => zo$1, $ZodCheckSizeEquals: () => bo$1, $ZodCheckRegex: () => wo$1, $ZodCheckProperty: () => jo$1, $ZodCheckOverwrite: () => Lo$1, $ZodCheckNumberFormat: () => lo, $ZodCheckMultipleOf: () => eo$1, $ZodCheckMinSize: () => _o$1, $ZodCheckMinLength: () => Do$1, $ZodCheckMimeType: () => Jo$1, $ZodCheckMaxSize: () => co, $ZodCheckMaxLength: () => Uo$1, $ZodCheckLowerCase: () => No$1, $ZodCheckLessThan: () => hn$1, $ZodCheckLengthEquals: () => ko$1, $ZodCheckIncludes: () => So$1, $ZodCheckGreaterThan: () => an$1, $ZodCheckEndsWith: () => Po$1, $ZodCheckBigIntFormat: () => Io$1, $ZodCheck: () => W$1, $ZodCatch: () => Xt$1, $ZodCUID2: () => To$1, $ZodCUID: () => Qo$1, $ZodCIDRv6: () => yo$1, $ZodCIDRv4: () => fo, $ZodBoolean: () => bn$1, $ZodBigIntFormat: () => vt$1, $ZodBigInt: () => ti$1, $ZodBase64URL: () => po, $ZodBase64: () => ao, $ZodAsyncError: () => f, $ZodArray: () => ct, $ZodAny: () => ut });
var Ov$1 = Object.freeze({ status: "aborted" });
function I(r2, i, o) {
  function t(u2, l) {
    if (!u2._zod) Object.defineProperty(u2, "_zod", { value: { def: l, constr: $2, traits: /* @__PURE__ */ new Set() }, enumerable: false });
    if (u2._zod.traits.has(r2)) return;
    u2._zod.traits.add(r2), i(u2, l);
    let e = $2.prototype, c = Object.keys(e);
    for (let b = 0; b < c.length; b++) {
      let N2 = c[b];
      if (!(N2 in u2)) u2[N2] = e[N2].bind(u2);
    }
  }
  let n = o?.Parent ?? Object;
  class v extends n {
  }
  Object.defineProperty(v, "name", { value: r2 });
  function $2(u2) {
    var l;
    let e = o?.Parent ? new v() : this;
    t(e, u2), (l = e._zod).deferred ?? (l.deferred = []);
    for (let c of e._zod.deferred) c();
    return e;
  }
  return Object.defineProperty($2, "init", { value: t }), Object.defineProperty($2, Symbol.hasInstance, { value: (u2) => {
    if (o?.Parent && u2 instanceof o.Parent) return true;
    return u2?._zod?.traits?.has(r2);
  } }), Object.defineProperty($2, "name", { value: r2 }), $2;
}
var Sv$1 = /* @__PURE__ */ Symbol("zod_brand");
class f extends Error {
  constructor() {
    super("Encountered Promise during synchronous parse. Use .parseAsync() instead.");
  }
}
class cr extends Error {
  constructor(r2) {
    super(`Encountered unidirectional transform during encode: ${r2}`);
    this.name = "ZodEncodeError";
  }
}
var rn$1 = {};
function A$1(r2) {
  if (r2) Object.assign(rn$1, r2);
  return rn$1;
}
var k$3 = {};
s(k$3, { unwrapMessage: () => nn$1, uint8ArrayToHex: () => A4, uint8ArrayToBase64url: () => W4, uint8ArrayToBase64: () => qe, stringifyPrimitive: () => U$1, slugify: () => jv$1, shallowClone: () => Lv$1, safeExtend: () => P4, required: () => L4, randomString: () => D4, propertyKeyTypes: () => tn$1, promiseAllObject: () => U4, primitiveTypes: () => Ev$1, prefixIssues: () => M$1, pick: () => O4, partial: () => J4, parsedType: () => D$2, optionalKeys: () => Gv$1, omit: () => S4, objectClone: () => c4, numKeys: () => k4, nullish: () => vr$1, normalizeParams: () => w$1, mergeDefs: () => rr, merge: () => j4, jsonStringifyReplacer: () => Pr$1, joinValues: () => _$1, issue: () => Jr$1, isPlainObject: () => tr, isObject: () => _r, hexToUint8Array: () => X4, getSizableOrigin: () => $n$1, getParsedType: () => w4, getLengthableOrigin: () => un$1, getEnumValues: () => vn$1, getElementAtPath: () => b4, floatSafeRemainder: () => Pv$1, finalizeIssue: () => q, extend: () => z4, escapeRegex: () => R, esc: () => Fn$1, defineLazy: () => j, createTransparentProxy: () => N4, cloneDef: () => _4, clone: () => Y$2, cleanRegex: () => on$1, cleanEnum: () => E4, captureStackTrace: () => qn$1, cached: () => jr$1, base64urlToUint8Array: () => G4, base64ToUint8Array: () => Fe$1, assignProp: () => or, assertNotEqual: () => g4, assertNever: () => l4, assertIs: () => e4, assertEqual: () => u4, assert: () => I4, allowsEval: () => Jv$1, aborted: () => $r$1, NUMBER_FORMAT_RANGES: () => Wv$1, Class: () => Be, BIGINT_FORMAT_RANGES: () => Xv$1 });
function u4(r2) {
  return r2;
}
function g4(r2) {
  return r2;
}
function e4(r2) {
}
function l4(r2) {
  throw Error("Unexpected value in exhaustive check");
}
function I4(r2) {
}
function vn$1(r2) {
  let i = Object.values(r2).filter((t) => typeof t === "number");
  return Object.entries(r2).filter(([t, n]) => i.indexOf(+t) === -1).map(([t, n]) => n);
}
function _$1(r2, i = "|") {
  return r2.map((o) => U$1(o)).join(i);
}
function Pr$1(r2, i) {
  if (typeof i === "bigint") return i.toString();
  return i;
}
function jr$1(r2) {
  return { get value() {
    {
      let o = r2();
      return Object.defineProperty(this, "value", { value: o }), o;
    }
  } };
}
function vr$1(r2) {
  return r2 === null || r2 === void 0;
}
function on$1(r2) {
  let i = r2.startsWith("^") ? 1 : 0, o = r2.endsWith("$") ? r2.length - 1 : r2.length;
  return r2.slice(i, o);
}
function Pv$1(r2, i) {
  let o = (r2.toString().split(".")[1] || "").length, t = i.toString(), n = (t.split(".")[1] || "").length;
  if (n === 0 && /\d?e-\d?/.test(t)) {
    let l = t.match(/\d?e-(\d?)/);
    if (l?.[1]) n = Number.parseInt(l[1]);
  }
  let v = o > n ? o : n, $2 = Number.parseInt(r2.toFixed(v).replace(".", "")), u2 = Number.parseInt(i.toFixed(v).replace(".", ""));
  return $2 % u2 / 10 ** v;
}
var Te$2 = /* @__PURE__ */ Symbol("evaluating");
function j(r2, i, o) {
  let t = void 0;
  Object.defineProperty(r2, i, { get() {
    if (t === Te$2) return;
    if (t === void 0) t = Te$2, t = o();
    return t;
  }, set(n) {
    Object.defineProperty(r2, i, { value: n });
  }, configurable: true });
}
function c4(r2) {
  return Object.create(Object.getPrototypeOf(r2), Object.getOwnPropertyDescriptors(r2));
}
function or(r2, i, o) {
  Object.defineProperty(r2, i, { value: o, writable: true, enumerable: true, configurable: true });
}
function rr(...r2) {
  let i = {};
  for (let o of r2) {
    let t = Object.getOwnPropertyDescriptors(o);
    Object.assign(i, t);
  }
  return Object.defineProperties({}, i);
}
function _4(r2) {
  return rr(r2._zod.def);
}
function b4(r2, i) {
  if (!i) return r2;
  return i.reduce((o, t) => o?.[t], r2);
}
function U4(r2) {
  let i = Object.keys(r2), o = i.map((t) => r2[t]);
  return Promise.all(o).then((t) => {
    let n = {};
    for (let v = 0; v < i.length; v++) n[i[v]] = t[v];
    return n;
  });
}
function D4(r2 = 10) {
  let o = "";
  for (let t = 0; t < r2; t++) o += "abcdefghijklmnopqrstuvwxyz"[Math.floor(Math.random() * 26)];
  return o;
}
function Fn$1(r2) {
  return JSON.stringify(r2);
}
function jv$1(r2) {
  return r2.toLowerCase().trim().replace(/[^\w\s-]/g, "").replace(/[\s_-]+/g, "-").replace(/^-+|-+$/g, "");
}
var qn$1 = "captureStackTrace" in Error ? Error.captureStackTrace : (...r2) => {
};
function _r(r2) {
  return typeof r2 === "object" && r2 !== null && !Array.isArray(r2);
}
var Jv$1 = jr$1(() => {
  if (typeof navigator < "u" && navigator?.userAgent?.includes("Cloudflare")) return false;
  try {
    return new Function(""), true;
  } catch (r2) {
    return false;
  }
});
function tr(r2) {
  if (_r(r2) === false) return false;
  let i = r2.constructor;
  if (i === void 0) return true;
  if (typeof i !== "function") return true;
  let o = i.prototype;
  if (_r(o) === false) return false;
  if (Object.prototype.hasOwnProperty.call(o, "isPrototypeOf") === false) return false;
  return true;
}
function Lv$1(r2) {
  if (tr(r2)) return { ...r2 };
  if (Array.isArray(r2)) return [...r2];
  return r2;
}
function k4(r2) {
  let i = 0;
  for (let o in r2) if (Object.prototype.hasOwnProperty.call(r2, o)) i++;
  return i;
}
var w4 = (r2) => {
  let i = typeof r2;
  switch (i) {
    case "undefined":
      return "undefined";
    case "string":
      return "string";
    case "number":
      return Number.isNaN(r2) ? "nan" : "number";
    case "boolean":
      return "boolean";
    case "function":
      return "function";
    case "bigint":
      return "bigint";
    case "symbol":
      return "symbol";
    case "object":
      if (Array.isArray(r2)) return "array";
      if (r2 === null) return "null";
      if (r2.then && typeof r2.then === "function" && r2.catch && typeof r2.catch === "function") return "promise";
      if (typeof Map < "u" && r2 instanceof Map) return "map";
      if (typeof Set < "u" && r2 instanceof Set) return "set";
      if (typeof Date < "u" && r2 instanceof Date) return "date";
      if (typeof File < "u" && r2 instanceof File) return "file";
      return "object";
    default:
      throw Error(`Unknown data type: ${i}`);
  }
}, tn$1 = /* @__PURE__ */ new Set(["string", "number", "symbol"]), Ev$1 = /* @__PURE__ */ new Set(["string", "number", "bigint", "boolean", "symbol", "undefined"]);
function R(r2) {
  return r2.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
}
function Y$2(r2, i, o) {
  let t = new r2._zod.constr(i ?? r2._zod.def);
  if (!i || o?.parent) t._zod.parent = r2;
  return t;
}
function w$1(r2) {
  let i = r2;
  if (!i) return {};
  if (typeof i === "string") return { error: () => i };
  if (i?.message !== void 0) {
    if (i?.error !== void 0) throw Error("Cannot specify both `message` and `error` params");
    i.error = i.message;
  }
  if (delete i.message, typeof i.error === "string") return { ...i, error: () => i.error };
  return i;
}
function N4(r2) {
  let i;
  return new Proxy({}, { get(o, t, n) {
    return i ?? (i = r2()), Reflect.get(i, t, n);
  }, set(o, t, n, v) {
    return i ?? (i = r2()), Reflect.set(i, t, n, v);
  }, has(o, t) {
    return i ?? (i = r2()), Reflect.has(i, t);
  }, deleteProperty(o, t) {
    return i ?? (i = r2()), Reflect.deleteProperty(i, t);
  }, ownKeys(o) {
    return i ?? (i = r2()), Reflect.ownKeys(i);
  }, getOwnPropertyDescriptor(o, t) {
    return i ?? (i = r2()), Reflect.getOwnPropertyDescriptor(i, t);
  }, defineProperty(o, t, n) {
    return i ?? (i = r2()), Reflect.defineProperty(i, t, n);
  } });
}
function U$1(r2) {
  if (typeof r2 === "bigint") return r2.toString() + "n";
  if (typeof r2 === "string") return `"${r2}"`;
  return `${r2}`;
}
function Gv$1(r2) {
  return Object.keys(r2).filter((i) => {
    return r2[i]._zod.optin === "optional" && r2[i]._zod.optout === "optional";
  });
}
var Wv$1 = { safeint: [Number.MIN_SAFE_INTEGER, Number.MAX_SAFE_INTEGER], int32: [-2147483648, 2147483647], uint32: [0, 4294967295], float32: [-34028234663852886e22, 34028234663852886e22], float64: [-Number.MAX_VALUE, Number.MAX_VALUE] }, Xv$1 = { int64: [BigInt("-9223372036854775808"), BigInt("9223372036854775807")], uint64: [BigInt(0), BigInt("18446744073709551615")] };
function O4(r2, i) {
  let o = r2._zod.def, t = o.checks;
  if (t && t.length > 0) throw Error(".pick() cannot be used on object schemas containing refinements");
  let v = rr(r2._zod.def, { get shape() {
    let $2 = {};
    for (let u2 in i) {
      if (!(u2 in o.shape)) throw Error(`Unrecognized key: "${u2}"`);
      if (!i[u2]) continue;
      $2[u2] = o.shape[u2];
    }
    return or(this, "shape", $2), $2;
  }, checks: [] });
  return Y$2(r2, v);
}
function S4(r2, i) {
  let o = r2._zod.def, t = o.checks;
  if (t && t.length > 0) throw Error(".omit() cannot be used on object schemas containing refinements");
  let v = rr(r2._zod.def, { get shape() {
    let $2 = { ...r2._zod.def.shape };
    for (let u2 in i) {
      if (!(u2 in o.shape)) throw Error(`Unrecognized key: "${u2}"`);
      if (!i[u2]) continue;
      delete $2[u2];
    }
    return or(this, "shape", $2), $2;
  }, checks: [] });
  return Y$2(r2, v);
}
function z4(r2, i) {
  if (!tr(i)) throw Error("Invalid input to extend: expected a plain object");
  let o = r2._zod.def.checks;
  if (o && o.length > 0) {
    let v = r2._zod.def.shape;
    for (let $2 in i) if (Object.getOwnPropertyDescriptor(v, $2) !== void 0) throw Error("Cannot overwrite keys on object schemas containing refinements. Use `.safeExtend()` instead.");
  }
  let n = rr(r2._zod.def, { get shape() {
    let v = { ...r2._zod.def.shape, ...i };
    return or(this, "shape", v), v;
  } });
  return Y$2(r2, n);
}
function P4(r2, i) {
  if (!tr(i)) throw Error("Invalid input to safeExtend: expected a plain object");
  let o = rr(r2._zod.def, { get shape() {
    let t = { ...r2._zod.def.shape, ...i };
    return or(this, "shape", t), t;
  } });
  return Y$2(r2, o);
}
function j4(r2, i) {
  let o = rr(r2._zod.def, { get shape() {
    let t = { ...r2._zod.def.shape, ...i._zod.def.shape };
    return or(this, "shape", t), t;
  }, get catchall() {
    return i._zod.def.catchall;
  }, checks: [] });
  return Y$2(r2, o);
}
function J4(r2, i, o) {
  let n = i._zod.def.checks;
  if (n && n.length > 0) throw Error(".partial() cannot be used on object schemas containing refinements");
  let $2 = rr(i._zod.def, { get shape() {
    let u2 = i._zod.def.shape, l = { ...u2 };
    if (o) for (let e in o) {
      if (!(e in u2)) throw Error(`Unrecognized key: "${e}"`);
      if (!o[e]) continue;
      l[e] = r2 ? new r2({ type: "optional", innerType: u2[e] }) : u2[e];
    }
    else for (let e in u2) l[e] = r2 ? new r2({ type: "optional", innerType: u2[e] }) : u2[e];
    return or(this, "shape", l), l;
  }, checks: [] });
  return Y$2(i, $2);
}
function L4(r2, i, o) {
  let t = rr(i._zod.def, { get shape() {
    let n = i._zod.def.shape, v = { ...n };
    if (o) for (let $2 in o) {
      if (!($2 in v)) throw Error(`Unrecognized key: "${$2}"`);
      if (!o[$2]) continue;
      v[$2] = new r2({ type: "nonoptional", innerType: n[$2] });
    }
    else for (let $2 in n) v[$2] = new r2({ type: "nonoptional", innerType: n[$2] });
    return or(this, "shape", v), v;
  } });
  return Y$2(i, t);
}
function $r$1(r2, i = 0) {
  if (r2.aborted === true) return true;
  for (let o = i; o < r2.issues.length; o++) if (r2.issues[o]?.continue !== true) return true;
  return false;
}
function M$1(r2, i) {
  return i.map((o) => {
    var t;
    return (t = o).path ?? (t.path = []), o.path.unshift(r2), o;
  });
}
function nn$1(r2) {
  return typeof r2 === "string" ? r2 : r2?.message;
}
function q(r2, i, o) {
  let t = { ...r2, path: r2.path ?? [] };
  if (!r2.message) {
    let n = nn$1(r2.inst?._zod.def?.error?.(r2)) ?? nn$1(i?.error?.(r2)) ?? nn$1(o.customError?.(r2)) ?? nn$1(o.localeError?.(r2)) ?? "Invalid input";
    t.message = n;
  }
  if (delete t.inst, delete t.continue, !i?.reportInput) delete t.input;
  return t;
}
function $n$1(r2) {
  if (r2 instanceof Set) return "set";
  if (r2 instanceof Map) return "map";
  if (r2 instanceof File) return "file";
  return "unknown";
}
function un$1(r2) {
  if (Array.isArray(r2)) return "array";
  if (typeof r2 === "string") return "string";
  return "unknown";
}
function D$2(r2) {
  let i = typeof r2;
  switch (i) {
    case "number":
      return Number.isNaN(r2) ? "nan" : "number";
    case "object": {
      if (r2 === null) return "null";
      if (Array.isArray(r2)) return "array";
      let o = r2;
      if (o && Object.getPrototypeOf(o) !== Object.prototype && "constructor" in o && o.constructor) return o.constructor.name;
    }
  }
  return i;
}
function Jr$1(...r2) {
  let [i, o, t] = r2;
  if (typeof i === "string") return { message: i, code: "custom", input: o, inst: t };
  return { ...i };
}
function E4(r2) {
  return Object.entries(r2).filter(([i, o]) => {
    return Number.isNaN(Number.parseInt(i, 10));
  }).map((i) => i[1]);
}
function Fe$1(r2) {
  let i = atob(r2), o = new Uint8Array(i.length);
  for (let t = 0; t < i.length; t++) o[t] = i.charCodeAt(t);
  return o;
}
function qe(r2) {
  let i = "";
  for (let o = 0; o < r2.length; o++) i += String.fromCharCode(r2[o]);
  return btoa(i);
}
function G4(r2) {
  let i = r2.replace(/-/g, "+").replace(/_/g, "/"), o = "=".repeat((4 - i.length % 4) % 4);
  return Fe$1(i + o);
}
function W4(r2) {
  return qe(r2).replace(/\+/g, "-").replace(/\//g, "_").replace(/=/g, "");
}
function X4(r2) {
  let i = r2.replace(/^0x/, "");
  if (i.length % 2 !== 0) throw Error("Invalid hex string length");
  let o = new Uint8Array(i.length / 2);
  for (let t = 0; t < i.length; t += 2) o[t / 2] = Number.parseInt(i.slice(t, t + 2), 16);
  return o;
}
function A4(r2) {
  return Array.from(r2).map((i) => i.toString(16).padStart(2, "0")).join("");
}
class Be {
  constructor(...r2) {
  }
}
var He = (r2, i) => {
  r2.name = "$ZodError", Object.defineProperty(r2, "_zod", { value: r2._zod, enumerable: false }), Object.defineProperty(r2, "issues", { value: i, enumerable: false }), r2.message = JSON.stringify(i, Pr$1, 2), Object.defineProperty(r2, "toString", { value: () => r2.message, enumerable: false });
}, gn$1 = I("$ZodError", He), B$3 = I("$ZodError", He, { Parent: Error });
function en$1(r2, i = (o) => o.message) {
  let o = {}, t = [];
  for (let n of r2.issues) if (n.path.length > 0) o[n.path[0]] = o[n.path[0]] || [], o[n.path[0]].push(i(n));
  else t.push(i(n));
  return { formErrors: t, fieldErrors: o };
}
function ln$1(r2, i = (o) => o.message) {
  let o = { _errors: [] }, t = (n) => {
    for (let v of n.issues) if (v.code === "invalid_union" && v.errors.length) v.errors.map(($2) => t({ issues: $2 }));
    else if (v.code === "invalid_key") t({ issues: v.issues });
    else if (v.code === "invalid_element") t({ issues: v.issues });
    else if (v.path.length === 0) o._errors.push(i(v));
    else {
      let $2 = o, u2 = 0;
      while (u2 < v.path.length) {
        let l = v.path[u2];
        if (u2 !== v.path.length - 1) $2[l] = $2[l] || { _errors: [] };
        else $2[l] = $2[l] || { _errors: [] }, $2[l]._errors.push(i(v));
        $2 = $2[l], u2++;
      }
    }
  };
  return t(r2), o;
}
function Av$1(r2, i = (o) => o.message) {
  let o = { errors: [] }, t = (n, v = []) => {
    var $2, u2;
    for (let l of n.issues) if (l.code === "invalid_union" && l.errors.length) l.errors.map((e) => t({ issues: e }, l.path));
    else if (l.code === "invalid_key") t({ issues: l.issues }, l.path);
    else if (l.code === "invalid_element") t({ issues: l.issues }, l.path);
    else {
      let e = [...v, ...l.path];
      if (e.length === 0) {
        o.errors.push(i(l));
        continue;
      }
      let c = o, b = 0;
      while (b < e.length) {
        let N2 = e[b], O = b === e.length - 1;
        if (typeof N2 === "string") c.properties ?? (c.properties = {}), ($2 = c.properties)[N2] ?? ($2[N2] = { errors: [] }), c = c.properties[N2];
        else c.items ?? (c.items = []), (u2 = c.items)[N2] ?? (u2[N2] = { errors: [] }), c = c.items[N2];
        if (O) c.errors.push(i(l));
        b++;
      }
    }
  };
  return t(r2), o;
}
function Me$2(r2) {
  let i = [], o = r2.map((t) => typeof t === "object" ? t.key : t);
  for (let t of o) if (typeof t === "number") i.push(`[${t}]`);
  else if (typeof t === "symbol") i.push(`[${JSON.stringify(String(t))}]`);
  else if (/[^\w$]/.test(t)) i.push(`[${JSON.stringify(t)}]`);
  else {
    if (i.length) i.push(".");
    i.push(t);
  }
  return i.join("");
}
function Vv$1(r2) {
  let i = [], o = [...r2.issues].sort((t, n) => (t.path ?? []).length - (n.path ?? []).length);
  for (let t of o) if (i.push(`✖ ${t.message}`), t.path?.length) i.push(`  → at ${Me$2(t.path)}`);
  return i.join(`
`);
}
var Lr$1 = (r2) => (i, o, t, n) => {
  let v = t ? Object.assign(t, { async: false }) : { async: false }, $2 = i._zod.run({ value: o, issues: [] }, v);
  if ($2 instanceof Promise) throw new f();
  if ($2.issues.length) {
    let u2 = new (n?.Err ?? r2)($2.issues.map((l) => q(l, v, A$1())));
    throw qn$1(u2, n?.callee), u2;
  }
  return $2.value;
}, Bn$1 = Lr$1(B$3), Er$1 = (r2) => async (i, o, t, n) => {
  let v = t ? Object.assign(t, { async: true }) : { async: true }, $2 = i._zod.run({ value: o, issues: [] }, v);
  if ($2 instanceof Promise) $2 = await $2;
  if ($2.issues.length) {
    let u2 = new (n?.Err ?? r2)($2.issues.map((l) => q(l, v, A$1())));
    throw qn$1(u2, n?.callee), u2;
  }
  return $2.value;
}, Hn$1 = Er$1(B$3), Gr$1 = (r2) => (i, o, t) => {
  let n = t ? { ...t, async: false } : { async: false }, v = i._zod.run({ value: o, issues: [] }, n);
  if (v instanceof Promise) throw new f();
  return v.issues.length ? { success: false, error: new (r2 ?? gn$1)(v.issues.map(($2) => q($2, n, A$1()))) } : { success: true, data: v.value };
}, Kv$1 = Gr$1(B$3), Wr$1 = (r2) => async (i, o, t) => {
  let n = t ? Object.assign(t, { async: true }) : { async: true }, v = i._zod.run({ value: o, issues: [] }, n);
  if (v instanceof Promise) v = await v;
  return v.issues.length ? { success: false, error: new r2(v.issues.map(($2) => q($2, n, A$1()))) } : { success: true, data: v.value };
}, Yv$1 = Wr$1(B$3), Mn$1 = (r2) => (i, o, t) => {
  let n = t ? Object.assign(t, { direction: "backward" }) : { direction: "backward" };
  return Lr$1(r2)(i, o, n);
}, K4 = Mn$1(B$3), mn$1 = (r2) => (i, o, t) => {
  return Lr$1(r2)(i, o, t);
}, Y4 = mn$1(B$3), Rn$1 = (r2) => async (i, o, t) => {
  let n = t ? Object.assign(t, { direction: "backward" }) : { direction: "backward" };
  return Er$1(r2)(i, o, n);
}, Q4 = Rn$1(B$3), xn$1 = (r2) => async (i, o, t) => {
  return Er$1(r2)(i, o, t);
}, T4 = xn$1(B$3), Zn$1 = (r2) => (i, o, t) => {
  let n = t ? Object.assign(t, { direction: "backward" }) : { direction: "backward" };
  return Gr$1(r2)(i, o, n);
}, F4 = Zn$1(B$3), dn$1 = (r2) => (i, o, t) => {
  return Gr$1(r2)(i, o, t);
}, q4 = dn$1(B$3), Cn$1 = (r2) => async (i, o, t) => {
  let n = t ? Object.assign(t, { direction: "backward" }) : { direction: "backward" };
  return Wr$1(r2)(i, o, n);
}, B4 = Cn$1(B$3), fn$1 = (r2) => async (i, o, t) => {
  return Wr$1(r2)(i, o, t);
}, H4 = fn$1(B$3);
var x$1 = {};
s(x$1, { xid: () => qv$1, uuid7: () => x4, uuid6: () => R4, uuid4: () => m4, uuid: () => br, uppercase: () => go, unicodeEmail: () => me$2, undefined: () => $o, ulid: () => Fv$1, time: () => sv$1, string: () => no, sha512_hex: () => I6, sha512_base64url: () => _6, sha512_base64: () => c6, sha384_hex: () => g6, sha384_base64url: () => l6, sha384_base64: () => e6, sha256_hex: () => t6, sha256_base64url: () => u6, sha256_base64: () => $6, sha1_hex: () => i6, sha1_base64url: () => o6, sha1_base64: () => v6, rfc5322Email: () => d4, number: () => In$1, null: () => to, nanoid: () => Hv$1, md5_hex: () => s4, md5_base64url: () => n6, md5_base64: () => r6, mac: () => Cv$1, lowercase: () => uo, ksuid: () => Bv$1, ipv6: () => dv$1, ipv4: () => Zv$1, integer: () => vo, idnEmail: () => C4, html5Email: () => Z4, hostname: () => h4, hex: () => p4, guid: () => mv$1, extendedDuration: () => M4, emoji: () => xv$1, email: () => Rv$1, e164: () => av$1, duration: () => Mv$1, domain: () => a4, datetime: () => ro, date: () => pv$1, cuid2: () => Tv$1, cuid: () => Qv$1, cidrv6: () => yv$1, cidrv4: () => fv$1, browserEmail: () => f4, boolean: () => oo, bigint: () => io, base64url: () => yn$1, base64: () => hv$1 });
var Qv$1 = /^[cC][^\s-]{8,}$/, Tv$1 = /^[0-9a-z]+$/, Fv$1 = /^[0-9A-HJKMNP-TV-Za-hjkmnp-tv-z]{26}$/, qv$1 = /^[0-9a-vA-V]{20}$/, Bv$1 = /^[A-Za-z0-9]{27}$/, Hv$1 = /^[a-zA-Z0-9_-]{21}$/, Mv$1 = /^P(?:(\d+W)|(?!.*W)(?=\d|T\d)(\d+Y)?(\d+M)?(\d+D)?(T(?=\d)(\d+H)?(\d+M)?(\d+([.,]\d+)?S)?)?)$/, M4 = /^[-+]?P(?!$)(?:(?:[-+]?\d+Y)|(?:[-+]?\d+[.,]\d+Y$))?(?:(?:[-+]?\d+M)|(?:[-+]?\d+[.,]\d+M$))?(?:(?:[-+]?\d+W)|(?:[-+]?\d+[.,]\d+W$))?(?:(?:[-+]?\d+D)|(?:[-+]?\d+[.,]\d+D$))?(?:T(?=[\d+-])(?:(?:[-+]?\d+H)|(?:[-+]?\d+[.,]\d+H$))?(?:(?:[-+]?\d+M)|(?:[-+]?\d+[.,]\d+M$))?(?:[-+]?\d+(?:[.,]\d+)?S)?)??$/, mv$1 = /^([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})$/, br = (r2) => {
  if (!r2) return /^([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[1-8][0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12}|00000000-0000-0000-0000-000000000000|ffffffff-ffff-ffff-ffff-ffffffffffff)$/;
  return new RegExp(`^([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-${r2}[0-9a-fA-F]{3}-[89abAB][0-9a-fA-F]{3}-[0-9a-fA-F]{12})$`);
}, m4 = br(4), R4 = br(6), x4 = br(7), Rv$1 = /^(?!\.)(?!.*\.\.)([A-Za-z0-9_'+\-\.]*)[A-Za-z0-9_+-]@([A-Za-z0-9][A-Za-z0-9\-]*\.)+[A-Za-z]{2,}$/, Z4 = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/, d4 = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/, me$2 = /^[^\s@"]{1,64}@[^\s@]{1,255}$/u, C4 = me$2, f4 = /^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*$/, y4 = "^(\\p{Extended_Pictographic}|\\p{Emoji_Component})+$";
function xv$1() {
  return new RegExp(y4, "u");
}
var Zv$1 = /^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])$/, dv$1 = /^(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))$/, Cv$1 = (r2) => {
  let i = R(r2 ?? ":");
  return new RegExp(`^(?:[0-9A-F]{2}${i}){5}[0-9A-F]{2}$|^(?:[0-9a-f]{2}${i}){5}[0-9a-f]{2}$`);
}, fv$1 = /^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9][0-9]|[0-9])\/([0-9]|[1-2][0-9]|3[0-2])$/, yv$1 = /^(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|::|([0-9a-fA-F]{1,4})?::([0-9a-fA-F]{1,4}:?){0,6})\/(12[0-8]|1[01][0-9]|[1-9]?[0-9])$/, hv$1 = /^$|^(?:[0-9a-zA-Z+/]{4})*(?:(?:[0-9a-zA-Z+/]{2}==)|(?:[0-9a-zA-Z+/]{3}=))?$/, yn$1 = /^[A-Za-z0-9_-]*$/, h4 = /^(?=.{1,253}\.?$)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[-0-9a-zA-Z]{0,61}[0-9a-zA-Z])?)*\.?$/, a4 = /^([a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?\.)+[a-zA-Z]{2,}$/, av$1 = /^\+[1-9]\d{6,14}$/, Re$1 = "(?:(?:\\d\\d[2468][048]|\\d\\d[13579][26]|\\d\\d0[48]|[02468][048]00|[13579][26]00)-02-29|\\d{4}-(?:(?:0[13578]|1[02])-(?:0[1-9]|[12]\\d|3[01])|(?:0[469]|11)-(?:0[1-9]|[12]\\d|30)|(?:02)-(?:0[1-9]|1\\d|2[0-8])))", pv$1 = new RegExp(`^${Re$1}$`);
function xe$2(r2) {
  return typeof r2.precision === "number" ? r2.precision === -1 ? "(?:[01]\\d|2[0-3]):[0-5]\\d" : r2.precision === 0 ? "(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d" : `(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d\\.\\d{${r2.precision}}` : "(?:[01]\\d|2[0-3]):[0-5]\\d(?::[0-5]\\d(?:\\.\\d+)?)?";
}
function sv$1(r2) {
  return new RegExp(`^${xe$2(r2)}$`);
}
function ro(r2) {
  let i = xe$2({ precision: r2.precision }), o = ["Z"];
  if (r2.local) o.push("");
  if (r2.offset) o.push("([+-](?:[01]\\d|2[0-3]):[0-5]\\d)");
  let t = `${i}(?:${o.join("|")})`;
  return new RegExp(`^${Re$1}T(?:${t})$`);
}
var no = (r2) => {
  let i = r2 ? `[\\s\\S]{${r2?.minimum ?? 0},${r2?.maximum ?? ""}}` : "[\\s\\S]*";
  return new RegExp(`^${i}$`);
}, io = /^-?\d+n?$/, vo = /^-?\d+$/, In$1 = /^-?\d+(?:\.\d+)?$/, oo = /^(?:true|false)$/i, to = /^null$/i;
var $o = /^undefined$/i;
var uo = /^[^A-Z]*$/, go = /^[^a-z]*$/, p4 = /^[0-9a-fA-F]*$/;
function cn$1(r2, i) {
  return new RegExp(`^[A-Za-z0-9+/]{${r2}}${i}$`);
}
function _n$1(r2) {
  return new RegExp(`^[A-Za-z0-9_-]{${r2}}$`);
}
var s4 = /^[0-9a-fA-F]{32}$/, r6 = cn$1(22, "=="), n6 = _n$1(22), i6 = /^[0-9a-fA-F]{40}$/, v6 = cn$1(27, "="), o6 = _n$1(27), t6 = /^[0-9a-fA-F]{64}$/, $6 = cn$1(43, "="), u6 = _n$1(43), g6 = /^[0-9a-fA-F]{96}$/, e6 = cn$1(64, ""), l6 = _n$1(64), I6 = /^[0-9a-fA-F]{128}$/, c6 = cn$1(86, "=="), _6 = _n$1(86);
var W$1 = I("$ZodCheck", (r2, i) => {
  var o;
  r2._zod ?? (r2._zod = {}), r2._zod.def = i, (o = r2._zod).onattach ?? (o.onattach = []);
}), de$2 = { number: "number", bigint: "bigint", object: "date" }, hn$1 = I("$ZodCheckLessThan", (r2, i) => {
  W$1.init(r2, i);
  let o = de$2[typeof i.value];
  r2._zod.onattach.push((t) => {
    let n = t._zod.bag, v = (i.inclusive ? n.maximum : n.exclusiveMaximum) ?? Number.POSITIVE_INFINITY;
    if (i.value < v) if (i.inclusive) n.maximum = i.value;
    else n.exclusiveMaximum = i.value;
  }), r2._zod.check = (t) => {
    if (i.inclusive ? t.value <= i.value : t.value < i.value) return;
    t.issues.push({ origin: o, code: "too_big", maximum: typeof i.value === "object" ? i.value.getTime() : i.value, input: t.value, inclusive: i.inclusive, inst: r2, continue: !i.abort });
  };
}), an$1 = I("$ZodCheckGreaterThan", (r2, i) => {
  W$1.init(r2, i);
  let o = de$2[typeof i.value];
  r2._zod.onattach.push((t) => {
    let n = t._zod.bag, v = (i.inclusive ? n.minimum : n.exclusiveMinimum) ?? Number.NEGATIVE_INFINITY;
    if (i.value > v) if (i.inclusive) n.minimum = i.value;
    else n.exclusiveMinimum = i.value;
  }), r2._zod.check = (t) => {
    if (i.inclusive ? t.value >= i.value : t.value > i.value) return;
    t.issues.push({ origin: o, code: "too_small", minimum: typeof i.value === "object" ? i.value.getTime() : i.value, input: t.value, inclusive: i.inclusive, inst: r2, continue: !i.abort });
  };
}), eo$1 = I("$ZodCheckMultipleOf", (r2, i) => {
  W$1.init(r2, i), r2._zod.onattach.push((o) => {
    var t;
    (t = o._zod.bag).multipleOf ?? (t.multipleOf = i.value);
  }), r2._zod.check = (o) => {
    if (typeof o.value !== typeof i.value) throw Error("Cannot mix number and bigint in multiple_of check.");
    if (typeof o.value === "bigint" ? o.value % i.value === BigInt(0) : Pv$1(o.value, i.value) === 0) return;
    o.issues.push({ origin: typeof o.value, code: "not_multiple_of", divisor: i.value, input: o.value, inst: r2, continue: !i.abort });
  };
}), lo = I("$ZodCheckNumberFormat", (r2, i) => {
  W$1.init(r2, i), i.format = i.format || "float64";
  let o = i.format?.includes("int"), t = o ? "int" : "number", [n, v] = Wv$1[i.format];
  r2._zod.onattach.push(($2) => {
    let u2 = $2._zod.bag;
    if (u2.format = i.format, u2.minimum = n, u2.maximum = v, o) u2.pattern = vo;
  }), r2._zod.check = ($2) => {
    let u2 = $2.value;
    if (o) {
      if (!Number.isInteger(u2)) {
        $2.issues.push({ expected: t, format: i.format, code: "invalid_type", continue: false, input: u2, inst: r2 });
        return;
      }
      if (!Number.isSafeInteger(u2)) {
        if (u2 > 0) $2.issues.push({ input: u2, code: "too_big", maximum: Number.MAX_SAFE_INTEGER, note: "Integers must be within the safe integer range.", inst: r2, origin: t, inclusive: true, continue: !i.abort });
        else $2.issues.push({ input: u2, code: "too_small", minimum: Number.MIN_SAFE_INTEGER, note: "Integers must be within the safe integer range.", inst: r2, origin: t, inclusive: true, continue: !i.abort });
        return;
      }
    }
    if (u2 < n) $2.issues.push({ origin: "number", input: u2, code: "too_small", minimum: n, inclusive: true, inst: r2, continue: !i.abort });
    if (u2 > v) $2.issues.push({ origin: "number", input: u2, code: "too_big", maximum: v, inclusive: true, inst: r2, continue: !i.abort });
  };
}), Io$1 = I("$ZodCheckBigIntFormat", (r2, i) => {
  W$1.init(r2, i);
  let [o, t] = Xv$1[i.format];
  r2._zod.onattach.push((n) => {
    let v = n._zod.bag;
    v.format = i.format, v.minimum = o, v.maximum = t;
  }), r2._zod.check = (n) => {
    let v = n.value;
    if (v < o) n.issues.push({ origin: "bigint", input: v, code: "too_small", minimum: o, inclusive: true, inst: r2, continue: !i.abort });
    if (v > t) n.issues.push({ origin: "bigint", input: v, code: "too_big", maximum: t, inclusive: true, inst: r2, continue: !i.abort });
  };
}), co = I("$ZodCheckMaxSize", (r2, i) => {
  var o;
  W$1.init(r2, i), (o = r2._zod.def).when ?? (o.when = (t) => {
    let n = t.value;
    return !vr$1(n) && n.size !== void 0;
  }), r2._zod.onattach.push((t) => {
    let n = t._zod.bag.maximum ?? Number.POSITIVE_INFINITY;
    if (i.maximum < n) t._zod.bag.maximum = i.maximum;
  }), r2._zod.check = (t) => {
    let n = t.value;
    if (n.size <= i.maximum) return;
    t.issues.push({ origin: $n$1(n), code: "too_big", maximum: i.maximum, inclusive: true, input: n, inst: r2, continue: !i.abort });
  };
}), _o$1 = I("$ZodCheckMinSize", (r2, i) => {
  var o;
  W$1.init(r2, i), (o = r2._zod.def).when ?? (o.when = (t) => {
    let n = t.value;
    return !vr$1(n) && n.size !== void 0;
  }), r2._zod.onattach.push((t) => {
    let n = t._zod.bag.minimum ?? Number.NEGATIVE_INFINITY;
    if (i.minimum > n) t._zod.bag.minimum = i.minimum;
  }), r2._zod.check = (t) => {
    let n = t.value;
    if (n.size >= i.minimum) return;
    t.issues.push({ origin: $n$1(n), code: "too_small", minimum: i.minimum, inclusive: true, input: n, inst: r2, continue: !i.abort });
  };
}), bo$1 = I("$ZodCheckSizeEquals", (r2, i) => {
  var o;
  W$1.init(r2, i), (o = r2._zod.def).when ?? (o.when = (t) => {
    let n = t.value;
    return !vr$1(n) && n.size !== void 0;
  }), r2._zod.onattach.push((t) => {
    let n = t._zod.bag;
    n.minimum = i.size, n.maximum = i.size, n.size = i.size;
  }), r2._zod.check = (t) => {
    let n = t.value, v = n.size;
    if (v === i.size) return;
    let $2 = v > i.size;
    t.issues.push({ origin: $n$1(n), ...$2 ? { code: "too_big", maximum: i.size } : { code: "too_small", minimum: i.size }, inclusive: true, exact: true, input: t.value, inst: r2, continue: !i.abort });
  };
}), Uo$1 = I("$ZodCheckMaxLength", (r2, i) => {
  var o;
  W$1.init(r2, i), (o = r2._zod.def).when ?? (o.when = (t) => {
    let n = t.value;
    return !vr$1(n) && n.length !== void 0;
  }), r2._zod.onattach.push((t) => {
    let n = t._zod.bag.maximum ?? Number.POSITIVE_INFINITY;
    if (i.maximum < n) t._zod.bag.maximum = i.maximum;
  }), r2._zod.check = (t) => {
    let n = t.value;
    if (n.length <= i.maximum) return;
    let $2 = un$1(n);
    t.issues.push({ origin: $2, code: "too_big", maximum: i.maximum, inclusive: true, input: n, inst: r2, continue: !i.abort });
  };
}), Do$1 = I("$ZodCheckMinLength", (r2, i) => {
  var o;
  W$1.init(r2, i), (o = r2._zod.def).when ?? (o.when = (t) => {
    let n = t.value;
    return !vr$1(n) && n.length !== void 0;
  }), r2._zod.onattach.push((t) => {
    let n = t._zod.bag.minimum ?? Number.NEGATIVE_INFINITY;
    if (i.minimum > n) t._zod.bag.minimum = i.minimum;
  }), r2._zod.check = (t) => {
    let n = t.value;
    if (n.length >= i.minimum) return;
    let $2 = un$1(n);
    t.issues.push({ origin: $2, code: "too_small", minimum: i.minimum, inclusive: true, input: n, inst: r2, continue: !i.abort });
  };
}), ko$1 = I("$ZodCheckLengthEquals", (r2, i) => {
  var o;
  W$1.init(r2, i), (o = r2._zod.def).when ?? (o.when = (t) => {
    let n = t.value;
    return !vr$1(n) && n.length !== void 0;
  }), r2._zod.onattach.push((t) => {
    let n = t._zod.bag;
    n.minimum = i.length, n.maximum = i.length, n.length = i.length;
  }), r2._zod.check = (t) => {
    let n = t.value, v = n.length;
    if (v === i.length) return;
    let $2 = un$1(n), u2 = v > i.length;
    t.issues.push({ origin: $2, ...u2 ? { code: "too_big", maximum: i.length } : { code: "too_small", minimum: i.length }, inclusive: true, exact: true, input: t.value, inst: r2, continue: !i.abort });
  };
}), Xr$1 = I("$ZodCheckStringFormat", (r2, i) => {
  var o, t;
  if (W$1.init(r2, i), r2._zod.onattach.push((n) => {
    let v = n._zod.bag;
    if (v.format = i.format, i.pattern) v.patterns ?? (v.patterns = /* @__PURE__ */ new Set()), v.patterns.add(i.pattern);
  }), i.pattern) (o = r2._zod).check ?? (o.check = (n) => {
    if (i.pattern.lastIndex = 0, i.pattern.test(n.value)) return;
    n.issues.push({ origin: "string", code: "invalid_format", format: i.format, input: n.value, ...i.pattern ? { pattern: i.pattern.toString() } : {}, inst: r2, continue: !i.abort });
  });
  else (t = r2._zod).check ?? (t.check = () => {
  });
}), wo$1 = I("$ZodCheckRegex", (r2, i) => {
  Xr$1.init(r2, i), r2._zod.check = (o) => {
    if (i.pattern.lastIndex = 0, i.pattern.test(o.value)) return;
    o.issues.push({ origin: "string", code: "invalid_format", format: "regex", input: o.value, pattern: i.pattern.toString(), inst: r2, continue: !i.abort });
  };
}), No$1 = I("$ZodCheckLowerCase", (r2, i) => {
  i.pattern ?? (i.pattern = uo), Xr$1.init(r2, i);
}), Oo$1 = I("$ZodCheckUpperCase", (r2, i) => {
  i.pattern ?? (i.pattern = go), Xr$1.init(r2, i);
}), So$1 = I("$ZodCheckIncludes", (r2, i) => {
  W$1.init(r2, i);
  let o = R(i.includes), t = new RegExp(typeof i.position === "number" ? `^.{${i.position}}${o}` : o);
  i.pattern = t, r2._zod.onattach.push((n) => {
    let v = n._zod.bag;
    v.patterns ?? (v.patterns = /* @__PURE__ */ new Set()), v.patterns.add(t);
  }), r2._zod.check = (n) => {
    if (n.value.includes(i.includes, i.position)) return;
    n.issues.push({ origin: "string", code: "invalid_format", format: "includes", includes: i.includes, input: n.value, inst: r2, continue: !i.abort });
  };
}), zo$1 = I("$ZodCheckStartsWith", (r2, i) => {
  W$1.init(r2, i);
  let o = new RegExp(`^${R(i.prefix)}.*`);
  i.pattern ?? (i.pattern = o), r2._zod.onattach.push((t) => {
    let n = t._zod.bag;
    n.patterns ?? (n.patterns = /* @__PURE__ */ new Set()), n.patterns.add(o);
  }), r2._zod.check = (t) => {
    if (t.value.startsWith(i.prefix)) return;
    t.issues.push({ origin: "string", code: "invalid_format", format: "starts_with", prefix: i.prefix, input: t.value, inst: r2, continue: !i.abort });
  };
}), Po$1 = I("$ZodCheckEndsWith", (r2, i) => {
  W$1.init(r2, i);
  let o = new RegExp(`.*${R(i.suffix)}$`);
  i.pattern ?? (i.pattern = o), r2._zod.onattach.push((t) => {
    let n = t._zod.bag;
    n.patterns ?? (n.patterns = /* @__PURE__ */ new Set()), n.patterns.add(o);
  }), r2._zod.check = (t) => {
    if (t.value.endsWith(i.suffix)) return;
    t.issues.push({ origin: "string", code: "invalid_format", format: "ends_with", suffix: i.suffix, input: t.value, inst: r2, continue: !i.abort });
  };
});
function Ze(r2, i, o) {
  if (r2.issues.length) i.issues.push(...M$1(o, r2.issues));
}
var jo$1 = I("$ZodCheckProperty", (r2, i) => {
  W$1.init(r2, i), r2._zod.check = (o) => {
    let t = i.schema._zod.run({ value: o.value[i.property], issues: [] }, {});
    if (t instanceof Promise) return t.then((n) => Ze(n, o, i.property));
    Ze(t, o, i.property);
    return;
  };
}), Jo$1 = I("$ZodCheckMimeType", (r2, i) => {
  W$1.init(r2, i);
  let o = new Set(i.mime);
  r2._zod.onattach.push((t) => {
    t._zod.bag.mime = i.mime;
  }), r2._zod.check = (t) => {
    if (o.has(t.value.type)) return;
    t.issues.push({ code: "invalid_value", values: i.mime, input: t.value.type, inst: r2, continue: !i.abort });
  };
}), Lo$1 = I("$ZodCheckOverwrite", (r2, i) => {
  W$1.init(r2, i), r2._zod.check = (o) => {
    o.value = i.tx(o.value);
  };
});
let pn$1 = class pn {
  constructor(r2 = []) {
    if (this.content = [], this.indent = 0, this) this.args = r2;
  }
  indented(r2) {
    this.indent += 1, r2(this), this.indent -= 1;
  }
  write(r2) {
    if (typeof r2 === "function") {
      r2(this, { execution: "sync" }), r2(this, { execution: "async" });
      return;
    }
    let o = r2.split(`
`).filter((v) => v), t = Math.min(...o.map((v) => v.length - v.trimStart().length)), n = o.map((v) => v.slice(t)).map((v) => " ".repeat(this.indent * 2) + v);
    for (let v of n) this.content.push(v);
  }
  compile() {
    let r2 = Function, i = this?.args, t = [...(this?.content ?? [""]).map((n) => `  ${n}`)];
    return new r2(...i, t.join(`
`));
  }
};
var Eo$1 = { major: 4, minor: 3, patch: 5 };
var z$1 = I("$ZodType", (r2, i) => {
  var o;
  r2 ?? (r2 = {}), r2._zod.def = i, r2._zod.bag = r2._zod.bag || {}, r2._zod.version = Eo$1;
  let t = [...r2._zod.def.checks ?? []];
  if (r2._zod.traits.has("$ZodCheck")) t.unshift(r2);
  for (let n of t) for (let v of n._zod.onattach) v(r2);
  if (t.length === 0) (o = r2._zod).deferred ?? (o.deferred = []), r2._zod.deferred?.push(() => {
    r2._zod.run = r2._zod.parse;
  });
  else {
    let n = ($2, u2, l) => {
      let e = $r$1($2), c;
      for (let b of u2) {
        if (b._zod.def.when) {
          if (!b._zod.def.when($2)) continue;
        } else if (e) continue;
        let N2 = $2.issues.length, O = b._zod.check($2);
        if (O instanceof Promise && l?.async === false) throw new f();
        if (c || O instanceof Promise) c = (c ?? Promise.resolve()).then(async () => {
          if (await O, $2.issues.length === N2) return;
          if (!e) e = $r$1($2, N2);
        });
        else {
          if ($2.issues.length === N2) continue;
          if (!e) e = $r$1($2, N2);
        }
      }
      if (c) return c.then(() => {
        return $2;
      });
      return $2;
    }, v = ($2, u2, l) => {
      if ($r$1($2)) return $2.aborted = true, $2;
      let e = n(u2, t, l);
      if (e instanceof Promise) {
        if (l.async === false) throw new f();
        return e.then((c) => r2._zod.parse(c, l));
      }
      return r2._zod.parse(e, l);
    };
    r2._zod.run = ($2, u2) => {
      if (u2.skipChecks) return r2._zod.parse($2, u2);
      if (u2.direction === "backward") {
        let e = r2._zod.parse({ value: $2.value, issues: [] }, { ...u2, skipChecks: true });
        if (e instanceof Promise) return e.then((c) => {
          return v(c, $2, u2);
        });
        return v(e, $2, u2);
      }
      let l = r2._zod.parse($2, u2);
      if (l instanceof Promise) {
        if (u2.async === false) throw new f();
        return l.then((e) => n(e, t, u2));
      }
      return n(l, t, u2);
    };
  }
  j(r2, "~standard", () => ({ validate: (n) => {
    try {
      let v = Kv$1(r2, n);
      return v.success ? { value: v.data } : { issues: v.error?.issues };
    } catch (v) {
      return Yv$1(r2, n).then(($2) => $2.success ? { value: $2.data } : { issues: $2.error?.issues });
    }
  }, vendor: "zod", version: 1 }));
}), Ur$1 = I("$ZodString", (r2, i) => {
  z$1.init(r2, i), r2._zod.pattern = [...r2?._zod.bag?.patterns ?? []].pop() ?? no(r2._zod.bag), r2._zod.parse = (o, t) => {
    if (i.coerce) try {
      o.value = String(o.value);
    } catch (n) {
    }
    if (typeof o.value === "string") return o;
    return o.issues.push({ expected: "string", code: "invalid_type", input: o.value, inst: r2 }), o;
  };
}), E = I("$ZodStringFormat", (r2, i) => {
  Xr$1.init(r2, i), Ur$1.init(r2, i);
}), Wo$1 = I("$ZodGUID", (r2, i) => {
  i.pattern ?? (i.pattern = mv$1), E.init(r2, i);
}), Xo$1 = I("$ZodUUID", (r2, i) => {
  if (i.version) {
    let t = { v1: 1, v2: 2, v3: 3, v4: 4, v5: 5, v6: 6, v7: 7, v8: 8 }[i.version];
    if (t === void 0) throw Error(`Invalid UUID version: "${i.version}"`);
    i.pattern ?? (i.pattern = br(t));
  } else i.pattern ?? (i.pattern = br());
  E.init(r2, i);
}), Ao$1 = I("$ZodEmail", (r2, i) => {
  i.pattern ?? (i.pattern = Rv$1), E.init(r2, i);
}), Vo$1 = I("$ZodURL", (r2, i) => {
  E.init(r2, i), r2._zod.check = (o) => {
    try {
      let t = o.value.trim(), n = new URL(t);
      if (i.hostname) {
        if (i.hostname.lastIndex = 0, !i.hostname.test(n.hostname)) o.issues.push({ code: "invalid_format", format: "url", note: "Invalid hostname", pattern: i.hostname.source, input: o.value, inst: r2, continue: !i.abort });
      }
      if (i.protocol) {
        if (i.protocol.lastIndex = 0, !i.protocol.test(n.protocol.endsWith(":") ? n.protocol.slice(0, -1) : n.protocol)) o.issues.push({ code: "invalid_format", format: "url", note: "Invalid protocol", pattern: i.protocol.source, input: o.value, inst: r2, continue: !i.abort });
      }
      if (i.normalize) o.value = n.href;
      else o.value = t;
      return;
    } catch (t) {
      o.issues.push({ code: "invalid_format", format: "url", input: o.value, inst: r2, continue: !i.abort });
    }
  };
}), Ko$1 = I("$ZodEmoji", (r2, i) => {
  i.pattern ?? (i.pattern = xv$1()), E.init(r2, i);
}), Yo$1 = I("$ZodNanoID", (r2, i) => {
  i.pattern ?? (i.pattern = Hv$1), E.init(r2, i);
}), Qo$1 = I("$ZodCUID", (r2, i) => {
  i.pattern ?? (i.pattern = Qv$1), E.init(r2, i);
}), To$1 = I("$ZodCUID2", (r2, i) => {
  i.pattern ?? (i.pattern = Tv$1), E.init(r2, i);
}), Fo$1 = I("$ZodULID", (r2, i) => {
  i.pattern ?? (i.pattern = Fv$1), E.init(r2, i);
}), qo$1 = I("$ZodXID", (r2, i) => {
  i.pattern ?? (i.pattern = qv$1), E.init(r2, i);
}), Bo$1 = I("$ZodKSUID", (r2, i) => {
  i.pattern ?? (i.pattern = Bv$1), E.init(r2, i);
}), Ho$1 = I("$ZodISODateTime", (r2, i) => {
  i.pattern ?? (i.pattern = ro(i)), E.init(r2, i);
}), Mo$1 = I("$ZodISODate", (r2, i) => {
  i.pattern ?? (i.pattern = pv$1), E.init(r2, i);
}), mo = I("$ZodISOTime", (r2, i) => {
  i.pattern ?? (i.pattern = sv$1(i)), E.init(r2, i);
}), Ro$1 = I("$ZodISODuration", (r2, i) => {
  i.pattern ?? (i.pattern = Mv$1), E.init(r2, i);
}), xo$1 = I("$ZodIPv4", (r2, i) => {
  i.pattern ?? (i.pattern = Zv$1), E.init(r2, i), r2._zod.bag.format = "ipv4";
}), Zo$1 = I("$ZodIPv6", (r2, i) => {
  i.pattern ?? (i.pattern = dv$1), E.init(r2, i), r2._zod.bag.format = "ipv6", r2._zod.check = (o) => {
    try {
      new URL(`http://[${o.value}]`);
    } catch {
      o.issues.push({ code: "invalid_format", format: "ipv6", input: o.value, inst: r2, continue: !i.abort });
    }
  };
}), Co$1 = I("$ZodMAC", (r2, i) => {
  i.pattern ?? (i.pattern = Cv$1(i.delimiter)), E.init(r2, i), r2._zod.bag.format = "mac";
}), fo = I("$ZodCIDRv4", (r2, i) => {
  i.pattern ?? (i.pattern = fv$1), E.init(r2, i);
}), yo$1 = I("$ZodCIDRv6", (r2, i) => {
  i.pattern ?? (i.pattern = yv$1), E.init(r2, i), r2._zod.check = (o) => {
    let t = o.value.split("/");
    try {
      if (t.length !== 2) throw Error();
      let [n, v] = t;
      if (!v) throw Error();
      let $2 = Number(v);
      if (`${$2}` !== v) throw Error();
      if ($2 < 0 || $2 > 128) throw Error();
      new URL(`http://[${n}]`);
    } catch {
      o.issues.push({ code: "invalid_format", format: "cidrv6", input: o.value, inst: r2, continue: !i.abort });
    }
  };
});
function ho$1(r2) {
  if (r2 === "") return true;
  if (r2.length % 4 !== 0) return false;
  try {
    return atob(r2), true;
  } catch {
    return false;
  }
}
var ao = I("$ZodBase64", (r2, i) => {
  i.pattern ?? (i.pattern = hv$1), E.init(r2, i), r2._zod.bag.contentEncoding = "base64", r2._zod.check = (o) => {
    if (ho$1(o.value)) return;
    o.issues.push({ code: "invalid_format", format: "base64", input: o.value, inst: r2, continue: !i.abort });
  };
});
function tl$1(r2) {
  if (!yn$1.test(r2)) return false;
  let i = r2.replace(/[-_]/g, (t) => t === "-" ? "+" : "/"), o = i.padEnd(Math.ceil(i.length / 4) * 4, "=");
  return ho$1(o);
}
var po = I("$ZodBase64URL", (r2, i) => {
  i.pattern ?? (i.pattern = yn$1), E.init(r2, i), r2._zod.bag.contentEncoding = "base64url", r2._zod.check = (o) => {
    if (tl$1(o.value)) return;
    o.issues.push({ code: "invalid_format", format: "base64url", input: o.value, inst: r2, continue: !i.abort });
  };
}), so = I("$ZodE164", (r2, i) => {
  i.pattern ?? (i.pattern = av$1), E.init(r2, i);
});
function $l$1(r2, i = null) {
  try {
    let o = r2.split(".");
    if (o.length !== 3) return false;
    let [t] = o;
    if (!t) return false;
    let n = JSON.parse(atob(t));
    if ("typ" in n && n?.typ !== "JWT") return false;
    if (!n.alg) return false;
    if (i && (!("alg" in n) || n.alg !== i)) return false;
    return true;
  } catch {
    return false;
  }
}
var rt$1 = I("$ZodJWT", (r2, i) => {
  E.init(r2, i), r2._zod.check = (o) => {
    if ($l$1(o.value, i.alg)) return;
    o.issues.push({ code: "invalid_format", format: "jwt", input: o.value, inst: r2, continue: !i.abort });
  };
}), nt$1 = I("$ZodCustomStringFormat", (r2, i) => {
  E.init(r2, i), r2._zod.check = (o) => {
    if (i.fn(o.value)) return;
    o.issues.push({ code: "invalid_format", format: i.format, input: o.value, inst: r2, continue: !i.abort });
  };
}), oi = I("$ZodNumber", (r2, i) => {
  z$1.init(r2, i), r2._zod.pattern = r2._zod.bag.pattern ?? In$1, r2._zod.parse = (o, t) => {
    if (i.coerce) try {
      o.value = Number(o.value);
    } catch ($2) {
    }
    let n = o.value;
    if (typeof n === "number" && !Number.isNaN(n) && Number.isFinite(n)) return o;
    let v = typeof n === "number" ? Number.isNaN(n) ? "NaN" : !Number.isFinite(n) ? "Infinity" : void 0 : void 0;
    return o.issues.push({ expected: "number", code: "invalid_type", input: n, inst: r2, ...v ? { received: v } : {} }), o;
  };
}), it$1 = I("$ZodNumberFormat", (r2, i) => {
  lo.init(r2, i), oi.init(r2, i);
}), bn$1 = I("$ZodBoolean", (r2, i) => {
  z$1.init(r2, i), r2._zod.pattern = oo, r2._zod.parse = (o, t) => {
    if (i.coerce) try {
      o.value = Boolean(o.value);
    } catch (v) {
    }
    let n = o.value;
    if (typeof n === "boolean") return o;
    return o.issues.push({ expected: "boolean", code: "invalid_type", input: n, inst: r2 }), o;
  };
}), ti$1 = I("$ZodBigInt", (r2, i) => {
  z$1.init(r2, i), r2._zod.pattern = io, r2._zod.parse = (o, t) => {
    if (i.coerce) try {
      o.value = BigInt(o.value);
    } catch (n) {
    }
    if (typeof o.value === "bigint") return o;
    return o.issues.push({ expected: "bigint", code: "invalid_type", input: o.value, inst: r2 }), o;
  };
}), vt$1 = I("$ZodBigIntFormat", (r2, i) => {
  Io$1.init(r2, i), ti$1.init(r2, i);
}), ot$1 = I("$ZodSymbol", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o, t) => {
    let n = o.value;
    if (typeof n === "symbol") return o;
    return o.issues.push({ expected: "symbol", code: "invalid_type", input: n, inst: r2 }), o;
  };
}), tt$1 = I("$ZodUndefined", (r2, i) => {
  z$1.init(r2, i), r2._zod.pattern = $o, r2._zod.values = /* @__PURE__ */ new Set([void 0]), r2._zod.optin = "optional", r2._zod.optout = "optional", r2._zod.parse = (o, t) => {
    let n = o.value;
    if (typeof n > "u") return o;
    return o.issues.push({ expected: "undefined", code: "invalid_type", input: n, inst: r2 }), o;
  };
}), $t$1 = I("$ZodNull", (r2, i) => {
  z$1.init(r2, i), r2._zod.pattern = to, r2._zod.values = /* @__PURE__ */ new Set([null]), r2._zod.parse = (o, t) => {
    let n = o.value;
    if (n === null) return o;
    return o.issues.push({ expected: "null", code: "invalid_type", input: n, inst: r2 }), o;
  };
}), ut = I("$ZodAny", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o) => o;
}), gt$1 = I("$ZodUnknown", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o) => o;
}), et$1 = I("$ZodNever", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o, t) => {
    return o.issues.push({ expected: "never", code: "invalid_type", input: o.value, inst: r2 }), o;
  };
}), lt$1 = I("$ZodVoid", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o, t) => {
    let n = o.value;
    if (typeof n > "u") return o;
    return o.issues.push({ expected: "void", code: "invalid_type", input: n, inst: r2 }), o;
  };
}), It$1 = I("$ZodDate", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o, t) => {
    if (i.coerce) try {
      o.value = new Date(o.value);
    } catch (u2) {
    }
    let n = o.value, v = n instanceof Date;
    if (v && !Number.isNaN(n.getTime())) return o;
    return o.issues.push({ expected: "date", code: "invalid_type", input: n, ...v ? { received: "Invalid Date" } : {}, inst: r2 }), o;
  };
});
function fe$1(r2, i, o) {
  if (r2.issues.length) i.issues.push(...M$1(o, r2.issues));
  i.value[o] = r2.value;
}
var ct = I("$ZodArray", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o, t) => {
    let n = o.value;
    if (!Array.isArray(n)) return o.issues.push({ expected: "array", code: "invalid_type", input: n, inst: r2 }), o;
    o.value = Array(n.length);
    let v = [];
    for (let $2 = 0; $2 < n.length; $2++) {
      let u2 = n[$2], l = i.element._zod.run({ value: u2, issues: [] }, t);
      if (l instanceof Promise) v.push(l.then((e) => fe$1(e, o, $2)));
      else fe$1(l, o, $2);
    }
    if (v.length) return Promise.all(v).then(() => o);
    return o;
  };
});
function vi$1(r2, i, o, t, n) {
  if (r2.issues.length) {
    if (n && !(o in t)) return;
    i.issues.push(...M$1(o, r2.issues));
  }
  if (r2.value === void 0) {
    if (o in t) i.value[o] = void 0;
  } else i.value[o] = r2.value;
}
function ul$1(r2) {
  let i = Object.keys(r2.shape);
  for (let t of i) if (!r2.shape?.[t]?._zod?.traits?.has("$ZodType")) throw Error(`Invalid element at key "${t}": expected a Zod schema`);
  let o = Gv$1(r2.shape);
  return { ...r2, keys: i, keySet: new Set(i), numKeys: i.length, optionalKeys: new Set(o) };
}
function gl$1(r2, i, o, t, n, v) {
  let $2 = [], u2 = n.keySet, l = n.catchall._zod, e = l.def.type, c = l.optout === "optional";
  for (let b in i) {
    if (u2.has(b)) continue;
    if (e === "never") {
      $2.push(b);
      continue;
    }
    let N2 = l.run({ value: i[b], issues: [] }, t);
    if (N2 instanceof Promise) r2.push(N2.then((O) => vi$1(O, o, b, i, c)));
    else vi$1(N2, o, b, i, c);
  }
  if ($2.length) o.issues.push({ code: "unrecognized_keys", keys: $2, input: i, inst: v });
  if (!r2.length) return o;
  return Promise.all(r2).then(() => {
    return o;
  });
}
var el$1 = I("$ZodObject", (r2, i) => {
  if (z$1.init(r2, i), !Object.getOwnPropertyDescriptor(i, "shape")?.get) {
    let u2 = i.shape;
    Object.defineProperty(i, "shape", { get: () => {
      let l = { ...u2 };
      return Object.defineProperty(i, "shape", { value: l }), l;
    } });
  }
  let t = jr$1(() => ul$1(i));
  j(r2._zod, "propValues", () => {
    let u2 = i.shape, l = {};
    for (let e in u2) {
      let c = u2[e]._zod;
      if (c.values) {
        l[e] ?? (l[e] = /* @__PURE__ */ new Set());
        for (let b of c.values) l[e].add(b);
      }
    }
    return l;
  });
  let n = _r, v = i.catchall, $2;
  r2._zod.parse = (u2, l) => {
    $2 ?? ($2 = t.value);
    let e = u2.value;
    if (!n(e)) return u2.issues.push({ expected: "object", code: "invalid_type", input: e, inst: r2 }), u2;
    u2.value = {};
    let c = [], b = $2.shape;
    for (let N2 of $2.keys) {
      let O = b[N2], J2 = O._zod.optout === "optional", X2 = O._zod.run({ value: e[N2], issues: [] }, l);
      if (X2 instanceof Promise) c.push(X2.then((Sr2) => vi$1(Sr2, u2, N2, e, J2)));
      else vi$1(X2, u2, N2, e, J2);
    }
    if (!v) return c.length ? Promise.all(c).then(() => u2) : u2;
    return gl$1(c, e, u2, l, t.value, r2);
  };
}), _t = I("$ZodObjectJIT", (r2, i) => {
  el$1.init(r2, i);
  let o = r2._zod.parse, t = jr$1(() => ul$1(i)), n = (N2) => {
    let O = new pn$1(["shape", "payload", "ctx"]), J2 = t.value, X2 = (C) => {
      let F2 = Fn$1(C);
      return `shape[${F2}]._zod.run({ value: input[${F2}], issues: [] }, ctx)`;
    };
    O.write("const input = payload.value;");
    let Sr2 = /* @__PURE__ */ Object.create(null), mI = 0;
    for (let C of J2.keys) Sr2[C] = `key_${mI++}`;
    O.write("const newResult = {};");
    for (let C of J2.keys) {
      let F2 = Sr2[C], Z2 = Fn$1(C), xI = N2[C]?._zod?.optout === "optional";
      if (O.write(`const ${F2} = ${X2(C)};`), xI) O.write(`
        if (${F2}.issues.length) {
          if (${Z2} in input) {
            payload.issues = payload.issues.concat(${F2}.issues.map(iss => ({
              ...iss,
              path: iss.path ? [${Z2}, ...iss.path] : [${Z2}]
            })));
          }
        }
        
        if (${F2}.value === undefined) {
          if (${Z2} in input) {
            newResult[${Z2}] = undefined;
          }
        } else {
          newResult[${Z2}] = ${F2}.value;
        }
        
      `);
      else O.write(`
        if (${F2}.issues.length) {
          payload.issues = payload.issues.concat(${F2}.issues.map(iss => ({
            ...iss,
            path: iss.path ? [${Z2}, ...iss.path] : [${Z2}]
          })));
        }
        
        if (${F2}.value === undefined) {
          if (${Z2} in input) {
            newResult[${Z2}] = undefined;
          }
        } else {
          newResult[${Z2}] = ${F2}.value;
        }
        
      `);
    }
    O.write("payload.value = newResult;"), O.write("return payload;");
    let RI = O.compile();
    return (C, F2) => RI(N2, C, F2);
  }, v, $2 = _r, u2 = !rn$1.jitless, e = u2 && Jv$1.value, c = i.catchall, b;
  r2._zod.parse = (N2, O) => {
    b ?? (b = t.value);
    let J2 = N2.value;
    if (!$2(J2)) return N2.issues.push({ expected: "object", code: "invalid_type", input: J2, inst: r2 }), N2;
    if (u2 && e && O?.async === false && O.jitless !== true) {
      if (!v) v = n(i.shape);
      if (N2 = v(N2, O), !c) return N2;
      return gl$1([], J2, N2, O, b, r2);
    }
    return o(N2, O);
  };
});
function ye$2(r2, i, o, t) {
  for (let v of r2) if (v.issues.length === 0) return i.value = v.value, i;
  let n = r2.filter((v) => !$r$1(v));
  if (n.length === 1) return i.value = n[0].value, n[0];
  return i.issues.push({ code: "invalid_union", input: i.value, inst: o, errors: r2.map((v) => v.issues.map(($2) => q($2, t, A$1()))) }), i;
}
var Un$1 = I("$ZodUnion", (r2, i) => {
  z$1.init(r2, i), j(r2._zod, "optin", () => i.options.some((n) => n._zod.optin === "optional") ? "optional" : void 0), j(r2._zod, "optout", () => i.options.some((n) => n._zod.optout === "optional") ? "optional" : void 0), j(r2._zod, "values", () => {
    if (i.options.every((n) => n._zod.values)) return new Set(i.options.flatMap((n) => Array.from(n._zod.values)));
    return;
  }), j(r2._zod, "pattern", () => {
    if (i.options.every((n) => n._zod.pattern)) {
      let n = i.options.map((v) => v._zod.pattern);
      return new RegExp(`^(${n.map((v) => on$1(v.source)).join("|")})$`);
    }
    return;
  });
  let o = i.options.length === 1, t = i.options[0]._zod.run;
  r2._zod.parse = (n, v) => {
    if (o) return t(n, v);
    let $2 = false, u2 = [];
    for (let l of i.options) {
      let e = l._zod.run({ value: n.value, issues: [] }, v);
      if (e instanceof Promise) u2.push(e), $2 = true;
      else {
        if (e.issues.length === 0) return e;
        u2.push(e);
      }
    }
    if (!$2) return ye$2(u2, n, r2, v);
    return Promise.all(u2).then((l) => {
      return ye$2(l, n, r2, v);
    });
  };
});
function he$2(r2, i, o, t) {
  let n = r2.filter((v) => v.issues.length === 0);
  if (n.length === 1) return i.value = n[0].value, i;
  if (n.length === 0) i.issues.push({ code: "invalid_union", input: i.value, inst: o, errors: r2.map((v) => v.issues.map(($2) => q($2, t, A$1()))) });
  else i.issues.push({ code: "invalid_union", input: i.value, inst: o, errors: [], inclusive: false });
  return i;
}
var bt = I("$ZodXor", (r2, i) => {
  Un$1.init(r2, i), i.inclusive = false;
  let o = i.options.length === 1, t = i.options[0]._zod.run;
  r2._zod.parse = (n, v) => {
    if (o) return t(n, v);
    let $2 = false, u2 = [];
    for (let l of i.options) {
      let e = l._zod.run({ value: n.value, issues: [] }, v);
      if (e instanceof Promise) u2.push(e), $2 = true;
      else u2.push(e);
    }
    if (!$2) return he$2(u2, n, r2, v);
    return Promise.all(u2).then((l) => {
      return he$2(l, n, r2, v);
    });
  };
}), Ut$1 = I("$ZodDiscriminatedUnion", (r2, i) => {
  i.inclusive = false, Un$1.init(r2, i);
  let o = r2._zod.parse;
  j(r2._zod, "propValues", () => {
    let n = {};
    for (let v of i.options) {
      let $2 = v._zod.propValues;
      if (!$2 || Object.keys($2).length === 0) throw Error(`Invalid discriminated union option at index "${i.options.indexOf(v)}"`);
      for (let [u2, l] of Object.entries($2)) {
        if (!n[u2]) n[u2] = /* @__PURE__ */ new Set();
        for (let e of l) n[u2].add(e);
      }
    }
    return n;
  });
  let t = jr$1(() => {
    let n = i.options, v = /* @__PURE__ */ new Map();
    for (let $2 of n) {
      let u2 = $2._zod.propValues?.[i.discriminator];
      if (!u2 || u2.size === 0) throw Error(`Invalid discriminated union option at index "${i.options.indexOf($2)}"`);
      for (let l of u2) {
        if (v.has(l)) throw Error(`Duplicate discriminator value "${String(l)}"`);
        v.set(l, $2);
      }
    }
    return v;
  });
  r2._zod.parse = (n, v) => {
    let $2 = n.value;
    if (!_r($2)) return n.issues.push({ code: "invalid_type", expected: "object", input: $2, inst: r2 }), n;
    let u2 = t.value.get($2?.[i.discriminator]);
    if (u2) return u2._zod.run(n, v);
    if (i.unionFallback) return o(n, v);
    return n.issues.push({ code: "invalid_union", errors: [], note: "No matching discriminator", discriminator: i.discriminator, input: $2, path: [i.discriminator], inst: r2 }), n;
  };
}), Dt$1 = I("$ZodIntersection", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o, t) => {
    let n = o.value, v = i.left._zod.run({ value: n, issues: [] }, t), $2 = i.right._zod.run({ value: n, issues: [] }, t);
    if (v instanceof Promise || $2 instanceof Promise) return Promise.all([v, $2]).then(([l, e]) => {
      return ae(o, l, e);
    });
    return ae(o, v, $2);
  };
});
function Go$1(r2, i) {
  if (r2 === i) return { valid: true, data: r2 };
  if (r2 instanceof Date && i instanceof Date && +r2 === +i) return { valid: true, data: r2 };
  if (tr(r2) && tr(i)) {
    let o = Object.keys(i), t = Object.keys(r2).filter((v) => o.indexOf(v) !== -1), n = { ...r2, ...i };
    for (let v of t) {
      let $2 = Go$1(r2[v], i[v]);
      if (!$2.valid) return { valid: false, mergeErrorPath: [v, ...$2.mergeErrorPath] };
      n[v] = $2.data;
    }
    return { valid: true, data: n };
  }
  if (Array.isArray(r2) && Array.isArray(i)) {
    if (r2.length !== i.length) return { valid: false, mergeErrorPath: [] };
    let o = [];
    for (let t = 0; t < r2.length; t++) {
      let n = r2[t], v = i[t], $2 = Go$1(n, v);
      if (!$2.valid) return { valid: false, mergeErrorPath: [t, ...$2.mergeErrorPath] };
      o.push($2.data);
    }
    return { valid: true, data: o };
  }
  return { valid: false, mergeErrorPath: [] };
}
function ae(r2, i, o) {
  let t = /* @__PURE__ */ new Map(), n;
  for (let u2 of i.issues) if (u2.code === "unrecognized_keys") {
    n ?? (n = u2);
    for (let l of u2.keys) {
      if (!t.has(l)) t.set(l, {});
      t.get(l).l = true;
    }
  } else r2.issues.push(u2);
  for (let u2 of o.issues) if (u2.code === "unrecognized_keys") for (let l of u2.keys) {
    if (!t.has(l)) t.set(l, {});
    t.get(l).r = true;
  }
  else r2.issues.push(u2);
  let v = [...t].filter(([, u2]) => u2.l && u2.r).map(([u2]) => u2);
  if (v.length && n) r2.issues.push({ ...n, keys: v });
  if ($r$1(r2)) return r2;
  let $2 = Go$1(i.value, o.value);
  if (!$2.valid) throw Error(`Unmergable intersection. Error path: ${JSON.stringify($2.mergeErrorPath)}`);
  return r2.value = $2.data, r2;
}
var $i$1 = I("$ZodTuple", (r2, i) => {
  z$1.init(r2, i);
  let o = i.items;
  r2._zod.parse = (t, n) => {
    let v = t.value;
    if (!Array.isArray(v)) return t.issues.push({ input: v, inst: r2, expected: "tuple", code: "invalid_type" }), t;
    t.value = [];
    let $2 = [], u2 = [...o].reverse().findIndex((c) => c._zod.optin !== "optional"), l = u2 === -1 ? 0 : o.length - u2;
    if (!i.rest) {
      let c = v.length > o.length, b = v.length < l - 1;
      if (c || b) return t.issues.push({ ...c ? { code: "too_big", maximum: o.length, inclusive: true } : { code: "too_small", minimum: o.length }, input: v, inst: r2, origin: "array" }), t;
    }
    let e = -1;
    for (let c of o) {
      if (e++, e >= v.length) {
        if (e >= l) continue;
      }
      let b = c._zod.run({ value: v[e], issues: [] }, n);
      if (b instanceof Promise) $2.push(b.then((N2) => sn$1(N2, t, e)));
      else sn$1(b, t, e);
    }
    if (i.rest) {
      let c = v.slice(o.length);
      for (let b of c) {
        e++;
        let N2 = i.rest._zod.run({ value: b, issues: [] }, n);
        if (N2 instanceof Promise) $2.push(N2.then((O) => sn$1(O, t, e)));
        else sn$1(N2, t, e);
      }
    }
    if ($2.length) return Promise.all($2).then(() => t);
    return t;
  };
});
function sn$1(r2, i, o) {
  if (r2.issues.length) i.issues.push(...M$1(o, r2.issues));
  i.value[o] = r2.value;
}
var kt$1 = I("$ZodRecord", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o, t) => {
    let n = o.value;
    if (!tr(n)) return o.issues.push({ expected: "record", code: "invalid_type", input: n, inst: r2 }), o;
    let v = [], $2 = i.keyType._zod.values;
    if ($2) {
      o.value = {};
      let u2 = /* @__PURE__ */ new Set();
      for (let e of $2) if (typeof e === "string" || typeof e === "number" || typeof e === "symbol") {
        u2.add(typeof e === "number" ? e.toString() : e);
        let c = i.valueType._zod.run({ value: n[e], issues: [] }, t);
        if (c instanceof Promise) v.push(c.then((b) => {
          if (b.issues.length) o.issues.push(...M$1(e, b.issues));
          o.value[e] = b.value;
        }));
        else {
          if (c.issues.length) o.issues.push(...M$1(e, c.issues));
          o.value[e] = c.value;
        }
      }
      let l;
      for (let e in n) if (!u2.has(e)) l = l ?? [], l.push(e);
      if (l && l.length > 0) o.issues.push({ code: "unrecognized_keys", input: n, inst: r2, keys: l });
    } else {
      o.value = {};
      for (let u2 of Reflect.ownKeys(n)) {
        if (u2 === "__proto__") continue;
        let l = i.keyType._zod.run({ value: u2, issues: [] }, t);
        if (l instanceof Promise) throw Error("Async schemas not supported in object keys currently");
        if (typeof u2 === "string" && In$1.test(u2) && l.issues.length && l.issues.some((b) => b.code === "invalid_type" && b.expected === "number")) {
          let b = i.keyType._zod.run({ value: Number(u2), issues: [] }, t);
          if (b instanceof Promise) throw Error("Async schemas not supported in object keys currently");
          if (b.issues.length === 0) l = b;
        }
        if (l.issues.length) {
          if (i.mode === "loose") o.value[u2] = n[u2];
          else o.issues.push({ code: "invalid_key", origin: "record", issues: l.issues.map((b) => q(b, t, A$1())), input: u2, path: [u2], inst: r2 });
          continue;
        }
        let c = i.valueType._zod.run({ value: n[u2], issues: [] }, t);
        if (c instanceof Promise) v.push(c.then((b) => {
          if (b.issues.length) o.issues.push(...M$1(u2, b.issues));
          o.value[l.value] = b.value;
        }));
        else {
          if (c.issues.length) o.issues.push(...M$1(u2, c.issues));
          o.value[l.value] = c.value;
        }
      }
    }
    if (v.length) return Promise.all(v).then(() => o);
    return o;
  };
}), wt$1 = I("$ZodMap", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o, t) => {
    let n = o.value;
    if (!(n instanceof Map)) return o.issues.push({ expected: "map", code: "invalid_type", input: n, inst: r2 }), o;
    let v = [];
    o.value = /* @__PURE__ */ new Map();
    for (let [$2, u2] of n) {
      let l = i.keyType._zod.run({ value: $2, issues: [] }, t), e = i.valueType._zod.run({ value: u2, issues: [] }, t);
      if (l instanceof Promise || e instanceof Promise) v.push(Promise.all([l, e]).then(([c, b]) => {
        pe$2(c, b, o, $2, n, r2, t);
      }));
      else pe$2(l, e, o, $2, n, r2, t);
    }
    if (v.length) return Promise.all(v).then(() => o);
    return o;
  };
});
function pe$2(r2, i, o, t, n, v, $2) {
  if (r2.issues.length) if (tn$1.has(typeof t)) o.issues.push(...M$1(t, r2.issues));
  else o.issues.push({ code: "invalid_key", origin: "map", input: n, inst: v, issues: r2.issues.map((u2) => q(u2, $2, A$1())) });
  if (i.issues.length) if (tn$1.has(typeof t)) o.issues.push(...M$1(t, i.issues));
  else o.issues.push({ origin: "map", code: "invalid_element", input: n, inst: v, key: t, issues: i.issues.map((u2) => q(u2, $2, A$1())) });
  o.value.set(r2.value, i.value);
}
var Nt$1 = I("$ZodSet", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o, t) => {
    let n = o.value;
    if (!(n instanceof Set)) return o.issues.push({ input: n, inst: r2, expected: "set", code: "invalid_type" }), o;
    let v = [];
    o.value = /* @__PURE__ */ new Set();
    for (let $2 of n) {
      let u2 = i.valueType._zod.run({ value: $2, issues: [] }, t);
      if (u2 instanceof Promise) v.push(u2.then((l) => se(l, o)));
      else se(u2, o);
    }
    if (v.length) return Promise.all(v).then(() => o);
    return o;
  };
});
function se(r2, i) {
  if (r2.issues.length) i.issues.push(...r2.issues);
  i.value.add(r2.value);
}
var Ot$1 = I("$ZodEnum", (r2, i) => {
  z$1.init(r2, i);
  let o = vn$1(i.entries), t = new Set(o);
  r2._zod.values = t, r2._zod.pattern = new RegExp(`^(${o.filter((n) => tn$1.has(typeof n)).map((n) => typeof n === "string" ? R(n) : n.toString()).join("|")})$`), r2._zod.parse = (n, v) => {
    let $2 = n.value;
    if (t.has($2)) return n;
    return n.issues.push({ code: "invalid_value", values: o, input: $2, inst: r2 }), n;
  };
}), St$1 = I("$ZodLiteral", (r2, i) => {
  if (z$1.init(r2, i), i.values.length === 0) throw Error("Cannot create literal schema with no valid values");
  let o = new Set(i.values);
  r2._zod.values = o, r2._zod.pattern = new RegExp(`^(${i.values.map((t) => typeof t === "string" ? R(t) : t ? R(t.toString()) : String(t)).join("|")})$`), r2._zod.parse = (t, n) => {
    let v = t.value;
    if (o.has(v)) return t;
    return t.issues.push({ code: "invalid_value", values: i.values, input: v, inst: r2 }), t;
  };
}), zt$1 = I("$ZodFile", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o, t) => {
    let n = o.value;
    if (n instanceof File) return o;
    return o.issues.push({ expected: "file", code: "invalid_type", input: n, inst: r2 }), o;
  };
}), Pt$1 = I("$ZodTransform", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o, t) => {
    if (t.direction === "backward") throw new cr(r2.constructor.name);
    let n = i.transform(o.value, o);
    if (t.async) return (n instanceof Promise ? n : Promise.resolve(n)).then(($2) => {
      return o.value = $2, o;
    });
    if (n instanceof Promise) throw new f();
    return o.value = n, o;
  };
});
function rl$1(r2, i) {
  if (r2.issues.length && i === void 0) return { issues: [], value: void 0 };
  return r2;
}
var ui = I("$ZodOptional", (r2, i) => {
  z$1.init(r2, i), r2._zod.optin = "optional", r2._zod.optout = "optional", j(r2._zod, "values", () => {
    return i.innerType._zod.values ? /* @__PURE__ */ new Set([...i.innerType._zod.values, void 0]) : void 0;
  }), j(r2._zod, "pattern", () => {
    let o = i.innerType._zod.pattern;
    return o ? new RegExp(`^(${on$1(o.source)})?$`) : void 0;
  }), r2._zod.parse = (o, t) => {
    if (i.innerType._zod.optin === "optional") {
      let n = i.innerType._zod.run(o, t);
      if (n instanceof Promise) return n.then((v) => rl$1(v, o.value));
      return rl$1(n, o.value);
    }
    if (o.value === void 0) return o;
    return i.innerType._zod.run(o, t);
  };
}), jt$1 = I("$ZodExactOptional", (r2, i) => {
  ui.init(r2, i), j(r2._zod, "values", () => i.innerType._zod.values), j(r2._zod, "pattern", () => i.innerType._zod.pattern), r2._zod.parse = (o, t) => {
    return i.innerType._zod.run(o, t);
  };
}), Jt = I("$ZodNullable", (r2, i) => {
  z$1.init(r2, i), j(r2._zod, "optin", () => i.innerType._zod.optin), j(r2._zod, "optout", () => i.innerType._zod.optout), j(r2._zod, "pattern", () => {
    let o = i.innerType._zod.pattern;
    return o ? new RegExp(`^(${on$1(o.source)}|null)$`) : void 0;
  }), j(r2._zod, "values", () => {
    return i.innerType._zod.values ? /* @__PURE__ */ new Set([...i.innerType._zod.values, null]) : void 0;
  }), r2._zod.parse = (o, t) => {
    if (o.value === null) return o;
    return i.innerType._zod.run(o, t);
  };
}), Lt$1 = I("$ZodDefault", (r2, i) => {
  z$1.init(r2, i), r2._zod.optin = "optional", j(r2._zod, "values", () => i.innerType._zod.values), r2._zod.parse = (o, t) => {
    if (t.direction === "backward") return i.innerType._zod.run(o, t);
    if (o.value === void 0) return o.value = i.defaultValue, o;
    let n = i.innerType._zod.run(o, t);
    if (n instanceof Promise) return n.then((v) => nl$1(v, i));
    return nl$1(n, i);
  };
});
function nl$1(r2, i) {
  if (r2.value === void 0) r2.value = i.defaultValue;
  return r2;
}
var Et$1 = I("$ZodPrefault", (r2, i) => {
  z$1.init(r2, i), r2._zod.optin = "optional", j(r2._zod, "values", () => i.innerType._zod.values), r2._zod.parse = (o, t) => {
    if (t.direction === "backward") return i.innerType._zod.run(o, t);
    if (o.value === void 0) o.value = i.defaultValue;
    return i.innerType._zod.run(o, t);
  };
}), Gt = I("$ZodNonOptional", (r2, i) => {
  z$1.init(r2, i), j(r2._zod, "values", () => {
    let o = i.innerType._zod.values;
    return o ? new Set([...o].filter((t) => t !== void 0)) : void 0;
  }), r2._zod.parse = (o, t) => {
    let n = i.innerType._zod.run(o, t);
    if (n instanceof Promise) return n.then((v) => il$1(v, r2));
    return il$1(n, r2);
  };
});
function il$1(r2, i) {
  if (!r2.issues.length && r2.value === void 0) r2.issues.push({ code: "invalid_type", expected: "nonoptional", input: r2.value, inst: i });
  return r2;
}
var Wt$1 = I("$ZodSuccess", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o, t) => {
    if (t.direction === "backward") throw new cr("ZodSuccess");
    let n = i.innerType._zod.run(o, t);
    if (n instanceof Promise) return n.then((v) => {
      return o.value = v.issues.length === 0, o;
    });
    return o.value = n.issues.length === 0, o;
  };
}), Xt$1 = I("$ZodCatch", (r2, i) => {
  z$1.init(r2, i), j(r2._zod, "optin", () => i.innerType._zod.optin), j(r2._zod, "optout", () => i.innerType._zod.optout), j(r2._zod, "values", () => i.innerType._zod.values), r2._zod.parse = (o, t) => {
    if (t.direction === "backward") return i.innerType._zod.run(o, t);
    let n = i.innerType._zod.run(o, t);
    if (n instanceof Promise) return n.then((v) => {
      if (o.value = v.value, v.issues.length) o.value = i.catchValue({ ...o, error: { issues: v.issues.map(($2) => q($2, t, A$1())) }, input: o.value }), o.issues = [];
      return o;
    });
    if (o.value = n.value, n.issues.length) o.value = i.catchValue({ ...o, error: { issues: n.issues.map((v) => q(v, t, A$1())) }, input: o.value }), o.issues = [];
    return o;
  };
}), At$1 = I("$ZodNaN", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o, t) => {
    if (typeof o.value !== "number" || !Number.isNaN(o.value)) return o.issues.push({ input: o.value, inst: r2, expected: "nan", code: "invalid_type" }), o;
    return o;
  };
}), Vt = I("$ZodPipe", (r2, i) => {
  z$1.init(r2, i), j(r2._zod, "values", () => i.in._zod.values), j(r2._zod, "optin", () => i.in._zod.optin), j(r2._zod, "optout", () => i.out._zod.optout), j(r2._zod, "propValues", () => i.in._zod.propValues), r2._zod.parse = (o, t) => {
    if (t.direction === "backward") {
      let v = i.out._zod.run(o, t);
      if (v instanceof Promise) return v.then(($2) => ri$1($2, i.in, t));
      return ri$1(v, i.in, t);
    }
    let n = i.in._zod.run(o, t);
    if (n instanceof Promise) return n.then((v) => ri$1(v, i.out, t));
    return ri$1(n, i.out, t);
  };
});
function ri$1(r2, i, o) {
  if (r2.issues.length) return r2.aborted = true, r2;
  return i._zod.run({ value: r2.value, issues: r2.issues }, o);
}
var Dn$1 = I("$ZodCodec", (r2, i) => {
  z$1.init(r2, i), j(r2._zod, "values", () => i.in._zod.values), j(r2._zod, "optin", () => i.in._zod.optin), j(r2._zod, "optout", () => i.out._zod.optout), j(r2._zod, "propValues", () => i.in._zod.propValues), r2._zod.parse = (o, t) => {
    if ((t.direction || "forward") === "forward") {
      let v = i.in._zod.run(o, t);
      if (v instanceof Promise) return v.then(($2) => ni$1($2, i, t));
      return ni$1(v, i, t);
    } else {
      let v = i.out._zod.run(o, t);
      if (v instanceof Promise) return v.then(($2) => ni$1($2, i, t));
      return ni$1(v, i, t);
    }
  };
});
function ni$1(r2, i, o) {
  if (r2.issues.length) return r2.aborted = true, r2;
  if ((o.direction || "forward") === "forward") {
    let n = i.transform(r2.value, r2);
    if (n instanceof Promise) return n.then((v) => ii$1(r2, v, i.out, o));
    return ii$1(r2, n, i.out, o);
  } else {
    let n = i.reverseTransform(r2.value, r2);
    if (n instanceof Promise) return n.then((v) => ii$1(r2, v, i.in, o));
    return ii$1(r2, n, i.in, o);
  }
}
function ii$1(r2, i, o, t) {
  if (r2.issues.length) return r2.aborted = true, r2;
  return o._zod.run({ value: i, issues: r2.issues }, t);
}
var Kt$1 = I("$ZodReadonly", (r2, i) => {
  z$1.init(r2, i), j(r2._zod, "propValues", () => i.innerType._zod.propValues), j(r2._zod, "values", () => i.innerType._zod.values), j(r2._zod, "optin", () => i.innerType?._zod?.optin), j(r2._zod, "optout", () => i.innerType?._zod?.optout), r2._zod.parse = (o, t) => {
    if (t.direction === "backward") return i.innerType._zod.run(o, t);
    let n = i.innerType._zod.run(o, t);
    if (n instanceof Promise) return n.then(vl$1);
    return vl$1(n);
  };
});
function vl$1(r2) {
  return r2.value = Object.freeze(r2.value), r2;
}
var Yt$1 = I("$ZodTemplateLiteral", (r2, i) => {
  z$1.init(r2, i);
  let o = [];
  for (let t of i.parts) if (typeof t === "object" && t !== null) {
    if (!t._zod.pattern) throw Error(`Invalid template literal part, no pattern found: ${[...t._zod.traits].shift()}`);
    let n = t._zod.pattern instanceof RegExp ? t._zod.pattern.source : t._zod.pattern;
    if (!n) throw Error(`Invalid template literal part: ${t._zod.traits}`);
    let v = n.startsWith("^") ? 1 : 0, $2 = n.endsWith("$") ? n.length - 1 : n.length;
    o.push(n.slice(v, $2));
  } else if (t === null || Ev$1.has(typeof t)) o.push(R(`${t}`));
  else throw Error(`Invalid template literal part: ${t}`);
  r2._zod.pattern = new RegExp(`^${o.join("")}$`), r2._zod.parse = (t, n) => {
    if (typeof t.value !== "string") return t.issues.push({ input: t.value, inst: r2, expected: "string", code: "invalid_type" }), t;
    if (r2._zod.pattern.lastIndex = 0, !r2._zod.pattern.test(t.value)) return t.issues.push({ input: t.value, inst: r2, code: "invalid_format", format: i.format ?? "template_literal", pattern: r2._zod.pattern.source }), t;
    return t;
  };
}), Qt$1 = I("$ZodFunction", (r2, i) => {
  return z$1.init(r2, i), r2._def = i, r2._zod.def = i, r2.implement = (o) => {
    if (typeof o !== "function") throw Error("implement() must be called with a function");
    return function(...t) {
      let n = r2._def.input ? Bn$1(r2._def.input, t) : t, v = Reflect.apply(o, this, n);
      if (r2._def.output) return Bn$1(r2._def.output, v);
      return v;
    };
  }, r2.implementAsync = (o) => {
    if (typeof o !== "function") throw Error("implementAsync() must be called with a function");
    return async function(...t) {
      let n = r2._def.input ? await Hn$1(r2._def.input, t) : t, v = await Reflect.apply(o, this, n);
      if (r2._def.output) return await Hn$1(r2._def.output, v);
      return v;
    };
  }, r2._zod.parse = (o, t) => {
    if (typeof o.value !== "function") return o.issues.push({ code: "invalid_type", expected: "function", input: o.value, inst: r2 }), o;
    if (r2._def.output && r2._def.output._zod.def.type === "promise") o.value = r2.implementAsync(o.value);
    else o.value = r2.implement(o.value);
    return o;
  }, r2.input = (...o) => {
    let t = r2.constructor;
    if (Array.isArray(o[0])) return new t({ type: "function", input: new $i$1({ type: "tuple", items: o[0], rest: o[1] }), output: r2._def.output });
    return new t({ type: "function", input: o[0], output: r2._def.output });
  }, r2.output = (o) => {
    return new r2.constructor({ type: "function", input: r2._def.input, output: o });
  }, r2;
}), Tt$1 = I("$ZodPromise", (r2, i) => {
  z$1.init(r2, i), r2._zod.parse = (o, t) => {
    return Promise.resolve(o.value).then((n) => i.innerType._zod.run({ value: n, issues: [] }, t));
  };
}), Ft$1 = I("$ZodLazy", (r2, i) => {
  z$1.init(r2, i), j(r2._zod, "innerType", () => i.getter()), j(r2._zod, "pattern", () => r2._zod.innerType?._zod?.pattern), j(r2._zod, "propValues", () => r2._zod.innerType?._zod?.propValues), j(r2._zod, "optin", () => r2._zod.innerType?._zod?.optin ?? void 0), j(r2._zod, "optout", () => r2._zod.innerType?._zod?.optout ?? void 0), r2._zod.parse = (o, t) => {
    return r2._zod.innerType._zod.run(o, t);
  };
}), qt$1 = I("$ZodCustom", (r2, i) => {
  W$1.init(r2, i), z$1.init(r2, i), r2._zod.parse = (o, t) => {
    return o;
  }, r2._zod.check = (o) => {
    let t = o.value, n = i.fn(t);
    if (n instanceof Promise) return n.then((v) => ol$1(v, o, t, r2));
    ol$1(n, o, t, r2);
    return;
  };
});
function ol$1(r2, i, o, t) {
  if (!r2) {
    let n = { code: "custom", input: o, inst: t, path: [...t._zod.def.path ?? []], continue: !t._zod.def.abort };
    if (t._zod.def.params) n.params = t._zod.def.params;
    i.issues.push(Jr$1(n));
  }
}
var Sn$1 = {};
s(Sn$1, { zhTW: () => W$, zhCN: () => G$, yo: () => X$, vi: () => E$, uz: () => L$, ur: () => J$, uk: () => On$1, ua: () => j$, tr: () => P$, th: () => z$, ta: () => S$, sv: () => O$, sl: () => N$, ru: () => w$, pt: () => k$, ps: () => U$, pl: () => D$, ota: () => b$, no: () => _$, nl: () => c$, ms: () => I$, mk: () => l$, lt: () => e$, ko: () => g$, km: () => wn$1, kh: () => u$, ka: () => $$, ja: () => t$, it: () => o$, is: () => v$, id: () => i$, hy: () => n$, hu: () => r$, he: () => st$1, frCA: () => pt$1, fr: () => at$1, fi: () => ht$1, fa: () => yt$1, es: () => ft$1, eo: () => Ct$1, en: () => kn$1, de: () => dt$1, da: () => Zt$1, cs: () => xt$1, ca: () => Rt$1, bg: () => mt, be: () => Mt$1, az: () => Ht, ar: () => Bt$1 });
var U6 = () => {
  let r2 = { string: { unit: "حرف", verb: "أن يحوي" }, file: { unit: "بايت", verb: "أن يحوي" }, array: { unit: "عنصر", verb: "أن يحوي" }, set: { unit: "عنصر", verb: "أن يحوي" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "مدخل", email: "بريد إلكتروني", url: "رابط", emoji: "إيموجي", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "تاريخ ووقت بمعيار ISO", date: "تاريخ بمعيار ISO", time: "وقت بمعيار ISO", duration: "مدة بمعيار ISO", ipv4: "عنوان IPv4", ipv6: "عنوان IPv6", cidrv4: "مدى عناوين بصيغة IPv4", cidrv6: "مدى عناوين بصيغة IPv6", base64: "نَص بترميز base64-encoded", base64url: "نَص بترميز base64url-encoded", json_string: "نَص على هيئة JSON", e164: "رقم هاتف بمعيار E.164", jwt: "JWT", template_literal: "مدخل" }, t = { nan: "NaN" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `مدخلات غير مقبولة: يفترض إدخال instanceof ${n.expected}، ولكن تم إدخال ${u2}`;
        return `مدخلات غير مقبولة: يفترض إدخال ${v}، ولكن تم إدخال ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `مدخلات غير مقبولة: يفترض إدخال ${U$1(n.values[0])}`;
        return `اختيار غير مقبول: يتوقع انتقاء أحد هذه الخيارات: ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return ` أكبر من اللازم: يفترض أن تكون ${n.origin ?? "القيمة"} ${v} ${n.maximum.toString()} ${$2.unit ?? "عنصر"}`;
        return `أكبر من اللازم: يفترض أن تكون ${n.origin ?? "القيمة"} ${v} ${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `أصغر من اللازم: يفترض لـ ${n.origin} أن يكون ${v} ${n.minimum.toString()} ${$2.unit}`;
        return `أصغر من اللازم: يفترض لـ ${n.origin} أن يكون ${v} ${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `نَص غير مقبول: يجب أن يبدأ بـ "${n.prefix}"`;
        if (v.format === "ends_with") return `نَص غير مقبول: يجب أن ينتهي بـ "${v.suffix}"`;
        if (v.format === "includes") return `نَص غير مقبول: يجب أن يتضمَّن "${v.includes}"`;
        if (v.format === "regex") return `نَص غير مقبول: يجب أن يطابق النمط ${v.pattern}`;
        return `${o[v.format] ?? n.format} غير مقبول`;
      }
      case "not_multiple_of":
        return `رقم غير مقبول: يجب أن يكون من مضاعفات ${n.divisor}`;
      case "unrecognized_keys":
        return `معرف${n.keys.length > 1 ? "ات" : ""} غريب${n.keys.length > 1 ? "ة" : ""}: ${_$1(n.keys, "، ")}`;
      case "invalid_key":
        return `معرف غير مقبول في ${n.origin}`;
      case "invalid_union":
        return "مدخل غير مقبول";
      case "invalid_element":
        return `مدخل غير مقبول في ${n.origin}`;
      default:
        return "مدخل غير مقبول";
    }
  };
};
function Bt$1() {
  return { localeError: U6() };
}
var D6 = () => {
  let r2 = { string: { unit: "simvol", verb: "olmalıdır" }, file: { unit: "bayt", verb: "olmalıdır" }, array: { unit: "element", verb: "olmalıdır" }, set: { unit: "element", verb: "olmalıdır" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "input", email: "email address", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO datetime", date: "ISO date", time: "ISO time", duration: "ISO duration", ipv4: "IPv4 address", ipv6: "IPv6 address", cidrv4: "IPv4 range", cidrv6: "IPv6 range", base64: "base64-encoded string", base64url: "base64url-encoded string", json_string: "JSON string", e164: "E.164 number", jwt: "JWT", template_literal: "input" }, t = { nan: "NaN" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Yanlış dəyər: gözlənilən instanceof ${n.expected}, daxil olan ${u2}`;
        return `Yanlış dəyər: gözlənilən ${v}, daxil olan ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Yanlış dəyər: gözlənilən ${U$1(n.values[0])}`;
        return `Yanlış seçim: aşağıdakılardan biri olmalıdır: ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Çox böyük: gözlənilən ${n.origin ?? "dəyər"} ${v}${n.maximum.toString()} ${$2.unit ?? "element"}`;
        return `Çox böyük: gözlənilən ${n.origin ?? "dəyər"} ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Çox kiçik: gözlənilən ${n.origin} ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Çox kiçik: gözlənilən ${n.origin} ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Yanlış mətn: "${v.prefix}" ilə başlamalıdır`;
        if (v.format === "ends_with") return `Yanlış mətn: "${v.suffix}" ilə bitməlidir`;
        if (v.format === "includes") return `Yanlış mətn: "${v.includes}" daxil olmalıdır`;
        if (v.format === "regex") return `Yanlış mətn: ${v.pattern} şablonuna uyğun olmalıdır`;
        return `Yanlış ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Yanlış ədəd: ${n.divisor} ilə bölünə bilən olmalıdır`;
      case "unrecognized_keys":
        return `Tanınmayan açar${n.keys.length > 1 ? "lar" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `${n.origin} daxilində yanlış açar`;
      case "invalid_union":
        return "Yanlış dəyər";
      case "invalid_element":
        return `${n.origin} daxilində yanlış dəyər`;
      default:
        return "Yanlış dəyər";
    }
  };
};
function Ht() {
  return { localeError: D6() };
}
function ll$1(r2, i, o, t) {
  let n = Math.abs(r2), v = n % 10, $2 = n % 100;
  if ($2 >= 11 && $2 <= 19) return t;
  if (v === 1) return i;
  if (v >= 2 && v <= 4) return o;
  return t;
}
var k6 = () => {
  let r2 = { string: { unit: { one: "сімвал", few: "сімвалы", many: "сімвалаў" }, verb: "мець" }, array: { unit: { one: "элемент", few: "элементы", many: "элементаў" }, verb: "мець" }, set: { unit: { one: "элемент", few: "элементы", many: "элементаў" }, verb: "мець" }, file: { unit: { one: "байт", few: "байты", many: "байтаў" }, verb: "мець" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "увод", email: "email адрас", url: "URL", emoji: "эмодзі", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO дата і час", date: "ISO дата", time: "ISO час", duration: "ISO працягласць", ipv4: "IPv4 адрас", ipv6: "IPv6 адрас", cidrv4: "IPv4 дыяпазон", cidrv6: "IPv6 дыяпазон", base64: "радок у фармаце base64", base64url: "радок у фармаце base64url", json_string: "JSON радок", e164: "нумар E.164", jwt: "JWT", template_literal: "увод" }, t = { nan: "NaN", number: "лік", array: "масіў" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Няправільны ўвод: чакаўся instanceof ${n.expected}, атрымана ${u2}`;
        return `Няправільны ўвод: чакаўся ${v}, атрымана ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Няправільны ўвод: чакалася ${U$1(n.values[0])}`;
        return `Няправільны варыянт: чакаўся адзін з ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) {
          let u2 = Number(n.maximum), l = ll$1(u2, $2.unit.one, $2.unit.few, $2.unit.many);
          return `Занадта вялікі: чакалася, што ${n.origin ?? "значэнне"} павінна ${$2.verb} ${v}${n.maximum.toString()} ${l}`;
        }
        return `Занадта вялікі: чакалася, што ${n.origin ?? "значэнне"} павінна быць ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) {
          let u2 = Number(n.minimum), l = ll$1(u2, $2.unit.one, $2.unit.few, $2.unit.many);
          return `Занадта малы: чакалася, што ${n.origin} павінна ${$2.verb} ${v}${n.minimum.toString()} ${l}`;
        }
        return `Занадта малы: чакалася, што ${n.origin} павінна быць ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Няправільны радок: павінен пачынацца з "${v.prefix}"`;
        if (v.format === "ends_with") return `Няправільны радок: павінен заканчвацца на "${v.suffix}"`;
        if (v.format === "includes") return `Няправільны радок: павінен змяшчаць "${v.includes}"`;
        if (v.format === "regex") return `Няправільны радок: павінен адпавядаць шаблону ${v.pattern}`;
        return `Няправільны ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Няправільны лік: павінен быць кратным ${n.divisor}`;
      case "unrecognized_keys":
        return `Нераспазнаны ${n.keys.length > 1 ? "ключы" : "ключ"}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Няправільны ключ у ${n.origin}`;
      case "invalid_union":
        return "Няправільны ўвод";
      case "invalid_element":
        return `Няправільнае значэнне ў ${n.origin}`;
      default:
        return "Няправільны ўвод";
    }
  };
};
function Mt$1() {
  return { localeError: k6() };
}
var w6 = () => {
  let r2 = { string: { unit: "символа", verb: "да съдържа" }, file: { unit: "байта", verb: "да съдържа" }, array: { unit: "елемента", verb: "да съдържа" }, set: { unit: "елемента", verb: "да съдържа" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "вход", email: "имейл адрес", url: "URL", emoji: "емоджи", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO време", date: "ISO дата", time: "ISO време", duration: "ISO продължителност", ipv4: "IPv4 адрес", ipv6: "IPv6 адрес", cidrv4: "IPv4 диапазон", cidrv6: "IPv6 диапазон", base64: "base64-кодиран низ", base64url: "base64url-кодиран низ", json_string: "JSON низ", e164: "E.164 номер", jwt: "JWT", template_literal: "вход" }, t = { nan: "NaN", number: "число", array: "масив" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Невалиден вход: очакван instanceof ${n.expected}, получен ${u2}`;
        return `Невалиден вход: очакван ${v}, получен ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Невалиден вход: очакван ${U$1(n.values[0])}`;
        return `Невалидна опция: очаквано едно от ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Твърде голямо: очаква се ${n.origin ?? "стойност"} да съдържа ${v}${n.maximum.toString()} ${$2.unit ?? "елемента"}`;
        return `Твърде голямо: очаква се ${n.origin ?? "стойност"} да бъде ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Твърде малко: очаква се ${n.origin} да съдържа ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Твърде малко: очаква се ${n.origin} да бъде ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Невалиден низ: трябва да започва с "${v.prefix}"`;
        if (v.format === "ends_with") return `Невалиден низ: трябва да завършва с "${v.suffix}"`;
        if (v.format === "includes") return `Невалиден низ: трябва да включва "${v.includes}"`;
        if (v.format === "regex") return `Невалиден низ: трябва да съвпада с ${v.pattern}`;
        let $2 = "Невалиден";
        if (v.format === "emoji") $2 = "Невалидно";
        if (v.format === "datetime") $2 = "Невалидно";
        if (v.format === "date") $2 = "Невалидна";
        if (v.format === "time") $2 = "Невалидно";
        if (v.format === "duration") $2 = "Невалидна";
        return `${$2} ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Невалидно число: трябва да бъде кратно на ${n.divisor}`;
      case "unrecognized_keys":
        return `Неразпознат${n.keys.length > 1 ? "и" : ""} ключ${n.keys.length > 1 ? "ове" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Невалиден ключ в ${n.origin}`;
      case "invalid_union":
        return "Невалиден вход";
      case "invalid_element":
        return `Невалидна стойност в ${n.origin}`;
      default:
        return "Невалиден вход";
    }
  };
};
function mt() {
  return { localeError: w6() };
}
var N6 = () => {
  let r2 = { string: { unit: "caràcters", verb: "contenir" }, file: { unit: "bytes", verb: "contenir" }, array: { unit: "elements", verb: "contenir" }, set: { unit: "elements", verb: "contenir" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "entrada", email: "adreça electrònica", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "data i hora ISO", date: "data ISO", time: "hora ISO", duration: "durada ISO", ipv4: "adreça IPv4", ipv6: "adreça IPv6", cidrv4: "rang IPv4", cidrv6: "rang IPv6", base64: "cadena codificada en base64", base64url: "cadena codificada en base64url", json_string: "cadena JSON", e164: "número E.164", jwt: "JWT", template_literal: "entrada" }, t = { nan: "NaN" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Tipus invàlid: s'esperava instanceof ${n.expected}, s'ha rebut ${u2}`;
        return `Tipus invàlid: s'esperava ${v}, s'ha rebut ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Valor invàlid: s'esperava ${U$1(n.values[0])}`;
        return `Opció invàlida: s'esperava una de ${_$1(n.values, " o ")}`;
      case "too_big": {
        let v = n.inclusive ? "com a màxim" : "menys de", $2 = i(n.origin);
        if ($2) return `Massa gran: s'esperava que ${n.origin ?? "el valor"} contingués ${v} ${n.maximum.toString()} ${$2.unit ?? "elements"}`;
        return `Massa gran: s'esperava que ${n.origin ?? "el valor"} fos ${v} ${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? "com a mínim" : "més de", $2 = i(n.origin);
        if ($2) return `Massa petit: s'esperava que ${n.origin} contingués ${v} ${n.minimum.toString()} ${$2.unit}`;
        return `Massa petit: s'esperava que ${n.origin} fos ${v} ${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Format invàlid: ha de començar amb "${v.prefix}"`;
        if (v.format === "ends_with") return `Format invàlid: ha d'acabar amb "${v.suffix}"`;
        if (v.format === "includes") return `Format invàlid: ha d'incloure "${v.includes}"`;
        if (v.format === "regex") return `Format invàlid: ha de coincidir amb el patró ${v.pattern}`;
        return `Format invàlid per a ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Número invàlid: ha de ser múltiple de ${n.divisor}`;
      case "unrecognized_keys":
        return `Clau${n.keys.length > 1 ? "s" : ""} no reconeguda${n.keys.length > 1 ? "s" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Clau invàlida a ${n.origin}`;
      case "invalid_union":
        return "Entrada invàlida";
      case "invalid_element":
        return `Element invàlid a ${n.origin}`;
      default:
        return "Entrada invàlida";
    }
  };
};
function Rt$1() {
  return { localeError: N6() };
}
var O6 = () => {
  let r2 = { string: { unit: "znaků", verb: "mít" }, file: { unit: "bajtů", verb: "mít" }, array: { unit: "prvků", verb: "mít" }, set: { unit: "prvků", verb: "mít" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "regulární výraz", email: "e-mailová adresa", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "datum a čas ve formátu ISO", date: "datum ve formátu ISO", time: "čas ve formátu ISO", duration: "doba trvání ISO", ipv4: "IPv4 adresa", ipv6: "IPv6 adresa", cidrv4: "rozsah IPv4", cidrv6: "rozsah IPv6", base64: "řetězec zakódovaný ve formátu base64", base64url: "řetězec zakódovaný ve formátu base64url", json_string: "řetězec ve formátu JSON", e164: "číslo E.164", jwt: "JWT", template_literal: "vstup" }, t = { nan: "NaN", number: "číslo", string: "řetězec", function: "funkce", array: "pole" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Neplatný vstup: očekáváno instanceof ${n.expected}, obdrženo ${u2}`;
        return `Neplatný vstup: očekáváno ${v}, obdrženo ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Neplatný vstup: očekáváno ${U$1(n.values[0])}`;
        return `Neplatná možnost: očekávána jedna z hodnot ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Hodnota je příliš velká: ${n.origin ?? "hodnota"} musí mít ${v}${n.maximum.toString()} ${$2.unit ?? "prvků"}`;
        return `Hodnota je příliš velká: ${n.origin ?? "hodnota"} musí být ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Hodnota je příliš malá: ${n.origin ?? "hodnota"} musí mít ${v}${n.minimum.toString()} ${$2.unit ?? "prvků"}`;
        return `Hodnota je příliš malá: ${n.origin ?? "hodnota"} musí být ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Neplatný řetězec: musí začínat na "${v.prefix}"`;
        if (v.format === "ends_with") return `Neplatný řetězec: musí končit na "${v.suffix}"`;
        if (v.format === "includes") return `Neplatný řetězec: musí obsahovat "${v.includes}"`;
        if (v.format === "regex") return `Neplatný řetězec: musí odpovídat vzoru ${v.pattern}`;
        return `Neplatný formát ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Neplatné číslo: musí být násobkem ${n.divisor}`;
      case "unrecognized_keys":
        return `Neznámé klíče: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Neplatný klíč v ${n.origin}`;
      case "invalid_union":
        return "Neplatný vstup";
      case "invalid_element":
        return `Neplatná hodnota v ${n.origin}`;
      default:
        return "Neplatný vstup";
    }
  };
};
function xt$1() {
  return { localeError: O6() };
}
var S6 = () => {
  let r2 = { string: { unit: "tegn", verb: "havde" }, file: { unit: "bytes", verb: "havde" }, array: { unit: "elementer", verb: "indeholdt" }, set: { unit: "elementer", verb: "indeholdt" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "input", email: "e-mailadresse", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO dato- og klokkeslæt", date: "ISO-dato", time: "ISO-klokkeslæt", duration: "ISO-varighed", ipv4: "IPv4-område", ipv6: "IPv6-område", cidrv4: "IPv4-spektrum", cidrv6: "IPv6-spektrum", base64: "base64-kodet streng", base64url: "base64url-kodet streng", json_string: "JSON-streng", e164: "E.164-nummer", jwt: "JWT", template_literal: "input" }, t = { nan: "NaN", string: "streng", number: "tal", boolean: "boolean", array: "liste", object: "objekt", set: "sæt", file: "fil" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Ugyldigt input: forventede instanceof ${n.expected}, fik ${u2}`;
        return `Ugyldigt input: forventede ${v}, fik ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Ugyldig værdi: forventede ${U$1(n.values[0])}`;
        return `Ugyldigt valg: forventede en af følgende ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin), u2 = t[n.origin] ?? n.origin;
        if ($2) return `For stor: forventede ${u2 ?? "value"} ${$2.verb} ${v} ${n.maximum.toString()} ${$2.unit ?? "elementer"}`;
        return `For stor: forventede ${u2 ?? "value"} havde ${v} ${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin), u2 = t[n.origin] ?? n.origin;
        if ($2) return `For lille: forventede ${u2} ${$2.verb} ${v} ${n.minimum.toString()} ${$2.unit}`;
        return `For lille: forventede ${u2} havde ${v} ${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Ugyldig streng: skal starte med "${v.prefix}"`;
        if (v.format === "ends_with") return `Ugyldig streng: skal ende med "${v.suffix}"`;
        if (v.format === "includes") return `Ugyldig streng: skal indeholde "${v.includes}"`;
        if (v.format === "regex") return `Ugyldig streng: skal matche mønsteret ${v.pattern}`;
        return `Ugyldig ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Ugyldigt tal: skal være deleligt med ${n.divisor}`;
      case "unrecognized_keys":
        return `${n.keys.length > 1 ? "Ukendte nøgler" : "Ukendt nøgle"}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Ugyldig nøgle i ${n.origin}`;
      case "invalid_union":
        return "Ugyldigt input: matcher ingen af de tilladte typer";
      case "invalid_element":
        return `Ugyldig værdi i ${n.origin}`;
      default:
        return "Ugyldigt input";
    }
  };
};
function Zt$1() {
  return { localeError: S6() };
}
var z6 = () => {
  let r2 = { string: { unit: "Zeichen", verb: "zu haben" }, file: { unit: "Bytes", verb: "zu haben" }, array: { unit: "Elemente", verb: "zu haben" }, set: { unit: "Elemente", verb: "zu haben" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "Eingabe", email: "E-Mail-Adresse", url: "URL", emoji: "Emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO-Datum und -Uhrzeit", date: "ISO-Datum", time: "ISO-Uhrzeit", duration: "ISO-Dauer", ipv4: "IPv4-Adresse", ipv6: "IPv6-Adresse", cidrv4: "IPv4-Bereich", cidrv6: "IPv6-Bereich", base64: "Base64-codierter String", base64url: "Base64-URL-codierter String", json_string: "JSON-String", e164: "E.164-Nummer", jwt: "JWT", template_literal: "Eingabe" }, t = { nan: "NaN", number: "Zahl", array: "Array" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Ungültige Eingabe: erwartet instanceof ${n.expected}, erhalten ${u2}`;
        return `Ungültige Eingabe: erwartet ${v}, erhalten ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Ungültige Eingabe: erwartet ${U$1(n.values[0])}`;
        return `Ungültige Option: erwartet eine von ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Zu groß: erwartet, dass ${n.origin ?? "Wert"} ${v}${n.maximum.toString()} ${$2.unit ?? "Elemente"} hat`;
        return `Zu groß: erwartet, dass ${n.origin ?? "Wert"} ${v}${n.maximum.toString()} ist`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Zu klein: erwartet, dass ${n.origin} ${v}${n.minimum.toString()} ${$2.unit} hat`;
        return `Zu klein: erwartet, dass ${n.origin} ${v}${n.minimum.toString()} ist`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Ungültiger String: muss mit "${v.prefix}" beginnen`;
        if (v.format === "ends_with") return `Ungültiger String: muss mit "${v.suffix}" enden`;
        if (v.format === "includes") return `Ungültiger String: muss "${v.includes}" enthalten`;
        if (v.format === "regex") return `Ungültiger String: muss dem Muster ${v.pattern} entsprechen`;
        return `Ungültig: ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Ungültige Zahl: muss ein Vielfaches von ${n.divisor} sein`;
      case "unrecognized_keys":
        return `${n.keys.length > 1 ? "Unbekannte Schlüssel" : "Unbekannter Schlüssel"}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Ungültiger Schlüssel in ${n.origin}`;
      case "invalid_union":
        return "Ungültige Eingabe";
      case "invalid_element":
        return `Ungültiger Wert in ${n.origin}`;
      default:
        return "Ungültige Eingabe";
    }
  };
};
function dt$1() {
  return { localeError: z6() };
}
var P6 = () => {
  let r2 = { string: { unit: "characters", verb: "to have" }, file: { unit: "bytes", verb: "to have" }, array: { unit: "items", verb: "to have" }, set: { unit: "items", verb: "to have" }, map: { unit: "entries", verb: "to have" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "input", email: "email address", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO datetime", date: "ISO date", time: "ISO time", duration: "ISO duration", ipv4: "IPv4 address", ipv6: "IPv6 address", mac: "MAC address", cidrv4: "IPv4 range", cidrv6: "IPv6 range", base64: "base64-encoded string", base64url: "base64url-encoded string", json_string: "JSON string", e164: "E.164 number", jwt: "JWT", template_literal: "input" }, t = { nan: "NaN" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        return `Invalid input: expected ${v}, received ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Invalid input: expected ${U$1(n.values[0])}`;
        return `Invalid option: expected one of ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Too big: expected ${n.origin ?? "value"} to have ${v}${n.maximum.toString()} ${$2.unit ?? "elements"}`;
        return `Too big: expected ${n.origin ?? "value"} to be ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Too small: expected ${n.origin} to have ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Too small: expected ${n.origin} to be ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Invalid string: must start with "${v.prefix}"`;
        if (v.format === "ends_with") return `Invalid string: must end with "${v.suffix}"`;
        if (v.format === "includes") return `Invalid string: must include "${v.includes}"`;
        if (v.format === "regex") return `Invalid string: must match pattern ${v.pattern}`;
        return `Invalid ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Invalid number: must be a multiple of ${n.divisor}`;
      case "unrecognized_keys":
        return `Unrecognized key${n.keys.length > 1 ? "s" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Invalid key in ${n.origin}`;
      case "invalid_union":
        return "Invalid input";
      case "invalid_element":
        return `Invalid value in ${n.origin}`;
      default:
        return "Invalid input";
    }
  };
};
function kn$1() {
  return { localeError: P6() };
}
var j6 = () => {
  let r2 = { string: { unit: "karaktrojn", verb: "havi" }, file: { unit: "bajtojn", verb: "havi" }, array: { unit: "elementojn", verb: "havi" }, set: { unit: "elementojn", verb: "havi" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "enigo", email: "retadreso", url: "URL", emoji: "emoĝio", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO-datotempo", date: "ISO-dato", time: "ISO-tempo", duration: "ISO-daŭro", ipv4: "IPv4-adreso", ipv6: "IPv6-adreso", cidrv4: "IPv4-rango", cidrv6: "IPv6-rango", base64: "64-ume kodita karaktraro", base64url: "URL-64-ume kodita karaktraro", json_string: "JSON-karaktraro", e164: "E.164-nombro", jwt: "JWT", template_literal: "enigo" }, t = { nan: "NaN", number: "nombro", array: "tabelo", null: "senvalora" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Nevalida enigo: atendiĝis instanceof ${n.expected}, riceviĝis ${u2}`;
        return `Nevalida enigo: atendiĝis ${v}, riceviĝis ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Nevalida enigo: atendiĝis ${U$1(n.values[0])}`;
        return `Nevalida opcio: atendiĝis unu el ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Tro granda: atendiĝis ke ${n.origin ?? "valoro"} havu ${v}${n.maximum.toString()} ${$2.unit ?? "elementojn"}`;
        return `Tro granda: atendiĝis ke ${n.origin ?? "valoro"} havu ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Tro malgranda: atendiĝis ke ${n.origin} havu ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Tro malgranda: atendiĝis ke ${n.origin} estu ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Nevalida karaktraro: devas komenciĝi per "${v.prefix}"`;
        if (v.format === "ends_with") return `Nevalida karaktraro: devas finiĝi per "${v.suffix}"`;
        if (v.format === "includes") return `Nevalida karaktraro: devas inkluzivi "${v.includes}"`;
        if (v.format === "regex") return `Nevalida karaktraro: devas kongrui kun la modelo ${v.pattern}`;
        return `Nevalida ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Nevalida nombro: devas esti oblo de ${n.divisor}`;
      case "unrecognized_keys":
        return `Nekonata${n.keys.length > 1 ? "j" : ""} ŝlosilo${n.keys.length > 1 ? "j" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Nevalida ŝlosilo en ${n.origin}`;
      case "invalid_union":
        return "Nevalida enigo";
      case "invalid_element":
        return `Nevalida valoro en ${n.origin}`;
      default:
        return "Nevalida enigo";
    }
  };
};
function Ct$1() {
  return { localeError: j6() };
}
var J6 = () => {
  let r2 = { string: { unit: "caracteres", verb: "tener" }, file: { unit: "bytes", verb: "tener" }, array: { unit: "elementos", verb: "tener" }, set: { unit: "elementos", verb: "tener" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "entrada", email: "dirección de correo electrónico", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "fecha y hora ISO", date: "fecha ISO", time: "hora ISO", duration: "duración ISO", ipv4: "dirección IPv4", ipv6: "dirección IPv6", cidrv4: "rango IPv4", cidrv6: "rango IPv6", base64: "cadena codificada en base64", base64url: "URL codificada en base64", json_string: "cadena JSON", e164: "número E.164", jwt: "JWT", template_literal: "entrada" }, t = { nan: "NaN", string: "texto", number: "número", boolean: "booleano", array: "arreglo", object: "objeto", set: "conjunto", file: "archivo", date: "fecha", bigint: "número grande", symbol: "símbolo", undefined: "indefinido", null: "nulo", function: "función", map: "mapa", record: "registro", tuple: "tupla", enum: "enumeración", union: "unión", literal: "literal", promise: "promesa", void: "vacío", never: "nunca", unknown: "desconocido", any: "cualquiera" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Entrada inválida: se esperaba instanceof ${n.expected}, recibido ${u2}`;
        return `Entrada inválida: se esperaba ${v}, recibido ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Entrada inválida: se esperaba ${U$1(n.values[0])}`;
        return `Opción inválida: se esperaba una de ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin), u2 = t[n.origin] ?? n.origin;
        if ($2) return `Demasiado grande: se esperaba que ${u2 ?? "valor"} tuviera ${v}${n.maximum.toString()} ${$2.unit ?? "elementos"}`;
        return `Demasiado grande: se esperaba que ${u2 ?? "valor"} fuera ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin), u2 = t[n.origin] ?? n.origin;
        if ($2) return `Demasiado pequeño: se esperaba que ${u2} tuviera ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Demasiado pequeño: se esperaba que ${u2} fuera ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Cadena inválida: debe comenzar con "${v.prefix}"`;
        if (v.format === "ends_with") return `Cadena inválida: debe terminar en "${v.suffix}"`;
        if (v.format === "includes") return `Cadena inválida: debe incluir "${v.includes}"`;
        if (v.format === "regex") return `Cadena inválida: debe coincidir con el patrón ${v.pattern}`;
        return `Inválido ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Número inválido: debe ser múltiplo de ${n.divisor}`;
      case "unrecognized_keys":
        return `Llave${n.keys.length > 1 ? "s" : ""} desconocida${n.keys.length > 1 ? "s" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Llave inválida en ${t[n.origin] ?? n.origin}`;
      case "invalid_union":
        return "Entrada inválida";
      case "invalid_element":
        return `Valor inválido en ${t[n.origin] ?? n.origin}`;
      default:
        return "Entrada inválida";
    }
  };
};
function ft$1() {
  return { localeError: J6() };
}
var L6 = () => {
  let r2 = { string: { unit: "کاراکتر", verb: "داشته باشد" }, file: { unit: "بایت", verb: "داشته باشد" }, array: { unit: "آیتم", verb: "داشته باشد" }, set: { unit: "آیتم", verb: "داشته باشد" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "ورودی", email: "آدرس ایمیل", url: "URL", emoji: "ایموجی", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "تاریخ و زمان ایزو", date: "تاریخ ایزو", time: "زمان ایزو", duration: "مدت زمان ایزو", ipv4: "IPv4 آدرس", ipv6: "IPv6 آدرس", cidrv4: "IPv4 دامنه", cidrv6: "IPv6 دامنه", base64: "base64-encoded رشته", base64url: "base64url-encoded رشته", json_string: "JSON رشته", e164: "E.164 عدد", jwt: "JWT", template_literal: "ورودی" }, t = { nan: "NaN", number: "عدد", array: "آرایه" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `ورودی نامعتبر: می‌بایست instanceof ${n.expected} می‌بود، ${u2} دریافت شد`;
        return `ورودی نامعتبر: می‌بایست ${v} می‌بود، ${u2} دریافت شد`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `ورودی نامعتبر: می‌بایست ${U$1(n.values[0])} می‌بود`;
        return `گزینه نامعتبر: می‌بایست یکی از ${_$1(n.values, "|")} می‌بود`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `خیلی بزرگ: ${n.origin ?? "مقدار"} باید ${v}${n.maximum.toString()} ${$2.unit ?? "عنصر"} باشد`;
        return `خیلی بزرگ: ${n.origin ?? "مقدار"} باید ${v}${n.maximum.toString()} باشد`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `خیلی کوچک: ${n.origin} باید ${v}${n.minimum.toString()} ${$2.unit} باشد`;
        return `خیلی کوچک: ${n.origin} باید ${v}${n.minimum.toString()} باشد`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `رشته نامعتبر: باید با "${v.prefix}" شروع شود`;
        if (v.format === "ends_with") return `رشته نامعتبر: باید با "${v.suffix}" تمام شود`;
        if (v.format === "includes") return `رشته نامعتبر: باید شامل "${v.includes}" باشد`;
        if (v.format === "regex") return `رشته نامعتبر: باید با الگوی ${v.pattern} مطابقت داشته باشد`;
        return `${o[v.format] ?? n.format} نامعتبر`;
      }
      case "not_multiple_of":
        return `عدد نامعتبر: باید مضرب ${n.divisor} باشد`;
      case "unrecognized_keys":
        return `کلید${n.keys.length > 1 ? "های" : ""} ناشناس: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `کلید ناشناس در ${n.origin}`;
      case "invalid_union":
        return "ورودی نامعتبر";
      case "invalid_element":
        return `مقدار نامعتبر در ${n.origin}`;
      default:
        return "ورودی نامعتبر";
    }
  };
};
function yt$1() {
  return { localeError: L6() };
}
var E6 = () => {
  let r2 = { string: { unit: "merkkiä", subject: "merkkijonon" }, file: { unit: "tavua", subject: "tiedoston" }, array: { unit: "alkiota", subject: "listan" }, set: { unit: "alkiota", subject: "joukon" }, number: { unit: "", subject: "luvun" }, bigint: { unit: "", subject: "suuren kokonaisluvun" }, int: { unit: "", subject: "kokonaisluvun" }, date: { unit: "", subject: "päivämäärän" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "säännöllinen lauseke", email: "sähköpostiosoite", url: "URL-osoite", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO-aikaleima", date: "ISO-päivämäärä", time: "ISO-aika", duration: "ISO-kesto", ipv4: "IPv4-osoite", ipv6: "IPv6-osoite", cidrv4: "IPv4-alue", cidrv6: "IPv6-alue", base64: "base64-koodattu merkkijono", base64url: "base64url-koodattu merkkijono", json_string: "JSON-merkkijono", e164: "E.164-luku", jwt: "JWT", template_literal: "templaattimerkkijono" }, t = { nan: "NaN" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Virheellinen tyyppi: odotettiin instanceof ${n.expected}, oli ${u2}`;
        return `Virheellinen tyyppi: odotettiin ${v}, oli ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Virheellinen syöte: täytyy olla ${U$1(n.values[0])}`;
        return `Virheellinen valinta: täytyy olla yksi seuraavista: ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Liian suuri: ${$2.subject} täytyy olla ${v}${n.maximum.toString()} ${$2.unit}`.trim();
        return `Liian suuri: arvon täytyy olla ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Liian pieni: ${$2.subject} täytyy olla ${v}${n.minimum.toString()} ${$2.unit}`.trim();
        return `Liian pieni: arvon täytyy olla ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Virheellinen syöte: täytyy alkaa "${v.prefix}"`;
        if (v.format === "ends_with") return `Virheellinen syöte: täytyy loppua "${v.suffix}"`;
        if (v.format === "includes") return `Virheellinen syöte: täytyy sisältää "${v.includes}"`;
        if (v.format === "regex") return `Virheellinen syöte: täytyy vastata säännöllistä lauseketta ${v.pattern}`;
        return `Virheellinen ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Virheellinen luku: täytyy olla luvun ${n.divisor} monikerta`;
      case "unrecognized_keys":
        return `${n.keys.length > 1 ? "Tuntemattomat avaimet" : "Tuntematon avain"}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return "Virheellinen avain tietueessa";
      case "invalid_union":
        return "Virheellinen unioni";
      case "invalid_element":
        return "Virheellinen arvo joukossa";
      default:
        return "Virheellinen syöte";
    }
  };
};
function ht$1() {
  return { localeError: E6() };
}
var G6 = () => {
  let r2 = { string: { unit: "caractères", verb: "avoir" }, file: { unit: "octets", verb: "avoir" }, array: { unit: "éléments", verb: "avoir" }, set: { unit: "éléments", verb: "avoir" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "entrée", email: "adresse e-mail", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "date et heure ISO", date: "date ISO", time: "heure ISO", duration: "durée ISO", ipv4: "adresse IPv4", ipv6: "adresse IPv6", cidrv4: "plage IPv4", cidrv6: "plage IPv6", base64: "chaîne encodée en base64", base64url: "chaîne encodée en base64url", json_string: "chaîne JSON", e164: "numéro E.164", jwt: "JWT", template_literal: "entrée" }, t = { nan: "NaN", number: "nombre", array: "tableau" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Entrée invalide : instanceof ${n.expected} attendu, ${u2} reçu`;
        return `Entrée invalide : ${v} attendu, ${u2} reçu`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Entrée invalide : ${U$1(n.values[0])} attendu`;
        return `Option invalide : une valeur parmi ${_$1(n.values, "|")} attendue`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Trop grand : ${n.origin ?? "valeur"} doit ${$2.verb} ${v}${n.maximum.toString()} ${$2.unit ?? "élément(s)"}`;
        return `Trop grand : ${n.origin ?? "valeur"} doit être ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Trop petit : ${n.origin} doit ${$2.verb} ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Trop petit : ${n.origin} doit être ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Chaîne invalide : doit commencer par "${v.prefix}"`;
        if (v.format === "ends_with") return `Chaîne invalide : doit se terminer par "${v.suffix}"`;
        if (v.format === "includes") return `Chaîne invalide : doit inclure "${v.includes}"`;
        if (v.format === "regex") return `Chaîne invalide : doit correspondre au modèle ${v.pattern}`;
        return `${o[v.format] ?? n.format} invalide`;
      }
      case "not_multiple_of":
        return `Nombre invalide : doit être un multiple de ${n.divisor}`;
      case "unrecognized_keys":
        return `Clé${n.keys.length > 1 ? "s" : ""} non reconnue${n.keys.length > 1 ? "s" : ""} : ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Clé invalide dans ${n.origin}`;
      case "invalid_union":
        return "Entrée invalide";
      case "invalid_element":
        return `Valeur invalide dans ${n.origin}`;
      default:
        return "Entrée invalide";
    }
  };
};
function at$1() {
  return { localeError: G6() };
}
var W6 = () => {
  let r2 = { string: { unit: "caractères", verb: "avoir" }, file: { unit: "octets", verb: "avoir" }, array: { unit: "éléments", verb: "avoir" }, set: { unit: "éléments", verb: "avoir" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "entrée", email: "adresse courriel", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "date-heure ISO", date: "date ISO", time: "heure ISO", duration: "durée ISO", ipv4: "adresse IPv4", ipv6: "adresse IPv6", cidrv4: "plage IPv4", cidrv6: "plage IPv6", base64: "chaîne encodée en base64", base64url: "chaîne encodée en base64url", json_string: "chaîne JSON", e164: "numéro E.164", jwt: "JWT", template_literal: "entrée" }, t = { nan: "NaN" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Entrée invalide : attendu instanceof ${n.expected}, reçu ${u2}`;
        return `Entrée invalide : attendu ${v}, reçu ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Entrée invalide : attendu ${U$1(n.values[0])}`;
        return `Option invalide : attendu l'une des valeurs suivantes ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "≤" : "<", $2 = i(n.origin);
        if ($2) return `Trop grand : attendu que ${n.origin ?? "la valeur"} ait ${v}${n.maximum.toString()} ${$2.unit}`;
        return `Trop grand : attendu que ${n.origin ?? "la valeur"} soit ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? "≥" : ">", $2 = i(n.origin);
        if ($2) return `Trop petit : attendu que ${n.origin} ait ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Trop petit : attendu que ${n.origin} soit ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Chaîne invalide : doit commencer par "${v.prefix}"`;
        if (v.format === "ends_with") return `Chaîne invalide : doit se terminer par "${v.suffix}"`;
        if (v.format === "includes") return `Chaîne invalide : doit inclure "${v.includes}"`;
        if (v.format === "regex") return `Chaîne invalide : doit correspondre au motif ${v.pattern}`;
        return `${o[v.format] ?? n.format} invalide`;
      }
      case "not_multiple_of":
        return `Nombre invalide : doit être un multiple de ${n.divisor}`;
      case "unrecognized_keys":
        return `Clé${n.keys.length > 1 ? "s" : ""} non reconnue${n.keys.length > 1 ? "s" : ""} : ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Clé invalide dans ${n.origin}`;
      case "invalid_union":
        return "Entrée invalide";
      case "invalid_element":
        return `Valeur invalide dans ${n.origin}`;
      default:
        return "Entrée invalide";
    }
  };
};
function pt$1() {
  return { localeError: W6() };
}
var X6 = () => {
  let r2 = { string: { label: "מחרוזת", gender: "f" }, number: { label: "מספר", gender: "m" }, boolean: { label: "ערך בוליאני", gender: "m" }, bigint: { label: "BigInt", gender: "m" }, date: { label: "תאריך", gender: "m" }, array: { label: "מערך", gender: "m" }, object: { label: "אובייקט", gender: "m" }, null: { label: "ערך ריק (null)", gender: "m" }, undefined: { label: "ערך לא מוגדר (undefined)", gender: "m" }, symbol: { label: "סימבול (Symbol)", gender: "m" }, function: { label: "פונקציה", gender: "f" }, map: { label: "מפה (Map)", gender: "f" }, set: { label: "קבוצה (Set)", gender: "f" }, file: { label: "קובץ", gender: "m" }, promise: { label: "Promise", gender: "m" }, NaN: { label: "NaN", gender: "m" }, unknown: { label: "ערך לא ידוע", gender: "m" }, value: { label: "ערך", gender: "m" } }, i = { string: { unit: "תווים", shortLabel: "קצר", longLabel: "ארוך" }, file: { unit: "בייטים", shortLabel: "קטן", longLabel: "גדול" }, array: { unit: "פריטים", shortLabel: "קטן", longLabel: "גדול" }, set: { unit: "פריטים", shortLabel: "קטן", longLabel: "גדול" }, number: { unit: "", shortLabel: "קטן", longLabel: "גדול" } }, o = (e) => e ? r2[e] : void 0, t = (e) => {
    let c = o(e);
    if (c) return c.label;
    return e ?? r2.unknown.label;
  }, n = (e) => `ה${t(e)}`, v = (e) => {
    return (o(e)?.gender ?? "m") === "f" ? "צריכה להיות" : "צריך להיות";
  }, $2 = (e) => {
    if (!e) return null;
    return i[e] ?? null;
  }, u2 = { regex: { label: "קלט", gender: "m" }, email: { label: "כתובת אימייל", gender: "f" }, url: { label: "כתובת רשת", gender: "f" }, emoji: { label: "אימוג'י", gender: "m" }, uuid: { label: "UUID", gender: "m" }, nanoid: { label: "nanoid", gender: "m" }, guid: { label: "GUID", gender: "m" }, cuid: { label: "cuid", gender: "m" }, cuid2: { label: "cuid2", gender: "m" }, ulid: { label: "ULID", gender: "m" }, xid: { label: "XID", gender: "m" }, ksuid: { label: "KSUID", gender: "m" }, datetime: { label: "תאריך וזמן ISO", gender: "m" }, date: { label: "תאריך ISO", gender: "m" }, time: { label: "זמן ISO", gender: "m" }, duration: { label: "משך זמן ISO", gender: "m" }, ipv4: { label: "כתובת IPv4", gender: "f" }, ipv6: { label: "כתובת IPv6", gender: "f" }, cidrv4: { label: "טווח IPv4", gender: "m" }, cidrv6: { label: "טווח IPv6", gender: "m" }, base64: { label: "מחרוזת בבסיס 64", gender: "f" }, base64url: { label: "מחרוזת בבסיס 64 לכתובות רשת", gender: "f" }, json_string: { label: "מחרוזת JSON", gender: "f" }, e164: { label: "מספר E.164", gender: "m" }, jwt: { label: "JWT", gender: "m" }, ends_with: { label: "קלט", gender: "m" }, includes: { label: "קלט", gender: "m" }, lowercase: { label: "קלט", gender: "m" }, starts_with: { label: "קלט", gender: "m" }, uppercase: { label: "קלט", gender: "m" } }, l = { nan: "NaN" };
  return (e) => {
    switch (e.code) {
      case "invalid_type": {
        let c = e.expected, b = l[c ?? ""] ?? t(c), N2 = D$2(e.input), O = l[N2] ?? r2[N2]?.label ?? N2;
        if (/^[A-Z]/.test(e.expected)) return `קלט לא תקין: צריך להיות instanceof ${e.expected}, התקבל ${O}`;
        return `קלט לא תקין: צריך להיות ${b}, התקבל ${O}`;
      }
      case "invalid_value": {
        if (e.values.length === 1) return `ערך לא תקין: הערך חייב להיות ${U$1(e.values[0])}`;
        let c = e.values.map((O) => U$1(O));
        if (e.values.length === 2) return `ערך לא תקין: האפשרויות המתאימות הן ${c[0]} או ${c[1]}`;
        let b = c[c.length - 1];
        return `ערך לא תקין: האפשרויות המתאימות הן ${c.slice(0, -1).join(", ")} או ${b}`;
      }
      case "too_big": {
        let c = $2(e.origin), b = n(e.origin ?? "value");
        if (e.origin === "string") return `${c?.longLabel ?? "ארוך"} מדי: ${b} צריכה להכיל ${e.maximum.toString()} ${c?.unit ?? ""} ${e.inclusive ? "או פחות" : "לכל היותר"}`.trim();
        if (e.origin === "number") {
          let J2 = e.inclusive ? `קטן או שווה ל-${e.maximum}` : `קטן מ-${e.maximum}`;
          return `גדול מדי: ${b} צריך להיות ${J2}`;
        }
        if (e.origin === "array" || e.origin === "set") {
          let J2 = e.origin === "set" ? "צריכה" : "צריך", X2 = e.inclusive ? `${e.maximum} ${c?.unit ?? ""} או פחות` : `פחות מ-${e.maximum} ${c?.unit ?? ""}`;
          return `גדול מדי: ${b} ${J2} להכיל ${X2}`.trim();
        }
        let N2 = e.inclusive ? "<=" : "<", O = v(e.origin ?? "value");
        if (c?.unit) return `${c.longLabel} מדי: ${b} ${O} ${N2}${e.maximum.toString()} ${c.unit}`;
        return `${c?.longLabel ?? "גדול"} מדי: ${b} ${O} ${N2}${e.maximum.toString()}`;
      }
      case "too_small": {
        let c = $2(e.origin), b = n(e.origin ?? "value");
        if (e.origin === "string") return `${c?.shortLabel ?? "קצר"} מדי: ${b} צריכה להכיל ${e.minimum.toString()} ${c?.unit ?? ""} ${e.inclusive ? "או יותר" : "לפחות"}`.trim();
        if (e.origin === "number") {
          let J2 = e.inclusive ? `גדול או שווה ל-${e.minimum}` : `גדול מ-${e.minimum}`;
          return `קטן מדי: ${b} צריך להיות ${J2}`;
        }
        if (e.origin === "array" || e.origin === "set") {
          let J2 = e.origin === "set" ? "צריכה" : "צריך";
          if (e.minimum === 1 && e.inclusive) {
            let Sr2 = e.origin === "set" ? "לפחות פריט אחד" : "לפחות פריט אחד";
            return `קטן מדי: ${b} ${J2} להכיל ${Sr2}`;
          }
          let X2 = e.inclusive ? `${e.minimum} ${c?.unit ?? ""} או יותר` : `יותר מ-${e.minimum} ${c?.unit ?? ""}`;
          return `קטן מדי: ${b} ${J2} להכיל ${X2}`.trim();
        }
        let N2 = e.inclusive ? ">=" : ">", O = v(e.origin ?? "value");
        if (c?.unit) return `${c.shortLabel} מדי: ${b} ${O} ${N2}${e.minimum.toString()} ${c.unit}`;
        return `${c?.shortLabel ?? "קטן"} מדי: ${b} ${O} ${N2}${e.minimum.toString()}`;
      }
      case "invalid_format": {
        let c = e;
        if (c.format === "starts_with") return `המחרוזת חייבת להתחיל ב "${c.prefix}"`;
        if (c.format === "ends_with") return `המחרוזת חייבת להסתיים ב "${c.suffix}"`;
        if (c.format === "includes") return `המחרוזת חייבת לכלול "${c.includes}"`;
        if (c.format === "regex") return `המחרוזת חייבת להתאים לתבנית ${c.pattern}`;
        let b = u2[c.format], N2 = b?.label ?? c.format, J2 = (b?.gender ?? "m") === "f" ? "תקינה" : "תקין";
        return `${N2} לא ${J2}`;
      }
      case "not_multiple_of":
        return `מספר לא תקין: חייב להיות מכפלה של ${e.divisor}`;
      case "unrecognized_keys":
        return `מפתח${e.keys.length > 1 ? "ות" : ""} לא מזוה${e.keys.length > 1 ? "ים" : "ה"}: ${_$1(e.keys, ", ")}`;
      case "invalid_key":
        return "שדה לא תקין באובייקט";
      case "invalid_union":
        return "קלט לא תקין";
      case "invalid_element":
        return `ערך לא תקין ב${n(e.origin ?? "array")}`;
      default:
        return "קלט לא תקין";
    }
  };
};
function st$1() {
  return { localeError: X6() };
}
var A6 = () => {
  let r2 = { string: { unit: "karakter", verb: "legyen" }, file: { unit: "byte", verb: "legyen" }, array: { unit: "elem", verb: "legyen" }, set: { unit: "elem", verb: "legyen" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "bemenet", email: "email cím", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO időbélyeg", date: "ISO dátum", time: "ISO idő", duration: "ISO időintervallum", ipv4: "IPv4 cím", ipv6: "IPv6 cím", cidrv4: "IPv4 tartomány", cidrv6: "IPv6 tartomány", base64: "base64-kódolt string", base64url: "base64url-kódolt string", json_string: "JSON string", e164: "E.164 szám", jwt: "JWT", template_literal: "bemenet" }, t = { nan: "NaN", number: "szám", array: "tömb" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Érvénytelen bemenet: a várt érték instanceof ${n.expected}, a kapott érték ${u2}`;
        return `Érvénytelen bemenet: a várt érték ${v}, a kapott érték ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Érvénytelen bemenet: a várt érték ${U$1(n.values[0])}`;
        return `Érvénytelen opció: valamelyik érték várt ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Túl nagy: ${n.origin ?? "érték"} mérete túl nagy ${v}${n.maximum.toString()} ${$2.unit ?? "elem"}`;
        return `Túl nagy: a bemeneti érték ${n.origin ?? "érték"} túl nagy: ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Túl kicsi: a bemeneti érték ${n.origin} mérete túl kicsi ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Túl kicsi: a bemeneti érték ${n.origin} túl kicsi ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Érvénytelen string: "${v.prefix}" értékkel kell kezdődnie`;
        if (v.format === "ends_with") return `Érvénytelen string: "${v.suffix}" értékkel kell végződnie`;
        if (v.format === "includes") return `Érvénytelen string: "${v.includes}" értéket kell tartalmaznia`;
        if (v.format === "regex") return `Érvénytelen string: ${v.pattern} mintának kell megfelelnie`;
        return `Érvénytelen ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Érvénytelen szám: ${n.divisor} többszörösének kell lennie`;
      case "unrecognized_keys":
        return `Ismeretlen kulcs${n.keys.length > 1 ? "s" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Érvénytelen kulcs ${n.origin}`;
      case "invalid_union":
        return "Érvénytelen bemenet";
      case "invalid_element":
        return `Érvénytelen érték: ${n.origin}`;
      default:
        return "Érvénytelen bemenet";
    }
  };
};
function r$() {
  return { localeError: A6() };
}
function Il$1(r2, i, o) {
  return Math.abs(r2) === 1 ? i : o;
}
function Ar$1(r2) {
  if (!r2) return "";
  let i = ["ա", "ե", "ը", "ի", "ո", "ու", "օ"], o = r2[r2.length - 1];
  return r2 + (i.includes(o) ? "ն" : "ը");
}
var V6 = () => {
  let r2 = { string: { unit: { one: "նշան", many: "նշաններ" }, verb: "ունենալ" }, file: { unit: { one: "բայթ", many: "բայթեր" }, verb: "ունենալ" }, array: { unit: { one: "տարր", many: "տարրեր" }, verb: "ունենալ" }, set: { unit: { one: "տարր", many: "տարրեր" }, verb: "ունենալ" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "մուտք", email: "էլ. հասցե", url: "URL", emoji: "էմոջի", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO ամսաթիվ և ժամ", date: "ISO ամսաթիվ", time: "ISO ժամ", duration: "ISO տևողություն", ipv4: "IPv4 հասցե", ipv6: "IPv6 հասցե", cidrv4: "IPv4 միջակայք", cidrv6: "IPv6 միջակայք", base64: "base64 ձևաչափով տող", base64url: "base64url ձևաչափով տող", json_string: "JSON տող", e164: "E.164 համար", jwt: "JWT", template_literal: "մուտք" }, t = { nan: "NaN", number: "թիվ", array: "զանգված" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Սխալ մուտքագրում․ սպասվում էր instanceof ${n.expected}, ստացվել է ${u2}`;
        return `Սխալ մուտքագրում․ սպասվում էր ${v}, ստացվել է ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Սխալ մուտքագրում․ սպասվում էր ${U$1(n.values[1])}`;
        return `Սխալ տարբերակ․ սպասվում էր հետևյալներից մեկը՝ ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) {
          let u2 = Number(n.maximum), l = Il$1(u2, $2.unit.one, $2.unit.many);
          return `Չափազանց մեծ արժեք․ սպասվում է, որ ${Ar$1(n.origin ?? "արժեք")} կունենա ${v}${n.maximum.toString()} ${l}`;
        }
        return `Չափազանց մեծ արժեք․ սպասվում է, որ ${Ar$1(n.origin ?? "արժեք")} լինի ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) {
          let u2 = Number(n.minimum), l = Il$1(u2, $2.unit.one, $2.unit.many);
          return `Չափազանց փոքր արժեք․ սպասվում է, որ ${Ar$1(n.origin)} կունենա ${v}${n.minimum.toString()} ${l}`;
        }
        return `Չափազանց փոքր արժեք․ սպասվում է, որ ${Ar$1(n.origin)} լինի ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Սխալ տող․ պետք է սկսվի "${v.prefix}"-ով`;
        if (v.format === "ends_with") return `Սխալ տող․ պետք է ավարտվի "${v.suffix}"-ով`;
        if (v.format === "includes") return `Սխալ տող․ պետք է պարունակի "${v.includes}"`;
        if (v.format === "regex") return `Սխալ տող․ պետք է համապատասխանի ${v.pattern} ձևաչափին`;
        return `Սխալ ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Սխալ թիվ․ պետք է բազմապատիկ լինի ${n.divisor}-ի`;
      case "unrecognized_keys":
        return `Չճանաչված բանալի${n.keys.length > 1 ? "ներ" : ""}. ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Սխալ բանալի ${Ar$1(n.origin)}-ում`;
      case "invalid_union":
        return "Սխալ մուտքագրում";
      case "invalid_element":
        return `Սխալ արժեք ${Ar$1(n.origin)}-ում`;
      default:
        return "Սխալ մուտքագրում";
    }
  };
};
function n$() {
  return { localeError: V6() };
}
var K6 = () => {
  let r2 = { string: { unit: "karakter", verb: "memiliki" }, file: { unit: "byte", verb: "memiliki" }, array: { unit: "item", verb: "memiliki" }, set: { unit: "item", verb: "memiliki" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "input", email: "alamat email", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "tanggal dan waktu format ISO", date: "tanggal format ISO", time: "jam format ISO", duration: "durasi format ISO", ipv4: "alamat IPv4", ipv6: "alamat IPv6", cidrv4: "rentang alamat IPv4", cidrv6: "rentang alamat IPv6", base64: "string dengan enkode base64", base64url: "string dengan enkode base64url", json_string: "string JSON", e164: "angka E.164", jwt: "JWT", template_literal: "input" }, t = { nan: "NaN" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Input tidak valid: diharapkan instanceof ${n.expected}, diterima ${u2}`;
        return `Input tidak valid: diharapkan ${v}, diterima ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Input tidak valid: diharapkan ${U$1(n.values[0])}`;
        return `Pilihan tidak valid: diharapkan salah satu dari ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Terlalu besar: diharapkan ${n.origin ?? "value"} memiliki ${v}${n.maximum.toString()} ${$2.unit ?? "elemen"}`;
        return `Terlalu besar: diharapkan ${n.origin ?? "value"} menjadi ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Terlalu kecil: diharapkan ${n.origin} memiliki ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Terlalu kecil: diharapkan ${n.origin} menjadi ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `String tidak valid: harus dimulai dengan "${v.prefix}"`;
        if (v.format === "ends_with") return `String tidak valid: harus berakhir dengan "${v.suffix}"`;
        if (v.format === "includes") return `String tidak valid: harus menyertakan "${v.includes}"`;
        if (v.format === "regex") return `String tidak valid: harus sesuai pola ${v.pattern}`;
        return `${o[v.format] ?? n.format} tidak valid`;
      }
      case "not_multiple_of":
        return `Angka tidak valid: harus kelipatan dari ${n.divisor}`;
      case "unrecognized_keys":
        return `Kunci tidak dikenali ${n.keys.length > 1 ? "s" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Kunci tidak valid di ${n.origin}`;
      case "invalid_union":
        return "Input tidak valid";
      case "invalid_element":
        return `Nilai tidak valid di ${n.origin}`;
      default:
        return "Input tidak valid";
    }
  };
};
function i$() {
  return { localeError: K6() };
}
var Y6 = () => {
  let r2 = { string: { unit: "stafi", verb: "að hafa" }, file: { unit: "bæti", verb: "að hafa" }, array: { unit: "hluti", verb: "að hafa" }, set: { unit: "hluti", verb: "að hafa" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "gildi", email: "netfang", url: "vefslóð", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO dagsetning og tími", date: "ISO dagsetning", time: "ISO tími", duration: "ISO tímalengd", ipv4: "IPv4 address", ipv6: "IPv6 address", cidrv4: "IPv4 range", cidrv6: "IPv6 range", base64: "base64-encoded strengur", base64url: "base64url-encoded strengur", json_string: "JSON strengur", e164: "E.164 tölugildi", jwt: "JWT", template_literal: "gildi" }, t = { nan: "NaN", number: "númer", array: "fylki" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Rangt gildi: Þú slóst inn ${u2} þar sem á að vera instanceof ${n.expected}`;
        return `Rangt gildi: Þú slóst inn ${u2} þar sem á að vera ${v}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Rangt gildi: gert ráð fyrir ${U$1(n.values[0])}`;
        return `Ógilt val: má vera eitt af eftirfarandi ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Of stórt: gert er ráð fyrir að ${n.origin ?? "gildi"} hafi ${v}${n.maximum.toString()} ${$2.unit ?? "hluti"}`;
        return `Of stórt: gert er ráð fyrir að ${n.origin ?? "gildi"} sé ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Of lítið: gert er ráð fyrir að ${n.origin} hafi ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Of lítið: gert er ráð fyrir að ${n.origin} sé ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Ógildur strengur: verður að byrja á "${v.prefix}"`;
        if (v.format === "ends_with") return `Ógildur strengur: verður að enda á "${v.suffix}"`;
        if (v.format === "includes") return `Ógildur strengur: verður að innihalda "${v.includes}"`;
        if (v.format === "regex") return `Ógildur strengur: verður að fylgja mynstri ${v.pattern}`;
        return `Rangt ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Röng tala: verður að vera margfeldi af ${n.divisor}`;
      case "unrecognized_keys":
        return `Óþekkt ${n.keys.length > 1 ? "ir lyklar" : "ur lykill"}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Rangur lykill í ${n.origin}`;
      case "invalid_union":
        return "Rangt gildi";
      case "invalid_element":
        return `Rangt gildi í ${n.origin}`;
      default:
        return "Rangt gildi";
    }
  };
};
function v$() {
  return { localeError: Y6() };
}
var Q6 = () => {
  let r2 = { string: { unit: "caratteri", verb: "avere" }, file: { unit: "byte", verb: "avere" }, array: { unit: "elementi", verb: "avere" }, set: { unit: "elementi", verb: "avere" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "input", email: "indirizzo email", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "data e ora ISO", date: "data ISO", time: "ora ISO", duration: "durata ISO", ipv4: "indirizzo IPv4", ipv6: "indirizzo IPv6", cidrv4: "intervallo IPv4", cidrv6: "intervallo IPv6", base64: "stringa codificata in base64", base64url: "URL codificata in base64", json_string: "stringa JSON", e164: "numero E.164", jwt: "JWT", template_literal: "input" }, t = { nan: "NaN", number: "numero", array: "vettore" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Input non valido: atteso instanceof ${n.expected}, ricevuto ${u2}`;
        return `Input non valido: atteso ${v}, ricevuto ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Input non valido: atteso ${U$1(n.values[0])}`;
        return `Opzione non valida: atteso uno tra ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Troppo grande: ${n.origin ?? "valore"} deve avere ${v}${n.maximum.toString()} ${$2.unit ?? "elementi"}`;
        return `Troppo grande: ${n.origin ?? "valore"} deve essere ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Troppo piccolo: ${n.origin} deve avere ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Troppo piccolo: ${n.origin} deve essere ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Stringa non valida: deve iniziare con "${v.prefix}"`;
        if (v.format === "ends_with") return `Stringa non valida: deve terminare con "${v.suffix}"`;
        if (v.format === "includes") return `Stringa non valida: deve includere "${v.includes}"`;
        if (v.format === "regex") return `Stringa non valida: deve corrispondere al pattern ${v.pattern}`;
        return `Invalid ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Numero non valido: deve essere un multiplo di ${n.divisor}`;
      case "unrecognized_keys":
        return `Chiav${n.keys.length > 1 ? "i" : "e"} non riconosciut${n.keys.length > 1 ? "e" : "a"}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Chiave non valida in ${n.origin}`;
      case "invalid_union":
        return "Input non valido";
      case "invalid_element":
        return `Valore non valido in ${n.origin}`;
      default:
        return "Input non valido";
    }
  };
};
function o$() {
  return { localeError: Q6() };
}
var T6 = () => {
  let r2 = { string: { unit: "文字", verb: "である" }, file: { unit: "バイト", verb: "である" }, array: { unit: "要素", verb: "である" }, set: { unit: "要素", verb: "である" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "入力値", email: "メールアドレス", url: "URL", emoji: "絵文字", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO日時", date: "ISO日付", time: "ISO時刻", duration: "ISO期間", ipv4: "IPv4アドレス", ipv6: "IPv6アドレス", cidrv4: "IPv4範囲", cidrv6: "IPv6範囲", base64: "base64エンコード文字列", base64url: "base64urlエンコード文字列", json_string: "JSON文字列", e164: "E.164番号", jwt: "JWT", template_literal: "入力値" }, t = { nan: "NaN", number: "数値", array: "配列" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `無効な入力: instanceof ${n.expected}が期待されましたが、${u2}が入力されました`;
        return `無効な入力: ${v}が期待されましたが、${u2}が入力されました`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `無効な入力: ${U$1(n.values[0])}が期待されました`;
        return `無効な選択: ${_$1(n.values, "、")}のいずれかである必要があります`;
      case "too_big": {
        let v = n.inclusive ? "以下である" : "より小さい", $2 = i(n.origin);
        if ($2) return `大きすぎる値: ${n.origin ?? "値"}は${n.maximum.toString()}${$2.unit ?? "要素"}${v}必要があります`;
        return `大きすぎる値: ${n.origin ?? "値"}は${n.maximum.toString()}${v}必要があります`;
      }
      case "too_small": {
        let v = n.inclusive ? "以上である" : "より大きい", $2 = i(n.origin);
        if ($2) return `小さすぎる値: ${n.origin}は${n.minimum.toString()}${$2.unit}${v}必要があります`;
        return `小さすぎる値: ${n.origin}は${n.minimum.toString()}${v}必要があります`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `無効な文字列: "${v.prefix}"で始まる必要があります`;
        if (v.format === "ends_with") return `無効な文字列: "${v.suffix}"で終わる必要があります`;
        if (v.format === "includes") return `無効な文字列: "${v.includes}"を含む必要があります`;
        if (v.format === "regex") return `無効な文字列: パターン${v.pattern}に一致する必要があります`;
        return `無効な${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `無効な数値: ${n.divisor}の倍数である必要があります`;
      case "unrecognized_keys":
        return `認識されていないキー${n.keys.length > 1 ? "群" : ""}: ${_$1(n.keys, "、")}`;
      case "invalid_key":
        return `${n.origin}内の無効なキー`;
      case "invalid_union":
        return "無効な入力";
      case "invalid_element":
        return `${n.origin}内の無効な値`;
      default:
        return "無効な入力";
    }
  };
};
function t$() {
  return { localeError: T6() };
}
var F6 = () => {
  let r2 = { string: { unit: "სიმბოლო", verb: "უნდა შეიცავდეს" }, file: { unit: "ბაიტი", verb: "უნდა შეიცავდეს" }, array: { unit: "ელემენტი", verb: "უნდა შეიცავდეს" }, set: { unit: "ელემენტი", verb: "უნდა შეიცავდეს" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "შეყვანა", email: "ელ-ფოსტის მისამართი", url: "URL", emoji: "ემოჯი", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "თარიღი-დრო", date: "თარიღი", time: "დრო", duration: "ხანგრძლივობა", ipv4: "IPv4 მისამართი", ipv6: "IPv6 მისამართი", cidrv4: "IPv4 დიაპაზონი", cidrv6: "IPv6 დიაპაზონი", base64: "base64-კოდირებული სტრინგი", base64url: "base64url-კოდირებული სტრინგი", json_string: "JSON სტრინგი", e164: "E.164 ნომერი", jwt: "JWT", template_literal: "შეყვანა" }, t = { nan: "NaN", number: "რიცხვი", string: "სტრინგი", boolean: "ბულეანი", function: "ფუნქცია", array: "მასივი" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `არასწორი შეყვანა: მოსალოდნელი instanceof ${n.expected}, მიღებული ${u2}`;
        return `არასწორი შეყვანა: მოსალოდნელი ${v}, მიღებული ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `არასწორი შეყვანა: მოსალოდნელი ${U$1(n.values[0])}`;
        return `არასწორი ვარიანტი: მოსალოდნელია ერთ-ერთი ${_$1(n.values, "|")}-დან`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `ზედმეტად დიდი: მოსალოდნელი ${n.origin ?? "მნიშვნელობა"} ${$2.verb} ${v}${n.maximum.toString()} ${$2.unit}`;
        return `ზედმეტად დიდი: მოსალოდნელი ${n.origin ?? "მნიშვნელობა"} იყოს ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `ზედმეტად პატარა: მოსალოდნელი ${n.origin} ${$2.verb} ${v}${n.minimum.toString()} ${$2.unit}`;
        return `ზედმეტად პატარა: მოსალოდნელი ${n.origin} იყოს ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `არასწორი სტრინგი: უნდა იწყებოდეს "${v.prefix}"-ით`;
        if (v.format === "ends_with") return `არასწორი სტრინგი: უნდა მთავრდებოდეს "${v.suffix}"-ით`;
        if (v.format === "includes") return `არასწორი სტრინგი: უნდა შეიცავდეს "${v.includes}"-ს`;
        if (v.format === "regex") return `არასწორი სტრინგი: უნდა შეესაბამებოდეს შაბლონს ${v.pattern}`;
        return `არასწორი ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `არასწორი რიცხვი: უნდა იყოს ${n.divisor}-ის ჯერადი`;
      case "unrecognized_keys":
        return `უცნობი გასაღებ${n.keys.length > 1 ? "ები" : "ი"}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `არასწორი გასაღები ${n.origin}-ში`;
      case "invalid_union":
        return "არასწორი შეყვანა";
      case "invalid_element":
        return `არასწორი მნიშვნელობა ${n.origin}-ში`;
      default:
        return "არასწორი შეყვანა";
    }
  };
};
function $$() {
  return { localeError: F6() };
}
var q6 = () => {
  let r2 = { string: { unit: "តួអក្សរ", verb: "គួរមាន" }, file: { unit: "បៃ", verb: "គួរមាន" }, array: { unit: "ធាតុ", verb: "គួរមាន" }, set: { unit: "ធាតុ", verb: "គួរមាន" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "ទិន្នន័យបញ្ចូល", email: "អាសយដ្ឋានអ៊ីមែល", url: "URL", emoji: "សញ្ញាអារម្មណ៍", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "កាលបរិច្ឆេទ និងម៉ោង ISO", date: "កាលបរិច្ឆេទ ISO", time: "ម៉ោង ISO", duration: "រយៈពេល ISO", ipv4: "អាសយដ្ឋាន IPv4", ipv6: "អាសយដ្ឋាន IPv6", cidrv4: "ដែនអាសយដ្ឋាន IPv4", cidrv6: "ដែនអាសយដ្ឋាន IPv6", base64: "ខ្សែអក្សរអ៊ិកូដ base64", base64url: "ខ្សែអក្សរអ៊ិកូដ base64url", json_string: "ខ្សែអក្សរ JSON", e164: "លេខ E.164", jwt: "JWT", template_literal: "ទិន្នន័យបញ្ចូល" }, t = { nan: "NaN", number: "លេខ", array: "អារេ (Array)", null: "គ្មានតម្លៃ (null)" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `ទិន្នន័យបញ្ចូលមិនត្រឹមត្រូវ៖ ត្រូវការ instanceof ${n.expected} ប៉ុន្តែទទួលបាន ${u2}`;
        return `ទិន្នន័យបញ្ចូលមិនត្រឹមត្រូវ៖ ត្រូវការ ${v} ប៉ុន្តែទទួលបាន ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `ទិន្នន័យបញ្ចូលមិនត្រឹមត្រូវ៖ ត្រូវការ ${U$1(n.values[0])}`;
        return `ជម្រើសមិនត្រឹមត្រូវ៖ ត្រូវជាមួយក្នុងចំណោម ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `ធំពេក៖ ត្រូវការ ${n.origin ?? "តម្លៃ"} ${v} ${n.maximum.toString()} ${$2.unit ?? "ធាតុ"}`;
        return `ធំពេក៖ ត្រូវការ ${n.origin ?? "តម្លៃ"} ${v} ${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `តូចពេក៖ ត្រូវការ ${n.origin} ${v} ${n.minimum.toString()} ${$2.unit}`;
        return `តូចពេក៖ ត្រូវការ ${n.origin} ${v} ${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `ខ្សែអក្សរមិនត្រឹមត្រូវ៖ ត្រូវចាប់ផ្តើមដោយ "${v.prefix}"`;
        if (v.format === "ends_with") return `ខ្សែអក្សរមិនត្រឹមត្រូវ៖ ត្រូវបញ្ចប់ដោយ "${v.suffix}"`;
        if (v.format === "includes") return `ខ្សែអក្សរមិនត្រឹមត្រូវ៖ ត្រូវមាន "${v.includes}"`;
        if (v.format === "regex") return `ខ្សែអក្សរមិនត្រឹមត្រូវ៖ ត្រូវតែផ្គូផ្គងនឹងទម្រង់ដែលបានកំណត់ ${v.pattern}`;
        return `មិនត្រឹមត្រូវ៖ ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `លេខមិនត្រឹមត្រូវ៖ ត្រូវតែជាពហុគុណនៃ ${n.divisor}`;
      case "unrecognized_keys":
        return `រកឃើញសោមិនស្គាល់៖ ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `សោមិនត្រឹមត្រូវនៅក្នុង ${n.origin}`;
      case "invalid_union":
        return "ទិន្នន័យមិនត្រឹមត្រូវ";
      case "invalid_element":
        return `ទិន្នន័យមិនត្រឹមត្រូវនៅក្នុង ${n.origin}`;
      default:
        return "ទិន្នន័យមិនត្រឹមត្រូវ";
    }
  };
};
function wn$1() {
  return { localeError: q6() };
}
function u$() {
  return wn$1();
}
var B6 = () => {
  let r2 = { string: { unit: "문자", verb: "to have" }, file: { unit: "바이트", verb: "to have" }, array: { unit: "개", verb: "to have" }, set: { unit: "개", verb: "to have" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "입력", email: "이메일 주소", url: "URL", emoji: "이모지", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO 날짜시간", date: "ISO 날짜", time: "ISO 시간", duration: "ISO 기간", ipv4: "IPv4 주소", ipv6: "IPv6 주소", cidrv4: "IPv4 범위", cidrv6: "IPv6 범위", base64: "base64 인코딩 문자열", base64url: "base64url 인코딩 문자열", json_string: "JSON 문자열", e164: "E.164 번호", jwt: "JWT", template_literal: "입력" }, t = { nan: "NaN" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `잘못된 입력: 예상 타입은 instanceof ${n.expected}, 받은 타입은 ${u2}입니다`;
        return `잘못된 입력: 예상 타입은 ${v}, 받은 타입은 ${u2}입니다`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `잘못된 입력: 값은 ${U$1(n.values[0])} 이어야 합니다`;
        return `잘못된 옵션: ${_$1(n.values, "또는 ")} 중 하나여야 합니다`;
      case "too_big": {
        let v = n.inclusive ? "이하" : "미만", $2 = v === "미만" ? "이어야 합니다" : "여야 합니다", u2 = i(n.origin), l = u2?.unit ?? "요소";
        if (u2) return `${n.origin ?? "값"}이 너무 큽니다: ${n.maximum.toString()}${l} ${v}${$2}`;
        return `${n.origin ?? "값"}이 너무 큽니다: ${n.maximum.toString()} ${v}${$2}`;
      }
      case "too_small": {
        let v = n.inclusive ? "이상" : "초과", $2 = v === "이상" ? "이어야 합니다" : "여야 합니다", u2 = i(n.origin), l = u2?.unit ?? "요소";
        if (u2) return `${n.origin ?? "값"}이 너무 작습니다: ${n.minimum.toString()}${l} ${v}${$2}`;
        return `${n.origin ?? "값"}이 너무 작습니다: ${n.minimum.toString()} ${v}${$2}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `잘못된 문자열: "${v.prefix}"(으)로 시작해야 합니다`;
        if (v.format === "ends_with") return `잘못된 문자열: "${v.suffix}"(으)로 끝나야 합니다`;
        if (v.format === "includes") return `잘못된 문자열: "${v.includes}"을(를) 포함해야 합니다`;
        if (v.format === "regex") return `잘못된 문자열: 정규식 ${v.pattern} 패턴과 일치해야 합니다`;
        return `잘못된 ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `잘못된 숫자: ${n.divisor}의 배수여야 합니다`;
      case "unrecognized_keys":
        return `인식할 수 없는 키: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `잘못된 키: ${n.origin}`;
      case "invalid_union":
        return "잘못된 입력";
      case "invalid_element":
        return `잘못된 값: ${n.origin}`;
      default:
        return "잘못된 입력";
    }
  };
};
function g$() {
  return { localeError: B6() };
}
var Nn$1 = (r2) => {
  return r2.charAt(0).toUpperCase() + r2.slice(1);
};
function cl$1(r2) {
  let i = Math.abs(r2), o = i % 10, t = i % 100;
  if (t >= 11 && t <= 19 || o === 0) return "many";
  if (o === 1) return "one";
  return "few";
}
var H6 = () => {
  let r2 = { string: { unit: { one: "simbolis", few: "simboliai", many: "simbolių" }, verb: { smaller: { inclusive: "turi būti ne ilgesnė kaip", notInclusive: "turi būti trumpesnė kaip" }, bigger: { inclusive: "turi būti ne trumpesnė kaip", notInclusive: "turi būti ilgesnė kaip" } } }, file: { unit: { one: "baitas", few: "baitai", many: "baitų" }, verb: { smaller: { inclusive: "turi būti ne didesnis kaip", notInclusive: "turi būti mažesnis kaip" }, bigger: { inclusive: "turi būti ne mažesnis kaip", notInclusive: "turi būti didesnis kaip" } } }, array: { unit: { one: "elementą", few: "elementus", many: "elementų" }, verb: { smaller: { inclusive: "turi turėti ne daugiau kaip", notInclusive: "turi turėti mažiau kaip" }, bigger: { inclusive: "turi turėti ne mažiau kaip", notInclusive: "turi turėti daugiau kaip" } } }, set: { unit: { one: "elementą", few: "elementus", many: "elementų" }, verb: { smaller: { inclusive: "turi turėti ne daugiau kaip", notInclusive: "turi turėti mažiau kaip" }, bigger: { inclusive: "turi turėti ne mažiau kaip", notInclusive: "turi turėti daugiau kaip" } } } };
  function i(n, v, $2, u2) {
    let l = r2[n] ?? null;
    if (l === null) return l;
    return { unit: l.unit[v], verb: l.verb[u2][$2 ? "inclusive" : "notInclusive"] };
  }
  let o = { regex: "įvestis", email: "el. pašto adresas", url: "URL", emoji: "jaustukas", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO data ir laikas", date: "ISO data", time: "ISO laikas", duration: "ISO trukmė", ipv4: "IPv4 adresas", ipv6: "IPv6 adresas", cidrv4: "IPv4 tinklo prefiksas (CIDR)", cidrv6: "IPv6 tinklo prefiksas (CIDR)", base64: "base64 užkoduota eilutė", base64url: "base64url užkoduota eilutė", json_string: "JSON eilutė", e164: "E.164 numeris", jwt: "JWT", template_literal: "įvestis" }, t = { nan: "NaN", number: "skaičius", bigint: "sveikasis skaičius", string: "eilutė", boolean: "loginė reikšmė", undefined: "neapibrėžta reikšmė", function: "funkcija", symbol: "simbolis", array: "masyvas", object: "objektas", null: "nulinė reikšmė" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Gautas tipas ${u2}, o tikėtasi - instanceof ${n.expected}`;
        return `Gautas tipas ${u2}, o tikėtasi - ${v}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Privalo būti ${U$1(n.values[0])}`;
        return `Privalo būti vienas iš ${_$1(n.values, "|")} pasirinkimų`;
      case "too_big": {
        let v = t[n.origin] ?? n.origin, $2 = i(n.origin, cl$1(Number(n.maximum)), n.inclusive ?? false, "smaller");
        if ($2?.verb) return `${Nn$1(v ?? n.origin ?? "reikšmė")} ${$2.verb} ${n.maximum.toString()} ${$2.unit ?? "elementų"}`;
        let u2 = n.inclusive ? "ne didesnis kaip" : "mažesnis kaip";
        return `${Nn$1(v ?? n.origin ?? "reikšmė")} turi būti ${u2} ${n.maximum.toString()} ${$2?.unit}`;
      }
      case "too_small": {
        let v = t[n.origin] ?? n.origin, $2 = i(n.origin, cl$1(Number(n.minimum)), n.inclusive ?? false, "bigger");
        if ($2?.verb) return `${Nn$1(v ?? n.origin ?? "reikšmė")} ${$2.verb} ${n.minimum.toString()} ${$2.unit ?? "elementų"}`;
        let u2 = n.inclusive ? "ne mažesnis kaip" : "didesnis kaip";
        return `${Nn$1(v ?? n.origin ?? "reikšmė")} turi būti ${u2} ${n.minimum.toString()} ${$2?.unit}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Eilutė privalo prasidėti "${v.prefix}"`;
        if (v.format === "ends_with") return `Eilutė privalo pasibaigti "${v.suffix}"`;
        if (v.format === "includes") return `Eilutė privalo įtraukti "${v.includes}"`;
        if (v.format === "regex") return `Eilutė privalo atitikti ${v.pattern}`;
        return `Neteisingas ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Skaičius privalo būti ${n.divisor} kartotinis.`;
      case "unrecognized_keys":
        return `Neatpažint${n.keys.length > 1 ? "i" : "as"} rakt${n.keys.length > 1 ? "ai" : "as"}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return "Rastas klaidingas raktas";
      case "invalid_union":
        return "Klaidinga įvestis";
      case "invalid_element": {
        let v = t[n.origin] ?? n.origin;
        return `${Nn$1(v ?? n.origin ?? "reikšmė")} turi klaidingą įvestį`;
      }
      default:
        return "Klaidinga įvestis";
    }
  };
};
function e$() {
  return { localeError: H6() };
}
var M6 = () => {
  let r2 = { string: { unit: "знаци", verb: "да имаат" }, file: { unit: "бајти", verb: "да имаат" }, array: { unit: "ставки", verb: "да имаат" }, set: { unit: "ставки", verb: "да имаат" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "внес", email: "адреса на е-пошта", url: "URL", emoji: "емоџи", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO датум и време", date: "ISO датум", time: "ISO време", duration: "ISO времетраење", ipv4: "IPv4 адреса", ipv6: "IPv6 адреса", cidrv4: "IPv4 опсег", cidrv6: "IPv6 опсег", base64: "base64-енкодирана низа", base64url: "base64url-енкодирана низа", json_string: "JSON низа", e164: "E.164 број", jwt: "JWT", template_literal: "внес" }, t = { nan: "NaN", number: "број", array: "низа" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Грешен внес: се очекува instanceof ${n.expected}, примено ${u2}`;
        return `Грешен внес: се очекува ${v}, примено ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Invalid input: expected ${U$1(n.values[0])}`;
        return `Грешана опција: се очекува една ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Премногу голем: се очекува ${n.origin ?? "вредноста"} да има ${v}${n.maximum.toString()} ${$2.unit ?? "елементи"}`;
        return `Премногу голем: се очекува ${n.origin ?? "вредноста"} да биде ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Премногу мал: се очекува ${n.origin} да има ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Премногу мал: се очекува ${n.origin} да биде ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Неважечка низа: мора да започнува со "${v.prefix}"`;
        if (v.format === "ends_with") return `Неважечка низа: мора да завршува со "${v.suffix}"`;
        if (v.format === "includes") return `Неважечка низа: мора да вклучува "${v.includes}"`;
        if (v.format === "regex") return `Неважечка низа: мора да одгоара на патернот ${v.pattern}`;
        return `Invalid ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Грешен број: мора да биде делив со ${n.divisor}`;
      case "unrecognized_keys":
        return `${n.keys.length > 1 ? "Непрепознаени клучеви" : "Непрепознаен клуч"}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Грешен клуч во ${n.origin}`;
      case "invalid_union":
        return "Грешен внес";
      case "invalid_element":
        return `Грешна вредност во ${n.origin}`;
      default:
        return "Грешен внес";
    }
  };
};
function l$() {
  return { localeError: M6() };
}
var m6 = () => {
  let r2 = { string: { unit: "aksara", verb: "mempunyai" }, file: { unit: "bait", verb: "mempunyai" }, array: { unit: "elemen", verb: "mempunyai" }, set: { unit: "elemen", verb: "mempunyai" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "input", email: "alamat e-mel", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "tarikh masa ISO", date: "tarikh ISO", time: "masa ISO", duration: "tempoh ISO", ipv4: "alamat IPv4", ipv6: "alamat IPv6", cidrv4: "julat IPv4", cidrv6: "julat IPv6", base64: "string dikodkan base64", base64url: "string dikodkan base64url", json_string: "string JSON", e164: "nombor E.164", jwt: "JWT", template_literal: "input" }, t = { nan: "NaN", number: "nombor" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Input tidak sah: dijangka instanceof ${n.expected}, diterima ${u2}`;
        return `Input tidak sah: dijangka ${v}, diterima ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Input tidak sah: dijangka ${U$1(n.values[0])}`;
        return `Pilihan tidak sah: dijangka salah satu daripada ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Terlalu besar: dijangka ${n.origin ?? "nilai"} ${$2.verb} ${v}${n.maximum.toString()} ${$2.unit ?? "elemen"}`;
        return `Terlalu besar: dijangka ${n.origin ?? "nilai"} adalah ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Terlalu kecil: dijangka ${n.origin} ${$2.verb} ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Terlalu kecil: dijangka ${n.origin} adalah ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `String tidak sah: mesti bermula dengan "${v.prefix}"`;
        if (v.format === "ends_with") return `String tidak sah: mesti berakhir dengan "${v.suffix}"`;
        if (v.format === "includes") return `String tidak sah: mesti mengandungi "${v.includes}"`;
        if (v.format === "regex") return `String tidak sah: mesti sepadan dengan corak ${v.pattern}`;
        return `${o[v.format] ?? n.format} tidak sah`;
      }
      case "not_multiple_of":
        return `Nombor tidak sah: perlu gandaan ${n.divisor}`;
      case "unrecognized_keys":
        return `Kunci tidak dikenali: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Kunci tidak sah dalam ${n.origin}`;
      case "invalid_union":
        return "Input tidak sah";
      case "invalid_element":
        return `Nilai tidak sah dalam ${n.origin}`;
      default:
        return "Input tidak sah";
    }
  };
};
function I$() {
  return { localeError: m6() };
}
var R6 = () => {
  let r2 = { string: { unit: "tekens", verb: "heeft" }, file: { unit: "bytes", verb: "heeft" }, array: { unit: "elementen", verb: "heeft" }, set: { unit: "elementen", verb: "heeft" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "invoer", email: "emailadres", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO datum en tijd", date: "ISO datum", time: "ISO tijd", duration: "ISO duur", ipv4: "IPv4-adres", ipv6: "IPv6-adres", cidrv4: "IPv4-bereik", cidrv6: "IPv6-bereik", base64: "base64-gecodeerde tekst", base64url: "base64 URL-gecodeerde tekst", json_string: "JSON string", e164: "E.164-nummer", jwt: "JWT", template_literal: "invoer" }, t = { nan: "NaN", number: "getal" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Ongeldige invoer: verwacht instanceof ${n.expected}, ontving ${u2}`;
        return `Ongeldige invoer: verwacht ${v}, ontving ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Ongeldige invoer: verwacht ${U$1(n.values[0])}`;
        return `Ongeldige optie: verwacht één van ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin), u2 = n.origin === "date" ? "laat" : n.origin === "string" ? "lang" : "groot";
        if ($2) return `Te ${u2}: verwacht dat ${n.origin ?? "waarde"} ${v}${n.maximum.toString()} ${$2.unit ?? "elementen"} ${$2.verb}`;
        return `Te ${u2}: verwacht dat ${n.origin ?? "waarde"} ${v}${n.maximum.toString()} is`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin), u2 = n.origin === "date" ? "vroeg" : n.origin === "string" ? "kort" : "klein";
        if ($2) return `Te ${u2}: verwacht dat ${n.origin} ${v}${n.minimum.toString()} ${$2.unit} ${$2.verb}`;
        return `Te ${u2}: verwacht dat ${n.origin} ${v}${n.minimum.toString()} is`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Ongeldige tekst: moet met "${v.prefix}" beginnen`;
        if (v.format === "ends_with") return `Ongeldige tekst: moet op "${v.suffix}" eindigen`;
        if (v.format === "includes") return `Ongeldige tekst: moet "${v.includes}" bevatten`;
        if (v.format === "regex") return `Ongeldige tekst: moet overeenkomen met patroon ${v.pattern}`;
        return `Ongeldig: ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Ongeldig getal: moet een veelvoud van ${n.divisor} zijn`;
      case "unrecognized_keys":
        return `Onbekende key${n.keys.length > 1 ? "s" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Ongeldige key in ${n.origin}`;
      case "invalid_union":
        return "Ongeldige invoer";
      case "invalid_element":
        return `Ongeldige waarde in ${n.origin}`;
      default:
        return "Ongeldige invoer";
    }
  };
};
function c$() {
  return { localeError: R6() };
}
var x6 = () => {
  let r2 = { string: { unit: "tegn", verb: "å ha" }, file: { unit: "bytes", verb: "å ha" }, array: { unit: "elementer", verb: "å inneholde" }, set: { unit: "elementer", verb: "å inneholde" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "input", email: "e-postadresse", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO dato- og klokkeslett", date: "ISO-dato", time: "ISO-klokkeslett", duration: "ISO-varighet", ipv4: "IPv4-område", ipv6: "IPv6-område", cidrv4: "IPv4-spekter", cidrv6: "IPv6-spekter", base64: "base64-enkodet streng", base64url: "base64url-enkodet streng", json_string: "JSON-streng", e164: "E.164-nummer", jwt: "JWT", template_literal: "input" }, t = { nan: "NaN", number: "tall", array: "liste" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Ugyldig input: forventet instanceof ${n.expected}, fikk ${u2}`;
        return `Ugyldig input: forventet ${v}, fikk ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Ugyldig verdi: forventet ${U$1(n.values[0])}`;
        return `Ugyldig valg: forventet en av ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `For stor(t): forventet ${n.origin ?? "value"} til å ha ${v}${n.maximum.toString()} ${$2.unit ?? "elementer"}`;
        return `For stor(t): forventet ${n.origin ?? "value"} til å ha ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `For lite(n): forventet ${n.origin} til å ha ${v}${n.minimum.toString()} ${$2.unit}`;
        return `For lite(n): forventet ${n.origin} til å ha ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Ugyldig streng: må starte med "${v.prefix}"`;
        if (v.format === "ends_with") return `Ugyldig streng: må ende med "${v.suffix}"`;
        if (v.format === "includes") return `Ugyldig streng: må inneholde "${v.includes}"`;
        if (v.format === "regex") return `Ugyldig streng: må matche mønsteret ${v.pattern}`;
        return `Ugyldig ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Ugyldig tall: må være et multiplum av ${n.divisor}`;
      case "unrecognized_keys":
        return `${n.keys.length > 1 ? "Ukjente nøkler" : "Ukjent nøkkel"}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Ugyldig nøkkel i ${n.origin}`;
      case "invalid_union":
        return "Ugyldig input";
      case "invalid_element":
        return `Ugyldig verdi i ${n.origin}`;
      default:
        return "Ugyldig input";
    }
  };
};
function _$() {
  return { localeError: x6() };
}
var Z6 = () => {
  let r2 = { string: { unit: "harf", verb: "olmalıdır" }, file: { unit: "bayt", verb: "olmalıdır" }, array: { unit: "unsur", verb: "olmalıdır" }, set: { unit: "unsur", verb: "olmalıdır" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "giren", email: "epostagâh", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO hengâmı", date: "ISO tarihi", time: "ISO zamanı", duration: "ISO müddeti", ipv4: "IPv4 nişânı", ipv6: "IPv6 nişânı", cidrv4: "IPv4 menzili", cidrv6: "IPv6 menzili", base64: "base64-şifreli metin", base64url: "base64url-şifreli metin", json_string: "JSON metin", e164: "E.164 sayısı", jwt: "JWT", template_literal: "giren" }, t = { nan: "NaN", number: "numara", array: "saf", null: "gayb" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Fâsit giren: umulan instanceof ${n.expected}, alınan ${u2}`;
        return `Fâsit giren: umulan ${v}, alınan ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Fâsit giren: umulan ${U$1(n.values[0])}`;
        return `Fâsit tercih: mûteberler ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Fazla büyük: ${n.origin ?? "value"}, ${v}${n.maximum.toString()} ${$2.unit ?? "elements"} sahip olmalıydı.`;
        return `Fazla büyük: ${n.origin ?? "value"}, ${v}${n.maximum.toString()} olmalıydı.`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Fazla küçük: ${n.origin}, ${v}${n.minimum.toString()} ${$2.unit} sahip olmalıydı.`;
        return `Fazla küçük: ${n.origin}, ${v}${n.minimum.toString()} olmalıydı.`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Fâsit metin: "${v.prefix}" ile başlamalı.`;
        if (v.format === "ends_with") return `Fâsit metin: "${v.suffix}" ile bitmeli.`;
        if (v.format === "includes") return `Fâsit metin: "${v.includes}" ihtivâ etmeli.`;
        if (v.format === "regex") return `Fâsit metin: ${v.pattern} nakşına uymalı.`;
        return `Fâsit ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Fâsit sayı: ${n.divisor} katı olmalıydı.`;
      case "unrecognized_keys":
        return `Tanınmayan anahtar ${n.keys.length > 1 ? "s" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `${n.origin} için tanınmayan anahtar var.`;
      case "invalid_union":
        return "Giren tanınamadı.";
      case "invalid_element":
        return `${n.origin} için tanınmayan kıymet var.`;
      default:
        return "Kıymet tanınamadı.";
    }
  };
};
function b$() {
  return { localeError: Z6() };
}
var d6 = () => {
  let r2 = { string: { unit: "توکي", verb: "ولري" }, file: { unit: "بایټس", verb: "ولري" }, array: { unit: "توکي", verb: "ولري" }, set: { unit: "توکي", verb: "ولري" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "ورودي", email: "بریښنالیک", url: "یو آر ال", emoji: "ایموجي", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "نیټه او وخت", date: "نېټه", time: "وخت", duration: "موده", ipv4: "د IPv4 پته", ipv6: "د IPv6 پته", cidrv4: "د IPv4 ساحه", cidrv6: "د IPv6 ساحه", base64: "base64-encoded متن", base64url: "base64url-encoded متن", json_string: "JSON متن", e164: "د E.164 شمېره", jwt: "JWT", template_literal: "ورودي" }, t = { nan: "NaN", number: "عدد", array: "ارې" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `ناسم ورودي: باید instanceof ${n.expected} وای, مګر ${u2} ترلاسه شو`;
        return `ناسم ورودي: باید ${v} وای, مګر ${u2} ترلاسه شو`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `ناسم ورودي: باید ${U$1(n.values[0])} وای`;
        return `ناسم انتخاب: باید یو له ${_$1(n.values, "|")} څخه وای`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `ډیر لوی: ${n.origin ?? "ارزښت"} باید ${v}${n.maximum.toString()} ${$2.unit ?? "عنصرونه"} ولري`;
        return `ډیر لوی: ${n.origin ?? "ارزښت"} باید ${v}${n.maximum.toString()} وي`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `ډیر کوچنی: ${n.origin} باید ${v}${n.minimum.toString()} ${$2.unit} ولري`;
        return `ډیر کوچنی: ${n.origin} باید ${v}${n.minimum.toString()} وي`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `ناسم متن: باید د "${v.prefix}" سره پیل شي`;
        if (v.format === "ends_with") return `ناسم متن: باید د "${v.suffix}" سره پای ته ورسيږي`;
        if (v.format === "includes") return `ناسم متن: باید "${v.includes}" ولري`;
        if (v.format === "regex") return `ناسم متن: باید د ${v.pattern} سره مطابقت ولري`;
        return `${o[v.format] ?? n.format} ناسم دی`;
      }
      case "not_multiple_of":
        return `ناسم عدد: باید د ${n.divisor} مضرب وي`;
      case "unrecognized_keys":
        return `ناسم ${n.keys.length > 1 ? "کلیډونه" : "کلیډ"}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `ناسم کلیډ په ${n.origin} کې`;
      case "invalid_union":
        return "ناسمه ورودي";
      case "invalid_element":
        return `ناسم عنصر په ${n.origin} کې`;
      default:
        return "ناسمه ورودي";
    }
  };
};
function U$() {
  return { localeError: d6() };
}
var C6 = () => {
  let r2 = { string: { unit: "znaków", verb: "mieć" }, file: { unit: "bajtów", verb: "mieć" }, array: { unit: "elementów", verb: "mieć" }, set: { unit: "elementów", verb: "mieć" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "wyrażenie", email: "adres email", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "data i godzina w formacie ISO", date: "data w formacie ISO", time: "godzina w formacie ISO", duration: "czas trwania ISO", ipv4: "adres IPv4", ipv6: "adres IPv6", cidrv4: "zakres IPv4", cidrv6: "zakres IPv6", base64: "ciąg znaków zakodowany w formacie base64", base64url: "ciąg znaków zakodowany w formacie base64url", json_string: "ciąg znaków w formacie JSON", e164: "liczba E.164", jwt: "JWT", template_literal: "wejście" }, t = { nan: "NaN", number: "liczba", array: "tablica" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Nieprawidłowe dane wejściowe: oczekiwano instanceof ${n.expected}, otrzymano ${u2}`;
        return `Nieprawidłowe dane wejściowe: oczekiwano ${v}, otrzymano ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Nieprawidłowe dane wejściowe: oczekiwano ${U$1(n.values[0])}`;
        return `Nieprawidłowa opcja: oczekiwano jednej z wartości ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Za duża wartość: oczekiwano, że ${n.origin ?? "wartość"} będzie mieć ${v}${n.maximum.toString()} ${$2.unit ?? "elementów"}`;
        return `Zbyt duż(y/a/e): oczekiwano, że ${n.origin ?? "wartość"} będzie wynosić ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Za mała wartość: oczekiwano, że ${n.origin ?? "wartość"} będzie mieć ${v}${n.minimum.toString()} ${$2.unit ?? "elementów"}`;
        return `Zbyt mał(y/a/e): oczekiwano, że ${n.origin ?? "wartość"} będzie wynosić ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Nieprawidłowy ciąg znaków: musi zaczynać się od "${v.prefix}"`;
        if (v.format === "ends_with") return `Nieprawidłowy ciąg znaków: musi kończyć się na "${v.suffix}"`;
        if (v.format === "includes") return `Nieprawidłowy ciąg znaków: musi zawierać "${v.includes}"`;
        if (v.format === "regex") return `Nieprawidłowy ciąg znaków: musi odpowiadać wzorcowi ${v.pattern}`;
        return `Nieprawidłow(y/a/e) ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Nieprawidłowa liczba: musi być wielokrotnością ${n.divisor}`;
      case "unrecognized_keys":
        return `Nierozpoznane klucze${n.keys.length > 1 ? "s" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Nieprawidłowy klucz w ${n.origin}`;
      case "invalid_union":
        return "Nieprawidłowe dane wejściowe";
      case "invalid_element":
        return `Nieprawidłowa wartość w ${n.origin}`;
      default:
        return "Nieprawidłowe dane wejściowe";
    }
  };
};
function D$() {
  return { localeError: C6() };
}
var f6 = () => {
  let r2 = { string: { unit: "caracteres", verb: "ter" }, file: { unit: "bytes", verb: "ter" }, array: { unit: "itens", verb: "ter" }, set: { unit: "itens", verb: "ter" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "padrão", email: "endereço de e-mail", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "data e hora ISO", date: "data ISO", time: "hora ISO", duration: "duração ISO", ipv4: "endereço IPv4", ipv6: "endereço IPv6", cidrv4: "faixa de IPv4", cidrv6: "faixa de IPv6", base64: "texto codificado em base64", base64url: "URL codificada em base64", json_string: "texto JSON", e164: "número E.164", jwt: "JWT", template_literal: "entrada" }, t = { nan: "NaN", number: "número", null: "nulo" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Tipo inválido: esperado instanceof ${n.expected}, recebido ${u2}`;
        return `Tipo inválido: esperado ${v}, recebido ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Entrada inválida: esperado ${U$1(n.values[0])}`;
        return `Opção inválida: esperada uma das ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Muito grande: esperado que ${n.origin ?? "valor"} tivesse ${v}${n.maximum.toString()} ${$2.unit ?? "elementos"}`;
        return `Muito grande: esperado que ${n.origin ?? "valor"} fosse ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Muito pequeno: esperado que ${n.origin} tivesse ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Muito pequeno: esperado que ${n.origin} fosse ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Texto inválido: deve começar com "${v.prefix}"`;
        if (v.format === "ends_with") return `Texto inválido: deve terminar com "${v.suffix}"`;
        if (v.format === "includes") return `Texto inválido: deve incluir "${v.includes}"`;
        if (v.format === "regex") return `Texto inválido: deve corresponder ao padrão ${v.pattern}`;
        return `${o[v.format] ?? n.format} inválido`;
      }
      case "not_multiple_of":
        return `Número inválido: deve ser múltiplo de ${n.divisor}`;
      case "unrecognized_keys":
        return `Chave${n.keys.length > 1 ? "s" : ""} desconhecida${n.keys.length > 1 ? "s" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Chave inválida em ${n.origin}`;
      case "invalid_union":
        return "Entrada inválida";
      case "invalid_element":
        return `Valor inválido em ${n.origin}`;
      default:
        return "Campo inválido";
    }
  };
};
function k$() {
  return { localeError: f6() };
}
function _l$1(r2, i, o, t) {
  let n = Math.abs(r2), v = n % 10, $2 = n % 100;
  if ($2 >= 11 && $2 <= 19) return t;
  if (v === 1) return i;
  if (v >= 2 && v <= 4) return o;
  return t;
}
var y6 = () => {
  let r2 = { string: { unit: { one: "символ", few: "символа", many: "символов" }, verb: "иметь" }, file: { unit: { one: "байт", few: "байта", many: "байт" }, verb: "иметь" }, array: { unit: { one: "элемент", few: "элемента", many: "элементов" }, verb: "иметь" }, set: { unit: { one: "элемент", few: "элемента", many: "элементов" }, verb: "иметь" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "ввод", email: "email адрес", url: "URL", emoji: "эмодзи", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO дата и время", date: "ISO дата", time: "ISO время", duration: "ISO длительность", ipv4: "IPv4 адрес", ipv6: "IPv6 адрес", cidrv4: "IPv4 диапазон", cidrv6: "IPv6 диапазон", base64: "строка в формате base64", base64url: "строка в формате base64url", json_string: "JSON строка", e164: "номер E.164", jwt: "JWT", template_literal: "ввод" }, t = { nan: "NaN", number: "число", array: "массив" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Неверный ввод: ожидалось instanceof ${n.expected}, получено ${u2}`;
        return `Неверный ввод: ожидалось ${v}, получено ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Неверный ввод: ожидалось ${U$1(n.values[0])}`;
        return `Неверный вариант: ожидалось одно из ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) {
          let u2 = Number(n.maximum), l = _l$1(u2, $2.unit.one, $2.unit.few, $2.unit.many);
          return `Слишком большое значение: ожидалось, что ${n.origin ?? "значение"} будет иметь ${v}${n.maximum.toString()} ${l}`;
        }
        return `Слишком большое значение: ожидалось, что ${n.origin ?? "значение"} будет ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) {
          let u2 = Number(n.minimum), l = _l$1(u2, $2.unit.one, $2.unit.few, $2.unit.many);
          return `Слишком маленькое значение: ожидалось, что ${n.origin} будет иметь ${v}${n.minimum.toString()} ${l}`;
        }
        return `Слишком маленькое значение: ожидалось, что ${n.origin} будет ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Неверная строка: должна начинаться с "${v.prefix}"`;
        if (v.format === "ends_with") return `Неверная строка: должна заканчиваться на "${v.suffix}"`;
        if (v.format === "includes") return `Неверная строка: должна содержать "${v.includes}"`;
        if (v.format === "regex") return `Неверная строка: должна соответствовать шаблону ${v.pattern}`;
        return `Неверный ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Неверное число: должно быть кратным ${n.divisor}`;
      case "unrecognized_keys":
        return `Нераспознанн${n.keys.length > 1 ? "ые" : "ый"} ключ${n.keys.length > 1 ? "и" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Неверный ключ в ${n.origin}`;
      case "invalid_union":
        return "Неверные входные данные";
      case "invalid_element":
        return `Неверное значение в ${n.origin}`;
      default:
        return "Неверные входные данные";
    }
  };
};
function w$() {
  return { localeError: y6() };
}
var h6 = () => {
  let r2 = { string: { unit: "znakov", verb: "imeti" }, file: { unit: "bajtov", verb: "imeti" }, array: { unit: "elementov", verb: "imeti" }, set: { unit: "elementov", verb: "imeti" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "vnos", email: "e-poštni naslov", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO datum in čas", date: "ISO datum", time: "ISO čas", duration: "ISO trajanje", ipv4: "IPv4 naslov", ipv6: "IPv6 naslov", cidrv4: "obseg IPv4", cidrv6: "obseg IPv6", base64: "base64 kodiran niz", base64url: "base64url kodiran niz", json_string: "JSON niz", e164: "E.164 številka", jwt: "JWT", template_literal: "vnos" }, t = { nan: "NaN", number: "število", array: "tabela" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Neveljaven vnos: pričakovano instanceof ${n.expected}, prejeto ${u2}`;
        return `Neveljaven vnos: pričakovano ${v}, prejeto ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Neveljaven vnos: pričakovano ${U$1(n.values[0])}`;
        return `Neveljavna možnost: pričakovano eno izmed ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Preveliko: pričakovano, da bo ${n.origin ?? "vrednost"} imelo ${v}${n.maximum.toString()} ${$2.unit ?? "elementov"}`;
        return `Preveliko: pričakovano, da bo ${n.origin ?? "vrednost"} ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Premajhno: pričakovano, da bo ${n.origin} imelo ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Premajhno: pričakovano, da bo ${n.origin} ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Neveljaven niz: mora se začeti z "${v.prefix}"`;
        if (v.format === "ends_with") return `Neveljaven niz: mora se končati z "${v.suffix}"`;
        if (v.format === "includes") return `Neveljaven niz: mora vsebovati "${v.includes}"`;
        if (v.format === "regex") return `Neveljaven niz: mora ustrezati vzorcu ${v.pattern}`;
        return `Neveljaven ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Neveljavno število: mora biti večkratnik ${n.divisor}`;
      case "unrecognized_keys":
        return `Neprepoznan${n.keys.length > 1 ? "i ključi" : " ključ"}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Neveljaven ključ v ${n.origin}`;
      case "invalid_union":
        return "Neveljaven vnos";
      case "invalid_element":
        return `Neveljavna vrednost v ${n.origin}`;
      default:
        return "Neveljaven vnos";
    }
  };
};
function N$() {
  return { localeError: h6() };
}
var a6 = () => {
  let r2 = { string: { unit: "tecken", verb: "att ha" }, file: { unit: "bytes", verb: "att ha" }, array: { unit: "objekt", verb: "att innehålla" }, set: { unit: "objekt", verb: "att innehålla" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "reguljärt uttryck", email: "e-postadress", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO-datum och tid", date: "ISO-datum", time: "ISO-tid", duration: "ISO-varaktighet", ipv4: "IPv4-intervall", ipv6: "IPv6-intervall", cidrv4: "IPv4-spektrum", cidrv6: "IPv6-spektrum", base64: "base64-kodad sträng", base64url: "base64url-kodad sträng", json_string: "JSON-sträng", e164: "E.164-nummer", jwt: "JWT", template_literal: "mall-literal" }, t = { nan: "NaN", number: "antal", array: "lista" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Ogiltig inmatning: förväntat instanceof ${n.expected}, fick ${u2}`;
        return `Ogiltig inmatning: förväntat ${v}, fick ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Ogiltig inmatning: förväntat ${U$1(n.values[0])}`;
        return `Ogiltigt val: förväntade en av ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `För stor(t): förväntade ${n.origin ?? "värdet"} att ha ${v}${n.maximum.toString()} ${$2.unit ?? "element"}`;
        return `För stor(t): förväntat ${n.origin ?? "värdet"} att ha ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `För lite(t): förväntade ${n.origin ?? "värdet"} att ha ${v}${n.minimum.toString()} ${$2.unit}`;
        return `För lite(t): förväntade ${n.origin ?? "värdet"} att ha ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Ogiltig sträng: måste börja med "${v.prefix}"`;
        if (v.format === "ends_with") return `Ogiltig sträng: måste sluta med "${v.suffix}"`;
        if (v.format === "includes") return `Ogiltig sträng: måste innehålla "${v.includes}"`;
        if (v.format === "regex") return `Ogiltig sträng: måste matcha mönstret "${v.pattern}"`;
        return `Ogiltig(t) ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Ogiltigt tal: måste vara en multipel av ${n.divisor}`;
      case "unrecognized_keys":
        return `${n.keys.length > 1 ? "Okända nycklar" : "Okänd nyckel"}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Ogiltig nyckel i ${n.origin ?? "värdet"}`;
      case "invalid_union":
        return "Ogiltig input";
      case "invalid_element":
        return `Ogiltigt värde i ${n.origin ?? "värdet"}`;
      default:
        return "Ogiltig input";
    }
  };
};
function O$() {
  return { localeError: a6() };
}
var p6 = () => {
  let r2 = { string: { unit: "எழுத்துக்கள்", verb: "கொண்டிருக்க வேண்டும்" }, file: { unit: "பைட்டுகள்", verb: "கொண்டிருக்க வேண்டும்" }, array: { unit: "உறுப்புகள்", verb: "கொண்டிருக்க வேண்டும்" }, set: { unit: "உறுப்புகள்", verb: "கொண்டிருக்க வேண்டும்" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "உள்ளீடு", email: "மின்னஞ்சல் முகவரி", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO தேதி நேரம்", date: "ISO தேதி", time: "ISO நேரம்", duration: "ISO கால அளவு", ipv4: "IPv4 முகவரி", ipv6: "IPv6 முகவரி", cidrv4: "IPv4 வரம்பு", cidrv6: "IPv6 வரம்பு", base64: "base64-encoded சரம்", base64url: "base64url-encoded சரம்", json_string: "JSON சரம்", e164: "E.164 எண்", jwt: "JWT", template_literal: "input" }, t = { nan: "NaN", number: "எண்", array: "அணி", null: "வெறுமை" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `தவறான உள்ளீடு: எதிர்பார்க்கப்பட்டது instanceof ${n.expected}, பெறப்பட்டது ${u2}`;
        return `தவறான உள்ளீடு: எதிர்பார்க்கப்பட்டது ${v}, பெறப்பட்டது ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `தவறான உள்ளீடு: எதிர்பார்க்கப்பட்டது ${U$1(n.values[0])}`;
        return `தவறான விருப்பம்: எதிர்பார்க்கப்பட்டது ${_$1(n.values, "|")} இல் ஒன்று`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `மிக பெரியது: எதிர்பார்க்கப்பட்டது ${n.origin ?? "மதிப்பு"} ${v}${n.maximum.toString()} ${$2.unit ?? "உறுப்புகள்"} ஆக இருக்க வேண்டும்`;
        return `மிக பெரியது: எதிர்பார்க்கப்பட்டது ${n.origin ?? "மதிப்பு"} ${v}${n.maximum.toString()} ஆக இருக்க வேண்டும்`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `மிகச் சிறியது: எதிர்பார்க்கப்பட்டது ${n.origin} ${v}${n.minimum.toString()} ${$2.unit} ஆக இருக்க வேண்டும்`;
        return `மிகச் சிறியது: எதிர்பார்க்கப்பட்டது ${n.origin} ${v}${n.minimum.toString()} ஆக இருக்க வேண்டும்`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `தவறான சரம்: "${v.prefix}" இல் தொடங்க வேண்டும்`;
        if (v.format === "ends_with") return `தவறான சரம்: "${v.suffix}" இல் முடிவடைய வேண்டும்`;
        if (v.format === "includes") return `தவறான சரம்: "${v.includes}" ஐ உள்ளடக்க வேண்டும்`;
        if (v.format === "regex") return `தவறான சரம்: ${v.pattern} முறைபாட்டுடன் பொருந்த வேண்டும்`;
        return `தவறான ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `தவறான எண்: ${n.divisor} இன் பலமாக இருக்க வேண்டும்`;
      case "unrecognized_keys":
        return `அடையாளம் தெரியாத விசை${n.keys.length > 1 ? "கள்" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `${n.origin} இல் தவறான விசை`;
      case "invalid_union":
        return "தவறான உள்ளீடு";
      case "invalid_element":
        return `${n.origin} இல் தவறான மதிப்பு`;
      default:
        return "தவறான உள்ளீடு";
    }
  };
};
function S$() {
  return { localeError: p6() };
}
var s6 = () => {
  let r2 = { string: { unit: "ตัวอักษร", verb: "ควรมี" }, file: { unit: "ไบต์", verb: "ควรมี" }, array: { unit: "รายการ", verb: "ควรมี" }, set: { unit: "รายการ", verb: "ควรมี" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "ข้อมูลที่ป้อน", email: "ที่อยู่อีเมล", url: "URL", emoji: "อิโมจิ", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "วันที่เวลาแบบ ISO", date: "วันที่แบบ ISO", time: "เวลาแบบ ISO", duration: "ช่วงเวลาแบบ ISO", ipv4: "ที่อยู่ IPv4", ipv6: "ที่อยู่ IPv6", cidrv4: "ช่วง IP แบบ IPv4", cidrv6: "ช่วง IP แบบ IPv6", base64: "ข้อความแบบ Base64", base64url: "ข้อความแบบ Base64 สำหรับ URL", json_string: "ข้อความแบบ JSON", e164: "เบอร์โทรศัพท์ระหว่างประเทศ (E.164)", jwt: "โทเคน JWT", template_literal: "ข้อมูลที่ป้อน" }, t = { nan: "NaN", number: "ตัวเลข", array: "อาร์เรย์ (Array)", null: "ไม่มีค่า (null)" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `ประเภทข้อมูลไม่ถูกต้อง: ควรเป็น instanceof ${n.expected} แต่ได้รับ ${u2}`;
        return `ประเภทข้อมูลไม่ถูกต้อง: ควรเป็น ${v} แต่ได้รับ ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `ค่าไม่ถูกต้อง: ควรเป็น ${U$1(n.values[0])}`;
        return `ตัวเลือกไม่ถูกต้อง: ควรเป็นหนึ่งใน ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "ไม่เกิน" : "น้อยกว่า", $2 = i(n.origin);
        if ($2) return `เกินกำหนด: ${n.origin ?? "ค่า"} ควรมี${v} ${n.maximum.toString()} ${$2.unit ?? "รายการ"}`;
        return `เกินกำหนด: ${n.origin ?? "ค่า"} ควรมี${v} ${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? "อย่างน้อย" : "มากกว่า", $2 = i(n.origin);
        if ($2) return `น้อยกว่ากำหนด: ${n.origin} ควรมี${v} ${n.minimum.toString()} ${$2.unit}`;
        return `น้อยกว่ากำหนด: ${n.origin} ควรมี${v} ${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `รูปแบบไม่ถูกต้อง: ข้อความต้องขึ้นต้นด้วย "${v.prefix}"`;
        if (v.format === "ends_with") return `รูปแบบไม่ถูกต้อง: ข้อความต้องลงท้ายด้วย "${v.suffix}"`;
        if (v.format === "includes") return `รูปแบบไม่ถูกต้อง: ข้อความต้องมี "${v.includes}" อยู่ในข้อความ`;
        if (v.format === "regex") return `รูปแบบไม่ถูกต้อง: ต้องตรงกับรูปแบบที่กำหนด ${v.pattern}`;
        return `รูปแบบไม่ถูกต้อง: ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `ตัวเลขไม่ถูกต้อง: ต้องเป็นจำนวนที่หารด้วย ${n.divisor} ได้ลงตัว`;
      case "unrecognized_keys":
        return `พบคีย์ที่ไม่รู้จัก: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `คีย์ไม่ถูกต้องใน ${n.origin}`;
      case "invalid_union":
        return "ข้อมูลไม่ถูกต้อง: ไม่ตรงกับรูปแบบยูเนียนที่กำหนดไว้";
      case "invalid_element":
        return `ข้อมูลไม่ถูกต้องใน ${n.origin}`;
      default:
        return "ข้อมูลไม่ถูกต้อง";
    }
  };
};
function z$() {
  return { localeError: s6() };
}
var rc$1 = () => {
  let r2 = { string: { unit: "karakter", verb: "olmalı" }, file: { unit: "bayt", verb: "olmalı" }, array: { unit: "öğe", verb: "olmalı" }, set: { unit: "öğe", verb: "olmalı" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "girdi", email: "e-posta adresi", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO tarih ve saat", date: "ISO tarih", time: "ISO saat", duration: "ISO süre", ipv4: "IPv4 adresi", ipv6: "IPv6 adresi", cidrv4: "IPv4 aralığı", cidrv6: "IPv6 aralığı", base64: "base64 ile şifrelenmiş metin", base64url: "base64url ile şifrelenmiş metin", json_string: "JSON dizesi", e164: "E.164 sayısı", jwt: "JWT", template_literal: "Şablon dizesi" }, t = { nan: "NaN" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Geçersiz değer: beklenen instanceof ${n.expected}, alınan ${u2}`;
        return `Geçersiz değer: beklenen ${v}, alınan ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Geçersiz değer: beklenen ${U$1(n.values[0])}`;
        return `Geçersiz seçenek: aşağıdakilerden biri olmalı: ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Çok büyük: beklenen ${n.origin ?? "değer"} ${v}${n.maximum.toString()} ${$2.unit ?? "öğe"}`;
        return `Çok büyük: beklenen ${n.origin ?? "değer"} ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Çok küçük: beklenen ${n.origin} ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Çok küçük: beklenen ${n.origin} ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Geçersiz metin: "${v.prefix}" ile başlamalı`;
        if (v.format === "ends_with") return `Geçersiz metin: "${v.suffix}" ile bitmeli`;
        if (v.format === "includes") return `Geçersiz metin: "${v.includes}" içermeli`;
        if (v.format === "regex") return `Geçersiz metin: ${v.pattern} desenine uymalı`;
        return `Geçersiz ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Geçersiz sayı: ${n.divisor} ile tam bölünebilmeli`;
      case "unrecognized_keys":
        return `Tanınmayan anahtar${n.keys.length > 1 ? "lar" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `${n.origin} içinde geçersiz anahtar`;
      case "invalid_union":
        return "Geçersiz değer";
      case "invalid_element":
        return `${n.origin} içinde geçersiz değer`;
      default:
        return "Geçersiz değer";
    }
  };
};
function P$() {
  return { localeError: rc$1() };
}
var nc$1 = () => {
  let r2 = { string: { unit: "символів", verb: "матиме" }, file: { unit: "байтів", verb: "матиме" }, array: { unit: "елементів", verb: "матиме" }, set: { unit: "елементів", verb: "матиме" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "вхідні дані", email: "адреса електронної пошти", url: "URL", emoji: "емодзі", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "дата та час ISO", date: "дата ISO", time: "час ISO", duration: "тривалість ISO", ipv4: "адреса IPv4", ipv6: "адреса IPv6", cidrv4: "діапазон IPv4", cidrv6: "діапазон IPv6", base64: "рядок у кодуванні base64", base64url: "рядок у кодуванні base64url", json_string: "рядок JSON", e164: "номер E.164", jwt: "JWT", template_literal: "вхідні дані" }, t = { nan: "NaN", number: "число", array: "масив" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Неправильні вхідні дані: очікується instanceof ${n.expected}, отримано ${u2}`;
        return `Неправильні вхідні дані: очікується ${v}, отримано ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Неправильні вхідні дані: очікується ${U$1(n.values[0])}`;
        return `Неправильна опція: очікується одне з ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Занадто велике: очікується, що ${n.origin ?? "значення"} ${$2.verb} ${v}${n.maximum.toString()} ${$2.unit ?? "елементів"}`;
        return `Занадто велике: очікується, що ${n.origin ?? "значення"} буде ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Занадто мале: очікується, що ${n.origin} ${$2.verb} ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Занадто мале: очікується, що ${n.origin} буде ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Неправильний рядок: повинен починатися з "${v.prefix}"`;
        if (v.format === "ends_with") return `Неправильний рядок: повинен закінчуватися на "${v.suffix}"`;
        if (v.format === "includes") return `Неправильний рядок: повинен містити "${v.includes}"`;
        if (v.format === "regex") return `Неправильний рядок: повинен відповідати шаблону ${v.pattern}`;
        return `Неправильний ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Неправильне число: повинно бути кратним ${n.divisor}`;
      case "unrecognized_keys":
        return `Нерозпізнаний ключ${n.keys.length > 1 ? "і" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Неправильний ключ у ${n.origin}`;
      case "invalid_union":
        return "Неправильні вхідні дані";
      case "invalid_element":
        return `Неправильне значення у ${n.origin}`;
      default:
        return "Неправильні вхідні дані";
    }
  };
};
function On$1() {
  return { localeError: nc$1() };
}
function j$() {
  return On$1();
}
var ic$1 = () => {
  let r2 = { string: { unit: "حروف", verb: "ہونا" }, file: { unit: "بائٹس", verb: "ہونا" }, array: { unit: "آئٹمز", verb: "ہونا" }, set: { unit: "آئٹمز", verb: "ہونا" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "ان پٹ", email: "ای میل ایڈریس", url: "یو آر ایل", emoji: "ایموجی", uuid: "یو یو آئی ڈی", uuidv4: "یو یو آئی ڈی وی 4", uuidv6: "یو یو آئی ڈی وی 6", nanoid: "نینو آئی ڈی", guid: "جی یو آئی ڈی", cuid: "سی یو آئی ڈی", cuid2: "سی یو آئی ڈی 2", ulid: "یو ایل آئی ڈی", xid: "ایکس آئی ڈی", ksuid: "کے ایس یو آئی ڈی", datetime: "آئی ایس او ڈیٹ ٹائم", date: "آئی ایس او تاریخ", time: "آئی ایس او وقت", duration: "آئی ایس او مدت", ipv4: "آئی پی وی 4 ایڈریس", ipv6: "آئی پی وی 6 ایڈریس", cidrv4: "آئی پی وی 4 رینج", cidrv6: "آئی پی وی 6 رینج", base64: "بیس 64 ان کوڈڈ سٹرنگ", base64url: "بیس 64 یو آر ایل ان کوڈڈ سٹرنگ", json_string: "جے ایس او این سٹرنگ", e164: "ای 164 نمبر", jwt: "جے ڈبلیو ٹی", template_literal: "ان پٹ" }, t = { nan: "NaN", number: "نمبر", array: "آرے", null: "نل" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `غلط ان پٹ: instanceof ${n.expected} متوقع تھا، ${u2} موصول ہوا`;
        return `غلط ان پٹ: ${v} متوقع تھا، ${u2} موصول ہوا`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `غلط ان پٹ: ${U$1(n.values[0])} متوقع تھا`;
        return `غلط آپشن: ${_$1(n.values, "|")} میں سے ایک متوقع تھا`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `بہت بڑا: ${n.origin ?? "ویلیو"} کے ${v}${n.maximum.toString()} ${$2.unit ?? "عناصر"} ہونے متوقع تھے`;
        return `بہت بڑا: ${n.origin ?? "ویلیو"} کا ${v}${n.maximum.toString()} ہونا متوقع تھا`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `بہت چھوٹا: ${n.origin} کے ${v}${n.minimum.toString()} ${$2.unit} ہونے متوقع تھے`;
        return `بہت چھوٹا: ${n.origin} کا ${v}${n.minimum.toString()} ہونا متوقع تھا`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `غلط سٹرنگ: "${v.prefix}" سے شروع ہونا چاہیے`;
        if (v.format === "ends_with") return `غلط سٹرنگ: "${v.suffix}" پر ختم ہونا چاہیے`;
        if (v.format === "includes") return `غلط سٹرنگ: "${v.includes}" شامل ہونا چاہیے`;
        if (v.format === "regex") return `غلط سٹرنگ: پیٹرن ${v.pattern} سے میچ ہونا چاہیے`;
        return `غلط ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `غلط نمبر: ${n.divisor} کا مضاعف ہونا چاہیے`;
      case "unrecognized_keys":
        return `غیر تسلیم شدہ کی${n.keys.length > 1 ? "ز" : ""}: ${_$1(n.keys, "، ")}`;
      case "invalid_key":
        return `${n.origin} میں غلط کی`;
      case "invalid_union":
        return "غلط ان پٹ";
      case "invalid_element":
        return `${n.origin} میں غلط ویلیو`;
      default:
        return "غلط ان پٹ";
    }
  };
};
function J$() {
  return { localeError: ic$1() };
}
var vc$1 = () => {
  let r2 = { string: { unit: "belgi", verb: "bo‘lishi kerak" }, file: { unit: "bayt", verb: "bo‘lishi kerak" }, array: { unit: "element", verb: "bo‘lishi kerak" }, set: { unit: "element", verb: "bo‘lishi kerak" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "kirish", email: "elektron pochta manzili", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO sana va vaqti", date: "ISO sana", time: "ISO vaqt", duration: "ISO davomiylik", ipv4: "IPv4 manzil", ipv6: "IPv6 manzil", mac: "MAC manzil", cidrv4: "IPv4 diapazon", cidrv6: "IPv6 diapazon", base64: "base64 kodlangan satr", base64url: "base64url kodlangan satr", json_string: "JSON satr", e164: "E.164 raqam", jwt: "JWT", template_literal: "kirish" }, t = { nan: "NaN", number: "raqam", array: "massiv" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Noto‘g‘ri kirish: kutilgan instanceof ${n.expected}, qabul qilingan ${u2}`;
        return `Noto‘g‘ri kirish: kutilgan ${v}, qabul qilingan ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Noto‘g‘ri kirish: kutilgan ${U$1(n.values[0])}`;
        return `Noto‘g‘ri variant: quyidagilardan biri kutilgan ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Juda katta: kutilgan ${n.origin ?? "qiymat"} ${v}${n.maximum.toString()} ${$2.unit} ${$2.verb}`;
        return `Juda katta: kutilgan ${n.origin ?? "qiymat"} ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Juda kichik: kutilgan ${n.origin} ${v}${n.minimum.toString()} ${$2.unit} ${$2.verb}`;
        return `Juda kichik: kutilgan ${n.origin} ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Noto‘g‘ri satr: "${v.prefix}" bilan boshlanishi kerak`;
        if (v.format === "ends_with") return `Noto‘g‘ri satr: "${v.suffix}" bilan tugashi kerak`;
        if (v.format === "includes") return `Noto‘g‘ri satr: "${v.includes}" ni o‘z ichiga olishi kerak`;
        if (v.format === "regex") return `Noto‘g‘ri satr: ${v.pattern} shabloniga mos kelishi kerak`;
        return `Noto‘g‘ri ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Noto‘g‘ri raqam: ${n.divisor} ning karralisi bo‘lishi kerak`;
      case "unrecognized_keys":
        return `Noma’lum kalit${n.keys.length > 1 ? "lar" : ""}: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `${n.origin} dagi kalit noto‘g‘ri`;
      case "invalid_union":
        return "Noto‘g‘ri kirish";
      case "invalid_element":
        return `${n.origin} da noto‘g‘ri qiymat`;
      default:
        return "Noto‘g‘ri kirish";
    }
  };
};
function L$() {
  return { localeError: vc$1() };
}
var oc$1 = () => {
  let r2 = { string: { unit: "ký tự", verb: "có" }, file: { unit: "byte", verb: "có" }, array: { unit: "phần tử", verb: "có" }, set: { unit: "phần tử", verb: "có" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "đầu vào", email: "địa chỉ email", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ngày giờ ISO", date: "ngày ISO", time: "giờ ISO", duration: "khoảng thời gian ISO", ipv4: "địa chỉ IPv4", ipv6: "địa chỉ IPv6", cidrv4: "dải IPv4", cidrv6: "dải IPv6", base64: "chuỗi mã hóa base64", base64url: "chuỗi mã hóa base64url", json_string: "chuỗi JSON", e164: "số E.164", jwt: "JWT", template_literal: "đầu vào" }, t = { nan: "NaN", number: "số", array: "mảng" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Đầu vào không hợp lệ: mong đợi instanceof ${n.expected}, nhận được ${u2}`;
        return `Đầu vào không hợp lệ: mong đợi ${v}, nhận được ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Đầu vào không hợp lệ: mong đợi ${U$1(n.values[0])}`;
        return `Tùy chọn không hợp lệ: mong đợi một trong các giá trị ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Quá lớn: mong đợi ${n.origin ?? "giá trị"} ${$2.verb} ${v}${n.maximum.toString()} ${$2.unit ?? "phần tử"}`;
        return `Quá lớn: mong đợi ${n.origin ?? "giá trị"} ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Quá nhỏ: mong đợi ${n.origin} ${$2.verb} ${v}${n.minimum.toString()} ${$2.unit}`;
        return `Quá nhỏ: mong đợi ${n.origin} ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Chuỗi không hợp lệ: phải bắt đầu bằng "${v.prefix}"`;
        if (v.format === "ends_with") return `Chuỗi không hợp lệ: phải kết thúc bằng "${v.suffix}"`;
        if (v.format === "includes") return `Chuỗi không hợp lệ: phải bao gồm "${v.includes}"`;
        if (v.format === "regex") return `Chuỗi không hợp lệ: phải khớp với mẫu ${v.pattern}`;
        return `${o[v.format] ?? n.format} không hợp lệ`;
      }
      case "not_multiple_of":
        return `Số không hợp lệ: phải là bội số của ${n.divisor}`;
      case "unrecognized_keys":
        return `Khóa không được nhận dạng: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Khóa không hợp lệ trong ${n.origin}`;
      case "invalid_union":
        return "Đầu vào không hợp lệ";
      case "invalid_element":
        return `Giá trị không hợp lệ trong ${n.origin}`;
      default:
        return "Đầu vào không hợp lệ";
    }
  };
};
function E$() {
  return { localeError: oc$1() };
}
var tc$1 = () => {
  let r2 = { string: { unit: "字符", verb: "包含" }, file: { unit: "字节", verb: "包含" }, array: { unit: "项", verb: "包含" }, set: { unit: "项", verb: "包含" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "输入", email: "电子邮件", url: "URL", emoji: "表情符号", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO日期时间", date: "ISO日期", time: "ISO时间", duration: "ISO时长", ipv4: "IPv4地址", ipv6: "IPv6地址", cidrv4: "IPv4网段", cidrv6: "IPv6网段", base64: "base64编码字符串", base64url: "base64url编码字符串", json_string: "JSON字符串", e164: "E.164号码", jwt: "JWT", template_literal: "输入" }, t = { nan: "NaN", number: "数字", array: "数组", null: "空值(null)" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `无效输入：期望 instanceof ${n.expected}，实际接收 ${u2}`;
        return `无效输入：期望 ${v}，实际接收 ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `无效输入：期望 ${U$1(n.values[0])}`;
        return `无效选项：期望以下之一 ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `数值过大：期望 ${n.origin ?? "值"} ${v}${n.maximum.toString()} ${$2.unit ?? "个元素"}`;
        return `数值过大：期望 ${n.origin ?? "值"} ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `数值过小：期望 ${n.origin} ${v}${n.minimum.toString()} ${$2.unit}`;
        return `数值过小：期望 ${n.origin} ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `无效字符串：必须以 "${v.prefix}" 开头`;
        if (v.format === "ends_with") return `无效字符串：必须以 "${v.suffix}" 结尾`;
        if (v.format === "includes") return `无效字符串：必须包含 "${v.includes}"`;
        if (v.format === "regex") return `无效字符串：必须满足正则表达式 ${v.pattern}`;
        return `无效${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `无效数字：必须是 ${n.divisor} 的倍数`;
      case "unrecognized_keys":
        return `出现未知的键(key): ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `${n.origin} 中的键(key)无效`;
      case "invalid_union":
        return "无效输入";
      case "invalid_element":
        return `${n.origin} 中包含无效值(value)`;
      default:
        return "无效输入";
    }
  };
};
function G$() {
  return { localeError: tc$1() };
}
var $c$1 = () => {
  let r2 = { string: { unit: "字元", verb: "擁有" }, file: { unit: "位元組", verb: "擁有" }, array: { unit: "項目", verb: "擁有" }, set: { unit: "項目", verb: "擁有" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "輸入", email: "郵件地址", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "ISO 日期時間", date: "ISO 日期", time: "ISO 時間", duration: "ISO 期間", ipv4: "IPv4 位址", ipv6: "IPv6 位址", cidrv4: "IPv4 範圍", cidrv6: "IPv6 範圍", base64: "base64 編碼字串", base64url: "base64url 編碼字串", json_string: "JSON 字串", e164: "E.164 數值", jwt: "JWT", template_literal: "輸入" }, t = { nan: "NaN" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `無效的輸入值：預期為 instanceof ${n.expected}，但收到 ${u2}`;
        return `無效的輸入值：預期為 ${v}，但收到 ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `無效的輸入值：預期為 ${U$1(n.values[0])}`;
        return `無效的選項：預期為以下其中之一 ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `數值過大：預期 ${n.origin ?? "值"} 應為 ${v}${n.maximum.toString()} ${$2.unit ?? "個元素"}`;
        return `數值過大：預期 ${n.origin ?? "值"} 應為 ${v}${n.maximum.toString()}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `數值過小：預期 ${n.origin} 應為 ${v}${n.minimum.toString()} ${$2.unit}`;
        return `數值過小：預期 ${n.origin} 應為 ${v}${n.minimum.toString()}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `無效的字串：必須以 "${v.prefix}" 開頭`;
        if (v.format === "ends_with") return `無效的字串：必須以 "${v.suffix}" 結尾`;
        if (v.format === "includes") return `無效的字串：必須包含 "${v.includes}"`;
        if (v.format === "regex") return `無效的字串：必須符合格式 ${v.pattern}`;
        return `無效的 ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `無效的數字：必須為 ${n.divisor} 的倍數`;
      case "unrecognized_keys":
        return `無法識別的鍵值${n.keys.length > 1 ? "們" : ""}：${_$1(n.keys, "、")}`;
      case "invalid_key":
        return `${n.origin} 中有無效的鍵值`;
      case "invalid_union":
        return "無效的輸入值";
      case "invalid_element":
        return `${n.origin} 中有無效的值`;
      default:
        return "無效的輸入值";
    }
  };
};
function W$() {
  return { localeError: $c$1() };
}
var uc$1 = () => {
  let r2 = { string: { unit: "àmi", verb: "ní" }, file: { unit: "bytes", verb: "ní" }, array: { unit: "nkan", verb: "ní" }, set: { unit: "nkan", verb: "ní" } };
  function i(n) {
    return r2[n] ?? null;
  }
  let o = { regex: "ẹ̀rọ ìbáwọlé", email: "àdírẹ́sì ìmẹ́lì", url: "URL", emoji: "emoji", uuid: "UUID", uuidv4: "UUIDv4", uuidv6: "UUIDv6", nanoid: "nanoid", guid: "GUID", cuid: "cuid", cuid2: "cuid2", ulid: "ULID", xid: "XID", ksuid: "KSUID", datetime: "àkókò ISO", date: "ọjọ́ ISO", time: "àkókò ISO", duration: "àkókò tó pé ISO", ipv4: "àdírẹ́sì IPv4", ipv6: "àdírẹ́sì IPv6", cidrv4: "àgbègbè IPv4", cidrv6: "àgbègbè IPv6", base64: "ọ̀rọ̀ tí a kọ́ ní base64", base64url: "ọ̀rọ̀ base64url", json_string: "ọ̀rọ̀ JSON", e164: "nọ́mbà E.164", jwt: "JWT", template_literal: "ẹ̀rọ ìbáwọlé" }, t = { nan: "NaN", number: "nọ́mbà", array: "akopọ" };
  return (n) => {
    switch (n.code) {
      case "invalid_type": {
        let v = t[n.expected] ?? n.expected, $2 = D$2(n.input), u2 = t[$2] ?? $2;
        if (/^[A-Z]/.test(n.expected)) return `Ìbáwọlé aṣìṣe: a ní láti fi instanceof ${n.expected}, àmọ̀ a rí ${u2}`;
        return `Ìbáwọlé aṣìṣe: a ní láti fi ${v}, àmọ̀ a rí ${u2}`;
      }
      case "invalid_value":
        if (n.values.length === 1) return `Ìbáwọlé aṣìṣe: a ní láti fi ${U$1(n.values[0])}`;
        return `Àṣàyàn aṣìṣe: yan ọ̀kan lára ${_$1(n.values, "|")}`;
      case "too_big": {
        let v = n.inclusive ? "<=" : "<", $2 = i(n.origin);
        if ($2) return `Tó pọ̀ jù: a ní láti jẹ́ pé ${n.origin ?? "iye"} ${$2.verb} ${v}${n.maximum} ${$2.unit}`;
        return `Tó pọ̀ jù: a ní láti jẹ́ ${v}${n.maximum}`;
      }
      case "too_small": {
        let v = n.inclusive ? ">=" : ">", $2 = i(n.origin);
        if ($2) return `Kéré ju: a ní láti jẹ́ pé ${n.origin} ${$2.verb} ${v}${n.minimum} ${$2.unit}`;
        return `Kéré ju: a ní láti jẹ́ ${v}${n.minimum}`;
      }
      case "invalid_format": {
        let v = n;
        if (v.format === "starts_with") return `Ọ̀rọ̀ aṣìṣe: gbọ́dọ̀ bẹ̀rẹ̀ pẹ̀lú "${v.prefix}"`;
        if (v.format === "ends_with") return `Ọ̀rọ̀ aṣìṣe: gbọ́dọ̀ parí pẹ̀lú "${v.suffix}"`;
        if (v.format === "includes") return `Ọ̀rọ̀ aṣìṣe: gbọ́dọ̀ ní "${v.includes}"`;
        if (v.format === "regex") return `Ọ̀rọ̀ aṣìṣe: gbọ́dọ̀ bá àpẹẹrẹ mu ${v.pattern}`;
        return `Aṣìṣe: ${o[v.format] ?? n.format}`;
      }
      case "not_multiple_of":
        return `Nọ́mbà aṣìṣe: gbọ́dọ̀ jẹ́ èyà pípín ti ${n.divisor}`;
      case "unrecognized_keys":
        return `Bọtìnì àìmọ̀: ${_$1(n.keys, ", ")}`;
      case "invalid_key":
        return `Bọtìnì aṣìṣe nínú ${n.origin}`;
      case "invalid_union":
        return "Ìbáwọlé aṣìṣe";
      case "invalid_element":
        return `Iye aṣìṣe nínú ${n.origin}`;
      default:
        return "Ìbáwọlé aṣìṣe";
    }
  };
};
function X$() {
  return { localeError: uc$1() };
}
var bl$1, A$ = /* @__PURE__ */ Symbol("ZodOutput"), V$ = /* @__PURE__ */ Symbol("ZodInput");
class K$ {
  constructor() {
    this._map = /* @__PURE__ */ new WeakMap(), this._idmap = /* @__PURE__ */ new Map();
  }
  add(r2, ...i) {
    let o = i[0];
    if (this._map.set(r2, o), o && typeof o === "object" && "id" in o) this._idmap.set(o.id, r2);
    return this;
  }
  clear() {
    return this._map = /* @__PURE__ */ new WeakMap(), this._idmap = /* @__PURE__ */ new Map(), this;
  }
  remove(r2) {
    let i = this._map.get(r2);
    if (i && typeof i === "object" && "id" in i) this._idmap.delete(i.id);
    return this._map.delete(r2), this;
  }
  get(r2) {
    let i = r2._zod.parent;
    if (i) {
      let o = { ...this.get(i) ?? {} };
      delete o.id;
      let t = { ...o, ...this._map.get(r2) };
      return Object.keys(t).length ? t : void 0;
    }
    return this._map.get(r2);
  }
  has(r2) {
    return this._map.has(r2);
  }
}
function gi$1() {
  return new K$();
}
(bl$1 = globalThis).__zod_globalRegistry ?? (bl$1.__zod_globalRegistry = gi$1());
var V = globalThis.__zod_globalRegistry;
function Y$(r2, i) {
  return new r2({ type: "string", ...w$1(i) });
}
function Q$(r2, i) {
  return new r2({ type: "string", coerce: true, ...w$1(i) });
}
function ei$1(r2, i) {
  return new r2({ type: "string", format: "email", check: "string_format", abort: false, ...w$1(i) });
}
function zn$1(r2, i) {
  return new r2({ type: "string", format: "guid", check: "string_format", abort: false, ...w$1(i) });
}
function li$1(r2, i) {
  return new r2({ type: "string", format: "uuid", check: "string_format", abort: false, ...w$1(i) });
}
function Ii$1(r2, i) {
  return new r2({ type: "string", format: "uuid", check: "string_format", abort: false, version: "v4", ...w$1(i) });
}
function ci$1(r2, i) {
  return new r2({ type: "string", format: "uuid", check: "string_format", abort: false, version: "v6", ...w$1(i) });
}
function _i$1(r2, i) {
  return new r2({ type: "string", format: "uuid", check: "string_format", abort: false, version: "v7", ...w$1(i) });
}
function Pn$1(r2, i) {
  return new r2({ type: "string", format: "url", check: "string_format", abort: false, ...w$1(i) });
}
function bi$1(r2, i) {
  return new r2({ type: "string", format: "emoji", check: "string_format", abort: false, ...w$1(i) });
}
function Ui$1(r2, i) {
  return new r2({ type: "string", format: "nanoid", check: "string_format", abort: false, ...w$1(i) });
}
function Di$1(r2, i) {
  return new r2({ type: "string", format: "cuid", check: "string_format", abort: false, ...w$1(i) });
}
function ki$1(r2, i) {
  return new r2({ type: "string", format: "cuid2", check: "string_format", abort: false, ...w$1(i) });
}
function wi$1(r2, i) {
  return new r2({ type: "string", format: "ulid", check: "string_format", abort: false, ...w$1(i) });
}
function Ni$1(r2, i) {
  return new r2({ type: "string", format: "xid", check: "string_format", abort: false, ...w$1(i) });
}
function Oi$1(r2, i) {
  return new r2({ type: "string", format: "ksuid", check: "string_format", abort: false, ...w$1(i) });
}
function Si$1(r2, i) {
  return new r2({ type: "string", format: "ipv4", check: "string_format", abort: false, ...w$1(i) });
}
function zi$1(r2, i) {
  return new r2({ type: "string", format: "ipv6", check: "string_format", abort: false, ...w$1(i) });
}
function T$(r2, i) {
  return new r2({ type: "string", format: "mac", check: "string_format", abort: false, ...w$1(i) });
}
function Pi$1(r2, i) {
  return new r2({ type: "string", format: "cidrv4", check: "string_format", abort: false, ...w$1(i) });
}
function ji$1(r2, i) {
  return new r2({ type: "string", format: "cidrv6", check: "string_format", abort: false, ...w$1(i) });
}
function Ji$1(r2, i) {
  return new r2({ type: "string", format: "base64", check: "string_format", abort: false, ...w$1(i) });
}
function Li$1(r2, i) {
  return new r2({ type: "string", format: "base64url", check: "string_format", abort: false, ...w$1(i) });
}
function Ei$1(r2, i) {
  return new r2({ type: "string", format: "e164", check: "string_format", abort: false, ...w$1(i) });
}
function Gi$1(r2, i) {
  return new r2({ type: "string", format: "jwt", check: "string_format", abort: false, ...w$1(i) });
}
var F$ = { Any: null, Minute: -1, Second: 0, Millisecond: 3, Microsecond: 6 };
function q$(r2, i) {
  return new r2({ type: "string", format: "datetime", check: "string_format", offset: false, local: false, precision: null, ...w$1(i) });
}
function B$(r2, i) {
  return new r2({ type: "string", format: "date", check: "string_format", ...w$1(i) });
}
function H$(r2, i) {
  return new r2({ type: "string", format: "time", check: "string_format", precision: null, ...w$1(i) });
}
function M$(r2, i) {
  return new r2({ type: "string", format: "duration", check: "string_format", ...w$1(i) });
}
function m$(r2, i) {
  return new r2({ type: "number", checks: [], ...w$1(i) });
}
function R$(r2, i) {
  return new r2({ type: "number", coerce: true, checks: [], ...w$1(i) });
}
function x$(r2, i) {
  return new r2({ type: "number", check: "number_format", abort: false, format: "safeint", ...w$1(i) });
}
function Z$(r2, i) {
  return new r2({ type: "number", check: "number_format", abort: false, format: "float32", ...w$1(i) });
}
function d$(r2, i) {
  return new r2({ type: "number", check: "number_format", abort: false, format: "float64", ...w$1(i) });
}
function C$(r2, i) {
  return new r2({ type: "number", check: "number_format", abort: false, format: "int32", ...w$1(i) });
}
function f$(r2, i) {
  return new r2({ type: "number", check: "number_format", abort: false, format: "uint32", ...w$1(i) });
}
function y$(r2, i) {
  return new r2({ type: "boolean", ...w$1(i) });
}
function h$(r2, i) {
  return new r2({ type: "boolean", coerce: true, ...w$1(i) });
}
function a$(r2, i) {
  return new r2({ type: "bigint", ...w$1(i) });
}
function p$(r2, i) {
  return new r2({ type: "bigint", coerce: true, ...w$1(i) });
}
function s$(r2, i) {
  return new r2({ type: "bigint", check: "bigint_format", abort: false, format: "int64", ...w$1(i) });
}
function ru$1(r2, i) {
  return new r2({ type: "bigint", check: "bigint_format", abort: false, format: "uint64", ...w$1(i) });
}
function nu$1(r2, i) {
  return new r2({ type: "symbol", ...w$1(i) });
}
function iu$1(r2, i) {
  return new r2({ type: "undefined", ...w$1(i) });
}
function vu$1(r2, i) {
  return new r2({ type: "null", ...w$1(i) });
}
function ou$1(r2) {
  return new r2({ type: "any" });
}
function tu$1(r2) {
  return new r2({ type: "unknown" });
}
function $u$1(r2, i) {
  return new r2({ type: "never", ...w$1(i) });
}
function uu$1(r2, i) {
  return new r2({ type: "void", ...w$1(i) });
}
function gu$1(r2, i) {
  return new r2({ type: "date", ...w$1(i) });
}
function eu$1(r2, i) {
  return new r2({ type: "date", coerce: true, ...w$1(i) });
}
function lu$1(r2, i) {
  return new r2({ type: "nan", ...w$1(i) });
}
function y$1(r2, i) {
  return new hn$1({ check: "less_than", ...w$1(i), value: r2, inclusive: false });
}
function m$2(r2, i) {
  return new hn$1({ check: "less_than", ...w$1(i), value: r2, inclusive: true });
}
function h$1(r2, i) {
  return new an$1({ check: "greater_than", ...w$1(i), value: r2, inclusive: false });
}
function Q(r2, i) {
  return new an$1({ check: "greater_than", ...w$1(i), value: r2, inclusive: true });
}
function Wi$1(r2) {
  return h$1(0, r2);
}
function Xi$1(r2) {
  return y$1(0, r2);
}
function Ai$1(r2) {
  return m$2(0, r2);
}
function Vi$1(r2) {
  return Q(0, r2);
}
function ur(r2, i) {
  return new eo$1({ check: "multiple_of", ...w$1(i), value: r2 });
}
function gr$1(r2, i) {
  return new co({ check: "max_size", ...w$1(i), maximum: r2 });
}
function a(r2, i) {
  return new _o$1({ check: "min_size", ...w$1(i), minimum: r2 });
}
function Dr$1(r2, i) {
  return new bo$1({ check: "size_equals", ...w$1(i), size: r2 });
}
function kr$1(r2, i) {
  return new Uo$1({ check: "max_length", ...w$1(i), maximum: r2 });
}
function nr(r2, i) {
  return new Do$1({ check: "min_length", ...w$1(i), minimum: r2 });
}
function wr$1(r2, i) {
  return new ko$1({ check: "length_equals", ...w$1(i), length: r2 });
}
function Vr$1(r2, i) {
  return new wo$1({ check: "string_format", format: "regex", ...w$1(i), pattern: r2 });
}
function Kr$1(r2) {
  return new No$1({ check: "string_format", format: "lowercase", ...w$1(r2) });
}
function Yr$1(r2) {
  return new Oo$1({ check: "string_format", format: "uppercase", ...w$1(r2) });
}
function Qr$1(r2, i) {
  return new So$1({ check: "string_format", format: "includes", ...w$1(i), includes: r2 });
}
function Tr$1(r2, i) {
  return new zo$1({ check: "string_format", format: "starts_with", ...w$1(i), prefix: r2 });
}
function Fr$1(r2, i) {
  return new Po$1({ check: "string_format", format: "ends_with", ...w$1(i), suffix: r2 });
}
function Ki$1(r2, i, o) {
  return new jo$1({ check: "property", property: r2, schema: i, ...w$1(o) });
}
function qr$1(r2, i) {
  return new Jo$1({ check: "mime_type", mime: r2, ...w$1(i) });
}
function d(r2) {
  return new Lo$1({ check: "overwrite", tx: r2 });
}
function Br$1(r2) {
  return d((i) => i.normalize(r2));
}
function Hr$1() {
  return d((r2) => r2.trim());
}
function Mr$1() {
  return d((r2) => r2.toLowerCase());
}
function mr$1() {
  return d((r2) => r2.toUpperCase());
}
function Rr$1() {
  return d((r2) => jv$1(r2));
}
function Iu$1(r2, i, o) {
  return new r2({ type: "array", element: i, ...w$1(o) });
}
function ec$1(r2, i, o) {
  return new r2({ type: "union", options: i, ...w$1(o) });
}
function lc$1(r2, i, o) {
  return new r2({ type: "union", options: i, inclusive: false, ...w$1(o) });
}
function Ic$1(r2, i, o, t) {
  return new r2({ type: "union", options: o, discriminator: i, ...w$1(t) });
}
function cc$1(r2, i, o) {
  return new r2({ type: "intersection", left: i, right: o });
}
function _c$1(r2, i, o, t) {
  let n = o instanceof z$1;
  return new r2({ type: "tuple", items: i, rest: n ? o : null, ...w$1(n ? t : o) });
}
function bc$1(r2, i, o, t) {
  return new r2({ type: "record", keyType: i, valueType: o, ...w$1(t) });
}
function Uc$1(r2, i, o, t) {
  return new r2({ type: "map", keyType: i, valueType: o, ...w$1(t) });
}
function Dc$1(r2, i, o) {
  return new r2({ type: "set", valueType: i, ...w$1(o) });
}
function kc$1(r2, i, o) {
  let t = Array.isArray(i) ? Object.fromEntries(i.map((n) => [n, n])) : i;
  return new r2({ type: "enum", entries: t, ...w$1(o) });
}
function wc$1(r2, i, o) {
  return new r2({ type: "enum", entries: i, ...w$1(o) });
}
function Nc$1(r2, i, o) {
  return new r2({ type: "literal", values: Array.isArray(i) ? i : [i], ...w$1(o) });
}
function cu$1(r2, i) {
  return new r2({ type: "file", ...w$1(i) });
}
function Oc$1(r2, i) {
  return new r2({ type: "transform", transform: i });
}
function Sc$1(r2, i) {
  return new r2({ type: "optional", innerType: i });
}
function zc$1(r2, i) {
  return new r2({ type: "nullable", innerType: i });
}
function Pc$1(r2, i, o) {
  return new r2({ type: "default", innerType: i, get defaultValue() {
    return typeof o === "function" ? o() : Lv$1(o);
  } });
}
function jc$1(r2, i, o) {
  return new r2({ type: "nonoptional", innerType: i, ...w$1(o) });
}
function Jc$1(r2, i) {
  return new r2({ type: "success", innerType: i });
}
function Lc$1(r2, i, o) {
  return new r2({ type: "catch", innerType: i, catchValue: typeof o === "function" ? o : () => o });
}
function Ec$1(r2, i, o) {
  return new r2({ type: "pipe", in: i, out: o });
}
function Gc$1(r2, i) {
  return new r2({ type: "readonly", innerType: i });
}
function Wc$1(r2, i, o) {
  return new r2({ type: "template_literal", parts: i, ...w$1(o) });
}
function Xc$1(r2, i) {
  return new r2({ type: "lazy", getter: i });
}
function Ac$1(r2, i) {
  return new r2({ type: "promise", innerType: i });
}
function _u$1(r2, i, o) {
  let t = w$1(o);
  return t.abort ?? (t.abort = true), new r2({ type: "custom", check: "custom", fn: i, ...t });
}
function bu$1(r2, i, o) {
  return new r2({ type: "custom", check: "custom", fn: i, ...w$1(o) });
}
function Uu$1(r2) {
  let i = Ul$1((o) => {
    return o.addIssue = (t) => {
      if (typeof t === "string") o.issues.push(Jr$1(t, o.value, i._zod.def));
      else {
        let n = t;
        if (n.fatal) n.continue = false;
        n.code ?? (n.code = "custom"), n.input ?? (n.input = o.value), n.inst ?? (n.inst = i), n.continue ?? (n.continue = !i._zod.def.abort), o.issues.push(Jr$1(n));
      }
    }, r2(o.value, o);
  });
  return i;
}
function Ul$1(r2, i) {
  let o = new W$1({ check: "custom", ...w$1(i) });
  return o._zod.check = r2, o;
}
function Du$1(r2) {
  let i = new W$1({ check: "describe" });
  return i._zod.onattach = [(o) => {
    let t = V.get(o) ?? {};
    V.add(o, { ...t, description: r2 });
  }], i._zod.check = () => {
  }, i;
}
function ku$1(r2) {
  let i = new W$1({ check: "meta" });
  return i._zod.onattach = [(o) => {
    let t = V.get(o) ?? {};
    V.add(o, { ...t, ...r2 });
  }], i._zod.check = () => {
  }, i;
}
function wu$1(r2, i) {
  let o = w$1(i), t = o.truthy ?? ["true", "1", "yes", "on", "y", "enabled"], n = o.falsy ?? ["false", "0", "no", "off", "n", "disabled"];
  if (o.case !== "sensitive") t = t.map((O) => typeof O === "string" ? O.toLowerCase() : O), n = n.map((O) => typeof O === "string" ? O.toLowerCase() : O);
  let v = new Set(t), $2 = new Set(n), u2 = r2.Codec ?? Dn$1, l = r2.Boolean ?? bn$1, c = new (r2.String ?? Ur$1)({ type: "string", error: o.error }), b = new l({ type: "boolean", error: o.error }), N2 = new u2({ type: "pipe", in: c, out: b, transform: (O, J2) => {
    let X2 = O;
    if (o.case !== "sensitive") X2 = X2.toLowerCase();
    if (v.has(X2)) return true;
    else if ($2.has(X2)) return false;
    else return J2.issues.push({ code: "invalid_value", expected: "stringbool", values: [...v, ...$2], input: J2.value, inst: N2, continue: false }), {};
  }, reverseTransform: (O, J2) => {
    if (O === true) return t[0] || "true";
    else return n[0] || "false";
  }, error: o.error });
  return N2;
}
function xr$1(r2, i, o, t = {}) {
  let n = w$1(t), v = { ...w$1(t), check: "string_format", type: "string", format: i, fn: typeof o === "function" ? o : (u2) => o.test(u2), ...n };
  if (o instanceof RegExp) v.pattern = o;
  return new r2(v);
}
function er(r2) {
  let i = r2?.target ?? "draft-2020-12";
  if (i === "draft-4") i = "draft-04";
  if (i === "draft-7") i = "draft-07";
  return { processors: r2.processors ?? {}, metadataRegistry: r2?.metadata ?? V, target: i, unrepresentable: r2?.unrepresentable ?? "throw", override: r2?.override ?? (() => {
  }), io: r2?.io ?? "output", counter: 0, seen: /* @__PURE__ */ new Map(), cycles: r2?.cycles ?? "ref", reused: r2?.reused ?? "inline", external: r2?.external ?? void 0 };
}
function L$1(r2, i, o = { path: [], schemaPath: [] }) {
  var t;
  let n = r2._zod.def, v = i.seen.get(r2);
  if (v) {
    if (v.count++, o.schemaPath.includes(r2)) v.cycle = o.path;
    return v.schema;
  }
  let $2 = { schema: {}, count: 1, cycle: void 0, path: o.path };
  i.seen.set(r2, $2);
  let u2 = r2._zod.toJSONSchema?.();
  if (u2) $2.schema = u2;
  else {
    let c = { ...o, schemaPath: [...o.schemaPath, r2], path: o.path };
    if (r2._zod.processJSONSchema) r2._zod.processJSONSchema(i, $2.schema, c);
    else {
      let N2 = $2.schema, O = i.processors[n.type];
      if (!O) throw Error(`[toJSONSchema]: Non-representable type encountered: ${n.type}`);
      O(r2, i, N2, c);
    }
    let b = r2._zod.parent;
    if (b) {
      if (!$2.ref) $2.ref = b;
      L$1(b, i, c), i.seen.get(b).isParent = true;
    }
  }
  let l = i.metadataRegistry.get(r2);
  if (l) Object.assign($2.schema, l);
  if (i.io === "input" && T$2(r2)) delete $2.schema.examples, delete $2.schema.default;
  if (i.io === "input" && $2.schema._prefault) (t = $2.schema).default ?? (t.default = $2.schema._prefault);
  return delete $2.schema._prefault, i.seen.get(r2).schema;
}
function lr(r2, i) {
  let o = r2.seen.get(i);
  if (!o) throw Error("Unprocessed schema. This is a bug in Zod.");
  let t = /* @__PURE__ */ new Map();
  for (let $2 of r2.seen.entries()) {
    let u2 = r2.metadataRegistry.get($2[0])?.id;
    if (u2) {
      let l = t.get(u2);
      if (l && l !== $2[0]) throw Error(`Duplicate schema id "${u2}" detected during JSON Schema conversion. Two different schemas cannot share the same id when converted together.`);
      t.set(u2, $2[0]);
    }
  }
  let n = ($2) => {
    let u2 = r2.target === "draft-2020-12" ? "$defs" : "definitions";
    if (r2.external) {
      let b = r2.external.registry.get($2[0])?.id, N2 = r2.external.uri ?? ((J2) => J2);
      if (b) return { ref: N2(b) };
      let O = $2[1].defId ?? $2[1].schema.id ?? `schema${r2.counter++}`;
      return $2[1].defId = O, { defId: O, ref: `${N2("__shared")}#/${u2}/${O}` };
    }
    if ($2[1] === o) return { ref: "#" };
    let e = `${"#"}/${u2}/`, c = $2[1].schema.id ?? `__schema${r2.counter++}`;
    return { defId: c, ref: e + c };
  }, v = ($2) => {
    if ($2[1].schema.$ref) return;
    let u2 = $2[1], { ref: l, defId: e } = n($2);
    if (u2.def = { ...u2.schema }, e) u2.defId = e;
    let c = u2.schema;
    for (let b in c) delete c[b];
    c.$ref = l;
  };
  if (r2.cycles === "throw") for (let $2 of r2.seen.entries()) {
    let u2 = $2[1];
    if (u2.cycle) throw Error(`Cycle detected: #/${u2.cycle?.join("/")}/<root>

Set the \`cycles\` parameter to \`"ref"\` to resolve cyclical schemas with defs.`);
  }
  for (let $2 of r2.seen.entries()) {
    let u2 = $2[1];
    if (i === $2[0]) {
      v($2);
      continue;
    }
    if (r2.external) {
      let e = r2.external.registry.get($2[0])?.id;
      if (i !== $2[0] && e) {
        v($2);
        continue;
      }
    }
    if (r2.metadataRegistry.get($2[0])?.id) {
      v($2);
      continue;
    }
    if (u2.cycle) {
      v($2);
      continue;
    }
    if (u2.count > 1) {
      if (r2.reused === "ref") {
        v($2);
        continue;
      }
    }
  }
}
function Ir$1(r2, i) {
  let o = r2.seen.get(i);
  if (!o) throw Error("Unprocessed schema. This is a bug in Zod.");
  let t = ($2) => {
    let u2 = r2.seen.get($2);
    if (u2.ref === null) return;
    let l = u2.def ?? u2.schema, e = { ...l }, c = u2.ref;
    if (u2.ref = null, c) {
      t(c);
      let N2 = r2.seen.get(c), O = N2.schema;
      if (O.$ref && (r2.target === "draft-07" || r2.target === "draft-04" || r2.target === "openapi-3.0")) l.allOf = l.allOf ?? [], l.allOf.push(O);
      else Object.assign(l, O);
      if (Object.assign(l, e), $2._zod.parent === c) for (let X2 in l) {
        if (X2 === "$ref" || X2 === "allOf") continue;
        if (!(X2 in e)) delete l[X2];
      }
      if (O.$ref) for (let X2 in l) {
        if (X2 === "$ref" || X2 === "allOf") continue;
        if (X2 in N2.def && JSON.stringify(l[X2]) === JSON.stringify(N2.def[X2])) delete l[X2];
      }
    }
    let b = $2._zod.parent;
    if (b && b !== c) {
      t(b);
      let N2 = r2.seen.get(b);
      if (N2?.schema.$ref) {
        if (l.$ref = N2.schema.$ref, N2.def) for (let O in l) {
          if (O === "$ref" || O === "allOf") continue;
          if (O in N2.def && JSON.stringify(l[O]) === JSON.stringify(N2.def[O])) delete l[O];
        }
      }
    }
    r2.override({ zodSchema: $2, jsonSchema: l, path: u2.path ?? [] });
  };
  for (let $2 of [...r2.seen.entries()].reverse()) t($2[0]);
  let n = {};
  if (r2.target === "draft-2020-12") n.$schema = "https://json-schema.org/draft/2020-12/schema";
  else if (r2.target === "draft-07") n.$schema = "http://json-schema.org/draft-07/schema#";
  else if (r2.target === "draft-04") n.$schema = "http://json-schema.org/draft-04/schema#";
  else if (r2.target === "openapi-3.0") ;
  if (r2.external?.uri) {
    let $2 = r2.external.registry.get(i)?.id;
    if (!$2) throw Error("Schema is missing an `id` property");
    n.$id = r2.external.uri($2);
  }
  Object.assign(n, o.def ?? o.schema);
  let v = r2.external?.defs ?? {};
  for (let $2 of r2.seen.entries()) {
    let u2 = $2[1];
    if (u2.def && u2.defId) v[u2.defId] = u2.def;
  }
  if (r2.external) ;
  else if (Object.keys(v).length > 0) if (r2.target === "draft-2020-12") n.$defs = v;
  else n.definitions = v;
  try {
    let $2 = JSON.parse(JSON.stringify(n));
    return Object.defineProperty($2, "~standard", { value: { ...i["~standard"], jsonSchema: { input: Zr$1(i, "input", r2.processors), output: Zr$1(i, "output", r2.processors) } }, enumerable: false, writable: false }), $2;
  } catch ($2) {
    throw Error("Error converting schema to JSON.");
  }
}
function T$2(r2, i) {
  let o = i ?? { seen: /* @__PURE__ */ new Set() };
  if (o.seen.has(r2)) return false;
  o.seen.add(r2);
  let t = r2._zod.def;
  if (t.type === "transform") return true;
  if (t.type === "array") return T$2(t.element, o);
  if (t.type === "set") return T$2(t.valueType, o);
  if (t.type === "lazy") return T$2(t.getter(), o);
  if (t.type === "promise" || t.type === "optional" || t.type === "nonoptional" || t.type === "nullable" || t.type === "readonly" || t.type === "default" || t.type === "prefault") return T$2(t.innerType, o);
  if (t.type === "intersection") return T$2(t.left, o) || T$2(t.right, o);
  if (t.type === "record" || t.type === "map") return T$2(t.keyType, o) || T$2(t.valueType, o);
  if (t.type === "pipe") return T$2(t.in, o) || T$2(t.out, o);
  if (t.type === "object") {
    for (let n in t.shape) if (T$2(t.shape[n], o)) return true;
    return false;
  }
  if (t.type === "union") {
    for (let n of t.options) if (T$2(n, o)) return true;
    return false;
  }
  if (t.type === "tuple") {
    for (let n of t.items) if (T$2(n, o)) return true;
    if (t.rest && T$2(t.rest, o)) return true;
    return false;
  }
  return false;
}
var Nu$1 = (r2, i = {}) => (o) => {
  let t = er({ ...o, processors: i });
  return L$1(r2, t), lr(t, r2), Ir$1(t, r2);
}, Zr$1 = (r2, i, o = {}) => (t) => {
  let { libraryOptions: n, target: v } = t ?? {}, $2 = er({ ...n ?? {}, target: v, io: i, processors: o });
  return L$1(r2, $2), lr($2, r2), Ir$1($2, r2);
};
var Vc$1 = { guid: "uuid", url: "uri", datetime: "date-time", json_string: "json-string", regex: "" }, Ou$1 = (r2, i, o, t) => {
  let n = o;
  n.type = "string";
  let { minimum: v, maximum: $2, format: u2, patterns: l, contentEncoding: e } = r2._zod.bag;
  if (typeof v === "number") n.minLength = v;
  if (typeof $2 === "number") n.maxLength = $2;
  if (u2) {
    if (n.format = Vc$1[u2] ?? u2, n.format === "") delete n.format;
    if (u2 === "time") delete n.format;
  }
  if (e) n.contentEncoding = e;
  if (l && l.size > 0) {
    let c = [...l];
    if (c.length === 1) n.pattern = c[0].source;
    else if (c.length > 1) n.allOf = [...c.map((b) => ({ ...i.target === "draft-07" || i.target === "draft-04" || i.target === "openapi-3.0" ? { type: "string" } : {}, pattern: b.source }))];
  }
}, Su$1 = (r2, i, o, t) => {
  let n = o, { minimum: v, maximum: $2, format: u2, multipleOf: l, exclusiveMaximum: e, exclusiveMinimum: c } = r2._zod.bag;
  if (typeof u2 === "string" && u2.includes("int")) n.type = "integer";
  else n.type = "number";
  if (typeof c === "number") if (i.target === "draft-04" || i.target === "openapi-3.0") n.minimum = c, n.exclusiveMinimum = true;
  else n.exclusiveMinimum = c;
  if (typeof v === "number") {
    if (n.minimum = v, typeof c === "number" && i.target !== "draft-04") if (c >= v) delete n.minimum;
    else delete n.exclusiveMinimum;
  }
  if (typeof e === "number") if (i.target === "draft-04" || i.target === "openapi-3.0") n.maximum = e, n.exclusiveMaximum = true;
  else n.exclusiveMaximum = e;
  if (typeof $2 === "number") {
    if (n.maximum = $2, typeof e === "number" && i.target !== "draft-04") if (e <= $2) delete n.maximum;
    else delete n.exclusiveMaximum;
  }
  if (typeof l === "number") n.multipleOf = l;
}, zu$1 = (r2, i, o, t) => {
  o.type = "boolean";
}, Pu$1 = (r2, i, o, t) => {
  if (i.unrepresentable === "throw") throw Error("BigInt cannot be represented in JSON Schema");
}, ju$1 = (r2, i, o, t) => {
  if (i.unrepresentable === "throw") throw Error("Symbols cannot be represented in JSON Schema");
}, Ju$1 = (r2, i, o, t) => {
  if (i.target === "openapi-3.0") o.type = "string", o.nullable = true, o.enum = [null];
  else o.type = "null";
}, Lu$1 = (r2, i, o, t) => {
  if (i.unrepresentable === "throw") throw Error("Undefined cannot be represented in JSON Schema");
}, Eu$1 = (r2, i, o, t) => {
  if (i.unrepresentable === "throw") throw Error("Void cannot be represented in JSON Schema");
}, Gu$1 = (r2, i, o, t) => {
  o.not = {};
}, Wu$1 = (r2, i, o, t) => {
}, Xu$1 = (r2, i, o, t) => {
}, Au$1 = (r2, i, o, t) => {
  if (i.unrepresentable === "throw") throw Error("Date cannot be represented in JSON Schema");
}, Vu$1 = (r2, i, o, t) => {
  let n = r2._zod.def, v = vn$1(n.entries);
  if (v.every(($2) => typeof $2 === "number")) o.type = "number";
  if (v.every(($2) => typeof $2 === "string")) o.type = "string";
  o.enum = v;
}, Ku$1 = (r2, i, o, t) => {
  let n = r2._zod.def, v = [];
  for (let $2 of n.values) if ($2 === void 0) {
    if (i.unrepresentable === "throw") throw Error("Literal `undefined` cannot be represented in JSON Schema");
  } else if (typeof $2 === "bigint") if (i.unrepresentable === "throw") throw Error("BigInt literals cannot be represented in JSON Schema");
  else v.push(Number($2));
  else v.push($2);
  if (v.length === 0) ;
  else if (v.length === 1) {
    let $2 = v[0];
    if (o.type = $2 === null ? "null" : typeof $2, i.target === "draft-04" || i.target === "openapi-3.0") o.enum = [$2];
    else o.const = $2;
  } else {
    if (v.every(($2) => typeof $2 === "number")) o.type = "number";
    if (v.every(($2) => typeof $2 === "string")) o.type = "string";
    if (v.every(($2) => typeof $2 === "boolean")) o.type = "boolean";
    if (v.every(($2) => $2 === null)) o.type = "null";
    o.enum = v;
  }
}, Yu$1 = (r2, i, o, t) => {
  if (i.unrepresentable === "throw") throw Error("NaN cannot be represented in JSON Schema");
}, Qu$1 = (r2, i, o, t) => {
  let n = o, v = r2._zod.pattern;
  if (!v) throw Error("Pattern not found in template literal");
  n.type = "string", n.pattern = v.source;
}, Tu$1 = (r2, i, o, t) => {
  let n = o, v = { type: "string", format: "binary", contentEncoding: "binary" }, { minimum: $2, maximum: u2, mime: l } = r2._zod.bag;
  if ($2 !== void 0) v.minLength = $2;
  if (u2 !== void 0) v.maxLength = u2;
  if (l) if (l.length === 1) v.contentMediaType = l[0], Object.assign(n, v);
  else Object.assign(n, v), n.anyOf = l.map((e) => ({ contentMediaType: e }));
  else Object.assign(n, v);
}, Fu$1 = (r2, i, o, t) => {
  o.type = "boolean";
}, qu$1 = (r2, i, o, t) => {
  if (i.unrepresentable === "throw") throw Error("Custom types cannot be represented in JSON Schema");
}, Bu$1 = (r2, i, o, t) => {
  if (i.unrepresentable === "throw") throw Error("Function types cannot be represented in JSON Schema");
}, Hu$1 = (r2, i, o, t) => {
  if (i.unrepresentable === "throw") throw Error("Transforms cannot be represented in JSON Schema");
}, Mu$1 = (r2, i, o, t) => {
  if (i.unrepresentable === "throw") throw Error("Map cannot be represented in JSON Schema");
}, mu$1 = (r2, i, o, t) => {
  if (i.unrepresentable === "throw") throw Error("Set cannot be represented in JSON Schema");
}, Ru$1 = (r2, i, o, t) => {
  let n = o, v = r2._zod.def, { minimum: $2, maximum: u2 } = r2._zod.bag;
  if (typeof $2 === "number") n.minItems = $2;
  if (typeof u2 === "number") n.maxItems = u2;
  n.type = "array", n.items = L$1(v.element, i, { ...t, path: [...t.path, "items"] });
}, xu$1 = (r2, i, o, t) => {
  let n = o, v = r2._zod.def;
  n.type = "object", n.properties = {};
  let $2 = v.shape;
  for (let e in $2) n.properties[e] = L$1($2[e], i, { ...t, path: [...t.path, "properties", e] });
  let u2 = new Set(Object.keys($2)), l = new Set([...u2].filter((e) => {
    let c = v.shape[e]._zod;
    if (i.io === "input") return c.optin === void 0;
    else return c.optout === void 0;
  }));
  if (l.size > 0) n.required = Array.from(l);
  if (v.catchall?._zod.def.type === "never") n.additionalProperties = false;
  else if (!v.catchall) {
    if (i.io === "output") n.additionalProperties = false;
  } else if (v.catchall) n.additionalProperties = L$1(v.catchall, i, { ...t, path: [...t.path, "additionalProperties"] });
}, Qi$1 = (r2, i, o, t) => {
  let n = r2._zod.def, v = n.inclusive === false, $2 = n.options.map((u2, l) => L$1(u2, i, { ...t, path: [...t.path, v ? "oneOf" : "anyOf", l] }));
  if (v) o.oneOf = $2;
  else o.anyOf = $2;
}, Zu$1 = (r2, i, o, t) => {
  let n = r2._zod.def, v = L$1(n.left, i, { ...t, path: [...t.path, "allOf", 0] }), $2 = L$1(n.right, i, { ...t, path: [...t.path, "allOf", 1] }), u2 = (e) => "allOf" in e && Object.keys(e).length === 1, l = [...u2(v) ? v.allOf : [v], ...u2($2) ? $2.allOf : [$2]];
  o.allOf = l;
}, du$1 = (r2, i, o, t) => {
  let n = o, v = r2._zod.def;
  n.type = "array";
  let $2 = i.target === "draft-2020-12" ? "prefixItems" : "items", u2 = i.target === "draft-2020-12" ? "items" : i.target === "openapi-3.0" ? "items" : "additionalItems", l = v.items.map((N2, O) => L$1(N2, i, { ...t, path: [...t.path, $2, O] })), e = v.rest ? L$1(v.rest, i, { ...t, path: [...t.path, u2, ...i.target === "openapi-3.0" ? [v.items.length] : []] }) : null;
  if (i.target === "draft-2020-12") {
    if (n.prefixItems = l, e) n.items = e;
  } else if (i.target === "openapi-3.0") {
    if (n.items = { anyOf: l }, e) n.items.anyOf.push(e);
    if (n.minItems = l.length, !e) n.maxItems = l.length;
  } else if (n.items = l, e) n.additionalItems = e;
  let { minimum: c, maximum: b } = r2._zod.bag;
  if (typeof c === "number") n.minItems = c;
  if (typeof b === "number") n.maxItems = b;
}, Cu$1 = (r2, i, o, t) => {
  let n = o, v = r2._zod.def;
  n.type = "object";
  let $2 = v.keyType, l = $2._zod.bag?.patterns;
  if (v.mode === "loose" && l && l.size > 0) {
    let c = L$1(v.valueType, i, { ...t, path: [...t.path, "patternProperties", "*"] });
    n.patternProperties = {};
    for (let b of l) n.patternProperties[b.source] = c;
  } else {
    if (i.target === "draft-07" || i.target === "draft-2020-12") n.propertyNames = L$1(v.keyType, i, { ...t, path: [...t.path, "propertyNames"] });
    n.additionalProperties = L$1(v.valueType, i, { ...t, path: [...t.path, "additionalProperties"] });
  }
  let e = $2._zod.values;
  if (e) {
    let c = [...e].filter((b) => typeof b === "string" || typeof b === "number");
    if (c.length > 0) n.required = c;
  }
}, fu$1 = (r2, i, o, t) => {
  let n = r2._zod.def, v = L$1(n.innerType, i, t), $2 = i.seen.get(r2);
  if (i.target === "openapi-3.0") $2.ref = n.innerType, o.nullable = true;
  else o.anyOf = [v, { type: "null" }];
}, yu$1 = (r2, i, o, t) => {
  let n = r2._zod.def;
  L$1(n.innerType, i, t);
  let v = i.seen.get(r2);
  v.ref = n.innerType;
}, hu$1 = (r2, i, o, t) => {
  let n = r2._zod.def;
  L$1(n.innerType, i, t);
  let v = i.seen.get(r2);
  v.ref = n.innerType, o.default = JSON.parse(JSON.stringify(n.defaultValue));
}, au$1 = (r2, i, o, t) => {
  let n = r2._zod.def;
  L$1(n.innerType, i, t);
  let v = i.seen.get(r2);
  if (v.ref = n.innerType, i.io === "input") o._prefault = JSON.parse(JSON.stringify(n.defaultValue));
}, pu$1 = (r2, i, o, t) => {
  let n = r2._zod.def;
  L$1(n.innerType, i, t);
  let v = i.seen.get(r2);
  v.ref = n.innerType;
  let $2;
  try {
    $2 = n.catchValue(void 0);
  } catch {
    throw Error("Dynamic catch values are not supported in JSON Schema");
  }
  o.default = $2;
}, su$1 = (r2, i, o, t) => {
  let n = r2._zod.def, v = i.io === "input" ? n.in._zod.def.type === "transform" ? n.out : n.in : n.out;
  L$1(v, i, t);
  let $2 = i.seen.get(r2);
  $2.ref = v;
}, rg$1 = (r2, i, o, t) => {
  let n = r2._zod.def;
  L$1(n.innerType, i, t);
  let v = i.seen.get(r2);
  v.ref = n.innerType, o.readOnly = true;
}, ng$1 = (r2, i, o, t) => {
  let n = r2._zod.def;
  L$1(n.innerType, i, t);
  let v = i.seen.get(r2);
  v.ref = n.innerType;
}, Ti$1 = (r2, i, o, t) => {
  let n = r2._zod.def;
  L$1(n.innerType, i, t);
  let v = i.seen.get(r2);
  v.ref = n.innerType;
}, ig$1 = (r2, i, o, t) => {
  let n = r2._zod.innerType;
  L$1(n, i, t);
  let v = i.seen.get(r2);
  v.ref = n;
}, Yi$1 = { string: Ou$1, number: Su$1, boolean: zu$1, bigint: Pu$1, symbol: ju$1, null: Ju$1, undefined: Lu$1, void: Eu$1, never: Gu$1, any: Wu$1, unknown: Xu$1, date: Au$1, enum: Vu$1, literal: Ku$1, nan: Yu$1, template_literal: Qu$1, file: Tu$1, success: Fu$1, custom: qu$1, function: Bu$1, transform: Hu$1, map: Mu$1, set: mu$1, array: Ru$1, object: xu$1, union: Qi$1, intersection: Zu$1, tuple: du$1, record: Cu$1, nullable: fu$1, nonoptional: yu$1, default: hu$1, prefault: au$1, catch: pu$1, pipe: su$1, readonly: rg$1, promise: ng$1, optional: Ti$1, lazy: ig$1 };
function Fi$1(r2, i) {
  if ("_idmap" in r2) {
    let t = r2, n = er({ ...i, processors: Yi$1 }), v = {};
    for (let l of t._idmap.entries()) {
      let [e, c] = l;
      L$1(c, n);
    }
    let $2 = {}, u2 = { registry: t, uri: i?.uri, defs: v };
    n.external = u2;
    for (let l of t._idmap.entries()) {
      let [e, c] = l;
      lr(n, c), $2[e] = Ir$1(n, c);
    }
    if (Object.keys(v).length > 0) {
      let l = n.target === "draft-2020-12" ? "$defs" : "definitions";
      $2.__shared = { [l]: v };
    }
    return { schemas: $2 };
  }
  let o = er({ ...i, processors: Yi$1 });
  return L$1(r2, o), lr(o, r2), Ir$1(o, r2);
}
let vg$1 = class vg {
  get metadataRegistry() {
    return this.ctx.metadataRegistry;
  }
  get target() {
    return this.ctx.target;
  }
  get unrepresentable() {
    return this.ctx.unrepresentable;
  }
  get override() {
    return this.ctx.override;
  }
  get io() {
    return this.ctx.io;
  }
  get counter() {
    return this.ctx.counter;
  }
  set counter(r2) {
    this.ctx.counter = r2;
  }
  get seen() {
    return this.ctx.seen;
  }
  constructor(r2) {
    let i = r2?.target ?? "draft-2020-12";
    if (i === "draft-4") i = "draft-04";
    if (i === "draft-7") i = "draft-07";
    this.ctx = er({ processors: Yi$1, target: i, ...r2?.metadata && { metadata: r2.metadata }, ...r2?.unrepresentable && { unrepresentable: r2.unrepresentable }, ...r2?.override && { override: r2.override }, ...r2?.io && { io: r2.io } });
  }
  process(r2, i = { path: [], schemaPath: [] }) {
    return L$1(r2, this.ctx, i);
  }
  emit(r2, i) {
    if (i) {
      if (i.cycles) this.ctx.cycles = i.cycles;
      if (i.reused) this.ctx.reused = i.reused;
      if (i.external) this.ctx.external = i.external;
    }
    lr(this.ctx, r2);
    let o = Ir$1(this.ctx, r2), { "~standard": t, ...n } = o;
    return n;
  }
};
var Dl$1 = {};
var jn$1 = {};
s(jn$1, { xor: () => gI, xid: () => Al$1, void: () => iI, uuidv7: () => Pl$1, uuidv6: () => zl$1, uuidv4: () => Sl$1, uuid: () => Ol$1, url: () => jl$1, unknown: () => Nr$1, union: () => lv$1, undefined: () => rI, ulid: () => Xl$1, uint64: () => pl$1, uint32: () => yl$1, tuple: () => Fg$1, transform: () => cv$1, templateLiteral: () => SI, symbol: () => sl$1, superRefine: () => le$2, success: () => wI, stringbool: () => WI, stringFormat: () => ml$1, string: () => Ri$1, strictObject: () => $I, set: () => _I, refine: () => ee$2, record: () => qg$1, readonly: () => ve$1, promise: () => zI, preprocess: () => AI, prefault: () => hg$1, pipe: () => Gn$1, partialRecord: () => lI, optional: () => Ln$1, object: () => tI, number: () => Sg$1, nullish: () => kI, nullable: () => En$1, null: () => Lg$1, nonoptional: () => ag$1, never: () => ev$1, nativeEnum: () => bI, nanoid: () => El$1, nan: () => NI, meta: () => EI, map: () => cI, mac: () => Yl$1, looseRecord: () => II, looseObject: () => uI, literal: () => UI, lazy: () => $e$1, ksuid: () => Vl$1, keyof: () => oI, jwt: () => Ml$1, json: () => XI, ipv6: () => Ql$1, ipv4: () => Kl$1, intersection: () => Qg$1, int64: () => al$1, int32: () => fl$1, int: () => xi$1, instanceof: () => GI, httpUrl: () => Jl$1, hostname: () => Rl$1, hex: () => xl$1, hash: () => Zl$1, guid: () => Nl$1, function: () => PI, float64: () => Cl$1, float32: () => dl$1, file: () => DI, exactOptional: () => Zg$1, enum: () => Iv$1, emoji: () => Ll$1, email: () => wl$1, e164: () => Hl$1, discriminatedUnion: () => eI, describe: () => LI, date: () => vI, custom: () => JI, cuid2: () => Wl$1, cuid: () => Gl$1, codec: () => OI, cidrv6: () => Fl$1, cidrv4: () => Tl$1, check: () => jI, catch: () => re$1, boolean: () => zg$1, bigint: () => hl$1, base64url: () => Bl$1, base64: () => ql$1, array: () => An$1, any: () => nI, _function: () => PI, _default: () => fg$1, _ZodString: () => Zi$1, ZodXor: () => Vg$1, ZodXID: () => pi$1, ZodVoid: () => Xg$1, ZodUnknown: () => Gg$1, ZodUnion: () => Kn$1, ZodUndefined: () => jg$1, ZodUUID: () => p$2, ZodURL: () => Wn$1, ZodULID: () => ai$1, ZodType: () => P$1, ZodTuple: () => Tg$1, ZodTransform: () => Rg$1, ZodTemplateLiteral: () => oe, ZodSymbol: () => Pg$1, ZodSuccess: () => pg$1, ZodStringFormat: () => G$1, ZodString: () => fr$1, ZodSet: () => Hg$1, ZodRecord: () => Yn$1, ZodReadonly: () => ie$1, ZodPromise: () => ue$2, ZodPrefault: () => yg$1, ZodPipe: () => Uv$1, ZodOptional: () => _v$1, ZodObject: () => Vn$1, ZodNumberFormat: () => Or$1, ZodNumber: () => hr$1, ZodNullable: () => dg$1, ZodNull: () => Jg$1, ZodNonOptional: () => bv$1, ZodNever: () => Wg$1, ZodNanoID: () => fi$1, ZodNaN: () => ne, ZodMap: () => Bg$1, ZodMAC: () => Og$1, ZodLiteral: () => Mg$1, ZodLazy: () => te, ZodKSUID: () => si, ZodJWT: () => uv$1, ZodIntersection: () => Yg$1, ZodIPv6: () => nv$1, ZodIPv4: () => rv$1, ZodGUID: () => Jn$1, ZodFunction: () => ge, ZodFile: () => mg$1, ZodExactOptional: () => xg$1, ZodEnum: () => Cr$1, ZodEmoji: () => Ci$1, ZodEmail: () => di$1, ZodE164: () => $v$1, ZodDiscriminatedUnion: () => Kg$1, ZodDefault: () => Cg$1, ZodDate: () => Xn$1, ZodCustomStringFormat: () => yr, ZodCustom: () => Qn$1, ZodCodec: () => Dv$1, ZodCatch: () => sg$1, ZodCUID2: () => hi$1, ZodCUID: () => yi$1, ZodCIDRv6: () => vv$1, ZodCIDRv4: () => iv$1, ZodBoolean: () => ar, ZodBigIntFormat: () => gv$1, ZodBigInt: () => pr$1, ZodBase64URL: () => tv$1, ZodBase64: () => ov$1, ZodArray: () => Ag$1, ZodAny: () => Eg$1 });
var qi$1 = {};
s(qi$1, { uppercase: () => Yr$1, trim: () => Hr$1, toUpperCase: () => mr$1, toLowerCase: () => Mr$1, startsWith: () => Tr$1, slugify: () => Rr$1, size: () => Dr$1, regex: () => Vr$1, property: () => Ki$1, positive: () => Wi$1, overwrite: () => d, normalize: () => Br$1, nonpositive: () => Ai$1, nonnegative: () => Vi$1, negative: () => Xi$1, multipleOf: () => ur, minSize: () => a, minLength: () => nr, mime: () => qr$1, maxSize: () => gr$1, maxLength: () => kr$1, lte: () => m$2, lt: () => y$1, lowercase: () => Kr$1, length: () => wr$1, includes: () => Qr$1, gte: () => Q, gt: () => h$1, endsWith: () => Fr$1 });
var dr = {};
s(dr, { time: () => $g$1, duration: () => ug$1, datetime: () => og$1, date: () => tg$1, ZodISOTime: () => Mi$1, ZodISODuration: () => mi$1, ZodISODateTime: () => Bi$1, ZodISODate: () => Hi$1 });
var Bi$1 = I("ZodISODateTime", (r2, i) => {
  Ho$1.init(r2, i), G$1.init(r2, i);
});
function og$1(r2) {
  return q$(Bi$1, r2);
}
var Hi$1 = I("ZodISODate", (r2, i) => {
  Mo$1.init(r2, i), G$1.init(r2, i);
});
function tg$1(r2) {
  return B$(Hi$1, r2);
}
var Mi$1 = I("ZodISOTime", (r2, i) => {
  mo.init(r2, i), G$1.init(r2, i);
});
function $g$1(r2) {
  return H$(Mi$1, r2);
}
var mi$1 = I("ZodISODuration", (r2, i) => {
  Ro$1.init(r2, i), G$1.init(r2, i);
});
function ug$1(r2) {
  return M$(mi$1, r2);
}
var kl$1 = (r2, i) => {
  gn$1.init(r2, i), r2.name = "ZodError", Object.defineProperties(r2, { format: { value: (o) => ln$1(r2, o) }, flatten: { value: (o) => en$1(r2, o) }, addIssue: { value: (o) => {
    r2.issues.push(o), r2.message = JSON.stringify(r2.issues, Pr$1, 2);
  } }, addIssues: { value: (o) => {
    r2.issues.push(...o), r2.message = JSON.stringify(r2.issues, Pr$1, 2);
  } }, isEmpty: { get() {
    return r2.issues.length === 0;
  } } });
}, Yc$1 = I("ZodError", kl$1), H$2 = I("ZodError", kl$1, { Parent: Error });
var gg$1 = Lr$1(H$2), eg$1 = Er$1(H$2), lg$1 = Gr$1(H$2), Ig$1 = Wr$1(H$2), cg$1 = Mn$1(H$2), _g$1 = mn$1(H$2), bg$1 = Rn$1(H$2), Ug$1 = xn$1(H$2), Dg$1 = Zn$1(H$2), kg$1 = dn$1(H$2), wg$1 = Cn$1(H$2), Ng$1 = fn$1(H$2);
var P$1 = I("ZodType", (r2, i) => {
  return z$1.init(r2, i), Object.assign(r2["~standard"], { jsonSchema: { input: Zr$1(r2, "input"), output: Zr$1(r2, "output") } }), r2.toJSONSchema = Nu$1(r2, {}), r2.def = i, r2.type = i.type, Object.defineProperty(r2, "_def", { value: i }), r2.check = (...o) => {
    return r2.clone(k$3.mergeDefs(i, { checks: [...i.checks ?? [], ...o.map((t) => typeof t === "function" ? { _zod: { check: t, def: { check: "custom" }, onattach: [] } } : t)] }), { parent: true });
  }, r2.with = r2.check, r2.clone = (o, t) => Y$2(r2, o, t), r2.brand = () => r2, r2.register = (o, t) => {
    return o.add(r2, t), r2;
  }, r2.parse = (o, t) => gg$1(r2, o, t, { callee: r2.parse }), r2.safeParse = (o, t) => lg$1(r2, o, t), r2.parseAsync = async (o, t) => eg$1(r2, o, t, { callee: r2.parseAsync }), r2.safeParseAsync = async (o, t) => Ig$1(r2, o, t), r2.spa = r2.safeParseAsync, r2.encode = (o, t) => cg$1(r2, o, t), r2.decode = (o, t) => _g$1(r2, o, t), r2.encodeAsync = async (o, t) => bg$1(r2, o, t), r2.decodeAsync = async (o, t) => Ug$1(r2, o, t), r2.safeEncode = (o, t) => Dg$1(r2, o, t), r2.safeDecode = (o, t) => kg$1(r2, o, t), r2.safeEncodeAsync = async (o, t) => wg$1(r2, o, t), r2.safeDecodeAsync = async (o, t) => Ng$1(r2, o, t), r2.refine = (o, t) => r2.check(ee$2(o, t)), r2.superRefine = (o) => r2.check(le$2(o)), r2.overwrite = (o) => r2.check(d(o)), r2.optional = () => Ln$1(r2), r2.exactOptional = () => Zg$1(r2), r2.nullable = () => En$1(r2), r2.nullish = () => Ln$1(En$1(r2)), r2.nonoptional = (o) => ag$1(r2, o), r2.array = () => An$1(r2), r2.or = (o) => lv$1([r2, o]), r2.and = (o) => Qg$1(r2, o), r2.transform = (o) => Gn$1(r2, cv$1(o)), r2.default = (o) => fg$1(r2, o), r2.prefault = (o) => hg$1(r2, o), r2.catch = (o) => re$1(r2, o), r2.pipe = (o) => Gn$1(r2, o), r2.readonly = () => ve$1(r2), r2.describe = (o) => {
    let t = r2.clone();
    return V.add(t, { description: o }), t;
  }, Object.defineProperty(r2, "description", { get() {
    return V.get(r2)?.description;
  }, configurable: true }), r2.meta = (...o) => {
    if (o.length === 0) return V.get(r2);
    let t = r2.clone();
    return V.add(t, o[0]), t;
  }, r2.isOptional = () => r2.safeParse(void 0).success, r2.isNullable = () => r2.safeParse(null).success, r2.apply = (o) => o(r2), r2;
}), Zi$1 = I("_ZodString", (r2, i) => {
  Ur$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (t, n, v) => Ou$1(r2, t, n);
  let o = r2._zod.bag;
  r2.format = o.format ?? null, r2.minLength = o.minimum ?? null, r2.maxLength = o.maximum ?? null, r2.regex = (...t) => r2.check(Vr$1(...t)), r2.includes = (...t) => r2.check(Qr$1(...t)), r2.startsWith = (...t) => r2.check(Tr$1(...t)), r2.endsWith = (...t) => r2.check(Fr$1(...t)), r2.min = (...t) => r2.check(nr(...t)), r2.max = (...t) => r2.check(kr$1(...t)), r2.length = (...t) => r2.check(wr$1(...t)), r2.nonempty = (...t) => r2.check(nr(1, ...t)), r2.lowercase = (t) => r2.check(Kr$1(t)), r2.uppercase = (t) => r2.check(Yr$1(t)), r2.trim = () => r2.check(Hr$1()), r2.normalize = (...t) => r2.check(Br$1(...t)), r2.toLowerCase = () => r2.check(Mr$1()), r2.toUpperCase = () => r2.check(mr$1()), r2.slugify = () => r2.check(Rr$1());
}), fr$1 = I("ZodString", (r2, i) => {
  Ur$1.init(r2, i), Zi$1.init(r2, i), r2.email = (o) => r2.check(ei$1(di$1, o)), r2.url = (o) => r2.check(Pn$1(Wn$1, o)), r2.jwt = (o) => r2.check(Gi$1(uv$1, o)), r2.emoji = (o) => r2.check(bi$1(Ci$1, o)), r2.guid = (o) => r2.check(zn$1(Jn$1, o)), r2.uuid = (o) => r2.check(li$1(p$2, o)), r2.uuidv4 = (o) => r2.check(Ii$1(p$2, o)), r2.uuidv6 = (o) => r2.check(ci$1(p$2, o)), r2.uuidv7 = (o) => r2.check(_i$1(p$2, o)), r2.nanoid = (o) => r2.check(Ui$1(fi$1, o)), r2.guid = (o) => r2.check(zn$1(Jn$1, o)), r2.cuid = (o) => r2.check(Di$1(yi$1, o)), r2.cuid2 = (o) => r2.check(ki$1(hi$1, o)), r2.ulid = (o) => r2.check(wi$1(ai$1, o)), r2.base64 = (o) => r2.check(Ji$1(ov$1, o)), r2.base64url = (o) => r2.check(Li$1(tv$1, o)), r2.xid = (o) => r2.check(Ni$1(pi$1, o)), r2.ksuid = (o) => r2.check(Oi$1(si, o)), r2.ipv4 = (o) => r2.check(Si$1(rv$1, o)), r2.ipv6 = (o) => r2.check(zi$1(nv$1, o)), r2.cidrv4 = (o) => r2.check(Pi$1(iv$1, o)), r2.cidrv6 = (o) => r2.check(ji$1(vv$1, o)), r2.e164 = (o) => r2.check(Ei$1($v$1, o)), r2.datetime = (o) => r2.check(og$1(o)), r2.date = (o) => r2.check(tg$1(o)), r2.time = (o) => r2.check($g$1(o)), r2.duration = (o) => r2.check(ug$1(o));
});
function Ri$1(r2) {
  return Y$(fr$1, r2);
}
var G$1 = I("ZodStringFormat", (r2, i) => {
  E.init(r2, i), Zi$1.init(r2, i);
}), di$1 = I("ZodEmail", (r2, i) => {
  Ao$1.init(r2, i), G$1.init(r2, i);
});
function wl$1(r2) {
  return ei$1(di$1, r2);
}
var Jn$1 = I("ZodGUID", (r2, i) => {
  Wo$1.init(r2, i), G$1.init(r2, i);
});
function Nl$1(r2) {
  return zn$1(Jn$1, r2);
}
var p$2 = I("ZodUUID", (r2, i) => {
  Xo$1.init(r2, i), G$1.init(r2, i);
});
function Ol$1(r2) {
  return li$1(p$2, r2);
}
function Sl$1(r2) {
  return Ii$1(p$2, r2);
}
function zl$1(r2) {
  return ci$1(p$2, r2);
}
function Pl$1(r2) {
  return _i$1(p$2, r2);
}
var Wn$1 = I("ZodURL", (r2, i) => {
  Vo$1.init(r2, i), G$1.init(r2, i);
});
function jl$1(r2) {
  return Pn$1(Wn$1, r2);
}
function Jl$1(r2) {
  return Pn$1(Wn$1, { protocol: /^https?$/, hostname: x$1.domain, ...k$3.normalizeParams(r2) });
}
var Ci$1 = I("ZodEmoji", (r2, i) => {
  Ko$1.init(r2, i), G$1.init(r2, i);
});
function Ll$1(r2) {
  return bi$1(Ci$1, r2);
}
var fi$1 = I("ZodNanoID", (r2, i) => {
  Yo$1.init(r2, i), G$1.init(r2, i);
});
function El$1(r2) {
  return Ui$1(fi$1, r2);
}
var yi$1 = I("ZodCUID", (r2, i) => {
  Qo$1.init(r2, i), G$1.init(r2, i);
});
function Gl$1(r2) {
  return Di$1(yi$1, r2);
}
var hi$1 = I("ZodCUID2", (r2, i) => {
  To$1.init(r2, i), G$1.init(r2, i);
});
function Wl$1(r2) {
  return ki$1(hi$1, r2);
}
var ai$1 = I("ZodULID", (r2, i) => {
  Fo$1.init(r2, i), G$1.init(r2, i);
});
function Xl$1(r2) {
  return wi$1(ai$1, r2);
}
var pi$1 = I("ZodXID", (r2, i) => {
  qo$1.init(r2, i), G$1.init(r2, i);
});
function Al$1(r2) {
  return Ni$1(pi$1, r2);
}
var si = I("ZodKSUID", (r2, i) => {
  Bo$1.init(r2, i), G$1.init(r2, i);
});
function Vl$1(r2) {
  return Oi$1(si, r2);
}
var rv$1 = I("ZodIPv4", (r2, i) => {
  xo$1.init(r2, i), G$1.init(r2, i);
});
function Kl$1(r2) {
  return Si$1(rv$1, r2);
}
var Og$1 = I("ZodMAC", (r2, i) => {
  Co$1.init(r2, i), G$1.init(r2, i);
});
function Yl$1(r2) {
  return T$(Og$1, r2);
}
var nv$1 = I("ZodIPv6", (r2, i) => {
  Zo$1.init(r2, i), G$1.init(r2, i);
});
function Ql$1(r2) {
  return zi$1(nv$1, r2);
}
var iv$1 = I("ZodCIDRv4", (r2, i) => {
  fo.init(r2, i), G$1.init(r2, i);
});
function Tl$1(r2) {
  return Pi$1(iv$1, r2);
}
var vv$1 = I("ZodCIDRv6", (r2, i) => {
  yo$1.init(r2, i), G$1.init(r2, i);
});
function Fl$1(r2) {
  return ji$1(vv$1, r2);
}
var ov$1 = I("ZodBase64", (r2, i) => {
  ao.init(r2, i), G$1.init(r2, i);
});
function ql$1(r2) {
  return Ji$1(ov$1, r2);
}
var tv$1 = I("ZodBase64URL", (r2, i) => {
  po.init(r2, i), G$1.init(r2, i);
});
function Bl$1(r2) {
  return Li$1(tv$1, r2);
}
var $v$1 = I("ZodE164", (r2, i) => {
  so.init(r2, i), G$1.init(r2, i);
});
function Hl$1(r2) {
  return Ei$1($v$1, r2);
}
var uv$1 = I("ZodJWT", (r2, i) => {
  rt$1.init(r2, i), G$1.init(r2, i);
});
function Ml$1(r2) {
  return Gi$1(uv$1, r2);
}
var yr = I("ZodCustomStringFormat", (r2, i) => {
  nt$1.init(r2, i), G$1.init(r2, i);
});
function ml$1(r2, i, o = {}) {
  return xr$1(yr, r2, i, o);
}
function Rl$1(r2) {
  return xr$1(yr, "hostname", x$1.hostname, r2);
}
function xl$1(r2) {
  return xr$1(yr, "hex", x$1.hex, r2);
}
function Zl$1(r2, i) {
  let o = i?.enc ?? "hex", t = `${r2}_${o}`, n = x$1[t];
  if (!n) throw Error(`Unrecognized hash format: ${t}`);
  return xr$1(yr, t, n, i);
}
var hr$1 = I("ZodNumber", (r2, i) => {
  oi.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (t, n, v) => Su$1(r2, t, n), r2.gt = (t, n) => r2.check(h$1(t, n)), r2.gte = (t, n) => r2.check(Q(t, n)), r2.min = (t, n) => r2.check(Q(t, n)), r2.lt = (t, n) => r2.check(y$1(t, n)), r2.lte = (t, n) => r2.check(m$2(t, n)), r2.max = (t, n) => r2.check(m$2(t, n)), r2.int = (t) => r2.check(xi$1(t)), r2.safe = (t) => r2.check(xi$1(t)), r2.positive = (t) => r2.check(h$1(0, t)), r2.nonnegative = (t) => r2.check(Q(0, t)), r2.negative = (t) => r2.check(y$1(0, t)), r2.nonpositive = (t) => r2.check(m$2(0, t)), r2.multipleOf = (t, n) => r2.check(ur(t, n)), r2.step = (t, n) => r2.check(ur(t, n)), r2.finite = () => r2;
  let o = r2._zod.bag;
  r2.minValue = Math.max(o.minimum ?? Number.NEGATIVE_INFINITY, o.exclusiveMinimum ?? Number.NEGATIVE_INFINITY) ?? null, r2.maxValue = Math.min(o.maximum ?? Number.POSITIVE_INFINITY, o.exclusiveMaximum ?? Number.POSITIVE_INFINITY) ?? null, r2.isInt = (o.format ?? "").includes("int") || Number.isSafeInteger(o.multipleOf ?? 0.5), r2.isFinite = true, r2.format = o.format ?? null;
});
function Sg$1(r2) {
  return m$(hr$1, r2);
}
var Or$1 = I("ZodNumberFormat", (r2, i) => {
  it$1.init(r2, i), hr$1.init(r2, i);
});
function xi$1(r2) {
  return x$(Or$1, r2);
}
function dl$1(r2) {
  return Z$(Or$1, r2);
}
function Cl$1(r2) {
  return d$(Or$1, r2);
}
function fl$1(r2) {
  return C$(Or$1, r2);
}
function yl$1(r2) {
  return f$(Or$1, r2);
}
var ar = I("ZodBoolean", (r2, i) => {
  bn$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => zu$1(r2, o, t);
});
function zg$1(r2) {
  return y$(ar, r2);
}
var pr$1 = I("ZodBigInt", (r2, i) => {
  ti$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (t, n, v) => Pu$1(r2, t), r2.gte = (t, n) => r2.check(Q(t, n)), r2.min = (t, n) => r2.check(Q(t, n)), r2.gt = (t, n) => r2.check(h$1(t, n)), r2.gte = (t, n) => r2.check(Q(t, n)), r2.min = (t, n) => r2.check(Q(t, n)), r2.lt = (t, n) => r2.check(y$1(t, n)), r2.lte = (t, n) => r2.check(m$2(t, n)), r2.max = (t, n) => r2.check(m$2(t, n)), r2.positive = (t) => r2.check(h$1(BigInt(0), t)), r2.negative = (t) => r2.check(y$1(BigInt(0), t)), r2.nonpositive = (t) => r2.check(m$2(BigInt(0), t)), r2.nonnegative = (t) => r2.check(Q(BigInt(0), t)), r2.multipleOf = (t, n) => r2.check(ur(t, n));
  let o = r2._zod.bag;
  r2.minValue = o.minimum ?? null, r2.maxValue = o.maximum ?? null, r2.format = o.format ?? null;
});
function hl$1(r2) {
  return a$(pr$1, r2);
}
var gv$1 = I("ZodBigIntFormat", (r2, i) => {
  vt$1.init(r2, i), pr$1.init(r2, i);
});
function al$1(r2) {
  return s$(gv$1, r2);
}
function pl$1(r2) {
  return ru$1(gv$1, r2);
}
var Pg$1 = I("ZodSymbol", (r2, i) => {
  ot$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => ju$1(r2, o);
});
function sl$1(r2) {
  return nu$1(Pg$1, r2);
}
var jg$1 = I("ZodUndefined", (r2, i) => {
  tt$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => Lu$1(r2, o);
});
function rI(r2) {
  return iu$1(jg$1, r2);
}
var Jg$1 = I("ZodNull", (r2, i) => {
  $t$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => Ju$1(r2, o, t);
});
function Lg$1(r2) {
  return vu$1(Jg$1, r2);
}
var Eg$1 = I("ZodAny", (r2, i) => {
  ut.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => Wu$1();
});
function nI() {
  return ou$1(Eg$1);
}
var Gg$1 = I("ZodUnknown", (r2, i) => {
  gt$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => Xu$1();
});
function Nr$1() {
  return tu$1(Gg$1);
}
var Wg$1 = I("ZodNever", (r2, i) => {
  et$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => Gu$1(r2, o, t);
});
function ev$1(r2) {
  return $u$1(Wg$1, r2);
}
var Xg$1 = I("ZodVoid", (r2, i) => {
  lt$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => Eu$1(r2, o);
});
function iI(r2) {
  return uu$1(Xg$1, r2);
}
var Xn$1 = I("ZodDate", (r2, i) => {
  It$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (t, n, v) => Au$1(r2, t), r2.min = (t, n) => r2.check(Q(t, n)), r2.max = (t, n) => r2.check(m$2(t, n));
  let o = r2._zod.bag;
  r2.minDate = o.minimum ? new Date(o.minimum) : null, r2.maxDate = o.maximum ? new Date(o.maximum) : null;
});
function vI(r2) {
  return gu$1(Xn$1, r2);
}
var Ag$1 = I("ZodArray", (r2, i) => {
  ct.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => Ru$1(r2, o, t, n), r2.element = i.element, r2.min = (o, t) => r2.check(nr(o, t)), r2.nonempty = (o) => r2.check(nr(1, o)), r2.max = (o, t) => r2.check(kr$1(o, t)), r2.length = (o, t) => r2.check(wr$1(o, t)), r2.unwrap = () => r2.element;
});
function An$1(r2, i) {
  return Iu$1(Ag$1, r2, i);
}
function oI(r2) {
  let i = r2._zod.def.shape;
  return Iv$1(Object.keys(i));
}
var Vn$1 = I("ZodObject", (r2, i) => {
  _t.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => xu$1(r2, o, t, n), k$3.defineLazy(r2, "shape", () => {
    return i.shape;
  }), r2.keyof = () => Iv$1(Object.keys(r2._zod.def.shape)), r2.catchall = (o) => r2.clone({ ...r2._zod.def, catchall: o }), r2.passthrough = () => r2.clone({ ...r2._zod.def, catchall: Nr$1() }), r2.loose = () => r2.clone({ ...r2._zod.def, catchall: Nr$1() }), r2.strict = () => r2.clone({ ...r2._zod.def, catchall: ev$1() }), r2.strip = () => r2.clone({ ...r2._zod.def, catchall: void 0 }), r2.extend = (o) => {
    return k$3.extend(r2, o);
  }, r2.safeExtend = (o) => {
    return k$3.safeExtend(r2, o);
  }, r2.merge = (o) => k$3.merge(r2, o), r2.pick = (o) => k$3.pick(r2, o), r2.omit = (o) => k$3.omit(r2, o), r2.partial = (...o) => k$3.partial(_v$1, r2, o[0]), r2.required = (...o) => k$3.required(bv$1, r2, o[0]);
});
function tI(r2, i) {
  let o = { type: "object", shape: r2 ?? {}, ...k$3.normalizeParams(i) };
  return new Vn$1(o);
}
function $I(r2, i) {
  return new Vn$1({ type: "object", shape: r2, catchall: ev$1(), ...k$3.normalizeParams(i) });
}
function uI(r2, i) {
  return new Vn$1({ type: "object", shape: r2, catchall: Nr$1(), ...k$3.normalizeParams(i) });
}
var Kn$1 = I("ZodUnion", (r2, i) => {
  Un$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => Qi$1(r2, o, t, n), r2.options = i.options;
});
function lv$1(r2, i) {
  return new Kn$1({ type: "union", options: r2, ...k$3.normalizeParams(i) });
}
var Vg$1 = I("ZodXor", (r2, i) => {
  Kn$1.init(r2, i), bt.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => Qi$1(r2, o, t, n), r2.options = i.options;
});
function gI(r2, i) {
  return new Vg$1({ type: "union", options: r2, inclusive: false, ...k$3.normalizeParams(i) });
}
var Kg$1 = I("ZodDiscriminatedUnion", (r2, i) => {
  Kn$1.init(r2, i), Ut$1.init(r2, i);
});
function eI(r2, i, o) {
  return new Kg$1({ type: "union", options: i, discriminator: r2, ...k$3.normalizeParams(o) });
}
var Yg$1 = I("ZodIntersection", (r2, i) => {
  Dt$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => Zu$1(r2, o, t, n);
});
function Qg$1(r2, i) {
  return new Yg$1({ type: "intersection", left: r2, right: i });
}
var Tg$1 = I("ZodTuple", (r2, i) => {
  $i$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => du$1(r2, o, t, n), r2.rest = (o) => r2.clone({ ...r2._zod.def, rest: o });
});
function Fg$1(r2, i, o) {
  let t = i instanceof z$1, n = t ? o : i;
  return new Tg$1({ type: "tuple", items: r2, rest: t ? i : null, ...k$3.normalizeParams(n) });
}
var Yn$1 = I("ZodRecord", (r2, i) => {
  kt$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => Cu$1(r2, o, t, n), r2.keyType = i.keyType, r2.valueType = i.valueType;
});
function qg$1(r2, i, o) {
  return new Yn$1({ type: "record", keyType: r2, valueType: i, ...k$3.normalizeParams(o) });
}
function lI(r2, i, o) {
  let t = Y$2(r2);
  return t._zod.values = void 0, new Yn$1({ type: "record", keyType: t, valueType: i, ...k$3.normalizeParams(o) });
}
function II(r2, i, o) {
  return new Yn$1({ type: "record", keyType: r2, valueType: i, mode: "loose", ...k$3.normalizeParams(o) });
}
var Bg$1 = I("ZodMap", (r2, i) => {
  wt$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => Mu$1(r2, o), r2.keyType = i.keyType, r2.valueType = i.valueType, r2.min = (...o) => r2.check(a(...o)), r2.nonempty = (o) => r2.check(a(1, o)), r2.max = (...o) => r2.check(gr$1(...o)), r2.size = (...o) => r2.check(Dr$1(...o));
});
function cI(r2, i, o) {
  return new Bg$1({ type: "map", keyType: r2, valueType: i, ...k$3.normalizeParams(o) });
}
var Hg$1 = I("ZodSet", (r2, i) => {
  Nt$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (o, t, n) => mu$1(r2, o), r2.min = (...o) => r2.check(a(...o)), r2.nonempty = (o) => r2.check(a(1, o)), r2.max = (...o) => r2.check(gr$1(...o)), r2.size = (...o) => r2.check(Dr$1(...o));
});
function _I(r2, i) {
  return new Hg$1({ type: "set", valueType: r2, ...k$3.normalizeParams(i) });
}
var Cr$1 = I("ZodEnum", (r2, i) => {
  Ot$1.init(r2, i), P$1.init(r2, i), r2._zod.processJSONSchema = (t, n, v) => Vu$1(r2, t, n), r2.enum = i.entries, r2.options = Object.values(i.entries);
  let o = new Set(Object.keys(i.entries));
  r2.extract = (t, n) => {
    let v = {};
    for (let $2 of t) if (o.has($2)) v[$2] = i.entries[$2];
    else throw Error(`Key ${$2} not found in enum`);
    return new Cr$1({ ...i, checks: [], ...k$3.normalizeParams(n), entries: v });
  }, r2.exclude = (t, n) => {
    let v = { ...i.entries };
    for (let $2 of t) if (o.has($2)) delete v[$2];
    else throw Error(`Key ${$2} not found in enum`);
    return new Cr$1({ ...i, checks: [], ...k$3.normalizeParams(n), entries: v });
  };
});
function Iv$1(r2, i) {
  let o =